// MessageDispatcherManager.cpp: implementation of the CMessageDispatcherManager class. 
// 
////////////////////////////////////////////////////////////////////// 
 
#include "../../Include/Comm/MessageDispatcherManager.h" 
 
#include "../../Include/Comm/MessageDispatcher.h" 
#include "../../Include/Comm/DispatchMessage.h" 
#include "../../Include/Base/StringToObjectCollection.h" 

#include <string.h>
 
////////////////////////////////////////////////////////////////////// 
// Construction/Destruction 
////////////////////////////////////////////////////////////////////// 
 
CMessageDispatcherManager::CMessageDispatcherManager() : CManager ("MessageDispatcher") 
{ 
	m_DispatcherList = new CStringToObjectCollection; 
	PASS_INITLOCK (&lock); 
} 
 
CMessageDispatcherManager::~CMessageDispatcherManager() 
{ 
	if (m_DispatcherList) delete m_DispatcherList; 
	PASS_DESTROYLOCK (&lock); 
} 
 
BOOL CMessageDispatcherManager::AddDispatcher (CMessageDispatcher *dispatcher) 
{ 
	return AddDispatcher (dispatcher,dispatcher->GetDispatcherName()); 
} 
 
BOOL CMessageDispatcherManager::AddDispatcher (CMessageDispatcher *dispatcher, char *name) 
{ 
	PASS_LOCK (&lock); 
 
	if (dispatcher == NULL || name == NULL) 
	{ 
		PASS_UNLOCK (&lock); 
		return FALSE; 
	} 
 
	if (m_DispatcherList == NULL) 
	{ 
		PASS_UNLOCK (&lock); 
		return FALSE; 
	} 
 
	// Check if it's a dispatcher 
	if (!(strcmp (dispatcher->GetName(),"MessageDispatcher") == 0 && strcmp (dispatcher->GetType(),"MessageDispatcher") == 0)) 
	{ 
		PASS_UNLOCK (&lock); 
		return FALSE; 
	} 
 
	// Before adding this dispatcher, set the tick time and start the thread 
	dispatcher->SetTickTime (10); 
	dispatcher->Start(); 
 
	m_DispatcherList->Add (name,dispatcher);
 
	PASS_UNLOCK (&lock); 

	return TRUE;
} 
 
BOOL CMessageDispatcherManager::IsMessageHandled (CDispatchMessage *message) 
{ 
	// For each dispatcher, check if it handle this message 
	char key[256]; 
	ULONG32 position; 
	CMessageDispatcher *object = NULL; 
 
	PASS_LOCK (&lock); 
 
	object = (CMessageDispatcher *) m_DispatcherList->GetFirst (&position,key,256); 
 
	while (object != NULL) 
	{ 
		if (object->IsMessageHandled (message) == TRUE) 
		{ 
			// And exit 
 
			PASS_UNLOCK (&lock); 
			return TRUE; 
		} 
		object = (CMessageDispatcher *) m_DispatcherList->GetNext (&position,key,256); 
	} 
 
	PASS_UNLOCK (&lock); 
	return FALSE; 
} 
 
void CMessageDispatcherManager::AddMessage (CDispatchMessage *message) 
{ 
	// Add this message to the first message dispatcher 
	char key[256]; 
	ULONG32 position; 
	CMessageDispatcher *first = NULL; 
 
	PASS_LOCK (&lock); 
 
	first = (CMessageDispatcher *)m_DispatcherList->GetFirst (&position,key,256); 
 
	if (first == NULL) 
	{ 
		PASS_UNLOCK (&lock); 
		return; 
	} 
 
	first->AddMessage (message); 
 
	PASS_UNLOCK (&lock); 
} 
