  // Message.cpp: implementation of the CMessage class. 
    // 
    ////////////////////////////////////////////////////////////////////// 
     
#include "../../Include/Comm/Message.h" 
#include <string.h> 
    ////////////////////////////////////////////////////////////////////// 
    // Construction/Destruction 
    ////////////////////////////////////////////////////////////////////// 
     
    CMessage::CMessage() : CObject ("Message","Message") 
    { 
    	m_ulMessageID = 0; 
    	m_ulPollCount = 0; 
    	m_szMessageName = NULL; 
    } 
     
    CMessage::CMessage(char *name) : CObject (name,"Message") 
    { 
    	m_ulMessageID = 0; 
    	m_ulPollCount = 0; 
    	m_szMessageName = NULL; 
    } 
     
    CMessage::~CMessage() 
    { 
    	if (m_szMessageName != NULL) 
    	{ 
    		delete m_szMessageName; 
    	} 
    } 
     
    void CMessage::SetMessageID (unsigned long anID) 
    { 
    	m_ulMessageID = anID; 
    } 
     
    unsigned long CMessage::GetMessageID (void) 
    { 
    	return m_ulMessageID; 
    } 
     
void CMessage::SetMessageName (char *name) 
{ 
	if (name != NULL) 
	{ 
		if (m_szMessageName != NULL) 
		{ 
			delete [] m_szMessageName; 
		} 
		m_szMessageName = new char [(strlen (name)) + 1]; 
		strcpy (m_szMessageName,name); 
	} 
} 
 
char *CMessage::GetMessageName (void) 
{ 
	return m_szMessageName; 
} 
     
  unsigned long CMessage::GetPollCount (void) 
  { 
  	return m_ulPollCount; 
  } 
   
  void CMessage::SetPollCount (unsigned long count) 
  { 
  	m_ulPollCount = count; 
  } 
   
    BOOL CMessage::Serialize (void) 
    { 
    	CObject::Serialize (); 
     
    	AddULongToSerialObject (m_ulMessageID,serializedObject); 
    	AddCharToSerialObject (m_szMessageName,serializedObject); 
    	return TRUE; 
    } 
     
    BOOL CMessage::UnSerialize (struct SerializedObject* anObject) 
    { 
    	CObject::UnSerialize (anObject); 
     
    	m_ulMessageID = GetULongFromSerialObject (serializedObject); 
    	m_szMessageName = GetCharFromSerialObject (serializedObject); 
     
    	return TRUE; 
    } 
