// MessageDispatcher.h: interface for the CMessageDispatcher class.
//
//////////////////////////////////////////////////////////////////////

#ifndef __MESSAGEDISPATCHER__
#define __MESSAGEDISPATCHER__

// Platform specific definitions
#include "../Base/platform.h"

#include "../../Include/Base/Thread.h"

class CDispatchMessageHandler;
class CLongToObjectCollection;
class CStringToObjectCollection;
class CDispatchMessage;

class CMessageDispatcher : public CThread  
{
public:
	CMessageDispatcher();
	virtual ~CMessageDispatcher();

	void SetDispatcherName (char *name);
	char *GetDispatcherName (void);

	void AddMessageHandler (CDispatchMessageHandler *handler);
	void AddMessageHandler (CDispatchMessageHandler *handler,char *name, char *type);

	void SetNextDispatcher (CMessageDispatcher *next);
	void SetPreviousDispatcher (CMessageDispatcher *previous);

	void AddMessage (CDispatchMessage *message);

	BOOL IsMessageHandled (CDispatchMessage *message);
	CDispatchMessageHandler *GetHandlerForMessage (CDispatchMessage *message);
	
	void Tick (void);

protected:

	PASS_SYNCH lock;

	char m_szDispatcherName[256];
	BOOL m_bHandlerPool;
	CLongToObjectCollection *m_HandlerList;

	CLongToObjectCollection *m_RunningHandler;

	CLongToObjectCollection *m_WaitingMessage;

	CMessageDispatcher *m_NextDispatcher;
	CMessageDispatcher *m_PreviousDispatcher;
};

#endif //__MESSAGEDISPATCHER__
