    // StringToObjectCollection.h: interface for the CStringToObjectCollection class. 
    // 
    ////////////////////////////////////////////////////////////////////// 
     
  #ifndef __STRINGTOOBJECTCOLLECTION__ 
  #define __STRINGTOOBJECTCOLLECTION__ 
         
  #include "../../Include/Base/platform.h" 
 
  #include <stddef.h> 
 
  #include "../../Include/Base/Object.h" 
     
    class CStringToObjectCollection : public CObject 
    { 
    public: 
    	CStringToObjectCollection(); 
    	virtual ~CStringToObjectCollection(); 
     
    	void Add (char *key, CObject *object);	// Add an Object 
    											// If the key already exist, the previous 
    											// Object reference is overwriten 
     
    	CObject *GetFirst (ULONG32 *firstPosition, 
    		char *key, unsigned long keyLength);	// If position == 0, no object found 
    												// return NULL; 
    	CObject *GetNext (ULONG32 *nextPosition, 
    		char *key, unsigned long keyLength);	// If position == 0, no more object 
    												// If return == NULL, no object found 
     
   
    	CObject *Lookup (char *key);		// Get Object for a specific key 
     
    	BOOL Remove (char *key);		// Remove based on key 
    	BOOL Remove (CObject *object);	// Remove based on Object 
    	BOOL RemoveAll (void);			// Remove all entries, but doesn't delete the Objects 
     
    	BOOL IsEmpty (void);			// Check if the collection is empty 
     
    	ULONG32 GetCount (void); 
     
  	BOOL Serialize (void); 
  	BOOL UnSerialize (struct SerializedObject* anObject); 
   
    protected: 
     
    	struct __StringToObjectCollectionElement 
    	{ 
    		char *key; 
    		CObject *object; 
    		ULONG32 position; 
    		struct __StringToObjectCollectionElement *next;
    	}; 
     
    private: 
     
    	void **m_pPositionArray; //Begin with 100 positions, expanded when needed 
     
    	ULONG32 m_ul32MaxObject; 
    	ULONG32 m_ul32ObjectCount; 
     
    	__StringToObjectCollectionElement *m_pCollectionTop; 
    	__StringToObjectCollectionElement *m_pCollectionBottom; 
    }; 
     
#endif // __STRINGTOOBJECTCOLLECTION__ 
