
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bsedatapocket.proc"
// Licensed GNU LGPL v2.1 or later: http://www.gnu.org/licenses/lgpl.html
#include        <bse/bseplugin.hh>
#include        <bse/bseprocedure.hh>
#include        <bse/bsedatapocket.hh>
/* --- create-entry --- */
static void
create_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 7 "bsedatapocket.proc"
 {
#line 10 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", NULL,
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 14 "bsedatapocket.proc"
}  }
static BseErrorType
#line 14 "bsedatapocket.proc"
create_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 17 "bsedatapocket.proc"
{
#line 18 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  uint id;
#line 21 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 24 "bsedatapocket.proc"
  
  id = _bse_data_pocket_create_entry (pocket);
#line 26 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, id);
  return BSE_ERROR_NONE;
}
/* --- delete-entry --- */
static void
delete_entry_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 30 "bsedatapocket.proc"
 {
#line 32 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", NULL,
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 39 "bsedatapocket.proc"
}  }
static BseErrorType
#line 39 "bsedatapocket.proc"
delete_entry_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 42 "bsedatapocket.proc"
{
#line 43 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  uint id = sfi_value_get_int (in_values++);
  bool fail = TRUE;
#line 47 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 50 "bsedatapocket.proc"
  
  if (id)
    fail = _bse_data_pocket_delete_entry (pocket, id);
#line 53 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, fail ? BSE_ERROR_NO_ENTRY : BSE_ERROR_NONE);
  return BSE_ERROR_NONE;
}
/* --- get-n-entries --- */
static void
get_n_entries_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 57 "bsedatapocket.proc"
 {
#line 59 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("n_entries", "N Entries", "The number of entries in use",
			 1, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 63 "bsedatapocket.proc"
}  }
static BseErrorType
#line 63 "bsedatapocket.proc"
get_n_entries_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 66 "bsedatapocket.proc"
{
#line 67 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
#line 69 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 72 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, pocket->n_entries);
  return BSE_ERROR_NONE;
}
/* --- get-nth-entry-id --- */
static void
get_nth_entry_id_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 76 "bsedatapocket.proc"
 {
#line 78 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_index", "Entry Index", "index into number of entries present",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID (or 0 if there's no such entry)",
			 0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 84 "bsedatapocket.proc"
}  }
static BseErrorType
#line 84 "bsedatapocket.proc"
get_nth_entry_id_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 87 "bsedatapocket.proc"
{
#line 88 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  uint index = sfi_value_get_int (in_values++);
#line 91 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 94 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, index < pocket->n_entries ? pocket->entries[index].id : 0);
  return BSE_ERROR_NONE;
}
/* --- set-float --- */
static void
set_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 98 "bsedatapocket.proc"
 {
#line 102 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_real ("number", "Number", "The value to store in the data pocket entry",
			  0, -G_MAXDOUBLE, G_MAXDOUBLE, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 113 "bsedatapocket.proc"
}  }
static BseErrorType
#line 113 "bsedatapocket.proc"
set_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 116 "bsedatapocket.proc"
{
#line 117 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  const char *name      = sfi_value_get_string (in_values++);
  gfloat v_float        = sfi_value_get_real (in_values++);
  BseDataPocketValue value;
  bool success = FALSE;
#line 124 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 127 "bsedatapocket.proc"
  
  value.v_float = v_float;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_FLOAT, value);
#line 131 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  return BSE_ERROR_NONE;
}
/* --- set-int --- */
static void
set_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 135 "bsedatapocket.proc"
 {
#line 139 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("number", "Number", "The value to store in the data pocket entry",
			 0, G_MININT, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 150 "bsedatapocket.proc"
}  }
static BseErrorType
#line 150 "bsedatapocket.proc"
set_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 153 "bsedatapocket.proc"
{
#line 154 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  const char *name      = sfi_value_get_string (in_values++);
  guint v_uint          = sfi_value_get_int (in_values++);
  BseDataPocketValue value;
  bool success = FALSE;
#line 161 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 164 "bsedatapocket.proc"
  
  value.v_int = v_uint;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_INT, value);
#line 168 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  return BSE_ERROR_NONE;
}
/* --- set-object --- */
static void
set_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 172 "bsedatapocket.proc"
 {
#line 176 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = bse_param_spec_object ("item", "Item", "The value to store in the data pocket entry",
				 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 187 "bsedatapocket.proc"
}  }
static BseErrorType
#line 187 "bsedatapocket.proc"
set_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 190 "bsedatapocket.proc"
{
#line 191 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  const char *name      = sfi_value_get_string (in_values++);
  BseItem *v_object     = (BseItem*) bse_value_get_object (in_values++);
  BseDataPocketValue value;
  bool success = FALSE;
#line 198 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket) ||
      (v_object && !bse_item_common_ancestor ((BseItem*) pocket, v_object)))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 202 "bsedatapocket.proc"
  
  value.v_object = v_object;
  if (id)
    success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_OBJECT, value);
#line 206 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  return BSE_ERROR_NONE;
}
/* --- set-string --- */
static void
set_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 210 "bsedatapocket.proc"
 {
#line 212 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("string", "String", "The value to store in the data pocket entry",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "BSE error code",
				BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
				SFI_PARAM_STANDARD);
#line 223 "bsedatapocket.proc"
}  }
static BseErrorType
#line 223 "bsedatapocket.proc"
set_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 226 "bsedatapocket.proc"
{
#line 227 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  const char *name      = sfi_value_get_string (in_values++);
  const char *v_string  = sfi_value_get_string (in_values++);
  bool success = FALSE;
#line 233 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 236 "bsedatapocket.proc"
  
  if (id)
    {
      BseDataPocketValue value;
      value.v_string = (char*) v_string;
      success = _bse_data_pocket_entry_set (pocket, id, g_quark_from_string (name), BSE_DATA_POCKET_STRING, value);
    }
#line 243 "bsedatapocket.proc"
  
  g_value_set_enum (out_values++, success ? BSE_ERROR_NONE : BSE_ERROR_NO_ENTRY);
  return BSE_ERROR_NONE;
}
/* --- get-float --- */
static void
get_float_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 247 "bsedatapocket.proc"
 {
#line 249 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_real ("number", "Number", "The value stored in the data pocket entry",
			  0, -G_MAXDOUBLE, G_MAXDOUBLE, 1, SFI_PARAM_STANDARD);
#line 257 "bsedatapocket.proc"
}  }
static BseErrorType
#line 257 "bsedatapocket.proc"
get_float_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 260 "bsedatapocket.proc"
{
#line 261 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  const char *name      = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
#line 267 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 270 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
#line 272 "bsedatapocket.proc"
  
  sfi_value_set_real (out_values++, type == BSE_DATA_POCKET_FLOAT ? value.v_float : 0);
  return BSE_ERROR_NONE;
}
/* --- get-int --- */
static void
get_int_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 276 "bsedatapocket.proc"
 {
#line 278 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++) = sfi_pspec_int ("number", "Number", "The value stored in the data pocket entry",
			 0, G_MININT, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 286 "bsedatapocket.proc"
}  }
static BseErrorType
#line 286 "bsedatapocket.proc"
get_int_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 289 "bsedatapocket.proc"
{
#line 290 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  const char *name      = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
#line 296 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 299 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
#line 301 "bsedatapocket.proc"
  
  sfi_value_set_int (out_values++, type == BSE_DATA_POCKET_INT ? value.v_int : 0);
  return BSE_ERROR_NONE;
}
/* --- get-object --- */
static void
get_object_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 305 "bsedatapocket.proc"
 {
#line 307 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", "Item", "The value stored in the data pocket entry",
				 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 315 "bsedatapocket.proc"
}  }
static BseErrorType
#line 315 "bsedatapocket.proc"
get_object_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 318 "bsedatapocket.proc"
{
#line 319 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  const char *name      = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
#line 325 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 328 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
#line 330 "bsedatapocket.proc"
  
  bse_value_set_object (out_values++, type == BSE_DATA_POCKET_OBJECT ? value.v_object : 0);
  return BSE_ERROR_NONE;
}
/* --- get-string --- */
static void
get_string_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 334 "bsedatapocket.proc"
 {
#line 336 "bsedatapocket.proc"
  *(in_pspecs++) = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket storing values",
				 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_int ("entry_id", "Entry ID", "The unique pocket entry ID",
			 1, 1, G_MAXINT, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++) = sfi_pspec_string ("name", "Name", "Name for the value",
			    0, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_string ("string", "String", "The value stored in the data pocket entry",
			    0, SFI_PARAM_STANDARD);
#line 344 "bsedatapocket.proc"
}  }
static BseErrorType
#line 344 "bsedatapocket.proc"
get_string_exec (BseProcedureClass *proc,
	const GValue      *in_values,
	GValue            *out_values)
#line 347 "bsedatapocket.proc"
{
#line 348 "bsedatapocket.proc"
  
  BseDataPocket *pocket = (BseDataPocket*) bse_value_get_object (in_values++);
  guint id              = sfi_value_get_int (in_values++);
  const char *name      = sfi_value_get_string (in_values++);
  BseDataPocketValue value = { 0, };
  gchar type;
#line 354 "bsedatapocket.proc"
  
  if (!BSE_IS_DATA_POCKET (pocket))
    return BSE_ERROR_PROC_PARAM_INVAL;
#line 357 "bsedatapocket.proc"
  
  type = _bse_data_pocket_entry_get (pocket, id, g_quark_try_string (name), &value);
#line 359 "bsedatapocket.proc"
  
  sfi_value_set_string (out_values++, type == BSE_DATA_POCKET_STRING ? value.v_string : 0);
  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_create_entry__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Create a new entry in a data pocket. "
	   "Entries have a unique ID which is required to set values in a data pocket.");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 8;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_create_entry = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+create-entry", 
    NULL,
    "/Methods/BseDataPocket/General/Create Entry",
    NULL,
    __enode_create_entry__fill_strings,
  },
  0, create_entry_setup, create_entry_exec, 
};
static void
__enode_delete_entry__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete an existing entry from a data pocket";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 31;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_delete_entry = {
  { (BseExportNode*) &__enode_create_entry, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+delete-entry", 
    NULL,
    "/Methods/BseDataPocket/General/Delete Entry",
    NULL,
    __enode_delete_entry__fill_strings,
  },
  0, delete_entry_setup, delete_entry_exec, 
};
static void
__enode_get_n_entries__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the number of entries created in a data pocket.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 58;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_n_entries = {
  { (BseExportNode*) &__enode_delete_entry, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-n-entries", 
    NULL,
    "/Methods/BseDataPocket/General/Get N Entries",
    NULL,
    __enode_get_n_entries__fill_strings,
  },
  0, get_n_entries_setup, get_n_entries_exec, 
};
static void
__enode_get_nth_entry_id__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the ID of an entry in the data pocket by sequential index.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 77;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_nth_entry_id = {
  { (BseExportNode*) &__enode_get_n_entries, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-nth-entry-id", 
    NULL,
    "/Methods/BseDataPocket/General/Get Nth Entry Id",
    NULL,
    __enode_get_nth_entry_id__fill_strings,
  },
  0, get_nth_entry_id_setup, get_nth_entry_id_exec, 
};
static void
__enode_set_float__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named floating point value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 99;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_float = {
  { (BseExportNode*) &__enode_get_nth_entry_id, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-float", 
    NULL,
    "/Methods/BseDataPocket/General/Set Float",
    NULL,
    __enode_set_float__fill_strings,
  },
  0, set_float_setup, set_float_exec, 
};
static void
__enode_set_int__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named integer value in a data pocket entry. "
	   "Names are required to distinguish different values from each other "
	   "when accessing values in a data pocket.");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 136;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_int = {
  { (BseExportNode*) &__enode_set_float, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-int", 
    NULL,
    "/Methods/BseDataPocket/General/Set Int",
    NULL,
    __enode_set_int__fill_strings,
  },
  0, set_int_setup, set_int_exec, 
};
static void
__enode_set_object__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named object reference in a data pocket entry. "
	   "Object references stored in a data pocket must exist within the "
	   "same project that the data pocket belongs to");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 173;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_object = {
  { (BseExportNode*) &__enode_set_int, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-object", 
    NULL,
    "/Methods/BseDataPocket/General/Set Object",
    NULL,
    __enode_set_object__fill_strings,
  },
  0, set_object_setup, set_object_exec, 
};
static void
__enode_set_string__fill_strings (BseExportStrings *es)
{
  es->blurb = ("Set a named string in a data pocket entry.");
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 211;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_set_string = {
  { (BseExportNode*) &__enode_set_object, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+set-string", 
    NULL,
    "/Methods/BseDataPocket/General/Set String",
    NULL,
    __enode_set_string__fill_strings,
  },
  0, set_string_setup, set_string_exec, 
};
static void
__enode_get_float__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set floating point value from a data pocket entry.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 248;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_float = {
  { (BseExportNode*) &__enode_set_string, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-float", 
    NULL,
    "/Methods/BseDataPocket/General/Get Float",
    NULL,
    __enode_get_float__fill_strings,
  },
  0, get_float_setup, get_float_exec, 
};
static void
__enode_get_int__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set integer value from a data pocket entry.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 277;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_int = {
  { (BseExportNode*) &__enode_get_float, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-int", 
    NULL,
    "/Methods/BseDataPocket/General/Get Int",
    NULL,
    __enode_get_int__fill_strings,
  },
  0, get_int_setup, get_int_exec, 
};
static void
__enode_get_object__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set object reference from a data pocket entry.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 306;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_object = {
  { (BseExportNode*) &__enode_get_int, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-object", 
    NULL,
    "/Methods/BseDataPocket/General/Get Object",
    NULL,
    __enode_get_object__fill_strings,
  },
  0, get_object_setup, get_object_exec, 
};
static void
__enode_get_string__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a previously set string from a data pocket entry.";
  es->file = "/opt/src/beast/bse/bsedatapocket.proc";
  es->line = 335;
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU Lesser General Public License";
}
static BseExportNodeProc __enode_get_string = {
  { (BseExportNode*) &__enode_get_object, BSE_EXPORT_NODE_PROC,
    "BseDataPocket+get-string", 
    NULL,
    "/Methods/BseDataPocket/General/Get String",
    NULL,
    __enode_get_string__fill_strings,
  },
  0, get_string_setup, get_string_exec, 
};
extern "C" BseExportNode* bse__builtin_init_bsedatapocket_genprc_cc (void)
{
  return (BseExportNode*) &__enode_get_string;
}

/*
 * Generated data ends here
 */
