
/*
 * Generated data (by mkcproc.pl)
 */
#line 1 "bseproject.proc"

#include <bse/bseplugin.h>
#include <bse/bseprocedure.h>
#include <bse/bseproject.h>
#include <bse/bsestorage.h>
#include <bse/bsesong.h>
#include <bse/bseundostack.h>
#include <bse/bsewaverepo.h>
#include <bse/bsecsynth.h>
#include <bse/bsemidisynth.h>
#include <bse/bsedatapocket.h>
#include <bse/bsemidifile.h>
#include <bse/bsemidireceiver.h>
#include <bse/bsemidinotifier.h>
#include <bse/bseengine.h>


#line 36 "bseproject.proc"


/* --- is-playing --- */
static void
is_playing_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 38 "bseproject.proc"
 {
#line 40 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_playing", "Is Playing", "Whether the project is currently playing songs or synths",
                          FALSE, SFI_PARAM_STANDARD);
#line 44 "bseproject.proc"
}  }
static BseErrorType
#line 44 "bseproject.proc"
is_playing_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 47 "bseproject.proc"
{
#line 48 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 51 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 55 "bseproject.proc"
  
  
#line 57 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->state == BSE_PROJECT_PLAYING);
  
  return BSE_ERROR_NONE;
}

/* --- is-active --- */
static void
is_active_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 63 "bseproject.proc"
 {
#line 65 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("is_active", NULL, "Whether the project is currently producing sound",
                          FALSE, SFI_PARAM_STANDARD);
#line 69 "bseproject.proc"
}  }
static BseErrorType
#line 69 "bseproject.proc"
is_active_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 72 "bseproject.proc"
{
#line 73 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 76 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 80 "bseproject.proc"
  
  
#line 82 "bseproject.proc"
  
  sfi_value_set_bool (out_values++, project->state != BSE_PROJECT_INACTIVE);
  
  return BSE_ERROR_NONE;
}

/* --- get-midi-notifier --- */
static void
get_midi_notifier_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 88 "bseproject.proc"
 {
#line 90 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL, BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("midi_notifier", NULL, NULL, BSE_TYPE_MIDI_NOTIFIER, SFI_PARAM_STANDARD);
#line 92 "bseproject.proc"
}  }
static BseErrorType
#line 92 "bseproject.proc"
get_midi_notifier_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 95 "bseproject.proc"
{
#line 96 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 99 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  BseMidiNotifier *notifier = bse_project_get_midi_notifier (self);

#line 105 "bseproject.proc"
  
  bse_value_set_object (out_values++, G_OBJECT (notifier));

  return BSE_ERROR_NONE;
}

/* --- import-midi-file --- */
static void
import_midi_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 111 "bseproject.proc"
 {
#line 113 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project", BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "MIDI File", "MIDI file name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_enum ("error", "Error", "Error indicating possible failures",
                               BSE_ERROR_NONE, BSE_TYPE_ERROR_TYPE,
                               SFI_PARAM_STANDARD);
#line 119 "bseproject.proc"
}  }
static BseErrorType
#line 119 "bseproject.proc"
import_midi_file_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 122 "bseproject.proc"
{
#line 123 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  BseMidiFile *smf;
  BseErrorType error;
  
#line 129 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 133 "bseproject.proc"
  
  smf = bse_midi_file_load (file_name, &error);
  if (!error)
    {
      BseUndoStack *ustack = bse_item_undo_open (project, "import-midi-file");
      gchar *basename = g_path_get_basename (file_name);
      BseSong *song;
      bse_item_exec (project, "create-song", basename, &song);
      g_free (basename);
      bse_midi_file_setup_song (smf, song);
      bse_item_undo_close (ustack);
      bse_project_clear_undo (project); // FIXME: why can't we undo MIDI imports?
    }
  if (smf)
    bse_midi_file_free (smf);
  g_printerr ("error: %u\n", error);
  
#line 150 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- restore-from-file --- */
static void
restore_from_file_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 156 "bseproject.proc"
 {
#line 158 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "File", "Source file name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_enum ("error", "Error", "Error indicating possible failures",
                               BSE_ERROR_NONE, BSE_TYPE_ERROR_TYPE,
                               SFI_PARAM_STANDARD);
#line 165 "bseproject.proc"
}  }
static BseErrorType
#line 165 "bseproject.proc"
restore_from_file_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 168 "bseproject.proc"
{
#line 169 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  BseErrorType error;
  
#line 174 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 178 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      BseStorage *storage = g_object_new (BSE_TYPE_STORAGE, NULL);
      error = bse_storage_input_file (storage, file_name);
      if (!error)
        error = bse_project_restore (project, storage);
      bse_storage_reset (storage);
      g_object_unref (storage);
      bse_project_clear_undo (project);
    }
  else
    error = BSE_ERROR_PROC_BUSY;

#line 192 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- store-bse --- */
static void
store_bse_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 198 "bseproject.proc"
 {
#line 201 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("super", "Super", NULL,
                                 BSE_TYPE_SUPER, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("file-name", "File", "Destination file name",
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_bool ("self-contained", "Self Contained",
                          "Whether references to other objects (e.g. samples) should "
                          "be stored or whether to include everything in a self-contained .bse file",
                          FALSE, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", "Error indicating possible failures",
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 214 "bseproject.proc"
}  }
static BseErrorType
#line 214 "bseproject.proc"
store_bse_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 217 "bseproject.proc"
{
#line 218 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseSuper *super = bse_value_get_object (in_values++);
  gchar *file_name = sfi_value_get_string (in_values++);
  gboolean self_contained = sfi_value_get_bool (in_values++);
  BseErrorType error;
  
#line 225 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !file_name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  if (super && BSE_ITEM (super)->parent != BSE_ITEM (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

  error = bse_project_store_bse (project, super, file_name, self_contained);
  
#line 233 "bseproject.proc"
  
  g_value_set_enum (out_values++, error);
  
  return BSE_ERROR_NONE;
}

/* --- create-song --- */
static void
create_song_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 239 "bseproject.proc"
 {
#line 241 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Song name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("song", "Song", "The new song",
                                 BSE_TYPE_SONG, SFI_PARAM_STANDARD);
#line 247 "bseproject.proc"
}  }
static BseErrorType
#line 247 "bseproject.proc"
create_song_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 250 "bseproject.proc"
{
#line 251 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 257 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 261 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-song");
  child = bse_container_new_child (container, BSE_TYPE_SONG, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);

#line 269 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);

  return BSE_ERROR_NONE;
}

/* --- get-wave-repo --- */
static void
get_wave_repo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 275 "bseproject.proc"
 {
#line 277 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("wrepo", "Wave Repo", "The project's unique wave repo",
                                 BSE_TYPE_WAVE_REPO, SFI_PARAM_STANDARD);
#line 281 "bseproject.proc"
}  }
static BseErrorType
#line 281 "bseproject.proc"
get_wave_repo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 284 "bseproject.proc"
{
#line 285 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseWaveRepo *wrepo = NULL;
  
#line 289 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 293 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  
#line 296 "bseproject.proc"
  
  bse_value_set_object (out_values++, wrepo);
  
  return BSE_ERROR_NONE;
}

/* --- get-data-pocket --- */
static void
get_data_pocket_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 302 "bseproject.proc"
 {
#line 304 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Name of the data pocket",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("data_pocket", "Data Pocket", "The data pocket",
                                 BSE_TYPE_DATA_POCKET, SFI_PARAM_STANDARD);
#line 310 "bseproject.proc"
}  }
static BseErrorType
#line 310 "bseproject.proc"
get_data_pocket_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 313 "bseproject.proc"
{
#line 314 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name = sfi_value_get_string (in_values++);
  BseItem *item;
  
#line 319 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 323 "bseproject.proc"
  
  item = bse_project_lookup_typed_item (project, BSE_TYPE_DATA_POCKET, name);
  if (!item)
    item = bse_container_new_child (BSE_CONTAINER (project), BSE_TYPE_DATA_POCKET,
                                    "uname", name,
                                    NULL);
  
#line 330 "bseproject.proc"
  
  bse_value_set_object (out_values++, item);
  
  return BSE_ERROR_NONE;
}

/* --- create-csynth --- */
static void
create_csynth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 336 "bseproject.proc"
 {
#line 338 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "Synth network name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("csynth", "Synthesizer Network", "New synth network",
                                 BSE_TYPE_CSYNTH, SFI_PARAM_STANDARD);
#line 344 "bseproject.proc"
}  }
static BseErrorType
#line 344 "bseproject.proc"
create_csynth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 347 "bseproject.proc"
{
#line 348 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  const gchar *name       = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;
  
#line 354 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 358 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-csynth");
  child = bse_container_new_child (container, BSE_TYPE_CSYNTH, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);
  
#line 366 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- create-midi-synth --- */
static void
create_midi_synth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 372 "bseproject.proc"
 {
#line 374 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", "Name", "MIDI synth name",
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("midi_synth", "MIDI Synthesizer", "New MIDI synth",
                                 BSE_TYPE_MIDI_SYNTH, SFI_PARAM_STANDARD);
#line 380 "bseproject.proc"
}  }
static BseErrorType
#line 380 "bseproject.proc"
create_midi_synth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 383 "bseproject.proc"
{
#line 384 "bseproject.proc"
  
  BseContainer *container = bse_value_get_object (in_values++);
  gchar *name             = sfi_value_get_string (in_values++);
  BseUndoStack *ustack;
  BseItem *child;

#line 390 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (container))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 394 "bseproject.proc"
  
  ustack = bse_item_undo_open (container, "create-midi-synth");
  child = bse_container_new_child (container, BSE_TYPE_MIDI_SYNTH, NULL);
  if (name)
    bse_item_set (child, "uname", name, NULL);
  bse_item_push_undo_proc (container, "remove-snet", child);
  bse_item_undo_close (ustack);

#line 402 "bseproject.proc"
  
  bse_value_set_object (out_values++, child);
  
  return BSE_ERROR_NONE;
}

/* --- remove-snet --- */
static void
remove_snet_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 408 "bseproject.proc"
 {
#line 410 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = bse_param_spec_object ("snet", "SNet", "Synthesizer Network",
                                 BSE_TYPE_SNET, SFI_PARAM_STANDARD);
#line 414 "bseproject.proc"
}  }
static BseErrorType
#line 414 "bseproject.proc"
remove_snet_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 417 "bseproject.proc"
{
#line 418 "bseproject.proc"
  
  BseContainer *self  = bse_value_get_object (in_values++);
  BseItem      *child = bse_value_get_object (in_values++);
  BseUndoStack *ustack;
  
#line 423 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self) || !BSE_IS_SNET (child) || child->parent != (BseItem*) self)
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 427 "bseproject.proc"
  
  if (!BSE_SOURCE_PREPARED (self))
    {
      ustack = bse_item_undo_open (self, "remove-child %s", bse_object_debug_name (child));
#line 431 "bseproject.proc"
      
      bse_container_uncross_undoable (BSE_CONTAINER (self), child);
#line 433 "bseproject.proc"
      
      bse_item_push_redo_proc (self, "remove-snet", child);
#line 435 "bseproject.proc"
      
      bse_container_remove_backedup (BSE_CONTAINER (self), child, ustack);
#line 437 "bseproject.proc"
      
      bse_item_undo_close (ustack);
    }
  
  return BSE_ERROR_NONE;
}

/* --- list-uname-paths --- */
static void
list_uname_paths_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 444 "bseproject.proc"
 {
#line 447 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("uname_paths", "Uname Paths", NULL, BSE_TYPE_STRING_SEQ, SFI_PARAM_STANDARD);
#line 452 "bseproject.proc"
}  }
static BseErrorType
#line 452 "bseproject.proc"
list_uname_paths_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 455 "bseproject.proc"
{
#line 456 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  
#line 461 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 465 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, bse_project_list_upaths (project, type));
  
  return BSE_ERROR_NONE;
}

/* --- find-item --- */
static void
find_item_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 471 "bseproject.proc"
 {
#line 473 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("uname_path", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_object ("item", NULL, NULL,
                                 BSE_TYPE_ITEM, SFI_PARAM_STANDARD);
#line 479 "bseproject.proc"
}  }
static BseErrorType
#line 479 "bseproject.proc"
find_item_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 482 "bseproject.proc"
{
#line 483 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  
#line 487 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 491 "bseproject.proc"
  
  bse_value_set_object (out_values++, bse_container_resolve_upath (BSE_CONTAINER (project), string));
  
  return BSE_ERROR_NONE;
}

/* --- match-items-by-uname --- */
static void
match_items_by_uname_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 497 "bseproject.proc"
 {
#line 499 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("item_type", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("uname", NULL, NULL,
                            NULL, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("item_list", "Item List", NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD);
#line 506 "bseproject.proc"
}  }
static BseErrorType
#line 506 "bseproject.proc"
match_items_by_uname_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 509 "bseproject.proc"
{
#line 510 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  const gchar *tname  = sfi_value_get_string (in_values++);
  const gchar *string = sfi_value_get_string (in_values++);
  GType type          = tname ? g_type_from_name (tname) : 0;
  GList *list, *free_list;
  BseItemSeq *iseq;
  
#line 518 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !string || !g_type_is_a (type, BSE_TYPE_ITEM))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 522 "bseproject.proc"
  
  iseq = bse_item_seq_new ();
  free_list = bse_objects_list_by_uname (type, string);
  for (list = free_list; list; list = list->next)
    if (bse_item_get_project (list->data) == project)
      {
        bse_item_seq_append (iseq, list->data);
        break;
      }
  g_list_free (free_list);
  
#line 533 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, iseq);
  
  return BSE_ERROR_NONE;
}

/* --- get-supers --- */
static void
get_supers_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 539 "bseproject.proc"
 {
#line 541 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_boxed ("super_list", NULL, NULL, BSE_TYPE_ITEM_SEQ, SFI_PARAM_STANDARD);
#line 544 "bseproject.proc"
}  }
static BseErrorType
#line 544 "bseproject.proc"
get_supers_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 547 "bseproject.proc"
{
#line 548 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  BseItemSeq *iseq;
  GSList *slist;
  
#line 553 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 557 "bseproject.proc"
  
  iseq = bse_item_seq_new ();
  for (slist = project->supers; slist; slist = slist->next)
    bse_item_seq_append (iseq, slist->data);
  
#line 562 "bseproject.proc"
  
  bse_value_take_boxed (out_values++, iseq);
  
  return BSE_ERROR_NONE;
}

/* --- can-play --- */
static void
can_play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 568 "bseproject.proc"
 {
#line 570 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("can_play", "Can Play", "Whether project playback makes sense",
                          FALSE, SFI_PARAM_STANDARD);
#line 574 "bseproject.proc"
}  }
static BseErrorType
#line 574 "bseproject.proc"
can_play_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 577 "bseproject.proc"
{
#line 578 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gpointer wrepo;
  
#line 582 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 586 "bseproject.proc"
  
  wrepo = bse_project_get_wave_repo (project);
  sfi_value_set_bool (out_values++, project->supers->data != wrepo || project->supers->next);
  
  return BSE_ERROR_NONE;
}

/* --- get-state --- */
static void
get_state_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 593 "bseproject.proc"
 {
#line 595 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("state", "State", "Project playback/activation state",
                                BSE_TYPE_PROJECT_STATE, BSE_PROJECT_INACTIVE, SFI_PARAM_STANDARD);
#line 599 "bseproject.proc"
}  }
static BseErrorType
#line 599 "bseproject.proc"
get_state_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 602 "bseproject.proc"
{
#line 603 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  
#line 606 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 610 "bseproject.proc"
  
  g_value_set_enum (out_values++, self->state);
  
  return BSE_ERROR_NONE;
}

/* --- activate --- */
static void
activate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 616 "bseproject.proc"
 {
#line 618 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 623 "bseproject.proc"
}  }
static BseErrorType
#line 623 "bseproject.proc"
activate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 626 "bseproject.proc"
{
#line 627 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseProjectState state_before;
  BseErrorType error;

#line 632 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  error = bse_project_activate (self);
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 640 "bseproject.proc"
      
      bse_project_push_undo_silent_deactivate (self);
    }
  
  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- start-playback --- */
static void
start_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 649 "bseproject.proc"
 {
#line 651 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 653 "bseproject.proc"
}  }
static BseErrorType
#line 653 "bseproject.proc"
start_playback_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 656 "bseproject.proc"
{
#line 657 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseProjectState state_before;

#line 661 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  bse_project_start_playback (self);
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 669 "bseproject.proc"
      
      bse_project_push_undo_silent_deactivate (self);
    }

  return BSE_ERROR_NONE;
}

/* --- play --- */
static void
play_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 676 "bseproject.proc"
 {
#line 678 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = bse_param_spec_genum ("error", "Error", NULL,
                                BSE_TYPE_ERROR_TYPE, BSE_ERROR_NONE,
                                SFI_PARAM_STANDARD);
#line 683 "bseproject.proc"
}  }
static BseErrorType
#line 683 "bseproject.proc"
play_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 686 "bseproject.proc"
{
#line 687 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);
  BseErrorType error;
  BseProjectState state_before;
  
#line 692 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  state_before = self->state;
  error = bse_project_activate (self);
  if (!error)
    {
      if (self->state == BSE_PROJECT_PLAYING)
        bse_project_stop_playback (self);
      bse_project_start_playback (self);
    }
  if (state_before == BSE_PROJECT_INACTIVE && self->state != BSE_PROJECT_INACTIVE)
    {
#line 706 "bseproject.proc"
      
      bse_project_push_undo_silent_deactivate (self);
    }

  g_value_set_enum (out_values++, error);

  return BSE_ERROR_NONE;
}

/* --- deactivate --- */
static void
deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 715 "bseproject.proc"
 {
#line 717 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 719 "bseproject.proc"
}  }
static BseErrorType
#line 719 "bseproject.proc"
deactivate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 722 "bseproject.proc"
{
#line 723 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 726 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- stop-playback --- */
static void
stop_playback_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 735 "bseproject.proc"
 {
#line 737 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 739 "bseproject.proc"
}  }
static BseErrorType
#line 739 "bseproject.proc"
stop_playback_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 742 "bseproject.proc"
{
#line 743 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 746 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_stop_playback (self);

  return BSE_ERROR_NONE;
}

/* --- stop --- */
static void
stop_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 755 "bseproject.proc"
 {
#line 757 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 759 "bseproject.proc"
}  }
static BseErrorType
#line 759 "bseproject.proc"
stop_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 762 "bseproject.proc"
{
#line 763 "bseproject.proc"
  
  BseProject *self = bse_value_get_object (in_values++);

#line 766 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  bse_project_deactivate (self);

  return BSE_ERROR_NONE;
}

/* --- auto-deactivate --- */
static void
auto_deactivate_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 775 "bseproject.proc"
 {
#line 777 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("msec_delay", NULL, "Delay for deactivation in milliseconds",
                         0, -1, G_MAXINT, 1000, SFI_PARAM_STANDARD);
#line 781 "bseproject.proc"
}  }
static BseErrorType
#line 781 "bseproject.proc"
auto_deactivate_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 784 "bseproject.proc"
{
#line 785 "bseproject.proc"
  
  BseProject *self  = bse_value_get_object (in_values++);
  gint64      msecs = sfi_value_get_int (in_values++);

#line 789 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (self))
    return BSE_ERROR_PROC_PARAM_INVAL;

  self->deactivate_usecs = msecs < 0 ? -1 : msecs * 1000;

  return BSE_ERROR_NONE;
}

/* --- inject-midi-control --- */
static void
inject_midi_control_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 798 "bseproject.proc"
 {
#line 800 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", NULL, NULL, BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("midi_channel", NULL, NULL, 1, 1, BSE_MIDI_MAX_CHANNELS, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_int ("midi_control", NULL, NULL, 7, 0, 127, 1, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_real ("control_value", NULL, NULL, 0, -1, +1, 0.1, SFI_PARAM_STANDARD);
#line 804 "bseproject.proc"
}  }
static BseErrorType
#line 804 "bseproject.proc"
inject_midi_control_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 807 "bseproject.proc"
{
#line 808 "bseproject.proc"
  
  BseProject *project   = bse_value_get_object (in_values++);
  int midi_channel      = g_value_get_int (in_values++);
  int midi_control      = g_value_get_int (in_values++);
  SfiReal control_value = sfi_value_get_real (in_values++);

#line 814 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
  if (BSE_SOURCE_PREPARED (project))
    {
#line 820 "bseproject.proc"
      
      BseMidiEvent *event = bse_midi_alloc_event ();
      event->status = BSE_MIDI_CONTROL_CHANGE;
      event->channel = midi_channel;
      event->delta_time = bse_engine_tick_stamp_from_systime (sfi_time_system ());
#line 825 "bseproject.proc"
      
      event->data.control.control = midi_control;
      event->data.control.value = control_value;
#line 828 "bseproject.proc"
      
      bse_midi_receiver_push_event (project->midi_receiver, event);
      bse_midi_receiver_process_events (project->midi_receiver, event->delta_time);
    }
  
  return BSE_ERROR_NONE;
}

/* --- change-name --- */
static void
change_name_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 836 "bseproject.proc"
 {
#line 838 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(in_pspecs++)    = sfi_pspec_string ("name", NULL, NULL, NULL, SFI_PARAM_STANDARD);
#line 841 "bseproject.proc"
}  }
static BseErrorType
#line 841 "bseproject.proc"
change_name_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 844 "bseproject.proc"
{
#line 845 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  gchar *name = sfi_value_get_string (in_values++);
  
#line 849 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project) || !name)
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 853 "bseproject.proc"
  
#line 854 "bseproject.proc"
  g_object_set (project, "uname", name, NULL); 

  return BSE_ERROR_NONE;
}

/* --- undo-depth --- */
static void
undo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 859 "bseproject.proc"
 {
#line 861 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("undo_depth", NULL, "Number of times undo can be called on the project",
                         0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 865 "bseproject.proc"
}  }
static BseErrorType
#line 865 "bseproject.proc"
undo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 868 "bseproject.proc"
{
#line 869 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 872 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 876 "bseproject.proc"
  
  sfi_value_set_int (out_values++, bse_undo_stack_depth (project->undo_stack));

  return BSE_ERROR_NONE;
}

/* --- undo --- */
static void
undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 882 "bseproject.proc"
 {
#line 884 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 886 "bseproject.proc"
}  }
static BseErrorType
#line 886 "bseproject.proc"
undo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 889 "bseproject.proc"
{
#line 890 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);

#line 893 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 897 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      const gchar *name = bse_undo_stack_peek (project->undo_stack);
      if (name)
        {
#line 903 "bseproject.proc"
          project->in_undo = TRUE;      
          bse_undo_group_open (project->redo_stack, name);
          bse_undo_stack_undo (project->undo_stack);
          bse_undo_group_close (project->redo_stack);
#line 907 "bseproject.proc"
          project->in_undo = FALSE;     
        }
    }

  return BSE_ERROR_NONE;
}

/* --- redo-depth --- */
static void
redo_depth_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 914 "bseproject.proc"
 {
#line 916 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_int ("redo_depth", NULL, "Number of times redo can be called on the project",
                         0, 0, G_MAXINT, 1, SFI_PARAM_STANDARD);
#line 920 "bseproject.proc"
}  }
static BseErrorType
#line 920 "bseproject.proc"
redo_depth_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 923 "bseproject.proc"
{
#line 924 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 927 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 931 "bseproject.proc"
  
  sfi_value_set_int (out_values++, bse_undo_stack_depth (project->redo_stack));

  return BSE_ERROR_NONE;
}

/* --- redo --- */
static void
redo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 937 "bseproject.proc"
 {
#line 939 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 941 "bseproject.proc"
}  }
static BseErrorType
#line 941 "bseproject.proc"
redo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 944 "bseproject.proc"
{
#line 945 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 948 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 952 "bseproject.proc"
  
  if (!project->in_undo && !project->in_redo)
    {
      const gchar *name = bse_undo_stack_peek (project->redo_stack);
      if (name)
        {
#line 958 "bseproject.proc"
          project->in_redo = TRUE;      
          bse_undo_group_open (project->undo_stack, name);
          bse_undo_stack_undo (project->redo_stack);
          bse_undo_group_close (project->undo_stack);
#line 962 "bseproject.proc"
          project->in_redo = FALSE;     
        }
    }

  return BSE_ERROR_NONE;
}

/* --- clear-undo --- */
static void
clear_undo_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 969 "bseproject.proc"
 {
#line 971 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 973 "bseproject.proc"
}  }
static BseErrorType
#line 973 "bseproject.proc"
clear_undo_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 976 "bseproject.proc"
{
#line 977 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 980 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 984 "bseproject.proc"
  
  bse_project_clear_undo (project);

  return BSE_ERROR_NONE;
}

/* --- clean-dirty --- */
static void
clean_dirty_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 990 "bseproject.proc"
 {
#line 992 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", NULL,
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
#line 994 "bseproject.proc"
}  }
static BseErrorType
#line 994 "bseproject.proc"
clean_dirty_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 997 "bseproject.proc"
{
#line 998 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 1001 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;

#line 1005 "bseproject.proc"
  
  bse_project_clean_dirty (project);

  return BSE_ERROR_NONE;
}

/* --- is-dirty --- */
static void
is_dirty_setup (BseProcedureClass *proc, GParamSpec **in_pspecs, GParamSpec **out_pspecs) {
#line 1011 "bseproject.proc"
 {
#line 1013 "bseproject.proc"
  *(in_pspecs++)    = bse_param_spec_object ("project", "Project", "The project",
                                 BSE_TYPE_PROJECT, SFI_PARAM_STANDARD);
  *(out_pspecs++)   = sfi_pspec_bool ("dirty", NULL, NULL, TRUE, SFI_PARAM_STANDARD);
#line 1016 "bseproject.proc"
}  }
static BseErrorType
#line 1016 "bseproject.proc"
is_dirty_exec (BseProcedureClass *proc,
        const GValue      *in_values,
        GValue            *out_values)
#line 1019 "bseproject.proc"
{
#line 1020 "bseproject.proc"
  
  BseProject *project = bse_value_get_object (in_values++);
  
#line 1023 "bseproject.proc"
  
  if (!BSE_IS_PROJECT (project))
    return BSE_ERROR_PROC_PARAM_INVAL;
  
#line 1027 "bseproject.proc"
  
  gboolean dirty = FALSE;
  g_object_get (project, "dirty", &dirty, NULL);
  sfi_value_set_bool (out_values++, dirty);

  return BSE_ERROR_NONE;
}

/* --- Export to BSE --- */
static void
__enode_is_playing__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project is currently playing";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_is_playing = {
  { NULL, BSE_EXPORT_NODE_PROC,
    "BseProject+is-playing", 
    NULL,
    "/Methods/BseProject/General/Is Playing",
    NULL,
    __enode_is_playing__fill_strings,
  },
  0, is_playing_setup, is_playing_exec, 
};
static void
__enode_is_active__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project is active";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_is_active = {
  { (BseExportNode*) &__enode_is_playing, BSE_EXPORT_NODE_PROC,
    "BseProject+is-active", 
    NULL,
    "/Methods/BseProject/General/Is Active",
    NULL,
    __enode_is_active__fill_strings,
  },
  0, is_active_setup, is_active_exec, 
};
static void
__enode_get_midi_notifier__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the project's midi notifier object.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_midi_notifier = {
  { (BseExportNode*) &__enode_is_active, BSE_EXPORT_NODE_PROC,
    "BseProject+get-midi-notifier", 
    NULL,
    "/Methods/BseProject/General/Get Midi Notifier",
    NULL,
    __enode_get_midi_notifier__fill_strings,
  },
  0, get_midi_notifier_setup, get_midi_notifier_exec, 
};
static void
__enode_import_midi_file__fill_strings (BseExportStrings *es)
{
  es->blurb = "Import a song from a MIDI file.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_import_midi_file = {
  { (BseExportNode*) &__enode_get_midi_notifier, BSE_EXPORT_NODE_PROC,
    "BseProject+import-midi-file", 
    NULL,
    "/Methods/BseProject/File/Import MIDI",
    NULL,
    __enode_import_midi_file__fill_strings,
  },
  0, import_midi_file_setup, import_midi_file_exec, 
};
static void
__enode_restore_from_file__fill_strings (BseExportStrings *es)
{
  es->blurb = "Load a project from file";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_restore_from_file = {
  { (BseExportNode*) &__enode_import_midi_file, BSE_EXPORT_NODE_PROC,
    "BseProject+restore-from-file", 
    NULL,
    "/Methods/BseProject/File/Restore",
    NULL,
    __enode_restore_from_file__fill_strings,
  },
  0, restore_from_file_setup, restore_from_file_exec, 
};
static void
__enode_store_bse__fill_strings (BseExportStrings *es)
{
  es->blurb = "Save supers of a project into a BSE file. "
          "If no super is specified, the project itself is stored.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_store_bse = {
  { (BseExportNode*) &__enode_restore_from_file, BSE_EXPORT_NODE_PROC,
    "BseProject+store-bse", 
    NULL,
    "/Methods/BseProject/File/Store",
    NULL,
    __enode_store_bse__fill_strings,
  },
  0, store_bse_setup, store_bse_exec, 
};
static void
__enode_create_song__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a song for this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_create_song = {
  { (BseExportNode*) &__enode_store_bse, BSE_EXPORT_NODE_PROC,
    "BseProject+create-song", 
    NULL,
    "/Methods/BseProject/General/Create Song",
    NULL,
    __enode_create_song__fill_strings,
  },
  0, create_song_setup, create_song_exec, 
};
static void
__enode_get_wave_repo__fill_strings (BseExportStrings *es)
{
  es->blurb = "Ensure the project has a wave repository";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_wave_repo = {
  { (BseExportNode*) &__enode_create_song, BSE_EXPORT_NODE_PROC,
    "BseProject+get-wave-repo", 
    NULL,
    "/Methods/BseProject/General/Get Wave Repo",
    NULL,
    __enode_get_wave_repo__fill_strings,
  },
  0, get_wave_repo_setup, get_wave_repo_exec, 
};
static void
__enode_get_data_pocket__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve a specifically named data pocket for this project";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_data_pocket = {
  { (BseExportNode*) &__enode_get_wave_repo, BSE_EXPORT_NODE_PROC,
    "BseProject+get-data-pocket", 
    NULL,
    "/Methods/BseProject/General/Get Data Pocket",
    NULL,
    __enode_get_data_pocket__fill_strings,
  },
  0, get_data_pocket_setup, get_data_pocket_exec, 
};
static void
__enode_create_csynth__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a synthsizer network for this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_create_csynth = {
  { (BseExportNode*) &__enode_get_data_pocket, BSE_EXPORT_NODE_PROC,
    "BseProject+create-csynth", 
    NULL,
    "/Methods/BseProject/General/Create Csynth",
    NULL,
    __enode_create_csynth__fill_strings,
  },
  0, create_csynth_setup, create_csynth_exec, 
};
static void
__enode_create_midi_synth__fill_strings (BseExportStrings *es)
{
  es->blurb = "Create a MIDI synthesizer network for this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_create_midi_synth = {
  { (BseExportNode*) &__enode_create_csynth, BSE_EXPORT_NODE_PROC,
    "BseProject+create-midi-synth", 
    NULL,
    "/Methods/BseProject/General/Create Midi Synth",
    NULL,
    __enode_create_midi_synth__fill_strings,
  },
  0, create_midi_synth_setup, create_midi_synth_exec, 
};
static void
__enode_remove_snet__fill_strings (BseExportStrings *es)
{
  es->blurb = "Remove an existing synthesizer network from this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_remove_snet = {
  { (BseExportNode*) &__enode_create_midi_synth, BSE_EXPORT_NODE_PROC,
    "BseProject+remove-snet", 
    NULL,
    "/Methods/BseProject/General/Remove Snet",
    NULL,
    __enode_remove_snet__fill_strings,
  },
  0, remove_snet_setup, remove_snet_exec, 
};
static void
__enode_list_uname_paths__fill_strings (BseExportStrings *es)
{
  es->blurb = ("List uname paths for all items of a specified type within this project. "
           "By their uname paths, items are uniquely identifyable within a project.");
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_list_uname_paths = {
  { (BseExportNode*) &__enode_remove_snet, BSE_EXPORT_NODE_PROC,
    "BseProject+list-uname-paths", 
    NULL,
    "/Methods/BseProject/General/List Uname Paths",
    NULL,
    __enode_list_uname_paths__fill_strings,
  },
  0, list_uname_paths_setup, list_uname_paths_exec, 
};
static void
__enode_find_item__fill_strings (BseExportStrings *es)
{
  es->blurb = "Find an item within a project, given its uname path.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_find_item = {
  { (BseExportNode*) &__enode_list_uname_paths, BSE_EXPORT_NODE_PROC,
    "BseProject+find-item", 
    NULL,
    "/Methods/BseProject/General/Find Item",
    NULL,
    __enode_find_item__fill_strings,
  },
  0, find_item_setup, find_item_exec, 
};
static void
__enode_match_items_by_uname__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all items of a specific type within a project with matching uname";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_match_items_by_uname = {
  { (BseExportNode*) &__enode_find_item, BSE_EXPORT_NODE_PROC,
    "BseProject+match-items-by-uname", 
    NULL,
    "/Methods/BseProject/General/Match Items By Uname",
    NULL,
    __enode_match_items_by_uname__fill_strings,
  },
  0, match_items_by_uname_setup, match_items_by_uname_exec, 
};
static void
__enode_get_supers__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve all supers of this project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_supers = {
  { (BseExportNode*) &__enode_match_items_by_uname, BSE_EXPORT_NODE_PROC,
    "BseProject+get-supers", 
    NULL,
    "/Methods/BseProject/General/Get Supers",
    NULL,
    __enode_get_supers__fill_strings,
  },
  0, get_supers_setup, get_supers_exec, 
};
static void
__enode_can_play__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether project playback would makes sense.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_can_play = {
  { (BseExportNode*) &__enode_get_supers, BSE_EXPORT_NODE_PROC,
    "BseProject+can-play", 
    NULL,
    "/Methods/BseProject/General/Can Play",
    NULL,
    __enode_can_play__fill_strings,
  },
  0, can_play_setup, can_play_exec, 
};
static void
__enode_get_state__fill_strings (BseExportStrings *es)
{
  es->blurb = "Retrieve the current project state.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_get_state = {
  { (BseExportNode*) &__enode_can_play, BSE_EXPORT_NODE_PROC,
    "BseProject+get-state", 
    NULL,
    "/Methods/BseProject/General/Get State",
    NULL,
    __enode_get_state__fill_strings,
  },
  0, get_state_setup, get_state_exec, 
};
static void
__enode_activate__fill_strings (BseExportStrings *es)
{
  es->blurb = "Activate a project, precondition to start playback.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_activate = {
  { (BseExportNode*) &__enode_get_state, BSE_EXPORT_NODE_PROC,
    "BseProject+activate", 
    NULL,
    "/Methods/BseProject/General/Activate",
    NULL,
    __enode_activate__fill_strings,
  },
  0, activate_setup, activate_exec, 
};
static void
__enode_start_playback__fill_strings (BseExportStrings *es)
{
  es->blurb = "Start playback in an activated project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_start_playback = {
  { (BseExportNode*) &__enode_activate, BSE_EXPORT_NODE_PROC,
    "BseProject+start-playback", 
    NULL,
    "/Methods/BseProject/General/Start Playback",
    NULL,
    __enode_start_playback__fill_strings,
  },
  0, start_playback_setup, start_playback_exec, 
};
static void
__enode_play__fill_strings (BseExportStrings *es)
{
  es->blurb = "Activate a project and start project playback (and already playing project is first halted).";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_play = {
  { (BseExportNode*) &__enode_start_playback, BSE_EXPORT_NODE_PROC,
    "BseProject+play", 
    NULL,
    "/Methods/BseProject/General/Play",
    NULL,
    __enode_play__fill_strings,
  },
  0, play_setup, play_exec, 
};
static void
__enode_deactivate__fill_strings (BseExportStrings *es)
{
  es->blurb = "Deactivate the project, automatically stop playback.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_deactivate = {
  { (BseExportNode*) &__enode_play, BSE_EXPORT_NODE_PROC,
    "BseProject+deactivate", 
    NULL,
    "/Methods/BseProject/General/Deactivate",
    NULL,
    __enode_deactivate__fill_strings,
  },
  0, deactivate_setup, deactivate_exec, 
};
static void
__enode_stop_playback__fill_strings (BseExportStrings *es)
{
  es->blurb = "Stop project playback.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_stop_playback = {
  { (BseExportNode*) &__enode_deactivate, BSE_EXPORT_NODE_PROC,
    "BseProject+stop-playback", 
    NULL,
    "/Methods/BseProject/General/Stop Playback",
    NULL,
    __enode_stop_playback__fill_strings,
  },
  0, stop_playback_setup, stop_playback_exec, 
};
static void
__enode_stop__fill_strings (BseExportStrings *es)
{
  es->blurb = "Stop project playback and deactivate project.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_stop = {
  { (BseExportNode*) &__enode_stop_playback, BSE_EXPORT_NODE_PROC,
    "BseProject+stop", 
    NULL,
    "/Methods/BseProject/General/Stop",
    NULL,
    __enode_stop__fill_strings,
  },
  0, stop_setup, stop_exec, 
};
static void
__enode_auto_deactivate__fill_strings (BseExportStrings *es)
{
  es->blurb = "Automatically deactivate a project once playback stopped.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_auto_deactivate = {
  { (BseExportNode*) &__enode_stop, BSE_EXPORT_NODE_PROC,
    "BseProject+auto-deactivate", 
    NULL,
    "/Methods/BseProject/General/Auto Deactivate",
    NULL,
    __enode_auto_deactivate__fill_strings,
  },
  0, auto_deactivate_setup, auto_deactivate_exec, 
};
static void
__enode_inject_midi_control__fill_strings (BseExportStrings *es)
{
  es->blurb = "Inject a MIDI control event into the project's MIDI receiver.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_inject_midi_control = {
  { (BseExportNode*) &__enode_auto_deactivate, BSE_EXPORT_NODE_PROC,
    "BseProject+inject-midi-control", 
    NULL,
    "/Methods/BseProject/General/Inject Midi Control",
    NULL,
    __enode_inject_midi_control__fill_strings,
  },
  0, inject_midi_control_setup, inject_midi_control_exec, 
};
static void
__enode_change_name__fill_strings (BseExportStrings *es)
{
  es->blurb = "Change a project name without recording undo steps.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_change_name = {
  { (BseExportNode*) &__enode_inject_midi_control, BSE_EXPORT_NODE_PROC,
    "BseProject+change-name", 
    NULL,
    "/Methods/BseProject/General/Change Name",
    NULL,
    __enode_change_name__fill_strings,
  },
  0, change_name_setup, change_name_exec, 
};
static void
__enode_undo_depth__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project can perform undo steps";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_undo_depth = {
  { (BseExportNode*) &__enode_change_name, BSE_EXPORT_NODE_PROC,
    "BseProject+undo-depth", 
    NULL,
    "/Methods/BseProject/General/Undo Depth",
    NULL,
    __enode_undo_depth__fill_strings,
  },
  0, undo_depth_setup, undo_depth_exec, 
};
static void
__enode_undo__fill_strings (BseExportStrings *es)
{
  es->blurb = "Undo a previous operation in a project";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_undo = {
  { (BseExportNode*) &__enode_undo_depth, BSE_EXPORT_NODE_PROC,
    "BseProject+undo", 
    NULL,
    "/Methods/BseProject/General/Undo",
    NULL,
    __enode_undo__fill_strings,
  },
  0, undo_setup, undo_exec, 
};
static void
__enode_redo_depth__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project can perform redo steps";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_redo_depth = {
  { (BseExportNode*) &__enode_undo, BSE_EXPORT_NODE_PROC,
    "BseProject+redo-depth", 
    NULL,
    "/Methods/BseProject/General/Redo Depth",
    NULL,
    __enode_redo_depth__fill_strings,
  },
  0, redo_depth_setup, redo_depth_exec, 
};
static void
__enode_redo__fill_strings (BseExportStrings *es)
{
  es->blurb = "Redo a previously undone operaiton in a project";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_redo = {
  { (BseExportNode*) &__enode_redo_depth, BSE_EXPORT_NODE_PROC,
    "BseProject+redo", 
    NULL,
    "/Methods/BseProject/General/Redo",
    NULL,
    __enode_redo__fill_strings,
  },
  0, redo_setup, redo_exec, 
};
static void
__enode_clear_undo__fill_strings (BseExportStrings *es)
{
  es->blurb = "Delete all recorded undo or redo steps.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_clear_undo = {
  { (BseExportNode*) &__enode_redo, BSE_EXPORT_NODE_PROC,
    "BseProject+clear-undo", 
    NULL,
    "/Methods/BseProject/General/Clear Undo",
    NULL,
    __enode_clear_undo__fill_strings,
  },
  0, clear_undo_setup, clear_undo_exec, 
};
static void
__enode_clean_dirty__fill_strings (BseExportStrings *es)
{
  es->blurb = "Clear a projects dirty flags.";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_clean_dirty = {
  { (BseExportNode*) &__enode_clear_undo, BSE_EXPORT_NODE_PROC,
    "BseProject+clean-dirty", 
    NULL,
    "/Methods/BseProject/General/Clean Dirty",
    NULL,
    __enode_clean_dirty__fill_strings,
  },
  0, clean_dirty_setup, clean_dirty_exec, 
};
static void
__enode_is_dirty__fill_strings (BseExportStrings *es)
{
  es->blurb = "Check whether a project is dirty (needs saving).";
  es->authors = "Tim Janik <timj@gtk.org>";
  es->license = "GNU General Public License";
}
static BseExportNodeProc __enode_is_dirty = {
  { (BseExportNode*) &__enode_clean_dirty, BSE_EXPORT_NODE_PROC,
    "BseProject+is-dirty", 
    NULL,
    "/Methods/BseProject/General/Is Dirty",
    NULL,
    __enode_is_dirty__fill_strings,
  },
  0, is_dirty_setup, is_dirty_exec, 
};
BseExportNode* bse__builtin_init_bseproject_gen_proc_c (void);
BseExportNode* bse__builtin_init_bseproject_gen_proc_c (void)
{
  return (BseExportNode*) &__enode_is_dirty;
}

/*
 * Generated data ends here
 */
