/***************************************************************************
                         -- tb_misc.cc --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#include "tb_misc.h"
#include "qfiledialog.h"
#include "qfileinfo.h"
#include "qstringlist.h"
#include "vr_filepreview.h"

/* 
 *  Constructs a ToolboxMisc which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
ToolboxMisc::ToolboxMisc( QWidget* parent,  const char* name, WFlags fl )
    : ToolboxMiscBase( parent, name, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ToolboxMisc::~ToolboxMisc()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * protected slot
 */
void ToolboxMisc::modified()
{
	changed();
}

void ToolboxMisc::rootBrowseClicked()
{
	QString file;
	MyPreview* p = new MyPreview;     
	QFileDialog* fd = new QFileDialog( QString::null, "All (*)", this, "w", true );
	fd->setContentsPreviewEnabled( TRUE );
	fd->setContentsPreview( p, p );
	fd->setMode( QFileDialog::ExistingFile );
	// fd->setDir( styledir );
	fd->setCaption( "Select File");
	fd->setPreviewMode( QFileDialog::Contents );
	fd->setShowHiddenFiles(true);

	// set the working directory if we can
	QString text = TRootCommand->text();
	if ( text.length() ) {
		QStringList list;
		list = list.split(" ",text.latin1(), false);
		for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it ) {
			QFileInfo file( (*it).latin1() );
			if ( file.exists() ) {
				fd->setSelection((*it).latin1());
			}
		}
	}

	if ( fd->exec() == QDialog::Accepted ) {
        	file = fd->selectedFile();
		TRootCommand->setText("bsetbg -f "+file);
	}

}

