/***************************************************************************
                         -- color.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef COLOR_HH
#define COLOR_HH

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qstring.h>
#include <qhgroupbox.h>

class ColorButton : public QPushButton {
	Q_OBJECT
public:
	ColorButton( QWidget *parent=0, const char *name=0 );
	QColor getColor() const { return color; };
	void setColor( QColor );
	QString getColorString() const;

public slots:
	void doColorSelect();

signals:
	void changed();

private:
	QColor color;
};


class ColorSelector : public QHGroupBox {
	Q_OBJECT
public:
	ColorSelector( QWidget *parent=0, const char *name=0 );
	~ColorSelector();
	QString getColorString() const;
	
public slots:
	void colorTextChanged( const QString& );
	void disable( bool );
	void setColor( QColor );

private:
	ColorButton *button;
	QLineEdit *lineedit;
};

#endif
