/***************************************************************************
                         -- menu.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef MENUEDITOR_H
#define MENUEDITOR_H

#include "menu_base.h"
#include "qlistview.h"
#include "qcombobox.h"
#include "qscrollview.h"
#include "qpushbutton.h"
#include "qvariant.h"
#include "plugin.h"
#include "menuitem.h"

#include "qlineedit.h"


class MenuEditor : public MenuEditorBase
{ 
	Q_OBJECT

public:
	MenuEditor( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~MenuEditor();
	void loadMenu(TreeNode<menuitem> *menu);

signals:
	void changed();

protected slots:
 	void modified();
	void dataTextChanged(const QString&);
	void descriptionTextChanged(const QString&);
	void itemDeleteClicked();
	void itemDownClicked();
	void itemNewClicked();
	void itemNewSubClicked();
	void itemUpClicked();
	void menuSelectionChanged(QListViewItem*);
	void dataBrowseClicked();
	void descriptionBrowseClicked();
	void titleTextChanged(const QString&);
	void typeDropdownChanged(int);
private:
	void customizeWidgets(int);
	bool reloading;
	bool listview_changed;
	void loadListview(TreeNode<menuitem> *menu, bool submenu = false);

};

#endif // MENUEDITOR_H
