/***************************************************************************
                         -- my_kkeybutton.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef _KKEYBUTTON_H_
#define _KKEYBUTTON_H_

#include <qpushbutton.h>
/**
 *  A push button that looks like a keyboard key.
 *  @short A push button that looks like a keyboard key.
 *  @author Mark Donohoe <donohoe@kde.org>
 *  @internal
 */
class KKeyButton: public QPushButton
{
  Q_OBJECT

public:

  /**
   * Constructs a key button widget.
   */
  KKeyButton( QWidget *parent=0, const char *name=0 );
  /**
   * Destructs the key button widget.
   */
  ~KKeyButton();

  void setKey( uint key );
  uint getKey()			{ return key; }
  /**
   * Reimplemented for internal purposes.
   */
  void setText( const QString& text );
  /**
   * Sets the widget into editing mode or not.
   * In editing mode, the widget has a different
   * look.
   */
  //void setEditing(bool _editing);
  void captureKey( bool bCapture );
  /**
   * @return whether the widget is in editing mode.
   */
  bool isCapturing() const	{ return editing; }

signals:
  void capturedKey( uint key );

public slots:
  void captureKey();
	void setEnabled(bool);

protected:
  virtual bool x11Event( XEvent *pEvent );
  void keyPressEventX( XEvent *pEvent );

protected:
  /**
   * Reimplemented for internal reasons.
   */
  void drawButton( QPainter* _painter );

private:
  bool editing;
  uint key;

  //class KKeyButtonPrivate;
  //KKeyButtonPrivate *d;
};


#endif
