/***************************************************************************
                         -- map.h --
                         -------------------
    begin                : 2001-09-01
    copyright            : (C) 2001 - 2002
    authors              : Jason Kasper (vanRijn)
                         : Ben Jansens (xOr)
    URL                  : http://bbconf.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 // E_O_H_VR
#ifndef __MAP_H
#define __MAP_H

template<class T1, class T2> class bbc_map {
	public:
		bbc_map() { next = NULL; }
		~bbc_map() { if(next) delete next; }
		void add(T1 i1, T2 i2) {
			if (next)
				next->add(i1, i2);
			else {
				next = new bbc_map;
				next->index1 = i1;
				next->index2 = i2;
			}
		}
		void add(T2 i2, T1 i1) {
			if (next)
				next->add(i2, i1);
			else {
				next = new bbc_map;
				next->index1 = i1;
				next->index2 = i2;
			}
		}
		T2 find(T1 search) {
			if (search == index1) return index2;
			else if (next) return next->find(search);
			else return NULL;
		}
		T1 find(T2 search) {
			if (search == index2) return index1;
			else if (next) return next->find(search);
			else return NULL;
		}
	private:
		T1 index1;
		T2 index2;
		bbc_map<T1, T2> *next;
};

#endif //__MAP_H
