#!/bin/bash
# -*- shell-script -*-

test_preserve_set_opts()
{
    set -u
    old_opts=$-
    # If running make distcheck we can't use top_builddir
    # because some files aren't there but are in the install
    # directory. 
    if [[ -f $top_builddir/dbg-opts.sh ]] ; then
	libdir=${top_builddir}
    else
	libdir=${prefix}/share/bashdb
    fi
    if [[ -f $libdir/dbg-opts.sh ]] ; then
	# Name we refer to ourselves by
	typeset _Dbg_debugger_name='bashdb'
	# The release name we are configured to run under.
	typeset _Dbg_release='4.0-0.2'
	. ${top_builddir}/bashdb-trace -L $libdir
	assertEquals $old_opts $-
    else
	echo 'Skipping test - building outside of source complications'
    fi
}

# load shunit2
prefix=/usr/local
top_builddir=/src/external-cvs/bashdb-3.1
top_srcdir=/src/external-cvs/bashdb-3.1
. ${top_srcdir}/lib/sig.sh
. ${top_srcdir}/lib/help.sh
. ${top_srcdir}/command/tracefn.sh

srcdir=.
srcdir=${srcdir}/
. ${srcdir}/shunit2

