# barectf 2 changelog

## barectf v2.2.0

**Features**:

  * Add `$default` boolean property to stream objects, and
    `$default-stream` string property to the metadata object, to specify
    a _default stream_: when a default stream exists, tracing function
    aliases without the default stream name (`barectf_trace_my_event()`,
    for example) are also generated
  * Add `options` property to the configuration object, with:
    * `gen-prefix-def`: true to generate a preprocessor definition
      (`#define`) in `barectf.h` for the effective prefix
    * `gen-default-stream-def`: true to generate a preprocessor
      definition for the default stream name, if any
  * Create `barectf-tracepoint.h`, a bridging C header file that
    allows LTTng-UST tracepoints to be used as is with barectf by
    providing the same `tracepoint()` macro

**Tests**:

  * Test the new `$default` (stream object), `$default-stream` (metadata
    object), and `options` (configuration object) properties

**README.md**:

  * Add instructions for installing barectf on Arch Linux using the AUR
  * Add instructions for installing barectf on Ubuntu using a PPA


## barectf v2.1.4

**Minor improvements**:

  * Override default metadata `env` entries with user entries instead of
    the opposite
  * Statically align and compute the size of event fields when possible
    for the `_get_event_size_*()` functions when possible

**Bug fixes**:

  * Do not write event's `stream_id` or stream's `id` when the trace
    packet header type has no `stream_id` field.

**Tests**:

  * Add config test for multiple streams, no `stream_id` field in packet
    header type

**README.md**:

  * Indicate how to install the command's man page


## barectf v2.1.3

**Minor improvements**:

  * Allow no or empty event payload type, as long as the event is not
    empty itself (contains at least one field in its 4 entities)

**Tests**:

  * Remove no/empty event payload type config tests
  * Add config test for empty event

**README.md**:

  * Add image on top
  * Add Community section


## barectf v2.1.2

**Bug fixes**:

  * Inherit from appropriate unsigned integer type aliases in
    `stdint.yaml` for self-aligned, signed integer type aliases


## barectf v2.1.1

**Bug fixes**:

  * Force clock offset object properties to their default values when
    set to `null`

**README.md**:

  * Update Babeltrace's URL
  * Add `--python=python3` option to virtualenv line in the
    testing section


## barectf v2.1.0

**Features**:

  * Add `$include` property to metadata, clock, trace, stream, and
    event objects to [include external YAML files](https://github.com/efficios/barectf/wiki/Including-external-YAML-files)
  * Object properties which have a default value can force it
    with `null`; this is especially useful when also using type
    inheritance or including external YAML files

**Bug fixes**:

  * Fix a few error messages
  * Use appropriate prefix for event context type parameters in
    generated code
  * `_write_cstring()`: use prefix
  * Enumeration type object: start from current last value when
    adding label-only members to parent object
  * Check the size of the `id` (event header) and `stream_id`
    (packet header) to make sure they can fit all events/streams
  * Reduce the number of compiler warnings when using `-Wall` and
    `-pedantic`
  * Make sure all entity types are structure types
  * Make sure all enumeration type object member values fit within
    the enumeration's value type
  * Check for unknown properties in enumeration type object
  * Check for unknown properties in floating point number size object
  * Check for unknown `base` values in integer type object
  * Check the type of the `byte-order` property in trace object
  * Check the signedness of the `uuid` field's element type in the
    trace packet header type
  * Check for unknown properties in configuration object
  * Check node type before checking its properties
  * Use unions to write floating point numbers to avoid aliasing warnings

**Tests**:

  * Add configuration file tests

**README.md**:

  * Add CI badge
  * Add C99 compliance limitation
  * Move documentation to the project's wiki


## barectf v2.0.2

**README.md**:

  * Add PyPI badge
  * Fix Arch Linux installation command line


## barectf v2.0.1

**Bug fixes**:

  * Fix various bugs in the Parallella platform


## barectf v2.0.0

Initial release.

Major changes from barectf 0.x:

  * Single YAML configuration input
  * TSDL metadata is generated by barectf instead of being consumed
  * Introduction of platforms to handle buffers automatically with
    custom callbacks and to allow continuous tracing
  * Various optimizations in the generated C code
