/***************************************************************************
 *            bbthread.c
 *
 *  Thu Jul  7 12:09:24 2005
 *  Copyright  2005  Fabio Marzocca
 *  Email
 ****************************************************************************/

#include <config.h>

#include <string.h>
#include <time.h>
#include <pwd.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs.h>
#include <glib/gstdio.h>
#include <fnmatch.h>

#include "baobab.h"
#include "bbthread.h"
#include "hardlinks.h"


struct allsizes {
	GnomeVFSFileSize size;
	GnomeVFSFileSize alloc_size;
};

static struct allsizes loopdir(GnomeVFSURI *, guint, baobab_hardlinks_array *);
static void loopsearch(GnomeVFSURI*,gchar*);


static void
loopsearch(GnomeVFSURI *vfs_uri_dir, gchar* search)
{
	GList 	*file_list, *l;
	gchar  *dir;
	struct BaobabSearchRet bbret;
	GnomeVFSResult result;
	GnomeVFSURI	*new_uri;

	dir = gnome_vfs_uri_to_string(vfs_uri_dir,GNOME_VFS_URI_HIDE_NONE);
	if (baobab.bbExcludedDirs && 
		(g_slist_find_custom(baobab.bbExcludedDirs,dir,list_find) != NULL)) 
		return ;
	
	/* get the GnomeVFSFileInfo stuct for every directory entry */
	result = gnome_vfs_directory_list_load(&file_list,dir,GNOME_VFS_FILE_INFO_GET_MIME_TYPE );
	g_free(dir);
	while (gtk_events_pending()) { gtk_main_iteration(); }
	if(result == GNOME_VFS_OK) {
		for (l = file_list; l != NULL; l = l->next) {
			GnomeVFSFileInfo * info = l->data;
			if (baobab.STOP_SCANNING) {gnome_vfs_file_info_list_free (file_list); 
						  return ;}
			if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_TYPE) == 0) continue;
			if (strcmp(info->name,".")==0 || strcmp(info->name,"..")==0) continue;
			new_uri = gnome_vfs_uri_append_file_name(vfs_uri_dir,info->name);
			dir = gnome_vfs_uri_to_string(new_uri,GNOME_VFS_URI_HIDE_NONE);
			if (fnmatch(search,info->name,FNM_PATHNAME|FNM_PERIOD)==0) {
				gchar * string_to_display = gnome_vfs_format_uri_for_display(dir);
				bbret.fullpath = string_to_display;
				bbret.size = info->size;
				bbret.lastacc = info->mtime;
				bbret.owner=info->uid;
				bbret.alloc_size = info->block_count*512;
				bbret.mime_type = info->mime_type;
				fill_search_model(&bbret);
				g_free(string_to_display);
				}
			/* is a directory? */
			if (info->type == GNOME_VFS_FILE_TYPE_DIRECTORY && 
						!bbSearchOpt.dont_recurse_dir) {
				if (strcmp(gnome_vfs_uri_get_path(vfs_uri_dir),"/proc") !=0) {
					loopsearch(new_uri,search);	
				}
			}
			gnome_vfs_uri_unref(new_uri);
			g_free(dir);			
		}
		gnome_vfs_file_info_list_free (file_list);
	}
	
	return ;
}


static struct allsizes
loopdir(GnomeVFSURI *vfs_uri_dir, guint count, baobab_hardlinks_array * hla)
{
	GList 	*file_list, *l;
	guint64 tempHLsize;
	gint elements;	
	struct chan_data data;
	struct allsizes retloop;
	struct allsizes temp;
	GnomeVFSResult result;
	gchar * dir, *string_to_display;
	GnomeVFSURI	*new_uri;
	GnomeVFSFileInfo *dir_info;
		
	count++;	
	elements=0;
	tempHLsize=0;
	retloop.size=0;
	retloop.alloc_size=0;
	
	dir = gnome_vfs_uri_to_string(vfs_uri_dir,GNOME_VFS_URI_HIDE_NONE);

	if (!baobab.is_local)
		string_to_display = gnome_vfs_unescape_string_for_display(dir);
	else
		string_to_display = gnome_vfs_format_uri_for_display(dir);
	
	if (baobab.bbExcludedDirs && 
		(g_slist_find_custom(baobab.bbExcludedDirs, dir,list_find) != NULL)) 
			goto exit;
	
	if (strcmp(gnome_vfs_uri_get_path(vfs_uri_dir),"/proc") ==0) 
			goto exit;

		
		
	/* prefill the model */
	data.size=1;
	data.alloc_size=1;
	data.depth=count-1;
	data.elements=-1;
	data.dir=string_to_display;
	data.tempHLsize = tempHLsize;
	fill_model(&data);

	/* get the directory-entry sizes */
	dir_info = gnome_vfs_file_info_new();
	gnome_vfs_get_file_info(dir, dir_info,GNOME_VFS_FILE_INFO_DEFAULT);
	if  ((dir_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_SIZE) != 0)
	retloop.size=dir_info->size;
	if  ((dir_info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_BLOCK_COUNT) != 0)
		retloop.alloc_size = dir_info->block_count*dir_info->io_block_size;
	gnome_vfs_file_info_unref(dir_info);
	
	/* get the GnomeVFSFileInfo stuct for every directory entry */
	result = gnome_vfs_directory_list_load(&file_list,dir,GNOME_VFS_FILE_INFO_DEFAULT );	

	    if(result == GNOME_VFS_OK) {		
		for (l = file_list; l != NULL; l = l->next) {
			GnomeVFSFileInfo * info = l->data;
			if (strcmp(info->name,".")==0 || strcmp(info->name,"..")==0) continue;
			if (baobab.STOP_SCANNING) goto exit;
			if ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_TYPE) == 0)
					{	continue;
						gnome_vfs_file_info_list_free (file_list); 
						goto exit;
						}			
			/* is a symlink? */
			if (info->type == GNOME_VFS_FILE_TYPE_SYMBOLIC_LINK)  continue;
			/* is a directory? */
			if (info->type == GNOME_VFS_FILE_TYPE_DIRECTORY) {				
					new_uri = gnome_vfs_uri_append_file_name(vfs_uri_dir,info->name);
					temp= loopdir(new_uri, count, hla);
					retloop.size += temp.size;
					retloop.alloc_size += temp.alloc_size;
					elements++;
					gnome_vfs_uri_unref(new_uri);				
			}
			else if ( info->type == GNOME_VFS_FILE_TYPE_REGULAR ) {
				/* check for hard links */
				/* only on local files */
				if (GNOME_VFS_FILE_INFO_LOCAL(info)) {
				   if (info->link_count > 1) {

					if (baobab_hardlinks_array_has(hla, info)) {
						tempHLsize += (info->block_count*info->io_block_size); 
						continue;
					}
					else {
						baobab_hardlinks_array_add(hla,info);
					}
				   }
				}
				if  ((info->valid_fields & GNOME_VFS_FILE_INFO_FIELDS_BLOCK_COUNT) != 0)
					retloop.alloc_size += (info->block_count*512);
				
				retloop.size += info->size;
				elements++;		
			}

		}
		gnome_vfs_file_info_list_free (file_list);
	    }

	data.dir = string_to_display;
	data.size = retloop.size;
	data.alloc_size = retloop.alloc_size;
	data.depth= count-1;
	data.elements= elements;
	data.tempHLsize = tempHLsize;
	fill_model(&data);

   	exit:
	g_free(dir);
	g_free(string_to_display);
	return retloop;
}






void 
getDir(gchar *uri_dir)
{
	baobab_hardlinks_array *hla;
	GnomeVFSURI *vfs_uri;
	GnomeVFSFileInfo *info;

	info = gnome_vfs_file_info_new();
	gnome_vfs_get_file_info(uri_dir, info,GNOME_VFS_FILE_INFO_DEFAULT);
		
	if (baobab.bbExcludedDirs && 
		(g_slist_find_custom(baobab.bbExcludedDirs,uri_dir,list_find) != NULL))
		return;

	hla = baobab_hardlinks_array_create();

	vfs_uri = gnome_vfs_uri_new (uri_dir);
	
	loopdir(vfs_uri, 0, hla);

	baobab_hardlinks_array_free(hla);
	gnome_vfs_uri_unref(vfs_uri);
	gnome_vfs_file_info_unref(info);
	
}

void
searchDir(gchar * uri_dir, gchar* search)
{
	GnomeVFSURI *vfs_uri;
	
	vfs_uri = gnome_vfs_uri_new (uri_dir);
	loopsearch(vfs_uri,search);
	gnome_vfs_uri_unref(vfs_uri);
}

gboolean
bb_scan_is_local(gchar * uri_dir)
{
	GnomeVFSFileInfo *info;
	gboolean bret;
	
	info = gnome_vfs_file_info_new();
	gnome_vfs_get_file_info(uri_dir, info,GNOME_VFS_FILE_INFO_DEFAULT);
	
	if ((info)->flags & GNOME_VFS_FILE_FLAGS_LOCAL)
		bret = TRUE;
	else
		bret = FALSE;

	gnome_vfs_file_info_unref(info);
	return bret;

}



