/***************************************************************************
 *            baobab.h
 *
 *  Tue Jul  5 10:36:52 2005
 *  Copyright  2005  Fabio Marzocca
 *  Email
 ****************************************************************************/
#ifndef BAOBAB_H_20050706
#define BAOBAB_H_20050706


#include <time.h>
#include <sys/types.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glade/glade-xml.h>


typedef struct _baobab_application baobab_application;
typedef struct _baobab_fs baobab_fs;
struct BaobabSearchOpt;

#include "baobab_globals.h"

#include "bb_util.h"


	#define PIX_DIR (BAOBAB_DATA_DIR "/" PACKAGE "/pixmaps/"  )
	#define GLADE_DIR (BAOBAB_DATA_DIR "/" PACKAGE "/pixmaps/" )

#define VIEW_TREE 0
#define VIEW_SEARCH 1

	#define PROPS_SCAN_KEY "/apps/baobab/properties/noscan"
	#define PROPS_ENABLE_HOME_MONITOR "/apps/baobab/properties/enable_home_monitor"
	#define BAOBAB_KEY "/apps/baobab"


struct _baobab_application {
  	GtkWidget *window;
	GladeXML  *main_xml; 
	gchar	*glade_path;
  	GtkWidget * tree_view, * tree_search;
	GtkTreeStore * model;
	GtkListStore* model_search;
	GtkTreeStore * search_model;
	gboolean STOP_SCANNING;
	GdkPixbuf * green_bar,*yellow_bar,*red_bar;
	gboolean CONTENTS_CHANGED_DELAYED;
	GSList * bbExcludedDirs;
	gboolean bbEnableHomeMonitor;
	gchar* label_scan;
	gchar* label_search;
	GString* last_scan_command;
	gint number_found_files;
 	guint64 size_found_files;
	gboolean show_allocated;
	gboolean is_local;

	char *selected_path;
};


struct _baobab_fs {
	guint64 total;
	guint64 used;
	guint64 avail;
};


struct chan_data {
	guint64 size;
	guint64 alloc_size;
	guint64 tempHLsize;
	guint depth;
	gint elements;
	gchar *dir;
};
	

struct BaobabSearchRet {
	guint64 size;
	guint64 alloc_size;
	gchar * fullpath;
	time_t lastacc;
	uid_t owner;
	gchar *mime_type;
};
	
	/* Advanced search options enums */
	enum {
		NONE=1,
		LAST_WEEK=2,
		LAST_MONTH=3,
		SIZE_SMALL=2,
		SIZE_MEDIUM=3
	};
	
struct BaobabSearchOpt {
	GString* filename;
	GString * dir;
	gint mod_date;
	gint size_limit;
	gboolean dont_recurse_dir;
	gboolean exact;
	gboolean search_whole;
};
	

	void start_proc_on_dir (gchar *);
	void fill_model (struct chan_data* );
	void start_search (gchar*,gchar*);
	void fill_search_model(struct BaobabSearchRet *);
	void first_row(void);
	gint list_find  (gconstpointer a, gconstpointer b);
	
#endif
