/***************************************************************************
 *            utilities.c
 *
 *  Tue Jul  5 14:55:21 2005
 *  Copyright  2005  Fabio Marzocca
 *  Email	<thesaltydog@gmail.com>
 ****************************************************************************/
#include <stdlib.h>
#include <sys/stat.h>
#include <string.h>
#include <monetary.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-mime.h>
#include <libgnomevfs/gnome-vfs-mime-handlers.h>
#include <glibtop/mountlist.h>
#include <glibtop/fsusage.h>
 
#include "baobab.h"
#include "utilities.h"
#include "interface.h"
#include "support.h"
#include "tv.h"
#include "callbacks.h"

static int radio_group_get_active(GtkRadioButton * );
static void radio_group_set_active(GtkRadioButton * rb,int btn);
static void set_search_opt(GtkWidget* dlg);
static void save_search_opt(GtkWidget* dlg);




struct _fs
getFileSystem(void)
{	
	struct _fs fs;	
	int lo;	
	glibtop_mountlist mountlist;
	glibtop_mountentry *mountentry, *mountentry_tofree;
	glibtop_fsusage fsusage;
  	
	glibtop_init();
	
	memset(&fs,0,sizeof(struct _fs));
	mountentry_tofree = glibtop_get_mountlist(&mountlist, 0);
	  for (lo = 0, mountentry = mountentry_tofree; lo < mountlist.number; lo++, mountentry++) {
    	glibtop_get_fsusage(&fsusage, mountentry->mountdir);
		  // check if not an "excluded" mount point
		  // v.1.1.1 changed bavail with bfree)
		if ((g_slist_find_custom(baobab.bbExcludedDirs,mountentry->mountdir,list_find))==NULL) {	
    		fs.total += fsusage.blocks*fsusage.block_size;
			fs.avail += fsusage.bfree*fsusage.block_size;
			fs.used  += (fsusage.blocks-fsusage.bfree)*fsusage.block_size;
		}
  	}
    free(mountentry_tofree);
	
	glibtop_close();
	return fs;
}


void
set_statusbar(gchar * text)
{
	guint context=1;
	text=g_filename_display_name(text);
	GtkWidget* sb = lookup_widget (GTK_WIDGET(baobab.window), "statusbar1");
	gtk_statusbar_pop(GTK_STATUSBAR (sb), context);
	gtk_statusbar_push(GTK_STATUSBAR(sb),context,text);
	while (gtk_events_pending()) { gtk_main_iteration(); }
	
}

/* GtkFileChooser to select a directory to scan
*/
gchar*
dir_select (gboolean SEARCH, GtkWidget* parent)
{
	GtkWidget *dialog;
	GtkWidget * toggle;
	
	dialog = gtk_file_chooser_dialog_new (_("Select a directory"),
				      GTK_WINDOW (parent),
				      GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER,
				      GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				      GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
				      NULL);

	gtk_file_chooser_set_show_hidden(GTK_FILE_CHOOSER (dialog),TRUE);
	gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER (dialog), 
								g_get_home_dir ());
	//add extra widget
	toggle = gtk_check_button_new_with_label (_("Show hidden directories"));
  	gtk_widget_show (toggle);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle),TRUE);
  	g_signal_connect ((gpointer) toggle, "toggled",
                    G_CALLBACK (on_toggled),
                    dialog);
	gtk_file_chooser_set_extra_widget (GTK_FILE_CHOOSER (dialog), toggle);
	
	
	if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_ACCEPT)
	{
		char *filename;
    	filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialog));
		gtk_widget_destroy (dialog);
		if (!SEARCH) {
    		start_proc_on_dir(filename);
    		g_free (filename);
			return NULL;
			}
		else {
			return(filename);
		}
  	}
	else {
		gtk_widget_destroy (dialog);
		return NULL;
	}
}


void
on_toggled                   (GtkToggleButton   *togglebutton,
                                        gpointer         dialog)
{
	gtk_file_chooser_set_show_hidden(GTK_FILE_CHOOSER (dialog),
		!gtk_file_chooser_get_show_hidden(GTK_FILE_CHOOSER (dialog)));
}



/* change busy icon
*/

void
change_icon(gchar *filename)
{
	GdkPixbufAnimation* anim;
	GError *err=NULL;
	GString *pathname ;
	
	pathname=g_string_new(PIX_DIR);
	g_string_append(pathname,"/");
	g_string_append(pathname,filename);
	GtkWidget* image = lookup_widget (GTK_WIDGET(baobab.window), "busyimage");

	anim= gdk_pixbuf_animation_new_from_file (pathname->str, &err);
	if(err!=NULL) {
		g_print("%s\n",err->message);
		g_error_free(err);
	}

	g_string_free (pathname,TRUE);
	gtk_image_set_from_animation(GTK_IMAGE(image),anim); 
	
}

////////////////////////////////////////////////

GdkPixbuf * 
set_bar(gfloat perc)
{
	
	GdkPixbuf * srcpxb=NULL, *destpxb;
	gint height,width;
	
	if (perc <= 33.0 ) {
			srcpxb = baobab.green_bar;
		}
	else if (perc > 33.0 && perc <= 60.0) {
			srcpxb = baobab.yellow_bar;
		}
	else if (perc > 60.0) {
			srcpxb = baobab.red_bar;
		}
		
	destpxb=create_pixbuf("white.png");
	height = gdk_pixbuf_get_height(destpxb);
	width = gdk_pixbuf_get_width(destpxb)-1; 
	width = (gint)(gfloat)((width*perc)/100.0);         //if bar width ==50 --> $width = $perc/2
	
	gdk_pixbuf_copy_area(srcpxb,1,1,width-2,height-2,destpxb,1,1);
                                        
	return destpxb;
}

////////////////////// menu & toolbar sensitivity
void
check_menu_sens(gboolean scanning)
{
	if (scanning) {
		while (gtk_events_pending()) { gtk_main_iteration();}
		set_statusbar(_("Scanning..."));
		GtkWidget* tbstop = lookup_widget (GTK_WIDGET(baobab.window), "tbstop");
		gtk_widget_set_sensitive(tbstop,TRUE);
		GtkWidget* tbscanall = lookup_widget (GTK_WIDGET(baobab.window), "tbscanall");
		gtk_widget_set_sensitive(tbscanall,FALSE);
		GtkWidget* tbscandir = lookup_widget (GTK_WIDGET(baobab.window), "tbscandir");
		gtk_widget_set_sensitive(tbscandir,FALSE);
		GtkWidget* menuallfs = lookup_widget (GTK_WIDGET(baobab.window), "menuallfs");
		gtk_widget_set_sensitive(menuallfs,FALSE);
		GtkWidget* menuscandir = lookup_widget (GTK_WIDGET(baobab.window), "menuscandir");
		gtk_widget_set_sensitive(menuscandir,FALSE);
		GtkWidget* tb_search = lookup_widget (GTK_WIDGET(baobab.window), "tb_search");
		gtk_widget_set_sensitive(tb_search,FALSE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "preferenze1"),FALSE);
		gtk_widget_set_sensitive(lookup_widget (GTK_WIDGET(baobab.window), "search_for_a_file"),FALSE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "tbprops"),FALSE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "ck_allocated"),FALSE);		
		if (get_NB_page()==VIEW_SEARCH) {
					gtk_widget_set_sensitive(lookup_widget (baobab.window, "label1"),FALSE);
			}
		}
	else {
		GtkWidget* tbstop = lookup_widget (GTK_WIDGET(baobab.window), "tbstop");
		gtk_widget_set_sensitive(tbstop,FALSE);
		if (get_NB_page()==VIEW_TREE) {
			gtk_widget_set_sensitive(lookup_widget (baobab.window, "ck_allocated"),TRUE);
			}
		GtkWidget* tbscanall = lookup_widget (GTK_WIDGET(baobab.window), "tbscanall");
		gtk_widget_set_sensitive(tbscanall,TRUE);
		GtkWidget* tbscandir = lookup_widget (GTK_WIDGET(baobab.window), "tbscandir");
		gtk_widget_set_sensitive(tbscandir,TRUE);
		GtkWidget* menuallfs = lookup_widget (GTK_WIDGET(baobab.window), "menuallfs");
		gtk_widget_set_sensitive(menuallfs,TRUE);
		GtkWidget* menuscandir = lookup_widget (GTK_WIDGET(baobab.window), "menuscandir");
		gtk_widget_set_sensitive(menuscandir,TRUE);
		GtkWidget* tb_search = lookup_widget (GTK_WIDGET(baobab.window), "tb_search");
		gtk_widget_set_sensitive(tb_search,TRUE);
		gtk_widget_set_sensitive(lookup_widget (GTK_WIDGET(baobab.window), "search_for_a_file"),TRUE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "label1"),TRUE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "preferenze1"),TRUE);
		gtk_widget_set_sensitive(lookup_widget (baobab.window, "tbprops"),TRUE);		

			}
}

//////////////////////////////////////
void
stop_scan(void)
{
	if(get_NB_page()==VIEW_TREE) {
		set_statusbar( _("Calculating percentage bars..."));
		gtk_tree_model_foreach((GtkTreeModel*)baobab.model,show_bars,NULL);
		gtk_tree_view_columns_autosize((GtkTreeView *)baobab.tree_view);
	}
	change_icon("done.png");
	check_menu_sens(FALSE);
	set_statusbar( _("Ready"));	
}
///////////////////////////////////////////
gboolean
show_bars (GtkTreeModel *mdl,
           GtkTreePath *path,
           GtkTreeIter *iter,
           gpointer data)
{
	GtkTreeIter parent;
	gfloat perc;
	gint readelements, size_col;
	guint64 refsize,size;
	gchar textperc[10];
	char* sizecstr=NULL;

	if (baobab.show_allocated)  size_col= (gint)COL_H_ALLOCSIZE;
	else size_col= (gint)COL_H_SIZE;
	
	if(gtk_tree_model_iter_parent (mdl,&parent,iter)) {
		gtk_tree_model_get(mdl,&parent,COL_H_ELEMENTS,&readelements,-1);
		if (readelements==-1) {return TRUE;}
		gtk_tree_model_get(mdl,iter,COL_H_ELEMENTS,&readelements,-1);
		if (readelements==-1) {return TRUE;}
		gtk_tree_model_get(mdl,&parent,size_col,&refsize,-1);
		if (refsize==0) {return FALSE;}		
		gtk_tree_model_get(mdl,iter,size_col,&size,-1);
	    perc =((gfloat)size*100)/(gfloat)refsize;
		g_sprintf(textperc," %.1f %%",perc);
		sizecstr = gnome_vfs_format_file_size_for_display(size);

		gtk_tree_store_set((GtkTreeStore*)mdl,iter,
					COL_BAR,set_bar(perc),
					COL_DIR_SIZE,sizecstr,
					COL_H_PERC,perc,
					COL_PERC,textperc,
					-1);
		g_free(sizecstr);
		}
	else {
		gtk_tree_model_get(mdl,iter,COL_H_ELEMENTS,&readelements,-1);
		if (readelements !=-1) {
			gtk_tree_model_get(mdl,iter,size_col,&size,-1);
			sizecstr = gnome_vfs_format_file_size_for_display(size);
			gtk_tree_store_set((GtkTreeStore*)mdl,iter,
				COL_BAR,set_bar(100.0),
				COL_H_PERC,100.0,
				COL_PERC,"100 %",
				COL_DIR_SIZE,sizecstr,
				-1);
			g_free(sizecstr);
			}
		}
	return FALSE;	
}


////////////////////////////////////////////////
void
message(gchar* messaggio,GtkWidget* parent)
{
	GtkWidget * dialog;
	dialog = gtk_message_dialog_new(GTK_WINDOW(parent),
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_INFO,
                                  GTK_BUTTONS_OK,
                                  "%s",messaggio);	
	gtk_message_dialog_set_markup((GtkMessageDialog*)dialog,messaggio);
	gtk_dialog_run (GTK_DIALOG (dialog));
    gtk_widget_destroy (dialog);
	
}
////////////////////////////////////////////////
gint
messageyesno(gchar* messaggio,GtkWidget* parent)
{
	GtkWidget * dialog;
	gint response;
	dialog = gtk_message_dialog_new(GTK_WINDOW(parent),
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_QUESTION,
                                  GTK_BUTTONS_YES_NO,
                                  "%s",messaggio);	
	gtk_message_dialog_set_markup((GtkMessageDialog*)dialog,messaggio);
	response=gtk_dialog_run (GTK_DIALOG (dialog));
    gtk_widget_destroy (dialog);
	return response;
}
/////////////////////////////////////////////
gboolean
check_dir(gchar * dirname)
{
	GString * dir;
	
	dir=g_string_new("");
	g_string_assign(dir,dirname);
	g_string_append(dir, " ");
	
	if (g_file_test(dirname, G_FILE_TEST_IS_SYMLINK)) {
		g_string_append(dir,_("is a symbolic link!"));
		message (dir->str,baobab.window);
		g_string_free(dir,TRUE);
		return FALSE;
		}	    
		
	if (!g_file_test(dirname, G_FILE_TEST_IS_DIR)) {
		g_string_append(dir,_("is not a valid directory!"));
		message (dir->str,baobab.window);
		g_string_free(dir,TRUE);
		return FALSE;
		}	    
/*
    if (strcmp(dirname, "/")==0) {
		message(_("To scan the whole filesystem, please use the proper menu/toolbar entries!"),baobab.window);
		g_string_free(dir,TRUE);	
	    return FALSE;
		}	    
*/		
	g_string_free(dir,TRUE);
	return TRUE;
	
}
//////////////////////////////////////////
gboolean
view_perc (GtkTreeModel *mdl,
           GtkTreePath *path,
           GtkTreeIter *iter,
           gpointer data)
{
	gfloat perc;
	gchar textperc[10];
	
	gtk_tree_model_get(mdl,iter,COL_H_PERC,&perc,-1);
	g_sprintf(textperc,"%.1f %%",perc);
	
	gtk_tree_store_set((GtkTreeStore*)mdl,iter,COL_DIR_SIZE,textperc,-1);
	return FALSE;
}

gboolean
view_size (GtkTreeModel *mdl,
           GtkTreePath *path,
           GtkTreeIter *iter,
           gpointer data)
{
	guint64 size;
	gint col_size;
	gchar *sizecstr;
	
	if (baobab.show_allocated) col_size = COL_H_ALLOCSIZE;
	else col_size = COL_H_SIZE;
	
	gtk_tree_model_get(mdl,iter,col_size,&size,-1);
	sizecstr = gnome_vfs_format_file_size_for_display(size);
	gtk_tree_store_set((GtkTreeStore*)mdl,iter,COL_DIR_SIZE,sizecstr,-1);

	g_free(sizecstr);
	return FALSE;
	
}

///////////////////////

gboolean
install_naut (void)
{
	gchar * nautpath, *fullpath;
	GString * myfilename;
	gboolean script_exists=FALSE;
	gchar *contents;
	gchar* origpath;
	
	nautpath= g_build_path("/",g_get_home_dir(), ".gnome2","nautilus-scripts",NULL);
	if (! g_file_test(nautpath,G_FILE_TEST_EXISTS)) { g_free(nautpath);return FALSE;}
	myfilename = g_string_new(_("Open in Baobab..."));
	
	fullpath = g_build_path("/",nautpath,myfilename->str,NULL);
	script_exists= g_file_test(fullpath,G_FILE_TEST_EXISTS);
	origpath= g_strconcat(SCRIPTS_DIR,"/naut-script.sh",NULL);
	if (!g_file_get_contents(origpath,&contents,NULL,NULL)) {
					g_free(nautpath);
					g_free(fullpath);
					g_string_free(myfilename,TRUE);
					return FALSE;
					}	
					
	FILE * tmp =fopen(fullpath,"w");
	fputs(contents,tmp);
	fclose(tmp);
	chmod(fullpath, S_IXUSR | S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
	
	g_free(contents);
	g_free(origpath);
	g_free(nautpath);
	g_free(fullpath);
	g_string_free(myfilename,TRUE);
	return !script_exists;				
}


///////////////////////////////////

void
popupmenu_list(GtkTreePath *path, GdkEventButton *event)
{
	GtkWidget * pmenu, *open, *trash,*sep,*allfiles;
	GtkTreeIter  iter;
	gchar* dir;
	
	pmenu =gtk_menu_new();	
	open= gtk_image_menu_item_new_from_stock("gtk-open",NULL);
	trash= gtk_image_menu_item_new_from_stock("gtk-delete",NULL);
	sep=gtk_separator_menu_item_new();
	allfiles = gtk_image_menu_item_new_with_label(_("List all files in folder"));
	GtkWidget * image=gtk_image_new_from_pixbuf(create_pixbuf("searchall.png"));
	gtk_image_menu_item_set_image ((GtkImageMenuItem *)allfiles,image);
	
	
	gtk_tree_model_get_iter ((GtkTreeModel*)baobab.model, &iter,path);	
	gtk_tree_model_get((GtkTreeModel*)baobab.model,&iter,COL_H_FULLPATH,&dir,-1);
	if (strcmp(dir,"")==0) return;
	
	g_signal_connect((gpointer)open,"activate",
					G_CALLBACK (open_file_cb),
					(gpointer)dir);
	
	g_signal_connect((gpointer)trash,"activate",
					G_CALLBACK (trash_dir_cb),
					(gpointer)dir);

	g_signal_connect((gpointer)allfiles,"activate",
					G_CALLBACK (list_all_cb),
					(gpointer)dir);


	if(dir) {
		gtk_container_add((GtkContainer*)pmenu,open);
		gtk_widget_show(open);
		gtk_container_add((GtkContainer*)pmenu,allfiles);
		gtk_widget_show(allfiles);
		gtk_container_add((GtkContainer*)pmenu,sep);
		gtk_widget_show(sep);
		gtk_container_add((GtkContainer*)pmenu,trash);
		gtk_widget_show(trash);
	
		gtk_menu_popup((GtkMenu*)pmenu,NULL,NULL,NULL,NULL,event->button,event->time);
	
	}
	
}


void
popupmenu_list_search(GtkTreePath *path, GdkEventButton *event)
{
	GtkWidget * pmenu, *trash, *open,*sep;
	GtkTreeIter  iter;
	gchar* filename;
	
	
	pmenu =gtk_menu_new();	
	open= gtk_image_menu_item_new_from_stock("gtk-open",NULL);
	trash= gtk_image_menu_item_new_from_stock("gtk-delete",NULL);
	sep=gtk_separator_menu_item_new();
	

	// get the data from the model
	gtk_tree_model_get_iter ((GtkTreeModel*)baobab.model_search, &iter,path);
	gtk_tree_model_get((GtkTreeModel*)baobab.model_search,&iter,
					COL_FULLPATH,&filename,
					-1);
	
	g_signal_connect((gpointer)open,"activate",
					G_CALLBACK (open_file_cb),
					(gpointer)filename);

	g_signal_connect((gpointer)trash,"activate",
					G_CALLBACK (trash_file_cb),
					(gpointer)filename);


	if (filename) {
		gtk_container_add((GtkContainer*)pmenu,open);
		gtk_widget_show(open);
		gtk_container_add((GtkContainer*)pmenu,sep);
		gtk_widget_show(sep);
		gtk_container_add((GtkContainer*)pmenu,trash);
		gtk_widget_show(trash);
	
		gtk_menu_popup((GtkMenu*)pmenu,NULL,NULL,NULL,NULL,event->button,event->time);
	}
}




//////////////// search dialog /////////////////////
void
dialog_search(void)
{
	GString * search;
	GtkWidget* dlg ;
	
	dlg=create_dlg_search();
	gtk_window_set_transient_for(GTK_WINDOW(dlg),GTK_WINDOW(baobab.window));
	set_search_opt(dlg);
			
	while (gtk_dialog_run (GTK_DIALOG (dlg)) != GTK_RESPONSE_CANCEL)
	{			
		save_search_opt(dlg);
		if (strcmp(bbSearchOpt.filename->str,"")==0) {
			message(_("Please provide a file name to search for!"),dlg);
		}
		else {	
			search = g_string_new(bbSearchOpt.filename->str);
   			gtk_widget_destroy (dlg);
			if (!bbSearchOpt.exact) {
				g_string_prepend(search,"*");
				g_string_append(search,"*");	
				}
			if (bbSearchOpt.search_whole){
				start_search(search->str,NULL);
				}
			else {
				start_search(search->str,bbSearchOpt.dir->str);
				}
			g_string_free(search,TRUE);
			return;	//exits from while loop
		}
    }
	
	gtk_widget_destroy (dlg);
	
}

void
save_search_opt(GtkWidget* dlg)
{
	GtkEntry * entry_searchname;
	GtkWidget* rb_exact;
	GtkEntry * entry_sel_dir;
	GtkWidget * rb_allfs;

	entry_searchname = (GtkEntry*)lookup_widget(dlg,"entry1");
	g_string_assign(bbSearchOpt.filename,gtk_entry_get_text(GTK_ENTRY(entry_searchname)));
	rb_exact = lookup_widget(dlg,"radio_exact");
	bbSearchOpt.exact = gtk_toggle_button_get_active((GtkToggleButton*)rb_exact);
	entry_sel_dir = (GtkEntry*)lookup_widget(dlg,"entry2");
	g_string_assign(bbSearchOpt.dir,gtk_entry_get_text(GTK_ENTRY(entry_sel_dir)));
	rb_allfs = lookup_widget(dlg,"radio_allfs");
	bbSearchOpt.search_whole = gtk_toggle_button_get_active((GtkToggleButton*)rb_allfs);
	bbSearchOpt.mod_date = radio_group_get_active(
						(GtkRadioButton*)lookup_widget(dlg,"radio_mod_unk"));
	bbSearchOpt.size_limit = radio_group_get_active(
						(GtkRadioButton*)lookup_widget(dlg,"radio_size_unk"));
	
}


void
set_search_opt(GtkWidget* dlg)
{
	GtkEntry * entry_searchname;
	GtkWidget* rb_exact;
	GtkEntry * entry_sel_dir;
	GtkWidget * rb_allfs;
	GtkWidget* expander;
	
	entry_searchname = (GtkEntry*)lookup_widget(dlg,"entry1");
	gtk_entry_set_text(entry_searchname,bbSearchOpt.filename->str);
	rb_exact = lookup_widget(dlg,"radio_exact");
	gtk_toggle_button_set_active((GtkToggleButton*)rb_exact,bbSearchOpt.exact);
	entry_sel_dir = (GtkEntry*)lookup_widget(dlg,"entry2");
	gtk_entry_set_text(entry_sel_dir,bbSearchOpt.dir->str);
	rb_allfs = lookup_widget(dlg,"radio_allfs");
	gtk_toggle_button_set_active((GtkToggleButton*)rb_allfs,bbSearchOpt.search_whole);
	
	radio_group_set_active((GtkRadioButton*)lookup_widget(dlg,"radio_mod_unk"),
							bbSearchOpt.mod_date);

	radio_group_set_active((GtkRadioButton*)lookup_widget(dlg,"radio_size_unk"),
							bbSearchOpt.size_limit);
	expander = lookup_widget(dlg,"expander1");
	gtk_expander_set_expanded((GtkExpander*)expander, 
							  (bbSearchOpt.mod_date != NONE || 
							   bbSearchOpt.size_limit != NONE));
}

void
switch_view(gint view)
{
	GtkWidget * nb;
	nb = lookup_widget(baobab.window,"notebook1");
	gtk_notebook_set_current_page(GTK_NOTEBOOK(nb), view);
	
}

gint
get_NB_page(void) {
	GtkWidget * nb;
	nb = lookup_widget(baobab.window,"notebook1");
	return (gtk_notebook_get_current_page(GTK_NOTEBOOK(nb))); 
}

int
radio_group_get_active(GtkRadioButton * rb)
{
	GSList *list, *l;
	int i;
	
	list = gtk_radio_button_get_group (rb);
	i = 0;
	for (l = list; l; l = l->next) {
	if (gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON (l->data)))
	    break;
		i++;
	 }
	i = g_slist_length (list) - i;
	
	 return i;
}


void
radio_group_set_active(GtkRadioButton * rb,int btn)
{
	GSList *list, *l;
	int i;
	
	list = gtk_radio_button_get_group (rb);
	btn = g_slist_length (list) - btn;
	i=0;
	for (l = list; l; l = l->next) {
		if (i==btn) {
	    	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(l->data),TRUE);
			break;
			}
		i++;
	 	}
}


void set_label_scan (struct _fs *fs)
{
	gchar *markup, *size;
	if (baobab.label_scan) {
			g_free(baobab.label_scan);
	}
	
	size = gnome_vfs_format_file_size_for_display(fs->total);
	GString *total = g_string_new(size);
	g_free(size);
	size = gnome_vfs_format_file_size_for_display(fs->used);
	GString *used = g_string_new(size);
	g_free(size);

	size = gnome_vfs_format_file_size_for_display(fs->avail);
	GString * avail = g_string_new(size);
	g_free(size);
 	

		markup = g_markup_printf_escaped ("<small>%s <b>%s</b> (%s %s %s %s )</small>", 
								_("Total filesystem capacity:"),
								total->str,
								_("used:"),
								used->str,
								_("available:"),
								avail->str);
	baobab.label_scan = strdup(markup);
	
	g_string_free(total,TRUE);
	g_string_free(used,TRUE);
	g_string_free(avail,TRUE);
	g_free (markup);
	
}

void
show_label(gint view)
{
	GtkWidget* label = lookup_widget (GTK_WIDGET(baobab.window), "label1");
	gtk_label_get_use_markup(GTK_LABEL(label));
	
	if (view==VIEW_TREE) {
		gtk_label_set_markup (GTK_LABEL (label), baobab.label_scan);
	}
	if (view == VIEW_SEARCH) {
		gtk_label_set_markup (GTK_LABEL (label), baobab.label_search);
	}
		
}

void 
set_label_search(gint numfiles,guint64 totalsize)
{
	gchar *markup, *size;
	if (baobab.label_search) {
			g_free(baobab.label_search);
	}
	
	size = gnome_vfs_format_file_size_for_display(totalsize);
	markup = g_markup_printf_escaped ("<small>%s <b>%d</b> %s %s <b>%s</b></small>", 
								_("Found:"),
								numfiles,
								(numfiles==1 ? _("file") : _("files")),
								_("for total:"),
								size);
	baobab.label_search = strdup(markup);
	g_free(markup);
	g_free(size);
}

void
open_file_with_application(gchar* file)
{
	GnomeVFSMimeApplication * application;
	const char * mime;
	
	mime = gnome_vfs_get_file_mime_type (file, NULL, FALSE);
	application = gnome_vfs_mime_get_default_application (mime);
	if (!application) {
		if ((g_file_test (file, G_FILE_TEST_IS_EXECUTABLE)) &&
	    	(g_ascii_strcasecmp (mime, "application/x-executable") == 0)) { 
			g_spawn_command_line_async (file, NULL);
			}
		else {
		message( _("There is no installed viewer capable "
					"of displaying the document."),baobab.window);
		}
	}
	else {
	GList *uris = NULL;
	char *uri;

		uri = gnome_vfs_get_uri_from_local_path (file);
		uris = g_list_append (uris, uri);
		gnome_vfs_mime_application_launch (application, uris);	
		
		g_list_free (uris);
		g_free (uri);
	}
	
	gnome_vfs_mime_application_free (application);
	
}


gchar *
get_trash_path (const gchar * file)
{
	GnomeVFSURI * trash_uri;
	GnomeVFSURI * uri;
	gchar       * filename;

	filename = gnome_vfs_escape_path_string (file);
	uri = gnome_vfs_uri_new (filename);
	g_free (filename);

	gnome_vfs_find_directory (uri,
				  GNOME_VFS_DIRECTORY_KIND_TRASH,
				  &trash_uri,
				  TRUE,
				  TRUE,
				  0777);
	gnome_vfs_uri_unref (uri);

	if (trash_uri == NULL) {
		return NULL;
	}
	else {
		gchar * trash_path;
		trash_path = gnome_vfs_uri_to_string (trash_uri, GNOME_VFS_URI_HIDE_TOPLEVEL_METHOD);
		gnome_vfs_uri_unref (trash_uri);
		return trash_path;
	}
}


gboolean
trash_file(gchar*  filename)
{
	gchar * trash_path, * basename, *destination;
	GnomeVFSResult result;
	
	
	trash_path = get_trash_path (filename);
	
	if (trash_path == NULL) {
			message(_("Cannot find the Trash on this system!"),baobab.window);
			g_free(filename);
			g_free (trash_path);
			return FALSE;
		}
		
	if ((!g_file_test (filename, G_FILE_TEST_EXISTS)) &&
		    (!g_file_test (filename, G_FILE_TEST_IS_SYMLINK))) {
				message (_("The document does not exist."),baobab.window);
				g_free(filename);
				g_free (trash_path);
				return FALSE;
			}
			
	basename = g_path_get_basename(filename);
	destination = g_build_filename (trash_path, basename, NULL);
				
	result = gnome_vfs_move (filename, destination, TRUE);
	if (result != GNOME_VFS_OK) {
		gchar * mess;

		mess = g_strdup_printf (_("Moving <b>%s</b> to trash failed: %s."),
				                           g_path_get_basename (filename),
				                           gnome_vfs_result_to_string (result));
		message (mess,baobab.window);
		g_free (mess);
		g_free(basename);			
		g_free(filename);
		g_free (trash_path);
		g_free(destination);
		return FALSE;	
		}
	if (strcmp(destination,filename)==0) {
		gchar* mess;
		gint response;
		
		mess = g_strdup_printf (_("Do you want to delete <b>%s</b> permanently?"),
	                           g_path_get_basename (filename));
		response = messageyesno(mess,baobab.window);
		g_free(mess);
		if (response == GTK_RESPONSE_YES) {
			GnomeVFSResult result;
			if (!g_file_test (filename, G_FILE_TEST_IS_DIR)) {
					result=gnome_vfs_unlink (filename);
				}
				else {
					result=gnome_vfs_remove_directory (filename);
				}
				
			if (result != GNOME_VFS_OK) {
			gchar * mess;

			mess = g_strdup_printf (_("Deleting <b>%s</b> failed: %s."),
				                           g_path_get_basename (filename),
				                           gnome_vfs_result_to_string (result));
			message (mess,baobab.window);
			g_free (mess);
			g_free(basename);			
			g_free(filename);
			g_free (trash_path);
			g_free(destination);
			return FALSE;	
				}
			}
		else {
			g_free(basename);			
			g_free(filename);
			g_free (trash_path);
			g_free(destination);
			return FALSE;
			}
		}
		
	
	
	g_free(basename);			
	g_free(filename);
	g_free (trash_path);
	g_free(destination);
	return TRUE;
}

void
contents_changed(void)
{
	g_fs=getFileSystem();
	set_label_scan(&g_fs);
	show_label(VIEW_TREE);

	if (messageyesno(_("The content of your home directory has changed.\n"
						"Do you want to rescan the last tree to update the folder branch details?"),
							baobab.window) == GTK_RESPONSE_YES) {
			
				start_proc_on_dir(baobab.last_scan_command->str);
			
		}
	

}
