/***************************************************************************
 *            tv.c
 *
 *  Tue Jul  5 12:35:27 2005
 *  Copyright  2005  Fabio Marzocca
 *  Email
 ****************************************************************************/

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "tv.h"
#include "baobab.h"
#include "interface.h"
#include "support.h"
#include "callbacks.h"

static GtkTreeStore * create_model (void);
static GtkListStore * create_search_model(void);

GtkWidget*
create_treeview (void)
{
	GtkCellRenderer     *cell;
	GtkTreeViewColumn	*col;
	GtkWidget* tvw = lookup_widget (GTK_WIDGET(baobab.window), "treeview1");
	
	
	g_signal_connect((gpointer)tvw,"row-expanded",
					G_CALLBACK (on_tv_row_expanded),
					NULL);
	g_signal_connect((gpointer)tvw,"cursor-changed",
					G_CALLBACK (on_tv_cur_changed),
					NULL);
				
	g_signal_connect((gpointer)tvw,"button-press-event",
					G_CALLBACK (on_tv_button_press),
					NULL);
	//dir name column
	cell = gtk_cell_renderer_text_new ();
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"markup",COL_DIR_NAME,
					"text",COL_DIR_NAME,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);
	
	//percentage bar column
	cell = gtk_cell_renderer_pixbuf_new ();
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"pixbuf",COL_BAR,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);

	//directory size column
	cell = gtk_cell_renderer_text_new ();
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"markup",COL_DIR_SIZE,
					"text",COL_DIR_SIZE,NULL);
	g_object_set(G_OBJECT (cell),"xalign",(gfloat)1.0,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);

	//percentage column
	cell = gtk_cell_renderer_text_new ();
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"markup",COL_PERC,
					"text",COL_PERC,NULL);
	g_object_set(G_OBJECT (cell),"xalign",(gfloat)1.0,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);

	//objects column
	cell = gtk_cell_renderer_text_new ();
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"markup",COL_ELEMENTS,
					"text",COL_ELEMENTS,NULL);
	g_object_set(G_OBJECT (cell),"xalign",(gfloat)1.0,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);
	
	//hardlink column
	cell = gtk_cell_renderer_text_new ();
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"markup",COL_HARDLINK,
					"text",COL_HARDLINK,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);
	
	
	gtk_tree_view_collapse_all(GTK_TREE_VIEW(tvw));
	gtk_tree_view_set_headers_visible(GTK_TREE_VIEW(tvw),FALSE);
	GtkWidget* scrolled = lookup_widget (GTK_WIDGET(baobab.window), "scrolledwindow1");
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled),
									GTK_POLICY_NEVER,GTK_POLICY_AUTOMATIC);
	
	baobab.model = create_model();
	
	gtk_tree_view_set_model(GTK_TREE_VIEW (tvw),GTK_TREE_MODEL (baobab.model));
	g_object_unref (baobab.model);
	return tvw;
}

GtkTreeStore *
create_model (void)
{
	GtkTreeStore * mdl = gtk_tree_store_new(NUM_TREE_COLUMNS, 
					G_TYPE_STRING, 		//COL_DIR_NAME
					G_TYPE_STRING,		//COL_H_FULLPATH
					GDK_TYPE_PIXBUF,	//COL_BAR
					G_TYPE_FLOAT,		//COL_H_PERC
					G_TYPE_STRING,		//COL_DIR_SIZE
					G_TYPE_UINT64,		//COL_H_SIZE
					G_TYPE_STRING,		//COL_PERC
					G_TYPE_UINT64,		//COL_H_ALLOCSIZE
					G_TYPE_STRING,		//COL_ELEMENTS
					G_TYPE_INT,			//COL_H_ELEMENTS
					G_TYPE_STRING,		//COL_HARDLINK
					G_TYPE_UINT64		//COL_H_HARDLINK
					);
	
	return mdl;
}

GtkWidget*
create_tree_search(void)
{
	GtkCellRenderer     *cell;
	GtkTreeViewColumn	*col;
	GtkWidget* tvw = lookup_widget (GTK_WIDGET(baobab.window), "tree_search");

	g_signal_connect((gpointer)tvw,"cursor-changed",
					G_CALLBACK (on_tv_cur_changed),
					NULL);
	g_signal_connect((gpointer)tvw,"button-press-event",
					G_CALLBACK (on_tv_button_press),
					NULL);

	//icons column
	cell= gtk_cell_renderer_pixbuf_new();
	g_object_set(cell,"stock-size",GTK_ICON_SIZE_LARGE_TOOLBAR,NULL);
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"pixbuf",COL0_ICON,NULL);	
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);
	
	//First text column
	cell = gtk_cell_renderer_text_new ();
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"markup",COL1_STRING,
					"text",COL1_STRING,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);
	
	//second text column
	cell = gtk_cell_renderer_text_new ();
	col=gtk_tree_view_column_new_with_attributes(NULL,cell,"markup",COL2_STRING,
					"text",COL2_STRING,NULL);
	gtk_tree_view_append_column(GTK_TREE_VIEW(tvw),col);
	
	
	baobab.model_search= create_search_model();
	gtk_tree_view_set_model(GTK_TREE_VIEW (tvw),GTK_TREE_MODEL (baobab.model_search));
	g_object_unref (baobab.model_search);
	
	
	return tvw;
}



GtkListStore *
create_search_model (void)
{
	GtkListStore * mdl = gtk_list_store_new(NUM_COLUMNS, 
					GDK_TYPE_PIXBUF,	//icon
					G_TYPE_STRING,		
					G_TYPE_STRING,
					G_TYPE_STRING,	//fullpath
					G_TYPE_LONG,	//last access
					G_TYPE_DOUBLE,	//size
					G_TYPE_STRING,	//filetype
					G_TYPE_UINT		//owner id (gushort)
					);		
	
	GtkTreeIter iter;
	gtk_list_store_append (mdl, &iter);
	gtk_list_store_set(mdl, &iter,
					COL1_STRING," ",-1);	
	gtk_list_store_append (mdl, &iter);
	gtk_list_store_set(mdl, &iter,
					COL1_STRING,_("<i>Use Menu->Actions->Search for a file, or the search toolbar button.</i>"),-1);
	
	
	return mdl;
}
