/***************************************************************************
 *            bbthread.c
 *
 *  Thu Jul  7 12:09:24 2005
 *  Copyright  2005  Fabio Marzocca
 *  Email
 ****************************************************************************/
#include <string.h>
#include <time.h>
#include <pwd.h>
#include <sys/stat.h>
#include <gtk/gtk.h>
#include <glib/gstdio.h>
#include <fnmatch.h>

#include "baobab.h"
#include "support.h"
#include "bbthread.h"

static GArray * hardLinkArray;
struct allsizes {
	guint64 size;
	guint64 alloc_size;
};

static struct allsizes loopdir(gchar *,guint);
static void create_hardlink_array(void);
static gboolean inode_exists (guint);
static void free_hardlink_array(void);
static void add_hardlink_array(guint inode);
static void loopsearch(gchar*,gchar*);


void
loopsearch(gchar *dir, gchar* search)
{
	GDir *dir_iter;
	GError * error=NULL;
	gchar *file;
	GString *fullfilename;
	guint ret;
	struct stat statarray;	
	struct BaobabSearchRet bbret;

	if (baobab.bbExcludedDirs && 
		(g_slist_find_custom(baobab.bbExcludedDirs,dir,list_find) != NULL)) 
		return ;
	
	dir_iter=g_dir_open(dir,0,&error);
	if (strcmp(dir,"/")==0) { dir = "";}
    while (gtk_events_pending()) { gtk_main_iteration(); }	
	if (dir_iter) {
		fullfilename = g_string_new(dir);
		while ((file=(gchar *)g_dir_read_name(dir_iter))) {
			if (baobab.STOP_SCANNING) {g_string_free(fullfilename,TRUE);
								g_dir_close(dir_iter); return ;}
			
			g_string_printf(fullfilename,"%s/%s",dir,file);
			//stat the file
			ret = g_lstat(fullfilename->str,&statarray);	
			if(ret== -1) {continue;}
			if (fnmatch(search,file,FNM_PATHNAME|FNM_PERIOD)==0) {
				bbret.fullpath = fullfilename->str;
				bbret.size = statarray.st_size;
				bbret.lastacc = statarray.st_mtime;
				bbret.owner=statarray.st_uid;
				bbret.alloc_size = statarray.st_blocks*512;
				fill_search_model(&bbret);
				}
			//is a directory?
			if (S_ISDIR(statarray.st_mode) && !bbSearchOpt.dont_recurse_dir) {
				if (strcmp(fullfilename->str,"/proc") !=0) {
					loopsearch(fullfilename->str,search);	
				}
			}			
		}
		g_string_free(fullfilename,TRUE);
		g_dir_close(dir_iter);
	
	}
	return ;
}


struct allsizes 
loopdir(gchar *dir, guint count)
{
	GDir *dir_iter;
	GError * error=NULL;
	gchar *file, *fullfilename;
	guint64 tempHLsize;
	guint ret;
	gint elements;
	struct stat statarray;	
	struct chan_data data;
	struct allsizes retloop;
	struct allsizes temp;
		
	count++;	
	elements=0;
	tempHLsize=0;
	fullfilename=NULL;
	retloop.size=0;
	retloop.alloc_size=0;
	
	if (baobab.bbExcludedDirs && 
		(g_slist_find_custom(baobab.bbExcludedDirs,dir,list_find) != NULL))
		return retloop;
	
	if (strcmp(dir,"/proc") ==0) return retloop;
		
	//prefill the model
	data.size=1;
	data.alloc_size=1;
	data.depth=count-1;
	data.elements=-1;
	data.dir=dir;
	data.tempHLsize = tempHLsize;
	fill_model((gchar*)&data);

	//get the directory-entry sizes
	ret = g_lstat(dir,&statarray);
	retloop.size=statarray.st_size;
	retloop.alloc_size = statarray.st_blocks*512;
	
	dir_iter=g_dir_open(dir,0,&error);
    while (gtk_events_pending()) { gtk_main_iteration(); }		
	if (dir_iter) {
		while ((file=(gchar *)g_dir_read_name(dir_iter))) {
			if (baobab.STOP_SCANNING) {g_dir_close(dir_iter); 
									   return retloop;}
			fullfilename= g_build_path("/",dir,file,NULL);
			//stat the file
			ret = g_lstat(fullfilename,&statarray);	
			if(ret== -1) {g_free(fullfilename); continue;}
			//is a symlink?
			if (S_ISLNK(statarray.st_mode)) {g_free(fullfilename); continue;}
			//is a directory?
			if (S_ISDIR(statarray.st_mode)) {
				if (strcmp(fullfilename,"/proc") !=0) {
					temp= loopdir(fullfilename,count);
					retloop.size += temp.size;
					retloop.alloc_size += temp.alloc_size;
					elements++;
				}
			}
			else if (S_ISREG(statarray.st_mode)) {
				//check for hard links
				if (statarray.st_nlink > 1) {
					if (inode_exists ((guint)statarray.st_ino))	{
						tempHLsize += (statarray.st_blocks*512); 
						g_free(fullfilename);
						continue;
					}
					else {
						add_hardlink_array((guint)statarray.st_ino);		
					}
				}
				retloop.alloc_size += (statarray.st_blocks*512);
				retloop.size += statarray.st_size;
				elements++;		
			}
		  g_free(fullfilename);	
		}
		g_dir_close(dir_iter);
		
	}
	data.dir = dir;
	data.size = retloop.size;
	data.alloc_size = retloop.alloc_size;
	data.depth= count-1;
	data.elements= elements;
	data.tempHLsize = tempHLsize;
	fill_model((gchar*)&data);
	
	return retloop;
}

////////////////////////entry-point//////////////////////////////////////

void 
getDir(gchar *dir)
{
	if (g_file_test (dir, G_FILE_TEST_IS_SYMLINK)) { return;}
	if (baobab.bbExcludedDirs && 
		(g_slist_find_custom(baobab.bbExcludedDirs,dir,list_find) != NULL))
		return;
	
	create_hardlink_array();
	loopdir(dir,0);

	free_hardlink_array();
}

void
searchDir(gchar * dir, gchar* search)
{
	loopsearch(dir,search);
}

/////////////////// hardLink Array //////////////////////////////////
/* Create the hard link array
*/
void
create_hardlink_array(void) 
{
	
	hardLinkArray = g_array_new (TRUE, TRUE, sizeof (guint));
	return;	
}

/* traverse the hard link array
*/
gboolean
inode_exists (guint inode)
{
	gint i;
	i=0;
	guint a_inode;
	
	while ( (a_inode=g_array_index (hardLinkArray, guint, i)) != 0)
	{
		if (a_inode == inode) {
			return TRUE;
		}
		i++;
	}
	return FALSE;
}


void
add_hardlink_array(guint inode)
{
	
	g_array_append_val(hardLinkArray,inode);
}


/* free the hard link array
*/
void 
free_hardlink_array(void) 
{
	g_array_free (hardLinkArray, TRUE);
}
