<?php

/*****

PamUserStore

A very simple user storage backend which authenticates using
php4-auth-pam. 

Configure like so:
   userbackend = pam

Note that if pam is set to use the shadow password file, then the process
running bamboo must be able to read the file. The error generated when you
don't have permissions is simply "Authentication failure."

*****/

$base = dirname(dirname(__FILE__));
require_once("$base/UserStore.php");

class PamUserStore extends UserStore {
	function authenticate($user,$pass,&$error) {
		if (!function_exists("pam_auth")) {
			$error = "PAM authentication module is not loaded by PHP.";
			return false;
		}
		else {
			return pam_auth($user, $pass, &$error);
		}
	}
} 

return;
?>
