#fedora and mdk are exclusive
%define fedora 1
%define mdk    0
%define gmimever 2.1.14
%define rel 1
%if %fedora
%define config_opts --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} --libdir=%{_libdir} --bindir=%{_bindir} --includedir=%{_includedir} --datadir=%{_datadir} --enable-threads --disable-more-warnings --with-ssl --with-gss
%define rel 1.FC3
%endif
%if %mdk
%define config_opts --prefix=%{_prefix} --sysconfdir=%{_sysconfdir} --mandir=%{_mandir} --libdir=%{_libdir} --bindir=%{_bindir} --includedir=%{_includedir} --datadir=%{_datadir} --enable-threads --disable-more-warnings
%define rel mdk
%endif

Name:           balsa
Version:        2.3.3
Release:        %{rel}
Summary:        Balsa Mail Client

Group:          Applications/Internet
License:        GPL
URL:            http://balsa.gnome.org/
Source0:        http://balsa.gnome.org/%{name}-%{version}.tar.bz2
Source1:        http://balsa.gnome.org/gmime-%{gmimever}.tar.bz2
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

Requires: libesmtp >= 1.0.3
Requires: aspell
Requires: openssl
BuildRequires: libesmtp-devel >= 1.0.3
BuildRequires: aspell-devel
BuildRequires: openssl-devel

%if %fedora
Requires: gtk2 >= 2.0.0
Requires: libgnome >= 2.0.0
Requires: libgnomeui >= 2.0.0
Requires: gnome-vfs2 >= 2.0.0
Requires:  libgnomeprint22 >= 2.2.0
Requires:  libgnomeprintui22 >= 2.2.0
BuildRequires:  gtk2-devel >= 2.0.0
BuildRequires:  libgnome-devel >= 2.0.0
BuildRequires:  libgnomeui-devel >= 2.0.0
BuildRequires:  gnome-vfs2-devel >= 2.0.0
BuildRequires:  libgnomeprint22-devel >= 2.2.0
BuildRequires:  libgnomeprintui22-devel >= 2.2.0
%endif
%if %mdk
Requires: gtk+2.0
Requires: libgnome2_0 
Requires: libgnomeui2_0
Requires: libgnome-vfs2_0
BuildRequires:  libgtk+2.0_0-devel
BuildRequires:  libgnome2_0-devel 
BuildRequires:  libgnomeui2_0-devel
BuildRequires:  libgnome-vfs2_0-devel
BuildRequires:  libpspell4-devel
BuildRequires:  libltdl3-devel
BuildRequires:  libpcre0-devel
%endif

%description
Balsa is an e-mail reader.  This client is part of the GNOME
desktop environment.  It supports local mailboxes, POP3 and
IMAP.

%prep
%setup -q -D -a 1

%build

dir=`pwd`; cd gmime-%{gmimever} && ./configure --prefix=`pwd` --disable-shared && make install; cd $dir
export PKG_CONFIG_PATH="gmime-%{gmimever}:$PKG_CONFIG_PATH"

%configure %{config_opts}

make %{?_smp_mflags}


%install
rm -rf $RPM_BUILD_ROOT
make install DESTDIR="$RPM_BUILD_ROOT"
rm "$RPM_BUILD_ROOT%{_bindir}"/balsa-ab

%find_lang %{name}

%clean
rm -rf $RPM_BUILD_ROOT

%post
which scrollkeeper-update>/dev/null 2>&1 && scrollkeeper-update

if which gtk-update-icon-cache >/dev/null 2>&1; then
    # cf. images/Makefile - this is probably incomplete.
    gtk-update-icon-cache %{_datadir}/balsa/hicolor
    gtk-update-icon-cache %{_datadir}/icons/hicolor
fi

%postun
which scrollkeeper-update>/dev/null 2>&1 && scrollkeeper-update

# no need to update cache - it will be removed.

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc README COPYING ChangeLog NEWS TODO AUTHORS HACKING docs/mh-mail-HOWTO
%doc docs/vconvert.awk docs/pine2vcard
%{_bindir}/balsa
%{_libdir}/bonobo/servers/GNOME_Balsa.server
%{_datadir}/applications/balsa.desktop
%{_datadir}/balsa/hicolor/16x16/apps/*
%{_datadir}/balsa/hicolor/24x24/apps/*
%{_datadir}/balsa/hicolor/22x22
%{_datadir}/balsa/pixmaps/*
%{_datadir}/gnome/help/balsa/*
/usr/share/icons/hicolor/*
%{_datadir}/idl/Balsa.idl
%{_datadir}/omf/balsa/*
%{_datadir}/pixmaps/gnome-balsa2.png
%{_datadir}/sounds/balsa/*
%{_mandir}/man1/balsa.1*
%config(noreplace) %{_sysconfdir}/sound/events/balsa.soundlist


%changelog
* Fri May 20 2005 Pawel Salek <pawsa@theochem.kth.se> - 2.3.2-1
- adapt to Fedora Extras template.


* Sat Jul 26 2003 Misu Moldovan <dumol@go.ro>
- further split the Red Hat and Mandrake sections
- fix Mandrake 9.x dependencies

* Mon Sep 16 2002 Pawel Salek <pawsa@theochem.kth.se>
- adapt to GNOME2 requirements.

* Sun Jun 24 2001 Spider <spider@darkmere.wanfear.com>
- remove all defined paths to user-specified. 
- update configures, locales, update esmtp as a requires/buildrequires 

