/***************************************************************************
 *   Copyright (C) 2006 by Bjorn Hansen                                    *
 *   holomorph@users.sourceforge.net                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "../../include/menu/menu.h"
#include "../../include/menu/mainmenu.h"
#include "../../include/menu/options.h"

using namespace Balder;

MainMenu::MainMenu(gcn::Container* top, Menu* menusystem):SubMenu(top),system(menusystem)
{
  page->setDimension(gcn::Rectangle(0, 0, 500, 400));
  page->setPosition(150,200);

  startButton = new gcn::Button("Start New Game");
  startButton->setEventId("startgame");
  startButton->addActionListener(this);
  startButton->setWidth(500);

  optionsButton = new gcn::Button("Options");
  optionsButton->setEventId("optionsMenu");
  optionsButton->addActionListener(this);
  optionsButton->setWidth(500);

  quitButton = new gcn::Button("Quit");
  quitButton->setWidth(500);
  quitButton->setEventId("quitgame");
  quitButton->addActionListener(this);

  // Add them to the page container
  page->add(startButton, 0, 0);
  page->add(optionsButton, 0, 60);
  page->add(quitButton, 0, 180);
  
  // create the submenus
  optionsMenu = new OptionsMenu(top, this);
}

MainMenu::~MainMenu()
{
    
}

void MainMenu::action(const std::string& action)
{
  // Main menu events.********************************************************
  if (action == "optionsMenu")
  {
    hide();
    optionsMenu->show();
  }  
  else  system->action(action);
}
