
#include <dcopclient.h>
#include <qdragobject.h>
#include <kurl.h>
#include <qstrlist.h>
#include <qtimer.h>
#include <kapplication.h>
#include <klocale.h>
#include <kfileitem.h>
#include <kpopupmenu.h>
#include <kicondialog.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kprocess.h>
#include <kurlrequester.h>
#include <kstandarddirs.h>
#include <kwin.h>
#include <qclipboard.h>
#include "listboxlink.h"
#include "linkconfig.h"
#include "dndlistbox.h"
#include "baghiralinkdrag.h"
#include "dndlistbox.moc"

#define ID 0
#define NAME 1
#define LABEL 2
#define USER_LABEL 3
#define MOUNTABLE 4
#define DEVICE_NODE 5
#define MOUNT_POINT 6
#define FS_TYPE 7
#define MOUNTED 8
#define BASE_URL 9
#define MIME_TYPE 10
#define ICON_NAME 11
#define MEDIA_PROPS 12
#define MEDIALIST_PROPS 13

ResizingLinkBox::ResizingLinkBox( QWidget * parent, const char * name, WFlags f ) : KListBox( parent, name, f)
{
}

void ResizingLinkBox::insertItem( const QListBoxItem *lbi, int index )
{
   KListBox::insertItem( lbi, index );
   if (height() <= numRows()*itemHeight())
      emit itemNumberChanged(TRUE);
}

void ResizingLinkBox::insertItem( const QListBoxItem *lbi, const QListBoxItem *after )
{
   KListBox::insertItem( lbi, after );
   if (height() <= numRows()*itemHeight())
      emit itemNumberChanged(TRUE);
}

void ResizingLinkBox::removeItem( int index )
{
   KListBox::removeItem(index);
   emit itemNumberChanged(FALSE);
}

void ResizingLinkBox::mousePressEvent ( QMouseEvent *mpe )
{
   if (mpe->button() == Qt::LeftButton) return;
   KListBox::mousePressEvent( mpe );
}

void ResizingLinkBox::mouseReleaseEvent ( QMouseEvent *mpe )
{
   if (mpe->button() == Qt::LeftButton)
   {
      ListBoxLink *link = (ListBoxLink*)itemAt(mpe->pos());
      if (isSelected(link)) emit highlighted(link);
      KListBox::mousePressEvent( mpe );
      return;
   }
   KListBox::mouseReleaseEvent( mpe );
}

void ResizingLinkBox::contentsWheelEvent ( QWheelEvent * we )
{
   if (we->state() == Qt::ControlButton)
      KListBox::contentsWheelEvent ( we );
   else
      emit scrolled(0, -we->delta());
}

MediaListBox::MediaListBox( QWidget * parent, uint size, const char * name, WFlags f ) : ResizingLinkBox(parent, name, f), DCOPObject("BaghiraSidebarIface")
{
   size_ = size;
   currentFloppy = 0L;
   floppyPopup = new KPopupMenu(this);
   floppyPopup->insertItem(i18n("Format disk..."), this, SLOT(kfloppy()));

#if KDE_IS_VERSION(3,4,90)
   insertItem(new ListBoxDevice("system", size_, i18n("My Computer"), "system:/", "", "", TRUE, FALSE, FALSE));
   insertItem(new ListBoxDevice("network", size_, i18n("Network"), "remote:/", "", "", TRUE, FALSE, FALSE));
#else
   insertItem(new ListBoxDevice("system", size_, i18n("My Computer"), "media:/", "", "", TRUE, FALSE, FALSE));
   insertItem(new ListBoxDevice("network", size_, i18n("Network"), "lan:/localhost", "", "", TRUE, FALSE, FALSE));
#endif
   insertItem(new ListBoxDevice("hdd_mount", size_, i18n("Startvolume"), QDir::rootDirPath(), "", "", TRUE, FALSE, FALSE));
   client = KApplication::dcopClient();
   client->connectDCOPSignal("kded", "mediamanager", "mediumAdded(QString)", "BaghiraSidebarIface", "mediumAdded(QString)", FALSE);
   client->connectDCOPSignal("kded", "mediamanager", "mediumRemoved(QString)", "BaghiraSidebarIface", "mediumRemoved(const QString)", FALSE);
   client->connectDCOPSignal("kded", "mediamanager", "mediumChanged(QString)", "BaghiraSidebarIface", "mediumChanged(QString)", FALSE);
   /* Get the media info - huhhh ;) */
   QByteArray data, replyData;
   QCString replyType;
   QDataStream arg(data, IO_WriteOnly);
   arg << ""; // ask for the full list
   if (!client->call("kded", "mediamanager", "fullList()", data, replyType, replyData))
      qDebug("there was some error using DCOP.");
   else
   {
      QDataStream reply(replyData, IO_ReadOnly);
      if (replyType == "QStringList")
      {
         QStringList result;
         reply >> result;
         for (uint i = 0; i < result.size()/MEDIALIST_PROPS; i++)
         {
            if (result[MEDIALIST_PROPS*i+MIME_TYPE] != "media/hdd_mounted" &&
                  result[MEDIALIST_PROPS*i+MIME_TYPE] != "media/hdd_unmounted" &&
                  result[MEDIALIST_PROPS*i+MIME_TYPE] != "media/nfs_mounted" &&
                  result[MEDIALIST_PROPS*i+MIME_TYPE] != "media/nfs_unmounted" &&
                  result[MEDIALIST_PROPS*i+MIME_TYPE] != "media/smb_mounted" &&
                  result[MEDIALIST_PROPS*i+MIME_TYPE] != "media/smb_unmounted")
            {
               insertItem(createListBoxDevice(result, i));
            }
         }
      }
      else
         qWarning("fullList() returned an unexpected type of reply!");
   }
   setCurrentItem( 0 );
}

void MediaListBox::kfloppy()
{
   if (currentFloppy)
   {
      KProcess proc;
      proc << "kfloppy" << currentFloppy->mountPoint();
      proc.start(KProcess::DontCare);
      proc.detach();
      currentFloppy = 0L;
   }
   return;
}

ListBoxDevice *MediaListBox::createListBoxDevice(QStringList & deviceProperties, uint n)
{
   QString icon;
   icon = deviceProperties[MEDIALIST_PROPS*n+ICON_NAME];
   if (icon.isNull())
   {
      icon = deviceProperties[MEDIALIST_PROPS*n+MIME_TYPE];
      icon = icon.section( '/', -1 );
      icon.truncate( icon.length()-2 );
      if (icon.contains("floppy")) icon.prepend("3");
   }
   QString label;
   label = deviceProperties[MEDIALIST_PROPS*n+USER_LABEL];
   if (label.isNull())
   {
      label = deviceProperties[MEDIALIST_PROPS*n+LABEL];
      label = i18n(label.section( " (", 0, 0 ).utf8());
   }
#if KDE_IS_VERSION(3,4,90)
   return new ListBoxDevice( icon, size_, label, "system:/media/"+deviceProperties[MEDIALIST_PROPS*n+NAME], deviceProperties[MEDIALIST_PROPS*n+NAME], deviceProperties[MEDIALIST_PROPS*n+DEVICE_NODE], deviceProperties[MEDIALIST_PROPS*n+MOUNTED] == "true", icon.contains("dvd") || icon.contains("cdrom") || icon.contains("cdwriter"),icon.contains("floppy"));
#else
   return new ListBoxDevice( icon, size_, label, "media:/"+deviceProperties[MEDIALIST_PROPS*n+NAME], deviceProperties[MEDIALIST_PROPS*n+NAME], deviceProperties[MEDIALIST_PROPS*n+DEVICE_NODE], deviceProperties[MEDIALIST_PROPS*n+MOUNTED] == "true", icon.contains("dvd") || icon.contains("cdrom") || icon.contains("cdwriter"),icon.contains("floppy"));
#endif
}

int MediaListBox::index (const QString & name )
{
   ListBoxDevice *device;
   for (uint i = 0; i < count(); i++)
      {
         device = (ListBoxDevice*)item(i);
         if (device && device->name() == name) return i;
      }
   return -1;
}

void MediaListBox::mediumAdded(const QString &name)
{
   QByteArray data, replyData;
   QCString replyType;
   QDataStream arg(data, IO_WriteOnly);
   arg << name; // ask for this item only
   if (!client->call("kded", "mediamanager", "properties(QString)", data, replyType, replyData))
      qDebug("there was some error using DCOP.");
   else
   {
      QDataStream reply(replyData, IO_ReadOnly);
      if (replyType == "QStringList")
      {
         QStringList result;
         reply >> result;
         insertItem(createListBoxDevice(result));
      }
      else
         qWarning("properties() returned an unexpected type of reply!");
   }
}

void MediaListBox::mediumRemoved(const QString &name)
{
   QByteArray data, replyData;
   QCString replyType;
   QDataStream arg(data, IO_WriteOnly);
   arg << name; // ask for this item only
   if (!client->call("kded", "mediamanager", "properties(QString)", data, replyType, replyData))
      qDebug("there was some error using DCOP.");
   else
   {
      QDataStream reply(replyData, IO_ReadOnly);
      if (replyType == "QStringList")
      {
         QStringList result;
         reply >> result;
         int i = index(name);
         if (i<0)
            return;
         if (i == currentItem()) setCurrentItem(0);
         removeItem(i);
      }
      else
         qWarning("properties() returned an unexpected type of reply!");
   }
}

void MediaListBox::mediumChanged(const QString &name)
{
   QByteArray data, replyData;
   QCString replyType;
   QDataStream arg(data, IO_WriteOnly);
   arg << name; // ask for this item only
   if (!client->call("kded", "mediamanager", "properties(QString)", data, replyType, replyData))
      qDebug("there was some error using DCOP.");
   else
   {
      QDataStream reply(replyData, IO_ReadOnly);
      if (replyType == "QStringList")
      {
         QStringList result;
         reply >> result;
         int i = index(name);
         if (i<0)
            return;
         if (i == currentItem()) // changing current item - take some care of updating stuff
         {
            ListBoxDevice *device = createListBoxDevice(result);
            if (((ListBoxDevice*)item(i))->mounted() && !device->mounted()) // unmounted the device - we certainly do not wanna select it anymore
            {
               setCurrentItem(0);
               removeItem(i);
               insertItem(device, i);
            }
            else // we're selected and wanna keep selection, but prevent i+1 from becoming selected (as this could trigger annoying cd mounts etc.)
            {
            insertItem(device, i+1); // pre insert the device behind the current one - no selection update (iff i was selected)
            removeItem(i); // post remove the old icon
            setSelected( i, TRUE ); // i is now former i+1 - our now item
            }
         }
         else // ordinary change
         {
            removeItem(i);
            insertItem(createListBoxDevice(result), i);
         }
      }
      else
         qWarning("properties() returned an unexpected type of reply!");
   }
}

void MediaListBox::mousePressEvent ( QMouseEvent *mpe )
{
   if (mpe->button() == Qt::RightButton)
   {
      ListBoxDevice *device = (ListBoxDevice*)itemAt(mpe->pos());
      if (device->name().contains("fd"))
      {
         currentFloppy = device;
         floppyPopup->popup(mpe->globalPos());
      }
      return;
   }
   if (mpe->button() == Qt::LeftButton && mpe->x() > width()-22)
   {
      ListBoxDevice *device = (ListBoxDevice*)itemAt(mpe->pos());
      int dy = itemRect(device).y();
      if ((device->removable() || device->ejectable()) && device->mounted() && mpe->y() > dy+11 && mpe->y() < dy+33)
      {
         KProcess proc;
         device->ejectable()?
            proc << "kdeeject" << "-q" << device->mountPoint():
            proc << "umount" << device->mountPoint(); // umount?
         proc.start(KProcess::DontCare);
         proc.detach();
         return;
      }
   }
   ResizingLinkBox::mousePressEvent( mpe );
}

void MediaListBox::resizeEvent ( QResizeEvent * re)
{
   if (width() != re->oldSize().width())
   {
      for (uint i = 0; i < count(); i++)
         if (((ListBoxDevice*)item(i))->ejectable() && ((ListBoxDevice*)item(i))->mounted() && !isSelected(i)) updateItem(i);
   }
   ResizingLinkBox::resizeEvent(re);
}

DnDListBox::DnDListBox( QWidget * parent, uint size, const char * name, WFlags f ):
ResizingLinkBox( parent, name, f), size_(size), _poof(0), _poofIndex(0), _poofAnimPix(0), _poofPix(0)
{
   setAcceptDrops(true);
   dialog = new LinkConfig();
   connect(dialog->buttonOk, SIGNAL(clicked()), this, SLOT(updateLink()));
   connect (this, SIGNAL(rightButtonPressed( QListBoxItem *, const QPoint & )), this, SLOT(configureLink(QListBoxItem *)));
   setCursor(Qt::PointingHandCursor);
}

DnDListBox::~DnDListBox()
{
}

void DnDListBox::poof(ListBoxLink *link)
{
   _poofIndex = 0;
   _poofPix = new QPixmap(locateLocal("data", "baghira/poof.png"), "png");
   _poofAnimPix = new QPixmap(_poofPix->width(), _poofPix->width());
   if (!_poof)
      _poof = new QWidget(0,0, Qt::WType_TopLevel | Qt::WStyle_NoBorder | Qt::WStyle_StaysOnTop | Qt::WX11BypassWM);
   KWin::setShadowSize(_poof->winId(), 0);
   _poof->setFixedSize(_poofPix->width(), _poofPix->width());
   int x = QCursor::pos().x() - _poof->width()/2;
   int y = QCursor::pos().y() - _poof->height()/2;
   QPixmap bgPix = QPixmap::grabWindow( qt_xrootwin(), x, y, _poofPix->width(), _poofPix->width());
   _poof->move(x,y);
   _poof->show();
   _poof->setBackgroundOrigin(QWidget::WidgetOrigin);
   _poof->setPaletteBackgroundPixmap( bgPix );
   runPoof();
   removeItem ( index(link) );
}

void DnDListBox::runPoof()
{
   if (_poofIndex > 4)
   {
      _poof->hide();
      delete _poofPix;
      _poofPix = 0L;
//       delete _poof;
//       _poof = 0L;
      delete _poofAnimPix;
      _poofAnimPix = 0L;
      _poofIndex = 0;
      return;
   }
   _poof->erase();
   bitBlt(_poof, 0 ,0, _poofPix, 0, _poofIndex * _poofPix->width(), _poofPix->width(), _poofPix->width(), Qt::AndROP);
   ++_poofIndex;
   QTimer::singleShot ( 70, this, SLOT(runPoof()) ); // around 15 fps
}

void DnDListBox::dragEnterEvent ( QDragEnterEvent *dee )
{
//    dragging_ = true;
   if (QUriDrag::canDecode(dee) || BaghiraLinkDrag::canDecode(dee))
      dee->accept(true);
   else if (QTextDrag::canDecode(dee))
   {
      QString string;
      QCString subtype;
      KURL url(string);
      dee->accept(url.isValid() || string.contains('@') ||  string.contains("'at'")/*mail*/);
   }
}

void DnDListBox::dropEvent ( QDropEvent *de )
{
   QStrList list;
   QString title;
   QString command;
   QString icon;
   int oldIndex;
   QCString subtype;
   if (BaghiraLinkDrag::decode(de, &title, &command, &icon, &oldIndex)) // internal move
   {
      BaghiraLinkDrag::setAccepted();
      QListBoxItem *after = itemAt(de->pos());
      int newIndex = index(after);
      if (!dragging_ || oldIndex < 0 || oldIndex > count()-2)
         insertItem (new ListBoxLink(icon, size_, title, command), after?newIndex:count());
      else if (oldIndex != newIndex)
      {
         insertItem (new ListBoxLink(*((ListBoxLink*)item(oldIndex))), after?newIndex:count());
         removeItem ( (newIndex < 0 || oldIndex < newIndex) ? oldIndex : oldIndex + 1 );
      }
   }
   else if ( QUriDrag::decode(de, list) )
   {
      char *uri;
      KURL url;
      QListBoxItem *after = itemAt(de->pos());
      for ( uri = list.first(); uri; uri = list.next() )
      {
         url = KURL(uri);
         if (url.protocol() == "http")
            insertItem(new ListBoxLink("html", size_, url.host()+(url.path()=="/"?QString(""):url.path()), uri), after?index(after):count());
         else
         {
            KFileItem item = KFileItem(KFileItem::Unknown, KFileItem::Unknown, url, true);
               insertItem(new ListBoxLink(item.iconName(), size_, url.fileName().isEmpty()?url.prettyURL():url.fileName(), uri), after?index(after):count());
         }
      }
   }
   else if (QTextDrag::decode(de, command, subtype))
   {
      KURL url(command);
      if (url.isValid())
      {
         QListBoxItem *after = itemAt(de->pos());
         if (url.protocol() == "http")
            insertItem(new ListBoxLink("html", size_, url.host()+(url.path()=="/"?QString(""):url.path()), command), after?index(after):count());
         else
         {
            KFileItem item = KFileItem(KFileItem::Unknown, KFileItem::Unknown, url, true);
            insertItem(new ListBoxLink(item.iconName(), size_, url.fileName().isEmpty()?url.prettyURL():url.fileName(), command), after?index(after):count());
         }
      }
      else if (command.contains('@'))
      {
         QListBoxItem *after = itemAt(de->pos());
         command.replace(" ","");
         insertItem(new ListBoxLink("kmail", size_, command, "mailto:"+command), after?index(after):count());
      }
      else if (command.contains("'at'")) //last chance for anti-spam addy
      {
         QListBoxItem *after = itemAt(de->pos());
         command.replace(" ","");
         command.replace("'at'","@");
         insertItem(new ListBoxLink("kmail", size_, command, "mailto:"+command), after?index(after):count());
      }
   }
}

void DnDListBox::mousePressEvent ( QMouseEvent *mpe )
{
   if (mpe->button() == Qt::RightButton)
   {
      emit rightButtonPressed ( itemAt(mpe->pos()), mpe->globalPos() );
      return;
   }
   if (mpe->button() == Qt::MidButton)
   {
      pasteURL(QClipboard::Selection, itemAt(mpe->pos()));
      return;
   }
   ResizingLinkBox::mousePressEvent( mpe );
}

void DnDListBox::mouseReleaseEvent ( QMouseEvent *mre )
{
   if (!dragging_) ResizingLinkBox::mouseReleaseEvent( mre );
}

void DnDListBox::mouseMoveEvent ( QMouseEvent * mme )
{
   if (mme->state() & Qt::LeftButton)
   {
      if (!dragging_)
      {
         ListBoxLink *link = (ListBoxLink*)itemAt(mme->pos());
         if (link)
         {
            dragging_ = true;
            BaghiraLinkDrag *d = new BaghiraLinkDrag( link->text(), link->URL(), link->icon(), index(link), this );
            d->setPixmap(*link->pixmap(),QPoint(22,22));
            d->drag();
            if (mme->state() & Qt::ControlButton || BaghiraLinkDrag::accepted())
               return;
            poof(link);
            // do NOT delete d.
         }
      }
   }
   else // ensure to release from drag
      dragging_ = false;
}

void DnDListBox::pasteURL(int mode, QListBoxItem *after)
{
   QString string = qApp->clipboard()->text( (QClipboard::Mode)mode );
   KURL url(string);
   if (url.isValid())
   {
      if (url.protocol() == "http")
         insertItem(new ListBoxLink("html", size_, url.host()+(url.path()=="/"?QString(""):url.path()), string), after?index(after):count());
      else
      {
         KFileItem item = KFileItem(KFileItem::Unknown, KFileItem::Unknown, url, true);
         insertItem(new ListBoxLink(item.iconName(),size_, url.fileName().isEmpty()?url.prettyURL():url.fileName(), string), after?index(after):count());
      }
   }
   else if (string.contains('@'))
   {
      string.replace(" ","");
      insertItem(new ListBoxLink("kmail", size_, string, "mailto:"+string), after?index(after):count());
   }
   else if (string.contains("'at'")) //last chance for anti-spam addy
   {
      string.replace(" ","");
      string.replace("'at'","@");
      insertItem(new ListBoxLink("kmail", size_, string, "mailto:"+string), after?index(after):count());
   }
}

void DnDListBox::configureLink(QListBoxItem *item)
{
   if (item == 0L)
      return;
   currentItem = (ListBoxLink*)item;
   dialog->title->setText(currentItem->text());
   dialog->url->setURL(currentItem->URL());
   dialog->icon->setIcon(currentItem->icon());
   dialog->show();
}

void DnDListBox::updateLink()
{
   if (currentItem)
   {
      int index_ = index(currentItem);
      bool wasSelected = isSelected(index_);
      insertItem( new ListBoxLink(dialog->icon->icon(), size_, dialog->title->text(),dialog->url->url()), index_ +1);
      removeItem( index_ );
      setSelected(index_, wasSelected);
   }
}
