//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _eriroot_6.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Toru Shiozaki <shiozaki@northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <cassert>
#include <src/integral/rys/erirootlist.h>

using namespace std;
using namespace bagel;

void ERIRootList::eriroot6(const double* ta, double* rr, double* ww, const int n) {

  constexpr double ax[6] = {9.874701406848116e-02,8.983028345696176e-01,2.552589802668170e+00,5.196152530054465e+00,9.124248037531178e+00,
    1.512995978110807e+01};
  constexpr double aw[6] = {5.701352362624799e-01,2.604923102641610e-01,5.160798561588392e-02,3.905390584629060e-03,8.573687043587890e-05,
    2.658551684356308e-07};
  constexpr double x[2304] = {  2.909526553051856e-02, -1.104032796973577e-03,  3.096629159527982e-05, -7.574753266090117e-07,  1.692060034008341e-08,
 -3.507786777298290e-10,  6.745845870712323e-12, -1.189681790460672e-13,  1.853870543666345e-15, -2.318394815721284e-17,  1.312197870295791e-19,  4.262128234759834e-21,
  2.530531519182802e-01, -8.582692559511705e-03,  1.879879753135910e-04, -2.743785573735527e-06,  1.212704714094835e-08,  7.245790508320184e-10, -2.631458430541367e-11,
  4.441339946806361e-13, -4.888983215478155e-16, -2.164798016449122e-16,  7.041509779669604e-18, -1.065484641891653e-19,  6.547912762698439e-01, -1.736611366624101e-02,
  1.829006676373259e-04,  2.175081034043631e-06, -9.762652664700297e-08,  3.788827837441759e-10,  4.419617186362160e-11, -8.773773748807007e-13, -1.238659462930805e-14,
  7.291178724673317e-16, -3.889386968760335e-18, -4.167910861338297e-19,  1.146323178027773e+00, -1.967280561488524e-02, -7.939654398623156e-05,  4.925848687279220e-06,
  5.340299724000268e-08, -2.132673818594678e-09, -3.919982606267849e-11,  1.057787023279281e-12,  2.953337585397368e-14, -5.430175885400219e-16, -2.281434418374407e-17,
  2.527789424431456e-19,  1.609575987670719e+00, -1.287649367822663e-02, -2.381150225648477e-04, -1.587405979457348e-06,  5.535624739109699e-08,  2.006508529400133e-09,
  1.952077473198550e-11, -6.419675394762444e-13, -2.786000413931395e-14, -3.216854238985703e-16,  9.336429122907814e-18,  4.521855395825135e-19,  1.920780369705748e+00,
 -3.159459069793771e-03, -9.048313248204459e-05, -2.161156083794863e-06, -4.396463319172953e-08, -7.292222769850478e-10, -8.010137632905130e-12,  3.132419500386322e-14,
  4.995430515309374e-15,  1.760136138342016e-16,  4.250340420060353e-18,  7.212729913553470e-20,  2.512288711331176e-02, -8.885400755384223e-04,  2.329512083109699e-05,
 -5.350951656402472e-07,  1.128573565566493e-08, -2.228766962185187e-10,  4.128440469336925e-12, -7.175718840385524e-14,  1.138848700327047e-15, -1.622447570354100e-17,
  1.853139720271064e-19, -3.009676783630189e-22,  2.215275147232538e-01, -7.206292889339338e-03,  1.566051243876475e-04, -2.464012990303547e-06,  2.127707219376433e-08,
  2.350047097937313e-10, -1.493506127962989e-11,  3.490258367564361e-13, -4.325374757607854e-15, -2.504682418502940e-17,  2.806263468587223e-18, -7.215578201970968e-20,
  5.883822275503587e-01, -1.582415222985895e-02,  2.000421236856565e-04,  7.224452621353533e-07, -8.156656153725668e-08,  1.122449601702054e-09,  1.764614492147033e-11,
 -9.111850659408406e-13,  7.936643344608202e-15,  3.490665144433469e-16, -1.167931919168157e-17,  4.221382860443445e-20,  1.066751859000989e+00, -2.006052855852224e-02,
 -1.670129492920361e-05,  5.399656540086595e-06,  4.195439316602541e-09, -2.634828355511287e-09, -3.526671821714206e-13,  1.549038148115974e-12, -1.788691378202188e-15,
 -1.026844901178941e-15,  2.270275386658422e-18,  7.352294318927485e-19,  1.554164969715164e+00, -1.483937525305409e-02, -2.504642378896134e-04, -3.632372142422599e-07,
  9.816204635533287e-08,  2.151467611134732e-09, -1.192126038407730e-11, -1.604779146865589e-12, -2.752567409312164e-14,  4.826372147270174e-16,  3.020807234053773e-17,
  3.437611015935764e-19,  1.906512129904033e+00, -4.000191181813521e-03, -1.211509454202444e-04, -2.991000060554897e-06, -6.027748762091644e-08, -8.856911862597315e-10,
 -3.671621885362389e-12,  3.317502326642370e-13,  1.517387428157584e-14,  4.097340393618219e-16,  7.208878752506090e-18,  3.692512148602066e-20,  2.190470884467950e-02,
 -7.251008662936470e-04,  1.782604710039850e-05, -3.854156362909225e-07,  7.675458069919894e-09, -1.442759543418729e-10,  2.551605798677916e-12, -4.327064919256413e-14,
  6.826189772669586e-16, -9.331690995548976e-18,  1.534084791600905e-19, -1.168857655177502e-21,  1.950292608609858e-01, -6.065691140134517e-03,  1.291799762933531e-04,
 -2.102417227018885e-06,  2.310235392755550e-08, -2.199846183757805e-11, -7.112270121228619e-12,  2.126272850225017e-13, -3.824274472603803e-15,  3.942535152865008e-17,
  7.414208826080044e-19, -2.820270659061645e-20,  5.283122650797850e-01, -1.420950889690812e-02,  2.016742353056044e-04, -3.880569786261843e-07, -5.676264945832549e-08,
  1.277066833538690e-09, -3.020320300692953e-12, -5.380145568668970e-13,  1.321534371088349e-14, -1.304266690989485e-17, -5.505007678487202e-18,  1.712233086160041e-19,
  9.866493120246325e-01, -1.993775089844830e-02,  4.679596329138267e-05,  5.058962319740970e-06, -4.524379541307349e-08, -2.161320930475409e-09,  3.713205768143363e-11,
  9.764063538197670e-13, -3.013644575899579e-14, -3.932285634203968e-16,  2.505621962730146e-17,  1.570060570073800e-19,  1.490814213414503e+00, -1.683073737570430e-02,
 -2.440753472547675e-04,  1.519268335048439e-06,  1.342763348019402e-07,  1.251472944925660e-09, -6.481419264401312e-11, -1.960268341644493e-12,  1.279029704656885e-14,
  1.707238624076974e-15,  2.195796581616990e-17, -8.766008142126029e-19,  1.888320698047735e+00, -5.130719224789765e-03, -1.634182233893547e-04, -4.097598516449865e-06,
 -7.777135849531192e-08, -7.918363994925340e-10,  1.503117624925264e-11,  1.108573500355157e-12,  3.492354521437396e-14,  6.597225836450341e-16,  2.598772790775293e-18,
 -3.420869355008200e-19,  1.926291372863820e-02, -5.991042750655961e-04,  1.385243276126430e-05, -2.827362760200583e-07,  5.315771111442806e-09, -9.537896554369198e-11,
  1.603090481534429e-12, -2.574038755951563e-14,  4.413267611269910e-16, -4.602415296424523e-18,  7.351196513438021e-20, -2.433373214425718e-21,  1.726823546536269e-01,
 -5.126968106761673e-03,  1.061292061575574e-04, -1.743779932207192e-06,  2.137234382792473e-08, -1.336172133596751e-10, -2.630427677233802e-12,  1.165351057116642e-13,
 -2.130452934182808e-15,  4.819829517211859e-17, -2.548241657944415e-19, -2.085829915766072e-20,  4.746522281615453e-01, -1.262828763110040e-02,  1.923864812025864e-04,
 -1.100147100926152e-06, -3.292571927044157e-08,  1.069975806930053e-09, -1.246037097491875e-11, -1.520679453335109e-13,  1.033050501240659e-14, -1.139650192397631e-16,
 -5.341475919184762e-19,  4.065953219506583e-20,  9.080102627056965e-01, -1.933579212345404e-02,  1.019109324414780e-04,  4.044906387106518e-06, -7.793730565612051e-08,
 -1.057171047999506e-09,  5.022303379247058e-11, -2.296243569356871e-14, -2.690901529116874e-14,  4.978794996129645e-16,  1.419575676901191e-17, -5.528244274858753e-19,
  1.419754795275698e+00, -1.867262558696194e-02, -2.124487159626529e-04,  3.766346802240676e-06,  1.397991830067642e-07, -8.559567193538607e-10, -1.040843175866570e-10,
 -4.982803430701358e-13,  7.711267215722784e-14,  1.434329337173307e-15, -4.186294260602461e-17, -1.678516866200906e-18,  1.864840497463487e+00, -6.656917196298762e-03,
 -2.204796574063778e-04, -5.435927307312957e-06, -8.674111629441394e-08,  8.933283555543365e-11,  6.518501662064159e-11,  2.581136633111501e-12,  5.445936021047271e-14,
  1.786404501671664e-16, -3.545251280812599e-17, -1.544978769151014e-18,  1.706851346840675e-02, -5.005427654325485e-04,  1.091312841166815e-05, -2.110722842637700e-07,
  3.742208731238406e-09, -6.409592528613890e-11,  1.057946466498121e-12, -1.392060474293312e-14,  3.014823159231557e-16, -3.908564243664071e-18, -3.672204622405621e-20,
 -2.124719284805726e-21,  1.537479395151623e-01, -4.356042986604502e-03,  8.715903410845296e-05, -1.425640956101158e-06,  1.829958949779979e-08, -1.638066247220299e-10,
 -8.536964288200896e-14,  7.238357719200187e-14, -7.953712628443108e-16,  2.035612452204659e-17, -1.091181751497358e-18, -1.415302949932262e-20,  4.271230122184249e-01,
 -1.114944246878516e-02,  1.766749525242490e-04, -1.472836025879675e-06, -1.468499527496795e-08,  7.532930147233749e-10, -1.272725874198030e-11,  1.100202155328816e-13,
  5.947434762973463e-15, -1.335470383832163e-16, -1.032482000034341e-18, -3.871387388929036e-20,  8.325735626832577e-01, -1.834873688211077e-02,  1.424779474722051e-04,
  2.692524537383346e-06, -8.750159541181781e-08,  6.240125096489841e-11,  4.070944291529116e-11, -5.380932507502744e-13, -4.978911988835248e-15,  5.536108734943952e-16,
 -1.043803616866139e-17, -4.286952531338293e-19,  1.342002210112625e+00, -2.015558962062195e-02, -1.548362466780220e-04,  5.731198997933545e-06,  9.816057383181907e-08,
 -3.209655243484884e-09, -7.877623763367773e-11,  2.347778914696468e-12,  8.411360559572147e-14, -1.309301316658270e-15, -7.986443784027683e-17,  3.845223815018209e-19,
  1.834239755516961e+00, -8.704448243850972e-03, -2.936280452735158e-04, -6.696424886486965e-06, -6.246086243955694e-08,  2.710300329107183e-09,  1.599611708254649e-10,
  3.992116049188885e-12,  1.480984878239483e-14, -3.039273713635228e-15, -1.332208273918092e-16, -2.483302771302919e-18,  1.522623010333597e-02, -4.224403743579495e-04,
  8.701359711242987e-06, -1.601874372185514e-07,  2.687658350975296e-09, -4.243634723364394e-11,  7.791912592737191e-13, -6.950904645038210e-15,  1.181182652996824e-16,
 -6.513922815502074e-18, -7.040477036691101e-20,  1.046378656354284e-21,  1.376166652100458e-01, -3.722470469112865e-03,  7.170140111712389e-05, -1.158525038289775e-06,
  1.515396919231524e-08, -1.440581111262340e-10,  1.629933509927251e-12,  4.939756385225576e-14, -9.380120687693530e-16, -2.878172440022126e-17, -1.149839313127299e-18,
  1.545559179896766e-20,  3.852358487487115e-01, -9.809689553087883e-03,  1.580382364020993e-04, -1.602491408181270e-06, -2.333142020197849e-09,  5.015084820603601e-10,
 -7.779140432071947e-12,  2.125699111806267e-13,  6.720047687717144e-17, -1.980281307164097e-16, -1.682748363023102e-18,  3.003253072621766e-20,  7.616298213328984e-01,
 -1.710305885046442e-02,  1.665868996075654e-04,  1.350323227614186e-06, -7.773153126189916e-08,  8.554196025702131e-10,  2.566686622278964e-11, -4.864373252340780e-13,
  4.364058331518581e-15, -7.679979116549570e-17, -1.678347307206908e-17,  1.514271612275444e-19,  1.259368622370933e+00, -2.109789781272181e-02, -7.901695402846088e-05,
  6.712560677729453e-06,  2.169814138839663e-08, -4.071114902325479e-09,  1.360203949953087e-11,  3.751511984053031e-12, -9.044905094405817e-15, -3.383484143971599e-15,
 -8.985458186688110e-18,  2.355053062792128e-18,  1.794198367170488e+00, -1.138622862336942e-02, -3.774143753045956e-04, -7.016285667177780e-06,  3.888894416156281e-08,
  7.801908778006480e-09,  2.535836563285436e-10,  1.523952072945213e-12, -2.081043526753171e-13, -9.407889390579351e-15, -1.318945196635154e-16,  5.028586999286654e-18,
  1.366447107467180e-02, -3.598456599948307e-04,  7.012240283566679e-06, -1.230200796193744e-07,  2.011401606542464e-09, -2.587643061299436e-11,  5.993045538179281e-13,
 -7.288415252215967e-15, -1.423415977726549e-16, -6.875514733511908e-18,  9.453622415342281e-20,  6.777329385886904e-21,  1.237915081670856e-01, -3.200549706253477e-03,
  5.916679383513266e-05, -9.365911737132341e-07,  1.275342512868068e-08, -9.296114646180238e-11,  2.385419801879857e-12, -3.934066564826439e-15, -2.512959554304916e-15,
 -4.709296628138214e-17,  6.221764654168773e-19,  6.814837975214464e-20,  3.484039509644596e-01, -8.622231716451850e-03,  1.388878424565973e-04, -1.567784399332065e-06,
  6.284091755274593e-09,  3.795334410278850e-10, -2.934221703783851e-12,  9.277261317789116e-14, -7.563823375987919e-15, -1.947537851556364e-16,  3.081510850955952e-18,
  1.976799187934498e-19,  6.959577132175228e-01, -1.572519550873970e-02,  1.759894191509436e-04,  2.725340325631670e-07, -5.551092675579601e-08,  1.317075805752265e-09,
  1.278506229600600e-11, -4.979983503421665e-13, -7.436549592937723e-15, -4.584626437236618e-16,  1.319325124024236e-18,  6.481343081805612e-19,  1.174223440739336e+00,
 -2.140783154961095e-02,  1.080362493963763e-06,  6.459789206230398e-06, -4.859094548319893e-08, -2.626958218933833e-09,  9.693379458688820e-11,  1.640023734107091e-12,
 -1.135644086958743e-13, -1.839986599730199e-15,  7.806679493740598e-17,  1.336580046376250e-18,  1.742114864841888e+00, -1.471773793549444e-02, -4.516582562477228e-04,
 -4.818356678283252e-06,  2.539452037192204e-07,  1.331462468545819e-08,  1.489120480385769e-10, -1.081955327822119e-11, -5.390900056293167e-13, -4.770573298045301e-15,
  5.008048728405745e-16,  2.264758429126615e-17,  1.232866119545832e-02, -3.091402463124368e-04,  5.714329385914367e-06, -9.427758179059473e-08,  1.617692178419465e-09,
 -1.464313056338604e-11,  3.032930145752636e-13, -1.440012825355511e-14, -2.370519730308814e-16,  4.113148035266651e-18,  4.597723435219590e-19,  6.840536721593651e-21,
  1.118695325043410e-01, -2.768824802939007e-03,  4.910021633863428e-05, -7.445176157542212e-07,  1.140531279516121e-08, -4.735288373365188e-11,  9.670807462268905e-13,
 -9.996955938299259e-14, -2.918625930157948e-15,  4.924653689096830e-17,  4.236414796949078e-18,  6.805705128414928e-20,  3.160212229987619e-01, -7.584119189168285e-03,
  1.209168718145355e-04, -1.410019589737711e-06,  1.321672748579257e-08,  3.077807527285343e-10, -4.496894444032773e-12, -2.178654811433686e-13, -9.861825217462627e-15,
  1.413591389133950e-16,  1.394417171154390e-17,  2.092879782454760e-19,  6.358749023622174e-01, -1.431721336152877e-02,  1.748395372913190e-04, -3.936416731943504e-07,
 -2.742802511900265e-08,  1.416310268399060e-09, -6.545938780890648e-12, -9.282253723103555e-13, -1.529212229036662e-14,  2.431196893455439e-16,  3.384402722250993e-17,
  6.156490253027038e-19,  1.089077511890720e+00, -2.110546176981987e-02,  7.263238769555089e-05,  5.396095109372151e-06, -7.644191851620505e-08, -1.973405162109826e-10,
  8.688222620830946e-11, -2.356224486257130e-12, -1.124029332145415e-13,  2.140752940981749e-15,  1.136000546797010e-16,  2.118009640982548e-19,  1.675776177306913e+00,
 -1.847236785772723e-02, -4.760499810108810e-04,  1.430918466716241e-06,  5.213467153244489e-07,  1.133057275843951e-08, -3.828976488849500e-10, -2.511475665522095e-11,
 -1.347788620610292e-13,  3.113141236208208e-14,  1.015564745397197e-15, -1.615356235366476e-17,  1.117695857726538e-02, -2.675313440393779e-04,  4.729508288465336e-06,
 -7.049134783309036e-08,  1.361603649852594e-09, -1.278721009285994e-11, -1.567267155409912e-13, -1.581756361479882e-14,  2.597328694015135e-16,  2.196180512672001e-17,
  2.067862338153773e-19, -2.327657748525694e-20,  1.015275419305026e-01, -2.408726841659853e-03,  4.123076004057813e-05, -5.694563267180489e-07,  1.042060047899433e-08,
 -6.538924357051021e-11, -2.621198614580077e-12, -1.296758230110237e-13,  2.101880626433057e-15,  2.158284168056362e-16,  1.924034300581971e-18, -2.212908659527075e-19,
  2.875178834577429e-01, -6.680453046598639e-03,  1.054425838855397e-04, -1.157786173263915e-06,  1.764959470097069e-08,  9.981853779120724e-11, -1.342539190431178e-11,
 -3.363953868407234e-13,  5.856646763245583e-15,  6.873703367900931e-16,  6.482563007762617e-18, -7.087767384260164e-19,  5.813657432809073e-01, -1.294280220092011e-02,
  1.683637474662574e-04, -6.240450286840206e-07, -2.992534113075373e-09,  9.103244477038477e-10, -3.602397212744001e-11, -9.893618770405894e-13,  2.012234900749401e-14,
  1.629670738550654e-15,  1.759264431851166e-17, -1.779673808005507e-18,  1.006198897942341e+00, -2.028588315152459e-02,  1.302075646356236e-04,  4.226217800210432e-06,
 -6.656643773012793e-08,  7.917326486095579e-10, -1.177441477428469e-11, -3.882611335631569e-12,  3.926062965794500e-14,  5.724003374708248e-15,  2.352232653094162e-17,
 -5.447603308446686e-18,  1.594596045702344e+00, -2.205746811568469e-02, -4.036096292517642e-04,  1.085373862480040e-05,  6.017999670735133e-07, -5.533654239071646e-09,
 -9.381794167353287e-10, -6.666174407437213e-12,  1.302986368228425e-12,  3.175466366103968e-14, -1.456956227237231e-15, -7.379912206445007e-17,  1.017764275753706e-02,
 -2.327299165958448e-04,  4.004874396399827e-06, -5.108024976138435e-08,  1.040341621519800e-09, -2.019662626480941e-11, -3.673240341923926e-13,  4.213946282594328e-15,
  8.792340616716086e-16,  2.897251658973524e-18, -1.161881132075461e-18, -2.149140624504489e-20,  9.251288410620989e-02, -2.103507110372022e-03,  3.534059180101033e-05,
 -4.176120953619656e-07,  8.259480456991458e-09, -1.571317631271280e-10, -4.173109079711341e-12,  5.261736372052090e-14,  8.196943492178527e-15,  3.107251539769862e-17,
 -1.120552071565475e-17, -2.072108369744370e-19,  2.624019787302810e-01, -5.887660757178118e-03,  9.324549686240408e-05, -8.794537441722648e-07,  1.586806373245803e-08,
 -2.914312170372752e-10, -1.658304506057534e-11,  2.193243843880944e-13,  2.541442944730911e-14,  1.025957482076291e-16, -3.596778595072440e-17, -6.748745233061140e-19,
  5.322411699071063e-01, -1.162562083800054e-02,  1.610155321457321e-04, -5.806528067299837e-07,  4.933238452118112e-09, -1.595306478627960e-10, -4.604020275367161e-11,
  5.312294569824462e-13,  6.629942102361770e-14,  1.721998447528634e-16, -9.153710963627712e-17, -1.739888029267193e-18,  9.274355767662955e-01, -1.905853132776383e-02,
  1.749150114653798e-04,  3.240464972504333e-06, -6.084199334315703e-08, -4.703438944337742e-10, -7.390391730800497e-11,  2.750290109607056e-13,  1.894481302963002e-13,
  4.929753680435902e-16, -2.796411810303006e-16, -4.142557771616309e-18,  1.500943355795390e+00, -2.461797440869609e-02, -2.231568766786384e-04,  1.840358791481846e-05,
  2.777883296362804e-07, -2.505213443175872e-08, -4.780795606141936e-10,  3.747955454035215e-11,  9.037320293468918e-13, -5.638023601219830e-14, -1.728179090563174e-15,
  8.292659835000377e-17,  9.307274592032370e-03, -2.028931858242320e-04,  3.477146091955835e-06, -3.805003510520063e-08,  5.734040647861749e-10, -2.466273644067652e-11,
  9.220952576124481e-14,  2.456941292067996e-14,  1.314960933113239e-16, -3.871527654189050e-17, -3.147146747420332e-19,  5.561467001496854e-20,  8.463538437635530e-02,
 -1.838850772952931e-03,  3.100343874034924e-05, -3.150281260237670e-07,  4.380203432001544e-09, -2.122303260253304e-10,  4.845213149658542e-13,  2.417094920932663e-13,
  1.101634343216285e-15, -3.698194686533246e-16, -2.998762348449189e-18,  5.378537141545600e-19,  2.402817779414574e-01, -5.180161000498097e-03,  8.396256593914709e-05,
 -6.901367972109889e-07,  7.007802817839146e-09, -5.310127344608086e-10, -6.086484661845410e-13,  7.990480988927482e-13,  2.741374147419254e-15, -1.181139573917946e-15,
 -9.175046974013015e-18,  1.751229185240894e-18,  4.882719396030983e-01, -1.036461654207983e-02,  1.542453543026946e-04, -5.781026047049900e-07, -6.936959900662664e-09,
 -8.674677049885168e-10, -5.886691422510889e-12,  2.009443544635176e-12,  5.792686447062617e-15, -3.045085982175342e-15, -1.940243356829822e-17,  4.600258734788044e-18,
  8.542213458595106e-01, -1.752149760690843e-02,  2.073728553157521e-04,  2.109733450536017e-06, -8.404357463896692e-08, -1.529960318753530e-09,  5.558620736470361e-12,
  4.451451596331150e-12,  1.515829415217052e-14, -8.438417788143964e-15, -2.555954814007408e-17,  1.367810623006473e-17,  1.400353320131621e+00, -2.548451141769026e-02,
  6.857720252985376e-06,  1.860498579656577e-05, -2.451230573115619e-07, -2.280643952726961e-08,  6.258902746664985e-10,  2.930710631515096e-11, -1.284879763424652e-12,
 -3.594384336052375e-14,  2.404370286952700e-15,  3.937745772244399e-17,  8.548617520962648e-03, -1.767820203125459e-04,  3.060328343128770e-06, -3.247529813215719e-08,
  1.550680992119101e-10, -1.497335432388278e-11,  6.401284184376509e-13,  8.797781980639523e-15, -9.209686764582684e-16, -7.420006862439768e-18,  1.442301418870608e-18,
 -9.346935005563573e-23,  7.775336966309929e-02, -1.605060514517618e-03,  2.751169256668644e-05, -2.760535730916214e-07,  7.692065148041668e-10, -1.273720743188133e-10,
  5.848937988116257e-12,  8.664402534006804e-14, -8.893241455807065e-15, -6.701079954499668e-17,  1.386602335820848e-17, -6.322901258447166e-21,  2.208537498242766e-01,
 -4.540456463754732e-03,  7.602075698422279e-05, -6.564803502087506e-07, -2.058811973629970e-09, -3.052823444985864e-10,  1.696927519503425e-11,  2.840825390608506e-13,
 -2.867711357865558e-14, -1.861002801459753e-16,  4.463458120877276e-17, -6.605489376940666e-20,  4.492331107051127e-01, -9.161565856134306e-03,  1.460951690149435e-04,
 -8.173297934015973e-07, -2.145106590924280e-08, -4.094875249373189e-10,  3.769149580604839e-11,  6.751665857954241e-13, -7.219400312976947e-14, -3.438726521794196e-16,
  1.146527855502772e-16, -4.462345764318181e-19,  7.875786285854369e-01, -1.578618353869224e-02,  2.237457870599848e-04,  5.674159960358209e-07, -1.040554459557882e-07,
 -1.058583213930364e-10,  9.634721924770820e-11,  9.590658051349521e-13, -1.806027739920047e-13, -8.209713148109013e-17,  3.093280708568878e-16, -3.225525838449956e-18,
  1.299807071735488e+00, -2.463163387558891e-02,  1.947185663927537e-04,  1.203699390838335e-05, -5.111585649093579e-07, -3.097118366851247e-09,  8.111684054289390e-10,
 -1.399152338644730e-11, -9.376431163742537e-13,  4.192760596138010e-14,  5.890513338287606e-16, -7.818722849115392e-17,  7.888023159399871e-03, -1.538331927192612e-04,
  2.678418033599715e-06, -3.153083162708867e-08,  1.228895804721837e-11,  1.371653955692181e-13,  5.053617413462899e-13, -1.533995694075273e-14, -3.711303439466683e-16,
  2.787156152701029e-17,  2.456595535960777e-20, -3.995349663783794e-20,  7.175243936427858e-02, -1.398150618491582e-03,  2.421440473837651e-05, -2.762455004521078e-07,
 -3.405803209110432e-10,  1.125768167123814e-11,  4.614121670175622e-12, -1.446535412190093e-13, -3.508235802965493e-15,  2.679819077552373e-16,  7.805022235836106e-20,
 -3.825492315397180e-19,  2.038571497403944e-01, -3.964675800752267e-03,  6.781849492907939e-05, -7.152653954411031e-07, -3.968008116266716e-09,  9.881000518141767e-11,
  1.325468327208614e-11, -4.488085977486899e-13, -1.072408263466842e-14,  8.589927769060669e-16, -9.177624640015681e-19, -1.216042860402804e-18,  4.148536139870603e-01,
 -8.038160904348862e-03,  1.341233769822550e-04, -1.175043375241225e-06, -2.035596064085964e-08,  4.778480171056379e-10,  2.787784484795724e-11, -1.104598493276143e-12,
 -2.373371744839944e-14,  2.160698698510575e-15, -8.242097859596482e-18, -3.014136607752210e-18,  7.280178104448046e-01, -1.399662920189169e-02,  2.209006625156584e-04,
 -9.906824098188023e-07, -8.398951385188906e-08,  1.945561526973924e-09,  5.575149063452936e-11, -3.050190628994776e-12, -3.632754561135998e-14,  5.482323921602182e-15,
 -5.836253089626164e-17, -7.255371822660559e-18,  1.205115983326786e+00, -2.263382558296449e-02,  2.910026812670824e-04,  4.244744959680167e-06, -4.216462848967119e-07,
  9.689687509361303e-09,  2.251642382016272e-10, -2.086391932310864e-11,  3.539209176344252e-13,  1.864651164467190e-14, -1.085755539347563e-15,  6.378127640837099e-18,
  7.313158166778108e-03, -1.339122791105891e-04,  2.303020760843841e-06, -3.081209286238236e-08,  9.831808523161956e-11,  6.632654589056529e-12,  4.571741966224733e-14,
 -1.360906920332893e-14,  3.511577731660044e-16,  7.763282354058233e-18, -6.611161924042163e-19,  7.671574201774012e-21,  6.652620473473052e-02, -1.217738981982283e-03,
  2.088960996548837e-05, -2.753732499544858e-07,  6.340101253509344e-10,  6.896821109205454e-11,  2.940266100849921e-13, -1.270105530670786e-13,  3.362076658084808e-15,
  7.189418901278936e-17, -6.320428424359832e-18,  7.760747098635882e-20,  1.890279702250409e-01, -3.457300224568771e-03,  5.896299014945265e-05, -7.502841315153930e-07,
  8.435793773731449e-11,  2.535486325668340e-10,  4.001768052411667e-15, -3.824641929782705e-13,  1.074175051486152e-14,  2.097377054238512e-16, -2.000222282798813e-17,
  2.772798132602174e-19,  3.847510119390031e-01, -7.026205748853768e-03,  1.184712532405589e-04, -1.399134195370146e-06, -6.777214833719607e-09,  7.544563858763327e-10,
 -3.588862602544499e-12, -8.692101613408459e-13,  2.741206187970174e-14,  4.208942545625608e-16, -4.906565222588453e-17,  8.396345680851981e-19,  6.754624757003782e-01,
 -1.229653862517621e-02,  2.023886099361678e-04, -1.979843471695498e-06, -3.861709912542582e-08,  2.282343290947541e-09, -2.197628560571825e-11, -1.904469856463999e-12,
  7.609758156961525e-14,  4.283564658659909e-16, -1.167822776550681e-16,  2.922571476607147e-18,  1.119418164847974e+00, -2.020098168274460e-02,  3.083323812245054e-04,
 -8.280122818414490e-07, -2.128865629960651e-07,  9.713150634049354e-09, -1.520721844526716e-10, -5.848825021652306e-12,  4.205340469697010e-13, -8.704155901336002e-15,
 -2.063837296606252e-16,  1.880472860084723e-17,  6.812066531113304e-03, -1.169304259579520e-04,  1.946989778548163e-06, -2.822318134903297e-08,  2.181459001145960e-10,
  4.526296390081629e-12, -1.667380609090365e-13, -1.994618738938755e-15,  2.842169408231041e-16, -7.427319779592185e-18, -8.054092033827540e-20,  1.121690155144493e-20,
  6.196893281617643e-02, -1.063565300780185e-03,  1.769001526098241e-05, -2.547859036517085e-07,  1.863239447013547e-09,  4.638563645834370e-11, -1.659181031460622e-12,
 -1.689158936455337e-14,  2.667761754291511e-15, -7.132725193024630e-17, -7.109330037786854e-19,  1.061674083430442e-19,  1.760856776490604e-01, -3.021216646275754e-03,
  5.012686851162267e-05, -7.112624364283400e-07,  4.501600223719501e-09,  1.662225626038134e-10, -5.670366507603273e-12, -3.901023829455613e-14,  8.120929689851660e-15,
 -2.287277586140603e-16, -1.815232093896220e-18,  3.281367741748458e-19,  3.584342248145532e-01, -6.146354775236050e-03,  1.014956503218006e-04, -1.397964618455136e-06,
  6.008590410779542e-09,  4.780477403078502e-10, -1.554751781687292e-11, -3.692836076792048e-14,  1.869082314718673e-14, -5.814213235039712e-16, -2.313063950222814e-18,
  7.662738487679844e-19,  6.293534951365999e-01, -1.077975320036505e-02,  1.762990041506492e-04, -2.274459894063669e-06, -1.177007755755677e-09,  1.378939098105836e-09,
 -4.373975343079389e-11,  1.482269205074978e-13,  4.074867650060577e-14, -1.548616519762911e-15,  6.274281908489669e-18,  1.611592898279353e-18,  1.043420500076155e+00,
 -1.781867590214226e-02,  2.836324647920673e-04, -2.910714988229156e-06, -6.185488246808081e-08,  5.305294266782379e-09, -1.784322716829532e-10,  2.234417244825399e-12,
  9.977480107019298e-14, -6.703915113468328e-15,  1.686256049465127e-16,  4.476712664361015e-19,  6.373442722558477e-03, -1.026444477775670e-04,  1.631522249300546e-06,
 -2.422978716261939e-08,  2.683770101298563e-10,  6.322809187227308e-13, -1.354786438873693e-13,  2.926201349280417e-15,  4.163703362467988e-17, -4.680598938532448e-18,
  1.327298598575672e-19, -1.589805262386652e-22,  5.797913860251854e-02, -9.337118521097194e-04,  1.483497263120292e-05, -2.197340022696793e-07,  2.394114156324591e-09,
  8.150687774041643e-12, -1.320648171464644e-12,  2.872705144814343e-14,  3.651942414994866e-16, -4.391043338018736e-17,  1.269901475363047e-18, -2.434274157656176e-21,
  1.647507861323073e-01, -2.652913279725166e-03,  4.210967146740815e-05, -6.199761912103393e-07,  6.496185665056674e-09,  3.884159985392962e-11, -4.335766868268216e-12,
  9.584889936643792e-14,  9.337971558831298e-16, -1.333417007137589e-16,  4.031997005509720e-18, -1.429243093534131e-20,  3.353695929455583e-01, -5.399260280949001e-03,
  8.554817189789920e-05, -1.244992524485927e-06,  1.202349364897884e-08,  1.413798435482289e-10, -1.119509502927686e-11,  2.552344612686961e-13,  1.359726902660959e-15,
 -3.041161126247840e-16,  1.000924613026144e-17, -6.619320195495286e-20,  5.888842708850643e-01, -9.477114372771125e-03,  1.496267077566904e-04, -2.126258122809780e-06,
  1.679795306859750e-08,  4.790550223267207e-10, -2.881208596730599e-11,  6.982416232479782e-13, -6.532496141600603e-16, -6.403580494722881e-16,  2.504641710364507e-17,
 -3.167378838998284e-19,  9.764478270031666e-01, -1.569947923717345e-02,  2.455820335938344e-04, -3.258866998673300e-06,  7.578649856182012e-09,  1.956571611797779e-09,
 -9.856423266587235e-11,  2.786065693554005e-12, -3.246213962918914e-14, -1.245138626524469e-15,  8.517691496946962e-17, -2.456923527452849e-18,  5.987230876508628e-03,
 -9.068234428347541e-05,  1.366453027364084e-06, -1.998233536978243e-08,  2.553896391126558e-10, -1.606348600262214e-12, -5.338483400253360e-14,  2.498185680627529e-15,
 -4.368211458356103e-17, -5.625023502166517e-19,  6.165409668706216e-20, -1.908263180085444e-21,  5.446587425799135e-02, -8.249255041728184e-04,  1.242857090811496e-05,
 -1.815643534385727e-07,  2.307170052411172e-09, -1.370130077196389e-11, -5.252358121707380e-13,  2.401831966372581e-14, -4.257777823570977e-16, -4.929216520127036e-18,
  5.764799042053097e-19, -1.814701324520418e-20,  1.547683012925535e-01, -2.344000884413320e-03,  3.530344874640055e-05, -5.145495761318213e-07,  6.452280495221242e-09,
 -3.302892568725021e-11, -1.751015053239236e-12,  7.678920808796378e-14, -1.401886588257166e-15, -1.254591880047679e-17,  1.736109880740035e-18, -5.679594738442446e-20,
  3.150514987139230e-01, -4.771232053153666e-03,  7.181516052080170e-05, -1.042180105308862e-06,  1.273497419666502e-08, -4.420652447970667e-11, -4.589106579622768e-12,
  1.909659129489879e-13, -3.667746661680160e-15, -1.780206879540889e-17,  3.886779859491517e-18, -1.369223588627230e-19,  5.532153872045458e-01, -8.377075917665944e-03,
  1.259362780568610e-04, -1.812019439649165e-06,  2.096778415259221e-08,  4.622335756298806e-12, -1.183080230091221e-11,  4.686267885350212e-13, -9.828580667696863e-15,
  1.246371539394346e-17,  7.798494980773224e-18, -3.209763082861278e-19,  9.173374768843623e-01, -1.388692637813563e-02,  2.081448043463789e-04, -2.929011476510675e-06,
  2.866114974891804e-08,  3.870873051835476e-10, -3.824679118237069e-11,  1.502231890010652e-12, -3.797266071961159e-14,  4.536485388444293e-16,  1.173154094108756e-17,
 -8.779765024418294e-19,  5.644940500856259e-03, -8.064319397756125e-05,  1.149954620065354e-06, -1.620189214229190e-08,  2.152704106147933e-10, -2.211536191208085e-12,
 -3.506749480593197e-15,  1.108850475461542e-15, -3.656197137533705e-17,  5.846892830644649e-19,  5.149828310984636e-21, -6.591195104759219e-22,  5.135208462191790e-02,
 -7.336087319855006e-04,  1.046058165425646e-05, -1.473266133971657e-07,  1.953373738570976e-09, -1.981627851999628e-11, -4.647932139925644e-14,  1.064592520292602e-14,
 -3.492158226272515e-16,  5.666556533676472e-18,  4.400056651517724e-20, -6.133874952947856e-21,  1.459204439425923e-01, -2.084578440007633e-03,  2.972085143488215e-05,
 -4.182427264152690e-07,  5.519037621214843e-09, -5.436824916316930e-11, -2.263264251906222e-13,  3.389283675420651e-14, -1.101910520434089e-15,  1.844870034666770e-17,
  1.035464132462146e-19, -1.826535196839902e-20,  2.970411698986094e-01, -4.243369517070086e-03,  6.048738981517064e-05, -8.498975148220352e-07,  1.111457641571414e-08,
 -1.032211016824833e-10, -8.270204261364983e-13,  8.337478567743987e-14, -2.686154010805796e-15,  4.746599346742835e-17,  1.020576449639567e-19, -3.993672540398604e-20,
  5.215923091364000e-01, -7.450932971519463e-03,  1.061687252795311e-04, -1.487379117643074e-06,  1.910767702578999e-08, -1.554212364171644e-10, -2.750782213663881e-12,
  1.989280214880777e-13, -6.406602820280584e-15,  1.241746317471870e-16, -3.982200072689825e-19, -7.565813461975750e-20,  8.649089322940400e-01, -1.235423861267744e-02,
  1.758756518985785e-04, -2.446329238216256e-06,  2.999201545859394e-08, -1.465569432006171e-10, -1.043294968921369e-11,  5.833225165063982e-13, -1.956770601309418e-14,
  4.576047928777712e-16, -5.802148735161981e-18, -8.130271648491908e-20,  5.339613902996911e-03, -7.216604190129435e-05,  9.747471192710640e-07, -1.310755253404570e-08,
  1.721137452173864e-10, -2.035563585728469e-12,  1.436003401069768e-14,  2.745236070142144e-16, -1.645705544582938e-17,  4.552299693735188e-19, -7.069095422615261e-21,
 -2.676868568958594e-23,  4.857453257915689e-02, -6.564945336377120e-04,  8.867138679274986e-06, -1.192227676465695e-07,  1.564322337314432e-09, -1.842709383705950e-11,
  1.259387880012608e-13,  2.696016730586272e-15, -1.565703889462443e-16,  4.330298190776724e-18, -6.814625900505622e-20, -2.046539893421306e-22,  1.380278869382779e-01,
 -1.865469320106447e-03,  2.519565357570910e-05, -3.386733095386950e-07,  4.436239374142168e-09, -5.178450314129730e-11,  3.277529646357489e-13,  8.942868046427685e-15,
 -4.895258624986055e-16,  1.354900150682109e-17, -2.194532688372234e-19, -2.984715518863546e-22,  2.809749542141061e-01, -3.797402916576207e-03,  5.128579144223404e-05,
 -6.890191653414535e-07,  8.997153016015906e-09, -1.032265116837844e-10,  5.519924141325866e-13,  2.316668891447143e-14, -1.171911774928722e-15,  3.258385621202191e-17,
 -5.548289106519455e-19,  7.485916648215435e-22,  4.933812422267630e-01, -6.668031736563064e-03,  9.004459811914924e-05, -1.208582856687663e-06,  1.568724449273868e-08,
 -1.738631850987696e-10,  5.729140917954528e-13,  5.812892151424973e-14, -2.692533438789331e-15,  7.607941929930548e-17, -1.411850357819533e-18,  7.997530692067638e-21,
  8.181312073421623e-01, -1.105678750021175e-02,  1.492706393412353e-04, -1.999051956214624e-06,  2.557274074384238e-08, -2.581684865565975e-10, -7.255266248949606e-13,
  1.736667186348646e-13, -7.452324988702980e-15,  2.228995665837292e-16, -4.916451549332089e-18,  6.614800956878133e-20,  5.065611692332351e-03, -6.495337568654332e-05,
  8.327015414098326e-07, -1.065897966180624e-08,  1.352211297700362e-10, -1.644986512506458e-12,  1.675345638382356e-14, -4.319669895380620e-17, -4.929542779462320e-18,
  2.003803557812927e-19, -4.966064201281632e-21,  7.692185617492370e-23,  4.608193296201349e-02, -5.908814717024405e-04,  7.575059758753778e-06, -9.696057980036573e-08,
  1.229737619190511e-09, -1.493941251362035e-11,  1.510346148253121e-13, -3.308099299428368e-16, -4.719699339386490e-17,  1.897178492702623e-18, -4.709688738790025e-20,
  7.378828606596764e-22,  1.309450045639025e-01, -1.679029377383920e-03,  2.152482686620145e-05, -2.754931355231611e-07,  3.492039687152403e-09, -4.229237661563159e-11,
  4.204342396701463e-13, -5.421380942449409e-16, -1.492636829450366e-16,  5.873130245859745e-18, -1.464275579466752e-19,  2.351724897363532e-21,  2.665568047037704e-01,
 -3.417893678134040e-03,  4.381593667922701e-05, -5.607044368117010e-07,  7.099800887650005e-09, -8.549605255803734e-11,  8.228389387822373e-13,  4.128181745600709e-16,
 -3.622403283629283e-16,  1.384156344450665e-17, -3.484079175383241e-19,  5.843806545144078e-21,  4.680636607694665e-01, -6.001677279172790e-03,  7.693640332319736e-05,
 -9.842509877260157e-07,  1.243839299529526e-08, -1.481534740632510e-10,  1.333978369015326e-12,  5.904091539343257e-15, -8.396752074428838e-16,  3.106054404637045e-17,
 -7.991094156599106e-19,  1.445043935621459e-20,  7.761497624491498e-01, -9.952013125298507e-03,  1.275670759498127e-04, -1.630889903182114e-06,  2.051683000716400e-08,
 -2.379776132353648e-10,  1.767252988210884e-12,  3.130079423848598e-14, -2.275475466624990e-15,  8.250633586911441e-17, -2.254656995917489e-18,  4.742819095831200e-20,
  4.818360135212005e-03, -5.876897576118481e-05,  7.167583553343450e-07, -8.737451673525342e-09,  1.061759438904413e-10, -1.269788815653717e-12,  1.418366829532237e-14,
 -1.175303907000831e-16, -5.243003986805483e-19,  6.341298585912947e-20, -2.103938584087952e-21,  4.823207293577131e-23,  4.383268288874933e-02, -5.346220668270473e-04,
  6.520351103390495e-06, -7.948366178497795e-08,  9.657907664157083e-10, -1.154476656624396e-11,  1.286569335046757e-13, -1.051446215201601e-15, -5.484788127802763e-18,
  6.014523071274667e-19, -1.985775041424700e-20,  4.563041559547144e-22,  1.245536074128238e-01, -1.519165378135562e-03,  1.852797525010248e-05, -2.258517625136518e-07,
  2.743774809095207e-09, -3.276408124049432e-11,  3.632297101102127e-13, -2.874981614303894e-15, -2.015532291145559e-17,  1.867013434144552e-18, -6.107461175358509e-20,
  1.411256942332470e-21,  2.535462351424969e-01, -3.092471893075113e-03,  3.771607775114129e-05, -4.597285977833836e-07,  5.583169875234611e-09, -6.654296901716210e-11,
  7.305943254967455e-13, -5.427955787591367e-15, -5.837899412048835e-17,  4.406646350743779e-18, -1.424079409221203e-19,  3.327616724413629e-21,  4.452176248334901e-01,
 -5.430260651745549e-03,  6.622737765166327e-05, -8.071888700186120e-07,  9.796851283345928e-09, -1.163491256493868e-10,  1.253881278968183e-12, -8.114801195483047e-15,
 -1.613298764272013e-16,  9.832919231794369e-18, -3.141570834805422e-19,  7.512651105761293e-21,  7.382662571580526e-01, -9.004524425473538e-03,  1.098169360531258e-04,
 -1.338212821914518e-06,  1.621956038931503e-08, -1.910614976709829e-10,  1.967638937937990e-12, -7.859239171900250e-15, -5.076378180627867e-16,  2.520935972851731e-17,
 -8.078274840461198e-19,  2.047581967625957e-20,  4.594126690953169e-03, -5.342724227209263e-05,  6.213205866082912e-07, -7.224438224241002e-09,  8.391502554233985e-11,
 -9.691466059715053e-13,  1.090640137656289e-14, -1.104708138988380e-16,  6.655487803606854e-19,  1.207154111019212e-20, -6.729039610535603e-22,  1.952995210796123e-23,
  4.179282852032349e-02, -4.860282871406325e-04,  5.652159231196297e-06, -6.572056071794772e-08,  7.633536775773597e-10, -8.814727572878625e-12,  9.912058009150887e-14,
 -1.000242334137791e-15,  5.855216839802505e-18,  1.170811322103244e-19, -6.350769981800861e-21,  1.839119395252988e-22,  1.187572204277234e-01, -1.381083017000619e-03,
  1.606098997262261e-05, -1.867479966382907e-07,  2.168982049589452e-09, -2.503752420580771e-11,  2.810582257281385e-13, -2.812444256839729e-15,  1.537252726967396e-17,
  3.790312958022218e-19, -1.951641632900784e-20,  5.629180040225622e-22,  2.417468834980691e-01, -2.811386843761260e-03,  3.269433963668643e-05, -3.801459897824369e-07,
  4.414750884400349e-09, -5.093004137651000e-11,  5.699124389526954e-13, -5.614067278215437e-15,  2.654618232125265e-17,  9.468154484299844e-19, -4.534507512852698e-20,
  1.301923242567100e-21,  4.244984156194752e-01, -4.936688594433353e-03,  5.740988619897697e-05, -6.675043453347013e-07,  7.750499087931903e-09, -8.931146268333673e-11,
  9.935519238264260e-13, -9.494483828018766e-15,  3.087640207425896e-17,  2.252311792398724e-18, -9.887337293183797e-20,  2.833422410784960e-21,  7.039093921054583e-01,
 -8.186085649837721e-03,  9.519740637466262e-05, -1.106802882209833e-06,  1.284612221900762e-08, -1.476610676992579e-10,  1.620805630757461e-12, -1.436348212642244e-14,
 -1.009310857602549e-17,  6.102645744623162e-18, -2.441742441499385e-19,  7.089643147932898e-21,  4.389840185396984e-03, -4.878201146319972e-05,  5.420868410082464e-07,
 -6.023644100140778e-09,  6.691266408285346e-11, -7.418529870535505e-13,  8.147866746350136e-15, -8.604349977766394e-17,  7.768299192286311e-19, -2.504590164489985e-21,
 -1.520675869417234e-22,  6.192559025411126e-24,  3.993443162210756e-02, -4.437705722417562e-04,  4.931370398755529e-06, -5.479711104312253e-08,  6.087001804523100e-10,
 -6.748264482934048e-12,  7.409810658470995e-14, -7.815554030004559e-16,  7.014899757521127e-18, -2.080524586513457e-20, -1.449337145097928e-21,  5.826235011484016e-23,
  1.134764569081524e-01, -1.261004842295569e-03,  1.401282822543192e-05, -1.557094452481002e-07,  1.729631445739373e-09, -1.917327064653389e-11,  2.104095494446362e-13,
 -2.213390427901492e-15,  1.960525958918732e-17, -4.657436595744354e-20, -4.538315687557395e-21,  1.778917242058832e-22,  2.309971534307119e-01, -2.566951164551785e-03,
  2.852505612031713e-05, -3.169670355946301e-07,  3.520788269018956e-09, -3.902112276138555e-11,  4.277839859277304e-13, -4.478144574590400e-15,  3.869094984353587e-17,
 -4.791173685633511e-20, -1.082043553613397e-20,  4.090371386877288e-22,  4.056222963709840e-01, -4.507469351676128e-03,  5.008889266346038e-05, -5.565782475781528e-07,
  6.182001226813248e-09, -6.849192595814939e-11,  7.494674543840948e-13, -7.774778887222191e-15,  6.397372491424196e-17,  7.036832217301885e-20, -2.428598058726056e-20,
  8.776811524168934e-22,  6.726087444620773e-01, -7.474350179545930e-03,  8.305801883285035e-05, -9.229125217082365e-07,  1.024978710874340e-08, -1.134759456356298e-10,
  1.236625347134458e-12, -1.256648579981580e-14,  9.120845128915966e-17,  7.101248497934111e-19, -6.115780637855794e-20,  2.107379260699355e-21,  4.202952022072561e-03,
 -4.471731386134743e-05,  4.757694016813804e-07, -5.061883120549067e-09,  5.384999272481483e-11, -5.725200780625176e-13,  6.067252341057883e-15, -6.338380384084246e-17,
  6.258504741513378e-19, -4.916701235682669e-21, -2.101935047230731e-24,  1.500822732534356e-24,  3.823430764432227e-02, -4.067939686619735e-04,  4.328080162516248e-06,
 -4.604800253504751e-08,  4.898729084725443e-10, -5.208135328288016e-12,  5.518846787734907e-14, -5.763196396316435e-16,  5.680546221318316e-18, -4.422133824056791e-20,
 -3.670006183834844e-23,  1.419345741459366e-23,  1.086454367519641e-01, -1.155933270425435e-03,  1.229853934498185e-05, -1.308485169660799e-07,  1.392000637444407e-09,
 -1.479873395728960e-11,  1.567880386188325e-13, -1.635872921030406e-15,  1.606101412853071e-17, -1.224667045500208e-19, -2.155278730389039e-22,  4.376494717056126e-23,
  2.211629382793300e-01, -2.353063368385526e-03,  2.503538986694723e-05, -2.663601312769557e-07,  2.833585336725172e-09, -3.012291072575613e-11,  3.190405291100517e-13,
 -3.323527584081282e-15,  3.239746304931119e-17, -2.374826151980469e-19, -8.532010375534422e-22,  1.019756768255048e-22,  3.883537855010434e-01, -4.131890570783538e-03,
  4.396119462780935e-05, -4.677175076786955e-07,  4.975587869433147e-09, -5.288850684354808e-11,  5.598339879198093e-13, -5.815266908469545e-15,  5.593666760386989e-17,
 -3.787589068330985e-19, -2.855179314820062e-21,  2.218151116419831e-22,  6.439738517085212e-01, -6.851560463793560e-03,  7.289706530457099e-05, -7.755730518440161e-07,
  8.250312998523291e-09, -8.767898959662594e-11,  9.269548473221992e-13, -9.568902037421759e-15,  8.929414728322718e-17, -4.862910548630979e-19, -9.877982344874257e-21,
  5.341778760870886e-22,  4.031329966289213e-03, -4.114030350606443e-05,  4.198426130896405e-07, -4.284539530290286e-09,  4.372298534226149e-11, -4.461015066108149e-13,
  4.546734581993067e-15, -4.611051086152627e-17,  4.581368676797189e-19, -4.211468923741962e-21,  2.779471349158433e-23,  1.536640451319320e-25,  3.667305963564445e-02,
 -3.742538606648802e-04,  3.819313535536556e-06, -3.897650764003376e-08,  3.977482991711920e-10, -4.058171803680730e-12,  4.136048412128272e-14, -4.194025558169782e-16,
  4.164648465708488e-18, -3.818887937134839e-20,  2.484368163278659e-22,  1.538857816400685e-24,  1.042090422678817e-01, -1.063468299329514e-03,  1.085284415993251e-05,
 -1.107544333883009e-07,  1.130227816455324e-09, -1.153145680700085e-11,  1.175210858461423e-13, -1.191352941650923e-15,  1.181516337270587e-17, -1.077444144618757e-19,
  6.781638201108451e-22,  5.263388120929869e-24,  2.121320386271812e-01, -2.164838033330316e-03,  2.209247738943941e-05, -2.254560371426003e-07,  2.300730723954423e-09,
 -2.347345555773261e-11,  2.392030074024215e-13, -2.423678118692029e-15,  2.398205921087780e-17, -2.164940717875318e-19,  1.277922930776135e-21,  1.402174965712908e-23,
  3.724958660948837e-01, -3.801374002494744e-03,  3.879355642699724e-05, -3.958921276378384e-07,  4.039979124527317e-09, -4.121716077850891e-11,  4.199455061044420e-13,
 -4.251217320533148e-15,  4.189215729563288e-17, -3.711122433640559e-19,  1.913699699797166e-21,  3.538509156653937e-23,  6.176780211259622e-01, -6.303493211064483e-03,
  6.432803064063806e-05, -6.564734462865528e-07,  6.699093284997076e-09, -6.834231748183824e-11,  6.960634679383334e-13, -7.033127928119784e-15,  6.868915473827753e-17,
 -5.828423992392586e-19,  1.962919124065146e-21,  9.895668250160960e-23,  3.873176550711550e-03, -3.797596946545927e-05,  3.723491922923392e-07, -3.650829948761703e-09,
  3.579558857529335e-11, -3.509486381783840e-13,  3.439657453808379e-15, -3.365644690253998e-17,  3.269558429423121e-19, -3.088588152717231e-21,  2.630334540281801e-23,
 -1.380814324048152e-25,  3.523433601621887e-02, -3.454678740017286e-04,  3.387265302473966e-06, -3.321164562718496e-08,  3.256328684429486e-10, -3.192580062011992e-12,
  3.129034115757017e-14, -3.061585702397882e-16,  2.973632728746512e-18, -2.806831032470271e-20,  2.382268899891848e-22, -1.221370330116107e-24,  1.001208093276916e-01,
 -9.816709224023028e-04,  9.625149241752628e-06, -9.437319095523146e-08,  9.253080494923614e-10, -9.071911981030455e-12,  8.891201856410745e-14, -8.698801146038001e-16,
  8.445483163468292e-18, -7.957899260719773e-20,  6.703213195683091e-22, -3.252030954248776e-24,  2.038098703333417e-01, -1.998328066890833e-03,  1.959333352316034e-05,
 -1.921097795656817e-07,  1.883592398966660e-09, -1.846704970588706e-11,  1.809868417345658e-13, -1.770434105525337e-15,  1.717634074674326e-17, -1.613412399375073e-19,
  1.340297753686634e-21, -5.815413309510023e-24,  3.578824521880470e-01, -3.508988781582492e-03,  3.440515505927498e-05, -3.373374971496585e-07,  3.307513664117540e-09,
 -3.242715967078476e-11,  3.177876206282199e-13, -3.107795542642854e-15,  3.011215333278935e-17, -2.812524093467327e-19,  2.276567766833864e-21, -7.634630093032732e-24,
  5.934458473275473e-01, -5.818655836367868e-03,  5.705112376602533e-05, -5.593777861646412e-07,  5.484554918187219e-09, -5.377023410570040e-11,  5.268975981908022e-13,
 -5.149902539985401e-15,  4.976325284333997e-17, -4.591580913326678e-19,  3.500840480274131e-21, -3.317601790767444e-24,  3.726965873921388e-03, -3.516318517443052e-05,
  3.317576854224355e-07, -3.130067386214774e-09,  2.953150038896083e-11, -2.786189463339741e-13,  2.628411490720237e-15, -2.478269300463673e-17,  2.331039366203533e-19,
 -2.170967874265421e-21,  1.949112148079104e-23, -1.529667269493206e-25,  3.390425564225064e-02, -3.198799397859606e-04,  3.018003854942508e-06, -2.847426244763370e-08,
  2.686484211736040e-10, -2.534599208684196e-12,  2.391063592185955e-14, -2.254453247908078e-16,  2.120397841322248e-18, -1.974289590444870e-20,  1.770687157729252e-22,
 -1.383355125206494e-24,  9.634129370288055e-02, -9.089610328831897e-04,  8.575867250377927e-06, -8.091159078104167e-08,  7.633830519234119e-10, -7.202234061126646e-12,
  6.794337887539962e-14, -6.405989692527685e-16,  6.024313628576722e-18, -5.606072672949827e-20,  5.016389608840850e-22, -3.879630287964294e-24,  1.961161391850138e-01,
 -1.850316946954648e-03,  1.745737376883157e-05, -1.647068246110412e-07,  1.553972421991315e-09, -1.466113265189231e-11,  1.383069623018108e-13, -1.303958148941084e-15,
  1.225992211574087e-17, -1.139741851167484e-19,  1.015648382874100e-21, -7.710235577370146e-24,  3.443725502154360e-01, -3.249086833569226e-03,  3.065449044126512e-05,
 -2.892189700510956e-07,  2.728716279328252e-09, -2.574433788983806e-11,  2.428579511812813e-13, -2.289484604535635e-15,  2.151740625179426e-17, -1.996818388567264e-19,
  1.766163952896800e-21, -1.294699059689844e-23,  5.710435329052793e-01, -5.387682678824612e-03,  5.083171829123365e-05, -4.795870463767057e-07,  4.524794309648479e-09,
 -4.268943945302105e-11,  4.026977056195829e-13, -3.795728071885984e-15,  3.564463131803903e-17, -3.295606128148878e-19,  2.868555783967974e-21, -1.937930711342763e-23,
  3.591394179504790e-03, -3.265173670317662e-05,  2.968585046727615e-07, -2.698936603778774e-09,  2.453780144598024e-11, -2.230883024810234e-13,  2.028176720978567e-15,
 -1.843595841528622e-17,  1.674505055343775e-19, -1.515808760567846e-21,  1.354443068739985e-23, -1.155335175705839e-25,  3.267095822531320e-02, -2.970332613162474e-04,
  2.700525567409675e-06, -2.455226036130782e-08,  2.232206875479550e-10, -2.029436928669698e-12,  1.845033749707475e-14, -1.677114837260042e-16,  1.523266919804652e-18,
 -1.378793245971082e-20,  1.231601069011306e-22, -1.049155119941405e-24,  9.283679356224622e-02, -8.440406115915116e-04,  7.673730683039882e-06, -6.976695040491297e-08,
  6.342970505378860e-10, -5.766784678723932e-12,  5.242784075753209e-14, -4.765597023684985e-16,  4.328267149909908e-18, -3.917066601368319e-20,  3.496331182207892e-22,
 -2.969669382855396e-24,  1.889822404078602e-01, -1.718162375623161e-03,  1.562094898786211e-05, -1.420203568330504e-07,  1.291200057292291e-09, -1.173909054285577e-11,
  1.067239214229445e-13, -9.700890132638934e-16,  8.810067689943310e-18, -7.970599952013500e-20,  7.105161213125253e-22, -6.003158257021480e-24,  3.318456927881707e-01,
 -3.017028386480957e-03,  2.742979777177653e-05, -2.493823934269919e-07,  2.267298497576832e-09, -2.061338878901230e-11,  1.874023937028311e-13, -1.703394788650244e-15,
  1.546792564528392e-17, -1.398639825890157e-19,  1.243881262669256e-21, -1.041006376289483e-23,  5.502713171280063e-01, -5.002880013409735e-03,  4.548448650993889e-05,
 -4.135294793083162e-07,  3.759666616295946e-09, -3.418138025719616e-11,  3.107507609331458e-13, -2.824445103830103e-15,  2.564172229222929e-17, -2.315982134015009e-19,
  2.049806904778170e-21, -1.680906895681636e-23,  3.465340845664177e-03, -3.040006608153877e-05,  2.666877684342832e-07, -2.339546394158228e-09,  2.052391326396873e-11,
 -1.800479591797786e-13,  1.579475418415556e-15, -1.385534576524961e-17,  1.215114439601281e-19, -1.064485330142190e-21,  9.283765411324765e-24, -7.964360988269421e-26,
  3.152424945478501e-02, -2.765497852238414e-04,  2.426061998798649e-06, -2.128288310157689e-08,  1.867062978239472e-10, -1.637898523752164e-12,  1.436850544669520e-14,
 -1.260421190113986e-16,  1.105384369350562e-18, -9.683340111074054e-21,  8.444295571251649e-23, -7.241122255273876e-25,  8.957834106535184e-02, -7.858353937286348e-04,
  6.893823419318255e-06, -6.047678829645121e-08,  5.305388908227124e-10, -4.654202025147033e-12,  4.082908993339168e-14, -3.581565782393922e-16,  3.140984403943086e-18,
 -2.751404405563333e-20,  2.398786009863256e-22, -2.055084134348197e-24,  1.823492059234303e-01, -1.599677537320061e-03,  1.403333898882173e-05, -1.231089366358737e-07,
  1.079985892113814e-09, -9.474276520478001e-12,  8.311325408563203e-14, -7.290746529800626e-16,  6.393761809369023e-18, -5.600208115220173e-20,  4.880476918736303e-22,
 -4.174277788493489e-24,  3.201983341845142e-01, -2.808973475297242e-03,  2.464201444767679e-05, -2.161746533677367e-07,  1.896414500842537e-09, -1.663647020339814e-11,
  1.459435836259423e-13, -1.280218489998629e-15,  1.122674812230365e-17, -9.831737557366780e-20,  8.561979825445150e-22, -7.301633883128275e-24,  5.309574989918380e-01,
 -4.657880357080970e-03,  4.086174399525524e-05, -3.584639292456396e-07,  3.144661802968431e-09, -2.758682744312291e-11,  2.420052432629793e-13, -2.122847007888627e-15,
  1.861485403325737e-17, -1.629643794001390e-19,  1.417095555359839e-21, -1.201207556040652e-23,  3.347837316567748e-03, -2.837354057241377e-05,  2.404710051119326e-07,
 -2.038036246895424e-09,  1.727273361731011e-11, -1.463895666943071e-13,  1.240675691306344e-15, -1.051479309489789e-17,  8.910705451680785e-20, -7.548730234199845e-22,
  6.385510909043663e-24, -5.370584788245129e-26,  3.045531836603309e-02, -2.581144570639507e-04,  2.187567771653689e-06, -1.854004148610372e-08,  1.571302758574534e-10,
 -1.331707730695304e-12,  1.128644196223006e-14, -9.565317811222177e-17,  8.106066185247701e-19, -6.867028130061002e-21,  5.808664472576063e-23, -4.884761034678330e-25,
  8.654089924517934e-02, -7.334501302538667e-04,  6.216125533222778e-06, -5.268281364879667e-08,  4.464965754669536e-10, -3.784139828755597e-12,  3.207120462432979e-14,
 -2.718049694010388e-16,  2.303386380856431e-18, -1.951275732519412e-20,  1.650421789987118e-22, -1.387500803043521e-24,  1.761660694938065e-01, -1.493040027818821e-03,
  1.265379042981673e-05, -1.072432143616646e-07,  9.089060463477846e-10, -7.703144208021090e-12,  6.528539927900785e-14, -5.532963179024996e-16,  4.688833789628676e-18,
 -3.971958450523457e-20,  3.359124979547255e-22, -2.822520338672155e-24,  3.093409796116148e-01, -2.621722027014565e-03,  2.221957916491668e-05, -1.883150431470604e-07,
  1.596004761737364e-09, -1.352643049536433e-11,  1.146386697553125e-13, -9.715656674012911e-16,  8.233323487122241e-18, -6.974198235816471e-20,  5.896853910958122e-22,
 -4.950321257339177e-24,  5.129536769408733e-01, -4.347377303067394e-03,  3.684482685304081e-05, -3.122667222237334e-07,  2.646518112532862e-09, -2.242972080982307e-11,
  1.900953967440257e-13, -1.611058359003971e-15,  1.365231747897819e-17, -1.156337180540260e-19,  9.772830157227029e-22, -8.188997857344140e-24,  3.238042151631447e-03,
 -2.654311256345623e-05,  2.175811158521080e-07, -1.783571607605428e-09,  1.462042164552283e-11, -1.198475650199630e-13,  9.824224919587016e-16, -8.053150655810108e-18,
  6.601223311644514e-20, -5.410506245698757e-22,  4.432493884131535e-24, -3.624154224942797e-26,  2.945651036343453e-02, -2.414630303405116e-04,  1.979338159866848e-06,
 -1.622517344821021e-08,  1.330021604099356e-10, -1.090254811798096e-12,  8.937109728103039e-15, -7.325960781456593e-17,  6.005138421060118e-19, -4.921931957196863e-21,
  4.032195492722002e-23, -3.296717529634237e-25,  8.370271703741911e-02, -6.861339464255543e-04,  5.624426650420514e-06, -4.610495558480541e-08,  3.779348625415151e-10,
 -3.098034649637374e-12,  2.539541651574507e-14, -2.081722226821750e-16,  1.706400022879194e-18, -1.398593436557597e-20,  1.145745526725942e-22, -9.366736169248342e-25,
  1.703885537941865e-01, -1.396721336874570e-03,  1.144930483506408e-05, -9.385306693255718e-08,  7.693391195179883e-10, -6.306481554734053e-12,  5.169590995784798e-14,
 -4.237634723841530e-16,  3.473609171211641e-18, -2.847004741021077e-20,  2.332215077414254e-22, -1.906331235958894e-24,  2.991958797556855e-01, -2.452590035269857e-03,
  2.010454784916573e-05, -1.648024488829623e-07,  1.350930502007405e-09, -1.107394387660383e-11,  9.077606378801895e-14, -7.441123334610206e-16,  6.099508635501195e-18,
 -4.999150897836558e-20,  4.094949640962227e-22, -3.346234129559997e-24,  4.961309259411151e-01, -4.066920193371867e-03,  3.333765140118257e-05, -2.732777992092549e-07,
  2.240132452340449e-09, -1.836297328330278e-11,  1.505261599299598e-13, -1.233896678644897e-15,  1.011423499433367e-17, -8.289399013869851e-20,  6.789224361505722e-22,
 -5.544801053440539e-24,  3.135220831896653e-03, -2.488427252828026e-05,  1.975066677781141e-07, -1.567611983312494e-09,  1.244214868101627e-11, -9.875343058818388e-14,
  7.838066368647797e-16, -6.221072586091357e-18,  4.937636539100955e-20, -3.918860562630269e-22,  3.109841887032435e-24, -2.466182066390153e-26,  2.852114351874292e-02,
 -2.263725415824185e-04,  1.796720652114265e-06, -1.426058601767283e-08,  1.131863837445438e-10, -8.983612054693767e-13,  7.130298860320109e-15, -5.659317485401627e-17,
  4.491773654420252e-19, -3.564989940419521e-21,  2.829017093100429e-23, -2.243452320312689e-25,  8.104480727956161e-02, -6.432532760783251e-04,  5.105506337432740e-06,
 -4.052244415554748e-08,  3.216269589846110e-10, -2.552755666025581e-12,  2.026123859466446e-14, -1.608134246253912e-16,  1.276368300236848e-18, -1.013015096291601e-20,
  8.038786563058983e-23, -6.374699127670515e-25,  1.649780078073182e-01, -1.309431752201770e-03,  1.039297016885284e-05, -8.248908637850240e-08,  6.547165293624004e-10,
 -5.196490162415501e-12,  4.124457642243869e-14, -3.273581300253890e-16,  2.598224495804400e-18, -2.062128123797967e-20,  1.636385208395968e-22, -1.297578407707563e-24,
  2.896951648869221e-01, -2.299312813895098e-03,  1.824966398093978e-05, -1.448477272642650e-07,  1.149657553850430e-09, -9.124840890567622e-12,  7.242392083362741e-14,
 -5.748284721333979e-16,  4.562380775001588e-18, -3.621003159731187e-20,  2.873364896919869e-22, -2.278255789882872e-24,  4.803767034271206e-01, -3.812753692722983e-03,
  3.026185620055551e-05, -2.401885918515983e-07,  1.906378747552604e-09, -1.513094280659467e-11,  1.200943871583375e-13, -9.531886529448064e-16,  7.565394450587813e-18,
 -6.004348270487048e-20,  4.764443578827114e-22, -3.777050486904373e-24  };
  constexpr double w[2304] = {  4.737178111532396e-01, -1.193413125937565e-02,  3.435875622784921e-04, -1.012049382937202e-05,  2.924749750278915e-07,
 -8.216007586900342e-09,  2.242000404808526e-10, -5.958299040126577e-12,  1.544971831933685e-13, -3.918424560323514e-15,  9.727507628235874e-17, -2.368460848681134e-18,
  4.053078035875129e-01, -2.891909904443605e-02,  1.818014205610514e-03, -9.674076713456094e-05,  4.575121547681064e-06, -1.974049077070637e-07,  7.894426106087379e-09,
 -2.957184795214979e-10,  1.045483213327797e-11, -3.508176826224412e-13,  1.122150122535202e-14, -3.430365793849395e-16,  3.023480149814822e-01, -4.680272809330174e-02,
  4.784579173511809e-03, -3.793697725430313e-04,  2.520277571939034e-05, -1.460093787912009e-06,  7.560551925111406e-08, -3.557591307491358e-09,  1.539313942019003e-10,
 -6.178853744512282e-12,  2.316701242343664e-13, -8.149386748481599e-15,  2.007663620936469e-01, -5.128049925652322e-02,  7.535689824899526e-03, -8.049447999897676e-04,
  6.874758882771282e-05, -4.939876651667578e-06,  3.082025175895641e-07, -1.705653352919462e-08,  8.502755998742960e-10, -3.862587428707037e-11,  1.613528377979675e-12,
 -6.235660422114538e-14,  1.162102439908707e-01, -4.016893220040154e-02,  7.562425191049275e-03, -9.928803151828605e-04,  1.009206488620417e-04, -8.410832416465499e-06,
  5.959001367691845e-07, -3.679215122768283e-08,  2.015695652484535e-09, -9.934454674285028e-11,  4.452434825146409e-12, -1.828046706640351e-13,  4.701175541368895e-02,
 -1.891655547970539e-02,  4.078187880439313e-03, -6.007938222942040e-04,  6.732906671277985e-05, -6.096592551102881e-06,  4.635840083230091e-07, -3.040505121924817e-08,
  1.754145788080107e-09, -9.036684208518586e-11,  4.206513147284923e-12, -1.783856768952012e-13,  4.308074670059936e-01, -9.602496062143508e-03,  2.456097206441683e-04,
 -6.511211160327126e-06,  1.708672918515053e-07, -4.386318630743459e-09,  1.097472356733749e-10, -2.684901056594545e-12,  6.415421609282507e-14, -1.506028746801792e-15,
  3.466340507171058e-17, -7.786689876194036e-19,  3.127985632480916e-01, -1.801893734561747e-02,  9.930664130822409e-04, -4.708831347108488e-05,  2.006165724002547e-06,
 -7.866844403637765e-08,  2.880131887936210e-09, -9.938316731309815e-11,  3.254421263942564e-12, -1.016452769747911e-13,  3.039967260693711e-15, -8.726272573481719e-17,
  1.702515115671238e-01, -2.159451806814258e-02,  1.934175262048978e-03, -1.371234997569820e-04,  8.269180972984521e-06, -4.398170899499584e-07,  2.109877818282175e-08,
 -9.267363720815209e-10,  3.767435361739807e-11, -1.428942642766579e-12,  5.088152354548453e-14, -1.707672771582017e-15,  7.405857292954157e-02, -1.645820007820962e-02,
  2.178402245084652e-03, -2.134735397190377e-04,  1.694920057971325e-05, -1.143669517633069e-06,  6.754830647642906e-08, -3.562442429760677e-09,  1.701860478579549e-10,
 -7.444318756822394e-12,  3.006764201149728e-13, -1.127641629230990e-14,  2.770835363581193e-02, -8.936821972787811e-03,  1.588021431005073e-03, -1.987120769600781e-04,
  1.939715242987389e-05, -1.561815235907167e-06,  1.074216074468888e-07, -6.464222121375229e-09,  3.463007249115667e-10, -1.673539077567644e-11,  7.371676095558801e-13,
 -2.980662211324765e-14,  8.195890894906121e-03, -3.234215354630071e-03,  6.848472926956706e-04, -9.933100465721548e-05,  1.098258601201088e-05, -9.828533548482501e-07,
  7.397003478134885e-08, -4.807507691927572e-09,  2.751210184797928e-10, -1.407085620533350e-11,  6.507316678373115e-13, -2.743371061206336e-14,  3.958902434538815e-01,
 -7.909529877044753e-03,  1.813860235793370e-04, -4.357980908542242e-06,  1.044074216209165e-07, -2.464482705754736e-09,  5.674203319943756e-11, -1.286538613217241e-12,
  2.845334906492398e-14, -6.146843839693233e-16,  1.349422315853233e-17, -2.758493050729080e-19,  2.536717626990219e-01, -1.188810966803926e-02,  5.786873007867109e-04,
 -2.459165165408696e-05,  9.476480432891694e-07, -3.386651387130230e-08,  1.137349458560020e-09, -3.619494772890987e-11,  1.098507022444630e-12, -3.193781401186586e-14,
  8.925077721669386e-16, -2.404021985968369e-17,  1.068743731024595e-01, -1.097920698981934e-02,  8.620741625038214e-04, -5.454107772222231e-05,  2.978538153545711e-06,
 -1.450322185907794e-07,  6.425375411806136e-09, -2.625470780301360e-10,  9.991868490818058e-12, -3.567613478659019e-13,  1.201793206888745e-14, -3.833338808866719e-16,
  3.163138660545541e-02, -5.966007972069883e-03,  7.027556553237854e-04, -6.254627786311038e-05,  4.576958871354581e-06, -2.877902561576249e-07,  1.597891938174255e-08,
 -7.979539734771020e-10,  3.631637067592970e-11, -1.521347118392351e-12,  5.911599343406082e-14, -2.141618071486929e-15,  7.445483296045359e-03, -2.192511122955690e-03,
  3.623311593474333e-04, -4.272099813220207e-05,  3.968012656680308e-06, -3.063121617081744e-07,  2.032067798185979e-08, -1.185222905318527e-09,  6.179196383902810e-11,
 -2.915958295929267e-12,  1.257835032783299e-13, -4.992993851865284e-15,  1.494660548367296e-03, -5.743274279197695e-04,  1.187656340425060e-04, -1.688263030283140e-05,
  1.834918193794212e-06, -1.618106796826471e-07,  1.202351299784787e-08, -7.727676833149128e-10,  4.379072681477068e-11, -2.220187444412262e-12,  1.018797171673408e-13,
 -4.265200436483531e-15,  3.668587868090960e-01, -6.642545346943365e-03,  1.376969699180650e-04, -3.018414009491709e-06,  6.627484752253115e-08, -1.449298654274843e-09,
  3.076427575861300e-11, -6.457398406040640e-13,  1.369197167950298e-14, -2.574308887321831e-16,  5.492826485364987e-18, -1.180657271390116e-19,  2.138157331738422e-01,
 -8.224553062455380e-03,  3.562190109653743e-04, -1.364946986048188e-05,  4.779686402124737e-07, -1.561843799363507e-08,  4.824760195055938e-10, -1.418851873294912e-11,
  3.994743649849527e-13, -1.083049002413997e-14,  2.827505794712481e-16, -7.139044954122193e-18,  7.351478747339570e-02, -6.066648767798446e-03,  4.193994765153284e-04,
 -2.368521719016406e-05,  1.170787933986646e-06, -5.212556687792383e-08,  2.129168086455723e-09, -8.076196034266361e-11,  2.870010887049510e-12, -9.621080767552982e-14,
  3.056864126630694e-15, -9.236915123435229e-17,  1.557254805975702e-02, -2.433282855459941e-03,  2.529245960457403e-04, -2.027657724476255e-05,  1.357713090549818e-06,
 -7.902083957437736e-08,  4.098676893680949e-09, -1.926639147948122e-10,  8.306982551285639e-12, -3.315174384348499e-13,  1.233189687828842e-14, -4.295455579488647e-16,
  2.299737397304200e-03, -6.017641788633618e-04,  9.096963517217612e-05, -9.977963611541166e-06,  8.727610038514191e-07, -6.403604510675769e-08,  4.067319573817434e-09,
 -2.284809021282140e-10,  1.152878546111329e-11, -5.287027263325974e-13,  2.224008233629266e-14, -8.634941088930606e-16,  2.893598615683307e-04, -1.071171997483168e-04,
  2.145708437067811e-05, -2.970731863307992e-06,  3.158338097492482e-07, -2.733615773406497e-08,  1.999015467965576e-09, -1.267146462251431e-10,  7.094451679721815e-12,
 -3.558912888780905e-13,  1.617834218150590e-14, -6.716717122904189e-16,  3.422851976319846e-01, -5.669796243636500e-03,  1.069969328579468e-04, -2.155140933953456e-06,
  4.343207975017607e-08, -8.856898403298915e-10,  1.767394617241705e-11, -3.224102338942916e-13,  7.308520724488053e-15, -1.224861045746895e-16,  1.640534536335149e-18,
 -6.366359097461528e-20,  1.857363465593761e-01, -5.920199580133231e-03,  2.297249383523402e-04, -7.984811801565703e-06,  2.553932380898292e-07, -7.656960399968829e-09,
  2.181624353936551e-10, -5.953773769646212e-12,  1.553328934815274e-13, -3.937047792755742e-15,  9.656101893254093e-17, -2.269734572332282e-18,  5.452245973761306e-02,
 -3.594261167154607e-03,  2.204366728102262e-04, -1.113243483350926e-05,  4.987037835391001e-07, -2.030240406299507e-08,  7.641676469417091e-10, -2.689488108360586e-11,
  8.907134329632808e-13, -2.798850725094770e-14,  8.374216855415116e-16, -2.390191895912955e-17,  8.742969708510533e-03, -1.106567936481091e-03,  1.011422544315626e-04,
 -7.259409818176419e-06,  4.424397547395418e-07, -2.370943028925188e-08,  1.142860161325884e-09, -5.031443767131708e-11,  2.044948531844599e-12, -7.737349037800020e-14,
  2.742511931743260e-15, -9.143625190290987e-17,  8.298061198544855e-04, -1.868189572037779e-04,  2.540525599810269e-05, -2.557769696132486e-06,  2.084057464295432e-07,
 -1.439983616994739e-08,  8.687169888987122e-10, -4.667338264008497e-11,  2.265376112522409e-12, -1.004145140560489e-13,  4.099434831184836e-15, -1.550213541938838e-16,
  6.069896408869396e-05, -2.129689887809569e-05,  4.085339323670815e-06, -5.461824975894675e-07,  5.642505355354719e-08, -4.768227684167547e-09,  3.417018532044034e-10,
 -2.128829573010911e-11,  1.174191852834189e-12, -5.814052016230412e-14,  2.612923445637742e-15, -1.073906148325815e-16,  3.211692480032920e-01, -4.906664012572941e-03,
  8.478747201793414e-05, -1.581533809170575e-06,  2.934934638947057e-08, -5.471612650629348e-10,  1.131990109893807e-11, -1.511771122424685e-13,  3.516334558014883e-15,
 -1.005365534297308e-16, -2.156627124844293e-19, -1.812895380770596e-20,  1.652090559793870e-01, -4.406239863372245e-03,  1.541591325078651e-04, -4.887173508986431e-06,
  1.435405357405359e-07, -3.968288462504931e-09,  1.041066303527861e-10, -2.663990678959826e-12,  6.447053587460701e-14, -1.505745314739612e-15,  3.563139244237679e-17,
 -7.792407313485891e-19,  4.298399686411367e-02, -2.254934110219701e-03,  1.239690784847308e-04, -5.613176596748481e-06,  2.284562519478400e-07, -8.520469446117913e-09,
  2.950976215616665e-10, -9.660486689882097e-12,  2.979041366324545e-13, -8.744406486354740e-15,  2.469309251814523e-16, -6.642184638653945e-18,  5.515470367950124e-03,
 -5.538271042991553e-04,  4.463484193721805e-05, -2.856372219741909e-06,  1.579569486285219e-07, -7.766592845424840e-09,  3.464590922437294e-10, -1.423309261869893e-11,
  5.430565803379769e-13, -1.939744539260507e-14,  6.525835560176784e-16, -2.073962445980670e-17,  3.529466072999878e-04, -6.591950727640704e-05,  7.950203772248324e-06,
 -7.252155558069399e-07,  5.446706720705348e-08, -3.511577671225558e-09,  1.995746247023001e-10, -1.018106647641590e-11,  4.722486711237133e-13, -2.011476767421601e-14,
  7.928073039827916e-16, -2.906256021429124e-17,  1.418737944778569e-05, -4.600548320743134e-06,  8.318373523235659e-07, -1.061506871383523e-07,  1.056246173820011e-08,
 -8.654675183676406e-10,  6.044296437012952e-11, -3.684374978091519e-12,  1.994591761721863e-13, -9.718312212464661e-15,  4.306653279518819e-16, -1.748400392207834e-17,
  3.027892815965939e-01, -4.297036987271788e-03,  6.830981566306773e-05, -1.185982953393094e-06,  2.083126630164357e-08, -3.169864450238565e-10,  8.102638620308434e-12,
 -9.867625007338176e-14, -2.777281296269405e-16, -1.055319901047320e-16,  5.286212083966855e-19,  5.903185888569897e-20,  1.497273600491263e-01, -3.373768755053383e-03,
  1.070531914749836e-04, -3.111419603295294e-06,  8.414182278958362e-08, -2.173397706760640e-09,  5.187900043569948e-11, -1.248756716869262e-12,  2.934502400694419e-14,
 -5.897279013680014e-16,  1.345555381953225e-17, -3.184705700291048e-19,  3.559448959571754e-02, -1.481313949666829e-03,  7.395414380006741e-05, -3.012084516058802e-06,
  1.115025233530668e-07, -3.841432184401591e-09,  1.216143973305267e-10, -3.711719334614729e-12,  1.077873602726843e-13, -2.909123088476800e-15,  7.773717507659583e-17,
 -2.004566925821806e-18,  3.845346026773547e-03, -3.003133117925895e-04,  2.155952136750920e-05, -1.226893411011936e-06,  6.144265600139111e-08, -2.771434109971596e-09,
  1.139328446623600e-10, -4.357438114695408e-12,  1.557791484150238e-13, -5.228032011591717e-15,  1.664736070269665e-16, -5.029713038716895e-18,  1.768967337881516e-04,
 -2.634072992842954e-05,  2.795806729004748e-06, -2.283761418393821e-07,  1.566351190557733e-08, -9.345796642266281e-10,  4.964374498338699e-11, -2.387749881684509e-12,
  1.051608195575788e-13, -4.278122282295542e-15,  1.619054770468597e-16, -5.724623227080334e-18,  3.830701272959558e-06, -1.104449438940598e-06,  1.843888317076564e-07,
 -2.212022295057935e-08,  2.095984664592101e-09, -1.650450753174943e-10,  1.115339453200921e-11, -6.613644704778588e-13,  3.497525987201887e-14, -1.670254967509371e-15,
  7.274445163197451e-17, -2.909071833305786e-18,  2.866114004830089e-01, -3.802237598921210e-03,  5.590013305332246e-05, -8.938344702763228e-07,  1.619331294346856e-08,
 -1.598905541183678e-10,  4.710793588446847e-12, -1.575544243403421e-13, -2.827147938920048e-15, -6.895657295804024e-18,  4.840888369841513e-18,  1.120738660510834e-19,
  1.377371131818524e-01, -2.646720876642193e-03,  7.655009457288401e-05, -2.055442646837482e-06,  5.076933650704616e-08, -1.258288408356316e-09,  2.746779655165959e-11,
 -5.695050552945886e-13,  1.493270747863815e-14, -2.782513467228511e-16,  3.212727360112028e-18, -1.618436771577865e-19,  3.065981388949958e-02, -1.008891523740198e-03,
  4.640972111173652e-05, -1.713469668475644e-06,  5.711309012624851e-08, -1.859017160111673e-09,  5.367592880553750e-11, -1.477634299990856e-12,  4.261740405893517e-14,
 -1.058283336806658e-15,  2.419133321298997e-17, -6.812510471266160e-19,  2.914847326633239e-03, -1.734343111344491e-04,  1.129436399638717e-05, -5.718685793919587e-07,
  2.578677854892509e-08, -1.074642875254341e-09,  4.056631321589712e-11, -1.434187544222729e-12,  4.835491342771139e-14, -1.517681637189309e-15,  4.527676617578790e-17,
 -1.312629087375958e-18,  1.034711793315146e-04, -1.176611690360095e-05,  1.102976454268328e-06, -7.991124292757948e-08,  4.962956420200238e-09, -2.725544476489578e-10,
  1.343340514809611e-11, -6.050864960942529e-13,  2.516529172825873e-14, -9.718160681762524e-16,  3.511622458718122e-17, -1.192154776260866e-18,  1.245687422570105e-06,
 -3.013766199706904e-07,  4.538543624142453e-08, -5.022854770730819e-09,  4.469011204314524e-10, -3.344922034991599e-11,  2.167848304111081e-12, -1.241480457667654e-13,
  6.375399301809545e-15, -2.969333172752130e-16,  1.265744903943845e-17, -4.968677077156663e-19,  2.722348589528289e-01, -3.393747290732096e-03,  4.663853021754550e-05,
 -6.558530999495840e-07,  1.372047199964456e-08, -1.086884983713092e-10, -6.939546378349225e-13, -2.075383302991752e-13,  1.166579649762968e-15,  2.307360602767613e-16,
  4.787012903513303e-18, -1.930283807276303e-19,  1.282360559159899e-01, -2.120875362254969e-03,  5.603147168011918e-05, -1.413203842330868e-06,  3.114625934414802e-08,
 -7.450790187104568e-10,  1.681613271448374e-11, -2.380748071021408e-13,  5.979800854376258e-15, -2.385870448787866e-16,  3.782527242442185e-19,  5.665113315727796e-20,
  2.725528503783832e-02, -7.067564743640649e-04,  3.029808474171455e-05, -1.038799475096480e-06,  3.013100878339282e-08, -9.429406500857237e-10,  2.671524309370490e-11,
 -5.840679565147907e-13,  1.639585833094576e-14, -5.098497438570166e-16,  7.181206802479815e-18, -1.313673636822008e-19,  2.366469657508793e-03, -1.048617993131327e-04,
  6.338626674871511e-06, -2.893750238435510e-07,  1.150440970020228e-08, -4.484025369125787e-10,  1.581880056507523e-11, -5.000855785604842e-13,  1.597573764205491e-14,
 -4.894996682342605e-16,  1.293164289493463e-17, -3.523014410254373e-19,  6.945566160717313e-05, -5.751739370426843e-06,  4.848001355689541e-07, -3.105440740127898e-08,
  1.725216270145373e-09, -8.715073667811356e-11,  3.971384464496509e-12, -1.658992052216613e-13,  6.495752583992605e-15, -2.374679093168041e-16,  8.113027211910609e-18,
 -2.635978910931406e-19,  5.067597403297074e-07, -9.484671550460516e-08,  1.264336333223645e-08, -1.263609367568278e-09,  1.038441717298568e-10, -7.297278490416616e-12,
  4.487786072257915e-13, -2.460238982023507e-14,  1.218186344913212e-15, -5.499817355810891e-17,  2.282651665461690e-18, -8.759031999051700e-20,  2.593612737194205e-01,
 -3.048568246206821e-03,  4.000580952455263e-05, -4.564135251796794e-07,  1.096686248340930e-08, -1.824262201371338e-10, -4.606646060472769e-12, -2.496056581029050e-14,
  9.703934262968469e-15,  1.335121955395543e-16, -1.112997698492952e-17, -3.642272394861373e-19,  1.205522887647416e-01, -1.732985662982004e-03,  4.163687237347051e-05,
 -1.014124671288439e-06,  1.981967121529202e-08, -4.074944429737267e-10,  1.160740359328936e-11, -1.722825036243562e-13, -1.146548655041923e-15, -1.143965991864091e-16,
  6.487749335090884e-18,  1.338854773634292e-19,  2.484401617432131e-02, -5.072694472825189e-04,  2.020250989773624e-05, -6.774298821270095e-07,  1.660033980335393e-08,
 -4.538564308228805e-10,  1.531269139019084e-11, -3.018540072039044e-13,  2.862318103850957e-15, -2.299874405936327e-16,  8.578840927382455e-18,  9.814980088759221e-20,
  2.030111363043546e-03, -6.548118878779427e-05,  3.730522409350614e-06, -1.603211595261781e-07,  5.439120791397173e-09, -1.923386189938097e-10,  6.896516092279774e-12,
 -1.941376903088919e-13,  4.983274773181523e-15, -1.722585668885669e-16,  4.942039556043562e-18, -7.272198305048181e-20,  5.236772373813750e-05, -2.999933924516077e-06,
  2.335420228013354e-07, -1.345606728580301e-08,  6.536022493531416e-10, -3.020774396992291e-11,  1.293645166417605e-12, -4.945128330729668e-14,  1.785412340165484e-15,
 -6.301685821102693e-17,  2.039525749053403e-18, -6.046006059404025e-20,  2.625622240693599e-07, -3.430404582680802e-08,  4.038384452835532e-09, -3.578792718727419e-10,
  2.661875051487387e-11, -1.734860360371798e-12,  1.002056509924096e-13, -5.199741395400283e-15,  2.461405516688289e-16, -1.070884653651075e-17,  4.298202725974323e-19,
 -1.602157384775044e-20,  2.477762045111621e-01, -2.747761472070195e-03,  3.544273082539883e-05, -3.157233237439676e-07,  6.343270866561500e-09, -2.654680375918062e-10,
 -9.690668911946146e-13,  2.579837739943593e-13,  4.667961742312530e-15, -3.959974138279708e-16, -8.279226203231820e-18,  5.437246951307904e-19,  1.142163701856218e-01,
 -1.443707327863723e-03,  3.114541930698417e-05, -7.488172864248619e-07,  1.403438350011010e-08, -1.927854766907085e-10,  6.045541851758165e-12, -2.193294643631857e-13,
 -1.315883992079581e-16,  1.530561362740270e-16,  3.767566857097238e-18, -2.651404152531879e-19,  2.309230548475417e-02, -3.742246189677660e-04,  1.342455132758646e-05,
 -4.672347096771171e-07,  1.054376274815761e-08, -1.825737321906001e-10,  7.398463016883245e-12, -2.725798910772908e-13,  1.062650466965100e-15,  1.110922410055235e-16,
  5.536842463627100e-18, -2.759192733203051e-19,  1.817457458673088e-03, -4.209498769871595e-05,  2.226606835838377e-06, -9.666141007931990e-08,  2.880555163567892e-09,
 -7.853193744632726e-11,  3.002188946945180e-12, -1.009669476622965e-13,  1.706881251199012e-15, -2.650884905326763e-17,  2.296491097481403e-18, -7.303887239154258e-20,
  4.328387135123121e-05, -1.636609446715719e-06,  1.192864833699913e-07, -6.521561156671125e-09,  2.739416823187197e-10, -1.095848730297513e-11,  4.560613805830107e-13,
 -1.686538418728915e-14,  5.203522727198205e-16, -1.651778879480567e-17,  5.902576512047296e-19, -1.696337152986836e-20,  1.703383190652485e-07, -1.391655221221203e-08,
  1.472755268320077e-09, -1.159970976534594e-10,  7.609058156237292e-12, -4.516722255254370e-13,  2.443440915350779e-14, -1.189926428541136e-15,  5.292580177280909e-17,
 -2.202939964503747e-18,  8.573792530462862e-20, -3.072727426225712e-21,  2.373301564225305e-01, -2.478047897033248e-03,  3.209075019237944e-05, -2.553908071662063e-07,
  1.413609911202166e-09, -1.993261806830191e-10,  6.051295426472170e-12,  1.680748260842295e-13, -9.071097108905556e-15, -2.023648534037209e-16,  1.517843280404437e-17,
  1.897546396301498e-19,  1.088880124530872e-01, -1.226921823427829e-03,  2.339963865633948e-05, -5.492554075277925e-07,  1.115314235996446e-08, -1.163396695907808e-10,
  7.388328166519895e-13, -1.307841810808470e-13,  5.108675604193933e-15,  6.549704876153684e-17, -6.592281455465557e-18, -6.752658053772489e-20,  2.177843673043099e-02,
 -2.866148092950780e-04,  8.733888435309266e-06, -3.205673325581572e-07,  8.088722330447926e-09, -8.818340500450335e-11,  9.950312099035343e-13, -1.583896795324516e-13,
  5.784140794719654e-15,  6.737991303193200e-17, -6.438440730720931e-18, -1.108646100698567e-19,  1.678332434774716e-03, -2.823664851960828e-05,  1.301679807972666e-06,
 -6.007930708253803e-08,  1.831387479353531e-09, -3.464369977649545e-11,  8.844216485939023e-13, -5.049984102724687e-14,  1.595461090254620e-15, -5.060986469077834e-19,
 -7.281667344407291e-19, -3.665419478210817e-20,  3.823764647951593e-05, -9.343134266730621e-07,  6.165012507831879e-08, -3.429548000727756e-09,  1.338587209172912e-10,
 -4.216414717544596e-12,  1.527549639720862e-13, -6.398296092419857e-15,  2.053707959237510e-16, -4.175082724430916e-18,  1.038827635676900e-19, -5.991382178278027e-21,
  1.316428461226817e-07, -6.157166497665000e-09,  5.920417966628509e-10, -4.329135458685890e-11,  2.488173574386409e-12, -1.285434334372333e-13,  6.431204165649801e-15,
 -3.008182345987211e-16,  1.251907676592478e-17, -4.747530491096901e-19,  1.763108039299114e-20, -6.419158592493008e-22,  2.279122217247746e-01, -2.233442485144294e-03,
  2.905862040995616e-05, -2.558086844196378e-07, -9.219856595006492e-10, -3.291914377868785e-11,  6.433939512956826e-12, -1.241479024836592e-13, -6.211265277002007e-15,
  2.798571396895597e-16,  3.915963109566646e-18, -4.686391285401758e-19,  1.043170276324630e-01, -1.063230685806649e-03,  1.780303474413122e-05, -3.893588128740285e-07,
  8.805131658214504e-09, -1.237079474602240e-10, -6.357372675350740e-13,  2.184007677706560e-14,  3.200543812381537e-15, -1.335870050751756e-16, -1.333397354595741e-18,
  2.004111186759892e-19,  2.075028930276180e-02, -2.300623239926864e-04,  5.606411542654847e-06, -2.050806291399655e-07,  6.315513736529096e-09, -9.620485700072975e-11,
 -8.478687384254268e-13,  1.542467078571278e-14,  3.756374205532340e-15, -1.454649033917965e-16, -1.699596864783207e-18,  2.173758526470700e-19,  1.582287537910703e-03,
 -2.025601818016817e-05,  7.363433419408248e-07, -3.554634615658615e-08,  1.265106705870180e-09, -2.487644845222065e-11,  1.335783896482663e-13, -6.605391198279664e-15,
  9.489623597919156e-16, -3.174865744483881e-17, -2.636129562467053e-19,  3.793941156048504e-20,  3.527042073935690e-05, -5.746896595026896e-07,  3.107065150081526e-08,
 -1.812371358438858e-09,  7.500113229084825e-11, -2.077427803404714e-12,  4.654993606820964e-14, -1.782986527881742e-15,  9.049576181510696e-17, -2.727583135797568e-18,
  1.908797368215958e-20,  7.762200703286639e-22,  1.139491166623251e-07, -2.974426425502873e-09,  2.475105017035470e-10, -1.787404847235374e-11,  9.595975922608609e-13,
 -4.202285395584540e-14,  1.768798805748512e-15, -7.875813100165871e-17,  3.369855764007741e-18, -1.218955618187930e-19,  3.725677241849267e-21, -1.165421965656127e-22,
  2.194235882921931e-01, -2.013505729948960e-03,  2.590192153972246e-05, -2.689010920778864e-07, -3.933650695900925e-10,  6.681228109514471e-11,  1.699260952170660e-12,
 -1.658771683650595e-13,  2.680846015664480e-15,  1.396124776789371e-16, -7.175587960087148e-18,  8.840814379123192e-21,  1.003224906815376e-01, -9.372923794462728e-04,
  1.389263274882734e-05, -2.687402863668333e-07,  6.268784460621694e-09, -1.244865705859398e-10,  6.999838926687777e-13,  5.145948133088769e-14, -8.950141527443607e-16,
 -6.365203673415717e-17,  3.191537117834745e-18, -8.936891831151162e-21,  1.990638159088248e-02, -1.934889950784818e-04,  3.685508159332201e-06, -1.202027599328162e-07,
  4.272240265527043e-09, -1.026757293958617e-10,  4.823521231662940e-13,  5.480962698252906e-14, -8.297133757565374e-16, -7.416959317664876e-17,  3.517195597712351e-18,
 -4.235206035389811e-21,  1.510780672683934e-03, -1.576417651848120e-05,  4.153302073284109e-07, -1.912546183587847e-08,  7.978892199859831e-10, -2.151187502484922e-11,
  2.047838321071749e-13,  6.350832632876161e-15, -4.271020540396518e-17, -1.674109080502740e-17,  7.069780107673594e-19, -4.800866560132763e-22,  3.335610756726442e-05,
 -3.955454819036278e-07,  1.531321884544801e-08, -8.962224648109862e-10,  4.191224132871329e-11, -1.315636954308452e-12,  2.390154956507849e-14, -2.350111805480335e-16,
  1.510672729353229e-17, -1.273464205609910e-18,  4.479318944736580e-20, -2.173427967201808e-22,  1.049526401275525e-07, -1.643161693863054e-09,  1.032626926656089e-10,
 -7.511608490078854e-12,  4.139031958992020e-13, -1.706989470998106e-14,  5.745154617101942e-16, -1.965977363249074e-17,  8.239830117296590e-19, -3.537272314617914e-20,
  1.202581850121062e-21, -2.820937885983743e-23,  2.117635520671767e-01, -1.819195636776916e-03,  2.268481645057182e-05, -2.636529277717004e-07,  1.037481234267978e-09,
  6.434808048876662e-11, -1.350311243836738e-12, -4.867249143989963e-14,  3.436804357599573e-15, -6.054210408078460e-17, -1.975074959424882e-18,  1.349774856059721e-19,
  9.677734684159439e-02, -8.375269043922413e-04,  1.119150403212935e-05, -1.870320730805862e-07,  4.041058726941235e-09, -9.493426166912324e-11,  1.554773856826100e-12,
  7.723668216863961e-15, -1.310244153235441e-15,  2.406991845578577e-17,  8.638356164657847e-19, -5.812569238515123e-20,  1.918370105899680e-02, -1.687623039775717e-04,
  2.588726822181288e-06, -6.720074184686381e-08,  2.436169839102523e-09, -7.724267029288251e-11,  1.421485092078383e-12,  9.617041028586576e-15, -1.398298742788618e-15,
  2.472206326479964e-17,  1.010882674151226e-18, -6.535122515376156e-20,  1.453181510090299e-03, -1.317322451952809e-05,  2.492358634404231e-07, -9.481711888244836e-09,
  4.287180186532667e-10, -1.499102520456777e-11,  3.087909959574663e-13,  2.205330329044719e-16, -2.181914584780146e-16,  3.520054072289453e-18,  2.200362233707857e-19,
 -1.298189295782848e-20,  3.196452648764751e-05, -3.064642015429649e-07,  7.810065158801774e-09, -4.066434244569318e-10,  2.094756664690518e-11, -7.972670642571109e-13,
  1.943277270804817e-14, -1.816949360199418e-16, -4.169151177130973e-18, -6.051661161967763e-21,  1.503766918251809e-20, -7.288225068055066e-22,  9.959125124434408e-08,
 -1.086869701717677e-09,  4.360923894567889e-11, -3.016971813679921e-12,  1.772400241416904e-13, -7.806166374172406e-15,  2.555437855315489e-16, -6.478131996547702e-18,
  1.666623107752228e-19, -6.852462323941498e-21,  3.348022539315029e-22, -1.243942961383826e-23,  2.048302000550408e-01, -1.650005374332588e-03,  1.965655446371869e-05,
 -2.387872396545507e-07,  1.944487775529598e-09,  2.570349349707821e-11, -1.553075815144421e-12,  2.063503597469772e-14,  9.332588763004947e-16, -5.771593569581060e-17,
  1.201310926512000e-18,  1.454972306961046e-20,  9.359346704211345e-02, -7.560043124627201e-04,  9.278992703801917e-06, -1.355371742944150e-07,  2.512467245087818e-09,
 -5.882999137958412e-11,  1.337488368365951e-12, -1.772892094789613e-14, -2.931418306819017e-16,  2.350514176297647e-17, -4.993786150498405e-19, -6.340357098535477e-21,
  1.854576024475549e-02, -1.507207255109173e-04,  1.971272232303565e-06, -3.871435809876800e-08,  1.232264374997934e-09, -4.397106119786601e-11,  1.226228582946912e-12,
 -1.767163063344197e-14, -3.138358038773189e-16,  2.535783304948744e-17, -5.391835716469624e-19, -7.478588778989777e-21,  1.403893608527130e-03, -1.153805949664797e-05,
  1.679981764216974e-07, -4.628319031006783e-09,  2.000693718919561e-10, -8.141137647585876e-12,  2.428812529751351e-13, -3.951917498629334e-15, -3.976481953319010e-17,
  4.338062254109288e-18, -9.283749482488477e-20, -1.645960747000666e-21,  3.083936766966282e-05, -2.588616419035251e-07,  4.491874733829635e-09, -1.756785333362438e-10,
  9.185933523894793e-12, -4.044084689596251e-13,  1.296312802309685e-14, -2.541412522459697e-16,  4.156850893509172e-19,  1.428847392422472e-19, -2.925662328139123e-21,
 -1.141686343343202e-22,  9.576704402588889e-08, -8.445715755882564e-10,  2.020067069159378e-11, -1.149912545136080e-12,  7.016541357049782e-14, -3.405008609581562e-15,
  1.250578263881286e-16, -3.357492536487552e-18,  6.205348012661857e-20, -8.958784174352580e-22,  3.584964594037542e-23, -2.510451753866138e-24,  1.985273186122108e-01,
 -1.503658767087818e-03,  1.698881854571975e-05, -2.053521642540258e-07,  2.143155618389880e-09, -2.841617956269080e-12, -8.019052676026822e-13,  2.665701336908835e-14,
 -2.875261655835264e-16, -1.324176588919528e-17,  7.890630983039026e-19, -1.899793663168246e-20,  9.070847293793444e-02, -6.876737393704881e-04,  7.860077186375155e-06,
 -1.031856450884115e-07,  1.613977377795807e-09, -3.310728045337132e-11,  8.087501394205483e-13, -1.749299120837221e-14,  1.953079969932301e-16,  4.925441063175463e-18,
 -3.299004977374339e-19,  7.989555185225637e-21,  1.797187248648245e-02, -1.365309935916910e-04,  1.600667699874804e-06, -2.461385869895081e-08,  6.042114523548939e-10,
 -2.092466929861081e-11,  6.974246554334551e-13, -1.737065898328376e-14,  2.100215491283886e-16,  5.138810557467713e-18, -3.583180684539323e-19,  8.823295923485418e-21,
  1.360140459267155e-03, -1.037232304792533e-05,  1.272122614982353e-07, -2.451700025339799e-09,  8.634604114882613e-11, -3.666334909395581e-12,  1.325101786981548e-13,
 -3.475982921956524e-15,  4.771257756041867e-17,  7.536590957215738e-19, -6.366214541622323e-20,  1.616596880067303e-21,  2.986528053585123e-05, -2.293772349788877e-07,
  3.046997589443528e-09, -7.884562438468284e-11,  3.657072291287905e-12, -1.733658161205400e-13,  6.618336322791399e-15, -1.851321860392674e-16,  3.083678657723113e-18,
  1.064325136507670e-20, -2.430963194857678e-21,  6.583456257008381e-23,  9.264585431235321e-08, -7.233365550447428e-10,  1.134022269444607e-11, -4.372349986844814e-13,
  2.552073655780052e-14, -1.331117488379596e-15,  5.510934700444305e-17, -1.750621836079769e-18,  4.009542497005475e-20, -5.379074363480442e-22, -9.742179545386951e-26,
  4.473623766144438e-26,  1.927697080248106e-01, -1.377032127238299e-03,  1.472571258857223e-05, -1.723307604917916e-07,  1.947749537277246e-09, -1.443161137862416e-11,
 -2.215072657405146e-13,  1.439818677332595e-14, -3.789120734453284e-16,  3.871691078542714e-18,  1.453724814997012e-19, -8.868016092119602e-21,  8.807625821679552e-02,
 -6.293512726038850e-04,  6.757935210582128e-06, -8.175705445487760e-08,  1.110324020327576e-09, -1.877962660757929e-11,  4.187147160031198e-13, -1.031140356356483e-14,
  2.121610336801098e-16, -2.175764595242788e-18, -5.808806774333743e-20,  3.758470273952379e-21,  1.744968514002728e-02, -1.247694290957891e-04,  1.352025471459308e-06,
 -1.753532428657519e-08,  3.180516476363664e-10, -9.173577641698417e-12,  3.173872444230533e-13, -9.748493056775179e-15,  2.220154804114022e-16, -2.478197855312785e-18,
 -5.941905892974242e-20,  4.087580657572010e-21,  1.320527273213518e-03, -9.453421658917171e-06,  1.041384806328593e-07, -1.513796102182354e-09,  3.788298741010143e-11,
 -1.470697056694987e-12,  5.789650012683933e-14, -1.876672142545687e-15,  4.459987550170454e-17, -5.614231015308746e-19, -8.968392723513208e-21,  7.368460406331830e-22,
  2.899164911066308e-05, -2.080065028064864e-07,  2.361129383622844e-09, -4.100350111355360e-11,  1.415403594822681e-12, -6.576064726476898e-14,  2.771424982013791e-15,
 -9.372939891085354e-17,  2.360917290289242e-18, -3.566657879461462e-20, -1.718641334146377e-22,  2.964561846294642e-23,  8.990835311961806e-08, -6.482897656692979e-10,
  7.857882026832438e-12, -1.843048019928504e-13,  8.828122989450682e-15, -4.694363834156547e-16,  2.118682514840988e-17, -7.693902800058489e-19,  2.179010459532254e-20,
 -4.446146578622556e-22,  4.662328770996204e-24,  6.371121923581824e-26,  1.874848111487210e-01, -1.266991740835233e-03,  1.283458624503529e-05, -1.436503346757420e-07,
  1.632171234585232e-09, -1.612674362405653e-11,  3.731448164237683e-14,  5.040510599484951e-15, -2.024104092569692e-16,  4.682265094995582e-18, -4.948814662838781e-20,
 -1.249921066749054e-21,  8.566115922051365e-02, -5.789355539343018e-04,  5.872578528684415e-06, -6.653599905991133e-08,  8.154577089990658e-10, -1.150976119934839e-11,
  2.115674932671109e-13, -4.976002748105455e-15,  1.206421375571984e-16, -2.378512918669353e-18,  2.441900628331733e-20,  5.213644205546223e-22,  1.697101378502518e-02,
 -1.147200718654024e-04,  1.167199294734240e-06, -1.357991800036391e-08,  1.924063281730511e-10, -4.120684741283128e-12,  1.288286783809124e-13, -4.262213293383811e-15,
  1.209128024978854e-16, -2.573240139215830e-18,  2.872350738177423e-20,  5.169504167589366e-22,  1.284276876275190e-03, -8.684494605696813e-06,  8.884120661047390e-08,
 -1.082700252079118e-09,  1.885731918936639e-11, -5.703472417430166e-13,  2.208747192948795e-14, -7.943273538978351e-16,  2.342248178867932e-17, -5.168330342194783e-19,
  6.395970890402341e-21,  7.566258518558811e-23,  2.819472148957850e-05, -1.907809819736184e-07,  1.971168927805308e-09, -2.601876753148274e-11,  5.918332725171703e-13,
 -2.338610705380838e-14,  1.013568110397389e-15, -3.818236750756501e-17,  1.166303048377760e-18, -2.711785057898012e-20,  3.928943168428979e-22,  1.215848925257386e-24,
  8.742955014917456e-08, -5.924373634274482e-10,  6.256402033680232e-12, -9.662009040273345e-14,  3.128685063586256e-15, -1.540923574393975e-16,  7.274662340886195e-18,
 -2.893936744470164e-19,  9.421430632922085e-21, -2.436012853555988e-22,  4.602774630949608e-24, -4.352613668988697e-26,  1.826118752082622e-01, -1.170790321651461e-03,
  1.125708810325270e-05, -1.200305515146934e-07,  1.326846805158554e-09, -1.412901391281847e-11,  1.100380475198936e-13,  8.250795081328495e-16, -7.484135001243276e-17,
  2.409325818182097e-18, -5.134343720516151e-20,  5.798770415075376e-22,  8.343461360066430e-02, -5.349427582114560e-04,  5.145615089783003e-06, -5.509481791337223e-08,
  6.266987111211017e-10, -7.739557974759203e-12,  1.149003512574447e-13, -2.275390271597131e-15,  5.474081616774060e-17, -1.288974105260760e-18,  2.454516834228558e-20,
 -2.651884856403073e-22,  1.652984340178212e-02, -1.059873241111991e-04,  1.020441649097324e-06, -1.102645685105660e-08,  1.331721813718265e-10, -2.100735051382183e-12,
  5.144066083445917e-14, -1.634022865478833e-15,  5.080112168409508e-17, -1.340455367541410e-18,  2.709648734202278e-20, -3.154761019827189e-22,  1.250884366649186e-03,
 -8.021317241181129e-06,  7.735853645052892e-08, -8.496770229411450e-10,  1.132128796346709e-11, -2.377990588622365e-13,  7.909482225014093e-15, -2.910900594286659e-16,
  9.575987027269509e-18, -2.602715360287780e-19,  5.427559864075880e-21, -6.866389235039142e-23,  2.746134817637216e-05, -1.761280460506492e-07,  1.703772578114205e-09,
 -1.926763149235631e-11,  2.991308410471451e-13, -8.466894296199989e-15,  3.415315909220756e-16, -1.351979132838160e-17,  4.603509857543694e-19, -1.289886619877946e-20,
  2.818235212620229e-22, -4.054967810072357e-24,  8.515351615543379e-08, -5.463570117263246e-10,  5.320086895288444e-12, -6.396394794205953e-14,  1.282397323075457e-15,
 -4.960245245870647e-17,  2.303664085117283e-18, -9.682006900982124e-20,  3.452240806948799e-21, -1.024506208814978e-22,  2.461019049488706e-24, -4.428300169088092e-26,
  1.781001874060741e-01, -1.086154702435524e-03,  9.935250149735023e-06, -1.009142718333264e-07,  1.071440975299672e-09, -1.141422372356079e-11,  1.101305083924542e-13,
 -5.255132444839169e-16, -1.854563503702432e-17,  8.946628114552322e-19, -2.510918925222340e-20,  5.051247264065303e-22,  8.137321145561580e-02, -4.962628121934937e-04,
  4.539965894304880e-06, -4.617472553558557e-08,  4.951868614061293e-10, -5.585234498150573e-12,  6.994885740343983e-14, -1.100783712305115e-15,  2.303353532426762e-17,
 -5.530676280686306e-19,  1.256391840155738e-20, -2.324536039114948e-22,  1.612143055795135e-02, -9.831966090811853e-05,  8.997038397167637e-07, -9.177495031247772e-09,
  1.005824292844591e-10, -1.269300436946905e-12,  2.252075193208220e-14, -5.994482894432501e-16,  1.859537701711467e-17, -5.408383786865610e-19,  1.337374469196914e-20,
 -2.595862230313369e-22,  1.219976199882995e-03, -7.440460073143853e-06,  6.811943141859062e-08, -6.985158449791277e-10,  7.950585747926259e-12, -1.184586839258037e-13,
  2.904563622841276e-15, -9.862451645407575e-17,  3.386257305221855e-18, -1.025460719297608e-19,  2.596846918584756e-21, -5.177884445279384e-23,  2.678273290262783e-05,
 -1.633518586774328e-07,  1.496841879510439e-09, -1.549444229997312e-11,  1.881359195079948e-13, -3.507885480459611e-15,  1.129524703201610e-16, -4.378999013118564e-18,
  1.580692673277481e-19, -4.919474726855730e-21,  1.279654306721087e-22, -2.658698139402057e-24,  8.304876121074014e-08, -5.065774501947203e-10,  4.650561765009999e-12,
 -4.911281935255143e-14,  6.758840734674158e-16, -1.717869247142086e-17,  7.001164595060760e-19, -2.978538990009418e-20,  1.125444681377894e-21, -3.646778389086222e-23,
  9.990881220115993e-25, -2.256908768335653e-26,  1.739072528138281e-01, -1.011241599534966e-03,  8.820053160380383e-06, -8.545977025637100e-08,  8.681536126333996e-10,
 -8.990915090717677e-12,  9.079379491157875e-14, -7.592151561672489e-16,  1.524432039424947e-19,  2.490274387023090e-19, -9.176335055003291e-21,  2.333414022843502e-22,
  7.945747003040679e-02, -4.620327246541627e-04,  4.029990857024126e-06, -3.906334615889455e-08,  3.981368585541475e-10, -4.208418442703029e-12,  4.703965964835962e-14,
 -6.029987579711987e-16,  1.005155436660380e-17, -2.171979360370838e-19,  5.118735422252395e-21, -1.118586740343372e-22,  1.574188597692926e-02, -9.153695419181044e-05,
  7.984740838732561e-07, -7.746592388338494e-09,  7.952482643084466e-11, -8.777787050332021e-13,  1.175983601183648e-14, -2.323310069354610e-16,  6.407702903392817e-18,
 -1.901837664980354e-19,  5.180533702175134e-21, -1.208200155887703e-22,  1.191254025146167e-03, -6.927030171907148e-06,  6.043246588410628e-08, -5.872283730708597e-10,
  6.105919641867568e-12, -7.243653707197565e-14,  1.225029710647120e-15, -3.317890075138608e-17,  1.099858690245359e-18, -3.507593257215484e-20,  9.848874656762093e-22,
 -2.342886805979794e-23,  2.615216357012467e-05, -1.520742304917639e-07,  1.327038423530021e-09, -1.293143392242726e-11,  1.375268893241656e-13, -1.830199768671486e-15,
  4.040262586529108e-17, -1.364363268494988e-18,  4.956392563428731e-20, -1.639471098872426e-21,  4.709290482335837e-23, -1.147310902719621e-24,  8.109335899172375e-08,
 -4.715678682136343e-10,  4.117084541511700e-12, -4.035782408886529e-14,  4.495355379834563e-16, -7.293911378789652e-18,  2.181970700777854e-19, -8.705494807647080e-21,
  3.374766451892033e-22, -1.158541386840307e-23,  3.449646929203791e-25, -8.806207686279722e-27,  1.699972286025093e-01, -9.445600379685417e-04,  7.872308636340047e-06,
 -7.289659684024919e-08,  7.084341128322685e-10, -7.060224740687187e-12,  7.054623676034349e-14, -6.650267848025819e-16,  4.483198424199294e-18,  3.408049616378720e-20,
 -2.658389392069790e-21,  8.314045771734108e-23,  7.767099509216326e-02, -4.315655695921353e-04,  3.596858692675526e-06, -3.331033064199285e-08,  3.240520533295292e-10,
 -3.251749419553466e-12,  3.371687789836823e-14, -3.750438419862965e-16,  4.958401560927576e-18, -8.680157745050743e-20,  1.896883445334377e-21, -4.341265031005468e-23,
  1.538795389678892e-02, -8.550061132840682e-05,  7.126145063007429e-07, -6.601168667554935e-09,  6.436206031846344e-11, -6.555572723726803e-13,  7.329338712532341e-15,
 -1.055342206611693e-16,  2.263003925722818e-18, -6.242106242232136e-20,  1.756769230406893e-21, -4.494651546042630e-23,  1.164470405521569e-03, -6.470197643972503e-06,
  5.392854140518492e-08, -4.997830030289260e-10,  4.892397112069088e-12, -5.114533524766820e-14,  6.431321887958982e-16, -1.226432145298968e-17,  3.477564967598101e-19,
 -1.100220048080184e-20,  3.263844026129023e-22, -8.551503370888611e-24,  2.556416598225574e-05, -1.420437177037433e-07,  1.183997499509945e-09, -1.098150295509896e-11,
  1.082603814996085e-13, -1.183400893700227e-15,  1.763684450988477e-17, -4.409265945779824e-19,  1.479558924772019e-20, -4.995980312566855e-22,  1.524390398561992e-23,
 -4.072677559579139e-25,  7.927005359741929e-08, -4.404556688899620e-10,  3.671871017045286e-12, -3.411280543099299e-14,  3.412459432425374e-16, -4.068228227549544e-18,
  7.821676335625107e-20, -2.536924398070856e-21,  9.573295563709345e-23, -3.392575877150951e-24,  1.068278197572052e-25, -2.947870009395653e-27,  1.663396638534577e-01,
 -8.848980755368294e-04,  7.061180810969692e-06, -6.260532555949876e-08,  5.827388463568112e-10, -5.573802578021620e-12,  5.400647824366310e-14, -5.167083207636796e-16,
  4.469668460735979e-18, -2.095164632773645e-20, -5.154163306871059e-22,  2.432063467628272e-23,  7.599986922686969e-02, -4.043061273032713e-04,  3.226230936891060e-06,
 -2.860509121608683e-08,  2.663405719852577e-10, -2.553073228307209e-12,  2.505331829787829e-14, -2.548039261826577e-16,  2.836840797111991e-18, -3.881845351444838e-20,
  7.043020448011109e-22, -1.530544455072990e-23,  1.505687506880694e-02, -8.009998371624151e-05,  6.391750909600257e-07, -5.667587369726607e-09,  5.280558201051894e-11,
 -5.086032153422225e-13,  5.128263325650600e-15, -5.866161060080021e-17,  9.101884459409823e-19, -2.054347932770411e-20,  5.540622869245408e-22, -1.473638431094460e-23,
  1.139416270534935e-03, -6.061500958861132e-06,  4.836950291755233e-08, -4.289473202774470e-10,  4.001249636608999e-12, -3.886496263970552e-14,  4.103769577807945e-16,
 -5.551319159736646e-18,  1.164530474833253e-19, -3.321312644890090e-21,  9.930558024308987e-23, -2.748981095398187e-24,  2.501413984438452e-05, -1.330710699361415e-07,
  1.061896369267302e-09, -9.419095161948085e-12,  8.804406720042304e-14, -8.679181930982674e-16,  9.885107084176233e-18, -1.659031994006329e-19,  4.457275824277559e-21,
 -1.442397795656707e-22,  4.525362767248740e-24, -1.281424276417785e-25,  7.756451188427900e-08, -4.126309164384931e-10,  3.292868669063139e-12, -2.922091476630774e-14,
  2.742998000070890e-16, -2.785950511802664e-18,  3.637248108325323e-20, -8.064759464200822e-22,  2.665170383892077e-23, -9.386893200271889e-25,  3.058799983842456e-26,
 -8.902412923864950e-28,  1.629085055893054e-01, -8.312632176217890e-04,  6.362396484906622e-06, -5.410752624001156e-08,  4.831326489161640e-10, -4.435895230436818e-12,
  4.140904006448155e-14, -3.881066581113829e-16,  3.532467025786215e-18, -2.744809520657609e-20,  5.534763911391966e-23,  5.362279869381600e-24,  7.443218783765124e-02,
 -3.798005593162753e-04,  2.906953117735569e-06, -2.472172028916915e-08,  2.207621603543244e-10, -2.028274571915265e-12,  1.901196985114486e-14, -1.820239065281849e-16,
  1.819697588311873e-18, -2.038884701508835e-20,  2.884700529806056e-22, -5.344367497547155e-24,  1.474629050846340e-02, -7.524499625274600e-05,  5.759179622137666e-07,
 -4.897894028411633e-09,  4.374583606210803e-11, -4.025009839894500e-13,  3.806731649373158e-15, -3.810849965657104e-17,  4.503025134019666e-19, -7.473445505661572e-21,
  1.726555730680311e-22, -4.491511511069897e-24,  1.115913041435627e-03, -5.694101900834912e-06,  4.358220881133887e-08, -3.706570471796899e-10,  3.311641549358366e-12,
 -3.054808130447918e-14,  2.934707199515504e-16, -3.160220475845891e-18,  4.625603666684475e-20, -1.033670522426580e-21,  2.890020656061376e-23, -8.136137969942651e-25,
  2.449816222205209e-05, -1.250053098972314e-07,  9.567846561098595e-10, -8.137707299106123e-12,  7.274859410370735e-14, -6.740804588641631e-16,  6.652562198921168e-18,
 -8.019385169240114e-20,  1.495770706572425e-21, -4.131314401483702e-23,  1.270633958486126e-24, -3.711839619008069e-26,  7.596455342448494e-08, -3.876199201933333e-10,
  2.966847848380401e-12, -2.523671407831879e-14,  2.258722034049824e-16, -2.111986303486615e-18,  2.197119090327091e-20, -3.187811315227231e-22,  7.797702770096716e-24,
 -2.526702983048393e-25,  8.279157310484735e-27, -2.494736820243910e-28,  1.596813159446010e-01, -7.828362041149985e-04,  5.756724557961655e-06, -4.703662614312732e-08,
  4.035349131095951e-10, -3.560597625381584e-12,  3.198109197482598e-14, -2.901233198920770e-16,  2.621366104955285e-18, -2.255632659154842e-20,  1.529903792608567e-22,
  2.467248223588580e-25,  7.295769890048065e-02, -3.576744596989776e-04,  2.630222819646128e-06, -2.149088051542835e-08,  1.843780977841253e-10, -1.627175741465396e-12,
  1.463379867808533e-14, -1.336898931777194e-16,  1.248621536403019e-18, -1.230675852650175e-20,  1.393262484614290e-22, -2.027768276424958e-24,  1.445416900125016e-02,
 -7.086143384384865e-05,  5.210923362335528e-07, -4.257733110263113e-09,  3.653050940211276e-11, -3.225245892527361e-13,  2.908642722147906e-15, -2.697846594622878e-17,
  2.695273823425183e-19, -3.310454793157962e-21,  5.794434895139414e-23, -1.339871955581567e-24,  1.093806992652479e-03, -5.362379087373054e-06,  3.943324393547057e-08,
 -3.222032395067356e-10,  2.764688335083321e-12, -2.442721566980299e-14,  2.213719082128085e-16, -2.107665770924278e-18,  2.338229219771810e-20, -3.685794303426959e-22,
  8.511103922791559e-24, -2.296646625549188e-25,  2.401285772259307e-05, -1.177228266700794e-07,  8.656973566347814e-10, -7.073588556855136e-12,  6.070490249657419e-14,
 -5.370449581871872e-16,  4.908507814490220e-18, -4.883071176971187e-20,  6.297500849412586e-22, -1.272890866478258e-23,  3.502688947816698e-25, -1.017068771691891e-26,
  7.445970803970944e-08, -3.650380998438774e-10,  2.684382638856322e-12, -2.193464251617598e-14,  1.882994989144524e-16, -1.670153368037207e-18,  1.552603209830619e-20,
 -1.676868963215958e-22,  2.702024953921964e-24, -6.973562357041916e-26,  2.169820616036035e-27, -6.617671350843515e-29,  1.566386520848200e-01, -7.389355584262731e-04,
  5.228802333308277e-06, -4.111066044213257e-08,  3.393863808753063e-10, -2.881762135949658e-12,  2.491832855582055e-14, -2.180595300853906e-16,  1.917780505373270e-18,
 -1.666172496564052e-20,  1.346770770888250e-22, -7.651623742764919e-25,  7.156751900904937e-02, -3.376164438994887e-04,  2.389017135288923e-06, -1.878329298940326e-08,
  1.550652106681400e-10, -1.316744085928726e-12,  1.139005250564536e-14, -9.989473360011852e-17,  8.883611720690610e-19, -8.101345244861733e-21,  7.897140503561208e-23,
 -9.048735056745704e-25,  1.417875056648027e-02, -6.688759684843921e-05,  4.733052253389926e-07, -3.721296597473976e-09,  3.072152470342774e-11, -2.609038542595415e-13,
  2.258715456575045e-15, -1.990527453222377e-17,  1.812627029305971e-19, -1.817359041277557e-21,  2.323910571736332e-23, -4.216478163454710e-25,  1.072964935695737e-03,
 -5.061662243986320e-06,  3.581697678893043e-08, -2.816065927866340e-10,  2.324885251340758e-12, -1.974823521209115e-14,  1.712128692752781e-16, -1.521599464494450e-18,
  1.442230876837403e-20, -1.660905809411793e-22,  2.784173741167761e-24, -6.479162999717574e-26,  2.355530226508149e-05, -1.111210452155948e-07,  7.863070666974957e-10,
 -6.182265135594715e-12,  5.104156225267620e-14, -4.337154535748583e-16,  3.769656468849987e-18, -3.399111143541084e-20,  3.438532939418408e-22, -4.756005611936647e-24,
  1.012493057657103e-25, -2.719259264260864e-27,  7.304090784652160e-08, -3.445670985061657e-10,  2.438202967798652e-12, -1.917027450219802e-14,  1.582848160796123e-16,
 -1.345938255193319e-18,  1.175672786985213e-20, -1.090657560850632e-22,  1.238196695956474e-24, -2.183926322417214e-26,  5.738378090934937e-28, -1.695884022346019e-29,
  1.537635710815106e-01, -6.989903173590266e-04,  4.766253405973077e-06, -3.611102469926851e-08,  2.872705955461006e-10, -2.350574303106305e-12,  1.958867268446685e-14,
 -1.653162100467644e-16,  1.406499656447538e-18, -1.197500356651292e-20,  9.982959945730077e-23, -7.529531376141282e-25,  7.025390699969848e-02, -3.193656365959284e-04,
  2.177680473661336e-06, -1.649897249983966e-08,  1.312529121501708e-10, -1.073984571500171e-12,  8.951085565964682e-15, -7.559202684588678e-17,  6.454208130583886e-19,
 -5.586365578803384e-21,  4.981475395105646e-23, -4.814714775540812e-25,  1.391850154137665e-02, -6.327179936113180e-05,  4.314357858478754e-07, -3.268729877407364e-09,
  2.600354591378526e-11, -2.127822186190699e-13,  1.773840323842285e-15, -1.500188729601218e-17,  1.290788411289492e-19, -1.156598172539417e-21,  1.169361961407587e-23,
 -1.551749459798231e-25,  1.053270811171604e-03, -4.788039812473931e-06,  3.264853856535407e-08, -2.473584963409466e-10,  1.967809146612405e-12, -1.610310504093705e-14,
  1.342971258018527e-16, -1.138687379463130e-18,  9.929283576615811e-21, -9.419273092611069e-23,  1.129840205400151e-24, -1.980035047950339e-26,  2.312294791430175e-05,
 -1.051140829365620e-07,  7.167487116066843e-10, -5.430381996717065e-12,  4.320071948059780e-14, -3.535564118488233e-16,  2.950685498274506e-18, -2.512883050572736e-20,
  2.241571562270441e-22, -2.324458834665415e-24,  3.428689496452174e-26, -7.487567446574152e-28,  7.170025196276742e-08, -3.259405455490270e-10,  2.222513696548736e-12,
 -1.683870253843828e-14,  1.339608402768132e-16, -1.096543448271715e-18,  9.164189817958547e-21, -7.872422537440385e-23,  7.334217093858541e-25, -8.817882217953465e-27,
  1.665052833176342e-28, -4.340652054680317e-30,  1.510412312299965e-01, -6.625188960713328e-04,  4.359026359720876e-06, -3.186673058210049e-08,  2.446101434295091e-10,
 -1.931278833130958e-12,  1.553025639629337e-14, -1.264968291188404e-16,  1.039770721992262e-18, -8.591193717552471e-21,  7.074822383429653e-23, -5.649069505577823e-25,
  6.901008175920001e-02, -3.027020027276009e-04,  1.991620192640522e-06, -1.455977112130246e-08,  1.117613586138019e-10, -8.823966200775597e-13,  7.095946493668984e-15,
 -5.780901121965817e-17,  4.756929486849711e-19, -3.951507676470158e-21,  3.330238925656556e-23, -2.908083360313567e-25,  1.367207847008565e-02, -5.997044822153816e-05,
  3.945740531338082e-07, -2.884540093979785e-09,  2.214185870632574e-11, -1.748194734395069e-13,  1.405931697451351e-15, -1.145862547749861e-17,  9.451313919002037e-20,
 -7.941962500592784e-22,  7.021044297678230e-24, -7.179623001223364e-26,  1.034622954031689e-03, -4.538212857968251e-06,  2.985905736258784e-08, -2.182851550518770e-10,
  1.675569093195292e-12, -1.322952622240283e-14,  1.064063260156140e-16, -8.678726461039441e-19,  7.188075348080144e-21, -6.160915591074583e-23,  5.878354010385420e-25,
 -7.333390445410028e-27,  2.271356276356703e-05, -9.962951452303916e-08,  6.555098926392522e-10, -4.792117368954230e-12,  3.678465459037242e-14, -2.904418925432095e-16,
  2.336501294525078e-18, -1.908119938361028e-20,  1.591653639183133e-22, -1.410114081446902e-24,  1.507326566906770e-26, -2.343131375308232e-28,  7.043081959529300e-08,
 -3.089338489958329e-10,  2.032622557294423e-12, -1.485953105110163e-14,  1.140634340654654e-16, -9.006572041703937e-19,  7.248177432344631e-21, -5.933977055211244e-23,
  5.018805865124941e-25, -4.728088739588460e-27,  6.026201449989930e-29, -1.188834335823621e-30,  1.484585684147166e-01, -6.291125639901590e-04,  3.998895987061281e-06,
 -2.824286152995221e-08,  2.094432194432705e-10, -1.597563197466602e-12,  1.241129523916575e-14, -9.767191029119658e-17,  7.759233801117755e-19, -6.205476463389021e-21,
  4.976844606800500e-23, -3.961724620158341e-25,  6.783007434934506e-02, -2.874387948489424e-04,  1.827078188389473e-06, -1.290404072131286e-08,  9.569370610113714e-11,
 -7.299204569599311e-13,  5.670717697580166e-15, -4.462870012646763e-17,  3.546526318250251e-19, -2.841069355772450e-21,  2.295957679494445e-23, -1.885311101191477e-25,
  1.343829880351018e-02, -5.694654546768536e-05,  3.619754642825277e-07, -2.556511393386126e-09,  1.895856544282594e-11, -1.446100710649830e-13,  1.123488095067330e-15,
 -8.842926001993222e-18,  7.032157916515446e-20, -5.653712577172354e-22,  4.643931762250748e-24, -4.060405957752947e-26,  1.016931875840107e-03, -4.309381578328667e-06,
  2.739218660425716e-08, -1.934618391917761e-10,  1.434673931857242e-12, -1.094328849714357e-14,  8.502188564625658e-17, -6.693414047099013e-19,  5.329303013737203e-21,
 -4.311626010493927e-23,  3.640848200361012e-25, -3.506291447732015e-27,  2.232518222998213e-05, -9.460587412819481e-08,  6.013535161360695e-10, -4.247158662341539e-12,
  3.149609007004501e-14, -2.402447794184031e-16,  1.866632916634063e-18, -1.470039198370219e-20,  1.172899203814470e-22, -9.591338980593380e-25,  8.474559018057874e-27,
 -9.355690987422753e-29,  6.922651890539119e-08, -2.933564110448298e-10,  1.864692987851323e-12, -1.316970376787395e-14,  9.766403529598986e-17, -7.449670877595845e-19,
  5.788745818422312e-21, -4.561950124664922e-23,  3.654669195248677e-25, -3.050715747915123e-27,  2.923601820793556e-29, -3.929031235597280e-31,  1.460040313888107e-01,
 -5.984224124591241e-04,  3.679083806734067e-06, -2.513207767463662e-08,  1.802628184138453e-10, -1.329897616277879e-12,  9.993065101808051e-15, -7.606418790935944e-17,
  5.845216315043761e-19, -4.524137264772601e-21,  3.518809942380774e-23, -2.738632579893280e-25,  6.670860705554407e-02, -2.734165980648114e-04,  1.680957393267556e-06,
 -1.148273702497953e-08,  8.236129988559476e-11, -6.076245979993316e-13,  4.565798564509426e-15, -3.475399188407405e-17,  2.670945118874718e-19, -2.068315642635484e-21,
  1.612571995642687e-23, -1.268062477313950e-25,  1.321611693599405e-02, -5.416850825979578e-05,  3.330264333004922e-07, -2.274926767919761e-09,  1.631718417915082e-11,
 -1.203809023842276e-13,  9.045673838752355e-16, -6.885616162710613e-18,  5.292850826285705e-20, -4.103095461597652e-22,  3.215645101971578e-24, -2.584695954538247e-26,
  1.000118451267507e-03, -4.099155966248036e-06,  2.520149317895530e-08, -1.721531567656729e-10,  1.234789199806871e-12, -9.109731768127430e-15,  6.845296507526540e-17,
 -5.210967491444546e-19,  4.006968327022064e-21, -3.112122660302709e-23,  2.461024561388079e-25, -2.052079368882804e-27,  2.195606923782608e-05, -8.999069270151241e-08,
  5.532601950715599e-10, -3.779359000991456e-12,  2.710791035568034e-14, -1.999905452814299e-16,  1.502802160409435e-18, -1.144113475724736e-20,  8.802860733320363e-23,
 -6.859042141026852e-25,  5.507087705257179e-27, -4.869736062024216e-29,  6.808196352086506e-08, -2.790455336768808e-10,  1.715563931302604e-12, -1.171913716077146e-14,
  8.405695372810500e-17, -6.201379538494744e-19,  4.660059334743225e-21, -3.548440920815797e-23,  2.733300949549618e-25, -2.143014349103371e-27,  1.770829572027399e-29,
 -1.732802802583567e-31,  1.436673637002249e-01, -5.701489904772260e-04,  3.393966692423477e-06, -2.244831318250213e-08,  1.559010066479110e-10, -1.113649321822806e-12,
  8.102457409156813e-15, -5.971564683870054e-17,  4.443351693064235e-19, -3.330519115950843e-21,  2.510328385718673e-23, -1.898569434786751e-25,  6.564099374942661e-02,
 -2.604985945052185e-04,  1.550688623424978e-06, -1.025653668251029e-08,  7.123049241731797e-11, -5.088215648631576e-13,  3.701979715081442e-15, -2.728394216794151e-17,
  2.030208856159328e-19, -1.521965438874620e-21,  1.147996028761006e-23, -8.711005662569247e-26,  1.300460446528140e-02, -5.160923063167071e-05,  3.072179600794235e-07,
 -2.031995483807854e-09,  1.411198000090113e-11, -1.008062755317484e-13,  7.334264734903020e-16, -5.405468590697168e-18,  4.022452009768801e-20, -3.016415158222610e-22,
  2.278838768794662e-24, -1.741521630657711e-26,  9.841124242583224e-04, -3.905484800152069e-06,  2.324845882841118e-08, -1.537695367724154e-10,  1.067912152042807e-12,
 -7.628431294135262e-15,  5.550154775465381e-17, -4.090611495387542e-19,  3.044298770491440e-21, -2.284147677444889e-23,  1.730374571505563e-25, -1.338658117947057e-27,
  2.160468142291874e-05, -8.573893879372613e-08,  5.103843161004036e-10, -3.375774739384426e-12,  2.344437695822800e-14, -1.674705951948721e-16,  1.218455968992565e-18,
 -8.980567129949590e-21,  6.684566754777584e-23, -5.020107095159913e-25,  3.820842905370580e-27, -3.017081957899163e-29,  6.699237083751757e-08, -2.658615820563780e-10,
  1.582613263856909e-12, -1.046769215381807e-14,  7.269695245338433e-17, -5.192976632948113e-19,  3.778246786614433e-21, -2.784868426440507e-23,  2.073521300325790e-25,
 -1.559983178512732e-27,  1.197985643818946e-29, -9.827272236221206e-32  };
  int offset = -6;
  for (int i = 1; i <= n; ++i) {
    double t = ta[i-1];
    offset += 6;
    if (std::isnan(t)) {
      fill_n(rr+offset, 6, 0.5);
      fill_n(ww+offset, 6, 0.0);
    } else if (t >= 64.0) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 6; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else {
      assert(t >= 0);
      int it = static_cast<int>(t*   0.500000000000000);
      t = (t-it*2.000000000000000-   1.000000000000000) *   1.000000000000000;
      const double t2 = t * 2.0;
      for (int j=1; j <=6; ++j) {
        const int boxof = it*72+12*(j-1);
        double d = x[boxof+11];
        double e = w[boxof+11];
        double f = t2*d + x[boxof+10];
        double g = t2*e + w[boxof+10];
        d = t2*f - d + x[boxof+9];
        e = t2*g - e + w[boxof+9];
        f = t2*d - f + x[boxof+8];
        g = t2*e - g + w[boxof+8];
        d = t2*f - d + x[boxof+7];
        e = t2*g - e + w[boxof+7];
        f = t2*d - f + x[boxof+6];
        g = t2*e - g + w[boxof+6];
        d = t2*f - d + x[boxof+5];
        e = t2*g - e + w[boxof+5];
        f = t2*d - f + x[boxof+4];
        g = t2*e - g + w[boxof+4];
        d = t2*f - d + x[boxof+3];
        e = t2*g - e + w[boxof+3];
        f = t2*d - f + x[boxof+2];
        g = t2*e - g + w[boxof+2];
        d = t2*f - d + x[boxof+1];
        e = t2*g - e + w[boxof+1];
        rr[offset+j-1] = t*d - f + x[boxof+0]*0.5;
        ww[offset+j-1] = t*e - g + w[boxof+0]*0.5;
      }
    }
  }
}
