//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _complex_eriroot_9.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot9(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[9] = {6.670223095819444e-02,6.032363570817492e-01,1.692395079793181e+00,3.369176270243263e+00,5.694423342957752e+00,
    8.769756730268591e+00,1.277182535486918e+01,1.804650546772897e+01,2.548597916609908e+01};
  static constexpr double aw[9] = {4.834956947254558e-01,2.848072856699794e-01,9.730174764131549e-02,1.864004238754467e-02,1.888522630268423e-03,
    9.181126867929429e-05,1.810654481093432e-06,1.046720579579196e-08,7.828199772115708e-12};
  static constexpr double xr[35460] = {   1.518557281627729e-02,  -4.182023574823342e-04,   8.567118853979743e-06,  -1.543304425311398e-07,   2.570010871033944e-09,
  -4.037306528088991e-11,   6.031476015899036e-13,  -8.583580467482666e-15,   1.159121258759099e-16,  -1.469887058313510e-18,   1.710618425812932e-20,  -1.731533221473428e-22,
   1.278131732404745e-24,   4.357296025333738e-28,   1.518637889388417e-02,  -4.182458966877301e-04,   8.568569292314265e-06,  -1.543684350332319e-07,   2.570862663974081e-09,
  -4.039004350290808e-11,   6.034533666888894e-13,  -8.588564590793070e-15,   1.159845423666853e-16,  -1.470779556878655e-18,   1.711397536565479e-20,  -1.731457478282039e-22,
   1.275618660429913e-24,   5.148321295222825e-28,   1.518780134165000e-02,  -4.183227310138958e-04,   8.571129004002970e-06,  -1.544354863669902e-07,   2.572366016206098e-09,
  -4.042000983226477e-11,   6.039930487222451e-13,  -8.597361603579120e-15,   1.161123490244760e-16,  -1.472354348392639e-18,   1.712771011419443e-20,  -1.731319086615601e-22,
   1.271171522385165e-24,   6.546979180868068e-28,   1.518952157022315e-02,  -4.184156547609834e-04,   8.574224900551507e-06,  -1.545165876687008e-07,   2.574184483010521e-09,
  -4.045625906336627e-11,   6.046459018287056e-13,  -8.608003220760937e-15,   1.162669395607292e-16,  -1.474258539949743e-18,   1.714429647817272e-20,  -1.731143645329855e-22,
   1.265772173958705e-24,   8.243167734073911e-28,   1.519119173685200e-02,  -4.185058790889038e-04,   8.577231040717212e-06,  -1.545953425698920e-07,   2.575950444667515e-09,
  -4.049146346133204e-11,   6.052799566486196e-13,  -8.618338290784421e-15,   1.164170608393929e-16,  -1.476107028256493e-18,   1.716037530539200e-20,  -1.730964836267111e-22,
   1.260507696083118e-24,   9.894951250767138e-28,   1.519253734361716e-02,  -4.185785737866750e-04,   8.579653247916044e-06,  -1.546588030929356e-07,   2.577373528734807e-09,
  -4.051983389470069e-11,   6.057909409869876e-13,  -8.626667221443847e-15,   1.165380305683704e-16,  -1.477596096518258e-18,   1.717331173196644e-20,  -1.730814693713156e-22,
   1.256250282005958e-24,   1.122930188936781e-27,   1.519342656625285e-02,  -4.186266146092755e-04,   8.581254044026277e-06,  -1.547007448048022e-07,   2.578314096889739e-09,
  -4.053858558063970e-11,   6.061286873054346e-13,  -8.632172364251636e-15,   1.166179818363583e-16,  -1.478580021378375e-18,   1.718185181315589e-20,  -1.730712493000341e-22,
   1.253429010109063e-24,   1.211282763391506e-27,   1.519388324616750e-02,  -4.186512875594730e-04,   8.582076205121838e-06,  -1.547222863948977e-07,   2.578797191550528e-09,
  -4.054821701788310e-11,   6.063021661925580e-13,  -8.634999992831562e-15,   1.166590457774135e-16,  -1.479085306059941e-18,   1.718623505152500e-20,  -1.730659082697989e-22,
   1.251977660945137e-24,   1.256712060197448e-27,   1.519404220122384e-02,  -4.186598754746620e-04,   8.582362377872203e-06,  -1.547297845428976e-07,   2.578965347883256e-09,
  -4.055156957448345e-11,   6.063625518829321e-13,  -8.635984250367952e-15,   1.166733392761422e-16,  -1.479261173767281e-18,   1.718776027916039e-20,  -1.730640345355554e-22,
   1.251472108823087e-24,   1.272533064247127e-27,   1.519406742536495e-02,  -4.186612382712948e-04,   8.582407790118608e-06,  -1.547309744147228e-07,   2.578992032490670e-09,
  -4.055210159075413e-11,   6.063721344870408e-13,  -8.636140442068463e-15,   1.166756074963656e-16,  -1.479289081490653e-18,   1.718800229285039e-20,  -1.730637364998276e-22,
   1.251391865825113e-24,   1.275044063270368e-27,   1.336136852858094e-01,  -3.449201859723447e-03,   6.183161654831117e-05,  -8.727274155113194e-07,   9.260520519570692e-09,
  -4.939111396841218e-11,  -7.225366248626931e-13,   2.786338041258086e-14,  -5.092547616049573e-16,   5.866998915717455e-18,  -2.020396459520476e-20,  -9.885533763177915e-22,
   3.056565282821213e-23,  -5.249341236484322e-25,   1.336194924334741e-01,  -3.449447475188664e-03,   6.183681974755901e-05,  -8.727732554378430e-07,   9.259488624077198e-09,
  -4.933594557840701e-11,  -7.238750303939035e-13,   2.788304414210114e-14,  -5.093338397878115e-16,   5.861752560132413e-18,  -2.001278859087506e-20,  -9.923871214270001e-22,
   3.061011668851518e-23,  -5.248527890826117e-25,   1.336297396329230e-01,  -3.449880877948318e-03,   6.184600039899355e-05,  -8.728540985655316e-07,   9.257666297409683e-09,
  -4.923856867905616e-11,  -7.262368330679834e-13,   2.791772659764515e-14,  -5.094727169829247e-16,   5.852479217018209e-18,  -1.967523330273372e-20,  -9.991512843663673e-22,
   3.068844229425882e-23,  -5.247050356035129e-25,   1.336421313312367e-01,  -3.450404970934797e-03,   6.185710092956480e-05,  -8.729517830642647e-07,   9.255460110203157e-09,
  -4.912076595585984e-11,  -7.290930305728749e-13,   2.795964023182941e-14,  -5.096395271545848e-16,   5.841238398959993e-18,  -1.926667939185421e-20,  -1.007329643397049e-21,
   3.078292973700517e-23,  -5.245191429364571e-25,   1.336541616845473e-01,  -3.450913769901514e-03,   6.186787628236528e-05,  -8.730465381970081e-07,   9.253315648178898e-09,
  -4.900634906930202e-11,  -7.318660701533539e-13,   2.800030329371964e-14,  -5.098002883729107e-16,   5.830297324347385e-18,  -1.886966660021601e-20,  -1.015268047347188e-21,
   3.087442071819110e-23,  -5.243311096841822e-25,   1.336638536873318e-01,  -3.451323665030135e-03,   6.187655615691059e-05,  -8.731228177416251e-07,   9.251586138678136e-09,
  -4.891413617387466e-11,  -7.341002034746562e-13,   2.803304229397949e-14,  -5.099289530197533e-16,   5.821462787151264e-18,  -1.854955513191607e-20,  -1.021662386401693e-21,
   3.094795538601716e-23,  -5.241742050689112e-25,   1.336702582381551e-01,  -3.451594522937677e-03,   6.188229136476244e-05,  -8.731731954805983e-07,   9.250442350492526e-09,
  -4.885318388770691e-11,  -7.355765808077240e-13,   2.805466650766524e-14,  -5.100135596275793e-16,   5.815615021258081e-18,  -1.833789271608001e-20,  -1.025887285128545e-21,
   3.099646276811804e-23,  -5.240678669541663e-25,   1.336735473581561e-01,  -3.451733623445600e-03,   6.188523657602553e-05,  -8.731990586865328e-07,   9.249854663905221e-09,
  -4.882187589734420e-11,  -7.363348026288134e-13,   2.806576874882066e-14,  -5.100568814979662e-16,   5.812608802313216e-18,  -1.822915115321118e-20,  -1.028056858063140e-21,
   3.102134792767979e-23,  -5.240124349357481e-25,   1.336746921787050e-01,  -3.451782038971545e-03,   6.188626166906540e-05,  -8.732080593108592e-07,   9.249650066982554e-09,
  -4.881097789755796e-11,  -7.365987136724522e-13,   2.806963253521561e-14,  -5.100719397427176e-16,   5.811561964959622e-18,  -1.819129584820859e-20,  -1.028811979409350e-21,
   3.103000534100158e-23,  -5.239930103844389e-25,   1.336748738465391e-01,  -3.451789721863929e-03,   6.188642433651452e-05,  -8.732094875241995e-07,   9.249617598026784e-09,
  -4.880924848917580e-11,  -7.366405929574386e-13,   2.807024564352161e-14,  -5.100743283136193e-16,   5.811395822774689e-18,  -1.818528840951201e-20,  -1.028931805892223e-21,
   3.103137895884007e-23,  -5.239899217596611e-25,   3.548195695765051e-01,  -8.026396057668948e-03,   1.059404443775271e-04,  -6.406318241137925e-07,  -7.796361482908085e-09,
   2.608454742263172e-10,  -2.722931070610219e-12,  -1.639470866575802e-14,   1.016066142944302e-15,  -1.432451046203286e-17,  -2.056401637533312e-20,   4.601126547675389e-21,
  -8.245804496704544e-23,   1.902553388113067e-25,   3.548294926266579e-01,  -8.026575374701620e-03,   1.059360375138249e-04,  -6.403875604590835e-07,  -7.800159084674467e-09,
   2.608124394631532e-10,  -2.720266074813190e-12,  -1.644243407986933e-14,   1.015963311181028e-15,  -1.430074363364215e-17,  -2.106541789028425e-20,   4.602255009479922e-21,
  -8.226825988009420e-23,   1.854770967875055e-25,   3.548470016665886e-01,  -8.026891726627586e-03,   1.059282598041037e-04,  -6.399565788029314e-07,  -7.806856966857435e-09,
   2.607540730190902e-10,  -2.715563876919417e-12,  -1.652658108147763e-14,   1.015780150930360e-15,  -1.425880222836205e-17,  -2.194919201689871e-20,   4.604217940365135e-21,
  -8.193319537943005e-23,   1.770568725647396e-25,   3.548681732080536e-01,  -8.027274167618439e-03,   1.059188519666038e-04,  -6.394354745370580e-07,  -7.814950924270548e-09,
   2.606833660319795e-10,  -2.709878322139252e-12,  -1.662822128313116e-14,   1.015555754768616e-15,  -1.420807870459476e-17,  -2.301622919253530e-20,   4.606543400754531e-21,
  -8.152771691248480e-23,   1.668939217505965e-25,   3.548887255700075e-01,  -8.027645335089815e-03,   1.059097159151130e-04,  -6.389296409901094e-07,  -7.822802959900858e-09,
   2.606145892261325e-10,  -2.704359298863289e-12,  -1.672677531954341e-14,   1.015334863255856e-15,  -1.415882940525509e-17,  -2.405038065996731e-20,   4.608750566927665e-21,
  -8.113375796653325e-23,   1.570476925743493e-25,   3.549052818526707e-01,  -8.027944271402462e-03,   1.059023538208068e-04,  -6.385221806658979e-07,  -7.829124561469026e-09,
   2.605590863710414e-10,  -2.699913544989929e-12,  -1.680608568210060e-14,   1.015154731487970e-15,  -1.411914930813039e-17,  -2.488225404102318e-20,   4.610492596005823e-21,
  -8.081615674068051e-23,   1.491298919633323e-25,   3.549162217373485e-01,  -8.028141768246698e-03,   1.058974879982934e-04,  -6.382529541199347e-07,  -7.833299855544438e-09,
   2.605223635295898e-10,  -2.696976017578203e-12,  -1.685845167625548e-14,   1.015034634883695e-15,  -1.409292674218855e-17,  -2.543134084386477e-20,   4.611626070387808e-21,
  -8.060617806324592e-23,   1.439049062924854e-25,   3.549218398260254e-01,  -8.028243181519094e-03,   1.058949888311452e-04,  -6.381146983508486e-07,  -7.835443478896478e-09,
   2.605034898956345e-10,  -2.695467502520420e-12,  -1.688533147657980e-14,   1.014972629187316e-15,  -1.407945938205393e-17,  -2.571313749124733e-20,   4.612202715786288e-21,
  -8.049830901944065e-23,   1.412237786818964e-25,   3.549237952428006e-01,  -8.028278477616805e-03,   1.058941189198916e-04,  -6.380665779517189e-07,  -7.836189492717529e-09,
   2.604969184150886e-10,  -2.694942457352328e-12,  -1.689468522435714e-14,   1.014950994961220e-15,  -1.407477181438630e-17,  -2.581118982724308e-20,   4.612402555491990e-21,
  -8.046075865977778e-23,   1.402909304712554e-25,   3.549241055400169e-01,  -8.028284078539730e-03,   1.058939808744289e-04,  -6.380589419444888e-07,  -7.836307870378117e-09,
   2.604958755005805e-10,  -2.694859140262683e-12,  -1.689616943974817e-14,   1.014947559411867e-15,  -1.407402795581240e-17,  -2.582674797880263e-20,   4.612434226147742e-21,
  -8.045479967156962e-23,   1.401429165842415e-25,   6.503784888565195e-01,  -1.197380209089914e-02,   8.371846489249837e-05,   7.984746674236682e-07,  -2.172689678566959e-08,
   1.662718805589105e-11,   5.169499702459786e-12,  -5.289547138800183e-14,  -9.486967876428732e-16,   2.484096047452992e-17,   4.338467181827177e-20,  -8.247297041702608e-21,
   6.970641978099785e-23,   1.997968643543237e-24,   6.503863129965390e-01,  -1.197357746866269e-02,   8.370628438941455e-05,   7.984893921622126e-07,  -2.171965658646896e-08,
   1.652436404668718e-11,   5.167013471993672e-12,  -5.281272495018187e-14,  -9.485005127068613e-16,   2.479899823372680e-17,   4.379923829164156e-20,  -8.232812841580244e-21,
   6.934321153657315e-23,   1.995700896751172e-24,   6.504001178913801e-01,  -1.197318111596953e-02,   8.368479500390175e-05,   7.985152962278129e-07,  -2.170688398173118e-08,
   1.634306136924531e-11,   5.162626906025422e-12,  -5.266683228294871e-14,  -9.481527752461831e-16,   2.472501578735972e-17,   4.452893477798367e-20,  -8.207268855718649e-21,
   6.870363925723235e-23,   1.991689623320181e-24,   6.504168093435726e-01,  -1.197270183657421e-02,   8.365881544169541e-05,   7.985464868286974e-07,  -2.169144405482048e-08,
   1.612405301709174e-11,   5.157323353362185e-12,  -5.249061281126723e-14,  -9.477298921545088e-16,   2.463565869046555e-17,   4.540820548026705e-20,  -8.176404045926758e-21,
   6.793249976482471e-23,   1.986822515311203e-24,   6.504330114682194e-01,  -1.197223655470627e-02,   8.363360082942738e-05,   7.985766270693112e-07,  -2.167646031236502e-08,
   1.591167872995964e-11,   5.152175523055377e-12,  -5.231974657949989e-14,  -9.473168616994533e-16,   2.454902045831801e-17,   4.625856028961486e-20,  -8.146465420943038e-21,
   6.718623084200871e-23,   1.982080287113744e-24,   6.504460625083537e-01,  -1.197186172559136e-02,   8.361329249007352e-05,   7.986008080845227e-07,  -2.166439323757526e-08,
   1.574076119486727e-11,   5.148029049155622e-12,  -5.218224544453310e-14,  -9.469823402413205e-16,   2.447930323638075e-17,   4.694128771985537e-20,  -8.122364770285151e-21,
   6.658672018229100e-23,   1.978247663463004e-24,   6.504546858251009e-01,  -1.197161404318994e-02,   8.359987516925457e-05,   7.986167377410260e-07,  -2.165642130834435e-08,
   1.562790435418205e-11,   5.145289403714257e-12,  -5.209145882294117e-14,  -9.467604197702024e-16,   2.443327322634008e-17,   4.739129373857829e-20,  -8.106448080247886e-21,
   6.619139271116949e-23,   1.975709115666535e-24,   6.504591141320987e-01,  -1.197148684580817e-02,   8.359298537251222e-05,   7.986249033176902e-07,  -2.165232789133234e-08,
   1.556997244647568e-11,   5.143882548549518e-12,  -5.204485770734487e-14,  -9.466461828224576e-16,   2.440964632796405e-17,   4.762204483210857e-20,  -8.098276758050109e-21,
   6.598862603483257e-23,   1.974403594356245e-24,   6.504606554164444e-01,  -1.197144257349639e-02,   8.359058741746329e-05,   7.986277430236635e-07,  -2.165090322762779e-08,
   1.554981277106038e-11,   5.143392893089916e-12,  -5.202864128919389e-14,  -9.466063786246895e-16,   2.440142463426566e-17,   4.770230440800119e-20,  -8.095433078226909e-21,
   6.591809147708314e-23,   1.973948900807525e-24,   6.504608999956921e-01,  -1.197143554808558e-02,   8.359020689985497e-05,   7.986281935320723e-07,  -2.165067715727601e-08,
   1.554661390073024e-11,   5.143315192146845e-12,  -5.202606813438694e-14,  -9.466000602067895e-16,   2.440012005322234e-17,   4.771503786531929e-20,  -8.094981845522534e-21,
   6.590690052413579e-23,   1.973876733213777e-24,   9.838744088583710e-01,  -1.351557038013843e-02,   1.891139094349901e-06,   1.647214982099125e-06,  -2.843681841726469e-10,
  -3.621931497045962e-10,   3.079945938818249e-14,   9.700743300844746e-14,   3.850487519979467e-18,  -2.885286535880844e-17,  -5.666133691079167e-21,   9.156908276722274e-21,
   3.305227604572612e-24,  -3.042130920246036e-24,   9.838745858317076e-01,  -1.351510829190399e-02,   1.890979382738584e-06,   1.646877018075832e-06,  -2.843247593897320e-10,
  -3.620036937501201e-10,   3.080908823905646e-14,   9.691126033527409e-14,   3.827217989674946e-18,  -2.880649114230913e-17,  -5.646305854169958e-21,   9.135209052532150e-21,
   3.291695720471932e-24,  -3.032178493246810e-24,   9.838748980918051e-01,  -1.351429300693427e-02,   1.890697588968786e-06,   1.646280819163006e-06,  -2.842481248549908e-10,
  -3.616695490744895e-10,   3.082602922104957e-14,   9.674168876708307e-14,   3.786225997989001e-18,  -2.872475351339526e-17,  -5.611386772867583e-21,   9.096979115537633e-21,
   3.267874855746316e-24,  -3.014653084340388e-24,   9.838752756593543e-01,  -1.351330728688871e-02,   1.890356874833385e-06,   1.645560134388445e-06,  -2.841554391424370e-10,
  -3.612657590757173e-10,   3.084643051439208e-14,   9.653685675466999e-14,   3.736772912063744e-18,  -2.862606948060357e-17,  -5.569277059315264e-21,   9.050850985880522e-21,
   3.239166352634202e-24,  -2.993522112396540e-24,   9.838756421737229e-01,  -1.351235050434717e-02,   1.890026150954403e-06,   1.644860762880293e-06,  -2.840654422226171e-10,
  -3.608740402027283e-10,   3.086614797837296e-14,   9.633823508733126e-14,   3.688884800551146e-18,  -2.853042976381805e-17,  -5.528517662684566e-21,   9.006175045159762e-21,
   3.211396907656475e-24,  -2.973072204802082e-24,   9.838759374174049e-01,  -1.351157983121180e-02,   1.889759749541143e-06,   1.644297542209887e-06,  -2.839929281273406e-10,
  -3.605586723874532e-10,   3.088196932032978e-14,   9.617838961971163e-14,   3.650392662144638e-18,  -2.845349888148582e-17,  -5.495768217775028e-21,   8.970259395660448e-21,
   3.189097911368709e-24,  -2.956643548067937e-24,   9.838761325015682e-01,  -1.351107063232243e-02,   1.889583728691636e-06,   1.643925466048204e-06,  -2.839450053879296e-10,
  -3.603503787791087e-10,   3.089239307278856e-14,   9.607284562727045e-14,   3.624999745447663e-18,  -2.840272068375829e-17,  -5.474169905560548e-21,   8.946563500570764e-21,
   3.174398186208913e-24,  -2.945810033495762e-24,   9.838762326842696e-01,  -1.351080914922976e-02,   1.889493337416318e-06,   1.643734414970550e-06,  -2.839203926938706e-10,
  -3.602434396691094e-10,   3.089773667911801e-14,   9.601866816940330e-14,   3.611972245290341e-18,  -2.837666106614339e-17,  -5.463091093490290e-21,   8.934405809565941e-21,
   3.166860003038250e-24,  -2.940253377616100e-24,   9.838762675534021e-01,  -1.351071814001692e-02,   1.889461876518621e-06,   1.643667922324131e-06,  -2.839118256903305e-10,
  -3.602062232478450e-10,   3.089959506019662e-14,   9.599981509755161e-14,   3.607439969526243e-18,  -2.836759354917671e-17,  -5.459237072572929e-21,   8.930176009458559e-21,
   3.164237992301433e-24,  -2.938320425958505e-24,   9.838762730866354e-01,  -1.351070369822085e-02,   1.889456884136566e-06,   1.643657371067228e-06,  -2.839104662091957e-10,
  -3.602003177381745e-10,   3.089988988800679e-14,   9.599682355927405e-14,   3.606720857791012e-18,  -2.836615479066731e-17,  -5.458625590351287e-21,   8.929504883657481e-21,
   3.163821997081182e-24,  -2.938013745039065e-24,   1.316227626549494e+00,  -1.205814174468722e-02,  -7.869633938789895e-05,   8.274654139028524e-07,   2.047756238568641e-08,
   2.105356440948874e-12,  -4.844946165227230e-12,  -4.563004074118749e-14,   8.861483746202281e-16,   2.161970588377129e-17,  -4.872761509328627e-20,  -7.071239346375415e-21,
  -5.639230658663302e-23,   1.674525190237884e-24,   1.316220271827298e+00,  -1.205790901632901e-02,  -7.868485906985636e-05,   8.274666431152581e-07,   2.047077664190030e-08,
   2.016666110138867e-12,  -4.842624529647767e-12,  -4.555801067235805e-14,   8.859320888895725e-16,   2.158371666783558e-17,  -4.906300813404140e-20,  -7.059097742796944e-21,
  -5.609872667694346e-23,   1.672663532442862e-24,   1.316207295174542e+00,  -1.205749836332152e-02,  -7.866460496451257e-05,   8.274687448325899e-07,   2.045880574256744e-08,
   1.860285454697253e-12,  -4.838528435130420e-12,  -4.543101088461864e-14,   8.855493108123563e-16,   2.152026392097513e-17,  -4.965334902744067e-20,  -7.037684862454909e-21,
  -5.558173524319348e-23,   1.669370952203903e-24,   1.316191605151084e+00,  -1.205700179705784e-02,  -7.864011876279297e-05,   8.274711716490965e-07,   2.044433492526010e-08,
   1.671383979881009e-12,  -4.833576193481503e-12,  -4.527760907239574e-14,   8.850845136550033e-16,   2.144362275186494e-17,  -5.036470046026316e-20,  -7.011811255588385e-21,
  -5.495834599484980e-23,   1.665376532595768e-24,   1.316176375101422e+00,  -1.205651973886626e-02,  -7.861635350893745e-05,   8.274734076260235e-07,   2.043029164130001e-08,
   1.488206479784735e-12,  -4.828769482457002e-12,  -4.512886472815251e-14,   8.846312717248114e-16,   2.136931144600223e-17,  -5.105265981915057e-20,  -6.986713622089060e-21,
  -5.435501300872489e-23,   1.661485282485841e-24,   1.316164107084414e+00,  -1.205613139888017e-02,  -7.859721248875208e-05,   8.274751230209290e-07,   2.041898194663535e-08,
   1.340787696547577e-12,  -4.824897861504952e-12,  -4.500916386363602e-14,   8.842646981643540e-16,   2.130951212024180e-17,  -5.160500528377734e-20,  -6.966509663906836e-21,
  -5.387029385358596e-23,   1.658340894356134e-24,   1.316156001142187e+00,  -1.205587479065302e-02,  -7.858456638185622e-05,   8.274762144963150e-07,   2.041151036268359e-08,
   1.243447745038766e-12,  -4.822339859162891e-12,  -4.493012914922477e-14,   8.840217652661259e-16,   2.127002955405072e-17,  -5.196907314197925e-20,  -6.953166294744579e-21,
  -5.355064457881191e-23,   1.656258435638432e-24,   1.316151838521490e+00,  -1.205574301002544e-02,  -7.857807260023091e-05,   8.274767620285221e-07,   2.040767386041338e-08,
   1.193481204755646e-12,  -4.821026294174296e-12,  -4.488956004897243e-14,   8.838967890250867e-16,   2.124976318763050e-17,  -5.215575757933127e-20,  -6.946316017762329e-21,
  -5.338668852151475e-23,   1.655187543383207e-24,   1.316150389710060e+00,  -1.205569714256735e-02,  -7.857581247548114e-05,   8.274769505340873e-07,   2.040633861242645e-08,
   1.176093423552898e-12,  -4.820569110446498e-12,  -4.487544262743642e-14,   8.838532551261271e-16,   2.124271085641638e-17,  -5.222068996434279e-20,  -6.943932063638474e-21,
  -5.332965380163632e-23,   1.654814579066463e-24,   1.316150159804913e+00,  -1.205568986403326e-02,  -7.857545382933978e-05,   8.274769803491562e-07,   2.040612673084172e-08,
   1.173334389744597e-12,  -4.820496562378473e-12,  -4.487320253067601e-14,   8.838463452455713e-16,   2.124159182278533e-17,  -5.223099171122789e-20,  -6.943553779453174e-21,
  -5.332060468106441e-23,   1.654755383833146e-24,   1.610464475136288e+00,  -8.338035759552762e-03,  -1.024947491991994e-04,  -5.180365476259806e-07,   8.657406012772674e-09,
   2.374778608263249e-10,   2.032432412352236e-12,  -2.136985327641106e-14,  -8.785979179118222e-16,  -9.999524357734017e-18,   5.720219052342925e-20,   3.817045646680850e-21,
   5.397015857876258e-23,  -1.050487818334653e-25,   1.610454876080623e+00,  -8.338180674195379e-03,  -1.024898634532502e-04,  -5.178142712544284e-07,   8.660236911042336e-09,
   2.374352614904857e-10,   2.030131329410052e-12,  -2.140308966578532e-14,  -8.783461229128127e-16,  -9.979879906894132e-18,   5.752903974117508e-20,   3.816115929702463e-21,
   5.381715718125183e-23,  -1.079893359598395e-25,   1.610437938769920e+00,  -8.338436327603380e-03,  -1.024812411893281e-04,  -5.174220937250636e-07,   8.665229446925053e-09,
   2.373600413451060e-10,   2.026071575996254e-12,  -2.146168192433321e-14,  -8.779007118580478e-16,  -9.945221026172966e-18,   5.810500053647421e-20,   3.814458067306110e-21,
   5.354717113054681e-23,  -1.131691174110874e-25,   1.610417458630667e+00,  -8.338745379893339e-03,  -1.024708128597738e-04,  -5.169479241221533e-07,   8.671261993022607e-09,
   2.372689941213717e-10,   2.021163407361620e-12,  -2.153244045866186e-14,  -8.773602170026327e-16,  -9.903318112694608e-18,   5.880014588852465e-20,   3.812423794609117e-21,
   5.322068057498351e-23,  -1.194174314299223e-25,   1.610397577533986e+00,  -8.339045311886843e-03,  -1.024606869194855e-04,  -5.164876667968083e-07,   8.677113591776174e-09,
   2.371805126501473e-10,   2.016399616670309e-12,  -2.160103544380862e-14,  -8.768335275950959e-16,  -9.862646857513839e-18,   5.947360638060658e-20,   3.810418040958039e-21,
   5.290370906216579e-23,  -1.254673335235002e-25,   1.610381562059715e+00,  -8.339286868276213e-03,  -1.024525279475622e-04,  -5.161169312896680e-07,   8.681824201810306e-09,
   2.371091655416270e-10,   2.012562668493422e-12,  -2.165622576976908e-14,  -8.764078118658997e-16,  -9.829887946893388e-18,   6.001515248082382e-20,   3.808780112571045e-21,
   5.264834747592031e-23,  -1.303296933032654e-25,   1.610370979554013e+00,  -8.339446452648461e-03,  -1.024471358385803e-04,  -5.158719763515573e-07,   8.684935243122916e-09,
   2.370619875728575e-10,   2.010027624647400e-12,  -2.169266082061280e-14,  -8.761258111034259e-16,  -9.808244066910267e-18,   6.037251424471311e-20,   3.807686981599923e-21,
   5.247960288977939e-23,  -1.335370889398582e-25,   1.610365545003474e+00,  -8.339528397029521e-03,  -1.024443664835142e-04,  -5.157461866061082e-07,   8.686532402724204e-09,
   2.370377492057322e-10,   2.008725864584651e-12,  -2.171136153083589e-14,  -8.759807753020790e-16,  -9.797129714421486e-18,   6.055588746636502e-20,   3.807122264063675e-21,
   5.239294263662813e-23,  -1.351825186703164e-25,   1.610363653469932e+00,  -8.339556916956871e-03,  -1.024434025444709e-04,  -5.157024053421356e-07,   8.687088227723943e-09,
   2.370293111930122e-10,   2.008272791999879e-12,  -2.171786882359321e-14,  -8.759302600606720e-16,  -9.793261392425728e-18,   6.061968845142830e-20,   3.806925177075960e-21,
   5.236277945731737e-23,  -1.357549514772562e-25,   1.610363353310158e+00,  -8.339561442602268e-03,  -1.024432495787380e-04,  -5.156954579064074e-07,   8.687176425649950e-09,
   2.370279721193695e-10,   2.008200896424265e-12,  -2.171890136249649e-14,  -8.759222423641131e-16,  -9.792647549186920e-18,   6.062981166186561e-20,   3.806893876840402e-21,
   5.235799296281395e-23,  -1.358457756679934e-25,   1.835386162926242e+00,  -3.991159250611237e-03,  -6.630909468004396e-05,  -8.436122170588400e-07,  -7.445588893419119e-09,
  -1.324312582081274e-11,   1.117060607822652e-12,   2.756106656525903e-14,   3.861934986290205e-16,   2.734080838321633e-18,  -2.587081669852458e-20,  -1.272897791307439e-21,
  -2.428158461852243e-23,  -2.709280196311697e-25,   1.835379938071530e+00,  -3.991396558100756e-03,  -6.631327387459415e-05,  -8.436241749042843e-07,  -7.444006073154508e-09,
  -1.318872144924379e-11,   1.118071995084963e-12,   2.757012070710781e-14,   3.860795212680506e-16,   2.727441881815278e-18,  -2.602117599936661e-20,  -1.274845730199145e-21,
  -2.428429731929831e-23,  -2.703294083927751e-25,   1.835368953899833e+00,  -3.991815293560198e-03,  -6.632064740257220e-05,  -8.436452332003748e-07,  -7.441212006487944e-09,
  -1.309270967178739e-11,   1.119856357670851e-12,   2.758607861106335e-14,   3.858778906098237e-16,   2.715719206784544e-18,  -2.628649962964151e-20,  -1.278279308875210e-21,
  -2.428895996584556e-23,  -2.692708202697556e-25,   1.835355671180506e+00,  -3.992321637482412e-03,  -6.632956231219456e-05,  -8.436706263309922e-07,  -7.437831421346836e-09,
  -1.297658665795383e-11,   1.122013607515991e-12,   2.760534390889616e-14,   3.856331971346899e-16,   2.701530167788152e-18,  -2.660735230656384e-20,  -1.282425097939032e-21,
  -2.429438663414550e-23,  -2.679867951407148e-25,   1.835342775979450e+00,  -3.992813192133488e-03,  -6.633821545400919e-05,  -8.436952034066799e-07,  -7.434547545224640e-09,
  -1.286383076677352e-11,   1.124107387061202e-12,   2.762401366605210e-14,   3.853947318767862e-16,   2.687741198649570e-18,  -2.691885146158851e-20,  -1.286443325844937e-21,
  -2.429943319374927e-23,  -2.667361324573746e-25,   1.835332387366911e+00,  -3.993209185555712e-03,  -6.634518538209673e-05,  -8.437149492543628e-07,  -7.431900619665253e-09,
  -1.277297770598734e-11,   1.125793791793310e-12,   2.763903036479838e-14,   3.852019674006807e-16,   2.676622607651916e-18,  -2.716980574148072e-20,  -1.289675740723831e-21,
  -2.430333980547393e-23,  -2.657256411845692e-25,   1.835325522557906e+00,  -3.993470852611168e-03,  -6.634979053071933e-05,  -8.437279709446889e-07,  -7.430150854977543e-09,
  -1.271293462927680e-11,   1.126907982590676e-12,   2.764894166177051e-14,   3.850742689228828e-16,   2.669270563817524e-18,  -2.733563885778025e-20,  -1.291809398722921e-21,
  -2.430584342203471e-23,  -2.650564714339176e-25,   1.835321997088503e+00,  -3.993605231676217e-03,  -6.635215535393018e-05,  -8.437346501600690e-07,  -7.429252043374512e-09,
  -1.268209685693078e-11,   1.127480124757663e-12,   2.765402803860866e-14,   3.850085897065529e-16,   2.665493368230242e-18,  -2.742080422910233e-20,  -1.292904433250430e-21,
  -2.430710508024394e-23,  -2.647123709261776e-25,   1.835320770006799e+00,  -3.993652003621843e-03,  -6.635297842986236e-05,  -8.437369736412158e-07,  -7.428939168150989e-09,
  -1.267136304550043e-11,   1.127679256412511e-12,   2.765579783363272e-14,   3.849857135434264e-16,   2.664178430953251e-18,  -2.745044715286348e-20,  -1.293285458388977e-21,
  -2.430754037950961e-23,  -2.645925319976365e-25,   1.835320575285368e+00,  -3.993659425689324e-03,  -6.635310903961172e-05,  -8.437373422848632e-07,  -7.428889517471319e-09,
  -1.266965971645743e-11,   1.127710855499618e-12,   2.765607864890382e-14,   3.849820826560713e-16,   2.663969756661429e-18,  -2.745515109252319e-20,  -1.293345916528869e-21,
  -2.430760927355680e-23,  -2.645735118115840e-25,   1.968104864422206e+00,  -8.262397644536205e-04,  -1.580514567232284e-05,  -2.630281586354309e-07,  -3.988096265831072e-09,
  -5.588489480550787e-11,  -7.226753412164475e-13,  -8.479642195528838e-15,  -8.617502145530896e-17,  -6.532220405532539e-19,  -7.283609818210425e-22,   1.054368587233885e-22,
   2.889645879365886e-24,   5.499359449464353e-26,   1.968103378177720e+00,  -8.263139260464746e-04,  -1.580739472507599e-05,  -2.630806913099995e-07,  -3.989115201826319e-09,
  -5.590162386960759e-11,  -7.229015997276706e-13,  -8.481832164607398e-15,  -8.617750632213936e-17,  -6.526624406646851e-19,  -7.101311727137145e-22,   1.058455586653290e-22,
   2.897186731421385e-24,   5.511231056042292e-26,   1.968100755503796e+00,  -8.264447973821969e-04,  -1.581136368070524e-05,  -2.631733988035597e-07,  -3.990913389143733e-09,
  -5.593114606485175e-11,  -7.233008413816820e-13,  -8.485694852330323e-15,  -8.618182807472096e-17,  -6.516732978218625e-19,  -6.779263330673501e-22,   1.065674234879784e-22,
   2.910503554948374e-24,   5.532190248989123e-26,   1.968097583844914e+00,  -8.266030689282204e-04,  -1.581616378004268e-05,  -2.632855234588761e-07,  -3.993088217610950e-09,
  -5.596685058224199e-11,  -7.237836170060954e-13,  -8.490363014305503e-15,  -8.618694675730049e-17,  -6.504742808898377e-19,  -6.389189729861964e-22,   1.074415166964734e-22,
   2.926624939012347e-24,   5.557554012947610e-26,   1.968094504545938e+00,  -8.267567377053089e-04,  -1.582082446683109e-05,  -2.633943949263131e-07,  -3.995199965413690e-09,
  -5.600151815239201e-11,  -7.242522958525409e-13,  -8.494892015074113e-15,  -8.619180348450630e-17,  -6.493072200775434e-19,  -6.009832675470931e-22,   1.082913353406177e-22,
   2.942294715802368e-24,   5.582197302253105e-26,   1.968092023682428e+00,  -8.268805466801854e-04,  -1.582457965272996e-05,  -2.634821166973888e-07,  -3.996901492987247e-09,
  -5.602945036742437e-11,  -7.246298635346981e-13,  -8.498538531531718e-15,  -8.619563538501848e-17,  -6.483648453401005e-19,  -5.703739756546767e-22,   1.089768443250817e-22,
   2.954931997642351e-24,   5.602064346906538e-26,   1.968090384264142e+00,  -8.269623649893554e-04,  -1.582706130512643e-05,  -2.635400896786217e-07,  -3.998025994167078e-09,
  -5.604790966620012e-11,  -7.248793564853994e-13,  -8.500947110254887e-15,  -8.619812793241434e-17,  -6.477410601808156e-19,  -5.501240028003014e-22,   1.094302602885584e-22,
   2.963289301458526e-24,   5.615199341314895e-26,   1.968089542311046e+00,  -8.270043849392308e-04,  -1.582833584282413e-05,  -2.635698640518680e-07,  -3.998603529450527e-09,
  -5.605739007610285e-11,  -7.250074839593115e-13,  -8.502183729084514e-15,  -8.619939575078116e-17,  -6.474203822740524e-19,  -5.397172792167916e-22,   1.096632483783130e-22,
   2.967583284014976e-24,   5.621947016086304e-26,   1.968089249256249e+00,  -8.270190107390631e-04,  -1.582877947174191e-05,  -2.635802276889354e-07,  -3.998804553874386e-09,
  -5.606068992731401e-11,  -7.250520800435507e-13,  -8.502614097556703e-15,  -8.619983507988069e-17,  -6.473087141440739e-19,  -5.360939464426784e-22,   1.097443638777379e-22,
   2.969078179443529e-24,   5.624295960425635e-26,   1.968089202752237e+00,  -8.270213316697017e-04,  -1.582884987022504e-05,  -2.635818722741025e-07,  -3.998836454060713e-09,
  -5.606121357336875e-11,  -7.250591568347356e-13,  -8.502682388825222e-15,  -8.619990470292984e-17,  -6.472909914216322e-19,  -5.355189175359243e-22,   1.097572368282404e-22,
   2.969315414686436e-24,   5.624668722360913e-26,   1.363902012712093e-02,  -3.564308592372355e-04,   6.937569657977327e-06,  -1.189582120835957e-07,   1.889812175897266e-09,
  -2.840698967699722e-11,   4.076414334751267e-13,  -5.602820184190221e-15,   7.363864242225634e-17,  -9.203275161013158e-19,   1.079241818226634e-20,  -1.156677976124124e-22,
   1.059549614532534e-24,  -6.543744168258239e-27,   1.363967266355074e-02,  -3.564644103225237e-04,   6.938635925240931e-06,  -1.189849367933873e-07,   1.890387719156567e-09,
  -2.841806989731157e-11,   4.078356798495522e-13,  -5.605941885091891e-15,   7.368438319409042e-17,  -9.209257400196585e-19,   1.079896212737081e-20,  -1.157145637340207e-22,
   1.059296066230929e-24,  -6.524215288758818e-27,   1.364082415602241e-02,  -3.565236178682578e-04,   6.940517634376770e-06,  -1.190321014255237e-07,   1.891403496758755e-09,
  -2.843762612495177e-11,   4.081785283827663e-13,  -5.611451818314220e-15,   7.376511594087261e-17,  -9.219815104784765e-19,   1.081050770433017e-20,  -1.157969659644810e-22,
   1.058844899385909e-24,  -6.489665448394110e-27,   1.364221669230031e-02,  -3.565952227151288e-04,   6.942793466997465e-06,  -1.190891478324524e-07,   1.892632165289753e-09,
  -2.846128225940213e-11,   4.085932711965384e-13,  -5.618117290036491e-15,   7.386277709178722e-17,  -9.232584914545125e-19,   1.082446648047718e-20,  -1.158964071984061e-22,
   1.058292894698788e-24,  -6.447732308160297e-27,   1.364356868828250e-02,  -3.566647464057971e-04,   6.945003277056341e-06,  -1.191445426109362e-07,   1.893825332834719e-09,
  -2.848425616535123e-11,   4.089960709538856e-13,  -5.624590948878398e-15,   7.395762489853498e-17,  -9.244985097753488e-19,   1.083801503657520e-20,  -1.159927326705791e-22,
   1.057750253329783e-24,  -6.406861612450032e-27,   1.364465794319077e-02,  -3.567207616300098e-04,   6.946783808939790e-06,  -1.191891787556803e-07,   1.894786817899817e-09,
  -2.850277005240785e-11,   4.093206863393722e-13,  -5.629808146981211e-15,   7.403406175245481e-17,  -9.254977009382739e-19,   1.084892785858841e-20,  -1.160701801635304e-22,
   1.057308253425099e-24,  -6.373819901387616e-27,   1.364537775461420e-02,  -3.567577793329916e-04,   6.947960518031294e-06,  -1.192186788293500e-07,   1.895422289579885e-09,
  -2.851500683694941e-11,   4.095352476867151e-13,  -5.633256608230449e-15,   7.408458391217253e-17,  -9.261580702220056e-19,   1.085613801074435e-20,  -1.161212819913214e-22,
   1.057013807300500e-24,  -6.351929247120421e-27,   1.364574742805219e-02,  -3.567767908825796e-04,   6.948564865592204e-06,  -1.192338301693402e-07,   1.895748677834394e-09,
  -2.852129198184978e-11,   4.096454541599679e-13,  -5.635027876552272e-15,   7.411053380291020e-17,  -9.264972390149053e-19,   1.085984050615097e-20,  -1.161475022812945e-22,
   1.056861858245777e-24,  -6.340669615777249e-27,   1.364587609879796e-02,  -3.567834082156367e-04,   6.948775222437099e-06,  -1.192391039931847e-07,   1.895862287123918e-09,
  -2.852347973861203e-11,   4.096838155501128e-13,  -5.635644433415436e-15,   7.411956659162382e-17,  -9.266152957978466e-19,   1.086112915166807e-20,  -1.161566248380913e-22,
   1.056808853610871e-24,  -6.336747773219054e-27,   1.364589651719288e-02,  -3.567844583042357e-04,   6.948808603557832e-06,  -1.192399408887974e-07,   1.895880315679596e-09,
  -2.852382691281582e-11,   4.096899031176805e-13,  -5.635742274905342e-15,   7.412100000362309e-17,  -9.266340300671681e-19,   1.086133363997241e-20,  -1.161580722886385e-22,
   1.056800436931870e-24,  -6.336125296683850e-27,   1.207433072328059e-01,  -2.994000986666453e-03,   5.221289774862016e-05,  -7.331692931305451e-07,   8.153768955669565e-09,
  -5.902346211167377e-11,  -1.402494841145182e-13,   1.472776983791843e-14,  -3.197868567475115e-16,   4.534582094592452e-18,  -3.970174431948706e-20,  -5.547516964216782e-23,
   1.065601716738404e-23,  -2.552838321990344e-25,   1.207482113870904e-01,  -2.994207384110607e-03,   5.221748305965711e-05,  -7.332243814462205e-07,   8.153561757485804e-09,
  -5.899422361499369e-11,  -1.410923305232711e-13,   1.474306435787996e-14,  -3.199521711325989e-16,   4.534222547552182e-18,  -3.963427520997388e-20,  -5.736126594903822e-23,
   1.068915415434270e-23,  -2.556358126208295e-25,   1.207568651939524e-01,  -2.994571588206754e-03,   5.222557381613202e-05,  -7.333215632870557e-07,   8.153195188072451e-09,
  -5.894260735132618e-11,  -1.425798977719204e-13,   1.477005073868899e-14,  -3.202436382109123e-16,   4.533580194781982e-18,  -3.951505826525699e-20,  -6.069139078647750e-23,
   1.074761988041947e-23,  -2.562558245392805e-25,   1.207673300655540e-01,  -2.995012009101761e-03,   5.223535707963916e-05,  -7.334390384709479e-07,   8.152750282812170e-09,
  -5.888015068084493e-11,  -1.443792789800750e-13,   1.480268117003492e-14,  -3.205956860584911e-16,   4.532789933898992e-18,  -3.937061574574704e-20,  -6.472175252315971e-23,
   1.081830856262020e-23,  -2.570037330171334e-25,   1.207774898057538e-01,  -2.995439584499464e-03,   5.224485432863189e-05,  -7.335530413936275e-07,   8.152316652870939e-09,
  -5.881947512543195e-11,  -1.461267139376091e-13,   1.483435633583690e-14,  -3.209370315111555e-16,   4.532008595621901e-18,  -3.923009594790432e-20,  -6.863805858026604e-23,
   1.088692260074968e-23,  -2.577278823260798e-25,   1.207856748074252e-01,  -2.995784049737744e-03,   5.225250506406492e-05,  -7.336448520284005e-07,   8.151966091017717e-09,
  -5.877056437660945e-11,  -1.475348736276646e-13,   1.485987206836837e-14,  -3.212117161932222e-16,   4.531369003942494e-18,  -3.911668188504380e-20,  -7.179563137968696e-23,
   1.094219036383818e-23,  -2.583098774906746e-25,   1.207910835296249e-01,  -2.996011674092113e-03,   5.225756047250808e-05,  -7.337055048341556e-07,   8.151733841098019e-09,
  -5.873822969510825e-11,  -1.484655800919614e-13,   1.487673173410135e-14,  -3.213930765072442e-16,   4.530941398488860e-18,  -3.904163554000259e-20,  -7.388339396576875e-23,
   1.097870692338767e-23,  -2.586937772650156e-25,   1.207938612349705e-01,  -2.996128572520430e-03,   5.226015664767426e-05,  -7.337366486133347e-07,   8.151614382561800e-09,
  -5.872161954815073e-11,  -1.489436102890967e-13,   1.488538976901406e-14,  -3.214861683909736e-16,   4.530720263708292e-18,  -3.900306338042802e-20,  -7.495596001743081e-23,
   1.099745886215047e-23,  -2.588907199612101e-25,   1.207948280515312e-01,  -2.996169260475911e-03,   5.226106026719507e-05,  -7.337474878000681e-07,   8.151572774137480e-09,
  -5.871583747964982e-11,  -1.491100038835010e-13,   1.488840324379475e-14,  -3.215185626566629e-16,   4.530643050683886e-18,  -3.898963284967051e-20,  -7.532934011509576e-23,
   1.100398547602605e-23,  -2.589592344963530e-25,   1.207949814725158e-01,  -2.996175717112452e-03,   5.226120365902471e-05,  -7.337492077969258e-07,   8.151566170039465e-09,
  -5.871491990918084e-11,  -1.491364087682997e-13,   1.488888143914496e-14,  -3.215237028378196e-16,   4.530630786406683e-18,  -3.898750136552192e-20,  -7.538859341590801e-23,
   1.100502115166306e-23,  -2.589701052340667e-25,   3.243578436595291e-01,  -7.211370551677134e-03,   9.766478750500003e-05,  -7.272850991301136e-07,  -3.253165141471760e-09,
   1.931869879990671e-10,  -2.803479788151937e-12,   8.038599763495843e-15,   5.242536376526210e-16,  -1.219137198943649e-17,   1.025629095692465e-19,   1.236729133367476e-21,
  -5.318532832722507e-23,   7.324353535193061e-25,   3.243669959969835e-01,  -7.211574461798421e-03,   9.766293545126605e-05,  -7.271038597451916e-07,  -3.257091136610934e-09,
   1.932021626139706e-10,  -2.802094939386362e-12,   7.997626290515934e-15,   5.246757521879836e-16,  -1.218479209220210e-17,   1.022340699488805e-19,   1.241965702678498e-21,
  -5.318055721045466e-23,   7.302760713329884e-25,   3.243831452968469e-01,  -7.211934222957191e-03,   9.765966568171988e-05,  -7.267840486290879e-07,  -3.264017030218157e-09,
   1.932288729642109e-10,  -2.799650457479506e-12,   7.925346155130361e-15,   5.254194522938424e-16,  -1.217315993036415e-17,   1.016538549896066e-19,   1.251192840377233e-21,
  -5.317180075617177e-23,   7.264634309731624e-25,   3.244026729579223e-01,  -7.212369179303083e-03,   9.765570878712512e-05,  -7.263973102574131e-07,  -3.272389188824556e-09,
   1.932610597482376e-10,  -2.796693040334477e-12,   7.837975320390904e-15,   5.263168197713964e-16,  -1.215905701160997e-17,   1.009523012939684e-19,   1.262328437124362e-21,
  -5.316063696370256e-23,   7.218488150623158e-25,   3.244216298167316e-01,  -7.212791353365313e-03,   9.765186430452387e-05,  -7.260218511178350e-07,  -3.280513900953113e-09,
   1.932921892206725e-10,  -2.793820437665836e-12,   7.753189822323102e-15,   5.271859553103384e-16,  -1.214532725032941e-17,   1.002712973083853e-19,   1.273115675798974e-21,
  -5.314919742180989e-23,   7.173645198068042e-25,   3.244369010317759e-01,  -7.213131398256522e-03,   9.764876494855423e-05,  -7.257193716586967e-07,  -3.287057031835681e-09,
   1.933171829782457e-10,  -2.791505166202456e-12,   7.684911119225676e-15,   5.278846771590481e-16,  -1.213423890060763e-17,   9.972272779628814e-20,   1.281789242227742e-21,
  -5.313955103727942e-23,   7.137488216124645e-25,   3.244469918885625e-01,  -7.213356067891034e-03,   9.764671582789539e-05,  -7.255194915534371e-07,  -3.291379621208828e-09,
   1.933336574136921e-10,  -2.789974718434249e-12,   7.639805236487578e-15,   5.283456738799807e-16,  -1.212689830252235e-17,   9.936026207824511e-20,   1.287512501445643e-21,
  -5.313296610582923e-23,   7.113580699951377e-25,   3.244521739984909e-01,  -7.213471438466216e-03,   9.764566315961092e-05,  -7.254168413725349e-07,  -3.293599169928356e-09,
   1.933421051482566e-10,  -2.789188587951228e-12,   7.616644757181206e-15,   5.285821993518943e-16,  -1.212312434674616e-17,   9.917412462942026e-20,   1.290449169628039e-21,
  -5.312951928301629e-23,   7.101298231222578e-25,   3.244539776748715e-01,  -7.213511592972694e-03,   9.764529671357014e-05,  -7.253811126897381e-07,  -3.294371655186902e-09,
   1.933450434416869e-10,  -2.788914940614456e-12,   7.608584105661823e-15,   5.286644894390278e-16,  -1.212181011730505e-17,   9.910933875542998e-20,   1.291470905925075e-21,
  -5.312830921690315e-23,   7.097022440460511e-25,   3.244542638932619e-01,  -7.213517964879149e-03,   9.764523856100960e-05,  -7.253754430233597e-07,  -3.294494235632333e-09,
   1.933455096125917e-10,  -2.788871515249215e-12,   7.607305018125948e-15,   5.286775460919309e-16,  -1.212160153541098e-17,   9.909905817566837e-20,   1.291633022510103e-21,
  -5.312811670394789e-23,   7.096343895066085e-25,   6.038752020637794e-01,  -1.127157094826576e-02,   9.124568731358643e-05,   4.596909821021558e-07,  -2.028787215698497e-08,
   1.203137984166360e-10,   3.396470317287806e-12,  -6.924898927151701e-14,  -9.953386332158193e-17,   2.057953283695679e-17,  -2.207527362319132e-19,  -3.441448561966544e-21,
   1.102919962249949e-22,  -3.098759394542154e-25,   6.038837334761821e-01,  -1.127144126738351e-02,   9.123430234759247e-05,   4.598026401105378e-07,  -2.028309922027923e-08,
   1.201785610823769e-10,   3.396190316542203e-12,  -6.917999835244416e-14,  -1.004436722310583e-16,   2.056171131727583e-17,  -2.200824830932665e-19,  -3.443456855109624e-21,
   1.100287459845775e-22,  -3.051756968940282e-25,   6.038987864232698e-01,  -1.127121241808896e-02,   9.121421557762285e-05,   4.599995596866798e-07,  -2.027467762571032e-08,
   1.199400428726690e-10,   3.395694322163118e-12,  -6.905831174418589e-14,  -1.020467562090658e-16,   2.053025680867811e-17,  -2.189011317018145e-19,  -3.446972861176172e-21,
   1.095645469501815e-22,  -2.969031693692852e-25,   6.039169871341171e-01,  -1.127093564788991e-02,   9.118993016051314e-05,   4.602375018257605e-07,  -2.026449470320998e-08,
   1.196518119414216e-10,   3.395091275270283e-12,  -6.891125048259785e-14,  -1.039813240853908e-16,   2.049220785180701e-17,  -2.174748800046931e-19,  -3.451177378402498e-21,
   1.090037621774972e-22,  -2.869359105620026e-25,   6.039346545261554e-01,  -1.127066691896699e-02,   9.116635819311813e-05,   4.604683086286759e-07,  -2.025460988626898e-08,
   1.193721989745125e-10,   3.394502411817612e-12,  -6.876857339951694e-14,  -1.058552906795223e-16,   2.045525620213590e-17,  -2.160926554283137e-19,  -3.455209863778331e-21,
   1.084599177209601e-22,  -2.772974730053219e-25,   6.039488860419797e-01,  -1.127045040206677e-02,   9.114737171349026e-05,   4.606541123004539e-07,  -2.024664722890294e-08,
   1.191470872422678e-10,   3.394025572213723e-12,  -6.865369726353678e-14,  -1.073620144138916e-16,   2.042547820060769e-17,  -2.149808402984278e-19,  -3.458423216004817e-21,
   1.080222025815183e-22,  -2.695597726755730e-25,   6.039582894328988e-01,  -1.127030731571050e-02,   9.113482715237513e-05,   4.607768237959768e-07,  -2.024138585423120e-08,
   1.189984063581507e-10,   3.393709282380919e-12,  -6.857781984797543e-14,  -1.083562023320844e-16,   2.040579644582972e-17,  -2.142469982823380e-19,  -3.460529354926990e-21,
   1.077331638118903e-22,  -2.644599911342450e-25,   6.039631183567054e-01,  -1.127023382912094e-02,   9.112838534256798e-05,   4.608398221516458e-07,  -2.023868395086633e-08,
   1.189220729256930e-10,   3.393546480723870e-12,  -6.853886265637417e-14,  -1.088663239275672e-16,   2.039568738841157e-17,  -2.138703905397878e-19,  -3.461605649407257e-21,
   1.075847891262306e-22,  -2.618450731951688e-25,   6.039647990812141e-01,  -1.127020825066062e-02,   9.112614327894378e-05,   4.608617461435111e-07,  -2.023774353890015e-08,
   1.188955077685968e-10,   3.393489756964958e-12,  -6.852530476030154e-14,  -1.090438061590059e-16,   2.039216859463120e-17,  -2.137393493941642e-19,  -3.461979419003598e-21,
   1.075331556037027e-22,  -2.609355737008608e-25,   6.039650657877814e-01,  -1.127020419167422e-02,   9.112578749751844e-05,   4.608652250289398e-07,  -2.023759430895917e-08,
   1.188912924051018e-10,   3.393480752877990e-12,  -6.852315338066208e-14,  -1.090719668096996e-16,   2.039161019895827e-17,  -2.137185568976787e-19,  -3.462038691009027e-21,
   1.075249625328061e-22,  -2.607912793483106e-25,   9.299667447403206e-01,  -1.342199802540867e-02,   2.139399954695631e-05,   1.585665957359835e-06,  -7.304770812083704e-09,
  -3.297876328122722e-10,   2.596749589650094e-12,   8.123588943208007e-14,  -9.454564007030372e-16,  -2.151975999405857e-17,   3.476696032869949e-19,   5.834374614096013e-21,
  -1.287069261723066e-22,  -1.567188480317776e-24,   9.299687422169206e-01,  -1.342155314175790e-02,   2.138991105469598e-05,   1.585358116011629e-06,  -7.301148092540401e-09,
  -3.296288412364928e-10,   2.594297473025812e-12,   8.116403149455252e-14,  -9.440146027343845e-16,  -2.149011298061240e-17,   3.468914220264810e-19,   5.823125418927100e-21,
  -1.283124211196616e-22,  -1.563354456217286e-24,   9.299722664866683e-01,  -1.342076820770404e-02,   2.138269849559139e-05,   1.584815045780086e-06,  -7.294758538633341e-09,
  -3.293487656354399e-10,   2.589973736517053e-12,   8.103731805931427e-14,  -9.414731806137834e-16,  -2.143784729994192e-17,   3.455202789412505e-19,   5.803298710095684e-21,
  -1.276176269459121e-22,  -1.556598187687039e-24,   9.299765275442838e-01,  -1.341981917664652e-02,   2.137397980424816e-05,   1.584158565146739e-06,  -7.287036979504259e-09,
  -3.290102905954912e-10,   2.584750644982033e-12,   8.088423288762359e-14,  -9.384045849419526e-16,  -2.137472705376559e-17,   3.438656325593408e-19,   5.779362665066232e-21,
  -1.267797148252906e-22,  -1.548443643511697e-24,   9.299806635534780e-01,  -1.341889799892994e-02,   2.136551879339940e-05,   1.583521480435233e-06,  -7.279546002759684e-09,
  -3.286819093615883e-10,   2.579685616240045e-12,   8.073576492421531e-14,  -9.354303718763706e-16,  -2.131353467590405e-17,   3.422628375289470e-19,   5.756166366425343e-21,
  -1.259686255328747e-22,  -1.540543261043606e-24,   9.299839950734269e-01,  -1.341815599983370e-02,   2.135870482152023e-05,   1.583008407501524e-06,  -7.273514934742060e-09,
  -3.284175161365992e-10,   2.575609202200273e-12,   8.061626449783143e-14,  -9.330377668903755e-16,  -2.126429877909787e-17,   3.409741554261920e-19,   5.737508643464286e-21,
  -1.253168966568998e-22,  -1.534190201103195e-24,   9.299861962889563e-01,  -1.341766574395818e-02,   2.135420330231575e-05,   1.582669453537908e-06,  -7.269531457299461e-09,
  -3.282428814657403e-10,   2.572917492113848e-12,   8.053735135713553e-14,  -9.314584305742971e-16,  -2.123179387434899e-17,   3.401238439585599e-19,   5.725194096222108e-21,
  -1.248870641377821e-22,  -1.529997781839489e-24,   9.299873266586186e-01,  -1.341741398768604e-02,   2.135189187591100e-05,   1.582495407800890e-06,  -7.267486290461158e-09,
  -3.281532203616527e-10,   2.571535761101389e-12,   8.049684132904289e-14,  -9.306478771019574e-16,  -2.121511010635855e-17,   3.396875473575598e-19,   5.718874358260470e-21,
  -1.246665773499330e-22,  -1.527846495313902e-24,   9.299877200846057e-01,  -1.341732636377148e-02,   2.135108741357805e-05,   1.582434833303870e-06,  -7.266774537275738e-09,
  -3.281220165198384e-10,   2.571054931016237e-12,   8.048274393296780e-14,  -9.303658379102579e-16,  -2.120930460939010e-17,   3.395357506402505e-19,   5.716675411252750e-21,
  -1.245898751207106e-22,  -1.527097994285990e-24,   9.299877825154393e-01,  -1.341731245916563e-02,   2.135095975889632e-05,   1.582425221141823e-06,  -7.266661595923447e-09,
  -3.281170650672938e-10,   2.570978634368022e-12,   8.048050698856819e-14,  -9.303210860369722e-16,  -2.120838342538847e-17,   3.395116654542890e-19,   5.716326501667461e-21,
  -1.245777054419736e-22,  -1.526979230484676e-24,   1.266806619095339e+00,  -1.264246396045092e-02,  -6.682101250127820e-05,   1.148757664460778e-06,   1.927290605789267e-08,
  -1.256107638742996e-10,  -5.614965442254123e-12,  -5.837984373060154e-15,   1.549849455838059e-15,   1.302959767643916e-17,  -3.805405671392766e-19,  -6.987987699263800e-21,
   7.043194265385527e-23,   2.854074496908012e-24,   1.266800376310418e+00,  -1.264214128811704e-02,  -6.681021578819930e-05,   1.148639814381508e-06,   1.926505770091859e-08,
  -1.256215745170720e-10,  -5.610929920305568e-12,  -5.794925168090195e-15,   1.548258030012985e-15,   1.299435449369362e-17,  -3.801057262663720e-19,  -6.967639878640127e-21,
   7.041206474009575e-23,   2.844562851431676e-24,   1.266789361635694e+00,  -1.264157195466181e-02,  -6.679116839578538e-05,   1.148431858029389e-06,   1.925121375221838e-08,
  -1.256405815957219e-10,  -5.603812566075413e-12,  -5.719042647703240e-15,   1.545451424645209e-15,   1.293225210794922e-17,  -3.793385483742310e-19,  -6.931791989355494e-21,
   7.037647401284517e-23,   2.827808109109884e-24,   1.266776043967011e+00,  -1.264088355652480e-02,  -6.676814218414352e-05,   1.148180381324577e-06,   1.923448134337423e-08,
  -1.256634485151326e-10,  -5.595211959484210e-12,  -5.627448434360645e-15,   1.542060188679231e-15,   1.285730160972121e-17,  -3.784110506048711e-19,  -6.888539980166299e-21,
   7.033256056662947e-23,   2.807596984389696e-24,   1.266763116863995e+00,  -1.264021531965998e-02,  -6.674579512121220e-05,   1.147936237831236e-06,   1.921824601902711e-08,
  -1.256855253108258e-10,  -5.586868683377653e-12,  -5.538701623321543e-15,   1.538770696329568e-15,   1.278469194165115e-17,  -3.775108445870921e-19,  -6.846651684754473e-21,
   7.028901556652551e-23,   2.788027497455956e-24,   1.266752704003268e+00,  -1.263967703121797e-02,  -6.672779719128019e-05,   1.147739548821571e-06,   1.920517293185901e-08,
  -1.257032227620538e-10,  -5.580151777116375e-12,  -5.467330915313764e-15,   1.536122630307363e-15,   1.272630656844052e-17,  -3.767857900148405e-19,  -6.812978568380117e-21,
   7.025328347723232e-23,   2.772299151572113e-24,   1.266745823882161e+00,  -1.263932135669047e-02,  -6.671590671851456e-05,   1.147609575253182e-06,   1.919653734629658e-08,
  -1.257148742023104e-10,  -5.575715483658878e-12,  -5.420230378387999e-15,   1.534373768702130e-15,   1.268777939066441e-17,  -3.763067558998632e-19,  -6.790762963387901e-21,
   7.022935372429343e-23,   2.761924029844517e-24,   1.266742290769024e+00,  -1.263913870602434e-02,  -6.670980108404238e-05,   1.147542826071076e-06,   1.919210344961678e-08,
  -1.257208445708473e-10,  -5.573437889709954e-12,  -5.396060528552673e-15,   1.533475933183267e-15,   1.266801016928134e-17,  -3.760607704440543e-19,  -6.779364999381519e-21,
   7.021696632736772e-23,   2.756601436355148e-24,   1.266741061061834e+00,  -1.263907513361871e-02,  -6.670767607224490e-05,   1.147519593162727e-06,   1.919056033289687e-08,
  -1.257229205109910e-10,  -5.572645256541998e-12,  -5.387650939817955e-15,   1.533163479251755e-15,   1.266113190905370e-17,  -3.759751563856464e-19,  -6.775399554137041e-21,
   7.021263914616506e-23,   2.754749738613587e-24,   1.266740865925435e+00,  -1.263906504559294e-02,  -6.670733886736988e-05,   1.147515906408551e-06,   1.919031546824856e-08,
  -1.257232498343605e-10,  -5.572519481524000e-12,  -5.386316593873710e-15,   1.533113899297038e-15,   1.266004054721285e-17,  -3.759615707768519e-19,  -6.774770374251742e-21,
   7.021195174027782e-23,   2.754455941436685e-24,   1.575436865848709e+00,  -9.180127764189534e-03,  -1.077154587308020e-04,  -3.391359357704223e-07,   1.382853554182866e-08,
   2.755910721974111e-10,   9.916143029661965e-13,  -5.443105176214212e-14,  -1.150390179483073e-15,  -3.653791744767990e-18,   2.746262524564985e-19,   5.753289714920343e-21,
   1.396557286907315e-23,  -1.569116537785669e-24,   1.575426783174752e+00,  -9.180222239312797e-03,  -1.077076725426185e-04,  -3.388784723412589e-07,   1.382989460617492e-08,
   2.754837289124314e-10,   9.886185174427465e-13,  -5.444262340430068e-14,  -1.149229278670693e-15,  -3.624573656628190e-18,   2.747004176941400e-19,   5.741797552250386e-21,
   1.370019377191153e-23,  -1.569469307668102e-24,   1.575408992732029e+00,  -9.180388883442770e-03,  -1.076939330776772e-04,  -3.384242559349119e-07,   1.383228928103039e-08,
   2.752943018465663e-10,   9.833348855736826e-13,  -5.446296190705899e-14,  -1.147180607252191e-15,  -3.573066072615733e-18,   2.748299566661144e-19,   5.721517596042208e-21,
   1.323267148582223e-23,  -1.570073713993613e-24,   1.575387481351608e+00,  -9.180590291210489e-03,  -1.076773181250335e-04,  -3.378751521986944e-07,   1.383517912557277e-08,
   2.750652137531300e-10,   9.769500883964817e-13,  -5.448741939544297e-14,  -1.144702919506994e-15,  -3.510864728274541e-18,   2.749843369050335e-19,   5.696991767561427e-21,
   1.266860588127021e-23,  -1.570773826445127e-24,   1.575366599536701e+00,  -9.180785709583158e-03,  -1.076611875238271e-04,  -3.373422379912996e-07,   1.383797844249463e-08,
   2.748427867909866e-10,   9.707562646574515e-13,  -5.451101995087868e-14,  -1.142297195254304e-15,  -3.450566800595432e-18,   2.751318435315756e-19,   5.673179376508873e-21,
   1.212234782279424e-23,  -1.571421360205756e-24,   1.575349778178284e+00,  -9.180943061004275e-03,  -1.076481921392433e-04,  -3.369130339923191e-07,   1.384022917112258e-08,
   2.746635795253051e-10,   9.657697729220206e-13,  -5.452993033897007e-14,  -1.140358871295806e-15,  -3.402053240661304e-18,   2.752489821470102e-19,   5.653994238817148e-21,
   1.168324021518235e-23,  -1.571920037788014e-24,   1.575338663296483e+00,  -9.181046999264444e-03,  -1.076396046381008e-04,  -3.366294749305030e-07,   1.384171427614642e-08,
   2.745451513280119e-10,   9.624763412918404e-13,  -5.454237612039637e-14,  -1.139077913736728e-15,  -3.370026539719378e-18,   2.753255583241563e-19,   5.641315998152000e-21,
   1.139355123350804e-23,  -1.572238329487721e-24,   1.575332955387953e+00,  -9.181100365168230e-03,  -1.076351944271535e-04,  -3.364838696485318e-07,   1.384247628809761e-08,
   2.744843293163127e-10,   9.607854869563481e-13,  -5.454875221011223e-14,  -1.138420035326069e-15,  -3.353588634871541e-18,   2.753646283165790e-19,   5.634804797874011e-21,
   1.124492603607492e-23,  -1.572398320112184e-24,   1.575330968716443e+00,  -9.181118937850346e-03,  -1.076336593940334e-04,  -3.364331929223745e-07,   1.384274140819031e-08,
   2.744631591069881e-10,   9.601970461018080e-13,  -5.455096901313432e-14,  -1.138191047512150e-15,  -3.347868758289783e-18,   2.753781863207827e-19,   5.632538465013241e-21,
   1.119321859250842e-23,  -1.572453454675706e-24,   1.575330653459905e+00,  -9.181121884993313e-03,  -1.076334158045251e-04,  -3.364251513437669e-07,   1.384278347410641e-08,
   2.744597996601760e-10,   9.601036722732014e-13,  -5.455132067278556e-14,  -1.138154709957977e-15,  -3.346961163232504e-18,   2.753803358592077e-19,   5.632178826838287e-21,
   1.118501442129874e-23,  -1.572462177591111e-24,   1.818293593870431e+00,  -4.564159852008810e-03,  -7.715046006321362e-05,  -9.631153164643583e-07,  -7.372281177286945e-09,
   2.430400732911361e-11,   2.074413842069557e-12,   4.116223698576021e-14,   4.490053131597924e-16,   1.865304199429716e-19,  -1.123612758252242e-19,  -2.757820852463290e-21,
  -3.641325185877571e-23,  -1.260394159345797e-25,   1.818286352737947e+00,  -4.564430644854433e-03,  -7.715459041156866e-05,  -9.630918501249730e-07,  -7.369350233416566e-09,
   2.438504859322367e-11,   2.075582519758078e-12,   4.116249492304239e-14,   4.485241557188658e-16,   1.722798448711316e-19,  -1.125836221633393e-19,  -2.758625333002304e-21,
  -3.634972893157800e-23,  -1.239180096992505e-25,   1.818273575332739e+00,  -4.564908457613522e-03,  -7.716187713271797e-05,  -9.630503816297343e-07,  -7.364177204565255e-09,
   2.452804741050611e-11,   2.077643638781414e-12,   4.116291093340004e-14,   4.476743858298694e-16,   1.471312283520295e-19,  -1.129756335012326e-19,  -2.760032219331051e-21,
  -3.623739465188145e-23,  -1.201732384685548e-25,   1.818258124224175e+00,  -4.565486224558593e-03,  -7.717068602259188e-05,  -9.630001321588089e-07,  -7.357919651962430e-09,
   2.470096346066700e-11,   2.080134206633386e-12,   4.116334726186593e-14,   4.466455398725184e-16,   1.167157428638622e-19,  -1.134491074471902e-19,  -2.761711896247008e-21,
  -3.610113792586635e-23,  -1.156424524657457e-25,   1.818243123996677e+00,  -4.566047100905853e-03,  -7.717923514055284e-05,  -9.629512405485723e-07,  -7.351842551241499e-09,
   2.486882768330185e-11,   2.082550163064217e-12,   4.116370097037278e-14,   4.456453987528574e-16,   8.718319267899018e-20,  -1.139081703517425e-19,  -2.763319928061551e-21,
  -3.596842194914490e-23,  -1.112413760037807e-25,   1.818231039608184e+00,  -4.566498928565724e-03,  -7.718612047895140e-05,  -9.629117750781087e-07,  -7.346945215565843e-09,
   2.500405710470684e-11,   2.084495104126066e-12,   4.116393584525699e-14,   4.448387277102251e-16,   6.338808619929892e-20,  -1.142775709853594e-19,  -2.764599161255977e-21,
  -3.586119254017872e-23,  -1.076940300490996e-25,   1.818223054263575e+00,  -4.566797484788059e-03,  -7.719066934567121e-05,  -9.628856583054955e-07,  -7.343708310165217e-09,
   2.509341437316402e-11,   2.085779638833749e-12,   4.116406652959293e-14,   4.443052190172498e-16,   4.766272506696009e-20,  -1.145214610990188e-19,  -2.765436533242229e-21,
  -3.579018308894386e-23,  -1.053490849682637e-25,   1.818218953346433e+00,  -4.566950806627078e-03,  -7.719300514588573e-05,  -9.628722341270160e-07,  -7.342045746740743e-09,
   2.513930362623169e-11,   2.086439108476613e-12,   4.116412605975096e-14,   4.440310899869588e-16,   3.958639058601871e-20,  -1.146466474213325e-19,  -2.765864113252536e-21,
  -3.575366868896732e-23,  -1.041445596441486e-25,   1.818217525975020e+00,  -4.567004171527366e-03,  -7.719381810106597e-05,  -9.628675598137417e-07,  -7.341467035307539e-09,
   2.515527580391142e-11,   2.086668611014710e-12,   4.116414557258288e-14,   4.439356535038301e-16,   3.677525168850956e-20,  -1.146902096443315e-19,  -2.766012546215758e-21,
  -3.574095193443243e-23,  -1.037252685080519e-25,   1.818217299470376e+00,  -4.567012639794022e-03,  -7.719394710388785e-05,  -9.628668179741634e-07,  -7.341375199826565e-09,
   2.515781036866874e-11,   2.086705028391701e-12,   4.116414861169074e-14,   4.439205079392843e-16,   3.632915807455150e-20,  -1.146971218932343e-19,  -2.766036081959060e-21,
  -3.573893360067677e-23,  -1.036587306422834e-25,   1.964525381242007e+00,  -9.664825356953567e-04,  -1.938451210414094e-05,  -3.368082612264184e-07,  -5.300170576242191e-09,
  -7.641152489401178e-11,  -1.002220464419185e-12,  -1.160712497802802e-14,  -1.086376884193904e-16,  -5.364244310845748e-19,   8.240713439576451e-21,   3.380681671763519e-22,
   7.441682758164138e-24,   1.296224769463812e-25,   1.964523557946485e+00,  -9.665775158774073e-04,  -1.938750142046278e-05,  -3.368800892828733e-07,  -5.301583308346824e-09,
  -7.643440432819147e-11,  -1.002504884019174e-12,  -1.160888884135727e-14,  -1.086014141931506e-16,  -5.346438227571935e-19,   8.287519877723752e-21,   3.390286354977039e-22,
   7.458086267944888e-24,   1.298509700868278e-25,   1.964520340484009e+00,  -9.667451263628550e-04,  -1.939277676307435e-05,  -3.370068484674537e-07,  -5.304076421282321e-09,
  -7.647477825056932e-11,  -1.003006668554014e-12,  -1.161199629262430e-14,  -1.085372465398396e-16,  -5.314978720571209e-19,   8.370193259257190e-21,   3.407247549719459e-22,
   7.487045609912148e-24,   1.302541191782023e-25,   1.964516449503774e+00,  -9.669478308211611e-04,  -1.939915686690472e-05,  -3.371601567812565e-07,  -5.307091674022425e-09,
  -7.652360359913933e-11,  -1.003613297990136e-12,  -1.161574547066227e-14,  -1.084593792561304e-16,  -5.276868636256872e-19,   8.470303832250539e-21,   3.427780361491809e-22,
   7.522089248271147e-24,   1.307415575880055e-25,   1.964512671798822e+00,  -9.671446421970042e-04,  -1.940535171663330e-05,  -3.373090169979139e-07,  -5.310019409191029e-09,
  -7.657100739082532e-11,  -1.004202062946201e-12,  -1.161937631715431e-14,  -1.083834987442822e-16,  -5.239799812026034e-19,   8.567637201877828e-21,   3.447737504473699e-22,
   7.556135861496798e-24,   1.312146961025236e-25,   1.964509628235983e+00,  -9.673032119469794e-04,  -1.941034303492523e-05,  -3.374289591795353e-07,  -5.312378370083860e-09,
  -7.660919883829898e-11,  -1.004676263529550e-12,  -1.162229497455158e-14,  -1.083221636491479e-16,  -5.209885873073497e-19,   8.646153613474605e-21,   3.463832089328442e-22,
   7.583582577516706e-24,   1.315958072287696e-25,   1.964507616960473e+00,  -9.674080023279616e-04,  -1.941364161454059e-05,  -3.375082257688631e-07,  -5.313937332843314e-09,
  -7.663443681212122e-11,  -1.004989557382944e-12,  -1.162422048134745e-14,  -1.082815332140434e-16,  -5.190093909936988e-19,   8.698087736989729e-21,   3.474475608578342e-22,
   7.601728268759117e-24,   1.318476170124941e-25,   1.964506584029912e+00,  -9.674618203928596e-04,  -1.941533571838755e-05,  -3.375489363363107e-07,  -5.314737997720147e-09,
  -7.664739825872233e-11,  -1.005150433457724e-12,  -1.162520836501269e-14,  -1.082606361994508e-16,  -5.179921942423055e-19,   8.724774441944008e-21,   3.479944194904723e-22,
   7.611049850461568e-24,   1.319769265689911e-25,   1.964506224501910e+00,  -9.674805527711059e-04,  -1.941592538670750e-05,  -3.375631065604064e-07,  -5.315016686477123e-09,
  -7.665190969475308e-11,  -1.005206425409884e-12,  -1.162555205468725e-14,  -1.082533578111107e-16,  -5.176380246387265e-19,   8.734065549143075e-21,   3.481848005131714e-22,
   7.614294773914199e-24,   1.320219328486927e-25,   1.964506167449432e+00,  -9.674835253656592e-04,  -1.941601895989649e-05,  -3.375653552053689e-07,  -5.315060911020093e-09,
  -7.665262560159314e-11,  -1.005215310445741e-12,  -1.162560658627484e-14,  -1.082522025941526e-16,  -5.175818168675864e-19,   8.735540041204803e-21,   3.482150133470748e-22,
   7.614809720483422e-24,   1.320290746732198e-25,   1.231592978997593e-02,  -3.061662389603039e-04,   5.674331337815423e-06,  -9.278368406279944e-08,   1.408055480067982e-09,
  -2.026773118298109e-11,   2.793123115210369e-13,  -3.702284092143138e-15,   4.717807659549643e-17,  -5.766827737205365e-19,   6.699831963249125e-21,  -7.307728812870450e-23,
   7.202066012707321e-25,  -6.032481068779601e-27,   1.231646335197322e-02,  -3.061924014783580e-04,   5.675125593705481e-06,  -9.280274659921729e-08,   1.408449734644093e-09,
  -2.027505117814494e-11,   2.794367408838888e-13,  -3.704240266516378e-15,   4.720648513323965e-17,  -5.770612868389911e-19,   6.704298848982599e-21,  -7.312123873653999e-23,
   7.204369464555661e-25,  -6.029598471680997e-27,   1.231740489132902e-02,  -3.062385700232545e-04,   5.676527251385369e-06,  -9.283638833396031e-08,   1.409145545546103e-09,
  -2.028797056088634e-11,   2.796563591702749e-13,  -3.707693006877731e-15,   4.725662777584636e-17,  -5.777293632762014e-19,   6.712181888622145e-21,  -7.319877267523780e-23,
   7.208425485438284e-25,  -6.024477688674232e-27,   1.231854351448690e-02,  -3.062944049734871e-04,   5.678222458924957e-06,  -9.287707781100533e-08,   1.409987170545580e-09,
  -2.030359816502139e-11,   2.799220275006396e-13,  -3.711869870885843e-15,   4.731728693809700e-17,  -5.785375222713202e-19,   6.721716101431670e-21,  -7.329249739225893e-23,
   7.213315625234352e-25,  -6.018226916226230e-27,   1.231964897875423e-02,  -3.063486163819348e-04,   5.679868459753811e-06,  -9.291658843484612e-08,   1.410804460078047e-09,
  -2.031877477494325e-11,   2.801800421842753e-13,  -3.715926555767979e-15,   4.737620118299039e-17,  -5.793223976078398e-19,   6.730973795853156e-21,  -7.338345197335317e-23,
   7.218047729986218e-25,  -6.012097312786629e-27,   1.232053960422326e-02,  -3.063922939808382e-04,   5.681194687865581e-06,  -9.294842483448477e-08,   1.411463040325313e-09,
  -2.033100486962174e-11,   2.803879731947112e-13,  -3.719195899633357e-15,   4.742368135276782e-17,  -5.799549183474323e-19,   6.738433137158386e-21,  -7.345670092481040e-23,
   7.221848968040476e-25,  -6.007115328113974e-27,   1.232112815177912e-02,  -3.064211580990350e-04,   5.682071149018286e-06,  -9.296946526404559e-08,   1.411898307759702e-09,
  -2.033908826462533e-11,   2.805254083723607e-13,  -3.721356875774259e-15,   4.745506501070061e-17,  -5.803729920115479e-19,   6.743362852301090e-21,  -7.350509127527685e-23,
   7.224355419984113e-25,  -6.003801742856158e-27,   1.232143041089721e-02,  -3.064359820519344e-04,   5.682521288782051e-06,  -9.298027161509025e-08,   1.412121866046706e-09,
  -2.034324008292444e-11,   2.805959996873882e-13,  -3.722466842071722e-15,   4.747118499214046e-17,  -5.805877284732703e-19,   6.745894717887822e-21,  -7.352993854505591e-23,
   7.225640950025693e-25,  -6.002093383281043e-27,   1.232153561682787e-02,  -3.064411417993614e-04,   5.682677969625377e-06,  -9.298403303707354e-08,   1.412199681955269e-09,
  -2.034468525813695e-11,   2.806205715158332e-13,  -3.722853208111685e-15,   4.747679617237839e-17,  -5.806624751374322e-19,   6.746775992051863e-21,  -7.353858630817492e-23,
   7.226088127197635e-25,  -6.001497710271822e-27,   1.232155231164923e-02,  -3.064419605866196e-04,   5.682702832982099e-06,  -9.298462993113040e-08,   1.412212030477124e-09,
  -2.034491459213699e-11,   2.806244708156043e-13,  -3.722914520605300e-15,   4.747768661186248e-17,  -5.806743366728751e-19,   6.746915839793355e-21,  -7.353995856263631e-23,
   7.226159075551384e-25,  -6.001403134710767e-27,   1.095500008070170e-01,  -2.609362391466266e-03,   4.415841716818918e-05,  -6.122144006205380e-07,   6.967666453159250e-09,
  -5.845736518974843e-11,   1.512287310950133e-13,   6.802541474879282e-15,  -1.846461313295853e-16,   3.008342765467366e-18,  -3.468349170939791e-20,   2.155100639087085e-22,
   2.003309811445509e-24,  -9.604984580104298e-26,   1.095541485206538e-01,  -2.609534769038113e-03,   4.416233763756865e-05,  -6.122690901692405e-07,   6.967873345869285e-09,
  -5.844381070352126e-11,   1.507410241419567e-13,   6.812722738471701e-15,  -1.847920251478643e-16,   3.009426010251011e-18,  -3.467033413940150e-20,   2.147932878231428e-22,
   2.019729346621868e-24,  -9.631118487225276e-26,   1.095614675256794e-01,  -2.609838944465280e-03,   4.416925546082200e-05,  -6.123655803586849e-07,   6.968237852543037e-09,
  -5.841987728902802e-11,   1.498801464417260e-13,   6.830690690196465e-15,  -1.850494112896125e-16,   3.011334393217860e-18,  -3.464703459361649e-20,   2.135269727606532e-22,
   2.048720736608304e-24,  -9.677222449648095e-26,   1.095703182546892e-01,  -2.610206777936422e-03,   4.417762072562172e-05,  -6.124822396201228e-07,   6.968677664918381e-09,
  -5.839090893484609e-11,   1.488386335290949e-13,   6.852422757027811e-15,  -1.853605670819048e-16,   3.013636877346378e-18,  -3.461871927708394e-20,   2.119930845166718e-22,
   2.083809562525121e-24,  -9.732955177101577e-26,   1.095789109232092e-01,  -2.610563886600490e-03,   4.418574174617508e-05,  -6.125954718587194e-07,   6.969103628887613e-09,
  -5.836275782774629e-11,   1.478269954792908e-13,   6.873525128940612e-15,  -1.856625495158448e-16,   3.015866687283641e-18,  -3.459108325253812e-20,   2.105012414453888e-22,
   2.117906787751532e-24,  -9.787041965890652e-26,   1.095858334478435e-01,  -2.610851584670931e-03,   4.419228405371235e-05,  -6.126866769767769e-07,   6.969446064444656e-09,
  -5.834005878729574e-11,   1.470116351817646e-13,   6.890528687268411e-15,  -1.859057635495884e-16,   3.017659118794345e-18,  -3.456871392699140e-20,   2.092974470811155e-22,
   2.145399113109824e-24,  -9.830600903653664e-26,   1.095904079161442e-01,  -2.611041698251800e-03,   4.419660715218350e-05,  -6.127469371785071e-07,   6.969671989355480e-09,
  -5.832504944377476e-11,   1.464726648535715e-13,   6.901766175581326e-15,  -1.860664460485760e-16,   3.018841626990181e-18,  -3.455388070055860e-20,   2.085010294555717e-22,
   2.163577312271652e-24,  -9.859377634466423e-26,   1.095927571824348e-01,  -2.611139333090795e-03,   4.419882728808569e-05,  -6.127778816597960e-07,   6.969787904222470e-09,
  -5.831733826622153e-11,   1.461958175724963e-13,   6.907537732081638e-15,  -1.861489552160049e-16,   3.019448314020586e-18,  -3.454624705041303e-20,   2.080917304052538e-22,
   2.172916321692007e-24,  -9.874153926089129e-26,   1.095935748753050e-01,  -2.611173316175655e-03,   4.419960002957981e-05,  -6.127886518489374e-07,   6.969828232196753e-09,
  -5.831465381692257e-11,   1.460994487529957e-13,   6.909546665651692e-15,  -1.861776718556872e-16,   3.019659383434462e-18,  -3.454358752838866e-20,   2.079492222865658e-22,
   2.176167427804514e-24,  -9.879296640777163e-26,   1.095937046323399e-01,  -2.611178708841478e-03,   4.419972265314839e-05,  -6.127903609143867e-07,   6.969834630871600e-09,
  -5.831422780789428e-11,   1.460841558933890e-13,   6.909865460036147e-15,  -1.861822287229209e-16,   3.019692872801189e-18,  -3.454316537732162e-20,   2.079266059399115e-22,
   2.176683361021461e-24,  -9.880112704093015e-26,   2.970188330059584e-01,  -6.465576402868867e-03,   8.874100443468645e-05,  -7.519758274145336e-07,  -3.584323771872252e-11,
   1.301248030018913e-10,  -2.403448986297975e-12,   1.865120541366828e-14,   1.664619559234253e-16,  -7.619662793810979e-18,   1.137639524090264e-19,  -4.558135411852310e-22,
  -1.929752025266669e-23,   5.161768647814795e-25,   2.970271523796481e-01,  -6.465787464820160e-03,   8.874096522767496e-05,  -7.518535307773535e-07,  -3.921778235417629e-11,
   1.301611124087696e-10,  -2.403002205386471e-12,   1.862543223310096e-14,   1.669379737841106e-16,  -7.621866637342737e-18,   1.136422956685014e-19,  -4.520484021115273e-22,
  -1.934637386097469e-23,   5.160115295608893e-25,   2.970418320403638e-01,  -6.466159858942323e-03,   8.874089450431137e-05,  -7.516377088855808e-07,  -4.517170488326322e-11,
   1.302251396490547e-10,  -2.402212839926936e-12,   1.857994911040225e-14,   1.677774955602310e-16,  -7.625739580197352e-18,   1.134273863368949e-19,  -4.454057838230844e-22,
  -1.943242680453651e-23,   5.157163802700892e-25,   2.970595828342787e-01,  -6.466610114127949e-03,   8.874080635583130e-05,  -7.513766877919643e-07,  -5.237037344877678e-11,
   1.303024916809493e-10,  -2.401256603270555e-12,   1.852494033367238e-14,   1.687919388729151e-16,  -7.630395891585680e-18,   1.131670999853953e-19,  -4.373752269427929e-22,
  -1.953622699061387e-23,   5.153536667480911e-25,   2.970768149885675e-01,  -6.467047164042988e-03,   8.874071802992238e-05,  -7.511232438880459e-07,  -5.935779566076949e-11,
   1.303775099734383e-10,  -2.400326497031486e-12,   1.847152822786742e-14,   1.697759930045916e-16,  -7.634888000408382e-18,   1.129139838538764e-19,  -4.295811705939145e-22,
  -1.963672617787194e-23,   5.149954643884430e-25,   2.970906969813235e-01,  -6.467399209924270e-03,   8.874064490342864e-05,  -7.509190375824207e-07,  -6.498611179356259e-11,
   1.304378909076316e-10,  -2.399575920492538e-12,   1.842849260654347e-14,   1.705681964196386e-16,  -7.638486612737635e-18,   1.127097658330829e-19,  -4.233037319449563e-22,
  -1.971749468131787e-23,   5.147025431702149e-25,   2.970998699515579e-01,  -6.467631818018170e-03,   8.874059561711767e-05,  -7.507840844700649e-07,  -6.870487922596009e-11,
   1.304777636856510e-10,  -2.399079319020041e-12,   1.840005176167761e-14,   1.710914067976504e-16,  -7.640854635969595e-18,   1.125746701384783e-19,  -4.191563792165725e-22,
  -1.977077083925769e-23,   5.145068533599639e-25,   2.971045807096634e-01,  -6.467751267975529e-03,   8.874057000762237e-05,  -7.507147742647714e-07,  -7.061454410047550e-11,
   1.304982322647044e-10,  -2.398824094420975e-12,   1.838544489339407e-14,   1.713600188195500e-16,  -7.642067675296438e-18,   1.125052450480118e-19,  -4.170267224648129e-22,
  -1.979810154160196e-23,   5.144056979677987e-25,   2.971062203319988e-01,  -6.467792842762783e-03,   8.874056104646400e-05,  -7.506906493655238e-07,  -7.127920450059469e-11,
   1.305053552673867e-10,  -2.398735229965730e-12,   1.838036065885567e-14,   1.714534987081460e-16,  -7.642489398577813e-18,   1.124810735326487e-19,  -4.162855090302430e-22,
  -1.980760960039872e-23,   5.143703849655626e-25,   2.971064805174745e-01,  -6.467799440067912e-03,   8.874055962219477e-05,  -7.506868210360329e-07,  -7.138467619503925e-11,
   1.305064855293450e-10,  -2.398721126919641e-12,   1.837955385230196e-14,   1.714683320624960e-16,  -7.642556297175084e-18,   1.124772374911780e-19,  -4.161678902396672e-22,
  -1.980911817796854e-23,   5.143647762969603e-25,   5.602762686067836e-01,  -1.052485020275450e-02,   9.490629811233605e-05,   1.581066286800663e-07,  -1.722269584011615e-08,
   1.788194724944412e-10,   1.510859756320077e-12,  -6.249145804998927e-14,   4.593120032167404e-16,   1.016718178851490e-17,  -2.678353902558920e-19,   9.204118500756609e-22,
   6.384447885113719e-23,  -1.198894143644816e-24,   5.602851466317370e-01,  -1.052480514871050e-02,   9.489662244409996e-05,   1.582732423524527e-07,  -1.722055724757787e-08,
   1.786969905500266e-10,   1.512042411952223e-12,  -6.245703012334123e-14,   4.581947432278766e-16,   1.017159589117648e-17,  -2.674412468263478e-19,   9.118528990315639e-22,
   6.382574881345828e-23,  -1.195119427821177e-24,   5.603008113106451e-01,  -1.052472561222127e-02,   9.487955055630805e-05,   1.585671416172573e-07,  -1.721678232427813e-08,
   1.784809243898023e-10,   1.514126849750868e-12,  -6.239626963565788e-14,   4.562246714247783e-16,   1.017934897812040e-17,  -2.667458729341018e-19,   8.967728779879907e-22,
   6.379232056004260e-23,  -1.188463175928851e-24,   5.603197519532233e-01,  -1.052462937120679e-02,   9.485890872032951e-05,   1.589223688955264e-07,  -1.721221535841060e-08,
   1.782197489412775e-10,   1.516643323762916e-12,  -6.232277723301851e-14,   4.538447429216721e-16,   1.018866334326069e-17,  -2.659051884530729e-19,   8.785761022001500e-22,
   6.375125427808668e-23,  -1.180421704568555e-24,   5.603381378875150e-01,  -1.052453587442204e-02,   9.483887173590238e-05,   1.592670510758756e-07,  -1.720777943310260e-08,
   1.779663028528285e-10,   1.519082034105485e-12,  -6.225141104217458e-14,   4.515367612902172e-16,   1.019764203230716e-17,  -2.650892452002616e-19,   8.609509116603942e-22,
   6.371071475523104e-23,  -1.172622893023109e-24,   5.603529484158982e-01,  -1.052446050615311e-02,   9.482273145794243e-05,   1.595446034216827e-07,  -1.720420419580873e-08,
   1.777622005777190e-10,   1.521043591941242e-12,  -6.219390435283684e-14,   4.496792091056152e-16,   1.020482968222965e-17,  -2.644320611191976e-19,   8.467808771532226e-22,
   6.367757565046059e-23,  -1.166345812488330e-24,   5.603627344884070e-01,  -1.052441068041425e-02,   9.481206686497554e-05,   1.597279467455978e-07,  -1.720184090436707e-08,
   1.776273680014294e-10,   1.522338268869513e-12,  -6.215589762985549e-14,   4.484526176038966e-16,   1.020955691555729e-17,  -2.639978693102105e-19,   8.374315626622738e-22,
   6.365544292680653e-23,  -1.162200749046169e-24,   5.603677599623820e-01,  -1.052438508517586e-02,   9.480659027648726e-05,   1.598220842807685e-07,  -1.720062698201501e-08,
   1.775581357144317e-10,   1.523002688154180e-12,  -6.213637709822409e-14,   4.478229657583020e-16,   1.021197770380715e-17,  -2.637749108480800e-19,   8.326345680677476e-22,
   6.364400414953377e-23,  -1.160072903109454e-24,   5.603695091019343e-01,  -1.052437617535072e-02,   9.480468413000691e-05,   1.598548468410811e-07,  -1.720020442398453e-08,
   1.775340404852686e-10,   1.523233872268594e-12,  -6.212958243895806e-14,   4.476038513096093e-16,   1.021281918769571e-17,  -2.636973112757293e-19,   8.309656187116369e-22,
   6.364001123567875e-23,  -1.159332421094991e-24,   5.603697866652146e-01,  -1.052437476142873e-02,   9.480438165225068e-05,   1.598600456719026e-07,  -1.720013736788716e-08,
   1.775302169850628e-10,   1.523270554533505e-12,  -6.212850420305430e-14,   4.475690828411614e-16,   1.021295266769040e-17,  -2.636849974426152e-19,   8.307008121188516e-22,
   6.363937706746932e-23,  -1.159214923173239e-24,   8.767381333809419e-01,  -1.317719667729300e-02,   3.951598896745481e-05,   1.420113481717959e-06,  -1.311338359047803e-08,
  -2.441987392002258e-10,   4.352795257935473e-12,   4.165448091438238e-14,  -1.426018792469029e-15,  -4.482036459206644e-18,   4.526832239958979e-19,  -1.127782139527062e-21,
  -1.375663039518565e-22,   1.137605074899770e-24,   8.767418232598555e-01,  -1.317679807497478e-02,   3.950864698444380e-05,   1.419885233058055e-06,  -1.310730623279238e-08,
  -2.441169752931860e-10,   4.349090772528942e-12,   4.163921177158058e-14,  -1.424135853429664e-15,  -4.487542070546225e-18,   4.518469447529924e-19,  -1.119778718420933e-21,
  -1.372434598135353e-22,   1.131853045768275e-24,   8.767483335538258e-01,  -1.317609478697423e-02,   3.949569470870008e-05,   1.419482546945463e-06,  -1.309658685943761e-08,
  -2.439727261001004e-10,   4.342558151871430e-12,   4.161225424817626e-14,  -1.420816233064019e-15,  -4.497223579057459e-18,   4.503729328854908e-19,  -1.105690398766848e-21,
  -1.366745221200603e-22,   1.121729749759158e-24,   8.767562049239584e-01,  -1.317524445236755e-02,   3.948003739816680e-05,   1.418995720704624e-06,  -1.308363207078323e-08,
  -2.437983402374569e-10,   4.334665656961918e-12,   4.157963161202870e-14,  -1.416806977203098e-15,  -4.508874000455863e-18,   4.485932949286278e-19,  -1.088712250690353e-21,
  -1.359877930492755e-22,   1.109533220000712e-24,   8.767638453224329e-01,  -1.317441905518461e-02,   3.946484249285787e-05,   1.418523229316894e-06,  -1.307106331375746e-08,
  -2.436290932567044e-10,   4.327010895832029e-12,   4.154793569539878e-14,  -1.412919950300395e-15,  -4.520124919675937e-18,   4.468685328801390e-19,  -1.072290339765504e-21,
  -1.353224216435045e-22,   1.097739700817166e-24,   8.767699996178820e-01,  -1.317375419252579e-02,   3.945260521357216e-05,   1.418142675990500e-06,  -1.306094347720420e-08,
  -2.434927814841356e-10,   4.320849429213888e-12,   4.152238299857035e-14,  -1.409792255032431e-15,  -4.529146249720389e-18,   4.454811480401872e-19,  -1.059104086356989e-21,
  -1.347873326527052e-22,   1.088272346464099e-24,   8.767740659189986e-01,  -1.317331489571962e-02,   3.944452076964533e-05,   1.417891252096911e-06,  -1.305425910776321e-08,
  -2.434027244703444e-10,   4.316780542025508e-12,   4.150548901069808e-14,  -1.407727312082532e-15,  -4.535086725177615e-18,   4.445653970879823e-19,  -1.050411872546136e-21,
  -1.344342081248777e-22,   1.082032784434497e-24,   8.767761540516749e-01,  -1.317308930586952e-02,   3.944036955646756e-05,   1.417762145946705e-06,  -1.305082717988955e-08,
  -2.433564806414769e-10,   4.314691746650869e-12,   4.149681029267359e-14,  -1.406667415994647e-15,  -4.538131062101198e-18,   4.440954267703722e-19,  -1.045954499634990e-21,
  -1.342530017065438e-22,   1.078833503855416e-24,   8.767768808282601e-01,  -1.317301078886090e-02,   3.943892477396539e-05,   1.417717211286992e-06,  -1.304963279579872e-08,
  -2.433403858107481e-10,   4.313964845307986e-12,   4.149378913258194e-14,  -1.406298597136366e-15,  -4.539189656170254e-18,   4.439318988896257e-19,  -1.044404103426105e-21,
  -1.341899534209211e-22,   1.077720765606511e-24,   8.767769961568824e-01,  -1.317299832936916e-02,   3.943869551092757e-05,   1.417710080866406e-06,  -1.304944326965606e-08,
  -2.433378318187315e-10,   4.313849501915314e-12,   4.149330969459593e-14,  -1.406240074825011e-15,  -4.539357592284683e-18,   4.439059516210510e-19,  -1.044158125937352e-21,
  -1.341799495832635e-22,   1.077544227368523e-24,   1.215262021954385e+00,  -1.311688781106393e-02,  -5.129224157795953e-05,   1.429754184105602e-06,   1.543023485041267e-08,
  -2.564123419715954e-10,  -5.037625128667684e-12,   4.780361638379020e-14,   1.683632832242378e-15,  -6.843701784762740e-18,  -5.649850444086903e-19,  -4.533151190506001e-22,
   1.860462487206171e-22,   1.039670543267395e-24,   1.215257230659162e+00,  -1.311648653725853e-02,  -5.128360175600616e-05,   1.429514585824468e-06,   1.542320232177685e-08,
  -2.563185971313717e-10,  -5.033253971112143e-12,   4.778046641954873e-14,   1.681285466806075e-15,  -6.845758742620460e-18,  -5.638568468678253e-19,  -4.460544800289997e-22,
   1.855487288670820e-22,   1.033426981431427e-24,   1.215248776997036e+00,  -1.311577853795447e-02,  -5.126835985796149e-05,   1.429091882219629e-06,   1.541079829267434e-08,
  -2.561532199627445e-10,  -5.025545982442418e-12,   4.773961250377633e-14,   1.677147352932711e-15,  -6.849358188374257e-18,  -5.618686122068139e-19,  -4.332796515282264e-22,
   1.846722121113650e-22,   1.022442448594202e-24,   1.215238555852868e+00,  -1.311492251078294e-02,  -5.124993465303402e-05,   1.428580866111008e-06,   1.539580769269172e-08,
  -2.559533073481152e-10,  -5.016233898858130e-12,   4.769020229332607e-14,   1.672150059092295e-15,  -6.853659477452042e-18,  -5.594686545731406e-19,  -4.178946097255333e-22,
   1.836146430785748e-22,   1.009214837472394e-24,   1.215228634509812e+00,  -1.311409159195581e-02,  -5.123205349979859e-05,   1.428084907839081e-06,   1.538126395767955e-08,
  -2.557593018579025e-10,  -5.007202781883043e-12,   4.764222613377675e-14,   1.667305632438694e-15,  -6.857781612460872e-18,  -5.571432481765249e-19,  -4.030242737134024e-22,
   1.825904038874380e-22,   9.964311446008340e-25,   1.215220642840706e+00,  -1.311342228442630e-02,  -5.121765276993322e-05,   1.427685461512162e-06,   1.536955407285177e-08,
  -2.556030610062851e-10,  -4.999933797955644e-12,   4.760357034801134e-14,   1.663407935050573e-15,  -6.861064124988550e-18,  -5.552731015631694e-19,  -3.910915201000403e-22,
   1.817670290640601e-22,   9.861738158908377e-25,   1.215215362497315e+00,  -1.311298005214111e-02,  -5.120813902846055e-05,   1.427421559145622e-06,   1.536181950166739e-08,
  -2.554998430688951e-10,  -4.995133698025671e-12,   4.757802397661515e-14,   1.660834807874008e-15,  -6.863214472221016e-18,  -5.540388926797042e-19,  -3.832293363499559e-22,
   1.812238080722807e-22,   9.794160098002797e-25,   1.215212650914862e+00,  -1.311275295528060e-02,  -5.120325388672140e-05,   1.427286046460188e-06,   1.535784839142543e-08,
  -2.554468429050256e-10,  -4.992669579993573e-12,   4.756490367112387e-14,   1.659514126285866e-15,  -6.864313009944063e-18,  -5.534055465650203e-19,  -3.791987597364138e-22,
   1.809451008866139e-22,   9.759517454970106e-25,   1.215211707143899e+00,  -1.311267391382256e-02,  -5.120155366705237e-05,   1.427238882227003e-06,   1.535646636328774e-08,
  -2.554283968566547e-10,  -4.991812074412554e-12,   4.756033686641645e-14,   1.659054569105717e-15,  -6.864694448426104e-18,  -5.531851809072058e-19,  -3.777969990753670e-22,
   1.808481361149925e-22,   9.747469615949120e-25,   1.215211557381402e+00,  -1.311266137111169e-02,  -5.120128387028974e-05,   1.427231398017095e-06,   1.535624706172581e-08,
  -2.554254697771328e-10,  -4.991676007361862e-12,   4.755961216971070e-14,   1.658981649318091e-15,  -6.864754933911388e-18,  -5.531502155317769e-19,  -3.775746120417864e-22,
   1.808327511259443e-22,   9.745558257271185e-25,   1.536973002644023e+00,  -1.005394417734494e-02,  -1.102730695927971e-04,  -7.308546873127597e-08,   1.943319621374571e-08,
   2.769077124408012e-10,  -1.049621783436213e-12,  -9.073495010591033e-14,  -1.023944247775862e-15,   1.223450499551396e-17,   5.056786401016400e-19,   3.754907706351920e-21,
  -1.099863514420729e-22,  -2.995713363445101e-24,   1.536962686490347e+00,  -1.005396382379164e-02,  -1.102621469660945e-04,  -7.282736391443107e-08,   1.943168898231269e-08,
   2.767297438496639e-10,  -1.052266093891861e-12,  -9.069317896481972e-14,  -1.021832916607037e-15,   1.225303548798362e-17,   5.049949964429060e-19,   3.733482687394624e-21,
  -1.100552440042083e-22,  -2.986987996623457e-24,   1.536944484306107e+00,  -1.005399843149879e-02,  -1.102428745157619e-04,  -7.237206933833006e-08,   1.942902644259828e-08,
   2.764157825599098e-10,  -1.056927528847026e-12,  -9.061942289167717e-14,  -1.018109786960600e-15,   1.228564351186854e-17,   5.037883642103525e-19,   3.695729713451156e-21,
  -1.101755070828041e-22,  -2.971596607182725e-24,   1.536922475447688e+00,  -1.005404017934342e-02,  -1.102195712511103e-04,  -7.182175316274314e-08,   1.942580174891735e-08,
   2.760362516607530e-10,  -1.062556529244238e-12,  -9.053015076800470e-14,  -1.013611742111063e-15,   1.232492133063666e-17,   5.023287295734856e-19,   3.650166733226586e-21,
  -1.103187197013814e-22,  -2.952993190409876e-24,   1.536901111112984e+00,  -1.005408060256389e-02,  -1.101969500906356e-04,  -7.128775748677570e-08,   1.942266591265797e-08,
   2.756679295507529e-10,  -1.068013051903767e-12,  -9.044339762255116e-14,  -1.009249311211616e-15,   1.236289241464037e-17,   5.009111586348337e-19,   3.606027442695061e-21,
  -1.104554380314869e-22,  -2.934941803985899e-24,   1.536883901346075e+00,  -1.005411309186864e-02,  -1.101787276711429e-04,  -7.085775068963149e-08,   1.942013588687048e-08,
   2.753713000179112e-10,  -1.072403017053038e-12,  -9.037344657444457e-14,  -1.005737998683100e-15,   1.239336753470250e-17,   4.997687682688630e-19,   3.570535635127648e-21,
  -1.105639250304185e-22,  -2.920405990289813e-24,   1.536872529959284e+00,  -1.005413452345134e-02,  -1.101666870586380e-04,  -7.057369463666039e-08,   1.941846221353621e-08,
   2.751753346193313e-10,  -1.075301019322505e-12,  -9.032719296968645e-14,  -1.003419257550055e-15,   1.241344924083266e-17,   4.990136961402364e-19,   3.547115702109352e-21,
  -1.106348041349794e-22,  -2.910804020747352e-24,   1.536866690369064e+00,  -1.005414551822435e-02,  -1.101605037634216e-04,  -7.042784447761917e-08,   1.941760212187552e-08,
   2.750747100384243e-10,  -1.076788413864517e-12,  -9.030342989503427e-14,  -1.002228928204412e-15,   1.242374494037323e-17,   4.986258686778863e-19,   3.535098470894591e-21,
  -1.106709546304956e-22,  -2.905873894924261e-24,   1.536864657871842e+00,  -1.005414934324579e-02,  -1.101583516324632e-04,  -7.037708416744899e-08,   1.941730266673274e-08,
   2.750396888059748e-10,  -1.077305976947102e-12,  -9.029515740645697e-14,  -1.001814695644351e-15,   1.242732571286827e-17,   4.984908719705673e-19,   3.530917359373847e-21,
  -1.106834974775638e-22,  -2.904158070429978e-24,   1.536864335343741e+00,  -1.005414995013809e-02,  -1.101580101199438e-04,  -7.036902940342496e-08,   1.941725514294142e-08,
   2.750341315171930e-10,  -1.077388100519558e-12,  -9.029384460370521e-14,  -1.001748966082439e-15,   1.242789380209119e-17,   4.984694493873470e-19,   3.530253950316358e-21,
  -1.106854859722289e-22,  -2.903885799889648e-24,   1.798726592737077e+00,  -5.229541748326944e-03,  -8.938963939106217e-05,  -1.074057338900842e-06,  -6.286701969912586e-09,
   8.951279383653454e-11,   3.421408024900837e-12,   5.450190080535780e-14,   3.408428130336443e-16,  -7.252112521130565e-18,  -2.718184240700902e-19,  -4.404179325452668e-21,
  -2.467778679823717e-23,   7.554683281133153e-25,   1.798718205431277e+00,  -5.229843527412534e-03,  -8.939314843212389e-05,  -1.073972522426967e-06,  -6.281880361981472e-09,
   8.961969430443337e-11,   3.422278945289735e-12,   5.447683974929907e-14,   3.396915601449969e-16,  -7.274596861474355e-18,  -2.719606651230187e-19,  -4.398438893386943e-21,
  -2.445235504115576e-23,   7.593985563214262e-25,   1.798703405633819e+00,  -5.230376001814588e-03,  -8.939933798297807e-05,  -1.073822781067441e-06,  -6.273371572462594e-09,
   8.980828146390259e-11,   3.423813238396722e-12,   5.443255759246134e-14,   3.376596776102692e-16,  -7.314246549406345e-18,  -2.722105166073844e-19,  -4.388286577991375e-21,
  -2.405447938628024e-23,   7.663236637237942e-25,   1.798685509109843e+00,  -5.231019842217480e-03,  -8.940681869006461e-05,  -1.073641573516229e-06,  -6.263080973172895e-09,
   9.003625412309479e-11,   3.425664327467385e-12,   5.437890626881650e-14,   3.352018899810382e-16,  -7.362149902418430e-18,  -2.725107039398540e-19,  -4.375970716322688e-21,
  -2.357319885190171e-23,   7.746807672511306e-25,   1.798668135002272e+00,  -5.231644836413260e-03,  -8.941407688906447e-05,  -1.073465515144702e-06,  -6.253089280597059e-09,
   9.025749374585400e-11,   3.427456939326649e-12,   5.432671273602724e-14,   3.328150637491317e-16,  -7.408610133120452e-18,  -2.728000930912775e-19,  -4.363973301578368e-21,
  -2.310580934113793e-23,   7.827760584639984e-25,   1.798654138309149e+00,  -5.232148298576542e-03,  -8.941992117512422e-05,  -1.073323580781381e-06,  -6.245038845902986e-09,
   9.043566965385467e-11,   3.428897895677481e-12,   5.428458770598837e-14,   3.308916619962766e-16,  -7.446006652578097e-18,  -2.730317682315580e-19,  -4.354278721237570e-21,
  -2.272916562602077e-23,   7.892848548650835e-25,   1.798644889378220e+00,  -5.232480965143772e-03,  -8.942378159209923e-05,  -1.073229742155021e-06,  -6.239718647263941e-09,
   9.055337970579627e-11,   3.429848512150349e-12,   5.425671376924190e-14,   3.296204168431116e-16,  -7.470702287298925e-18,  -2.731841434953603e-19,  -4.347858227666792e-21,
  -2.248022762630462e-23,   7.935795401120850e-25,   1.798640139558483e+00,  -5.232651801550622e-03,  -8.942576367315738e-05,  -1.073181535782203e-06,  -6.236986280715227e-09,
   9.061382158497801e-11,   3.430336222321304e-12,   5.424238727619569e-14,   3.289674804385223e-16,  -7.483379934653080e-18,  -2.732621754087910e-19,  -4.344556519723145e-21,
  -2.235236807659752e-23,   7.957831433169110e-25,   1.798638486332082e+00,  -5.232711262122571e-03,  -8.942645348651693e-05,  -1.073164754605700e-06,  -6.236035225283047e-09,
   9.063485768200163e-11,   3.430505898389053e-12,   5.423739891605962e-14,   3.287402054440602e-16,  -7.487791750409393e-18,  -2.732893000923731e-19,  -4.343406617526387e-21,
  -2.230786253917606e-23,   7.965498212257233e-25,   1.798638223987434e+00,  -5.232720697667762e-03,  -8.942656294716365e-05,  -1.073162091545092e-06,  -6.235884304449142e-09,
   9.063819576141393e-11,   3.430532820039751e-12,   5.423660724214481e-14,   3.287041393445594e-16,  -7.488491808933905e-18,  -2.732936027426548e-19,  -4.343224110064904e-21,
  -2.230079998824992e-23,   7.966714679027880e-25,   1.960321501683936e+00,  -1.139292289805244e-03,  -2.399001197921555e-05,  -4.352614968943841e-07,  -7.097353900704143e-09,
  -1.047723606191393e-10,  -1.378135030215208e-12,  -1.529238865911341e-14,  -1.172688209633680e-16,   2.244305546659500e-19,   3.392746207242823e-20,   9.106569462991457e-22,
   1.772534024000395e-23,   2.818820608932745e-25,   1.960319244588232e+00,  -1.139415053784762e-03,  -2.399401519456719e-05,  -4.353599737858157e-07,  -7.099295498941045e-09,
  -1.048024531355146e-10,  -1.378439819353890e-12,  -1.529150637287108e-14,  -1.171221104217395e-16,   2.292070476489896e-19,   3.403856226227478e-20,   9.127343353551765e-22,
   1.775610333669027e-23,   2.821760657801181e-25,   1.960315261600862e+00,  -1.139631695322644e-03,  -2.400107981990705e-05,  -4.355337607443067e-07,  -7.102721826886510e-09,
  -1.048555503810128e-10,  -1.378977309317017e-12,  -1.528993639916319e-14,  -1.168628550485395e-16,   2.376439697559099e-19,   3.423475494990700e-20,   9.164016533660185e-22,
   1.781037631512585e-23,   2.826936879110471e-25,   1.960310444807339e+00,  -1.139893699063341e-03,  -2.400962395606457e-05,  -4.357439448955475e-07,  -7.106865571194600e-09,
  -1.049197536114370e-10,  -1.379626709806909e-12,  -1.528801550505905e-14,  -1.165487084400294e-16,   2.478608680773962e-19,   3.447225691145891e-20,   9.208391625464164e-22,
   1.787598828003113e-23,   2.833176304276611e-25,   1.960305768200203e+00,  -1.140148088058316e-03,  -2.401792004292773e-05,  -4.359480289798190e-07,  -7.110888866005851e-09,
  -1.049820783323270e-10,  -1.380256572336135e-12,  -1.528612718809880e-14,  -1.162430568662453e-16,   2.577948466724571e-19,   3.470309577342275e-20,   9.251501018288446e-22,
   1.793966678761497e-23,   2.839212733942955e-25,   1.960302000394085e+00,  -1.140353049401711e-03,  -2.402460440007048e-05,  -4.361124658029090e-07,  -7.114130423678461e-09,
  -1.050322843953069e-10,  -1.380763576628949e-12,  -1.528458909895002e-14,  -1.159963378924293e-16,   2.658087056692572e-19,   3.488925433185687e-20,   9.286251425617905e-22,
   1.799095342190790e-23,   2.844060739888830e-25,   1.960299510502861e+00,  -1.140488498346574e-03,  -2.402902186116011e-05,  -4.362211370910644e-07,  -7.116272604396538e-09,
  -1.050654587211743e-10,  -1.381098397644056e-12,  -1.528356448345216e-14,  -1.158330703207384e-16,   2.711095943153703e-19,   3.501236141410345e-20,   9.309224650384949e-22,
   1.802483680569111e-23,   2.847256924466781e-25,   1.960298231765180e+00,  -1.140558062234086e-03,  -2.403129061105311e-05,  -4.362769494396467e-07,  -7.117372783832580e-09,
  -1.050824950311083e-10,  -1.381270282858658e-12,  -1.528303573441199e-14,  -1.157491503389621e-16,   2.738335473490778e-19,   3.507561273219036e-20,   9.321025829014562e-22,
   1.804223570325737e-23,   2.848896060281840e-25,   1.960297786679363e+00,  -1.140582275278447e-03,  -2.403208029765403e-05,  -4.362963761459128e-07,  -7.117755722047133e-09,
  -1.050884246279321e-10,  -1.381330099303285e-12,  -1.528285129080470e-14,  -1.157199293941405e-16,   2.747819137215419e-19,   3.509763269909147e-20,   9.325133866879759e-22,
   1.804829125456569e-23,   2.849466216788384e-25,   1.960297716049924e+00,  -1.140586117588174e-03,  -2.403220561134378e-05,  -4.362994589302224e-07,  -7.117816489575167e-09,
  -1.050893655710575e-10,  -1.381339590884951e-12,  -1.528282200278910e-14,  -1.157152918711347e-16,   2.749324192019701e-19,   3.510112719084670e-20,   9.325785781045964e-22,
   1.804925217316324e-23,   2.849556675690995e-25,   1.117550543368277e-02,  -2.648708179402500e-04,   4.683814150711253e-06,  -7.316581531911736e-08,   1.062145556507228e-09,
  -1.465508593072027e-11,   1.939982633054089e-13,  -2.478756381220626e-15,   3.055127351578384e-17,  -3.638774249253880e-19,   4.142039682377709e-21,  -4.532337867148584e-23,
   4.518057177546437e-25,  -4.229569134661314e-27,   1.117594574289731e-02,  -2.648914443333899e-04,   4.684413152232585e-06,  -7.317959565014779e-08,   1.062419319292541e-09,
  -1.465998561827342e-11,   1.940788232755545e-13,  -2.479990593200979e-15,   3.056883811820005e-17,  -3.641123235129414e-19,   4.144849257010777e-21,  -4.535423978502908e-23,
   4.521083560163532e-25,  -4.228346778658652e-27,   1.117672272128497e-02,  -2.649278430872737e-04,   4.685470225276841e-06,  -7.320391500196409e-08,   1.062902470287385e-09,
  -1.466863317267510e-11,   1.942210101524765e-13,  -2.482169025107269e-15,   3.059984078474426e-17,  -3.645269350743323e-19,   4.149808319571537e-21,  -4.540868742237444e-23,
   4.526424979895820e-25,  -4.226188662358911e-27,   1.117766233004085e-02,  -2.649718622358134e-04,   4.686748663205154e-06,  -7.323332860164801e-08,   1.063486858961833e-09,
  -1.467909326229745e-11,   1.943930080700580e-13,  -2.484804309034304e-15,   3.063734599675606e-17,  -3.650285082648395e-19,   4.155807469853966e-21,  -4.547451366404366e-23,
   4.532886099440558e-25,  -4.223576920093423e-27,   1.117857456784250e-02,  -2.650146009046263e-04,   4.687989972656581e-06,  -7.326188949707855e-08,   1.064054338162507e-09,
  -1.468925127082976e-11,   1.945600477374507e-13,  -2.487363750101244e-15,   3.067377264489672e-17,  -3.655156576734252e-19,   4.161634063141655e-21,  -4.553840362417825e-23,
   4.539160722814071e-25,  -4.221039268417355e-27,   1.117930951342957e-02,  -2.650490346629980e-04,   4.688990115958600e-06,  -7.328490257159112e-08,   1.064511610125829e-09,
  -1.469743696356634e-11,   1.946946607867542e-13,  -2.489426428914261e-15,   3.070312983279726e-17,  -3.659082642774029e-19,   4.166329841637513e-21,  -4.558986321490857e-23,
   4.544217082083328e-25,  -4.218993385744262e-27,   1.117979518111337e-02,  -2.650717898566838e-04,   4.689651071456164e-06,  -7.330011154625861e-08,   1.064813825128388e-09,
  -1.470284716406642e-11,   1.947836342309978e-13,  -2.490789815031724e-15,   3.072253458967161e-17,  -3.661677726920041e-19,   4.169433683690541e-21,  -4.562386222556911e-23,
   4.547559007776530e-25,  -4.217640729713835e-27,   1.118004460359365e-02,  -2.650834763496834e-04,   4.689990528046094e-06,  -7.330792280776419e-08,   1.064969044881016e-09,
  -1.470562594460224e-11,   1.948293336326842e-13,  -2.491490104215685e-15,   3.073250173213397e-17,  -3.663010677173977e-19,   4.171027950558111e-21,  -4.564132093058061e-23,
   4.549275483215580e-25,  -4.216945837440745e-27,   1.118013141878680e-02,  -2.650875440380681e-04,   4.690108682892268e-06,  -7.331064170433903e-08,   1.065023073385432e-09,
  -1.470659318570714e-11,   1.948452408871612e-13,  -2.491733866209241e-15,   3.073597118528633e-17,  -3.663474662575204e-19,   4.171582896781695e-21,  -4.564739736763558e-23,
   4.549872955666477e-25,  -4.216703935862284e-27,   1.118014519522948e-02,  -2.650881895288211e-04,   4.690127432622892e-06,  -7.331107316126229e-08,   1.065031647100200e-09,
  -1.470674667644976e-11,   1.948477652044022e-13,  -2.491772548826648e-15,   3.073652175386427e-17,  -3.663548292560451e-19,   4.171670961337752e-21,  -4.564836160382287e-23,
   4.549967768089463e-25,  -4.216665547612042e-27,   9.977511800951663e-02,  -2.283673437156946e-03,   3.744294791437788e-05,  -5.098337743169577e-07,   5.847182869441555e-09,
  -5.311892425511237e-11,   2.734636394286685e-13,   2.378535843128272e-15,  -9.888387414813621e-17,   1.824642121056864e-18,  -2.443122059177318e-20,   2.280022347745648e-22,
  -8.783084359244705e-25,  -2.510328110948968e-26,   9.977863488591844e-02,  -2.283817002881970e-03,   3.744623909980563e-05,  -5.098835329134481e-07,   5.847564328736018e-09,
  -5.311414301634546e-11,   2.732019372459731e-13,   2.384724421677832e-15,  -9.898710603071909e-17,   1.825810338781136e-18,  -2.443633594729620e-20,   2.278125781936651e-22,
  -8.714439447766133e-25,  -2.521335163819298e-26,   9.978484072085685e-02,  -2.284070338236758e-03,   3.745204662207221e-05,  -5.099713290664694e-07,   5.848237119632321e-09,
  -5.310569652477347e-11,   2.727399392119139e-13,   2.395647466032281e-15,  -9.916927757785502e-17,   1.827870876061724e-18,  -2.444532736416194e-20,   2.274772691909289e-22,
  -8.593154218321744e-25,  -2.540776542684872e-26,   9.979234531109925e-02,  -2.284376693448372e-03,   3.745906943630335e-05,  -5.100774868443522e-07,   5.849050153824274e-09,
  -5.309546601804799e-11,   2.721809104008018e-13,   2.408861182978498e-15,  -9.938959071780258e-17,   1.830361131631922e-18,  -2.445614064569247e-20,   2.270706889687994e-22,
  -8.446221896610529e-25,  -2.564318106095665e-26,   9.979963108595566e-02,  -2.284674118093121e-03,   3.746588737291048e-05,  -5.101805364067001e-07,   5.849838897226040e-09,
  -5.308551669746084e-11,   2.716378212872532e-13,   2.421694541157101e-15,  -9.960349754020068e-17,   1.832777193532034e-18,  -2.446657589083965e-20,   2.266748130328766e-22,
  -8.303297033920239e-25,  -2.587206236850360e-26,   9.980550073282914e-02,  -2.284913734069466e-03,   3.747138003609158e-05,  -5.102635470814007e-07,   5.850473914371267e-09,
  -5.307748895345524e-11,   2.712000337097145e-13,   2.432037017804865e-15,  -9.977583997422184e-17,   1.834722511631928e-18,  -2.447493784372720e-20,   2.263550580137622e-22,
  -8.187954267199740e-25,  -2.605669255292330e-26,   9.980937944828781e-02,  -2.285072075162114e-03,   3.747500959879297e-05,  -5.103183967471649e-07,   5.850893334171068e-09,
  -5.307217814333844e-11,   2.709106133689871e-13,   2.438873144245515e-15,  -9.988973146757003e-17,   1.836007438200778e-18,  -2.448044144290932e-20,   2.261433567915864e-22,
  -8.111637848114149e-25,  -2.617881351792314e-26,   9.981137140293403e-02,  -2.285153393092678e-03,   3.747687358652362e-05,  -5.103465639604229e-07,   5.851108668085447e-09,
  -5.306944886440174e-11,   2.707619394625474e-13,   2.442384441324966e-15,  -9.994822349641868e-17,   1.836667153159941e-18,  -2.448326104894603e-20,   2.260345103609961e-22,
  -8.072414815557609e-25,  -2.624156578078049e-26,   9.981206472873858e-02,  -2.285181696893838e-03,   3.747752236987411e-05,  -5.103563677031481e-07,   5.851183607756212e-09,
  -5.306849860757356e-11,   2.707101853477233e-13,   2.443606678972964e-15,  -9.996858270711553e-17,   1.836896748094281e-18,  -2.448424136278827e-20,   2.259966050248912e-22,
  -8.058757962202930e-25,  -2.626341321926791e-26,   9.981217475036294e-02,  -2.285186188333926e-03,   3.747762532311065e-05,  -5.103579234166962e-07,   5.851195499209769e-09,
  -5.306834780036052e-11,   2.707019723596405e-13,   2.443800635932755e-15,  -9.997181345834499e-17,   1.836933180466040e-18,  -2.448439687401168e-20,   2.259905890044170e-22,
  -8.056590574234928e-25,  -2.626688038879635e-26,   2.725194557743002e-01,  -5.791574613634727e-03,   7.979008850129115e-05,  -7.346780064857203e-07,   2.034271768870362e-09,
   7.908747778207843e-11,  -1.841908356945966e-12,   2.041531162847782e-14,  -3.262491232175175e-17,  -3.659579749286268e-18,   8.129138184596256e-20,  -8.732062964783690e-22,
  -7.354737575607360e-25,   2.131836354796870e-25,   2.725269383477835e-01,  -5.791780979000722e-03,   7.979121815058516e-05,  -7.346035260581762e-07,   2.031680672278997e-09,
   7.912747179266015e-11,  -1.841986919326543e-12,   2.040284505822166e-14,  -3.228217433251667e-17,  -3.664020399125903e-18,   8.128513445171269e-20,  -8.716216930277735e-22,
  -7.721244714794646e-25,   2.136517206467437e-25,   2.725401415509633e-01,  -5.792145096852134e-03,   7.979321024940744e-05,  -7.344720737483029e-07,   2.027108554477751e-09,
   7.919802184376108e-11,  -1.842124812567556e-12,   2.038083545945648e-14,  -3.167743066807797e-17,  -3.671849326781887e-18,   8.127392672321036e-20,  -8.688228739800678e-22,
  -8.367711473631204e-25,   2.144760706956600e-25,   2.725561071494316e-01,  -5.792585362915235e-03,   7.979561709581968e-05,  -7.343130683460962e-07,   2.021579752834812e-09,
   7.928329758780732e-11,  -1.842290307629205e-12,   2.035420053129226e-14,  -3.094620766207874e-17,  -3.681304770923333e-18,   8.126006039063394e-20,  -8.654338102938168e-22,
  -9.149014357964363e-25,   2.154701635322725e-25,   2.725716064268965e-01,  -5.793012735074212e-03,   7.979795150449207e-05,  -7.341586543552645e-07,   2.016212333705113e-09,
   7.936604604486859e-11,  -1.842449661654155e-12,   2.032832215775817e-14,  -3.023639093475180e-17,  -3.690472026560450e-18,   8.124627066465049e-20,  -8.621388505768851e-22,
  -9.907057406100337e-25,   2.164323596218219e-25,   2.725840925512840e-01,  -5.793356998660328e-03,   7.979983055751487e-05,  -7.340342215568433e-07,   2.011888300685983e-09,
   7.943268149256802e-11,  -1.842577099675112e-12,   2.030745937836598e-14,  -2.966460222638536e-17,  -3.697848496562183e-18,   8.123492652526929e-20,  -8.594809579082919e-22,
  -1.051741645225756e-24,   2.172054462672568e-25,   2.725923432127168e-01,  -5.793584471196669e-03,   7.980107145987468e-05,  -7.339519795398609e-07,   2.009031003060414e-09,
   7.947670045383650e-11,  -1.842660850411932e-12,   2.029366604163212e-14,  -2.928678948334525e-17,  -3.702718546425952e-18,   8.122731533384059e-20,  -8.577229506385228e-22,
  -1.092057842455870e-24,   2.177152853453857e-25,   2.725965803384880e-01,  -5.793701285916164e-03,   7.980170849301429e-05,  -7.339097384413710e-07,   2.007563627469730e-09,
   7.949930241274730e-11,  -1.842703718773158e-12,   2.028658015885595e-14,  -2.909276924969931e-17,  -3.705218253616632e-18,   8.122337100696607e-20,  -8.568195986324351e-22,
  -1.112757417918142e-24,   2.179768017624638e-25,   2.725980551115170e-01,  -5.793741943821721e-03,   7.980193018167995e-05,  -7.338950351029624e-07,   2.007052891327805e-09,
   7.950716861311039e-11,  -1.842718616948322e-12,   2.028411347932401e-14,  -2.902523947983900e-17,  -3.706088093147190e-18,   8.122199247835758e-20,  -8.565050941783949e-22,
  -1.119961342491531e-24,   2.180677755197183e-25,   2.725982891378093e-01,  -5.793748395646349e-03,   7.980196535888277e-05,  -7.338927018411621e-07,   2.006971844411295e-09,
   7.950841684141269e-11,  -1.842720980012997e-12,   2.028372203354149e-14,  -2.901452347102705e-17,  -3.706226114899163e-18,   8.122177345571393e-20,  -8.564551826416413e-22,
  -1.121104470383218e-24,   2.180822094552492e-25,   5.197011421904707e-01,  -9.762413486696250e-03,   9.527305601113743e-05,  -8.743663887104809e-08,  -1.341567225185167e-08,
   1.960109521608021e-10,   7.839101340217215e-15,  -4.388068909998399e-14,   6.488441666244380e-16,   9.471113908254503e-19,  -1.813437486624611e-19,   2.559574719634343e-21,
   7.711179892738417e-24,  -8.390324166129688e-25,   5.197100588735782e-01,  -9.762437433656382e-03,   9.526550989586097e-05,  -8.725360477267812e-08,  -1.341564129700630e-08,
   1.959246191804531e-10,   9.526553901477893e-15,  -4.387715568182285e-14,   6.480808200229576e-16,   9.600722330269622e-19,  -1.812916810391944e-19,   2.553478956278403e-21,
   7.805593895191095e-24,  -8.383207825028177e-25,   5.197257919263032e-01,  -9.762479646719053e-03,   9.525219467538492e-05,  -8.693070400615157e-08,  -1.341558475365201e-08,
   1.957722890973391e-10,   1.250246249311325e-14,  -4.387088552080019e-14,   6.467340653160323e-16,   9.829163305465460e-19,  -1.811993352313107e-19,   2.542727180581633e-21,
   7.971892277151644e-24,  -8.370603290441291e-25,   5.197448155215221e-01,  -9.762530620070799e-03,   9.523609380090324e-05,  -8.654036110555323e-08,  -1.341551310314989e-08,
   1.955880998935564e-10,   1.609818735491795e-14,  -4.386324328164150e-14,   6.451058672113097e-16,   1.010496168942278e-18,  -1.810868664825909e-19,   2.529733360486793e-21,
   8.172476411969491e-24,  -8.355280740897326e-25,   5.197632822719724e-01,  -9.762580029639943e-03,   9.522046338533928e-05,  -8.616154041947308e-08,  -1.341544011535998e-08,
   1.954093026824369e-10,   1.958594857011245e-14,  -4.385576125053518e-14,   6.435255688851112e-16,   1.037224673911930e-18,  -1.809768439563586e-19,   2.517126897783950e-21,
   8.366670640141554e-24,  -8.340321316331890e-25,   5.197781581105143e-01,  -9.762619779992059e-03,   9.520787175120779e-05,  -8.585645154715468e-08,  -1.341537886039022e-08,
   1.952652735176057e-10,   2.239356158374712e-14,  -4.384968867174082e-14,   6.422527372558843e-16,   1.058724202838773e-18,  -1.808876104361847e-19,   2.506976838883733e-21,
   8.522731779549057e-24,  -8.328209806716169e-25,   5.197879874395163e-01,  -9.762646020196698e-03,   9.519955143632857e-05,  -8.565489545422966e-08,  -1.341533718166919e-08,
   1.951701053186512e-10,   2.424776291238986e-14,  -4.384565392969214e-14,   6.414117888152682e-16,   1.072914747800424e-18,  -1.808283527168526e-19,   2.500272581971358e-21,
   8.625668568729612e-24,  -8.320177245879318e-25,   5.197930351589101e-01,  -9.762659487720302e-03,   9.519527856048188e-05,  -8.555139949731437e-08,  -1.341531540585727e-08,
   1.951212330443814e-10,   2.519966879731901e-14,  -4.384357506871206e-14,   6.409799575200745e-16,   1.080197336589863e-18,  -1.807978302615920e-19,   2.496830468291028e-21,
   8.678474135055402e-24,  -8.316043037856021e-25,   5.197947920461413e-01,  -9.762664173929420e-03,   9.519379134754758e-05,  -8.551537881007063e-08,  -1.341530776740511e-08,
   1.951042227850345e-10,   2.553093817667130e-14,  -4.384285041543173e-14,   6.408296604167505e-16,   1.082731322731085e-18,  -1.807871921960945e-19,   2.495632543445718e-21,
   8.696844458511695e-24,  -8.314602641058423e-25,   5.197950708391069e-01,  -9.762664917505227e-03,   9.519355534736733e-05,  -8.550966291938221e-08,  -1.341530655247859e-08,
   1.951015234998512e-10,   2.558350368262838e-14,  -4.384273537135471e-14,   6.408058106087235e-16,   1.083133394140796e-18,  -1.807855033959803e-19,   2.495442455651225e-21,
   8.699759142072183e-24,  -8.314374001220653e-25,   8.247640546079712e-01,  -1.279680287495933e-02,   5.515653940155880e-05,   1.177206655467534e-06,  -1.688505581755524e-08,
  -1.309207779217847e-10,   4.879834614455674e-12,  -3.267714260754526e-15,  -1.289117605289318e-15,   1.096690009895199e-17,   2.865143612191346e-19,  -5.653404745458867e-21,
  -4.263251717326999e-23,   2.107564848370913e-24,   8.247692065352523e-01,  -1.279647221874167e-02,   5.514708006571865e-05,   1.177083868794147e-06,  -1.687823325027571e-08,
  -1.309266359456528e-10,   4.876475448875510e-12,  -3.231443379374732e-15,  -1.287917406513495e-15,   1.093833451715634e-17,   2.862492308610404e-19,  -5.638325105213076e-21,
  -4.266228613291016e-23,   2.101527507920953e-24,   8.247782964757271e-01,  -1.279588879871930e-02,   5.513039202928612e-05,   1.176867205485751e-06,  -1.686619855355341e-08,
  -1.309369148305936e-10,   4.870550704481478e-12,  -3.167520789552848e-15,  -1.285800547375285e-15,   1.088799297350733e-17,   2.857812604929475e-19,  -5.611752525322060e-21,
  -4.271426279987434e-23,   2.090890079663599e-24,   8.247892869077474e-01,  -1.279518336886627e-02,   5.511021797973842e-05,   1.176605206610709e-06,  -1.685165259913822e-08,
  -1.309492458863596e-10,   4.863390797317705e-12,  -3.090357706113723e-15,  -1.283242371465417e-15,   1.082722654572820e-17,   2.852151426212495e-19,  -5.579681456395245e-21,
  -4.277617623757520e-23,   2.078053681191987e-24,   8.247999549503658e-01,  -1.279449859990733e-02,   5.509063891275549e-05,   1.176350855044664e-06,  -1.683753847340515e-08,
  -1.309611138506896e-10,   4.856444644352118e-12,  -3.015588032046623e-15,  -1.280760565044849e-15,   1.076834757826932e-17,   2.846653130163494e-19,  -5.548610984084985e-21,
  -4.283530227977710e-23,   2.065620036543809e-24,   8.248085480708424e-01,  -1.279394699485844e-02,   5.507487024727803e-05,   1.176145947316978e-06,  -1.682617321273243e-08,
  -1.309706009410175e-10,   4.850852180574298e-12,  -2.955453978896788e-15,  -1.278762419719441e-15,   1.072099562427498e-17,   2.842221984429558e-19,  -5.523626503947021e-21,
  -4.288223456316790e-23,   2.055623482782291e-24,   8.248142258033709e-01,  -1.279358252165583e-02,   5.506445254048964e-05,   1.176010545300898e-06,  -1.681866564717088e-08,
  -1.309768338417884e-10,   4.847158379124449e-12,  -2.915767105758201e-15,  -1.277442651735472e-15,   1.068974551616803e-17,   2.839293092666190e-19,  -5.507139453963307e-21,
  -4.291290526054131e-23,   2.049027636865822e-24,   8.248171414520342e-01,  -1.279339535266594e-02,   5.505910315145005e-05,   1.175941009072779e-06,  -1.681481089393171e-08,
  -1.309800236079548e-10,   4.845261929736803e-12,  -2.895401030096701e-15,  -1.276765064293055e-15,   1.067370921152020e-17,   2.837788699118971e-19,  -5.498679440884325e-21,
  -4.292855076111337e-23,   2.045643351695658e-24,   8.248181562481784e-01,  -1.279333020765088e-02,   5.505724134341613e-05,   1.175916806222386e-06,  -1.681346932970468e-08,
  -1.309811320644927e-10,   4.844601931860049e-12,  -2.888314823364313e-15,  -1.276529251890307e-15,   1.066812955783044e-17,   2.837265038712881e-19,  -5.495735950087132e-21,
  -4.293397956235845e-23,   2.044465897237200e-24,   8.248183172813026e-01,  -1.279331987007529e-02,   5.505694590467063e-05,   1.175912965557217e-06,  -1.681325644753684e-08,
  -1.309813078772260e-10,   4.844497203022602e-12,  -2.887190453507891e-15,  -1.276491833044256e-15,   1.066724423519589e-17,   2.837181939005522e-19,  -5.495268910573950e-21,
  -4.293484024310262e-23,   2.044279074071169e-24,   1.162087817028098e+00,  -1.345483025504723e-02,  -3.284290219077544e-05,   1.629603090309475e-06,   9.231311895709830e-09,
  -3.555468977253120e-10,  -3.012425655334801e-12,   9.349834868552731e-14,   1.050173232300455e-15,  -2.715721954164647e-17,  -3.862474441006781e-19,   8.240598134279800e-21,
   1.438478772910699e-22,  -2.625156636725380e-24,   1.162084748387736e+00,  -1.345437309841474e-02,  -3.283773330098203e-05,   1.629271299885053e-06,   9.227107839519181e-09,
  -3.553642614104269e-10,  -3.009701950001529e-12,   9.340777907999499e-14,   1.048571589906058e-15,  -2.711545551006863e-17,  -3.853784535659639e-19,   8.221856577259798e-21,
   1.433907805023281e-22,  -2.616876889312637e-24,   1.162079334114608e+00,  -1.345356651393263e-02,  -3.282861462850492e-05,   1.628685989214133e-06,   9.219692817148699e-09,
  -3.550421411868315e-10,  -3.004899330310543e-12,   9.324808164701724e-14,   1.045748428729021e-15,  -2.704184031939010e-17,  -3.838473868443694e-19,   8.188835689062965e-21,
   1.425859144740735e-22,  -2.602292335192857e-24,   1.162072787784391e+00,  -1.345259131222067e-02,  -3.281759149637745e-05,   1.627978461806643e-06,   9.210731777537658e-09,
  -3.546528761065299e-10,  -2.999097746315437e-12,   9.305516814170738e-14,   1.042339677236841e-15,  -2.695295707156677e-17,  -3.819998876850337e-19,   8.148989727369069e-21,
   1.416155354802365e-22,  -2.584699434478108e-24,   1.162066433418367e+00,  -1.345164473819457e-02,  -3.280689384737786e-05,   1.627291854021388e-06,   9.202038086066246e-09,
  -3.542752418968100e-10,  -2.993471732020395e-12,   9.286809437139709e-14,   1.039035796748269e-15,  -2.686680987977193e-17,  -3.802104264312383e-19,   8.110395004908203e-21,
   1.406765107667407e-22,  -2.567665404662509e-24,   1.162061314923782e+00,  -1.345088228711545e-02,  -3.279827840775854e-05,   1.626738909037286e-06,   9.195038521593525e-09,
  -3.539712091401999e-10,  -2.988943828329677e-12,   9.271753572251094e-14,   1.036378009368416e-15,  -2.679751038055995e-17,  -3.787717627500570e-19,   8.079365875838680e-21,
   1.399221911068028e-22,  -2.553975100905571e-24,   1.162057932958543e+00,  -1.345037852033774e-02,  -3.279258667664685e-05,   1.626373619634788e-06,   9.190415272198253e-09,
  -3.537703999780820e-10,  -2.985953993778099e-12,   9.261812046046346e-14,   1.034623637605646e-15,  -2.675176720171207e-17,  -3.778225387289065e-19,   8.058892835807682e-21,
   1.394247991383818e-22,  -2.544944484263899e-24,   1.162056196233271e+00,  -1.345011982662326e-02,  -3.278966407077175e-05,   1.626186052883767e-06,   9.188041611594729e-09,
  -3.536673027713429e-10,  -2.984419227070994e-12,   9.256708797794394e-14,   1.033723254488235e-15,  -2.672829093945694e-17,  -3.773355052648596e-19,   8.048388360978843e-21,
   1.391696885736210e-22,  -2.540311679323113e-24,   1.162055591762186e+00,  -1.345002978823590e-02,  -3.278864688999247e-05,   1.626120772830140e-06,   9.187215532655649e-09,
  -3.536314232862782e-10,  -2.983885141932755e-12,   9.254932915830078e-14,   1.033409958722631e-15,  -2.672012220622228e-17,  -3.771660585760937e-19,   8.044733679832957e-21,
   1.390809465517166e-22,  -2.538699960704205e-24,   1.162055495841522e+00,  -1.345001550049442e-02,  -3.278848548021054e-05,   1.626110413987465e-06,   9.187084449832188e-09,
  -3.536257299169922e-10,  -2.983800394935756e-12,   9.254651124449195e-14,   1.033360247310380e-15,  -2.671882605443079e-17,  -3.771391730315850e-19,   8.044153803346015e-21,
   1.390668668613547e-22,  -2.538444239777678e-24,   1.494995302869746e+00,  -1.093394353647438e-02,  -1.091086892124422e-04,   2.798584197272737e-07,   2.449677406960886e-08,
   2.180797571977365e-10,  -3.953565195085615e-12,  -1.123428876721780e-13,  -1.978328476133267e-16,   3.365972517962486e-17,   5.006947973209438e-19,  -5.095089329056730e-21,
  -2.461072593793119e-22,  -1.490451431314082e-24,   1.494985101547725e+00,  -1.093386411320518e-02,  -1.090949412209885e-04,   2.800610263804806e-07,   2.449120880652273e-08,
   2.178603769025096e-10,  -3.954042015985762e-12,  -1.122299828126728e-13,  -1.957684867957107e-16,   3.363306530502304e-17,   4.991994944118212e-19,  -5.105194083359598e-21,
  -2.455135549243401e-22,  -1.475970826185503e-24,   1.494967102198373e+00,  -1.093372392358743e-02,  -1.090706852197868e-04,   2.804183623555242e-07,   2.448138828362387e-08,
   2.174734572861981e-10,  -3.954878997362598e-12,  -1.120308338433014e-13,  -1.921309941319628e-16,   3.358598198610059e-17,   4.965639909221287e-19,  -5.122938816691536e-21,
  -2.444663629957272e-22,  -1.450480704140588e-24,   1.494945338972514e+00,  -1.093355432637923e-02,  -1.090413589452631e-04,   2.808501727731812e-07,   2.446951230445047e-08,
   2.170058974100981e-10,  -3.955883629150191e-12,  -1.117901460654671e-13,  -1.877411956943084e-16,   3.352897772973478e-17,   4.933821950989937e-19,  -5.144250802613318e-21,
  -2.432007883992725e-22,  -1.419761895553839e-24,   1.494924213473077e+00,  -1.093338960225288e-02,  -1.090128940519531e-04,   2.812690695056589e-07,   2.445798237345468e-08,
   2.165523202397652e-10,  -3.956851110941967e-12,  -1.115566218310899e-13,  -1.834887533785874e-16,   3.347356535884608e-17,   4.902986839876949e-19,  -5.164788441703495e-21,
  -2.419729295138217e-22,  -1.390049489579181e-24,   1.494907196380527e+00,  -1.093325684384322e-02,  -1.089899663616606e-04,   2.816063143027493e-07,   2.444869334341125e-08,
   2.161871549114970e-10,  -3.957624921593185e-12,  -1.113685918854080e-13,  -1.800695535565030e-16,   3.342887333946786e-17,   4.878184588560632e-19,  -5.181224849859993e-21,
  -2.409843152951200e-22,  -1.366191468513602e-24,   1.494895952442553e+00,  -1.093316909067261e-02,  -1.089748177474123e-04,   2.818290554186378e-07,   2.444255499220771e-08,
   2.159459730176623e-10,  -3.958133512417267e-12,  -1.112443911684594e-13,  -1.778133933322994e-16,   3.339931601524747e-17,   4.861814358697739e-19,  -5.192032726958509e-21,
  -2.403313189461514e-22,  -1.350464615431268e-24,   1.494890178344534e+00,  -1.093312401632265e-02,  -1.089670387024586e-04,   2.819434114100504e-07,   2.443940255471448e-08,
   2.158221494686617e-10,  -3.958393854601194e-12,  -1.111806224269352e-13,  -1.766557318958110e-16,   3.338412900620342e-17,   4.853413230782492e-19,  -5.197566714719022e-21,
  -2.399960554926628e-22,  -1.342399898167060e-24,   1.494888168649019e+00,  -1.093310832636597e-02,  -1.089643312131588e-04,   2.819832089297897e-07,   2.443830530400888e-08,
   2.157790571030437e-10,  -3.958484334840923e-12,  -1.111584294047067e-13,  -1.762529539633470e-16,   3.337884177120508e-17,   4.850490059514111e-19,  -5.199490264734536e-21,
  -2.398793769650786e-22,  -1.339594773136550e-24,   1.494887849739547e+00,  -1.093310583651869e-02,  -1.089639015756235e-04,   2.819895240045319e-07,   2.443813118467597e-08,
   2.157722192017798e-10,  -3.958498686437002e-12,  -1.111549077856076e-13,  -1.761890460922262e-16,   3.337800270016764e-17,   4.850026236082135e-19,  -5.199795381992044e-21,
  -2.398608623067674e-22,  -1.339149727359686e-24,   1.776294368191718e+00,  -5.997755900215739e-03,  -1.028068576666142e-04,  -1.155323877696827e-06,  -3.546656179091219e-09,
   1.908457887243133e-10,   5.043683341558965e-12,   5.874091431239510e-14,  -1.643953700580697e-16,  -2.214464440204523e-17,  -4.696724964760276e-19,  -3.886082138132603e-21,
   6.477765730803550e-23,   2.888836403514498e-24,   1.776284726144145e+00,  -5.998080200617385e-03,  -1.028088126561869e-04,  -1.155143999059132e-06,  -3.539569159949218e-09,
   1.909602368454860e-10,   5.043211204210165e-12,   5.866567870848702e-14,  -1.663632330548842e-16,  -2.216385753511163e-17,  -4.692534665461783e-19,  -3.864901736306184e-21,
   6.517237215829521e-23,   2.889899386194789e-24,   1.776267712455025e+00,  -5.998652392489270e-03,  -1.028122590264527e-04,  -1.154826513506584e-06,  -3.527064558741042e-09,
   1.911620616929736e-10,   5.042373919009518e-12,   5.853287218759666e-14,  -1.698341051363089e-16,  -2.219767056710469e-17,  -4.685121076271291e-19,  -3.827522739736394e-21,
   6.586780587484103e-23,   2.891739744496703e-24,   1.776247139074152e+00,  -5.999344222600409e-03,  -1.028164208906100e-04,  -1.154442458532647e-06,  -3.511944811902615e-09,
   1.914059046582726e-10,   5.041354320216649e-12,   5.837219243148722e-14,  -1.740286384071282e-16,  -2.223840614497850e-17,  -4.676122862586967e-19,  -3.782313836044296e-21,
   6.670694469113200e-23,   2.893904984863069e-24,   1.776227166534514e+00,  -6.000015765542770e-03,  -1.028204553722723e-04,  -1.154069469654249e-06,  -3.497267822978367e-09,
   1.916424076076329e-10,   5.040357032355252e-12,   5.821611464129122e-14,  -1.780980133310227e-16,  -2.227779286752488e-17,  -4.667352389649983e-19,  -3.738415712726818e-21,
   6.751969205368861e-23,   2.895944027885487e-24,   1.776211076731884e+00,  -6.000556698947631e-03,  -1.028237013541664e-04,  -1.153768883694393e-06,  -3.485444950708743e-09,
   1.918327767946510e-10,   5.039548273473879e-12,   5.809031415979143e-14,  -1.813743779633267e-16,  -2.230940859746810e-17,  -4.660261849261291e-19,  -3.703044846199936e-21,
   6.817308610833075e-23,   2.897541592811586e-24,   1.776200444786692e+00,  -6.000914112220450e-03,  -1.028258442121981e-04,  -1.153570207535912e-06,  -3.477632960627668e-09,
   1.919584936878137e-10,   5.039011237985807e-12,   5.800715506877703e-14,  -1.835384236369972e-16,  -2.233024403168853e-17,  -4.655564239950321e-19,  -3.679668978846509e-21,
   6.860417812460613e-23,   2.898575184447460e-24,   1.776194984746221e+00,  -6.001097653031509e-03,  -1.028269440448629e-04,  -1.153468161030947e-06,  -3.473621239444928e-09,
   1.920230319204456e-10,   5.038734633846942e-12,   5.796443889752937e-14,  -1.846494804697021e-16,  -2.234092680431298e-17,  -4.653147989697644e-19,  -3.667663303143392e-21,
   6.882536049699116e-23,   2.899099166476729e-24,   1.776193084324693e+00,  -6.001161534816934e-03,  -1.028273267518016e-04,  -1.153432640137621e-06,  -3.472224940606357e-09,
   1.920454913164683e-10,   5.038638230190528e-12,   5.794956955224125e-14,  -1.850361487036608e-16,  -2.234464229963639e-17,  -4.652306386461606e-19,  -3.663484451703022e-21,
   6.890231255502022e-23,   2.899280458227089e-24,   1.776192782753759e+00,  -6.001171671915971e-03,  -1.028273874773799e-04,  -1.153427003334176e-06,  -3.472003368040039e-09,
   1.920490551363666e-10,   5.038622926131688e-12,   5.794720991643552e-14,  -1.850975054772817e-16,  -2.234523176742258e-17,  -4.652172806892647e-19,  -3.662821317667731e-21,
   6.891452224402669e-23,   2.899309175227735e-24,   1.955344461486749e+00,  -1.354207100401498e-03,  -2.996988264070345e-05,  -5.675328327125591e-07,  -9.560355245721872e-09,
  -1.433908070763634e-10,  -1.855238633905559e-12,  -1.855805394898007e-14,  -7.238955211493962e-17,   2.693830498239777e-18,   9.891530421826096e-20,   2.207525346593830e-21,
   3.841935505687404e-23,   5.239740153474445e-25,   1.955341640990412e+00,  -1.354367193343569e-03,  -2.997527506962632e-05,  -5.676675671053795e-07,  -9.562966299275835e-09,
  -1.434271930910297e-10,  -1.855419855022293e-12,  -1.854866110837922e-14,  -7.196454600044447e-17,   2.705361585918499e-18,   9.915476278140233e-20,   2.211345259575503e-21,
   3.845710537542021e-23,   5.237699625991867e-25,   1.955336663767412e+00,  -1.354649710723792e-03,  -2.998479129000622e-05,  -5.679053357512825e-07,  -9.567573748132066e-09,
  -1.434913816044102e-10,  -1.855738710837970e-12,  -1.853205554391383e-14,  -7.121379318212807e-17,   2.725724372849989e-18,   9.957747946359197e-20,   2.218084279272076e-21,
   3.852356955955188e-23,   5.234051803823440e-25,   1.955330644552191e+00,  -1.354991386390969e-03,  -2.999630044251556e-05,  -5.681928953444308e-07,  -9.573145471269697e-09,
  -1.435689731193044e-10,  -1.856122718975843e-12,  -1.851192175241003e-14,  -7.030457139652705e-17,   2.750374552191596e-18,   1.000889535174013e-19,   2.226230977441428e-21,
   3.860368790229653e-23,   5.229560121101267e-25,   1.955324800464953e+00,  -1.355323134335997e-03,  -3.000747546191225e-05,  -5.684721026433512e-07,  -9.578554765845702e-09,
  -1.436442704297645e-10,  -1.856493876755481e-12,  -1.849231945616139e-14,  -6.942044437902791e-17,   2.774333081926063e-18,   1.005858186759788e-19,   2.234137326239408e-21,
   3.868120210195587e-23,   5.225115063296320e-25,   1.955320092015949e+00,  -1.355590425664809e-03,  -3.001647944081972e-05,  -5.686970638170720e-07,  -9.582912682081881e-09,
  -1.437049094515709e-10,  -1.856791707180083e-12,  -1.847648740585137e-14,  -6.870714932950985e-17,   2.793654223291496e-18,   1.009863263542197e-19,   2.240504894925685e-21,
   3.874345745336556e-23,   5.221473485974817e-25,   1.955316980498019e+00,  -1.355767066354400e-03,  -3.002242985815231e-05,  -5.688457314853108e-07,  -9.585792441987121e-09,
  -1.437449690705136e-10,  -1.856987935184560e-12,  -1.846600593259217e-14,  -6.823530052913544e-17,   2.806431306355854e-18,   1.012510918065553e-19,   2.244711639765542e-21,
   3.878450193007125e-23,   5.219037448103968e-25,   1.955315382504669e+00,  -1.355857785782213e-03,  -3.002548591364599e-05,  -5.689220848059569e-07,  -9.587271375552486e-09,
  -1.437655386404134e-10,  -1.857088530344508e-12,  -1.846061702669507e-14,  -6.799282393847423e-17,   2.812996047435200e-18,   1.013870977136829e-19,   2.246871745997179e-21,
   3.880555151215871e-23,   5.217777219762008e-25,   1.955314826295711e+00,  -1.355889362462182e-03,  -3.002654963859886e-05,  -5.689486611316175e-07,  -9.587786138137436e-09,
  -1.437726975959179e-10,  -1.857123515174928e-12,  -1.845874038650903e-14,  -6.790840232032705e-17,   2.815281458795781e-18,   1.014344415713488e-19,   2.247623549461081e-21,
   3.881287343634644e-23,   5.217337119520301e-25,   1.955314738032405e+00,  -1.355894373291623e-03,  -3.002671843884849e-05,  -5.689528784689869e-07,  -9.587867824165129e-09,
  -1.437738336011651e-10,  -1.857129065445062e-12,  -1.845844254292752e-14,  -6.789500456535854e-17,   2.815644145512486e-18,   1.014419546627235e-19,   2.247742848353840e-21,
   3.881403510758992e-23,   5.217267212055102e-25,   1.018578301798686e-02,  -2.306441020457198e-04,   3.898877422405153e-06,  -5.828508115441865e-08,   8.105050521126698e-10,
  -1.073256710172664e-11,   1.365178845120153e-13,  -1.682280888526153e-15,   2.000617727027161e-17,  -2.324035308096422e-19,   2.556886876959129e-21,  -2.803811820051878e-23,
   2.876798225392992e-25,  -1.998957981594868e-27,   1.018614945444770e-02,  -2.306605302381405e-04,   3.899334418115526e-06,  -5.829517088064914e-08,   8.106976540633939e-10,
  -1.073589163071332e-11,   1.365706247748118e-13,  -1.683069034658929e-15,   2.001702197689065e-17,  -2.325486707826159e-19,   2.558683806030607e-21,  -2.805273434615437e-23,
   2.880458490797700e-25,  -1.998896504024652e-27,   1.018679607231904e-02,  -2.306895203545071e-04,   3.900140882474866e-06,  -5.831297689937604e-08,   8.110375636260524e-10,
  -1.074175907787362e-11,   1.366637089788254e-13,  -1.684460129596092e-15,   2.003616381067039e-17,  -2.328048338243691e-19,   2.561856349302225e-21,  -2.807852476782677e-23,
   2.886910150925448e-25,  -1.998815370988872e-27,   1.018757802919194e-02,  -2.307245794561955e-04,   3.901116218268897e-06,  -5.833451245574428e-08,   8.114486888903033e-10,
  -1.074885621241833e-11,   1.367763069268178e-13,  -1.686142936367198e-15,   2.005932085948970e-17,  -2.331146933929888e-19,   2.565695746668682e-21,  -2.810971093644857e-23,
   2.894699737261968e-25,  -1.998763772417834e-27,   1.018833720184269e-02,  -2.307586183550681e-04,   3.902063214973909e-06,  -5.835542333445874e-08,   8.118479100529085e-10,
  -1.075574824477271e-11,   1.368856564767746e-13,  -1.687777288193396e-15,   2.008181236334208e-17,  -2.334156091115633e-19,   2.569426235693946e-21,  -2.813998619043605e-23,
   2.902249339527208e-25,  -1.998762234976392e-27,   1.018894882621006e-02,  -2.307860426087155e-04,   3.902826216140864e-06,  -5.837227211516179e-08,   8.121695947366840e-10,
  -1.076130199393101e-11,   1.369737767312816e-13,  -1.689094411122181e-15,   2.009993914156746e-17,  -2.336581012961276e-19,   2.572433808872431e-21,  -2.816437582756492e-23,
   2.908322317657365e-25,  -1.998795679599324e-27,   1.018935299861016e-02,  -2.308041655161177e-04,   3.903330449023389e-06,  -5.838340708021540e-08,   8.123821961032643e-10,
  -1.076497260457950e-11,   1.370320195606329e-13,  -1.689964992413553e-15,   2.011192087076120e-17,  -2.338183741965042e-19,   2.574422304377446e-21,  -2.818049224532552e-23,
   2.912330882526954e-25,  -1.998834718556411e-27,   1.018956056725398e-02,  -2.308134729444084e-04,   3.903589413839904e-06,  -5.838912590961557e-08,   8.124913887869995e-10,
  -1.076685788379070e-11,   1.370619345361009e-13,  -1.690412154862617e-15,   2.011807526135543e-17,  -2.339006938705262e-19,   2.575443845797319e-21,  -2.818876886115217e-23,
   2.914388126539061e-25,  -1.998859996537672e-27,   1.018963281450032e-02,  -2.308167125514151e-04,   3.903679551639040e-06,  -5.839111647890040e-08,   8.125293961648068e-10,
  -1.076751411149411e-11,   1.370723474330621e-13,  -1.690567806155088e-15,   2.012021754432940e-17,  -2.339293478768023e-19,   2.575799458957543e-21,  -2.819164962405535e-23,
   2.915103954869445e-25,  -1.998869626527161e-27,   1.018964427919453e-02,  -2.308172266358180e-04,   3.903693855395646e-06,  -5.839143235855049e-08,   8.125354275007242e-10,
  -1.076761824764487e-11,   1.370739998503834e-13,  -1.690592506455811e-15,   2.012055750419980e-17,  -2.339338949626872e-19,   2.575855892541562e-21,  -2.819210676198956e-23,
   2.915217536793453e-25,  -1.998871194143825e-27,   9.120290595588854e-02,  -2.007089776449123e-03,   3.185241675277780e-05,  -4.244043541889503e-07,   4.854216755539200e-09,
  -4.605975132726830e-11,   3.044022963339726e-13,   9.537154505392355e-17,  -4.850751891245360e-17,   1.032434266631756e-18,  -1.561192820064965e-20,   1.698489407255099e-22,
  -1.275317758171510e-24,   6.550471898223083e-27,   9.120589760029899e-02,  -2.007209292029186e-03,   3.185514965119109e-05,  -4.244475330175115e-07,   4.854643296324568e-09,
  -4.605950772475729e-11,   3.042735982309135e-13,   9.887888672732884e-17,  -4.857362916842489e-17,   1.033311815978730e-18,  -1.561965349829420e-20,   1.698947038827526e-22,
  -1.271741547599203e-24,   6.512281723563742e-27,   9.121117661259057e-02,  -2.007420189026346e-03,   3.185997208821078e-05,  -4.245237225380357e-07,   4.855395786585235e-09,
  -4.605907225915376e-11,   3.040463671620695e-13,   1.050700555685859e-16,  -4.869030810783350e-17,   1.034860455256051e-18,  -1.563326691719514e-20,   1.699752216512856e-22,
  -1.265431220115890e-24,   6.444523260134022e-27,   9.121756040646060e-02,  -2.007675224767969e-03,   3.186580376264446e-05,  -4.246158513733736e-07,   4.856305453956172e-09,
  -4.605853609551792e-11,   3.037713560590895e-13,   1.125605914623423e-16,  -4.883144241936715e-17,   1.036733409110595e-18,  -1.564969773360176e-20,   1.700721874417435e-22,
  -1.257800620625417e-24,   6.361956946599476e-27,   9.122375805565343e-02,  -2.007922826685220e-03,   3.187146539891389e-05,  -4.247052880849217e-07,   4.857188279373193e-09,
  -4.605800554705080e-11,   3.035041277585441e-13,   1.198365767552550e-16,  -4.896850012182881e-17,   1.038551977351193e-18,  -1.566561636276338e-20,   1.701659023381353e-22,
  -1.250392875075382e-24,   6.281142443043056e-27,   9.122875106822838e-02,  -2.008122304204515e-03,   3.187602658853371e-05,  -4.247773368710509e-07,   4.857899282851006e-09,
  -4.605757094087135e-11,   3.032886713208934e-13,   1.257010990818870e-16,  -4.907894563029470e-17,   1.040017233168585e-18,  -1.567841718722098e-20,   1.702410971276275e-22,
  -1.244425223350978e-24,   6.215566978310135e-27,   9.123205049271677e-02,  -2.008254121582003e-03,   3.187904066331390e-05,  -4.248249452943118e-07,   4.858369008606854e-09,
  -4.605728023299504e-11,   3.031462130096626e-13,   1.295777807058587e-16,  -4.915194249370180e-17,   1.040985565810675e-18,  -1.568686447457947e-20,   1.702906367240813e-22,
  -1.240481870936121e-24,   6.172004980162817e-27,   9.123374494549233e-02,  -2.008321818025743e-03,   3.188058857263740e-05,  -4.248493944568614e-07,   4.858610206588488e-09,
  -4.605712984936419e-11,   3.030730264670928e-13,   1.315691091415338e-16,  -4.918943495645383e-17,   1.041482887302650e-18,  -1.569119907564283e-20,   1.703160318587670e-22,
  -1.238456759904030e-24,   6.149562482240415e-27,   9.123433472173463e-02,  -2.008345380697510e-03,   3.188112734265525e-05,  -4.248579042052738e-07,   4.858694153189826e-09,
  -4.605707733322134e-11,   3.030475488609955e-13,   1.322622835778144e-16,  -4.920248536001082e-17,   1.041655990384093e-18,  -1.569270721839072e-20,   1.703248635632860e-22,
  -1.237751899710856e-24,   6.141739817015893e-27,   9.123442831140731e-02,  -2.008349119783469e-03,   3.188121283832197e-05,  -4.248592545848391e-07,   4.858707474142596e-09,
  -4.605706899138422e-11,   3.030435057088153e-13,   1.323722843434198e-16,  -4.920455631770079e-17,   1.041683459733489e-18,  -1.569294651353388e-20,   1.703262646861760e-22,
  -1.237640048022066e-24,   6.140497929183553e-27,   2.505748843627511e-01,  -5.187859568190102e-03,   7.121418297587984e-05,  -6.916866323165843e-07,   3.219214720575033e-09,
   4.152210320908917e-11,  -1.300659306040236e-12,   1.781656016632301e-14,  -1.149539938605050e-16,  -1.155242366446963e-18,   4.504811241211591e-20,  -7.254538745290016e-22,
   5.536883286902044e-24,   5.555470555925492e-26,   2.505815642933818e-01,  -5.188053966459403e-03,   7.121598343450790e-05,  -6.916474111081225e-07,   3.217382156380192e-09,
   4.155711571509509e-11,  -1.300957109097634e-12,   1.781256422441171e-14,  -1.147628673518290e-16,  -1.158966232138838e-18,   4.508179649915383e-20,  -7.250266843268191e-22,
   5.524526636353261e-24,   5.593573812160409e-26,   2.505933512722384e-01,  -5.188396976249602e-03,   7.121915953324496e-05,  -6.915781780012535e-07,   3.214148229061985e-09,
   4.161888939000308e-11,  -1.301482178741909e-12,   1.780550311646394e-14,  -1.144255065915074e-16,  -1.165535239633754e-18,   4.514116999539829e-20,  -7.242706483894423e-22,
   5.502682727590706e-24,   5.660709809766171e-26,   2.506076044451527e-01,  -5.188811731978731e-03,   7.122299867538187e-05,  -6.914944151217373e-07,   3.210237151948600e-09,
   4.169357578113867e-11,  -1.302116401811385e-12,   1.779694735135119e-14,  -1.140173703691759e-16,  -1.173475457456092e-18,   4.521285817539522e-20,  -7.233526055994300e-22,
   5.476199997526189e-24,   5.741724776526907e-26,   2.506214414217381e-01,  -5.189214353556282e-03,   7.122672415008686e-05,  -6.914130519599895e-07,   3.206439741489583e-09,
   4.176606850705868e-11,  -1.302731364740531e-12,   1.778862334811278e-14,  -1.136209537429401e-16,  -1.181180432915706e-18,   4.528233971242942e-20,  -7.224573735322635e-22,
   5.450418995754319e-24,   5.820198439130528e-26,   2.506325884842356e-01,  -5.189538688720532e-03,   7.122972427063676e-05,  -6.913474727468542e-07,   3.203380164173701e-09,
   4.182445943325004e-11,  -1.303226247794636e-12,   1.778190459177195e-14,  -1.133014588820180e-16,  -1.187385126146209e-18,   4.533823268586555e-20,  -7.217333151903486e-22,
   5.429598595727334e-24,   5.883291078875853e-26,   2.506399543497875e-01,  -5.189752997966150e-03,   7.123170617123581e-05,  -6.913041224720460e-07,   3.201358238176893e-09,
   4.186303906329137e-11,  -1.303553001524043e-12,   1.777745857007988e-14,  -1.130902705548830e-16,  -1.191483931385659e-18,   4.537512632657951e-20,  -7.212534660423350e-22,
   5.415815619638870e-24,   5.924920559363399e-26,   2.506437371005474e-01,  -5.189863054269503e-03,   7.123272380946443e-05,  -6.912818548676331e-07,   3.200319816952231e-09,
   4.188285029474915e-11,  -1.303720725960719e-12,   1.777517335017536e-14,  -1.129817930460413e-16,  -1.193588509238397e-18,   4.539406076833370e-20,  -7.210066065603741e-22,
   5.408729604330587e-24,   5.946280432795344e-26,   2.506450537257863e-01,  -5.189901360095344e-03,   7.123307798188873e-05,  -6.912741036018940e-07,   3.199958374513165e-09,
   4.188974557548300e-11,  -1.303779091370933e-12,   1.777437764405631e-14,  -1.129440329227733e-16,  -1.194320970310917e-18,   4.540064912969004e-20,  -7.209206157933535e-22,
   5.406262010777789e-24,   5.953711931388338e-26,   2.506452626562780e-01,  -5.189907438689131e-03,   7.123313418294609e-05,  -6.912728735437460e-07,   3.199901018081221e-09,
   4.189083975208530e-11,  -1.303788352558769e-12,   1.777425136152857e-14,  -1.129380407435538e-16,  -1.194437199111310e-18,   4.540169451957012e-20,  -7.209069669647856e-22,
   5.405870378756512e-24,   5.954891065422374e-26,   4.821644509020318e-01,  -9.007778959587088e-03,   9.306427231023171e-05,  -2.710909977171106e-07,  -9.580998525468813e-09,
   1.837883433442805e-10,  -9.337099511634671e-13,  -2.375092260306343e-14,   5.795158910921461e-16,  -4.075963960864159e-18,  -7.293185378111536e-20,   2.157607098479450e-21,
  -1.883829302550361e-23,  -1.950937169387268e-25,   4.821731648269160e-01,  -9.007854598358353e-03,   9.305887570835619e-05,  -2.709190916325068e-07,  -9.582293648825722e-09,
   1.837413702261674e-10,  -9.321951646738943e-13,  -2.376439067068961e-14,   5.792046099509175e-16,  -4.064896243324699e-18,  -7.304444953665369e-20,   2.156137923617352e-21,
  -1.875255918430228e-23,  -1.958678610596232e-25,   4.821885402725007e-01,  -9.007988024923433e-03,   9.304935273124167e-05,  -2.706157965053176e-07,  -9.584577185102026e-09,
   1.836584640039873e-10,  -9.295229665318935e-13,  -2.378812496206188e-14,   5.786549667673241e-16,  -4.045373283638559e-18,  -7.324269633764868e-20,   2.153540966434837e-21,
  -1.860137942820795e-23,  -1.972318245275994e-25,   4.822071317231302e-01,  -9.008149298855267e-03,   9.303783644316284e-05,  -2.702491099582162e-07,  -9.587335513554653e-09,
   1.835581764309280e-10,  -9.262928528939238e-13,  -2.381677302442410e-14,   5.779896808084623e-16,  -4.021776500252135e-18,  -7.348168533603279e-20,   2.150392905546889e-21,
  -1.841874029943128e-23,  -1.988776843802040e-25,   4.822251792459472e-01,  -9.008305790750728e-03,   9.302665558102435e-05,  -2.698932010672413e-07,  -9.590010164609304e-09,
   1.834607808282938e-10,  -9.231583057531705e-13,  -2.384452994650202e-14,   5.773431517073732e-16,  -3.998880255806204e-18,  -7.371292440769711e-20,   2.147328672866750e-21,
  -1.824161482750381e-23,  -2.004718279061382e-25,   4.822397175685264e-01,  -9.008431808404063e-03,   9.301764767275219e-05,  -2.696065314029013e-07,  -9.592162617749648e-09,
   1.833822928837969e-10,  -9.206340093757568e-13,  -2.386685179503314e-14,   5.768218292380119e-16,  -3.980443307056658e-18,  -7.389865813028142e-20,   2.144854335131609e-21,
  -1.809905226748152e-23,  -2.017534449218034e-25,   4.822493239750034e-01,  -9.008515054055815e-03,   9.301169503985529e-05,  -2.694171276781905e-07,  -9.593583838082544e-09,
   1.833304160868636e-10,  -9.189664176578072e-13,  -2.388158269783863e-14,   5.764771105387370e-16,  -3.968264405861220e-18,  -7.402111875713028e-20,   2.143216484479543e-21,
  -1.800491196957127e-23,  -2.025990377599461e-25,   4.822542572445593e-01,  -9.008557797083504e-03,   9.300863796440368e-05,  -2.693198667567379e-07,  -9.594313368037824e-09,
   1.833037707398491e-10,  -9.181101589436732e-13,  -2.388914185335680e-14,   5.763000074362788e-16,  -3.962011166364733e-18,  -7.408392501284163e-20,   2.142374488327972e-21,
  -1.795658577606512e-23,  -2.030328948955855e-25,   4.822559743014982e-01,  -9.008572672976204e-03,   9.300757390320961e-05,  -2.692860153094721e-07,  -9.594567234340329e-09,
   1.832944959256046e-10,  -9.178121508651846e-13,  -2.389177195255965e-14,   5.762383533763011e-16,  -3.959834861657892e-18,  -7.410577207236405e-20,   2.142081283582219e-21,
  -1.793976848521176e-23,  -2.031838398882821e-25,   4.822562467741834e-01,  -9.008575033518082e-03,   9.300740505049403e-05,  -2.692806436035618e-07,  -9.594607516896962e-09,
   1.832930241091238e-10,  -9.177648620657876e-13,  -2.389218926873766e-14,   5.762285691706427e-16,  -3.959489521217016e-18,  -7.410923827166452e-20,   2.142034749369025e-21,
  -1.793709995918603e-23,  -2.032077897903623e-25,   7.745421207231107e-01,  -1.230379550980388e-02,   6.759598330711746e-05,   8.923521184852154e-07,  -1.836201737244011e-08,
  -1.913275251383496e-11,   4.283007934291910e-12,  -3.649782692057140e-14,  -7.506967620827567e-16,   1.722024103130604e-17,   2.868602479603910e-20,  -5.346378404008934e-21,
   4.690470139815929e-23,   1.153922862255507e-24,   7.745484371687956e-01,  -1.230354460167038e-02,   6.758568854614649e-05,   8.923335859922094e-07,  -1.835601767184798e-08,
  -1.920369588546834e-11,   4.281040071544505e-12,  -3.644041750754454e-14,  -7.505667490938502e-16,   1.719300125022457e-17,   2.896715957835513e-20,  -5.337960036858540e-21,
   4.670769850144166e-23,   1.153582437464727e-24,   7.745595818561204e-01,  -1.230310187465576e-02,   6.756752601645328e-05,   8.923008313241838e-07,  -1.834543335435939e-08,
  -1.932878504177166e-11,   4.277568029613434e-12,  -3.633919219576055e-14,  -7.503363828368775e-16,   1.714497149653420e-17,   2.946224202415917e-20,  -5.323107869377908e-21,
   4.636069112320708e-23,   1.152970586223889e-24,   7.745730568005124e-01,  -1.230256653181770e-02,   6.754556835929183e-05,   8.922611323564200e-07,  -1.833263851837326e-08,
  -1.947988818594842e-11,   4.273370083075868e-12,  -3.621691643075577e-14,  -7.500561932412881e-16,   1.708695353453834e-17,   3.005922477763925e-20,  -5.305152221324786e-21,
   4.594212028315292e-23,   1.152211744081073e-24,   7.745861366500708e-01,  -1.230204683801537e-02,   6.752425713298306e-05,   8.922224973471102e-07,  -1.832022152751564e-08,
  -1.962641324481577e-11,   4.269295297501611e-12,  -3.609834610513113e-14,  -7.497824878733799e-16,   1.703069365984487e-17,   3.063701262676116e-20,  -5.287725174975771e-21,
   4.553686021258809e-23,   1.151455261652861e-24,   7.745966726086820e-01,  -1.230162818501257e-02,   6.750709258721764e-05,   8.921913047891347e-07,  -1.831022143728309e-08,
  -1.974433502628193e-11,   4.266013068645068e-12,  -3.600292253436308e-14,  -7.495607768648614e-16,   1.698541654004387e-17,   3.110121709042642e-20,  -5.273689069351311e-21,
   4.521116146204390e-23,   1.150831703120209e-24,   7.746036340937994e-01,  -1.230135154929458e-02,   6.749575227507945e-05,   8.921706596839252e-07,  -1.830361496394655e-08,
  -1.982219843075549e-11,   4.263844409705219e-12,  -3.593991489850662e-14,  -7.494136788818710e-16,   1.695552030737342e-17,   3.140734193563567e-20,  -5.264415695149575e-21,
   4.499632375853035e-23,   1.150412760107454e-24,   7.746072089983963e-01,  -1.230120948446123e-02,   6.748992901217603e-05,   8.921600470413908e-07,  -1.830022265924400e-08,
  -1.986216732876736e-11,   4.262730755166781e-12,  -3.590757185661097e-14,  -7.493379531053213e-16,   1.694017398980801e-17,   3.156436221570977e-20,  -5.259653820827080e-21,
   4.488611118378142e-23,   1.150195481070155e-24,   7.746084532526238e-01,  -1.230116003762947e-02,   6.748790225656551e-05,   8.921563515596884e-07,  -1.829904200585137e-08,
  -1.987607605469936e-11,   4.262343146366261e-12,  -3.589631685576618e-14,  -7.493115667901802e-16,   1.693483365048518e-17,   3.161898441168140e-20,  -5.257996478338846e-21,
   4.484776928365571e-23,   1.150119516105721e-24,   7.746086506974917e-01,  -1.230115219110465e-02,   6.748758064236833e-05,   8.921557650591097e-07,  -1.829885465570925e-08,
  -1.987828304432247e-11,   4.262281638608668e-12,  -3.589453095089424e-14,  -7.493073782563731e-16,   1.693398626378760e-17,   3.162765077086057e-20,  -5.257733484310760e-21,
   4.484168583477439e-23,   1.150107445425888e-24,   1.107869665235010e+00,  -1.363740290637261e-02,  -1.264627513225072e-05,   1.717434334905664e-06,   1.624912268208527e-09,
  -3.936227256221644e-10,  -8.761988618471028e-14,   1.092874672937946e-13,  -1.038804079445281e-16,  -3.390356925499086e-17,   6.911661977747159e-20,   1.096729850637225e-20,
  -3.964307366405700e-23,  -3.685293561325026e-24,   1.107868481482412e+00,  -1.363692117201879e-02,  -1.264536183586569e-05,   1.717067106473674e-06,   1.624785906384692e-09,
  -3.934093602182052e-10,  -8.788672871224314e-14,   1.091744866215767e-13,  -1.035963838523158e-16,  -3.384803503224738e-17,   6.888010233610063e-20,   1.094107851049373e-20,
  -3.945268702421472e-23,  -3.672011624440885e-24,   1.107866392801824e+00,  -1.363607122781852e-02,  -1.264375036852746e-05,   1.716419288192085e-06,   1.624562636167528e-09,
  -3.930330537280834e-10,  -8.835697497486930e-14,   1.089752820803439e-13,  -1.030960224048659e-16,  -3.375015319360396e-17,   6.846371341530527e-20,   1.089489116300723e-20,
  -3.911746223281707e-23,  -3.648628465916868e-24,   1.107863867265429e+00,  -1.363504360880759e-02,  -1.264180186484682e-05,   1.715636215642871e-06,   1.624292139619220e-09,
  -3.925783268565353e-10,  -8.892457721104642e-14,   1.087346601620571e-13,  -1.024923478646570e-16,  -3.363197935066903e-17,   6.796182855975486e-20,   1.083917413315881e-20,
  -3.871332303042573e-23,  -3.620443550713749e-24,   1.107861415642488e+00,  -1.363404616335409e-02,  -1.263991039587596e-05,   1.714876311521848e-06,   1.624029006691358e-09,
  -3.921372071120757e-10,  -8.947452420511652e-14,   1.085013388410920e-13,  -1.019077406592233e-16,  -3.351745264051703e-17,   6.747629768667449e-20,   1.078522422164192e-20,
  -3.832226524363217e-23,  -3.593176418551967e-24,   1.107859440735825e+00,  -1.363324274121391e-02,  -1.263838672815289e-05,   1.714264349738178e-06,   1.623816644053071e-09,
  -3.917820767945916e-10,  -8.991678772163722e-14,   1.083135716847620e-13,  -1.014378109999957e-16,  -3.342533050638031e-17,   6.708636918897345e-20,   1.074186243016386e-20,
  -3.800814517513519e-23,  -3.571277783932851e-24,   1.107858135796207e+00,  -1.363271190653041e-02,  -1.263737995246072e-05,   1.713860077657945e-06,   1.623676129693418e-09,
  -3.915475255671930e-10,  -9.020865263433487e-14,   1.081895931447297e-13,  -1.011277895960348e-16,  -3.336452586457891e-17,   6.682930238510985e-20,   1.071325839828560e-20,
  -3.780102567470270e-23,  -3.556840502744003e-24,   1.107857465660735e+00,  -1.363243931371002e-02,  -1.263686293635710e-05,   1.713652495941769e-06,   1.623603910459877e-09,
  -3.914271070864833e-10,  -9.035842336832290e-14,   1.081259534884942e-13,  -1.009687331503152e-16,  -3.333332079124507e-17,   6.669746886442739e-20,   1.069858389360199e-20,
  -3.769479753021478e-23,  -3.549436444178630e-24,   1.107857232416090e+00,  -1.363234443785970e-02,  -1.263668298598099e-05,   1.713580250213321e-06,   1.623578764602282e-09,
  -3.913851998701726e-10,  -9.041053400614939e-14,   1.081038077795765e-13,  -1.009133966599484e-16,  -3.332246292452516e-17,   6.665161205093157e-20,   1.069347868987907e-20,
  -3.765784575103986e-23,  -3.546861012698481e-24,   1.107857195403479e+00,  -1.363232938249125e-02,  -1.263665443042072e-05,   1.713568786048025e-06,   1.623574773859939e-09,
  -3.913785500350153e-10,  -9.041880237155632e-14,   1.081002937815853e-13,  -1.009046166867729e-16,  -3.332074008937244e-17,   6.664433658497079e-20,   1.069266867788548e-20,
  -3.765198305199447e-23,  -3.546452404023744e-24,   1.449544854063303e+00,  -1.178642404520422e-02,  -1.032743845082398e-04,   7.004773261039924e-07,   2.765623090615015e-08,
   8.597466791312743e-11,  -6.981661952732954e-12,  -9.607290304822214e-14,   1.287784722929006e-15,   4.562947324787988e-17,   1.185183119638783e-20,  -1.664858596637954e-20,
  -1.834778088905099e-22,   4.419024900592665e-24,   1.449535203225635e+00,  -1.178622675830368e-02,  -1.032588830802744e-04,   7.005563595699927e-07,   2.764645294254191e-08,
   8.578793439109142e-11,  -6.978281314992218e-12,  -9.592110412778953e-14,   1.287799957320171e-15,   4.554487879340884e-17,   1.076333979701700e-20,  -1.661644195997406e-20,
  -1.824628173063448e-22,   4.416008375556245e-24,   1.449518175345420e+00,  -1.178587862465893e-02,  -1.032315350285355e-04,   7.006956737802939e-07,   2.762920343674541e-08,
   8.545868203642855e-11,  -6.972316114878544e-12,  -9.565348373989948e-14,   1.287823146230460e-15,   4.539574511734884e-17,   8.847743555980390e-21,  -1.655974189288278e-20,
  -1.806756412946327e-22,   4.410640627929177e-24,   1.449497587053412e+00,  -1.178545762739881e-02,  -1.031984730786470e-04,   7.008638927254493e-07,   2.760835173985608e-08,
   8.506095874854584e-11,  -6.965102916678031e-12,  -9.533026826195676e-14,   1.287844902472574e-15,   4.521564048113608e-17,   6.540005564122504e-21,  -1.649121135593157e-20,
  -1.785210276036230e-22,   4.404073364878922e-24,   1.449477602392806e+00,  -1.178504889880524e-02,  -1.031663850738768e-04,   7.010269442530399e-07,   2.758811617424659e-08,
   8.467528717099444e-11,  -6.958100460377945e-12,  -9.501690849374423e-14,   1.287859457560908e-15,   4.504103817215206e-17,   4.308705169275885e-21,  -1.642471661789481e-20,
  -1.764361190553869e-22,   4.397618192890141e-24,   1.449461504512316e+00,  -1.178471960964297e-02,  -1.031405410995182e-04,   7.011581156319130e-07,   2.757181961012322e-08,
   8.436490396551502e-11,  -6.952459371466984e-12,  -9.476476506858503e-14,   1.287866489418222e-15,   4.490055284314418e-17,   2.517643751696504e-21,  -1.637117350153927e-20,
  -1.747613751798037e-22,   4.392361069452395e-24,   1.449450868055095e+00,  -1.178450201011293e-02,  -1.031234666545303e-04,   7.012447028578832e-07,   2.756105355175635e-08,
   8.415995937859446e-11,  -6.948731841765205e-12,  -9.459829759629941e-14,   1.287868842148786e-15,   4.480780684625595e-17,   1.337293282957482e-21,  -1.633580506849942e-20,
  -1.736570968857797e-22,   4.388859485114788e-24,   1.449445405952797e+00,  -1.178439025890595e-02,  -1.031146989736751e-04,   7.012891421865403e-07,   2.755552541433049e-08,
   8.405475723837358e-11,  -6.946817577739826e-12,  -9.451285322508644e-14,   1.287869341923080e-15,   4.476020337630128e-17,   7.321003143734823e-22,  -1.631764538125523e-20,
  -1.730907271839212e-22,   4.387052686724717e-24,   1.449443504854276e+00,  -1.178435136232802e-02,  -1.031116474395440e-04,   7.013046053477653e-07,   2.755360141466545e-08,
   8.401814810483928e-11,  -6.946151300784652e-12,  -9.448312063437558e-14,   1.287869403166574e-15,   4.474363869741862e-17,   5.216122486617160e-22,  -1.631132532536205e-20,
  -1.728937131903886e-22,   4.386422451950744e-24,   1.449443203177842e+00,  -1.178434518995083e-02,  -1.031111632096304e-04,   7.013070589318047e-07,   2.755329610807477e-08,
   8.401233909245521e-11,  -6.946045571816760e-12,  -9.447840281898425e-14,   1.287869407536118e-15,   4.474101030777088e-17,   4.882180428158811e-22,  -1.631032244754605e-20,
  -1.728624552966845e-22,   4.386322377748868e-24,   1.750569707909157e+00,  -6.876295486434840e-03,  -1.168624814953325e-04,  -1.174420331937164e-06,   1.607275011661111e-09,
   3.301635131107465e-10,   6.467520053621820e-12,   3.684431775686154e-14,  -1.328081024958247e-15,  -4.280107124903255e-17,  -5.070895708358998e-19,   3.905069289753397e-21,
   2.794827372028347e-22,   5.071804029774826e-24,   1.750558753991669e+00,  -6.876624699047814e-03,  -1.168615263259952e-04,  -1.174110215875871e-06,   1.616328142987766e-09,
   3.302337628079886e-10,   6.463990986631090e-12,   3.670043145242497e-14,  -1.330164563396794e-15,  -4.277953211754827e-17,  -5.053565018404413e-19,   3.941281413358628e-21,
   2.795687113568604e-22,   5.055984903194345e-24,   1.750539425710534e+00,  -6.877205528879505e-03,  -1.168598367843945e-04,  -1.173562958359558e-06,   1.632298484346896e-09,
   3.303574894832627e-10,   6.457759479584423e-12,   3.644660193081375e-14,  -1.333835052446770e-15,  -4.274137507673597e-17,  -5.022980762037953e-19,   4.005083815347071e-21,
   2.797173001133100e-22,   5.028040906614502e-24,   1.750516053880693e+00,  -6.877907753443904e-03,  -1.168577867314449e-04,  -1.172901118734076e-06,   1.651603080540757e-09,
   3.305067089633752e-10,   6.450216759146172e-12,   3.613977136375582e-14,  -1.338263305492024e-15,  -4.269497814245087e-17,  -4.985991271000470e-19,   4.082073175808557e-21,
   2.798916704662007e-22,   4.994198296115191e-24,   1.750493365053676e+00,  -6.878589334097794e-03,  -1.168557892036860e-04,  -1.172258522198850e-06,   1.670336406633020e-09,
   3.306511580943882e-10,   6.442886557609197e-12,   3.584201357448744e-14,  -1.342551555665647e-15,  -4.264966798658784e-17,  -4.950075653075794e-19,   4.156644164575460e-21,
   2.800553973016988e-22,   4.961289894011121e-24,   1.750475087330775e+00,  -6.879138315751732e-03,  -1.168541747405482e-04,  -1.171740787484082e-06,   1.685422538762389e-09,
   3.307672303332862e-10,   6.436975819380409e-12,   3.560222141695623e-14,  -1.345998503388487e-15,  -4.261297435393699e-17,  -4.921137679061696e-19,   4.216596420878939e-21,
   2.801833221392843e-22,   4.934740433877219e-24,   1.750463009786659e+00,  -6.879501028559941e-03,  -1.168531053469341e-04,  -1.171398644697968e-06,   1.695388642862162e-09,
   3.308437848249695e-10,   6.433067358746015e-12,   3.544380915052001e-14,  -1.348272458254669e-15,  -4.258863376931501e-17,  -4.902013660468003e-19,   4.256152434969877e-21,
   2.802659098772144e-22,   4.917178079297202e-24,   1.750456807405212e+00,  -6.879687285182888e-03,  -1.168525553627670e-04,  -1.171222927838008e-06,   1.700505927386122e-09,
   3.308830546987365e-10,   6.431059327373866e-12,   3.536246868256669e-14,  -1.349439090275527e-15,  -4.257610463862910e-17,  -4.892191852376520e-19,   4.276447971065845e-21,
   2.803077222080262e-22,   4.908153130817550e-24,   1.750454648611995e+00,  -6.879752111315645e-03,  -1.168523638084879e-04,  -1.171161766357742e-06,   1.702286919845468e-09,
   3.308967158506302e-10,   6.430360278432679e-12,   3.533415927000679e-14,  -1.349844963731600e-15,  -4.257173913292181e-17,  -4.888773169907573e-19,   4.283509092923763e-21,
   2.803221798180348e-22,   4.905010987008564e-24,   1.750454306041358e+00,  -6.879762398226120e-03,  -1.168523334054210e-04,  -1.171152060796359e-06,   1.702569532872506e-09,
   3.308988833508435e-10,   6.430249342574430e-12,   3.532966704551097e-14,  -1.349909361547716e-15,  -4.257104616766634e-17,  -4.888230666770172e-19,   4.284629456822713e-21,
   2.803244695060203e-22,   4.904512328047977e-24,   1.949401003050418e+00,  -1.624042717062135e-03,  -3.780103614266150e-05,  -7.460402017821803e-07,  -1.291637439647890e-08,
  -1.942915270916699e-10,  -2.385993154563185e-12,  -1.833252444444622e-14,   1.249286714992843e-16,   9.241808113321026e-18,   2.472903191666439e-19,   4.795760424045012e-21,
   7.066100448481346e-23,   6.537430033957102e-25,   1.949397444586837e+00,  -1.624253183159566e-03,  -3.780832050264238e-05,  -7.462226484081801e-07,  -1.291972552169658e-08,
  -1.943271112459620e-10,  -2.385643339290555e-12,  -1.830068342464543e-14,   1.259859356527188e-16,   9.266715069933356e-18,   2.477262563128679e-19,   4.800382321448843e-21,
   7.063430904612189e-23,   6.508884436174523e-25,   1.949391165064309e+00,  -1.624624595674598e-03,  -3.782117540214107e-05,  -7.465446053196366e-07,  -1.292563822638485e-08,
  -1.943898487615624e-10,  -2.385023819890280e-12,  -1.824443097060553e-14,   1.278529889653391e-16,   9.310682999154796e-18,   2.484953334684172e-19,   4.808520581251826e-21,
   7.058661580738049e-23,   6.458381619520984e-25,   1.949383570847810e+00,  -1.625073782890440e-03,  -3.783672229553904e-05,  -7.469339650155900e-07,  -1.293278723380243e-08,
  -1.944656241163336e-10,  -2.384270826474216e-12,  -1.817629311289648e-14,   1.301131969728198e-16,   9.363882198255592e-18,   2.494250676773529e-19,   4.818332153783308e-21,
   7.052793979521321e-23,   6.397085058396441e-25,   1.949376197518156e+00,  -1.625509920665390e-03,  -3.785181768518324e-05,  -7.473119967617038e-07,  -1.293972663296591e-08,
  -1.945390937736422e-10,  -2.383535784436537e-12,  -1.811002371374694e-14,   1.323100347419161e-16,   9.415561249448435e-18,   2.503273814257490e-19,   4.827826308206725e-21,
   7.046992457167058e-23,   6.337340497430863e-25,   1.949370256946160e+00,  -1.625861321040542e-03,  -3.786398029402546e-05,  -7.476165686546270e-07,  -1.294531639554638e-08,
  -1.945982141711923e-10,  -2.382940741025802e-12,  -1.805655025459801e-14,   1.340816892381328e-16,   9.457217673074398e-18,   2.510540882994460e-19,   4.835452593943756e-21,
   7.042243246202179e-23,   6.289039768618628e-25,   1.949366331172627e+00,  -1.626093546323230e-03,  -3.787201808853554e-05,  -7.478178411859425e-07,  -1.294900975233244e-08,
  -1.946372476305154e-10,  -2.382546124710674e-12,  -1.802117299555925e-14,   1.352533023029002e-16,   9.484755450037162e-18,   2.515341917639880e-19,   4.840481076143777e-21,
   7.039068008964254e-23,   6.257039599611593e-25,   1.949364314992020e+00,  -1.626212813212576e-03,  -3.787614617725955e-05,  -7.479212094703104e-07,  -1.295090638760427e-08,
  -1.946572832013045e-10,  -2.382343030344566e-12,  -1.800299179490303e-14,   1.358552709052175e-16,   9.498901109269587e-18,   2.517807194125105e-19,   4.843060088372521e-21,
   7.037425908810175e-23,   6.240580023682804e-25,   1.949363613224693e+00,  -1.626254326434408e-03,  -3.787758304356981e-05,  -7.479571885773966e-07,  -1.295156651610588e-08,
  -1.946642551761275e-10,  -2.382272271425880e-12,  -1.799666154621631e-14,   1.360648376339439e-16,   9.503825223115086e-18,   2.518665210744491e-19,   4.843957202861464e-21,
   7.036852535038194e-23,   6.234846984226760e-25,   1.949363501863066e+00,  -1.626260914072166e-03,  -3.787781105670635e-05,  -7.479628980055346e-07,  -1.295167126880099e-08,
  -1.946653614570634e-10,  -2.382261039633490e-12,  -1.799565692250620e-14,   1.360980951734031e-16,   9.504606640055040e-18,   2.518801364005267e-19,   4.844099537201345e-21,
   7.036761461827396e-23,   6.233937033583875e-25,   9.321450074153326e-03,  -2.020455406594789e-04,   3.270717261521697e-06,  -4.687099804768421e-08,   6.251460498573330e-10,
  -7.956122310189143e-12,   9.724691487345626e-14,  -1.158390700501992e-15,   1.321813792157300e-17,  -1.510172939737797e-19,   1.601308319971450e-21,  -1.574893470420649e-23,
   2.422706363429443e-25,   1.591184897689822e-29,   9.321757410774052e-03,  -2.020587494463997e-04,   3.271069679961914e-06,  -4.687847614884584e-08,   6.252832152768264e-10,
  -7.958411032997961e-12,   9.728175308547927e-14,  -1.158902500367437e-15,   1.322494185097303e-17,  -1.510985202741032e-19,   1.602813412282754e-21,  -1.574938621669796e-23,
   2.424033739184353e-25,   5.610281159967806e-30,   9.322299738037991e-03,  -2.020820582723447e-04,   3.271691590678190e-06,  -4.689167312314438e-08,   6.255252857065019e-10,
  -7.962450340691583e-12,   9.734324020947886e-14,  -1.159805802188495e-15,   1.323695265911860e-17,  -1.512418478351986e-19,   1.605469821974487e-21,  -1.575024406427174e-23,
   2.426360378874819e-25,  -1.255985077961060e-29,   9.322955571935449e-03,  -2.021102464758749e-04,   3.272443718911580e-06,  -4.690763402494608e-08,   6.258180678822179e-10,
  -7.967336113623869e-12,   9.741761591470836e-14,  -1.160898464482365e-15,   1.325148506949157e-17,  -1.514151654512534e-19,   1.608683085019156e-21,  -1.575138561321768e-23,
   2.429147345999810e-25,  -3.451910344668823e-29,   9.323592292279874e-03,  -2.021376141563283e-04,   3.273173984204173e-06,  -4.692313171275968e-08,   6.261023670008424e-10,
  -7.972080602652284e-12,   9.748984456065078e-14,  -1.161959600147021e-15,   1.326560211255327e-17,  -1.515834240219236e-19,   1.611803614551426e-21,  -1.575260292026870e-23,
   2.431825283241247e-25,  -5.582382070562892e-29,   9.324105260411024e-03,  -2.021596633968217e-04,   3.273762356845977e-06,  -4.693561868483182e-08,   6.263314457347294e-10,
  -7.975903751373425e-12,   9.754804965336208e-14,  -1.162814722426991e-15,   1.327698123391878e-17,  -1.517189745561693e-19,   1.614318291329838e-21,  -1.575366171775224e-23,
   2.433962870938702e-25,  -7.297727751160072e-29,   9.324444237508221e-03,  -2.021742342160122e-04,   3.274151182386035e-06,  -4.694387094864390e-08,   6.264828418862447e-10,
  -7.978430534167887e-12,   9.758651966860738e-14,  -1.163379911634057e-15,   1.328450359405675e-17,  -1.518085457695193e-19,   1.615980343917784e-21,  -1.575439960601576e-23,
   2.435365714988085e-25,  -8.430737128137788e-29,   9.324618323692078e-03,  -2.021817173609790e-04,   3.274350875085028e-06,  -4.694810921967530e-08,   6.265605987880188e-10,
  -7.979728317083223e-12,   9.760627868531304e-14,  -1.163670206519983e-15,   1.328836768786457e-17,  -1.518545454544782e-19,   1.616834010424340e-21,  -1.575479037493088e-23,
   2.436083167128965e-25,  -9.012448634404978e-29,   9.324678916814450e-03,  -2.021843219909898e-04,   3.274420381896731e-06,  -4.694958444264635e-08,   6.265876640210887e-10,
  -7.980180047634024e-12,   9.761315644152720e-14,  -1.163771253188589e-15,   1.328971278062192e-17,  -1.518705561597963e-19,   1.617131156411228e-21,  -1.575492826845283e-23,
   2.436332409634832e-25,  -9.214895827877813e-29,   9.324688532147959e-03,  -2.021847353124112e-04,   3.274431411762541e-06,  -4.694981854277483e-08,   6.265919589592850e-10,
  -7.980251732253269e-12,   9.761424786805673e-14,  -1.163787288229644e-15,   1.328992623589079e-17,  -1.518730968427006e-19,   1.617178310313954e-21,  -1.575495023963518e-23,
   2.436371938527848e-25,  -9.247020324732904e-29,   8.365370574318252e-02,  -1.771388943299010e-03,   2.719645143428314e-05,  -3.537113532328348e-07,   4.005519226208740e-09,
  -3.886707763278081e-11,   2.901492592573854e-13,  -9.690972271968538e-16,  -2.092947834360079e-17,   5.414207505531962e-19,  -9.269012786378304e-21,   1.251518214860915e-22,
  -4.511277066841687e-25,   2.191995561495709e-26,   8.365625993314552e-02,  -1.771488552826958e-03,   2.719870683348123e-05,  -3.537478068117103e-07,   4.005926587252965e-09,
  -3.886895616514380e-11,   2.900935097732365e-13,  -9.672529341898053e-16,  -2.096867103042074e-17,   5.420720470672945e-19,  -9.271786956515146e-21,   1.253064854494678e-22,
  -4.507390810430757e-25,   2.181799246642824e-26,   8.366076701376379e-02,  -1.771664323746814e-03,   2.720268670704373e-05,  -3.538121311488186e-07,   4.006645318178471e-09,
  -3.887226790473458e-11,   2.899950552334483e-13,  -9.639968586516344e-16,  -2.103783664439732e-17,   5.432219126251871e-19,  -9.276680204086567e-21,   1.255787864337754e-22,
  -4.500656446525798e-25,   2.163808858062501e-26,   8.366621731750901e-02,  -1.771876882043079e-03,   2.720749953013899e-05,  -3.538899152505216e-07,   4.007514306024494e-09,
  -3.887626744607940e-11,   2.898758602260934e-13,  -9.600565214407023e-16,  -2.112148864062455e-17,   5.446134363124761e-19,  -9.282594111335356e-21,   1.259070224450019e-22,
  -4.492722308459093e-25,   2.142056752142277e-26,   8.367150868561860e-02,  -1.772083244851095e-03,   2.721217206790607e-05,  -3.539654292485210e-07,   4.008357789874816e-09,
  -3.888014484123076e-11,   2.897599982973196e-13,  -9.562281086642785e-16,  -2.120271350654024e-17,   5.459654467946680e-19,  -9.288332079238363e-21,   1.262245863442573e-22,
  -4.485238224242604e-25,   2.120942435277245e-26,   8.367577156334512e-02,  -1.772249498716899e-03,   2.721593644172528e-05,  -3.540262641607448e-07,   4.009037207391860e-09,
  -3.888326462804971e-11,   2.896665543205866e-13,  -9.531416940902462e-16,  -2.126815934757891e-17,   5.470554265158161e-19,  -9.292952291601969e-21,   1.264796365362862e-22,
  -4.479364979114065e-25,   2.103934691930306e-26,   8.367858850491887e-02,  -1.772359361534780e-03,   2.721842398948688e-05,  -3.540664636763286e-07,   4.009486114159861e-09,
  -3.888532427008095e-11,   2.896047557546635e-13,  -9.511011221805098e-16,  -2.131141073872370e-17,   5.477760654143045e-19,  -9.296004173835154e-21,   1.266477896435028e-22,
  -4.475560130104485e-25,   2.092697123911614e-26,   8.368003517257644e-02,  -1.772415782964423e-03,   2.721970150034590e-05,  -3.540871083259684e-07,   4.009716636819953e-09,
  -3.888638142020597e-11,   2.895730030121566e-13,  -9.500528431232993e-16,  -2.133362423590499e-17,   5.481462714512474e-19,  -9.297571133153757e-21,   1.267340269454812e-22,
  -4.473629642908916e-25,   2.086926361993970e-26,   8.368053870381605e-02,  -1.772435421216960e-03,   2.722014615543992e-05,  -3.540942939290890e-07,   4.009796870361199e-09,
  -3.888674927949608e-11,   2.895619485966917e-13,  -9.496879246280764e-16,  -2.134135613966110e-17,   5.482751446990516e-19,  -9.298116475725663e-21,   1.267640239440006e-22,
  -4.472961453912150e-25,   2.084917838440270e-26,   8.368061860754127e-02,  -1.772438537549388e-03,   2.722021671635196e-05,  -3.540954341874195e-07,   4.009809602225115e-09,
  -3.888680764935548e-11,   2.895601942905925e-13,  -9.496300144598884e-16,  -2.134258310019352e-17,   5.482955960410425e-19,  -9.298203011619909e-21,   1.267687831675493e-22,
  -4.472855598739485e-25,   2.084599115464165e-26,   2.309116113306522e-01,  -4.650418531578988e-03,   6.324534319633282e-05,  -6.350699665114770e-07,   3.775635747873387e-09,
   1.584952182520917e-11,  -8.574048133663917e-13,   1.376298077467519e-14,  -1.310270829959970e-16,   9.457839508968954e-20,   1.973525777250750e-20,  -4.120323998411560e-22,
   7.233586096949228e-24,   1.935868229294380e-26,   2.309175448194616e-01,  -4.650597091466277e-03,   6.324746015635693e-05,  -6.350548797607410e-07,   3.774425980724851e-09,
   1.587662171557150e-11,  -8.577470053326218e-13,   1.376324475260760e-14,  -1.309423927851593e-16,   9.245914736798171e-20,   1.977983180944685e-20,  -4.118956855312346e-22,
   7.229715063406428e-24,   1.927037168558031e-26,   2.309280147145046e-01,  -4.650912159711884e-03,   6.325119501148323e-05,  -6.350282382948258e-07,   3.772290936995718e-09,
   1.592444029448646e-11,  -8.583506268408017e-13,   1.376370473472482e-14,  -1.307928028553284e-16,   8.872026953827366e-20,   1.985846322266606e-20,  -4.116549714127557e-22,
   7.222820771466145e-24,   1.911488455824147e-26,   2.309406752974270e-01,  -4.651293137656163e-03,   6.325571029323142e-05,  -6.349959879276560e-07,   3.769708553505097e-09,
   1.598226369995638e-11,  -8.590802225526866e-13,   1.376425104267237e-14,  -1.306116567611064e-16,   8.420014571380689e-20,   1.995351054687075e-20,  -4.113647833181729e-22,
   7.214375523790315e-24,   1.892744651834444e-26,   2.309529662590371e-01,  -4.651662978220454e-03,   6.326009266086832e-05,  -6.349646429451464e-07,   3.767200923274719e-09,
   1.603839835343806e-11,  -8.597881766680799e-13,   1.376477101545039e-14,  -1.304355306916103e-16,   7.981309869031466e-20,   2.004574431056987e-20,  -4.110839997596918e-22,
   7.206063525879970e-24,   1.874609313678835e-26,   2.309628679033860e-01,  -4.651960912503376e-03,   6.326362233000299e-05,  -6.349393654071957e-07,   3.765180309673639e-09,
   1.608362019065088e-11,  -8.603582623980734e-13,   1.376518246711819e-14,  -1.302934505639745e-16,   7.627967366060690e-20,   2.012002025884375e-20,  -4.108584664097445e-22,
   7.199286324984151e-24,   1.860043458806181e-26,   2.309694108341963e-01,  -4.652157779982180e-03,   6.326595432518028e-05,  -6.349226495206590e-07,   3.763844879784033e-09,
   1.611350221287677e-11,  -8.607348507784053e-13,   1.376545070870565e-14,  -1.301994709617360e-16,   7.394520280874773e-20,   2.016908749056902e-20,  -4.107097617281904e-22,
   7.194768394970150e-24,   1.850440080381355e-26,   2.309727709733493e-01,  -4.652258880175451e-03,   6.326715180886804e-05,  -6.349140611113406e-07,   3.763158997060285e-09,
   1.612884813413967e-11,  -8.609282116226307e-13,   1.376558733848562e-14,  -1.301511783825054e-16,   7.274644952281724e-20,   2.019428182718077e-20,  -4.106334947694290e-22,
   7.192435964945103e-24,   1.845514942204809e-26,   2.309739405055060e-01,  -4.652294068915788e-03,   6.326756858692990e-05,  -6.349110711997407e-07,   3.762920257266112e-09,
   1.613418943415435e-11,  -8.609955070125642e-13,   1.376563471461997e-14,  -1.301343650029240e-16,   7.232922983789261e-20,   2.020305030293885e-20,  -4.106069652681258e-22,
   7.191622191219259e-24,   1.843801763633257e-26,   2.309741260943873e-01,  -4.652299652879134e-03,   6.326763472305647e-05,  -6.349105967117031e-07,   3.762882371977623e-09,
   1.613503702545417e-11,  -8.610061855971825e-13,   1.376564222405714e-14,  -1.301316967277811e-16,   7.226302364454078e-20,   2.020444170868551e-20,  -4.106027561568444e-22,
   7.191492963983294e-24,   1.843529956175755e-26,   4.475984385545046e-01,  -8.278612708690606e-03,   8.900822961983275e-05,  -3.963887043580792e-07,  -6.172993887408627e-09,
   1.553431008480705e-10,  -1.364192765815224e-12,  -7.948321081338212e-15,   4.005825193357660e-16,  -5.377400296085562e-18,   8.667993574599406e-22,   1.213807832546620e-21,
  -1.702778833325857e-23,   2.030159456782345e-25,   4.476067760673844e-01,  -8.278723680327634e-03,   8.900474656589185e-05,  -3.962432047379332e-07,  -6.174899844515730e-09,
   1.553271669345941e-10,  -1.363141242296817e-12,  -7.966304986383889e-15,   4.005828393302263e-16,  -5.371087137490543e-18,   7.628081356325644e-22,   1.215219267750935e-21,
  -1.699819579387671e-23,   2.016894644746122e-25,   4.476214874734915e-01,  -8.278919458283822e-03,   8.899859979363431e-05,  -3.959864805979319e-07,  -6.178261733679142e-09,
   1.552990225894199e-10,  -1.361285813815862e-12,  -7.998020507844315e-15,   4.005830484910464e-16,  -5.359941627712889e-18,   5.794623232128810e-22,   1.217701894784834e-21,
  -1.694602704631435e-23,   1.993498568592030e-25,   4.476392762084377e-01,  -8.279156138399911e-03,   8.899116556997088e-05,  -3.956760678907246e-07,  -6.182324916236591e-09,
   1.552649412225736e-10,  -1.359042212623226e-12,  -8.036341640874205e-15,   4.005826956446953e-16,  -5.346454419482548e-18,   3.580113670126243e-22,   1.220690494597828e-21,
  -1.688302528003496e-23,   1.965224744461695e-25,   4.476565447283939e-01,  -8.279385844007087e-03,   8.898394700394267e-05,  -3.953747464773687e-07,  -6.186267237066311e-09,
   1.552318044132320e-10,  -1.356864166963883e-12,  -8.073512107715641e-15,   4.005817191989192e-16,  -5.333350892271180e-18,   1.432950907421767e-22,   1.223577728228765e-21,
  -1.682194909682373e-23,   1.937794884280383e-25,   4.476704556824091e-01,  -8.279570849332894e-03,   8.897813071051744e-05,  -3.951320215481244e-07,  -6.189441581528490e-09,
   1.552050731570927e-10,  -1.355109564708121e-12,  -8.103433912812150e-15,   4.005804787059634e-16,  -5.322787444992082e-18,  -2.948819761149506e-23,   1.225893584944110e-21,
  -1.677280754191699e-23,   1.915710638301603e-25,   4.476796476259852e-01,  -8.279693076736224e-03,   8.897428686383778e-05,  -3.949716409229807e-07,  -6.191538378790050e-09,
   1.551873916698582e-10,  -1.353950156452722e-12,  -8.123194815549020e-15,   4.005794369041969e-16,  -5.315803684253827e-18,  -1.435676640436461e-22,   1.227418937105451e-21,
  -1.674036529485631e-23,   1.901124107815012e-25,   4.476843680771732e-01,  -8.279755839917509e-03,   8.897231269656287e-05,  -3.948892801755738e-07,  -6.192614951636832e-09,
   1.551783058306008e-10,  -1.353354745390747e-12,  -8.133339615020540e-15,   4.005788332276277e-16,  -5.312216070267202e-18,  -2.021242874867174e-22,   1.228200755738503e-21,
  -1.672371379394581e-23,   1.893635196054671e-25,   4.476860110652137e-01,  -8.279777684192488e-03,   8.897162554280743e-05,  -3.948606141418117e-07,  -6.192989625601098e-09,
   1.551751425376798e-10,  -1.353147507209591e-12,  -8.136870068859179e-15,   4.005786121838533e-16,  -5.310967190423733e-18,  -2.225008979413373e-22,   1.228472632488261e-21,
  -1.671791954125098e-23,   1.891028925924676e-25,   4.476862717843977e-01,  -8.279781150529422e-03,   8.897151649969992e-05,  -3.948560652550248e-07,  -6.193049079439106e-09,
   1.551746405247254e-10,  -1.353114621368794e-12,  -8.137430277789240e-15,   4.005785765884817e-16,  -5.310769001948135e-18,  -2.257341690009241e-22,   1.228515764077862e-21,
  -1.671700014218158e-23,   1.890615361677522e-25,   7.264692472198431e-01,  -1.172518390441233e-02,   7.654586792888158e-05,   6.006946745997955e-07,  -1.781113131238384e-08,
   6.925182849197620e-11,   3.017093202673967e-12,  -5.079301896619978e-14,  -1.595065772907278e-16,   1.449019022579428e-17,  -1.418360757545070e-19,  -2.188184167983154e-21,
   7.453381978943556e-23,  -1.211281906858037e-26,   7.264764033174358e-01,  -1.172501473380327e-02,   7.653587310451384e-05,   6.007587645590106e-07,  -1.780689364563098e-08,
   6.915260248025471e-11,   3.016662486455170e-12,  -5.074440876489729e-14,  -1.600903531978661e-16,   1.447890816828650e-17,  -1.413812064969707e-19,  -2.188179467287213e-21,
   7.439782202227812e-23,  -1.040750675546536e-26,   7.264890296054630e-01,  -1.172471621508777e-02,   7.651823901614967e-05,   6.008717769106649e-07,  -1.779941671300715e-08,
   6.897759427954426e-11,   3.015901243879275e-12,  -5.065866625449185e-14,  -1.611188803988645e-16,   1.445900091460340e-17,  -1.405792676476319e-19,  -2.188161173299182e-21,
   7.415776128018100e-23,  -7.408758748759289e-27,   7.265042961542177e-01,  -1.172435521833078e-02,   7.649691898976740e-05,   6.010083041486550e-07,  -1.779037637462533e-08,
   6.876610487270946e-11,   3.014978634246854e-12,  -5.055503827447386e-14,  -1.623599374175494e-16,   1.443492907408582e-17,  -1.396107230988948e-19,  -2.188122043680984e-21,
   7.386732417879152e-23,  -3.800175185641123e-27,   7.265191153009342e-01,  -1.172400474303888e-02,   7.647622533448884e-05,   6.011407079103334e-07,  -1.778160106031147e-08,
   6.856093320048315e-11,   3.014080777272105e-12,  -5.045449329518564e-14,  -1.635619620724911e-16,   1.441156081815882e-17,  -1.386717008191659e-19,  -2.188066299520758e-21,
   7.358521420704984e-23,  -3.153461121374534e-28,   7.265310524423769e-01,  -1.172372238616252e-02,   7.645955727189200e-05,   6.012472743138518e-07,  -1.777453241954744e-08,
   6.839574883320351e-11,   3.013355898596000e-12,  -5.037353516774957e-14,  -1.645283128125709e-16,   1.439273587417451e-17,  -1.379161139457301e-19,  -2.188008706760918e-21,
   7.335783756327608e-23,   2.478888282819409e-27,   7.265389398176766e-01,  -1.172353580069567e-02,   7.644854452579682e-05,   6.013176443364843e-07,  -1.776986190054426e-08,
   6.828664653576930e-11,   3.012876140471662e-12,  -5.032005886858110e-14,  -1.651658889949649e-16,   1.438029680410491e-17,  -1.374172652398609e-19,  -2.187964454176565e-21,
   7.320753650301569e-23,   4.318866718630506e-27,   7.265429902153648e-01,  -1.172343997732567e-02,   7.644288932877445e-05,   6.013537681291460e-07,  -1.776746346239846e-08,
   6.823063230990485e-11,   3.012629523391006e-12,  -5.029260222647505e-14,  -1.654930146524509e-16,   1.437390878498263e-17,  -1.371612154534068e-19,  -2.187939815300846e-21,
   7.313033292332816e-23,   5.261806304309175e-27,   7.265443999699827e-01,  -1.172340662467774e-02,   7.644092104536757e-05,   6.013663390249505e-07,  -1.776662867946100e-08,
   6.821113843727271e-11,   3.012543648131038e-12,  -5.028304664536014e-14,  -1.656068259490865e-16,   1.437168538275869e-17,  -1.370721161391889e-19,  -2.187930935238999e-21,
   7.310345884569892e-23,   5.589690479252509e-27,   7.265446236775146e-01,  -1.172340133205066e-02,   7.644060870873295e-05,   6.013683337428035e-07,  -1.776649621163799e-08,
   6.820804514169452e-11,   3.012530019109791e-12,  -5.028153035155731e-14,  -1.656248839661801e-16,   1.437133255975147e-17,  -1.370579783096371e-19,  -2.187929511656299e-21,
   7.309919417337161e-23,   5.641706252251981e-27,   1.053248078636138e+00,  -1.365628824328706e-02,   7.861563073463977e-06,   1.681358620678060e-06,  -6.027292107247534e-09,
  -3.604669656472930e-10,   2.751398906260344e-12,   8.785297387338723e-14,  -1.168019358257394e-15,  -2.265447254724908e-17,   4.520731676899648e-19,   5.429008550797522e-21,
  -1.644290003690821e-22,  -6.744943816389931e-25,   1.053248808894221e+00,  -1.365581654702836e-02,   7.858194347128319e-06,   1.681022126461776e-06,  -6.023458701995568e-09,
  -3.602952084818343e-10,   2.748371498394275e-12,   8.777723908244309e-14,  -1.166143915902605e-15,  -2.262667311063203e-17,   4.510820242663878e-19,   5.424033500922973e-21,
  -1.638590671292747e-22,  -6.752774705744781e-25,   1.053250097191927e+00,  -1.365498430823803e-02,   7.852251921094989e-06,   1.680428507656163e-06,  -6.016698044050589e-09,
  -3.599922611215833e-10,   2.743033572771138e-12,   8.764367998619144e-14,  -1.162838044806162e-15,  -2.257764146584593e-17,   4.493359785952856e-19,   5.415250357406476e-21,
  -1.628556310125637e-22,  -6.766543473930127e-25,   1.053251654581985e+00,  -1.365397808692388e-02,   7.845069249626651e-06,   1.679710919959930e-06,  -6.008528856716748e-09,
  -3.596261399301019e-10,   2.736585682820538e-12,   8.748230867512560e-14,  -1.158846300628019e-15,  -2.251838752376654e-17,   4.472294805897903e-19,   5.404621880348198e-21,
  -1.616460442406794e-22,  -6.783109479049311e-25,   1.053253166015669e+00,  -1.365300140155580e-02,   7.838099549035140e-06,   1.679014531171743e-06,  -6.000604496711750e-09,
  -3.592709314228849e-10,   2.730333283621026e-12,   8.732578804873460e-14,  -1.154977197850362e-15,  -2.246090216798246e-17,   4.451895865232060e-19,   5.394295789623884e-21,
  -1.604757473239591e-22,  -6.799104383055525e-25,   1.053254383282048e+00,  -1.365221469457009e-02,   7.832487078032639e-06,   1.678453696254046e-06,  -5.994225135888676e-09,
  -3.589849344760977e-10,   2.725301515387482e-12,   8.719979436753915e-14,  -1.151864601568568e-15,  -2.241461948255761e-17,   4.435498914115411e-19,   5.385971404153435e-21,
  -1.595357949758146e-22,  -6.811927400166379e-25,   1.053255187470921e+00,  -1.365169490060681e-02,   7.828779548241114e-06,   1.678083188194754e-06,  -5.990011921397895e-09,
  -3.587960283601628e-10,   2.721979099692493e-12,   8.711658761383852e-14,  -1.149809957658339e-15,  -2.238404982036061e-17,   4.424681783285166e-19,   5.380467955548961e-21,
  -1.589160713927694e-22,  -6.820370184123036e-25,   1.053255600411199e+00,  -1.365142797637774e-02,   7.826875891633148e-06,   1.677892939828445e-06,  -5.987848899910872e-09,
  -3.586990393955895e-10,   2.720273649046077e-12,   8.707387169035382e-14,  -1.148755449950641e-15,  -2.236835489207846e-17,   4.419132131597404e-19,   5.377640793669640e-21,
  -1.585982400166909e-22,  -6.824696555589051e-25,   1.053255744131015e+00,  -1.365133507331817e-02,   7.826213360214996e-06,   1.677826726161758e-06,  -5.987096146440747e-09,
  -3.586652852174037e-10,   2.719680173688411e-12,   8.705900636610652e-14,  -1.148388522361458e-15,  -2.236289277436383e-17,   4.417201393633223e-19,   5.376656634493482e-21,
  -1.584876837246769e-22,  -6.826200892948956e-25,   1.053255766936999e+00,  -1.365132033099426e-02,   7.826108228152517e-06,   1.677816219155573e-06,  -5.986976699862294e-09,
  -3.586599290707439e-10,   2.719586003130677e-12,   8.705664755515390e-14,  -1.148330300917862e-15,  -2.236202604216830e-17,   4.416895053358693e-19,   5.376500455362070e-21,
  -1.584701431829126e-22,  -6.826439539576723e-25,   1.400810716731137e+00,  -1.257140631564386e-02,  -9.218866113260109e-05,   1.146817217703716e-06,   2.751262984005021e-08,
  -1.077257623571529e-10,  -8.856065248265361e-12,  -3.003674920256442e-14,   2.746388603590859e-15,   2.992241272563832e-17,  -8.041451419754803e-19,  -1.740759426777887e-20,
   1.922495463224538e-22,   8.914540348250649e-24,   1.400802104986187e+00,  -1.257108413146741e-02,  -9.217325508427189e-05,   1.146715742514016e-06,   2.750026035341333e-08,
  -1.077833318529661e-10,  -8.848925150218971e-12,  -2.993802746175599e-14,   2.743034371232951e-15,   2.983510675157466e-17,  -8.029555570844814e-19,  -1.734428943040179e-20,
   1.922541738893972e-22,   8.880271636095563e-24,   1.400786910592444e+00,  -1.257051565569733e-02,  -9.214607650613394e-05,   1.146536644544176e-06,   2.747844233533040e-08,
  -1.078847572336048e-10,  -8.836333469881926e-12,  -2.976406915600596e-14,   2.737119855411171e-15,   2.968131743962569e-17,  -8.008565204780536e-19,  -1.723278937274624e-20,
   1.922598030714062e-22,   8.819908236311958e-24,   1.400768539356508e+00,  -1.256982828841936e-02,  -9.211322148722407e-05,   1.146320003444022e-06,   2.745207362118890e-08,
  -1.080071346184593e-10,  -8.821119635272579e-12,  -2.955412182011005e-14,   2.729974916274163e-15,   2.949580239068241e-17,  -7.983183595715118e-19,  -1.709830686739659e-20,
   1.922622984853402e-22,   8.747093791779568e-24,   1.400750706959400e+00,  -1.256916104574309e-02,  -9.208133646192409e-05,   1.146109614707897e-06,   2.742648984363487e-08,
  -1.081256569141134e-10,  -8.806363033988858e-12,  -2.935073196609582e-14,   2.723046017834131e-15,   2.931617665587146e-17,  -7.958543852937304e-19,  -1.696811385480193e-20,
   1.922602226806044e-22,   8.676592557751480e-24,   1.400736342902763e+00,  -1.256862355351717e-02,  -9.205565750466708e-05,   1.145940072961462e-06,   2.740589027913875e-08,
  -1.082209368693767e-10,  -8.794484420667345e-12,  -2.918718665650374e-14,   2.717469406824766e-15,   2.917180806259413e-17,  -7.938694677567500e-19,  -1.686348981312918e-20,
   1.922553390949831e-22,   8.619930615574835e-24,   1.400726852119740e+00,  -1.256826840282105e-02,  -9.203869283374478e-05,   1.145828015740646e-06,   2.739228354104174e-08,
  -1.082837983032659e-10,  -8.786639704282224e-12,  -2.907926696463794e-14,   2.713787037174313e-15,   2.907657595887874e-17,  -7.925578864888138e-19,  -1.679448216115477e-20,
   1.922505444541880e-22,   8.582554434652102e-24,   1.400721978374190e+00,  -1.256808602045839e-02,  -9.202998175392731e-05,   1.145770460635265e-06,   2.738529740278913e-08,
  -1.083160504122641e-10,  -8.782612445800688e-12,  -2.902389081329870e-14,   2.711896754488073e-15,   2.902772041892764e-17,  -7.918843326357368e-19,  -1.675908237973614e-20,
   1.922475983664237e-22,   8.563380071346759e-24,   1.400720282058340e+00,  -1.256802254132540e-02,  -9.202694995640380e-05,   1.145750426723279e-06,   2.738286606374976e-08,
  -1.083272712408718e-10,  -8.781210941061577e-12,  -2.900462392064044e-14,   2.711238950108509e-15,   2.901072386869835e-17,  -7.916498970449037e-19,  -1.674676735958194e-20,
   1.922464960193773e-22,   8.556709456313984e-24,   1.400720012878082e+00,  -1.256801246809536e-02,  -9.202646886013152e-05,   1.145747247554207e-06,   2.738248025561365e-08,
  -1.083290516033695e-10,  -8.780988551978790e-12,  -2.900156687584763e-14,   2.711134571585985e-15,   2.900802713318471e-17,  -7.916126953938143e-19,  -1.674481342966705e-20,
   1.922463174415624e-22,   8.555651073357389e-24,   1.721106819804160e+00,  -7.866572370983005e-03,  -1.305552923307841e-04,  -1.087199274482871e-06,   9.814983482008972e-09,
   4.914108917903536e-10,   6.647904309530525e-12,  -3.361167301901741e-14,  -3.149798346184660e-15,  -5.477464847677679e-17,   4.994644853362079e-20,   2.320523462601446e-20,
   4.960126817100103e-22,   1.594842646095546e-24,   1.721094591458380e+00,  -7.866876524640503e-03,  -1.305497192484956e-04,  -1.086739161135808e-06,   9.824234389341369e-09,
   4.913418352419611e-10,   6.639642736189395e-12,  -3.379340745624156e-14,  -3.149491411975331e-15,  -5.465464326980517e-17,   5.294940523480837e-20,   2.321466560435256e-20,
   4.945882306824036e-22,   1.554232497856641e-24,   1.721073014780529e+00,  -7.867413103456459e-03,  -1.305398812494175e-04,  -1.085927337404533e-06,   9.840548318497099e-09,
   4.912196945326459e-10,   6.625065773072594e-12,  -3.411375120195222e-14,  -3.148939580221966e-15,  -5.444285493406351e-17,   5.824098596411717e-20,   2.323106689771294e-20,
   4.920731195316340e-22,   1.482694804480612e-24,   1.721046924765639e+00,  -7.868061761102434e-03,  -1.305279778642832e-04,  -1.084945762860380e-06,   9.860259196520480e-09,
   4.910715076889083e-10,   6.607440384176182e-12,  -3.450055234249652e-14,  -3.148254853637359e-15,  -5.418669536986610e-17,   6.462736771959239e-20,   2.325049109848779e-20,
   4.890290360805715e-22,   1.396394720839796e-24,   1.721021597800242e+00,  -7.868691279080504e-03,  -1.305164147578520e-04,  -1.083992963173649e-06,   9.879377317326208e-09,
   4.909271346698846e-10,   6.590331269470246e-12,  -3.487546365154094e-14,  -3.147571885494011e-15,  -5.393795516218095e-17,   7.081431706310563e-20,   2.326892070828905e-20,
   4.860710031620324e-22,   1.312830053420023e-24,   1.721001195277770e+00,  -7.869198276144178e-03,  -1.305070942941798e-04,  -1.083225468976080e-06,   9.894766548402181e-09,
   4.908104604021814e-10,   6.576549339538519e-12,  -3.517706557838214e-14,  -3.147008636233822e-15,  -5.373752737445993e-17,   7.578923859718424e-20,   2.328346180951878e-20,
   4.836859984896104e-22,   1.245664935337402e-24,   1.720987713924477e+00,  -7.869533224953321e-03,  -1.305009328669054e-04,  -1.082718356242682e-06,   9.904929564455024e-09,
   4.907331834655749e-10,   6.567442956487759e-12,  -3.537615223590213e-14,  -3.146630063263587e-15,  -5.360506603189806e-17,   7.907206942499435e-20,   2.329292088119045e-20,
   4.821090326917771e-22,   1.201358651381269e-24,   1.720980790688049e+00,  -7.869705216839161e-03,  -1.304977678657796e-04,  -1.082457940041799e-06,   9.910146930664242e-09,
   4.906934422185823e-10,   6.562766539795673e-12,  -3.547832888633476e-14,  -3.146433673724089e-15,  -5.353703397223892e-17,   8.075656535666622e-20,   2.329773239271337e-20,
   4.812988784889852e-22,   1.178628536195642e-24,   1.720978381005511e+00,  -7.869765076949697e-03,  -1.304966661286784e-04,  -1.082367301463294e-06,   9.911962591606768e-09,
   4.906796010259196e-10,   6.561138893602504e-12,  -3.551388223592532e-14,  -3.146365004366834e-15,  -5.351335370945782e-17,   8.134264750431741e-20,   2.329939973571332e-20,
   4.810168481956138e-22,   1.170720819346713e-24,   1.720977998622711e+00,  -7.869774575771002e-03,  -1.304964912920276e-04,  -1.082352918448246e-06,   9.912250698171084e-09,
   4.906774041973899e-10,   6.560880609683849e-12,  -3.551952358007746e-14,  -3.146354092572793e-15,  -5.350959592664218e-17,   8.143564012551624e-20,   2.329966397133572e-20,
   4.809720915629522e-22,   1.169466149644700e-24,   1.942237940838664e+00,  -1.966090544455169e-03,  -4.813224853822379e-05,  -9.870618739823152e-07,  -1.741249735878648e-08,
  -2.568762840603098e-10,  -2.777003943315697e-12,  -6.625326278580067e-15,   6.964445893508663e-16,   2.446006065972968e-17,   5.430925875035653e-19,   8.805381495014595e-21,
   8.847556212260723e-23,  -3.108774578026955e-25,   1.942233408742795e+00,  -1.966369003675839e-03,  -4.814206495415589e-05,  -9.873027921446934e-07,  -1.741638025437131e-08,
  -2.568879931251574e-10,  -2.775128058630452e-12,  -6.541593700494877e-15,   6.987527360524533e-16,   2.450534665444788e-17,   5.436232859789005e-19,   8.802481319430645e-21,
   8.811662613468111e-23,  -3.221995326101273e-25,   1.942225411037409e+00,  -1.966860404462850e-03,  -4.815938794519043e-05,  -9.877279045509249e-07,  -1.742322952134421e-08,
  -2.569085193508749e-10,  -2.771813094391464e-12,  -6.393722075384374e-15,   7.028273027029333e-16,   2.458524170384053e-17,   5.445578881066431e-19,   8.797296244793820e-21,
   8.748164349975026e-23,  -3.422041072001766e-25,   1.942215738846118e+00,  -1.967454705515877e-03,  -4.818033810953459e-05,  -9.882419694691847e-07,  -1.743150803555026e-08,
  -2.569331102362634e-10,  -2.767796184956799e-12,  -6.214702424468959e-15,   7.077573864238154e-16,   2.468182963009725e-17,   5.456849038224656e-19,   8.790910907568186e-21,
   8.671102809766593e-23,  -3.664391567914365e-25,   1.942206347909207e+00,  -1.968031741097916e-03,  -4.820067932650048e-05,  -9.887410298399422e-07,  -1.743954080204485e-08,
  -2.569567419853921e-10,  -2.763887818899422e-12,  -6.040691585906667e-15,   7.125466401175449e-16,   2.477557220784981e-17,   5.467757218089619e-19,   8.784591055470260e-21,
   8.596000787364031e-23,  -3.900135101462922e-25,   1.942198781731626e+00,  -1.968496663968346e-03,  -4.821706820992668e-05,  -9.891430771019862e-07,  -1.744600911665886e-08,
  -2.569756068630514e-10,  -2.760732968236936e-12,  -5.900351921045155e-15,   7.164070993702247e-16,   2.485107313296577e-17,   5.476521230343603e-19,   8.779413016374515e-21,
   8.535290280713498e-23,  -4.090386157618865e-25,   1.942193781665737e+00,  -1.968803911242707e-03,  -4.822789880019240e-05,  -9.894087479924440e-07,  -1.745028190232776e-08,
  -2.569879879026332e-10,  -2.758645202852239e-12,  -5.807540228879760e-15,   7.189591460350414e-16,   2.490095446521429e-17,   5.482300818762145e-19,   8.775948897953984e-21,
   8.495071356371628e-23,  -4.216266554618258e-25,   1.942191213747136e+00,  -1.968961708096262e-03,  -4.823346116914185e-05,  -9.895451843160361e-07,  -1.745247576088877e-08,
  -2.569943200049519e-10,  -2.757572077679238e-12,  -5.759852943709847e-15,   7.202700913687630e-16,   2.492656832354669e-17,   5.485265348548078e-19,   8.774156736233485e-21,
   8.474385308549169e-23,  -4.280963430018812e-25,   1.942190319936382e+00,  -1.969016632435991e-03,  -4.823539725713469e-05,  -9.895926724836487e-07,  -1.745323928634942e-08,
  -2.569965197864753e-10,  -2.757198414141966e-12,  -5.743251120316504e-15,   7.207264331518924e-16,   2.493548304742590e-17,   5.486296612281624e-19,   8.773530860326528e-21,
   8.467180292056662e-23,  -4.303489928931606e-25,   1.942190178099825e+00,  -1.969025348252970e-03,  -4.823570449022406e-05,  -9.896002082139617e-07,  -1.745336044413847e-08,
  -2.569968686637774e-10,  -2.757139111645056e-12,  -5.740616457907552e-15,   7.207988509305357e-16,   2.493689767164502e-17,   5.486460232660334e-19,   8.773431442844493e-21,
   8.466036715507833e-23,  -4.307064961339533e-25,   8.562262278834406e-03,  -1.779708916466643e-04,   2.763410841884846e-06,  -3.802505903782203e-08,   4.869628492303188e-10,
  -5.968230077390080e-12,   6.999769044104331e-14,  -8.111840980980512e-16,   8.798724779340459e-18,  -9.738893895594816e-20,   1.164936986213439e-21,  -4.158077996325134e-24,
   2.286741520692003e-25,  -1.416533926419907e-27,   8.562521899096037e-03,  -1.779816059321340e-04,   2.763685315276272e-06,  -3.803066771911606e-08,   4.870615578010997e-10,
  -5.969832331534098e-12,   7.002088959978444e-14,  -8.115133573430204e-16,   8.803683745726015e-18,  -9.741082193146460e-20,   1.166322404848385e-21,  -4.169323899849646e-24,
   2.280363925808861e-25,  -1.432730999084942e-27,   8.562980024125571e-03,  -1.780005127424972e-04,   2.764169673106320e-06,  -3.804056554848172e-08,   4.872357571934271e-10,
  -5.972660061515647e-12,   7.006183549092050e-14,  -8.120944008427130e-16,   8.812438645943580e-18,  -9.744948283407831e-20,   1.168763798145296e-21,  -4.189262716732513e-24,
   2.269118227760838e-25,  -1.461233022337940e-27,   8.563534029604442e-03,  -1.780233772509926e-04,   2.764755440869790e-06,  -3.805253619507800e-08,   4.874464462660260e-10,
  -5.976080282044812e-12,   7.011136579877110e-14,  -8.127971078987585e-16,   8.823033215579410e-18,  -9.749631420832114e-20,   1.171710503949273e-21,  -4.213535028633885e-24,
   2.255532921912958e-25,  -1.495565215288660e-27,   8.564071886024215e-03,  -1.780455760151089e-04,   2.765324174824251e-06,  -3.806415927592704e-08,   4.876510270254977e-10,
  -5.979401514672851e-12,   7.015946792593302e-14,  -8.134793917728063e-16,   8.833326661486583e-18,  -9.754186371879675e-20,   1.174565407956120e-21,  -4.237267496053598e-24,
   2.242358320457989e-25,  -1.528755521622844e-27,   8.564505203025680e-03,  -1.780634606953739e-04,   2.765782397366135e-06,  -3.807352424403357e-08,   4.878158686336261e-10,
  -5.982077731303012e-12,   7.019823196619810e-14,  -8.140291082734303e-16,   8.841624954592722e-18,  -9.757861997766571e-20,   1.176861194873287e-21,  -4.256507101761745e-24,
   2.231754938089028e-25,  -1.555393919102016e-27,   8.564791544335362e-03,  -1.780752793787900e-04,   2.766085210993857e-06,  -3.807971321465468e-08,   4.879248096863808e-10,
  -5.983846458009624e-12,   7.022385321103574e-14,  -8.143923891161766e-16,   8.847111267080237e-18,  -9.760293839492322e-20,   1.178376210024268e-21,  -4.269279439755298e-24,
   2.224753275114521e-25,  -1.572947552222092e-27,   8.564938598367114e-03,  -1.780813490872892e-04,   2.766240729044301e-06,  -3.808289178427706e-08,   4.879807612808604e-10,
  -5.984754885998430e-12,   7.023701300564352e-14,  -8.145789629616119e-16,   8.849929662241052e-18,  -9.761543653029572e-20,   1.179153624501220e-21,  -4.275856914541944e-24,
   2.221159092986850e-25,  -1.581947183595938e-27,   8.564989782517241e-03,  -1.780834617445694e-04,   2.766294859921168e-06,  -3.808399815228747e-08,   4.880002365658521e-10,
  -5.985071088949028e-12,   7.024159372058537e-14,  -8.146439035684130e-16,   8.850910775497621e-18,  -9.761978812939108e-20,   1.179424112314563e-21,  -4.278149171013367e-24,
   2.219908345123834e-25,  -1.585077201070367e-27,   8.564997904767694e-03,  -1.780837969960662e-04,   2.766303449812061e-06,  -3.808417371944548e-08,   4.880033270642981e-10,
  -5.985121266774866e-12,   7.024232063252812e-14,  -8.146542088371852e-16,   8.851066471542411e-18,  -9.762047873989322e-20,   1.179467030333626e-21,  -4.278513058465929e-24,
   2.219709880068939e-25,  -1.585573778459668e-27,   7.697787439474849e-02,  -1.569762645967031e-03,   2.331199033116726e-05,  -2.954738031858973e-07,   3.295292405881702e-09,
  -3.228907952226090e-11,   2.561193515041316e-13,  -1.387985396330037e-15,  -6.813664716553438e-18,   2.783475950200294e-19,  -3.859495954528741e-21,   1.278392668773742e-22,
   3.996289106747833e-25,   2.636392296150024e-27,   7.698006361467703e-02,  -1.569845854520893e-03,   2.331384596119301e-05,  -2.955040969701044e-07,   3.295652357018148e-09,
  -3.229179685836594e-11,   2.561011309973932e-13,  -1.387028780440703e-15,  -6.829879127675610e-18,   2.790071506622130e-19,  -3.857338180788440e-21,   1.278504378601149e-22,
   3.928215050381778e-25,   2.488435637894790e-27,   7.698392666941636e-02,  -1.569992684256275e-03,   2.331712041417499e-05,  -2.955575528961317e-07,   3.296287475507784e-09,
  -3.229659010111000e-11,   2.560689460626889e-13,  -1.385339006628477e-15,  -6.858482587342648e-18,   2.801709855565319e-19,  -3.853564915950541e-21,   1.278692791613728e-22,
   3.808172528976303e-25,   2.228072243656151e-27,   7.698859815816166e-02,  -1.570170244162929e-03,   2.332108019837325e-05,  -2.956221958970191e-07,   3.297055431817382e-09,
  -3.230238351438524e-11,   2.560299687715186e-13,  -1.383292627771937e-15,  -6.893058129774583e-18,   2.815783704583897e-19,  -3.849060464792767e-21,   1.278905815880326e-22,
   3.663144456121566e-25,   1.914444301886853e-27,   7.699313341166801e-02,  -1.570342628626874e-03,   2.332492458223221e-05,  -2.956849538925662e-07,   3.297800913033735e-09,
  -3.230800490614050e-11,   2.559920685999059e-13,  -1.381302806571200e-15,  -6.926610934047172e-18,   2.829446984957336e-19,  -3.844748556626427e-21,   1.279097147263116e-22,
   3.522488877037851e-25,   1.611240709298977e-27,   7.699678713426528e-02,  -1.570481508179909e-03,   2.332802177845034e-05,  -2.957355135602702e-07,   3.298401436131689e-09,
  -3.231253145152866e-11,   2.559614925213922e-13,  -1.379697516697230e-15,  -6.953631728437280e-18,   2.840454376046145e-19,  -3.841318575619912e-21,   1.279240223709029e-22,
   3.409275744263168e-25,   1.367885782338901e-27,   7.699920153786689e-02,  -1.570573281657951e-03,   2.333006845363822e-05,  -2.957689237816153e-07,   3.298798237928279e-09,
  -3.231552154449467e-11,   2.559412667588828e-13,  -1.378635635851968e-15,  -6.971482255297833e-18,   2.847728065603548e-19,  -3.839073461135252e-21,   1.279329362361192e-22,
   3.334514233414220e-25,   1.207522173701631e-27,   7.700044147710362e-02,  -1.570620413073403e-03,   2.333111955116163e-05,  -2.957860819288965e-07,   3.299002010562499e-09,
  -3.231705680091398e-11,   2.559308731721590e-13,  -1.378089958557401e-15,  -6.980648021219384e-18,   2.851463513665063e-19,  -3.837927089881028e-21,   1.279373470389080e-22,
   3.296135403411009e-25,   1.125304035442798e-27,   7.700087305368208e-02,  -1.570636817808021e-03,   2.333148540035634e-05,  -2.957920540428623e-07,   3.299072934845065e-09,
  -3.231759111329330e-11,   2.559272545241440e-13,  -1.377899974750134e-15,  -6.983838038204285e-18,   2.852763680023314e-19,  -3.837529135806482e-21,   1.279388557092293e-22,
   3.282779656143044e-25,   1.096708938513088e-27,   7.700094153914888e-02,  -1.570639421023627e-03,   2.333154345582595e-05,  -2.957930017381220e-07,   3.299084189521115e-09,
  -3.231767589904557e-11,   2.559266802439844e-13,  -1.377869824286089e-15,  -6.984344239923308e-18,   2.852969998963469e-19,  -3.837466035863391e-21,   1.279390938544148e-22,
   3.280660394886534e-25,   1.092172319383783e-27,   2.132750705866422e-01,  -4.173894727978034e-03,   5.599414130327911e-05,  -5.731193398797654e-07,   3.915645528590894e-09,
  -5.697962920963733e-13,  -5.293182137904157e-13,   9.747717600132947e-15,  -1.168320721439759e-16,   6.260047194027961e-19,   9.443362727995814e-21,  -5.651448864911329e-23,
   7.050508108832330e-24,  -4.384120443208146e-26,   2.132803244400002e-01,  -4.174055918752885e-03,   5.599633962558133e-05,  -5.731197123967904e-07,   3.914897560951642e-09,
  -5.505720498204490e-13,  -5.296240421238994e-13,   9.749822362187939e-15,  -1.167908625917459e-16,   6.256998987448946e-19,   9.486120108537208e-21,  -5.685609664578722e-23,
   7.031771560951490e-24,  -4.422553284959048e-26,   2.132895951140918e-01,  -4.174340342472259e-03,   5.600021825701762e-05,  -5.731203550461026e-07,   3.913577410954360e-09,
  -5.166472064646440e-13,  -5.301635922619410e-13,   9.753535401664590e-15,  -1.167180017981017e-16,   6.251605844749451e-19,   9.561472032601541e-21,  -5.746112264757467e-23,
   6.998720126356737e-24,  -4.490134355990599e-26,   2.133008055973112e-01,  -4.174684270775005e-03,   5.600490775489639e-05,  -5.731211071414018e-07,   3.911980475903853e-09,
  -4.756191860006885e-13,  -5.308158704851913e-13,   9.758023802935949e-15,  -1.166296492135767e-16,   6.245059552694314e-19,   9.652427889909577e-21,  -5.819655914720987e-23,
   6.958770275937645e-24,  -4.571455154969833e-26,   2.133116888388521e-01,  -4.175018150522181e-03,   5.600945962583556e-05,  -5.731218110772393e-07,   3.910429575415432e-09,
  -4.357838869644392e-13,  -5.314489319014167e-13,   9.762379547710251e-15,  -1.165436180730973e-16,   6.238678425127953e-19,   9.740558236318465e-21,  -5.891450951328087e-23,
   6.920004847763179e-24,  -4.649982858147559e-26,   2.133204564505564e-01,  -4.175287119777295e-03,   5.601312611497082e-05,  -5.731223593955663e-07,   3.909179743417332e-09,
  -4.036887849633215e-13,  -5.319588038377488e-13,   9.765887389293112e-15,  -1.164741264284822e-16,   6.233519113253520e-19,   9.811434537937012e-21,  -5.949573941038309e-23,
   6.888788333523837e-24,  -4.712945354053104e-26,   2.133262500368826e-01,  -4.175464849904373e-03,   5.601554865073969e-05,  -5.731227125269345e-07,   3.908353657990750e-09,
  -3.824788067214504e-13,  -5.322956621830264e-13,   9.768204773937235e-15,  -1.164281165598021e-16,   6.230100724040598e-19,   9.858209416568235e-21,  -5.988120189029185e-23,
   6.868167129935986e-24,  -4.754403932481648e-26,   2.133292253530526e-01,  -4.175556122839293e-03,   5.601679267229185e-05,  -5.731228910352982e-07,   3.907929355965670e-09,
  -3.715858166231273e-13,  -5.324686377428151e-13,   9.769394696294754e-15,  -1.164044601566275e-16,   6.228342365074101e-19,   9.882212336263090e-21,  -6.007958634728278e-23,
   6.857579053418492e-24,  -4.775649809941538e-26,   2.133302609442473e-01,  -4.175587891221814e-03,   5.601722565480114e-05,  -5.731229527143876e-07,   3.907781662993611e-09,
  -3.677943079654071e-13,  -5.325288407118589e-13,   9.769808833294913e-15,  -1.163962218513957e-16,   6.227729897566068e-19,   9.890563872086755e-21,  -6.014870442965243e-23,
   6.853894079309675e-24,  -4.783037457914241e-26,   2.133304252785522e-01,  -4.175592932426677e-03,   5.601729436265974e-05,  -5.731229624805334e-07,   3.907758225641893e-09,
  -3.671926428361651e-13,  -5.325383939629275e-13,   9.769874549880831e-15,  -1.163949143332860e-16,   6.227632685818932e-19,   9.891889008125985e-21,  -6.015967577064461e-23,
   6.853309339061796e-24,  -4.784209435390271e-26,   4.158759198300433e-01,  -7.587028297534223e-03,   8.375557287460626e-05,  -4.721324950612174e-07,  -3.404829397674937e-09,
   1.212040554237543e-10,  -1.435798058680359e-12,   1.871385728204888e-15,   2.186073634313617e-16,  -4.473164515154121e-18,   4.048303206510116e-20,   6.817323620023490e-22,
  -5.530594402179397e-24,   1.577738677701188e-25,   4.158837680318596e-01,  -7.587160684193739e-03,   8.375364630707984e-05,  -4.720188377465762e-07,  -3.406841651681265e-09,
   1.212075012577121e-10,  -1.435220716094734e-12,   1.856381711840120e-15,   2.187769764731242e-16,  -4.469607636255089e-18,   4.044681607240121e-20,   6.828151885652046e-22,
  -5.573789785252084e-24,   1.564828082154235e-25,   4.158976161594449e-01,  -7.587394256547177e-03,   8.375024592969912e-05,  -4.718182850708581e-07,  -3.410391644141805e-09,
   1.212135575164366e-10,  -1.434201624745017e-12,   1.829916678611782e-15,   2.190761353916909e-16,  -4.463327000468909e-18,   4.038269607704733e-20,   6.847182362938470e-22,
  -5.649919601897937e-24,   1.542090679751266e-25,   4.159143612109093e-01,  -7.587676650417195e-03,   8.374613259083353e-05,  -4.715757702868156e-07,  -3.414683204948517e-09,
   1.212208399499533e-10,  -1.432968712778533e-12,   1.797931578198334e-15,   2.194376662701925e-16,  -4.455724793715105e-18,   4.030479298126288e-20,   6.870064523624233e-22,
  -5.741824423760258e-24,   1.514670525426983e-25,   4.159306167526728e-01,  -7.587950747090889e-03,   8.374213779281428e-05,  -4.713403365974773e-07,  -3.418848196295288e-09,
   1.212278668366834e-10,  -1.431771178542157e-12,   1.766898495590203e-15,   2.197884081013194e-16,  -4.448336777493453e-18,   4.022878049570776e-20,   6.892142538118101e-22,
  -5.830884413813588e-24,   1.488129048291109e-25,   4.159437118162840e-01,  -7.588171522555938e-03,   8.373891846071890e-05,  -4.711506710409584e-07,  -3.422202612297093e-09,
   1.212334969677481e-10,  -1.430805998819086e-12,   1.741911193368561e-15,   2.200707987130604e-16,  -4.442379428655870e-18,   4.016726988814916e-20,   6.909831307543543e-22,
  -5.902515424234618e-24,   1.466803047132362e-25,   4.159523647082687e-01,  -7.588317390769692e-03,   8.373679060830109e-05,  -4.710253418390323e-07,  -3.424418735885378e-09,
   1.212372022610322e-10,  -1.430167999251622e-12,   1.725406174825431e-15,   2.202573176770902e-16,  -4.438440155732458e-18,   4.012648978032374e-20,   6.921472305376488e-22,
  -5.949791751263942e-24,   1.452738329552080e-25,   4.159568083536352e-01,  -7.588392296042047e-03,   8.373569767642557e-05,  -4.709609788091021e-07,  -3.425556693098821e-09,
   1.212391004692898e-10,  -1.429840286068294e-12,   1.716931959298448e-15,   2.203530793959574e-16,  -4.436416297813646e-18,   4.010550551947758e-20,   6.927435861488225e-22,
  -5.974053020197919e-24,   1.445523805154629e-25,   4.159583550005303e-01,  -7.588418366706479e-03,   8.373531724316580e-05,  -4.709385765895183e-07,  -3.425952749102686e-09,
   1.212397604198931e-10,  -1.429726211370304e-12,   1.713982733715027e-15,   2.203864062044058e-16,  -4.435711739915836e-18,   4.009819511490317e-20,   6.929509200195462e-22,
  -5.982494607521333e-24,   1.443014057493170e-25,   4.159586004318749e-01,  -7.588422503723820e-03,   8.373525687230286e-05,  -4.709350216621169e-07,  -3.426015596766225e-09,
   1.212398651099233e-10,  -1.429708108758757e-12,   1.713514746605338e-15,   2.203916945230556e-16,  -4.435599929845708e-18,   4.009703473917852e-20,   6.929838099829118e-22,
  -5.983834039663008e-24,   1.442615858402448e-25,   6.808322268353335e-01,  -1.108869984335940e-02,   8.210145225823110e-05,   3.302429884812454e-07,  -1.581828066078715e-08,
   1.244581772140390e-10,   1.593259023283627e-12,  -4.877216267550317e-14,   2.461983276320929e-16,   7.912029818997583e-18,  -1.632322058458899e-19,   1.058229523965452e-21,
   5.501686601485873e-23,  -6.860299674896269e-25,   6.808399059954306e-01,  -1.108860655472413e-02,   8.209256718586896e-05,   3.303588644970962e-07,  -1.581603268881335e-08,
   1.243625844267479e-10,   1.593891326079712e-12,  -4.874532324568043e-14,   2.455204857486935e-16,   7.917291264806688e-18,  -1.628959007631662e-19,   1.053216250125020e-21,
   5.492835765472786e-23,  -6.859814983223458e-25,   6.808534553187375e-01,  -1.108844191910079e-02,   8.207689036545081e-05,   3.305632568249089e-07,  -1.581206538942028e-08,
   1.241939524732451e-10,   1.595005594257558e-12,  -4.869795035541154e-14,   2.443255729210017e-16,   7.926554156894795e-18,  -1.623029319938330e-19,   1.044370644574903e-21,
   5.477203683094462e-23,  -6.858880212531088e-25,   6.808698381535365e-01,  -1.108824279501334e-02,   8.205793554237705e-05,   3.308102862317350e-07,  -1.580726686636332e-08,
   1.239901142875072e-10,   1.596350525510287e-12,  -4.864064221715397e-14,   2.428826310821740e-16,   7.937719119388775e-18,  -1.615866702186452e-19,   1.033675149486185e-21,
   5.458276355135060e-23,  -6.857614613347302e-25,   6.808857411199816e-01,  -1.108804944175751e-02,   8.203953636705319e-05,   3.310499683020882e-07,  -1.580260726475404e-08,
   1.237923085617746e-10,   1.597653594103140e-12,  -4.858498303743616e-14,   2.414838987689990e-16,   7.948520357217573e-18,  -1.608921346920697e-19,   1.023292927877150e-21,
   5.439876166993569e-23,  -6.856244766579236e-25,   6.808985514789039e-01,  -1.108789364519625e-02,   8.202471554837947e-05,   3.312429600788297e-07,  -1.579885263526919e-08,
   1.236330139228479e-10,   1.598701491199664e-12,  -4.854012654028014e-14,   2.403585665410492e-16,   7.957194816189071e-18,  -1.603331988330747e-19,   1.014929732743187e-21,
   5.425034790104137e-23,  -6.855040346154053e-25,   6.809070159128380e-01,  -1.108779068111117e-02,   8.201492286068034e-05,   3.313704400885197e-07,  -1.579637119537837e-08,
   1.235277818380801e-10,   1.599393023600168e-12,  -4.851047727612986e-14,   2.396156856044302e-16,   7.962913584600802e-18,  -1.599641446743711e-19,   1.009403781679417e-21,
   5.415218895052159e-23,  -6.854195208273232e-25,   6.809113626738488e-01,  -1.108773779902716e-02,   8.200989404655269e-05,   3.314358930979606e-07,  -1.579509671891998e-08,
   1.234737484708166e-10,   1.599747880578900e-12,  -4.849524821408887e-14,   2.392344028353694e-16,   7.965846376214570e-18,  -1.597747045522505e-19,   1.006566036430474e-21,
   5.410175196144584e-23,  -6.853745975297887e-25,   6.809128755829983e-01,  -1.108771939212174e-02,   8.200814375351622e-05,   3.314586723766564e-07,  -1.579465310370084e-08,
   1.234549429909107e-10,   1.599871347553977e-12,  -4.848994716264966e-14,   2.391017292332361e-16,   7.966866513317985e-18,  -1.597087820124328e-19,   1.005578348557686e-21,
   5.408419250846157e-23,  -6.853587195791819e-25,   6.809131156598555e-01,  -1.108771647116082e-02,   8.200786600762518e-05,   3.314622870280965e-07,  -1.579458270703009e-08,
   1.234519588833084e-10,   1.599890937962233e-12,  -4.848910593805646e-14,   2.390806774381702e-16,   7.967028364270170e-18,  -1.596983216698653e-19,   1.005421616828016e-21,
   5.408140585653029e-23,  -6.853561884838422e-25,   9.988734910953080e-01,  -1.351485073420458e-02,   2.723504405443855e-05,   1.531587078963868e-06,  -1.240158675146481e-08,
  -2.697581746150721e-10,   4.592302854589333e-12,   4.124470280601161e-14,  -1.621722674385984e-15,  -2.103809816454308e-18,   5.216084474592858e-19,  -1.847155985228765e-21,
  -1.140827252994013e-22,   2.111756169903922e-24,   9.988760304454286e-01,  -1.351442086442118e-02,   2.722810432043492e-05,   1.531334862781951e-06,  -1.239517858032575e-08,
  -2.696770913964394e-10,   4.588090756119785e-12,   4.123737124456863e-14,  -1.619544595937472e-15,  -2.112765520383781e-18,   5.209091185992415e-19,  -1.832429484681130e-21,
  -1.139407430486135e-22,   2.098704292378248e-24,   9.988805106440931e-01,  -1.351366240996687e-02,   2.721586196928048e-05,   1.530889885119035e-06,  -1.238387605935704e-08,
  -2.695340306272120e-10,   4.580663076704407e-12,   4.122441043103199e-14,  -1.615703735041120e-15,  -2.128506996349867e-18,   5.196758523756541e-19,  -1.806521176116434e-21,
  -1.136905451910206e-22,   2.075730555971174e-24,   9.988859272538994e-01,  -1.351274537683955e-02,   2.720106336253689e-05,   1.530351918670659e-06,  -1.237021710729695e-08,
  -2.693610602404194e-10,   4.571689346276566e-12,   4.120869699911702e-14,  -1.611063403250923e-15,  -2.147437958901578e-18,   5.181857840923681e-19,  -1.775323350917049e-21,
  -1.133885685011530e-22,   2.048046657175586e-24,   9.988911846686406e-01,  -1.351185523967303e-02,   2.718670233921633e-05,   1.529829780411699e-06,  -1.235696579138979e-08,
  -2.691931647945716e-10,   4.562986071290640e-12,   4.119339980017633e-14,  -1.606562918047966e-15,  -2.165707392608589e-18,   5.167405176758515e-19,  -1.745173700321829e-21,
  -1.130960054488453e-22,   2.021272131281599e-24,   9.988954193028688e-01,  -1.351113823033683e-02,   2.717513701571221e-05,   1.529409231613386e-06,  -1.234629683236908e-08,
  -2.690579256281523e-10,   4.555980746407806e-12,   4.118104596054132e-14,  -1.602940442618764e-15,  -2.180347527208198e-18,   5.155771359658444e-19,  -1.720983243548016e-21,
  -1.128607428305482e-22,   1.999774802743495e-24,   9.988982171453836e-01,  -1.351066447936822e-02,   2.716749668179379e-05,   1.529131379133989e-06,  -1.233924997379208e-08,
  -2.689685694583745e-10,   4.551354649971800e-12,   4.117286781452414e-14,  -1.600548271535068e-15,  -2.189983608660200e-18,   5.148088373053913e-19,  -1.705046379099280e-21,
  -1.127054919426807e-22,   1.985604888099163e-24,   9.988996538698545e-01,  -1.351042119671883e-02,   2.716357356928749e-05,   1.528988700551091e-06,  -1.233563200207105e-08,
  -2.689226830994154e-10,   4.548979823894954e-12,   4.116866333091107e-14,  -1.599320239791521e-15,  -2.194920506301065e-18,   5.144144161725601e-19,  -1.696876788765972e-21,
  -1.126258269591584e-22,   1.978338813061988e-24,   9.989001539188006e-01,  -1.351033652173842e-02,   2.716220818391772e-05,   1.528939041867713e-06,  -1.233437288148974e-08,
  -2.689067122998602e-10,   4.548153386518451e-12,   4.116719918805775e-14,  -1.598892885727411e-15,  -2.196636978974881e-18,   5.142771560866419e-19,  -1.694035635023691e-21,
  -1.125981089787562e-22,   1.975811516001150e-24,   9.989002332689143e-01,  -1.351032308506939e-02,   2.716199152032991e-05,   1.528931161808960e-06,  -1.233417308340135e-08,
  -2.689041779713931e-10,   4.548022249057300e-12,   4.116696681392994e-14,  -1.598825074018293e-15,  -2.196909271289986e-18,   5.142553758362091e-19,  -1.693584894441339e-21,
  -1.125937109985679e-22,   1.975410550723383e-24,   1.349147484630081e+00,  -1.324662437181216e-02,  -7.589447737786672e-05,   1.558137882665851e-06,   2.321916731407151e-08,
  -3.196924771738738e-10,  -8.356625949600914e-12,   6.760525865817371e-14,   3.096504648726198e-15,  -1.326987912642418e-17,  -1.214698786734264e-18,   1.662009751092900e-21,
   5.477582328931110e-22,   2.632407494276852e-24,   1.349140395621940e+00,  -1.324618719791001e-02,  -7.588148236865060e-05,   1.557839283954595e-06,   2.320751057429551e-08,
  -3.195600875220719e-10,  -8.348600969180348e-12,   6.756071687936885e-14,   3.091485994555072e-15,  -1.326062312654180e-17,  -1.211393776567963e-18,   1.679863882575665e-21,
   5.459328756301838e-22,   2.606914464553437e-24,   1.349127887938011e+00,  -1.324541586575407e-02,  -7.585855777863839e-05,   1.557312502511383e-06,   2.318695120759393e-08,
  -3.193265550673429e-10,  -8.334451411266928e-12,   6.748214810582420e-14,   3.082641762061399e-15,  -1.324421734345126e-17,  -1.205571160144718e-18,   1.711218139817781e-21,
   5.427170999445590e-22,   2.562074234488069e-24,   1.349112765187861e+00,  -1.324448327872219e-02,  -7.583084616750405e-05,   1.556675684392911e-06,   2.316210616766956e-08,
  -3.190442864474380e-10,  -8.317359751072933e-12,   6.738718619625536e-14,   3.071966402486604e-15,  -1.322425452492147e-17,  -1.198545933260631e-18,   1.748877473010374e-21,
   5.388372286665106e-22,   2.508095589376394e-24,   1.349098086037375e+00,  -1.324357806088356e-02,  -7.580395368649888e-05,   1.556057652069844e-06,   2.313800332292148e-08,
  -3.187703919650826e-10,  -8.300786434598456e-12,   6.729504537264554e-14,   3.061623006973061e-15,  -1.320474485144364e-17,  -1.191742218887887e-18,   1.785170653597227e-21,
   5.350797927360116e-22,   2.455947455016037e-24,   1.349086261960826e+00,  -1.324284891621098e-02,  -7.578229623718420e-05,   1.555559901976358e-06,   2.311859804887116e-08,
  -3.185498371064995e-10,  -8.287448764588631e-12,   6.722085140137223e-14,   3.053304854918016e-15,  -1.318893526779590e-17,  -1.186272865489565e-18,   1.814218005559471e-21,
   5.320593451802679e-22,   2.414118670558301e-24,   1.349078449436644e+00,  -1.324236715301497e-02,  -7.576798870091627e-05,   1.555231060587394e-06,   2.310578109758240e-08,
  -3.184041429179838e-10,  -8.278642112166503e-12,   6.717184178766349e-14,   3.047815388028270e-15,  -1.317844327156783e-17,  -1.182664502422683e-18,   1.833319175995271e-21,
   5.300666632645337e-22,   2.386567418076358e-24,   1.349074437521822e+00,  -1.324211975773997e-02,  -7.576064212310459e-05,   1.555062204281905e-06,   2.309920074447290e-08,
  -3.183293357509593e-10,  -8.274121527699074e-12,   6.714667810090802e-14,   3.044998453411227e-15,  -1.317304115129483e-17,  -1.180813193120567e-18,   1.843099885353167e-21,
   5.290443072025114e-22,   2.372445848037651e-24,   1.349073041168401e+00,  -1.324203365164672e-02,  -7.575808524284420e-05,   1.555003435399782e-06,   2.309691067318916e-08,
  -3.183033006234139e-10,  -8.272548423594369e-12,   6.713792046133515e-14,   3.044018338728737e-15,  -1.317115867143346e-17,  -1.180169107686105e-18,   1.846499592744506e-21,
   5.286886229923763e-22,   2.367535051366809e-24,   1.349072819587781e+00,  -1.324201998789519e-02,  -7.575767950891875e-05,   1.554994109734794e-06,   2.309654728374882e-08,
  -3.182991693112916e-10,  -8.272298809146181e-12,   6.713653078311634e-14,   3.043862824412170e-15,  -1.317085984235836e-17,  -1.180066913475039e-18,   1.847038863179143e-21,
   5.286321882197781e-22,   2.366755981769190e-24,   1.687473840165617e+00,  -8.959729834037318e-03,  -1.423084506804715e-04,  -8.434125803552786e-07,   2.109610406074394e-08,
   6.265263873010234e-10,   4.015609044309135e-12,  -1.631538656858830e-13,  -4.776349729761566e-15,  -2.549620848930967e-17,   1.567484895758230e-18,   4.361270054263367e-20,
   2.129278137012319e-22,  -1.466140039262448e-23,   1.687460522658789e+00,  -8.959964984612797e-03,  -1.422965531763469e-04,  -8.428279255290759e-07,   2.110160456758937e-08,
   6.262039140903472e-10,   4.003208594852322e-12,  -1.632341792694068e-13,  -4.769700079377197e-15,  -2.527553040903405e-17,   1.568653608023269e-18,   4.350486479012315e-20,
   2.097013089940847e-22,  -1.467318780582659e-23,   1.687437024618605e+00,  -8.960379778295549e-03,  -1.422755573617994e-04,  -8.417965390459523e-07,   2.111129617546588e-08,
   6.256347792971804e-10,   3.981342019576655e-12,  -1.633752914277368e-13,  -4.757962788301993e-15,  -2.488659312923816e-17,   1.570699707790042e-18,   4.331452119620329e-20,
   2.040188821783284e-22,  -1.469366230980553e-23,   1.687408612089301e+00,  -8.960881124158297e-03,  -1.422501647720054e-04,  -8.405497952699943e-07,   2.112299130153984e-08,
   6.249463616850646e-10,   3.954924962781236e-12,  -1.635448994268373e-13,  -4.743763355268616e-15,  -2.441705802728588e-17,   1.573146439378783e-18,   4.308424495651119e-20,
   1.971660327578233e-22,  -1.471786807828805e-23,   1.687381031323015e+00,  -8.961367584286162e-03,  -1.422255096650282e-04,  -8.393399176638024e-07,   2.113431953613562e-08,
   6.242778347968808e-10,   3.929305131894995e-12,  -1.637084782598326e-13,  -4.729971953954547e-15,  -2.396205015169066e-17,   1.575493002776992e-18,   4.286058248374444e-20,
   1.905326770360273e-22,  -1.474078987305165e-23,   1.687358813781025e+00,  -8.961759299921532e-03,  -1.422056446682588e-04,  -8.383655710775668e-07,   2.114342737511888e-08,
   6.237391190511345e-10,   3.908684326494252e-12,  -1.638394867210288e-13,  -4.718856915166611e-15,  -2.359608129656917e-17,   1.577362847158070e-18,   4.268032219600058e-20,
   1.852027412771531e-22,  -1.475884321711037e-23,   1.687344133395358e+00,  -8.962018055257353e-03,  -1.421925166850747e-04,  -8.377218945050182e-07,   2.114943684430467e-08,
   6.233830675835422e-10,   3.895067377440323e-12,  -1.639256788001687e-13,  -4.711509927029295e-15,  -2.335453943474108e-17,   1.578588375060466e-18,   4.256117036638321e-20,
   1.816875765243852e-22,  -1.477057117917037e-23,   1.687336594491263e+00,  -8.962150912720903e-03,  -1.421857743594126e-04,  -8.373913835080662e-07,   2.115252026482208e-08,
   6.232001941399387e-10,   3.888077179034472e-12,  -1.639698263481568e-13,  -4.707736167500121e-15,  -2.323058392448104e-17,   1.579214642681939e-18,   4.249996822730454e-20,
   1.798844624791701e-22,  -1.477653186751179e-23,   1.687333970534734e+00,  -8.962197150873440e-03,  -1.421834275551302e-04,  -8.372763537266691e-07,   2.115359304311463e-08,
   6.231365395502888e-10,   3.885644615337867e-12,  -1.639851738117977e-13,  -4.706422560045191e-15,  -2.318745405197485e-17,   1.579432127659179e-18,   4.247866436512799e-20,
   1.792572050605159e-22,  -1.477859664859758e-23,   1.687333554150303e+00,  -8.962204488036604e-03,  -1.421830551459997e-04,  -8.372581004452805e-07,   2.115376325763162e-08,
   6.231264382626576e-10,   3.885258621816535e-12,  -1.639876083650221e-13,  -4.706214103136861e-15,  -2.318061059880795e-17,   1.579466616121004e-18,   4.247528364571752e-20,
   1.791576837526765e-22,  -1.477892383152469e-23,   1.933521215051659e+00,  -2.403677768677995e-03,  -6.182989644584789e-05,  -1.310388966370126e-06,  -2.321445217470919e-08,
  -3.222485326964595e-10,  -2.483501519478542e-12,   3.476963647775728e-14,   2.071680027564958e-15,   5.501053461375152e-17,   1.003435210866644e-18,   1.121460022476451e-20,
  -3.087200198797951e-23,  -5.375426316777559e-24,   1.933515392257629e+00,  -2.404047376712180e-03,  -6.184297385759317e-05,  -1.310690470230037e-06,  -2.321787911333314e-08,
  -3.221771004768538e-10,  -2.477976145190755e-12,   3.495675584873950e-14,   2.075904721557252e-15,   5.506675611655111e-17,   1.003179671901595e-18,   1.117364239932315e-20,
  -3.226037433957501e-23,  -5.405332738836294e-24,   1.933505116846769e+00,  -2.404699624747845e-03,  -6.186605070840428e-05,  -1.311222423177526e-06,  -2.322391964913902e-08,
  -3.220507569802045e-10,  -2.468217524474889e-12,   3.528708400769829e-14,   2.083358327357261e-15,   5.516578645615803e-17,   1.002721754974527e-18,   1.110119389973516e-20,
  -3.471291947182639e-23,  -5.458101484088841e-24,   1.933492690006384e+00,  -2.405488447418786e-03,  -6.189395812735648e-05,  -1.311865571820846e-06,  -2.323121309301647e-08,
  -3.218974690048081e-10,  -2.456401933190111e-12,   3.568678104202312e-14,   2.092369699407816e-15,   5.528523885210037e-17,   1.002156067403555e-18,   1.101328529304865e-20,
  -3.768322687003935e-23,  -5.521906861447696e-24,   1.933480624460560e+00,  -2.406254345718198e-03,  -6.192105293321844e-05,  -1.312489830184369e-06,  -2.323828208514491e-08,
  -3.217481232449620e-10,  -2.444915475699232e-12,   3.607507258263681e-14,   2.101116078723101e-15,   5.540089039493911e-17,   1.001594361360937e-18,   1.092762774197720e-20,
  -4.057162233612606e-23,  -5.583844187214885e-24,   1.933470903335242e+00,  -2.406871431481229e-03,  -6.194288213694369e-05,  -1.312992653381467e-06,  -2.324396862972476e-08,
  -3.216274277308783e-10,  -2.435650610652100e-12,   3.638807020405650e-14,   2.108160811876947e-15,   5.549383464521606e-17,   1.001132860444964e-18,   1.085839572864447e-20,
  -4.290195931516258e-23,  -5.633736974297199e-24,   1.933464479162785e+00,  -2.407279233870456e-03,  -6.195730745486115e-05,  -1.313324875063233e-06,  -2.324772220722209e-08,
  -3.215474859574825e-10,  -2.429522910814994e-12,   3.659498881697500e-14,   2.112815234721931e-15,   5.555514111500931e-17,   1.000823499887716e-18,   1.081253710877018e-20,
  -4.444350670471987e-23,  -5.666703562274955e-24,   1.933461179849233e+00,  -2.407488673241432e-03,  -6.196471584534542e-05,  -1.313495475978634e-06,  -2.324964861442254e-08,
  -3.215063737767852e-10,  -2.426374299002335e-12,   3.670128089102374e-14,   2.115205313218958e-15,   5.558659103735235e-17,   1.000663264200641e-18,   1.078895208162807e-20,
  -4.523569079174773e-23,  -5.683632931836085e-24,   1.933460031462114e+00,  -2.407561572654815e-03,  -6.196729445116564e-05,  -1.313554853466803e-06,  -2.325031892151601e-08,
  -3.214920550303821e-10,  -2.425278118070907e-12,   3.673828150948500e-14,   2.116037171511043e-15,   5.559753207304981e-17,   1.000607275449444e-18,   1.078073761548036e-20,
  -4.551150135543096e-23,  -5.689525263400648e-24,   1.933459849227431e+00,  -2.407573140888484e-03,  -6.196770364265883e-05,  -1.313564275774608e-06,  -2.325042528068712e-08,
  -3.214897824021715e-10,  -2.425104156068170e-12,   3.674415322059546e-14,   2.116169174519174e-15,   5.559926800841096e-17,   1.000598380490713e-18,   1.077943383261295e-20,
  -4.555527266267089e-23,  -5.690460290912962e-24,   7.891879117509198e-03,  -1.575648686893096e-04,   2.350195398516235e-06,  -3.110448171562687e-08,   3.827097636580427e-10,
  -4.531950700370051e-12,   5.076222378028411e-14,  -5.769084610055934e-16,   6.113693806617895e-18,  -5.167583126812556e-20,   1.173048700435027e-21,   2.763835253597396e-24,
   4.475495303170367e-27,  -7.692906511249031e-27,   7.892099880866749e-03,  -1.575736318087752e-04,   2.350411076459099e-06,  -3.110873998651946e-08,   3.827813390502959e-10,
  -4.533089255285301e-12,   5.077837438070149e-14,  -5.770825602981803e-16,   6.118641745528117e-18,  -5.166375137091168e-20,   1.173029500498395e-21,   2.707974338928642e-24,
   3.456640549982269e-27,  -7.685845336871737e-27,   7.892489437777072e-03,  -1.575890954465162e-04,   2.350791676365595e-06,  -3.111625464126217e-08,   3.829076534628129e-10,
  -4.535098531891661e-12,   5.080688292857380e-14,  -5.773897296927421e-16,   6.127372354833848e-18,  -5.164266996738316e-20,   1.172990548656399e-21,   2.609449479115085e-24,
   1.663568400203989e-27,  -7.673339284276147e-27,   7.892960522278886e-03,  -1.576077959060870e-04,   2.351251957743241e-06,  -3.112534292352708e-08,   3.830604257641017e-10,
  -4.537528645545117e-12,   5.084137377365532e-14,  -5.777611088567310e-16,   6.137929307045706e-18,  -5.161757657473628e-20,   1.172934813535189e-21,   2.490384994874603e-24,
  -4.966071751459941e-28,  -7.658137799221902e-27,   7.893417872411792e-03,  -1.576259517308071e-04,   2.351698849486970e-06,  -3.113416722218808e-08,   3.832087675338521e-10,
  -4.539888255096883e-12,   5.087487574279262e-14,  -5.781215820129767e-16,   6.148177595430634e-18,  -5.159363345534413e-20,   1.172871685887845e-21,   2.374875758973136e-24,
  -2.585275511574674e-27,  -7.643298020002987e-27,   7.893786328835908e-03,  -1.576405790755548e-04,   2.352058901620182e-06,  -3.114127707425175e-08,   3.833282934322799e-10,
  -4.541789482138419e-12,   5.090187800193192e-14,  -5.784119352668593e-16,   6.156433316404673e-18,  -5.157464393757482e-20,   1.172814382119367e-21,   2.281878003576125e-24,
  -4.261874992739383e-27,  -7.631284444443017e-27,   7.894029808611229e-03,  -1.576502451757186e-04,   2.352296838200687e-06,  -3.114597568226751e-08,   3.834072856227922e-10,
  -4.543045953527131e-12,   5.091972722777807e-14,  -5.786037764743300e-16,   6.161888463766645e-18,  -5.156224223237620e-20,   1.172773365088239e-21,   2.220453732155945e-24,
  -5.366805609211592e-27,  -7.623317367940323e-27,   7.894154850321982e-03,  -1.576552093697292e-04,   2.352419036373802e-06,  -3.114838881068494e-08,   3.834478554821956e-10,
  -4.543691265646419e-12,   5.092889570473844e-14,  -5.787022902561071e-16,   6.164689915452279e-18,  -5.155591857668035e-20,   1.172751327428950e-21,   2.188917790602157e-24,
  -5.933332979093484e-27,  -7.619217030448064e-27,   7.894198372743334e-03,  -1.576569372330165e-04,   2.352461569578645e-06,  -3.114922874893691e-08,   3.834619767648685e-10,
  -4.543915881026423e-12,   5.093208720274120e-14,  -5.787365779505110e-16,   6.165664981906628e-18,  -5.155372476757116e-20,   1.172743502156085e-21,   2.177942749685724e-24,
  -6.130373630773140e-27,  -7.617788461233669e-27,   7.894205279176357e-03,  -1.576572114225527e-04,   2.352468319060503e-06,  -3.114936203684234e-08,   3.834642176450830e-10,
  -4.543951524801437e-12,   5.093259366497908e-14,  -5.787420188913291e-16,   6.165819711310734e-18,  -5.155337698193490e-20,   1.172742253043408e-21,   2.176201225119404e-24,
  -6.161634415313991e-27,  -7.617561700109343e-27,   7.105056298373338e-02,  -1.396600122909905e-03,   2.006238689003845e-05,  -2.475949443555837e-07,   2.707740480956789e-09,
  -2.662474441402638e-11,   2.155624779457173e-13,  -1.464188051409422e-15,   1.826368745853103e-18,   2.405912273770078e-19,   1.983130308988897e-21,   1.267537599479792e-22,
  -1.003687605350182e-24,  -6.093297647379226e-26,   7.105244688983173e-02,  -1.396669846861287e-03,   2.006391170252568e-05,  -2.476199291165729e-07,   2.708043674035369e-09,
  -2.662761381310232e-11,   2.155674397907745e-13,  -1.463359535702384e-15,   1.834517988694051e-18,   2.412276373051528e-19,   1.976451609020982e-21,   1.263120526928791e-22,
  -1.013860012025937e-24,  -6.086357002305731e-26,   7.105577118825367e-02,  -1.396792881589374e-03,   2.006660239685658e-05,  -2.476640173040008e-07,   2.708578668738856e-09,
  -2.663267557875616e-11,   2.155762123032400e-13,  -1.461895873051151e-15,   1.848874139217802e-18,   2.423487449827245e-19,   1.964616249991080e-21,   1.255330716932654e-22,
  -1.031765546150632e-24,  -6.074067087589974e-26,   7.105979116403022e-02,  -1.396941666248869e-03,   2.006985624970343e-05,  -2.477173329338419e-07,   2.709225599862390e-09,
  -2.663879404313085e-11,   2.155868495122481e-13,  -1.460123043980264e-15,   1.866193874586289e-18,   2.437012511740710e-19,   1.950218530843474e-21,   1.245918346881838e-22,
  -1.053342453514548e-24,  -6.059132847707344e-26,   7.106369389491644e-02,  -1.397086114033207e-03,   2.007301528139984e-05,  -2.477690947217182e-07,   2.709853639690854e-09,
  -2.664473135584962e-11,   2.155972066667828e-13,  -1.458398924742809e-15,   1.882965666052948e-18,   2.450109445180299e-19,   1.936151318223516e-21,   1.236788491951060e-22,
  -1.074210878546281e-24,  -6.044558654367720e-26,   7.106683803319563e-02,  -1.397202486607265e-03,   2.007556033371496e-05,  -2.478107961366940e-07,   2.710359587795801e-09,
  -2.664951266608789e-11,   2.156055722469645e-13,  -1.457007787666530e-15,   1.896446670133445e-18,   2.460636557819283e-19,   1.924754493263272e-21,   1.229438996667641e-22,
  -1.090966359875530e-24,  -6.032763424391605e-26,   7.106891569673203e-02,  -1.397279387114068e-03,   2.007724214583755e-05,  -2.478383530555164e-07,   2.710693912911963e-09,
  -2.665267123195131e-11,   2.156111108281746e-13,  -1.456087468721834e-15,   1.905339880733487e-18,   2.467581132308686e-19,   1.917192166830403e-21,   1.224585229934996e-22,
  -1.102010770422594e-24,  -6.024942772643792e-26,   7.106998269893847e-02,  -1.397318880311959e-03,   2.007810586370634e-05,  -2.478525052744896e-07,   2.710865605977021e-09,
  -2.665429304711209e-11,   2.156139584779822e-13,  -1.455614507068869e-15,   1.909902384755758e-18,   2.471143931353981e-19,   1.913298817976157e-21,   1.222093408976800e-22,
  -1.107674163885957e-24,  -6.020918293824836e-26,   7.107035408242063e-02,  -1.397332626457565e-03,   2.007840649289835e-05,  -2.478574311511802e-07,   2.710925365499195e-09,
  -2.665485749339854e-11,   2.156149501574168e-13,  -1.455449835310502e-15,   1.911489675290613e-18,   2.472383427567288e-19,   1.911942153876652e-21,   1.221226238616347e-22,
  -1.109644016838309e-24,  -6.019516233300267e-26,   7.107041301603503e-02,  -1.397334807789932e-03,   2.007845419881388e-05,  -2.478582128231643e-07,   2.710934848520821e-09,
  -2.665494706128806e-11,   2.156151075483864e-13,  -1.455423701648869e-15,   1.911741521729422e-18,   2.472580091553084e-19,   1.911726796482718e-21,   1.221088636832223e-22,
  -1.109956541628247e-24,  -6.019293683740915e-26,   1.974333382090633e-01,  -3.752391189905706e-03,   4.949023518365505e-05,  -5.111649201282078e-07,   3.797235469097024e-09,
  -1.039725225790841e-11,  -3.048160952558547e-13,   6.443178694779472e-15,  -8.728221820591813e-17,   1.040005653925444e-18,   1.290752199754563e-20,   1.628804005127970e-22,
   5.634332012901526e-25,  -2.176347061773831e-25,   1.974379821923436e-01,  -3.752534988690033e-03,   4.949236868817907e-05,  -5.111745603525110e-07,   3.796804127875861e-09,
  -1.038451108019977e-11,  -3.050440844987012e-13,   6.446708755748864e-15,  -8.722770007859423e-17,   1.040784085814983e-18,   1.290972973933190e-20,   1.613001342552644e-22,
   5.356567104452411e-25,  -2.174340503853464e-25,   1.974461767363456e-01,  -3.752788726096656e-03,   4.949613309263937e-05,  -5.111915609516622e-07,   3.796042759280104e-09,
  -1.036202341136817e-11,  -3.054462587255870e-13,   6.452939694761845e-15,  -8.713149553003079e-17,   1.042151028153373e-18,   1.291348700845828e-20,   1.585129413243735e-22,
   4.867716433223003e-25,  -2.170785869307175e-25,   1.974560859434829e-01,  -3.753095551811563e-03,   4.950068471332603e-05,  -5.112121016672995e-07,   3.795121660624506e-09,
  -1.033482142836502e-11,  -3.059323736540311e-13,   6.460477765535534e-15,  -8.701515327818978e-17,   1.043792677266562e-18,   1.291779491692410e-20,   1.551447096309311e-22,
   4.278755418883179e-25,  -2.166463713857838e-25,   1.974657059202769e-01,  -3.753393416810377e-03,   4.950510299446674e-05,  -5.112320248612932e-07,   3.794227009561030e-09,
  -1.030840410212263e-11,  -3.064040777932595e-13,   6.467799298721464e-15,  -8.690219945751572e-17,   1.045374562190731e-18,   1.292173098442544e-20,   1.518770653598368e-22,
   3.709263165268546e-25,  -2.162242952228986e-25,   1.974734558562802e-01,  -3.753633375777126e-03,   4.950866205099035e-05,  -5.112480622739278e-07,   3.793505957615986e-09,
  -1.028711540040159e-11,  -3.067839276052189e-13,   6.473700073789519e-15,  -8.681119789682924e-17,   1.046640456897764e-18,   1.292472597992542e-20,   1.492462583323834e-22,
   3.252105018837255e-25,  -2.158824993470917e-25,   1.974785769776733e-01,  -3.753791937756748e-03,   4.951101368808457e-05,  -5.112586534119326e-07,   3.793029336478413e-09,
  -1.027304465628988e-11,  -3.070348526819727e-13,   6.477600490486816e-15,  -8.675106216467950e-17,   1.047472800910892e-18,   1.292661907690309e-20,   1.475086360759506e-22,
   2.950813967677022e-25,  -2.156557793276550e-25,   1.974812069500093e-01,  -3.753873367343489e-03,   4.951222132788296e-05,  -5.112640905817976e-07,   3.792784518360683e-09,
  -1.026581755811397e-11,  -3.071636921658573e-13,   6.479603938965504e-15,  -8.672017852448577e-17,   1.047898970361700e-18,   1.292756472781604e-20,   1.466165219003150e-22,
   2.796330975571593e-25,  -2.155390800486385e-25,   1.974821223409745e-01,  -3.753901709724242e-03,   4.951264165186472e-05,  -5.112659827382443e-07,   3.792699299156380e-09,
  -1.026330192562123e-11,  -3.072085323381611e-13,   6.480301320812587e-15,  -8.670942902345845e-17,   1.048047098943482e-18,   1.292788964727137e-20,   1.463060513195222e-22,
   2.742600641632328e-25,  -2.154984192263026e-25,   1.974822676011515e-01,  -3.753906207272928e-03,   4.951270835120179e-05,  -5.112662829831558e-07,   3.792685775661762e-09,
  -1.026290272109240e-11,  -3.072156476855292e-13,   6.480411988708507e-15,  -8.670772321779557e-17,   1.048070595244365e-18,   1.292794100709461e-20,   1.462567857155590e-22,
   2.734076223287259e-25,  -2.154919648938563e-25,   3.868309340211352e-01,  -6.940399981858600e-03,   7.783712817501483e-05,  -5.090591447631679e-07,  -1.317596442352133e-09,
   8.802792940289706e-11,  -1.307123238076508e-12,   6.657608894472904e-15,   9.337198501481353e-17,  -2.316331159238412e-18,   6.582487514806214e-20,   4.523841015135030e-22,
  -7.967670083030769e-24,  -2.898765639059081e-25,   3.868382297287447e-01,  -6.940542863370732e-03,   7.783637667123734e-05,  -5.089765096982039e-07,  -1.319431606048329e-09,
   8.804091325399279e-11,  -1.306872442492714e-12,   6.649849650709687e-15,   9.364797014305991e-17,  -2.314080065527643e-18,   6.577213131324906e-20,   4.502859121328884e-22,
  -8.042446841195560e-24,  -2.894900131687756e-25,   3.868511030612762e-01,  -6.940794961136441e-03,   7.783504979243672e-05,  -5.088306889656517e-07,  -1.322669492339563e-09,
   8.806381107300874e-11,  -1.306429321791746e-12,   6.636164459704009e-15,   9.413476633265773e-17,  -2.310116748683518e-18,   6.567869124812718e-20,   4.465859554376550e-22,
  -8.174081632188658e-24,  -2.888054482151301e-25,   3.868666695330374e-01,  -6.941099768203292e-03,   7.783344388668569e-05,  -5.086543441713953e-07,  -1.326584285944765e-09,
   8.809147824023794e-11,  -1.305892493277215e-12,   6.619626593508637e-15,   9.472309103231785e-17,  -2.305339216278279e-18,   6.556506803659231e-20,   4.421159136468339e-22,
  -8.332727891230661e-24,  -2.879734352436329e-25,   3.868817810901376e-01,  -6.941395635859011e-03,   7.783188340409981e-05,  -5.084831341063460e-07,  -1.330384182862823e-09,
   8.811831493890509e-11,  -1.305370300271547e-12,   6.603582802657247e-15,   9.529389606400408e-17,  -2.300716920182609e-18,   6.545410151878784e-20,   4.377806606502589e-22,
  -8.486186844078746e-24,  -2.871613226416487e-25,   3.868939546893034e-01,  -6.941633958798476e-03,   7.783062522705030e-05,  -5.083451969060850e-07,  -1.333444959599770e-09,
   8.813991839976627e-11,  -1.304948876891276e-12,   6.590665916492393e-15,   9.575349166086534e-17,  -2.297004465396104e-18,   6.536423420292737e-20,   4.342912455689465e-22,
  -8.609416346669151e-24,  -2.865039508085775e-25,   3.869019987501703e-01,  -6.941791426503596e-03,   7.782979332094304e-05,  -5.082540442952445e-07,  -1.335467284619639e-09,
   8.815418583122672e-11,  -1.304670039980830e-12,   6.582134473062081e-15,   9.605706763596989e-17,  -2.294556826109552e-18,   6.530461971931413e-20,   4.319869788213376e-22,
  -8.690651003626642e-24,  -2.860680373948433e-25,   3.869061297489985e-01,  -6.941872290040597e-03,   7.782936593495853e-05,  -5.082072311616375e-07,  -1.336505789047265e-09,
   8.816151044351358e-11,  -1.304526730146219e-12,   6.577754344055934e-15,   9.621293229562835e-17,  -2.293301541889357e-18,   6.527393323703384e-20,   4.308040850031298e-22,
  -8.732309183096805e-24,  -2.858437018869584e-25,   3.869075675791686e-01,  -6.941900434751832e-03,   7.782921715350015e-05,  -5.081909371183193e-07,  -1.336867241067819e-09,
   8.816405946042594e-11,  -1.304476831740338e-12,   6.576229987056959e-15,   9.626717666001494e-17,  -2.292864898626876e-18,   6.526324113554092e-20,   4.303924408658290e-22,
  -8.746799193122634e-24,  -2.857655446487003e-25,   3.869077957429288e-01,  -6.941904900902195e-03,   7.782919354270446e-05,  -5.081883514636445e-07,  -1.336924598100253e-09,
   8.816446393619553e-11,  -1.304468912691046e-12,   6.575988101470881e-15,   9.627578422011621e-17,  -2.292795622167042e-18,   6.526154390570012e-20,   4.303271220721422e-22,
  -8.749098107201069e-24,  -2.857531386031252e-25,   6.378103386417657e-01,  -1.042013868936226e-02,   8.463346190117549e-05,   9.869607302075472e-08,  -1.305178696611810e-08,
   1.474203634851227e-10,   3.725022074039540e-13,  -3.746489647169595e-14,   4.307321409396355e-16,   2.942262001377076e-18,  -7.385729828148739e-20,   2.599019157955847e-21,
   4.058526754198334e-24,  -1.274512821175817e-24,   6.378182582815701e-01,  -1.042011044665316e-02,   8.462612332446618e-05,   9.883366073759046e-08,  -1.305124985061851e-08,
   1.473467687066225e-10,   3.736264578100641e-13,  -3.745462782376869e-14,   4.304212278349578e-16,   2.955303279613344e-18,  -7.383584071520953e-20,   2.589760154774563e-21,
   3.979056644888745e-24,  -1.273422663636877e-24,   6.378322320518321e-01,  -1.042006058059499e-02,   8.461317453897627e-05,   9.907638038969877e-08,  -1.305030081904048e-08,
   1.472169261623841e-10,   3.756095522354670e-13,  -3.743647311331618e-14,   4.298726871638857e-16,   2.978276069326624e-18,  -7.379837371696983e-20,   2.573429096303167e-21,
   3.839243041279878e-24,  -1.271490327939612e-24,   6.378491283314154e-01,  -1.042000022857283e-02,   8.459751715342790e-05,   9.936978404444773e-08,  -1.304915105310441e-08,
   1.470599475139967e-10,   3.780064006579524e-13,  -3.741445975225432e-14,   4.292095050281009e-16,   3.005988957726983e-18,  -7.375374068221621e-20,   2.553692691806140e-21,
   3.670881375350711e-24,  -1.269138875542355e-24,   6.378655299494992e-01,  -1.041994158391134e-02,   8.458231767931341e-05,   9.965451519429063e-08,  -1.304803259088990e-08,
   1.469075850897371e-10,   3.803320358477460e-13,  -3.739302630939066e-14,   4.285658228408832e-16,   3.032823003044744e-18,  -7.371111409493936e-20,   2.534544795316859e-21,
   3.508172875150813e-24,  -1.266840629332310e-24,   6.378787421649282e-01,  -1.041989430044521e-02,   8.457007349964428e-05,   9.988381923590833e-08,  -1.304712993243255e-08,
   1.467848652385335e-10,   3.822046892352826e-13,  -3.737571455140211e-14,   4.280473685383905e-16,   3.054390634673535e-18,  -7.367727666139241e-20,   2.519128030528593e-21,
   3.377621944439770e-24,  -1.264978127510800e-24,   6.378874722115362e-01,  -1.041986303674742e-02,   8.456198292018348e-05,   1.000353041734305e-07,  -1.304653266908198e-08,
   1.467037846078978e-10,   3.834416900280313e-13,  -3.736425311839305e-14,   4.277048257766855e-16,   3.068617899036880e-18,  -7.365516276438779e-20,   2.508945097012370e-21,
   3.291612806155522e-24,  -1.263742017668190e-24,   6.378919553999534e-01,  -1.041984697527393e-02,   8.455782806889156e-05,   1.001130880864447e-07,  -1.304622569756432e-08,
   1.466621490626049e-10,   3.840768207247892e-13,  -3.735836028531741e-14,   4.275289267836882e-16,   3.075916784343387e-18,  -7.364388196515615e-20,   2.503716971922315e-21,
   3.247522261074653e-24,  -1.263105548894377e-24,   6.378935157975069e-01,  -1.041984138396490e-02,   8.455638194255554e-05,   1.001401597623085e-07,  -1.304611881380478e-08,
   1.466476579455553e-10,   3.842978633395776e-13,  -3.735630814255238e-14,   4.274677056084012e-16,   3.078456035023981e-18,  -7.363996762868971e-20,   2.501897482071402e-21,
   3.232188753802180e-24,  -1.262883754981575e-24,   6.378937634102905e-01,  -1.041984049665530e-02,   8.455615246258824e-05,   1.001444555824273e-07,  -1.304610185094850e-08,
   1.466453584293455e-10,   3.843329387879270e-13,  -3.735598244410558e-14,   4.274579907496552e-16,   3.078858922493824e-18,  -7.363934704921184e-20,   2.501608763920636e-21,
   3.229756135884063e-24,  -1.262848546761740e-24,   9.453609975539776e-01,  -1.322719703800974e-02,   4.426571386704812e-05,   1.296276368276826e-06,  -1.663115120334257e-08,
  -1.514803276611934e-10,   5.036621880824997e-12,  -8.074460419072011e-15,  -1.353224454505839e-15,   1.592061830576461e-17,   3.587085652011024e-19,  -4.768006741644201e-21,
  -1.817768264925835e-23,   9.372135999251349e-25,   9.453651287575758e-01,  -1.322683296168035e-02,   4.425639858503964e-05,   1.296134230017324e-06,  -1.662411005891678e-08,
  -1.514953810375272e-10,   5.033100825057104e-12,  -8.021361661401378e-15,  -1.351715466336011e-15,   1.589628841818390e-17,   3.585773908137556e-19,  -4.761410600988615e-21,
  -1.858429438649918e-23,   9.325188224433363e-25,   9.453724176261533e-01,  -1.322619057578237e-02,   4.423996483337659e-05,   1.295883413604324e-06,  -1.661168986194242e-08,
  -1.515218582789288e-10,   5.026891084388386e-12,  -7.927734638546738e-15,  -1.349053299189850e-15,   1.585338533750619e-17,   3.583439091246955e-19,  -4.749799208232398e-21,
  -1.929968132621517e-23,   9.242577995221115e-25,   9.453812302017214e-01,  -1.322541385132953e-02,   4.422009843731815e-05,   1.295580104634186e-06,  -1.659667806726573e-08,
  -1.515537305319835e-10,   5.019387685244951e-12,  -7.814633299044162e-15,  -1.345834977891248e-15,   1.580155309522169e-17,   3.580581393306051e-19,  -4.735805557292732e-21,
  -2.016118405328311e-23,   9.143076092551032e-25,   9.453897840388239e-01,  -1.322465987873264e-02,   4.420081821257956e-05,   1.295285637608153e-06,  -1.658211203663414e-08,
  -1.515845205362531e-10,   5.012109258834603e-12,  -7.704955222195670e-15,  -1.342711530689337e-15,   1.575128397261075e-17,   3.577771244428570e-19,  -4.722269830264428e-21,
  -2.099380498008537e-23,   9.046890262561119e-25,   9.453966739970427e-01,  -1.322405252981245e-02,   4.418529041770042e-05,   1.295048404562473e-06,  -1.657038295947603e-08,
  -1.516092164182128e-10,   5.006249967801239e-12,  -7.616685024807865e-15,  -1.340195930769360e-15,   1.571082265893635e-17,   3.575481734612877e-19,  -4.711400697448612e-21,
  -2.166189982792554e-23,   8.969696590203572e-25,   9.454012263172522e-01,  -1.322365122483393e-02,   4.417503193615927e-05,   1.294891638236233e-06,  -1.656263510397614e-08,
  -1.516254820927838e-10,   5.002380267040856e-12,  -7.558399267742634e-15,  -1.338533966811748e-15,   1.568410357268083e-17,   3.573956314471669e-19,  -4.704235707033231e-21,
  -2.210206774775541e-23,   8.918831306447105e-25,   9.454035640149934e-01,  -1.322344514182497e-02,   4.416976433614885e-05,   1.294811129078968e-06,  -1.655865698542117e-08,
  -1.516338189332632e-10,   5.000393613451143e-12,  -7.528479609087348e-15,  -1.337680561831703e-15,   1.567038730375086e-17,   3.573169061667805e-19,  -4.700561434822121e-21,
  -2.232771429294025e-23,   8.892753698027748e-25,   9.454043776503692e-01,  -1.322337341374931e-02,   4.416793099859916e-05,   1.294783106787880e-06,  -1.655727248834504e-08,
  -1.516367180426351e-10,   4.999702239639101e-12,  -7.518067845905351e-15,  -1.337383541256612e-15,   1.566561406765165e-17,   3.572894434454430e-19,  -4.699283412777760e-21,
  -2.240618888015773e-23,   8.883684171617617e-25,   9.454045067620662e-01,  -1.322336203153916e-02,   4.416764007787284e-05,   1.294778660020002e-06,  -1.655705279359010e-08,
  -1.516371779677406e-10,   4.999592532844388e-12,  -7.516415739700202e-15,  -1.337336408887301e-15,   1.566485666054086e-17,   3.572850825632668e-19,  -4.699080648242360e-21,
  -2.241863869031858e-23,   8.882245296045735e-25,   1.295073285133585e+00,  -1.377322670491703e-02,  -5.521185348476507e-05,   1.868432912442975e-06,   1.502786626659526e-08,
  -4.871036415560785e-10,  -5.211984937168489e-12,   1.502836611952300e-13,   1.832766121209172e-15,  -5.267463070001206e-17,  -5.775007283105236e-19,   2.552706531716362e-20,
   3.250741854645373e-22,  -1.111324608210979e-23,   1.295068125918365e+00,  -1.377270280848237e-02,  -5.520344135010863e-05,   1.867978715281129e-06,   1.502059316817337e-08,
  -4.868105383796504e-10,  -5.207222790485190e-12,   1.501092233398181e-13,   1.830391541462338e-15,  -5.254608761310727e-17,  -5.755681347899444e-19,   2.544761020754448e-20,
   3.233631244728725e-22,  -1.108031207650657e-23,   1.295059023038093e+00,  -1.377177848839602e-02,  -5.518860131881418e-05,   1.867177499782310e-06,   1.500776509674663e-08,
  -4.862936307719038e-10,  -5.198824938043552e-12,   1.498017754439938e-13,   1.826208117638803e-15,  -5.231960254133294e-17,  -5.721665710189390e-19,   2.530760503738770e-20,
   3.203511303280255e-22,  -1.102228657038369e-23,   1.295048016822519e+00,  -1.377066096696707e-02,  -5.517066224105463e-05,   1.866209040743170e-06,   1.499226250214457e-08,
  -4.856690534470021e-10,  -5.188678732702185e-12,   1.494306030798406e-13,   1.821160641421780e-15,  -5.204629858581488e-17,  -5.680678798675296e-19,   2.513864078125014e-20,
   3.167212490771194e-22,  -1.095226976524322e-23,   1.295037333314428e+00,  -1.376957628107873e-02,  -5.515325320583877e-05,   1.865269274490294e-06,   1.497722252943420e-08,
  -4.850632192964398e-10,  -5.178837931921120e-12,   1.490708996678765e-13,   1.816272304922627e-15,  -5.178156996508168e-17,  -5.641041111250045e-19,   2.497495989075443e-20,
   3.132102274809768e-22,  -1.088445366612779e-23,   1.295028727632647e+00,  -1.376870260444570e-02,  -5.513923294711373e-05,   1.864512495350810e-06,   1.496511345358402e-08,
  -4.845755212943020e-10,  -5.170916721864745e-12,   1.487815740244356e-13,   1.812342665414958e-15,  -5.156873035563690e-17,  -5.609217974611611e-19,   2.484334877530917e-20,
   3.103909484948741e-22,  -1.082993278211285e-23,   1.295023041549633e+00,  -1.376812535921280e-02,  -5.512997068220176e-05,   1.864012568341498e-06,   1.495711538395388e-08,
  -4.842534323861251e-10,  -5.165685662962229e-12,   1.485906113081019e-13,   1.809750106307251e-15,  -5.142829631298545e-17,  -5.588242832850497e-19,   2.475650383419102e-20,
   3.085324933681273e-22,  -1.079396057385119e-23,   1.295020121597070e+00,  -1.376782893617881e-02,  -5.512521470673085e-05,   1.863755874928377e-06,   1.495300904120324e-08,
  -4.840880778680749e-10,  -5.163000232896587e-12,   1.484926103458585e-13,   1.808419962371356e-15,  -5.135624055626239e-17,  -5.577487471866930e-19,   2.471194229965988e-20,
   3.075794697202980e-22,  -1.077550387684724e-23,   1.295019105300443e+00,  -1.376772576661317e-02,  -5.512355944791005e-05,   1.863666537284147e-06,   1.495157995793143e-08,
  -4.840305332360367e-10,  -5.162065698567216e-12,   1.484585109600650e-13,   1.807957193925710e-15,  -5.133117105044894e-17,  -5.573746575681680e-19,   2.469643821681276e-20,
   3.072479809741463e-22,  -1.076908252021515e-23,   1.295018944029095e+00,  -1.376770939517521e-02,  -5.512329678597364e-05,   1.863652360955508e-06,   1.495135319002190e-08,
  -4.840214020999758e-10,  -5.161917408158706e-12,   1.484531003672535e-13,   1.807883768454414e-15,  -5.132719334739919e-17,  -5.573153070644524e-19,   2.469397821563044e-20,
   3.071953887099767e-22,  -1.076806366588030e-23,   1.649303274649403e+00,  -1.013196575865735e-02,  -1.499787119954835e-04,  -4.022641601911192e-07,   3.412936533220766e-08,
   6.504889134801629e-10,  -2.722163568415424e-12,  -3.147843584089959e-13,  -4.100875349423626e-15,   7.505302060314567e-17,   3.342385785003138e-18,   2.670915977719316e-20,
  -1.074919740714342e-21,  -3.211703252902218e-23,   1.649289252665575e+00,  -1.013207676655458e-02,  -1.499595366368271e-04,  -4.016595001211510e-07,   3.412541382211405e-08,
   6.498732723713622e-10,  -2.732642214990971e-12,  -3.145277296072607e-13,  -4.086989389785547e-15,   7.518192108672311e-17,   3.335711680319821e-18,   2.648141336744309e-20,
  -1.075445693454663e-21,  -3.198793972275220e-23,   1.649264512112975e+00,  -1.013227250437672e-02,  -1.499257032503201e-04,  -4.005930358721409e-07,   3.411842945251288e-08,
   6.487873763159840e-10,  -2.751102447789792e-12,  -3.140745568131796e-13,  -4.062510305803552e-15,   7.540842056914489e-17,   3.323932687018309e-18,   2.608031627521469e-20,
  -1.076354213793887e-21,  -3.176033271173277e-23,   1.649234598059109e+00,  -1.013250895850723e-02,  -1.498847946912142e-04,  -3.993042535965933e-07,   3.410996366545909e-08,
   6.474750026972903e-10,  -2.773374485376245e-12,  -3.135259851334809e-13,  -4.032949005186728e-15,   7.568069287691806e-17,   3.309685324845423e-18,   2.559660908499550e-20,
  -1.077419595015803e-21,  -3.148541514114307e-23,   1.649205560617325e+00,  -1.013273825899284e-02,  -1.498450846560555e-04,  -3.980539611285139e-07,   3.410172408873165e-08,
   6.462017102749649e-10,  -2.794943191141284e-12,  -3.129928253497535e-13,  -4.004292326031130e-15,   7.594332349921154e-17,   3.295850047227240e-18,   2.512839878880061e-20,
  -1.078419186938414e-21,  -3.121885368589901e-23,   1.649182170297425e+00,  -1.013292280494067e-02,  -1.498130971257601e-04,  -3.970473398957198e-07,   3.409507126882022e-08,
   6.451764909732197e-10,  -2.812281000444368e-12,  -3.125628790666162e-13,  -3.981236201574987e-15,   7.615368882565843e-17,   3.284701588713716e-18,   2.475219148600108e-20,
  -1.079199692420383e-21,  -3.100434862611145e-23,   1.649166715304118e+00,  -1.013304466369216e-02,  -1.497919614912566e-04,  -3.963824752941885e-07,   3.409066780714373e-08,
   6.444993032325135e-10,  -2.823719089015024e-12,  -3.122785635769240e-13,  -3.966015484763905e-15,   7.629210455266398e-17,   3.277333471105147e-18,   2.450407840817547e-20,
  -1.079703350080447e-21,  -3.086272233930282e-23,   1.649158778708030e+00,  -1.013310721742485e-02,  -1.497811076893233e-04,  -3.960411260358703e-07,   3.408840413312546e-08,
   6.441516150245951e-10,  -2.829587398676604e-12,  -3.121324877245963e-13,  -3.958203359602363e-15,   7.636300537855845e-17,   3.273549157738445e-18,   2.437680824045583e-20,
  -1.079958271599614e-21,  -3.079002609847658e-23,   1.649156016348049e+00,  -1.013312898559537e-02,  -1.497773299811338e-04,  -3.959223307110882e-07,   3.408761587691708e-08,
   6.440306117142547e-10,  -2.831629010996839e-12,  -3.120816341524280e-13,  -3.955484984979711e-15,   7.638765405728878e-17,   3.272231924428757e-18,   2.433253421298985e-20,
  -1.080046406050345e-21,  -3.076472918977549e-23,   1.649155578001699e+00,  -1.013313243970348e-02,  -1.497767305135766e-04,  -3.959034802132083e-07,   3.408749077424830e-08,
   6.440114107609371e-10,  -2.831952943720001e-12,  -3.120735638910521e-13,  -3.955053649933347e-15,   7.639156408657273e-17,   3.272022894406418e-18,   2.432550965104542e-20,
  -1.080060363619787e-21,  -3.076071518879643e-23,   1.922808052192965e+00,  -2.968038518575843e-03,  -8.000503994685469e-05,  -1.736126334508638e-06,  -3.012904271226509e-08,
  -3.605492611283691e-10,  -2.236510307404768e-13,   1.413824752001490e-13,   4.879664313681475e-15,   1.031737572258972e-16,   1.313366567933647e-18,  -1.944275191225493e-21,
  -6.481176220640142e-22,  -2.061056806934773e-23,   1.922800517712292e+00,  -2.968527984789566e-03,  -8.002198832834192e-05,  -1.736461956523225e-06,  -3.012920425357839e-08,
  -3.602653842384210e-10,  -2.107307001710667e-13,   1.417302455726525e-13,   4.885070335657431e-15,   1.031577723943153e-16,   1.309200457765819e-18,  -2.097115400322662e-21,
  -6.514867756250209e-22,  -2.064955510351906e-23,   1.922787221710564e+00,  -2.969391731961044e-03,  -8.005189405231800e-05,  -1.737053948784349e-06,  -3.012947448053280e-08,
  -3.597639225792098e-10,  -1.879211182404701e-13,   1.423438436243657e-13,   4.894594920521869e-15,   1.031289240371028e-16,   1.301832379356085e-18,  -2.367031837025810e-21,
  -6.574283865601066e-22,  -2.071803024685724e-23,   1.922771141840161e+00,  -2.970436314396347e-03,  -8.008805643378494e-05,  -1.737769420044967e-06,  -3.012977597173173e-08,
  -3.591566010953076e-10,  -1.603200169002068e-13,   1.430857294780102e-13,   4.906087513177019e-15,   1.030929435014719e-16,   1.292893996471756e-18,  -2.693804249062339e-21,
  -6.646073425042698e-22,  -2.080028739127241e-23,   1.922755529473304e+00,  -2.971450513166234e-03,  -8.012316230516175e-05,  -1.738463597123011e-06,  -3.013004218017583e-08,
  -3.585660305277758e-10,  -1.335049407125752e-13,   1.438058504716868e-13,   4.917218472815898e-15,   1.030568648457582e-16,   1.284186600221690e-18,  -3.011432396743339e-21,
  -6.715705075335369e-22,  -2.087957008294551e-23,   1.922742950700630e+00,  -2.972267636078788e-03,  -8.015144317556554e-05,  -1.739022537428478e-06,  -3.013023765770351e-08,
  -3.580895628544164e-10,  -1.118884632321693e-13,   1.443859057561953e-13,   4.926166871776157e-15,   1.030269762485950e-16,   1.277150429854853e-18,  -3.267597176162715e-21,
  -6.771755659540142e-22,  -2.094302876360363e-23,   1.922734638062394e+00,  -2.972807624104587e-03,  -8.017013068732910e-05,  -1.739391738160879e-06,  -3.013035753112630e-08,
  -3.577743730556108e-10,  -9.759753878035731e-14,   1.447691637755001e-13,   4.932070713822480e-15,   1.030068226612474e-16,   1.272490479701583e-18,  -3.437006675191428e-21,
  -6.808771262045212e-22,  -2.098475968283083e-23,   1.922730368874620e+00,  -2.973084948561384e-03,  -8.017972762349746e-05,  -1.739581297991707e-06,  -3.013041621672167e-08,
  -3.576124002563573e-10,  -9.025625844184666e-14,   1.449659750609876e-13,   4.935099801696965e-15,   1.029963479215816e-16,   1.270094103115971e-18,  -3.524049869757236e-21,
  -6.827773815701732e-22,  -2.100612810271362e-23,   1.922728882904872e+00,  -2.973181476229090e-03,  -8.018306792573515e-05,  -1.739647269272896e-06,  -3.013043618499270e-08,
  -3.575560069857348e-10,  -8.770070740619713e-14,   1.450344754236060e-13,   4.936153654647675e-15,   1.029926822025507e-16,   1.269259501920421e-18,  -3.554352936825099e-21,
  -6.834386753492952e-22,  -2.101355563284073e-23,   1.922728647100046e+00,  -2.973196793952151e-03,  -8.018359798573030e-05,  -1.739657737685980e-06,  -3.013043933194838e-08,
  -3.575470573359743e-10,  -8.729515998358103e-14,   1.450453454112617e-13,   4.936320865284402e-15,   1.029920995590950e-16,   1.269127037502574e-18,  -3.559161942949338e-21,
  -6.835436084535427e-22,  -2.101473380731101e-23,   7.296997217370232e-03,  -1.401587077935746e-04,   2.010890996773655e-06,  -2.564515689876080e-08,   3.030534091673591e-10,
  -3.486781603856789e-12,   3.713373402101322e-14,  -4.018035715401282e-16,   5.115865342766597e-18,  -3.918667662035912e-21,   1.130332160820636e-21,  -8.989141607631053e-24,
  -5.260416431974198e-25,  -1.116066849774064e-26,   7.297186080835604e-03,  -1.401659320186755e-04,   2.011061759732735e-06,  -2.564843240326081e-08,   3.031057884747122e-10,
  -3.487572887085354e-12,   3.714725916204211e-14,  -4.018180972289165e-16,   5.120529944685996e-18,  -3.968081497803233e-21,   1.127095472961907e-21,  -9.068267308384572e-24,
  -5.256540055199741e-25,  -1.111546428663919e-26,   7.297519346447168e-03,  -1.401786800278334e-04,   2.011363097656583e-06,  -2.565421268574992e-08,   3.031982280887131e-10,
  -3.488969142707744e-12,   3.717113437838624e-14,  -4.018438658656342e-16,   5.128749623042829e-18,  -4.055602147352523e-21,   1.121386273158522e-21,  -9.207618434280272e-24,
  -5.249666679384927e-25,  -1.103579910176756e-26,   7.297922357047943e-03,  -1.401940963361649e-04,   2.011727519614122e-06,  -2.566120329373392e-08,   3.033100334978282e-10,
  -3.490657550858924e-12,   3.720002139597126e-14,  -4.018752612041441e-16,   5.138670049616915e-18,  -4.161993529725498e-21,   1.114486046958811e-21,  -9.375667732168391e-24,
  -5.241298373984824e-25,  -1.093963438585856e-26,   7.298313616077769e-03,  -1.402090635613879e-04,   2.012081337000023e-06,  -2.566799073215482e-08,   3.034185999513923e-10,
  -3.492296671327459e-12,   3.722808203804473e-14,  -4.019059867869795e-16,   5.148280846010211e-18,  -4.265862392556890e-21,   1.107791001043443e-21,  -9.538330516586255e-24,
  -5.233115043676290e-25,  -1.084645396679999e-26,   7.298628825970210e-03,  -1.402211219235456e-04,   2.012366398396735e-06,  -2.567345937610119e-08,   3.035060795268216e-10,
  -3.493617156453153e-12,   3.725069994040163e-14,  -4.019309168250940e-16,   5.156009009134046e-18,  -4.349956941336235e-21,   1.102400130344041e-21,  -9.669028439107213e-24,
  -5.226480086695791e-25,  -1.077151376312442e-26,   7.298837119232152e-03,  -1.402290903446032e-04,   2.012554776928649e-06,  -2.567707333651059e-08,   3.035638941948877e-10,
  -3.494489724731306e-12,   3.726565161764313e-14,  -4.019474774815573e-16,   5.161108705634159e-18,  -4.405730067474319e-21,   1.098839202112092e-21,  -9.755224429170670e-24,
  -5.222075011415712e-25,  -1.072205552686079e-26,   7.298944090318552e-03,  -1.402331826554986e-04,   2.012651522969746e-06,  -2.567892939497570e-08,   3.035935878007979e-10,
  -3.494937835015173e-12,   3.727333192628500e-14,  -4.019560092265437e-16,   5.163725499139071e-18,  -4.434435558846399e-21,   1.097010886587691e-21,  -9.799438619179923e-24,
  -5.219806364119061e-25,  -1.069667516145837e-26,   7.298981322987562e-03,  -1.402346070449317e-04,   2.012685197055863e-06,  -2.567957543172822e-08,   3.036039234111162e-10,
  -3.495093804655983e-12,   3.727600543152224e-14,  -4.019589830900105e-16,   5.164635956682505e-18,  -4.444436843756077e-21,   1.096374587033299e-21,  -9.814819564783103e-24,
  -5.219015717508683e-25,  -1.068784428374447e-26,   7.298987231318478e-03,  -1.402348330770167e-04,   2.012690540704719e-06,  -2.567967794974679e-08,   3.036055635528632e-10,
  -3.495118554925690e-12,   3.727642969438820e-14,  -4.019594552059519e-16,   5.164780417548913e-18,  -4.446024388154259e-21,   1.096273618021541e-21,  -9.817259919408343e-24,
  -5.218890204220337e-25,  -1.068644308699980e-26,   6.576733210004002e-02,  -1.247287791416574e-03,   1.733449128641675e-05,  -2.082636726898858e-07,   2.223730698850077e-09,
  -2.192781072541449e-11,   1.768514013244251e-13,  -1.242328556438594e-15,   1.303254816100062e-17,   4.036423567394394e-19,   5.103045794738131e-21,  -2.125501784253155e-23,
  -5.493629376643380e-24,  -9.712712070042980e-26,   6.576895971927094e-02,  -1.247346437945342e-03,   1.733574353882993e-05,  -2.082842503330297e-07,   2.223979805813984e-09,
  -2.193023495258620e-11,   1.768860305487808e-13,  -1.240969921094057e-15,   1.305298906837911e-17,   4.035061735422225e-19,   5.069199533553352e-21,  -2.194195784765204e-23,
  -5.490534397305374e-24,  -9.670351909599860e-26,   6.577183177466601e-02,  -1.247449925378289e-03,   1.733795327196362e-05,  -2.083205617496972e-07,   2.224419398731874e-09,
  -2.193451036684995e-11,   1.769471773252003e-13,  -1.238572980757353e-15,   1.308894141301630e-17,   4.032630202710575e-19,   5.009493182687807e-21,  -2.315156839270524e-23,
  -5.485042356612288e-24,  -9.595699141356899e-26,   6.577530485784570e-02,  -1.247575071519724e-03,   1.734062549935738e-05,  -2.083644730416876e-07,   2.224951027014446e-09,
  -2.193967653924121e-11,   1.770211897505926e-13,  -1.235675250501712e-15,   1.313221769209650e-17,   4.029641344036438e-19,   4.937322858200240e-21,  -2.460997335121955e-23,
  -5.478348714696952e-24,  -9.505585370585600e-26,   6.577867663769199e-02,  -1.247696569638750e-03,   1.734321985512728e-05,  -2.084071046495213e-07,   2.225467193621326e-09,
  -2.194468789152620e-11,   1.770931160550852e-13,  -1.232862898425409e-15,   1.317402259439263e-17,   4.026688985386538e-19,   4.867289809586829e-21,  -2.602130190053832e-23,
  -5.471795655841407e-24,  -9.418268544864712e-26,   6.578139302208214e-02,  -1.247794452970302e-03,   1.734530998033967e-05,  -2.084414504715552e-07,   2.225883061680539e-09,
  -2.194872219327178e-11,   1.771511134835478e-13,  -1.230597820747249e-15,   1.320755182793168e-17,   4.024274251178603e-19,   4.810892721341839e-21,  -2.715505348389317e-23,
  -5.466477271050755e-24,  -9.348044438677599e-26,   6.578318802042656e-02,  -1.247859135483105e-03,   1.734669116930796e-05,  -2.084641467306729e-07,   2.226157884845740e-09,
  -2.195138662774235e-11,   1.771894637903945e-13,  -1.229101352631958e-15,   1.322963477385308e-17,   4.022660864695719e-19,   4.773636666988222e-21,  -2.790265266641680e-23,
  -5.462943751235699e-24,  -9.301698836883275e-26,   6.578410985649835e-02,  -1.247892353961035e-03,   1.734740049803198e-05,  -2.084758027018131e-07,   2.226299027412573e-09,
  -2.195275452169564e-11,   1.772091667333058e-13,  -1.228332923881678e-15,   1.324095298190304e-17,   4.021826822572037e-19,   4.754507043531810e-21,  -2.828609732631629e-23,
  -5.461123180129117e-24,  -9.277915823003364e-26,   6.578443071293581e-02,  -1.247903916101783e-03,   1.734764738990885e-05,  -2.084798597259955e-07,   2.226348154605035e-09,
  -2.195323056275024e-11,   1.772160258313412e-13,  -1.228065477868254e-15,   1.324488881544076e-17,   4.021535652896452e-19,   4.747849304014881e-21,  -2.841948183648750e-23,
  -5.460488568637865e-24,  -9.269640737607665e-26,   6.578448162857362e-02,  -1.247905750861181e-03,   1.734768656841651e-05,  -2.084805035225498e-07,   2.226355950472262e-09,
  -2.195330610073059e-11,   1.772171143378210e-13,  -1.228023038470537e-15,   1.324551320842870e-17,   4.021489406812671e-19,   4.746792836249538e-21,  -2.844064447034858e-23,
  -5.460387819680899e-24,  -9.268327728884570e-26,   1.831782030735765e-01,  -3.379990479657472e-03,   4.371279599088295e-05,  -4.524140516638772e-07,   3.529277411768584e-09,
  -1.582505610088473e-11,  -1.570949132514583e-13,   4.361483129797024e-15,  -3.908614437005513e-17,   1.660892686096909e-18,   1.591781741598599e-20,  -1.459447272125121e-22,
  -1.428889743171932e-23,  -3.108842086507682e-25,   1.831823051228218e-01,  -3.380117772843780e-03,   4.371477995115117e-05,  -4.524288145961187e-07,   3.529055301778693e-09,
  -1.581638068848405e-11,  -1.571961941821715e-13,   4.367066452067719e-15,  -3.902181474327569e-17,   1.660054780437233e-18,   1.582992098340390e-20,  -1.481496937573720e-22,
  -1.427789597430889e-23,  -3.096411674718359e-25,   1.831895434044225e-01,  -3.380342387039869e-03,   4.371828057845332e-05,  -4.524548573830432e-07,   3.528663269924144e-09,
  -1.580106386100961e-11,  -1.573747704037364e-13,   4.376915950540982e-15,  -3.890860511760959e-17,   1.658567109235903e-18,   1.567488269203651e-20,  -1.520330393114900e-22,
  -1.425839254951542e-23,  -3.074505766103193e-25,   1.831982962696335e-01,  -3.380613998664506e-03,   4.372251340077302e-05,  -4.524863372741039e-07,   3.528189024354389e-09,
  -1.578252737295605e-11,  -1.575904759533995e-13,   4.388822025611190e-15,  -3.877222394674906e-17,   1.656752580821262e-18,   1.548750512198656e-20,  -1.567162966587045e-22,
  -1.423465358527476e-23,  -3.048064102676646e-25,   1.832067936695881e-01,  -3.380877680536439e-03,   4.372662236955578e-05,  -4.525168855419132e-07,   3.527728429364520e-09,
  -1.576451653990385e-11,  -1.577996381144670e-13,   4.400375980781404e-15,  -3.864036462795582e-17,   1.654974737252479e-18,   1.530570355592673e-20,  -1.612496194284291e-22,
  -1.421144599475957e-23,  -3.022444265144178e-25,   1.832136392578809e-01,  -3.381090103527492e-03,   4.372993237104234e-05,  -4.525414863234158e-07,   3.527357232812871e-09,
  -1.574999583467113e-11,  -1.579679641132305e-13,   4.409680631709452e-15,  -3.853452522862262e-17,   1.653530847546497e-18,   1.515931946554250e-20,  -1.648922275218222e-22,
  -1.419263426277248e-23,  -3.001840453809637e-25,   1.832181627953650e-01,  -3.381230470962841e-03,   4.373211949723366e-05,  -4.525577379152433e-07,   3.527111880700405e-09,
  -1.574039522450718e-11,  -1.580791067225824e-13,   4.415827472320898e-15,  -3.846477677541085e-17,   1.652571038738322e-18,   1.506262726685510e-20,  -1.672946104978011e-22,
  -1.418014710076261e-23,  -2.988243012603650e-25,   1.832204858775898e-01,  -3.381302557008771e-03,   4.373324267144169e-05,  -4.525660825964172e-07,   3.526985858378861e-09,
  -1.573546312424558e-11,  -1.581361577611143e-13,   4.418983701724844e-15,  -3.842901584166954e-17,   1.652076366060745e-18,   1.501298229199671e-20,  -1.685269312212488e-22,
  -1.417371682859201e-23,  -2.981265383039018e-25,   1.832212944522942e-01,  -3.381327647320920e-03,   4.373363359936742e-05,  -4.525689868339009e-07,   3.526941991610737e-09,
  -1.573374618656965e-11,  -1.581560107598345e-13,   4.420082181749867e-15,  -3.841657819124417e-17,   1.651903909870681e-18,   1.499570467245832e-20,  -1.689556260817381e-22,
  -1.417147592647481e-23,  -2.978837599254862e-25,   1.832214227621852e-01,  -3.381331628812833e-03,   4.373369563409606e-05,  -4.525694476866488e-07,   3.526935030390499e-09,
  -1.573347371915115e-11,  -1.581591609609424e-13,   4.420256491861092e-15,  -3.841460494747677e-17,   1.651876530119211e-18,   1.499296303619331e-20,  -1.690236433410939e-22,
  -1.417112019389782e-23,  -2.978452383459348e-25,   3.602756965604814e-01,  -6.342373116662066e-03,   7.165469234386437e-05,  -5.176920547811238e-07,   1.458388062258927e-10,
   5.917348039542844e-11,  -1.087611677045062e-12,   8.848930672009842e-15,   6.064420083021544e-17,   5.309585938171851e-19,   6.990272134833612e-20,  -4.716811614415999e-22,
  -3.319937960837676e-23,  -5.844179320846881e-25,   3.602824143218831e-01,  -6.342518521316664e-03,   7.165476575696602e-05,  -5.176364330219200e-07,   1.443113172693215e-10,
   5.919092895822419e-11,  -1.087446551789620e-12,   8.850654472249579e-15,   6.093251883592912e-17,   5.283671689507554e-19,   6.969787467516682e-20,  -4.757999858740794e-22,
  -3.318728797544532e-23,  -5.816043821414820e-25,   3.602942679223045e-01,  -6.342775077377193e-03,   7.165489459746360e-05,  -5.175382742438164e-07,   1.416162300470673e-10,
   5.922171994746080e-11,  -1.087154574356870e-12,   8.853688917756042e-15,   6.144055841933038e-17,   5.237774507121162e-19,   6.933648256935816e-20,  -4.830510788196471e-22,
  -3.316574824400462e-23,  -5.766464529426647e-25,   3.603086014306428e-01,  -6.343085285981999e-03,   7.165504920255431e-05,  -5.174195569062430e-07,   1.383576280507500e-10,
   5.925895738014262e-11,  -1.086800470796476e-12,   8.857345846860338e-15,   6.205368836953902e-17,   5.181983909366461e-19,   6.889959161488629e-20,  -4.917908362365230e-22,
  -3.313935515201111e-23,  -5.706625408448627e-25,   3.603225161608184e-01,  -6.343386408373237e-03,   7.165519804419560e-05,  -5.173042844028601e-07,   1.351945759110626e-10,
   5.929511168340868e-11,  -1.086455624028566e-12,   8.860882951747657e-15,   6.264765107978351e-17,   5.127518992291871e-19,   6.847557967881681e-20,  -5.002455964712686e-22,
  -3.311337052647392e-23,  -5.648652306617883e-25,   3.603337256924787e-01,  -6.343628972351712e-03,   7.165531705616800e-05,  -5.172114053428847e-07,   1.326467079046788e-10,
   5.932424058643360e-11,  -1.086177040499146e-12,   8.863723069656481e-15,   6.312524191604214e-17,   5.083425110769461e-19,   6.813408365682020e-20,  -5.070354248462553e-22,
  -3.309217830859231e-23,  -5.602034018325906e-25,   3.603411327542280e-01,  -6.343789246323991e-03,   7.165539525998486e-05,  -5.171500241756178e-07,   1.309632425701397e-10,
   5.934349014099603e-11,  -1.085992576194741e-12,   8.865595190279486e-15,   6.344038590225296e-17,   5.054182263425118e-19,   6.790846980606876e-20,  -5.115116439815076e-22,
  -3.307804809287026e-23,  -5.571270563335527e-25,   3.603449366357512e-01,  -6.343871552208430e-03,   7.165543528619122e-05,  -5.171184994302180e-07,   1.300987398586694e-10,
   5.935337623169143e-11,  -1.085897727115919e-12,   8.866555195330890e-15,   6.360209150134338e-17,   5.039131794929351e-19,   6.779261891970871e-20,  -5.138071890990401e-22,
  -3.307075238795883e-23,  -5.555484741684715e-25,   3.603462606116933e-01,  -6.343900199132137e-03,   7.165544919615601e-05,  -5.171075265432924e-07,   1.297978477127424e-10,
   5.935681725935756e-11,  -1.085864695273448e-12,   8.866889107839750e-15,   6.365835297886868e-17,   5.033888112315006e-19,   6.775229797188701e-20,  -5.146056641299579e-22,
  -3.306820682010992e-23,  -5.549992359524720e-25,   3.603464707084480e-01,  -6.343904744985734e-03,   7.165545140245409e-05,  -5.171057852777659e-07,   1.297501005551823e-10,
   5.935736330700930e-11,  -1.085859452684894e-12,   8.866942084420864e-15,   6.366727987334366e-17,   5.033055763918940e-19,   6.774589968849019e-20,  -5.147323468906357e-22,
  -3.306780257782526e-23,  -5.549120889866189e-25,   5.974867056767396e-01,  -9.741658086979660e-03,   8.466280945104093e-05,  -8.638706476522889e-08,  -1.009054131670623e-08,
   1.454126800262082e-10,  -4.704197094020999e-13,  -2.233999459331090e-14,   5.097107202406308e-16,   2.079162524474304e-18,   1.940337856033686e-20,   1.040552712109045e-21,
  -7.041678156869757e-23,  -1.415721019888086e-24,   5.974946313981021e-01,  -9.741681904495597e-03,   8.465712989665071e-05,  -8.625110936159733e-08,  -1.009118700204293e-08,
   1.453688121867761e-10,  -4.690803594340734e-13,  -2.233284929201238e-14,   5.097787079261521e-16,   2.084137377023079e-18,   1.897141477837413e-20,   1.030474250153439e-21,
  -7.033660649940739e-23,  -1.410739115686267e-24,   5.975086160250227e-01,  -9.741723899854693e-03,   8.464710794188108e-05,  -8.601124730989668e-08,  -1.009232479221574e-08,
   1.452914181920082e-10,  -4.667169186183353e-13,  -2.232022793100124e-14,   5.098971949980695e-16,   2.092873613278638e-18,   1.820961512886688e-20,   1.012720107226304e-21,
  -7.019477977775686e-23,  -1.401960052684515e-24,   5.975255256468150e-01,  -9.741774628200951e-03,   8.463498879020111e-05,  -8.572126049245222e-08,  -1.009369800836727e-08,
   1.451978521661074e-10,  -4.638587897578000e-13,  -2.230494333741745e-14,   5.100379512222835e-16,   2.103366086637628e-18,   1.728913444992174e-20,   9.913017958316331e-22,
  -7.002267486858351e-23,  -1.391364019946629e-24,   5.975419404415793e-01,  -9.741823819021467e-03,   8.462322320780287e-05,  -8.543980592723702e-08,  -1.009502836757076e-08,
   1.451070404514649e-10,  -4.610839286125880e-13,  -2.229008163802877e-14,   5.101719576475493e-16,   2.113477255827792e-18,   1.639627771649674e-20,   9.705617665810753e-22,
  -6.985496507217179e-23,  -1.381098144965401e-24,   5.975551634326519e-01,  -9.741863406831950e-03,   8.461374463567251e-05,  -8.521311249989920e-08,  -1.009609812774601e-08,
   1.450338984617838e-10,  -4.588483671688486e-13,  -2.227809234977719e-14,   5.102780227463763e-16,   2.121569205383400e-18,   1.567752806195968e-20,   9.538914405009178e-22,
  -6.971940773671092e-23,  -1.372842783145928e-24,   5.975639006782768e-01,  -9.741889546327938e-03,   8.460748118211685e-05,  -8.506333843134688e-08,  -1.009680404655842e-08,
   1.449855747635246e-10,  -4.573710658361011e-13,  -2.227016179714850e-14,   5.103471842502735e-16,   2.126890068369681e-18,   1.520284815733977e-20,   9.428943652408479e-22,
  -6.962961281864349e-23,  -1.367394963354505e-24,   5.975683875880589e-01,  -9.741902964203223e-03,   8.460426454278917e-05,  -8.498642874680900e-08,  -1.009716627285596e-08,
   1.449607604679343e-10,  -4.566123756747960e-13,  -2.226608653526991e-14,   5.103824161799782e-16,   2.129614504520993e-18,   1.495915690662387e-20,   9.372525212594942e-22,
  -6.958343058022773e-23,  -1.364599462677564e-24,   5.975699492847399e-01,  -9.741907633461366e-03,   8.460314495306525e-05,  -8.495966065615667e-08,  -1.009729230178600e-08,
   1.449521239811316e-10,  -4.563483026127759e-13,  -2.226466769864081e-14,   5.103946334807956e-16,   2.130561483452875e-18,   1.487435061479451e-20,   9.352897297959535e-22,
  -6.956734557317912e-23,  -1.363626815426150e-24,   5.975701971038611e-01,  -9.741908374362932e-03,   8.460296728917054e-05,  -8.495541297769316e-08,  -1.009731229859838e-08,
   1.449507535065231e-10,  -4.563063976649495e-13,  -2.226444252962044e-14,   5.103965700385159e-16,   2.130711694927468e-18,   1.486089362636569e-20,   9.349783047321200e-22,
  -6.956479258891054e-23,  -1.363472486423590e-24,   8.932523407899521e-01,  -1.281556202721828e-02,   5.814533209474605e-05,   1.012351619499023e-06,  -1.849299595790172e-08,
  -3.758947144587119e-11,   4.307763701276180e-12,  -3.986006414717031e-14,  -5.741156721627648e-16,   2.587987554844278e-17,   1.334331843339346e-19,  -5.677860800427953e-21,
  -4.280934938352271e-23,  -1.638841362187502e-24,   8.932577710913950e-01,  -1.281527743043019e-02,   5.813496388964023e-05,   1.012315732569795e-06,  -1.848695584659442e-08,
  -3.766657056112254e-11,   4.306268066798087e-12,  -3.977349601081153e-14,  -5.735615944146655e-16,   2.585016257268427e-17,   1.331595277165897e-19,  -5.689183557096085e-21,
  -4.300078214593989e-23,  -1.626793435449651e-24,   8.932673521576717e-01,  -1.281477526323062e-02,   5.811667178641837e-05,   1.012252351176554e-06,  -1.847629968046774e-08,
  -3.780247498723662e-11,   4.303630173282380e-12,  -3.962082701774018e-14,  -5.725848617512943e-16,   2.579768676769408e-17,   1.326757090065414e-19,  -5.709091713153770e-21,
  -4.333714651732084e-23,  -1.605579221576354e-24,   8.932789363452511e-01,  -1.281416805146600e-02,   5.809455748149840e-05,   1.012175610312495e-06,  -1.846341703728394e-08,
  -3.796657656038357e-11,   4.300442409835320e-12,  -3.943635768043156e-14,  -5.714054017989558e-16,   2.573415288261586e-17,   1.320890598976782e-19,  -5.733043942746873e-21,
  -4.374146136652822e-23,  -1.580002557730734e-24,   8.932901806708420e-01,  -1.281357859565482e-02,   5.807309422001448e-05,   1.012101007604640e-06,  -1.845091383303089e-08,
  -3.812563701707650e-11,   4.297349882704716e-12,  -3.925742438185974e-14,  -5.702620971600313e-16,   2.567239220902847e-17,   1.315178709654141e-19,  -5.756169950275308e-21,
  -4.413143311246181e-23,  -1.555252340117853e-24,   8.932992379480627e-01,  -1.281310374837332e-02,   5.805580722246349e-05,   1.012040834178484e-06,  -1.844084359357550e-08,
  -3.825359751003151e-11,   4.294860085338175e-12,  -3.911338297426267e-14,  -5.693422820057492e-16,   2.562257927080704e-17,   1.310565291571988e-19,  -5.774709555913510e-21,
  -4.444377973839150e-23,  -1.535370465802842e-24,   8.933052223433573e-01,  -1.281278998296869e-02,   5.804438600904903e-05,   1.012001036221427e-06,  -1.843419042544380e-08,
  -3.833806511709871e-11,   4.293215606638377e-12,  -3.901825438646811e-14,  -5.687350808132296e-16,   2.558963478627761e-17,   1.307510971995215e-19,  -5.786915997331336e-21,
  -4.464928814366871e-23,  -1.522260522680319e-24,   8.933082954644953e-01,  -1.281262885103528e-02,   5.803852120340466e-05,   1.011980586805769e-06,  -1.843077403508335e-08,
  -3.838141655972368e-11,   4.292371315352255e-12,  -3.896941721009697e-14,  -5.684234385200731e-16,   2.557270726972208e-17,   1.305940625765031e-19,  -5.793170933745990e-21,
  -4.475455322775439e-23,  -1.515536476914924e-24,   8.933093650682226e-01,  -1.281257276784743e-02,   5.803647998909042e-05,   1.011973467407195e-06,  -1.842958498163313e-08,
  -3.839650117384993e-11,   4.292077488201113e-12,  -3.895242151634786e-14,  -5.683149979652573e-16,   2.556681406951848e-17,   1.305393765038868e-19,  -5.795345848934887e-21,
  -4.479114821703708e-23,  -1.513197469273181e-24,   8.933095347984531e-01,  -1.281256386823011e-02,   5.803615608052592e-05,   1.011972337571621e-06,  -1.842939629771878e-08,
  -3.839889469249637e-11,   4.292030863595453e-12,  -3.894972465406726e-14,  -5.682977913386588e-16,   2.556587883228003e-17,   1.305306972138906e-19,  -5.795690874901122e-21,
  -4.479695327386447e-23,  -1.512826365423531e-24,   1.239243737623736e+00,  -1.412192622110757e-02,  -3.168734226358703e-05,   2.025672147375798e-06,   4.402181708195289e-09,
  -5.569221357369385e-10,  -4.861539587769406e-13,   1.765097612576738e-13,  -1.842070153786973e-16,  -5.112482834821419e-17,   6.448034248887198e-19,   2.398629369642455e-20,
  -4.188036341305338e-22,  -1.438208977156718e-23,   1.239240771904193e+00,  -1.412135833015024e-02,  -3.168486993101454e-05,   2.025152930359167e-06,   4.401493062755901e-09,
  -5.565773210677990e-10,  -4.865832532535867e-13,   1.763403208707567e-13,  -1.815683552463423e-16,  -5.100509675399228e-17,   6.422584074059869e-19,   2.388434048621698e-20,
  -4.178009160309592e-22,  -1.432350660232812e-23,   1.239235539033298e+00,  -1.412035639582693e-02,  -3.168050777730316e-05,   2.024237025740130e-06,   4.400277467462794e-09,
  -5.559691598337917e-10,  -4.873351682423948e-13,   1.760416662766700e-13,  -1.769210862703296e-16,  -5.079425258173104e-17,   6.377727055038045e-19,   2.370478785678342e-20,
  -4.160336493438940e-22,  -1.422034855030517e-23,   1.239229211710258e+00,  -1.411914504764610e-02,  -3.167523355338355e-05,   2.023129950637847e-06,   4.398806760307185e-09,
  -5.552342242340833e-10,  -4.882348869869311e-13,   1.756810843909399e-13,  -1.713163615472742e-16,  -5.054001971040683e-17,   6.323571018687453e-19,   2.348825899664710e-20,
  -4.139001334679978e-22,  -1.409597100652990e-23,   1.239223069590031e+00,  -1.411796930276576e-02,  -3.167011399266395e-05,   2.022055688735271e-06,   4.397378194869125e-09,
  -5.545212421681328e-10,  -4.890983810809640e-13,   1.753316173315791e-13,  -1.658908779157834e-16,  -5.029396981450944e-17,   6.271086774094143e-19,   2.327867127967121e-20,
  -4.118325926111075e-22,  -1.397560593234380e-23,   1.239218121818187e+00,  -1.411702228909900e-02,  -3.166599014575652e-05,   2.021190612112281e-06,   4.396226771485285e-09,
  -5.539472171839220e-10,  -4.897868920332531e-13,   1.750505057780977e-13,  -1.615312640344698e-16,  -5.009629526891166e-17,   6.228870211269013e-19,   2.311026983555705e-20,
  -4.101696114468594e-22,  -1.387891196376046e-23,   1.239214852536362e+00,  -1.411639659331533e-02,  -3.166326537935089e-05,   2.020619148764520e-06,   4.395465644289422e-09,
  -5.535680800504682e-10,  -4.902383718040677e-13,   1.748649549662738e-13,  -1.586559321786194e-16,  -4.996593951655831e-17,   6.201005599730196e-19,   2.299920813613997e-20,
  -4.090720156234004e-22,  -1.381515054064446e-23,   1.239213173640103e+00,  -1.411607529146684e-02,  -3.166186614272184e-05,   2.020325725660640e-06,   4.395074680590780e-09,
  -5.533734270279271e-10,  -4.904691542608708e-13,   1.747697283702545e-13,  -1.571809879987015e-16,  -4.989907718917936e-17,   6.186705475556797e-19,   2.294223905603500e-20,
  -4.085087407735914e-22,  -1.378244683885853e-23,   1.239212589290678e+00,  -1.411596346305751e-02,  -3.166137913535854e-05,   2.020223605127813e-06,   4.394938588041137e-09,
  -5.533056845427091e-10,  -4.905493093118418e-13,   1.747365938458595e-13,  -1.566678869593845e-16,  -4.987581812609989e-17,   6.181729728104256e-19,   2.292242101372021e-20,
  -4.083127503530891e-22,  -1.377107051299582e-23,   1.239212496562748e+00,  -1.411594571760194e-02,  -3.166130185446049e-05,   2.020207400388560e-06,   4.394916991361219e-09,
  -5.532949351363879e-10,  -4.905620207032556e-13,   1.747313363261076e-13,  -1.565864775547357e-16,  -4.987212784929256e-17,   6.180940218691591e-19,   2.291927666490876e-20,
  -4.082816523412624e-22,  -1.376926555509886e-23,   1.606359541084949e+00,  -1.134087108764024e-02,  -1.511203803076778e-04,   2.411120255481743e-07,   4.570933527185616e-08,
   4.680163859115712e-10,  -1.277535906533632e-11,  -3.758298688894898e-13,   1.109425013611736e-15,   2.112786318084265e-16,   2.821800137855040e-18,  -6.114310714753696e-20,
  -2.373725884968051e-21,  -7.218220380761240e-24,   1.606345424985784e+00,  -1.134080175242212e-02,  -1.510947700318888e-04,   2.415446742121335e-07,   4.569140754102305e-08,
   4.672876644435148e-10,  -1.277221180567318e-11,  -3.751250724173184e-13,   1.120871965363731e-15,   2.109617211824720e-16,   2.807509892719888e-18,  -6.118672702782420e-20,
  -2.365125401900749e-21,  -7.050382141486016e-24,   1.606320518846290e+00,  -1.134067931146839e-02,  -1.510495884863023e-04,   2.423075376146837e-07,   4.565977746757674e-08,
   4.660029479505400e-10,  -1.276663426353395e-11,  -3.738823186773718e-13,   1.141021626906438e-15,   2.104023538374289e-16,   2.782337571135620e-18,  -6.126271369354048e-20,
  -2.349969883888349e-21,  -6.755456342791486e-24,   1.606290405382970e+00,  -1.134053108776683e-02,  -1.509949684402550e-04,   2.432290596194752e-07,   4.562153635468026e-08,
   4.644513706011063e-10,  -1.275984872796338e-11,  -3.723810525464937e-13,   1.165303936001960e-15,   2.097256677241647e-16,   2.751972249382488e-18,  -6.135292934383164e-20,
  -2.331678084336314e-21,  -6.400916612557743e-24,   1.606261175216207e+00,  -1.134038702020903e-02,  -1.509419588639679e-04,   2.441226730176428e-07,   4.558441917572741e-08,
   4.629471309048077e-10,  -1.275321848561483e-11,  -3.709252048182617e-13,   1.188790121950211e-15,   2.090684491364405e-16,   2.722570810123507e-18,  -6.143876849019072e-20,
  -2.313956790773328e-21,  -6.058915232234488e-24,   1.606237630254225e+00,  -1.134027083626734e-02,  -1.508992655120063e-04,   2.448418516909377e-07,   4.555452282728705e-08,
   4.617367704942459e-10,  -1.274784653011339e-11,  -3.697535075704908e-13,   1.207648287298967e-15,   2.085387874871303e-16,   2.698940278040929e-18,  -6.150667666799045e-20,
  -2.299706611181002e-21,  -5.784960460003186e-24,   1.606222073377018e+00,  -1.134019400282064e-02,  -1.508710596331651e-04,   2.453167273387397e-07,   4.553477019424474e-08,
   4.609376884216127e-10,  -1.274428182265545e-11,  -3.689798168248645e-13,   1.220079106380308e-15,   2.081886922897851e-16,   2.683352491247171e-18,  -6.155094250291246e-20,
  -2.290303018405096e-21,  -5.604696556961137e-24,   1.606214084551683e+00,  -1.134015452625931e-02,  -1.508565761504365e-04,   2.455604921160309e-07,   4.552462699759726e-08,
   4.605275387309552e-10,  -1.274244653675404e-11,  -3.685826584625595e-13,   1.226453557613732e-15,   2.080088696392144e-16,   2.675355714424218e-18,  -6.157348788711769e-20,
  -2.285477744270399e-21,  -5.512357221524259e-24,   1.606211304027640e+00,  -1.134014078307070e-02,  -1.508515352940678e-04,   2.456453197138734e-07,   4.552109668075211e-08,
   4.603848169451726e-10,  -1.274180701078972e-11,  -3.684444507415896e-13,   1.228670752850489e-15,   2.079462756410809e-16,   2.672573683518216e-18,  -6.158130523956888e-20,
  -2.283798887755455e-21,  -5.480255016029800e-24,   1.606210862799605e+00,  -1.134013860207306e-02,  -1.508507353915695e-04,   2.456587798800722e-07,   4.552053647358137e-08,
   4.603621706043887e-10,  -1.274170549180620e-11,  -3.684225203560190e-13,   1.229022520435370e-15,   2.079363425949595e-16,   2.672132276206924e-18,  -6.158254433290913e-20,
  -2.283532505990545e-21,  -5.475162610351787e-24,   1.909511587270300e+00,  -3.700149796461907e-03,  -1.039653065447311e-04,  -2.274459731644070e-06,  -3.696602345105901e-08,
  -2.969898834527439e-10,   6.547373682501225e-12,   3.662001504717577e-13,   9.401787896164588e-15,   1.401013243550081e-16,   5.083371191578296e-20,  -6.923138970159577e-20,
  -2.382681340229295e-21,  -4.623016489167991e-23,   1.909501798909804e+00,  -3.700790444770542e-03,  -1.039860461145023e-04,  -2.274732028489030e-06,  -3.695652446100321e-08,
  -2.962615832093825e-10,   6.572046407390185e-12,   3.666632995474062e-13,   9.401523544911481e-15,   1.397314803910250e-16,   3.596194883985689e-20,  -6.956316344232794e-20,
  -2.385528280318166e-21,  -4.611825320884409e-23,   1.909484525619198e+00,  -3.701920940000155e-03,  -1.040226369994078e-04,  -2.275211943203897e-06,  -3.693973513870985e-08,
  -2.949757494362225e-10,   6.615580964318462e-12,   3.674795091383220e-13,   9.401005973517567e-15,   1.390775006090538e-16,   9.706651230357738e-21,  -7.014789989279494e-20,
  -2.390508044654267e-21,  -4.591943207322001e-23,   1.909463635887192e+00,  -3.703288051191920e-03,  -1.040668755563547e-04,  -2.275791310491800e-06,  -3.691938521995928e-08,
  -2.934196507738378e-10,   6.668221884260323e-12,   3.684647294901992e-13,   9.400292925931813e-15,   1.382843429318274e-16,  -2.206497841666829e-20,  -7.085379847872451e-20,
  -2.396455002094641e-21,  -4.567671242385524e-23,   1.909443353686139e+00,  -3.704615328162455e-03,  -1.041098136829258e-04,  -2.276352754161633e-06,  -3.689957951196009e-08,
  -2.919077046366408e-10,   6.719323078897997e-12,   3.694193295038150e-13,   9.399509361812871e-15,   1.375118921102937e-16,  -5.293268290587515e-20,  -7.153783936036096e-20,
  -2.402149924633045e-21,  -4.543867389509472e-23,   1.909427012595000e+00,  -3.705684643313337e-03,  -1.041443984119441e-04,  -2.276804331860985e-06,  -3.688358820983248e-08,
  -2.906887611138917e-10,   6.760488251913350e-12,   3.701870258671189e-13,   9.398812652556707e-15,   1.368878499252102e-16,  -7.781661917816562e-20,  -7.208800524189015e-20,
  -2.406681499268405e-21,  -4.524518689708714e-23,   1.909416213707191e+00,  -3.706391265916076e-03,  -1.041672486066825e-04,  -2.277102376618706e-06,  -3.687300377622395e-08,
  -2.898828454167679e-10,   6.787688808625735e-12,   3.706936601729688e-13,   9.398320207271140e-15,   1.364746300906998e-16,  -9.426790375246192e-20,  -7.245110800076276e-20,
  -2.409648337985441e-21,  -4.511648926679831e-23,   1.909410667656716e+00,  -3.706754162240196e-03,  -1.041789824151883e-04,  -2.277255328672451e-06,  -3.686756269980833e-08,
  -2.894688271180101e-10,   6.801657387236047e-12,   3.709536412184425e-13,   9.398057392008256e-15,   1.362621549285670e-16,  -1.027190186171312e-19,  -7.263744305321877e-20,
  -2.411163425101630e-21,  -4.505013566803875e-23,   1.909408737254524e+00,  -3.706880473508188e-03,  -1.041830663377461e-04,  -2.277308547808789e-06,  -3.686566801357419e-08,
  -2.893247016546576e-10,   6.806519245190623e-12,   3.710440981580515e-13,   9.397964337090807e-15,   1.361881585089275e-16,  -1.056609183126302e-19,  -7.270227705102288e-20,
  -2.411689406906352e-21,  -4.502699911253749e-23,   1.909408430923978e+00,  -3.706900517456023e-03,  -1.041837143935087e-04,  -2.277316992134921e-06,  -3.686536731167268e-08,
  -2.893018298556726e-10,   6.807290753476665e-12,   3.710584509164695e-13,   9.397949495561095e-15,   1.361764142791948e-16,  -1.061277768048717e-19,  -7.271256428625780e-20,
  -2.411772808485149e-21,  -4.502332568612512e-23,   6.766697369966512e-03,  -1.252251197703629e-04,   1.730088169914950e-06,  -2.130925619127160e-08,   2.414146823293525e-10,
  -2.711925927074675e-12,   2.820913566516327e-14,  -2.329247640783786e-16,   5.611556737186979e-18,   2.408125016744956e-20,   1.261826143841309e-24,  -4.538964792494891e-23,
  -8.949886412875467e-25,  -5.016928505896946e-29,   6.766859838473254e-03,  -1.252311219565587e-04,   1.730224190403425e-06,  -2.131180246129796e-08,   2.414545254936693e-10,
  -2.712383314702099e-12,   2.822386198963082e-14,  -2.328495875462931e-16,   5.611389256092314e-18,   2.384732162593363e-20,  -4.134582743302287e-24,  -4.538722171627621e-23,
  -8.919371773758561e-25,   4.481934129121236e-31,   6.767146527107897e-03,  -1.252417134915774e-04,   1.730464218960697e-06,  -2.131629574314229e-08,   2.415248462195882e-10,
  -2.713190265055261e-12,   2.824984635934027e-14,  -2.327175791522824e-16,   5.611075348363248e-18,   2.343456406103711e-20,  -1.364129315098882e-23,  -4.538263971265105e-23,
  -8.865539364681805e-25,   8.976292293113716e-29,   6.767493211799501e-03,  -1.252545218830952e-04,   1.730754495206293e-06,  -2.132172966142236e-08,   2.416099074985298e-10,
  -2.714165838722842e-12,   2.828126612321540e-14,  -2.325590474513353e-16,   5.610664456344844e-18,   2.293547627891979e-20,  -2.511076012950207e-23,  -4.537658601067393e-23,
  -8.800463400315708e-25,   1.977625663494174e-28,   6.767829785866472e-03,  -1.252669570890627e-04,   1.731036322987098e-06,  -2.132700543704216e-08,   2.416925135756144e-10,
  -2.715112700922558e-12,   2.831176700000802e-14,  -2.324062934816309e-16,   5.610232826403747e-18,   2.245099576618670e-20,  -3.621774200495965e-23,  -4.537017187328860e-23,
  -8.737308101774502e-25,   3.026064823333165e-28,   6.768100938863763e-03,  -1.252769754753416e-04,   1.731263383163710e-06,  -2.133125597874878e-08,   2.417590814944952e-10,
  -2.715875332521066e-12,   2.833633745080471e-14,  -2.322840578494262e-16,   5.609861683020278e-18,   2.206072344641041e-20,  -4.514576907426181e-23,  -4.536461974673633e-23,
  -8.686444630613224e-25,   3.870674946052560e-28,   6.768280118449277e-03,  -1.252835958118382e-04,   1.731413431933600e-06,  -2.133406487908399e-08,   2.418030789345702e-10,
  -2.716379193551208e-12,   2.835257283468663e-14,  -2.322036886835728e-16,   5.609604980227009e-18,   2.180284800824511e-20,  -5.103564852184018e-23,  -4.536076250277544e-23,
  -8.652841530210382e-25,   4.428780072383529e-28,   6.768372137754868e-03,  -1.252869957843820e-04,   1.731490492697974e-06,  -2.133550745125080e-08,   2.418256769863967e-10,
  -2.716637927980342e-12,   2.836091037631542e-14,  -2.321625395795870e-16,   5.609469610397912e-18,   2.167041965472654e-20,  -5.405741426932466e-23,  -4.535872332860190e-23,
  -8.635586744301660e-25,   4.715394576131159e-28,   6.768404166237664e-03,  -1.252881791939490e-04,   1.731517314966557e-06,  -2.133600956244085e-08,   2.418335429644576e-10,
  -2.716727979319498e-12,   2.836381231715970e-14,  -2.321482370469335e-16,   5.609421930259016e-18,   2.162432724073939e-20,  -5.510869483870430e-23,  -4.535800429471977e-23,
  -8.629581376954045e-25,   4.815153531874911e-28,   6.768409248732009e-03,  -1.252883669856030e-04,   1.731521571317947e-06,  -2.133608924108123e-08,   2.418347912114907e-10,
  -2.716742269058462e-12,   2.836427281440078e-14,  -2.321459683714625e-16,   5.609414337334772e-18,   2.161701303268426e-20,  -5.527549614780788e-23,  -4.535788975336273e-23,
  -8.628628422967723e-25,   4.830983911971500e-28,   6.104051654569336e-02,  -1.118035549287914e-03,   1.503505015338972e-05,  -1.759726113268602e-07,   1.825106454712005e-09,
  -1.803897980982275e-11,   1.503337394884659e-13,  -5.605600214306842e-16,   3.018313623111434e-17,   4.951619588361710e-19,  -3.181399907304394e-21,  -3.816180983683766e-22,
  -8.656989014356925e-24,   3.265245474240521e-27,   6.104192814219956e-02,  -1.118085101089498e-03,   1.503607797284704e-05,  -1.759895318751378e-07,   1.825318793841785e-09,
  -1.804005775790281e-11,   1.504126532174878e-13,  -5.589400838714974e-16,   3.016804052554288e-17,   4.931963380464506e-19,  -3.233670862814158e-21,  -3.815683317427180e-22,
  -8.629045620198897e-24,   3.734458122476202e-27,   6.104441900496201e-02,  -1.118172539894819e-03,   1.503789167380165e-05,  -1.760193892629555e-07,   1.825693559676563e-09,
  -1.804195724664453e-11,   1.505518645074828e-13,  -5.560870703289890e-16,   3.014122577059910e-17,   4.897282043407438e-19,  -3.325763344348990e-21,  -3.814777285499926e-22,
  -8.579750511209015e-24,   4.562365828727513e-27,   6.104743111671750e-02,  -1.118278278434490e-03,   1.504008498639761e-05,  -1.760554945222609e-07,   1.826146884129237e-09,
  -1.804424975665747e-11,   1.507201433739311e-13,  -5.526463688043133e-16,   3.010849766009752e-17,   4.855349088807434e-19,  -3.436883130112731e-21,  -3.813634144627528e-22,
  -8.520161623089283e-24,   5.563440841386211e-27,   6.105035536288459e-02,  -1.118380934492225e-03,   1.504221439019347e-05,  -1.760905463337190e-07,   1.826587124476249e-09,
  -1.804647071484758e-11,   1.508834456554914e-13,  -5.493158214604895e-16,   3.007640845676406e-17,   4.814645686198031e-19,  -3.544505617228145e-21,  -3.812474602537251e-22,
  -8.462333653463046e-24,   6.535229788349573e-27,   6.105271119803704e-02,  -1.118463637831169e-03,   1.504392993481989e-05,  -1.761187846554425e-07,   1.826941891574313e-09,
  -1.804825662020286e-11,   1.510149566780921e-13,  -5.466396724879662e-16,   3.005033074958436e-17,   4.781858767433446e-19,  -3.631025317299901e-21,  -3.811504809045486e-22,
  -8.415762232546161e-24,   7.318066599496833e-27,   6.105426794113240e-02,  -1.118518289149817e-03,   1.504506359717560e-05,  -1.761374445432657e-07,   1.827176371747823e-09,
  -1.804943511587037e-11,   1.511018355871135e-13,  -5.448746975270444e-16,   3.003298800919950e-17,   4.760195357863191e-19,  -3.688108082051426e-21,  -3.810846516401940e-22,
  -8.384995455694912e-24,   7.835340808528224e-27,   6.105506741841352e-02,  -1.118546355967057e-03,   1.504564580591466e-05,  -1.761470274454691e-07,   1.827296805974988e-09,
  -1.805003983580548e-11,   1.511464454777280e-13,  -5.439693426417110e-16,   3.002404736259497e-17,   4.749070662208127e-19,  -3.717395628370083e-21,  -3.810503048796485e-22,
  -8.369197324838989e-24,   8.100982900682805e-27,   6.105534568622475e-02,  -1.118556124999250e-03,   1.504584845200321e-05,  -1.761503628873182e-07,   1.827338726986719e-09,
  -1.805025023551531e-11,   1.511619713083744e-13,  -5.436543918187577e-16,   3.002093002721230e-17,   4.745198690433967e-19,  -3.727585099484756e-21,  -3.810382641615915e-22,
  -8.363698970431603e-24,   8.193441614023267e-27,   6.105538984360902e-02,  -1.118557675215787e-03,   1.504588060928925e-05,  -1.761508921771889e-07,   1.827345379405720e-09,
  -1.805028361932095e-11,   1.511644349939751e-13,  -5.436044213524221e-16,   3.002043508979243e-17,   4.744584265668317e-19,  -3.729201822779139e-21,  -3.810363493821272e-22,
  -8.362826472931612e-24,   8.208113517580830e-27,   1.703245845175374e-01,  -3.051069209353556e-03,   3.861163884973678e-05,  -3.986427487470597e-07,   3.184483618593537e-09,
  -1.821213648594719e-11,  -4.276084024441855e-14,   4.163431072237860e-15,   2.838888522517091e-17,   1.915197194577629e-18,  -1.055174001698625e-20,  -1.142508478781677e-21,
  -2.458988227925868e-23,  -3.884340684710043e-27,   1.703282079467729e-01,  -3.051181387284991e-03,   3.861342978420179e-05,  -3.986597527356337e-07,   3.184424353714668e-09,
  -1.820383971824532e-11,  -4.268735139401184e-14,   4.169741352324484e-15,   2.833962198643678e-17,   1.909308409364593e-18,  -1.070001633728817e-20,  -1.142462016782961e-21,
  -2.450623633899812e-23,  -2.527312520534168e-27,   1.703346016812221e-01,  -3.051379330888646e-03,   3.861658988938868e-05,  -3.986897501870128e-07,   3.184319863508653e-09,
  -1.818918991628696e-11,  -4.255778716378911e-14,   4.180859784749816e-15,   2.825219106272643e-17,   1.898917826534854e-18,  -1.096123189738191e-20,  -1.142371968797165e-21,
  -2.435868144642964e-23,  -1.330145770199005e-28,   1.703423332860786e-01,  -3.051618693021976e-03,   3.862041107658802e-05,  -3.987260125865082e-07,   3.184193655302225e-09,
  -1.817145814377500e-11,  -4.240130160024691e-14,   4.194276765212302e-15,   2.814560829570733e-17,   1.886353908529551e-18,  -1.127637996190028e-20,  -1.142249330942903e-21,
  -2.418032344411373e-23,   2.761867182082777e-27,   1.703498392380729e-01,  -3.051851068561314e-03,   3.862412057109379e-05,  -3.987612041388907e-07,   3.184071283639535e-09,
  -1.815422658730047e-11,  -4.224958267384824e-14,   4.207272891627910e-15,   2.804123988898051e-17,   1.874157612649057e-18,  -1.158157001798554e-20,  -1.142115877364671e-21,
  -2.400724578203850e-23,   5.571838292786063e-27,   1.703558861100950e-01,  -3.052038272233812e-03,   3.862710885734412e-05,  -3.987895458536864e-07,   3.183972809356033e-09,
  -1.814033228975162e-11,  -4.212749993406682e-14,   4.217721734601964e-15,   2.795651831221428e-17,   1.864332841764353e-18,  -1.182688973843578e-20,  -1.141998052771071e-21,
  -2.386786560954745e-23,   7.835288077510597e-27,   1.703598818609475e-01,  -3.052161975513864e-03,   3.862908344688776e-05,  -3.988082695654408e-07,   3.183907791533104e-09,
  -1.813114493457673e-11,  -4.204689867492166e-14,   4.224616024803846e-15,   2.790022096678231e-17,   1.857841015610058e-18,  -1.198872955132122e-20,  -1.141915145570161e-21,
  -2.377578938008725e-23,   9.330828524747718e-27,   1.703619338966544e-01,  -3.052225503818017e-03,   3.863009748791291e-05,  -3.988178838534446e-07,   3.183874417915679e-09,
  -1.812642485632587e-11,  -4.200552741797116e-14,   4.228153443330559e-15,   2.787121229633019e-17,   1.854507218197035e-18,  -1.207176068646248e-20,  -1.141871006796608e-21,
  -2.372851110701293e-23,   1.009882790445427e-26,   1.703626481306857e-01,  -3.052247615545583e-03,   3.863045043335255e-05,  -3.988212299979584e-07,   3.183862804492311e-09,
  -1.812478168244711e-11,  -4.199113117651897e-14,   4.229384176047992e-15,   2.786110008104510e-17,   1.853346870134615e-18,  -1.210064748287141e-20,  -1.141855395230692e-21,
  -2.371205662466458e-23,   1.036613207030868e-26,   1.703627614699898e-01,  -3.052251124377894e-03,   3.863050644089379e-05,  -3.988217609756810e-07,   3.183860961723951e-09,
  -1.812452091879104e-11,  -4.198884685294119e-14,   4.229579452729437e-15,   2.785949467690890e-17,   1.853162739386848e-18,  -1.210523080483841e-20,  -1.141852906085497e-21,
  -2.370944557959574e-23,   1.040854932175497e-26,   3.360134980844969e-01,  -5.793863963345993e-03,   6.549108916702179e-05,  -5.072205317087680e-07,   1.089624605311456e-09,
   3.629870054915429e-11,  -8.063433189931029e-13,   1.156216049715146e-14,   1.200714188089424e-16,   2.343947756904014e-18,   4.665591494266440e-21,  -2.654882781992252e-21,
  -5.252384453489706e-23,   2.383505576666909e-26,   3.360196390795002e-01,  -5.794006498255648e-03,   6.549169570217122e-05,  -5.071863092375744e-07,   1.088494416775915e-09,
   3.632158287091070e-11,  -8.060279660209349e-13,   1.156971488473786e-14,   1.200809527037709e-16,   2.330272699658587e-18,   4.348687021243143e-21,  -2.654544566054231e-21,
  -5.234917283357461e-23,   2.680711559885712e-26,   3.360304750074251e-01,  -5.794257995491105e-03,   6.549276542702768e-05,  -5.071259056706886e-07,   1.086500541886131e-09,
   3.636197100418938e-11,  -8.054715065205033e-13,   1.158300720886742e-14,   1.200966955792776e-16,   2.306144431382014e-18,   3.790381514026153e-21,  -2.653930122597352e-21,
  -5.204107588744493e-23,   3.205037606763073e-26,   3.360435780050322e-01,  -5.794562095239304e-03,   6.549405807011789e-05,  -5.070528352244972e-07,   1.084090141858964e-09,
   3.641082904410460e-11,  -8.047986070717179e-13,   1.159901647199285e-14,   1.201138928884648e-16,   2.276971025428170e-18,   3.116768221836729e-21,  -2.653157029660756e-21,
  -5.166871456317952e-23,   3.838893050760232e-26,   3.360562982497174e-01,  -5.794857295979202e-03,   6.549531202465242e-05,  -5.069818684780043e-07,   1.081750811050065e-09,
   3.645828076559768e-11,  -8.041453461925103e-13,   1.161449101623533e-14,   1.201286644322063e-16,   2.248652936377571e-18,   2.464401886620278e-21,  -2.652375007369647e-21,
  -5.130743247099578e-23,   4.454059575532678e-26,   3.360665455717325e-01,  -5.795095095800271e-03,   6.549632153432561e-05,  -5.069246762138171e-07,   1.079866737867085e-09,
   3.649652239526124e-11,  -8.036190735561114e-13,   1.162690912608843e-14,   1.201391880052086e-16,   2.225842410234098e-18,   1.939985592654774e-21,  -2.651722441844043e-21,
  -5.101653005191346e-23,   4.949510915182680e-26,   3.360733168481161e-01,  -5.795252224761107e-03,   6.549698827732292e-05,  -5.068868736263279e-07,   1.078622001735218e-09,
   3.652179918087518e-11,  -8.032713156054338e-13,   1.163509129992091e-14,   1.201454687226895e-16,   2.210770695987474e-18,   1.594009648097001e-21,  -2.651280184439427e-21,
  -5.082437573154110e-23,   5.276839174661197e-26,   3.360767942313587e-01,  -5.795332916477629e-03,   6.549733058186913e-05,  -5.068674567994811e-07,   1.077982840023926e-09,
   3.653478230445087e-11,  -8.030927234100746e-13,   1.163928597284623e-14,   1.201484861771472e-16,   2.203030985964274e-18,   1.416504200742148e-21,  -2.651049645911433e-21,
  -5.072571645201958e-23,   5.444920435259857e-26,   3.360780045678461e-01,  -5.795361001726000e-03,   6.549744970820007e-05,  -5.068606980554467e-07,   1.077760385057430e-09,
   3.653930156295348e-11,  -8.030305624775494e-13,   1.164074481062228e-14,   1.201495033309748e-16,   2.200337162916507e-18,   1.354748826828817e-21,  -2.650968860709804e-21,
  -5.069138054371241e-23,   5.503419896144755e-26,   3.360781966316443e-01,  -5.795365458456607e-03,   6.549746861115329e-05,  -5.068596255102323e-07,   1.077725085045870e-09,
   3.654001872428583e-11,  -8.030206983804149e-13,   1.164097625318118e-14,   1.201496631682555e-16,   2.199909692864835e-18,   1.344950382296940e-21,  -2.650956015378538e-21,
  -5.068593206711202e-23,   5.512702824222798e-26,   5.598645233585801e-01,  -9.071030693772150e-03,   8.275095879807634e-05,  -2.253616936076359e-07,  -7.336013541321449e-09,
   1.285349715067274e-10,  -8.550856809834214e-13,  -4.661733469239114e-15,   5.987586321700498e-16,   2.544779934393189e-18,  -3.106869800107153e-20,  -3.698140775441973e-21,
  -1.144399824721445e-22,   4.319937480674977e-26,   5.598722729484956e-01,  -9.071093652463377e-03,   8.274682562584975e-05,  -2.252412682749052e-07,  -7.337197459340164e-09,
   1.285259213421249e-10,  -8.535171740905047e-13,  -4.653641181331561e-15,   5.986054202715956e-16,   2.525736157645477e-18,  -3.175993385369202e-20,  -3.697548470967907e-21,
  -1.140757299008857e-22,   4.821278886918173e-26,   5.598859469062046e-01,  -9.071204716543215e-03,   8.273953204126893e-05,  -2.250287827366528e-07,  -7.339284709388240e-09,
   1.285099648920599e-10,  -8.507498593218603e-13,  -4.639414446589727e-15,   5.983327194346382e-16,   2.492135879492977e-18,  -3.297780104831348e-20,  -3.696473574513874e-21,
  -1.134332735985439e-22,   5.705607786164322e-26,   5.599024810637970e-01,  -9.071338969490219e-03,   8.273071164551356e-05,  -2.247718546367454e-07,  -7.341805579348940e-09,
   1.284906917926837e-10,  -8.474041764367415e-13,  -4.622300385694618e-15,   5.979989537311098e-16,   2.451510864963280e-18,  -3.444734081461064e-20,  -3.695123056435599e-21,
  -1.126568710230031e-22,   6.774450291303810e-26,   5.599185315741830e-01,  -9.071469250789211e-03,   8.272214800016243e-05,  -2.245224455110667e-07,  -7.344249597354071e-09,
   1.284720043587133e-10,  -8.441568610228093e-13,  -4.605779605931220e-15,   5.976707429312548e-16,   2.412077940406954e-18,  -3.587068034307401e-20,  -3.693758875084138e-21,
  -1.119036330527273e-22,   7.811552138348898e-26,   5.599314612527841e-01,  -9.071574168503181e-03,   8.271524855305165e-05,  -2.243215335170650e-07,  -7.346216174713577e-09,
   1.284569661156470e-10,  -8.415413101212448e-13,  -4.592537491875026e-15,   5.974033374231966e-16,   2.380315046149295e-18,  -3.701496616173191e-20,  -3.692621856881631e-21,
  -1.112971755530575e-22,   8.646667351362668e-26,   5.599400047563325e-01,  -9.071643479022012e-03,   8.271068918573555e-05,  -2.241887787344620e-07,  -7.347514531993275e-09,
   1.284470369799743e-10,  -8.398132193971160e-13,  -4.583820049293280e-15,   5.972251717599811e-16,   2.359328561961917e-18,  -3.776994543052790e-20,  -3.691851908550715e-21,
  -1.108966051586287e-22,   9.198322582043907e-26,   5.599443921930423e-01,  -9.071679067959039e-03,   8.270834762872482e-05,  -2.241206041258513e-07,  -7.348180953611415e-09,
   1.284419403223656e-10,  -8.389258300290494e-13,  -4.579353340984055e-15,   5.971332212382487e-16,   2.348551583241682e-18,  -3.815730955831515e-20,  -3.691450743537260e-21,
  -1.106909441615848e-22,   9.481570651178563e-26,   5.599459192708320e-01,  -9.071691454165825e-03,   8.270753261185282e-05,  -2.240968755397924e-07,  -7.348412852522494e-09,
   1.284401667702614e-10,  -8.386169768671154e-13,  -4.577800272624476e-15,   5.971011447805753e-16,   2.344800650838451e-18,  -3.829207886298139e-20,  -3.691310197503340e-21,
  -1.106193700763949e-22,   9.580149299187014e-26,   5.599461615965837e-01,  -9.071693419645968e-03,   8.270740327911608e-05,  -2.240931101499866e-07,  -7.348449649063721e-09,
   1.284398853502968e-10,  -8.385679666387193e-13,  -4.577553898513860e-15,   5.970960512597996e-16,   2.344205433986467e-18,  -3.831346222163760e-20,  -3.691287851257749e-21,
  -1.106080126392949e-22,   9.595791973426026e-26,   8.429902236185294e-01,  -1.230685922474071e-02,   6.851050870727256e-05,   7.156611601199548e-07,  -1.830830800957429e-08,
   5.121261127117559e-11,   3.078819159702318e-12,  -4.283295243111744e-14,   3.855318641311777e-16,   2.529213145121890e-17,  -1.934016173091799e-19,  -9.830165897146261e-21,
  -1.203349907495068e-22,  -4.903827483012671e-25,   8.429966258424794e-01,  -1.230665777892634e-02,   6.850023481580449e-05,   7.157084753784709e-07,  -1.830396669353410e-08,
   5.112961779491585e-11,   3.079813783536541e-12,  -4.274891614122614e-14,   3.846929623449967e-16,   2.524133802271778e-17,  -1.941206152587152e-19,  -9.833022674593711e-21,
  -1.197817590570939e-22,  -4.771378031940743e-25,   8.430079218873893e-01,  -1.230630231391408e-02,   6.848210836051151e-05,   7.157919010507422e-07,  -1.829630524270404e-08,
   5.098330835390720e-11,   3.081567008757938e-12,  -4.260077223072939e-14,   3.832102633083841e-16,   2.515170098764236e-17,  -1.953865255776671e-19,  -9.837985051162523e-21,
  -1.188064928091358e-22,  -4.537885104120486e-25,   8.430215798557830e-01,  -1.230587246358221e-02,   6.846019304685979e-05,   7.158926731773455e-07,  -1.828703900852873e-08,
   5.080661749298578e-11,   3.083683947600330e-12,  -4.242187281691255e-14,   3.814132076845795e-16,   2.504329200136045e-17,  -1.969125530015711e-19,  -9.843851929123655e-21,
  -1.176287507881474e-22,  -4.255909814576365e-25,   8.430348373826564e-01,  -1.230545515323125e-02,   6.843892158989187e-05,   7.159903889609999e-07,  -1.827804149374545e-08,
   5.063532771002506e-11,   3.085735805495122e-12,  -4.224844939503713e-14,   3.796643090582705e-16,   2.493803090190333e-17,  -1.983890501505421e-19,  -9.849407513671707e-21,
  -1.164870430763879e-22,  -3.982554958252428e-25,   8.430455164763282e-01,  -1.230511895977049e-02,   6.842178812477910e-05,   7.160690273028414e-07,  -1.827079177035109e-08,
   5.049750974004396e-11,   3.087386438285879e-12,  -4.210892019025275e-14,   3.782523094859129e-16,   2.485322013634425e-17,  -1.995749575804920e-19,  -9.853782874877649e-21,
  -1.155684545569528e-22,  -3.762615846953189e-25,   8.430525725427881e-01,  -1.230489680243150e-02,   6.841046788198728e-05,   7.161209508642752e-07,  -1.826600057651497e-08,
   5.040652567856231e-11,   3.088476011159807e-12,  -4.201680915764620e-14,   3.773177651444489e-16,   2.479717202153950e-17,  -2.003568521843945e-19,  -9.856625032858262e-21,
  -1.149620309462434e-22,  -3.617416537618011e-25,   8.430561960195024e-01,  -1.230478271194014e-02,   6.840465478094139e-05,   7.161476039632423e-07,  -1.826353985107552e-08,
   5.035982685116118e-11,   3.089035207413193e-12,  -4.196953275972298e-14,   3.768373622818063e-16,   2.476838658684274e-17,  -2.007578571077846e-19,  -9.858069469030525e-21,
  -1.146507770070156e-22,  -3.542890596502205e-25,   8.430574571797117e-01,  -1.230474300137066e-02,   6.840263153922734e-05,   7.161568788871034e-07,  -1.826268333833104e-08,
   5.034357700959289e-11,   3.089229784798342e-12,  -4.195308207897968e-14,   3.766700789454916e-16,   2.475836722851641e-17,  -2.008973453334897e-19,  -9.858569807282499e-21,
  -1.145424698063625e-22,  -3.516957651740158e-25,   8.430576573073264e-01,  -1.230473669983456e-02,   6.840231048154392e-05,   7.161583505981076e-07,  -1.826254741990647e-08,
   5.034099857876714e-11,   3.089260658890995e-12,  -4.195047178676468e-14,   3.766435298375562e-16,   2.475677727898073e-17,  -2.009194761490658e-19,  -9.858649089626801e-21,
  -1.145252842536225e-22,  -3.512842758490506e-25,   1.182403565556800e+00,  -1.427783771851620e-02,  -7.321769981468348e-06,   2.008014278674330e-06,  -6.462483004932984e-09,
  -5.114281735114832e-10,   4.142184145140519e-12,   1.477568646339264e-13,  -1.377330419922330e-15,  -1.242990142001039e-17,   1.042779151060920e-18,  -9.326437591857905e-21,
  -8.383523531842058e-22,   4.886965289324258e-25,   1.182402871911143e+00,  -1.427727464530488e-02,  -7.325372498580154e-06,   2.007537254992496e-06,  -6.456699662578376e-09,
  -5.111379676999183e-10,   4.138655686058345e-12,   1.477136650165058e-13,  -1.373092910050220e-15,  -1.247783105234823e-17,   1.037728678852364e-18,  -9.322404817223512e-21,
  -8.353877589794620e-22,   4.969704407595725e-25,   1.182401647691754e+00,  -1.427628120240127e-02,  -7.331726561738380e-06,   2.006695760167296e-06,  -6.446498863857211e-09,
  -5.106259647326602e-10,   4.132438610091466e-12,   1.476373072164300e-13,  -1.365632959566231e-15,  -1.256238626548325e-17,   1.028831864779773e-18,  -9.315239291754665e-21,
  -8.301648024812119e-22,   5.116025646144255e-25,   1.182400166891130e+00,  -1.427508010582630e-02,  -7.339405471214395e-06,   2.005678592361908e-06,  -6.434170762182754e-09,
  -5.100069643521259e-10,   4.124936083364265e-12,   1.475447505416223e-13,  -1.356641604479037e-15,  -1.266460155998983e-17,   1.018098989827043e-18,  -9.306489902422562e-21,
  -8.238629556073705e-22,   5.293517401926774e-25,   1.182398728872455e+00,  -1.427391429595621e-02,  -7.346855321648091e-06,   2.004691537922732e-06,  -6.422209980275764e-09,
  -5.094061743785234e-10,   4.117668674953321e-12,   1.474546635883510e-13,  -1.347943587629289e-15,  -1.276379903796443e-17,   1.007706104350589e-18,  -9.297907216092176e-21,
  -8.177596510401180e-22,   5.466409993780515e-25,   1.182397570077320e+00,  -1.427297527357863e-02,  -7.352853456449487e-06,   2.003896662297956e-06,  -6.412579629297744e-09,
  -5.089222753948419e-10,   4.111825525581362e-12,   1.473819226965153e-13,  -1.340958497103302e-15,  -1.284368863731831e-17,   9.993526242560022e-19,  -9.290929276015352e-21,
  -8.128532113048720e-22,   5.606111588031202e-25,   1.182396804196781e+00,  -1.427235485231262e-02,  -7.356815268545585e-06,   2.003371560997983e-06,  -6.406218559211905e-09,
  -5.086025674924849e-10,   4.107970039620677e-12,   1.473337745591748e-13,  -1.336353593146838e-15,  -1.289646714418131e-17,   9.938420340453352e-19,  -9.286287070989329e-21,
  -8.096161565667056e-22,   5.698630814165267e-25,   1.182396410828113e+00,  -1.427203625733124e-02,  -7.358849338895881e-06,   2.003101939139258e-06,  -6.402952616202024e-09,
  -5.084383957827282e-10,   4.105991781596961e-12,   1.473090227523080e-13,  -1.333992067034217e-15,  -1.292356798357870e-17,   9.910149379129828e-19,  -9.283893384300535e-21,
  -8.079553282152253e-22,   5.746207953177383e-25,   1.182396273904211e+00,  -1.427192537077731e-02,  -7.359557234568061e-06,   2.003008101593222e-06,  -6.401815997500903e-09,
  -5.083812564811322e-10,   4.105303504190552e-12,   1.473004036102773e-13,  -1.333170643345840e-15,  -1.293300012879806e-17,   9.900313956418982e-19,  -9.283058695771455e-21,
  -8.073775089037791e-22,   5.762777824392452e-25,   1.182396252175877e+00,  -1.427190777476724e-02,  -7.359669564010090e-06,   2.002993211190354e-06,  -6.401635637589496e-09,
  -5.083721893637244e-10,   4.105194297021709e-12,   1.472990356789281e-13,  -1.333040319737745e-15,  -1.293449685420687e-17,   9.898753425983764e-19,  -9.282926168881917e-21,
  -8.072858286682106e-22,   5.765407719745057e-25,   1.558614788192973e+00,  -1.252524179890588e-02,  -1.435934049984800e-04,   1.027275590137502e-06,   5.120405960307577e-08,
   4.678013182024683e-11,  -2.154312053017615e-11,  -2.040984317222794e-13,   9.798865118219392e-15,   2.379637092392477e-16,  -2.196537595422486e-18,  -1.554447144581627e-19,
  -9.189445645932817e-22,   6.433680718896467e-23,   1.558601383812904e+00,  -1.252495273593297e-02,  -1.435647719095963e-04,   1.027316184573612e-06,   5.117406621959029e-08,
   4.639071923957314e-11,  -2.151759390474739e-11,  -2.033156654522659e-13,   9.789430998019917e-15,   2.371799886451707e-16,  -2.201810642663835e-18,  -1.549857215804125e-19,
  -9.099501437774657e-22,   6.412825774057550e-23,   1.558577733735321e+00,  -1.252444267104252e-02,  -1.435142620185074e-04,   1.027387521094582e-06,   5.112117152894081e-08,
   4.570483750111960e-11,  -2.147257200612113e-11,  -2.019365994341525e-13,   9.772766618941922e-15,   2.357990137086433e-16,  -2.211070402719723e-18,  -1.541770547471001e-19,
  -8.941366067285014e-22,   6.376074982274432e-23,   1.558549139494374e+00,  -1.252382588029112e-02,  -1.434532081747755e-04,   1.027473283031700e-06,   5.105726031669897e-08,
   4.487757886714501e-11,  -2.141816557063719e-11,  -2.002726589009323e-13,   9.752585754030028e-15,   2.341323812985926e-16,  -2.222191527136336e-18,  -1.532013071046598e-19,
  -8.751120425392251e-22,   6.331717835687429e-23,   1.558521384558811e+00,  -1.252322709502720e-02,  -1.433939625022430e-04,   1.027556017564532e-06,   5.099526835192884e-08,
   4.407670432043960e-11,  -2.136538493198833e-11,  -1.986611423120947e-13,   9.732963111002771e-15,   2.325178498502807e-16,  -2.232908514113411e-18,  -1.522562657245670e-19,
  -8.567448707776495e-22,   6.288743268572917e-23,   1.558499028307686e+00,  -1.252274471035481e-02,  -1.433462523917747e-04,   1.027622294230521e-06,   5.094536562731122e-08,
   4.343311429677177e-11,  -2.132289148668710e-11,  -1.973656507649183e-13,   9.717132953824072e-15,   2.312196418468926e-16,  -2.241485402144133e-18,  -1.514965254163193e-19,
  -8.420210052115777e-22,   6.254185829311723e-23,   1.558484257048289e+00,  -1.252242595376212e-02,  -1.433147349329928e-04,   1.027665906176269e-06,   5.091240900223920e-08,
   4.300861624486748e-11,  -2.129482529042806e-11,  -1.965109460918234e-13,   9.706661732378347e-15,   2.303630013276579e-16,  -2.247125225694411e-18,  -1.509952718834227e-19,
  -8.323271217548375e-22,   6.231381510178290e-23,   1.558476671718208e+00,  -1.252226225533496e-02,  -1.432985518478401e-04,   1.027688246608710e-06,   5.089548982760217e-08,
   4.279085560870763e-11,  -2.128041589004374e-11,  -1.960724263319238e-13,   9.701280885186926e-15,   2.299234438594765e-16,  -2.250013014713692e-18,  -1.507380919771394e-19,
  -8.273597688006272e-22,   6.219679894537343e-23,   1.558474031641215e+00,  -1.252220527833355e-02,  -1.432929195967611e-04,   1.027696013428107e-06,   5.088960185000368e-08,
   4.271510012586819e-11,  -2.127540119280463e-11,  -1.959198610777836e-13,   9.699407495618042e-15,   2.297705104871937e-16,  -2.251016779436471e-18,  -1.506486159945836e-19,
  -8.256325725563533e-22,   6.215608553498376e-23,   1.558473612700517e+00,  -1.252219623685556e-02,  -1.432920258560167e-04,   1.027697245489504e-06,   5.088866755158679e-08,
   4.270308058250822e-11,  -2.127460545916292e-11,  -1.958956541851633e-13,   9.699110189042582e-15,   2.297462448501079e-16,  -2.251175998694266e-18,  -1.506344191844982e-19,
  -8.253585726929911e-22,   6.214962559637229e-23,   1.892859988290132e+00,  -4.651477033412173e-03,  -1.349647929773923e-04,  -2.900740470241606e-06,  -4.030897944963478e-08,
   2.167153461830193e-11,   2.172801966735445e-11,   7.398080525147979e-13,   1.337521184776385e-14,   3.853618373410560e-17,  -6.402814677885421e-18,  -2.433317599725442e-19,
  -4.691890421416264e-21,  -2.160635284349064e-23,   1.892847290204965e+00,  -4.652292747625440e-03,  -1.349872917406179e-04,  -2.900707893644451e-06,  -4.027801703401938e-08,
   2.312950172351570e-11,   2.176255028795905e-11,   7.399052810495149e-13,   1.334729768910100e-14,   3.727734495864554e-17,  -6.431009673438755e-18,  -2.434456222768849e-19,
  -4.674027518818858e-21,  -2.080758015852328e-23,   1.892824882539736e+00,  -4.653732078627184e-03,  -1.350269769076306e-04,  -2.900649300050811e-06,  -4.022334411446057e-08,
   2.570224709424832e-11,   2.182341999446358e-11,   7.400733853195660e-13,   1.329794675216849e-14,   3.505567206035049e-17,  -6.480668974220356e-18,  -2.436417756775875e-19,
  -4.642385400668759e-21,  -1.939740190274024e-23,   1.892797784063551e+00,  -4.655472516578249e-03,  -1.350749403180528e-04,  -2.900576552487913e-06,  -4.015716615869324e-08,
   2.881347231407330e-11,   2.189692165032921e-11,   7.402707635538876e-13,   1.323810766008231e-14,   3.236847840513554e-17,  -6.540561586161864e-18,  -2.438708501583481e-19,
  -4.603914543004922e-21,  -1.769097712175912e-23,   1.892771474308654e+00,  -4.657162086139741e-03,  -1.351214768859878e-04,  -2.900503945316678e-06,  -4.009285177212952e-08,
   3.183403613569725e-11,   2.196816812029485e-11,   7.404562005321951e-13,   1.317984605844322e-14,   2.975905760739486e-17,  -6.598540457189676e-18,  -2.440847288728350e-19,
  -4.566349512531142e-21,  -1.603316122980465e-23,   1.892750277346755e+00,  -4.658523168729807e-03,  -1.351589478721748e-04,  -2.900444031552722e-06,  -4.004099084628075e-08,
   3.426753178454003e-11,   2.202548608296802e-11,   7.406011615578073e-13,   1.313278905394613e-14,   2.765642445547698e-17,  -6.645129713989889e-18,  -2.442509321089043e-19,
  -4.535931663265813e-21,  -1.469677421937231e-23,   1.892736269711930e+00,  -4.659422541588607e-03,  -1.351836990835273e-04,  -2.900403745151749e-06,  -4.000669756104679e-08,
   3.587562358832876e-11,   2.206332288913672e-11,   7.406947825607515e-13,   1.310163486251827e-14,   2.626679342068672e-17,  -6.675857250780711e-18,  -2.443577711673353e-19,
  -4.515755888026007e-21,  -1.381329549205704e-23,   1.892729075793446e+00,  -4.659884410632515e-03,  -1.351964072464180e-04,  -2.900382840767944e-06,  -3.998907874216311e-08,
   3.670148050152507e-11,   2.208274217326426e-11,   7.407421913104074e-13,   1.308561722972463e-14,   2.555307560007571e-17,  -6.691619399276451e-18,  -2.444117147697607e-19,
  -4.505371128828252e-21,  -1.335945954190737e-23,   1.892726571832064e+00,  -4.660045168070876e-03,  -1.352008299980665e-04,  -2.900375530515043e-06,  -3.998294514511441e-08,
   3.698893148958023e-11,   2.208949936514706e-11,   7.407585856717991e-13,   1.308003920782373e-14,   2.530464760458793e-17,  -6.697102704929467e-18,  -2.444303433155505e-19,
  -4.501752874711128e-21,  -1.320147767977741e-23,   1.892726174485400e+00,  -4.660070678047517e-03,  -1.352015318069130e-04,  -2.900374368850687e-06,  -3.998197177050004e-08,
   3.703454618841571e-11,   2.209057154974759e-11,   7.407611821662343e-13,   1.307915391311799e-14,   2.526522493666949e-17,  -6.697972694449770e-18,  -2.444332924293757e-19,
  -4.501178529953895e-21,  -1.317640718309191e-23,   6.291946356099577e-03,  -1.123454865471832e-04,   1.495877030156073e-06,  -1.784558768356110e-08,   1.935260006336187e-10,
  -2.092187024142922e-12,   2.430536651257384e-14,  -4.411269768459285e-17,   5.888167071882989e-18,  -2.759920184116401e-20,  -2.833224573709048e-21,  -7.827749341223429e-23,
  -2.305718066702581e-25,   2.836531888673633e-26,   6.292086813216986e-03,  -1.123505125204409e-04,   1.495986082359133e-06,  -1.784754985095486e-08,   1.935603594589004e-10,
  -2.092275538866053e-12,   2.432057521449743e-14,  -4.421611940582692e-17,   5.876178370846310e-18,  -2.799460196772525e-20,  -2.834387159422177e-21,  -7.806680917038502e-23,
  -2.248782083779038e-25,   2.842446282847389e-26,   6.292334660349092e-03,  -1.123593813782496e-04,   1.496178522444861e-06,  -1.785101219422985e-08,   1.936210034379286e-10,
  -2.092431895074545e-12,   2.434738560203106e-14,  -4.439968754131796e-17,   5.855020363825224e-18,  -2.869140517937948e-20,  -2.836409878209733e-21,  -7.769470193752252e-23,
  -2.148280446782230e-25,   2.852882290201142e-26,   6.292634373968595e-03,  -1.123701064613438e-04,   1.496411249926507e-06,  -1.785519901281841e-08,   1.936943642483674e-10,
  -2.092621254715127e-12,   2.437976134302303e-14,  -4.462349800472657e-17,   5.829429539761426e-18,  -2.953247444804203e-20,  -2.838806853828949e-21,  -7.724414647270309e-23,
  -2.026690125062775e-25,   2.865501051122511e-26,   6.292925345653694e-03,  -1.123805189879706e-04,   1.496637205886095e-06,  -1.785926362553421e-08,   1.937656124810822e-10,
  -2.092805389102458e-12,   2.441114541862384e-14,  -4.484269184043494e-17,   5.804579861901960e-18,  -3.034738464654197e-20,  -2.841082554653383e-21,  -7.680612737870281e-23,
  -1.908587692377630e-25,   2.877749874949052e-26,   6.293159759329679e-03,  -1.123889077583749e-04,   1.496819253242190e-06,  -1.786253811196432e-08,   1.938230312008006e-10,
  -2.092953946626392e-12,   2.443639524938093e-14,  -4.502064751331570e-17,   5.784556653042493e-18,  -3.100272894339886e-20,  -2.842879104295940e-21,  -7.645281523809470e-23,
  -1.813400272921310e-25,   2.887616011873946e-26,   6.293314660935693e-03,  -1.123944511896463e-04,   1.496939556771498e-06,  -1.786470187703540e-08,   1.938609832666884e-10,
  -2.093052219551408e-12,   2.445306383963473e-14,  -4.513891055558394e-17,   5.771323430107841e-18,  -3.143521182515934e-20,  -2.844048246229135e-21,  -7.621913273140701e-23,
  -1.750480056163508e-25,   2.894134529811642e-26,   6.293394211938052e-03,  -1.123972980938211e-04,   1.497001341445841e-06,  -1.786581308716628e-08,   1.938804768065299e-10,
  -2.093102721126434e-12,   2.446161899487569e-14,  -4.519985232052669e-17,   5.764526848430948e-18,  -3.165714015688869e-20,  -2.844643093273833e-21,  -7.609905750897960e-23,
  -1.718160749770860e-25,   2.897481798418560e-26,   6.293421900650189e-03,  -1.123982889987367e-04,   1.497022846654067e-06,  -1.786619985613608e-08,   1.938872622428749e-10,
  -2.093120304039392e-12,   2.446459590478541e-14,  -4.522109676767636e-17,   5.762161126789788e-18,  -3.173435690432140e-20,  -2.844849249471905e-21,  -7.605725339128521e-23,
  -1.706910647606674e-25,   2.898646794276260e-26,   6.293426294479682e-03,  -1.123984462423572e-04,   1.497026259257535e-06,  -1.786626123114498e-08,   1.938883390233914e-10,
  -2.093123094460963e-12,   2.446506826187447e-14,  -4.522446954035683e-17,   5.761785714174426e-18,  -3.174660883584758e-20,  -2.844881921569579e-21,  -7.605061913909090e-23,
  -1.705125360567162e-25,   2.898831660551990e-26,   5.679622750564706e-02,  -1.005731567903306e-03,   1.308730889496153e-05,  -1.494642875703893e-07,   1.499763359469821e-09,
  -1.449552835023835e-11,   1.504396015939069e-13,   6.260460986241439e-16,   4.061099600250305e-17,  -8.167949003930167e-20,  -2.805754510861546e-20,  -7.001172155835701e-22,
  -2.368200313562470e-24,   2.639055520828663e-25,   5.679745613440147e-02,  -1.005773652479988e-03,   1.308815371194954e-05,  -1.494778667960128e-07,   1.499976142588446e-09,
  -1.449430187474286e-11,   1.505437516278579e-13,   6.256786224323849e-16,   4.049224724466383e-17,  -8.521303650020709e-20,  -2.806977844828352e-20,  -6.981576580946734e-22,
  -2.316026780430178e-24,   2.644446625274962e-25,   5.679962413373475e-02,  -1.005847914481927e-03,   1.308964450243457e-05,  -1.495018266207480e-07,   1.500351719861662e-09,
  -1.449213837268519e-11,   1.507272723533287e-13,   6.250205655580982e-16,   4.028267336103398e-17,  -9.143978985981175e-20,  -2.809110153790279e-20,  -6.946967822889277e-22,
  -2.223931492863168e-24,   2.653960112467353e-25,   5.680224581179135e-02,  -1.005937718181119e-03,   1.309144734870330e-05,  -1.495307975071821e-07,   1.500806073107044e-09,
  -1.448952333314146e-11,   1.509487550285952e-13,   6.242084157856529e-16,   4.002918708222422e-17,  -9.895517900733624e-20,  -2.811643738353973e-20,  -6.905063881742872e-22,
  -2.112511146286509e-24,   2.665464811690621e-25,   5.680479100676863e-02,  -1.006024903600386e-03,   1.309319769504292e-05,  -1.495589202780545e-07,   1.501247361807318e-09,
  -1.448698585314366e-11,   1.511633135460504e-13,   6.234028194235502e-16,   3.978303730389393e-17,  -1.062362455589585e-19,  -2.814056342403976e-20,  -6.864327021855714e-22,
  -2.004286618158050e-24,   2.676633702530462e-25,   5.680684146536152e-02,  -1.006095143011486e-03,   1.309460787627434e-05,  -1.495815744244895e-07,   1.501603008842403e-09,
  -1.448494252934847e-11,   1.513358344535143e-13,   6.227415493262781e-16,   3.958469286932690e-17,  -1.120912063968183e-19,  -2.815966250991855e-20,  -6.831468927452972e-22,
  -1.917060277294533e-24,   2.685631026195689e-25,   5.680819641232634e-02,  -1.006141557907405e-03,   1.309553976011888e-05,  -1.495965432973566e-07,   1.501838087731657e-09,
  -1.448359275105949e-11,   1.514496742215993e-13,   6.222985809139224e-16,   3.945360644994043e-17,  -1.159548806938803e-19,  -2.817211802717666e-20,  -6.809736805560682e-22,
  -1.859402319885566e-24,   2.691576033367345e-25,   5.680889225493588e-02,  -1.006165394778624e-03,   1.309601834599413e-05,  -1.496042303493750e-07,   1.501958834755317e-09,
  -1.448289970406820e-11,   1.515080872210769e-13,   6.220692370946452e-16,   3.938627994231173e-17,  -1.179374597879210e-19,  -2.817846355112807e-20,  -6.798570111952986e-22,
  -1.829785961940289e-24,   2.694628960889860e-25,   5.680913445132031e-02,  -1.006173691515669e-03,   1.309618492520502e-05,  -1.496069058695033e-07,   1.502000865485665e-09,
  -1.448265850328472e-11,   1.515284105724142e-13,   6.219891161343803e-16,   3.936284516746917e-17,  -1.186272594095462e-19,  -2.818066405199004e-20,  -6.794682453500331e-22,
  -1.819476729055576e-24,   2.695691538223182e-25,   5.680917288464550e-02,  -1.006175008098117e-03,   1.309621135917473e-05,  -1.496073304363362e-07,   1.502007535355682e-09,
  -1.448262022902017e-11,   1.515316352367423e-13,   6.219763880036771e-16,   3.935912633612118e-17,  -1.187367089935271e-19,  -2.818101285582193e-20,  -6.794065488719791e-22,
  -1.817840748958241e-24,   2.695860153499624e-25,   1.587089831930545e-01,  -2.760472608699117e-03,   3.412155008719430e-05,  -3.506184646161256e-07,   2.820202272180958e-09,
  -1.767884578303477e-11,   9.564853548668183e-14,   5.975110364253347e-15,   7.459964685058952e-17,   1.632527697142005e-19,  -8.389248908141100e-20,  -2.051316639731269e-21,
  -6.645093988773680e-24,   7.655404249196888e-25,   1.587121852682024e-01,  -2.760571277957338e-03,   3.412313722081242e-05,  -3.506349395616030e-07,   2.820338995291137e-09,
  -1.766707842470352e-11,   9.583702471093785e-14,   5.975392275435946e-15,   7.424466658447528e-17,   1.528972664250371e-19,  -8.392654167667101e-20,  -2.045634996510422e-21,
  -6.492795583339781e-24,   7.670552356951259e-25,   1.587178355013232e-01,  -2.760745385168244e-03,   3.412593780613606e-05,  -3.506640008925799e-07,   2.820580457983142e-09,
  -1.764631441644255e-11,   9.616885871775913e-14,   5.975861461073805e-15,   7.361818773165310e-17,   1.346487211705702e-19,  -8.398586078470655e-20,  -2.035600632873077e-21,
  -6.223961786250922e-24,   7.697288938165917e-25,   1.587246680301548e-01,  -2.760955923864934e-03,   3.412932441146532e-05,  -3.506991268706720e-07,   2.820872799179429e-09,
  -1.762120584208373e-11,   9.656882300404384e-14,   5.976380679939967e-15,   7.286045604967634e-17,   1.126231681222766e-19,  -8.405628155347870e-20,  -2.023451600148751e-21,
  -5.898715037913272e-24,   7.729630513449891e-25,   1.587313011471985e-01,  -2.761160317884372e-03,   3.413261218209274e-05,  -3.507332105465101e-07,   2.821156977202919e-09,
  -1.759683037408372e-11,   9.695574725859151e-14,   5.976834389639036e-15,   7.212466997873037e-17,   9.128388293526970e-20,  -8.412327411140022e-20,  -2.011641428751661e-21,
  -5.582795529122382e-24,   7.761037344366008e-25,   1.587366448550295e-01,  -2.761324979845638e-03,   3.413526084823181e-05,  -3.507606564372905e-07,   2.821386177803793e-09,
  -1.757719348446984e-11,   9.726647802408085e-14,   5.977163865103889e-15,   7.153179343421865e-17,   7.412387897746945e-20,  -8.417626004239066e-20,  -2.002115770787159e-21,
  -5.328170821186886e-24,   7.786344336639180e-25,   1.587401759578640e-01,  -2.761433787884670e-03,   3.413701107925604e-05,  -3.507787865743843e-07,   2.821537761696583e-09,
  -1.756421762742846e-11,   9.747132819841722e-14,   5.977363953136292e-15,   7.113996482322165e-17,   6.279986889167271e-20,  -8.421079107261367e-20,  -1.995815736187972e-21,
  -5.159859317477367e-24,   7.803069211000952e-25,   1.587419893715981e-01,  -2.761489666745137e-03,   3.413790991889155e-05,  -3.507880955296671e-07,   2.821615648122441e-09,
  -1.755755385989389e-11,   9.757638159916412e-14,   5.977461261180324e-15,   7.093872170288907e-17,   5.698909336011137e-20,  -8.422837559015306e-20,  -1.992578619730569e-21,
  -5.073404893091503e-24,   7.811658889692610e-25,   1.587426205505917e-01,  -2.761509116009840e-03,   3.413822277021013e-05,  -3.507913353201717e-07,   2.821642763704530e-09,
  -1.755523446777401e-11,   9.761292299920226e-14,   5.977494263319487e-15,   7.086867395979943e-17,   5.496733946829880e-20,  -8.423447234814833e-20,  -1.991451633532746e-21,
  -5.043310720992414e-24,   7.814648700872091e-25,   1.587427207101826e-01,  -2.761512202345776e-03,   3.413827241549841e-05,  -3.507918494171731e-07,   2.821647066882379e-09,
  -1.755486641186904e-11,   9.761872050532436e-14,   5.977499459160118e-15,   7.085755819449661e-17,   5.464655009147829e-20,  -8.423543869478207e-20,  -1.991272783138497e-21,
  -5.038535052092807e-24,   7.815123147040687e-25,   3.138478341585139e-01,  -5.293936533383915e-03,   5.952991956606584e-05,  -4.849113735043167e-07,   1.650858080147371e-09,
   2.133832389686547e-11,  -4.174039545144174e-13,   1.651930836371664e-14,   1.732399162732619e-16,  -4.936675707769702e-19,  -1.609405453520557e-19,  -4.565392209846582e-21,
  -1.313545743239724e-23,   1.640178870624766e-24,   3.138534169349897e-01,  -5.294072842955486e-03,   5.953084489075096e-05,  -4.848910957786216e-07,   1.650276296521124e-09,
   2.137080884570123e-11,  -4.169632719063796e-13,   1.651704284264934e-14,   1.725588850956691e-16,  -5.167335119171595e-19,  -1.610070559905176e-19,  -4.553228487185114e-21,
  -1.281712200340610e-23,   1.643253749543355e-24,   3.138632679021940e-01,  -5.294313358658405e-03,   5.953247737589609e-05,  -4.848552906643940e-07,   1.649250228431121e-09,
   2.142812512915230e-11,  -4.161871351255157e-13,   1.651298235410311e-14,   1.713569797219170e-16,  -5.573825632383196e-19,  -1.611228113935236e-19,  -4.531747081391008e-21,
  -1.225520435174906e-23,   1.648682946858532e-24,   3.138751799168220e-01,  -5.294604184831695e-03,   5.953445094299207e-05,  -4.848119525421047e-07,   1.648010344387232e-09,
   2.149742583919894e-11,  -4.152511027760640e-13,   1.650796514470910e-14,   1.699032598283978e-16,  -6.064485376897385e-19,  -1.612600489815214e-19,  -4.505740276808907e-21,
  -1.157537366646813e-23,   1.655253705017640e-24,   3.138867440198961e-01,  -5.294886505480342e-03,   5.953636637527788e-05,  -4.847698364591675e-07,   1.646807573457418e-09,
   2.156469461036325e-11,  -4.143450167511996e-13,   1.650298236454783e-14,   1.684916383246364e-16,  -6.539894570221209e-19,  -1.613904118191744e-19,  -4.480460571960049e-21,
  -1.091504016263055e-23,   1.661638090496852e-24,   3.138960600008370e-01,  -5.295113933325701e-03,   5.953790908422020e-05,  -4.847358766347639e-07,   1.645839271371331e-09,
   2.161888026683137e-11,  -4.136169473409352e-13,   1.649888802606882e-14,   1.673541888224371e-16,  -6.922222113475006e-19,  -1.614933770178623e-19,  -4.460072095905090e-21,
  -1.038282557684777e-23,   1.666785020228226e-24,   3.139022158790933e-01,  -5.295264210656403e-03,   5.953892831317421e-05,  -4.847134210891146e-07,   1.645199744872851e-09,
   2.165468261690545e-11,  -4.131367636931827e-13,   1.649614329012312e-14,   1.666024537910711e-16,  -7.174535995607784e-19,  -1.615604089361366e-19,  -4.446588256542202e-21,
  -1.003102250011390e-23,   1.670187749511504e-24,   3.139053772307351e-01,  -5.295341384347313e-03,   5.953945168479884e-05,  -4.847018842990374e-07,   1.644871413281369e-09,
   2.167306803774996e-11,  -4.128904483724291e-13,   1.649472159973997e-14,   1.662163623850188e-16,  -7.304011826344064e-19,  -1.615945219743230e-19,  -4.439660103333707e-21,
  -9.850316381823805e-24,   1.671935725940556e-24,   3.139064775702913e-01,  -5.295368245212443e-03,   5.953963384093378e-05,  -4.846978680505753e-07,   1.644757149718279e-09,
   2.167946712416996e-11,  -4.128047609595019e-13,   1.649422483579804e-14,   1.660819734732482e-16,  -7.349061243420818e-19,  -1.616063458039702e-19,  -4.437248129893373e-21,
  -9.787413875223238e-24,   1.672544204644252e-24,   3.139066521791276e-01,  -5.295372507654934e-03,   5.953966274621673e-05,  -4.846972306910340e-07,   1.644739018388483e-09,
   2.168048256498449e-11,  -4.127911656783001e-13,   1.649414591451680e-14,   1.660606475070252e-16,  -7.356209213832531e-19,  -1.616082197316543e-19,  -4.436865356042613e-21,
  -9.777431825295117e-24,   1.672640765567491e-24,   5.248847197884104e-01,  -8.421647710312353e-03,   7.942355694024954e-05,  -3.232918476449633e-07,  -4.969620398647000e-09,
   1.086781304065235e-10,  -7.076143130945996e-13,   1.531273632914274e-14,   6.147427218497890e-16,  -3.460128708787698e-18,  -3.012249388938854e-19,  -7.969954512687339e-21,
  -3.635527407788458e-23,   3.192557622381389e-24,   5.248921601094877e-01,  -8.421738276150807e-03,   7.942075603325944e-05,  -3.231897105576431e-07,  -4.970596749160951e-09,
   1.087080726131604e-10,  -7.060270088486268e-13,   1.530001480309888e-14,   6.134657183665066e-16,  -3.500303386936191e-18,  -3.014224520698240e-19,  -7.946343229227604e-21,
  -3.576381239179212e-23,   3.197356341807083e-24,   5.249052884591416e-01,  -8.421898057601867e-03,   7.941581334663688e-05,  -3.230094652998595e-07,  -4.972317730678959e-09,
   1.087608852339707e-10,  -7.032289144868692e-13,   1.527745791288779e-14,   6.112117722983025e-16,  -3.571092986787907e-18,  -3.017679873012973e-19,  -7.904652056963317e-21,
  -3.471975297427290e-23,   3.205836095530301e-24,   5.249211630350147e-01,  -8.422091227144629e-03,   7.940983584377665e-05,  -3.227914720110482e-07,  -4.974395685535964e-09,
   1.088247111081762e-10,  -6.998500829073825e-13,   1.524999526262353e-14,   6.084851696495641e-16,  -3.656523212169520e-18,  -3.021807298652861e-19,  -7.854189679104018e-21,
  -3.345656226136404e-23,   3.216110383946269e-24,   5.249365734164428e-01,  -8.422278711010766e-03,   7.940403219924692e-05,  -3.225798072858832e-07,  -4.976409711408844e-09,
   1.088866346132341e-10,  -6.965748465224876e-13,   1.522313981150619e-14,   6.058370807189571e-16,  -3.739279985530917e-18,  -3.025760892671444e-19,  -7.805150340971804e-21,
  -3.222955064711976e-23,   3.226105220439579e-24,   5.249489875455702e-01,  -8.422429715635234e-03,   7.939935629443027e-05,  -3.224092638462430e-07,  -4.978029881608030e-09,
   1.089364923726876e-10,  -6.939398523069316e-13,   1.520136572771461e-14,   6.037029968496022e-16,  -3.805820577398609e-18,  -3.028907698418278e-19,  -7.765608066822761e-21,
  -3.124057025670434e-23,   3.234171286565013e-24,   5.249571904469077e-01,  -8.422529482140366e-03,   7.939626626375308e-05,  -3.222965575404495e-07,  -4.979099334452888e-09,
   1.089694242233755e-10,  -6.922004059734450e-13,   1.518690947713175e-14,   6.022924343439382e-16,  -3.849727110171576e-18,  -3.030968363380116e-19,  -7.739461192293679e-21,
  -3.058681942990992e-23,   3.239508026312192e-24,   5.249614029877843e-01,  -8.422580712480185e-03,   7.939467929981309e-05,  -3.222386730569538e-07,  -4.979648201364748e-09,
   1.089863321917804e-10,  -6.913076462351120e-13,   1.517946438543476e-14,   6.015679204921731e-16,  -3.872255940805237e-18,  -3.032020832882479e-19,  -7.726027937542197e-21,
  -3.025101022306854e-23,   3.242250765777209e-24,   5.249628691946138e-01,  -8.422598542947232e-03,   7.939412692889925e-05,  -3.222185251315495e-07,  -4.979839184085436e-09,
   1.089922165094612e-10,  -6.909969972855236e-13,   1.517686969279186e-14,   6.013157273553808e-16,  -3.880094237475488e-18,  -3.032386234165676e-19,  -7.721351481004326e-21,
  -3.013411655925641e-23,   3.243205726803660e-24,   5.249631018611314e-01,  -8.422601372362518e-03,   7.939403927459792e-05,  -3.222153279000004e-07,  -4.979869487781599e-09,
   1.089931502384988e-10,  -6.909477055754452e-13,   1.517645779130587e-14,   6.012757068551811e-16,  -3.881337921492324e-18,  -3.032444174622292e-19,  -7.720609349537840e-21,
  -3.011556656670629e-23,   3.243357281338824e-24,   7.949064478981339e-01,  -1.172930123949292e-02,   7.538661864164629e-05,   4.345644132673145e-07,  -1.663177674016697e-08,
   1.128715945992675e-10,   2.173053083438949e-12,  -1.836740615550591e-14,   1.037420550486371e-15,   7.280212878358447e-18,  -7.411251197158479e-19,  -1.426330724226934e-20,
  -1.671376488552710e-23,   4.999426073368922e-24,   7.949134966348831e-01,  -1.172917864689447e-02,   7.537728072866059e-05,   4.346699294961931e-07,  -1.662868955038677e-08,
   1.128357906734798e-10,   2.175711698800833e-12,  -1.834470930275816e-14,   1.034292435145156e-15,   7.208110833791238e-18,  -7.411794151238537e-19,  -1.422629299121258e-20,
  -1.565422613981958e-23,   5.007629340615096e-24,   7.949259335323160e-01,  -1.172896230624776e-02,   7.536080525321160e-05,   4.348560873637300e-07,  -1.662323914123818e-08,
   1.127726494901343e-10,   2.180396190903398e-12,  -1.830485712549000e-14,   1.028772683317790e-15,   7.081041275728239e-18,  -7.412698862372231e-19,  -1.416093142609527e-20,
  -1.378428439687712e-23,   5.022146801555830e-24,   7.949409711519806e-01,  -1.172870066377519e-02,   7.534088535256648e-05,   4.350811451229695e-07,  -1.661664331400083e-08,
   1.126963586536044e-10,   2.186049344604592e-12,  -1.825700267415847e-14,   1.022097908973561e-15,   6.927652919630478e-18,  -7.413701887577771e-19,  -1.408181123382661e-20,
  -1.152250997012992e-23,   5.039773176036957e-24,   7.949555681462726e-01,  -1.172844662280892e-02,   7.532154999353778e-05,   4.352995788136056e-07,  -1.661023482921690e-08,
   1.126223595519625e-10,   2.191525406736764e-12,  -1.821089707373726e-14,   1.015617927197601e-15,   6.779024381558330e-18,  -7.414580337999899e-19,  -1.400491424434551e-20,
  -9.326178879803106e-24,   5.056958311670938e-24,   7.949673263876209e-01,  -1.172824193991679e-02,   7.530597549740825e-05,   4.354755114300492e-07,  -1.660506839441834e-08,
   1.125627915849936e-10,   2.195928309240832e-12,  -1.817400599345478e-14,   1.010397587223839e-15,   6.659490638456418e-18,  -7.415219735502631e-19,  -1.394290349082933e-20,
  -7.556392335053445e-24,   5.070854340332458e-24,   7.949750955797671e-01,  -1.172810667403221e-02,   7.529568503812496e-05,   4.355917475735221e-07,  -1.660165262670304e-08,
   1.125234519650408e-10,   2.198833486370915e-12,  -1.814975181051702e-14,   1.006948010223046e-15,   6.580602590350624e-18,  -7.415608806518377e-19,  -1.390189672115044e-20,
  -6.386731255172432e-24,   5.080061624483686e-24,   7.949790852942874e-01,  -1.172803720386625e-02,   7.529040067031095e-05,   4.356514351403019e-07,  -1.659989788565221e-08,
   1.125032559228572e-10,   2.200324140375563e-12,  -1.813733407696049e-14,   1.005176466902600e-15,   6.540120034876576e-18,  -7.415798273204114e-19,  -1.388082813141178e-20,
  -5.785987666606866e-24,   5.084797667289952e-24,   7.949804739290909e-01,  -1.172801302339663e-02,   7.528856144155231e-05,   4.356722091081066e-07,  -1.659928703951750e-08,
   1.124962275761698e-10,   2.200842770231507e-12,  -1.813301801073140e-14,   1.004559861853479e-15,   6.526034524660808e-18,  -7.415862572613160e-19,  -1.387349347820966e-20,
  -5.576882805688248e-24,   5.086447302949051e-24,   7.949806942852712e-01,  -1.172800918625389e-02,   7.528826958336052e-05,   4.356755056109883e-07,  -1.659919010226081e-08,
   1.124951123251485e-10,   2.200925059871174e-12,  -1.813233339714395e-14,   1.004462014975319e-15,   6.523799576732208e-18,  -7.415872697891420e-19,  -1.387232949674408e-20,
  -5.543700244279114e-24,   5.086709134829284e-24,   1.125324221227756e+00,  -1.424252065733796e-02,   1.583757843128532e-05,   1.829501780534397e-06,  -1.538835695759243e-08,
  -3.675081682667759e-10,   7.644425996738460e-12,   1.030876352768597e-13,  -1.275426091690557e-15,   1.006809206893155e-17,  -1.526289647543238e-19,  -4.081218759409351e-20,
  -3.164141997269857e-22,   1.848734911118349e-23,   1.125325688744305e+00,  -1.424200731814553e-02,   1.582898293090384e-05,   1.829158952837110e-06,  -1.537764679480100e-08,
  -3.673047710688089e-10,   7.641063307841393e-12,   1.031162853454434e-13,  -1.276129284372417e-15,   9.862849563313060e-18,  -1.544883100838705e-19,  -4.067845040931583e-20,
  -3.142918535169354e-22,   1.846067041395082e-23,   1.125328277552440e+00,  -1.424110160114345e-02,   1.581382092355740e-05,   1.828554183122485e-06,  -1.535875239415845e-08,
  -3.669458302671460e-10,   7.635128253879438e-12,   1.031662794956644e-13,  -1.277376369566761e-15,   9.501255091646106e-18,  -1.577584582784535e-19,  -4.044262413575433e-20,
  -3.105451617027425e-22,   1.841385718554086e-23,   1.125331406862428e+00,  -1.424000653157350e-02,   1.579549519602088e-05,   1.827823153687502e-06,  -1.533591164897565e-08,
  -3.665117220864059e-10,   7.627948894244320e-12,   1.032257802728706e-13,  -1.278895059229968e-15,   9.064964164701775e-18,  -1.616945129960186e-19,  -4.015772388414248e-20,
  -3.060116046377554e-22,   1.835769407938259e-23,   1.125334443586128e+00,  -1.423894359634693e-02,   1.577771362242078e-05,   1.827113760043481e-06,  -1.531374512629485e-08,
  -3.660902215774829e-10,   7.620976531551278e-12,   1.032825462948404e-13,  -1.280380550660926e-15,   8.642417868133236e-18,  -1.654964547775538e-19,  -3.988142214713092e-20,
  -3.016073658837150e-22,   1.830363379659634e-23,   1.125336889103018e+00,  -1.423808740937751e-02,   1.576339526865007e-05,   1.826542480292765e-06,  -1.529589299260431e-08,
  -3.657506124851023e-10,   7.615357697823262e-12,   1.033275633595677e-13,  -1.281585226584855e-15,   8.302734295007325e-18,  -1.685455505618558e-19,  -3.965903280109848e-20,
  -2.980571325748555e-22,   1.826041235476637e-23,   1.125338504651580e+00,  -1.423752170514911e-02,   1.575393701560956e-05,   1.826165086030160e-06,  -1.528409903436348e-08,
  -3.655261787434909e-10,   7.611643895427568e-12,   1.033569611575982e-13,  -1.282385154691496e-15,   8.078626988097867e-18,  -1.705536291426568e-19,  -3.951217734664404e-20,
  -2.957101126106398e-22,   1.823201253781750e-23,   1.125339334187704e+00,  -1.423723120407105e-02,   1.574908069637032e-05,   1.825971306086340e-06,  -1.527804301903455e-08,
  -3.654109132527904e-10,   7.609736377301356e-12,   1.033719505832077e-13,  -1.282797160124022e-15,   7.963645229848874e-18,  -1.715827981122325e-19,  -3.943678948717591e-20,
  -2.945044699834197e-22,   1.821747721572343e-23,   1.125339622895393e+00,  -1.423713009491605e-02,   1.574739056062349e-05,   1.825903863989269e-06,  -1.527593528630001e-08,
  -3.653707927696798e-10,   7.609072399865129e-12,   1.033771506432802e-13,  -1.282940753904673e-15,   7.923641977341098e-18,  -1.719406793392694e-19,  -3.941055473260690e-20,
  -2.940847817111983e-22,   1.821242590295020e-23,   1.125339668708379e+00,  -1.423711405039985e-02,   1.574712236650848e-05,   1.825893162084547e-06,  -1.527560082378607e-08,
  -3.653644261411860e-10,   7.608967033497000e-12,   1.033779750073294e-13,  -1.282963549348479e-15,   7.917294828649647e-18,  -1.719974544724437e-19,  -3.940639186041388e-20,
  -2.940181804336197e-22,   1.821162470100462e-23,   1.506313917360833e+00,  -1.361087044463600e-02,  -1.264142017196716e-04,   1.824720337786115e-06,   4.671983302797385e-08,
  -4.964275987749120e-10,  -2.178000705871603e-11,   2.159644544727858e-13,   1.511658372880159e-14,   1.398690965927915e-17,  -8.629302889958716e-18,  -1.039752049857007e-19,
   3.114216016478532e-21,   6.923059764694761e-23,   1.506302118462598e+00,  -1.361035886894175e-02,  -1.263880919077367e-04,   1.824258517350912e-06,   4.668966434907941e-08,
  -4.960019118955724e-10,  -2.174106365587046e-11,   2.159982511551351e-13,   1.508078305774078e-14,   1.346966474124168e-17,  -8.610449491140537e-18,  -1.034872489688198e-19,
   3.105170954005333e-21,   6.889499357547686e-23,   1.506281301090622e+00,  -1.360945629054343e-02,  -1.263420344218733e-04,   1.823443952514974e-06,   4.663647547375436e-08,
  -4.952507331665435e-10,  -2.167242344594376e-11,   2.160564804873839e-13,   1.501767651064107e-14,   1.255900492028516e-17,  -8.577227326141211e-18,  -1.026281998696571e-19,
   3.089260276296871e-21,   6.830565921164588e-23,   1.506256131859595e+00,  -1.360836506201872e-02,  -1.262863645433824e-04,   1.822459525481521e-06,   4.657223427938855e-08,
  -4.943423203015223e-10,  -2.158955252657805e-11,   2.161244994031883e-13,   1.494147693198712e-14,   1.146127593586862e-17,  -8.537131209380208e-18,  -1.015927538685415e-19,
   3.070105179084687e-21,   6.759786156103005e-23,   1.506231701520943e+00,  -1.360730590355247e-02,  -1.262323455977198e-04,   1.821504440372348e-06,   4.650994888261583e-08,
  -4.934603674933246e-10,  -2.150923842281412e-11,   2.161880302927378e-13,   1.486761826773181e-14,   1.039922600023067e-17,  -8.498286465935572e-18,  -1.005910285192727e-19,
   3.051597856477470e-21,   6.691578068449974e-23,   1.506212023275790e+00,  -1.360645279341706e-02,  -1.261888461140002e-04,   1.820735451538907e-06,   4.645982901420182e-08,
  -4.927498208844476e-10,  -2.144463546245936e-11,   2.162374216087015e-13,   1.480820068168238e-14,   9.546231355051265e-18,  -8.467050721700697e-18,  -9.978652596599969e-20,
   3.036751641913208e-21,   6.636989793355665e-23,   1.506199021474553e+00,  -1.360588913910259e-02,  -1.261601109820069e-04,   1.820227520770939e-06,   4.642673830967774e-08,
  -4.922802770386382e-10,  -2.140199445518045e-11,   2.162691842603910e-13,   1.476897870757454e-14,   8.983848419682119e-18,  -8.446438582723402e-18,  -9.925613240265008e-20,
   3.026972359384141e-21,   6.601094093144077e-23,   1.506192344808646e+00,  -1.360559969594592e-02,  -1.261453567605060e-04,   1.819966736908678e-06,   4.640975318415734e-08,
  -4.920391354805768e-10,  -2.138011093344979e-11,   2.162852258236432e-13,   1.474884874296015e-14,   8.695427340022127e-18,  -8.435861873499522e-18,  -9.898412245030245e-20,
   3.021959757056162e-21,   6.582713995775971e-23,   1.506190020994607e+00,  -1.360549895583663e-02,  -1.261402218393843e-04,   1.819875978709651e-06,   4.640384271398490e-08,
  -4.919552026378934e-10,  -2.137249650907331e-11,   2.162907662657748e-13,   1.474184429714172e-14,   8.595101707733019e-18,  -8.432181922616535e-18,  -9.888950612333004e-20,
   3.020216590956638e-21,   6.576325229042893e-23,   1.506189652240204e+00,  -1.360548296992213e-02,  -1.261394070180958e-04,   1.819861577108733e-06,   4.640290486824410e-08,
  -4.919418835894822e-10,  -2.137128831566581e-11,   2.162916434181937e-13,   1.474073288169373e-14,   8.579184352549742e-18,  -8.431598030089375e-18,  -9.887449462548818e-20,
   3.019940046461494e-21,   6.575311827509194e-23,   1.871859030685631e+00,  -5.881139450189527e-03,  -1.735159275765508e-04,  -3.505975781432636e-06,  -3.273586545242586e-08,
   8.390066922771589e-10,   4.815003181447885e-11,   1.115680534294401e-12,   6.976007117699370e-15,  -4.957616139253032e-16,  -2.163963126696831e-17,  -4.135523518489037e-19,
   1.699935511176036e-22,   2.807351426987893e-22,   1.871842727413448e+00,  -5.882122665279243e-03,  -1.735339580794275e-04,  -3.505171006055188e-06,  -3.266796322604149e-08,
   8.411756069979989e-10,   4.816646248880329e-11,   1.113954249840362e-12,   6.884886940409908e-15,  -4.978109906512779e-16,  -2.163486375874648e-17,  -4.114299144771842e-19,
   2.504005925133955e-22,   2.820180323717900e-22,   1.871813958704298e+00,  -5.883857376624636e-03,  -1.735657420892033e-04,  -3.503749322637431e-06,  -3.254813063268690e-08,
   8.449999021015507e-10,   4.819526032389925e-11,   1.110902631743098e-12,   6.724123564105511e-15,  -5.014181805878806e-16,  -2.162604858740060e-17,  -4.076774193061388e-19,
   3.921318302850757e-22,   2.842664641810739e-22,   1.871779169009545e+00,  -5.885954688760223e-03,  -1.736041226264615e-04,  -3.502027405141727e-06,  -3.240319716142145e-08,
   8.496195190077668e-10,   4.822975162584491e-11,   1.107203115761585e-12,   6.529761152252666e-15,  -5.057647218252652e-16,  -2.161470285749912e-17,  -4.031272708553942e-19,
   5.632595848681189e-22,   2.869592651095048e-22,   1.871745393407047e+00,  -5.887990388323349e-03,  -1.736413262515448e-04,  -3.500352864342448e-06,  -3.226246638643487e-08,
   8.540991691356478e-10,   4.826288824195995e-11,   1.103601797807803e-12,   6.341114693887448e-15,  -5.099682082246576e-16,  -2.160297057520581e-17,  -3.986969596900147e-19,
   7.291171864421434e-22,   2.895460978602303e-22,   1.871718182524956e+00,  -5.889630081339522e-03,  -1.736712572118867e-04,  -3.499001775818654e-06,  -3.214907280635317e-08,
   8.577043334171256e-10,   4.828933411557745e-11,   1.100693550669782e-12,   6.189171066769503e-15,  -5.133429561178403e-16,  -2.159300520414986e-17,  -3.951186245011293e-19,
   8.625341292456871e-22,   2.916104366380097e-22,   1.871700201229020e+00,  -5.890713443633357e-03,  -1.736910155700788e-04,  -3.498107972796262e-06,  -3.207413329038581e-08,
   8.600848049359374e-10,   4.830668739168705e-11,   1.098768376188457e-12,   6.088783234785549e-15,  -5.155672783989856e-16,  -2.158616879261142e-17,  -3.927495767980044e-19,
   9.505969434031282e-22,   2.929649178051348e-22,   1.871690966716688e+00,  -5.891269765606904e-03,  -1.737011564054079e-04,  -3.497648644436511e-06,  -3.203564485510421e-08,
   8.613067471855500e-10,   4.831556149941033e-11,   1.097778639312534e-12,   6.037233623452614e-15,  -5.167078250937901e-16,  -2.158258023990017e-17,  -3.915315559112921e-19,
   9.957913151864110e-22,   2.936575385376970e-22,   1.871687752519281e+00,  -5.891463392767545e-03,  -1.737046850564675e-04,  -3.497488720419889e-06,  -3.202224806121008e-08,
   8.617319687643461e-10,   4.831864422338027e-11,   1.097433982472856e-12,   6.019292007171449e-15,  -5.171045241943591e-16,  -2.158131884054575e-17,  -3.911073898916177e-19,
   1.011516822338942e-21,   2.938981384826585e-22,   1.871687242468481e+00,  -5.891494118456028e-03,  -1.737052449592398e-04,  -3.497463340280226e-06,  -3.202012214883592e-08,
   8.617994414600876e-10,   4.831913312483499e-11,   1.097379282117829e-12,   6.016444953032148e-15,  -5.171674616482478e-16,  -2.158111808663736e-17,  -3.910400700226215e-19,
   1.014012015175152e-21,   2.939362959195379e-22,   5.865221467122929e-03,  -1.011857038706533e-04,   1.299036514690993e-06,  -1.505238796168757e-08,   1.575208663082572e-10,
  -1.504241730335857e-12,   2.536427834368903e-14,   9.981641681171591e-17,   2.041335288698724e-18,  -2.062470591898860e-19,   5.865406600657930e-03,  -1.011921376207409e-04,
   1.299171320246158e-06,  -1.505452624878493e-08,   1.575750957417110e-10,  -1.503960436870878e-12,   2.537165837763222e-14,   9.875321250599696e-17,   2.004903606055488e-18,
  -2.064969612151835e-19,   5.865710541242360e-03,  -1.012027003223527e-04,   1.299392658883263e-06,  -1.505803631098645e-08,   1.576641331221775e-10,  -1.503500948831062e-12,
   2.538366959477502e-14,   9.700690134087086e-17,   1.945203071313327e-18,  -2.069024244042114e-19,   5.866033064621350e-03,  -1.012139090615880e-04,   1.299627561819757e-06,
  -1.506176037614504e-08,   1.577586235116990e-10,  -1.503016524397525e-12,   2.539627283916024e-14,   9.515273142125345e-17,   1.882003137455985e-18,  -2.073261417698708e-19,
   5.866286905921616e-03,  -1.012227310473013e-04,   1.299812464637352e-06,  -1.506469095935280e-08,   1.578329986257486e-10,  -1.502637545307338e-12,   2.540608928167750e-14,
   9.369262962855427e-17,   1.832371015631155e-18,  -2.076548970874974e-19,   5.866433408194390e-03,  -1.012278226479211e-04,   1.299919188886915e-06,  -1.506638214607435e-08,
   1.578759262172099e-10,  -1.502419737445923e-12,   2.541171354918242e-14,   9.284963398885611e-17,   1.803770115293420e-18,  -2.078427396357546e-19,   5.866488422293235e-03,
  -1.012297346437552e-04,   1.299959267402310e-06,  -1.506701718272525e-08,   1.578920467569267e-10,  -1.502338120153122e-12,   2.541381777465704e-14,   9.253301633649379e-17,
   1.793038282756728e-18,  -2.079129194710672e-19,   5.866497541722371e-03,  -1.012300515870265e-04,   1.299965911121717e-06,  -1.506712244804465e-08,   1.578947190093873e-10,
  -1.502324599978612e-12,   2.541416617180528e-14,   9.248052903817282e-17,   1.791259754837541e-18,  -2.079245339559928e-19,   5.297196577882714e-02,  -9.078227894727541e-04,
   1.142885691921690e-05,  -1.275834258613782e-07,   1.248111452921856e-09,  -1.053950972057752e-11,   1.838292525821418e-13,   1.601661008250388e-15,   1.017030053983341e-17,
  -1.790296164357320e-18,   5.297359433672141e-02,  -9.078773104919196e-04,   1.142992483745157e-05,  -1.275983853270372e-07,   1.248504243422229e-09,  -1.053487084373716e-11,
   1.838626644180869e-13,   1.592430958092950e-15,   9.826601360241940e-18,  -1.792507599131008e-18,   5.297626798835581e-02,  -9.079668201783835e-04,   1.143167824064708e-05,
  -1.276229390018597e-07,   1.249149120391433e-09,  -1.052727535041987e-11,   1.839165311699839e-13,   1.577270481346536e-15,   9.263350703146713e-18,  -1.796093861361596e-18,
   5.297910508929198e-02,  -9.080618031384551e-04,   1.143353906666526e-05,  -1.276489859598718e-07,   1.249833448824916e-09,  -1.051924310011996e-11,   1.839723519326309e-13,
   1.561173457055514e-15,   8.667041796596793e-18,  -1.799839151171503e-18,   5.298133801119066e-02,  -9.081365597624651e-04,   1.143500378525330e-05,  -1.276694804360167e-07,
   1.250372064677799e-09,  -1.051294134511054e-11,   1.840153170785966e-13,   1.548497419732890e-15,   8.198717845919668e-18,  -1.802743274815998e-18,   5.298262671759951e-02,
  -9.081797050897990e-04,   1.143584919869251e-05,  -1.276813063512871e-07,   1.250682928555477e-09,  -1.050931236537575e-11,   1.840397262543383e-13,   1.541178809617591e-15,
   7.928829976069497e-18,  -1.804401892498769e-18,   5.298311064789658e-02,  -9.081959069328059e-04,   1.143616667793449e-05,  -1.276857467511861e-07,   1.250799664435284e-09,
  -1.050795113826952e-11,   1.840488190721531e-13,   1.538430030484869e-15,   7.827558366691728e-18,  -1.805021429922221e-18,   5.298319086670414e-02,  -9.081985926383176e-04,
   1.143621930561745e-05,  -1.276864827926317e-07,   1.250819015257171e-09,  -1.050772557404915e-11,   1.840503224832480e-13,   1.537974351087391e-15,   7.810775051514169e-18,
  -1.805123953566396e-18,   1.481876463286499e-01,  -2.503594893306798e-03,   3.017387372481264e-05,  -3.081384644517519e-07,   2.504481205882009e-09,  -1.312691401821701e-11,
   2.916165368633417e-13,   7.632314442845618e-15,  -1.285925891113569e-18,  -4.907890788361011e-18,   1.481919446000385e-01,  -2.503726509700997e-03,   3.017601568602223e-05,
  -3.081569562283797e-07,   2.505103352446734e-09,  -1.310451006062269e-11,   2.915903634572489e-13,   7.607000250137139e-15,  -2.303019636907053e-18,  -4.914372417410299e-18,
   1.481990011292595e-01,  -2.503942584981659e-03,   3.017953244594276e-05,  -3.081872905980738e-07,   2.506124655193971e-09,  -1.306778512464825e-11,   2.915444828543935e-13,
   7.565419872454098e-15,  -3.969867893125500e-18,  -4.924884814866169e-18,   1.482064889526966e-01,  -2.504171865255823e-03,   3.018326452182094e-05,  -3.082194466516700e-07,
   2.507208263859930e-09,  -1.302889161499615e-11,   2.914918459133417e-13,   7.521268834119327e-15,  -5.734608742346912e-18,  -4.935865020173177e-18,   1.482123821267189e-01,
  -2.504352315609646e-03,   3.018620206293220e-05,  -3.082447311729481e-07,   2.508061015167050e-09,  -1.299833616912574e-11,   2.914475610899988e-13,   7.486499462921951e-15,
  -7.120630838342834e-18,  -4.944380358734795e-18,   1.482157832799287e-01,  -2.504456459270515e-03,   3.018789752677871e-05,  -3.082593143687792e-07,   2.508553132178326e-09,
  -1.298072365671121e-11,   2.914208584952659e-13,   7.466424518539095e-15,  -7.919392147112603e-18,  -4.949244173483019e-18,   1.482170604632705e-01,  -2.504495566672727e-03,
   3.018853421893368e-05,  -3.082647888044769e-07,   2.508737922692192e-09,  -1.297411407281321e-11,   2.914106151373002e-13,   7.458884510616478e-15,  -8.219119479268139e-18,
  -4.951061030307979e-18,   1.482172721755607e-01,  -2.504502049306676e-03,   3.018863976128171e-05,  -3.082656961809286e-07,   2.508768554135312e-09,  -1.297301865544104e-11,
   2.914089057484229e-13,   7.457634558647973e-15,  -8.268792202975383e-18,  -4.951361696347110e-18,   2.935887559005729e-01,  -4.840503520743387e-03,   5.388232396549433e-05,
  -4.554587796750316e-07,   2.017899209652243e-09,   1.742984176523671e-11,   1.089474869031516e-13,   2.014443949371325e-14,  -7.849569091704199e-18,  -1.074332357651543e-17,
   2.935964272186277e-01,  -4.840697876639176e-03,   5.388404824849237e-05,  -4.554334757516065e-07,   2.018130819648429e-09,   1.748915583180263e-11,   1.088727219730503e-13,
   2.008900346763676e-14,  -9.951024365517777e-18,  -1.075837770840919e-17,   2.936090211067017e-01,  -4.841016935381790e-03,   5.388687908077956e-05,  -4.553918746256407e-07,
   2.018510906511879e-09,   1.758640947905532e-11,   1.087439662231918e-13,   1.999794255466491e-14,  -1.339477628371265e-17,  -1.078282109892692e-17,   2.936223844372236e-01,
  -4.841355470601101e-03,   5.388988300650471e-05,  -4.553476502677444e-07,   2.018914014838611e-09,   1.768943997330144e-11,   1.085991784987907e-13,   1.990124744861654e-14,
  -1.704052427815438e-17,  -1.080838998600292e-17,   2.936329016237421e-01,  -4.841621891795079e-03,   5.389224725216716e-05,  -4.553127858966671e-07,   2.019231119337116e-09,
   1.777040734567063e-11,   1.084793236369176e-13,   1.982509587541988e-14,  -1.990370021236520e-17,  -1.082824684840752e-17,   2.936389713679627e-01,  -4.841775645545598e-03,
   5.389361176080765e-05,  -4.552926411256733e-07,   2.019414067562822e-09,   1.781708781599347e-11,   1.084077880874119e-13,   1.978112660463622e-14,  -2.155366809396033e-17,
  -1.083960002867399e-17,   2.936412506305479e-01,  -4.841833381015874e-03,   5.389412415799836e-05,  -4.552850720560138e-07,   2.019482755136887e-09,   1.783460783890927e-11,
   1.083804790740293e-13,   1.976461180896318e-14,  -2.217278836235618e-17,  -1.084384311370006e-17,   2.936416284516464e-01,  -4.841842951465250e-03,   5.389420909572767e-05,
  -4.552838171366183e-07,   2.019494140485334e-09,   1.783751156087118e-11,   1.083759286558972e-13,   1.976187404000562e-14,  -2.227539218154573e-17,  -1.084454540298182e-17,
   4.924431529918169e-01,  -7.802976836488497e-03,   7.513607924842070e-05,  -3.861498540493810e-07,  -2.920518153699907e-09,   9.885221676871863e-11,  -4.272817217211396e-14,
   2.997265898995098e-14,   1.892396178318526e-16,  -2.228487174649246e-17,   4.924538403922492e-01,  -7.803141192626590e-03,   7.513358511308392e-05,  -3.860084410198364e-07,
  -2.920601462858815e-09,   9.893995135997851e-11,  -4.205363276135303e-14,   2.985777324640122e-14,   1.853977518304471e-16,  -2.231212770812093e-17,   4.924713852336437e-01,
  -7.803410966026525e-03,   7.512949053718355e-05,  -3.857761991629069e-07,  -2.920737229819409e-09,   9.908373328298791e-11,  -4.095726805281512e-14,   2.966907258656353e-14,
   1.791017909778010e-16,  -2.235636792723071e-17,   4.924900013184177e-01,  -7.803697156911888e-03,   7.512514580927348e-05,  -3.855296511282537e-07,  -2.920879941279470e-09,
   9.923595902464605e-11,  -3.980887394131053e-14,   2.946871563543271e-14,   1.724363755519720e-16,  -2.240262416131579e-17,   4.925046520230486e-01,  -7.803922347520790e-03,
   7.512172643773477e-05,  -3.853355286883094e-07,  -2.920991287398933e-09,   9.935551668019167e-11,  -3.891588024333560e-14,   2.931093964438641e-14,   1.672015979411315e-16,
  -2.243853140244867e-17,   4.925131071302007e-01,  -7.804052292135474e-03,   7.511975303245955e-05,  -3.852234616574969e-07,  -2.921055161573160e-09,   9.942441758305815e-11,
  -3.840484013875058e-14,   2.921984661306387e-14,   1.641848960167995e-16,  -2.245905511116607e-17,   4.925162820879277e-01,  -7.804101084362150e-03,   7.511901199555559e-05,
  -3.851813727289672e-07,  -2.921079074316171e-09,   9.945027200091478e-11,  -3.821375624022206e-14,   2.918563323247556e-14,   1.630529249765724e-16,  -2.246672434583908e-17,
   4.925168083816097e-01,  -7.804109172199694e-03,   7.511888915789206e-05,  -3.851743955362126e-07,  -2.921083034370230e-09,   9.945455676173715e-11,  -3.818212442247861e-14,
   2.917996150422002e-14,   1.628653284041719e-16,  -2.246799364660132e-17,   7.492228583026246e-01,  -1.110967972995732e-02,   7.908753328968650e-05,   1.892537385204449e-07,
  -1.387467780511249e-08,   1.626139460233818e-10,   2.115265716551860e-12,   1.209805688855648e-14,   6.206596332844263e-16,  -3.394187732133765e-17,   7.492340892683141e-01,
  -1.110959811476982e-02,   7.907571222826943e-05,   1.894854291915514e-07,  -1.387013534378228e-08,   1.626473037997020e-10,   2.117574756325895e-12,   1.192316990034639e-14,
   6.127352212519662e-16,  -3.397995576150695e-17,   7.492525255049495e-01,  -1.110946405866924e-02,   7.905630885410666e-05,   1.898658200814180e-07,  -1.386267468271571e-08,
   1.627016875985164e-10,   2.121342712855703e-12,   1.163593004714536e-14,   5.997462640335515e-16,  -3.404161359540671e-17,   7.492720861310688e-01,  -1.110932171752118e-02,
   7.903572419631186e-05,   1.902694890649233e-07,  -1.385475364013769e-08,   1.627588785929767e-10,   2.125309978739139e-12,   1.133096522254576e-14,   5.859915335547574e-16,
  -3.410587659173446e-17,   7.492874792551132e-01,  -1.110920962386311e-02,   7.901952673045657e-05,   1.905872109807901e-07,  -1.384851634679165e-08,   1.628035156310558e-10,
   2.128409943325813e-12,   1.109082651642351e-14,   5.751864708477244e-16,  -3.415561154948122e-17,   7.492963624504343e-01,  -1.110914490418924e-02,   7.901017996602256e-05,
   1.907705874052933e-07,  -1.384491532841141e-08,   1.628291271523758e-10,   2.130190065079160e-12,   1.095218619738636e-14,   5.689586778257132e-16,  -3.418397772495988e-17,
   7.492996980883507e-01,  -1.110912059597184e-02,   7.900667037284104e-05,   1.908394495066828e-07,  -1.384356285478943e-08,   1.628387162930572e-10,   2.130856831923598e-12,
   1.090011568401686e-14,   5.666215966605667e-16,  -3.419456584147455e-17,   7.493002510133194e-01,  -1.110911656625535e-02,   7.900608861860476e-05,   1.908508645137245e-07,
  -1.384333864946780e-08,   1.628403043404681e-10,   2.130967269121819e-12,   1.089148374095276e-14,   5.662342720647659e-16,  -3.419631761481102e-17,   1.068740269106035e+00,
  -1.403264737033976e-02,   3.610569651915426e-05,   1.535346219698793e-06,  -2.069188916078750e-08,  -1.538043981737253e-10,   9.984282619613324e-12,   6.326110670956894e-14,
  -1.468771034210046e-15,  -3.251147253000237e-17,   1.068745371926906e+00,  -1.403199266460655e-02,   3.608814917596667e-05,   1.535128915071457e-06,  -2.067064937504013e-08,
  -1.536181055817557e-10,   9.978186330950601e-12,   6.308905916860547e-14,  -1.480559999275408e-15,  -3.271768200750764e-17,   1.068753747247890e+00,  -1.403091792584190e-02,
   3.605935545606720e-05,   1.534772364805521e-06,  -2.063579036330804e-08,  -1.533126512933835e-10,   9.968144573666378e-12,   6.280586573089180e-14,  -1.499871734999943e-15,
  -3.305435158352737e-17,   1.068762631685129e+00,  -1.402977763550097e-02,   3.602882087250119e-05,   1.534394296037235e-06,  -2.059881524353345e-08,  -1.529890514258938e-10,
   9.957443740562307e-12,   6.250436067064262e-14,  -1.520306184030292e-15,  -3.340906074562706e-17,   1.068769622028276e+00,  -1.402888028654734e-02,   3.600480286443536e-05,
   1.534096941010423e-06,  -2.056972505436488e-08,  -1.527347471082951e-10,   9.948989054536404e-12,   6.226634272677824e-14,  -1.536347048606422e-15,  -3.368639186367447e-17,
   1.068773655588438e+00,  -1.402836243518106e-02,   3.599094676027052e-05,   1.533925406545622e-06,  -2.055294032244695e-08,  -1.525881318460481e-10,   9.944096449259416e-12,
   6.212868552017695e-14,  -1.545588037755998e-15,  -3.384571280559755e-17,   1.068775170097430e+00,  -1.402816798180636e-02,   3.598574463017816e-05,   1.533861007805416e-06,
  -2.054663820500035e-08,  -1.525331044959519e-10,   9.942256726743826e-12,   6.207693872034217e-14,  -1.549054999701258e-15,  -3.390540100028302e-17,   1.068775421141960e+00,
  -1.402813574863793e-02,   3.598488235407610e-05,   1.533850333539125e-06,  -2.054559357663547e-08,  -1.525239844101268e-10,   9.941951634536324e-12,   6.206835804100797e-14,
  -1.549629533571273e-15,  -3.391528787160835e-17,   1.450002532103970e+00,  -1.452276414581077e-02,  -1.004428232646380e-04,   2.467368222162034e-06,   3.232818477915478e-08,
  -8.939150165450482e-10,  -9.395360723728629e-12,   6.351670884128879e-13,   8.778725244857285e-15,  -3.688794010111059e-16,   1.449988293636079e+00,  -1.452171520742455e-02,
  -1.004153312013700e-04,   2.466111862596556e-06,   3.230852933944941e-08,  -8.920466831332967e-10,  -9.361547377846830e-12,   6.332975850355934e-13,   8.722334481697726e-15,
  -3.681229761317737e-16,   1.449964921696000e+00,  -1.451999358925179e-02,  -1.003702105327594e-04,   2.464051254294371e-06,   3.227631330366470e-08,  -8.889835363205024e-10,
  -9.306198601015326e-12,   6.302312876039245e-13,   8.629951854576811e-15,  -3.668819734436582e-16,   1.449940126078578e+00,  -1.451816734080375e-02,  -1.003223503112407e-04,
   2.461867382195840e-06,   3.224219952409471e-08,  -8.857387676169240e-10,  -9.247688192612004e-12,   6.269815060349575e-13,   8.532187385709766e-15,  -3.655662345842306e-16,
   1.449920614560722e+00,  -1.451673045100248e-02,  -1.002846958500413e-04,   2.460150538693928e-06,   3.221540232088069e-08,  -8.831890731236829e-10,  -9.201798461588342e-12,
   6.244266587960122e-13,   8.455434772385969e-15,  -3.645314980795664e-16,   1.449909355189750e+00,  -1.451590134496819e-02,  -1.002629694436018e-04,   2.459160465872062e-06,
   3.219995734701072e-08,  -8.817191792919461e-10,  -9.175377963956267e-12,   6.229533076140672e-13,   8.411214857039270e-15,  -3.639346311242979e-16,   1.449905127393300e+00,
  -1.451559003597020e-02,  -1.002548118534328e-04,   2.458788825585078e-06,   3.219416142262658e-08,  -8.811675189683988e-10,  -9.165468771439356e-12,   6.224002576712217e-13,
   8.394624106214548e-15,  -3.637105578592457e-16,   1.449904426586564e+00,  -1.451553843355434e-02,  -1.002534596631138e-04,   2.458727228372246e-06,   3.219320086645453e-08,
  -8.810760891670503e-10,  -9.163826812031212e-12,   6.223085927028268e-13,   8.391874704279193e-15,  -3.636734174629963e-16,   1.845279961260282e+00,  -7.444798961017770e-03,
  -2.179436593633741e-04,  -3.821759025990199e-06,  -1.825465304811343e-09,   2.371514198316154e-09,   7.844050351596647e-11,   8.532432832181663e-13,  -3.030221524864862e-14,
  -1.648215392217006e-15,   1.845248945048094e+00,  -7.446418555611268e-03,  -2.179442785209420e-04,  -3.818363911787289e-06,  -1.659512679871842e-09,   2.373930110335427e-09,
   7.831577740030358e-11,   8.448530436968486e-13,  -3.049548288730083e-14,  -1.646266143490411e-15,   1.845198027001258e+00,  -7.449076330011218e-03,  -2.179451930277066e-04,
  -3.812787852986516e-06,  -1.387269120292722e-09,   2.377878134115649e-09,   7.811047049530603e-11,   8.310867207187821e-13,  -3.081140163120179e-14,  -1.643013668693249e-15,
   1.845143999139399e+00,  -7.451895003590558e-03,  -2.179460249106422e-04,  -3.806867932086081e-06,  -1.098662507280452e-09,   2.382042720302508e-09,   7.789188028930871e-11,
   8.164900407160054e-13,  -3.114476483845125e-14,  -1.639491425332516e-15,   1.845101479020350e+00,  -7.454112278497936e-03,  -2.179465793962835e-04,  -3.802206548052977e-06,
  -8.717197016218268e-10,   2.385302487939128e-09,   7.771931187343291e-11,   8.050100278320653e-13,  -3.140578265467917e-14,  -1.636668062005110e-15,   1.845076939866582e+00,
  -7.455391495817907e-03,  -2.179468592486644e-04,  -3.799515422721149e-06,  -7.408236985124576e-10,   2.387176637485209e-09,   7.761950465754746e-11,   7.983877820664950e-13,
  -3.155588349368122e-14,  -1.635018114226712e-15,   1.845067725177757e+00,  -7.455871776117426e-03,  -2.179469567488999e-04,  -3.798504699255110e-06,  -6.916855397615312e-10,
   2.387879052660499e-09,   7.758198555862117e-11,   7.959016509994919e-13,  -3.161214620747021e-14,  -1.634394668051776e-15,   1.845066197711583e+00,  -7.455951385308880e-03,
  -2.179469725107554e-04,  -3.798337147930362e-06,  -6.835409567341810e-10,   2.387995416997165e-09,   7.757576409616235e-11,   7.954895702915053e-13,  -3.162146719488983e-14,
  -1.634291118678534e-15,   5.480177004570956e-03,  -9.147514735846221e-05,   1.132646893449223e-06,  -1.273867862324963e-08,   1.337529222758582e-10,  -8.630737684620030e-13,
   2.763243270106809e-14,   1.068894341889640e-18,  -9.521291003139898e-18,  -4.203099426393010e-19,   5.480338418878360e-03,  -9.148059012140412e-05,   1.132761428974708e-06,
  -1.273990712846576e-08,   1.338114510911277e-10,  -8.631042310299065e-13,   2.759411832717023e-14,  -1.042561017954332e-18,  -9.539696786841325e-18,  -4.187571040685433e-19,
   5.480603418429504e-03,  -9.148952567707937e-05,   1.132949493557684e-06,  -1.274192396396947e-08,   1.339074763065529e-10,  -8.631587736842784e-13,   2.753116786551128e-14,
  -4.503069344757869e-18,  -9.569600164335130e-18,  -4.162028850615873e-19,   5.480884619532204e-03,  -9.149900750801240e-05,   1.133149093497857e-06,  -1.274406404653216e-08,
   1.340092858362847e-10,  -8.632228020754067e-13,   2.746430344619671e-14,  -8.167060672004790e-18,  -9.600905428127665e-18,  -4.134859323994881e-19,   5.481105937934714e-03,
  -9.150647013221933e-05,   1.133306215076336e-06,  -1.274574835124938e-08,   1.340893520487012e-10,  -8.632776433137668e-13,   2.741163114314899e-14,  -1.104493127099964e-17,
  -9.625235817060321e-18,  -4.113428387907058e-19,   5.481233669785836e-03,  -9.151077710827347e-05,   1.133396907187263e-06,  -1.274672041653388e-08,   1.341355363961053e-10,
  -8.633110754860574e-13,   2.738121315069073e-14,  -1.270351533795499e-17,  -9.639154409204828e-18,  -4.101040897127844e-19,   5.481281635249450e-03,  -9.151239444890481e-05,
   1.133430965655465e-06,  -1.274708544059103e-08,   1.341528746481187e-10,  -8.633239662452439e-13,   2.736978716924784e-14,  -1.332589676001753e-17,  -9.644357753899912e-18,
  -4.096385640771739e-19,   5.481289586258214e-03,  -9.151266254775739e-05,   1.133436611475373e-06,  -1.274714594875980e-08,   1.341557484778486e-10,  -8.633261208274930e-13,
   2.736789295324975e-14,  -1.342904251884122e-17,  -9.645219057878669e-18,  -4.095613774205367e-19,   4.951430019859478e-02,  -8.221908396248976e-04,   1.001153621241411e-05,
  -1.090452551725200e-07,   1.084954148901176e-09,  -5.627601731778351e-12,   2.204849758803586e-13,   4.700239133784179e-16,  -9.319944803280524e-17,  -3.804620165727853e-18,
   4.951572678202790e-02,  -8.222374217075320e-04,   1.001246523320117e-05,  -1.090532546520667e-07,   1.085420339404813e-09,  -5.626501609887837e-12,   2.201100282828111e-13,
   4.509187655855841e-16,  -9.337491730195190e-17,  -3.790281252795417e-18,   4.951806884566443e-02,  -8.223138962038925e-04,   1.001399065750984e-05,  -1.090663860876533e-07,
   1.086185086221918e-09,  -5.624736596482786e-12,   2.194940022572711e-13,   4.196080154163307e-16,  -9.366010195769255e-17,  -3.766695412434484e-18,   4.952055408676503e-02,
  -8.223950449106587e-04,   1.001560963955967e-05,  -1.090803182132872e-07,   1.086995752563513e-09,  -5.622919459771289e-12,   2.188396911607430e-13,   3.864576138322040e-16,
  -9.395879953696672e-17,  -3.741606632461171e-18,   4.952251007912131e-02,  -8.224589117988126e-04,   1.001688406840617e-05,  -1.090912819155052e-07,   1.087633179562040e-09,
  -5.621529626733881e-12,   2.183242706830253e-13,   3.604208000835014e-16,  -9.419105172537786e-17,  -3.721816780892730e-18,   4.952363895846352e-02,  -8.224957716026933e-04,
   1.001761967898899e-05,  -1.090976089060330e-07,   1.088000821889508e-09,  -5.620743649891745e-12,   2.180266225319015e-13,   3.454156047566483e-16,  -9.432395792245364e-17,
  -3.710377796301187e-18,   4.952406287104697e-02,  -8.225096130096457e-04,   1.001789592938726e-05,  -1.090999846834531e-07,   1.088138831894868e-09,  -5.620451553222295e-12,
   2.179148171238347e-13,   3.397850067816973e-16,  -9.437365186217619e-17,  -3.706078977772036e-18,   4.952413314100347e-02,  -8.225119074306810e-04,   1.001794172296899e-05,
  -1.091003784988681e-07,   1.088161706741791e-09,  -5.620403294631567e-12,   2.178962819041420e-13,   3.388518657681483e-16,  -9.438187807564985e-17,  -3.705366209794985e-18,
   1.386335691676718e-01,  -2.276330461492637e-03,   2.670940323742594e-05,  -2.697167652877055e-07,   2.328358372685473e-09,  -3.777050703889647e-12,   4.691365513802984e-13,
   3.504017084552378e-15,  -2.931877695961710e-16,  -1.088018301097545e-17,   1.386373741212279e-01,  -2.276445628214772e-03,   2.671139687983904e-05,  -2.697220600384742e-07,
   2.329345775435785e-09,  -3.767449620585091e-12,   4.679575028503452e-13,   3.449400517861646e-15,  -2.937167045658803e-16,  -1.083847444065776e-17,   1.386436207744339e-01,
  -2.276634694649126e-03,   2.671467037151611e-05,  -2.697307427149503e-07,   2.330964932136084e-09,  -3.751805125713718e-12,   4.660204286069120e-13,   3.359894047449508e-15,
  -2.945766504675385e-16,  -1.076986701182212e-17,   1.386502492365094e-01,  -2.276835310951347e-03,   2.671814462083326e-05,  -2.697399428415141e-07,   2.332680501376320e-09,
  -3.735364257883988e-12,   4.639630513310084e-13,   3.265132323569656e-15,  -2.954777332916329e-16,  -1.069688547361526e-17,   1.386554660739235e-01,  -2.276993198629314e-03,
   2.672087946771387e-05,  -2.697471741270428e-07,   2.334028866001831e-09,  -3.722540292356142e-12,   4.623424528690359e-13,   3.190707735931574e-15,  -2.961786554613432e-16,
  -1.063931649132823e-17,   1.386584768941612e-01,  -2.277084319334235e-03,   2.672245803943686e-05,  -2.697513437474717e-07,   2.334806312801653e-09,  -3.715185414487671e-12,
   4.614066033101622e-13,   3.147817405819249e-15,  -2.965798735009422e-16,  -1.060603964346261e-17,   1.386596075024777e-01,  -2.277118536185681e-03,   2.672305085380223e-05,
  -2.697529087848710e-07,   2.335098115531528e-09,  -3.712432289249798e-12,   4.610550750711913e-13,   3.131723303117898e-15,  -2.967299118999346e-16,  -1.059353393828118e-17,
   1.386597949178007e-01,  -2.277124208124945e-03,   2.672314912364146e-05,  -2.697531681755255e-07,   2.335146478820822e-09,  -3.711976378397967e-12,   4.609967985767182e-13,
   3.129056089636261e-15,  -2.967547500569128e-16,  -1.059146041630446e-17,   2.750550562357565e-01,  -4.430729734215625e-03,   4.862301173153640e-05,  -4.200557898816574e-07,
   2.436323778845109e-09,   2.633293443343628e-11,   5.925395244979987e-13,   1.108523624777595e-14,  -6.344504840100274e-16,  -2.320486867891283e-17,   2.750619798449942e-01,
  -4.430908931921461e-03,   4.862509895144073e-05,  -4.200180538562349e-07,   2.437558287934716e-09,   2.636420472574981e-11,   5.899887768714427e-13,   1.096870567328276e-14,
  -6.355619106334374e-16,  -2.311764096652365e-17,   2.750733462862283e-01,  -4.431203102261320e-03,   4.862852621302053e-05,  -4.199560726685719e-07,   2.439580987127071e-09,
   2.641528980244490e-11,   5.857982130185873e-13,   1.077772706757126e-14,  -6.373686843705666e-16,  -2.297414973454197e-17,   2.750854072527216e-01,  -4.431515223828352e-03,
   4.863216382356951e-05,  -4.198902633101134e-07,   2.441721860063383e-09,   2.646915540327970e-11,   5.813475174226156e-13,   1.057552655447092e-14,  -6.392616254729146e-16,
  -2.282149891830263e-17,   2.750948995095330e-01,  -4.431760853626438e-03,   4.863502738046035e-05,  -4.198384403178923e-07,   2.443402850283320e-09,   2.651130232863326e-11,
   5.778417896989323e-13,   1.041671456252210e-14,  -6.407338879242304e-16,  -2.270107747104403e-17,   2.751003777618687e-01,  -4.431902606768882e-03,   4.863668029072753e-05,
  -4.198085199933562e-07,   2.444371423438288e-09,   2.653552780077819e-11,   5.758173676135893e-13,   1.032518982879693e-14,  -6.415765538783492e-16,  -2.263146650884825e-17,
   2.751024349162228e-01,  -4.431955835610602e-03,   4.863730103079763e-05,  -4.197972823005653e-07,   2.444734837511732e-09,   2.654460613061805e-11,   5.750569514063093e-13,
   1.029084573827852e-14,  -6.418916599550576e-16,  -2.260530554372585e-17,   2.751027759198534e-01,  -4.431964659006972e-03,   4.863740393029357e-05,  -4.197954193701943e-07,
   2.444795063043499e-09,   2.654611001406675e-11,   5.749308896560342e-13,   1.028515399906122e-14,  -6.419438235022116e-16,  -2.260096786447600e-17,   4.624031534320689e-01,
  -7.221066454622980e-03,   7.028775838303079e-05,  -4.168310449035523e-07,  -8.859885285416317e-10,   1.076679916192984e-10,   7.263367559112394e-13,   1.840473708905445e-14,
  -1.051255228261926e-15,  -4.504678023118048e-17,   4.624131543923543e-01,  -7.221243866068167e-03,   7.028701036121726e-05,  -4.166773948263917e-07,  -8.844883890118055e-10,
   1.077193833839231e-10,   7.221066779932586e-13,   1.817828776157194e-14,  -1.053273914872048e-15,  -4.488610719412986e-17,   4.624295725121366e-01,  -7.221535068165494e-03,
   7.028578327207843e-05,  -4.164251019886760e-07,  -8.820322151070224e-10,   1.078032649839455e-10,   7.151566958104708e-13,   1.780713369960006e-14,  -1.056554923156661e-15,
  -4.462177626680196e-17,   4.624469933042156e-01,  -7.221843991530284e-03,   7.028448246982956e-05,  -4.161573302454715e-07,  -8.794349285819606e-10,   1.078916096362183e-10,
   7.077746351590666e-13,   1.741412597983136e-14,  -1.059991528831560e-15,  -4.434054393294951e-17,   4.624607034853769e-01,  -7.222087069087214e-03,   7.028345962344438e-05,
  -4.159465423393021e-07,  -8.773973006832093e-10,   1.079606598932375e-10,   7.019594583620491e-13,   1.710541810586284e-14,  -1.062663753882659e-15,  -4.411866819071745e-17,
   4.624686158694728e-01,  -7.222227335154927e-03,   7.028286967570384e-05,  -4.158248724897914e-07,  -8.762239325459828e-10,   1.080003189464500e-10,   6.986012324101903e-13,
   1.692749405133450e-14,  -1.064192969970591e-15,  -4.399040229059720e-17,   4.624715870427978e-01,  -7.222280002915150e-03,   7.028264821185189e-05,  -4.157791804744923e-07,
  -8.757838102099510e-10,   1.080151751984344e-10,   6.973397759162484e-13,   1.686072668513724e-14,  -1.064764754292704e-15,  -4.394219627904417e-17,   4.624720795570106e-01,
  -7.222288733163366e-03,   7.028261150460194e-05,  -4.157716061698855e-07,  -8.757108794368681e-10,   1.080176359300610e-10,   6.971306498951341e-13,   1.684966140723985e-14,
  -1.064859406431598e-15,  -4.393420328882620e-17,   7.060589445971958e-01,  -1.047140342788677e-02,   8.014324253654407e-05,  -3.826930339709457e-09,  -1.008176928659494e-08,
   2.182094769954039e-10,   2.478595590317149e-12,   2.696938466348466e-15,  -1.488649203648543e-15,  -8.001649637615128e-17,   7.060703323183550e-01,  -1.047140396459492e-02,
   8.013466381255176e-05,  -3.516394107496630e-09,  -1.007655008239894e-08,   2.182111291195628e-10,   2.472575885449408e-12,   2.294963281347542e-15,  -1.492946453222673e-15,
  -7.972119165454267e-17,   7.060890262285444e-01,  -1.047140474986660e-02,   8.012058364644758e-05,  -3.006599570153205e-09,  -1.006799124751505e-08,   2.182129782814848e-10,
   2.462681523958379e-12,   1.636157025607466e-15,  -1.499942772024153e-15,  -7.923539045626929e-17,   7.061088607202824e-01,  -1.047140545287147e-02,   8.010564784471767e-05,
  -2.465669932325092e-09,  -1.005892235716924e-08,   2.182137687132972e-10,   2.452166567944748e-12,   9.386111344938957e-16,  -1.507287223004011e-15,  -7.871855199457217e-17,
   7.061244697067753e-01,  -1.047140591185109e-02,   8.009389643202200e-05,  -2.039957124326256e-09,  -1.005179429212308e-08,   2.182135434944112e-10,   2.443879531859329e-12,
   3.907253639379274e-16,  -1.513010065887763e-15,  -7.831081462452951e-17,   7.061334776123271e-01,  -1.047140613894174e-02,   8.008711572050889e-05,  -1.794270728497957e-09,
  -1.004768423650089e-08,   2.182130742185798e-10,   2.439092250911457e-12,   7.496581837451784e-17,  -1.516289887789979e-15,  -7.807510948344079e-17,   7.061368601050856e-01,
  -1.047140621707283e-02,   8.008456973368920e-05,  -1.702013208025749e-09,  -1.004614156751655e-08,   2.182128339104729e-10,   2.437293699388405e-12,  -4.352255200056956e-17,
  -1.517517159221891e-15,  -7.798652602019787e-17,   7.061374207982292e-01,  -1.047140622964732e-02,   8.008414771247272e-05,  -1.686720212481473e-09,  -1.004588588486896e-08,
   2.182127906958982e-10,   2.436995517378491e-12,  -6.315934277762706e-17,  -1.517720368425737e-15,  -7.797183815373228e-17,   1.013295912832944e+00,  -1.367588003232531e-02,
   5.248546677743799e-05,   1.193174159352717e-06,  -2.126235059058420e-08,   1.001186056940547e-10,   1.080866568677790e-11,  -1.841407899563555e-14,  -4.130223821731162e-15,
  -1.134029161335101e-16,   1.013303345654581e+00,  -1.367537013868164e-02,   5.246744154770475e-05,   1.193316086168848e-06,  -2.123947623908087e-08,   1.000545202125527e-10,
   1.079202457356605e-11,  -1.898237695232839e-14,  -4.139190802619521e-15,  -1.129327099662176e-16,   1.013315546001309e+00,  -1.367453302205700e-02,   5.243786426866602e-05,
   1.193549012339264e-06,  -2.120195005937838e-08,   9.994809428560705e-11,   1.076468033055654e-11,  -1.991357481626225e-14,  -4.153795986337406e-15,  -1.121589157045482e-16,
   1.013328489021860e+00,  -1.367364471725405e-02,   5.240649957971088e-05,   1.193796069640410e-06,  -2.116216692719304e-08,   9.983351319418672e-11,   1.073563195967712e-11,
  -2.089925849128660e-14,  -4.169136270045151e-15,  -1.113353254421962e-16,   1.013338673444646e+00,  -1.367294557373350e-02,   5.238182921953457e-05,   1.193990435448687e-06,
  -2.113088278285158e-08,   9.974214068185513e-11,   1.071274625399378e-11,  -2.167326391585414e-14,  -4.181095616208557e-15,  -1.106853307216781e-16,   1.013344550351897e+00,
  -1.367254206711405e-02,   5.236759700767248e-05,   1.194102579687261e-06,  -2.111283827423822e-08,   9.968892870683772e-11,   1.069952869795316e-11,  -2.211926202248175e-14,
  -4.187952108613421e-15,  -1.103094779829718e-16,   1.013346757052513e+00,  -1.367239054311120e-02,   5.236225371657531e-05,   1.194144685637443e-06,  -2.110606430711917e-08,
   9.966885658855622e-11,   1.069456353361870e-11,  -2.228660716405782e-14,  -4.190518197232697e-15,  -1.101682043355815e-16,   1.013347122837526e+00,  -1.367236542566715e-02,
   5.236136804476687e-05,   1.194151665019869e-06,  -2.110494152669173e-08,   9.966552457533355e-11,   1.069374038959649e-11,  -2.231434007226502e-14,  -4.190943109953167e-15,
  -1.101447789780512e-16,   1.390502471329432e+00,  -1.520048641451952e-02,  -6.834306022258108e-05,   2.835779690982319e-06,   1.373936217179757e-08,  -8.887238605473872e-10,
   9.896633143709782e-12,   6.460814647262963e-13,  -9.408530832980162e-15,  -5.847308510418456e-16,   1.390492769438310e+00,  -1.519928016663592e-02,  -6.833121200514953e-05,
   2.834530835634471e-06,   1.376004191913799e-08,  -8.868398694623399e-10,   9.859114999871352e-12,   6.431456889342769e-13,  -9.410067773752248e-15,  -5.825019615883526e-16,
   1.390476843450692e+00,  -1.519730029712224e-02,  -6.831174861751038e-05,   2.832482555806473e-06,   1.379393317338493e-08,  -8.837532954291083e-10,   9.797519349764639e-12,
   6.383343891259740e-13,  -9.412437152122838e-15,  -5.788431213077581e-16,   1.390459946428509e+00,  -1.519520002085842e-02,  -6.829107932516254e-05,   2.830311776248879e-06,
   1.382981572301433e-08,  -8.804867573218565e-10,   9.732157029869911e-12,   6.332404418175414e-13,  -9.414742156700418e-15,  -5.749611527726422e-16,   1.390446649601287e+00,
  -1.519354746742163e-02,  -6.827480009351505e-05,   2.828605243667857e-06,   1.385799850214344e-08,  -8.779221614058860e-10,   9.680713419974386e-12,   6.292395970696451e-13,
  -9.416404730887085e-15,  -5.719062833026371e-16,   1.390438976230706e+00,  -1.519259389676251e-02,  -6.826540006915581e-05,   2.827621123967068e-06,   1.387424049568354e-08,
  -8.764445603788652e-10,   9.651023118870644e-12,   6.269338855021655e-13,  -9.417303486650372e-15,  -5.701433664098987e-16,   1.390436094896087e+00,  -1.519223584988568e-02,
  -6.826186932937403e-05,   2.827251719567318e-06,   1.388033520881388e-08,  -8.758901744586059e-10,   9.639873898553634e-12,   6.260686829352763e-13,  -9.417629492919899e-15,
  -5.694813944480193e-16,   1.390435617278503e+00,  -1.519217649998819e-02,  -6.826128400929222e-05,   2.827190493006588e-06,   1.388134526701340e-08,  -8.757983017365303e-10,
   9.638025744433345e-12,   6.259252956719308e-13,  -9.417682927134455e-15,  -5.693716642314680e-16,   1.811728138348489e+00,  -9.367990309394973e-03,  -2.620677233497912e-04,
  -3.363866880131133e-06,   6.553802565989847e-08,   4.368661045983110e-09,   7.835360868757975e-11,  -1.259642062247673e-12,  -1.050789770573412e-13,  -2.139265740763873e-15,
   1.811690958578722e+00,  -9.369404578989365e-03,  -2.620108468149265e-04,  -3.357683281701921e-06,   6.570035680334790e-08,   4.364731423162920e-09,   7.793868569282994e-11,
  -1.270051649154130e-12,  -1.048993149123376e-13,  -2.118745976676929e-15,   1.811629927963409e+00,  -9.371724431296937e-03,  -2.619173761563339e-04,  -3.347536013921341e-06,
   6.596621152631158e-08,   4.358258183815883e-09,   7.725805355488768e-11,  -1.287064964860678e-12,  -1.046019792942860e-13,  -2.085095744979490e-15,   1.811565177914962e+00,
  -9.374183392190615e-03,  -2.618180627428996e-04,  -3.336774576383698e-06,   6.624743713328284e-08,   4.351359592906652e-09,   7.653657580627102e-11,  -1.305014593250528e-12,
  -1.042832481236952e-13,  -2.049440119554832e-15,   1.811514225192463e+00,  -9.376116738674225e-03,  -2.617398058437278e-04,  -3.328309331122300e-06,   6.646813593685792e-08,
   4.345908726895319e-09,   7.596929727072368e-11,  -1.319066664902527e-12,  -1.040300742157484e-13,  -2.021415501694579e-15,   1.811484821748682e+00,  -9.377231761868334e-03,
  -2.616946035419776e-04,  -3.323425504220507e-06,   6.659525422772909e-08,   4.342754274786084e-09,   7.564212244037862e-11,  -1.327146594959777e-12,  -1.038830320849820e-13,
  -2.005256740226752e-15,   1.811473780911033e+00,  -9.377650322643731e-03,  -2.616776223172632e-04,  -3.321591887434203e-06,   6.664294092510039e-08,   4.341568114322110e-09,
   7.551930535563352e-11,  -1.330175059818327e-12,  -1.038276408753151e-13,  -1.999191777804850e-15,   1.811471950757788e+00,  -9.377719697618076e-03,  -2.616748070506790e-04,
  -3.321287955504580e-06,   6.665084317307355e-08,   4.341371405201237e-09,   7.549894879556194e-11,  -1.330676774309287e-12,  -1.038184497458594e-13,  -1.998186572294866e-15,
   5.131480548596779e-03,  -8.299012886294496e-05,   9.921682573988646e-07,  -1.070148381504603e-08,   1.228868753271505e-10,  -2.482912298927031e-13,   2.107573308494825e-14,
  -5.470010863920827e-16,  -2.387319651291743e-17,  -2.646913389264635e-19,   5.131621952935460e-03,  -8.299469886275964e-05,   9.922734317148322e-07,  -1.070185113645812e-08,
   1.229307586933876e-10,  -2.499455191015892e-13,   2.098247464338625e-14,  -5.482421354643627e-16,  -2.378339675150100e-17,  -2.603909032482854e-19,   5.131854101907022e-03,
  -8.300220137393458e-05,   9.924461191137005e-07,  -1.070245586361647e-08,   1.230026574547875e-10,  -2.526639088378745e-13,   2.082963541521514e-14,  -5.502637370452265e-16,
  -2.363580486955258e-17,  -2.533499055004978e-19,   5.132100444676624e-03,  -8.301016227730248e-05,   9.926293900822180e-07,  -1.070309985081826e-08,   1.230787536233492e-10,
  -2.555518539951877e-13,   2.066781425716759e-14,  -5.523874029445687e-16,  -2.347896864590493e-17,  -2.459045433004156e-19,   5.132294328424954e-03,  -8.301642766555810e-05,
   9.927736515362236e-07,  -1.070360835658116e-08,   1.231385014383859e-10,  -2.578272185667363e-13,   2.054071599610196e-14,  -5.540432683073057e-16,  -2.335537337135532e-17,
  -2.400636315180681e-19,   5.132406226814565e-03,  -8.302004359000015e-05,   9.928569181477150e-07,  -1.070390250078033e-08,   1.231729269008389e-10,  -2.591413879354768e-13,
   2.046746772458553e-14,  -5.549927090850041e-16,  -2.328397892211391e-17,  -2.367002049581473e-19,   5.132448246582939e-03,  -8.302140141435690e-05,   9.928881875724927e-07,
  -1.070401308258746e-08,   1.231858433943990e-10,  -2.596350623058491e-13,   2.043998167445289e-14,  -5.553480644691394e-16,  -2.325715735361055e-17,  -2.354386195379534e-19,
   5.132455212003760e-03,  -8.302162649364264e-05,   9.928933710318711e-07,  -1.070403141984452e-08,   1.231879839285358e-10,  -2.597169059456793e-13,   2.043542649206411e-14,
  -5.554069080659654e-16,  -2.325271065080981e-17,  -2.352295683599531e-19,   4.637784166883539e-02,  -7.470443088432891e-04,   8.804359858638525e-06,  -9.230214627121942e-08,
   1.024090897857193e-09,  -6.450226621415265e-13,   1.708257288172570e-13,  -4.722488284163608e-15,  -2.236103621851728e-16,  -2.404461921387688e-18,   4.637909635640543e-02,
  -7.470837183578098e-04,   8.805236274775996e-06,  -9.230318500162622e-08,   1.024445188032356e-09,  -6.593133602130358e-13,   1.699518346600996e-13,  -4.733745192273728e-15,
  -2.227875905515878e-16,  -2.364768920542484e-18,   4.638115621963909e-02,  -7.471484158049078e-04,   8.806675269117885e-06,  -9.230490501763542e-08,   1.025025473542111e-09,
  -6.827974820585326e-13,   1.685195746130414e-13,  -4.752079559937249e-15,  -2.214352854725189e-16,  -2.299779578881714e-18,   4.638334201678852e-02,  -7.472170652763886e-04,
   8.808202445652230e-06,  -9.230675017690061e-08,   1.025639383317158e-09,  -7.077478914041994e-13,   1.670030712226190e-13,  -4.771336118497894e-15,  -2.199982454857138e-16,
  -2.231056590364665e-18,   4.638506233973833e-02,  -7.472710931206072e-04,   8.809404552906804e-06,  -9.230821688235585e-08,   1.026121218840732e-09,  -7.274069861822165e-13,
   1.658119193719218e-13,  -4.786348325234343e-15,  -2.188657572313457e-16,  -2.177142227958136e-18,   4.638605520747454e-02,  -7.473022737867186e-04,   8.810098397092447e-06,
  -9.230906918462378e-08,   1.026398769070862e-09,  -7.387618060599254e-13,   1.651254226736369e-13,  -4.794955011220344e-15,  -2.182115689731901e-16,  -2.146095840586138e-18,
   4.638642804593468e-02,  -7.473139824635790e-04,   8.810358958456873e-06,  -9.230939033641506e-08,   1.026502892495621e-09,  -7.430273821455860e-13,   1.648678141420996e-13,
  -4.798176115974085e-15,  -2.179658007643460e-16,  -2.134450600393376e-18,   4.638648984960239e-02,  -7.473159233457733e-04,   8.810402151074967e-06,  -9.230944363016217e-08,
   1.026520147198941e-09,  -7.437345534859318e-13,   1.648251212224482e-13,  -4.798709491164307e-15,  -2.179250551693029e-16,  -2.132520920564141e-18,   1.299359909167963e-01,
  -2.074970021860769e-03,   2.369584806130237e-05,  -2.324460924053674e-07,   2.366296181954981e-09,   7.226737832900661e-12,   3.754743505172609e-13,  -1.222133437056056e-14,
  -6.678233830044818e-16,  -6.913034505969764e-18,   1.299393670819386e-01,  -2.075069223056670e-03,   2.369787285962335e-05,  -2.324361213536107e-07,   2.367066723455390e-09,
   7.189704795763863e-12,   3.728628702649516e-13,  -1.225364723411507e-14,  -6.654409369313693e-16,  -6.796984287667767e-18,   1.299449098125463e-01,  -2.075232074876460e-03,
   2.370119735959507e-05,  -2.324197905581129e-07,   2.368327689355358e-09,   7.128841284428823e-12,   3.685825913023570e-13,  -1.230626810094802e-14,  -6.615250094464730e-16,
  -6.606970370761958e-18,   1.299507913623761e-01,  -2.075404869176360e-03,   2.370472554278585e-05,  -2.324025144116768e-07,   2.369660237503179e-09,   7.064168767920337e-12,
   3.640502538716884e-13,  -1.236152505942870e-14,  -6.573635141024378e-16,  -6.406033467894407e-18,   1.299554203788422e-01,  -2.075540856258795e-03,   2.370750269786938e-05,
  -2.323889557372244e-07,   2.370705030032989e-09,   7.013205210949281e-12,   3.604900698570201e-13,  -1.240459500362963e-14,  -6.540838219821767e-16,  -6.248390220102063e-18,
   1.299580919572822e-01,  -2.075619335886602e-03,   2.370910563096392e-05,  -2.323811459001204e-07,   2.371306426460929e-09,   6.983766840460177e-12,   3.584381414130092e-13,
  -1.242928439236887e-14,  -6.521892325930666e-16,  -6.157610015331343e-18,   1.299590951771503e-01,  -2.075648805545049e-03,   2.370970758275055e-05,  -2.323782160912020e-07,
   2.371531959520835e-09,   6.972707483053558e-12,   3.576681368429126e-13,  -1.243852394788434e-14,  -6.514774545743818e-16,  -6.123558757555458e-18,   1.299592614760261e-01,
  -2.075653690551042e-03,   2.370980736669284e-05,  -2.323777305844785e-07,   2.371569329175345e-09,   6.970873975157403e-12,   3.575405247357843e-13,  -1.244005387254450e-14,
  -6.513594492505888e-16,  -6.117916259274676e-18,   2.580791762878294e-01,  -4.061200271178285e-03,   4.383627876049618e-05,  -3.760345852964178e-07,   3.115103758674002e-09,
   4.118976299369053e-11,   4.898459835185125e-13,  -2.274576309526260e-14,  -1.434044781360900e-15,  -1.484355293370280e-17,   2.580854198723210e-01,  -4.061360603726319e-03,
   4.383894408796763e-05,  -3.759765533893622e-07,   3.116082907441290e-09,   4.112069169064867e-11,   4.842366276547391e-13,  -2.281521538908272e-14,  -1.429007016246183e-15,
  -1.459702736222159e-17,   2.580956700020590e-01,  -4.061623797790850e-03,   4.384332023771754e-05,  -3.758813561132812e-07,   3.117681740107674e-09,   4.100715421858245e-11,
   4.750425307246820e-13,  -2.292832766443579e-14,  -1.420726208208853e-15,  -1.419336660815118e-17,   2.581065465561927e-01,  -4.061903042909127e-03,   4.384796446077366e-05,
  -3.757804416882674e-07,   3.119366551412088e-09,   4.088648516604521e-11,   4.653066992753875e-13,  -2.304712083626844e-14,  -1.411925510655496e-15,  -1.376648237060296e-17,
   2.581151067324657e-01,  -4.062122792826612e-03,   4.385162005840427e-05,  -3.757010919743719e-07,   3.120684064380949e-09,   4.079137617675146e-11,   4.576589086473909e-13,
  -2.313972449153393e-14,  -1.404989211124711e-15,  -1.343156051048533e-17,   2.581200470862278e-01,  -4.062249607806248e-03,   4.385373000289113e-05,  -3.756553259708079e-07,
   3.121441045954504e-09,   4.073643034953328e-11,   4.532509793847896e-13,  -2.319281279685200e-14,  -1.400982125865279e-15,  -1.323868746027921e-17,   2.581219022587280e-01,
  -4.062297226770421e-03,   4.385452235095924e-05,  -3.756381457267570e-07,   3.121724661413946e-09,   4.071578698549903e-11,   4.515968473494067e-13,  -2.321268093688646e-14,
  -1.399476672006608e-15,  -1.316634059543738e-17,   2.581222097812079e-01,  -4.062305120225623e-03,   4.385465369625572e-05,  -3.756352981374435e-07,   3.121771641053683e-09,
   4.071236449088574e-11,   4.513227087614851e-13,  -2.321597083010205e-14,  -1.399227081843923e-15,  -1.315435223053057e-17,   4.346116965370981e-01,  -6.678842934039359e-03,
   6.527513098733905e-05,  -4.127457260436626e-07,   1.457254622851403e-09,   1.259437132539054e-10,   5.211591464620401e-13,  -4.144445472238148e-14,  -2.603133347884439e-15,
  -2.936157626296687e-17,   4.346209881812250e-01,  -6.679018515074045e-03,   6.527638081521010e-05,  -4.125675649780365e-07,   1.458246482332654e-09,   1.258176759739741e-10,
   5.109818965766498e-13,  -4.158257078046993e-14,  -2.593745753149328e-15,  -2.890144374854743e-17,   4.346362420487028e-01,  -6.679306705042963e-03,   6.527843318390466e-05,
  -4.122752152797731e-07,   1.459859182364087e-09,   1.256104750169123e-10,   4.943014471899188e-13,  -4.180762134624370e-14,  -2.578313932845557e-15,  -2.814798078575497e-17,
   4.346524277576424e-01,  -6.679612422533779e-03,   6.528061168055553e-05,  -4.119651872077096e-07,   1.461549206016081e-09,   1.253902261489598e-10,   4.766391365296054e-13,
  -4.204412541890863e-14,  -2.561911916214878e-15,  -2.735111215114387e-17,   4.346651661235334e-01,  -6.679852969999216e-03,   6.528232672576336e-05,  -4.117213221639383e-07,
   1.462863949819044e-09,   1.252166064138018e-10,   4.627655720667352e-13,  -4.222859900416472e-14,  -2.548983638697080e-15,  -2.672586923807568e-17,   4.346725177348590e-01,
  -6.679991773082842e-03,   6.528331673376835e-05,  -4.115806345000943e-07,   1.463616581657359e-09,   1.251162942556220e-10,   4.547696042530061e-13,  -4.233439938308825e-14,
  -2.541514612110052e-15,  -2.636579113858862e-17,   4.346752783477086e-01,  -6.680043890946151e-03,   6.528368853339523e-05,  -4.115278146452205e-07,   1.463898043997156e-09,
   1.250786047808124e-10,   4.517690692862953e-13,  -4.237400329721929e-14,  -2.538708440584192e-15,  -2.623072239298592e-17,   4.346757359593146e-01,  -6.680052530013049e-03,
   6.528375016670522e-05,  -4.115190595133252e-07,   1.463944639315357e-09,   1.250723560907130e-10,   4.512717948055286e-13,  -4.238056161201385e-14,  -2.538243199741521e-15,
  -2.620834042436860e-17,   6.654519238080592e-01,  -9.832831132717434e-03,   7.928371745641586e-05,  -1.270960931089661e-07,  -5.156128495997774e-09,   2.704572810513725e-10,
   1.438434531570487e-12,  -9.224550108422128e-14,  -4.312100337743257e-15,  -5.549660718260021e-17,   6.654631976429224e-01,  -9.832884041927257e-03,   7.927933109343911e-05,
  -1.267135787197583e-07,  -5.153257568571237e-09,   2.701774670666391e-10,   1.421592750737509e-12,  -9.250752930354300e-14,  -4.295741036438633e-15,  -5.466345155574385e-17,
   6.654817050193440e-01,  -9.832970783484081e-03,   7.927213187706352e-05,  -1.260859089337944e-07,  -5.148570279291849e-09,   2.697175555721568e-10,   1.393991576977231e-12,
  -9.293463117058933e-14,  -4.268845926185778e-15,  -5.329902349443394e-17,   6.655013421673199e-01,  -9.833062663372385e-03,   7.926449526516372e-05,  -1.254202965233688e-07,
  -5.143631730977809e-09,   2.692288079301091e-10,   1.364768990321637e-12,  -9.338366747230939e-14,  -4.240256097986249e-15,  -5.185579940134442e-17,   6.655167962652591e-01,
  -9.833134857805768e-03,   7.925848687940214e-05,  -1.248967413776678e-07,  -5.139770397059540e-09,   2.688436236729011e-10,   1.341817328996022e-12,  -9.373406075909693e-14,
  -4.217718482305877e-15,  -5.072327010299622e-17,   6.655257149507422e-01,  -9.833176476330998e-03,   7.925501998884126e-05,  -1.245947019132883e-07,  -5.137552088682857e-09,
   2.686211118624253e-10,   1.328590198423239e-12,  -9.393507854029738e-14,  -4.204696777094651e-15,  -5.007098926466325e-17,   6.655290639724449e-01,  -9.833192095752542e-03,
   7.925371826264264e-05,  -1.244813047321057e-07,  -5.136721007709684e-09,   2.685375160435934e-10,   1.323626819811000e-12,  -9.401033591857362e-14,  -4.199804214587874e-15,
  -4.982630191117355e-17,   6.655296191189682e-01,  -9.833194684433749e-03,   7.925350248951635e-05,  -1.244625086680757e-07,  -5.136583345183498e-09,   2.685236567103429e-10,
   1.322804255579436e-12,  -9.402279894681179e-14,  -4.198993055907719e-15,  -4.978575470791391e-17,   9.595149900872272e-01,  -1.320426568516730e-02,   6.487286798285501e-05,
   8.825948934785244e-07,  -1.680184846593839e-08,   3.343828081461936e-10,   7.786558298658838e-12,  -2.201349912712074e-13,  -8.307964346354728e-15,  -8.074852912211561e-17,
   9.595241933094294e-01,  -1.320388722575532e-02,   6.485861362067155e-05,   8.830651356360760e-07,  -1.678561273307603e-08,   3.337190753599597e-10,   7.754032455218576e-12,
  -2.205074639622155e-13,  -8.280182946766105e-15,  -7.920799767366990e-17,   9.595393004370393e-01,  -1.320326577957549e-02,   6.483522267512382e-05,   8.838364291690866e-07,
  -1.675900902315908e-08,   3.326286727064332e-10,   7.700716498224992e-12,  -2.211132796300518e-13,  -8.234493113930921e-15,  -7.668502612982259e-17,   9.595553282954721e-01,
  -1.320260618181892e-02,   6.481041650796231e-05,   8.846538997233692e-07,  -1.673084814418441e-08,   3.314706207008517e-10,   7.644253651665176e-12,  -2.217484188718943e-13,
  -8.185901973703016e-15,  -7.401621901987602e-17,   9.595679408772503e-01,  -1.320208693358534e-02,   6.479090363740624e-05,   8.852965785837782e-07,  -1.670873435702930e-08,
   3.305584723204462e-10,   7.599896477932534e-12,  -2.222427274852541e-13,  -8.147581111465149e-15,  -7.192185382641892e-17,   9.595752192729405e-01,  -1.320178720865286e-02,
   6.477964626751171e-05,   8.856672105343840e-07,  -1.669599167095971e-08,   3.300317525867240e-10,   7.574328938687779e-12,  -2.225257814398539e-13,  -8.125433825622836e-15,
  -7.071556605609603e-17,   9.595779522748220e-01,  -1.320167464826146e-02,   6.477541974777136e-05,   8.858063353606504e-07,  -1.669121037056519e-08,   3.298339073890710e-10,
   7.564734097864719e-12,  -2.226316515667112e-13,  -8.117111363098727e-15,  -7.026304950879069e-17,   9.595784053033023e-01,  -1.320165598920110e-02,   6.477471918036767e-05,
   8.858293945929449e-07,  -1.669041799698678e-08,   3.298011087294650e-10,   7.563143933567509e-12,  -2.226491789372872e-13,  -8.115731483366680e-15,  -7.018806251451466e-17,
   1.328826189770473e+00,  -1.560861618463582e-02,  -3.352468293513671e-05,   2.931612590202408e-06,  -4.512283771239412e-10,  -4.870338728956490e-10,   2.074310938169870e-11,
   3.272343516961143e-14,  -2.726726177241787e-14,  -3.007505161620556e-16,   1.328821418680007e+00,  -1.560736706095333e-02,  -3.352482512200828e-05,   2.930920116082569e-06,
  -4.082124599950357e-10,  -4.869590681375076e-10,   2.063656926819878e-11,   3.127350199107865e-14,  -2.716566944990154e-14,  -2.973569178511847e-16,   1.328813586186598e+00,
  -1.560531663575410e-02,  -3.352503239762576e-05,   2.929783375182241e-06,  -3.377581210180418e-10,  -4.868393369591193e-10,   2.046195929632886e-11,   2.890568382859065e-14,
  -2.699883888264225e-14,  -2.917968932547660e-16,   1.328805275339377e+00,  -1.560314126627170e-02,  -3.352521685166052e-05,   2.928577295176669e-06,  -2.632222455051965e-10,
  -4.867164545757127e-10,   2.027708272512342e-11,   2.641018664355689e-14,  -2.682175231429364e-14,  -2.859124635568368e-16,   1.328798734684392e+00,  -1.560142944910980e-02,
  -3.352533637142159e-05,   2.927628167662937e-06,  -2.047223864556027e-10,  -4.866227470839496e-10,   2.013187218696620e-11,   2.445846483257154e-14,  -2.668233768423709e-14,
  -2.812924426692050e-16,   1.328794959955064e+00,  -1.560044161014902e-02,  -3.352539508235251e-05,   2.927080432746513e-06,  -1.710251525533380e-10,  -4.865698660423033e-10,
   2.004818392695159e-11,   2.333699147757553e-14,  -2.660186061245377e-14,  -2.786305901192097e-16,   1.328793542508705e+00,  -1.560007068271011e-02,  -3.352541519014295e-05,
   2.926874757536801e-06,  -1.583836289484251e-10,  -4.865502349291905e-10,   2.001678000128906e-11,   2.291679317457892e-14,  -2.657163729890057e-14,  -2.776318818299882e-16,
   1.328793307546791e+00,  -1.560000919701726e-02,  -3.352541842106046e-05,   2.926840664173375e-06,  -1.562887548089174e-10,  -4.865469927155398e-10,   2.001157550374136e-11,
   2.284718812938882e-14,  -2.656662717560219e-14,  -2.774663762082489e-16,   1.769842088326417e+00,  -1.160095730023421e-02,  -2.929791678062345e-04,  -1.533718221832898e-06,
   1.666401718383926e-07,   5.388375532498222e-09,  -1.261616524173623e-11,  -5.385639240654580e-12,  -1.294575115586767e-13,   1.809105325500539e-15,   1.769800680984919e+00,
  -1.160158548932686e-02,  -2.928370715493736e-04,  -1.526184574559741e-06,   1.666074156735981e-07,   5.372438902039257e-09,  -1.310931399974476e-11,  -5.375814315295217e-12,
  -1.283601591905678e-13,   1.830149601122419e-15,   1.769732718713764e+00,  -1.160261447017067e-02,  -2.926038195898974e-04,  -1.513833198445691e-06,   1.665528922963228e-07,
   5.346297920774039e-09,  -1.391576139668340e-11,  -5.359609629867041e-12,  -1.265628997277344e-13,   1.864372926359355e-15,   1.769660625306806e+00,  -1.160370318443827e-02,
  -2.923563514396077e-04,  -1.500749608634296e-06,   1.664940236914357e-07,   5.318589731575014e-09,  -1.476720889222714e-11,  -5.342313274599521e-12,  -1.246616159864130e-13,
   1.900247269189901e-15,   1.769603901762302e+00,  -1.160455775586436e-02,  -2.921616147699018e-04,  -1.490468800185069e-06,   1.664469609083393e-07,   5.296804604899464e-09,
  -1.543422670208948e-11,  -5.328627662214212e-12,  -1.231694642528258e-13,   1.928163671322366e-15,   1.769571171245589e+00,  -1.160505004356999e-02,  -2.920492373386279e-04,
  -1.484541973212830e-06,   1.664195069611972e-07,   5.284240568431672e-09,  -1.581794450988480e-11,  -5.320700217420762e-12,  -1.223099876320640e-13,   1.944148119678318e-15,
   1.769558881697859e+00,  -1.160523473206245e-02,  -2.920070401871814e-04,  -1.482317605442980e-06,   1.664091424140381e-07,   5.279524273335613e-09,  -1.596180185711433e-11,
  -5.317717881986369e-12,  -1.219875621680124e-13,   1.950126544698033e-15,   1.769556844586743e+00,  -1.160526533783445e-02,  -2.920000454947466e-04,  -1.481948948717229e-06,
   1.664074214257458e-07,   5.278742565734474e-09,  -1.598563601092095e-11,  -5.317223227479446e-12,  -1.219341322385861e-13,   1.951116294774307e-15,   4.814628289077274e-03,
  -7.553326005598187e-05,   8.754546246978479e-07,  -8.754363402854523e-09,   1.212731033403383e-10,  -1.631946595323922e-14,  -5.313959293817372e-15,  -1.306507543520111e-15,
  -1.736276803758821e-17,   7.744078835533333e-19,   4.814753080794372e-03,  -7.553699768946852e-05,   8.755581040579142e-07,  -8.754418995447727e-09,   1.212609978490090e-10,
  -2.016016676442139e-14,  -5.378666738289986e-15,  -1.302521238076047e-15,  -1.714591912705922e-17,   7.751595399570555e-19,   4.814957957233011e-03,  -7.554313364463803e-05,
   8.757279744701489e-07,  -8.754514183567993e-09,   1.212410272596687e-10,  -2.645667713567665e-14,  -5.484276830521774e-15,  -1.295974649280212e-15,  -1.679112412857144e-17,
   7.763456827511737e-19,   4.815175361428153e-03,  -7.554964440183321e-05,   8.759082096040912e-07,  -8.754620513544887e-09,   1.212197049742922e-10,  -3.312604121946360e-14,
  -5.595499750811722e-15,  -1.289025015000945e-15,  -1.641628560863145e-17,   7.775395843318226e-19,   4.815346470140912e-03,  -7.555476842747756e-05,   8.760500479726665e-07,
  -8.754708049610304e-09,   1.212028290970491e-10,  -3.836637815100307e-14,  -5.682427846940273e-15,  -1.283553376172384e-15,  -1.612246230892509e-17,   7.784325967999099e-19,
   4.815445224521290e-03,  -7.555772561327409e-05,   8.761319026024673e-07,  -8.754760111926916e-09,   1.211930517003977e-10,  -4.138727615187998e-14,  -5.732353754277741e-15,
  -1.280394713066023e-15,  -1.595336244847108e-17,   7.789293737186263e-19,   4.815482308566262e-03,  -7.555883606793262e-05,   8.761626392493781e-07,  -8.754779953440166e-09,
   1.211893730246130e-10,  -4.252101012898734e-14,  -5.751055747072945e-15,  -1.279208441512171e-15,  -1.588995281347937e-17,   7.791124125957884e-19,   4.815488455819370e-03,
  -7.555902014179233e-05,   8.761677342579116e-07,  -8.754783257834313e-09,   1.211887628537885e-10,  -4.270890882695477e-14,  -5.754153461568366e-15,  -1.279011791539288e-15,
  -1.587944645537627e-17,   7.791425691931595e-19,   4.352391266432198e-02,  -6.807611980039778e-04,   7.795183456061614e-06,  -7.585723205189831e-08,   1.037124782630650e-09,
   1.026078401438565e-12,  -6.491721549085854e-14,  -1.182195274074709e-14,  -1.627700101916386e-16,   7.154223804532482e-18,   4.352502375531119e-02,  -6.807935790617638e-04,
   7.796068169738114e-06,  -7.585606464234762e-08,   1.036979054423704e-09,   9.913379553210299e-13,  -6.552452709470541e-14,  -1.178512074850417e-14,  -1.607711086119531e-16,
   7.161364385712155e-18,   4.352684788191006e-02,  -6.808467375184408e-04,   7.797520478287092e-06,  -7.585418363821883e-08,   1.036738902820190e-09,   9.343855543483916e-13,
  -6.651583390123602e-14,  -1.172463196636128e-14,  -1.575006249818429e-16,   7.172643853869118e-18,   4.352878354478554e-02,  -6.809031423611766e-04,   7.799061364391032e-06,
  -7.585223593314148e-08,   1.036482844394651e-09,   8.740629497478124e-13,  -6.755996652815888e-14,  -1.166041817809523e-14,  -1.540453780316581e-16,   7.184013075002659e-18,
   4.353030701110662e-02,  -6.809475329923777e-04,   7.800273958742978e-06,  -7.585073793145413e-08,   1.036280431734169e-09,   8.266671703251689e-13,  -6.837612819447675e-14,
  -1.160986019018324e-14,  -1.513369241942036e-16,   7.192529127403300e-18,   4.353118626917250e-02,  -6.809731515844116e-04,   7.800973734056875e-06,  -7.584988736434472e-08,
   1.036163258568337e-09,   7.993455829711134e-13,  -6.884492033102166e-14,  -1.158067383688020e-14,  -1.497781662943324e-16,   7.197271639774495e-18,   4.353151644609756e-02,
  -6.809827716000000e-04,   7.801236499719121e-06,  -7.584957060494133e-08,   1.036119191575280e-09,   7.890919991560606e-13,  -6.902053534542369e-14,  -1.156971251985684e-14,
  -1.491936578722906e-16,   7.199020026971246e-18,   4.353157117800653e-02,  -6.809843662542072e-04,   7.801280056523174e-06,  -7.584951823661616e-08,   1.036111883293392e-09,
   7.873926344569909e-13,  -6.904962384621096e-14,  -1.156789544349299e-14,  -1.490968105202482e-16,   7.199308136184128e-18,   1.219985047206762e-01,  -1.895903612095696e-03,
   2.113958864395198e-05,  -1.931009290569270e-07,   2.560249476979688e-09,   9.622195119523232e-12,  -2.752225021133090e-13,  -3.338690008581310e-14,  -4.880518746788243e-16,
   2.092728638044249e-17,   1.220015174285036e-01,  -1.895986005844290e-03,   2.114177123684235e-05,  -1.930880622442929e-07,   2.559640488339457e-09,   9.524143132001539e-12,
  -2.770465896253288e-13,  -3.327912976089660e-14,  -4.822093319412421e-16,   2.094932619075348e-17,   1.220064635000670e-01,  -1.896121264743923e-03,   2.114535393383888e-05,
  -1.930670394237117e-07,   2.558637984412850e-09,   9.363408041456808e-12,  -2.800244828701966e-13,  -3.310213555720821e-14,  -4.726500617623054e-16,   2.098420148684406e-17,
   1.220117119688188e-01,  -1.896264779779348e-03,   2.114915493155743e-05,  -1.930448685462213e-07,   2.557570526042004e-09,   9.193172589012551e-12,  -2.831616912018857e-13,
  -3.291423609947461e-14,  -4.625506817603168e-16,   2.101943940197436e-17,   1.220158427617973e-01,  -1.896377723179167e-03,   2.115214595903229e-05,  -1.930275182845022e-07,
   2.556727745202947e-09,   9.059425898617132e-12,  -2.856143917194942e-13,  -3.276629155815963e-14,  -4.546340644708149e-16,   2.104589866706023e-17,   1.220182268115791e-01,
  -1.896442903550072e-03,   2.115387198784119e-05,  -1.930175444928395e-07,   2.556240287020922e-09,   8.982330084620488e-12,  -2.870233728546650e-13,  -3.268088381403858e-14,
  -4.500779077434389e-16,   2.106066062954509e-17,   1.220191220626829e-01,  -1.896467379149471e-03,   2.115452010013422e-05,  -1.930138066747605e-07,   2.556057039268788e-09,
   8.953397234150645e-12,  -2.875512284394970e-13,  -3.264880751179152e-14,  -4.483694208716832e-16,   2.106610809424539e-17,   1.220192704642489e-01,  -1.896471436315755e-03,
   2.115462753250962e-05,  -1.930131874702990e-07,   2.556026652666074e-09,   8.948602117729708e-12,  -2.876386631639617e-13,  -3.264349015190977e-14,  -4.480863410559365e-16,
   2.106700604189803e-17,   2.425084592285430e-01,  -3.727647102435726e-03,   3.965134334254508e-05,  -3.192772813128105e-07,   3.976993372936608e-09,   3.991055341307043e-11,
  -8.103144674903510e-13,  -6.831422874812180e-14,  -1.059437104631150e-15,   4.428797970828872e-17,   2.425141087142352e-01,  -3.727783214592949e-03,   3.965472898693360e-05,
  -3.192221751939293e-07,   3.975216944533907e-09,   3.971004813637071e-11,  -8.142786671682156e-13,  -6.808605518518832e-14,  -1.046975978616169e-15,   4.433845611808142e-17,
   2.425233836062053e-01,  -3.728006648124366e-03,   3.966028595933177e-05,  -3.191319142919784e-07,   3.972294669658178e-09,   3.938137989719543e-11,  -8.207510470250638e-13,
  -6.771130569826919e-14,  -1.026587402282647e-15,   4.441849852179508e-17,   2.425332254548513e-01,  -3.728243705839972e-03,   3.966618082491144e-05,  -3.190364184390011e-07,
   3.969185812393204e-09,   3.903330854793180e-11,  -8.275706088104430e-13,  -6.731344804661704e-14,  -1.005046419452574e-15,   4.449961114007987e-17,   2.425409713827386e-01,
  -3.728430255222597e-03,   3.967081901910361e-05,  -3.189614637181502e-07,   3.966733285736265e-09,   3.875986056810712e-11,  -8.329028744936477e-13,  -6.700017750193455e-14,
  -9.881607472231226e-16,   4.456069645710840e-17,   2.425454418459784e-01,  -3.728537910000097e-03,   3.967349537183342e-05,  -3.189182863886256e-07,   3.965315551498177e-09,
   3.860224325009443e-11,  -8.359663215069643e-13,  -6.681932247393816e-14,  -9.784426145368958e-16,   4.459485195732771e-17,   2.425471205752315e-01,  -3.728578334208437e-03,
   3.967450028570312e-05,  -3.189020880798486e-07,   3.964782738117650e-09,   3.854309321537379e-11,  -8.371140509231289e-13,  -6.675139835550800e-14,  -9.747984451268022e-16,
   4.460747069531675e-17,   2.425473988499980e-01,  -3.728585035034671e-03,   3.967466686017082e-05,  -3.188994037803803e-07,   3.964694393479523e-09,   3.853329019382465e-11,
  -8.373041650815236e-13,  -6.674013837097570e-14,  -9.741946401501823e-16,   4.460955152535442e-17,   4.089101725201191e-01,  -6.175864133126446e-03,   6.054589987077055e-05,
  -3.691704822677893e-07,   3.956308147112769e-09,   1.146704042626930e-10,  -1.853418343390781e-12,  -1.251053429365086e-13,  -1.962684998662547e-15,   8.125595057932144e-17,
   4.089187953930856e-01,  -6.176021175168106e-03,   6.054925499292602e-05,  -3.690103917668632e-07,   3.952265359096999e-09,   1.143032321781185e-10,  -1.860755159934960e-12,
  -1.246864174553496e-13,  -1.939254257761550e-15,   8.135961943069087e-17,   4.089329515764132e-01,  -6.176278936425498e-03,   6.055476044700244e-05,  -3.687479521626339e-07,
   3.945617404406933e-09,   1.137013662502713e-10,  -1.872732983388833e-12,  -1.239983402456694e-13,  -1.900916445940684e-15,   8.152441101322819e-17,   4.089479728455050e-01,
  -6.176552374958687e-03,   6.056059872812888e-05,  -3.684699924157741e-07,   3.938548429914920e-09,   1.130639723319243e-10,  -1.885351864505911e-12,  -1.232677814831678e-13,
  -1.860410306278718e-15,   8.169196555667536e-17,   4.089597949994090e-01,  -6.176767524724779e-03,   6.056519099895157e-05,  -3.682516047306195e-07,   3.932974307277544e-09,
   1.125632325133059e-10,  -1.895217612685767e-12,  -1.226925064565094e-13,  -1.828657115242531e-15,   8.181857144050573e-17,   4.089666179303300e-01,  -6.176891672718940e-03,
   6.056784029035103e-05,  -3.681257163458353e-07,   3.929753056336253e-09,   1.122746036423960e-10,  -1.900885174300806e-12,  -1.223603779192561e-13,  -1.810381949681049e-15,
   8.188953823549232e-17,   4.089691800341980e-01,  -6.176938287908965e-03,   6.056883493689249e-05,  -3.680784718534441e-07,   3.928542630567290e-09,   1.121662882835125e-10,
  -1.903008462744031e-12,  -1.222356368524165e-13,  -1.803528932610271e-15,   8.191579109771202e-17,   4.089696047409305e-01,  -6.176946014853221e-03,   6.056899980383516e-05,
  -3.680706418713004e-07,   3.928341942269585e-09,   1.121483370316014e-10,  -1.903360167882050e-12,  -1.222149580034686e-13,  -1.802393447465355e-15,   8.192012202646628e-17,
   6.273780501102351e-01,  -9.205646746068122e-03,   7.744504482405278e-05,  -1.656188433714264e-07,   3.039303297241106e-10,   2.574857662532353e-10,  -3.181088141423431e-12,
  -2.329758468461817e-13,  -3.303269718640369e-15,   1.415057045340611e-16,   6.273890715510226e-01,  -9.205716179392295e-03,   7.744526496900514e-05,  -1.652581912267851e-07,
   2.969951910559087e-10,   2.568012110404031e-10,  -3.193378875380245e-12,  -2.322454391606035e-13,  -3.261055574652594e-15,   1.417187283945331e-16,   6.274071650466218e-01,
  -9.205830055493486e-03,   7.744562204724207e-05,  -1.646668215887506e-07,   2.855915365792466e-10,   2.556789838678390e-10,  -3.213435842222760e-12,  -2.310456432562230e-13,
  -3.191983206372641e-15,   1.420584381729148e-16,   6.274263636665588e-01,  -9.205950737540726e-03,   7.744599505026747e-05,  -1.640402821087061e-07,   2.734663329550446e-10,
   2.544903636006011e-10,  -3.234554749331508e-12,  -2.297716174501473e-13,  -3.119003150190784e-15,   1.424053628387434e-16,   6.274414730975871e-01,  -9.206045606942336e-03,
   7.744628434024122e-05,  -1.635478789436700e-07,   2.639056799510612e-10,   2.535564701100076e-10,  -3.251057646060206e-12,  -2.287682805962160e-13,  -3.061792570120386e-15,
   1.426686440672447e-16,   6.274501930521419e-01,  -9.206100314666024e-03,   7.744644958380672e-05,  -1.632639784799992e-07,   2.583808292076850e-10,   2.530181261977046e-10,
  -3.260534666126266e-12,  -2.281889711200702e-13,  -3.028865422301660e-15,   1.428166963315580e-16,   6.274534674829996e-01,  -9.206120849786687e-03,   7.744651131076257e-05,
  -1.631574229891311e-07,   2.563048329648274e-10,   2.528160907246818e-10,  -3.264084485522198e-12,  -2.279713853345624e-13,  -3.016517994434221e-15,   1.428715576036646e-16,
   6.274540102668474e-01,  -9.206124253345766e-03,   7.744652152581074e-05,  -1.631397626315647e-07,   2.559606352094839e-10,   2.527826066797471e-10,  -3.264672449872301e-12,
  -2.279353147893815e-13,  -3.014472130538995e-15,   1.428806129784181e-16,   9.077972563525789e-01,  -1.264692673329746e-02,   7.409754017361178e-05,   6.747648361882380e-07,
  -8.905590916691845e-09,   4.161980729659491e-10,  -2.195479830756298e-12,  -4.813173738153163e-13,  -5.908626467060855e-15,   2.711692997771194e-16,   9.078077856283541e-01,
  -1.264663661337015e-02,   7.408990804355691e-05,   6.753451819716040e-07,  -8.910535901459536e-09,   4.147820898004661e-10,  -2.217431726982691e-12,  -4.799163177166115e-13,
  -5.831520280740344e-15,   2.716288078461547e-16,   9.078250703495044e-01,  -1.264616015824888e-02,   7.407737553377041e-05,   6.762964664319525e-07,  -8.918686920882461e-09,
   4.124605577845102e-10,  -2.253249703485817e-12,  -4.776147035021107e-13,  -5.705365043968176e-15,   2.723635602864153e-16,   9.078434097019712e-01,  -1.264565436316401e-02,
   7.406407330320734e-05,   6.773038877979318e-07,  -8.927380484212638e-09,   4.100013574177608e-10,  -2.290957545489953e-12,  -4.751704403904820e-13,  -5.572084801868802e-15,
   2.731166649603261e-16,   9.078578420920230e-01,  -1.264525612664820e-02,   7.405360127842563e-05,   6.780953123619781e-07,  -8.934254585047578e-09,   4.080689414196389e-10,
  -2.320418729920848e-12,  -4.732453226787270e-13,  -5.467612496867048e-15,   2.736902517051424e-16,   9.078661709951474e-01,  -1.264502622723249e-02,   7.404755642295652e-05,
   6.785514896517839e-07,  -8.938234631268280e-09,   4.069549043787711e-10,  -2.337335312955077e-12,  -4.721337205348351e-13,  -5.407487772421858e-15,   2.740136502178112e-16,
   9.078692985222305e-01,  -1.264493988461815e-02,   7.404528628393257e-05,   6.787226812090706e-07,  -8.939731604780331e-09,   4.065367988814856e-10,  -2.343671415895960e-12,
  -4.717161946259850e-13,  -5.384942142237190e-15,   2.741336511693363e-16,   9.078698169515059e-01,  -1.264492557140316e-02,   7.404490996345353e-05,   6.787510529875697e-07,
  -8.939979877442478e-09,   4.064675038602169e-10,  -2.344720859309211e-12,  -4.716469780487760e-13,  -5.381206558854505e-15,   2.741534672519187e-16,   1.266077197714374e+00,
  -1.573678948406980e-02,   1.373929216622209e-06,   2.871976598000442e-06,  -5.672354069188687e-09,  -8.148119557572581e-11,   8.909252784295378e-12,  -8.529455776772230e-13,
  -2.211699599178867e-14,   6.955097796009806e-16,   1.266077383700857e+00,  -1.573556386190286e-02,   1.369187542772352e-06,   2.871839656685112e-06,  -5.654329761023521e-09,
  -8.397316286198581e-11,   8.825136621361489e-12,  -8.493777346071371e-13,  -2.192272945688648e-14,   6.957261178286313e-16,   1.266077688556046e+00,  -1.573355185184528e-02,
   1.361414128330547e-06,   2.871612305929324e-06,  -5.624867597162115e-09,  -8.805642188500827e-11,   8.687599994314927e-12,  -8.435200690250781e-13,  -2.160482277796981e-14,
   6.960377902419942e-16,   1.266078011390401e+00,  -1.573141701807731e-02,   1.353180584945934e-06,   2.871367622260139e-06,  -5.593778993493373e-09,  -9.237859837383256e-11,
   8.542413883339010e-12,  -8.373040763129679e-13,  -2.126887614579741e-14,   6.963096950327162e-16,   1.266078264999382e+00,  -1.572973693964655e-02,   1.346711316942463e-06,
   2.871172562658191e-06,  -5.569437012555129e-09,  -9.577258819608080e-11,   8.428694051816953e-12,  -8.324117223996130e-13,  -2.100548113605657e-14,   6.964813388928155e-16,
   1.266078411176491e+00,  -1.572876735246515e-02,   1.342982003515907e-06,   2.871058992047286e-06,  -5.555438731103602e-09,  -9.772828527575726e-11,   8.363281120627246e-12,
  -8.295881373685012e-13,  -2.085387021175692e-14,   6.965634985554692e-16,   1.266078466032387e+00,  -1.572840326642874e-02,   1.341582407012226e-06,   2.871016156673820e-06,
  -5.550191664376935e-09,  -9.846209422534796e-11,   8.338758881897095e-12,  -8.285278346127992e-13,  -2.079701430133984e-14,   6.965911651233927e-16,   1.266078475123688e+00,
  -1.572834291414655e-02,   1.341350445912655e-06,   2.871009046157650e-06,  -5.549322384938872e-09,  -9.858370324151626e-11,   8.334696129832809e-12,  -8.283520733428866e-13,
  -2.078759360309188e-14,   6.965955834377831e-16,   1.718708337220026e+00,  -1.396528404463085e-02,  -2.920409398871565e-04,   1.919805430754950e-06,   2.571929687908304e-07,
   2.920974092536909e-09,  -2.010140984577740e-10,  -6.992783620082936e-12,   7.422412770974209e-14,   9.118382281588838e-15,   1.718667214376836e+00,  -1.396445038482453e-02,
  -2.918237456013173e-04,   1.923792465169143e-06,   2.567675626246423e-07,   2.900794418829384e-09,  -2.007057416777967e-10,  -6.947657234737638e-12,   7.484207502526714e-14,
   9.059084088521675e-15,   1.718599726526785e+00,  -1.396308060641341e-02,  -2.914674473759325e-04,   1.930317368517269e-06,   2.560696718576558e-07,   2.867762660539670e-09,
  -2.001978086570111e-10,  -6.873793228220757e-12,   7.584531925684558e-14,   8.961909776170139e-15,   1.718528146522303e+00,  -1.396162555045939e-02,  -2.910897424453408e-04,
   1.937213043743462e-06,   2.553298127127447e-07,   2.832844227160088e-09,  -1.996565384844449e-10,  -6.795714080861182e-12,   7.689467007895750e-14,   8.859037339978028e-15,
   1.718471834262018e+00,  -1.396047924697831e-02,  -2.907927435969330e-04,   1.942619925751971e-06,   2.547480163900817e-07,   2.805457748172775e-09,  -1.992288943080571e-10,
  -6.734479607711729e-12,   7.770959079739748e-14,   8.778248992997531e-15,   1.718439344001791e+00,  -1.395981722598283e-02,  -2.906214426958670e-04,   1.945732319685705e-06,
   2.544124418058545e-07,   2.789690294049827e-09,  -1.989814308849094e-10,  -6.699225774676997e-12,   7.817553793273405e-14,   8.731694113956420e-15,   1.718427145219797e+00,
  -1.395956854238151e-02,  -2.905571369561101e-04,   1.946899539701642e-06,   2.542864664414026e-07,   2.783776598403408e-09,  -1.988883813911260e-10,  -6.686003811726525e-12,
   7.834968400739411e-14,   8.714225505538239e-15,   1.718425123183251e+00,  -1.395952731486803e-02,  -2.905464783853421e-04,   1.947092943251481e-06,   2.542655861338357e-07,
   2.782796695185427e-09,  -1.988729505497645e-10,  -6.683812936561370e-12,   7.837850791904396e-14,   8.711330531737929e-15,   4.525883591609636e-03,  -6.891698094436537e-05,
   7.819754715191087e-07,  -6.836677583245934e-09,   1.165278566776863e-10,  -6.103814528780002e-13,  -4.361950888405073e-14,  -1.161908641752485e-15,   3.272485479542132e-17,
   1.783230915773386e-18,   4.525995071497961e-03,  -6.891990284589450e-05,   7.820744501292878e-07,  -6.837574214116996e-09,   1.164362927225175e-10,  -6.137143236970246e-13,
  -4.348927823072972e-14,  -1.153137203525471e-15,   3.271819755848194e-17,   1.769601889925476e-18,   4.526178093880320e-03,  -6.892469990345607e-05,   7.822368835252678e-07,
  -6.839049549298308e-09,   1.162861764898917e-10,  -6.191670600379904e-13,  -4.327551052775760e-14,  -1.138787413118562e-15,   3.270590171460846e-17,   1.747296650070419e-18,
   4.526372308502960e-03,  -6.892979033791378e-05,   7.824091618568389e-07,  -6.840619564318986e-09,   1.161271644659839e-10,  -6.249274643698858e-13,  -4.304872527749300e-14,
  -1.123628915747476e-15,   3.269100886888627e-17,   1.723722840981659e-18,   4.526525166369900e-03,  -6.893379681622799e-05,   7.825446907960982e-07,  -6.841858475287234e-09,
   1.160022187327655e-10,  -6.294426101176594e-13,  -4.287027384788697e-14,  -1.111748033725714e-15,   3.267796075281294e-17,   1.705238008798306e-18,   4.526613387616987e-03,
  -6.893610914544735e-05,   7.826228851627735e-07,  -6.842574795508992e-09,   1.159301892930978e-10,  -6.320410595160841e-13,  -4.276729850888747e-14,  -1.104910923762040e-15,
   3.266990136951928e-17,   1.694597254571009e-18,   4.526646516325276e-03,  -6.893697746929439e-05,   7.826522437623834e-07,  -6.842844030139458e-09,   1.159031564883353e-10,
  -6.330154195534508e-13,  -4.272863266669238e-14,  -1.102347217377643e-15,   3.266677535098282e-17,   1.690606686671710e-18,   4.526652007922579e-03,  -6.893712140752151e-05,
   7.826571101509546e-07,  -6.842888672775228e-09,   1.158986762035092e-10,  -6.331768607318980e-13,  -4.272222337921444e-14,  -1.101922441244227e-15,   3.266625192093313e-17,
   1.689945464122107e-18,   4.092022456034939e-02,  -6.217583583808605e-04,   6.984539059278480e-06,  -5.930293185083948e-08,   1.013543162976719e-09,  -4.767232065185025e-12,
  -4.129375640212125e-13,  -1.056476364391744e-14,   2.997654187937631e-16,   1.647235847080702e-17,   4.092122024192511e-02,  -6.217837010261104e-04,   6.985399560282088e-06,
  -5.930997049607502e-08,   1.012675870884284e-09,  -4.797516283140094e-12,  -4.117445782698744e-13,  -1.048373662194782e-14,   2.997070044658840e-16,   1.634653895699087e-17,
   4.092285490214980e-02,  -6.218253073119782e-04,   6.986811681247630e-06,  -5.932155618868811e-08,   1.011253910185120e-09,  -4.847059886655395e-12,  -4.097863398629017e-13,
  -1.035117873818720e-14,   2.995984246546882e-16,   1.614062198956834e-17,   4.092458952226151e-02,  -6.218694578359405e-04,   6.988309330098574e-06,  -5.933389101924164e-08,
   1.009747599945889e-09,  -4.899395115748560e-12,  -4.077088444832323e-13,  -1.021114994130442e-14,   2.994660844268698e-16,   1.592299257884723e-17,   4.092595476374104e-02,
  -6.219042067346059e-04,   6.989487466345196e-06,  -5.934362857836942e-08,   1.008563935709787e-09,  -4.940413956175692e-12,  -4.060741112719551e-13,  -1.010139830763174e-14,
   2.993496156022624e-16,   1.575234281903112e-17,   4.092674270589613e-02,  -6.219242618884182e-04,   6.990167183021374e-06,  -5.934926030786757e-08,   1.007881545336504e-09,
  -4.964019023248812e-12,  -4.051307866679853e-13,  -1.003823924968300e-14,   2.992774901182638e-16,   1.565410828488527e-17,   4.092703859254963e-02,  -6.219317929655110e-04,
   6.990422383948063e-06,  -5.935137734228064e-08,   1.007625438066074e-09,  -4.972870179811534e-12,  -4.047765806474660e-13,  -1.001455652039157e-14,   2.992494817410044e-16,
   1.561726763477160e-17,   4.092708764034264e-02,  -6.219330413581727e-04,   6.990464685074158e-06,  -5.935172839040071e-08,   1.007582991852586e-09,  -4.974336711864109e-12,
  -4.047178670914535e-13,  -1.001063256829936e-14,   2.992447902588092e-16,   1.561116326980605e-17,   1.147394454692281e-01,  -1.735348733758309e-03,   1.907242926565678e-05,
  -1.512944108295744e-07,   2.605691441694912e-09,  -9.013799460637136e-12,  -1.265104539337597e-12,  -3.008339647528281e-14,   8.659941592619999e-16,   4.827604563321705e-17,
   1.147421640596175e-01,  -1.735413372692758e-03,   1.907463907173326e-05,  -1.513079618879711e-07,   2.603031873341233e-09,  -9.099927205732689e-12,  -1.261657750861360e-12,
  -2.984592530198906e-14,   8.658438256786675e-16,   4.790741278232346e-17,   1.147466272907506e-01,  -1.735519492317338e-03,   1.907826519783430e-05,  -1.513302951719586e-07,
   2.598671076728993e-09,  -9.240813278609429e-12,  -1.255999937420142e-12,  -2.945742889818462e-14,   8.655594903282438e-16,   4.730410015924033e-17,   1.147513634297027e-01,
  -1.735632099370920e-03,   1.908211058681827e-05,  -1.513541105092682e-07,   2.594051157683104e-09,  -9.389617423756829e-12,  -1.249997498572239e-12,  -2.904703648099062e-14,
   8.652070929583562e-16,   4.666646357114976e-17,   1.147550910172633e-01,  -1.735720726018711e-03,   1.908513532869715e-05,  -1.513729385165207e-07,   2.590420486347981e-09,
  -9.506231004472149e-12,  -1.245274272705391e-12,  -2.872537915879822e-14,   8.648933016173945e-16,   4.616646796723695e-17,   1.147572423696282e-01,  -1.735771875919506e-03,
   1.908688032570515e-05,  -1.513838386119672e-07,   2.588327250868542e-09,  -9.573332545342960e-12,  -1.242548712262574e-12,  -2.854027404394032e-14,   8.646976771677017e-16,
   4.587864328838965e-17,   1.147580502405953e-01,  -1.735791083543181e-03,   1.908753546839433e-05,  -1.513879381398317e-07,   2.587541616263078e-09,  -9.598492383301889e-12,
  -1.241525296740254e-12,  -2.847086521939117e-14,   8.646214818713755e-16,   4.577070070969195e-17,   1.147581841576559e-01,  -1.735794267499017e-03,   1.908764406128861e-05,
  -1.513886180344470e-07,   2.587411406978981e-09,  -9.602661011693740e-12,  -1.241355654151936e-12,  -2.845936498513371e-14,   8.646087072939889e-16,   4.575281498578675e-17,
   2.282096215633598e-01,  -3.424629550361441e-03,   3.622283479135121e-05,  -2.510113216927498e-07,   4.414252336354761e-09,  -4.301280558568502e-12,  -2.850455132844297e-12,
  -6.201995379831763e-14,   1.820909572772105e-15,   1.029959114799257e-16,   2.282147838495180e-01,  -3.424736739805130e-03,   3.622656993119768e-05,  -2.510189323048367e-07,
   4.408253822745138e-09,  -4.478571009191512e-12,  -2.843206113623657e-12,  -6.151335687769111e-14,   1.820669227733847e-15,   1.022078592709943e-16,   2.282232589567414e-01,
  -3.424912711323419e-03,   3.623269809336799e-05,  -2.510316053831575e-07,   4.398417471268726e-09,  -4.768541362572047e-12,  -2.831306833615276e-12,  -6.068458422855141e-14,
   1.820193186679125e-15,   1.009180965295168e-16,   2.282322522154943e-01,  -3.425099434402888e-03,   3.623919555706332e-05,  -2.510452952092119e-07,   4.387995534581397e-09,
  -5.074757073023632e-12,  -2.818682478418023e-12,  -5.980910964621765e-14,   1.819578037796451e-15,   9.955493036663717e-17,   2.282393303300904e-01,  -3.425246389148325e-03,
   3.624430548520828e-05,  -2.510562444310653e-07,   4.379804414345482e-09,  -5.314692234366702e-12,  -2.808748374662161e-12,  -5.912293643964307e-14,   1.819014793553893e-15,
   9.848600068868340e-17,   2.282434153977781e-01,  -3.425331200695692e-03,   3.624725307860231e-05,  -2.510626335374985e-07,   4.375081567148797e-09,  -5.452740200454795e-12,
  -2.803015774711913e-12,  -5.872806474815153e-14,   1.818658199209579e-15,   9.787065942924142e-17,   2.282449494095382e-01,  -3.425363048482039e-03,   3.624835965602819e-05,
  -2.510650459409907e-07,   4.373308924264589e-09,  -5.504498679183318e-12,  -2.800863237172611e-12,  -5.858000026769186e-14,   1.818518355363524e-15,   9.763988731953067e-17,
   2.282452036954336e-01,  -3.425368327719428e-03,   3.624854307266593e-05,  -2.510654465289177e-07,   4.373015127287336e-09,  -5.513074175073506e-12,  -2.800506429200551e-12,
  -5.855546773178741e-14,   1.818494861448838e-15,   9.760164908312378e-17,   3.851491150211519e-01,  -5.707988684365246e-03,   5.656004793578963e-05,  -2.912129786936949e-07,
   5.499730322311852e-09,   2.478988312450913e-11,  -5.592978410094044e-12,  -1.133889586422780e-13,   3.393340172297027e-15,   1.926580906330986e-16,   3.851571732396160e-01,
  -5.708112895111482e-03,   5.656467719451173e-05,  -2.911804210735952e-07,   5.487952000249027e-09,   2.446608420121853e-11,  -5.579464937604651e-12,  -1.124416438004839e-13,
   3.393119812050253e-15,   1.911729855473827e-16,   3.851704025752841e-01,  -5.708316797743493e-03,   5.657226965425097e-05,  -2.911272992944596e-07,   5.468636821185934e-09,
   2.393653636777282e-11,  -5.557281916522874e-12,  -1.108919163442944e-13,   3.392601341028920e-15,   1.887423519117690e-16,   3.851844405557704e-01,  -5.708533141460247e-03,
   5.658031603850310e-05,  -2.910713760355810e-07,   5.448170248578086e-09,   2.337738481470960e-11,  -5.533746340659470e-12,  -1.092549184055639e-13,   3.391839565362105e-15,
   1.861733296301772e-16,   3.851954889781007e-01,  -5.708703395923800e-03,   5.658664149356605e-05,  -2.910276840375906e-07,   5.432083455046565e-09,   2.293930814345889e-11,
  -5.515225591564474e-12,  -1.079719258518805e-13,   3.391087868544822e-15,   1.841587860436585e-16,   3.852018654221297e-01,  -5.708801649438600e-03,   5.659028919651985e-05,
  -2.910025964729936e-07,   5.422807671474708e-09,   2.268727697484129e-11,  -5.504537718125742e-12,  -1.072336197687638e-13,   3.390593396665388e-15,   1.829990762127495e-16,
   3.852042598749326e-01,  -5.708838543919283e-03,   5.659165840851718e-05,  -2.909931999908509e-07,   5.419326076018822e-09,   2.259278615971637e-11,  -5.500524476436486e-12,
  -1.069567813791106e-13,   3.390396294659848e-15,   1.825641460842218e-16,   3.852046567915867e-01,  -5.708844659671135e-03,   5.659188534669449e-05,  -2.909916436625012e-07,
   5.418749033690312e-09,   2.257713083104490e-11,  -5.499859232858922e-12,  -1.069109126961581e-13,   3.390363020574649e-15,   1.824920793345529e-16,   5.917825814189107e-01,
  -8.593600612403839e-03,   7.563689120355708e-05,  -1.260604152072424e-07,   4.126876573687895e-09,   9.748723219547788e-11,  -1.005116375894874e-11,  -2.069475653290287e-13,
   6.203739669696194e-15,   3.446324446767018e-16,   5.917933519473402e-01,  -8.593653958775887e-03,   7.564029516097812e-05,  -1.259266536912796e-07,   4.105714806141133e-09,
   9.689569649743661e-11,  -1.002645007624973e-11,  -2.052540912088562e-13,   6.203738034676082e-15,   3.419343122142565e-16,   5.918110338444003e-01,  -8.593741495357736e-03,
   7.564587034163501e-05,  -1.257076598185015e-07,   4.071012461918466e-09,   9.592820613087015e-11,  -9.985880243162569e-12,  -2.024838686842706e-13,   6.203443031912062e-15,
   3.375183214560933e-16,   5.918297961537232e-01,  -8.593834324006204e-03,   7.565176842973530e-05,  -1.254761001673103e-07,   4.034242401087087e-09,   9.490652038136877e-11,
  -9.942835247052714e-12,  -1.995578615712805e-13,   6.202735262743421e-15,   3.328508732182686e-16,   5.918445625149829e-01,  -8.593907341307949e-03,   7.565639751644115e-05,
  -1.252944462253655e-07,   4.005341678597995e-09,   9.410598425677933e-11,  -9.908960941849656e-12,  -1.972647685808110e-13,   6.201894421483228e-15,   3.291907917634167e-16,
   5.918530846010001e-01,  -8.593949465279417e-03,   7.565906394955712e-05,  -1.251898440496772e-07,   3.988677541067429e-09,   9.364539357957108e-11,  -9.889412469300036e-12,
  -1.959452569348565e-13,   6.201296036437866e-15,   3.270837897800548e-16,   5.918562847536273e-01,  -8.593965280277328e-03,   7.566006425751859e-05,  -1.251506090340767e-07,
   3.982422833312396e-09,   9.347270417480209e-11,  -9.882072035982091e-12,  -1.954504991728817e-13,   6.201050033546178e-15,   3.262935919904823e-16,   5.918568152260280e-01,
  -8.593967901682879e-03,   7.566023002202582e-05,  -1.251441075957988e-07,   3.981386175877958e-09,   9.344409250952247e-11,  -9.880855265637182e-12,  -1.953685245867804e-13,
   6.201008133082594e-15,   3.261626582814011e-16,   8.584437540676342e-01,  -1.202358980366734e-02,   8.159207393090677e-05,   5.911871213409790e-07,  -2.259759532025577e-09,
   1.928642249523175e-10,  -1.617690012504395e-11,  -4.218442912693615e-13,   1.197206881035533e-14,   6.444870396322818e-16,   8.584553609492510e-01,  -1.202333648114468e-02,
   8.158995229113559e-05,   5.914514077343453e-07,  -2.293724785812593e-09,   1.916538641085221e-10,  -1.612923530504163e-11,  -4.186793978825506e-13,   1.197072052522923e-14,
   6.393652416201020e-16,   8.584744152755787e-01,  -1.202292053202003e-02,   8.158644849452091e-05,   5.918840524807633e-07,  -2.349410736240032e-09,   1.896736084521239e-10,
  -1.605099292736134e-11,  -4.135024827036229e-13,   1.196793791800973e-14,   6.309828865995341e-16,   8.584946330499463e-01,  -1.202247907040261e-02,   8.158270247642204e-05,
   5.923414620442728e-07,  -2.408397934667943e-09,   1.875815525502850e-10,  -1.596798230181888e-11,  -4.080348322149624e-13,   1.196421687072275e-14,   6.221237861141773e-16,
   8.585105442986291e-01,  -1.202213156015148e-02,   8.157973392860016e-05,   5.927002468717278e-07,  -2.454748847044808e-09,   1.859416999282184e-10,  -1.590266085673993e-11,
  -4.037501524197413e-13,   1.196073595415394e-14,   6.151771459785312e-16,   8.585197268924843e-01,  -1.202193097412060e-02,   8.157801254592761e-05,   5.929068290004660e-07,
  -2.481469876712561e-09,   1.849979513771296e-10,  -1.586496614805200e-11,  -4.012847378556316e-13,   1.195850690955603e-14,   6.111783375519351e-16,   8.585231750290609e-01,
  -1.202185564620507e-02,   8.157736460509301e-05,   5.929843121077134e-07,  -2.491498410269029e-09,   1.846440631875326e-10,  -1.585081211257258e-11,  -4.003603392722704e-13,
   1.195762842716236e-14,   6.096786799494654e-16,   8.585237466060656e-01,  -1.202184315921552e-02,   8.157725711816332e-05,   5.929971512684279e-07,  -2.493160494228312e-09,
   1.845854274507696e-10,  -1.584846591630574e-11,  -4.002071802171021e-13,   1.195748062301733e-14,   6.094301923134265e-16,   1.203367991865885e+00,  -1.558957929651018e-02,
   3.525212253402039e-05,   2.770620449957329e-06,  -7.382602174705751e-09,  -2.027142837134322e-10,  -1.947477706913911e-11,  -9.368433006008855e-13,   2.230286191450960e-14,
   1.559443582833635e-15,   1.203372995361011e+00,  -1.558839756062529e-02,   3.524558988450902e-05,   2.770309471540566e-06,  -7.423122999097781e-09,  -2.053923747819979e-10,
  -1.938631178986236e-11,  -9.291903710142438e-13,   2.228460934288672e-14,   1.546857329165732e-15,   1.203381208699918e+00,  -1.558645765102830e-02,   3.523484080927374e-05,
   2.769796245776051e-06,  -7.489508232399945e-09,  -2.097725819564278e-10,  -1.924114129658576e-11,  -9.166729411411205e-13,   2.225341826933788e-14,   1.526262788305401e-15,
   1.203389922723605e+00,  -1.558439939486792e-02,   3.522340172182653e-05,   2.769248007196103e-06,  -7.559762965023670e-09,  -2.143982041523829e-10,  -1.908718705394739e-11,
  -9.034534863464757e-13,   2.221866774241391e-14,   1.504502601444752e-15,   1.203396780007267e+00,  -1.558277963660954e-02,   3.521437488988842e-05,   2.768813893117353e-06,
  -7.614919813018420e-09,  -2.180226229495840e-10,  -1.896608573826022e-11,  -8.930948534621443e-13,   2.219013089846428e-14,   1.487444001587010e-15,   1.203400737199315e+00,
  -1.558184488270647e-02,   3.520915563598175e-05,   2.768562298511299e-06,  -7.646698211089721e-09,  -2.201079582493247e-10,  -1.889622093122561e-11,  -8.871347455464520e-13,
   2.217318874123648e-14,   1.477625924419362e-15,   1.203402223111230e+00,  -1.558149388094413e-02,   3.520719392363735e-05,   2.768467622373414e-06,  -7.658621167948575e-09,
  -2.208898167180896e-10,  -1.886999080888602e-11,  -8.849000753555261e-13,   2.216673777570918e-14,   1.473944199998781e-15,   1.203402469419600e+00,  -1.558143569778036e-02,
   3.520686864519881e-05,   2.768451917911587e-06,  -7.660597033421570e-09,  -2.210193573865453e-10,  -1.886564304567035e-11,  -8.845298265526885e-13,   2.216566374910427e-14,
   1.473334168489496e-15,   1.658422558377936e+00,  -1.613706445726214e-02,  -2.433954922896698e-04,   6.182402813684499e-06,   2.542273732220847e-07,  -3.671812594716654e-09,
  -3.131269443407356e-10,   6.068424887969597e-13,   3.702621017804680e-13,   3.898980248731690e-15,   1.658388350463583e+00,  -1.613444344628489e-02,  -2.431821048855925e-04,
   6.177195532862537e-06,   2.535758358378540e-07,  -3.669713436638442e-09,  -3.117011112137684e-10,   6.249486533875135e-13,   3.678627549803338e-13,   3.828515244887918e-15,
   1.658332213996875e+00,  -1.613014223490703e-02,  -2.428321916841449e-04,   6.168649214327630e-06,   2.525084054128485e-07,  -3.666229416675425e-09,  -3.093672054164803e-10,
   6.544188498609470e-13,   3.639377926007275e-13,   3.713754678195159e-15,   1.658272677876780e+00,  -1.612558049446907e-02,  -2.424614452341293e-04,   6.159584023404854e-06,
   2.513787276601224e-07,  -3.662481371969294e-09,  -3.069000116605432e-10,   6.853456297430217e-13,   3.597920279654524e-13,   3.593226794516569e-15,   1.658225843624477e+00,
  -1.612199195684160e-02,  -2.421700551506571e-04,   6.152451941049490e-06,   2.504917955857674e-07,  -3.659494780348876e-09,  -3.049650050077453e-10,   7.094379896048356e-13,
   3.565429589588199e-13,   3.499264257495558e-15,   1.658198823068795e+00,  -1.611992157326219e-02,  -2.420020441077738e-04,   6.148336792323319e-06,   2.499807821779157e-07,
  -3.657756460196421e-09,  -3.038509499818921e-10,   7.232435508646688e-13,   3.546733266532061e-13,   3.445392959354453e-15,   1.658188678169827e+00,  -1.611914424301724e-02,
  -2.419389837297485e-04,   6.146791686720118e-06,   2.497890525056237e-07,  -3.657100934301292e-09,  -3.034331162013766e-10,   7.284090938050579e-13,   3.539722935715048e-13,
   3.425230879035922e-15,   1.658186996591390e+00,  -1.611901539569995e-02,  -2.419285321219693e-04,   6.146535572527035e-06,   2.497572790542938e-07,  -3.656992125622808e-09,
  -3.033638808939771e-10,   7.292643775317544e-13,   3.538561417391526e-13,   3.421892261556081e-15,   4.262250692173828e-03,  -6.295898316335742e-05,   7.105114116798260e-07,
  -5.134978219188320e-09,   9.206627102241076e-11,  -1.874163033918141e-12,  -5.282195277277594e-14,   7.416722805132459e-16,   7.571748276359411e-17,   2.800923343591133e-20,
   4.262351959997843e-03,  -6.296118475145552e-05,   7.105894042942933e-07,  -5.137626589258967e-09,   9.195696076112184e-11,  -1.871947789921450e-12,  -5.253076181702906e-14,
   7.416206852321365e-16,   7.520782324083331e-17,   2.063090729112721e-20,   4.262518215449466e-03,  -6.296479982756844e-05,   7.107173754240491e-07,  -5.141972039663312e-09,
   9.177795397946613e-11,  -1.868311344244552e-12,  -5.205417423438078e-14,   7.415095545834610e-16,   7.437432848414447e-17,   8.636762020626870e-21,   4.262694636106912e-03,
  -6.296863680721797e-05,   7.108530726302405e-07,  -5.146579803045483e-09,   9.158861576453559e-11,  -1.864453145513220e-12,  -5.155044295762902e-14,   7.413559540564582e-16,
   7.349425448513303e-17,  -3.929808685252985e-21,   4.262833487889263e-03,  -6.297165732975008e-05,   7.109598019597169e-07,  -5.150203896088228e-09,   9.144004037348680e-11,
  -1.861417001056283e-12,  -5.115542257359384e-14,   7.412094195303981e-16,   7.280475580373340e-17,  -1.370460154526085e-20,   4.262913625092919e-03,  -6.297340085270262e-05,
   7.110213714916858e-07,  -5.152294532821562e-09,   9.135446857819216e-11,  -1.859664902092575e-12,  -5.092801601289427e-14,   7.411146303537543e-16,   7.240808178059257e-17,
  -1.929991917828496e-20,   4.262943718000302e-03,  -6.297405562344358e-05,   7.110444865437859e-07,  -5.153079417936242e-09,   9.132236836275589e-11,  -1.859006995002915e-12,
  -5.084272968448697e-14,   7.410771113461778e-16,   7.225936246469900e-17,  -2.139237029066968e-20,   4.262948706361594e-03,  -6.297416416425933e-05,   7.110483179351256e-07,
  -5.153209514922830e-09,   9.131704902436540e-11,  -1.858897938747756e-12,  -5.082859790086373e-14,   7.410707906707132e-16,   7.223472253565001e-17,  -2.173876862538005e-20,
   3.854081148206287e-02,  -5.684640440638730e-04,   6.365100280903552e-06,  -4.446182734794282e-08,   8.029371237944219e-10,  -1.663390691252640e-11,  -4.943365333676058e-13,
   6.942346548869933e-15,   6.972218732331813e-16,   2.702343906403266e-19,   3.854171864955312e-02,  -5.684831087729625e-04,   6.365780080715156e-06,  -4.448532355546362e-08,
   8.019136167147616e-10,  -1.661317033988696e-11,  -4.916555255015786e-13,   6.941924415340771e-15,   6.925124389182050e-16,   2.019069597251684e-19,   3.854320798085555e-02,
  -5.685144137886037e-04,   6.366895460515468e-06,  -4.452387506120797e-08,   8.002374492070640e-10,  -1.657912996372309e-11,  -4.872676108444157e-13,   6.940986690338059e-15,
   6.848106911185819e-16,   9.083706484504817e-20,   3.854478837029384e-02,  -5.685476406255578e-04,   6.368078121234228e-06,  -4.456475221248354e-08,   7.984644465832963e-10,
  -1.654301358226347e-11,  -4.826298510368714e-13,   6.939661285048835e-15,   6.766785893187875e-16,  -2.553015238932017e-20,   3.854603221298963e-02,  -5.685737974105267e-04,
   6.369008271818501e-06,  -4.459690176747273e-08,   7.970730869883708e-10,  -1.651459225823857e-11,  -4.789930193979909e-13,   6.938380676700102e-15,   6.703074887121609e-16,
  -1.160427777614731e-19,   3.854675008614265e-02,  -5.685888958435866e-04,   6.369544835895968e-06,  -4.461544749585430e-08,   7.962717077839236e-10,  -1.649819081432746e-11,
  -4.768993758331015e-13,   6.937546970291527e-15,   6.666421596041042e-16,  -1.678532728805167e-19,   3.854701965979219e-02,  -5.685945659922016e-04,   6.369746274963287e-06,
  -4.462241001205117e-08,   7.959710843040394e-10,  -1.649203211763004e-11,  -4.761141814363841e-13,   6.937216083612014e-15,   6.652679730918952e-16,  -1.872283733446692e-19,
   3.854706434575446e-02,  -5.685955059288151e-04,   6.369779663942177e-06,  -4.462356406493337e-08,   7.959212676027202e-10,  -1.649101123671203e-11,  -4.759840763962753e-13,
   6.937160295863546e-15,   6.650402969807104e-16,  -1.904358466432433e-19,   1.080926786671880e-01,  -1.589348226193395e-03,   1.749514613433545e-05,  -1.129056139574567e-07,
   2.076203186128687e-09,  -4.485838823730853e-11,  -1.484494034477514e-12,   2.084599789603379e-14,   2.032495479088075e-15,   8.338906960762931e-19,   1.080951718847107e-01,
  -1.589396651655889e-03,   1.749690150354937e-05,  -1.129689250348693e-07,   2.073126780092203e-09,  -4.479611824913455e-11,  -1.476680425777131e-12,   2.084494579258581e-14,
   2.018674987538344e-15,   6.325047413477246e-19,   1.080992650826972e-01,  -1.589476169305093e-03,   1.749978135686987e-05,  -1.130727963861434e-07,   2.068088266128952e-09,
  -4.469389765305435e-11,  -1.463892426548898e-12,   2.084249742613355e-14,   1.996073401169693e-15,   3.051576677455309e-19,   1.081036085238408e-01,  -1.589560570053278e-03,
   1.750283456721410e-05,  -1.131829249028588e-07,   2.062758159595862e-09,  -4.458544223824620e-11,  -1.450376652116225e-12,   2.083892589232358e-14,   1.972209257594802e-15,
  -3.777929287551228e-20,   1.081070270097865e-01,  -1.589627012974623e-03,   1.750523562633860e-05,  -1.132695336271131e-07,   2.058575002226418e-09,  -4.450009409207661e-11,
  -1.439778136732575e-12,   2.083541522619920e-14,   1.953513140284873e-15,  -3.045058929227460e-19,   1.081089999549726e-01,  -1.589665366132830e-03,   1.750662059059166e-05,
  -1.133194919645118e-07,   2.056165487529925e-09,  -4.445084096198697e-11,  -1.433676911876775e-12,   2.083311028347431e-14,   1.942757266581616e-15,  -4.571768219227752e-19,
   1.081097408287554e-01,  -1.589679769570535e-03,   1.750714051984390e-05,  -1.133382470444646e-07,   2.055261571946496e-09,  -4.443234650561147e-11,  -1.431388745142598e-12,
   2.083219224317943e-14,   1.938724749096957e-15,  -5.142685480646481e-19,   1.081098636398883e-01,  -1.589682157222747e-03,   1.750722669825098e-05,  -1.133413557156553e-07,
   2.055111781459851e-09,  -4.442928081615535e-11,  -1.431009601844416e-12,   2.083203729946505e-14,   1.938056640037954e-15,  -5.237197983369271e-19,   2.150732450618505e-01,
  -3.145727728556872e-03,   3.361835220319109e-05,  -1.852184040092006e-07,   3.551275165308204e-09,  -8.377508036666065e-11,  -3.269387084129960e-12,   4.584677291976632e-14,
   4.313534047843239e-15,   1.752957782077113e-18,   2.150780352203411e-01,  -3.145807219247306e-03,   3.362134610533664e-05,  -1.853364659378972e-07,   3.544492345201302e-09,
  -8.363813182080000e-11,  -3.252809915089429e-12,   4.584428243643408e-14,   4.283933746567502e-15,   1.319010039864408e-18,   2.150858993428444e-01,  -3.145937752244203e-03,
   3.362625695628076e-05,  -1.855301428844707e-07,   3.533382501394344e-09,  -8.341332131095637e-11,  -3.225679983091018e-12,   4.583864039379095e-14,   4.235527465079083e-15,
   6.137027362404802e-19,   2.150942441950137e-01,  -3.146076306968949e-03,   3.363146215229618e-05,  -1.857354577235551e-07,   3.521628349075930e-09,  -8.317479903419770e-11,
  -3.197007134006701e-12,   4.583055652769235e-14,   4.184418628884217e-15,  -1.251103667910765e-19,   2.151008119344913e-01,  -3.146185385815770e-03,   3.363555462357549e-05,
  -1.858969030326671e-07,   3.512402512551225e-09,  -8.298709594842484e-11,  -3.174523836458251e-12,   4.582268708342271e-14,   4.144379016775854e-15,  -6.996770606812095e-19,
   2.151046024243567e-01,  -3.146248351595473e-03,   3.363791484937405e-05,  -1.859900207436664e-07,   3.507088001991556e-09,  -8.287877538097813e-11,  -3.161581234290051e-12,
   4.581754485383901e-14,   4.121344666127339e-15,  -1.028527250204487e-18,   2.151060258134761e-01,  -3.146271998563456e-03,   3.363880083180518e-05,  -1.860249768739998e-07,
   3.505094219493256e-09,  -8.283810122421340e-11,  -3.156727377094230e-12,   4.581550080183635e-14,   4.112708869150083e-15,  -1.151497070255682e-18,   2.151062617617826e-01,
  -3.146275918528852e-03,   3.363894767994749e-05,  -1.860307707992500e-07,   3.504763820054424e-09,  -8.283135897009585e-11,  -3.155923108627684e-12,   4.581515601522758e-14,
   4.111278091280018e-15,  -1.171853865136590e-18,   3.632020856063374e-01,  -5.268004486833598e-03,   5.358395765900607e-05,  -2.073241358942727e-07,   4.485282095272761e-09,
  -1.292937950131550e-10,  -6.307810820365723e-12,   8.807933284900800e-14,   8.058113466989419e-15,   2.496034948096974e-18,   3.632097185485003e-01,  -5.268093639825045e-03,
   5.358771335734895e-05,  -2.075059098983003e-07,   4.472183456493690e-09,  -1.290307605034579e-10,  -6.276854800370662e-12,   8.807034727191073e-14,   8.002241863547474e-15,
   1.672168176893392e-18,   3.632222496333041e-01,  -5.268240054463627e-03,   5.359387097595144e-05,  -2.078040509056854e-07,   4.450727072028076e-09,  -1.285989800702469e-10,
  -6.226194342911579e-12,   8.805264813604535e-14,   7.910877117072382e-15,   3.333206518764415e-19,   3.632355465919620e-01,  -5.268395487196796e-03,   5.360039387166206e-05,
  -2.081200340350283e-07,   4.428024138869273e-09,  -1.281408763090562e-10,  -6.172655024877782e-12,   8.802988882828023e-14,   7.814416578262296e-15,  -1.068849812651089e-18,
   3.632460117366361e-01,  -5.268517868192508e-03,   5.360551960788240e-05,  -2.083684483433326e-07,   4.410203007761974e-09,  -1.277803841346190e-10,  -6.130674775133238e-12,
   8.800911740313186e-14,   7.738851335382070e-15,  -2.159099931178222e-18,   3.632520515238067e-01,  -5.268588518540022e-03,   5.360847464110107e-05,  -2.085117064494537e-07,
   4.399936568127591e-09,  -1.275723531153742e-10,  -6.106509329857281e-12,   8.799599046267090e-14,   7.695380975932234e-15,  -2.783017654643002e-18,   3.632543195518220e-01,
  -5.268615052582540e-03,   5.360958369445422e-05,  -2.085654811359877e-07,   4.396084907477028e-09,  -1.274942385389933e-10,  -6.097446699949517e-12,   8.799084664580682e-14,
   7.679083808241709e-15,  -3.016309294714914e-18,   3.632546955113997e-01,  -5.268619451197968e-03,   5.360976750475583e-05,  -2.085743939966570e-07,   4.395446623580841e-09,
  -1.274812900980183e-10,  -6.095945057982217e-12,   8.798998268779787e-14,   7.676383710280534e-15,  -3.054928285424507e-18,   5.586104520576310e-01,  -7.993378492997194e-03,
   7.453812959203728e-05,  -5.896479547161116e-08,   3.357132450927061e-09,  -1.801475241228442e-10,  -1.138495566283470e-11,   1.576100367508524e-13,   1.451404179865015e-14,
  -1.150142224678829e-19,   5.586210648744352e-01,  -7.993404557259514e-03,   7.454086242709205e-05,  -5.921718873195986e-08,   3.333489094126803e-09,  -1.796772320694369e-10,
  -1.132921999005631e-11,   1.575699574891798e-13,   1.441235703992175e-14,  -1.609985080554155e-18,   5.586384877911957e-01,  -7.993447422917018e-03,   7.454533443483513e-05,
  -5.963104974332833e-08,   3.294759580261131e-09,  -1.789052832730253e-10,  -1.123800991032614e-11,   1.574988172990877e-13,   1.424608834225821e-14,  -4.038692759334910e-18,
   5.586569752056566e-01,  -7.993493011196463e-03,   7.455006006085124e-05,  -6.006953139519026e-08,   3.253779693483035e-09,  -1.780863439609539e-10,  -1.114162076659981e-11,
   1.574161205140530e-13,   1.407056322907363e-14,  -6.581271280628516e-18,   5.586715251531206e-01,  -7.993528965011584e-03,   7.455376504262609e-05,  -6.041414323031364e-08,
   3.221611468105304e-09,  -1.774419536661876e-10,  -1.106604486352268e-11,   1.573458561055170e-13,   1.393307274541697e-14,  -8.557516252515107e-18,   5.586799223143920e-01,
  -7.993549744944348e-03,   7.455589761106179e-05,  -6.061283486401513e-08,   3.203079828859938e-09,  -1.770701128102083e-10,  -1.102254164851238e-11,   1.573032411242566e-13,
   1.385398365008106e-14,  -9.688172095351039e-18,   5.586830755512197e-01,  -7.993557553737029e-03,   7.455669734486266e-05,  -6.068740952627176e-08,   3.196127295513440e-09,
  -1.769304923931586e-10,  -1.100622710707122e-11,   1.572868501998888e-13,   1.382433384747143e-14,  -1.011088528252586e-17,   5.586835982463745e-01,  -7.993558848457951e-03,
   7.455682985592726e-05,  -6.069976944372721e-08,   3.194975144788986e-09,  -1.769073488174353e-10,  -1.100352386375186e-11,   1.572841127081242e-13,   1.381942154807234e-14,
  -1.018085812475842e-17,   8.116991249002395e-01,  -1.134295063490807e-02,   8.851982055583301e-05,   5.618202330103364e-07,  -2.931801354120958e-09,  -2.739109952561061e-10,
  -1.949789176938644e-11,   2.690886051397669e-13,   2.722449562686480e-14,  -2.017764787982929e-17,   8.117117164241744e-01,  -1.134271213334563e-02,   8.851708905194089e-05,
   5.614371993549668e-07,  -2.972186383506695e-09,  -2.731097735395879e-10,  -1.939341426651288e-11,   2.689136185937156e-13,   2.703043014245565e-14,  -2.289198002188856e-17,
   8.117323871319821e-01,  -1.134232071102954e-02,   8.851258031241395e-05,   5.608092104099479e-07,  -3.038325867372413e-09,  -2.717948619335308e-10,  -1.922244893190054e-11,
   2.686166728615284e-13,   2.671315024249379e-14,  -2.729830411186031e-17,   8.117543199191174e-01,  -1.134190554002608e-02,   8.850776290068211e-05,   5.601439835811426e-07,
  -3.108289233004019e-09,  -2.704002258607428e-10,  -1.904178883844958e-11,   2.682885375177038e-13,   2.637826668381451e-14,  -3.190668501657751e-17,   8.117715808244576e-01,
  -1.134157891278791e-02,   8.850394751052341e-05,   5.596212558089030e-07,  -3.163194930547324e-09,  -2.693030735144814e-10,  -1.890014788222352e-11,   2.680209198500789e-13,
   2.611599238300347e-14,  -3.548530836428285e-17,   8.117815423044992e-01,  -1.134139045569244e-02,   8.850173594273741e-05,   5.593199037029011e-07,  -3.194819733177490e-09,
  -2.686700620988710e-10,  -1.881861984141817e-11,   2.678627404457998e-13,   2.596514076365810e-14,  -3.753140133339226e-17,   8.117852829154636e-01,  -1.134131969684485e-02,
   8.850090365820777e-05,   5.592068042806794e-07,  -3.206683390544116e-09,  -2.684323937470989e-10,  -1.878804596282880e-11,   2.678026401204225e-13,   2.590859108807288e-14,
  -3.829611460717292e-17,   8.117859029740142e-01,  -1.134130796801009e-02,   8.850076559922179e-05,   5.591880596656934e-07,  -3.208649340964699e-09,  -2.683929986034966e-10,
  -1.878298005100459e-11,   2.677926406503614e-13,   2.589922226230293e-14,  -3.842268641556404e-17,   1.141780782406076e+00,  -1.517708989498722e-02,   6.755529113107120e-05,
   2.587830537115408e-06,  -1.761291323122264e-08,  -8.567349395788729e-10,  -2.828343879798408e-11,   5.034026734111026e-13,   5.765966101490996e-14,  -1.096808814181538e-16,
   1.141790365116988e+00,  -1.517598935340465e-02,   6.753992641779821e-05,   2.586623936277890e-06,  -1.767068397635122e-08,  -8.552417983657524e-10,  -2.806314477253946e-11,
   5.027139161816006e-13,   5.720074984787940e-14,  -1.145081526143052e-16,   1.141806095056450e+00,  -1.517418300560590e-02,   6.751466792114834e-05,   2.584644636637554e-06,
  -1.776518911803405e-08,  -8.527921333581863e-10,  -2.770279886963702e-11,   5.015661502928093e-13,   5.645073398439578e-14,  -1.223244597722588e-16,   1.141822783519030e+00,
  -1.517226683265732e-02,   6.748781947395340e-05,   2.582546526448077e-06,  -1.786501232819466e-08,  -8.501950000114040e-10,  -2.732220881828087e-11,   5.003253119141949e-13,
   5.565946129704608e-14,  -1.304719446421869e-16,   1.141835915818803e+00,  -1.517075915750063e-02,   6.746665549628386e-05,   2.580896807733907e-06,  -1.794324582855535e-08,
  -8.481526147659949e-10,  -2.702395609319207e-11,   4.993323026581907e-13,   5.504000893716264e-14,  -1.367790937702060e-16,   1.141843494080775e+00,  -1.516988919413695e-02,
   6.745442770715980e-05,   2.579945325852738e-06,  -1.798826475703467e-08,  -8.469745495763994e-10,  -2.685233780057723e-11,   4.987526734508923e-13,   5.468382292883055e-14,
  -1.403772938100497e-16,   1.141846339671532e+00,  -1.516956254172689e-02,   6.744983347534776e-05,   2.579588148898312e-06,  -1.800514505612465e-08,  -8.465322950487269e-10,
  -2.678798950606041e-11,   4.985337865303271e-13,   5.455031904818180e-14,  -1.417205920974060e-16,   1.141846811362496e+00,  -1.516950839586400e-02,   6.744907177988318e-05,
   2.579528947716407e-06,  -1.800794190213115e-08,  -8.464589914104935e-10,  -2.677732791995556e-11,   4.984974381403887e-13,   5.452820191429176e-14,  -1.419428491348603e-16,
   1.590536912560969e+00,  -1.772642850030903e-02,  -1.484718557612006e-04,   9.284576753486517e-06,   1.140456724325244e-07,  -9.636429905560774e-09,  -1.337082984623962e-10,
   1.122793402931219e-11,   1.863821071689760e-13,  -1.338594102219547e-14,   1.590515976572880e+00,  -1.772251213762201e-02,  -1.483760440877688e-04,   9.271136982769112e-06,
   1.137686284451034e-07,  -9.603915772448221e-09,  -1.329995407477291e-10,   1.116246405700706e-11,   1.847333306731211e-13,  -1.326922745801590e-14,   1.590481616365426e+00,
  -1.771608687780278e-02,  -1.482189220555588e-04,   9.249106436996241e-06,   1.133148915495893e-07,  -9.550677973655009e-09,  -1.318406574300069e-10,   1.105540879676360e-11,
   1.820425368380173e-13,  -1.307866906819871e-14,   1.590445170574961e+00,  -1.770927472469148e-02,  -1.480524318614617e-04,   9.225775115025994e-06,   1.128348996499147e-07,
  -9.494377531455593e-09,  -1.306172973543854e-10,   1.094238944911451e-11,   1.792089443886755e-13,  -1.287788654012850e-14,   1.590416496984407e+00,  -1.770391753423162e-02,
  -1.479215683107136e-04,   9.207445610267392e-06,   1.124581961072359e-07,  -9.450205222979191e-09,  -1.296590519109125e-10,   1.085385698417691e-11,   1.769944031441266e-13,
  -1.272088864226181e-14,   1.590399952675521e+00,  -1.770082740079371e-02,  -1.478461104877732e-04,   9.196880249461844e-06,   1.122412140652214e-07,  -9.424767082282733e-09,
  -1.291078453702691e-10,   1.080292872362673e-11,   1.757225360488943e-13,  -1.263068883586315e-14,   1.590393740837376e+00,  -1.769966732833056e-02,  -1.478177878059120e-04,
   9.192915297638327e-06,   1.121598145940999e-07,  -9.415225105156163e-09,  -1.289012042528890e-10,   1.078383588330452e-11,   1.752461033876838e-13,  -1.259689458778416e-14,
   1.590392711173968e+00,  -1.769947504571486e-02,  -1.478130935741511e-04,   9.192258179111261e-06,   1.121463256547286e-07,  -9.413643928743161e-09,  -1.288669685756322e-10,
   1.078067261758669e-11,   1.751671892850443e-13,  -1.259129674748456e-14,   4.021423783439058e-03,  -5.749957065017290e-05,   6.563006714929222e-07,  -4.018899371191115e-09,
   4.492000443945536e-11,  -2.641763040847521e-12,  -2.707492805312168e-15,   2.525804332071439e-15,   1.764782607461661e-17,  -2.900999103906250e-18,   4.021517256919818e-03,
  -5.750129945879761e-05,   6.563389982659291e-07,  -4.022597178039141e-09,   4.491501069196592e-11,  -2.634440935404050e-12,  -2.640904936898430e-15,   2.511573952421289e-15,
   1.746626122988302e-17,  -2.877285397658072e-18,   4.021670712709033e-03,  -5.750413870475093e-05,   6.564019150336775e-07,  -4.028660288748388e-09,   4.490691341848598e-11,
  -2.622450844565397e-12,  -2.532102589285088e-15,   2.488298788326920e-15,   1.717002490140401e-17,  -2.838554763328940e-18,   4.021833546520751e-03,  -5.750715289435354e-05,
   6.564686707703057e-07,  -4.035083626276422e-09,   4.489845811561608e-11,  -2.609769551741298e-12,  -2.417348453525402e-15,   2.463718939597160e-15,   1.685817167505317e-17,
  -2.797728150498825e-18,   4.021961701466432e-03,  -5.750952618436056e-05,   6.565212051486266e-07,  -4.040131533355544e-09,   4.489190226538773e-11,  -2.599819000611710e-12,
  -2.327536274442442e-15,   2.444458795070380e-15,   1.661452430837434e-17,  -2.765791625603552e-18,   4.022035663746952e-03,  -5.751089629983606e-05,   6.565515226770170e-07,
  -4.043041860071780e-09,   4.488815813710642e-11,  -2.594088219368972e-12,  -2.275903574225703e-15,   2.433377088301662e-15,   1.647462191531204e-17,  -2.747437979021299e-18,
   4.022063437612741e-03,  -5.751141087559176e-05,   6.565629070056624e-07,  -4.044134165457869e-09,   4.488675961011574e-11,  -2.591938495695886e-12,  -2.256552633677499e-15,
   2.429222154538010e-15,   1.642222121459473e-17,  -2.740560622254629e-18,   4.022068041544054e-03,  -5.751149617830713e-05,   6.565647941103121e-07,  -4.044315201643089e-09,
   4.488652817591872e-11,  -2.591582266409135e-12,  -2.253346922481550e-15,   2.428533749874096e-15,   1.641354210987119e-17,  -2.739421372298994e-18,   3.636568814146395e-02,
  -5.194879760818210e-04,   5.895859520487194e-06,  -3.481147216963346e-08,   3.796289752038452e-10,  -2.385518134983978e-11,  -2.980469421790258e-14,   2.335606302457636e-14,
   1.609895644010904e-16,  -2.679181899531454e-17,   3.636652781679139e-02,  -5.195029556755963e-04,   5.896183348083748e-06,  -3.484485005596057e-08,   3.795725169096546e-10,
  -2.378747110414372e-11,  -2.919757757710314e-14,   2.322465439217142e-14,   1.593175986529014e-16,  -2.657227347000618e-17,   3.636790631303745e-02,  -5.195275572708730e-04,
   5.896714930916561e-06,  -3.489957647790476e-08,   3.794807500884826e-10,  -2.367659384898436e-11,  -2.820561566689785e-14,   2.300972486699434e-14,   1.565897228874186e-16,
  -2.621370321866223e-17,   3.636936904936116e-02,  -5.195536752725003e-04,   5.897278937420295e-06,  -3.495755211905444e-08,   3.793846229349916e-10,  -2.355932421618251e-11,
  -2.715945365308429e-14,   2.278275024720526e-14,   1.537181191682356e-16,  -2.583573444123753e-17,   3.637052026330816e-02,  -5.195742402652426e-04,   5.897722781907749e-06,
  -3.500311180771736e-08,   3.793098683632774e-10,  -2.346730658191693e-11,  -2.634072185167069e-14,   2.260490068224180e-14,   1.514746252085030e-16,  -2.554007366379163e-17,
   3.637118466452555e-02,  -5.195861127255344e-04,   5.897978920654074e-06,  -3.502937819959098e-08,   3.792670849928626e-10,  -2.341431107109012e-11,  -2.587005414971706e-14,
   2.250257219285650e-14,   1.501864331807071e-16,  -2.537016172854599e-17,   3.637143415627248e-02,  -5.195905717082855e-04,   5.898075100930653e-06,  -3.503923639330470e-08,
   3.792510871380973e-10,  -2.339443142904690e-11,  -2.569366042723004e-14,   2.246420568045715e-14,   1.497039427913217e-16,  -2.530649378962272e-17,   3.637147551323169e-02,
  -5.195913108883675e-04,   5.898091044063414e-06,  -3.504087026121472e-08,   3.792484388346202e-10,  -2.339113718510587e-11,  -2.566443891222417e-14,   2.245784898385482e-14,
   1.496240283510037e-16,  -2.529594706686730e-17,   1.020073206165007e-01,  -1.454321056659678e-03,   1.630456574274980e-05,  -8.847480165796859e-08,   9.057812544195906e-10,
  -6.675049994738566e-11,  -1.139384387336871e-13,   6.859755666408250e-14,   4.600742502988885e-16,  -7.855299589011049e-17,   1.020096424287282e-01,  -1.454359157854983e-03,
   1.630533788661179e-05,  -8.856811891908105e-08,   9.055584867749601e-10,  -6.655162051941803e-11,  -1.122052447573413e-13,   6.821235633766362e-14,   4.552073369669643e-16,
  -7.790600863969343e-17,   1.020134541386080e-01,  -1.454421735541366e-03,   1.630660535470873e-05,  -8.872111227762877e-08,   9.051953990565880e-10,  -6.622594867188199e-11,
  -1.093736586951530e-13,   6.758234208308194e-14,   4.472671592258808e-16,  -7.684935301754981e-17,   1.020174987652365e-01,  -1.454488173878851e-03,   1.630795005912798e-05,
  -8.888317593980671e-08,   9.048136862325383e-10,  -6.588149861223744e-11,  -1.063877131977779e-13,   6.691703714329110e-14,   4.389091342074572e-16,  -7.573557193165221e-17,
   1.020206819857302e-01,  -1.454540489103339e-03,   1.630900822096027e-05,  -8.901052278458211e-08,   9.045158385292953e-10,  -6.561121824417358e-11,  -1.040511548436549e-13,
   6.639573889752255e-14,   4.323796388782718e-16,  -7.486436059023442e-17,   1.020225191158217e-01,  -1.454570692418993e-03,   1.630961885591532e-05,  -8.908393784476470e-08,
   9.043449689528047e-10,  -6.545555558719118e-11,  -1.027080314595314e-13,   6.609580671453365e-14,   4.286306143049276e-16,  -7.436369945772595e-17,   1.020232089823550e-01,
  -1.454582036175832e-03,   1.630984814581322e-05,  -8.911149095647776e-08,   9.042809989551627e-10,  -6.539716338062285e-11,  -1.022046841498151e-13,   6.598335260601182e-14,
   4.272264505446358e-16,  -7.417609816050036e-17,   1.020233233379195e-01,  -1.454583916677265e-03,   1.630988615339001e-05,  -8.911605748956000e-08,   9.042704051975070e-10,
  -6.538748723507730e-11,  -1.021213002938467e-13,   6.596472086779944e-14,   4.269938816542207e-16,  -7.414502173911578e-17,   2.030153160507948e-01,  -2.884857216371501e-03,
   3.166939459134556e-05,  -1.453610758538731e-07,   1.270912924509019e-09,  -1.325635044478447e-10,  -3.184246255316794e-13,   1.468216755423049e-13,   9.446078343268379e-16,
  -1.680866588032223e-16,   2.030198250132519e-01,  -2.884919927333980e-03,   3.167047615975065e-05,  -1.455461413055796e-07,   1.270275120152578e-09,  -1.321378273820051e-10,
  -3.148715088311045e-13,   1.459977262862515e-13,   9.343504571265604e-16,  -1.666909794434552e-16,   2.030272273157724e-01,  -2.885022933804507e-03,   3.167225134892840e-05,
  -1.458495237744532e-07,   1.269233432094699e-09,  -1.314407653493850e-10,  -3.090674266472238e-13,   1.446501583812607e-13,   9.176173543630206e-16,  -1.644116719141372e-16,
   2.030350818816099e-01,  -2.885132308044336e-03,   3.167413444662950e-05,  -1.461708493029690e-07,   1.268135396144869e-09,  -1.307035089384038e-10,  -3.029480055141762e-13,
   1.432271624122122e-13,   9.000055828709593e-16,  -1.620092846733378e-16,   2.030412635753416e-01,  -2.885218441415294e-03,   3.167561608277467e-05,  -1.464233101482907e-07,
   1.267276484958140e-09,  -1.301250029965647e-10,  -2.981602117854176e-13,   1.421122180619164e-13,   8.862482043499409e-16,  -1.601302168283393e-16,   2.030448311954199e-01,
  -2.885268172804280e-03,   3.167647101545088e-05,  -1.465688405167884e-07,   1.266782888338682e-09,  -1.297918233259585e-10,  -2.954083531893477e-13,   1.414707443323093e-13,
   8.783497123423700e-16,  -1.590504102802731e-16,   2.030461708805034e-01,  -2.885286851617173e-03,   3.167679202315538e-05,  -1.466234565679969e-07,   1.266597933674983e-09,
  -1.296668407943662e-10,  -2.943771281928138e-13,   1.412302385439635e-13,   8.753915061674510e-16,  -1.586458069795003e-16,   2.030463929529182e-01,  -2.885289948118329e-03,
   3.167684523330055e-05,  -1.466325082702329e-07,   1.266567295653070e-09,  -1.296461299911268e-10,  -2.942062998839872e-13,   1.411903909781282e-13,   8.749015497463311e-16,
  -1.585787842853165e-16,   3.429730577965268e-01,  -4.848308136738902e-03,   5.141818054672957e-05,  -1.631339107882535e-07,   7.267069777916882e-10,  -2.244782556067659e-10,
  -7.366773500274962e-13,   2.755258537590965e-13,   1.674832180532217e-15,  -3.171116872383986e-16,   3.429803762120254e-01,  -4.848378885719219e-03,   5.141879258815255e-05,
  -1.634466386401274e-07,   7.252086103804108e-10,  -2.236795450205159e-10,  -7.303890625972726e-13,   2.739722297040178e-13,   1.656079241771570e-15,  -3.144469075432318e-16,
   3.429923906374758e-01,  -4.848495126560622e-03,   5.141979645180067e-05,  -1.639592207027888e-07,   7.227582969721652e-10,  -2.223716424090400e-10,  -7.201186943662770e-13,
   2.714313976106457e-13,   1.625491477488632e-15,  -3.100953447593818e-16,   3.430051389557071e-01,  -4.848618595975501e-03,   5.142086040677281e-05,  -1.645020090812251e-07,
   7.201711912941283e-10,  -2.209883439758957e-10,  -7.092925908506273e-13,   2.687485060106715e-13,   1.593303412792058e-15,  -3.055092548450089e-16,   3.430151720101260e-01,
  -4.848715860274524e-03,   5.142169686265908e-05,  -1.649283908176872e-07,   7.181444066003789e-10,  -2.199029208908804e-10,  -7.008239541649024e-13,   2.666465247497238e-13,
   1.568164059537505e-15,  -3.019224927444615e-16,   3.430209623064558e-01,  -4.848772030736331e-03,   5.142217924485669e-05,  -1.651741456263741e-07,   7.169784185323476e-10,
  -2.192777978559515e-10,  -6.959571285140919e-13,   2.654372138254460e-13,   1.553732561172275e-15,  -2.998614897354253e-16,   3.430231366249228e-01,  -4.848793130355487e-03,
   5.142236031757193e-05,  -1.652663688708096e-07,   7.165412781177145e-10,  -2.190433025227005e-10,  -6.941334694560355e-13,   2.649838192691326e-13,   1.548327882620362e-15,
  -2.990892568989047e-16,   3.430234970495750e-01,  -4.848796628291311e-03,   5.142239032945538e-05,  -1.652816530228881e-07,   7.164688527164113e-10,  -2.190044444590612e-10,
  -6.938313764472819e-13,   2.649087002491977e-13,   1.547432743243171e-15,  -2.989613375255326e-16,   5.278258869379231e-01,  -7.399349763480437e-03,   7.399212759552419e-05,
  -4.652241536890479e-08,  -2.366868200893442e-09,  -3.527036299275759e-10,  -1.413254745545333e-12,   4.914490868518846e-13,   2.769185247203326e-15,  -5.769253918914964e-16,
   5.278364124640997e-01,  -7.399371353493964e-03,   7.399009032023652e-05,  -4.701235792905881e-08,  -2.369762576869431e-09,  -3.512798265211243e-10,  -1.402875037122778e-12,
   4.886248731529672e-13,   2.737319204162868e-15,  -5.719894328793703e-16,   5.278536916071787e-01,  -7.399406945394162e-03,   7.398674405518478e-05,  -4.781523200675714e-08,
  -2.374498493278809e-09,  -3.489484384033804e-10,  -1.385924838255223e-12,   4.840064163883522e-13,   2.685355523731839e-15,  -5.639300704204640e-16,   5.278720258258572e-01,
  -7.399444912598945e-03,   7.398319103886779e-05,  -4.866518166735751e-08,  -2.379502444139249e-09,  -3.464828101171259e-10,  -1.368060831982778e-12,   4.791301806724069e-13,
   2.630690465808408e-15,  -5.554377247458041e-16,   5.278864547440166e-01,  -7.399474938654970e-03,   7.398039308410884e-05,  -4.933267875228792e-08,  -2.383425272519487e-09,
  -3.445482354606971e-10,  -1.354089283920478e-12,   4.753100855222497e-13,   2.588008719979079e-15,  -5.487968877242333e-16,   5.278947818713239e-01,  -7.399492325607690e-03,
   7.397877764467876e-05,  -4.971733692467534e-08,  -2.385683096755985e-09,  -3.434341092979540e-10,  -1.346060972792902e-12,   4.731124374605288e-13,   2.563511825783847e-15,
  -5.449813675142313e-16,   5.278979087746447e-01,  -7.399498865598722e-03,   7.397817090178959e-05,  -4.986167274236369e-08,  -2.386529778359566e-09,  -3.430161882658148e-10,
  -1.343052850076365e-12,   4.722885198278661e-13,   2.554338541878773e-15,  -5.435518131799465e-16,   5.278984271027951e-01,  -7.399499950276885e-03,   7.397807031865260e-05,
  -4.988559281993948e-08,  -2.386670067139381e-09,  -3.429469353022318e-10,  -1.342554557818960e-12,   4.721520133138943e-13,   2.552819284306877e-15,  -5.433150132937306e-16,
   7.677844787329204e-01,  -1.060918407163964e-02,   9.472813475526489e-05,   4.498956577004205e-07,  -1.200627311462132e-08,  -5.627034461659753e-10,  -1.665068777285757e-12,
   8.815835341869924e-13,   4.381028734011790e-15,  -1.093288987787011e-15,   7.677979385885951e-01,  -1.060899475031762e-02,   9.471786432325988e-05,   4.491163396288084e-07,
  -1.200963393728549e-08,  -5.601537629854165e-10,  -1.648658831575751e-12,   8.762393998155407e-13,   4.330023131336260e-15,  -1.083637993116519e-15,   7.678200340613497e-01,
  -1.060868418421010e-02,   9.470100173301060e-05,   4.478395503302992e-07,  -1.201512650345716e-08,  -5.559794232673329e-10,  -1.621862729450459e-12,   8.675012034384723e-13,
   4.246885930916389e-15,  -1.067883429509869e-15,   7.678434776267983e-01,  -1.060835496917923e-02,   9.468310649245003e-05,   4.464882884243367e-07,  -1.202092099777236e-08,
  -5.515655486361912e-10,  -1.593624068142621e-12,   8.582767797987340e-13,   4.159477100355743e-15,  -1.051287115358794e-15,   7.678619267941647e-01,  -1.060809610629262e-02,
   9.466902087457193e-05,   4.454273747383295e-07,  -1.202545710248723e-08,  -5.481029402306078e-10,  -1.571539883521705e-12,   8.510513457883685e-13,   4.091265771786954e-15,
  -1.038312496262814e-15,   7.678725737517721e-01,  -1.060794680397398e-02,   9.466089100167276e-05,   4.448161158432040e-07,  -1.202806531014923e-08,  -5.461090537647625e-10,
  -1.558850465994038e-12,   8.468950841803009e-13,   4.052130878960567e-15,  -1.030859214961472e-15,   7.678765717112844e-01,  -1.060789075694190e-02,   9.465783800498146e-05,
   4.445867737277871e-07,  -1.202904289451756e-08,  -5.453611698950392e-10,  -1.554095981596597e-12,   8.453369463987711e-13,   4.037478888742054e-15,  -1.028066959762515e-15,
   7.678772344261349e-01,  -1.060788146726556e-02,   9.465733191924804e-05,   4.445487670965507e-07,  -1.202920484700793e-08,  -5.452372417389333e-10,  -1.553308411941270e-12,
   8.450787987212000e-13,   4.035052405560067e-15,  -1.027604447324022e-15,   1.082341246723340e+00,  -1.451872603826028e-02,   9.625510769462623e-05,   2.140354538660639e-06,
  -3.940838965615359e-08,  -1.182435526421041e-09,   6.931145475098079e-12,   1.721190627859966e-12,   3.984688530223709e-15,  -2.428446805757551e-15,   1.082354877038255e+00,
  -1.451781806314261e-02,   9.622154396393150e-05,   2.138713520102208e-06,  -3.939342178799965e-08,  -1.177479525491140e-09,   6.945816687448098e-12,   1.709367947256160e-12,
   3.925822702788978e-15,  -2.405195351405516e-15,   1.082377249968226e+00,  -1.451632797169585e-02,   9.616645295761524e-05,   2.136024542628112e-06,  -3.936882760616825e-08,
  -1.169368586900003e-09,   6.969736801464434e-12,   1.690043460619308e-12,   3.829967520897976e-15,  -2.367255382126115e-15,   1.082400984704303e+00,  -1.451474754367059e-02,
   9.610800977438261e-05,   2.133178138433127e-06,  -3.934270150984862e-08,  -1.160796321584024e-09,   6.994894778587624e-12,   1.669652873173637e-12,   3.729313937113442e-15,
  -2.327310450903508e-15,   1.082419660684254e+00,  -1.451350422597533e-02,   9.606202383383077e-05,   2.130942922135010e-06,  -3.932211868837642e-08,  -1.154074492233396e-09,
   7.014533646051764e-12,   1.653687686541558e-12,   3.650857921800846e-15,  -2.296098359025924e-15,   1.082430437601922e+00,  -1.451278687820820e-02,   9.603548811863511e-05,
   2.129654903187612e-06,  -3.931023137790422e-08,  -1.150205024006724e-09,   7.025803557173113e-12,   1.644506741731349e-12,   3.605881716851172e-15,  -2.278174913711793e-15,
   1.082434484185472e+00,  -1.451251754385548e-02,   9.602552438765986e-05,   2.129171610826339e-06,  -3.930576596052421e-08,  -1.148753855346607e-09,   7.030023449028431e-12,
   1.641065405612848e-12,   3.589049616153557e-15,  -2.271461376950112e-15,   1.082435154951102e+00,  -1.451247289977560e-02,   9.602387279324637e-05,   2.129091517790820e-06,
  -3.930502566862735e-08,  -1.148513401162816e-09,   7.030722320558695e-12,   1.640495281625210e-12,   3.586262451378798e-15,  -2.270349402163463e-15,   1.517985012725171e+00,
  -1.845274473144825e-02,  -3.272550277142205e-05,   9.505993707149264e-06,  -8.386759090756195e-08,  -8.881779343071773e-09,   1.855635509498973e-10,   8.911073189436557e-12,
  -3.024194109977272e-13,  -8.774898372367903e-15,   1.517980216021668e+00,  -1.844873025258732e-02,  -3.279495200928745e-05,   9.493572678680728e-06,  -8.348506680908906e-08,
  -8.855838295677649e-09,   1.844136089821448e-10,   8.867736996466599e-12,  -2.997420521972325e-13,  -8.714260181907183e-15,   1.517972334655353e+00,  -1.844214361758066e-02,
  -3.290873237962520e-05,   9.473207946687851e-06,  -8.285883674830049e-08,  -8.813344427721153e-09,   1.825333642405510e-10,   8.796815220733568e-12,  -2.953711164592216e-13,
  -8.615101967780744e-15,   1.517963962685362e+00,  -1.843515982408745e-02,  -3.302914769853161e-05,   9.451635215427970e-06,  -8.219672375312807e-08,  -8.768380685536181e-09,
   1.805485310317414e-10,   8.721862121764433e-12,  -2.907661904544154e-13,  -8.510414985140290e-15,   1.517957367226959e+00,  -1.842966725658072e-02,  -3.312368797196161e-05,
   9.434683259138817e-06,  -8.167734508851438e-08,  -8.733084671577479e-09,   1.789938497078646e-10,   8.663090512027278e-12,  -2.871658368921529e-13,  -8.428406642551610e-15,
   1.517953558186827e+00,  -1.842649887636263e-02,  -3.317815808232182e-05,   9.424910320995610e-06,  -8.137828442902076e-08,  -8.712750936681222e-09,   1.780995663783308e-10,
   8.629258998163033e-12,  -2.850974799131232e-13,  -8.381230332691040e-15,   1.517952127349699e+00,  -1.842530939917776e-02,  -3.319859498138437e-05,   9.421242443489767e-06,
  -8.126611306439880e-08,  -8.705122267293494e-09,   1.777643112103498e-10,   8.616571297396205e-12,  -2.843225776947092e-13,  -8.363543904171698e-15,   1.517951890141349e+00,
  -1.842511224113410e-02,  -3.320198178462252e-05,   9.420634543543899e-06,  -8.124752584977163e-08,  -8.703858067334974e-09,   1.777087672295687e-10,   8.614468992342884e-12,
  -2.841942206800997e-13,  -8.360613640862716e-15,   3.801632947508576e-03,  -5.243377296824851e-05,   6.106969113532173e-07,  -3.702458361880917e-09,  -2.923276461580483e-12,
  -1.891887417693396e-12,   6.023586797429818e-14,   1.473728010667297e-15,  -7.367706911514357e-17,  -1.328011599025935e-18,   3.801719850582011e-03,  -5.243536300592014e-05,
   6.106951233017121e-07,  -3.705114453881541e-09,  -2.798030617687589e-12,  -1.887588237210277e-12,   5.995380118728433e-14,   1.467132101318748e-15,  -7.311836550187878e-17,
  -1.320245411559214e-18,   3.801862515974590e-03,  -5.243797412133742e-05,   6.106922641692312e-07,  -3.709470480357305e-09,  -2.592848405913580e-12,  -1.880544549260051e-12,
   5.949232670576946e-14,   1.456332328215851e-15,  -7.220557155603841e-17,  -1.307532690547040e-18,   3.802013894896209e-03,  -5.244074581844110e-05,   6.106893338873806e-07,
  -3.714086618391294e-09,  -2.375716095417867e-12,  -1.873089798615693e-12,   5.900481224973303e-14,   1.444911565889848e-15,  -7.124299244225265e-17,  -1.294093403756571e-18,
   3.802133030843931e-03,  -5.244292795582040e-05,   6.106871025497394e-07,  -3.717715246773162e-09,  -2.205252082205404e-12,  -1.867236707095718e-12,   5.862268392215160e-14,
   1.435951277796167e-15,  -7.048973696429347e-17,  -1.283552714009320e-18,   3.802201786506403e-03,  -5.244418762934016e-05,   6.106858447517731e-07,  -3.719807678949078e-09,
  -2.107042085786191e-12,  -1.863864311199087e-12,   5.840276898332149e-14,   1.430791289540394e-15,  -7.005673530709423e-17,  -1.277483938196727e-18,   3.802227604937218e-03,
  -5.244466070961448e-05,   6.106853780927375e-07,  -3.720593083140661e-09,  -2.070194991297517e-12,  -1.862598988655024e-12,   5.832030548493708e-14,   1.428855771448225e-15,
  -6.989446259256698e-17,  -1.275207785081938e-18,   3.802231884711470e-03,  -5.244473913262425e-05,   6.106853010356276e-07,  -3.720723257993626e-09,  -2.064088731181208e-12,
  -1.862389298469431e-12,   5.830664213357306e-14,   1.428535042813060e-15,  -6.986758062569853e-17,  -1.274830624252721e-18,   3.437952332054027e-02,  -4.739241979429489e-04,
   5.499303252401784e-06,  -3.237191459786121e-08,  -5.249338011118784e-11,  -1.704200220812822e-11,   5.515039343661282e-13,   1.358739721124406e-14,  -6.812503799542535e-16,
  -1.219155093907728e-17,   3.438030583480251e-02,  -4.739381026617929e-04,   5.499264911379544e-06,  -3.239583280033950e-08,  -5.134696318054971e-11,  -1.700236077035607e-11,
   5.488958954570308e-13,   1.352684179316349e-14,  -6.760807005058623e-16,  -1.212036874962151e-17,   3.438159045573309e-02,  -4.739609368115854e-04,   5.499202666169399e-06,
  -3.243505802692385e-08,  -4.946890184707722e-11,  -1.693741250081459e-11,   5.446290319310495e-13,   1.342769133163432e-14,  -6.676347051596317e-16,  -1.200384519724444e-17,
   3.438295353396386e-02,  -4.739851755287462e-04,   5.499137566218077e-06,  -3.247662422519291e-08,  -4.748151367128148e-11,  -1.686867315094980e-11,   5.401214127637547e-13,
   1.332283915121140e-14,  -6.587281589472426e-16,  -1.188065777591347e-17,   3.438402628092858e-02,  -4.740042587032267e-04,   5.499087016854062e-06,  -3.250929742265036e-08,
  -4.592131444462398e-11,  -1.681470195262879e-11,   5.365882168254130e-13,   1.324057579729030e-14,  -6.517585180717926e-16,  -1.178403648371707e-17,   3.438464538308016e-02,
  -4.740152748514331e-04,   5.499058117925232e-06,  -3.252813790122527e-08,  -4.502244739672884e-11,  -1.678360495985968e-11,   5.345548657487164e-13,   1.319320239489776e-14,
  -6.477521178744356e-16,  -1.172840580562265e-17,   3.438487786188788e-02,  -4.740194120678378e-04,   5.499047317856977e-06,  -3.253520969230536e-08,  -4.468520731187043e-11,
  -1.677193732993328e-11,   5.337924024109041e-13,   1.317543254277421e-14,  -6.462506757625232e-16,  -1.170754075351112e-17,   3.438491639856704e-02,  -4.740200978993278e-04,
   5.499045530321024e-06,  -3.253638178490415e-08,  -4.462932041123319e-11,  -1.677000375948257e-11,   5.336660701374279e-13,   1.317248795474912e-14,  -6.460019483805837e-16,
  -1.170408338168266e-17,   9.644440215209474e-02,  -1.327984129661112e-03,   1.528706844455772e-05,  -8.416206834623372e-08,  -3.036638748472183e-10,  -4.741272406486168e-11,
   1.588911333145237e-12,   3.965010333646357e-14,  -2.001636885436700e-15,  -3.527781330227085e-17,   9.644657713067613e-02,  -1.328020295040325e-03,   1.528682782176848e-05,
  -8.422856578466578e-08,  -3.003627424439769e-10,  -4.729702105114365e-11,   1.581248987568544e-12,   3.947485592477857e-14,  -1.986420529484441e-15,  -3.507270249730685e-17,
   9.645014768834427e-02,  -1.328079686657513e-03,   1.528643480922447e-05,  -8.433761424148082e-08,  -2.949550557405194e-10,  -4.710745080776275e-11,   1.568713138101216e-12,
   3.918791133005808e-14,  -1.961561196446816e-15,  -3.473691981828795e-17,   9.645393629665892e-02,  -1.328142733315825e-03,   1.528602051866791e-05,  -8.445316312357447e-08,
  -2.892328881822855e-10,  -4.690681086987435e-11,   1.555470062928809e-12,   3.888446159530472e-14,  -1.935346962655086e-15,  -3.438190554114175e-17,   9.645691793016192e-02,
  -1.328192371307735e-03,   1.528569644057591e-05,  -8.454398505089251e-08,  -2.847409279778621e-10,  -4.674927383252461e-11,   1.545089850498066e-12,   3.864638254502428e-14,
  -1.914834004474159e-15,  -3.410343183062818e-17,   9.645863868071143e-02,  -1.328221026351616e-03,   1.528551019774861e-05,  -8.459635385688874e-08,  -2.821530966244665e-10,
  -4.665850327082923e-11,   1.539116077227135e-12,   3.850927759716195e-14,  -1.903042606400702e-15,  -3.394308965618579e-17,   9.645928483806013e-02,  -1.328231788114772e-03,
   1.528544041072107e-05,  -8.461601011873638e-08,  -2.811822022734247e-10,  -4.662444580671034e-11,   1.536876045090058e-12,   3.845784904936705e-14,  -1.898623687018018e-15,
  -3.388294958249233e-17,   9.645939194780564e-02,  -1.328233572110661e-03,   1.528542885038018e-05,  -8.461926796428269e-08,  -2.810213080879757e-10,  -4.661880175963088e-11,
   1.536504895273035e-12,   3.844932696966382e-14,  -1.897891655172618e-15,  -3.387298419735095e-17,   1.919717774939297e-01,  -2.638330961883328e-03,   2.996204024632984e-05,
  -1.452655145232782e-07,  -1.130208769230542e-09,  -9.309730629676980e-11,   3.310552896177181e-12,   8.390639517842853e-14,  -4.293083477304229e-15,  -7.374295285558263e-17,
   1.919760394505191e-01,  -2.638393439294651e-03,   2.996111406658579e-05,  -1.453959362808037e-07,  -1.123336258630736e-09,  -9.285238882868748e-11,   3.294121240071414e-12,
   8.353996015403711e-14,  -4.260327684909649e-15,  -7.331827347023395e-17,   1.919830360531431e-01,  -2.638496045844030e-03,   2.995959777269194e-05,  -1.456097952102555e-07,
  -1.112078915687257e-09,  -9.245110130211937e-11,   3.267238854324972e-12,   8.293995622669652e-14,  -4.206815404375725e-15,  -7.262295328482695e-17,   1.919904598687455e-01,
  -2.638604973329346e-03,   2.995799454040785e-05,  -1.458363774198116e-07,  -1.100167898137846e-09,  -9.202636809067864e-11,   3.238840330395626e-12,   8.230541999474734e-14,
  -4.150388805072364e-15,  -7.188769310931188e-17,   1.919963023635479e-01,  -2.638690738902238e-03,   2.995673688887099e-05,  -1.460144539661765e-07,  -1.090818343703550e-09,
  -9.169286965171481e-11,   3.216581280462487e-12,   8.180756449190174e-14,  -4.106235921160600e-15,  -7.131087054658195e-17,   1.919996741466949e-01,  -2.638740251541786e-03,
   2.995601271519670e-05,  -1.461171273910188e-07,  -1.085432325439821e-09,  -9.150070889309382e-11,   3.203771414692176e-12,   8.152085380422810e-14,  -4.080856307805447e-15,
  -7.097870909931011e-17,   1.920009402782153e-01,  -2.638758846987091e-03,   2.995574109080961e-05,  -1.461556637673472e-07,  -1.083411670522416e-09,  -9.142860872185472e-11,
   3.198968025132401e-12,   8.141330654553470e-14,  -4.071345219875179e-15,  -7.085411794868162e-17,   1.920011501572909e-01,  -2.638761929604275e-03,   2.995569608152867e-05,
  -1.461620507468681e-07,  -1.083076815505392e-09,  -9.141666015034228e-11,   3.198172155222547e-12,   8.139548513595325e-14,  -4.069769633140332e-15,  -7.083347250353335e-17,
   3.243899551472845e-01,  -4.444929916453279e-03,   4.938619970004656e-05,  -1.857889018440598e-07,  -3.328763760673241e-09,  -1.541304148648906e-10,   6.027654492688087e-12,
   1.544196239787782e-13,  -8.108005197773960e-15,  -1.336246132059419e-16,   3.243969775939132e-01,  -4.445009994570145e-03,   4.938342809611385e-05,  -1.860044434033206e-07,
  -3.316263771692415e-09,  -1.536795162122347e-10,   5.996630502483576e-12,   1.537551955183680e-13,  -8.045692204724474e-15,  -1.328716946534664e-16,   3.244085058030692e-01,
  -4.445141521388512e-03,   4.937888565825331e-05,  -1.863578303662539e-07,  -3.295790204799126e-09,  -1.529407151960939e-10,   5.945876183787024e-12,   1.526671940250658e-13,
  -7.943897728557397e-15,  -1.316386436751240e-16,   3.244207377527186e-01,  -4.445281170628750e-03,   4.937407609198518e-05,  -1.867321776925584e-07,  -3.274130152960086e-09,
  -1.521587197052752e-10,   5.892261135039307e-12,   1.515164926052362e-13,  -7.836565713317164e-15,  -1.303343465153985e-16,   3.244303640928995e-01,  -4.445391139780596e-03,
   4.937029839147766e-05,  -1.870263401590184e-07,  -3.257129789677301e-09,  -1.515446795900200e-10,   5.850238387959638e-12,   1.506135964832324e-13,  -7.752584698740745e-15,
  -1.293108057947564e-16,   3.244359195345462e-01,  -4.445454630949973e-03,   4.936812119030069e-05,  -1.871959265540331e-07,  -3.247337033432757e-09,  -1.511908631543725e-10,
   5.826055215283964e-12,   1.500936029772609e-13,  -7.704313199316212e-15,  -1.287212836316153e-16,   3.244380056378195e-01,  -4.445478477393609e-03,   4.936730419307040e-05,
  -1.872595738365852e-07,  -3.243663245590306e-09,  -1.510581069553732e-10,   5.816987206801437e-12,   1.498985452280342e-13,  -7.686223647954343e-15,  -1.285001360097638e-16,
   3.244383514382261e-01,  -4.445482430540264e-03,   4.936716879379856e-05,  -1.872701224866257e-07,  -3.243054446646688e-09,  -1.510361062725487e-10,   5.815484740526364e-12,
   1.498662224232654e-13,  -7.683226989074999e-15,  -1.284634894373233e-16,   4.994072236256766e-01,  -6.810814595211103e-03,   7.298055963932411e-05,  -1.380573250652530e-07,
  -8.675736197834183e-09,  -2.306542080882371e-10,   1.051819324578358e-11,   2.657035654538329e-13,  -1.470255599356057e-14,  -2.258379192434968e-16,   4.994175946484337e-01,
  -6.810874670177930e-03,   7.297327502999577e-05,  -1.383790262936954e-07,  -8.653948477125731e-09,  -2.298780737220111e-10,   1.046196908389761e-11,   2.645788406283435e-13,
  -1.458795588424176e-14,  -2.246330592978705e-16,   4.994346196315402e-01,  -6.810973390706780e-03,   7.296132940117108e-05,  -1.389063600500574e-07,  -8.618265907523886e-09,
  -2.286063319939625e-10,   1.036999270668226e-11,   2.627368569019157e-13,  -1.440075731220162e-14,  -2.226586889035880e-16,   4.994526834641730e-01,  -6.811078273534916e-03,
   7.294867212657672e-05,  -1.394648284050706e-07,  -8.580519873985832e-09,  -2.272601837738854e-10,   1.027283847412813e-11,   2.607883886745567e-13,  -1.420339167670242e-14,
  -2.205686526657643e-16,   4.994668990789657e-01,  -6.811160912859574e-03,   7.293872376681400e-05,  -1.399035697360584e-07,  -8.550897271775570e-09,  -2.262031200981261e-10,
   1.019669487549708e-11,   2.592592858985432e-13,  -1.404897645159829e-14,  -2.189273692255999e-16,   4.994751029012521e-01,  -6.811208644072528e-03,   7.293298757030708e-05,
  -1.401564651459190e-07,  -8.533834979957790e-09,  -2.255940134556738e-10,   1.015287772730439e-11,   2.583785533272147e-13,  -1.396022475648072e-14,  -2.179815968892494e-16,
   4.994781834638768e-01,  -6.811226574879668e-03,   7.293083455279038e-05,  -1.402513711855610e-07,  -8.527434241603339e-09,  -2.253654663985416e-10,   1.013644787657956e-11,
   2.580481586158695e-13,  -1.392696630625082e-14,  -2.176267238053725e-16,   4.994786941083664e-01,  -6.811229547550616e-03,   7.293047771106653e-05,  -1.402671001243356e-07,
  -8.526373560908096e-09,  -2.253275908675255e-10,   1.013372565466769e-11,   2.579934083205375e-13,  -1.392145686178083e-14,  -2.175679129779676e-16,   7.268918791191938e-01,
  -9.833857924803230e-03,   9.861846138873284e-05,   1.738033228002240e-07,  -2.173224586405179e-08,  -3.264618242092413e-10,   1.926143721149805e-11,   4.396269750513881e-13,
  -2.748496035638972e-14,  -3.655149672830936e-16,   7.269058763922228e-01,  -9.833785325289624e-03,   9.860013075053884e-05,   1.733495636597420e-07,  -2.169237085626504e-08,
  -3.251771530316347e-10,   1.915645250943454e-11,   4.377983114989739e-13,  -2.726483117412641e-14,  -3.638808177328817e-16,   7.269288533322587e-01,  -9.833666278931126e-03,
   9.857006225803822e-05,   1.726059538679577e-07,  -2.162706916188436e-08,  -3.230720786426642e-10,   1.898472661025740e-11,   4.348023204929362e-13,  -2.690528437459804e-14,
  -3.611973579270445e-16,   7.269532311299577e-01,  -9.833540148189799e-03,   9.853819012303927e-05,   1.718187036232636e-07,  -2.155799538502965e-08,  -3.208437541606029e-10,
   1.880335666498660e-11,   4.316315742722212e-13,  -2.652625448848169e-14,  -3.583491168655850e-16,   7.269724147674719e-01,  -9.833441017599316e-03,   9.851313033489121e-05,
   1.712004185742881e-07,  -2.150379020817008e-08,  -3.190938988215531e-10,   1.866122677500211e-11,   4.291421410278197e-13,  -2.622974062526573e-14,  -3.561069914179089e-16,
   7.269834852916479e-01,  -9.833383861441820e-03,   9.849867734746599e-05,   1.708441087195397e-07,  -2.147256983885749e-08,  -3.180855635957331e-10,   1.857944430415142e-11,
   4.277078299474055e-13,  -2.605932916443331e-14,  -3.548128294057928e-16,   7.269876422459705e-01,  -9.833362408944651e-03,   9.849325190214267e-05,   1.707104080114713e-07,
  -2.146085807662406e-08,  -3.177072146427330e-10,   1.854878010395277e-11,   4.271696835382426e-13,  -2.599547229117736e-14,  -3.543268268894927e-16,   7.269883313133937e-01,
  -9.833358853424550e-03,   9.849235265158554e-05,   1.706882503306721e-07,  -2.145891730634526e-08,  -3.176445132317483e-10,   1.854369949478311e-11,   4.270805018957471e-13,
  -2.598489417828792e-14,  -3.542462634261696e-16,   1.025951759106595e+00,  -1.365832694575317e-02,   1.174482130918612e-04,   1.345306468952635e-06,  -5.774645406685137e-08,
  -5.001816315477992e-10,   4.476364524960048e-11,   6.336782706948487e-13,  -5.975374155840905e-14,  -4.716098362820418e-16,   1.025968374760665e+00,  -1.365775506118462e-02,
   1.173994314284132e-04,   1.344610300928516e-06,  -5.765359293332657e-08,  -4.983265484769727e-10,   4.453581257405206e-11,   6.312605576587399e-13,  -5.925518593280869e-14,
  -4.717165341762255e-16,   1.025995647112565e+00,  -1.365681643125727e-02,   1.173194048913464e-04,   1.343469320410870e-06,  -5.750149245148023e-08,  -4.952863515879405e-10,
   4.416319990126506e-11,   6.272914622754547e-13,  -5.844096734075300e-14,  -4.718428045571462e-16,   1.026024578484047e+00,  -1.365582075900601e-02,   1.172345671669414e-04,
   1.342261220286168e-06,  -5.734057128213830e-08,  -4.920675648768945e-10,   4.376974083914614e-11,   6.230800032031374e-13,  -5.758275640106929e-14,  -4.719110463531086e-16,
   1.026047342775603e+00,  -1.365503736700391e-02,   1.171678548143769e-04,   1.341312296410224e-06,  -5.721426426510931e-08,  -4.895395011204719e-10,   4.346146549405077e-11,
   6.197656796452585e-13,  -5.691147382117661e-14,  -4.719177058504568e-16,   1.026060478550133e+00,  -1.365458533917203e-02,   1.171293759815786e-04,   1.340765397610410e-06,
  -5.714150551597985e-08,  -4.880825656839286e-10,   4.328410483818616e-11,   6.178529900440449e-13,  -5.652571389400686e-14,  -4.719028704343788e-16,   1.026065410796884e+00,
  -1.365441561390655e-02,   1.171149309841487e-04,   1.340560172153863e-06,  -5.711420945711919e-08,  -4.875358612120156e-10,   4.321760810514096e-11,   6.171347724615968e-13,
  -5.638116834705905e-14,  -4.718937904366408e-16,   1.026066228368013e+00,  -1.365438748034136e-02,   1.171125367398549e-04,   1.340526160505683e-06,  -5.710968609296783e-08,
  -4.874452576559163e-10,   4.320659079909129e-11,   6.170157185516673e-13,  -5.635722424836647e-14,  -4.718921006923524e-16,   1.444325265170533e+00,  -1.829266905273555e-02,
   6.839583616426361e-05,   7.047703734471716e-06,  -2.031726164081083e-07,  -2.689073971605859e-09,   2.780659287685589e-10,  -2.209074463955132e-12,  -2.903408618871493e-13,
   7.817168142039034e-15,   1.444334656196128e+00,  -1.828967393911445e-02,   6.822563911441655e-05,   7.043826790576500e-06,  -2.025924133227808e-07,  -2.695082259223047e-09,
   2.769378232547076e-10,  -2.171616702123765e-12,  -2.889508286178432e-13,   7.719753593329794e-15,   1.444350056101311e+00,  -1.828475818299763e-02,   6.794658694698094e-05,
   7.037456223727263e-06,  -2.016416412447718e-07,  -2.704866592516886e-09,   2.750898421781750e-10,  -2.110476912354736e-12,  -2.866717347848875e-13,   7.560830609055002e-15,
   1.444366373528545e+00,  -1.827954382800761e-02,   6.765097134309822e-05,   7.030688536199318e-06,  -2.006351398972771e-07,  -2.715141240924637e-09,   2.731344050280837e-10,
  -2.046080881316053e-12,  -2.842573775205706e-13,   7.393552197775231e-15,   1.444379198746744e+00,  -1.827544129294009e-02,   6.741866761626392e-05,   7.025356555462669e-06,
  -1.998447105817384e-07,  -2.723150088854190e-09,   2.715993816295823e-10,  -1.995745392913956e-12,  -2.823601443718516e-13,   7.262876595875778e-15,   1.444386593748614e+00,
  -1.827307411686403e-02,   6.728473966175075e-05,   7.022277061440637e-06,  -1.993892159506091e-07,  -2.727741250242461e-09,   2.707150580836958e-10,  -1.966833387382163e-12,
  -2.812663770451084e-13,   7.187849728345880e-15,   1.444389369382906e+00,  -1.827218530892027e-02,   6.723447465080056e-05,   7.021120246733273e-06,  -1.992183011542309e-07,
  -2.729459448922526e-09,   2.703832821108574e-10,  -1.956002586517858e-12,  -2.808558774362341e-13,   7.159749648246199e-15,   1.444389829417434e+00,  -1.827203798104116e-02,
   6.722614389106165e-05,   7.020928465270116e-06,  -1.991899763286062e-07,  -2.729743957797828e-09,   2.703283011226245e-10,  -1.954208593456322e-12,  -2.807878429297793e-13,
   7.155095517622972e-15,   3.601383408713309e-03,  -4.772902715365103e-05,   5.650186454356871e-07,  -3.964458300673110e-09,  -2.443157515314087e-11,  -2.357143116147968e-13,
   6.644031968041841e-14,  -9.397212122987628e-16,  -5.778156778422036e-17,   1.831900111822190e-18,   3.601463774663743e-03,  -4.773072093681845e-05,   5.649985717883612e-07,
  -3.964816133068784e-09,  -2.429241863344774e-11,  -2.383816974730195e-13,   6.621513614473996e-14,  -9.308395473478917e-16,  -5.753768162218479e-17,   1.812995320875103e-18,
   3.601595706442737e-03,  -4.773350167169026e-05,   5.649657026818473e-07,  -3.965406258367076e-09,  -2.406431541924402e-11,  -2.427417828829888e-13,   6.584616104946674e-14,
  -9.163275849149516e-16,  -5.713769480173689e-17,   1.782129076691461e-18,   3.601735693632195e-03,  -4.773645240397483e-05,   5.649309414727335e-07,  -3.966036066290186e-09,
  -2.382274821065277e-11,  -2.473426184003834e-13,   6.545560084272367e-14,  -9.010223390406153e-16,  -5.671381607303987e-17,   1.749606391056975e-18,   3.601845862389256e-03,
  -4.773877476029063e-05,   5.649036677192353e-07,  -3.966534355240294e-09,  -2.363297187935617e-11,  -2.509450627552856e-13,   6.514891587096382e-14,  -8.890441481236147e-16,
  -5.638061542457533e-17,   1.724175776701324e-18,   3.601909442174189e-03,  -4.774011508354418e-05,   5.648879609441988e-07,  -3.966822977797007e-09,  -2.352358371492049e-11,
  -2.530167339221718e-13,   6.497219757917376e-14,  -8.821581169337171e-16,  -5.618847826308167e-17,   1.709565134291022e-18,   3.601933316872337e-03,  -4.774061839696401e-05,
   5.648820692112201e-07,  -3.966931556626980e-09,  -2.348253295800799e-11,  -2.537932765147818e-13,   6.490589017506489e-14,  -8.795774020829607e-16,  -5.611635915828591e-17,
   1.704091112745810e-18,   3.601937274437735e-03,  -4.774070182882748e-05,   5.648810929053217e-07,  -3.966949565569819e-09,  -2.347572955682167e-11,  -2.539219262679918e-13,
   6.489490152025090e-14,  -8.791498782539426e-16,  -5.610440598754919e-17,   1.703184369829646e-18,   3.256930724745637e-02,  -4.315186821143386e-04,   5.097122934780977e-06,
  -3.513716277369753e-08,  -2.437321823626384e-10,  -1.869738706887973e-12,   6.082345126341939e-13,  -8.681234597209715e-15,  -5.316933831612113e-16,   1.696598796020496e-17,
   3.257003220160939e-02,  -4.315336931147910e-04,   5.096922030371753e-06,  -3.514003039264985e-08,  -2.424583884690700e-10,  -1.894376963438821e-12,   6.061622395140697e-13,
  -8.598976518677762e-15,  -5.294581751949843e-16,   1.679095118442256e-17,   3.257122231169984e-02,  -4.315583370348637e-04,   5.096592991603676e-06,  -3.514476285745354e-08,
  -2.403704221876650e-10,  -1.934649973567511e-12,   6.027666851947909e-13,  -8.464572912070293e-15,  -5.257921722049959e-16,   1.650516511109610e-17,   3.257248508406120e-02,
  -4.315844874115142e-04,   5.096244912798611e-06,  -3.514981798247641e-08,  -2.381592349259273e-10,  -1.977146096330426e-12,   5.991724557532176e-13,  -8.322821998558195e-15,
  -5.219070063967104e-16,   1.620404243008958e-17,   3.257347887344673e-02,  -4.316050688200729e-04,   5.095971737238237e-06,  -3.515382065401882e-08,  -2.364221325858663e-10,
  -2.010420008197806e-12,   5.963500845499652e-13,  -8.211884719774926e-15,  -5.188528395163461e-16,   1.596858428556250e-17,   3.257405240108961e-02,  -4.316169471251280e-04,
   5.095814388370880e-06,  -3.515614037433245e-08,  -2.354208635652981e-10,  -2.029554775945003e-12,   5.947237653187437e-13,  -8.148108941295027e-15,  -5.170916284612498e-16,
   1.583330664186375e-17,   3.257426776497905e-02,  -4.316214076171756e-04,   5.095755360128162e-06,  -3.515701328286915e-08,  -2.350451125658865e-10,  -2.036727192912324e-12,
   5.941135436106463e-13,  -8.124207336597222e-15,  -5.164305440282509e-16,   1.578262354487264e-17,   3.257430346455027e-02,  -4.316221470112951e-04,   5.095745578401569e-06,
  -3.515715807644806e-08,  -2.349828388775797e-10,  -2.037915444840651e-12,   5.940124158051824e-13,  -8.120247771876892e-15,  -5.163209739899069e-16,   1.577422815654806e-17,
   9.137046936551142e-02,  -1.209867249760791e-03,   1.422409021323420e-05,  -9.429560897022806e-08,  -8.204644779166218e-10,  -3.663413396228378e-12,   1.750865212498415e-12,
  -2.548419624658937e-14,  -1.546017046223572e-15,   5.002529744960292e-17,   9.137249219132475e-02,  -1.209907527315266e-03,   1.422341039995457e-05,  -9.430142931565847e-08,
  -8.167984621570308e-10,  -3.735723097220846e-12,   1.744838468015916e-12,  -2.524164519309626e-14,  -1.539573944563379e-15,   4.950948583999435e-17,   9.137581292075792e-02,
  -1.209973651377824e-03,   1.422229661626115e-05,  -9.431105714378070e-08,  -8.107893312366913e-10,  -3.853916110218864e-12,   1.734963095102678e-12,  -2.484533360588383e-14,
  -1.529005612871494e-15,   4.866730967269570e-17,   9.137933638107580e-02,  -1.210043816765313e-03,   1.422111784670030e-05,  -9.432137165437553e-08,  -8.044257038872088e-10,
  -3.978630212420499e-12,   1.724509694155379e-12,  -2.442735570844171e-14,  -1.517804280368752e-15,   4.777993826779910e-17,   9.138210929760728e-02,  -1.210099039219493e-03,
   1.422019234821768e-05,  -9.432956042313632e-08,  -7.994265518966258e-10,  -4.076277345677307e-12,   1.716300997842903e-12,  -2.410023619949927e-14,  -1.508997942334446e-15,
   4.708607208225713e-17,   9.138370957583539e-02,  -1.210130909952551e-03,   1.421965910575872e-05,  -9.433431478651790e-08,  -7.965450696552486e-10,  -4.132430144500256e-12,
   1.711570884284935e-12,  -2.391218082742552e-14,  -1.503919350692569e-15,   4.668742549264080e-17,   9.138431049128896e-02,  -1.210142877876564e-03,   1.421945903430080e-05,
  -9.433610546864512e-08,  -7.954637293163006e-10,  -4.153478103586195e-12,   1.709796056193795e-12,  -2.384170218014132e-14,  -1.502012996864127e-15,   4.653806863361423e-17,
   9.138441010136655e-02,  -1.210144861739030e-03,   1.421942587836826e-05,  -9.433640258299132e-08,  -7.952845177966583e-10,  -4.156965102352174e-12,   1.709501925642756e-12,
  -2.383002660955260e-14,  -1.501697028894095e-15,   4.651332845578734e-17,   1.818862242853658e-01,  -2.406025494158623e-03,   2.806436543887416e-05,  -1.734244454955048e-07,
  -2.092433103537565e-09,  -1.916708775520055e-12,   3.636500571600210e-12,  -5.473170469074343e-14,  -3.257297832741682e-15,   1.079510360963847e-16,   1.818902145452523e-01,
  -2.406099547370997e-03,   2.806262188073555e-05,  -1.734284764601978e-07,  -2.084821077832247e-09,  -2.071966350511604e-12,   3.623798685154382e-12,  -5.420826894047230e-14,
  -3.243926809901395e-15,   1.068390014830912e-16,   1.818967650303710e-01,  -2.406221119252733e-03,   2.805976419786583e-05,  -1.734352502102524e-07,  -2.072344155175209e-09,
  -2.325735237787193e-12,   3.602984901547293e-12,  -5.335300726215752e-14,  -3.221991540749761e-15,   1.050233541916081e-16,   1.819037153675053e-01,  -2.406350118546236e-03,
   2.805673828868631e-05,  -1.734426494488361e-07,  -2.059131576923176e-09,  -2.593497685310162e-12,   3.580952056996666e-12,  -5.245098310339336e-14,  -3.198737883541312e-15,
   1.031102630789919e-16,   1.819091851502441e-01,  -2.406451643231021e-03,   2.805436144808364e-05,  -1.734486255297188e-07,  -2.048752297985119e-09,  -2.803141493746570e-12,
   3.563649858060453e-12,  -5.174503347776668e-14,  -3.180452901035520e-15,   1.016143462104990e-16,   1.819123418011002e-01,  -2.406510235744941e-03,   2.805299155541962e-05,
  -1.734521355504214e-07,  -2.042769856814766e-09,  -2.923696671568823e-12,   3.553679552208344e-12,  -5.133919362154957e-14,  -3.169906699827002e-15,   1.007548958131445e-16,
   1.819135271420940e-01,  -2.406532237936994e-03,   2.805247749251249e-05,  -1.734534651291945e-07,  -2.040524834401544e-09,  -2.968884385081440e-12,   3.549938462410661e-12,
  -5.118709427035238e-14,  -3.165947721544012e-15,   1.004328939048797e-16,   1.819137236286558e-01,  -2.406535885121634e-03,   2.805239229744451e-05,  -1.734536861337642e-07,
  -2.040152765940939e-09,  -2.976370575461091e-12,   3.549318474042798e-12,  -5.116189730804328e-14,  -3.165291529142892e-15,   1.003795559632517e-16,   3.073847781437041e-01,
  -4.059841776519470e-03,   4.676358621740036e-05,  -2.549359634108476e-07,  -4.774429696699891e-09,   1.151478113709556e-11,   6.560920928495443e-12,  -1.042283067437438e-13,
  -5.974818594472357e-15,   2.059236291658020e-16,   3.073914249051174e-01,  -4.059950565659593e-03,   4.675958724634256e-05,  -2.549220587958276e-07,  -4.760700890296480e-09,
   1.121914469424053e-11,   6.537609317531841e-12,  -1.032297313697238e-13,  -5.950915721022978e-15,   2.038056804442714e-16,   3.074023362410844e-01,  -4.060129156928051e-03,
   4.675303067316351e-05,  -2.548995296690749e-07,  -4.738198534859059e-09,   1.073593022428969e-11,   6.499408277642173e-12,  -1.015981084265250e-13,  -5.911691901694942e-15,
   2.003476102176744e-16,   3.074139134706192e-01,  -4.060318651071723e-03,   4.674608502622613e-05,  -2.548760277420286e-07,  -4.714370260672282e-09,   1.022607537879165e-11,
   6.458967419307722e-12,  -9.987725760832101e-14,  -5.870095810358323e-15,   1.967038938487423e-16,   3.074230244195946e-01,  -4.060467780380100e-03,   4.674062699848704e-05,
  -2.548578226204294e-07,  -4.695652327387439e-09,   9.826890043219584e-12,   6.427207850306053e-12,  -9.853045888071051e-14,  -5.837377066267770e-15,   1.938546975490143e-16,
   3.074282823695925e-01,  -4.060553844398180e-03,   4.673748036101479e-05,  -2.548474324404691e-07,  -4.684863874314087e-09,   9.597341065075101e-12,   6.408905871190141e-12,
  -9.775619960459498e-14,  -5.818501705007459e-15,   1.922177307725209e-16,   3.074302567524757e-01,  -4.060586162025509e-03,   4.673629939016624e-05,  -2.548435527802564e-07,
  -4.680815353359492e-09,   9.511299495671485e-12,   6.402038415232093e-12,  -9.746602429109150e-14,  -5.811415217499672e-15,   1.916044214515489e-16,   3.074305840331369e-01,
  -4.060591519120763e-03,   4.673610366019110e-05,  -2.548429108284261e-07,  -4.680144392841326e-09,   9.497045115644203e-12,   6.400900306144785e-12,  -9.741795344942154e-14,
  -5.810240605138514e-15,   1.915028297980661e-16,   4.733174908611150e-01,  -6.236209656262590e-03,   7.038770149484644e-05,  -2.985296301805185e-07,  -1.044939346800780e-08,
   5.559110524974574e-11,   1.117630741291537e-11,  -1.938534466962447e-13,  -1.030743877123684e-14,   3.795362165150409e-16,   4.733274898741783e-01,  -6.236336842865690e-03,
   7.037891157177042e-05,  -2.984551382021424e-07,  -1.042601341666491e-08,   5.504099276241730e-11,   1.113605238133315e-11,  -1.920126610328656e-13,  -1.026812153209685e-14,
   3.756448559714535e-16,   4.733439039898423e-01,  -6.236545618346239e-03,   7.036449576784388e-05,  -2.983334013457073e-07,  -1.038769295065341e-08,   5.414180342945935e-11,
   1.107008051080041e-11,  -1.890048628679741e-13,  -1.020356715736186e-14,   3.692910227877502e-16,   4.733613194365923e-01,  -6.236767115577154e-03,   7.034921886913523e-05,
  -2.982049795988430e-07,  -1.034711569615098e-08,   5.319299061153591e-11,   1.100023322041874e-11,  -1.858325175865187e-13,  -1.013505986225304e-14,   3.625957706552880e-16,
   4.733750246175172e-01,  -6.236941413636461e-03,   7.033720988746894e-05,  -2.981044526674371e-07,  -1.031524172509654e-08,   5.245009181393323e-11,   1.094537451439720e-11,
  -1.833496840951660e-13,  -1.008113833878241e-14,   3.573602074802117e-16,   4.733829337980187e-01,  -6.237041995889687e-03,   7.033028488304783e-05,  -2.980466531745368e-07,
  -1.029687087635518e-08,   5.202287812604906e-11,   1.091375916984659e-11,  -1.819223138489467e-13,  -1.005001725719677e-14,   3.543520968127199e-16,   4.733859037083056e-01,
  -6.237079763909823e-03,   7.032768553544398e-05,  -2.980249897568562e-07,  -1.028997701924804e-08,   5.186274338950514e-11,   1.090189574010171e-11,  -1.813873636371687e-13,
  -1.003833067369533e-14,   3.532250550935025e-16,   4.733863960099842e-01,  -6.237086024414573e-03,   7.032725471229845e-05,  -2.980214008895707e-07,  -1.028883450526052e-08,
   5.183621395899561e-11,   1.089992965240491e-11,  -1.812987428751520e-13,  -1.003639344027716e-14,   3.530383653252222e-16,   6.891387744097137e-01,  -9.042798608050299e-03,
   9.849069016276842e-05,  -1.986904775328824e-07,  -2.317085620816094e-08,   1.817981159211835e-10,   1.920878626872122e-11,  -3.870891701266030e-13,  -1.747889768468390e-14,
   7.289444053985852e-16,   6.891527510339592e-01,  -9.042882553838847e-03,   9.847113318379758e-05,  -1.984410077454157e-07,  -2.313066372862149e-08,   1.806974490220204e-10,
   1.914038033038631e-11,  -3.835520067811838e-13,  -1.741925984994372e-14,   7.215363367461911e-16,   6.891756939500057e-01,  -9.043020289598460e-03,   9.843905178440734e-05,
  -1.980325716697405e-07,  -2.306478614501944e-08,   1.788980393163160e-10,   1.902825354348338e-11,  -3.777721275670727e-13,  -1.732120029810174e-14,   7.094390270582773e-16,
   6.892000354748694e-01,  -9.043166336354646e-03,   9.840504426588450e-05,  -1.976006924183533e-07,  -2.299502732627434e-08,   1.769989059752133e-10,   1.890951320687359e-11,
  -3.716757230002664e-13,  -1.721694606590033e-14,   6.966898207166681e-16,   6.892191904418762e-01,  -9.043281202550428e-03,   9.837830427120448e-05,  -1.972618861174379e-07,
  -2.294022974763245e-08,   1.755116235158810e-10,   1.881623415352639e-11,  -3.669041421201542e-13,  -1.713475207903510e-14,   6.867188452452459e-16,   6.892302443702100e-01,
  -9.043347464714876e-03,   9.836288174921397e-05,  -1.970667881999530e-07,  -2.290864623429644e-08,   1.746562200300115e-10,   1.876246927616660e-11,  -3.641608872737623e-13,
  -1.708725916955925e-14,   6.809894566631479e-16,   6.892343950832681e-01,  -9.043372341272098e-03,   9.835709226206057e-05,  -1.969936088615548e-07,  -2.289679410140238e-08,
   1.743355615422687e-10,   1.874229294406854e-11,  -3.631327518269644e-13,  -1.706941443943877e-14,   6.788427402371486e-16,   6.892350831156187e-01,  -9.043376464625177e-03,
   9.835613266785178e-05,  -1.969814826546218e-07,  -2.289482985159588e-08,   1.742824370119834e-10,   1.873894910965824e-11,  -3.629624282302850e-13,  -1.706645586030058e-14,
   6.784871403347785e-16,   9.732771844144433e-01,  -1.267024048338413e-02,   1.279143109623061e-04,   4.018628530893950e-07,  -5.667470952385311e-08,   5.764733029476531e-10,
   3.731034009788149e-11,  -9.945456729365731e-13,  -2.905104160463818e-14,   1.651467930908786e-15,   9.732952911454092e-01,  -1.267006611011466e-02,   1.278663624628687e-04,
   4.026593146104141e-07,  -5.659642530972301e-08,   5.736286473745670e-10,   3.719579930667142e-11,  -9.865136275733957e-13,  -2.899340520601603e-14,   1.635386086827609e-15,
   9.733250114144162e-01,  -1.266977960793348e-02,   1.277876951200978e-04,   4.039639618037954e-07,  -5.646808515890155e-08,   5.689757576423855e-10,   3.700793391644664e-11,
  -9.733863105748066e-13,  -2.889775867112527e-14,   1.609112891794176e-15,   9.733565403140516e-01,  -1.266947528094035e-02,   1.277042880015404e-04,   4.053443977468465e-07,
  -5.633214546535559e-08,   5.640618166662881e-10,   3.680882936014329e-11,  -9.595365777229293e-13,  -2.879488852998348e-14,   1.581408130930119e-15,   9.733813489452103e-01,
  -1.266923553830718e-02,   1.276386931849545e-04,   4.064279950257466e-07,  -5.622533322784213e-08,   5.602112155886292e-10,   3.665230450655415e-11,  -9.486940259465442e-13,
  -2.871293974489784e-14,   1.559729296534901e-15,   9.733956645765756e-01,  -1.266909708379031e-02,   1.276008559678693e-04,   4.070522350312691e-07,  -5.616375911120295e-08,
   5.579956334334055e-10,   3.656204009155143e-11,  -9.424594639712400e-13,  -2.866525248196622e-14,   1.547267977347947e-15,   9.734010398766707e-01,  -1.266904507492273e-02,
   1.275866512746488e-04,   4.072864309814462e-07,  -5.614065051458882e-08,   5.571649198504973e-10,   3.652815802165817e-11,  -9.401226418959120e-13,  -2.864727158332902e-14,
   1.542598055655642e-15,   9.734019308905159e-01,  -1.266903645276877e-02,   1.275842968310830e-04,   4.073252411155362e-07,  -5.613682062471237e-08,   5.570272835790409e-10,
   3.652254227665255e-11,  -9.397355077868525e-13,  -2.864428710610280e-14,   1.541824446261956e-15,   1.372703904469337e+00,  -1.746437550677872e-02,   1.327685800637789e-04,
   3.693069776278251e-06,  -1.994207130368407e-07,   2.485233137427502e-09,   1.341278929432081e-10,  -6.383765904680038e-12,   2.062716470192041e-14,   6.664471902749456e-15,
   1.372722459297510e+00,  -1.746278694125654e-02,   1.325999320861116e-04,   3.696450371551419e-06,  -1.991337413804516e-07,   2.466689946853418e-09,   1.341863599753280e-10,
  -6.350245136601552e-12,   1.947268436403711e-14,   6.641504097673869e-15,   1.372752902966549e+00,  -1.746017804692706e-02,   1.323232464226621e-04,   3.701981314795133e-06,
  -1.986625532289330e-07,   2.436320293439252e-09,   1.342790860806037e-10,  -6.295301920644765e-12,   1.758926608291079e-14,   6.603598117860166e-15,   1.372785182843385e+00,
  -1.745740844301668e-02,   1.320299025164815e-04,   3.707824493328393e-06,  -1.981624832459068e-07,   2.404193487430766e-09,   1.343730676724666e-10,  -6.237120943043384e-12,
   1.560686378360624e-14,   6.563107692622331e-15,   1.372810570480044e+00,  -1.745522776405349e-02,   1.317992138040593e-04,   3.712404616815243e-06,  -1.977688531350332e-07,
   2.378980209607643e-09,   1.344438547233135e-10,  -6.191417963834195e-12,   1.405828231227662e-14,   6.531049223372522e-15,   1.372825215451505e+00,  -1.745396885709700e-02,
   1.316661487839417e-04,   3.715040494871928e-06,  -1.975416531735621e-07,   2.364457441997262e-09,   1.344834386079123e-10,  -6.165076355718189e-12,   1.316919379541820e-14,
   6.512471442826324e-15,   1.372830713512167e+00,  -1.745349605055046e-02,   1.316161947670000e-04,   3.716028895711093e-06,  -1.974563320574078e-07,   2.359009345653185e-09,
   1.344980635188799e-10,  -6.155191347833808e-12,   1.283620537211021e-14,   6.505480999886573e-15,   1.372831624827337e+00,  -1.745341767217165e-02,   1.316079148711588e-04,
   3.716192663599501e-06,  -1.974421885850671e-07,   2.358106527717209e-09,   1.345004752005235e-10,  -6.153553110947694e-12,   1.278105379823484e-14,   6.504321481945532e-15,
   3.419197085626620e-03,  -4.340566955169292e-05,   5.151931249851018e-07,  -4.318303473681554e-09,  -1.613149577383579e-11,   9.003666184232663e-13,   2.503951516025705e-14,
  -1.645057041073292e-15,   1.106503290025330e-17,   1.448526571081694e-18,   3.419270374314834e-03,  -4.340750875471547e-05,   5.151796568306555e-07,  -4.317062606295522e-09,
  -1.607759189057966e-11,   8.955666479139761e-13,   2.507838229004267e-14,  -1.637768312130313e-15,   1.081118805642993e-17,   1.443630521201182e-18,   3.419390688225300e-03,
  -4.341052773074569e-05,   5.151575800816362e-07,  -4.315030410475327e-09,  -1.598904272596959e-11,   8.877023762870811e-13,   2.514147101134231e-14,  -1.625821023396970e-15,
   1.039674764500820e-17,   1.435564809411852e-18,   3.419518348774799e-03,  -4.341373059100235e-05,   5.151342003647737e-07,  -4.312880729173704e-09,  -1.589500805518904e-11,
   8.793790332813442e-13,   2.520744083102982e-14,  -1.613169006292627e-15,   9.960092755503360e-18,   1.426968835995599e-18,   3.419618816990434e-03,  -4.341625089267289e-05,
   5.151158333044528e-07,  -4.311193716103962e-09,  -1.582094687585427e-11,   8.728438920364046e-13,   2.525865834084082e-14,  -1.603229930908758e-15,   9.618678729835153e-18,
   1.420176903331089e-18,   3.419676798638614e-03,  -4.341770526147636e-05,   5.151052465072963e-07,  -4.310222028645154e-09,  -1.577818266828933e-11,   8.690784909934933e-13,
   2.528793685972181e-14,  -1.597501176880412e-15,   9.422535663100612e-18,   1.416246508096043e-18,   3.419698571225153e-03,  -4.341825136374522e-05,   5.151012735537677e-07,
  -4.309857513118228e-09,  -1.576212013321050e-11,   8.676657084748230e-13,   2.529887840104254e-14,  -1.595351350554282e-15,   9.349050599088546e-18,   1.414768609994041e-18,
   3.419702180337803e-03,  -4.341834188655349e-05,   5.151006151114396e-07,  -4.309797108583532e-09,  -1.575945731962630e-11,   8.674315808878628e-13,   2.530068933359118e-14,
  -1.594995058792471e-15,   9.336878285387421e-18,   1.414523522319792e-18,   3.092202457653564e-02,  -3.924927905098953e-04,   4.653121700742667e-06,  -3.865235133571640e-08,
  -1.621883194570424e-10,   8.500487906019655e-12,   2.267692030588000e-13,  -1.512928269562535e-14,   1.037050766895534e-16,   1.331743372151304e-17,   3.092268647707144e-02,
  -3.925092507002042e-04,   4.652985986036675e-06,  -3.864062625745741e-08,  -1.616999907711425e-10,   8.456343349030447e-12,   2.271340187593062e-13,  -1.506225898048894e-14,
   1.013522779045286e-16,   1.327290339649429e-17,   3.092377308044396e-02,  -3.925362692359120e-04,   4.652763491063649e-06,  -3.862142260558404e-08,  -1.608977828341323e-10,
   8.384016895122739e-12,   2.277262679089656e-13,  -1.495239558948642e-14,   9.751091881579179e-17,   1.319953326324066e-17,   3.092492603230584e-02,  -3.925649331996930e-04,
   4.652527818241754e-06,  -3.860110707264726e-08,  -1.600458534325015e-10,   8.307468420226391e-12,   2.283456786214770e-13,  -1.483604937125292e-14,   9.346358211913224e-17,
   1.312132446386605e-17,   3.092583339824632e-02,  -3.925874884270244e-04,   4.652342640593595e-06,  -3.858516276250925e-08,  -1.593748601046720e-10,   8.247365746326661e-12,
   2.288266595489749e-13,  -1.474464928497402e-14,   9.029897395565438e-17,   1.305951857375756e-17,   3.092635705157363e-02,  -3.926005041036479e-04,   4.652235890489473e-06,
  -3.857597865438982e-08,  -1.589874095552201e-10,   8.212735937623225e-12,   2.291016466271008e-13,  -1.469196677978178e-14,   8.848087786925393e-17,   1.302374809542764e-17,
   3.092655368760400e-02,  -3.926053913578846e-04,   4.652195827362950e-06,  -3.857253326686137e-08,  -1.588418790317973e-10,   8.199742795652723e-12,   2.292044172719378e-13,
  -1.467219651691821e-14,   8.779972339436071e-17,   1.301029695884782e-17,   3.092658628278783e-02,  -3.926062014764259e-04,   4.652189187518604e-06,  -3.857196232051130e-08,
  -1.588177532117228e-10,   8.197589560478050e-12,   2.292214271662158e-13,  -1.466891997487231e-14,   8.768689445046122e-17,   1.300806624329863e-17,   8.675111376678109e-02,
  -1.100816152452508e-03,   1.301790091867215e-05,  -1.060463624958030e-07,  -5.526081833089278e-10,   2.600286899832286e-11,   6.377743099634364e-13,  -4.396424209445106e-14,
   3.135912476361269e-16,   3.865419151824977e-17,   8.675296537667687e-02,  -1.100861299279543e-03,   1.301743687043823e-05,  -1.060104387651124e-07,  -5.512338420862039e-10,
   2.587458699363009e-11,   6.388808786887977e-13,  -4.376962342236670e-14,   3.066428245490555e-16,   3.852799477378298e-17,   8.675600504760601e-02,  -1.100935404271553e-03,
   1.301667591230806e-05,  -1.059515948045271e-07,  -5.489760065598300e-10,   2.566440945507124e-11,   6.406778347639135e-13,  -4.345059885732133e-14,   2.952979412310181e-16,
   3.831999562670037e-17,   8.675923031041845e-02,  -1.101014020697066e-03,   1.301586963558112e-05,  -1.058893341539424e-07,  -5.465780669473404e-10,   2.544196255499953e-11,
   6.425579276996842e-13,  -4.311273425736858e-14,   2.833442499263841e-16,   3.809818270193159e-17,   8.676176856364692e-02,  -1.101075881612106e-03,   1.301523593087186e-05,
  -1.058404629093068e-07,  -5.446892946855624e-10,   2.526730627014767e-11,   6.440183759616043e-13,  -4.284730138618649e-14,   2.739973220199245e-16,   3.792282212953470e-17,
   8.676323342097227e-02,  -1.101111578502438e-03,   1.301487054406393e-05,  -1.058123096925454e-07,  -5.435986176794624e-10,   2.516667315270876e-11,   6.448535600333866e-13,
  -4.269430303249234e-14,   2.686272870976263e-16,   3.782130394358256e-17,   8.676378348601703e-02,  -1.101124982236457e-03,   1.301473340131558e-05,  -1.058017475751850e-07,
  -5.431889391183263e-10,   2.512891547978533e-11,   6.451657333778673e-13,  -4.263688623957943e-14,   2.666153629280536e-16,   3.778312389570469e-17,   8.676387466698988e-02,
  -1.101127204054869e-03,   1.301471067129924e-05,  -1.057999972643532e-07,  -5.431210227935956e-10,   2.512265824334739e-11,   6.452174043370991e-13,  -4.262737046408713e-14,
   2.662820989779102e-16,   3.777679190616200e-17,   1.726971993917794e-01,  -2.190379468064250e-03,   2.579466730566867e-05,  -2.031518489254680e-07,  -1.426678295759122e-09,
   5.904993979579245e-11,   1.272835367833816e-12,  -9.267153297858556e-14,   7.055074920081174e-16,   8.121062594213322e-17,   1.727008677443646e-01,  -2.190465909681205e-03,
   2.579346471892479e-05,  -2.030700937411985e-07,  -1.423932008426303e-09,   5.877951998167006e-11,   1.275337241964628e-12,  -9.226235248295426e-14,   6.904766947454938e-16,
   8.095669805622962e-17,   1.727068898178246e-01,  -2.190607792892621e-03,   2.579149218202226e-05,  -2.029361548080201e-07,  -1.419419836187361e-09,   5.833646139789473e-11,
   1.279401946914215e-12,  -9.159157122236655e-14,   6.659341841319687e-16,   8.053790160166075e-17,   1.727132795388776e-01,  -2.190758308432864e-03,   2.578940148479419e-05,
  -2.027944090911424e-07,  -1.414627083472533e-09,   5.786753590561284e-11,   1.283657324464575e-12,  -9.088112183044145e-14,   6.400728561093154e-16,   8.009093016533365e-17,
   1.727183081640321e-01,  -2.190876740725744e-03,   2.578775777350079e-05,  -2.026831247524297e-07,  -1.410851577353452e-09,   5.749935260255798e-11,   1.286964796530619e-12,
  -9.032293960457359e-14,   6.198498714661005e-16,   7.973730570803074e-17,   1.727212102343094e-01,  -2.190945080617805e-03,   2.578680982866585e-05,  -2.026190086007846e-07,
  -1.408671231207203e-09,   5.728721266531568e-11,   1.288857008712346e-12,  -9.000118156537659e-14,   6.082307660629657e-16,   7.953248617309144e-17,   1.727222999815568e-01,
  -2.190970741094839e-03,   2.578645399321197e-05,  -2.025949527871321e-07,  -1.407852220775556e-09,   5.720761734265739e-11,   1.289564423020406e-12,  -8.988043012957333e-14,
   6.038774832101058e-16,   7.945543623278909e-17,   1.727224806222867e-01,  -2.190974994589594e-03,   2.578639501510645e-05,  -2.025909662695607e-07,  -1.407716443920862e-09,
   5.719442672437628e-11,   1.289681522092057e-12,  -8.986041764689154e-14,   6.031563812024895e-16,   7.944265683604084e-17,   2.918725054883507e-01,  -3.699201753616768e-03,
   4.327787841244336e-05,  -3.222168934160950e-07,  -3.286653235786347e-09,   1.196449945267819e-10,   2.150841482350927e-12,  -1.707212731049299e-13,   1.434455382081435e-15,
   1.483540093645799e-16,   2.918786586585781e-01,  -3.699338729235210e-03,   4.327509850506276e-05,  -3.220508257199104e-07,  -3.282002004645425e-09,   1.191467376241858e-10,
   2.155965226998549e-12,  -1.699728769265004e-13,   1.405690116159314e-15,   1.479247155224664e-16,   2.918887598019760e-01,  -3.699563546621523e-03,   4.327053772616122e-05,
  -3.217787062481766e-07,  -3.274358662660672e-09,   1.183303771337043e-10,   2.164295274904021e-12,  -1.687458840664258e-13,   1.358717706986798e-15,   1.472158303149096e-16,
   2.918994775136297e-01,  -3.699802027022336e-03,   4.326570231603544e-05,  -3.214906553267226e-07,  -3.266238234042584e-09,   1.174663401810555e-10,   2.173023851425874e-12,
  -1.674461604460195e-13,   1.309215694339745e-15,   1.464580961386007e-16,   2.919079121324465e-01,  -3.699989663022944e-03,   4.326189966931422e-05,  -3.212644557893654e-07,
  -3.259840044515750e-09,   1.167879187554311e-10,   2.179813771922564e-12,  -1.664248780173610e-13,   1.270502250589365e-15,   1.458577828631304e-16,   2.919127798050794e-01,
  -3.700097931676703e-03,   4.325970622916036e-05,  -3.211341110236185e-07,  -3.256144587630510e-09,   1.163970214006603e-10,   2.183700595264811e-12,  -1.658361221461689e-13,
   1.248257872252593e-15,   1.455097535027750e-16,   2.919146076436158e-01,  -3.700138583902193e-03,   4.325888278642512e-05,  -3.210852029308513e-07,  -3.254756353852483e-09,
   1.162503551244371e-10,   2.185154142747075e-12,  -1.656151608432580e-13,   1.239923361385294e-15,   1.453787688239943e-16,   2.919149106329119e-01,  -3.700145322393713e-03,
   4.325874630039425e-05,  -3.210770977006252e-07,  -3.254526205111878e-09,   1.162260493960558e-10,   2.185394773165739e-12,  -1.655785398066207e-13,   1.238542770759824e-15,
   1.453570406579962e-16,   4.494723715941493e-01,  -5.690111814718763e-03,   6.587981602043927e-05,  -4.445979099290645e-07,  -7.231310952067404e-09,   2.346610011631536e-10,
   3.276297789814670e-12,  -2.990155926539852e-13,   2.909884882480801e-15,   2.544317635003700e-16,   4.494817344413762e-01,  -5.690300471012321e-03,   6.587368199051327e-05,
  -4.442713227646592e-07,  -7.224194168374508e-09,   2.337879272035860e-10,   3.286797282690899e-12,  -2.977292751561089e-13,   2.856678059184893e-15,   2.538013069057299e-16,
   4.494971044464613e-01,  -5.690610081797108e-03,   6.586361641773718e-05,  -4.437360665572063e-07,  -7.212495194208753e-09,   2.323574020509817e-10,   3.303883248263890e-12,
  -2.956199779956116e-13,   2.769781176244204e-15,   2.527574238632052e-16,   4.495134123621237e-01,  -5.690938468296185e-03,   6.585294209295594e-05,  -4.431693256721443e-07,
  -7.200060572615761e-09,   2.308432620595536e-10,   3.321808737194559e-12,  -2.933851316390261e-13,   2.678187717472581e-15,   2.516378230165364e-16,   4.495262461639398e-01,
  -5.691196812950907e-03,   6.584454571011540e-05,  -4.427241705298554e-07,  -7.190259277426719e-09,   2.296543443672749e-10,   3.335769013712203e-12,  -2.916286849899658e-13,
   2.606544100050930e-15,   2.507481233889393e-16,   4.495336525560706e-01,  -5.691345869760252e-03,   6.583970174513923e-05,  -4.424676122975317e-07,  -7.184596704714828e-09,
   2.289692856489784e-10,   3.343766948227637e-12,  -2.906159674545959e-13,   2.565373462218897e-15,   2.502312559529686e-16,   4.495364336835031e-01,  -5.691401834718340e-03,
   6.583788311937522e-05,  -4.423713381424328e-07,  -7.182469212005747e-09,   2.287122450173662e-10,   3.346759157332489e-12,  -2.902358643399549e-13,   2.549946746759959e-15,
   2.500365271926687e-16,   4.495368946927327e-01,  -5.691411111323261e-03,   6.583758167360223e-05,  -4.423553828044581e-07,  -7.182116489572073e-09,   2.286696477043934e-10,
   3.347254574046665e-12,  -2.901728664427789e-13,   2.547391301621685e-15,   2.500042144426821e-16,   6.545199757479631e-01,  -8.270295436652086e-03,   9.407101729289813e-05,
  -5.197913482471078e-07,  -1.602378209619769e-08,   4.743252962569688e-10,   4.533358410037668e-12,  -5.318905335882962e-13,   6.472257073419014e-15,   4.276543034317913e-16,
   6.545333353459115e-01,  -8.270515011173077e-03,   9.405739202177207e-05,  -5.191294446219089e-07,  -1.601382682671109e-08,   4.727704327331266e-10,   4.557040337912340e-12,
  -5.297186730765423e-13,   6.369919905532990e-15,   4.269650540603569e-16,   6.545552658964627e-01,  -8.270875277103091e-03,   9.403503016410006e-05,  -5.180444075406078e-07,
  -1.599744821435113e-08,   4.702225509264084e-10,   4.595628039668558e-12,  -5.261559227638784e-13,   6.202739117041211e-15,   4.258125062601800e-16,   6.545785340147094e-01,
  -8.271257273940312e-03,   9.401131098337550e-05,  -5.168952506372252e-07,  -1.598002133563115e-08,   4.675254062890581e-10,   4.636179708288630e-12,  -5.223792944081235e-13,
   6.026462064455304e-15,   4.245612161531905e-16,   6.545968447773156e-01,  -8.271557709891273e-03,   9.399265001124132e-05,  -5.159924136495941e-07,  -1.596627179571711e-08,
   4.654073377584866e-10,   4.667810650875759e-12,  -5.194097976495009e-13,   5.888535959434438e-15,   4.235561061123215e-16,   6.546074117279174e-01,  -8.271731018226772e-03,
   9.398188286659729e-05,  -5.154719916247335e-07,  -1.595832290250484e-08,   4.641868014134404e-10,   4.685952204504710e-12,  -5.176971478126351e-13,   5.809258010873863e-15,
   4.229679460445710e-16,   6.546113796192741e-01,  -8.271796082282448e-03,   9.397784016340934e-05,  -5.152766856245865e-07,  -1.595533541976897e-08,   4.637288260113312e-10,
   4.692743166358323e-12,  -5.170542408513678e-13,   5.779549109721901e-15,   4.227455639861142e-16,   6.546120373485931e-01,  -8.271806866792630e-03,   9.397717005211833e-05,
  -5.152443170638323e-07,  -1.595484006506353e-08,   4.636529283960514e-10,   4.693867738988665e-12,  -5.169476809336477e-13,   5.774627637199347e-15,   4.227086208557450e-16,
   9.246531197486927e-01,  -1.164191203314672e-02,   1.278050589175448e-04,  -3.747107190271906e-07,  -3.876165346621203e-08,   1.085751553584352e-09,   4.898467051561246e-12,
  -1.064103620618435e-12,   1.864537093739751e-14,   7.003655419297017e-16,   9.246712409222826e-01,  -1.164206664484689e-02,   1.277720268005639e-04,  -3.731919241515933e-07,
  -3.875037722134166e-08,   1.082629196580030e-09,   4.968055558451898e-12,  -1.060496992274365e-12,   1.841708378713393e-14,   7.011181087378413e-16,   9.247009863753951e-01,
  -1.164232000246188e-02,   1.277178064490596e-04,  -3.707017640197555e-07,  -3.873176056077968e-08,   1.077511143201891e-09,   5.081648022595100e-12,  -1.054573813474101e-12,
   1.804390546689329e-14,   7.022908243954498e-16,   9.247325439987162e-01,  -1.164258820641038e-02,   1.276602843048863e-04,  -3.680638392750565e-07,  -3.871186484727438e-08,
   1.072091097555490e-09,   5.201299773022361e-12,  -1.048285842185994e-12,   1.765009456045716e-14,   7.034504424446117e-16,   9.247573766829413e-01,  -1.164279883000999e-02,
   1.276150212260954e-04,  -3.659909084899071e-07,  -3.869610443115949e-08,   1.067833172951090e-09,   5.294832139539568e-12,  -1.043335086367859e-12,   1.734172453844897e-14,
   7.043021571156453e-16,   9.247717067754234e-01,  -1.164292020303236e-02,   1.275889018935500e-04,  -3.647958330588070e-07,  -3.868696788555991e-08,   1.065378920423545e-09,
   5.348557928590439e-12,  -1.040477102889170e-12,   1.716438307332740e-14,   7.047694238782868e-16,   9.247770876153001e-01,  -1.164296574543022e-02,   1.275790943689700e-04,
  -3.643473071321127e-07,  -3.868352930767662e-08,   1.064457906229319e-09,   5.368684646352462e-12,  -1.039403753229462e-12,   1.709790759404483e-14,   7.049403158999708e-16,
   9.247779795532177e-01,  -1.164297329292130e-02,   1.275774686601396e-04,  -3.642729700276302e-07,  -3.868295890762210e-08,   1.064305265649983e-09,   5.372018415469621e-12,
  -1.039225822421175e-12,   1.708689455442616e-14,   7.049684029525320e-16,   1.305180855490567e+00,  -1.627457614079907e-02,   1.599901118850890e-04,   1.017741494532183e-06,
  -1.308793931482823e-07,   3.800294745475760e-09,  -1.029692228977917e-11,  -3.410258806480887e-12,   1.220670139596003e-13,  -4.213227699975792e-16,   1.305203398350165e+00,
  -1.627412286007569e-02,   1.598782711347556e-04,   1.023063357277280e-06,  -1.308957937498966e-07,   3.790082806315773e-09,  -9.825433044091373e-12,  -3.411640941041811e-12,
   1.213488591911149e-13,  -3.921779821345846e-16,   1.305240394587454e+00,  -1.627337710443335e-02,   1.596946580783979e-04,   1.031789545137706e-06,  -1.309219984831573e-07,
   3.773315770015396e-09,  -9.053474518335560e-12,  -3.413803849665536e-12,   1.201700386515327e-13,  -3.445745712519414e-16,   1.305279634804571e+00,  -1.627258359743112e-02,
   1.594998193064539e-04,   1.041034418246839e-06,  -1.309488276065007e-07,   3.755521394992191e-09,  -8.237176285248981e-12,  -3.415955170868129e-12,   1.189194432813660e-13,
  -2.943929816722665e-16,   1.305310505730510e+00,  -1.627195750988364e-02,   1.593464723005148e-04,   1.048299837172970e-06,  -1.309692369006963e-07,   3.741514870076891e-09,
  -7.596779125651309e-12,  -3.417544621070144e-12,   1.179354000481650e-13,  -2.551380463453308e-16,   1.305328317403417e+00,  -1.627159554427662e-02,   1.592579696526467e-04,
   1.052488705523477e-06,  -1.309807332096711e-07,   3.733430557435413e-09,  -7.228008574434610e-12,  -3.418420502471838e-12,   1.173675687516536e-13,  -2.325786902262159e-16,
   1.305335005005200e+00,  -1.627145950201244e-02,   1.592247354512395e-04,   1.054060883387330e-06,  -1.309849968853618e-07,   3.730394656403938e-09,  -7.089685630174786e-12,
  -3.418741590688763e-12,   1.171543581987119e-13,  -2.241254581579060e-16,   1.305336113525630e+00,  -1.627143694470011e-02,   1.592192263763861e-04,   1.054321453019409e-06,
  -1.309857008399975e-07,   3.729891403939081e-09,  -7.066764749560830e-12,  -3.418794403804227e-12,   1.171190163468048e-13,  -2.227251649447581e-16,   3.253485094177739e-03,
  -3.949428324284615e-05,   4.624849162763947e-07,  -4.414140530360687e-09,   4.521324808138329e-12,   1.024624861357819e-12,  -1.064166772475424e-14,  -7.930083997848565e-16,
   3.250308005125875e-17,  -1.426348270167851e-19,   3.253550916700194e-03,  -3.949616266031822e-05,   4.624886572704300e-07,  -4.412702503329448e-09,   4.500100503755954e-12,
   1.022246324359241e-12,  -1.051568121889856e-14,  -7.935717155570668e-16,   3.233302717850471e-17,  -1.363499589030746e-19,   3.253658975393014e-03,  -3.949924758933884e-05,
   4.624947860909333e-07,  -4.410344199074534e-09,   4.465449876506195e-12,   1.018340461970746e-12,  -1.030934273916403e-14,  -7.944736117958928e-16,   3.205402864424496e-17,
  -1.260845842406054e-19,   3.253773634519685e-03,  -3.950252034134785e-05,   4.625012721469257e-07,  -4.407845186107754e-09,   4.428944098274226e-12,   1.014194559738096e-12,
  -1.009106564693106e-14,  -7.953996062971667e-16,   3.175822570061790e-17,  -1.152631339874933e-19,   3.253863872217939e-03,  -3.950509558310577e-05,   4.625063643794639e-07,
  -4.405880861308828e-09,   4.400402661840206e-12,   1.010930662084694e-12,  -9.919760945138614e-15,  -7.961060162430446e-16,   3.152560124464648e-17,  -1.067978456355369e-19,
   3.253915950303531e-03,  -3.950658163271464e-05,   4.625092982815378e-07,  -4.404748177863710e-09,   4.384006415602610e-12,   1.009046588609444e-12,  -9.821090192174133e-15,
  -7.965047664784446e-16,   3.139141989116043e-17,  -1.019328766547218e-19,   3.253935506169993e-03,  -3.950713962647796e-05,   4.625103990620603e-07,  -4.404323026720467e-09,
   4.377863733831897e-12,   1.008339022794611e-12,  -9.784074726407070e-15,  -7.966528160162400e-16,   3.134104695513217e-17,  -1.001099064065682e-19,   3.253938747836225e-03,
  -3.950723212020953e-05,   4.625105814832338e-07,  -4.404252561474441e-09,   4.376846248991317e-12,   1.008221729564921e-12,  -9.777940802278638e-15,  -7.966772685266904e-16,
   3.133269763489150e-17,  -9.980792727939918e-20,   2.942352213760668e-02,  -3.571530743972525e-04,   4.179924453711407e-06,  -3.972429394786590e-08,   3.134126930796524e-11,
   9.565153349546669e-12,  -1.006593996075001e-13,  -7.249222895789630e-15,   2.994639513763854e-16,  -1.361547961196692e-18,   2.942411702308389e-02,  -3.571699861698250e-04,
   4.179950081554556e-06,  -3.971086571859050e-08,   3.114014406036857e-11,   9.543405775150577e-12,  -9.949852464612704e-14,  -7.254648232336562e-15,   2.979025928957122e-16,
  -1.303362788102144e-18,   2.942509362636040e-02,  -3.571977454818979e-04,   4.179992034030465e-06,  -3.968884350836797e-08,   3.081173825523728e-11,   9.507692891541121e-12,
  -9.759724855121475e-14,  -7.263342978292072e-15,   2.953408622718780e-16,  -1.208323492427335e-18,   2.942612988129750e-02,  -3.572271946896510e-04,   4.180036386657515e-06,
  -3.966550669211108e-08,   3.046568131897175e-11,   9.469784439904096e-12,  -9.558594480155996e-14,  -7.272281865027049e-15,   2.926247328290374e-16,  -1.108132283381093e-18,
   2.942694542182263e-02,  -3.572503673426579e-04,   4.180071175442087e-06,  -3.964716254662556e-08,   3.019507245175484e-11,   9.439940114345326e-12,  -9.400745070360755e-14,
  -7.279109848211806e-15,   2.904886485126696e-16,  -1.029753150067159e-18,   2.942741608718552e-02,  -3.572637391201012e-04,   4.180091205997307e-06,  -3.963658462230312e-08,
   3.003959518502037e-11,   9.422712355766528e-12,  -9.309823899471566e-14,  -7.282967699029149e-15,   2.892564927788882e-16,  -9.847079085790495e-19,   2.942759282689431e-02,
  -3.572687600506034e-04,   4.180098718855234e-06,  -3.963261417769251e-08,   2.998134343595813e-11,   9.416242409881595e-12,  -9.275715506785447e-14,  -7.284400756849299e-15,
   2.887939244142247e-16,  -9.678286432017473e-19,   2.942762212404059e-02,  -3.572695923256209e-04,   4.180099963754400e-06,  -3.963195610783131e-08,   2.997169430967720e-11,
   9.415169884296338e-12,  -9.270063314869247e-14,  -7.284637484268376e-15,   2.887172533583676e-16,  -9.650325443851071e-19,   8.254792038301878e-02,  -1.001870500143604e-03,
   1.171108493202384e-05,  -1.102808960293441e-07,   3.091640694699796e-11,   2.862686622836454e-11,  -3.091979069989759e-13,  -2.079423353700612e-14,   8.733978737476785e-16,
  -4.266662307581231e-18,   8.254958700244841e-02,  -1.001917439532263e-03,   1.171110783734612e-05,  -1.102406850526342e-07,   3.029648233773984e-11,   2.856445639969640e-11,
  -3.058114604843699e-13,  -2.081152561938169e-14,   8.688788615135610e-16,  -4.095260451549258e-18,   8.255232302986237e-02,  -1.001994485853553e-03,   1.171114507023593e-05,
  -1.101747365237798e-07,   2.928395069853306e-11,   2.846196615559515e-11,  -3.002650528269096e-13,  -2.083928925931209e-14,   8.614640124950300e-16,  -3.815276893850341e-18,
   8.255522616897713e-02,  -1.002076221274272e-03,   1.171118407621110e-05,  -1.101048474407087e-07,   2.821659856747973e-11,   2.835317005091981e-11,  -2.943975369115510e-13,
  -2.086790324003855e-14,   8.536016153689811e-16,  -3.520093080526102e-18,   8.255751095656250e-02,  -1.002140535411067e-03,   1.171121441274044e-05,  -1.100499076612005e-07,
   2.738166247213131e-11,   2.826751418801769e-11,  -2.897925459452574e-13,  -2.088981273305164e-14,   8.474178136185165e-16,  -3.289155597749804e-18,   8.255882955289155e-02,
  -1.002177647522086e-03,   1.171123177613324e-05,  -1.100182262168794e-07,   2.690183625564434e-11,   2.821806757234366e-11,  -2.871400347124109e-13,  -2.090221339882411e-14,
   8.438506308421688e-16,  -3.156426992005306e-18,   8.255932469906367e-02,  -1.002191582575293e-03,   1.171123826901776e-05,  -1.100063343165050e-07,   2.672204042064048e-11,
   2.819949745262853e-11,  -2.861449577266202e-13,  -2.090682399138811e-14,   8.425114259330787e-16,  -3.106689936562117e-18,   8.255940677663640e-02,  -1.002193892461641e-03,
   1.171123934387046e-05,  -1.100043633168764e-07,   2.669225692005903e-11,   2.819641906215456e-11,  -2.859800605003597e-13,  -2.090758583953221e-14,   8.422894498645074e-16,
  -3.098450784431698e-18,   1.643325357282419e-01,  -1.994065030298448e-03,   2.326199474439856e-05,  -2.156796552369004e-07,  -1.283182693577439e-10,   6.300344847207079e-11,
  -7.072584959780952e-13,  -4.287767098682006e-14,   1.851333830388961e-15,  -1.010082127021543e-17,   1.643358458443858e-01,  -1.994156796002276e-03,   2.326187715072898e-05,
  -2.155910846240772e-07,  -1.297429715499812e-10,   6.287466039835160e-11,  -7.000776031173384e-13,  -4.291958276752621e-14,   1.841885417924981e-15,  -9.731696405796770e-18,
   1.643412799225596e-01,  -1.994307417186117e-03,   2.326168324932289e-05,  -2.154458143519473e-07,  -1.320708759904072e-10,   6.266314973894495e-11,  -6.883161798370787e-13,
  -4.298704321502484e-14,   1.826380619818597e-15,  -9.128672873098429e-18,   1.643470458815475e-01,  -1.994467201135506e-03,   2.326147635017931e-05,  -2.152918517914582e-07,
  -1.345260698373873e-10,   6.243860773266044e-11,  -6.758733224115911e-13,  -4.305680262388950e-14,   1.809937637315140e-15,  -8.492828566307441e-18,   1.643515837085504e-01,
  -1.994592925340177e-03,   2.326131268626558e-05,  -2.151708131149939e-07,  -1.364475556231691e-10,   6.226181152324331e-11,  -6.661074519538165e-13,  -4.311038963837313e-14,
   1.797003490914152e-15,  -7.995315046990805e-18,   1.643542025720191e-01,  -1.994665472579142e-03,   2.326121789958011e-05,  -2.151010117172641e-07,  -1.375521735661762e-10,
   6.215974712287269e-11,  -6.604820864580561e-13,  -4.314079057669316e-14,   1.789541637176888e-15,  -7.709351037490498e-18,   1.643551859803037e-01,  -1.994692712774994e-03,
   2.326118224340176e-05,  -2.150748105017694e-07,  -1.379661548339946e-10,   6.212141495372113e-11,  -6.583717296009005e-13,  -4.315210735128671e-14,   1.786740153723640e-15,
  -7.602187937737416e-18,   1.643553489942509e-01,  -1.994697228121148e-03,   2.326117632956772e-05,  -2.150704677977464e-07,  -1.380347352428539e-10,   6.211506053413788e-11,
  -6.580220145019065e-13,  -4.315397804622494e-14,   1.786275795187205e-15,  -7.584435681254260e-18,   2.777426475143826e-01,  -3.369146535504215e-03,   3.917970288066174e-05,
  -3.543374285227117e-07,  -7.219009214461627e-10,   1.226824270354842e-10,  -1.449967447561342e-12,  -7.623718486803723e-14,   3.436502162696538e-15,  -2.186980590233121e-17,
   2.777482218008223e-01,  -3.369297200396180e-03,   3.917906992671866e-05,  -3.541647795506046e-07,  -7.248381094124520e-10,   1.224531411828696e-10,  -1.436629593179437e-12,
  -7.633054054974664e-14,   3.419376763963541e-15,  -2.116873723446184e-17,   2.777573728267320e-01,  -3.369544488387848e-03,   3.917802906763248e-05,  -3.538815847344872e-07,
  -7.296395896098045e-10,   1.220765417415644e-10,  -1.414782630801240e-12,  -7.648124400833240e-14,   3.391268835088359e-15,  -2.002324702072388e-17,   2.777670826807956e-01,
  -3.369806808324243e-03,   3.917692224678895e-05,  -3.535814145526670e-07,  -7.347066622304244e-10,   1.216766859331257e-10,  -1.391668285232407e-12,  -7.663769055627891e-14,
   3.361453036871316e-15,  -1.881516138906764e-17,   2.777747243205191e-01,  -3.370013203586137e-03,   3.917604944868813e-05,  -3.533454118271823e-07,  -7.386744746522146e-10,
   1.213618152537371e-10,  -1.373525652733802e-12,  -7.675831724041778e-14,   3.337994657534808e-15,  -1.786971966799538e-17,   2.777791344335738e-01,  -3.370132297531428e-03,
   3.917554505042064e-05,  -3.532093033767759e-07,  -7.409563704294177e-10,   1.211800250216467e-10,  -1.363074614375624e-12,  -7.682693494609568e-14,   3.324459221461326e-15,
  -1.732622029742352e-17,   2.777807904698384e-01,  -3.370177014562666e-03,   3.917535551375806e-05,  -3.531582109449703e-07,  -7.418117329816354e-10,   1.211117474258330e-10,
  -1.359153817569183e-12,  -7.685251322305314e-14,   3.319377084576022e-15,  -1.712253387603241e-17,   2.777810649812874e-01,  -3.370184426843395e-03,   3.917532408848514e-05,
  -3.531497425739871e-07,  -7.419534418345100e-10,   1.211004287241149e-10,  -1.358504083083207e-12,  -7.685674326030937e-14,   3.318534677222941e-15,  -1.708879118959198e-17,
   4.277299243899519e-01,  -5.186009522510787e-03,   6.001201614728898e-05,  -5.210538702413278e-07,  -2.348571495028195e-09,   2.293700760120139e-10,  -2.897873814220184e-12,
  -1.259311174700046e-13,   6.075622267826675e-15,  -4.754902315975151e-17,   4.277384604405485e-01,  -5.186230830689169e-03,   6.000997750850936e-05,  -5.207306677893026e-07,
  -2.354477764283079e-09,   2.289904572175581e-10,  -2.874266489065636e-12,  -1.261406016224662e-13,   6.046634363691337e-15,  -4.626960815187988e-17,   4.277524735345698e-01,
  -5.186594044914234e-03,   6.000662719633572e-05,  -5.202004704335929e-07,  -2.364137759059827e-09,   2.283668210409179e-10,  -2.835594755570309e-12,  -1.264798369172179e-13,
   5.999040991482298e-15,  -4.417860149410348e-17,   4.277673422187032e-01,  -5.186979308843356e-03,   6.000306743442308e-05,  -5.196384227489527e-07,  -2.374338765046297e-09,
   2.277045152653830e-10,  -2.794674561386807e-12,  -1.268334681284839e-13,   5.948534824868916e-15,  -4.197259318905407e-17,   4.277790437399430e-01,  -5.187282416297473e-03,
   6.000026240148891e-05,  -5.191964741286718e-07,  -2.382331592106152e-09,   2.271828617922318e-10,  -2.762552336793433e-12,  -1.271072141488489e-13,   5.908782642955956e-15,
  -4.024564858577425e-17,   4.277857968319199e-01,  -5.187457306557909e-03,   5.999864216965175e-05,  -5.189415716691294e-07,  -2.386930229783638e-09,   2.268816402908207e-10,
  -2.744046916869401e-12,  -1.272633739144025e-13,   5.885839690167106e-15,  -3.925267848432510e-17,   4.277883326690857e-01,  -5.187522972224518e-03,   5.999803349366324e-05,
  -5.188458825136733e-07,  -2.388654386135260e-09,   2.267684975872748e-10,  -2.737104174526686e-12,  -1.273216692088939e-13,   5.877224186237586e-15,  -3.888050422238175e-17,
   4.277887530195479e-01,  -5.187533856860181e-03,   5.999793258304969e-05,  -5.188300222098709e-07,  -2.388940048515610e-09,   2.267497409315444e-10,  -2.735953644102913e-12,
  -1.273313143418701e-13,   5.875796033433167e-15,  -3.881884771454566e-17,   6.228992438931074e-01,  -7.546299305803030e-03,   8.661492591242768e-05,  -6.988738381559558e-07,
  -6.490960918093340e-09,   4.374914273650463e-10,  -6.041688297350956e-12,  -2.014021738238544e-13,   1.091201568193252e-14,  -1.129657913423222e-16,   6.229115585461910e-01,
  -7.546595490175137e-03,   8.660931367593261e-05,  -6.982564129831913e-07,  -6.503354231664316e-09,   4.368814475312635e-10,  -5.999195960501661e-12,  -2.019169714265168e-13,
   1.086447297522398e-14,  -1.105696447137914e-16,   6.229317744545366e-01,  -7.547081535464397e-03,   8.660009279199825e-05,  -6.972434403157831e-07,  -6.523634829218495e-09,
   4.358789962231442e-10,  -5.929575172832038e-12,  -2.027533411550557e-13,   1.078636426413562e-14,  -1.066517072432702e-16,   6.229532242966912e-01,  -7.547597009926823e-03,
   8.659029856445230e-05,  -6.961694557499434e-07,  -6.545065842539646e-09,   4.348138730314317e-10,  -5.855888772719143e-12,  -2.036289288125790e-13,   1.070340565447163e-14,
  -1.025158434022634e-16,   6.229701048563611e-01,  -7.548002504935011e-03,   8.658258311903185e-05,  -6.953248457244838e-07,  -6.561868345529446e-09,   4.339745774156674e-10,
  -5.798032386676390e-12,  -2.043094552196628e-13,   1.063806088185827e-14,  -9.927636869844712e-17,   6.229798467253175e-01,  -7.548236449462213e-03,   8.657812744924919e-05,
  -6.948376540286366e-07,  -6.571539847619003e-09,   4.334897900446895e-10,  -5.764696551070268e-12,  -2.046987750285790e-13,   1.060032720100634e-14,  -9.741300596494192e-17,
   6.229835048500981e-01,  -7.548324283867069e-03,   8.657645374679451e-05,  -6.946547558337797e-07,  -6.575166767015157e-09,   4.333076697331042e-10,  -5.752188863318622e-12,
  -2.048443220564577e-13,   1.058615373937655e-14,  -9.671446681248850e-17,   6.229841112343266e-01,  -7.548338842933611e-03,   8.657617627743836e-05,  -6.946244403268475e-07,
  -6.575767726324392e-09,   4.332774765862656e-10,  -5.750116075837969e-12,  -2.048684144814917e-13,   1.058380407088991e-14,  -9.659873578032182e-17,   8.800891636016732e-01,
  -1.064635362955485e-02,   1.203003966624105e-04,  -8.235037573347030e-07,  -1.787222020749703e-08,   9.269642817513507e-10,  -1.461534764795108e-11,  -3.163743306259132e-13,
   2.184707278154453e-14,  -3.382409262103717e-16,   8.801062521985649e-01,  -1.064670057175798e-02,   1.202849660589842e-04,  -8.221928378668920e-07,  -1.790240454927218e-08,
   9.259935247835358e-10,  -1.452982252256042e-11,  -3.179734831120570e-13,   2.177380440006402e-14,  -3.332387653798733e-16,   8.801343042826609e-01,  -1.064726973097740e-02,
   1.202596159184973e-04,  -8.200417602088287e-07,  -1.795182589659883e-08,   9.243965024273023e-10,  -1.438963206783758e-11,  -3.205804138692008e-13,   2.165319524200038e-14,
  -3.250514346204173e-16,   8.801640675184619e-01,  -1.064787310596518e-02,   1.202326926224453e-04,  -8.177606734661419e-07,  -1.800408772405381e-08,   9.226973828976566e-10,
  -1.424116898561743e-11,  -3.233216977197412e-13,   2.152477907405929e-14,  -3.163974476626580e-16,   8.801874897525344e-01,  -1.064834756939293e-02,   1.202114858983138e-04,
  -8.159664416853943e-07,  -1.804508929242188e-08,   9.213568856157681e-10,  -1.412453799396164e-11,  -3.254611345667765e-13,   2.142339923673945e-14,  -3.096109548847338e-16,
   8.802010065446666e-01,  -1.064862123288021e-02,   1.201992398997874e-04,  -8.149313549507294e-07,  -1.806870053112140e-08,   9.205819486881889e-10,  -1.405731236872018e-11,
  -3.266886559703753e-13,   2.136476551610048e-14,  -3.057040719165355e-16,   8.802060821140626e-01,  -1.064872396626269e-02,   1.201946400491932e-04,  -8.145427451574471e-07,
  -1.807755704471947e-08,   9.202907052748111e-10,  -1.403208444578304e-11,  -3.271482451353938e-13,   2.134272439207229e-14,  -3.042388405946854e-16,   8.802069234559851e-01,
  -1.064874099420998e-02,   1.201938774865941e-04,  -8.144783315096859e-07,  -1.807902462485702e-08,   9.202424145017855e-10,  -1.402790339919365e-11,  -3.272243570506648e-13,
   2.133906951953775e-14,  -3.039960547595937e-16,   1.242676829540927e+00,  -1.497584393970897e-02,   1.620328166216979e-04,  -5.066515061681174e-07,  -6.294399019035563e-08,
   2.811797732621456e-09,  -5.769760376543207e-11,  -2.996153911691671e-13,   6.340740270059475e-14,  -2.005175586270578e-15,   1.242699778545332e+00,  -1.497604613772345e-02,
   1.619783930716916e-04,  -5.026591562130169e-07,  -6.306413362413594e-08,   2.810743542316984e-09,  -5.744364852747813e-11,  -3.095906191042647e-13,   6.347248780365948e-14,
  -1.994137797135666e-15,   1.242737447345362e+00,  -1.497637684877205e-02,   1.618889748189696e-04,  -4.961062175619299e-07,  -6.326097604008460e-08,   2.808991566311973e-09,
  -5.702656667708890e-11,  -3.259253859275313e-13,   6.357685486806937e-14,  -1.975975773697536e-15,   1.242777409096444e+00,  -1.497672608767797e-02,   1.617939958066351e-04,
  -4.891546179676493e-07,  -6.346930751333196e-08,   2.807103614215782e-09,  -5.658377906839433e-11,  -3.432017809821743e-13,   6.368423155282715e-14,  -1.956648374835196e-15,
   1.242808853585111e+00,  -1.497699973079350e-02,   1.617191750078482e-04,  -4.836848221140755e-07,  -6.363287907053227e-08,   2.805596849375756e-09,  -5.623513831900696e-11,
  -3.567577452381284e-13,   6.376630653228863e-14,  -1.941397466783072e-15,   1.242826998560837e+00,  -1.497715717071847e-02,   1.616759657084004e-04,  -4.805285598504238e-07,
  -6.372712448897292e-08,   2.804718886196466e-09,  -5.603386596118951e-11,  -3.645648420537783e-13,   6.381270084494062e-14,  -1.932579931132733e-15,   1.242833811753586e+00,
  -1.497721619933735e-02,   1.616597347561952e-04,  -4.793434400301795e-07,  -6.376248529408044e-08,   2.804387619950495e-09,  -5.595827403016826e-11,  -3.674933983132115e-13,
   6.382993871316430e-14,  -1.929265864508097e-15,   1.242834941115327e+00,  -1.497722597934167e-02,   1.616570439571529e-04,  -4.791469941101627e-07,  -6.376834530857082e-08,
   2.804332624389917e-09,  -5.594574294705913e-11,  -3.679786855593387e-13,   6.383278645281186e-14,  -1.928716353009388e-15,   3.102575885217918e-03,  -3.600361486983322e-05,
   4.105647903565266e-07,  -4.197289740390604e-09,   2.122752970504274e-11,   6.099769344513809e-13,  -2.011319246169069e-14,   2.893318736470258e-17,   1.656539949215260e-17,
  -5.451618568587932e-19,   3.102634347569082e-03,  -3.600540371743448e-05,   4.105826769605354e-07,  -4.196421372380253e-09,   2.118538369005936e-11,   6.100201967401082e-13,
  -2.004690402695814e-14,   2.621961219741487e-17,   1.657951871707834e-17,  -5.422119107690092e-19,   3.102730324784822e-03,  -3.600834013236262e-05,   4.106120149573205e-07,
  -4.194995779117705e-09,   2.111629660050650e-11,   6.100854092145211e-13,  -1.993804341226706e-14,   2.177579806406826e-17,   1.660213176854100e-17,  -5.373643464167218e-19,
   3.102832166480382e-03,  -3.601145553144066e-05,   4.106431098662455e-07,  -4.193483081531562e-09,   2.104312907901413e-11,   6.101467219988256e-13,  -1.982248391660069e-14,
   1.707547072180547e-17,   1.662535870639595e-17,  -5.322143660810594e-19,   3.102912318204099e-03,  -3.601390710326334e-05,   4.106675564287387e-07,  -4.192292559273850e-09,
   2.098564667728221e-11,   6.101892784222539e-13,  -1.973150250335267e-14,   1.338708560949628e-17,   1.664308441037431e-17,  -5.281568053810255e-19,   3.102958576041997e-03,
  -3.601532184762890e-05,   4.106816548877908e-07,  -4.191605477896326e-09,   2.095251288119108e-11,   6.102115582699992e-13,  -1.967898135629957e-14,   1.126277679527877e-17,
   1.665309267615117e-17,  -5.258133342230797e-19,   3.102975946454422e-03,  -3.601585307823313e-05,   4.106869470857138e-07,  -4.191347470650712e-09,   2.094007845233753e-11,
   6.102194939755651e-13,  -1.965925652545363e-14,   1.046589646617718e-17,   1.665680905643671e-17,  -5.249330058409671e-19,   3.102978825856002e-03,  -3.601594113625603e-05,
   4.106878242423436e-07,  -4.191304702187588e-09,   2.093801767089273e-11,   6.102207867261286e-13,  -1.965598671496390e-14,   1.033384534481121e-17,   1.665742289474716e-17,
  -5.247870614010310e-19,   2.805879938642479e-02,  -3.255985009890553e-04,   3.711985482756645e-06,  -3.787431079095801e-08,   1.872563515468919e-10,   5.700021062611702e-12,
  -1.865210109854864e-13,   3.050972588590127e-16,   1.517397012858963e-16,  -5.025335976107666e-18,   2.805932794627316e-02,  -3.256146416951938e-04,   3.712143159156976e-06,
  -3.786619526914004e-08,   1.868654199988310e-10,   5.700534497023337e-12,  -1.859136765355541e-13,   2.800786333399232e-16,   1.518753306141570e-16,  -4.998320766667235e-18,
   2.806019567869905e-02,  -3.256411367724114e-04,   3.712401771531288e-06,  -3.785287196323861e-08,   1.862245809879219e-10,   5.701323816462729e-12,  -1.849162780795034e-13,
   2.391068846841496e-16,   1.520927611537077e-16,  -4.953925282649849e-18,   2.806111643145793e-02,  -3.256692466938552e-04,   3.712675854806526e-06,  -3.783873444197777e-08,
   1.855458769100119e-10,   5.702088663528045e-12,  -1.838574792614055e-13,   1.957691977842006e-16,   1.523163853042552e-16,  -4.906757282883762e-18,   2.806184108433980e-02,
  -3.256913668857221e-04,   3.712891325129814e-06,  -3.782760782604891e-08,   1.850126570560898e-10,   5.702638072186277e-12,  -1.830238565033621e-13,   1.617611121836895e-16,
   1.524872615875323e-16,  -4.869592525762323e-18,   2.806225930194703e-02,  -3.257041318932945e-04,   3.713015583287876e-06,  -3.782118632092891e-08,   1.847052958373915e-10,
   5.702934120888006e-12,  -1.825426213225321e-13,   1.421740478873567e-16,   1.525838309565120e-16,  -4.848126940469946e-18,   2.806241634799988e-02,  -3.257089250938860e-04,
   3.713062225708640e-06,  -3.781877496061432e-08,   1.845899486587134e-10,   5.703041319701361e-12,  -1.823618874266226e-13,   1.348264105518238e-16,   1.526197074092161e-16,
  -4.840063204882219e-18,   2.806244238069344e-02,  -3.257097196256443e-04,   3.713069956421190e-06,  -3.781837524202596e-08,   1.845708319066213e-10,   5.703058880071464e-12,
  -1.823319268678260e-13,   1.336088302172735e-16,   1.526256340785509e-16,  -4.838726357545323e-18,   7.871949939696757e-02,  -9.134267642881202e-04,   1.040785861607247e-05,
  -1.057536182887381e-07,   4.972497262297099e-10,   1.708832069782638e-11,  -5.510716798848508e-13,   1.123187512558582e-15,   4.370947032462712e-16,  -1.467078638486421e-17,
   7.872098135225646e-02,  -9.134718268612477e-04,   1.040827665327453e-05,  -1.057292828928739e-07,   4.960942059128847e-10,   1.709051387618864e-11,  -5.493214103674000e-13,
   1.050119440340283e-15,   4.375246082259109e-16,  -1.459303215703098e-17,   7.872341426373451e-02,  -9.135457968575583e-04,   1.040896222251878e-05,  -1.056893306272704e-07,
   4.941999370722256e-10,   1.709395787113446e-11,  -5.464469093346191e-13,   9.304553685556889e-16,   4.382150480071835e-16,  -1.446524125858975e-17,   7.872599582794275e-02,
  -9.136242745334507e-04,   1.040968870522843e-05,  -1.056469358609532e-07,   4.921936483534232e-10,   1.709739991371923e-11,  -5.433953021950405e-13,   8.038755876521754e-16,
   4.389268883436796e-16,  -1.432945167611141e-17,   7.872802757385108e-02,  -9.136860294864228e-04,   1.041025975713953e-05,  -1.056135693426552e-07,   4.906173514970357e-10,
   1.709995537642340e-11,  -5.409925756492752e-13,   7.045414300650151e-16,   4.394721119065078e-16,  -1.422244689630637e-17,   7.872920015069422e-02,  -9.137216665149199e-04,
   1.041058904449222e-05,  -1.055943122479356e-07,   4.897087074152099e-10,   1.710136876525184e-11,  -5.396054821671577e-13,   6.473279761186280e-16,   4.397807718733625e-16,
  -1.416063797700984e-17,   7.872964046808574e-02,  -9.137350480135550e-04,   1.041071264267512e-05,  -1.055870809020199e-07,   4.893677043528687e-10,   1.710188790862245e-11,
  -5.390845336654436e-13,   6.258653544141527e-16,   4.398955443878247e-16,  -1.413741793378953e-17,   7.872971345716093e-02,  -9.137372661589542e-04,   1.041073312807457e-05,
  -1.055858821969065e-07,   4.893111888621255e-10,   1.710197335246898e-11,  -5.389981747338104e-13,   6.223087573115006e-16,   4.399145098748549e-16,  -1.413356834461011e-17,
   1.567121433880900e-01,  -1.818268387345116e-03,   2.069927384993496e-05,  -2.088696938556593e-07,   8.967833595781526e-10,   3.767583771938609e-11,  -1.190655328958009e-12,
   3.173773755867413e-15,   9.073233959800347e-16,  -3.113835738309833e-17,   1.567150905579835e-01,  -1.818357368791553e-03,   2.070002542950838e-05,  -2.088160214015059e-07,
   8.942849957950285e-10,   3.768285116012742e-11,  -1.187019221567065e-12,   3.018582040762731e-15,   9.083558788472504e-16,  -3.097733707448232e-17,   1.567199288895355e-01,
  -1.818503429667297e-03,   2.070125774096433e-05,  -2.087279031895317e-07,   8.901891478624636e-10,   3.769403247223077e-11,  -1.181047176663052e-12,   2.764408560335835e-15,
   9.100181616626834e-16,  -3.071264840502415e-17,   1.567250628353972e-01,  -1.818658389025813e-03,   2.070256324382223e-05,  -2.086343947264031e-07,   8.858507776867861e-10,
   3.770544567947893e-11,  -1.174706640196479e-12,   2.495525399325736e-15,   9.117376261354928e-16,  -3.043132740507579e-17,   1.567291033516602e-01,  -1.818780326550126e-03,
   2.070358918068831e-05,  -2.085607972619690e-07,   8.824419916260921e-10,   3.771410193533788e-11,  -1.169713940532353e-12,   2.284503219028015e-15,   9.130588266789154e-16,
  -3.020959432168752e-17,   1.567314352422041e-01,  -1.818850692543751e-03,   2.070418066783607e-05,  -2.085183204441316e-07,   8.804769334287927e-10,   3.771896713782724e-11,
  -1.166831501243824e-12,   2.162954977465292e-15,   9.138085059374403e-16,  -3.008149649776223e-17,   1.567323108958834e-01,  -1.818877114438663e-03,   2.070440266359017e-05,
  -2.085023695510467e-07,   8.797394539968610e-10,   3.772076942732166e-11,  -1.165748918856508e-12,   2.117357179215609e-15,   9.140875996343287e-16,  -3.003336987691060e-17,
   1.567324560483096e-01,  -1.818881494180768e-03,   2.070443945657510e-05,  -2.084997254398873e-07,   8.796172283550021e-10,   3.772106688314066e-11,  -1.165569454935012e-12,
   2.109801054058892e-15,   9.141337359097363e-16,  -3.002539090718753e-17,   2.648659567740128e-01,  -3.072742018420318e-03,   3.493172011570170e-05,  -3.486666230003388e-07,
   1.269926994946422e-09,   7.342222630869250e-11,  -2.265871686215509e-12,   8.063555941196834e-15,   1.629011700555377e-15,  -5.787801594897029e-17,   2.648709299403295e-01,
  -3.072890502154222e-03,   3.493277751050217e-05,  -3.485619773323337e-07,   1.265167955269832e-09,   7.344172476530247e-11,  -2.259334868401329e-12,   7.774776441020082e-15,
   1.631279253384091e-15,  -5.759071115952436e-17,   2.648790943024141e-01,  -3.073134229915659e-03,   3.493451048298848e-05,  -3.483901663784314e-07,   1.257365330272031e-09,
   7.347311592568005e-11,  -2.248597444520355e-12,   7.301767722772786e-15,   1.634940551287998e-15,  -5.711829023880871e-17,   2.648877574637852e-01,  -3.073392799982644e-03,
   3.493634534623059e-05,  -3.482078373506503e-07,   1.249099885858150e-09,   7.350558476300045e-11,  -2.237195905660871e-12,   6.801324043740672e-15,   1.638742398450985e-15,
  -5.661599010799459e-17,   2.648945755201420e-01,  -3.073596264179331e-03,   3.493778653276898e-05,  -3.480643261062431e-07,   1.242604892429820e-09,   7.353053100746474e-11,
  -2.228216899095535e-12,   6.408526956831555e-15,   1.641674467183615e-15,  -5.621994514807108e-17,   2.648985103949698e-01,  -3.073713674596318e-03,   3.493861712396883e-05,
  -3.479814960989163e-07,   1.238860496350670e-09,   7.354468502621312e-11,  -2.223032584368467e-12,   6.182259240437851e-15,   1.643342615268456e-15,  -5.599108968230228e-17,
   2.648999879873745e-01,  -3.073757760965544e-03,   3.493892880277378e-05,  -3.479503913211776e-07,   1.237455193000367e-09,   7.354995412075000e-11,  -2.221085380569509e-12,
   6.097373490204150e-15,   1.643964489639144e-15,  -5.590509772470078e-17,   2.649002329198758e-01,  -3.073765068785152e-03,   3.493898045658088e-05,  -3.479452351914402e-07,
   1.237222283667642e-09,   7.355082512915935e-11,  -2.220762580418957e-12,   6.083306684955317e-15,   1.644067335279881e-15,  -5.589084046368891e-17,   4.079059998807000e-01,
  -4.731243145517163e-03,   5.367066274307234e-05,  -5.265438968113836e-07,   1.361159867458689e-09,   1.369994693644955e-10,  -4.127448818079176e-12,   1.982477314371460e-14,
   2.728676063223447e-15,  -1.023844217763375e-16,   4.079136398478578e-01,  -4.731467248358651e-03,   5.367177584763097e-05,  -5.263485125337923e-07,   1.352479870831140e-09,
   1.370505624819560e-10,  -4.116474946455272e-12,   1.931300625620428e-14,   2.733655280792215e-15,  -1.019109416979551e-16,   4.079261821974393e-01,  -4.731835089067877e-03,
   5.367359787373864e-05,  -5.260277084393794e-07,   1.338247234870018e-09,   1.371333430287510e-10,  -4.098445846331796e-12,   1.847462386351599e-14,   2.741720194534546e-15,
  -1.011319744668182e-16,   4.079394907449484e-01,  -4.732225314430638e-03,   5.367552396626011e-05,  -5.256872442726092e-07,   1.323168400998199e-09,   1.372196906716260e-10,
  -4.079297111198210e-12,   1.758743848978121e-14,   2.750129462391917e-15,  -1.003031791424718e-16,   4.079499647467066e-01,  -4.732532364422961e-03,   5.367703458969498e-05,
  -5.254192497153893e-07,   1.311318008140369e-09,   1.372865703572424e-10,  -4.064213720561639e-12,   1.689096145318766e-14,   2.756640505846017e-15,  -9.964930114615882e-17,
   4.079560095399238e-01,  -4.732709545157890e-03,   5.367790430847390e-05,  -5.252645659466856e-07,   1.304485623221183e-09,   1.373247370164659e-10,  -4.055503539752987e-12,
   1.648971026346493e-14,   2.760355302527115e-15,  -9.927129522070714e-17,   4.079582794278133e-01,  -4.732776073783307e-03,   5.367823050137758e-05,  -5.252064771057643e-07,
   1.301921263064099e-09,   1.373389875939340e-10,  -4.052231791107963e-12,   1.633916873150587e-14,   2.761742154742417e-15,  -9.912922994504654e-17,   4.079586556946397e-01,
  -4.732787101617718e-03,   5.367828455167902e-05,  -5.251968478622188e-07,   1.301496250580214e-09,   1.373413455394168e-10,  -4.051689399886019e-12,   1.631422129853866e-14,
   2.761971618736607e-15,  -9.910567426332200e-17,   5.940450823747442e-01,  -6.888084432010907e-03,   7.786486655920308e-05,  -7.418792622942749e-07,   5.347550550486013e-10,
   2.591284287562983e-10,  -7.662108756157657e-12,   5.053462771030081e-14,   4.456369271794480e-15,  -1.833822100557321e-16,   5.940561638501869e-01,  -6.888399849591813e-03,
   7.786523180964738e-05,  -7.415093654990860e-07,   5.186135754771670e-10,   2.592647944498167e-10,  -7.644110597028939e-12,   4.961504590116589e-14,   4.468183261114141e-15,
  -1.826448723345807e-16,   5.940743559090904e-01,  -6.888917544215031e-03,   7.786582153405221e-05,  -7.409019858462912e-07,   4.921426183767136e-10,   2.594866875516463e-10,
  -7.614530808536535e-12,   4.810816335176737e-14,   4.487381274463459e-15,  -1.814304782660474e-16,   5.940936591211265e-01,  -6.889466702746197e-03,   7.786643384085131e-05,
  -7.402573278081494e-07,   4.640928243366861e-10,   2.597194547562286e-10,  -7.583099965723339e-12,   4.651300314478274e-14,   4.507485120185095e-15,  -1.801366056071340e-16,
   5.941088508728397e-01,  -6.889898780811211e-03,   7.786690600866446e-05,  -7.397498481585886e-07,   4.420449779014735e-10,   2.599007070326310e-10,  -7.558331822428837e-12,
   4.526033114742820e-14,   4.523114159004589e-15,  -1.791145110969751e-16,   5.941176183386624e-01,  -6.890148096376664e-03,   7.786717461179565e-05,  -7.394569197498371e-07,
   4.293317604385586e-10,   2.600045357793536e-10,  -7.544024933391789e-12,   4.453848494630491e-14,   4.532056809669830e-15,  -1.785231237693889e-16,   5.941209106109165e-01,
  -6.890241708319055e-03,   7.786727473920013e-05,  -7.393469124288148e-07,   4.245599056868508e-10,   2.600433780329489e-10,  -7.538650161613695e-12,   4.426763178080130e-14,
   4.535400290246785e-15,  -1.783007665561018e-16,   5.941214563522544e-01,  -6.890257225388351e-03,   7.786729129794408e-05,  -7.393286766250618e-07,   4.237690124623757e-10,
   2.600498089678268e-10,  -7.537759090265328e-12,   4.422274493140281e-14,   4.535953751498643e-15,  -1.782638926403543e-16,   8.393607958519662e-01,  -9.727064460461267e-03,
   1.092475162267661e-04,  -9.819577954773731e-07,  -3.204619807992596e-09,   5.358441296844878e-10,  -1.583943870170059e-11,   1.502114138713967e-13,   7.271803766056561e-15,
  -3.612556663364663e-16,   8.393763366893936e-01,  -9.727480972775425e-03,   1.092445905956187e-04,  -9.811917319988617e-07,  -3.238077266612868e-09,   5.362639356462435e-10,
  -1.580975816759097e-11,   1.483873755240206e-13,   7.306147255917402e-15,  -3.602717678789265e-16,   8.394018491587329e-01,  -9.728164507972896e-03,   1.092397671633714e-04,
  -9.799336950673483e-07,  -3.292956937408243e-09,   5.369491927818925e-10,  -1.576093601532662e-11,   1.453966475526786e-13,   7.362151522002101e-15,  -3.586455170245040e-16,
   8.394289194103860e-01,  -9.728889469240266e-03,   1.092346212355535e-04,  -9.785982523738997e-07,  -3.351125690767879e-09,   5.376709773149651e-10,  -1.570900103762907e-11,
   1.422283403010761e-13,   7.421065543508448e-15,  -3.569050334829940e-16,   8.394502235139162e-01,  -9.729459784083516e-03,   1.092305511800932e-04,  -9.775468422371756e-07,
  -3.396859259677388e-09,   5.382351727107617e-10,  -1.566803362741400e-11,   1.397385657295091e-13,   7.467061616850567e-15,  -3.555245302144027e-16,   8.394625183973766e-01,
  -9.729788830322475e-03,   1.092281941851402e-04,  -9.769398892208737e-07,  -3.423234718943670e-09,   5.385592376677023e-10,  -1.564435288311552e-11,   1.383031569041881e-13,
   7.493458803018028e-15,  -3.547235315123274e-16,   8.394671352235280e-01,  -9.729912372762009e-03,   1.092273075821769e-04,  -9.767119414607958e-07,  -3.433135509049269e-09,
   5.386806357322300e-10,  -1.563545343000758e-11,   1.377644286822693e-13,   7.503343237881134e-15,  -3.544219412471034e-16,   8.394679005272351e-01,  -9.729932850756169e-03,
   1.092271605344523e-04,  -9.766741542300513e-07,  -3.434776524288339e-09,   5.387007438219575e-10,  -1.563397784425639e-11,   1.376751416648718e-13,   7.504980249126534e-15,
  -3.543719058117368e-16,   1.185308321319031e+00,  -1.371723654295113e-02,   1.515228251617593e-04,  -1.138633803322471e-06,  -2.031293454711780e-08,   1.494667095859993e-09,
  -4.734791272847425e-11,   7.497455402914576e-13,   8.755786522762288e-15,  -9.422923773097876e-16,   1.185329848095721e+00,  -1.371771506843002e-02,   1.515049113045847e-04,
  -1.136488595665243e-06,  -2.041354082744683e-08,   1.496829607463136e-09,  -4.730937140046513e-11,   7.448665728377902e-13,   8.932357109315283e-15,  -9.442511496409820e-16,
   1.185365185850706e+00,  -1.371849997929657e-02,   1.514754408694447e-04,  -1.132964698285742e-06,  -2.057864092096168e-08,   1.500369149035680e-09,  -4.724559428601212e-11,
   7.368500149150797e-13,   9.221663038163148e-15,  -9.474257258755314e-16,   1.185402679309679e+00,  -1.371933192467236e-02,   1.514440863004504e-04,  -1.129222597900282e-06,
  -2.075374101002798e-08,   1.504110501029785e-09,  -4.717723601008685e-11,   7.283344743664049e-13,   9.527870509469087e-15,  -9.507383986808645e-16,   1.185432184951844e+00,
  -1.371998601400576e-02,   1.514193491728978e-04,  -1.126275397462401e-06,  -2.089148464154105e-08,   1.507044550428948e-09,  -4.712294183783404e-11,   7.216259928983225e-13,
   9.768298685752111e-15,  -9.533051015279015e-16,   1.185449212469564e+00,  -1.372036323867985e-02,   1.514050484799032e-04,  -1.124573651074140e-06,  -2.097095459949938e-08,
   1.508733671105484e-09,  -4.709140908204624e-11,   7.177517304079331e-13,   9.906829769095503e-15,  -9.547702102278127e-16,   1.185455606327024e+00,  -1.372050484056184e-02,
   1.513996738138403e-04,  -1.123934466135009e-06,  -2.100079169899834e-08,   1.509367163051442e-09,  -4.707953072285847e-11,   7.162964048591636e-13,   9.958807004115725e-15,
  -9.553173143156456e-16,   1.185456666192779e+00,  -1.372052831047666e-02,   1.513987826426348e-04,  -1.123828503527373e-06,  -2.100573737916931e-08,   1.509472131744914e-09,
  -4.707755973740791e-11,   7.160551374267227e-13,   9.967420727156304e-15,  -9.554078432957136e-16,   2.964820633457628e-03,  -3.291403082508401e-05,   3.625556483333640e-07,
  -3.785146899466213e-09,   2.890301390225490e-11,   1.801365005934522e-13,  -1.454099373632062e-14,   2.886828966580931e-16,   1.391219533057820e-18,  -2.670342479465031e-19,
   2.964872277062130e-03,  -3.291564585566872e-05,   3.625801516289695e-07,  -3.784883474427819e-09,   2.887205397151060e-11,   1.809771664391619e-13,  -1.453443051985877e-14,
   2.873043676440296e-16,   1.440530410444502e-18,  -2.674351472280410e-19,   2.964957060891784e-03,  -3.291829710689947e-05,   3.626203586748721e-07,  -3.784450164091333e-09,
   2.882123890018321e-11,   1.823542712728378e-13,  -1.452351494627734e-14,   2.850398840196947e-16,   1.521303927500695e-18,  -2.680827674910486e-19,   2.965047026477801e-03,
  -3.292111017663145e-05,   3.626629955314350e-07,  -3.783989227318591e-09,   2.876733479612754e-11,   1.838114285375199e-13,  -1.451174134292819e-14,   2.826352034748267e-16,
   1.606768069750909e-18,  -2.687556614305133e-19,   2.965117832320441e-03,  -3.292332399556132e-05,   3.626965321930142e-07,  -3.783625628373819e-09,   2.872492265708790e-11,
   1.849552800396671e-13,  -1.450233714552831e-14,   2.807413567205873e-16,   1.673852596910695e-18,  -2.692749062762246e-19,   2.965158696740095e-03,  -3.292460160095737e-05,
   3.627158793338202e-07,  -3.783415452323251e-09,   2.870045009165473e-11,   1.856142406335395e-13,  -1.449685443143447e-14,   2.796478448677261e-16,   1.712497625732739e-18,
  -2.695704379275757e-19,   2.965174041921849e-03,  -3.292508134828441e-05,   3.627231429558893e-07,  -3.783336465672721e-09,   2.869126121813956e-11,   1.858614640965153e-13,
  -1.449478516142414e-14,   2.792371196649976e-16,   1.726995827479630e-18,  -2.696806320442687e-19,   2.965176585615174e-03,  -3.292516087294349e-05,   3.627243469302195e-07,
  -3.783323369158607e-09,   2.868973807407733e-11,   1.859024331697169e-13,  -1.449444159889563e-14,   2.791690307909952e-16,   1.729398405130889e-18,  -2.696988571107544e-19,
   2.681300009830958e-02,  -2.976625190614674e-04,   3.278471777200235e-06,  -3.419867419442075e-08,   2.593556369183873e-10,   1.720542409764570e-12,  -1.344763505596057e-13,
   2.673341666429482e-15,   1.223692649602681e-17,  -2.446750721419752e-18,   2.681346709096548e-02,  -2.976771103344974e-04,   3.278691604436649e-06,  -3.419616017489018e-08,
   2.590692866423668e-10,   1.728329478317941e-12,  -1.344181916204380e-13,   2.660707554791486e-15,   1.269143474515624e-17,  -2.450539358325464e-18,   2.681423375736283e-02,
  -2.977010634803544e-04,   3.279052309945091e-06,  -3.419202507955503e-08,   2.585992910247148e-10,   1.741085859615768e-12,  -1.343214146675334e-13,   2.639953317422250e-15,
   1.343595691140346e-17,  -2.456662153810848e-18,   2.681504728006653e-02,  -2.977264785441183e-04,   3.279434806555501e-06,  -3.418762666795938e-08,   2.581007191529096e-10,
   1.754584177166989e-12,  -1.342169631033521e-13,   2.617913590082866e-15,   1.422373681804677e-17,  -2.463027421805057e-18,   2.681568754871420e-02,  -2.977464795533081e-04,
   3.279735659794147e-06,  -3.418415731953379e-08,   2.577084353099966e-10,   1.765180486319740e-12,  -1.341334842135926e-13,   2.600555419106309e-15,   1.484211575405751e-17,
  -2.467941841718011e-18,   2.681605706908909e-02,  -2.977580222140030e-04,   3.279909218501091e-06,  -3.418215197795635e-08,   2.574820789324352e-10,   1.771285021692193e-12,
  -1.340847965176430e-13,   2.590532603098363e-15,   1.519834852442583e-17,  -2.470739977990656e-18,   2.681619582933078e-02,  -2.977623565387071e-04,   3.279974378371095e-06,
  -3.418139836438531e-08,   2.573970871343239e-10,   1.773575293306256e-12,  -1.340664174133843e-13,   2.586767982611160e-15,   1.533199526048018e-17,  -2.471783514964363e-18,
   2.681621883091493e-02,  -2.977630750119452e-04,   3.279985178858521e-06,  -3.418127341114783e-08,   2.573829989117114e-10,   1.773954830866524e-12,  -1.340633657307129e-13,
   2.586143892729836e-15,   1.535414266917160e-17,  -2.471956116916111e-18,   7.522450028855215e-02,  -8.350833636085588e-04,   9.195586481597649e-06,  -9.574884888924548e-08,
   7.155413062124591e-10,   5.371577254486175e-12,  -3.950432501710693e-13,   7.877008864066435e-15,   3.214162556149925e-17,  -7.051921328584825e-18,   7.522581010701698e-02,
  -8.351242131753766e-04,   9.196192676212494e-06,  -9.574101144526263e-08,   7.146999293810266e-10,   5.394534534017302e-12,  -3.948877426477743e-13,   7.840576251986560e-15,
   3.346815812944419e-17,  -7.063555234928112e-18,   7.522796044766217e-02,  -8.351912718890652e-04,   9.197187324180424e-06,  -9.572812164201563e-08,   7.133189275842371e-10,
   5.432143737380501e-12,  -3.946286581474443e-13,   7.780725270692646e-15,   3.564123054276858e-17,  -7.082372174561226e-18,   7.523024220905447e-02,  -8.352624230183078e-04,
   9.198242017823133e-06,  -9.571441284655721e-08,   7.118539269418174e-10,   5.471942748558970e-12,  -3.943486008501652e-13,   7.717163667498205e-15,   3.794070016682070e-17,
  -7.101955572090532e-18,   7.523203802789333e-02,  -8.353184169032873e-04,   9.199071557094237e-06,  -9.570360102283295e-08,   7.107012189297924e-10,   5.503187083367729e-12,
  -3.941244723567105e-13,   7.667100916264589e-15,   3.974580170428041e-17,  -7.117090971700831e-18,   7.523307445435892e-02,  -8.353507310951317e-04,   9.199550095952134e-06,
  -9.569735212813776e-08,   7.100360717136924e-10,   5.521187643504277e-12,  -3.939936334034663e-13,   7.638193063381905e-15,   4.078571621248634e-17,  -7.125715050048805e-18,
   7.523346364739450e-02,  -8.353628652112638e-04,   9.199729753406461e-06,  -9.569500387233637e-08,   7.097863219084125e-10,   5.527941142517339e-12,  -3.939442206751249e-13,
   7.627334934778637e-15,   4.117586530577262e-17,  -7.128932537696578e-18,   7.523352816195318e-02,  -8.353648766049757e-04,   9.199759532162446e-06,  -9.569461452389774e-08,
   7.097449233390998e-10,   5.529060320871901e-12,  -3.939360149685716e-13,   7.625534889745804e-15,   4.124051967273836e-17,  -7.129464778006450e-18,   1.497547917011828e-01,
  -1.662408490674909e-03,   1.829896275923823e-05,  -1.899688556342562e-07,   1.384608552024994e-09,   1.249855226494599e-11,  -8.457411083476464e-13,   1.695590285529715e-14,
   5.590811785320860e-17,  -1.464962868577385e-17,   1.497573981347542e-01,  -1.662489528175193e-03,   1.830013479159749e-05,  -1.899506527946099e-07,   1.382806645421216e-09,
   1.254801227993113e-11,  -8.454601326345421e-13,   1.688015028570640e-14,   5.872195469486826e-17,  -1.467632488476379e-17,   1.497616771363348e-01,  -1.662622558637267e-03,
   1.830205776155302e-05,  -1.899207195188139e-07,   1.379848988411224e-09,   1.262904483106818e-11,  -8.449908161977451e-13,   1.675569582024012e-14,   6.333183147068176e-17,
  -1.471955565221619e-17,   1.497662176494774e-01,  -1.662763706471237e-03,   1.830409667174082e-05,  -1.898888896372278e-07,   1.376711323531457e-09,   1.271480353958966e-11,
  -8.444819105643996e-13,   1.662351297333092e-14,   6.821033467296707e-17,  -1.476461851858438e-17,   1.497697911742473e-01,  -1.662874784927614e-03,   1.830570021194568e-05,
  -1.898637899297172e-07,   1.374242431888010e-09,   1.278213448493454e-11,  -8.440735013141493e-13,   1.651939334477227e-14,   7.204035377629533e-17,  -1.479949864311576e-17,
   1.497718535721811e-01,  -1.662938888217667e-03,   1.830662520833918e-05,  -1.898492846103439e-07,   1.372817775231685e-09,   1.282092768151792e-11,  -8.438346384219291e-13,
   1.645926769198286e-14,   7.424696104470357e-17,  -1.481939453102604e-17,   1.497726280319783e-01,  -1.662962959213251e-03,   1.830697247089886e-05,  -1.898438339815209e-07,
   1.372282838419684e-09,   1.283548265980305e-11,  -8.437443458604337e-13,   1.643668311031417e-14,   7.507485015550294e-17,  -1.482682141085316e-17,   1.497727564102428e-01,
  -1.662966949302770e-03,   1.830703003027167e-05,  -1.898429302646923e-07,   1.372194166886629e-09,   1.283789470932125e-11,  -8.437293470839469e-13,   1.643293903474461e-14,
   7.521204694263423e-17,  -1.482805019011958e-17,   2.531080090499222e-01,  -2.809585699210801e-03,   3.090893554936539e-05,  -3.193952214788317e-07,   2.235737952099301e-09,
   2.588922869717241e-11,  -1.587689433290326e-12,   3.212971792944719e-14,   6.963972284945310e-17,  -2.632422456895581e-17,   2.531124114185054e-01,  -2.809721922962063e-03,
   3.091082534836031e-05,  -3.193575889365192e-07,   2.232353588664800e-09,   2.598306561299801e-11,  -1.587303884494594e-12,   3.199339962504973e-14,   7.486291491290482e-17,
  -2.637955460541879e-17,   2.531196388105424e-01,  -2.809945544506686e-03,   3.091392567229965e-05,  -3.192957134180287e-07,   2.226798260393510e-09,   2.613681872670500e-11,
  -1.586655996107324e-12,   3.176941444985286e-14,   8.342106703514591e-17,  -2.646929222059650e-17,   2.531273078922975e-01,  -2.810182808210677e-03,   3.091721251951636e-05,
  -3.192299289356657e-07,   2.220904526489014e-09,   2.629956100331450e-11,  -1.585948247716178e-12,   3.153148387034541e-14,   9.247935392724063e-17,  -2.656302304681635e-17,
   2.531333436882557e-01,  -2.810369524368162e-03,   3.091979723232528e-05,  -3.191780623729247e-07,   2.216266787540321e-09,   2.642734903958879e-11,  -1.585376577168208e-12,
   3.134404113270383e-14,   9.959187949444279e-17,  -2.663571356963227e-17,   2.531368271395872e-01,  -2.810477277250078e-03,   3.092128809766014e-05,  -3.191480915970952e-07,
   2.213590525759110e-09,   2.650098131261571e-11,  -1.585040781763834e-12,   3.123578862719639e-14,   1.036900693457300e-16,  -2.667723366414967e-17,   2.531381352244602e-01,
  -2.810517738646748e-03,   3.092184777687612e-05,  -3.191368301771016e-07,   2.212585613899713e-09,   2.652860889863534e-11,  -1.584913577979533e-12,   3.119512450715751e-14,
   1.052277333032960e-16,  -2.669274344435494e-17,   2.531383520590036e-01,  -2.810524445655861e-03,   3.092194054351193e-05,  -3.191349630613430e-07,   2.212419038077588e-09,
   2.653318740229437e-11,  -1.584892433632461e-12,   3.118838309829126e-14,   1.054825572777239e-16,  -2.669531011772194e-17,   3.898004955849754e-01,  -4.326606927624622e-03,
   4.755664686348958e-05,  -4.879017791548056e-07,   3.193272856100807e-09,   5.140166710784315e-11,  -2.834523929632769e-12,   5.828836898692078e-14,   3.339846813214558e-17,
  -4.412146007361862e-17,   3.898072686587146e-01,  -4.326814959862794e-03,   4.755933916473896e-05,  -4.878271944111551e-07,   3.187226371066017e-09,   5.157219334788846e-11,
  -2.834200201944903e-12,   5.805933892701216e-14,   4.261065598415237e-17,  -4.423473980728601e-17,   3.898183880271823e-01,  -4.327156455110687e-03,   4.756375528299996e-05,
  -4.877045776114609e-07,   3.177300687703130e-09,   5.185164316133305e-11,  -2.833642370349409e-12,   5.768294388879145e-14,   5.770769436911281e-17,  -4.441880695410632e-17,
   3.898301869057112e-01,  -4.327518776214661e-03,   4.756843605670248e-05,  -4.875742356837458e-07,   3.166769608713128e-09,   5.214748560973876e-11,  -2.833014656858161e-12,
   5.728301291368317e-14,   7.369100927702234e-17,  -4.461153589423274e-17,   3.898394729522657e-01,  -4.327803901818872e-03,   4.757211618023780e-05,  -4.874714852328615e-07,
   3.158482218537812e-09,   5.237982579423031e-11,  -2.832494747830198e-12,   5.696787230077063e-14,   8.624393975636885e-17,  -4.476134744708054e-17,   3.898448322183505e-01,
  -4.327968444150110e-03,   4.757423858045257e-05,  -4.874121175986447e-07,   3.153699659616230e-09,   5.251371757104403e-11,  -2.832184328961400e-12,   5.678584201943444e-14,
   9.347801913383561e-17,  -4.484705859619525e-17,   3.898468446962818e-01,  -4.328030229686149e-03,   4.757503528480385e-05,  -4.873898115533802e-07,   3.151903810254483e-09,
   5.256395815008008e-11,  -2.832065804999484e-12,   5.671745838255603e-14,   9.619250668905441e-17,  -4.487910264962225e-17,   3.898471782943719e-01,  -4.328040471431025e-03,
   4.757516733528656e-05,  -4.873861133263363e-07,   3.151606125122747e-09,   5.257228428688084e-11,  -2.832046054663598e-12,   5.670612126486439e-14,   9.664236724913603e-17,
  -4.488440695529534e-17,   5.676828465766297e-01,  -6.300297974097840e-03,   6.915416729867488e-05,  -7.011544216130109e-07,   4.052942632349297e-09,   1.029324662798803e-10,
  -5.100847730739543e-12,   1.079348284304207e-13,  -1.876160440559807e-16,  -7.202711989542936e-17,   5.676926945565671e-01,  -6.300596784922091e-03,   6.915756616220623e-05,
  -7.010052740839830e-07,   4.042049946864574e-09,   1.032490102884649e-10,  -5.101256048570109e-12,   1.075592851829569e-13,  -1.712314405925148e-16,  -7.227393315453535e-17,
   5.677088619496208e-01,  -6.301087284619910e-03,   6.916313922344689e-05,  -7.007601011932284e-07,   4.024167390477250e-09,   1.037678531539460e-10,  -5.101879397993694e-12,
   1.069418807984063e-13,  -1.443712491170239e-16,  -7.267586325806743e-17,   5.677260172652232e-01,  -6.301607679282901e-03,   6.916904353451416e-05,  -7.004995151699522e-07,
   4.005192043652559e-09,   1.043172763624987e-10,  -5.102477043653490e-12,   1.062855649166699e-13,  -1.159221073153299e-16,  -7.309792059328589e-17,   5.677395189229899e-01,
  -6.302017186652997e-03,   6.917368364238241e-05,  -7.002941153777366e-07,   3.990257962668197e-09,   1.047488714321304e-10,  -5.102901265823887e-12,   1.057681757001071e-13,
  -9.357003054918639e-17,  -7.342688112233520e-17,   5.677473111275883e-01,  -6.302253502925306e-03,   6.917635888734003e-05,  -7.001754481022502e-07,   3.981639069085611e-09,
   1.049976308843068e-10,  -5.103127618044828e-12,   1.054692351727787e-13,  -8.068532298374156e-17,  -7.361544781584204e-17,   5.677502372031941e-01,  -6.302342238548710e-03,
   6.917736296716075e-05,  -7.001308633628500e-07,   3.978402562950197e-09,   1.050909815443746e-10,  -5.103209125523634e-12,   1.053569150094005e-13,  -7.584985107641524e-17,
  -7.368601403304456e-17,   5.677507222434429e-01,  -6.302356947564449e-03,   6.917752938131929e-05,  -7.001234715384940e-07,   3.977866064395541e-09,   1.051064525343293e-10,
  -5.103222452486092e-12,   1.053382929093205e-13,  -7.504845365794368e-17,  -7.369769860379325e-17,   8.021255540737690e-01,  -8.900401132372410e-03,   9.744787474948037e-05,
  -9.663852197149880e-07,   4.142654210046753e-09,   2.221758070760216e-10,  -9.984762989097889e-12,   2.234927271115540e-13,  -1.210186341824954e-15,  -1.170886774456913e-16,
   8.021394284897558e-01,  -8.900812565819906e-03,   9.745129087324698e-05,  -9.660635007620593e-07,   4.121292089085237e-09,   2.228338128668424e-10,  -9.988928918581315e-12,
   2.228758437909904e-13,  -1.178528410034627e-15,  -1.177283220942318e-16,   8.021622059216570e-01,  -8.901487899862396e-03,   9.745688579498623e-05,  -9.655346743496333e-07,
   4.086216630783580e-09,   2.239126924495917e-10,  -9.995677013338549e-12,   2.218608038731986e-13,  -1.126595322761122e-15,  -1.187727848302075e-16,   8.021863749887261e-01,
  -8.902204344712812e-03,   9.746280449983654e-05,  -9.649726351802042e-07,   4.048990672852579e-09,   2.250556385298053e-10,  -1.000271371353058e-11,   2.207806181366570e-13,
  -1.071543209942557e-15,  -1.198733992677236e-16,   8.022053964977763e-01,  -8.902768091465989e-03,   9.746744956141966e-05,  -9.645296466196703e-07,   4.019687781978780e-09,
   2.259538170489499e-10,  -1.000816222952468e-11,   2.199282346458164e-13,  -1.028255636564622e-15,  -1.207340509977712e-16,   8.022163743131960e-01,  -8.903093400984144e-03,
   9.747012510966448e-05,  -9.642737245830060e-07,   4.002774178988326e-09,   2.264716411864972e-10,  -1.001127085348746e-11,   2.194353998434142e-13,  -1.003289194853161e-15,
  -1.212285285178331e-16,   8.022204966167091e-01,  -8.903215550425135e-03,   9.747112882028116e-05,  -9.641775733103983e-07,   3.996422514533384e-09,   2.266659886152598e-10,
  -1.001243140408659e-11,   2.192501642773960e-13,  -9.939170247882647e-16,  -1.214137896741685e-16,   8.022211799488226e-01,  -8.903235798046711e-03,   9.747129514775223e-05,
  -9.641616322233702e-07,   3.995369612166713e-09,   2.266981991698546e-10,  -1.001262342493383e-11,   2.192194498081169e-13,  -9.923636109051135e-16,  -1.214444771972853e-16,
   1.132771938611331e+00,  -1.256332614735204e-02,   1.367158011970275e-04,  -1.278859370813531e-06,  -2.609682021217323e-11,   6.175847315405833e-10,  -2.615628262657762e-11,
   6.740430539272702e-13,  -8.727561200626146e-15,  -1.411542402040909e-16,   1.132791393582509e+00,  -1.256386895262441e-02,   1.367154601573150e-04,  -1.277963615380990e-06,
  -8.232235083686009e-11,   6.195862586999794e-10,  -2.618947963476226e-11,   6.732496955988926e-13,  -8.651643093317449e-15,  -1.437741690680655e-16,   1.132823331980866e+00,
  -1.256475977499545e-02,   1.367148654625833e-04,  -1.276491034524133e-06,  -1.746760369763581e-10,   6.228703302622856e-10,  -2.624375824415204e-11,   6.719376058421035e-13,
  -8.526835162144635e-15,  -1.480702437109067e-16,   1.132857220972005e+00,  -1.256570462504293e-02,   1.367141871014492e-04,  -1.274925722758800e-06,  -2.727387174705437e-10,
   6.263525816778733e-10,  -2.630105324302475e-11,   6.705322537813263e-13,  -8.394166264091710e-15,  -1.526219102293585e-16,   1.132883891699165e+00,  -1.256644795062422e-02,
   1.367136189360748e-04,  -1.273691795178029e-06,  -3.499638534525187e-10,   6.290913835076963e-10,  -2.634592815317666e-11,   6.694167407631874e-13,  -8.289583788988604e-15,
  -1.561991277621129e-16,   1.132899283861977e+00,  -1.256687682747968e-02,   1.367132772866250e-04,  -1.272978862392455e-06,  -3.945516995179667e-10,   6.306712958267590e-10,
  -2.637173946482715e-11,   6.687691535977835e-13,  -8.229158836164845e-15,  -1.582616040774009e-16,   1.132905063765426e+00,  -1.256703785403682e-02,   1.367131463944313e-04,
  -1.272710996154701e-06,  -4.112985987313257e-10,   6.312644352410894e-10,  -2.638141544007752e-11,   6.685252597334842e-13,  -8.206455783375180e-15,  -1.590357035893326e-16,
   1.132906021866797e+00,  -1.256706454538722e-02,   1.367131245600326e-04,  -1.272666585426889e-06,  -4.140748330743538e-10,   6.313627495445346e-10,  -2.638301850457105e-11,
   6.684847929411908e-13,  -8.202691748767183e-15,  -1.591640015299840e-16,   2.838689050618981e-03,  -3.018724677516558e-05,   3.199735632665095e-07,  -3.310093242480539e-09,
   2.966632363722612e-11,  -7.369790487123142e-14,  -6.887045332398091e-15,   2.329227726736048e-16,  -3.485836712453343e-18,  -3.368791259780953e-20,   2.838734635975395e-03,
  -3.018866027562431e-05,   3.199988094097278e-07,  -3.310192272311405e-09,   2.965146382628639e-11,  -7.300495100959124e-14,  -6.900459109605269e-15,   2.327297791374002e-16,
  -3.462940147583691e-18,  -3.444999118122804e-20,   2.838809474300994e-03,  -3.019098079464934e-05,   3.200402458201871e-07,  -3.310354134380946e-09,   2.962704859931522e-11,
  -7.186778518115333e-14,  -6.922413830207301e-15,   2.324101428317734e-16,  -3.425312624973117e-18,  -3.569899133568661e-20,   2.838888887062246e-03,  -3.019344308433998e-05,
   3.200842005174763e-07,  -3.310524915908554e-09,   2.960111442962367e-11,  -7.066175218251675e-14,  -6.945619500235544e-15,   2.320671744379924e-16,  -3.385334142094611e-18,
  -3.702144403634416e-20,   2.838951387866325e-03,  -3.019538094788613e-05,   3.201187840129374e-07,  -3.310658622191468e-09,   2.958068407089842e-11,  -6.971302608678825e-14,
  -6.963817285132044e-15,   2.317945016418643e-16,  -3.353832951206908e-18,  -3.806016017607776e-20,   2.838987459322032e-03,  -3.019649933827433e-05,   3.201387391820416e-07,
  -3.310735506301545e-09,   2.956888529653252e-11,  -6.916567020997556e-14,  -6.974293431962972e-15,   2.316360336629428e-16,  -3.335637896784566e-18,  -3.865879412970540e-20,
   2.839001004705023e-03,  -3.019691930714524e-05,   3.201462318578139e-07,  -3.310764324058541e-09,   2.956445322627452e-11,  -6.896016534249611e-14,  -6.978222384675522e-15,
   2.315763189818089e-16,  -3.328802630183041e-18,  -3.888342997167969e-20,   2.839003250056304e-03,  -3.019698892311075e-05,   3.201474738397368e-07,  -3.310769098218938e-09,
   2.956371846740602e-11,  -6.892610169709302e-14,  -6.978873403931321e-15,   2.315664094289710e-16,  -3.327669437220022e-18,  -3.892065827752472e-20,   2.567230823099368e-02,
  -2.730041339974716e-04,   2.893622912551450e-06,  -2.992366591270352e-08,   2.675065469260164e-10,  -6.273410142000023e-13,  -6.376782714326566e-14,   2.148156737775824e-15,
  -3.228524483089632e-17,  -3.022936253126016e-19,   2.567272047253195e-02,  -2.730169120226838e-04,   2.893850541147299e-06,  -2.992450472748049e-08,   2.673689574148265e-10,
  -6.209494763166621e-13,  -6.389211082678607e-14,   2.146420114064300e-15,  -3.207547274862720e-17,  -3.093118926590343e-19,   2.567339725704290e-02,  -2.730378894659257e-04,
   2.894224144961477e-06,  -2.992587521548998e-08,   2.671428925320455e-10,  -6.104606053127344e-13,  -6.409553637252497e-14,   2.143543319841971e-15,  -3.173073198501834e-17,
  -3.208146903103391e-19,   2.567411540939251e-02,  -2.730601484889836e-04,   2.894620451402523e-06,  -2.992732049284129e-08,   2.669027632781424e-10,  -5.993363965639876e-13,
  -6.431056210571007e-14,   2.140455731555297e-15,  -3.136444148571336e-17,  -3.329943470270893e-19,   2.567468062199675e-02,  -2.730776666984173e-04,   2.894932262558968e-06,
  -2.992845147979429e-08,   2.667135946652642e-10,  -5.905854428388612e-13,  -6.447919108742451e-14,   2.138000409731175e-15,  -3.107581403992570e-17,  -3.425611011004577e-19,
   2.567500682643392e-02,  -2.730877768960897e-04,   2.895112181148819e-06,  -2.992910160801444e-08,   2.666043474838850e-10,  -5.855366502951050e-13,  -6.457627055703923e-14,
   2.136573234575051e-15,  -3.090910012605486e-17,  -3.480747360042173e-19,   2.567512932118085e-02,  -2.730915733940468e-04,   2.895179735991928e-06,  -2.992934524882641e-08,
   2.665633100578927e-10,  -5.836410731455724e-13,  -6.461267955656374e-14,   2.136035396795628e-15,  -3.084647077896194e-17,  -3.501437346715100e-19,   2.567514962653015e-02,
  -2.730922027188845e-04,   2.895190933837704e-06,  -2.992938560999376e-08,   2.665565067777430e-10,  -5.833268696674526e-13,  -6.461871247883565e-14,   2.135946141262073e-15,
  -3.083608766676253e-17,  -3.504866254970679e-19,   7.202430107567191e-02,  -7.659147992653064e-04,   8.117373301924983e-06,  -8.388125890315178e-08,   7.458305321278721e-10,
  -1.527452426871124e-12,  -1.877363204664557e-13,   6.275940877516679e-15,  -9.516560499314342e-17,  -8.320990282478788e-19,   7.202545751349666e-02,  -7.659506171146324e-04,
   8.118007827645110e-06,  -8.388327495963227e-08,   7.454254512189724e-10,  -1.508775040761298e-12,  -1.881029530092628e-13,   6.271130376419489e-15,  -9.456115783602551e-17,
  -8.525450691294779e-19,   7.202735605829867e-02,  -7.660094184980868e-04,   8.119049252975128e-06,  -8.388656546474036e-08,   7.447598863705803e-10,  -1.478123834091837e-12,
  -1.887030925594403e-13,   6.263157852756162e-15,  -9.356775827710262e-17,  -8.860574869468095e-19,   7.202937064934020e-02,  -7.660718121053679e-04,   8.120153943975748e-06,
  -8.389003088682104e-08,   7.440529124086706e-10,  -1.445615227705551e-12,  -1.893375108291772e-13,   6.254596148852978e-15,  -9.251219717293002e-17,  -9.215442845137318e-19,
   7.203095620697823e-02,  -7.661209167751362e-04,   8.121023094005553e-06,  -8.389273933028932e-08,   7.434959723803844e-10,  -1.420041491562714e-12,  -1.898350795846487e-13,
   6.247784104374930e-15,  -9.168039593675710e-17,  -9.494198416582406e-19,   7.203187128890751e-02,  -7.661492562691198e-04,   8.121524598187936e-06,  -8.389429486680647e-08,
   7.431743321958137e-10,  -1.405286703602780e-12,  -1.901215456390246e-13,   6.243823130532626e-15,  -9.119992120220348e-17,  -9.654861415843867e-19,   7.203221491611191e-02,
  -7.661598980740715e-04,   8.121712899221705e-06,  -8.389487755766810e-08,   7.430535117220967e-10,  -1.399746952365960e-12,  -1.902289859075850e-13,   6.242330152306971e-15,
  -9.101941795404543e-17,  -9.715151738757033e-19,   7.203227187749499e-02,  -7.661616621078408e-04,   8.121744111822819e-06,  -8.389497407166027e-08,   7.430334818169976e-10,
  -1.398828702542691e-12,  -1.902467887798466e-13,   6.242082374814679e-15,  -9.098949273314957e-17,  -9.725143597828134e-19,   1.433840521940650e-01,  -1.524746049470125e-03,
   1.615737404064841e-05,  -1.667582455522979e-07,   1.469452326290999e-09,  -2.273852539988532e-12,  -4.030228455408701e-13,   1.332649039656960e-14,  -2.050244397954631e-16,
  -1.592165005782925e-18,   1.433863540202119e-01,  -1.524817252422893e-03,   1.615862379188067e-05,  -1.667611465814370e-07,   1.468582672897377e-09,  -2.234178119953457e-12,
  -4.038136940979962e-13,   1.331717554562405e-14,  -2.037693646010539e-16,  -1.635398878611226e-18,   1.433901329682289e-01,  -1.524934144413756e-03,   1.616067492119334e-05,
  -1.667658683465997e-07,   1.467153789820451e-09,  -2.169067008870854e-12,  -4.051083713520337e-13,   1.330172442285277e-14,  -2.017065018333005e-16,  -1.706268285674932e-18,
   1.433941428979111e-01,  -1.525058176958963e-03,   1.616285059416907e-05,  -1.667708231423526e-07,   1.465635998071067e-09,  -2.100007640468350e-12,  -4.064771885278486e-13,
   1.328511332074788e-14,  -1.995143309506303e-16,  -1.781321410197536e-18,   1.433972988594356e-01,  -1.525155792021148e-03,   1.616456232866125e-05,  -1.667746825185624e-07,
   1.464440305632645e-09,  -2.045678375455053e-12,  -4.075508784467927e-13,   1.327188388535673e-14,  -1.977866977895267e-16,  -1.840283197844456e-18,   1.433991202769612e-01,
  -1.525212127900191e-03,   1.616554999092408e-05,  -1.667768937795199e-07,   1.463749774996004e-09,  -2.014332288885633e-12,  -4.081690913207767e-13,   1.326418627923487e-14,
  -1.967886969914519e-16,  -1.874268751718788e-18,   1.433998042468825e-01,  -1.525233282642837e-03,   1.616592082761850e-05,  -1.667777210947688e-07,   1.463490384540188e-09,
  -2.002563114139858e-12,  -4.084009651368308e-13,   1.326128391872030e-14,  -1.964137588627292e-16,  -1.887022619577022e-18,   1.433999176251898e-01,  -1.525236789347389e-03,
   1.616598229698202e-05,  -1.667778580740006e-07,   1.463447382148768e-09,  -2.000612289115155e-12,  -4.084393872275311e-13,   1.326080218685043e-14,  -1.963515980786774e-16,
  -1.889136330737474e-18,   2.423408304820204e-01,  -2.577009659523002e-03,   2.730203066214215e-05,  -2.812502004295645e-07,   2.443702992689714e-09,  -1.834706692083777e-12,
  -7.584697092662291e-13,   2.474802981157280e-14,  -3.891480426960628e-16,  -2.472659734825566e-18,   2.423447199386902e-01,  -2.577129738334468e-03,   2.730410792065312e-05,
  -2.812521891811999e-07,   2.442066160365997e-09,  -1.760989264023890e-12,  -7.599734561293695e-13,   2.473322303909348e-14,  -3.868947838733211e-16,  -2.552502788526500e-18,
   2.423511053236480e-01,  -2.577326867611134e-03,   2.730751706100057e-05,  -2.812553783178560e-07,   2.439376740060138e-09,  -1.640003544208451e-12,  -7.624355826636351e-13,
   2.470862102366017e-14,  -3.831908117223119e-16,  -2.683400205285672e-18,   2.423578809991893e-01,  -2.577536037641655e-03,   2.731113304123827e-05,  -2.812586593464235e-07,
   2.436519943490405e-09,  -1.511674043613308e-12,  -7.650392240226547e-13,   2.468211676962829e-14,  -3.792540119128326e-16,  -2.822049329136011e-18,   2.423632137003519e-01,
  -2.577700656002742e-03,   2.731397783609028e-05,  -2.812611670518941e-07,   2.434269379474944e-09,  -1.410711412757026e-12,  -7.670818788591521e-13,   2.466096874047804e-14,
  -3.761509813234150e-16,  -2.930989770832971e-18,   2.423662913901968e-01,  -2.577795660654210e-03,   2.731561922154094e-05,  -2.812625844470560e-07,   2.432969634453233e-09,
  -1.352457366641029e-12,  -7.682581576599495e-13,   2.464864803274879e-14,  -3.743582679809162e-16,  -2.993790059642598e-18,   2.423674471091612e-01,  -2.577831335878478e-03,
   2.731623550222847e-05,  -2.812631110515453e-07,   2.432481397236043e-09,  -1.330584948287154e-12,  -7.686993746878012e-13,   2.464399961482292e-14,  -3.736847295186008e-16,
  -3.017358659912645e-18,   2.423676386869570e-01,  -2.577837249559276e-03,   2.731633765557063e-05,  -2.812631980461781e-07,   2.432400455962729e-09,  -1.326959416929141e-12,
  -7.687724870096566e-13,   2.464322791957260e-14,  -3.735730620842870e-16,  -3.021264777808567e-18,   3.732191959710615e-01,  -3.968647641698026e-03,   4.203181960450770e-05,
  -4.317394283628183e-07,   3.668958784461200e-09,   1.975308242282441e-12,  -1.355121287630637e-12,   4.359356371416408e-14,  -7.081675072129753e-16,  -3.092950100176247e-18,
   3.732251836739123e-01,  -3.968831946750606e-03,   4.203493573386648e-05,  -4.317355204308170e-07,   3.666033654258409e-09,   2.105265054250405e-12,  -1.357864629971201e-12,
   4.357397613476516e-14,  -7.043972155786618e-16,  -3.232578035729585e-18,   3.732350137753411e-01,  -3.969134511868895e-03,   4.204004954918182e-05,  -4.317289713952133e-07,
   3.661227388767138e-09,   2.318565458330984e-12,  -1.362357357729302e-12,   4.354130491541033e-14,  -6.981981902242643e-16,  -3.461537635931947e-18,   3.732454447050312e-01,
  -3.969455554847207e-03,   4.204547323387377e-05,  -4.317218409060568e-07,   3.656121883136616e-09,   2.544832264950991e-12,  -1.367109643052664e-12,   4.350593878998651e-14,
  -6.916077222516728e-16,  -3.704122516127935e-18,   3.732536542144542e-01,  -3.969708215894957e-03,   4.204973991379677e-05,  -4.317160978150547e-07,   3.652099713495770e-09,
   2.722860491518878e-12,  -1.370838956024685e-12,   4.347759948113566e-14,  -6.864117547741820e-16,  -3.894776219345764e-18,   3.732583922082927e-01,  -3.969854030933933e-03,
   4.205220158095899e-05,  -4.317127307167954e-07,   3.649776795701698e-09,   2.825585891027199e-12,  -1.372986898301419e-12,   4.346104163100004e-14,  -6.834093750184137e-16,
  -4.004700576996225e-18,   3.732601713957955e-01,  -3.969908785818393e-03,   4.205312582584539e-05,  -4.317114563876914e-07,   3.648904206326795e-09,   2.864156846737111e-12,
  -1.373792655544550e-12,   4.345478570178428e-14,  -6.822812569475603e-16,  -4.045958225148426e-18,   3.732604663228413e-01,  -3.969917862218283e-03,   4.205327902550958e-05,
  -4.317112446245032e-07,   3.648759545766958e-09,   2.870550352108180e-12,  -1.373926178259128e-12,   4.345374667231972e-14,  -6.820942186330449e-16,  -4.052796211729766e-18,
   5.435365478507745e-01,  -5.779499439547733e-03,   6.117851042323497e-05,  -6.254986031659770e-07,   5.120861416925860e-09,   1.433969528946132e-11,  -2.428595750082890e-12,
   7.719788757352345e-14,  -1.318616380567513e-15,  -2.004971784985843e-18,   5.435452627346824e-01,  -5.779766399333482e-03,   6.118285309408210e-05,  -6.254762515622542e-07,
   5.115616599520638e-09,   1.457011546056875e-11,  -2.433722234058973e-12,   7.718105726567952e-14,  -1.312481751461289e-15,  -2.249553349191942e-18,   5.435595700693595e-01,
  -5.780204649687214e-03,   6.118997903528645e-05,  -6.254393209067104e-07,   5.106998541445340e-09,   1.494834685488455e-11,  -2.442120409179499e-12,   7.715252434561819e-14,
  -1.302391498145446e-15,  -2.650756267875623e-18,   5.435747518582620e-01,  -5.780669657170689e-03,   6.119753578211754e-05,  -6.253998127103239e-07,   5.097843473603794e-09,
   1.534962333878202e-11,  -2.451007330087315e-12,   7.712102178792388e-14,  -1.291658877021352e-15,  -3.076027739035692e-18,   5.435867004409329e-01,  -5.781035613222718e-03,
   6.120347977386071e-05,  -6.253684864952372e-07,   5.090630693773482e-09,   1.566538846804204e-11,  -2.457983844253857e-12,   7.709534130785728e-14,  -1.283193444126481e-15,
  -3.410399462220552e-18,   5.435935963759742e-01,  -5.781246810687507e-03,   6.120690888123329e-05,  -6.253503141097191e-07,   5.086464977539349e-09,   1.584760575819452e-11,
  -2.462003088628440e-12,   7.708016489996786e-14,  -1.278300366438251e-15,  -3.603242802317731e-18,   5.435961859011001e-01,  -5.781326116880843e-03,   6.120819630190874e-05,
  -6.253434725427723e-07,   5.084900127993284e-09,   1.591602692776343e-11,  -2.463511023610312e-12,   7.707439879759291e-14,  -1.276461550656054e-15,  -3.675632848185274e-18,
   5.435966151536936e-01,  -5.781339262988260e-03,   6.120840969747949e-05,  -6.253423375237359e-07,   5.084640701107461e-09,   1.592736854453031e-11,  -2.463760915166067e-12,
   7.707343943845611e-14,  -1.276156665972890e-15,  -3.687631236115854e-18,   7.680116120651713e-01,  -8.165814599422757e-03,   8.635894678582167e-05,  -8.755637291953808e-07,
   6.661959265478392e-09,   5.054980041505474e-11,  -4.672642038300761e-12,   1.482426268688151e-13,  -2.756141267622280e-15,   7.917078389908838e-18,   7.680239129003857e-01,
  -8.166188128757019e-03,   8.636457776077358e-05,  -8.754880487614822e-07,   6.651857292335258e-09,   5.099324379472586e-11,  -4.683417734276197e-12,   1.482709044322396e-13,
  -2.746235987981419e-15,   7.459553556729347e-18,   7.680441072827294e-01,  -8.166801313399207e-03,   8.637381564290492e-05,  -8.753633507982344e-07,   6.635256753093042e-09,
   5.172128097223702e-11,  -4.701078997187080e-12,   1.483156330979991e-13,  -2.729929682797955e-15,   6.708531799429274e-18,   7.680655358583498e-01,  -8.167451916714990e-03,
   8.638360921660910e-05,  -8.752304164667697e-07,   6.617619876539231e-09,   5.249385485084007e-11,  -4.719779768564027e-12,   1.483607922133326e-13,  -2.712566180456549e-15,
   5.911756265455864e-18,   7.680824008209487e-01,  -8.167963921003657e-03,   8.639131062793165e-05,  -8.751253474193786e-07,   6.603723347581600e-09,   5.310192377717777e-11,
  -4.734468941007368e-12,   1.483946665189762e-13,  -2.698856789517363e-15,   5.284781074994230e-18,   7.680921341454282e-01,  -8.168259399074456e-03,   8.639575278325526e-05,
  -8.750645300174586e-07,   6.595696895791439e-09,   5.345287145728739e-11,  -4.742934934055647e-12,   1.484135482213310e-13,  -2.690927146228788e-15,   4.922980324992687e-18,
   7.680957891480323e-01,  -8.168370352208321e-03,   8.639742038788251e-05,  -8.750416584555953e-07,   6.592681656806758e-09,   5.358465937046747e-11,  -4.746111838786188e-12,
   1.484205122698674e-13,  -2.687946148453782e-15,   4.787128167948179e-18,   7.680963950192714e-01,  -8.168388744182350e-03,   8.639769679248009e-05,  -8.750378653719708e-07,
   6.592181773099505e-09,   5.360650529025906e-11,  -4.746638342224318e-12,   1.484216600021767e-13,  -2.687451829435745e-15,   4.764609137087461e-18,   1.084609877958084e+00,
  -1.153024552834277e-02,   1.216801939096149e-04,  -1.208755955513172e-06,   7.403356671566608e-09,   1.826173133838344e-10,  -1.146614794963239e-11,   3.781421121715038e-13,
  -8.406295952666514e-15,   9.398396013385231e-17,   1.084627206369147e+00,  -1.153076061890852e-02,   1.216863741142613e-04,  -1.208486469092747e-06,   7.378486391449098e-09,
   1.837545898013490e-10,  -1.149939138765112e-11,   3.785970412084195e-13,  -8.394280583550393e-15,   9.299790822659692e-17,   1.084655654374104e+00,  -1.153160613804763e-02,
   1.216965044467872e-04,  -1.208042890754529e-06,   7.337606646540666e-09,   1.856225784372214e-10,  -1.155393039581274e-11,   3.793402054187713e-13,  -8.374403430341115e-15,
   9.137593158671463e-17,   1.084685840739421e+00,  -1.153250318295780e-02,   1.217072324652971e-04,  -1.207570625424897e-06,   7.294160583935455e-09,   1.876059663598612e-10,
  -1.161175204423452e-11,   3.801237583794055e-13,  -8.353105730340516e-15,   8.965053634401407e-17,   1.084709598170255e+00,  -1.153320907769514e-02,   1.217156602198456e-04,
  -1.207197795294806e-06,   7.259918013004420e-09,   1.891678463806651e-10,  -1.165722271428512e-11,   3.807367922253735e-13,  -8.336194853810709e-15,   8.828950069104851e-17,
   1.084723309289520e+00,  -1.153361642949988e-02,   1.217205179234046e-04,  -1.206982164682811e-06,   7.240135804404449e-09,   1.900696148713346e-10,  -1.168345052659890e-11,
   3.810891307158292e-13,  -8.326375352831994e-15,   8.750276512482579e-17,   1.084728457996739e+00,  -1.153376938774878e-02,   1.217223408824229e-04,  -1.206901105705364e-06,
   7.232703580500771e-09,   1.904083090264707e-10,  -1.169329663948652e-11,   3.812211620518241e-13,  -8.322676711810706e-15,   8.720710126584568e-17,   1.084729311471063e+00,
  -1.153379474242994e-02,   1.217226430029251e-04,  -1.206887664401146e-06,   7.231471382146982e-09,   1.904644561792666e-10,  -1.169492863146661e-11,   3.812430336090340e-13,
  -8.322063011939049e-15,   8.715807826577624e-17,   2.722819256420769e-03,  -2.777843380967247e-05,   2.830281777579392e-07,  -2.854220161169722e-09,   2.700075407337588e-11,
  -1.736715932809857e-13,  -1.959792462315225e-15,   1.216646374742788e-16,  -3.054152572000698e-18,   3.768042019174568e-20,   2.722859579721589e-03,  -2.777965320075287e-05,
   2.830512076042145e-07,  -2.854464211402134e-09,   2.699642708304107e-11,  -1.733050718968176e-13,  -1.971889877492193e-15,   1.218491998357471e-16,  -3.050718450454885e-18,
   3.736546100478892e-20,   2.722925779312680e-03,  -2.778165510319984e-05,   2.830890121091945e-07,  -2.854864481161097e-09,   2.698930500225426e-11,  -1.727029745909263e-13,
  -1.991739586299874e-15,   1.221510165464932e-16,  -3.045034390736091e-18,   3.684760421777637e-20,   2.722996025412132e-03,  -2.778377937780744e-05,   2.831291219149567e-07,
  -2.855288684093806e-09,   2.698172261865325e-11,  -1.720635699019440e-13,  -2.012787785313067e-15,   1.224696725733529e-16,  -3.038940153137142e-18,   3.629703540492965e-20,
   2.723051311790583e-03,  -2.778545126644586e-05,   2.831606858620463e-07,  -2.855622161551010e-09,   2.697573692796647e-11,  -1.715599703040512e-13,  -2.029342724286466e-15,
   1.227193005809024e-16,  -3.034098367436435e-18,   3.586295481669706e-20,   2.723083219574248e-03,  -2.778641617546173e-05,   2.831789009568992e-07,  -2.855814468547469e-09,
   2.697227512956216e-11,  -1.712691792635878e-13,  -2.038892834077510e-15,   1.228629020062206e-16,  -3.031285814945981e-18,   3.561212702536176e-20,   2.723095201440753e-03,
  -2.778677851394518e-05,   2.831857407025340e-07,  -2.855886653498630e-09,   2.697097380291201e-11,  -1.711599552972234e-13,  -2.042478223892933e-15,   1.229167380612053e-16,
  -3.030226222872364e-18,   3.551787999131916e-20,   2.723097187615940e-03,  -2.778683857702814e-05,   2.831868744775294e-07,  -2.855898617697664e-09,   2.697075801623297e-11,
  -1.711418483305000e-13,  -2.043072512826792e-15,   1.229256575297220e-16,  -3.030050398314368e-18,   3.550225410321887e-20,   2.462441636117210e-02,  -2.512201258992980e-04,
   2.559586839324000e-06,  -2.580879465570294e-08,   2.439080704449843e-10,  -1.555662219419271e-12,  -1.835266075519605e-14,   1.121002257479701e-15,  -2.813694113483708e-17,
   3.492123676120963e-19,   2.462478102751970e-02,  -2.512311519572483e-04,   2.559794868665147e-06,  -2.581097993845438e-08,   2.438675715742750e-10,  -1.552284963703919e-12,
  -1.846412369270259e-14,   1.122713681357795e-15,  -2.810594304214960e-17,   3.463287277603858e-19,   2.462537970772563e-02,  -2.512492536840110e-04,   2.560136357092640e-06,
  -2.581456394886374e-08,   2.438009145017993e-10,  -1.546737005726844e-12,  -1.864701642411862e-14,   1.125512526904185e-15,  -2.805462784226187e-17,   3.415873268758586e-19,
   2.462601498275124e-02,  -2.512684619227412e-04,   2.560498668124818e-06,  -2.581836212261147e-08,   2.437299530260618e-10,  -1.540845250853190e-12,  -1.884095441892485e-14,
   1.128467715345182e-15,  -2.799959874626072e-17,   3.365462685983085e-19,   2.462651496857170e-02,  -2.512835795642305e-04,   2.560783783727163e-06,  -2.582134787305380e-08,
   2.436739372124088e-10,  -1.536204840211316e-12,  -1.899349336934621e-14,   1.130782879494488e-15,  -2.795587113324903e-17,   3.325716771520740e-19,   2.462680352859804e-02,
  -2.512923045138272e-04,   2.560948319446730e-06,  -2.582306963167512e-08,   2.436415417644493e-10,  -1.533525341325031e-12,  -1.908148982052938e-14,   1.132114759290257e-15,
  -2.793046704420822e-17,   3.302749674408770e-19,   2.462691188735112e-02,  -2.512955808688671e-04,   2.561010102340471e-06,  -2.582371590895262e-08,   2.436293641719350e-10,
  -1.532518893493384e-12,  -1.911452639424205e-14,   1.132614090269441e-15,  -2.792089580872747e-17,   3.294119842682284e-19,   2.462692984944954e-02,  -2.512961239742337e-04,
   2.561020343638911e-06,  -2.582382302493349e-08,   2.436273448875438e-10,  -1.532352046159142e-12,  -1.912000231107549e-14,   1.132696819146831e-15,  -2.791930756491379e-17,
   3.292689036935551e-19,   6.908442654122168e-02,  -7.048028886983528e-04,   7.180744809895256e-06,  -7.238375975127194e-08,   6.826391936402352e-10,  -4.275734519450257e-12,
  -5.522255173529987e-14,   3.268279895469809e-15,  -8.202627497920349e-17,   1.030741027398784e-18,   6.908544958468622e-02,  -7.048338121066969e-04,   7.181326985661164e-06,
  -7.238976122041081e-08,   6.825174567876949e-10,  -4.265887051379176e-12,  -5.554757524594897e-14,   3.273337112344288e-15,  -8.193980549775850e-17,   1.022443906438732e-18,
   6.908712913592406e-02,  -7.048845797200647e-04,   7.182282645074629e-06,  -7.239960344148886e-08,   6.823171055530897e-10,  -4.249710060647242e-12,  -5.608089780064149e-14,
   3.281608462863218e-15,  -8.179661116235834e-17,   1.008800744890032e-18,   6.908891135090088e-02,  -7.049384505724989e-04,   7.183296569674293e-06,  -7.241003298199086e-08,
   6.821038374207099e-10,  -4.232530411431810e-12,  -5.664644417591524e-14,   3.290342979232730e-15,  -8.164298573166469e-17,   9.942943973548767e-19,   6.909031402231772e-02,
  -7.049808490186395e-04,   7.184094458304343e-06,  -7.241823107673975e-08,   6.819355021237675e-10,  -4.218999386780212e-12,  -5.709127714285991e-14,   3.297186626881922e-15,
  -8.152086241020988e-17,   9.828562802957603e-19,   6.909112355501588e-02,  -7.050053187129535e-04,   7.184554905184170e-06,  -7.242295834409935e-08,   6.818381553091560e-10,
  -4.211186148236940e-12,  -5.734789622273937e-14,   3.301124007416184e-15,  -8.144989416653997e-17,   9.762465165076521e-19,   6.909142754705357e-02,  -7.050145074628998e-04,
   7.184727801843261e-06,  -7.242473272123553e-08,   6.818015633419083e-10,  -4.208251403049991e-12,  -5.744423976289986e-14,   3.302600221452123e-15,  -8.142315258842664e-17,
   9.737628624769254e-19,   6.909147793832035e-02,  -7.050160306369240e-04,   7.184756461637274e-06,  -7.242502680961114e-08,   6.817954957335578e-10,  -4.207764885040927e-12,
  -5.746020905479835e-14,   3.302844803083373e-15,  -8.141871492079466e-17,   9.733510758009786e-19,   1.375314684683405e-01,  -1.403098057875922e-03,   1.429445335146300e-05,
  -1.440230808444094e-07,   1.353576184176993e-09,  -8.220729176265638e-12,  -1.222437731312105e-13,   6.914973816232250e-15,  -1.736125358854563e-16,   2.225517466937251e-18,
   1.375335049951275e-01,  -1.403159585176410e-03,   1.429560756564526e-05,  -1.440346034446554e-07,   1.353307071538618e-09,  -8.199890226019770e-12,  -1.229319790576640e-13,
   6.925912619762476e-15,  -1.734429096941071e-16,   2.208331312745304e-18,   1.375368484020159e-01,  -1.403260595715084e-03,   1.429750222640446e-05,  -1.440534981520063e-07,
   1.352864219702056e-09,  -8.165656390056143e-12,  -1.240612769675542e-13,   6.943806435408819e-15,  -1.731618270465739e-16,   2.180069285694428e-18,   1.375403961762876e-01,
  -1.403367780480604e-03,   1.429951237838474e-05,  -1.440735176556490e-07,   1.352392879631370e-09,  -8.129300017505105e-12,  -1.252588609076408e-13,   6.962706077479391e-15,
  -1.728600262057509e-16,   2.150015886348386e-18,   1.375431884099609e-01,  -1.403452138910279e-03,   1.430109421209758e-05,  -1.440892519285511e-07,   1.352020890228706e-09,
  -8.100664522475535e-12,  -1.262008640821348e-13,   6.977517071371108e-15,  -1.726199382966127e-16,   2.126316703893168e-18,   1.375447999093829e-01,  -1.403500825194020e-03,
   1.430200705244774e-05,  -1.440983239910922e-07,   1.351805790182026e-09,  -8.084129283145129e-12,  -1.267443103696726e-13,   6.986039457533018e-15,  -1.724803495751312e-16,
   2.112620672025071e-18,   1.375454050522799e-01,  -1.403519107639250e-03,   1.430234982043623e-05,  -1.441017290349282e-07,   1.351724939041612e-09,  -8.077918412052823e-12,
  -1.269483415163797e-13,   6.989234908059416e-15,  -1.724277381361519e-16,   2.107474136360893e-18,   1.375455053638433e-01,  -1.403522138230033e-03,   1.430240663846953e-05,
  -1.441022933849570e-07,   1.351711532644015e-09,  -8.076888780361117e-12,  -1.269821605737910e-13,   6.989764346945308e-15,  -1.724190067785694e-16,   2.106620837885309e-18,
   2.324491772324530e-01,  -2.371436885517264e-03,   2.415779114447192e-05,  -2.432235449156328e-07,   2.273765164867817e-09,  -1.313669381519827e-11,  -2.388213384943591e-13,
   1.276554496890449e-14,  -3.210083149671402e-16,   4.238132700525037e-18,   2.324526189617346e-01,  -2.371540787841061e-03,   2.415972960380941e-05,  -2.432419141962889e-07,
   2.273240258128150e-09,  -1.309821250302246e-11,  -2.400946004748190e-13,   1.278642963837721e-14,  -3.207319550141666e-16,   4.207398832273899e-18,   2.324582693164382e-01,
  -2.371711365918303e-03,   2.416291156988278e-05,  -2.432720306259385e-07,   2.272376577431022e-09,  -1.303499462930354e-11,  -2.421840426706819e-13,   1.282060069951532e-14,
  -3.202734664360488e-16,   4.156851194206085e-18,   2.324642650500498e-01,  -2.371892370042809e-03,   2.416628743449877e-05,  -2.433039324811519e-07,   2.271457480548538e-09,
  -1.296785513829556e-11,  -2.443999756657617e-13,   1.285670302868379e-14,  -3.197804553725248e-16,   4.103090296048956e-18,   2.324689839197972e-01,  -2.372034826738078e-03,
   2.416894393330358e-05,  -2.433290002886747e-07,   2.270732217564155e-09,  -1.291497235219636e-11,  -2.461431048878861e-13,   1.288500279561921e-14,  -3.193877353310354e-16,
   4.060689369997502e-18,   2.324717073503210e-01,  -2.372117043484781e-03,   2.417047692050826e-05,  -2.433434517228439e-07,   2.270312881097480e-09,  -1.288443519890369e-11,
  -2.471487675146632e-13,   1.290128981803419e-14,  -3.191591985977273e-16,   4.036182685483197e-18,   2.324727300404044e-01,  -2.372147917106757e-03,   2.417105254781758e-05,
  -2.433488754141659e-07,   2.270155269998423e-09,  -1.287296489763393e-11,  -2.475263409725558e-13,   1.290739718400631e-14,  -3.190730235863375e-16,   4.026973338918309e-18,
   2.324728995667072e-01,  -2.372153034873460e-03,   2.417114796498367e-05,  -2.433497743121522e-07,   2.270129135996598e-09,  -1.287106335721003e-11,  -2.475889258559371e-13,
   1.290840911493726e-14,  -3.190587200033632e-16,   4.025446397271942e-18,   3.579857029870745e-01,  -3.652125226037075e-03,   3.719976896979316e-05,  -3.741182133341452e-07,
   3.468901552098558e-09,  -1.843927736469112e-11,  -4.447093952225556e-13,   2.226671480260523e-14,  -5.623449393443787e-16,   7.749362597113428e-18,   3.579910027325307e-01,
  -3.652285035934265e-03,   3.720272532894072e-05,  -3.741438862554051e-07,   3.467925763061926e-09,  -1.837212466776374e-11,  -4.469419340091892e-13,   2.230503891463301e-14,
  -5.619584620040214e-16,   7.698264492743455e-18,   3.579997034258653e-01,  -3.652547397540923e-03,   3.720757806045866e-05,  -3.741859631877655e-07,   3.466320407343752e-09,
  -1.826180076419637e-11,  -4.506058470525740e-13,   2.236776363264037e-14,  -5.613156823361505e-16,   7.614205426607617e-18,   3.580089359463741e-01,  -3.652825794068655e-03,
   3.721272635281396e-05,  -3.742305158036074e-07,   3.464612326473522e-09,  -1.814462751555222e-11,  -4.544919513564335e-13,   2.243406013184904e-14,  -5.606223468029821e-16,
   7.524777560059076e-18,   3.580162022871158e-01,  -3.653044901254214e-03,   3.721677748348662e-05,  -3.742655106624938e-07,   3.463264674268138e-09,  -1.805233132072288e-11,
  -4.575491738974437e-13,   2.248604782945892e-14,  -5.600685118755573e-16,   7.454228036821505e-18,   3.580203959541272e-01,  -3.653171355361127e-03,   3.721911522841710e-05,
  -3.742856794964505e-07,   3.462485561782782e-09,  -1.799903327951183e-11,  -4.593130876374732e-13,   2.251597549846326e-14,  -5.597456064257073e-16,   7.413444854899893e-18,
   3.580219707404112e-01,  -3.653218840714794e-03,   3.721999302914660e-05,  -3.742932479169986e-07,   3.462192741021903e-09,  -1.797901327436189e-11,  -4.599753657045386e-13,
   2.252719936464846e-14,  -5.596237330429751e-16,   7.398117597607329e-18,   3.580222317849722e-01,  -3.653226712122398e-03,   3.722013853476839e-05,  -3.742945022178845e-07,
   3.462144188270524e-09,  -1.797569435238909e-11,  -4.600851430644886e-13,   2.252905912799850e-14,  -5.596034981238532e-16,   7.395576212390166e-18,   5.213518416332101e-01,
  -5.318697889834415e-03,   5.416513957077843e-05,  -5.437870285166131e-07,   4.975694976693299e-09,  -2.264491778342878e-11,  -8.309302771510040e-13,   3.876209719048718e-14,
  -9.890188403931033e-16,   1.452605496703641e-17,   5.213595582530507e-01,  -5.318930154659830e-03,   5.416937770100928e-05,  -5.438182651209513e-07,   4.973874569697228e-09,
  -2.252792971826822e-11,  -8.348623166818878e-13,   3.883429921669196e-14,  -9.886078986165984e-16,   1.444384029214244e-17,   5.213722267680210e-01,  -5.319311464378736e-03,
   5.417633413959284e-05,  -5.438694242564029e-07,   4.970880015170575e-09,  -2.233572036349501e-11,  -8.413161302927623e-13,   3.895252359548093e-14,  -9.879189359403544e-16,
   1.430853941758202e-17,   5.213856696322285e-01,  -5.319716076242172e-03,   5.418371390978692e-05,  -5.439235437808578e-07,   4.967694323934614e-09,  -2.213156175210831e-11,
  -8.481623825615063e-13,   3.907755098042447e-14,  -9.871684121089255e-16,   1.416452445516118e-17,   5.213962496646442e-01,  -5.320034517142877e-03,   5.418952070473255e-05,
  -5.439660171252581e-07,   4.965181204936791e-09,  -2.197073636129629e-11,  -8.535491394492854e-13,   3.917564515131949e-14,  -9.865636423465521e-16,   1.405085884161401e-17,
   5.214023557796434e-01,  -5.320218299311384e-03,   5.419287146896906e-05,  -5.439904815970711e-07,   4.963728444745351e-09,  -2.187786025313531e-11,  -8.566574233859030e-13,
   3.923213557000367e-14,  -9.862089649499804e-16,   1.398513019208491e-17,   5.214046487189400e-01,  -5.320287312041461e-03,   5.419412962901404e-05,  -5.439996592261740e-07,
   4.963182467133239e-09,  -2.184297290250491e-11,  -8.578245161564076e-13,   3.925332527112895e-14,  -9.860747116530782e-16,   1.396042389564523e-17,   5.214050288081580e-01,
  -5.320298751926127e-03,   5.419433818255190e-05,  -5.440011800734781e-07,   4.963091939699950e-09,  -2.183718922108614e-11,  -8.580179732617654e-13,   3.925683655286459e-14,
  -9.860524008855925e-16,   1.395632717993751e-17,   7.366661713019452e-01,  -7.515114482211670e-03,   7.650879403007840e-05,  -7.657390438160400e-07,   6.838489907488858e-09,
  -2.118369856066784e-11,  -1.656426227159934e-12,   7.198397121607030e-14,  -1.882221513934174e-15,   3.062359918758930e-17,   7.366770707656849e-01,  -7.515441492722987e-03,
   7.651461245131143e-05,  -7.657673506456167e-07,   6.834864967707961e-09,  -2.096613372064263e-11,  -1.663928119625791e-12,   7.213735723777068e-14,  -1.882341742407009e-15,
   3.049389632509464e-17,   7.366949645950752e-01,  -7.515978341719664e-03,   7.652416206624373e-05,  -7.658135960925509e-07,   6.828902467070550e-09,  -2.060863679425362e-11,
  -1.676243887575369e-12,   7.238867956881743e-14,  -1.882513127279374e-15,   3.028025489861378e-17,   7.367139521405681e-01,  -7.516547991266898e-03,   7.653429186329327e-05,
  -7.658623603851476e-07,   6.822560061087836e-09,  -2.022885832261956e-11,  -1.689312096331558e-12,   7.265469050535756e-14,  -1.882659645109717e-15,   3.005259714152366e-17,
   7.367288960246853e-01,  -7.516996316583991e-03,   7.654226183193364e-05,  -7.659005166584484e-07,   6.817557163798649e-09,  -1.992964777285535e-11,  -1.699596977391576e-12,
   7.286356244646304e-14,  -1.882749362245984e-15,   2.987272990818548e-17,   7.367375206673101e-01,  -7.517255057140286e-03,   7.654686055982336e-05,  -7.659224485614417e-07,
   6.814665328070838e-09,  -1.975683823089149e-11,  -1.705532625671630e-12,   7.298391372205754e-14,  -1.882790877554571e-15,   2.976864507756936e-17,   7.367407593507697e-01,
  -7.517352217404996e-03,   7.654858725823831e-05,  -7.659306674139097e-07,   6.813578551999624e-09,  -1.969192211159317e-11,  -1.707761527352709e-12,   7.302907033612810e-14,
  -1.882804526924269e-15,   2.972950732780197e-17,   7.367412962112526e-01,  -7.517368323141909e-03,   7.654887347426410e-05,  -7.659320289201887e-07,   6.813398357782851e-09,
  -1.968116004790921e-11,  -1.708131000034363e-12,   7.303655376535553e-14,  -1.882806687147645e-15,   2.972301689812988e-17,   1.040347019303855e+00,  -1.061261431316513e-02,
   1.079665521149271e-04,  -1.072939432979086e-06,   9.018623367814947e-09,   7.469026893068698e-12,  -4.090632629154227e-12,   1.683712099004451e-13,  -4.722778563781660e-15,
   9.376156928875540e-17,   1.040362399119610e+00,  -1.061307232097780e-02,   1.079742017513330e-04,  -1.072924484577695e-06,   9.009666355704012e-09,   7.979801522175431e-12,
  -4.109568738308399e-12,   1.688476129435261e-13,  -4.728499039972458e-15,   9.361660479430986e-17,   1.040387648355608e+00,  -1.061382420932020e-02,   1.079867542683965e-04,
  -1.072899415821415e-06,   8.994932692329149e-09,   8.819347189598294e-12,  -4.140671608293325e-12,   1.696291537144091e-13,  -4.737839003857513e-15,   9.337661463831237e-17,
   1.040414440805455e+00,  -1.061462201325642e-02,   1.080000658395575e-04,  -1.072872097027225e-06,   8.979259331261432e-09,   9.711564401640898e-12,  -4.173696069056482e-12,
   1.704576746753179e-13,  -4.747679830609617e-15,   9.311923750115233e-17,   1.040435527370779e+00,  -1.061524988349603e-02,   1.080105365913874e-04,  -1.072850076029048e-06,
   8.966895482799236e-09,   1.041475307709216e-11,  -4.199702294128713e-12,   1.711091757517220e-13,  -4.755374132392580e-15,   9.291470390581974e-17,   1.040447697147137e+00,
  -1.061561223740062e-02,   1.080165772498981e-04,  -1.072837158302498e-06,   8.959748503716964e-09,   1.082098131290319e-11,  -4.214717307895278e-12,   1.714849485292715e-13,
  -4.759794399515542e-15,   9.279587114003661e-17,   1.040452267077223e+00,  -1.061574830445970e-02,   1.080188451578708e-04,  -1.072832268050878e-06,   8.957062556556936e-09,
   1.097360045137025e-11,  -4.220356785538248e-12,   1.716260130025674e-13,  -4.761450419956455e-15,   9.275109845699451e-17,   1.040453024611610e+00,  -1.061577085949935e-02,
   1.080192210739487e-04,  -1.072831455336548e-06,   8.956617207066952e-09,   1.099890328787576e-11,  -4.221291672431500e-12,   1.716493942425169e-13,  -4.761724726711006e-15,
   9.274366884091048e-17,   2.616027056749798e-03,  -2.564414233286069e-05,   2.512494298078524e-07,  -2.451574777655008e-09,   2.328140624217351e-11,  -1.895539620954255e-13,
   2.933092157656670e-16,   4.676327634723950e-17,  -1.649388524114223e-18,   3.487204015595187e-20,   2.616062851371118e-03,  -2.564518991265972e-05,   2.512693115607192e-07,
  -2.451843320455264e-09,   2.328195364589326e-11,  -1.894113797260637e-13,   2.866898784037065e-16,   4.694068301218054e-17,  -1.651678137710794e-18,   3.482628352098315e-20,
   2.616121616082317e-03,  -2.564690976707473e-05,   2.513019509894860e-07,  -2.452284029100911e-09,   2.328284206005508e-11,  -1.891769253084501e-13,   2.758166689078920e-16,
   4.723175046339911e-17,  -1.655419765619455e-18,   3.475052058635612e-20,   2.616183972765394e-03,  -2.564873477782181e-05,   2.513365843691269e-07,  -2.452751453918281e-09,
   2.328377081685673e-11,  -1.889276315687617e-13,   2.642705519049263e-16,   4.754035732226590e-17,  -1.659366590814060e-18,   3.466925242501583e-20,   2.616233049817469e-03,
  -2.565017115215197e-05,   2.513638413245196e-07,  -2.453119173922200e-09,   2.328449167110750e-11,  -1.887310601313005e-13,   2.551773461102844e-16,   4.778305904471559e-17,
  -1.662455845539413e-18,   3.460465850500447e-20,   2.616261373951548e-03,  -2.565100014444100e-05,   2.513795719672823e-07,  -2.453331333833974e-09,   2.328490364732659e-11,
  -1.886174642643703e-13,   2.499269404703844e-16,   4.792305706880504e-17,  -1.664231925285714e-18,   3.456712541287305e-20,   2.616272010098204e-03,  -2.565131144544534e-05,
   2.513854790027916e-07,  -2.453410990928108e-09,   2.328505758418255e-11,  -1.885747794195005e-13,   2.479548819300149e-16,   4.797561446939862e-17,  -1.664897576616346e-18,
   3.455298323187539e-20,   2.616273773199809e-03,  -2.565136304836746e-05,   2.513864581796757e-07,  -2.453424194647900e-09,   2.328508306109495e-11,  -1.885677022938665e-13,
   2.476279597497636e-16,   4.798432591088096e-17,  -1.665007850077312e-18,   3.455063642391133e-20,   2.365861818228663e-02,  -2.319183843363625e-04,   2.272217310941170e-06,
  -2.217010658886863e-08,   2.104583652260875e-10,  -1.709031652207542e-12,   2.415357158881538e-15,   4.315733167153433e-16,  -1.517004363904253e-17,   3.210963410851993e-19,
   2.365894189692150e-02,  -2.319278577942229e-04,   2.272397034317752e-06,  -2.217252753312221e-08,   2.104627972128670e-10,  -1.707715830272242e-12,   2.354472707697565e-15,
   4.332070715982464e-16,  -1.519129055815598e-17,   3.206832706641610e-19,   2.365947334539095e-02,  -2.319434107533863e-04,   2.272692081840600e-06,  -2.217650054076422e-08,
   2.104699788688740e-10,  -1.705552174067465e-12,   2.254460734306657e-15,   4.358875703501304e-16,  -1.522601397269375e-17,   3.199992125690717e-19,   2.366003727844540e-02,
  -2.319599146573254e-04,   2.273005153451451e-06,  -2.218071435295795e-08,   2.104774711284454e-10,  -1.703251583414417e-12,   2.148258605847009e-15,   4.387296350266446e-16,
  -1.526264474245941e-17,   3.192653076213361e-19,   2.366048111493533e-02,  -2.319729040491517e-04,   2.273251544880653e-06,  -2.218402929995774e-08,   2.104832748372584e-10,
  -1.701437544082963e-12,   2.064618018936317e-15,   4.409647875128936e-16,  -1.529131857062982e-17,   3.186818812897971e-19,   2.366073726895331e-02,  -2.319804007748199e-04,
   2.273393743156840e-06,  -2.218594188090094e-08,   2.104865870837225e-10,  -1.700389239104754e-12,   2.016323833594443e-15,   4.422541063282932e-16,  -1.530780467797030e-17,
   3.183428342247414e-19,   2.366083345871415e-02,  -2.319832159253500e-04,   2.273447140204846e-06,  -2.218665997197611e-08,   2.104878238348504e-10,  -1.699995327985557e-12,
   1.998184440022443e-15,   4.427381386532332e-16,  -1.531398362491782e-17,   3.182150763780594e-19,   2.366084940361664e-02,  -2.319836825797733e-04,   2.273455991539406e-06,
  -2.218677900046335e-08,   2.104880284731319e-10,  -1.699930017749697e-12,   1.995177341496634e-15,   4.428183676150618e-16,  -1.531500725371742e-17,   3.181938753539057e-19,
   6.637485887759517e-02,  -6.506525054059061e-04,   6.374690974580972e-06,  -6.219142591671381e-08,   5.899022547427408e-10,  -4.763746070431630e-12,   5.371269291364913e-15,
   1.262189513602478e-15,  -4.406889520380367e-17,   9.350857629912680e-19,   6.637576705595229e-02,  -6.506790801248912e-04,   6.375194711118721e-06,  -6.219817251931470e-08,
   5.899116171805109e-10,  -4.759898087122222e-12,   5.194376183278316e-15,   1.266948631814122e-15,  -4.413177417653800e-17,   9.339331625369879e-19,   6.637725802957262e-02,
  -6.507227089024702e-04,   6.376021681303844e-06,  -6.220924417012728e-08,   5.899267135307827e-10,  -4.753570740631439e-12,   4.903799005893136e-15,   1.274757096893351e-15,
  -4.423454961548705e-17,   9.320237705078218e-19,   6.637884013831639e-02,  -6.507690052277429e-04,   6.376899167472238e-06,  -6.222098661988616e-08,   5.899423599202184e-10,
  -4.746842999211141e-12,   4.595232263860164e-15,   1.283036470025352e-15,  -4.434298906509230e-17,   9.299743685710502e-19,   6.638008531725594e-02,  -6.508054427204835e-04,
   6.377589758612003e-06,  -6.223022405537929e-08,   5.899544042512615e-10,  -4.741538144200620e-12,   4.352214037256702e-15,   1.289547999973035e-15,  -4.442788680126600e-17,
   9.283445462901608e-19,   6.638080395483215e-02,  -6.508264723282119e-04,   6.377988314208785e-06,  -6.223555358152790e-08,   5.899612472187652e-10,  -4.738472566586224e-12,
   4.211893671907164e-15,   1.293304166379145e-15,  -4.447670447097610e-17,   9.273971575379072e-19,   6.638107381425554e-02,  -6.508343693096496e-04,   6.378137976163519e-06,
  -6.223755457306049e-08,   5.899637963936543e-10,  -4.737320647882318e-12,   4.159188809535061e-15,   1.294714309562035e-15,  -4.449500223131544e-17,   9.270401210312381e-19,
   6.638111854752171e-02,  -6.508356783555149e-04,   6.378162784793926e-06,  -6.223788625029548e-08,   5.899642178781289e-10,  -4.737129660577634e-12,   4.150451529961668e-15,
   1.294948043298314e-15,  -4.449803356535762e-17,   9.269808694587924e-19,   1.321373440785326e-01,  -1.295300613021070e-03,   1.269033247710293e-05,  -1.237850678349718e-07,
   1.172587111586217e-09,  -9.382184207622716e-12,   6.082098085542716e-15,   2.682087298732521e-15,  -9.273022624916398e-17,   1.975960922165137e-18,   1.321391520195632e-01,
  -1.295353506506166e-03,   1.269133372992233e-05,  -1.237983501958429e-07,   1.172595667954340e-09,  -9.374008256505857e-12,   5.709794041472849e-15,   2.692148604226147e-15,
  -9.286655538227721e-17,   1.973698413078345e-18,   1.321421201504478e-01,  -1.295440343807227e-03,   1.269297745238944e-05,  -1.238201468650459e-07,   1.172609138717060e-09,
  -9.360564417547325e-12,   5.098209399842156e-15,   2.708657215533657e-15,  -9.308943090073043e-17,   1.969948029977676e-18,   1.321452697068304e-01,  -1.295532490445865e-03,
   1.269472157410662e-05,  -1.238432632841918e-07,   1.172622649213406e-09,  -9.346269994448160e-12,   4.448745929820900e-15,   2.726162298561052e-15,  -9.332465212079605e-17,
   1.965919512843976e-18,   1.321477485257031e-01,  -1.295605014352526e-03,   1.269609421063207e-05,  -1.238614476688026e-07,   1.172632714858291e-09,  -9.334998878802612e-12,
   3.937235887679518e-15,   2.739930268328924e-15,  -9.350885369761812e-17,   1.962713522931461e-18,   1.321491791412127e-01,  -1.295646870927410e-03,   1.269688638739221e-05,
  -1.238719388789891e-07,   1.172638296498264e-09,  -9.328485550338247e-12,   3.641881949681581e-15,   2.747872557568679e-15,  -9.361479126340139e-17,   1.960849043972717e-18,
   1.321497163592489e-01,  -1.295662588791796e-03,   1.269718385789783e-05,  -1.238758777984656e-07,   1.172640349460958e-09,  -9.326038115541435e-12,   3.530945021340937e-15,
   2.750854307019634e-15,  -9.365450211483296e-17,   1.960146222294364e-18,   1.321498054112335e-01,  -1.295665194268852e-03,   1.269723316790537e-05,  -1.238765306972798e-07,
   1.172640687500297e-09,  -9.325632332991238e-12,   3.512554130529311e-15,   2.751348539843695e-15,  -9.366108107542923e-17,   1.960029577566685e-18,   2.233323142527141e-01,
  -2.189252288497309e-03,   2.144799688697451e-05,  -2.091540996924205e-07,   1.977281418931647e-09,  -1.559526743335422e-11,  -1.701439281715782e-15,   4.975966677718620e-15,
  -1.699116451921290e-16,   3.645446187692734e-18,   2.233353698551951e-01,  -2.189341658919567e-03,   2.144968510638332e-05,  -2.091761645766681e-07,   1.977269673022811e-09,
  -1.558010035733224e-11,  -2.383856686402014e-15,   4.994541725140851e-15,  -1.701727937023023e-16,   3.641754285758127e-18,   2.233403862949757e-01,  -2.189488381714391e-03,
   2.145245658201614e-05,  -2.092123719322852e-07,   1.977249334484777e-09,  -1.555516109139486e-11,  -3.504897918460558e-15,   5.025021504528030e-15,  -1.705998536313688e-16,
   3.635627569976238e-18,   2.233457093615062e-01,  -2.189644075156117e-03,   2.145539731826671e-05,  -2.092507693437649e-07,   1.977226318273628e-09,  -1.552864418019361e-11,
  -4.695415963305416e-15,   5.057343517869620e-15,  -1.710507408418515e-16,   3.629037138373000e-18,   2.233498988138669e-01,  -2.189766613383946e-03,   2.145771168302450e-05,
  -2.092809728027874e-07,   1.977207164598074e-09,  -1.550773584178240e-11,  -5.633086697186818e-15,   5.082766969296217e-15,  -1.714039549871767e-16,   3.623785623534069e-18,
   2.233523166973041e-01,  -2.189837335264805e-03,   2.145904734403140e-05,  -2.092983975883485e-07,   1.977195693674281e-09,  -1.549565344584911e-11,  -6.174525459386301e-15,
   5.097433636425407e-15,  -1.716071448912510e-16,   3.620728892153920e-18,   2.233532246495362e-01,  -2.189863892539542e-03,   2.145954889722559e-05,  -2.093049395920194e-07,
   1.977191307398783e-09,  -1.549111340303545e-11,  -6.377895952485141e-15,   5.102940033567648e-15,  -1.716833204538965e-16,   3.619576148716421e-18,   2.233533751562985e-01,
  -2.189868294814615e-03,   2.145963203680441e-05,  -2.093060239606819e-07,   1.977190576151757e-09,  -1.549036066860066e-11,  -6.411610414519331e-15,   5.103852740519305e-15,
  -1.716959410854885e-16,   3.619384805945289e-18,   3.439452568821636e-01,  -3.371572087108547e-03,   3.302981502514328e-05,  -3.219672308473766e-07,   3.034486172002101e-09,
  -2.340331949853624e-11,  -3.091942159135259e-14,   8.719187813430422e-15,  -2.935141751319020e-16,   6.367433933286951e-18,   3.439499624769380e-01,  -3.371709658838101e-03,
   3.303240554274068e-05,  -3.220003106376846e-07,   3.034406146163677e-09,  -2.337674388024469e-11,  -3.209889386562322e-14,   8.751666441921303e-15,  -2.939954932177614e-16,
   6.362247239407900e-18,   3.439576877389315e-01,  -3.371935515258382e-03,   3.303665824290127e-05,  -3.220545889177542e-07,   3.034272945769330e-09,  -2.333304564127216e-11,
  -3.403655901871992e-14,   8.804965309816651e-15,  -2.947829171870555e-16,   6.353619499905862e-18,   3.439658852013588e-01,  -3.372175180182915e-03,   3.304117061283194e-05,
  -3.221121448866079e-07,   3.034129128328575e-09,  -2.328658323821799e-11,  -3.609442982720444e-14,   8.861492038897112e-15,  -2.956147078819486e-16,   6.344311280173325e-18,
   3.439723369097455e-01,  -3.372363807730831e-03,   3.304472181789071e-05,  -3.221574145679419e-07,   3.034014145645810e-09,  -2.324994817880170e-11,  -3.771532702564182e-14,
   8.905958788273278e-15,  -2.962666280548963e-16,   6.336874490845034e-18,   3.439760604219903e-01,  -3.372472672381705e-03,   3.304677126605077e-05,  -3.221835296855107e-07,
   3.033947066025745e-09,  -2.322877775581991e-11,  -3.865131533109956e-14,   8.931613308971546e-15,  -2.966417785955306e-16,   6.332538005560144e-18,   3.439774586577437e-01,
  -3.372513552897393e-03,   3.304754085008980e-05,  -3.221933341102698e-07,   3.033921740674859e-09,  -2.322082283293260e-11,  -3.900288958059529e-14,   8.941245296667682e-15,
  -2.967824460170311e-16,   6.330901187591088e-18,   3.439776904363826e-01,  -3.372520329467942e-03,   3.304766841944186e-05,  -3.221949592252251e-07,   3.033917535444862e-09,
  -2.321950391531624e-11,  -3.906117338731646e-14,   8.942841855087396e-15,  -2.968057528183913e-16,   6.330629417131131e-18,   5.009042228595695e-01,  -4.910165029293654e-03,
   4.809977333230439e-05,  -4.685717816975594e-07,   4.394844070419704e-09,  -3.266043358610407e-11,  -1.113375961225679e-13,   1.520842895157491e-14,  -5.046493777516411e-16,
   1.115453198760844e-17,   5.009110753538296e-01,  -4.910365235652961e-03,   4.810352434846305e-05,  -4.686178676423870e-07,   4.394582271146282e-09,  -3.261407351262402e-11,
  -1.133672571195513e-13,   1.526541823009559e-14,  -5.055610320701878e-16,   1.114890002534573e-17,   5.009223252180900e-01,  -4.910693920931876e-03,   4.810968207948122e-05,
  -4.686934771176605e-07,   4.394149343783714e-09,  -3.253784295501803e-11,  -1.167018747769422e-13,   1.535895305622620e-14,  -5.070533056512785e-16,   1.113946281041085e-17,
   5.009342627180864e-01,  -4.911042700624950e-03,   4.811621567718114e-05,  -4.687736392253252e-07,   4.393685702646018e-09,  -3.245678930920632e-11,  -1.202436894315480e-13,
   1.545817004167154e-14,  -5.086307932970720e-16,   1.112918891923210e-17,   5.009436579730959e-01,  -4.911317205977694e-03,   4.812135748494290e-05,  -4.688366798270530e-07,
   4.393317720049226e-09,  -3.239287867701436e-11,  -1.230336648100134e-13,   1.553623180084950e-14,  -5.098679816616794e-16,   1.112091479001913e-17,   5.009490803107156e-01,
  -4.911475633954895e-03,   4.812432485514431e-05,  -4.688730427734948e-07,   4.393104109067804e-09,  -3.235594611101515e-11,  -1.246448339815570e-13,   1.558127363663522e-14,
  -5.105802594825387e-16,   1.111606403442647e-17,   5.009511164811848e-01,  -4.911535126288330e-03,   4.812543911935164e-05,  -4.688866938248198e-07,   4.393023661385337e-09,
  -3.234206840088954e-11,  -1.252500365703726e-13,   1.559818555583182e-14,  -5.108473999574697e-16,   1.111422823654513e-17,   5.009514540071033e-01,  -4.911544988049681e-03,
   4.812562382391672e-05,  -4.688889564921832e-07,   4.393010313650781e-09,  -3.233976748835495e-11,  -1.253503677145167e-13,   1.560098885652999e-14,  -5.108916650591571e-16,
   1.111392317278879e-17,   7.077742273692020e-01,  -6.937982818042465e-03,   6.795704801272979e-05,  -6.612970429684750e-07,   6.149545608547562e-09,  -4.257825147850926e-11,
  -3.269011958616112e-13,   2.806484744510062e-14,  -9.218611110203253e-16,   2.110041472902548e-17,   7.077839087069043e-01,  -6.938265351686225e-03,   6.796229453973826e-05,
  -6.613569106604580e-07,   6.148803632057106e-09,  -4.249265332520274e-11,  -3.306147120124861e-13,   2.817295779926930e-14,  -9.238077510266992e-16,   2.110116560360768e-17,
   7.077998027290199e-01,  -6.938729194705030e-03,   6.797090709119555e-05,  -6.614551044046832e-07,   6.147579806706287e-09,  -4.235189657899511e-11,  -3.367166177067139e-13,
   2.835043868906069e-14,  -9.269967616719702e-16,   2.110206224654208e-17,   7.078166682480906e-01,  -6.939221392878793e-03,   6.798004503089466e-05,  -6.615591747905968e-07,
   6.146273412795822e-09,  -4.220222541342945e-11,  -3.431987678866867e-13,   2.853875928096090e-14,  -9.303713999074498e-16,   2.110255658769814e-17,   7.078299420310685e-01,
  -6.939608773431240e-03,   6.798723617034280e-05,  -6.616409911895592e-07,   6.145239607877151e-09,  -4.208420362946089e-11,  -3.483057169483981e-13,   2.868696778507930e-14,
  -9.330206155579359e-16,   2.110261442648339e-17,   7.078376028035698e-01,  -6.939832345535797e-03,   6.799138612978874e-05,  -6.616881739080840e-07,   6.144640706395993e-09,
  -4.201599883927720e-11,  -3.512552241066634e-13,   2.877250131641107e-14,  -9.345468610075106e-16,   2.110251494857626e-17,   7.078404795400397e-01,  -6.939916300447057e-03,
   6.799294444528085e-05,  -6.617058848449739e-07,   6.144415383273568e-09,  -4.199036985250222e-11,  -3.523632064078811e-13,   2.880461989337025e-14,  -9.351194762097113e-16,
   2.110245247116488e-17,   7.078409564024083e-01,  -6.939930217247195e-03,   6.799320275650233e-05,  -6.617088203357216e-07,   6.144378010070745e-09,  -4.198612056265160e-11,
  -3.525468921150193e-13,   2.880994400067852e-14,  -9.352143687095694e-16,   2.110244078905038e-17,   9.995459263227476e-01,  -9.797946385986980e-03,   9.594843914372390e-05,
  -9.314477708081599e-07,   8.492065455931541e-09,  -4.837574759086473e-11,  -1.041490202520172e-12,   6.321908941480459e-14,  -2.100089151378307e-15,   5.218341120613248e-17,
   9.995595950450198e-01,  -9.798344278675342e-03,   9.595567682397424e-05,  -9.315149776485543e-07,   8.489741217102059e-09,  -4.818251605261797e-11,  -1.049982964793713e-12,
   6.348820898138484e-14,  -2.106106639708983e-15,   5.225030555084599e-17,   9.995820352077710e-01,  -9.798997504291120e-03,   9.596755718116955e-05,  -9.316251080080083e-07,
   8.485912433231851e-09,  -4.786471275155521e-11,  -1.063942499519966e-12,   6.393025544290744e-14,  -2.115978391847416e-15,   5.235951814008681e-17,   9.996058469645956e-01,
  -9.799690654812369e-03,   9.598016116110456e-05,  -9.317416919421329e-07,   8.481831884222743e-09,  -4.752670698806083e-11,  -1.078778133634652e-12,   6.439963011271951e-14,
  -2.126443608991857e-15,   5.247457682542991e-17,   9.996245876734142e-01,  -9.800236187912538e-03,   9.599007910995155e-05,  -9.318332462722366e-07,   8.478607489388695e-09,
  -4.726012109465731e-11,  -1.090470853478153e-12,   6.476926782733760e-14,  -2.134672884263141e-15,   5.256453049278295e-17,   9.996354035959675e-01,  -9.800551033739412e-03,
   9.599580236993946e-05,  -9.318860046774434e-07,   8.476741420732280e-09,  -4.710603916908413e-11,  -1.097225761423461e-12,   6.498268781437507e-14,  -2.139419376822216e-15,
   5.261620432923967e-17,   9.996394651378222e-01,  -9.800669262990586e-03,   9.599795140079012e-05,  -9.319058009676988e-07,   8.476039708701748e-09,  -4.704813639390834e-11,
  -1.099763583470798e-12,   6.506284702807359e-14,  -2.141201204150970e-15,   5.263556292059853e-17,   9.996401383994423e-01,  -9.800688861261035e-03,   9.599830762759817e-05,
  -9.319090816937840e-07,   8.475923337930520e-09,  -4.703853588614047e-11,  -1.100184331684541e-12,   6.507613550777540e-14,  -2.141496539646595e-15,   5.263876948538293e-17,
   2.517292724169071e-03,  -2.374577375558767e-05,   2.239426691476291e-07,  -2.108666774410811e-09,   1.964047840471453e-11,  -1.717166079419242e-13,   1.030402944705964e-15,
   1.096158928576328e-17,  -6.840260372542610e-19,   1.896613859995899e-20,   2.517324626604739e-03,  -2.374667485414037e-05,   2.239594513122457e-07,  -2.108910848530540e-09,
   1.964264491101614e-11,  -1.716822844127927e-13,   1.027630379288394e-15,   1.105945449111247e-17,  -6.862927466394918e-19,   1.899242863408459e-20,   2.517377001345755e-03,
  -2.374815422854037e-05,   2.239870032788652e-07,  -2.109311499754077e-09,   1.964619727914788e-11,  -1.716257249412354e-13,   1.023072249637917e-15,   1.122021181695043e-17,
  -6.900115740086116e-19,   1.903537619718212e-20,   2.517432577345094e-03,  -2.374972406144427e-05,   2.240162398475381e-07,  -2.109736572696884e-09,   1.964996076318950e-11,
  -1.715654229437982e-13,   1.018226871351195e-15,   1.139091746807737e-17,  -6.939543334529570e-19,   1.908065854897819e-20,   2.517476317651053e-03,  -2.375095960227363e-05,
   2.240392504847643e-07,  -2.110071071786343e-09,   1.965291840276401e-11,  -1.715177563270245e-13,   1.014407128173169e-15,   1.152535728141940e-17,  -6.970549708244289e-19,
   1.911608684431283e-20,   2.517501561719388e-03,  -2.375167268674204e-05,   2.240525308958187e-07,  -2.110264103470519e-09,   1.965462361250940e-11,  -1.714901633329159e-13,
   1.012200113227672e-15,   1.160298252147238e-17,  -6.988434682235727e-19,   1.913644923800594e-20,   2.517511041247066e-03,  -2.375194046266336e-05,   2.240575179209139e-07,
  -2.110336586084409e-09,   1.965526361388073e-11,  -1.714797860736531e-13,   1.011370872197538e-15,   1.163213862566748e-17,  -6.995148883086294e-19,   1.914407963305369e-20,
   2.517512612621271e-03,  -2.375198485065129e-05,   2.240583445969116e-07,  -2.110348600972476e-09,   1.965536968628598e-11,  -1.714780650599651e-13,   1.011233388045652e-15,
   1.163697203911016e-17,  -6.996261763683233e-19,   1.914534364180614e-20,   2.276569263132660e-02,  -2.147501267204698e-04,   2.025271405285686e-06,  -1.906981969051943e-08,
   1.775943465325238e-10,  -1.551249079140016e-12,   9.236781835383128e-15,   1.023519973059304e-16,  -6.290443604489980e-18,   1.742852123096205e-19,   2.276598114748835e-02,
  -2.147582758356789e-04,   2.025423153007136e-06,  -1.907202451478169e-08,   1.776137599586520e-10,  -1.550928819517215e-12,   9.211284279051494e-15,   1.032513740638918e-16,
  -6.311311303622366e-18,   1.745292361896680e-19,   2.276645480910214e-02,  -2.147716546072714e-04,   2.025672283342559e-06,  -1.907564375533644e-08,   1.776455906709926e-10,
  -1.550401114639900e-12,   9.169365934934714e-15,   1.047287355693261e-16,  -6.345547875496515e-18,   1.749279050697741e-19,   2.276695742194238e-02,  -2.147858514422891e-04,
   2.025936646032655e-06,  -1.907948359249631e-08,   1.776793116891473e-10,  -1.549838531957967e-12,   9.124805849353466e-15,   1.062975345864799e-16,  -6.381846622484823e-18,
   1.753482880044530e-19,   2.276735299628240e-02,  -2.147970250952667e-04,   2.026144712541236e-06,  -1.908250523292500e-08,   1.777058112949229e-10,  -1.549393859091413e-12,
   9.089677858811480e-15,   1.075330564766691e-16,  -6.410392860211341e-18,   1.756772197365198e-19,   2.276758129614003e-02,  -2.148034738971369e-04,   2.026264796471349e-06,
  -1.908424894749869e-08,   1.777210890842347e-10,  -1.549136460850138e-12,   9.069381179682309e-15,   1.082464475602026e-16,  -6.426858961075325e-18,   1.758662851154060e-19,
   2.276766702617313e-02,  -2.148058955370645e-04,   2.026309890065251e-06,  -1.908490370444953e-08,   1.777268230862063e-10,  -1.549039659901118e-12,   9.061755109790476e-15,
   1.085143985159190e-16,  -6.433040535239613e-18,   1.759371358272554e-19,   2.276768123721477e-02,  -2.148062969612199e-04,   2.026317365020527e-06,  -1.908501223845536e-08,
   1.777277734229256e-10,  -1.549023606089592e-12,   9.060490744022452e-15,   1.085588186751791e-16,  -6.434065134545649e-18,   1.759488726825277e-19,   6.386973445683251e-02,
  -6.024868587218892e-04,   5.681929836618090e-06,  -5.349866697521767e-08,   4.980766107037258e-10,  -4.341990575417166e-12,   2.543005868372648e-14,   3.062053063761037e-16,
  -1.826690946058737e-17,   5.053940087754537e-19,   6.387054389302850e-02,  -6.025097202813327e-04,   5.682355418504756e-06,  -5.350483783025518e-08,   4.981300125786346e-10,
  -4.341033772813894e-12,   2.535601280224764e-14,   3.088137299450741e-16,  -1.832765744705402e-17,   5.061165372211126e-19,   6.387187275740761e-02,  -6.025472531344849e-04,
   5.683054112745090e-06,  -5.351496728625382e-08,   4.982175654885230e-10,  -4.339457379789555e-12,   2.523427988437084e-14,   3.130985129872746e-16,  -1.842732623497026e-17,
   5.072971341569758e-19,   6.387328284484124e-02,  -6.025870809793863e-04,   5.683795525736480e-06,  -5.352571405802310e-08,   4.983103095718908e-10,  -4.337777027488100e-12,
   2.510487462068412e-14,   3.176485669206910e-16,  -1.853300200222479e-17,   5.085422816913568e-19,   6.387439263423222e-02,  -6.026184275754815e-04,   5.684379053774721e-06,
  -5.353417083384977e-08,   4.983831863560401e-10,  -4.336449020261294e-12,   2.500286031193821e-14,   3.212320576610725e-16,  -1.861611067936796e-17,   5.095167372043423e-19,
   6.387503313269681e-02,  -6.026365190597531e-04,   5.684715832080607e-06,  -5.353905100686788e-08,   4.984251995200035e-10,  -4.335680371343556e-12,   2.494391706380107e-14,
   3.233011892413723e-16,  -1.866405065496852e-17,   5.100769135314944e-19,   6.387527364951036e-02,  -6.026433127338827e-04,   5.684842298113680e-06,  -5.354088348510024e-08,
   4.984409672851562e-10,  -4.335391314447179e-12,   2.492177028782790e-14,   3.240783628665742e-16,  -1.868204810317323e-17,   5.102868488845466e-19,   6.387531351878747e-02,
  -6.026444388900978e-04,   5.684863261797049e-06,  -5.354118724062403e-08,   4.984435805643543e-10,  -4.335343376886329e-12,   2.491809845696107e-14,   3.242072007525213e-16,
  -1.868503120060093e-17,   5.103216266957082e-19,   1.271502109459932e-01,  -1.199414797161408e-03,   1.131137042906042e-05,  -1.064966129692997e-07,   9.910086470887917e-10,
  -8.611063192304876e-12,   4.904339759495482e-14,   6.720738808573524e-16,  -3.840322934204889e-17,   1.060532484968300e-18,   1.271518223399009e-01,  -1.199460306139105e-03,
   1.131221717763995e-05,  -1.065088493676894e-07,   9.911114824857792e-10,  -8.608967154571892e-12,   4.888771577031961e-14,   6.775488552644912e-16,  -3.853152713516552e-17,
   1.062100135677348e-18,   1.271544677910586e-01,  -1.199535020265117e-03,   1.131360731538728e-05,  -1.065289352041348e-07,   9.912800618262406e-10,  -8.605514316306863e-12,
   4.863177001569799e-14,   6.865426305125530e-16,  -3.874203354256856e-17,   1.064662258529515e-18,   1.271572749378199e-01,  -1.199614302856347e-03,   1.131508244440951e-05,
  -1.065502448434377e-07,   9.914586088592557e-10,  -8.601834471896008e-12,   4.835969068203751e-14,   6.960934700089027e-16,  -3.896523948005207e-17,   1.067365306416052e-18,
   1.271594842629630e-01,  -1.199676702385604e-03,   1.131624344049293e-05,  -1.065670134746604e-07,   9.915988880961433e-10,  -8.598926741174550e-12,   4.814520014745117e-14,
   7.036156228906480e-16,  -3.914078874365941e-17,   1.069481329029360e-18,   1.271607593421357e-01,  -1.199712715862530e-03,   1.131691349878322e-05,  -1.065766901093088e-07,
   9.916797504171023e-10,  -8.597243951727127e-12,   4.802126813812752e-14,   7.079590399090185e-16,  -3.924205528495025e-17,   1.070697993920168e-18,   1.271612381535523e-01,
  -1.199726239562545e-03,   1.131716511700932e-05,  -1.065803236171344e-07,   9.917100969494099e-10,  -8.596611162555795e-12,   4.797470297359045e-14,   7.095904580009177e-16,
  -3.928007308003064e-17,   1.071154005990348e-18,   1.271613175237415e-01,  -1.199728481324238e-03,   1.131720682657848e-05,  -1.065809259143716e-07,   9.917151263678313e-10,
  -8.596506222000283e-12,   4.796698268240749e-14,   7.098609111361982e-16,  -3.928637460878464e-17,   1.071229551249433e-18,   2.149033055815511e-01,  -2.027193413540908e-03,
   1.911777261729915e-05,  -1.799773074134534e-07,   1.673548172238205e-09,  -1.446949436146847e-11,   7.880447267066304e-14,   1.298114196806701e-15,  -7.023078848968156e-17,
   1.935804118076674e-18,   2.149060290565088e-01,  -2.027270322438799e-03,   1.911920249867255e-05,  -1.799978643166537e-07,   1.673712999567589e-09,  -1.446545508351002e-11,
   7.851972624256810e-14,   1.308111626417973e-15,  -7.046730719020494e-17,   1.938809710428219e-18,   2.149105002287820e-01,  -2.027396587180771e-03,   1.912154998107266e-05,
  -1.800316075797981e-07,   1.673983148376927e-09,  -1.445880230844727e-11,   7.805158878297096e-14,   1.324535001852798e-15,  -7.085540396407754e-17,   1.943723626045472e-18,
   2.149152446884333e-01,  -2.027530572445949e-03,   1.912404097806788e-05,  -1.800674060419217e-07,   1.674269195949386e-09,  -1.445171376737993e-11,   7.755393472202278e-14,
   1.341976349491098e-15,  -7.126694858502057e-17,   1.948910094196722e-18,   2.149189787481433e-01,  -2.027636025790919e-03,   1.912600150467788e-05,  -1.800955754483911e-07,
   1.674493881158421e-09,  -1.444611372816126e-11,   7.716160957103626e-14,   1.355713520516383e-15,  -7.159064942885217e-17,   1.952971863857762e-18,   2.149211338051579e-01,
  -2.027696887478395e-03,   1.912713300252082e-05,  -1.801118308884524e-07,   1.674623376573455e-09,  -1.444287328651072e-11,   7.693492304906073e-14,   1.363645804440207e-15,
  -7.177738807315172e-17,   1.955307956480478e-18,   2.149219430614856e-01,  -2.027719742119754e-03,   1.912755789869244e-05,  -1.801179346508209e-07,   1.674671970330317e-09,
  -1.444165485210411e-11,   7.684974935942211e-14,   1.366625266244743e-15,  -7.184749597091083e-17,   1.956183662316508e-18,   2.149220772078852e-01,  -2.027723530628621e-03,
   1.912762833170925e-05,  -1.801189464200680e-07,   1.674680023696625e-09,  -1.444145279388175e-11,   7.683562792960818e-14,   1.367119197402609e-15,  -7.185911660154388e-17,
   1.956328742857294e-18,   3.309640944974930e-01,  -3.121998105429888e-03,   2.944212845326022e-05,  -2.771338940527021e-07,   2.574107629140258e-09,  -2.208729770482676e-11,
   1.117991877593624e-13,   2.381685217054798e-15,  -1.208324137840027e-16,   3.326884664008316e-18,   3.309682887512230e-01,  -3.122116530808947e-03,   2.944432765596579e-05,
  -2.771652632321172e-07,   2.574340443556350e-09,  -2.207990511878891e-11,   1.113091589801408e-13,   2.398877072651929e-15,  -1.212451254647282e-16,   3.332428910817105e-18,
   3.309751745241489e-01,  -3.122310954905573e-03,   2.944793814505664e-05,  -2.772167530999005e-07,   2.574721885505749e-09,  -2.206773176168176e-11,   1.105035102918505e-13,
   2.427120565647498e-15,  -1.219223984204395e-16,   3.341497514519394e-18,   3.309824811694546e-01,  -3.122517267041778e-03,   2.945176934567933e-05,  -2.772713773201519e-07,
   2.575125590177196e-09,  -2.205476426518973e-11,   1.096470417570931e-13,   2.457116588669582e-15,  -1.226406805813957e-16,   3.351074821502400e-18,   3.309882317607510e-01,
  -3.122679645292194e-03,   2.945478465998528e-05,  -2.773143592431732e-07,   2.575442557919909e-09,  -2.204452210550432e-11,   1.089718289870008e-13,   2.480743469519923e-15,
  -1.232057114619735e-16,   3.358579424403909e-18,   3.309915506288487e-01,  -3.122773360769530e-03,   2.945652491259913e-05,  -2.773391618893594e-07,   2.575625185322887e-09,
  -2.203859644881691e-11,   1.085816825988374e-13,   2.494386944983858e-15,  -1.235316963628396e-16,   3.362897309859847e-18,   3.309927969137218e-01,  -3.122808552583979e-03,
   2.945717840529278e-05,  -2.773484749502232e-07,   2.575693706828381e-09,  -2.203636852547421e-11,   1.084350903265623e-13,   2.499511704433304e-15,  -1.236540868968038e-16,
   3.364516227043250e-18,   3.309930035041702e-01,  -3.122814386168977e-03,   2.945728673161613e-05,  -2.773500186927839e-07,   2.575705062246214e-09,  -2.203599906859729e-11,
   1.084107858947068e-13,   2.500361285680916e-15,  -1.236743738200755e-16,   3.364784454217396e-18,   4.819991693763734e-01,  -4.546712876923263e-03,   4.287711693867657e-05,
  -4.035088245135398e-07,   3.741402561477347e-09,  -3.171686656146705e-11,   1.407209979379858e-13,   4.362463616830670e-15,  -2.060190952976605e-16,   5.680620945320120e-18,
   4.820052775326322e-01,  -4.546885302765411e-03,   4.288031315363502e-05,  -4.035538454726793e-07,   3.741692995127808e-09,  -3.170335942632664e-11,   1.398851164355148e-13,
   4.391846481513838e-15,  -2.067410707530943e-16,   5.691124309925491e-18,   4.820153053890047e-01,  -4.547168381564732e-03,   4.288556043399084e-05,  -4.036277405762490e-07,
   3.742168491355479e-09,  -3.168112162822166e-11,   1.385108039199148e-13,   4.440121709799744e-15,  -2.079260348415507e-16,   5.708315237335235e-18,   4.820259461672837e-01,
  -4.547468768904047e-03,   4.289112844308292e-05,  -4.037061298109837e-07,   3.742671264272898e-09,  -3.165743905456734e-11,   1.370497287265976e-13,   4.491397677302369e-15,
  -2.091829933586488e-16,   5.726485236434563e-18,   4.820343208398230e-01,  -4.547705188968253e-03,   4.289551066825713e-05,  -4.037678086345064e-07,   3.743065669667983e-09,
  -3.163873804346825e-11,   1.358978110095232e-13,   4.531789857533108e-15,  -2.101719468237853e-16,   5.740733652173540e-18,   4.820391541570342e-01,  -4.547841637081252e-03,
   4.289803980523388e-05,  -4.038033991020462e-07,   3.743292775377835e-09,  -3.162792017878715e-11,   1.352321976069477e-13,   4.555116068751001e-15,  -2.107425777269522e-16,
   5.748936016453245e-18,   4.820409691402671e-01,  -4.547892875738494e-03,   4.289898953437214e-05,  -4.038167626192875e-07,   3.743377958746275e-09,  -3.162385320887029e-11,
   1.349820983393067e-13,   4.563878142677259e-15,  -2.109568336843293e-16,   5.752012172796965e-18,   4.820412700010128e-01,  -4.547901369333897e-03,   4.289914696625935e-05,
  -4.038189777577520e-07,   3.743392073985955e-09,  -3.162317879955576e-11,   1.349406326389324e-13,   4.565330732100790e-15,  -2.109923485312668e-16,   5.752521883186799e-18,
   6.810616242610444e-01,  -6.424462392464582e-03,   6.058296100049273e-05,  -5.699277436935777e-07,   5.268621166385486e-09,  -4.370896066811092e-11,   1.436372835007693e-13,
   8.439239645650915e-15,  -3.693961862020911e-16,   1.027382881486161e-17,   6.810702547112787e-01,  -6.424705926104915e-03,   6.058746120848200e-05,  -5.699897238465604e-07,
   5.268909915075146e-09,  -4.368288851462134e-11,   1.421371147051577e-13,   8.492471721990697e-15,  -3.707584691553046e-16,   1.029619750168330e-17,   6.810844234556706e-01,
  -6.425105745074686e-03,   6.059484920093561e-05,  -5.700914471288168e-07,   5.269381613174066e-09,  -4.363997148357952e-11,   1.396704210326244e-13,   8.579943031407459e-15,
  -3.729949385795344e-16,   1.033284130375510e-17,   6.810994582186520e-01,  -6.425530009838715e-03,   6.060268866591211e-05,  -5.701993464021453e-07,   5.269878951846875e-09,
  -4.359427629918402e-11,   1.370477355251769e-13,   8.672868464096500e-15,  -3.753680795313594e-16,   1.037161685537960e-17,   6.811112911123615e-01,  -6.425863927212498e-03,
   6.060885853483371e-05,  -5.702842368632744e-07,   5.270268062596369e-09,  -4.355820027429921e-11,   1.349798070438626e-13,   8.746081952943690e-15,  -3.772358000499745e-16,
   1.040205616173770e-17,   6.811181202895941e-01,  -6.426056644983295e-03,   6.061241935429105e-05,  -5.703332180350577e-07,   5.270491704245565e-09,  -4.353733450331237e-11,
   1.337848173018962e-13,   8.788367190037269e-15,  -3.783137141031601e-16,   1.041959222917358e-17,   6.811206847481217e-01,  -6.426129013844728e-03,   6.061375649013088e-05,
  -5.703516089138396e-07,   5.270575509581350e-09,  -4.352949057854212e-11,   1.333357942229368e-13,   8.804251817328081e-15,  -3.787184842827767e-16,   1.042617131790731e-17,
   6.811211098456534e-01,  -6.426141010094403e-03,   6.061397814020651e-05,  -5.703546573576627e-07,   5.270589392316275e-09,  -4.352818988090411e-11,   1.332613467871298e-13,
   8.806885243366751e-15,  -3.787855808708926e-16,   1.042726158565302e-17,   9.618216817325191e-01,  -9.072838375730969e-03,   8.555133614475155e-05,  -8.041878940384231e-07,
   7.385208760925018e-09,  -5.822846878763733e-11,   2.298857048019041e-14,   1.960867237426745e-14,  -7.988835011484319e-16,   2.297055038743849e-17,   9.618338689970373e-01,
  -9.073181992100849e-03,   8.555764200054796e-05,  -8.042702447578948e-07,   7.385219094887853e-09,  -5.816795577910011e-11,   1.973592011962084e-14,   1.972817574049142e-14,
  -8.022253920660838e-16,   2.303854407765175e-17,   9.618538770133565e-01,  -9.073746119290529e-03,   8.556799407769688e-05,  -8.044053737539655e-07,   7.385231004335123e-09,
  -5.806835456367131e-11,   1.438652432745511e-14,   1.992461109265924e-14,  -8.077149521168419e-16,   2.315009519325197e-17,   9.618751079474770e-01,  -9.074344736225532e-03,
   8.557897842223046e-05,  -8.045486702422240e-07,   7.385236762217770e-09,  -5.796231724116432e-11,   8.697289951117744e-15,   2.013338548741555e-14,  -8.135442758196279e-16,
   2.326836162899205e-17,   9.618918174431160e-01,  -9.074815875787822e-03,   8.558762315093457e-05,  -8.046613830794012e-07,   7.385236306697615e-09,  -5.787860968678598e-11,
   4.210335069970724e-15,   2.029793903005426e-14,  -8.181352125771470e-16,   2.336136648651188e-17,   9.619014610759079e-01,  -9.075087789616023e-03,   8.559261218919313e-05,
  -8.047264068699186e-07,   7.385234042647759e-09,  -5.783019787626420e-11,   1.617017248111169e-15,   2.039300506722487e-14,  -8.207860219124010e-16,   2.341501258620436e-17,
   9.619050824043252e-01,  -9.075189897847249e-03,   8.559448562191351e-05,  -8.047508192215840e-07,   7.385232813981612e-09,  -5.781199936893469e-11,   6.424806279350938e-16,
   2.042872201125204e-14,  -8.217816705004583e-16,   2.343515176070667e-17,   9.619056826938989e-01,  -9.075206823847555e-03,   8.559479617016163e-05,  -8.047548656687577e-07,
   7.385232590339251e-09,  -5.780898168266550e-11,   4.808992472521411e-16,   2.043464359245652e-14,  -8.219467263297835e-16,   2.343848982808443e-17,   2.425739662444546e-03,
  -2.205035811447413e-05,   2.004153670567370e-07,  -1.820483099448432e-09,   1.646786573369459e-11,  -1.452366887820734e-13,   1.115799324048209e-15,  -2.428232849452297e-18,
  -2.176643100268164e-19,   8.037169617984812e-21,   2.425768211327114e-03,  -2.205113604922726e-05,   2.004294414755214e-07,  -1.820689836918622e-09,   1.647023688424013e-11,
  -1.452432750093384e-13,   1.114906229343683e-15,  -2.386366464134295e-18,  -2.189058063960857e-19,   8.062946693695112e-21,   2.425815080389486e-03,  -2.205241321887169e-05,
   2.004525483724226e-07,  -1.821029236439210e-09,   1.647412812004945e-11,  -1.452539964858109e-13,   1.113436486923804e-15,  -2.317540758242956e-18,  -2.209452052207670e-19,
   8.105238510085159e-21,   2.425864814059760e-03,  -2.205376848135269e-05,   2.004770685606982e-07,  -1.821389374352395e-09,   1.647825512770927e-11,  -1.452652491721027e-13,
   1.111872105097863e-15,  -2.244381952458544e-18,  -2.231109010553972e-19,   8.150078593458769e-21,   2.425903956147998e-03,  -2.205483514287913e-05,   2.004963675144060e-07,
  -1.821672811106777e-09,   1.648150173052360e-11,  -1.452740154957597e-13,   1.110637399677976e-15,  -2.186711931127600e-18,  -2.248165674811787e-19,   8.185342582209905e-21,
   2.425926546385120e-03,  -2.205545075929075e-05,   2.005075058937462e-07,  -1.821836390521938e-09,   1.648337485697826e-11,  -1.452790387673741e-13,   1.109923412037898e-15,
  -2.153391905572542e-18,  -2.258014414678880e-19,   8.205683877046535e-21,   2.425935029352026e-03,  -2.205568193413557e-05,   2.005116885747607e-07,  -1.821897816694003e-09,
   1.648407813025230e-11,  -1.452809182583197e-13,   1.109655035067993e-15,  -2.140872812998477e-18,  -2.261713658723939e-19,   8.213320291932695e-21,   2.425936435530923e-03,
  -2.205572025492623e-05,   2.005123819197489e-07,  -1.821907998986286e-09,   1.648419470235749e-11,  -1.452812294521633e-13,   1.109610533629825e-15,  -2.138797220132845e-18,
  -2.262326911146590e-19,   8.214586034286337e-21,   2.193771235092622e-02,  -1.994172773977598e-04,   1.812499640506306e-06,  -1.646383412531399e-08,   1.489223159331477e-10,
  -1.312955628429761e-12,   1.006464687333673e-14,  -2.086542373074153e-17,  -2.006638096685051e-18,   7.380100687447302e-20,   2.193797053889420e-02,  -1.994243127741519e-04,
   1.812626918063443e-06,  -1.646570302646623e-08,   1.489437018969001e-10,  -1.313011827279057e-12,   1.005641434013944e-14,  -2.048097246670273e-17,  -2.018041435749854e-18,
   7.403824910688855e-20,   2.193839440935297e-02,  -1.994358630602663e-04,   1.812835877945484e-06,  -1.646877118549852e-08,   1.489787975905666e-10,  -1.313103252227649e-12,
   1.004286639411366e-14,  -1.984895673270955e-17,  -2.036773757430958e-18,   7.442749191232229e-20,   2.193884418650906e-02,  -1.994481195909969e-04,   1.813057618430607e-06,
  -1.647202681409647e-08,   1.490160193732544e-10,  -1.313199125887229e-12,   1.002844622940306e-14,  -1.917714806468595e-17,  -2.056666312379475e-18,   7.484019550093879e-20,
   2.193919817641156e-02,  -1.994577661130821e-04,   1.813232142314623e-06,  -1.647458906465020e-08,   1.490453004477924e-10,  -1.313273756171395e-12,   1.001706507132018e-14,
  -1.864756907670018e-17,  -2.072333483146627e-18,   7.516476690857258e-20,   2.193940247608446e-02,  -1.994633335372942e-04,   1.813332868653515e-06,  -1.647606781096732e-08,
   1.490621940448781e-10,  -1.313316496683759e-12,   1.001048378500710e-14,  -1.834159326386788e-17,  -2.081379960184447e-18,   7.535199123904383e-20,   2.193947919362192e-02,
  -1.994654242034830e-04,   1.813370693376728e-06,  -1.647662309894780e-08,   1.490685367968561e-10,  -1.313332483749802e-12,   1.000800998932912e-14,  -1.822663102970589e-17,
  -2.084777878865848e-18,   7.542227834473976e-20,   2.193949191070350e-02,  -1.994657707635995e-04,   1.813376963417783e-06,  -1.647671514609128e-08,   1.490695881480293e-10,
  -1.313335130541046e-12,   1.000759979264263e-14,  -1.820757095072335e-17,  -2.085341178728999e-18,   7.543392851408663e-20,   6.154681484479090e-02,  -5.594702532681675e-04,
   5.085008415572146e-06,  -4.618908102044814e-08,   4.177555672088880e-10,  -3.680441137787299e-12,   2.808130869569080e-14,  -5.207079370583061e-17,  -5.855404879706998e-18,
   2.136646340305631e-19,   6.154753919684040e-02,  -5.594899909128602e-04,   5.085365451547237e-06,  -4.619431970553326e-08,   4.178152235653579e-10,  -3.680578923313696e-12,
   2.805729094617512e-14,  -5.095765974565951e-17,  -5.888442180542762e-18,   2.143548729543750e-19,   6.154872837477412e-02,  -5.595223950687562e-04,   5.085951620626470e-06,
  -4.620291998947161e-08,   4.179131217101369e-10,  -3.680802704128828e-12,   2.801776657219083e-14,  -4.912771907502234e-17,  -5.942713471015030e-18,   2.154873786548910e-19,
   6.154999023451277e-02,  -5.595567805814782e-04,   5.086573641250256e-06,  -4.621204573694296e-08,   4.180169482715268e-10,  -3.681036865709140e-12,   2.797569851065226e-14,
  -4.718254469762591e-17,  -6.000347213624508e-18,   2.166881876081636e-19,   6.155098336099250e-02,  -5.595838437527720e-04,   5.087063210888823e-06,  -4.621922787850881e-08,
   4.180986233778350e-10,  -3.681218769728639e-12,   2.794249681435810e-14,  -4.564917387157433e-17,  -6.045739696027267e-18,   2.176325975945740e-19,   6.155155652822933e-02,
  -5.595994630763310e-04,   5.087345765583598e-06,  -4.622337288474664e-08,   4.181457448492121e-10,  -3.681322794338456e-12,   2.792329780779971e-14,  -4.476323044715392e-17,
  -6.071950345080560e-18,   2.181773796439449e-19,   6.155177176097180e-02,  -5.596053284082723e-04,   5.087451870418256e-06,  -4.622492938557349e-08,   4.181634366248429e-10,
  -3.681361675872595e-12,   2.791608127039715e-14,  -4.443035994114047e-17,  -6.081795300533708e-18,   2.183819022415237e-19,   6.155180743902450e-02,  -5.596063006773602e-04,
   5.087469458957744e-06,  -4.622518739837916e-08,   4.181663691418293e-10,  -3.681368111506237e-12,   2.791488465039851e-14,  -4.437517187092954e-17,  -6.083427379660637e-18,
   2.184158022271386e-19,   1.225258037840775e-01,  -1.113778767088875e-03,   1.012308411179298e-05,  -9.194999141360653e-08,   8.314953513964582e-10,  -7.316883263811345e-12,
   5.539749259202960e-14,  -8.253247989380115e-17,  -1.239655676041341e-17,   4.471207524631185e-19,   1.225272458023912e-01,  -1.113818059359480e-03,   1.012379474543128e-05,
  -9.196040560920523e-08,   8.316129975347661e-10,  -7.317092600011494e-12,   5.534665910100309e-14,  -8.020277898962829e-17,  -1.246578501111575e-17,   4.485771683962825e-19,
   1.225296131821046e-01,  -1.113882567196688e-03,   1.012496143800498e-05,  -9.197750239697473e-08,   8.318060535203325e-10,  -7.317431201661852e-12,   5.526300787948468e-14,
  -7.637281416379818e-17,  -1.257951076792799e-17,   4.509668853463634e-19,   1.225321252545508e-01,  -1.113951019368675e-03,   1.012619948743669e-05,  -9.199564367953679e-08,
   8.320107930462454e-10,  -7.317783604072734e-12,   5.517397577622317e-14,  -7.230161101896067e-17,  -1.270028608281562e-17,   4.535008805185143e-19,   1.225341023408856e-01,
  -1.114004894752576e-03,   1.012717391009824e-05,  -9.200992115702835e-08,   8.321718459486286e-10,  -7.318055960209009e-12,   5.510371023614045e-14,  -6.909225888587860e-17,
  -1.279541158204698e-17,   4.554939215238711e-19,   1.225352433849805e-01,  -1.114035988558773e-03,   1.012773629702543e-05,  -9.201816104501382e-08,   8.322647613453908e-10,
  -7.318211141806920e-12,   5.506307969797303e-14,  -6.723795763329571e-17,  -1.285034022776700e-17,   4.566436492845848e-19,   1.225356718638492e-01,  -1.114047664831983e-03,
   1.012794748430528e-05,  -9.202125521926706e-08,   8.322996460639640e-10,  -7.318269035736556e-12,   5.504780760628877e-14,  -6.654124819038708e-17,  -1.287097211473420e-17,
   4.570752894775745e-19,   1.225357428906431e-01,  -1.114049600354049e-03,   1.012798249190447e-05,  -9.202176812369521e-08,   8.323054283920765e-10,  -7.318278612522072e-12,
   5.504527525127386e-14,  -6.642573748122217e-17,  -1.287439244232009e-17,   4.571468350480458e-19,   2.070873525562763e-01,  -1.882456218880752e-03,   1.710951293475494e-05,
  -1.554043744282177e-07,   1.404941830375931e-09,  -1.234093545336451e-11,   9.232993014289715e-14,  -8.497832355952866e-17,  -2.287021691660341e-17,   8.124836060866491e-19,
   2.070897897802765e-01,  -1.882522626483991e-03,   1.711071364579028e-05,  -1.554219379953382e-07,   1.405137801386565e-09,  -1.234112159557554e-11,   9.223618143838232e-14,
  -8.074397830060864e-17,  -2.299632896297958e-17,   8.151648350204515e-19,   2.070937910017189e-01,  -1.882631650735493e-03,   1.711268492792474e-05,  -1.554507715972756e-07,
   1.405459373487272e-09,  -1.234141798508537e-11,   9.208191371871534e-14,  -7.378270159024759e-17,  -2.320350864588426e-17,   8.195645566023546e-19,   2.070980367752001e-01,
  -1.882747341263880e-03,   1.711477677455285e-05,  -1.554813664952258e-07,   1.405800387565078e-09,  -1.234171997133180e-11,   9.191772874006215e-14,  -6.638277946146154e-17,
  -2.342354065810518e-17,   8.242303269397064e-19,   2.071013783430929e-01,  -1.882838395654802e-03,   1.711642318749205e-05,  -1.555054449943050e-07,   1.406068623274928e-09,
  -1.234194857220361e-11,   9.178815572067615e-14,  -6.054925275342698e-17,  -2.359685019469923e-17,   8.279003571224329e-19,   2.071033068761132e-01,  -1.882890947063738e-03,
   1.711737341214236e-05,  -1.555193412271966e-07,   1.406223369481213e-09,  -1.234207686593624e-11,   9.171323280201922e-14,  -5.717870355342640e-17,  -2.369692777223974e-17,
   8.300176130454976e-19,   2.071040310686723e-01,  -1.882910681044735e-03,   1.711773023993314e-05,  -1.555245594120540e-07,   1.406281467273441e-09,  -1.234212435384737e-11,
   9.168507131512736e-14,  -5.591229050073270e-17,  -2.373451870271430e-17,   8.308125135729168e-19,   2.071041511144420e-01,  -1.882913952255885e-03,   1.711778938972101e-05,
  -1.555254244014743e-07,   1.406291097236365e-09,  -1.234213218936233e-11,   9.168040171122721e-14,  -5.570232546395555e-17,  -2.374075050710643e-17,   8.309442717750748e-19,
   3.189270594470217e-01,  -2.899095887908112e-03,   2.634957647308397e-05,  -2.393202858653073e-07,   2.162746829278311e-09,  -1.894637676057807e-11,   1.391738744623953e-13,
  -3.489257688429620e-18,  -3.973691063969841e-17,   1.386191616111499e-18,   3.189308129022777e-01,  -2.899198154263482e-03,   2.635142479289602e-05,  -2.393472469558950e-07,
   2.163041970587717e-09,  -1.894627144746309e-11,   1.390110477422376e-13,   3.737584798341331e-18,  -3.995306216628135e-17,   1.390860631254671e-18,   3.189369749971147e-01,
  -2.899366049361042e-03,   2.635445929061891e-05,  -2.393915077941620e-07,   2.163526239212290e-09,  -1.894608286729390e-11,   1.387431172542918e-13,   1.561888573160087e-17,
  -4.030817950810685e-17,   1.398522974848711e-18,   3.189435137150338e-01,  -2.899544210350056e-03,   2.635767937399409e-05,  -2.394384717445544e-07,   2.164039740457113e-09,
  -1.894586142233666e-11,   1.384579737009747e-13,   2.824932950781683e-17,  -4.068535201841425e-17,   1.406649738074442e-18,   3.189486599079636e-01,  -2.899684432176587e-03,
   2.636021377512822e-05,  -2.394754324541689e-07,   2.164443618288486e-09,  -1.894567167218157e-11,   1.382329494839704e-13,   3.820654029998599e-17,  -4.098245274817991e-17,
   1.413042922125176e-18,   3.189516299517244e-01,  -2.899765360218404e-03,   2.636167649915002e-05,  -2.394967631335379e-07,   2.164676603593955e-09,  -1.894555595648427e-11,
   1.381028370793611e-13,   4.395984842816159e-17,  -4.115402097638121e-17,   1.416731492189409e-18,   3.189527452469025e-01,  -2.899795750123516e-03,   2.636222578008996e-05,
  -2.395047730024550e-07,   2.164764072883194e-09,  -1.894551133023732e-11,   1.380539319680549e-13,   4.612155927785800e-17,  -4.121846648186965e-17,   1.418116385022717e-18,
   3.189529301237922e-01,  -2.899800787718025e-03,   2.636231683198146e-05,  -2.395061007521714e-07,   2.164778571166654e-09,  -1.894550387085677e-11,   1.380458227866590e-13,
   4.647996165457705e-17,  -4.122915029757707e-17,   1.418345940150359e-18,   4.644690599042413e-01,  -4.222093561652478e-03,   3.837393288497898e-05,  -3.485073164321425e-07,
   3.147580206716006e-09,  -2.745797947714575e-11,   1.957918469128747e-13,   2.884388719079002e-16,  -6.839302610950749e-17,   2.337659154335234e-18,   4.644745262061368e-01,
  -4.222242485120150e-03,   3.837662277506622e-05,  -3.485463820479494e-07,   3.147994807007726e-09,  -2.745692217667952e-11,   1.955116872406537e-13,   3.006333757266309e-16,
  -6.876072762095623e-17,   2.345800381721819e-18,   4.644835003026977e-01,  -4.222486979154129e-03,   3.838103891991506e-05,  -3.486105134115192e-07,   3.148675004181146e-09,
  -2.745515996419958e-11,   1.950506978739515e-13,   3.206827555843930e-16,  -6.936487861481350e-17,   2.359163126108321e-18,   4.644930228897066e-01,  -4.222746422611959e-03,
   3.838572513726570e-05,  -3.486785601437690e-07,   3.149396152076957e-09,  -2.745325409253597e-11,   1.945601084752407e-13,   3.419976390721427e-16,  -7.000662053624419e-17,
   2.373338703618798e-18,   4.645005174886782e-01,  -4.222950617844476e-03,   3.838941346560109e-05,  -3.487321121086314e-07,   3.149963268568288e-09,  -2.745172804810057e-11,
   1.941729658755573e-13,   3.588022033939103e-16,  -7.051217404291826e-17,   2.384492495214508e-18,   4.645048428777169e-01,  -4.223068467663301e-03,   3.839154217244367e-05,
  -3.487630175214530e-07,   3.150290389708633e-09,  -2.745083686120474e-11,   1.939491187487240e-13,   3.685123254975316e-16,  -7.080413862292375e-17,   2.390928561771466e-18,
   4.645064671249942e-01,  -4.223112722341320e-03,   3.839234154200984e-05,  -3.487746227213703e-07,   3.150413194246407e-09,  -2.745050023033436e-11,   1.938649826003644e-13,
   3.721608180775805e-16,  -7.091381194135905e-17,   2.393345176768213e-18,   4.645067363683206e-01,  -4.223120058235087e-03,   3.839247404995856e-05,  -3.487765464446159e-07,
   3.150433549130417e-09,  -2.745044432439827e-11,   1.938510316440481e-13,   3.727657263853787e-16,  -7.093199385234840e-17,   2.393745755114949e-18,   6.562917250354320e-01,
  -5.965787077075303e-03,   5.422154467204315e-05,  -4.923757756372291e-07,   4.442408278103857e-09,  -3.847260814664870e-11,   2.597687620195723e-13,   1.137364345027688e-15,
  -1.232835596033073e-16,   4.129348018438913e-18,   6.562994487937366e-01,  -5.965997476450742e-03,   5.422534090063554e-05,  -4.924304930535491e-07,   4.442956764762640e-09,
  -3.846886374079374e-11,   2.592637818370888e-13,   1.158929287266713e-15,  -1.239448368773332e-16,   4.144617194308035e-18,   6.563121289843723e-01,  -5.966342897964039e-03,
   5.423157336101724e-05,  -4.925203165548673e-07,   4.443856407955970e-09,  -3.846266984467038e-11,   2.584328644394547e-13,   1.194388188037809e-15,  -1.250315085320454e-16,
   4.169686315404333e-18,   6.563255841786291e-01,  -5.966709439838719e-03,   5.423818694062414e-05,  -4.926156207788509e-07,   4.444809928474401e-09,  -3.845603390452466e-11,
   2.575485983448592e-13,   1.232089693940688e-15,  -1.261860142308005e-16,   4.196289600269084e-18,   6.563361738724006e-01,  -5.966997926838016e-03,   5.424339219352773e-05,
  -4.926906217348227e-07,   4.445559577826612e-09,  -3.845076518408944e-11,   2.568507935459810e-13,   1.261816637729425e-15,  -1.270956740273550e-16,   4.217228615585856e-18,
   6.563422855461605e-01,  -5.967164424987626e-03,   5.424639637937649e-05,  -4.927339046552147e-07,   4.445991903523947e-09,  -3.844770596558845e-11,   2.564473216176904e-13,
   1.278994950840104e-15,  -1.276210799621070e-16,   4.229313739396268e-18,   6.563445805696170e-01,  -5.967226947957451e-03,   5.424752450609296e-05,  -4.927501575193831e-07,
   4.446154187176003e-09,  -3.844655369287978e-11,   2.562956711160300e-13,   1.285449795662642e-15,  -1.278184550951982e-16,   4.233851972908288e-18,   6.563449610041450e-01,
  -5.967237312101058e-03,   5.424771151056563e-05,  -4.927528516482627e-07,   4.446181084903320e-09,  -3.844636250219090e-11,   2.562705253411020e-13,   1.286520001076442e-15,
  -1.278511770664844e-16,   4.234604257865736e-18,   9.268407517176765e-01,  -8.425107495416527e-03,   7.657213151443694e-05,  -6.951679056366262e-07,   6.258478480085778e-09,
  -5.333834234336673e-11,   3.139751665308808e-13,   3.959637803720404e-15,  -2.631278690599244e-16,   8.717924274152924e-18,   9.268516592482235e-01,  -8.425404545680963e-03,
   7.657747899719138e-05,  -6.952437032592216e-07,   6.259135835283110e-09,  -5.332577758888139e-11,   3.128963113572084e-13,   4.005290874711616e-15,  -2.645894950205204e-16,
   8.754779494689599e-18,   9.268695662760751e-01,  -8.425892225143616e-03,   7.658625815741233e-05,  -6.953681240978386e-07,   6.260213309497553e-09,  -5.330505125281314e-11,
   3.111209680026821e-13,   4.080374559707225e-15,  -2.669921989899389e-16,   8.815324119172105e-18,   9.268885677658197e-01,  -8.426409722518817e-03,   7.659557407052603e-05,
  -6.955001261925803e-07,   6.261354305061894e-09,  -5.328292394510039e-11,   3.092314402053887e-13,   4.160230131851170e-15,  -2.695460125192907e-16,   8.879621940493406e-18,
   9.269035225805740e-01,  -8.426817018676112e-03,   7.660290613768262e-05,  -6.956039994353621e-07,   6.262250615267621e-09,  -5.326541172013128e-11,   3.077402038158373e-13,
   4.223211605745587e-15,  -2.715590319105657e-16,   8.930264560428227e-18,   9.269121535140612e-01,  -8.427052086473416e-03,   7.660713777503345e-05,  -6.956639414494398e-07,
   6.262767227352597e-09,  -5.325526578033071e-11,   3.068779100467575e-13,   4.259613469216469e-15,  -2.727220489188359e-16,   8.959507353498833e-18,   9.269153945565139e-01,
  -8.427140358511501e-03,   7.660872682678754e-05,  -6.956864492748054e-07,   6.262961094323992e-09,  -5.325144844736653e-11,   3.065537939633135e-13,   4.273292944427401e-15,
  -2.731590122590286e-16,   8.970491321745642e-18,   9.269159318078605e-01,  -8.427154990957255e-03,   7.660899023643539e-05,  -6.956901802163942e-07,   6.262993223899504e-09,
  -5.325081527761053e-11,   3.065000503984525e-13,   4.275561052118041e-15,  -2.732314577884900e-16,   8.972312230291748e-18,   2.340612563461788e-03,  -2.053015057585863e-05,
   1.800592511669487e-07,  -1.578814436456302e-09,   1.382231161496286e-11,  -1.198395783035433e-13,   9.847322800932054e-16,  -5.990694869767516e-18,  -3.590007536564645e-20,
   2.787563882770413e-21,   2.340638210973853e-03,  -2.053082520959804e-05,   1.800710651641382e-07,  -1.578985125935582e-09,   1.382441178813530e-11,  -1.198572462985821e-13,
   9.845781863050122e-16,  -5.976041366803534e-18,  -3.643121736327465e-20,   2.801427618972079e-21,   2.340680316734092e-03,  -2.053193278280371e-05,   1.800904610486276e-07,
  -1.579265358423544e-09,   1.382785931875158e-11,  -1.198862192778755e-13,   9.843236796932409e-16,  -5.951933815447635e-18,  -3.730439447990250e-20,   2.824202866999248e-21,
   2.340724995856105e-03,  -2.053310807526212e-05,   1.801110433426761e-07,  -1.579562731311611e-09,   1.383151708290283e-11,  -1.199169184403952e-13,   9.840515380369908e-16,
  -5.926283877018173e-18,  -3.823256251871723e-20,   2.848390412261885e-21,   2.340760159759099e-03,  -2.053403308850847e-05,   1.801272429916057e-07,  -1.579796783105141e-09,
   1.383439552090211e-11,  -1.199410473660869e-13,   9.838358460445335e-16,  -5.906046560471763e-18,  -3.896423679993488e-20,   2.867441469273515e-21,   2.340780454015847e-03,
  -2.053456695254838e-05,   1.801365926369859e-07,  -1.579931866089572e-09,   1.383605662657078e-11,  -1.199549600077365e-13,   9.837107581591122e-16,  -5.894346886046095e-18,
  -3.938698166524041e-20,   2.878442335556671e-21,   2.340788074801924e-03,  -2.053476742773698e-05,   1.801401036184195e-07,  -1.579982592438231e-09,   1.383668036985760e-11,
  -1.199601819533295e-13,   9.836636714706215e-16,  -5.889949699667418e-18,  -3.954581752400417e-20,   2.882574426609666e-21,   2.340789338061092e-03,  -2.053480065957653e-05,
   1.801406856189447e-07,  -1.579991001127535e-09,   1.383678376326334e-11,  -1.199610474394443e-13,   9.836558601127719e-16,  -5.889220600363068e-18,  -3.957215163913374e-20,
   2.883259440801860e-21,   2.116784664488488e-02,  -1.856689492870797e-04,   1.628405338571668e-06,  -1.427832770826629e-08,   1.250027362694548e-10,  -1.083642602749793e-12,
   8.897660712047345e-15,  -5.383097421010033e-17,  -3.374496480851833e-19,   2.561070761600566e-20,   2.116807859378241e-02,  -1.856750504729702e-04,   1.628512178922020e-06,
  -1.427987114933408e-08,   1.250217119841846e-10,  -1.083801315843854e-12,   8.896214753573854e-15,  -5.369634745275717e-17,  -3.423231496298229e-19,   2.573800048559496e-20,
   2.116845938645486e-02,  -1.856850670339163e-04,   1.628687586358861e-06,  -1.428240512006197e-08,   1.250528614068606e-10,  -1.084061576054341e-12,   8.893826878345088e-15,
  -5.347486338916015e-17,  -3.503350312672352e-19,   2.594711775347425e-20,   2.116886345188829e-02,  -1.856956960274415e-04,   1.628873723121964e-06,  -1.428509407944170e-08,
   1.250859102356389e-10,  -1.084337333452383e-12,   8.891273976725847e-15,  -5.323920927958646e-17,  -3.588515279781722e-19,   2.616920438006464e-20,   2.116918146435258e-02,
  -1.857040615705481e-04,   1.629020225255649e-06,  -1.428721046419002e-08,   1.251119175719645e-10,  -1.084554066789594e-12,   8.889250927849459e-15,  -5.305328291057676e-17,
  -3.655651081806462e-19,   2.634412991686605e-20,   2.116936499991168e-02,  -1.857088896772054e-04,   1.629104779120582e-06,  -1.428843193514040e-08,   1.251269260030530e-10,
  -1.084679031771818e-12,   8.888077809616108e-15,  -5.294579455759060e-17,  -3.694440756278988e-19,   2.644513970837003e-20,   2.116943392016091e-02,  -1.857107027148283e-04,
   1.629136530810645e-06,  -1.428889062170631e-08,   1.251325616455610e-10,  -1.084725935410503e-12,   8.887636237363343e-15,  -5.290539633198256e-17,  -3.709015034456383e-19,
   2.648308061507540e-20,   2.116944534472209e-02,  -1.857110032536418e-04,   1.629141794153812e-06,  -1.428896665620718e-08,   1.251334958248592e-10,  -1.084733709201348e-12,
   8.887562984788861e-15,  -5.289869788642841e-17,  -3.711431371175754e-19,   2.648937042880963e-20,   5.938693693391077e-02,  -5.208989924143655e-04,   4.568531404001373e-06,
  -4.005804255458402e-08,   3.506843301097838e-10,  -3.039286574945846e-12,   2.491560263504517e-14,  -1.489769470778056e-16,  -1.022187384076987e-18,   7.422219765542212e-20,
   5.938758767224750e-02,  -5.209161093696885e-04,   4.568831134754490e-06,  -4.006237138302708e-08,   3.507374629234116e-10,  -3.039725530946356e-12,   2.491123663174076e-14,
  -1.485867969247922e-16,  -1.036275205845895e-18,   7.459070024055417e-20,   5.938865599545418e-02,  -5.209442109595648e-04,   4.569323224083425e-06,  -4.006947830459855e-08,
   3.508246821460684e-10,  -3.040445299092749e-12,   2.490402836965347e-14,  -1.479449345258362e-16,  -1.059435331050835e-18,   7.519608662778989e-20,   5.938978961096222e-02,
  -5.209740307363067e-04,   4.569845413456963e-06,  -4.007701990758117e-08,   3.509172190839105e-10,  -3.041207873005890e-12,   2.489632439685228e-14,  -1.472620091078810e-16,
  -1.084054422382340e-18,   7.583903074337109e-20,   5.939068180274824e-02,  -5.209975003736506e-04,   4.570256411501447e-06,  -4.008295562998226e-08,   3.509900393083685e-10,
  -3.041807184630984e-12,   2.489022114203953e-14,  -1.467231959824474e-16,  -1.103461918250372e-18,   7.634545145047124e-20,   5.939119671627046e-02,  -5.210110456879802e-04,
   4.570493619442030e-06,  -4.008638142819013e-08,   3.510320625363293e-10,  -3.042152722735224e-12,   2.488668271172222e-14,  -1.464116961297187e-16,  -1.114675243806253e-18,
   7.663788478155468e-20,   5.939139007372359e-02,  -5.210161321879447e-04,   4.570582695826765e-06,  -4.008766788287404e-08,   3.510478421559224e-10,  -3.042282412104823e-12,
   2.488535094701539e-14,  -1.462946226957031e-16,  -1.118888393096388e-18,   7.674772811351983e-20,   5.939142212561073e-02,  -5.210169753533827e-04,   4.570597461641499e-06,
  -4.008788113291309e-08,   3.510504578262574e-10,  -3.042303906616476e-12,   2.488513002706873e-14,  -1.462752107091662e-16,  -1.119586911292754e-18,   7.676593788952728e-20,
   1.182259750765728e-01,  -1.036992185976758e-03,   9.094908899207634e-06,  -7.974595651657045e-08,   6.980877885429963e-10,  -6.047613077018030e-12,   4.944860620821703e-14,
  -2.899137166627299e-16,  -2.281294368575285e-18,   1.555230509153263e-19,   1.182272705487924e-01,  -1.037026261714917e-03,   9.095505554662427e-06,  -7.975456990655050e-08,
   6.981932259139937e-10,  -6.048466365216732e-12,   4.943890446983326e-14,  -2.890962311577797e-16,  -2.310705132876199e-18,   1.562942840405149e-19,   1.182293973376333e-01,
  -1.037082205215217e-03,   9.096485126217727e-06,  -7.976871105282369e-08,   6.983663031326688e-10,  -6.049865396629721e-12,   4.942289239646204e-14,  -2.877513335653044e-16,
  -2.359056573053260e-18,   1.575613175631713e-19,   1.182316541086093e-01,  -1.037141569210084e-03,   9.097524615772440e-06,  -7.978371708698070e-08,   6.985499305864801e-10,
  -6.051347455514563e-12,   4.940578658202997e-14,  -2.863204005495068e-16,  -2.410454816476219e-18,   1.589069978839476e-19,   1.182334302597897e-01,  -1.037188291605187e-03,
   9.098342763533760e-06,  -7.979552777192389e-08,   6.986944312033566e-10,  -6.052512087682481e-12,   4.939224031186683e-14,  -2.851914288277115e-16,  -2.450973272105473e-18,
   1.599669647723174e-19,   1.182344553356456e-01,  -1.037215257062982e-03,   9.098814958266195e-06,  -7.980234429250732e-08,   6.987778192416932e-10,  -6.053183514922017e-12,
   4.938438883323850e-14,  -2.845387463222285e-16,  -2.474384422755368e-18,   1.605790560197366e-19,   1.182348402664117e-01,  -1.037225383058983e-03,   9.098992276933729e-06,
  -7.980490402863529e-08,   6.988091311253638e-10,  -6.053435509215398e-12,   4.938143415925575e-14,  -2.842934437513467e-16,  -2.483180674833532e-18,   1.608089709914866e-19,
   1.182349040744381e-01,  -1.037227061598231e-03,   9.099021670296832e-06,  -7.980532834495921e-08,   6.988143214573442e-10,  -6.053477273841167e-12,   4.938094404385034e-14,
  -2.842527700587121e-16,  -2.484639050249146e-18,   1.608470863064748e-19,   1.998199848961746e-01,  -1.752675366203209e-03,   1.537177470863499e-05,  -1.347814546546339e-07,
   1.179759473672995e-09,  -1.021394525637908e-11,   8.318504389978743e-14,  -4.728890987733313e-16,  -4.490627747669874e-18,   2.829631316540620e-19,   1.998221744403954e-01,
  -1.752732958771942e-03,   1.537278304393882e-05,  -1.347960015576020e-07,   1.179936814004246e-09,  -1.021533461929297e-11,   8.316604263665766e-14,  -4.714017607836012e-16,
  -4.543895090033195e-18,   2.843655583333755e-19,   1.998257690355786e-01,  -1.752827510788779e-03,   1.537443849895263e-05,  -1.348198840729289e-07,   1.180227916959648e-09,
  -1.021761224617366e-11,   8.313469484868612e-14,  -4.689548482929721e-16,  -4.631468757230631e-18,   2.866696424444399e-19,   1.998295833202369e-01,  -1.752927843895363e-03,
   1.537619521338116e-05,  -1.348452271954475e-07,   1.180536758928420e-09,  -1.022002457850699e-11,   8.310122273325668e-14,  -4.663514053796271e-16,  -4.724563346254522e-18,
   2.891168583310635e-19,   1.998325852846563e-01,  -1.753006811000846e-03,   1.537757786453311e-05,  -1.348651737604930e-07,   1.180779789562393e-09,  -1.022191990192500e-11,
   8.307472802372889e-14,  -4.642973534462856e-16,  -4.797953892203523e-18,   2.910445662555179e-19,   1.998343178180536e-01,  -1.753052386234761e-03,   1.537837586270513e-05,
  -1.348766858717160e-07,   1.180920035387137e-09,  -1.022301244789204e-11,   8.305937643624358e-14,  -4.631098631541999e-16,  -4.840358952280666e-18,   2.921577785467797e-19,
   1.998349684093277e-01,  -1.753069500523451e-03,   1.537867552711045e-05,  -1.348810088894599e-07,   1.180972696834433e-09,  -1.022342246721920e-11,   8.305360023186460e-14,
  -4.626635598827594e-16,  -4.856291912041064e-18,   2.925759318825670e-19,   1.998350762545529e-01,  -1.753072337479453e-03,   1.537872520120524e-05,  -1.348817254970941e-07,
   1.180981426104074e-09,  -1.022349042099147e-11,   8.305264213486682e-14,  -4.625895582105238e-16,  -4.858933526048036e-18,   2.926452536922189e-19,   3.077348747781534e-01,
  -2.699226010982052e-03,   2.367343481045109e-05,  -2.075683829538430e-07,   1.816636439165446e-09,  -1.571299638107702e-11,   1.272088890680250e-13,  -6.886084208394773e-16,
  -8.396798385135255e-18,   4.830204650301175e-19,   3.077382468042258e-01,  -2.699314705561358e-03,   2.367498747061418e-05,  -2.075907606956351e-07,   1.816907558044683e-09,
  -1.571501355118503e-11,   1.271735492041394e-13,  -6.860694206087143e-16,  -8.487277600193347e-18,   4.854179956410144e-19,   3.077437826908754e-01,  -2.699460318981317e-03,
   2.367753658081836e-05,  -2.076274994393278e-07,   1.817352588046720e-09,  -1.571831953614459e-11,   1.271152712501178e-13,  -6.818923384187352e-16,  -8.636034090551317e-18,
   4.893571786353919e-19,   3.077496569121198e-01,  -2.699614835471274e-03,   2.368024161107732e-05,  -2.076664848811027e-07,   1.817824723601759e-09,  -1.572181992048597e-11,
   1.270530776134336e-13,  -6.774480256470223e-16,  -8.794175464588590e-18,   4.935413613724793e-19,   3.077542801127063e-01,  -2.699736447565104e-03,   2.368237064867703e-05,
  -2.076971686500503e-07,   1.818196241800651e-09,  -1.572456928746268e-11,   1.270038727048260e-13,  -6.739415580859284e-16,  -8.918850174473045e-18,   4.968375168626289e-19,
   3.077569483153458e-01,  -2.699806635010115e-03,   2.368359942387183e-05,  -2.077148776625861e-07,   1.818410630128122e-09,  -1.572615381197410e-11,   1.269753720044394e-13,
  -6.719143899179079e-16,  -8.990889204837718e-18,   4.987410654735081e-19,   3.077579502639107e-01,  -2.699832991609214e-03,   2.368406085364362e-05,  -2.077215277257925e-07,
   1.818491130894843e-09,  -1.572674840262664e-11,   1.269646501185607e-13,  -6.711525031286350e-16,  -9.017956984833022e-18,   4.994561071777569e-19,   3.077581163518570e-01,
  -2.699837360619975e-03,   2.368413734289079e-05,  -2.077226300770204e-07,   1.818504474828405e-09,  -1.572684694268676e-11,   1.269628717788112e-13,  -6.710261744020195e-16,
  -9.022444722350981e-18,   4.995746482431716e-19,   4.481693377609131e-01,  -3.931014386728348e-03,   3.447671623229984e-05,  -3.022848421706812e-07,   2.645066277459113e-09,
  -2.284523719554074e-11,   1.832246195962966e-13,  -9.125268221109559e-16,  -1.563174515140404e-17,   8.131983078455347e-19,   4.481742485971281e-01,  -3.931143553729683e-03,
   3.447897691762859e-05,  -3.023173750042999e-07,   2.645456608676706e-09,  -2.284789569795816e-11,   1.831591780451079e-13,  -9.082515126127703e-16,  -1.578342779497062e-17,
   8.172612182963460e-19,   4.481823107626814e-01,  -3.931355612317378e-03,   3.448268843922148e-05,  -3.023707856232544e-07,   2.646097297908344e-09,  -2.285225075403988e-11,
   1.830513060975928e-13,  -9.012178095746435e-16,  -1.603282218972746e-17,   8.239372264160259e-19,   4.481908656603387e-01,  -3.931580636529423e-03,   3.448662697767513e-05,
  -3.024274620925338e-07,   2.646776978841539e-09,  -2.285685913967446e-11,   1.829362483098414e-13,  -8.937339852587875e-16,  -1.629796912558531e-17,   8.310292394548050e-19,
   4.481975986392109e-01,  -3.931757741658240e-03,   3.448972686500377e-05,  -3.024720694280660e-07,   2.647311789752291e-09,  -2.286047677912058e-11,   1.828452642774418e-13,
  -8.878293081690475e-16,  -1.650701777552428e-17,   8.366166541903016e-19,   4.482014844649621e-01,  -3.931859956456419e-03,   3.449151596553809e-05,  -3.024978142571201e-07,
   2.647620398781671e-09,  -2.286256090342764e-11,   1.827925819089683e-13,  -8.844156405304164e-16,  -1.662781479733088e-17,   8.398436469494093e-19,   4.482029436485584e-01,
  -3.931898339879023e-03,   3.449218780852310e-05,  -3.025074818972742e-07,   2.647736276816857e-09,  -2.286334281555303e-11,   1.827727663051421e-13,  -8.831326469334311e-16,
  -1.667320381176761e-17,   8.410558654204284e-19,   4.482031855300432e-01,  -3.931904702520269e-03,   3.449229917706106e-05,  -3.025090844576014e-07,   2.647755484852078e-09,
  -2.286347239188198e-11,   1.827694798517002e-13,  -8.829199128927935e-16,  -1.668072919573847e-17,   8.412568317433067e-19,   6.332603324739072e-01,  -5.554496672946905e-03,
   4.871522551914966e-05,  -4.271098010196155e-07,   3.736069029134938e-09,  -3.218878303019626e-11,   2.539928096530612e-13,  -1.069147399147245e-15,  -3.050840538676267e-17,
   1.425485905116946e-18,   6.332672714296366e-01,  -5.554679177462686e-03,   4.871841860206958e-05,  -4.271556338733147e-07,   3.736609687091016e-09,  -3.219185791011690e-11,
   2.538657177095240e-13,  -1.061649286313298e-15,  -3.077411467486718e-17,   1.432746125922525e-18,   6.332786631777486e-01,  -5.554978802320048e-03,   4.872366089779310e-05,
  -4.272308790350299e-07,   3.737497065613907e-09,  -3.219688949980074e-11,   2.536563063627872e-13,  -1.049312940799812e-15,  -3.121103319489603e-17,   1.444677633099736e-18,
   6.332907511505247e-01,  -5.555296746694953e-03,   4.872922383171418e-05,  -4.273107241913968e-07,   3.738438371683323e-09,  -3.220220618837932e-11,   2.534330579893955e-13,
  -1.036186431066702e-15,  -3.167560763804735e-17,   1.457355096172028e-18,   6.333002647727102e-01,  -5.555546984522562e-03,   4.873360221787309e-05,  -4.273735658002709e-07,
   3.739178987688303e-09,  -3.220637433927999e-11,   2.532566015812848e-13,  -1.025829211436777e-15,  -3.204193265283703e-17,   1.467344771447532e-18,   6.333057554000250e-01,
  -5.555691407251684e-03,   4.873612920157632e-05,  -4.274098341422773e-07,   3.739606332603026e-09,  -3.220877339428643e-11,   2.531544606942748e-13,  -1.019841193220202e-15,
  -3.225362760262970e-17,   1.473114991571723e-18,   6.333078172097367e-01,  -5.555745640478343e-03,   4.873707813392537e-05,  -4.274234534957878e-07,   3.739766789903833e-09,
  -3.220967304009243e-11,   2.531160481976851e-13,  -1.017590616391215e-15,  -3.233317439398228e-17,   1.475282707826195e-18,   6.333081589855042e-01,  -5.555754630467640e-03,
   4.873723543435542e-05,  -4.274257111107263e-07,   3.739793387208272e-09,  -3.220982210470839e-11,   2.531096777382085e-13,  -1.017217444671788e-15,  -3.234636322160606e-17,
   1.475642087461131e-18,   8.943149429544754e-01,  -7.844274482038199e-03,   6.879712231287693e-05,  -6.031332049311138e-07,   5.272163046904463e-09,  -4.518697598900266e-11,
   3.438444791526830e-13,  -8.264831959734330e-16,  -6.995944639508567e-17,   2.925878100298526e-18,   8.943247423513890e-01,  -7.844532200146793e-03,   6.880162805525598e-05,
  -6.031975278564459e-07,   5.272893556152058e-09,  -4.518919869447582e-11,   3.435542100028717e-13,  -8.110681099445200e-16,  -7.051240893591495e-17,   2.941695595231300e-18,
   8.943408301119750e-01,  -7.844955305996951e-03,   6.880902541053163e-05,  -6.033031265344104e-07,   5.274092351346203e-09,  -4.519281405048028e-11,   3.430760839163370e-13,
  -7.857029046540939e-16,  -7.142188262403443e-17,   2.967699087581846e-18,   8.943579011008892e-01,  -7.845404281006265e-03,   6.881687518760003e-05,  -6.034151778454749e-07,
   5.275363747364688e-09,  -4.519660452149463e-11,   3.425665748270606e-13,  -7.587084090676044e-16,  -7.238921092203121e-17,   2.995340415732575e-18,   8.943713365161611e-01,
  -7.845757646248310e-03,   6.882305344595391e-05,  -6.035033649386615e-07,   5.276363893947370e-09,  -4.519955449807429e-11,   3.421640077404705e-13,  -7.374055806196653e-16,
  -7.315217419889117e-17,   3.017130196813727e-18,   8.943790905403505e-01,  -7.845961588076296e-03,   6.882661921701975e-05,  -6.035542602804784e-07,   5.276940917856603e-09,
  -4.520124368331397e-11,   3.419310440608408e-13,  -7.250880258105608e-16,  -7.359316527231105e-17,   3.029719896772277e-18,   8.943820022881882e-01,  -7.846038171741966e-03,
   6.882795823303040e-05,  -6.035733721467223e-07,   5.277157561962824e-09,  -4.520187547242341e-11,   3.418434439023330e-13,  -7.204582598085777e-16,  -7.375888848691544e-17,
   3.034450173964032e-18,   8.943824849538984e-01,  -7.846050866658896e-03,   6.882818019586864e-05,  -6.035765402205043e-07,   5.277193472023965e-09,  -4.520198006768923e-11,
   3.418289165906524e-13,  -7.196905775598129e-16,  -7.378636616573405e-17,   3.035234428580915e-18,   2.261257997045671e-03,  -1.916187409332425e-05,   1.623653259779367e-07,
  -1.375606065156240e-09,   1.164792055633714e-11,  -9.827509856774405e-14,   8.122811197190642e-16,  -6.033447553825860e-18,   2.112919577639543e-20,   7.219907240055675e-22,
   2.261281122844447e-03,  -1.916246186452417e-05,   1.623752813157558e-07,  -1.375746069494663e-09,   1.164965540700063e-11,  -9.829306729797215e-14,   8.123613338415339e-16,
  -6.029590840537944e-18,   2.093814078636452e-20,   7.278587010032350e-22,   2.261319088612569e-03,  -1.916342682934108e-05,   1.623916256854249e-07,  -1.375975927737912e-09,
   1.165250356685479e-11,  -9.832255744389602e-14,   8.124924643738156e-16,  -6.023237587579425e-18,   2.062385001805482e-20,   7.375058819152775e-22,   2.261359374622495e-03,
  -1.916445079040288e-05,   1.624089697811871e-07,  -1.376219850188742e-09,   1.165552584955754e-11,  -9.835383728113185e-14,   8.126308501423594e-16,  -6.016466592539045e-18,
   2.028948877406681e-20,   7.477612365657606e-22,   2.261391080934580e-03,  -1.916525669572350e-05,   1.624226207301590e-07,  -1.376411836601263e-09,   1.165790452100020e-11,
  -9.837844634020473e-14,   8.127392138512012e-16,  -6.011116256019652e-18,   2.002571124564872e-20,   7.558459709228514e-22,   2.261409379672394e-03,  -1.916572181651391e-05,
   1.624304993824433e-07,  -1.376522642993118e-09,   1.165927734641229e-11,  -9.839264536071608e-14,   8.128015332908527e-16,  -6.008019835421757e-18,   1.987322603464484e-20,
   7.605173260677453e-22,   2.261416251106978e-03,  -1.916589647722250e-05,   1.624334579746162e-07,  -1.376564253270773e-09,   1.165979286498984e-11,  -9.839797660037131e-14,
   8.128248933643896e-16,  -6.006855465382674e-18,   1.981591829156650e-20,   7.622725051787074e-22,   2.261417390149656e-03,  -1.916592542990523e-05,   1.624339484078323e-07,
  -1.376571150842463e-09,   1.165987832004669e-11,  -9.839886029620213e-14,   8.128287634410953e-16,  -6.006662368196213e-18,   1.980641617873021e-20,   7.625635060371380e-22,
   2.045018610146433e-02,  -1.732946399210351e-04,   1.468386615457347e-06,  -1.244058948370130e-08,   1.053398922895201e-10,  -8.887297836818480e-13,   7.343740820415932e-15,
  -5.446089073809177e-17,   1.870904297977970e-19,   6.661650807440342e-21,   2.045039524472199e-02,  -1.732999555561488e-04,   1.468476648169742e-06,  -1.244185558025796e-08,
   1.053555766828515e-10,  -8.888919661056999e-13,   7.344449814303880e-15,  -5.442531450800458e-17,   1.853377370691547e-19,   6.715465169888488e-21,   2.045073859651277e-02,
  -1.733086824227479e-04,   1.468624461124865e-06,  -1.244393424930322e-08,   1.053813262280432e-10,  -8.891581370190312e-13,   7.345608660857422e-15,  -5.436671012998418e-17,
   1.824545053875585e-19,   6.803938445686584e-21,   2.045110293192153e-02,  -1.733179428345330e-04,   1.468781315260585e-06,  -1.244614010426144e-08,   1.054086499426440e-10,
  -8.894404589783711e-13,   7.346831370840624e-15,  -5.430425395231635e-17,   1.793871470527366e-19,   6.897989742018588e-21,   2.045138967494207e-02,  -1.733252312123697e-04,
   1.468904769822762e-06,  -1.244787628762495e-08,   1.054301549011633e-10,  -8.896625709447786e-13,   7.347788635448652e-15,  -5.425490317952167e-17,   1.769673051622340e-19,
   6.972134777918756e-21,   2.045155516361001e-02,  -1.733294376321153e-04,   1.468976021686146e-06,  -1.244887833869025e-08,   1.054425662536366e-10,  -8.897907252171353e-13,
   7.348339079059194e-15,  -5.422634267512222e-17,   1.755684351855113e-19,   7.014975891867795e-21,   2.045161730694292e-02,  -1.733310172137377e-04,   1.469002778191681e-06,
  -1.244925463124550e-08,   1.054472269192334e-10,  -8.898388425754890e-13,   7.348545395433746e-15,  -5.421560294246051e-17,   1.750427047191459e-19,   7.031072711836971e-21,
   2.045162760812639e-02,  -1.733312790535408e-04,   1.469007213503565e-06,  -1.244931700777767e-08,   1.054479994954494e-10,  -8.898468184078336e-13,   7.348579575236654e-15,
  -5.421382188762670e-17,   1.749555341077056e-19,   7.033741494222705e-21,   5.737352188463831e-02,  -4.861825569351635e-04,   4.119595926704269e-06,  -3.490234745011863e-08,
   2.955299573252286e-10,  -2.493102927428954e-12,   2.058951146790068e-14,  -1.521796405804510e-16,   5.013333269818148e-19,   1.946957576679010e-20,   5.737410864135020e-02,
  -4.861974700650951e-04,   4.119848512362076e-06,  -3.490589914284419e-08,   2.955739302310081e-10,  -2.493556040073529e-12,   2.059140365719829e-14,  -1.520757147848429e-16,
   4.962691778847256e-19,   1.962497482556419e-20,   5.737507192350409e-02,  -4.862219534790391e-04,   4.120263199755560e-06,  -3.491173028680264e-08,   2.956461217376950e-10,
  -2.494299670621029e-12,   2.059449530931870e-14,  -1.519045255274700e-16,   4.879384792225108e-19,   1.988046034123574e-20,   5.737609407572970e-02,  -4.862479337654401e-04,
   4.120703252042655e-06,  -3.491791821382650e-08,   2.957227263877362e-10,  -2.495088410647916e-12,   2.059775580881943e-14,  -1.517220938502485e-16,   4.790757410099007e-19,
   2.015205678038391e-20,   5.737689854054271e-02,  -4.862683814676498e-04,   4.121049602231720e-06,  -3.492278860284029e-08,   2.957830174507127e-10,  -2.495708928596849e-12,
   2.060030734998896e-14,  -1.515779490126580e-16,   4.720838958146406e-19,   2.036617127313022e-20,   5.737736282319557e-02,  -4.862801826694967e-04,   4.121249498412231e-06,
  -3.492559958310617e-08,   2.958178137216036e-10,  -2.496066951431171e-12,   2.060177407934131e-14,  -1.514945314679276e-16,   4.680420183576871e-19,   2.048988788043296e-20,
   5.737753716789130e-02,  -4.862846142199957e-04,   4.121324563440804e-06,  -3.492665516883302e-08,   2.958308802785444e-10,  -2.496201375494130e-12,   2.060232375087647e-14,
  -1.514631640927066e-16,   4.665229775798973e-19,   2.053637246731711e-20,   5.737756606812264e-02,  -4.862853488172415e-04,   4.121337006650585e-06,  -3.492683014910635e-08,
   2.958330462585220e-10,  -2.496223657305566e-12,   2.060241480875513e-14,  -1.514579622186720e-16,   4.662711075250835e-19,   2.054407941789326e-20,   1.142177206391738e-01,
  -9.678796283689260e-04,   8.201183519306232e-06,  -6.948254185226323e-08,   5.883210642775648e-10,  -4.962391877320604e-12,   4.094518697035747e-14,  -3.009691090615766e-16,
   9.214050765985434e-19,   4.130438653491676e-20,   1.142188887390239e-01,  -9.679093169744996e-04,   8.201686349218106e-06,  -6.948961126126267e-08,   5.884085069737238e-10,
  -4.963287771247249e-12,   4.094863851365390e-14,  -3.007487876353665e-16,   9.108426287055924e-19,   4.162827892777172e-20,   1.142208064158327e-01,  -9.679580578100810e-04,
   8.202511879900021e-06,  -6.950121776062328e-08,   5.885520635233621e-10,  -4.964758044572567e-12,   4.095427415559118e-14,  -3.003858890828439e-16,   8.934669520690181e-19,
   4.216078582681830e-20,   1.142228412896323e-01,  -9.680097785732905e-04,   8.203387905157567e-06,  -6.951353440412659e-08,   5.887043951759414e-10,  -4.966317462310404e-12,
   4.096021232860247e-14,  -2.999991859979829e-16,   8.749814584660113e-19,   4.272688362425816e-20,   1.142244427970481e-01,  -9.680504852359526e-04,   8.204077394784883e-06,
  -6.952322857258003e-08,   5.888242860769740e-10,  -4.967544256250848e-12,   4.096485548093204e-14,  -2.996936602127227e-16,   8.603981002089789e-19,   4.317317779756787e-20,
   1.142253670787559e-01,  -9.680739787089393e-04,   8.204475334035641e-06,  -6.952882362957633e-08,   5.888934794939348e-10,  -4.968252071841561e-12,   4.096752300618312e-14,
  -2.995168585143664e-16,   8.519676513145055e-19,   4.343105238220180e-20,   1.142257141595957e-01,  -9.680828009045895e-04,   8.204624768208168e-06,  -6.953092469768327e-08,
   5.889194626936207e-10,  -4.968517827454728e-12,   4.096852239423297e-14,  -2.994503775503872e-16,   8.487992666248348e-19,   4.352794534285990e-20,   1.142257716934169e-01,
  -9.680842633183927e-04,   8.204649539273665e-06,  -6.953127298341328e-08,   5.889237698011014e-10,  -4.968561878341861e-12,   4.096868793603493e-14,  -2.994393526210400e-16,
   8.482739207795573e-19,   4.354400982342172e-20,   1.930454218545449e-01,  -1.635864627412190e-03,   1.386125155161728e-05,  -1.174357538989008e-07,   9.943213856140522e-10,
  -8.385136224363514e-12,   6.909184489793756e-14,  -5.036087367702117e-16,   1.360824282422877e-18,   7.636155983174743e-20,   1.930473961214738e-01,  -1.635914805527988e-03,
   1.386210138302757e-05,  -1.174476992094172e-07,   9.944689288847734e-10,  -8.386634700803065e-12,   6.909686968558676e-14,  -5.032017811976273e-16,   1.341727901172298e-18,
   7.694680678419805e-20,   1.930506372878004e-01,  -1.635997184717443e-03,   1.386349660994229e-05,  -1.174673109090301e-07,   9.947111525896088e-10,  -8.389093803147278e-12,
   6.910506331758982e-14,  -5.025315197608384e-16,   1.310313258406706e-18,   7.790902549788306e-20,   1.930540765349143e-01,  -1.636084600422080e-03,   1.386497717737816e-05,
  -1.174881225295026e-07,   9.949681808728845e-10,  -8.391701889646014e-12,   6.911368203872425e-14,  -5.018173575409492e-16,   1.276891718399249e-18,   7.893197222165330e-20,
   1.930567833267324e-01,  -1.636153400674237e-03,   1.386614248140118e-05,  -1.175045028980563e-07,   9.951704708389950e-10,  -8.393753588482975e-12,   6.912041037705979e-14,
  -5.012531604963835e-16,   1.250524909969705e-18,   7.973845428287757e-20,   1.930583455038022e-01,  -1.636193108101578e-03,   1.386681503708514e-05,  -1.175139569357677e-07,
   9.952872192707793e-10,  -8.394937311006077e-12,   6.912427150343580e-14,  -5.009266897158614e-16,   1.235282489859670e-18,   8.020445901730981e-20,   1.930589321233627e-01,
  -1.636208018910688e-03,   1.386706759522647e-05,  -1.175175071355978e-07,   9.953310600214596e-10,  -8.395381743784458e-12,   6.912571724675607e-14,  -5.008039337432512e-16,
   1.229553965689122e-18,   8.037955580840251e-20,   1.930590293642964e-01,  -1.636210490605252e-03,   1.386710946071188e-05,  -1.175180956380848e-07,   9.953383272825816e-10,
  -8.395455411353041e-12,   6.912595668050098e-14,  -5.007835765852418e-16,   1.228604125239233e-18,   8.040858627232030e-20,   2.973016379096036e-01,  -2.519330529961532e-03,
   2.134715922101961e-05,  -1.808573278785996e-07,   1.531244093197345e-09,  -1.290890105089607e-11,   1.061493284750356e-13,  -7.639002159030607e-16,   1.640940042237317e-18,
   1.328542744008648e-19,   2.973046783990246e-01,  -2.519407806913024e-03,   2.134846794894827e-05,  -1.808757173612218e-07,   1.531470749338127e-09,  -1.291117257493658e-11,
   1.061551939119431e-13,  -7.631929270421880e-16,   1.608611053909426e-18,   1.338451332830252e-19,   2.973096699894576e-01,  -2.519534675218365e-03,   2.135061657761635e-05,
  -1.809059090057198e-07,   1.531842850776521e-09,  -1.291490010420818e-11,   1.061647292326673e-13,  -7.620281099754002e-16,   1.555427165206504e-18,   1.354742867500352e-19,
   2.973149666361672e-01,  -2.519669300020247e-03,   2.135289662893696e-05,  -1.809379478434493e-07,   1.532237690908863e-09,  -1.291885319659989e-11,   1.061747193642116e-13,
  -7.607871317253210e-16,   1.498844513345147e-18,   1.372063395301035e-19,   2.973191352578097e-01,  -2.519775256039977e-03,   2.135469117905172e-05,  -1.809631648712236e-07,
   1.532548440610718e-09,  -1.292196277409129e-11,   1.061824891402609e-13,  -7.598068386451279e-16,   1.454204678780368e-18,   1.385719320269348e-19,   2.973215411041299e-01,
  -2.519836407573037e-03,   2.135572690423017e-05,  -1.809777190304321e-07,   1.532727783703876e-09,  -1.292375675883515e-11,   1.061869361019302e-13,  -7.592396332630609e-16,
   1.428398445417813e-18,   1.393610273088636e-19,   2.973224445334129e-01,  -2.519859371005592e-03,   2.135611583977034e-05,  -1.809831844356850e-07,   1.532795129452040e-09,
  -1.292443030190280e-11,   1.061885989572606e-13,  -7.590263660644356e-16,   1.418699683398581e-18,   1.396575266273512e-19,   2.973225942902790e-01,  -2.519863177545590e-03,
   2.135618031195383e-05,  -1.809840904140014e-07,   1.532806293007120e-09,  -1.292454194518212e-11,   1.061888742287069e-13,  -7.589909994128475e-16,   1.417091538696617e-18,
   1.397066854557064e-19,   4.329749058483873e-01,  -3.669024089975030e-03,   3.108889503257685e-05,  -2.633895075600438e-07,   2.229868331789811e-09,  -1.878936655507836e-11,
   1.540166599254096e-13,  -1.086163902960621e-15,   1.356897376257744e-18,   2.284313167626608e-19,   4.329793338591331e-01,  -3.669136631327632e-03,   3.109080085547727e-05,
  -2.634162734320332e-07,   2.230197146609400e-09,  -1.879259300343757e-11,   1.540209454694846e-13,  -1.084949129884902e-15,   1.303047667531701e-18,   2.300847662617820e-19,
   4.329866033519573e-01,  -3.669321394443015e-03,   3.109392977524637e-05,  -2.634602172545408e-07,   2.230736955380418e-09,  -1.879788708773968e-11,   1.540278247222735e-13,
  -1.082948728034992e-15,   1.214457787569658e-18,   2.328034957297351e-19,   4.329943171128633e-01,  -3.669517453631207e-03,   3.109725007691165e-05,  -2.635068495462931e-07,
   2.231309742270338e-09,  -1.880350090758434e-11,   1.540349116076900e-13,  -1.080817772730706e-15,   1.120202940863361e-18,   2.356941553299659e-19,   4.330003880766899e-01,
  -3.669671761383319e-03,   3.109986337157928e-05,  -2.635435526617453e-07,   2.231760534296411e-09,  -1.880791639179318e-11,   1.540403349104507e-13,  -1.079134629530869e-15,
   1.045839747712393e-18,   2.379733751819144e-19,   4.330038918261806e-01,  -3.669760818667855e-03,   3.110137163512805e-05,  -2.635647360524835e-07,   2.232020697453626e-09,
  -1.881046360134245e-11,   1.540434029514947e-13,  -1.078160819169787e-15,   1.002849441877087e-18,   2.392904633872665e-19,   4.330052075336140e-01,  -3.669794261180612e-03,
   3.110193801822747e-05,  -2.635726908729834e-07,   2.232118391730015e-09,  -1.881141990465417e-11,   1.540445433314009e-13,  -1.077794683087913e-15,   9.866921904386299e-19,
   2.397853655331192e-19,   4.330054256317271e-01,  -3.669799804788332e-03,   3.110203190513193e-05,  -2.635740095113545e-07,   2.232134585976959e-09,  -1.881157841510201e-11,
   1.540447317482422e-13,  -1.077733966485808e-15,   9.840131579473347e-19,   2.398674196572723e-19,   6.117907018312623e-01,  -5.184306760370843e-03,   4.392836734395914e-05,
  -3.721633470250238e-07,   3.150422702154375e-09,  -2.652457741422395e-11,   2.162630647396996e-13,  -1.471574818214115e-15,  -5.900061566646368e-19,   4.088293957715570e-19,
   6.117969585754124e-01,  -5.184465778598062e-03,   4.393105992894905e-05,  -3.722011302510125e-07,   3.150884285750350e-09,  -2.652894028376956e-11,   2.162587759383856e-13,
  -1.469402939273018e-15,  -6.830737884651704e-19,   4.117052491294588e-19,   6.118072303112214e-01,  -5.184726844429234e-03,   4.393548052796242e-05,  -3.722631620061813e-07,
   3.151642042295928e-09,  -2.653609789854131e-11,   2.162514652323983e-13,  -1.465826739001256e-15,  -8.361914660807662e-19,   4.164344301561853e-19,   6.118181297942631e-01,
  -5.185003871323371e-03,   4.394017151250736e-05,  -3.723289885719924e-07,   3.152446069959096e-09,  -2.654368622392084e-11,   2.162433406029340e-13,  -1.462017542657995e-15,
  -9.991128488812158e-19,   4.214633347304637e-19,   6.118267080180119e-01,  -5.185221904436000e-03,   4.394386362243683e-05,  -3.723807988246946e-07,   3.153078836102144e-09,
  -2.654965359072366e-11,   2.162366800506214e-13,  -1.459009122154333e-15,  -1.127660140258620e-18,   4.254289867078240e-19,   6.118316587882456e-01,  -5.185347740215302e-03,
   4.394599452368945e-05,  -3.724107012974975e-07,   3.153444014609320e-09,  -2.655309559344903e-11,   2.162327291822927e-13,  -1.457268665472834e-15,  -1.201978585069325e-18,
   4.277208003109191e-19,   6.118335178724083e-01,  -5.185394993672432e-03,   4.394679471954693e-05,  -3.724219303064968e-07,   3.153581142156746e-09,  -2.655438774371159e-11,
   2.162312253641680e-13,  -1.456614305081055e-15,  -1.229910725682291e-18,   4.285819961252023e-19,   6.118338260433113e-01,  -5.185402826655261e-03,   4.394692736458504e-05,
  -3.724237916930393e-07,   3.153603872978017e-09,  -2.655460191732360e-11,   2.162309750172858e-13,  -1.456505793179450e-15,  -1.234542187719855e-18,   4.287247831552633e-19,
   8.639946984198983e-01,  -7.321479694008012e-03,   6.203725036337431e-05,  -5.255715103107822e-07,   4.448104745731261e-09,  -3.738761370610960e-11,   3.014047557304313e-13,
  -1.888422062274232e-15,  -8.541383830161951e-18,   8.491637427707584e-19,   8.640035344214154e-01,  -7.321704260214001e-03,   6.204105199373900e-05,  -5.256247626018427e-07,
   4.448747671214976e-09,  -3.739318478689180e-11,   3.013668269900234e-13,  -1.883912807847966e-15,  -8.728385599467754e-18,   8.550654131650489e-19,   8.640180405399908e-01,
  -7.322072938439686e-03,   6.204729338206488e-05,  -5.257121905586423e-07,   4.449803076877701e-09,  -3.740232077390843e-11,   3.013040181493390e-13,  -1.876488142488087e-15,
  -9.036093649224679e-18,   8.647726285454192e-19,   8.640334331858776e-01,  -7.322464156897334e-03,   6.205391651678693e-05,  -5.258049661230767e-07,   4.450922861077043e-09,
  -3.741200135756935e-11,   3.012366344374679e-13,  -1.868580068225172e-15,  -9.363567531775631e-18,   8.750981206206853e-19,   8.640455476649652e-01,  -7.322772064073917e-03,
   6.205912934909250e-05,  -5.258779865831819e-07,   4.451804076828791e-09,  -3.741961030180561e-11,   3.011830673866827e-13,  -1.862334671773493e-15,  -9.621995600373947e-18,
   8.832427288684484e-19,   8.640525393224301e-01,  -7.322949769818394e-03,   6.206213793306772e-05,  -5.259201303632523e-07,   4.452312619380763e-09,  -3.742399766686425e-11,
   3.011519377589868e-13,  -1.858721622878423e-15,  -9.771422097884952e-18,   8.879505175898798e-19,   8.640551647885718e-01,  -7.323016501319612e-03,   6.206326771585043e-05,
  -5.259359561958368e-07,   4.452503577560574e-09,  -3.742564442709097e-11,   3.011402075953207e-13,  -1.857363239922700e-15,  -9.827586678351684e-18,   8.897197336597746e-19,
   8.640555999987077e-01,  -7.323027563085852e-03,   6.206345499507874e-05,  -5.259385795764837e-07,   4.452535231368908e-09,  -3.742591736216563e-11,   3.011382610059409e-13,
  -1.857137981580069e-15,  -9.836899581657539e-18,   8.900130801292404e-19,   2.187108084013882e-03,  -1.792595511746436e-05,   1.469146699805085e-07,  -1.203959961278242e-09,
   9.864154249708715e-12,  -8.071382077658269e-14,   6.554320053086982e-16,  -5.113262134887038e-18,   3.238798819167041e-20,   3.647183402829853e-23,   2.187129008004134e-03,
  -1.792646952078404e-05,   1.469231003665664e-07,  -1.204074951952960e-09,   9.865554858779438e-12,  -8.072909751175019e-14,   6.555598749605604e-16,  -5.113018154052970e-18,
   3.233120168927932e-20,   3.859297283191189e-23,   2.187163358989954e-03,  -1.792731403262406e-05,   1.469369410749505e-07,  -1.204263743473079e-09,   9.867854381967383e-12,
  -8.075417618132171e-14,   6.557696286070306e-16,  -5.112609711945683e-18,   3.223770909391717e-20,   4.208227990824380e-23,   2.187199809222707e-03,  -1.792821017326441e-05,
   1.469516283123988e-07,  -1.204464087229048e-09,   9.870294621027821e-12,  -8.078078581270648e-14,   6.559919686517686e-16,  -5.112165561012862e-18,   3.213814113284677e-20,
   4.579437908269036e-23,   2.187228496603213e-03,  -1.792891547563642e-05,   1.469631880970703e-07,  -1.204621774284270e-09,   9.872215295367044e-12,  -8.080172716370028e-14,
   6.561667883493842e-16,  -5.111808208286710e-18,   3.205951600110569e-20,   4.872282971971848e-23,   2.187245052994530e-03,  -1.792932253344924e-05,   1.469698598162408e-07,
  -1.204712784767009e-09,   9.873323831564353e-12,  -8.081381259643883e-14,   6.562676147320904e-16,  -5.111598841210291e-18,   3.201403373167444e-20,   5.041570685873423e-23,
   2.187251270148949e-03,  -1.792947539035613e-05,   1.469723651776612e-07,  -1.204746961280077e-09,   9.873740112569555e-12,  -8.081835075276684e-14,   6.563054636512319e-16,
  -5.111519629394975e-18,   3.199693460905413e-20,   5.105193053846748e-23,   2.187252300734706e-03,  -1.792950072871623e-05,   1.469727804805820e-07,  -1.204752626588131e-09,
   9.873809117876936e-12,  -8.081910301481643e-14,   6.563117369973828e-16,  -5.111506467640296e-18,   3.199409912523907e-20,   5.115742176223838e-23,   1.977959498763294e-02,
  -1.621173340116612e-04,   1.328655247211262e-06,  -1.088827581271488e-08,   8.920848699351054e-11,  -7.299417631451847e-13,   5.926907742874645e-15,  -4.621329127178830e-17,
   2.917271585194019e-19,   3.705820246415690e-22,   1.977978421835714e-02,  -1.621219861307777e-04,   1.328731489115824e-06,  -1.088931573913117e-08,   8.922115229447156e-11,
  -7.300798296817494e-13,   5.928059286702790e-15,  -4.621086905803034e-17,   2.912054982738122e-19,   3.900248529465819e-22,   1.978009487907935e-02,  -1.621296236586123e-04,
   1.328856660365759e-06,  -1.089102308869362e-08,   8.924194620725665e-11,  -7.303064826786904e-13,   5.929948215795209e-15,  -4.620682011433703e-17,   2.903466483261847e-19,
   4.220086879993812e-22,   1.978042452480453e-02,  -1.621377281028058e-04,   1.328989487371570e-06,  -1.089283491159636e-08,   8.926401256225516e-11,  -7.305469713736410e-13,
   5.931950450641751e-15,  -4.620242522169646e-17,   2.894319951304553e-19,   4.560347892003976e-22,   1.978068396546198e-02,  -1.621441066593083e-04,   1.329094030624064e-06,
  -1.089426096552142e-08,   8.928138064091059e-11,  -7.307362316320428e-13,   5.933524721863116e-15,  -4.619889488770857e-17,   2.887097322849781e-19,   4.828778291624072e-22,
   1.978083369684116e-02,  -1.621477879758051e-04,   1.329154367666458e-06,  -1.089508402515738e-08,   8.929140479640004e-11,  -7.308454551576205e-13,   5.934432663034777e-15,
  -4.619682875552591e-17,   2.882919269551312e-19,   4.983952680637669e-22,   1.978088992304938e-02,  -1.621491703707257e-04,   1.329177025409377e-06,  -1.089539310282533e-08,
   8.929516909829381e-11,  -7.308864692457855e-13,   5.934773490156445e-15,  -4.619604747223955e-17,   2.881348528285268e-19,   5.042270978892585e-22,   1.978089924337914e-02,
  -1.621493995237356e-04,   1.329180781285367e-06,  -1.089544433743154e-08,   8.929579309216764e-11,  -7.308932678951212e-13,   5.934829981123099e-15,  -4.619591767678910e-17,
   2.881088058306491e-19,   5.051940644914398e-22,   5.549216131179036e-02,  -4.548243401697512e-04,   3.727576289840653e-06,  -3.054732551083385e-08,   2.502756998912857e-10,
  -2.047802865431946e-12,   1.662435470409560e-14,  -1.294784359665494e-16,   8.114997179938075e-19,   1.279713006722486e-21,   5.549269220342679e-02,  -4.548373918039651e-04,
   3.727790187559579e-06,  -3.055024295046350e-08,   2.503112243988241e-10,  -2.048189673841321e-12,   1.662755670795485e-14,  -1.294703692839920e-16,   8.099883962640936e-19,
   1.335796265025753e-21,   5.549356377002819e-02,  -4.548588190754845e-04,   3.728141357229293e-06,  -3.055503279772966e-08,   2.503695485524525e-10,  -2.048824664053867e-12,
   1.663280892224340e-14,  -1.294569174229365e-16,   8.075002178819500e-19,   1.428054783706785e-21,   5.549448859954082e-02,  -4.548815562922484e-04,   3.728514005220789e-06,
  -3.056011573674055e-08,   2.504314416774783e-10,  -2.049498412502421e-12,   1.663837594545820e-14,  -1.294423593936328e-16,   8.048504101723818e-19,   1.526204912961036e-21,
   5.549521646694036e-02,  -4.548994514887752e-04,   3.728807302748292e-06,  -3.056411642804966e-08,   2.504801567331710e-10,  -2.050028637599051e-12,   1.664275288193020e-14,
  -1.294306958122520e-16,   8.027579971617853e-19,   1.603635564056150e-21,   5.549563654215389e-02,  -4.549097795123778e-04,   3.728976579145525e-06,  -3.056642546220523e-08,
   2.505082730839823e-10,  -2.050334633401249e-12,   1.664527715492934e-14,  -1.294238817220338e-16,   8.015476160629330e-19,   1.648396897161950e-21,   5.549579428621900e-02,
  -4.549136578551856e-04,   3.729040145752625e-06,  -3.056729255716017e-08,   2.505188314197838e-10,  -2.050449536448304e-12,   1.664622471481906e-14,  -1.294213072996941e-16,
   8.010925747631279e-19,   1.665219325796583e-21,   5.549582043464250e-02,  -4.549143007495673e-04,   3.729050682913974e-06,  -3.056743629212551e-08,   2.505205816344035e-10,
  -2.050468583197979e-12,   1.664638176903111e-14,  -1.294208797257214e-16,   8.010171171258743e-19,   1.668008628241493e-21,   1.104723567794520e-01,  -9.054525087739461e-04,
   7.420761959365353e-06,  -6.081278642390715e-08,   4.982391560988259e-10,  -4.076495066339761e-12,   3.308325390806184e-14,  -2.571984279403532e-16,   1.592970094460379e-18,
   3.328055094098389e-21,   1.104734136647127e-01,  -9.054784916119164e-04,   7.421187778497543e-06,  -6.081859406230877e-08,   4.983098504701600e-10,  -4.077263363016045e-12,
   3.308953530531486e-14,  -2.571782354474395e-16,   1.589805587101213e-18,   3.444726819457829e-21,   1.104751487568318e-01,  -9.055211484404462e-04,   7.421886873191941e-06,
  -6.082812903106367e-08,   4.984259163815459e-10,  -4.078524600718772e-12,   3.309983803705384e-14,  -2.571446512008625e-16,   1.584595756757332e-18,   3.636656666446312e-21,
   1.104769898833687e-01,  -9.055664130721503e-04,   7.422628726057476e-06,  -6.083824744409747e-08,   4.985490844049370e-10,  -4.079862808867128e-12,   3.311075750679558e-14,
  -2.571084237099306e-16,   1.579047617147031e-18,   3.840845316921153e-21,   1.104784389028540e-01,  -9.056020383417761e-04,   7.423212611144911e-06,  -6.084621146610001e-08,
   4.986460277804355e-10,  -4.080915940029877e-12,   3.311934210003059e-14,  -2.570794832201782e-16,   1.574666628014976e-18,   4.001931370518236e-21,   1.104792751776617e-01,
  -9.056225990896988e-04,   7.423549599877482e-06,  -6.085080797069504e-08,   4.987019795017059e-10,  -4.081523704171449e-12,   3.312429278812251e-14,  -2.570626088190433e-16,
   1.572132426195387e-18,   4.095053100442497e-21,   1.104795892104431e-01,  -9.056303199888580e-04,   7.423676145754515e-06,  -6.085253406280399e-08,   4.987229906481013e-10,
  -4.081751922147712e-12,   3.312615113039560e-14,  -2.570562397263582e-16,   1.571179702375873e-18,   4.130050697246753e-21,   1.104796412660444e-01,  -9.056315998454708e-04,
   7.423697122716804e-06,  -6.085282019038655e-08,   4.987264735842728e-10,  -4.081789752358779e-12,   3.312645914079135e-14,  -2.570551822383506e-16,   1.571021716412501e-18,
   4.135853604317738e-21,   1.867151839768866e-01,  -1.530353259181421e-03,   1.254222218237934e-05,  -1.027828178101128e-07,   8.420922572300537e-10,  -6.889348732825888e-12,
   5.588509537683403e-14,  -4.332695904230209e-16,   2.634823493789952e-18,   7.623640688768263e-21,   1.867169702745368e-01,  -1.530397174109235e-03,   1.254294187451829e-05,
  -1.027926327847645e-07,   8.422116732402839e-10,  -6.890642813084119e-12,   5.589547427760861e-14,  -4.332248727532110e-16,   2.629074278056253e-18,   7.833812162075347e-21,
   1.867199028454507e-01,  -1.530469270603893e-03,   1.254412343941260e-05,  -1.028087469853680e-07,   8.424077299025831e-10,  -6.892767155033938e-12,   5.591249621245764e-14,
  -4.331506778172280e-16,   2.619609349849899e-18,   8.179557659451552e-21,   1.867230146307382e-01,  -1.530545774680151e-03,   1.254537727136041e-05,  -1.028258472069402e-07,
   8.426157828451127e-10,  -6.895021108883304e-12,   5.593053504761822e-14,  -4.330708847561804e-16,   2.609530058486966e-18,   8.547392724936576e-21,   1.867254636951690e-01,
  -1.530605986775775e-03,   1.254636411629889e-05,  -1.028393064811310e-07,   8.427795372835844e-10,  -6.896794882377035e-12,   5.594471519837306e-14,  -4.330073138753698e-16,
   2.601571312483388e-18,   8.837585356474755e-21,   1.867268771274288e-01,  -1.530640737550417e-03,   1.254693367291614e-05,  -1.028470746165379e-07,   8.428740494535794e-10,
  -6.897818521406673e-12,   5.595289221274580e-14,  -4.329703155132709e-16,   2.596967616192990e-18,   9.005343755306543e-21,   1.867274078908330e-01,  -1.530653787038078e-03,
   1.254714755259107e-05,  -1.028499917278734e-07,   8.429095409000518e-10,  -6.898202900388018e-12,   5.595596150890307e-14,  -4.329563635534240e-16,   2.595236887553655e-18,
   9.068392127104078e-21,   1.867274958727566e-01,  -1.530655950189380e-03,   1.254718300649885e-05,  -1.028504752860677e-07,   8.429154241779205e-10,  -6.898266616301644e-12,
   5.595647022248567e-14,  -4.329540477182209e-16,   2.594949889240121e-18,   9.078846116046382e-21,   2.875526883981772e-01,  -2.356836667280963e-03,   1.931577970613687e-05,
  -1.582915482486293e-07,   1.296854619450665e-09,  -1.060876070563787e-11,   8.599650117945522e-14,  -6.639760700340266e-16,   3.925489725244958e-18,   1.635923838493335e-20,
   2.875554394044170e-01,  -2.356904298830570e-03,   1.931688805897273e-05,  -1.583066620335039e-07,   1.297038371544048e-09,  -1.061074345667328e-11,   8.601193874608783e-14,
  -6.638827230010980e-16,   3.915703838841813e-18,   1.671330458328468e-20,   2.875599557406939e-01,  -2.357015331635852e-03,   1.931870771304568e-05,  -1.583314757969396e-07,
   1.297340054062095e-09,  -1.061399825561735e-11,   8.603725356866601e-14,  -6.637281584738463e-16,   3.899593693403996e-18,   1.729577874098115e-20,   2.875647480779250e-01,
  -2.357133152372972e-03,   1.932063866094896e-05,  -1.583578078896501e-07,   1.297660194742293e-09,  -1.061745156491478e-11,   8.606407582608040e-14,  -6.635623567241568e-16,
   3.882438320455148e-18,   1.791548420934913e-20,   2.875685197850200e-01,  -2.357225882509616e-03,   1.932215843881754e-05,  -1.583785333918506e-07,   1.297912170443614e-09,
  -1.062016913066366e-11,   8.608515698878086e-14,  -6.634305669605116e-16,   3.868892544271285e-18,   1.840439506547235e-20,   2.875706965560407e-01,  -2.357279400727734e-03,
   1.932303557712997e-05,  -1.583904952888712e-07,   1.298057599883137e-09,  -1.062173740768871e-11,   8.609731205968095e-14,  -6.633539855946715e-16,   3.861057194423971e-18,
   1.868703614194665e-20,   2.875715139637297e-01,  -2.357299497699172e-03,   1.932336495975379e-05,  -1.583949872521920e-07,   1.298112211847493e-09,  -1.062232629551157e-11,
   8.610187427536676e-14,  -6.633251296170595e-16,   3.858111572942829e-18,   1.879326163602801e-20,   2.875716494612040e-01,  -2.357302829078229e-03,   1.932341956008499e-05,
  -1.583957318674302e-07,   1.298121264655312e-09,  -1.062242391126299e-11,   8.610263041527117e-14,  -6.633203411057481e-16,   3.857623116203852e-18,   1.881087483149317e-20,
   4.187770344038082e-01,  -3.432376407598020e-03,   2.813051001896519e-05,  -2.305272489115269e-07,   1.888632213407279e-09,  -1.544728752779952e-11,   1.250856146294831e-13,
  -9.596427474448011e-16,   5.419455270454190e-18,   3.428498975764761e-20,   4.187810408280041e-01,  -3.432474902514204e-03,   2.813212413077644e-05,  -2.305492557208738e-07,
   1.888899474401949e-09,  -1.545015228514746e-11,   1.251068675900932e-13,  -9.594513208057439e-16,   5.403073260971772e-18,   3.487085039664871e-20,   4.187876181881947e-01,
  -3.432636604660984e-03,   2.813477412164456e-05,  -2.305853864064484e-07,   1.889338259199595e-09,  -1.545485482430305e-11,   1.251417101548813e-13,  -9.591348781332537e-16,
   5.376104663415809e-18,   3.583468466774501e-20,   4.187945975019937e-01,  -3.432808192381222e-03,   2.813758619117730e-05,  -2.306237278606859e-07,   1.889803888078978e-09,
  -1.545984400341208e-11,   1.251786159845514e-13,  -9.587961343961777e-16,   5.347387019720766e-18,   3.686017439943333e-20,   4.188000904224802e-01,  -3.432943239512828e-03,
   2.813979946716670e-05,  -2.306539056857777e-07,   1.890170372494134e-09,  -1.546377009277674e-11,   1.252076140381962e-13,  -9.585273850340560e-16,   5.324712233227560e-18,
   3.766925970839345e-20,   4.188032605599873e-01,  -3.433021180536739e-03,   2.814107685715701e-05,  -2.306713230608066e-07,   1.890381890649394e-09,  -1.546603574636487e-11,
   1.252243304999366e-13,  -9.583714191026831e-16,   5.311596538856666e-18,   3.813700869701841e-20,   4.188044509905600e-01,  -3.433050448673482e-03,   2.814155654211267e-05,
  -2.306778636779611e-07,   1.890461320244312e-09,  -1.546688648972610e-11,   1.252306041249702e-13,  -9.583126886422620e-16,   5.306665861051774e-18,   3.831280626050166e-20,
   4.188046483221219e-01,  -3.433055300312843e-03,   2.814163605740970e-05,  -2.306789478904619e-07,   1.890474486964470e-09,  -1.546702751092069e-11,   1.252316438795598e-13,
  -9.583029445886172e-16,   5.305848234901034e-18,   3.834195530472763e-20,   5.917292030835317e-01,  -4.849925301683712e-03,   3.974821697533089e-05,  -3.257324156203662e-07,
   2.668531413921105e-09,  -2.182048285679908e-11,   1.763814331291298e-13,  -1.338624463820453e-15,   6.947354229468588e-18,   7.372197518616959e-20,   5.917348641331670e-01,
  -4.850064473861230e-03,   3.975049762026965e-05,  -3.257635014850496e-07,   2.668908240481545e-09,  -2.182447675257334e-11,   1.764085242316141e-13,  -1.338219758878411e-15,
   6.918980183196431e-18,   7.472497318107107e-20,   5.917441578975439e-01,  -4.850292957121576e-03,   3.975424190081233e-05,  -3.258145380697433e-07,   2.669526903766755e-09,
  -2.183103248721266e-11,   1.764529162002306e-13,  -1.337551628861775e-15,   6.872270087403902e-18,   7.637517710329107e-20,   5.917540196195716e-01,  -4.850535408578568e-03,
   3.975821518824725e-05,  -3.258686974119071e-07,   2.670183409662487e-09,  -2.183798741207907e-11,   1.764999072331967e-13,  -1.336837599051652e-15,   6.822530848988895e-18,
   7.813109547634722e-20,   5.917617810781410e-01,  -4.850726228604962e-03,   3.976134241542880e-05,  -3.259113251394528e-07,   2.670700123985602e-09,  -2.184346009038188e-11,
   1.765368079698229e-13,  -1.336271961114782e-15,   6.783258059661357e-18,   7.951658109364987e-20,   5.917662604604588e-01,  -4.850836358364104e-03,   3.976314729122189e-05,
  -3.259359280541561e-07,   2.670998346235334e-09,  -2.184661812449312e-11,   1.765580714026990e-13,  -1.335944038259714e-15,   6.760541704342220e-18,   8.031760346462073e-20,
   5.917679425306035e-01,  -4.850877713900258e-03,   3.976382505738808e-05,  -3.259451669993782e-07,   2.671110334736164e-09,  -2.184780393036424e-11,   1.765660498454740e-13,
  -1.335820619598664e-15,   6.752001791900298e-18,   8.061866602847886e-20,   5.917682213587323e-01,  -4.850884569210128e-03,   3.976393740774727e-05,  -3.259466985029408e-07,
   2.671128898595615e-09,  -2.184800049110485e-11,   1.765673720599811e-13,  -1.335800146392770e-15,   6.750585667558632e-18,   8.066858574135796e-20,   8.356630684686536e-01,
  -6.849253605235370e-03,   5.613395780018964e-05,  -4.600090582200624e-07,   3.768342860513437e-09,  -3.079751854384235e-11,   2.480471856937473e-13,  -1.839754439981358e-15,
   7.694817713557275e-18,   1.811099155734664e-19,   8.356710632197826e-01,  -6.849450148250736e-03,   5.613717837953754e-05,  -4.600529316235339e-07,   3.768872693099989e-09,
  -3.080300077608023e-11,   2.480766699020486e-13,  -1.838773162002104e-15,   7.638368251187847e-18,   1.830929638230800e-19,   8.356841882297864e-01,  -6.849772818978091e-03,
   5.614246580901556e-05,  -4.601249625503168e-07,   3.769742543926190e-09,  -3.081199859326893e-11,   2.481249089180426e-13,  -1.837154834296559e-15,   7.545434610060041e-18,
   1.863561406984533e-19,   8.356981153313018e-01,  -6.850115215988568e-03,   5.614807662515631e-05,  -4.602014005875909e-07,   3.770665583750596e-09,  -3.082154303608011e-11,
   2.481758708208098e-13,  -1.835427589093632e-15,   7.446467313318476e-18,   1.898290752430638e-19,   8.357090763603028e-01,  -6.850384697580123e-03,   5.615249268901545e-05,
  -4.602615632674660e-07,   3.771392064904247e-09,  -3.082905242957168e-11,   2.482158160142770e-13,  -1.834060931532330e-15,   7.368320305426297e-18,   1.925698688014583e-19,
   8.357154023155303e-01,  -6.850540226025839e-03,   5.615504141492967e-05,  -4.602962865480199e-07,   3.771811348969686e-09,  -3.083338539003495e-11,   2.482388040838944e-13,
  -1.833269273852901e-15,   7.323116106795294e-18,   1.941546739268146e-19,   8.357177777993944e-01,  -6.850598629514945e-03,   5.615599851125798e-05,  -4.603093259050125e-07,
   3.771968797625156e-09,  -3.083501229745227e-11,   2.482474240184352e-13,  -1.832971443693488e-15,   7.306121802999125e-18,   1.947503588544558e-19,   8.357181715711538e-01,
  -6.850608310782584e-03,   5.615615716496145e-05,  -4.603114873872251e-07,   3.771994897168502e-09,  -3.083528197207395e-11,   2.482488522460258e-13,  -1.832922044799980e-15,
   7.303303715451010e-18,   1.948491324914440e-19,   2.117667030101670e-03,  -1.680586215111486e-05,   1.333634787369735e-07,  -1.058239596172041e-09,   8.396188042864460e-12,
  -6.658505738966178e-14,   5.266075086044277e-16,  -4.103448557752281e-18,   2.970085639906831e-20,  -1.409860037609031e-22,   2.117686023134112e-03,  -1.680631427207088e-05,
   1.333706541500289e-07,  -1.058334455241975e-09,   8.397313547355025e-12,  -6.659733157972267e-14,   5.267256236599574e-16,  -4.104153039048710e-18,   2.968980967154084e-20,
  -1.403258518577260e-22,   2.117717204010747e-03,  -1.680705653110997e-05,   1.333824344472446e-07,  -1.058490194391751e-09,   8.399161427297182e-12,  -6.661748315982307e-14,
   5.269194962753138e-16,  -4.105307092704364e-18,   2.967157804776768e-20,  -1.392391972141380e-22,   2.117750290336712e-03,  -1.680784416516953e-05,   1.333949351983038e-07,
  -1.058655462839246e-09,   8.401122418297907e-12,  -6.663886759403540e-14,   5.271251659657875e-16,  -4.106528274830003e-18,   2.965210137341955e-20,  -1.380822156450078e-22,
   2.117776330177507e-03,  -1.680846406616931e-05,   1.334047740395173e-07,  -1.058785542410330e-09,   8.402665907743153e-12,  -6.665569873827851e-14,   5.272869970149038e-16,
  -4.107486915625839e-18,   2.963667776811440e-20,  -1.371687968178354e-22,   2.117791358570817e-03,  -1.680882183472570e-05,   1.334104525015504e-07,  -1.058860618859028e-09,
   8.403556757518696e-12,  -6.666541291410323e-14,   5.273803799796280e-16,  -4.108039187984996e-18,   2.962773823216056e-20,  -1.366404941376022e-22,   2.117797001937138e-03,
  -1.680895618256272e-05,   1.334125848723720e-07,  -1.058888811754237e-09,   8.403891294044618e-12,  -6.666906079578272e-14,   5.274154437688339e-16,  -4.108246386714008e-18,
   2.962437410820580e-20,  -1.364418935838606e-22,   2.117797937408795e-03,  -1.680897845275508e-05,   1.334129383460940e-07,  -1.058893485179870e-09,   8.403946748978482e-12,
  -6.666966549029554e-14,   5.274212559648141e-16,  -4.108280723103314e-18,   2.962381607446549e-20,  -1.364089612145383e-22,   1.915158948051611e-02,  -1.519875259703829e-04,
   1.206102069475628e-06,  -9.570423005893695e-09,   7.593273752582759e-11,  -6.021736834155518e-13,   4.762321968706331e-15,  -3.710234727872130e-17,   2.682736606707778e-19,
  -1.263156300579237e-21,   1.915176124819900e-02,  -1.519916148258727e-04,   1.206166961869132e-06,  -9.571280880375790e-09,   7.594291589635947e-11,  -6.022846625563931e-13,
   4.763388791562379e-15,  -3.710865529367711e-17,   2.681712872114776e-19,  -1.257102747368124e-21,   1.915204323934212e-02,  -1.519983276090468e-04,   1.206273499524166e-06,
  -9.572689334412993e-09,   7.595962698419113e-11,  -6.024668663011339e-13,   4.765139854064960e-15,  -3.711898830442857e-17,   2.680023393139040e-19,  -1.247138204551868e-21,
   1.915234246283701e-02,  -1.520054507512148e-04,   1.206386552758380e-06,  -9.574183968273303e-09,   7.597736097590865e-11,  -6.026602169106972e-13,   4.766997457765642e-15,
  -3.712992163498888e-17,   2.678218676899409e-19,  -1.236528789058547e-21,   1.915257795988727e-02,  -1.520110569624963e-04,   1.206475532437436e-06,  -9.575360365403042e-09,
   7.599131933929563e-11,  -6.028123981244010e-13,   4.768459104443049e-15,  -3.713850388618609e-17,   2.676789619318939e-19,  -1.228152836084941e-21,   1.915271387248070e-02,
  -1.520142925212668e-04,   1.206526886831451e-06,  -9.576039332259204e-09,   7.599937563255246e-11,  -6.029002301901375e-13,   4.769302529826887e-15,  -3.714344790313177e-17,
   2.675961375979199e-19,  -1.223308362722482e-21,   1.915276490951016e-02,  -1.520155075255330e-04,   1.206546171386075e-06,  -9.576294299584016e-09,   7.600240097340351e-11,
  -6.029332130073127e-13,   4.769619221816178e-15,  -3.714530273392420e-17,   2.675649699138877e-19,  -1.221487220109463e-21,   1.915277336965466e-02,  -1.520157089309245e-04,
   1.206549368101781e-06,  -9.576336564517058e-09,   7.600290247342230e-11,  -6.029386804342657e-13,   4.769671716851605e-15,  -3.714561010912639e-17,   2.675597999240527e-19,
  -1.221185234396250e-21,   5.373027574729081e-02,  -4.264049042089527e-04,   3.383750281522500e-06,  -2.685006442134256e-08,   2.130309896948359e-10,  -1.689396205160648e-12,
   1.335982322256013e-14,  -1.040440590413726e-16,   7.506942799669001e-19,  -3.473925400831847e-21,   5.373075764592896e-02,  -4.264163755966190e-04,   3.383932338568241e-06,
  -2.685247118403434e-08,   2.130595431577677e-10,  -1.689707411991257e-12,   1.336280813088899e-14,  -1.040613850291727e-16,   7.503925207743322e-19,  -3.456450543469467e-21,
   5.373154877931075e-02,  -4.264352084798716e-04,   3.384231232315244e-06,  -2.685642259484191e-08,   2.131064228916503e-10,  -1.690218345501145e-12,   1.336770745741003e-14,
  -1.040897631548936e-16,   7.498945832865286e-19,  -3.427685868673162e-21,   5.373238825849716e-02,  -4.264551926356662e-04,   3.384548405661838e-06,  -2.686061578250927e-08,
   2.131561721683660e-10,  -1.690760535833397e-12,   1.337290481661079e-14,  -1.041197856515246e-16,   7.493627614065340e-19,  -3.397059743805565e-21,   5.373304895150934e-02,
  -4.264709210034239e-04,   3.384798040116148e-06,  -2.686391615850362e-08,   2.131953296394174e-10,  -1.691187278896506e-12,   1.337699429005039e-14,  -1.041433490332715e-16,
   7.489416974161039e-19,  -3.372881015303393e-21,   5.373343025777470e-02,  -4.264799984455091e-04,   3.384942116001942e-06,  -2.686582099640720e-08,   2.132179299968645e-10,
  -1.691433575242789e-12,   1.337935405312101e-14,  -1.041569220338524e-16,   7.486976828283667e-19,  -3.358896582264054e-21,   5.373357344346936e-02,  -4.264834071707525e-04,
   3.384996219245443e-06,  -2.686653630586945e-08,   2.132264169988914e-10,  -1.691526064723312e-12,   1.338024010095899e-14,  -1.041620139326307e-16,   7.486058618149697e-19,
  -3.353639536235275e-21,   5.373359717862165e-02,  -4.264839722186799e-04,   3.385005187701886e-06,  -2.686665487991181e-08,   2.132278238590563e-10,  -1.691541396323776e-12,
   1.338038697255114e-14,  -1.041628577292327e-16,   7.485906310822337e-19,  -3.352767802061600e-21,   1.069648406572230e-01,  -8.488758335218353e-04,   6.736282298314096e-06,
  -5.345240312708062e-08,   4.240957569124421e-10,  -3.363149761802646e-12,   2.659318580622315e-14,  -2.069746691843421e-16,   1.488138340191023e-18,  -6.689206261279037e-21,
   1.069658000085317e-01,  -8.488986704588497e-04,   6.736644732024757e-06,  -5.345719436352723e-08,   4.241525932546159e-10,  -3.363768826098737e-12,   2.659910189886891e-14,
  -2.070079572937843e-16,   1.487490331911668e-18,  -6.652816789368334e-21,   1.069673749763465e-01,  -8.489361624677368e-04,   6.737239760734411e-06,  -5.346506059078969e-08,
   4.242459084320636e-10,  -3.364785191622037e-12,   2.660881222598919e-14,  -2.070624691605442e-16,   1.486421223481131e-18,  -6.592917714522994e-21,   1.069690461897350e-01,
  -8.489759463996987e-04,   6.737871179916795e-06,  -5.347340813198993e-08,   4.243449354456709e-10,  -3.365863730728526e-12,   2.661911304777121e-14,  -2.071201253669485e-16,
   1.485279606441610e-18,  -6.529142659630060e-21,   1.069703614802455e-01,  -8.490072580206972e-04,   6.738368144694369e-06,  -5.347997831790784e-08,   4.244228792012191e-10,
  -3.366712616584092e-12,   2.662721796985033e-14,  -2.071653668319854e-16,   1.484375919492899e-18,  -6.478793691979342e-21,   1.069711205748675e-01,  -8.490253291537236e-04,
   6.738654966640860e-06,  -5.348377035207338e-08,   4.244678656641019e-10,  -3.367202553192833e-12,   2.663189472357577e-14,  -2.071914226585227e-16,   1.483852285726359e-18,
  -6.449673058236516e-21,   1.069714056252342e-01,  -8.490321151543094e-04,   6.738762673752838e-06,  -5.348519434612806e-08,   4.244847592081554e-10,  -3.367386534545200e-12,
   2.663365074808667e-14,  -2.072011966813064e-16,   1.483655259121317e-18,  -6.438726006719503e-21,   1.069714528765597e-01,  -8.490332400368659e-04,   6.738780527886507e-06,
  -5.348543039603216e-08,   4.244875595907593e-10,  -3.367417032366451e-12,   2.663394182673350e-14,  -2.072028163271878e-16,   1.483622578194599e-18,  -6.436910744908634e-21,
   1.807869451303691e-01,  -1.434730026011534e-03,   1.138534745935637e-05,  -9.034271535075027e-08,   7.167846520127261e-10,  -5.684095161602815e-12,   4.493844603490729e-14,
  -3.494294731983769e-16,   2.499102204106742e-18,  -1.072802778555201e-20,   1.807885665808185e-01,  -1.434768623918074e-03,   1.138596002591462e-05,  -9.035081306033292e-08,
   7.168806960275667e-10,  -5.685140262024230e-12,   4.494837854563691e-14,  -3.494826644565378e-16,   2.497886005328133e-18,  -1.066241169016175e-20,   1.807912285173248e-01,
  -1.434831991131136e-03,   1.138696571239998e-05,  -9.036410783687999e-08,   7.170383831374993e-10,  -5.686856077293741e-12,   4.496468081259608e-14,  -3.495697413734334e-16,
   2.495879897036315e-18,  -1.055440429636780e-20,   1.807940531235715e-01,  -1.434899232043652e-03,   1.138803290414873e-05,  -9.037821608445359e-08,   7.172057221615288e-10,
  -5.688676844269138e-12,   4.498197392862087e-14,  -3.496618029551341e-16,   2.493738302945027e-18,  -1.043940832291332e-20,   1.807962761657140e-01,  -1.434952153458450e-03,
   1.138887284806844e-05,  -9.038932040811960e-08,   7.173374339198113e-10,  -5.690109908981180e-12,   4.499558017897169e-14,  -3.497340137917510e-16,   2.492043460896610e-18,
  -1.034862189216636e-20,   1.807975591517323e-01,  -1.434982696429252e-03,   1.138935761954248e-05,  -9.039572935484020e-08,   7.174134533899195e-10,  -5.690937003282328e-12,
   4.500343119606650e-14,  -3.497755908747713e-16,   2.491061563256613e-18,  -1.029611331802857e-20,   1.807980409304517e-01,  -1.434994165805155e-03,   1.138953966047706e-05,
  -9.039813605828095e-08,   7.174420005981916e-10,  -5.691247593844071e-12,   4.500637906294107e-14,  -3.497911850923806e-16,   2.490692137585285e-18,  -1.027637427549019e-20,
   1.807981207924191e-01,  -1.434996067028227e-03,   1.138956983660113e-05,  -9.039853500805714e-08,   7.174467327667883e-10,  -5.691299079119752e-12,   4.500686769991501e-14,
  -3.497937690865372e-16,   2.490630862346740e-18,  -1.027310110942729e-20,   2.784228416596434e-01,  -2.209571106576370e-03,   1.753412398959773e-05,  -1.391331986564050e-07,
   1.103887118502682e-09,  -8.753528417482895e-12,   6.918953144439127e-14,  -5.372558750866919e-16,   3.812015277880017e-18,  -1.519558530125053e-20,   2.784253387914374e-01,
  -2.209630549665109e-03,   1.753506737498688e-05,  -1.391456691373848e-07,   1.104034991014526e-09,  -8.755135172423747e-12,   6.920467584548852e-14,  -5.373307411836870e-16,
   3.809863112721332e-18,  -1.508498879938042e-20,   2.784294383347108e-01,  -2.209728138969841e-03,   1.753661618614538e-05,  -1.391661431039416e-07,   1.104277771023631e-09,
  -8.757773080537500e-12,   6.922953154148285e-14,  -5.374532328089893e-16,   3.806313997554439e-18,  -1.490294143274524e-20,   2.784337883992257e-01,  -2.209831694003615e-03,
   1.753825971867543e-05,  -1.391878698126840e-07,   1.104535411106441e-09,  -8.760572321679386e-12,   6.925589678284050e-14,  -5.375826433392260e-16,   3.802526352643745e-18,
  -1.470911479304149e-20,   2.784372120186236e-01,  -2.209913196152850e-03,   1.753955327733546e-05,  -1.392049704742231e-07,   1.104738198174320e-09,  -8.762775495718988e-12,
   6.927664013917966e-14,  -5.376840820241387e-16,   3.799529677670866e-18,  -1.455609354608755e-20,   2.784391878947148e-01,  -2.209960234157609e-03,   1.754029985138066e-05,
  -1.392148402528365e-07,   1.104855239762285e-09,  -8.764047053165264e-12,   6.928860903301366e-14,  -5.377424604362976e-16,   3.797793905194038e-18,  -1.446758993029663e-20,
   2.784399298630912e-01,  -2.209977897683579e-03,   1.754058020417216e-05,  -1.392185465761722e-07,   1.104899191782230e-09,  -8.764524547452411e-12,   6.929310299783873e-14,
  -5.377643511131685e-16,   3.797140907466970e-18,  -1.443431961814858e-20,   2.784400528553528e-01,  -2.209980825681004e-03,   1.754062667701971e-05,  -1.392191609588224e-07,
   1.104906477550434e-09,  -8.764603699588538e-12,   6.929384791181845e-14,  -5.377679781701996e-16,   3.797032600529103e-18,  -1.442880267086221e-20,   4.054807924225623e-01,
  -3.217906391475030e-03,   2.553580078333810e-05,  -2.026263620874349e-07,   1.607634613521819e-09,  -1.274748401644403e-11,   1.007235395866099e-13,  -7.804672829030732e-16,
   5.469724258687638e-18,  -1.915599192099391e-20,   4.054844291174857e-01,  -3.217992961297489e-03,   2.553717467240656e-05,  -2.026445223999646e-07,   1.607849876863530e-09,
  -1.274981788670814e-11,   1.007452556256421e-13,  -7.805604910163124e-16,   5.465958998672755e-18,  -1.897316893355226e-20,   4.054903994824635e-01,  -3.218135085284377e-03,
   2.553943026666431e-05,  -2.026743378941581e-07,   1.608203299950944e-09,  -1.275364951068209e-11,   1.007808950239897e-13,  -7.807128241731674e-16,   5.459751380085023e-18,
  -1.867223101179052e-20,   4.054967346937526e-01,  -3.218285897448252e-03,   2.554182380728287e-05,  -2.027059777027796e-07,   1.608578354647760e-09,  -1.275771542845646e-11,
   1.008186961962492e-13,  -7.808735314640962e-16,   5.453128774094381e-18,  -1.835181810723350e-20,   4.055017206777950e-01,  -3.218404592938025e-03,   2.554370766722911e-05,
  -2.027308807624291e-07,   1.608873557590937e-09,  -1.276091552094705e-11,   1.008484350358138e-13,  -7.809993343357599e-16,   5.447890756673608e-18,  -1.809885802061765e-20,
   4.055045982425923e-01,  -3.218473096640744e-03,   2.554479493211718e-05,  -2.027452537527618e-07,   1.609043938177946e-09,  -1.276276243438795e-11,   1.008655935289071e-13,
  -7.810716667897978e-16,   5.444857362308728e-18,  -1.795255142912155e-20,   4.055056788073556e-01,  -3.218498820880897e-03,   2.554520322081308e-05,  -2.027506511326740e-07,
   1.609107920276510e-09,  -1.276345598337159e-11,   1.008720358858992e-13,  -7.810987771026349e-16,   5.443716319201075e-18,  -1.789755163335672e-20,   4.055058579269895e-01,
  -3.218503085063996e-03,   2.554527090103185e-05,  -2.027515458351007e-07,   1.609118526356730e-09,  -1.276357094981364e-11,   1.008731037550841e-13,  -7.811032683205073e-16,
   5.443527070831063e-18,  -1.788843145235359e-20,   5.729417004801073e-01,  -4.546880615470960e-03,   3.608191683652977e-05,  -2.863094589271906e-07,   2.271553985677687e-09,
  -1.801048557045361e-11,   1.422278007295479e-13,  -1.098209966893613e-15,   7.535843860681887e-18,  -1.999418677665656e-20,   5.729468391058284e-01,  -4.547002937941942e-03,
   3.608385811178653e-05,  -2.863351168947860e-07,   2.271857941377720e-09,  -1.801376900634886e-11,   1.422576852739880e-13,  -1.098304001172398e-15,   7.529004040754419e-18,
  -1.968275256182466e-20,   5.729552751918012e-01,  -4.547203758004882e-03,   3.608704521709429e-05,  -2.863772419802762e-07,   2.272356979898345e-09,  -1.801915949554540e-11,
   1.423067256355550e-13,  -1.098457210002568e-15,   7.517730585829499e-18,  -1.917009907297947e-20,   5.729642268031802e-01,  -4.547416854391743e-03,   3.609042723741206e-05,
  -2.864219445446373e-07,   2.272886560904883e-09,  -1.802487948863808e-11,   1.423587340582625e-13,  -1.098618192073533e-15,   7.505707623671384e-18,  -1.862425106701034e-20,
   5.729712719654387e-01,  -4.547584570173030e-03,   3.609308909000626e-05,  -2.864571290232118e-07,   2.273303389226907e-09,  -1.802938134580319e-11,   1.423996452171223e-13,
  -1.098743736479746e-15,   7.496201284952279e-18,  -1.819330064567423e-20,   5.729753379453396e-01,  -4.547681365358830e-03,   3.609462537128392e-05,  -2.864774360068785e-07,
   2.273543967151339e-09,  -1.803197953242624e-11,   1.424232479144319e-13,  -1.098815729170587e-15,   7.490697248296361e-18,  -1.794404290779234e-20,   5.729768647761558e-01,
  -4.547717713505022e-03,   3.609520227418550e-05,  -2.864850617331443e-07,   2.273634309984072e-09,  -1.803295519181663e-11,   1.424321094604580e-13,  -1.098842675837433e-15,
   7.488627071458282e-18,  -1.785034053365545e-20,   5.729771178710061e-01,  -4.547723738761732e-03,   3.609529790483794e-05,  -2.864863258197183e-07,   2.273649285782670e-09,
  -1.803311692208865e-11,   1.424335783092887e-13,  -1.098847138025341e-15,   7.488283732885213e-18,  -1.783480255602827e-20,   8.091306245533223e-01,  -6.421282183856036e-03,
   5.095628488348395e-05,  -4.043366779857976e-07,   3.207913536407832e-09,  -2.543059475255914e-11,   2.005954242272829e-13,  -1.537845052333310e-15,   1.008288566383593e-17,
  -7.333466969863462e-21,   8.091378815201065e-01,  -6.421454932094735e-03,   5.095902637044600e-05,  -4.043729063955233e-07,   3.208342202727445e-09,  -2.543519083887554e-11,
   2.006353029879347e-13,  -1.537866319549003e-15,   1.006862966420723e-17,  -6.728924881552587e-21,   8.091497952882970e-01,  -6.421738537483238e-03,   5.096352722981771e-05,
  -4.044323859226961e-07,   3.209045989256449e-09,  -2.544273609388684e-11,   2.007007288693074e-13,  -1.537898973604005e-15,   1.004513866367016e-17,  -5.733695961200696e-21,
   8.091624371014755e-01,  -6.422039479939439e-03,   5.096830334945367e-05,  -4.044955047259911e-07,   3.209792844559434e-09,  -2.545074223817730e-11,   2.007700941659208e-13,
  -1.537930545518881e-15,   1.002009382779883e-17,  -4.673904197729380e-21,   8.091723865531729e-01,  -6.422276334254308e-03,   5.097206244136203e-05,  -4.045451842099314e-07,
   3.210380683965312e-09,  -2.545704314668109e-11,   2.008246439149086e-13,  -1.537953160802974e-15,   1.000029705236849e-17,  -3.837103830129026e-21,   8.091781286878638e-01,
  -6.422413031928764e-03,   5.097423199129976e-05,  -4.045738570771640e-07,   3.210719961766635e-09,  -2.546067953586769e-11,   2.008561091291843e-13,  -1.537965316367579e-15,
   9.988837280539256e-18,  -3.353070840081585e-21,   8.091802849376262e-01,  -6.422464364099870e-03,   5.097504669862572e-05,  -4.045846243765491e-07,   3.210847368524973e-09,
  -2.546204503829126e-11,   2.008679215046901e-13,  -1.537969711344528e-15,   9.984527464255647e-18,  -3.171103732076629e-21,   8.091806423680008e-01,  -6.422472873186041e-03,
   5.097518174906848e-05,  -4.045864092291452e-07,   3.210868488259911e-09,  -2.546227138997349e-11,   2.008698794100293e-13,  -1.537970430925623e-15,   9.983812704410075e-18,
  -3.140929107377927e-21,   2.052500067040009e-03,  -1.578756299287258e-05,   1.214288136621522e-07,  -9.339046963196242e-10,   7.182100083261388e-12,  -5.522282660763448e-14,
   4.241983263784820e-16,  -3.241170620029663e-18,   2.410482345206971e-20,  -1.572415502203686e-22,   2.052517359594761e-03,  -1.578796197531377e-05,   1.214349511932125e-07,
  -9.339833643585259e-10,   7.183006722845155e-12,  -5.523252549228280e-14,   4.242944174671271e-16,  -3.241971812672097e-18,   2.410691856918549e-20,  -1.570799275151516e-22,
   2.052545748755021e-03,  -1.578861699387689e-05,   1.214450275039543e-07,  -9.341125206614451e-10,   7.184495266777234e-12,  -5.524844950931872e-14,   4.244521724033451e-16,
  -3.243286493807630e-18,   2.411032740867433e-20,  -1.568135625799526e-22,   2.052575872708648e-03,  -1.578931205224723e-05,   1.214557200098896e-07,  -9.342495790536081e-10,
   7.186074928532627e-12,  -5.526534847026392e-14,   4.246195705031833e-16,  -3.244680646040546e-18,   2.411390274407209e-20,  -1.565295200166898e-22,   2.052599581041495e-03,
  -1.578985909076813e-05,   1.214641356196176e-07,  -9.343574545562716e-10,   7.187318276602370e-12,  -5.527864974089285e-14,   4.247513193835239e-16,  -3.245777251419833e-18,
   2.411668629831024e-20,  -1.563049554754801e-22,   2.052613263833744e-03,  -1.579017480698887e-05,   1.214689926535854e-07,  -9.344197155580552e-10,   7.188035895598916e-12,
  -5.528632684535631e-14,   4.248273565093302e-16,  -3.246409882868433e-18,   2.411828059612489e-20,  -1.561749448869902e-22,   2.052618401905503e-03,  -1.579029336338250e-05,
   1.214708165599171e-07,  -9.344430959280298e-10,   7.188305379727720e-12,  -5.528920980313283e-14,   4.248559096338582e-16,  -3.246647396659073e-18,   2.411887697290764e-20,
  -1.561260470628142e-22,   2.052619253616932e-03,  -1.579031301589739e-05,   1.214711189007026e-07,  -9.344469715983009e-10,   7.188350051162856e-12,  -5.528968770143979e-14,
   4.248606427454773e-16,  -3.246686765561911e-18,   2.411897570961700e-20,  -1.561179374556624e-22,   1.856223765778030e-02,  -1.427783126565455e-04,   1.098168293296768e-06,
  -8.445973256151620e-09,   6.495289756950605e-11,  -4.994190753171462e-13,   3.836287668910133e-15,  -2.931010992227143e-17,   2.179073946920171e-19,  -1.418741689262721e-21,
   1.856239404681816e-02,  -1.427819209423133e-04,   1.098223799404694e-06,  -8.446684706807135e-09,   6.496109686733372e-11,  -4.995067826669983e-13,   3.837156316804264e-15,
  -2.931733806750579e-17,   2.179256290660121e-19,  -1.417254975742495e-21,   1.856265079045854e-02,  -1.427878447472602e-04,   1.098314926730270e-06,  -8.447852758497788e-09,
   6.497455868251646e-11,  -4.996507840673641e-13,   3.838582393851283e-15,  -2.932919866131143e-17,   2.179552831009660e-19,  -1.414804815441899e-21,   1.856292322308585e-02,
  -1.427941306610405e-04,   1.098411626752106e-06,  -8.449092274354663e-09,   6.498884453125304e-11,  -4.998036018661746e-13,   3.840095640616873e-15,  -2.934177606986899e-17,
   2.179863662483135e-19,  -1.412192104450745e-21,   1.856313763462978e-02,  -1.427990779246423e-04,   1.098487735163805e-06,  -8.450067868720575e-09,   6.500008888878985e-11,
  -4.999238856092008e-13,   3.841286623236952e-15,  -2.935166903999326e-17,   2.180105516961482e-19,  -1.410126531829962e-21,   1.856326137798325e-02,  -1.428019331739667e-04,
   1.098531660815373e-06,  -8.450630938933594e-09,   6.500657875634065e-11,  -4.999933098536401e-13,   3.841973982308062e-15,  -2.935737625019584e-17,   2.180243983235930e-19,
  -1.408930694697847e-21,   1.856330784526991e-02,  -1.428030053648792e-04,   1.098548155712162e-06,  -8.450842384131920e-09,   6.500901586611727e-11,  -5.000193805089013e-13,
   3.842232096186327e-15,  -2.935951894487543e-17,   2.180295768188093e-19,  -1.408480935711006e-21,   1.856331554791032e-02,  -1.428031830967352e-04,   1.098550889997341e-06,
  -8.450877434555389e-09,   6.500941985722124e-11,  -5.000237021544301e-13,   3.842274882451724e-15,  -2.935987410504334e-17,   2.180304341174795e-19,  -1.408406344238541e-21,
   5.207683408522323e-02,  -4.005682200422178e-04,   3.080939321635251e-06,  -2.369539399962882e-08,   1.822269581751055e-10,  -1.401128621362545e-12,   1.076254815131128e-14,
  -8.221776192824542e-17,   6.108172083274430e-19,  -3.960891137957822e-21,   5.207727283868115e-02,  -4.005783431802084e-04,   3.081095045388584e-06,  -2.369738998609256e-08,
   1.822499609443600e-10,  -1.401374647554882e-12,   1.076498297561277e-14,  -8.223793718273404e-17,   6.108641708495659e-19,  -3.956572685783539e-21,   5.207799313955110e-02,
  -4.005949625664647e-04,   3.081350705345304e-06,  -2.370066697419700e-08,   1.822877274711513e-10,  -1.401778582881352e-12,   1.076898026448620e-14,  -8.227104193217568e-17,
   6.109404589031614e-19,  -3.949455954661994e-21,   5.207875745627640e-02,  -4.006125978583097e-04,   3.081621999638174e-06,  -2.370414445613303e-08,   1.823278057830749e-10,
  -1.402207248604761e-12,   1.077322187332634e-14,  -8.230614656252119e-17,   6.110203056632245e-19,  -3.941867406946739e-21,   5.207935899336371e-02,  -4.006264775328466e-04,
   3.081835523661307e-06,  -2.370688150198567e-08,   1.823593513237004e-10,  -1.402544653573362e-12,   1.077656016848619e-14,  -8.233375806980157e-17,   6.110823470053151e-19,
  -3.935868244111454e-21,   5.207970615851653e-02,  -4.006344880078345e-04,   3.081958758158275e-06,  -2.370846120460555e-08,   1.823775583546431e-10,  -1.402739393726604e-12,
   1.077848681436196e-14,  -8.234968677400757e-17,   6.111178317147608e-19,  -3.932395199115820e-21,   5.207983652368139e-02,  -4.006374960668554e-04,   3.082005034997310e-06,
  -2.370905441753770e-08,   1.823843955560408e-10,  -1.402812523831206e-12,   1.077921029854463e-14,  -8.235566694252868e-17,   6.111310959276821e-19,  -3.931088991211668e-21,
   5.207985813363667e-02,  -4.006379946981219e-04,   3.082012706101697e-06,  -2.370915275206887e-08,   1.823855289348221e-10,  -1.402824646363752e-12,   1.077933022690379e-14,
  -8.235665817674694e-17,   6.111332914599309e-19,  -3.930872360633896e-21,   1.036732118426201e-01,  -7.974408325294667e-04,   6.133454146844056e-06,  -4.717217409154308e-08,
   3.627725047903731e-10,  -2.789316370838252e-12,   2.142497987254300e-14,  -1.636366800505151e-16,   1.214295711298996e-18,  -7.822420779067895e-21,   1.036740853016317e-01,
  -7.974609854092156e-04,   6.133764157474410e-06,  -4.717614762842487e-08,   3.628182962680760e-10,  -2.789806027566936e-12,   2.142981998704537e-14,  -1.636765096878160e-16,
   1.214375611482158e-18,  -7.813344966057339e-21,   1.036755192579336e-01,  -7.974940708509993e-04,   6.134273118390548e-06,  -4.718267133641253e-08,   3.628934778604668e-10,
  -2.790609964229890e-12,   2.143776603903950e-14,  -1.637418624509667e-16,   1.214505102021190e-18,  -7.798388936881060e-21,   1.036770408398593e-01,  -7.975291787311896e-04,
   6.134813203718008e-06,  -4.718959418000675e-08,   3.629732614946323e-10,  -2.791463119867502e-12,   2.144619771166913e-14,  -1.638111604149898e-16,   1.214640216252017e-18,
  -7.782442382305708e-21,   1.036782383643010e-01,  -7.975568100261456e-04,   6.135238281556640e-06,  -4.719504299045438e-08,   3.630360589859861e-10,  -2.792134642303079e-12,
   2.145283369551948e-14,  -1.638656646136575e-16,   1.214744894176025e-18,  -7.769836486577150e-21,   1.036789294916887e-01,  -7.975727570713377e-04,   6.135483613453025e-06,
  -4.719818780441170e-08,   3.630723035933304e-10,  -2.792522224879497e-12,   2.145666353632649e-14,  -1.638971065286587e-16,   1.214804640346192e-18,  -7.762538952501737e-21,
   1.036791890192799e-01,  -7.975787454369732e-04,   6.135575740129792e-06,  -4.719936875092014e-08,   3.630859143608440e-10,  -2.792667772387338e-12,   2.145810169557208e-14,
  -1.639089107206757e-16,   1.214826949717467e-18,  -7.759794413933216e-21,   1.036792320398188e-01,  -7.975797380991252e-04,   6.135591011556467e-06,  -4.719956451169111e-08,
   3.630881705697675e-10,  -2.792691899307501e-12,   2.145834009189137e-14,  -1.639108672993411e-16,   1.214830641169808e-18,  -7.759339243516324e-21,   1.752235888538976e-01,
  -1.347797006226449e-03,   1.036647581022655e-05,  -7.972818533313683e-08,   6.131405267008129e-10,  -4.714335696638310e-12,   3.620942004540855e-14,  -2.764691324359122e-16,
   2.048030152302771e-18,  -1.306154065496014e-20,   1.752250651332490e-01,  -1.347831067673768e-03,   1.036699977516111e-05,  -7.973490116486515e-08,   6.132179166632472e-10,
  -4.715162973267462e-12,   3.621758266229399e-14,  -2.765356002427108e-16,   2.048130569608335e-18,  -1.304497754743294e-20,   1.752274887387656e-01,  -1.347886987127764e-03,
   1.036785999621842e-05,  -7.974592714124262e-08,   6.133449774102212e-10,  -4.716521225060891e-12,   3.623098319124855e-14,  -2.766446558093089e-16,   2.048292406980409e-18,
  -1.301768496733585e-20,   1.752300604449916e-01,  -1.347946324811791e-03,   1.036877282224236e-05,  -7.975762771201931e-08,   6.134798158066694e-10,  -4.717962629905869e-12,
   3.624520255350287e-14,  -2.767602875938082e-16,   2.048460025693756e-18,  -1.298858720593612e-20,   1.752320844444951e-01,  -1.347993025923902e-03,   1.036949126818420e-05,
  -7.976683696096314e-08,   6.135859467315456e-10,  -4.719097164015945e-12,   3.625639352707338e-14,  -2.768512289996297e-16,   2.048588966044508e-18,  -1.296558688105843e-20,
   1.752332525555090e-01,  -1.348019978867886e-03,   1.036990591625299e-05,  -7.977215213464875e-08,   6.136472019335655e-10,  -4.719751982305884e-12,   3.626285216003782e-14,
  -2.769036883907875e-16,   2.048662185088250e-18,  -1.295227271400200e-20,   1.752336911968405e-01,  -1.348030100121169e-03,   1.037006162429224e-05,  -7.977414809873881e-08,
   6.136702048104208e-10,  -4.719997883756333e-12,   3.626527746031390e-14,  -2.769233827440581e-16,   2.048689453488961e-18,  -1.294726550192925e-20,   1.752337639081324e-01,
  -1.348031777871941e-03,   1.037008743531666e-05,  -7.977447896170741e-08,   6.136740179160745e-10,  -4.720038646004419e-12,   3.626567948956832e-14,  -2.769266471185061e-16,
   2.048693961684694e-18,  -1.294643508324857e-20,   2.698549361532556e-01,  -2.075688994498553e-03,   1.596500030333658e-05,  -1.227862199718403e-07,   9.442723968637282e-10,
  -7.260281970710608e-12,   5.576001402856300e-14,  -4.255482943943220e-16,   3.144278067106519e-18,  -1.975143911431518e-20,   2.698572097128242e-01,  -2.075741451183876e-03,
   1.596580724002890e-05,  -1.227965626387337e-07,   9.443915716039965e-10,  -7.261555305567854e-12,   5.577254419890162e-14,  -4.256487173807468e-16,   3.144353330861881e-18,
  -1.972311233388722e-20,   2.698609422120342e-01,  -2.075827570519113e-03,   1.596713203084111e-05,  -1.228135431112191e-07,   9.445872355666073e-10,  -7.263645907290918e-12,
   5.579311468976471e-14,  -4.258134717941832e-16,   3.144471837141637e-18,  -1.967643923690578e-20,   2.698649027953018e-01,  -2.075918954134918e-03,   1.596853783637416e-05,
  -1.228315624867579e-07,   9.447948764379920e-10,  -7.265864491391484e-12,   5.581494181847298e-14,  -4.259881443171629e-16,   3.144590704266856e-18,  -1.962668395452749e-20,
   2.698680198770609e-01,  -2.075990876667024e-03,   1.596964428519119e-05,  -1.228457451202172e-07,   9.449583099260059e-10,  -7.267610741571795e-12,   5.583212005676257e-14,
  -4.261255075115228e-16,   3.144679264628612e-18,  -1.958735839611885e-20,   2.698698188387343e-01,  -2.076032385827958e-03,   1.597028286749308e-05,  -1.228539307125397e-07,
   9.450526382164792e-10,  -7.268618621980063e-12,   5.584203402137765e-14,  -4.262047403180979e-16,   3.144728371731379e-18,  -1.956459546212200e-20,   2.698704943729382e-01,
  -2.076047973169050e-03,   1.597052266698911e-05,  -1.228570045816176e-07,   9.450880608694548e-10,  -7.268997107211001e-12,   5.584575682616328e-14,  -4.262344850418513e-16,
   3.144746433014794e-18,  -1.955603500720614e-20,   2.698706063527294e-01,  -2.076050557006526e-03,   1.597056241747772e-05,  -1.228575141245736e-07,   9.450939327572850e-10,
  -7.269059847405645e-12,   5.584637393499670e-14,  -4.262394152341717e-16,   3.144749406932203e-18,  -1.955461531656606e-20,   3.930029328830375e-01,  -3.022927332294353e-03,
   2.325061001283528e-05,  -1.788195457658028e-07,   1.375187570266708e-09,  -1.057332802998252e-11,   8.119577242510173e-14,  -6.192387733781447e-16,   4.557471100269922e-18,
  -2.795549290888206e-20,   3.930062439789220e-01,  -3.023003727516312e-03,   2.325178519193738e-05,  -1.788346080339514e-07,   1.375361107285550e-09,  -1.057518086225572e-11,
   8.121393057407180e-14,  -6.193807058042767e-16,   4.557403029325572e-18,  -2.790788578046193e-20,   3.930116797998888e-01,  -3.023129147292372e-03,   2.325371454585129e-05,
  -1.788593370922937e-07,   1.375646024410786e-09,  -1.057822289212220e-11,   8.124373987156822e-14,  -6.196135324657628e-16,   4.557282991773392e-18,  -2.782945180290123e-20,
   3.930174477908122e-01,  -3.023262233696122e-03,   2.325576188521727e-05,  -1.788855791271780e-07,   1.375948381588674e-09,  -1.058145113636761e-11,   8.127536949711406e-14,
  -6.198603365356008e-16,   4.557144338653635e-18,  -2.774584731179396e-20,   3.930219873492760e-01,  -3.023366977977192e-03,   2.325737325759158e-05,  -1.789062336238986e-07,
   1.376186365852961e-09,  -1.058399208218202e-11,   8.130026191994841e-14,  -6.200543962387391e-16,   4.557027032439233e-18,  -2.767977458212062e-20,   3.930246072650564e-01,
  -3.023427429786800e-03,   2.325830325440469e-05,  -1.789181544904352e-07,   1.376323722279534e-09,  -1.058545863215074e-11,   8.131462771681966e-14,  -6.201663210316834e-16,
   4.556956046459892e-18,  -2.764153211629485e-20,   3.930255910785235e-01,  -3.023450130389620e-03,   2.325865248545250e-05,  -1.789226310366133e-07,   1.376375303072894e-09,
  -1.058600935900748e-11,   8.132002219574652e-14,  -6.202083364941666e-16,   4.556928768769208e-18,  -2.762715076797345e-20,   3.930257541601646e-01,  -3.023453893357784e-03,
   2.325871037591936e-05,  -1.789233730957232e-07,   1.376383853437930e-09,  -1.058610065106751e-11,   8.132091640674467e-14,  -6.202153004505929e-16,   4.556924214286564e-18,
  -2.762476574948037e-20,   5.553105668093409e-01,  -4.271376493058359e-03,   3.285295895225972e-05,  -2.526707832054352e-07,   1.943125419810882e-09,  -1.493964368272549e-11,
   1.147055807517170e-13,  -8.738080682376419e-16,   6.389225806971629e-18,  -3.760219151098546e-20,   5.553152453660275e-01,  -4.271484438977281e-03,   3.285461946754407e-05,
  -2.526920654919529e-07,   1.943370573783857e-09,  -1.494225805648815e-11,   1.147310282838215e-13,  -8.739984795273444e-16,   6.388708385481956e-18,  -3.751969127640981e-20,
   5.553229261452669e-01,  -4.271661656251034e-03,   3.285734562359862e-05,  -2.527270065010409e-07,   1.943773072974915e-09,  -1.494655038409382e-11,   1.147728029569981e-13,
  -8.743107614286153e-16,   6.387844980049559e-18,  -3.738378172741029e-20,   5.553310762784677e-01,  -4.271849706416281e-03,   3.286023849176638e-05,  -2.527640852704752e-07,
   1.944200209094733e-09,  -1.495110543225239e-11,   1.148171269591546e-13,  -8.746416956753118e-16,   6.386909813979566e-18,  -3.723892863922280e-20,   5.553374906446896e-01,
  -4.271997709358610e-03,   3.286251534330305e-05,  -2.527932691057759e-07,   1.944536406106144e-09,  -1.495469068195942e-11,   1.148520086042138e-13,  -8.749018371016496e-16,
   6.386160031262038e-18,  -3.712446250221801e-20,   5.553411925684385e-01,  -4.272083127346033e-03,   3.286382941861285e-05,  -2.528101127296836e-07,   1.944730447464355e-09,
  -1.495675996106827e-11,   1.148721388455502e-13,  -8.750518470700071e-16,   6.385721775654437e-18,  -3.705821480874056e-20,   5.553425826903901e-01,  -4.272115203140254e-03,
   3.286432287825549e-05,  -2.528164378786671e-07,   1.944803314851402e-09,  -1.495753702644445e-11,   1.148796978300483e-13,  -8.751081540766687e-16,   6.385556157899602e-18,
  -3.703330275695773e-20,   5.553428131236753e-01,  -4.272120520188151e-03,   3.286440467685049e-05,  -2.528174863732368e-07,   1.944815393818250e-09,  -1.495766583776171e-11,
   1.148809508335107e-13,  -8.751174865428727e-16,   6.385528649051970e-18,  -3.702917136038171e-20,   7.842312497196648e-01,  -6.032204537955160e-03,   4.639622912998968e-05,
  -3.568313722436195e-07,   2.744142409489453e-09,  -2.109725712283820e-11,   1.619267693237134e-13,  -1.230747953434772e-15,   8.880059490185373e-18,  -4.763473803680545e-20,
   7.842378569597445e-01,  -6.032356983316800e-03,   4.639857416072047e-05,  -3.568614262799188e-07,   2.744488479785687e-09,  -2.110093897773226e-11,   1.619621114955507e-13,
  -1.230987611737023e-15,   8.878091622904299e-18,  -4.747256713913487e-20,   7.842487040555106e-01,  -6.032607256338697e-03,   4.640242412201502e-05,  -3.569107686346551e-07,
   2.745056664708639e-09,  -2.110698385339479e-11,   1.620201255713043e-13,  -1.231380442245117e-15,   8.874834361094826e-18,  -4.720542533963181e-20,   7.842602139912297e-01,
  -6.032872827984179e-03,   4.640650951915129e-05,  -3.569631298382998e-07,   2.745659626925321e-09,  -2.111339863287175e-11,   1.620816750385443e-13,  -1.231796438426318e-15,
   8.871341814424115e-18,  -4.692072569767283e-20,   7.842692726091766e-01,  -6.033081843407175e-03,   4.640972495862102e-05,  -3.570043421109761e-07,   2.746134215005182e-09,
  -2.111844760370671e-11,   1.621301090026501e-13,  -1.232123229115821e-15,   8.868566797712968e-18,  -4.669576507850626e-20,   7.842745006101582e-01,  -6.033202473959927e-03,
   4.641158073598154e-05,  -3.570281280147774e-07,   2.746408130569503e-09,  -2.112136166601900e-11,   1.621580588584948e-13,  -1.232311585222735e-15,   8.866954695842664e-18,
  -4.656557441511219e-20,   7.842764637945512e-01,  -6.033247772624765e-03,   4.641227761478088e-05,  -3.570370601408278e-07,   2.746510992651870e-09,  -2.112245596364931e-11,
   1.621685538652229e-13,  -1.232382269168776e-15,   8.866347332721915e-18,  -4.651661813836804e-20,   7.842767892214164e-01,  -6.033255281563402e-03,   4.641239313325812e-05,
  -3.570385407834843e-07,   2.746528043728767e-09,  -2.112263736116264e-11,   1.621702935394579e-13,  -1.232393983635196e-15,   8.866246547881690e-18,  -4.650849932544969e-20,
   1.991224350937654e-03,  -1.485908686971492e-05,   1.108767029844804e-07,  -8.273029461354356e-10,   6.172528923903067e-12,  -4.604903434170600e-14,   3.434209470062411e-16,
  -2.556362873449025e-18,   1.884484949164064e-20,  -1.326014253414117e-22,   1.991240140114060e-03,  -1.485944029533287e-05,   1.108819775207059e-07,  -8.273685418969963e-10,
   6.173262887023100e-12,  -4.605668476467394e-14,   3.434961332834590e-16,  -2.557041841277701e-18,   1.884953081888209e-20,  -1.325884117430739e-22,   1.991266061146458e-03,
  -1.486002052095757e-05,   1.108906369790693e-07,  -8.274762358325635e-10,   6.174467922360904e-12,  -4.606924563885261e-14,   3.436195771645529e-16,  -2.558156426213258e-18,
   1.885720775309531e-20,  -1.325667189107191e-22,   1.991293566104693e-03,  -1.486063621274809e-05,   1.108998259501082e-07,  -8.275905181283462e-10,   6.175746715783791e-12,
  -4.608257569056470e-14,   3.437505789151277e-16,  -2.559339017481773e-18,   1.886534237384970e-20,  -1.325432533565364e-22,   1.991315213186808e-03,  -1.486112078537720e-05,
   1.109070581649651e-07,  -8.276804666483869e-10,   6.176753247185618e-12,  -4.609306795455604e-14,   3.438536911860328e-16,  -2.560269672182148e-18,   1.887173623429893e-20,
  -1.325244610277097e-22,   1.991327706355838e-03,  -1.486140044971624e-05,   1.109112321965169e-07,  -8.277323808061070e-10,   6.177334181943295e-12,  -4.609912382378719e-14,
   3.439132045836477e-16,  -2.560806750653846e-18,   1.887542299120364e-20,  -1.325134852054802e-22,   1.991332397705611e-03,  -1.486150546796850e-05,   1.109127996206930e-07,
  -8.277518756760163e-10,   6.177552337379288e-12,  -4.610139797224557e-14,   3.439355534556684e-16,  -2.561008425054884e-18,   1.887680678718455e-20,  -1.325093390039508e-22,
   1.991333175366127e-03,  -1.486152287632679e-05,   1.109130594454703e-07,  -8.277551072607406e-10,   6.177588500222175e-12,  -4.610177495067250e-14,   3.439392581538168e-16,
  -2.561041855267026e-18,   1.887703613855982e-20,  -1.325086504096047e-22,   1.800807718627411e-02,  -1.343814337840968e-04,   1.002737950693687e-06,  -7.481896877289878e-09,
   5.582262596183293e-11,  -4.164544274627252e-13,   3.105792294264756e-15,  -2.311848864781452e-17,   1.704041197899655e-19,  -1.198326178432394e-21,   1.800821997917799e-02,
  -1.343846300667147e-04,   1.002785652124595e-06,  -7.482490106769343e-09,   5.582926369500644e-11,  -4.165236140521454e-13,   3.106472160471061e-15,  -2.312462432145688e-17,
   1.704462596758889e-19,  -1.198201349409700e-21,   1.800845440175917e-02,  -1.343898774652747e-04,   1.002863965844908e-06,  -7.483464060203276e-09,   5.584016165800961e-11,
  -4.166372082902287e-13,   3.107588391843142e-15,  -2.313469653806214e-17,   1.705153636951338e-19,  -1.197993411126554e-21,   1.800870314892347e-02,  -1.343954456099365e-04,
   1.002947068329789e-06,  -7.484497596897542e-09,   5.585172666588108e-11,  -4.167577585700274e-13,   3.108772963886165e-15,  -2.314538327350077e-17,   1.705885856622200e-19,
  -1.197768672923044e-21,   1.800889891909135e-02,  -1.343998279495089e-04,   1.003012474458845e-06,  -7.485311065818715e-09,   5.586082942101616e-11,  -4.168526453158123e-13,
   3.109705347163245e-15,  -2.315379330425021e-17,   1.706461371677526e-19,  -1.197588828977214e-21,   1.800901190382460e-02,  -1.344023571557133e-04,   1.003050223233145e-06,
  -7.485780562746433e-09,   5.586608321317757e-11,  -4.169074115400570e-13,   3.110243491396538e-15,  -2.315864670096191e-17,   1.706793213167263e-19,  -1.197483843640541e-21,
   1.800905433108236e-02,  -1.344033069114672e-04,   1.003064398579142e-06,  -7.485956868824077e-09,   5.586805614266396e-11,  -4.169279777899435e-13,   3.110445578902850e-15,
  -2.316046916236064e-17,   1.706917766265882e-19,  -1.197444194728719e-21,   1.800906136402698e-02,  -1.344034643477994e-04,   1.003066748361781e-06,  -7.485986094360324e-09,
   5.586838318809646e-11,  -4.169313869923689e-13,   3.110479078274116e-15,  -2.316077125944992e-17,   1.706938409732905e-19,  -1.197437610432869e-21,   5.052212266185188e-02,
  -3.770105609140134e-04,   2.813207051125168e-06,  -2.099065351878684e-08,   1.566117945199721e-10,  -1.168372502789677e-12,   8.713316265113475e-15,  -6.485632927458946e-17,
   4.779357424470374e-19,  -3.356748339187050e-21,   5.052252327100779e-02,  -3.770195281668424e-04,   2.813340878699957e-06,  -2.099231783769278e-08,   1.566304167078922e-10,
  -1.168566597581835e-12,   8.715223075665567e-15,  -6.487351536159161e-17,   4.780528117236691e-19,  -3.356356171445599e-21,   5.052318094957457e-02,  -3.770342498780313e-04,
   2.813560589829341e-06,  -2.099505028637182e-08,   1.566609909873785e-10,  -1.168885272720420e-12,   8.718353749791915e-15,  -6.490172758803276e-17,   4.782447820164335e-19,
  -3.355703700134851e-21,   5.052387881612685e-02,  -3.770498714506316e-04,   2.813793735959103e-06,  -2.099794989723925e-08,   1.566934366627651e-10,  -1.169223462127656e-12,
   8.721676093331078e-15,  -6.493166086170766e-17,   4.784481805625309e-19,  -3.354999581457180e-21,   5.052442805435629e-02,  -3.770621662166522e-04,   2.813977234513528e-06,
  -2.100023210291881e-08,   1.567189744774856e-10,  -1.169489655498362e-12,   8.724291125279532e-15,  -6.495521698618571e-17,   4.786080408926350e-19,  -3.354436879559857e-21,
   5.052474503592461e-02,  -3.770692619694995e-04,   2.814083139657480e-06,  -2.100154928729277e-08,   1.567337140113580e-10,  -1.169643295540513e-12,   8.725800443593523e-15,
  -6.496881107268888e-17,   4.787002129017549e-19,  -3.354108698022728e-21,   5.052486406668494e-02,  -3.770719265336160e-04,   2.814122908950285e-06,  -2.100204391802714e-08,
   1.567392490724633e-10,  -1.169700991671689e-12,   8.726367232613241e-15,  -6.497391567083293e-17,   4.787348080352367e-19,  -3.353984812661334e-21,   5.052488379779155e-02,
  -3.770723682252821e-04,   2.814129501325087e-06,  -2.100212591093767e-08,   1.567401665996525e-10,  -1.169710555777281e-12,   8.726461187323924e-15,  -6.497476182488128e-17,
   4.787405418095742e-19,  -3.353964242587305e-21,   1.005781326280583e-01,  -7.505428552629555e-04,   5.600459695002918e-06,  -4.178764856218189e-08,   3.117786538247026e-10,
  -2.325962234789030e-12,   1.734603946689795e-14,  -1.291040550016257e-16,   9.510194340521377e-19,  -6.665792851392470e-21,   1.005789301503843e-01,  -7.505607070372733e-04,
   5.600726115426976e-06,  -4.179096183992558e-08,   3.118157259347724e-10,  -2.326348601619782e-12,   1.734983365422910e-14,  -1.291381792193222e-16,   9.512487584567138e-19,
  -6.664876276170778e-21,   1.005802394398316e-01,  -7.505900146380196e-04,   5.601163510577522e-06,  -4.179640151936853e-08,   3.118765916615571e-10,  -2.326982959013963e-12,
   1.735606308482699e-14,  -1.291941961173990e-16,   9.516247775065069e-19,  -6.663353616779951e-21,   1.005816287344790e-01,  -7.506211136595182e-04,   5.601627651773860e-06,
  -4.180217398039461e-08,   3.119411828646710e-10,  -2.327656161416450e-12,   1.736267388578930e-14,  -1.292536295443935e-16,   9.520231442747197e-19,  -6.661713515702195e-21,
   1.005827221437129e-01,  -7.506455897607763e-04,   5.601992955879906e-06,  -4.180671732908745e-08,   3.119920222467419e-10,  -2.328186047774613e-12,   1.736787726734268e-14,
  -1.293004004369277e-16,   9.523362121143664e-19,  -6.660405017725261e-21,   1.005833531824046e-01,  -7.506597158014747e-04,   5.602203789060786e-06,  -4.180933954141797e-08,
   3.120213649596472e-10,  -2.328491884626115e-12,   1.737088049953231e-14,  -1.293273914103513e-16,   9.525167093873888e-19,  -6.659642740006020e-21,   1.005835901457577e-01,
  -7.506650203465966e-04,   5.602282960725052e-06,  -4.181032423789109e-08,   3.120323838770173e-10,  -2.328606734899971e-12,   1.737200829200467e-14,  -1.293375265191275e-16,
   9.525844537872290e-19,  -6.659355150469366e-21,   1.005836294259334e-01,  -7.506658996549076e-04,   5.602296084651774e-06,  -4.181048746699139e-08,   3.120342104433423e-10,
  -2.328625773266682e-12,   1.737219524233020e-14,  -1.293392065442001e-16,   9.525956815901038e-19,  -6.659307407312265e-21,   1.699924314694197e-01,  -1.268532249986414e-03,
   9.465633681061690e-06,  -7.062751776690740e-08,   5.269535021010012e-10,  -3.931223314091512e-12,   2.931694534711288e-14,  -2.181797852315729e-16,   1.606250466009849e-18,
  -1.122385447131905e-20,   1.699937794041608e-01,  -1.268562422215512e-03,   9.466083972227371e-06,  -7.063311770010974e-08,   5.270161584835491e-10,  -3.931876252350164e-12,
   2.932335345221225e-14,  -2.182372340626408e-16,   1.606628582985395e-18,  -1.122195958746126e-20,   1.699959923036304e-01,  -1.268611956543484e-03,   9.466823236766515e-06,
  -7.064231156902263e-08,   5.271190289700429e-10,  -3.932948280262676e-12,   2.933387447842229e-14,  -2.183315383597603e-16,   1.607248503808642e-18,  -1.121881668267399e-20,
   1.699983404241278e-01,  -1.268664518646528e-03,   9.467607706202791e-06,  -7.065206788829099e-08,   5.272281959553034e-10,  -3.934085953376407e-12,   2.934503957318358e-14,
  -2.184315925798160e-16,   1.607905171626347e-18,  -1.121543805216066e-20,   1.700001884530100e-01,  -1.268705887001360e-03,   9.468225125876093e-06,  -7.065974682448828e-08,
   5.273141206842463e-10,  -3.934981430192322e-12,   2.935382762676846e-14,  -2.185103285371506e-16,   1.608421162626632e-18,  -1.121274730486613e-20,   1.700012550049394e-01,
  -1.268729762170767e-03,   9.468581466118102e-06,  -7.066417875397318e-08,   5.273637134292159e-10,  -3.935498276313857e-12,   2.935889981104147e-14,  -2.185557656787361e-16,
   1.608718625784835e-18,  -1.121118167638690e-20,   1.700016555092582e-01,  -1.268738727663371e-03,   9.468715278309691e-06,  -7.066584303770249e-08,   5.273823367359660e-10,
  -3.935692366421989e-12,   2.936080454728471e-14,  -2.185728272234672e-16,   1.608830264590071e-18,  -1.121059135592616e-20,   1.700017218987646e-01,  -1.268740213828909e-03,
   9.468737459748126e-06,  -7.066611891919782e-08,   5.273854238545562e-10,  -3.935724540123549e-12,   2.936112028883262e-14,  -2.185756553894588e-16,   1.608848767070129e-18,
  -1.121049337459075e-20,   2.617986370498943e-01,  -1.953616471079599e-03,   1.457764896285621e-05,  -1.087706506620469e-07,   8.115400267789108e-10,  -6.054302381503445e-12,
   4.514871181117664e-14,  -3.359518215769925e-16,   2.471193098059423e-18,  -1.718924773481854e-20,   2.618007129510053e-01,  -1.953662938137870e-03,   1.457834243826817e-05,
  -1.087792748688751e-07,   8.116365188017626e-10,  -6.055307763596604e-12,   4.515857014984359e-14,  -3.360397822286636e-16,   2.471753819395713e-18,  -1.718553818258651e-20,
   2.618041209501670e-01,  -1.953739223999831e-03,   1.457948095001163e-05,  -1.087934339352675e-07,   8.117949412947704e-10,  -6.056958450994446e-12,   4.517475581569081e-14,
  -3.361841697366384e-16,   2.472672952884633e-18,  -1.717939467588047e-20,   2.618077371978983e-01,  -1.953820172818573e-03,   1.458068908000658e-05,  -1.088084592060460e-07,
   8.119630604929504e-10,  -6.058710216091748e-12,   4.519193224064139e-14,  -3.363373567188970e-16,   2.473646343074327e-18,  -1.717280286189527e-20,   2.618105832742645e-01,
  -1.953883882587829e-03,   1.458163994334305e-05,  -1.088202851919196e-07,   8.120953861659867e-10,  -6.060089051353826e-12,   4.520545175583780e-14,  -3.364579016021975e-16,
   2.474411040775102e-18,  -1.716756205833929e-20,   2.618122258288095e-01,  -1.953920651793175e-03,   1.458218872869228e-05,  -1.088271106080400e-07,   8.121717599048132e-10,
  -6.060884879070748e-12,   4.521325476459857e-14,  -3.365274647404505e-16,   2.474851814343091e-18,  -1.716451620548975e-20,   2.618128426297087e-01,  -1.953934459194201e-03,
   1.458239480749448e-05,  -1.088296736968642e-07,   8.122004401383180e-10,  -6.061183734453176e-12,   4.521618499140060e-14,  -3.365535853153093e-16,   2.475017225414585e-18,
  -1.716336843087562e-20,   2.618129448735679e-01,  -1.953936747979045e-03,   1.458242896824029e-05,  -1.088300985695971e-07,   8.122051943574277e-10,  -6.061233274757612e-12,
   4.521667072473394e-14,  -3.365579151176674e-16,   2.475044639189036e-18,  -1.716317795828797e-20,   3.812701507438854e-01,  -2.845147151042011e-03,   2.123014262509475e-05,
  -1.584080083302847e-07,   1.181884817522697e-09,  -8.817134069096400e-12,   6.574975228499134e-14,  -4.891357143412547e-16,   3.593364984904733e-18,  -2.482138668244581e-20,
   3.812731739801261e-01,  -2.845214823287093e-03,   2.123115256669695e-05,  -1.584205681204843e-07,   1.182025337908986e-09,  -8.818597857390027e-12,   6.576408633363470e-14,
  -4.892626811784626e-16,   3.594133653886032e-18,  -2.481421762241948e-20,   3.812781372158595e-01,  -2.845325922111467e-03,   2.123281063611372e-05,  -1.584411885558841e-07,
   1.182256046996091e-09,  -8.821001176970009e-12,   6.578762019571200e-14,  -4.894710905880004e-16,   3.595393268205439e-18,  -2.480236082980833e-20,   3.812834037341623e-01,
  -2.845443811827376e-03,   2.123457009393411e-05,  -1.584630704800838e-07,   1.182500877249516e-09,  -8.823551657425552e-12,   6.581259443062283e-14,  -4.896921919305583e-16,
   3.596726710582241e-18,  -2.478966056232735e-20,   3.812875486142664e-01,  -2.845536595474046e-03,   2.123595488194221e-05,  -1.584802931527525e-07,   1.182693581726700e-09,
  -8.825559168720579e-12,   6.583225144556222e-14,  -4.898661728116424e-16,   3.597773882758777e-18,  -2.477957884732716e-20,   3.812899407467245e-01,  -2.845590144262506e-03,
   2.123675410443839e-05,  -1.584902332885686e-07,   1.182804803980222e-09,  -8.826717850875553e-12,   6.584359675849627e-14,  -4.899665696958579e-16,   3.598377321039012e-18,
  -2.477372574932288e-20,   3.812908390240180e-01,  -2.845610252654562e-03,   2.123705422690848e-05,  -1.584939660208096e-07,   1.182846570692814e-09,  -8.827152967983481e-12,
   6.584785719974571e-14,  -4.900042676614263e-16,   3.598603746801413e-18,  -2.477152127950881e-20,   3.812909879267470e-01,  -2.845613585923645e-03,   2.123710397684539e-05,
  -1.584945847805377e-07,   1.182853494210333e-09,  -8.827225095950404e-12,   6.584856343748453e-14,  -4.900105165298629e-16,   3.598641271069948e-18,  -2.477115551015275e-20,
   5.387322225976608e-01,  -4.020174265059952e-03,   2.999805218171251e-05,  -2.238294624446113e-07,   1.669994175794201e-09,  -1.245845691790763e-11,   9.289824035525739e-14,
  -6.908546642150599e-16,   5.064626516145186e-18,  -3.458083557469482e-20,   5.387364944106230e-01,  -4.020269885491763e-03,   2.999947922137246e-05,  -2.238472092018738e-07,
   1.670192717314682e-09,  -1.246052432957185e-11,   9.291844103090382e-14,  -6.910314363431942e-16,   5.065600528488314e-18,  -3.456653472579803e-20,   5.387435074301332e-01,
  -4.020426867390980e-03,   3.000182206060535e-05,  -2.238763455046377e-07,   1.670518686540342e-09,  -1.246391870208915e-11,   9.295160649325600e-14,  -6.913215823464022e-16,
   5.067195664433667e-18,  -3.454291091869324e-20,   5.387509489859229e-01,  -4.020593444774665e-03,   3.000430816085565e-05,  -2.239072642670121e-07,   1.670864607472853e-09,
  -1.246752091235952e-11,   9.298680138977754e-14,  -6.916293759175188e-16,   5.068882965494723e-18,  -3.451764456588943e-20,   5.387568056743007e-01,  -4.020724547449624e-03,
   3.000626485555993e-05,  -2.239315995904749e-07,   1.671136879758695e-09,  -1.247035624626695e-11,   9.301450268862464e-14,  -6.918715574330874e-16,   5.070207061901288e-18,
  -3.449761496657443e-20,   5.387601857417607e-01,  -4.020800211531153e-03,   3.000739415073886e-05,  -2.239456448213506e-07,   1.671294025723417e-09,  -1.247199272340940e-11,
   9.303049074274022e-14,  -6.920113035411950e-16,   5.070969690278087e-18,  -3.448599733843984e-20,   5.387614550016796e-01,  -4.020828624555228e-03,   3.000781822145721e-05,
  -2.239509191039551e-07,   1.671353037921560e-09,  -1.247260726529372e-11,   9.303649462241836e-14,  -6.920637755062520e-16,   5.071255774608377e-18,  -3.448162380063630e-20,
   5.387616654002582e-01,  -4.020833334442247e-03,   3.000788851773150e-05,  -2.239517934001664e-07,   1.671362820160786e-09,  -1.247270913590798e-11,   9.303748986229574e-14,
  -6.920724732696373e-16,   5.071303181862683e-18,  -3.448089824342042e-20,   7.608186651812799e-01,  -5.677446955930555e-03,   4.236441945457396e-05,  -3.161006620983416e-07,
   2.358427418680600e-09,  -1.759406172591459e-11,   1.311789653552536e-13,  -9.748532868972435e-16,   7.116962531274950e-18,  -4.745171132718685e-20,   7.608246980021736e-01,
  -5.677581994817620e-03,   4.236643477246064e-05,  -3.161257243740548e-07,   2.358707771790335e-09,  -1.759697889940313e-11,   1.312073453808940e-13,  -9.750955094624984e-16,
   7.118016988406596e-18,  -4.741936302808783e-20,   7.608346020618788e-01,  -5.677803690751703e-03,   4.236974341616055e-05,  -3.161668711591560e-07,   2.359168060604802e-09,
  -1.760176843457730e-11,   1.312539387819976e-13,  -9.754930351441125e-16,   7.119740689293917e-18,  -4.736598147022127e-20,   7.608451113172331e-01,  -5.678038937801399e-03,
   4.237325437830649e-05,  -3.162105351606886e-07,   2.359656522161021e-09,  -1.760685121194285e-11,   1.313033820419433e-13,  -9.759146744323306e-16,   7.121559642938120e-18,
  -4.730896289771826e-20,   7.608533823610080e-01,  -5.678224086089772e-03,   4.237601769446126e-05,  -3.162449019153846e-07,   2.360040987090414e-09,  -1.761085189865877e-11,
   1.313422970779125e-13,  -9.762463860009977e-16,   7.122983892620768e-18,  -4.726381574870621e-20,   7.608581558241186e-01,  -5.678330941843742e-03,   4.237761252659712e-05,
  -3.162647368265549e-07,   2.360262886603683e-09,  -1.761316097928165e-11,   1.313647568778207e-13,  -9.764377746776493e-16,   7.123802932577914e-18,  -4.723765073842751e-20,
   7.608599483224853e-01,  -5.678371067819608e-03,   4.237821141484199e-05,  -3.162721852569258e-07,   2.360346215344507e-09,  -1.761402810096520e-11,   1.313731909771245e-13,
  -9.765096338337919e-16,   7.124109937192134e-18,  -4.722780475922702e-20,   7.608602454555647e-01,  -5.678377719304939e-03,   4.237831068982247e-05,  -3.162734199526916e-07,
   2.360360028448401e-09,  -1.761417184085062e-11,   1.313745890614631e-13,  -9.765215450319892e-16,   7.124160798409887e-18,  -4.722617155165125e-20,   1.933501437174854e-03,
  -1.401017206049103e-05,   1.015126249908914e-07,  -7.354856730118732e-10,   5.328505634988731e-12,  -3.860193252864259e-14,   2.796084549794653e-16,  -2.023994152083726e-18,
   1.460114682795850e-20,  -1.035849908200162e-22,   1.933515892323365e-03,  -1.401048624980028e-05,   1.015171780898213e-07,  -7.355406575458636e-10,   5.329103182357315e-12,
  -3.860798963367794e-14,   2.796667249714816e-16,  -2.024525420184142e-18,   1.460549384488469e-20,  -1.036072580274720e-22,   1.933539623258676e-03,  -1.401100205939472e-05,
   1.015246531078171e-07,  -7.356309297936745e-10,   5.330084243051470e-12,  -3.861793450011873e-14,   2.797623971080024e-16,  -2.025397664537568e-18,   1.461262874011143e-20,
  -1.036437214837410e-22,   1.933564804253508e-03,  -1.401154939634088e-05,   1.015325851815127e-07,  -7.357267241025966e-10,   5.331125346579340e-12,  -3.862848833272913e-14,
   2.798639296451339e-16,  -2.026323294180470e-18,   1.462019745497900e-20,  -1.036822870412486e-22,   1.933584622290986e-03,  -1.401198017012051e-05,   1.015388281285952e-07,
  -7.358021208653258e-10,   5.331944789089916e-12,  -3.863679538452928e-14,   2.799438485965051e-16,  -2.027051849771992e-18,   1.462615264767647e-20,  -1.037125476334499e-22,
   1.933596059853237e-03,  -1.401222878479759e-05,   1.015424312011127e-07,  -7.358456362721278e-10,   5.332417740890020e-12,  -3.864158999958095e-14,   2.799899763204402e-16,
  -2.027472345549354e-18,   1.462958893227881e-20,  -1.037299751851327e-22,   1.933600354806619e-03,  -1.401232214334845e-05,   1.015437842182076e-07,  -7.358619772052131e-10,
   5.332595345704832e-12,  -3.864339051083844e-14,   2.800072986720386e-16,  -2.027630251956383e-18,   1.463087918266245e-20,  -1.037365125106223e-22,   1.933601066758467e-03,
  -1.401233761893143e-05,   1.015440085016106e-07,  -7.358646859733101e-10,   5.332624786599121e-12,  -3.864368897586884e-14,   2.800101701489599e-16,  -2.027656427523203e-18,
   1.463109305439385e-20,  -1.037375958020340e-22,   1.748604726736415e-02,  -1.267040852222190e-04,   9.180518434541191e-07,  -6.651527111692190e-09,   4.818951691955088e-11,
  -3.491050580244107e-13,   2.528698168460832e-15,  -1.830430355076777e-17,   1.320427775012058e-19,  -9.365655701462060e-22,   1.748617799569217e-02,  -1.267069266626238e-04,
   9.180930204093054e-07,  -6.652024376402422e-09,   4.819492096520487e-11,  -3.491598363697490e-13,   2.529225121331434e-15,  -1.830910696972335e-17,   1.320820385536213e-19,
  -9.367650032122748e-22,   1.748639261164670e-02,  -1.267115915006044e-04,   9.181606223845204e-07,  -6.652840773302933e-09,   4.820379339446611e-11,  -3.492497742706691e-13,
   2.530090312773676e-15,  -1.831699329169093e-17,   1.321464786332196e-19,  -9.370915642082154e-22,   1.748662034153475e-02,  -1.267165414631527e-04,   9.182323578438378e-07,
  -6.653707110175379e-09,   4.821320883370370e-11,  -3.493452194455404e-13,   2.531008501353129e-15,  -1.832536228247500e-17,   1.322148364002224e-19,  -9.374369256979777e-22,
   1.748679957033356e-02,  -1.267204372609624e-04,   9.182888173137846e-07,  -6.654388977358399e-09,   4.822061963476392e-11,  -3.494203455171716e-13,   2.531731231778122e-15,
  -1.833194944029148e-17,   1.322686211322086e-19,  -9.377078960995942e-22,   1.748690300845379e-02,  -1.267226856626994e-04,   9.183214024954018e-07,  -6.654782518496866e-09,
   4.822489687403832e-11,  -3.494637063380653e-13,   2.532148378203320e-15,  -1.833575130527758e-17,   1.322996560466555e-19,  -9.378639447167660e-22,   1.748694185081326e-02,
  -1.267235299713717e-04,   9.183336388041501e-07,  -6.654930301314061e-09,   4.822650308060680e-11,  -3.494799895316851e-13,   2.532305029256539e-15,  -1.833717899765422e-17,
   1.323113089604678e-19,  -9.379224793760857e-22,   1.748694828950702e-02,  -1.267236699282241e-04,   9.183356671606104e-07,  -6.654954798653251e-09,   4.822676933553807e-11,
  -3.494826887449447e-13,   2.532330996855187e-15,  -1.833741566096295e-17,   1.323132405446469e-19,  -9.379321790005334e-22,   4.905755432825259e-02,  -3.554715625166958e-04,
   2.575618005156571e-06,  -1.866102996164923e-08,   1.351969227810576e-10,  -9.794229407653047e-13,   7.094312125363963e-15,  -5.135240590836282e-17,   3.704147453837026e-19,
  -2.626221731994405e-21,   4.905792108993150e-02,  -3.554795342506495e-04,   2.575733528157778e-06,  -1.866242505016613e-08,   1.352120839350543e-10,  -9.795766203506676e-13,
   7.095790360694706e-15,  -5.136587486570797e-17,   3.705245873916253e-19,  -2.626769827330831e-21,   4.905852320049924e-02,  -3.554926215732813e-04,   2.575923187228686e-06,
  -1.866471547198058e-08,   1.352369757057334e-10,  -9.798289393720629e-13,   7.098217439425836e-15,  -5.138798835091787e-17,   3.707048717711453e-19,  -2.627667192923125e-21,
   4.905916210254398e-02,  -3.555065088202029e-04,   2.576124442894960e-06,  -1.866714600162522e-08,   1.352633909010281e-10,  -9.800967089220777e-13,   7.100793187231333e-15,
  -5.141145519732060e-17,   3.708961141449594e-19,  -2.628616068985815e-21,   4.905966493353824e-02,  -3.555174385809053e-04,   2.576282841382237e-06,  -1.866905899696522e-08,
   1.352841820452644e-10,  -9.803074736148770e-13,   7.102820625349183e-15,  -5.142992570110517e-17,   3.710465841517148e-19,  -2.629360445937929e-21,   4.905995513183890e-02,
  -3.555237465296616e-04,   2.576374259942848e-06,  -1.867016308641555e-08,   1.352961819218383e-10,  -9.804291215254268e-13,   7.103990824204917e-15,  -5.144058617935443e-17,
   3.711334077489751e-19,  -2.629789079183401e-21,   4.906006410507512e-02,  -3.555261152593026e-04,   2.576408589220064e-06,  -1.867057769478397e-08,   1.353006881650634e-10,
  -9.804748036963490e-13,   7.104430269074130e-15,  -5.144458944398365e-17,   3.711660079206984e-19,  -2.629949853326553e-21,   4.906008216899573e-02,  -3.555265079118425e-04,
   2.576414279826002e-06,  -1.867064642267821e-08,   1.353014351483608e-10,  -9.804823762845881e-13,   7.104503114594301e-15,  -5.144525305025656e-17,   3.711714117098814e-19,
  -2.629976494340591e-21,   9.766250794057532e-02,  -7.076635754072839e-04,   5.127473582305331e-06,  -3.714989476454268e-08,   2.691465191619234e-10,  -1.949808983654827e-12,
   1.412312309003567e-14,  -1.022285098007717e-16,   7.373006304222091e-19,  -5.223908990956067e-21,   9.766323808022172e-02,  -7.076794453286118e-04,   5.127703562492258e-06,
  -3.715267206936697e-08,   2.691767014828871e-10,  -1.950114917062314e-12,   1.412606545797395e-14,  -1.022553004007357e-16,   7.375183145652688e-19,  -5.224963239765819e-21,
   9.766443674633736e-02,  -7.077054992312838e-04,   5.128081130838960e-06,  -3.715723177971259e-08,   2.692262551910930e-10,  -1.950617214164985e-12,   1.413089645774257e-14,
  -1.022992853734991e-16,   7.378755948668174e-19,  -5.226688934288599e-21,   9.766570865597202e-02,  -7.077331456024973e-04,   5.128481785386077e-06,  -3.716207041295934e-08,
   2.692788416813264e-10,  -1.951150268912856e-12,   1.413602337337158e-14,  -1.023459620747556e-16,   7.382545830311872e-19,  -5.228513184916207e-21,   9.766670967888544e-02,
  -7.077549042868034e-04,   5.128797120975605e-06,  -3.716587875278098e-08,   2.693202319974890e-10,  -1.951569842786041e-12,   1.414005889932079e-14,  -1.023827006738729e-16,
   7.385527659360341e-19,  -5.229943912616557e-21,   9.766728739814243e-02,  -7.077674619876847e-04,   5.128979114668821e-06,  -3.716807674444683e-08,   2.693441209510640e-10,
  -1.951812009916688e-12,   1.414238812731188e-14,  -1.024039047543664e-16,   7.387248198292649e-19,  -5.230767618713822e-21,   9.766750433923724e-02,  -7.077721775932564e-04,
   5.129047456501201e-06,  -3.716890213566621e-08,   2.693530918295476e-10,  -1.951902950400223e-12,   1.414326282227582e-14,  -1.024118673837682e-16,   7.387894214710879e-19,
  -5.231076551050902e-21,   9.766754030042228e-02,  -7.077729592757553e-04,   5.129058785211523e-06,  -3.716903895731464e-08,   2.693545788989405e-10,  -1.951918025314862e-12,
   1.414340781794938e-14,  -1.024131873186640e-16,   7.388001297849171e-19,  -5.231127741082353e-21,   1.650645796897774e-01,  -1.196059707028190e-03,   8.666214797606581e-06,
  -6.278900535896442e-08,   4.548987653035717e-10,  -3.295473408806674e-12,   2.387011410639901e-14,  -1.727754644143059e-16,   1.245870238780579e-18,  -8.818343297802014e-21,
   1.650658137374826e-01,  -1.196086529623010e-03,   8.666603499280966e-06,  -6.279369942589554e-08,   4.549497777636182e-10,  -3.295990463137469e-12,   2.387508598812325e-14,
  -1.728206864556404e-16,   1.246235663405193e-18,  -8.820031629599116e-21,   1.650678396665998e-01,  -1.196130564704244e-03,   8.667241647507904e-06,  -6.280140602882385e-08,
   4.550335306502494e-10,  -3.296839389237505e-12,   2.388324918841271e-14,  -1.728949319410659e-16,   1.246835411526892e-18,  -8.822794283755755e-21,   1.650699893884696e-01,
  -1.196177291300927e-03,   8.667918814942621e-06,  -6.280958405378476e-08,   4.551224093718098e-10,  -3.297740298283715e-12,   2.389191240409417e-14,  -1.729737205282999e-16,
   1.247471578468928e-18,  -8.825713394198558e-21,   1.650716812703380e-01,  -1.196214066806040e-03,   8.668451780295698e-06,  -6.281602072638098e-08,   4.551923649492979e-10,
  -3.298449414625512e-12,   2.389873143499577e-14,  -1.730357336198464e-16,   1.247972090967918e-18,  -8.828001838583483e-21,   1.650726577042665e-01,  -1.196235291241601e-03,
   8.668759377459362e-06,  -6.281973566605386e-08,   4.552327407103068e-10,  -3.298858698091843e-12,   2.390266724574228e-14,  -1.730715250117337e-16,   1.248260884494729e-18,
  -8.829318965933708e-21,   1.650730243679062e-01,  -1.196243261336408e-03,   8.668874885603768e-06,  -6.282113070254595e-08,   4.552479027826569e-10,  -3.299012395391648e-12,
   2.390414526018458e-14,  -1.730849654929097e-16,   1.248369317588645e-18,  -8.829812883145758e-21,   1.650730851478106e-01,  -1.196244582499413e-03,   8.668894032856076e-06,
  -6.282136195190736e-08,   4.552504161433834e-10,  -3.299037873303577e-12,   2.390439026636853e-14,  -1.730871934691761e-16,   1.248387291305748e-18,  -8.829894721248277e-21,
   2.542094469412944e-01,  -1.842004367011151e-03,   1.334649549881457e-05,  -9.669886926638884e-08,   7.005715778986430e-10,  -5.075223946091144e-12,   3.676114167073184e-14,
  -2.660703895376879e-16,   1.918083227798354e-18,  -1.355623424088357e-20,   2.542113474494777e-01,  -1.842045675430891e-03,   1.334709412287012e-05,  -9.670609840669892e-08,
   7.006501395480276e-10,  -5.076020196258270e-12,   3.676879603178653e-14,  -2.661399027115759e-16,   1.918640345551259e-18,  -1.355862154553133e-20,   2.542144675029814e-01,
  -1.842113492121669e-03,   1.334807690968240e-05,  -9.671796703032183e-08,   7.007791230297584e-10,  -5.077327520004207e-12,   3.678136350757296e-14,  -2.662540285659502e-16,
   1.919554671834221e-18,  -1.356252560981340e-20,   2.542177782048191e-01,  -1.842185453909168e-03,   1.334911978843080e-05,  -9.673056167165177e-08,   7.009160005388079e-10,
  -5.078714895732083e-12,   3.679470074938006e-14,  -2.663751367515919e-16,   1.920524470808672e-18,  -1.356664758176261e-20,   2.542203838053341e-01,  -1.842242090413254e-03,
   1.334994058726370e-05,  -9.674047452747234e-08,   7.010237354911963e-10,  -5.079806915571489e-12,   3.680519880586727e-14,  -2.664704580737850e-16,   1.921287437429107e-18,
  -1.356987668827683e-20,   2.542218875727038e-01,  -1.842274777328842e-03,   1.335041430547333e-05,  -9.674619575388094e-08,   7.010859161025767e-10,  -5.080437200843649e-12,
   3.681125807161920e-14,  -2.665254732895259e-16,   1.921727651712306e-18,  -1.357173428206147e-20,   2.542224522569091e-01,  -1.842287051757316e-03,   1.335059219499190e-05,
  -9.674834419243160e-08,   7.011092664219938e-10,  -5.080673890433654e-12,   3.681353350561641e-14,  -2.665461326949521e-16,   1.921892935972776e-18,  -1.357243069410633e-20,
   2.542225458616419e-01,  -1.842289086428320e-03,   1.335062168291686e-05,  -9.674870033009927e-08,   7.011131371181739e-10,  -5.080713125712126e-12,   3.681391069767295e-14,
  -2.665495573211110e-16,   1.921920333118110e-18,  -1.357254607457320e-20,   3.702176422619003e-01,  -2.682600988987384e-03,   1.943715370304622e-05,  -1.408272880578713e-07,
   1.020276493112941e-09,  -7.391286685147392e-12,   5.353644256085710e-14,  -3.874602669532105e-16,   2.792018758179213e-18,  -1.968882197215644e-20,   3.702204100648546e-01,
  -2.682661148457344e-03,   1.943802550839202e-05,  -1.408378161931729e-07,   1.020390904922959e-09,  -7.392446205771945e-12,   5.354758422377681e-14,  -3.875612141244797e-16,
   2.792817654343202e-18,  -1.969182753584955e-20,   3.702249539512637e-01,  -2.682759913217583e-03,   1.943945678865594e-05,  -1.408551010250146e-07,   1.020578747630311e-09,
  -7.394349964692407e-12,   5.356587736532462e-14,  -3.877269461914328e-16,   2.794128700790312e-18,  -1.969673700357943e-20,   3.702297754881597e-01,  -2.682864714684695e-03,
   1.944097558372976e-05,  -1.408734431902721e-07,   1.020778086646290e-09,  -7.396370296561286e-12,   5.358529092579720e-14,  -3.879028155530265e-16,   2.795519180302602e-18,
  -1.970191275402293e-20,   3.702335701515376e-01,  -2.682947197192791e-03,   1.944217095301411e-05,  -1.408878797457578e-07,   1.020934984432866e-09,  -7.397960523057334e-12,
   5.360057176080033e-14,  -3.880412363621883e-16,   2.796613028433568e-18,  -1.970596173247900e-20,   3.702357601614543e-01,  -2.682994800745007e-03,   1.944286085189585e-05,
  -1.408962118352781e-07,   1.021025540001878e-09,  -7.398878359929816e-12,   5.360939153557692e-14,  -3.881211259928967e-16,   2.797244122016270e-18,  -1.970828869235113e-20,
   3.702365825386613e-01,  -2.683012676594907e-03,   1.944311992105851e-05,  -1.408993407067842e-07,   1.021059545801649e-09,  -7.399223033070064e-12,   5.361270361994588e-14,
  -3.881511261501060e-16,   2.797481068415608e-18,  -1.970916063731346e-20,   3.702367188598085e-01,  -2.683015639785701e-03,   1.944316286575861e-05,  -1.408998593667195e-07,
   1.021065182817404e-09,  -7.399280168434842e-12,   5.361325265437145e-14,  -3.881560991480855e-16,   2.797520343797653e-18,  -1.970930507693781e-20,   5.231151005973299e-01,
  -3.790497604572597e-03,   2.746457068525163e-05,  -1.989880311714152e-07,   1.441643688938480e-09,  -1.044381721344116e-11,   7.564528092280094e-14,  -5.474085434022593e-16,
   3.941962442421872e-18,  -2.769687980603831e-20,   5.231190114847484e-01,  -3.790582609507591e-03,   2.746580254021020e-05,  -1.990029073238025e-07,   1.441805349013108e-09,
  -1.044545538784421e-11,   7.566101089974006e-14,  -5.475505197982009e-16,   3.943062478613566e-18,  -2.770002883554519e-20,   5.231254319664380e-01,  -3.790722163463584e-03,
   2.746782492937891e-05,  -1.990273306222028e-07,   1.442070764478382e-09,  -1.044814502305755e-11,   7.568683736673112e-14,  -5.477836083857179e-16,   3.944867527117797e-18,
  -2.770515726150873e-20,   5.231322447664444e-01,  -3.790870247246629e-03,   2.746997097636948e-05,  -1.990532479220720e-07,   1.442352423815995e-09,  -1.045099935089867e-11,
   7.571424554334086e-14,  -5.480309487424375e-16,   3.946781679403298e-18,  -2.771054278369551e-20,   5.231376066009057e-01,  -3.790986794487516e-03,   2.747166002494266e-05,
  -1.990736466333594e-07,   1.442574115101359e-09,  -1.045324602384438e-11,   7.573581903397343e-14,  -5.482256179509050e-16,   3.948287296492730e-18,  -2.771474048205862e-20,
   5.231407010705521e-01,  -3.791054057993378e-03,   2.747263484731445e-05,  -1.990854197940283e-07,   1.442702067060884e-09,  -1.045454274376859e-11,   7.574827076422280e-14,
  -5.483379697645003e-16,   3.949155883614549e-18,  -2.771714669617962e-20,   5.231418630841511e-01,  -3.791079316451593e-03,   2.747300091025814e-05,  -1.990898408587230e-07,
   1.442750116105535e-09,  -1.045502969787191e-11,   7.575294674839568e-14,  -5.483801598180378e-16,   3.949481983489077e-18,  -2.771804715769632e-20,   5.231420557050378e-01,
  -3.791083503420676e-03,   2.747306159082380e-05,  -1.990905737201145e-07,   1.442758081018017e-09,  -1.045511041869158e-11,   7.575372187213368e-14,  -5.483871534670500e-16,
   3.949536035872857e-18,  -2.771819625867437e-20,   7.387635561420608e-01,  -5.353088615706096e-03,   3.878653827441779e-05,  -2.810186532004948e-07,   2.035944666880810e-09,
  -1.474910679358025e-11,   1.068255762156054e-13,  -7.728819012184621e-16,   5.558416324247275e-18,  -3.877405487036113e-20,   7.387690792498582e-01,  -5.353208662988057e-03,
   3.878827794732446e-05,  -2.810396617937785e-07,   2.036172961345251e-09,  -1.475141969077431e-11,   1.068477548428436e-13,  -7.730805768228747e-16,   5.559889136990663e-18,
  -3.877538050060993e-20,   7.387781465045983e-01,  -5.353405746523294e-03,   3.879113404301390e-05,  -2.810741531810821e-07,   2.036547777902447e-09,  -1.475521711511867e-11,
   1.068841688820092e-13,  -7.734067393176484e-16,   5.562305310755969e-18,  -3.877747971874233e-20,   7.387877678065714e-01,  -5.353614876212674e-03,   3.879416477302363e-05,
  -2.811107544456822e-07,   2.036945533787644e-09,  -1.475924705929306e-11,   1.069228127426210e-13,  -7.737528286701326e-16,   5.564866758930821e-18,  -3.877960225180546e-20,
   7.387953399983918e-01,  -5.353779468768180e-03,   3.879655011230568e-05,  -2.811395621770935e-07,   2.037258603465615e-09,  -1.476241906897724e-11,   1.069532298255767e-13,
  -7.740252068392474e-16,   5.566880962464101e-18,  -3.878119656939370e-20,   7.387997101291583e-01,  -5.353874460912453e-03,   3.879792679390614e-05,  -2.811561886218055e-07,
   2.037439295610785e-09,  -1.476424986713066e-11,   1.069707857864193e-13,  -7.741824031814449e-16,   5.568042727737389e-18,  -3.878208610746423e-20,   7.388013511700993e-01,
  -5.353910131891476e-03,   3.879844376205685e-05,  -2.811624321947283e-07,   2.037507149862132e-09,  -1.476493738204940e-11,   1.069773785393794e-13,  -7.742414322638322e-16,
   5.568478855126853e-18,  -3.878241435214527e-20,   7.388016231968306e-01,  -5.353916044892383e-03,   3.879852945748259e-05,  -2.811634671656788e-07,   2.037518397810284e-09,
  -1.476505134917663e-11,   1.069784713991700e-13,  -7.742512171944917e-16,   5.568551142778308e-18,  -3.878246845800796e-20,   1.879031025681246e-03,  -1.323198141738231e-05,
   9.317398679219061e-08,  -6.560596434999916e-10,   4.619241501865772e-12,  -3.252185842923402e-14,   2.289532176098201e-16,  -1.611440071061827e-18,   1.132848814945470e-20,
  -7.916985808913603e-23,   1.879044292961191e-03,  -1.323226166736200e-05,   9.317793367654267e-08,  -6.561059652137684e-10,   4.619730764897798e-12,  -3.252668063787575e-14,
   2.289984287725322e-16,  -1.611846338719431e-18,   1.133193839397425e-20,  -7.919503097529616e-23,   1.879066073755492e-03,  -1.323272175737692e-05,   9.318441342829128e-08,
  -6.561820147687437e-10,   4.620534039165288e-12,  -3.253459795201831e-14,   2.290726601539773e-16,  -1.612513385912677e-18,   1.133760284151072e-20,  -7.923633650179328e-23,
   1.879089185415017e-03,  -1.323320996790363e-05,   9.319128935663222e-08,  -6.562627159730855e-10,   4.621386470146935e-12,  -3.254300002797026e-14,   2.291514388981827e-16,
  -1.613221301009119e-18,   1.134361368097268e-20,  -7.928013780998418e-23,   1.879107374813208e-03,  -1.323359420624541e-05,   9.319670104591806e-08,  -6.563262331317685e-10,
   4.622057406526988e-12,  -3.254961337028885e-14,   2.292134479668761e-16,  -1.613778525446364e-18,   1.134834454757756e-20,  -7.931459002063551e-23,   1.879117872431214e-03,
  -1.323381596335500e-05,   9.319982435690740e-08,  -6.563628920850991e-10,   4.622444644579671e-12,  -3.255343040598289e-14,   2.292492385346395e-16,  -1.614100147247205e-18,
   1.135107494462047e-20,  -7.933446516712749e-23,   1.879121814421524e-03,  -1.323389923642253e-05,   9.320099721378781e-08,  -6.563766582568987e-10,   4.622590061526245e-12,
  -3.255486380634210e-14,   2.292626789899859e-16,  -1.614220926363617e-18,   1.135210025873970e-20,  -7.934192698689309e-23,   1.879122467864444e-03,  -1.323391304018175e-05,
   9.320119163279318e-08,  -6.563789402164554e-10,   4.622614166741312e-12,  -3.255510141642451e-14,   2.292649069769481e-16,  -1.614240947596633e-18,   1.135227022043632e-20,
  -7.934316381137516e-23,   1.699343207104939e-02,  -1.196663462754851e-04,   8.426395273302486e-07,  -5.933220277446663e-09,   4.177513055676219e-11,  -2.941185989439278e-13,
   2.070588360648518e-15,  -1.457338172822113e-17,   1.024502321514877e-19,  -7.159330194691787e-22,   1.699355205662569e-02,  -1.196688807780698e-04,   8.426752218504412e-07,
  -5.933639198079955e-09,   4.177955531363493e-11,  -2.941622095508947e-13,   2.070997231717687e-15,  -1.457705559332513e-17,   1.024814218434998e-19,  -7.161601658767123e-22,
   1.699374903604932e-02,  -1.196730417037310e-04,   8.427338229162439e-07,  -5.934326969000530e-09,   4.178681989955001e-11,  -2.942338113619764e-13,   2.071668549613020e-15,
  -1.458308767737613e-17,   1.025326275184345e-19,  -7.165328810554709e-22,   1.699395805144651e-02,  -1.196774569434510e-04,   8.427960068925420e-07,  -5.935056808137775e-09,
   4.179452904491079e-11,  -2.943097972123724e-13,   2.072380991924146e-15,  -1.458948932591418e-17,   1.025869644109701e-19,  -7.169281119916782e-22,   1.699412255128623e-02,
  -1.196809318877542e-04,   8.428449486996105e-07,  -5.935631239568669e-09,   4.180059680427803e-11,  -2.943696062925918e-13,   2.072941776203297e-15,  -1.459452828289233e-17,
   1.026297305035638e-19,  -7.172389801670256e-22,   1.699421748881310e-02,  -1.196829373971500e-04,   8.428731950522332e-07,  -5.935962772896840e-09,   4.180409887599287e-11,
  -2.944041264158994e-13,   2.073265451227619e-15,  -1.459743669447992e-17,   1.026544127178123e-19,  -7.174183156590065e-22,   1.699425313907307e-02,  -1.196836904955272e-04,
   8.428838020424219e-07,  -5.936087270307103e-09,   4.180541398583721e-11,  -2.944170896577782e-13,   2.073387001118606e-15,  -1.459852889449958e-17,   1.026636813355339e-19,
  -7.174856441717241e-22,   1.699425904862844e-02,  -1.196838153328723e-04,   8.428855603136285e-07,  -5.936107907711549e-09,   4.180563198660243e-11,  -2.944192385319205e-13,
   2.073407150106373e-15,  -1.459870994558573e-17,   1.026652177521694e-19,  -7.174968041105973e-22,   4.767550975370924e-02,  -3.357270053034603e-04,   2.364046817318350e-06,
  -1.664580173535544e-08,   1.172011999739585e-10,  -8.251572166092744e-13,   5.809085111832993e-15,  -4.088580673297804e-17,   2.874182595772638e-19,  -2.008234357929187e-21,
   4.767584637632256e-02,  -3.357341159154971e-04,   2.364146959209982e-06,  -1.664697702785148e-08,   1.172136137346564e-10,  -8.252795666905755e-13,   5.810232174624528e-15,
  -4.089611206343628e-17,   2.875056848155001e-19,  -2.008868632133715e-21,   4.767639900715032e-02,  -3.357457894992087e-04,   2.364311366002657e-06,  -1.664890658666870e-08,
   1.172339947032547e-10,  -8.254804464271806e-13,   5.812115515724035e-15,  -4.091303227636429e-17,   2.876492147274530e-19,  -2.009909366617902e-21,   4.767698540521080e-02,
  -3.357581765675381e-04,   2.364485824742589e-06,  -1.665095416893732e-08,   1.172556228938792e-10,  -8.256936256332708e-13,   5.814114228544665e-15,  -4.093098911627449e-17,
   2.878015208302318e-19,  -2.011012944821033e-21,   4.767744691373246e-02,  -3.357679256129476e-04,   2.364623132237205e-06,  -1.665256575093118e-08,   1.172726461370146e-10,
  -8.258614207146565e-13,   5.815687473922785e-15,  -4.094512354975486e-17,   2.879213935625737e-19,  -2.011880942538761e-21,   4.767771326340033e-02,  -3.357735521210186e-04,
   2.364702378103733e-06,  -1.665349587611788e-08,   1.172824712824332e-10,  -8.259582673270422e-13,   5.816595523962511e-15,  -4.095328173183275e-17,   2.879905772625970e-19,
  -2.012381670329664e-21,   4.767781328111951e-02,  -3.357756649578402e-04,   2.364732136286673e-06,  -1.665384515676965e-08,   1.172861608543494e-10,  -8.259946358544776e-13,
   5.816936524563994e-15,  -4.095634538496341e-17,   2.880165569577026e-19,  -2.012569658708598e-21,   4.767782986052873e-02,  -3.357760151922153e-04,   2.364737069161626e-06,
  -1.665390305553285e-08,   1.172867724606758e-10,  -8.260006645461222e-13,   5.816993051285540e-15,  -4.095685323853429e-17,   2.880208634918322e-19,  -2.012600818367424e-21,
   9.491116941416093e-02,  -6.683566225472575e-04,   4.706283144737160e-06,  -3.313803072798537e-08,   2.333211092838438e-10,  -1.642701411818070e-12,   1.156456435899316e-14,
  -8.139379631378656e-17,   5.721575497403463e-19,  -3.996867117905259e-21,   9.491183955373669e-02,  -6.683707781694317e-04,   4.706482504617682e-06,  -3.314037046954066e-08,
   2.333458222505191e-10,  -1.642944981279120e-12,   1.156684778794425e-14,  -8.141430613719514e-17,   5.723313418121801e-19,  -3.998120175002841e-21,   9.491293971686836e-02,
  -6.683940176373687e-04,   4.706809801396373e-06,  -3.314421178475451e-08,   2.333863961110812e-10,  -1.643344884304598e-12,   1.157059690683276e-14,  -8.144798096420345e-17,
   5.726166624953922e-19,  -4.000176160720445e-21,   9.491410710293190e-02,  -6.684186774919927e-04,   4.707157109330925e-06,  -3.314828805796508e-08,   2.334294529060278e-10,
  -1.643769272585705e-12,   1.157457569228551e-14,  -8.148371885224139e-17,   5.729194271619962e-19,  -4.002356206940328e-21,   9.491502586213781e-02,  -6.684380856389512e-04,
   4.707430457529871e-06,  -3.315149635323353e-08,   2.334633423005683e-10,  -1.644103312030202e-12,   1.157770751010243e-14,  -8.151184931314886e-17,   5.731577170248494e-19,
  -4.004070815365926e-21,   9.491555610415472e-02,  -6.684492867454102e-04,   4.707588218145553e-06,  -3.315334802211893e-08,   2.334829019241767e-10,  -1.644296110219027e-12,
   1.157951514093325e-14,  -8.152808577759018e-17,   5.732952437346040e-19,  -4.005059907544287e-21,   9.491575521683832e-02,  -6.684534929262012e-04,   4.707647459964311e-06,
  -3.315404336090157e-08,   2.334902470203309e-10,  -1.644368511162722e-12,   1.158019396162066e-14,  -8.153418307638737e-17,   5.733468873172866e-19,  -4.005431237834058e-21,
   9.491578822269658e-02,  -6.684541901637189e-04,   4.707657280203823e-06,  -3.315415862424442e-08,   2.334914645890289e-10,  -1.644380512829914e-12,   1.158030648783572e-14,
  -8.153519380913410e-17,   5.733554480295957e-19,  -4.005492786727938e-21,   1.604143966561783e-01,  -1.129624943181842e-03,   7.954338522664929e-06,  -5.600834160747173e-08,
   3.943483636692415e-10,  -2.776416218671074e-12,   1.954585359622127e-14,  -1.375664430846569e-16,   9.669652995873186e-19,  -6.752615406676745e-21,   1.604155292945851e-01,
  -1.129648868348936e-03,   7.954675471356883e-06,  -5.601229612792754e-08,   3.943901322975125e-10,  -2.776827883533164e-12,   1.954971265431724e-14,  -1.376010933264329e-16,
   9.672583998635134e-19,  -6.754708909596373e-21,   1.604173887385901e-01,  -1.129688146605074e-03,   7.955228652975786e-06,  -5.601878853711880e-08,   3.944587082200536e-10,
  -2.777503772930806e-12,   1.955604876716608e-14,  -1.376579850445878e-16,   9.677395892771515e-19,  -6.758143713044614e-21,   1.604193617996343e-01,  -1.129729825532012e-03,
   7.955815656508920e-06,  -5.602567806119043e-08,   3.945314806742876e-10,  -2.778221045630901e-12,   1.956277302031634e-14,  -1.377183620679458e-16,   9.682501925093677e-19,
  -6.761785550977469e-21,   1.604209146432520e-01,  -1.129762628269556e-03,   7.956277656776065e-06,  -5.603110057001630e-08,   3.945887588436812e-10,  -2.778785616737124e-12,
   1.956806587388578e-14,  -1.377658867113671e-16,   9.686520571932080e-19,  -6.764649696232788e-21,   1.604218108333816e-01,  -1.129781559853090e-03,   7.956544296347375e-06,
  -5.603423017313171e-08,   3.946218175466648e-10,  -2.779111471316389e-12,   1.957112081629616e-14,  -1.377933171613114e-16,   9.688839880206749e-19,  -6.766301846534272e-21,
   1.604221473642789e-01,  -1.129788668942115e-03,   7.956644424082603e-06,  -5.603540540183318e-08,   3.946342318628276e-10,  -2.779233838537483e-12,   1.957226804051287e-14,
  -1.378036181441801e-16,   9.689710816425093e-19,  -6.766922093199626e-21,   1.604222031492289e-01,  -1.129789847380188e-03,   7.956661021789466e-06,  -5.603560021448008e-08,
   3.946362897368752e-10,  -2.779254122950628e-12,   1.957245821266954e-14,  -1.378053257099279e-16,   9.689855187248442e-19,  -6.767024899927056e-21,   2.470478835134658e-01,
  -1.739690808264348e-03,   1.225016293758121e-05,  -8.625623707432363e-08,   6.073203422430200e-10,  -4.275848006232605e-12,   3.010173225965385e-14,  -2.118572367722255e-16,
   1.489031365251201e-18,  -1.039335680027192e-20,   2.470496278451903e-01,  -1.739727654470204e-03,   1.225068185895490e-05,  -8.626232727364020e-08,   6.073846683115571e-10,
  -4.276481984315705e-12,   3.010767480025162e-14,  -2.119105676061205e-16,   1.489481324036528e-18,  -1.039652576500004e-20,   2.470524915015420e-01,  -1.739788145362731e-03,
   1.225153379211981e-05,  -8.627232597422033e-08,   6.074902791404204e-10,  -4.277522877225315e-12,   3.011743173868477e-14,  -2.119981305120351e-16,   1.490220022917330e-18,
  -1.040172469378602e-20,   2.470555301350134e-01,  -1.739852333433636e-03,   1.225243781307900e-05,  -8.628293625558191e-08,   6.076023528659077e-10,  -4.278627501748748e-12,
   3.012778636630923e-14,  -2.120910574323408e-16,   1.491003864590003e-18,  -1.040723647078012e-20,   2.470579216082049e-01,  -1.739902851635470e-03,   1.225314932144483e-05,
  -8.629128724523728e-08,   6.076905645090302e-10,  -4.279496960519101e-12,   3.013593678832676e-14,  -2.121642029204662e-16,   1.491620769966167e-18,  -1.041157086322676e-20,
   2.470593017952663e-01,  -1.739932007420310e-03,   1.225355996251827e-05,  -8.629610702221829e-08,   6.077414767940787e-10,  -4.279998787663781e-12,   3.014064106760937e-14,
  -2.122064212253640e-16,   1.491976805186147e-18,  -1.041407095747983e-20,   2.470598200732240e-01,  -1.739942955847823e-03,   1.225371416528897e-05,  -8.629791694508433e-08,
   6.077605955478007e-10,  -4.280187237344615e-12,   3.014240766791230e-14,  -2.122222754904293e-16,   1.492110501275466e-18,  -1.041500950867799e-20,   2.470599059854246e-01,
  -1.739944770713803e-03,   1.225373972676182e-05,  -8.629821696827446e-08,   6.077637647909988e-10,  -4.280218476030228e-12,   3.014270051229815e-14,  -2.122249036077823e-16,
   1.492132663385527e-18,  -1.041516507329687e-20,   3.597879074151992e-01,  -2.533596752782021e-03,   1.784051101941328e-05,  -1.256191735566123e-07,   8.844702665029804e-10,
  -6.227124127861949e-12,   4.383848233924221e-14,  -3.085306677605286e-16,   2.168215674672826e-18,  -1.512311542851470e-20,   3.597904477707446e-01,  -2.533650413712341e-03,
   1.784126674994405e-05,  -1.256280430080574e-07,   8.845639473816685e-10,  -6.228047397930486e-12,   4.384713535732239e-14,  -3.086082649679901e-16,   2.168867836130119e-18,
  -1.512760933695087e-20,   3.597946182534524e-01,  -2.533738509555410e-03,   1.784250746180415e-05,  -1.256426045986645e-07,   8.847177530678260e-10,  -6.229563262906848e-12,
   4.386134256562976e-14,  -3.087356699433505e-16,   2.169938472487983e-18,  -1.513498107656470e-20,   3.597990435638914e-01,  -2.533831989780038e-03,   1.784382403166175e-05,
  -1.256580568638713e-07,   8.848809709511269e-10,  -6.231171940799446e-12,   4.387642006510636e-14,  -3.088708790199811e-16,   2.171074510390512e-18,  -1.514279524129894e-20,
   3.598025263831847e-01,  -2.533905561906269e-03,   1.784486023603088e-05,  -1.256702188134223e-07,   8.850094374348901e-10,  -6.232438143845992e-12,   4.388828798519465e-14,
  -3.089773055921677e-16,   2.171968584945708e-18,  -1.514893935042082e-20,   3.598045364170595e-01,  -2.533948022900617e-03,   1.784545827267363e-05,  -1.256772380874042e-07,
   8.850835832271454e-10,  -6.233168960566413e-12,   4.389513793503275e-14,  -3.090387329862770e-16,   2.172484575407994e-18,  -1.515248295362651e-20,   3.598052912105805e-01,
  -2.533963967630671e-03,   1.784568284569677e-05,  -1.256798739654799e-07,   8.851114267060250e-10,  -6.233443402021908e-12,   4.389771029938564e-14,  -3.090618008190185e-16,
   2.172678335421695e-18,  -1.515381317981268e-20,   3.598054163287172e-01,  -2.533966610708692e-03,   1.784572007211758e-05,  -1.256803109037405e-07,   8.851160422137703e-10,
  -6.233488895281414e-12,   4.389813671298689e-14,  -3.090656247076486e-16,   2.172710453941440e-18,  -1.515403366103433e-20,   5.083779536583347e-01,  -3.579955596109519e-03,
   2.520852506496774e-05,  -1.774990676772802e-07,   1.249750617185297e-09,  -8.798880421632482e-12,   6.194317179132194e-14,  -4.359352416652092e-16,   3.062921850282488e-18,
  -2.133880766584402e-20,   5.083815431640596e-01,  -3.580031418651805e-03,   2.520959290718864e-05,  -1.775116001462585e-07,   1.249882986939808e-09,  -8.800184944073792e-12,
   6.195539530031526e-14,  -4.360447244969448e-16,   3.063836180332617e-18,  -2.134487838746231e-20,   5.083874360287736e-01,  -3.580155897499757e-03,   2.521134602480650e-05,
  -1.775321755655175e-07,   1.250100312190714e-09,  -8.802326765442335e-12,   6.197546480229632e-14,  -4.362244806944677e-16,   3.065337166866167e-18,  -2.135483464359039e-20,
   5.083936889634006e-01,  -3.580287984443503e-03,   2.521320632927039e-05,  -1.775540095012900e-07,   1.250330936735964e-09,  -8.804599725124061e-12,   6.199676367449994e-14,
  -4.364152463514533e-16,   3.066929782094398e-18,  -2.136538562409199e-20,   5.083986101642202e-01,  -3.580391941374900e-03,   2.521467047916088e-05,  -1.775711942454676e-07,
   1.250512458043663e-09,  -8.806388789261080e-12,   6.201352859046267e-14,  -4.365654019485898e-16,   3.068183143484325e-18,  -2.137367958764172e-20,   5.084014503289025e-01,
  -3.580451938481175e-03,   2.521551550096439e-05,  -1.775811124273285e-07,   1.250617224987766e-09,  -8.807421386533307e-12,   6.202320499013110e-14,  -4.366520685024904e-16,
   3.068906468499170e-18,  -2.137846229315340e-20,   5.084025168471974e-01,  -3.580474468280070e-03,   2.521583282115422e-05,  -1.775848369034150e-07,   1.250656567424871e-09,
  -8.807809154726727e-12,   6.202683877077774e-14,  -4.366846143222269e-16,   3.069178081491630e-18,  -2.138025750780099e-20,   5.084026936383039e-01,  -3.580478202931964e-03,
   2.521588542183954e-05,  -1.775854542939222e-07,   1.250663089071230e-09,  -8.807873433786333e-12,   6.202744113229136e-14,  -4.366900093456254e-16,   3.069223105087470e-18,
  -2.138055505132125e-20,   7.179511822167114e-01,  -5.055752976647354e-03,   3.560046267627712e-05,  -2.506711071901385e-07,   1.764946405656735e-09,  -1.242610881472209e-11,
   8.747772968830416e-14,  -6.156006588813313e-16,   4.323555334577767e-18,  -3.005390275385244e-20,   7.179562514567501e-01,  -5.055860056199157e-03,   3.560197072456325e-05,
  -2.506888060115288e-07,   1.765133341506498e-09,  -1.242795097336832e-11,   8.749498373455190e-14,  -6.157548358046992e-16,   4.324826875316671e-18,  -3.006169889719984e-20,
   7.179645735902249e-01,  -5.056035850083736e-03,   3.560444654539705e-05,  -2.507178633879585e-07,   1.765440253601934e-09,  -1.243097550817557e-11,   8.752331270579348e-14,
  -6.160079709105848e-16,   4.326914139189544e-18,  -3.007447876534786e-20,   7.179734042284800e-01,  -5.056222388417951e-03,   3.560707373965898e-05,  -2.507486980882711e-07,
   1.765765947272092e-09,  -1.243418522633392e-11,   8.755337691047921e-14,  -6.162766058369842e-16,   4.329128646411298e-18,  -3.008801362596740e-20,   7.179803541402908e-01,
  -5.056369200451463e-03,   3.560914146903519e-05,  -2.507729670262713e-07,   1.766022296126377e-09,  -1.243671161938277e-11,   8.757704120063720e-14,  -6.164880511534965e-16,
   4.330871299256954e-18,  -3.009864706843483e-20,   7.179843651316717e-01,  -5.056453930705220e-03,   3.561033484166549e-05,  -2.507869738533260e-07,   1.766170250575849e-09,
  -1.243816978169822e-11,   8.759069976945781e-14,  -6.166100916815165e-16,   4.331876947277986e-18,  -3.010477637732251e-20,   7.179858713104208e-01,  -5.056485748166027e-03,
   3.561078297356925e-05,  -2.507922336976237e-07,   1.766225810930024e-09,  -1.243871736100062e-11,   8.759582897083567e-14,  -6.166559212482026e-16,   4.332254564631365e-18,
  -3.010707658192249e-20,   7.179861209817195e-01,  -5.056491022387107e-03,   3.561085725830120e-05,  -2.507931055995669e-07,   1.766235020958840e-09,  -1.243880813141906e-11,
   8.759667922378228e-14,  -6.166635182674693e-16,   4.332317159400384e-18,  -3.010745779922841e-20,   1.827545734236373e-03,  -1.251687151906017e-05,   8.572418071278620e-08,
  -5.870713580687090e-10,   4.020299409927695e-12,  -2.752995299773296e-14,   1.885076381556352e-16,  -1.290645210373732e-18,   8.832972561118441e-21,  -6.032685118621003e-23,
   1.827557940324771e-03,  -1.251712229129282e-05,   8.572761570408784e-08,  -5.871105678256969e-10,   4.020702219064465e-12,  -2.753381498080173e-14,   1.885428884016482e-16,
  -1.290954824469079e-18,   8.835590253111995e-21,  -6.034755040969418e-23,   1.827577978948622e-03,  -1.251753398661731e-05,   8.573325504713068e-08,  -5.871749409639280e-10,
   4.021363549889187e-12,  -2.754015572036354e-14,   1.886007649296477e-16,  -1.291463182772554e-18,   8.839888220749327e-21,  -6.038153093325190e-23,   1.827599241958899e-03,
  -1.251797084364955e-05,   8.573923916427218e-08,  -5.872432512437976e-10,   4.022065346999467e-12,  -2.754688464489644e-14,   1.886621866535130e-16,  -1.292002694408126e-18,
   8.844449515032606e-21,  -6.041758605349252e-23,   1.827615976408464e-03,  -1.251831466435804e-05,   8.574394894088167e-08,  -5.872970157067099e-10,   4.022617718591403e-12,
  -2.755218100265936e-14,   1.887105332983202e-16,  -1.292427368333255e-18,   8.848039869755374e-21,  -6.044596099457970e-23,   1.827625634326342e-03,  -1.251851309479390e-05,
   8.574666714326336e-08,  -5.873280457985036e-10,   4.022936524517058e-12,  -2.755523789839470e-14,   1.887384380691436e-16,  -1.292672486196719e-18,   8.850112170898372e-21,
  -6.046233647002867e-23,   1.827629260996967e-03,  -1.251858760829958e-05,   8.574768787384936e-08,  -5.873396982030865e-10,   4.023056243372216e-12,  -2.755638584306201e-14,
   1.887489171507310e-16,  -1.292764536106962e-18,   8.850890385405772e-21,  -6.046848557441283e-23,   1.827629862170928e-03,  -1.251859996002739e-05,   8.574785707553376e-08,
  -5.873416297715809e-10,   4.023076088700271e-12,  -2.755657613395568e-14,   1.887506542381830e-16,  -1.292779794998663e-18,   8.851019387963690e-21,  -6.046950487385299e-23,
   1.652781346716861e-02,  -1.131990919756423e-04,   7.752655607460624e-07,  -5.309309483033029e-09,   3.635846557856841e-11,  -2.489732076549207e-13,   1.704810312537061e-15,
  -1.167222736540325e-17,   7.988259082986426e-20,  -5.455653176787013e-22,   1.652792385562480e-02,  -1.132013598897119e-04,   7.752966258484991e-07,  -5.309664085126389e-09,
   3.636210847163022e-11,  -2.490081343277098e-13,   1.705129104468840e-15,  -1.167502735422997e-17,   7.990626118847060e-20,  -5.457523863343326e-22,   1.652810507934518e-02,
  -1.132050831473030e-04,   7.753476264927271e-07,  -5.310246257813125e-09,   3.636808936245949e-11,  -2.490654781667058e-13,   1.705652521236731e-15,  -1.167962468182796e-17,
   7.994512534153373e-20,  -5.460594835711619e-22,   1.652829737607463e-02,  -1.132090339603551e-04,   7.754017451776577e-07,  -5.310864036909409e-09,   3.637443621904314e-11,
  -2.491263326395780e-13,   1.706207999606924e-15,  -1.168450374329235e-17,   7.998637058480357e-20,  -5.463853287814468e-22,   1.652844871776514e-02,  -1.132121433788661e-04,
   7.754443390825554e-07,  -5.311350267698856e-09,   3.637943171307124e-11,  -2.491742313873153e-13,   1.706645231146565e-15,  -1.168834427201781e-17,   8.001883614250337e-20,
  -5.466417642091513e-22,   1.652853606127844e-02,  -1.132139379283368e-04,   7.754689217460948e-07,  -5.311630895184219e-09,   3.638231490460480e-11,  -2.492018770796771e-13,
   1.706897592934631e-15,  -1.169056098950706e-17,   8.003757478775740e-20,  -5.467897554609492e-22,   1.652856885987520e-02,  -1.132146118076818e-04,   7.754781529485724e-07,
  -5.311736276277456e-09,   3.638339760841226e-11,  -2.492122587635262e-13,   1.706992362383332e-15,  -1.169139344061625e-17,   8.004461173916009e-20,  -5.468453271403838e-22,
   1.652857429672469e-02,  -1.132147235132603e-04,   7.754796831613725e-07,  -5.311753744843549e-09,   3.638357708400292e-11,  -2.492139797000425e-13,   1.707008072044375e-15,
  -1.169153143402783e-17,   8.004577823587764e-20,  -5.468545389147679e-22,   4.636920481201173e-02,  -3.175829574055656e-04,   2.175027425199451e-06,  -1.489540399796404e-08,
   1.020046080115159e-10,  -6.985007093376181e-13,   4.782888229564410e-15,  -3.274668878835691e-17,   2.241106286571122e-19,  -1.530516305278671e-21,   4.636951450965832e-02,
  -3.175893200966853e-04,   2.175114579141348e-06,  -1.489639884321580e-08,   1.020148282395665e-10,  -6.985986968740617e-13,   4.783782600016397e-15,  -3.275454379244610e-17,
   2.241770170440325e-19,  -1.531040373736296e-21,   4.637002293745634e-02,  -3.175997657914002e-04,   2.175257662757209e-06,  -1.489803214359361e-08,   1.020316077791072e-10,
  -6.987595762545516e-13,   4.785251045190639e-15,  -3.276744099370896e-17,   2.242860194325219e-19,  -1.531900694767576e-21,   4.637056243086544e-02,  -3.176108498988004e-04,
   2.175409494116256e-06,  -1.489976533866481e-08,   1.020494140447519e-10,  -6.989303047930370e-13,   4.786809439080683e-15,  -3.278112855876216e-17,   2.244016999092250e-19,
  -1.532813531137726e-21,   4.637098702386181e-02,  -3.176195734522243e-04,   2.175528992409238e-06,  -1.490112947159311e-08,   1.020634290287738e-10,  -6.990646857638087e-13,
   4.788036091577639e-15,  -3.279190265414286e-17,   2.244927558967231e-19,  -1.533531915412123e-21,   4.637123206832977e-02,  -3.176246081068144e-04,   2.175597959702492e-06,
  -1.490191677918787e-08,   1.020715178950644e-10,  -6.991422463501492e-13,   4.788744092213189e-15,  -3.279812136078462e-17,   2.245453120343648e-19,  -1.533946499744660e-21,
   4.637132408563464e-02,  -3.176264986926096e-04,   2.175623858077879e-06,  -1.490221242854288e-08,   1.020745554477993e-10,  -6.991713723880892e-13,   4.789009967761880e-15,
  -3.280045669165624e-17,   2.245650485102132e-19,  -1.534102178510799e-21,   4.637133933885541e-02,  -3.176268120854764e-04,   2.175628151129149e-06,  -1.490226143705229e-08,
   1.020750589710782e-10,  -6.991762005125974e-13,   4.789054041192572e-15,  -3.280084381380860e-17,   2.245683201728502e-19,  -1.534127984400615e-21,   9.231061138618439e-02,
  -6.322359221552536e-04,   4.329988237096888e-06,  -2.965338429197754e-08,   2.030681298188140e-10,  -1.390557068016447e-12,   9.521647229271648e-15,  -6.519111663474297e-17,
   4.461471263590797e-19,  -3.046651689151203e-21,   9.231122792423407e-02,  -6.322485888358569e-04,   4.330161740905479e-06,  -2.965536480405906e-08,   2.030884759778507e-10,
  -1.390752138615462e-12,   9.523427691566685e-15,  -6.520675277292007e-17,   4.462792282778451e-19,  -3.047692554625865e-21,   9.231224008911962e-02,  -6.322693838542139e-04,
   4.330446588059355e-06,  -2.965861633601822e-08,   2.031218802402546e-10,  -1.391072412376469e-12,   9.526350989291693e-15,  -6.523242587884238e-17,   4.464961246353861e-19,
  -3.049401244612778e-21,   9.231331409861868e-02,  -6.322914498080015e-04,   4.330748849993629e-06,  -2.966206673573712e-08,   2.031573284817055e-10,  -1.391412293536564e-12,
   9.529453351600546e-15,  -6.525967226709559e-17,   4.467263087409897e-19,  -3.051214215081473e-21,   9.231415936735347e-02,  -6.323088164321023e-04,   4.330986744098019e-06,
  -2.966478241612979e-08,   2.031852291401990e-10,  -1.391679815066009e-12,   9.531895301755472e-15,  -6.528111911068664e-17,   4.469074940017690e-19,  -3.052640972220932e-21,
   9.231464719553051e-02,  -6.323188392919962e-04,   4.331124042397862e-06,  -2.966634976763454e-08,   2.032013322406656e-10,  -1.391834220309576e-12,   9.533304749158171e-15,
  -6.529349802384362e-17,   4.470120712398805e-19,  -3.053464357220763e-21,   9.231483038119662e-02,  -6.323226030212062e-04,   4.331175600212320e-06,  -2.966693833868925e-08,
   2.032073793200806e-10,  -1.391892203535038e-12,   9.533834039067466e-15,  -6.529814671618568e-17,   4.470513432396407e-19,  -3.053773541815593e-21,   9.231486074691327e-02,
  -6.323232269156043e-04,   4.331184146707516e-06,  -2.966703590355647e-08,   2.032083817208684e-10,  -1.391901815217622e-12,   9.533921777944027e-15,  -6.529891731864101e-17,
   4.470578532521354e-19,  -3.053824793340959e-21,   1.560190557326434e-01,  -1.068575433459020e-03,   7.318342560288517e-06,  -5.011875607354112e-08,   3.432162050723618e-10,
  -2.350254074703910e-12,   1.609303372787556e-14,  -1.101826033052463e-16,   7.540406007545379e-19,  -5.148653771729037e-21,   1.560200977762707e-01,  -1.068596842087092e-03,
   7.318635808267833e-06,  -5.012210344178912e-08,   3.432505931785486e-10,  -2.350583772735532e-12,   1.609604291332934e-14,  -1.102090272562892e-16,   7.542637164229706e-19,
  -5.150406856489321e-21,   1.560218084897771e-01,  -1.068631988849508e-03,   7.319117243534093e-06,  -5.012759902797448e-08,   3.433070514672325e-10,  -2.351125082536457e-12,
   1.610098362127213e-14,  -1.102524129401481e-16,   7.546300460627527e-19,  -5.153284690845259e-21,   1.560236237301419e-01,  -1.068669283687241e-03,   7.319628112443343e-06,
  -5.013343073108001e-08,   3.433669643915231e-10,  -2.351699531717857e-12,   1.610622696826559e-14,  -1.102984573266747e-16,   7.550188168853841e-19,  -5.156338105672067e-21,
   1.560250523636204e-01,  -1.068698635938860e-03,   7.320030189873025e-06,  -5.013802064618139e-08,   3.434141207515536e-10,  -2.352151682466753e-12,   1.611035414277643e-14,
  -1.103347008885784e-16,   7.553248298615444e-19,  -5.158741019919882e-21,   1.560258768678718e-01,  -1.068715576105460e-03,   7.320262245003780e-06,  -5.014066970987790e-08,
   3.434413374425940e-10,  -2.352412650045172e-12,   1.611273626959972e-14,  -1.103556203173374e-16,   7.555014552795441e-19,  -5.160127732297491e-21,   1.560261864796729e-01,
  -1.068721937383631e-03,   7.320349385597575e-06,  -5.014166448495484e-08,   3.434515579272983e-10,  -2.352510650226391e-12,   1.611363082986560e-14,  -1.103634762548034e-16,
   7.555677835352131e-19,  -5.160648445848950e-21,   1.560262378023796e-01,  -1.068722991860613e-03,   7.320363830481907e-06,  -5.014182938449844e-08,   3.434532521372157e-10,
  -2.352526895383946e-12,   1.611377911856416e-14,  -1.103647785144166e-16,   7.555787785857682e-19,  -5.160734761005387e-21,   2.402787923650917e-01,  -1.645670866911876e-03,
   1.127069064864956e-05,  -7.718591887523624e-08,   5.285737333701418e-10,  -3.619533332352460e-12,   2.478423119816548e-14,  -1.696870829350587e-16,   1.161231727436502e-18,
  -7.927773046710765e-21,   2.402803971753708e-01,  -1.645703837495327e-03,   1.127114226829011e-05,  -7.719107402464340e-08,   5.286266931016510e-10,  -3.620041084773736e-12,
   2.478886537335260e-14,  -1.697277695380113e-16,   1.161574986581882e-18,  -7.930459067047533e-21,   2.402830317777497e-01,  -1.645757965637464e-03,   1.127188370774485e-05,
  -7.719953755950357e-08,   5.287136422283591e-10,  -3.620874730504580e-12,   2.479647411116923e-14,  -1.697945731273087e-16,   1.162138575470928e-18,  -7.934868305300892e-21,
   2.402858273578194e-01,  -1.645815401945646e-03,   1.127267047679159e-05,  -7.720851873473105e-08,   5.288059116993080e-10,  -3.621759412611619e-12,   2.480454891468214e-14,
  -1.698654704155566e-16,   1.162736686576438e-18,  -7.939546437914156e-21,   2.402880275398760e-01,  -1.645860606190317e-03,   1.127328970037387e-05,  -7.721558748138082e-08,
   5.288785353014687e-10,  -3.622455748650763e-12,   2.481090480112570e-14,  -1.699212767401598e-16,   1.163207475300711e-18,  -7.943227853038472e-21,   2.402892973263447e-01,
  -1.645886695072551e-03,   1.127364707932314e-05,  -7.721966719956981e-08,   5.289204506260732e-10,  -3.622857652501014e-12,   2.481457329779584e-14,  -1.699534875839961e-16,
   1.163479205574080e-18,  -7.945352348518109e-21,   2.402897741472645e-01,  -1.645896491826087e-03,   1.127378128111281e-05,  -7.722119921330741e-08,   5.289361907809979e-10,
  -3.623008577953384e-12,   2.481595092855259e-14,  -1.699655838175619e-16,   1.163581248452400e-18,  -7.946150094674632e-21,   2.402898531873404e-01,  -1.645898115784484e-03,
   1.127380352710913e-05,  -7.722145316857021e-08,   5.289387999651352e-10,  -3.623033596353512e-12,   2.481617929446182e-14,  -1.699675889805301e-16,   1.163598163807999e-18,
  -7.946282331301443e-21,   3.499297491313377e-01,  -2.396670916905067e-03,   1.641405765468145e-05,  -1.124096261050181e-07,   7.697877553897674e-10,  -5.271302777007712e-12,
   3.609445479295637e-14,  -2.471218774345959e-16,   1.691079867636949e-18,  -1.154243036814410e-20,   3.499320862949833e-01,  -2.396718933577174e-03,   1.641471537043087e-05,
  -1.124171338002724e-07,   7.698648831620091e-10,  -5.272042236275846e-12,   3.610120343937706e-14,  -2.471811142517407e-16,   1.691579006336247e-18,  -1.154631194565399e-20,
   3.499359231951958e-01,  -2.396797763036066e-03,   1.641579516493674e-05,  -1.124294596584498e-07,   7.699915113042486e-10,  -5.273256306396762e-12,   3.611228387313795e-14,
  -2.472783754452845e-16,   1.692398525297902e-18,  -1.155268355789773e-20,   3.499399945350873e-01,  -2.396881410338854e-03,   1.641694097514226e-05,  -1.124425393815069e-07,
   7.701258877157660e-10,  -5.274544702692082e-12,   3.612404302494001e-14,  -2.473815966197064e-16,   1.693268236746001e-18,  -1.155944347475396e-20,   3.499431987677519e-01,
  -2.396947243489714e-03,   1.641784278070129e-05,  -1.124528339416450e-07,   7.702316529152755e-10,  -5.275558803388893e-12,   3.613329895495861e-14,  -2.474628463664414e-16,
   1.693952804381957e-18,  -1.156476294008009e-20,   3.499450480198479e-01,  -2.396985238003997e-03,   1.641836324912716e-05,  -1.124587754340069e-07,   7.702926961921547e-10,
  -5.276144111259782e-12,   3.613864130071701e-14,  -2.475097428517948e-16,   1.694347921860433e-18,  -1.156783265549982e-20,   3.499457424374584e-01,  -2.396999505494986e-03,
   1.641855869375075e-05,  -1.124610065802520e-07,   7.703156193268949e-10,  -5.276363909736535e-12,   3.614064751195124e-14,  -2.475273540195999e-16,   1.694496299979171e-18,
  -1.156898531633573e-20,   3.499458575473839e-01,  -2.397001870544969e-03,   1.641859109168216e-05,  -1.124613764276738e-07,   7.703194192055999e-10,  -5.276400344984074e-12,
   3.614098007583931e-14,  -2.475302733792566e-16,   1.694520896175790e-18,  -1.156917638384034e-20,   4.944484406539361e-01,  -3.386480288011291e-03,   2.319295582001669e-05,
  -1.588340643326914e-07,   1.087705034717693e-09,  -7.448315100767170e-12,   5.100115595001021e-14,  -3.491777713689494e-16,   2.389308674833421e-18,  -1.630223714631773e-20,
   4.944517430508398e-01,  -3.386548135254007e-03,   2.319388516804326e-05,  -1.588446726551060e-07,   1.087814015591632e-09,  -7.449359939827164e-12,   5.101069100525648e-14,
  -3.492614341581586e-16,   2.390012218677111e-18,  -1.630765294310858e-20,   4.944571645656770e-01,  -3.386659520762327e-03,   2.319541091057558e-05,  -1.588620890090013e-07,
   1.087992940058367e-09,  -7.451075393102010e-12,   5.102634636906683e-14,  -3.493988002149428e-16,   2.391167332503886e-18,  -1.631654252628027e-20,   4.944629173422430e-01,
  -3.386777713852468e-03,   2.319702993285702e-05,  -1.588805705688350e-07,   1.088182812760844e-09,  -7.452895867447002e-12,   5.104296067582043e-14,  -3.495445834631391e-16,
   2.392393177720904e-18,  -1.632597325183045e-20,   4.944674449019841e-01,  -3.386870735662788e-03,   2.319830417817833e-05,  -1.588951167123705e-07,   1.088332258068104e-09,
  -7.454328768336058e-12,   5.105603821798634e-14,  -3.496593353698440e-16,   2.393358054603646e-18,  -1.633339396443945e-20,   4.944700578830681e-01,  -3.386924421662238e-03,
   2.319903959663951e-05,  -1.589035120007073e-07,   1.088418511687101e-09,  -7.455155794821765e-12,   5.106358632322542e-14,  -3.497255688449130e-16,   2.393914956069227e-18,
  -1.633767607185114e-20,   4.944710390905976e-01,  -3.386944581533415e-03,   2.319931575860665e-05,  -1.589066645951907e-07,   1.088450901876913e-09,  -7.455466364980161e-12,
   5.106642086300256e-14,  -3.497504416676186e-16,   2.394124087956406e-18,  -1.633928394509659e-20,   4.944712017401676e-01,  -3.386947923333527e-03,   2.319936153667056e-05,
  -1.589071871870845e-07,   1.088456271072436e-09,  -7.455517847140980e-12,   5.106689073652035e-14,  -3.497545647728297e-16,   2.394158755079571e-18,  -1.633955046778337e-20,
   6.982793804456893e-01,  -4.782519597530255e-03,   3.275399715626215e-05,  -2.243116626776474e-07,   1.536099451112687e-09,  -1.051879822195357e-11,   7.202563487799722e-14,
  -4.931124375108610e-16,   3.373808498513362e-18,  -2.300356492401302e-20,   6.982840442194502e-01,  -4.782615414053512e-03,   3.275530961777087e-05,  -2.243266441599648e-07,
   1.536253357731417e-09,  -1.052027375279666e-11,   7.203909869848342e-14,  -4.932304864806928e-16,   3.374797378117991e-18,  -2.301102515531143e-20,   6.982917006942408e-01,
  -4.782772717014120e-03,   3.275746433084755e-05,  -2.243512402070469e-07,   1.536506041146036e-09,  -1.052269633066907e-11,   7.206120458837310e-14,  -4.934243105766194e-16,
   3.376420939980212e-18,  -2.302326922851714e-20,   6.982998249897703e-01,  -4.782939633907376e-03,   3.275975077722156e-05,  -2.243773405790176e-07,   1.536774186039493e-09,
  -1.052526721990026e-11,   7.208466451922080e-14,  -4.936300104372176e-16,   3.378143876095792e-18,  -2.303625689959114e-20,   6.983062189862937e-01,  -4.783071002937198e-03,
   3.276155031613309e-05,  -2.243978832041981e-07,   1.536985237943763e-09,  -1.052729077440882e-11,   7.210313041256905e-14,  -4.937919244652169e-16,   3.379499988643599e-18,
  -2.304647518272443e-20,   6.983099091401342e-01,  -4.783146820400204e-03,   3.276258890274973e-05,  -2.244097393543160e-07,   1.537107048328405e-09,  -1.052845870797717e-11,
   7.211378856495876e-14,  -4.938853791010837e-16,   3.380282688832416e-18,  -2.305237111339852e-20,   6.983112948396923e-01,  -4.783175290956826e-03,   3.276297890944417e-05,
  -2.244141915698847e-07,   1.537152790889772e-09,  -1.052889729767882e-11,   7.211779101966758e-14,  -4.939204743031849e-16,   3.380576612074470e-18,  -2.305458485898487e-20,
   6.983115245397613e-01,  -4.783180010377326e-03,   3.276304355901039e-05,  -2.244149295943206e-07,   1.537160373455874e-09,  -1.052897000120384e-11,   7.211845449503648e-14,
  -4.939262919437908e-16,   3.380625334667331e-18,  -2.305495180659100e-20,   1.778806708193323e-03,  -1.185820428435075e-05,   7.904786740371237e-08,  -5.269172829715672e-10,
   3.512171947225215e-12,  -2.340938602042482e-14,   1.560214427690138e-16,  -1.039805108110407e-18,   6.928691740782471e-21,  -4.613516596529157e-23,   1.778817963320009e-03,
  -1.185842935474277e-05,   7.905086813993323e-08,  -5.269506225190317e-10,   3.512505320683210e-12,  -2.341249721504776e-14,   1.560490916527382e-16,  -1.040041882935205e-18,
   6.930656341332044e-21,  -4.615085752861658e-23,   1.778836440741526e-03,  -1.185879885452211e-05,   7.905579454007806e-08,  -5.270053579852642e-10,   3.513052649865077e-12,
  -2.341760525640831e-14,   1.560944874326281e-16,  -1.040430645271035e-18,   6.933882083338106e-21,  -4.617662110220180e-23,   1.778856047134598e-03,  -1.185919093635378e-05,
   7.906102211138717e-08,  -5.270634408995242e-10,   3.513633466465405e-12,  -2.342302597884852e-14,   1.561426635605732e-16,  -1.040843231183371e-18,   6.937305568239553e-21,
  -4.620396276880734e-23,   1.778871477773645e-03,  -1.185949951695858e-05,   7.906513644022490e-08,  -5.271091556111100e-10,   3.514090614206348e-12,  -2.342729261970877e-14,
   1.561805839999374e-16,  -1.041167995688282e-18,   6.940000392502002e-21,  -4.622548407483386e-23,   1.778880383219310e-03,  -1.185967760892572e-05,   7.906751098112636e-08,
  -5.271355397289940e-10,   3.514354459953722e-12,  -2.342975518355389e-14,   1.562024708613763e-16,  -1.041355446574643e-18,   6.941555838169428e-21,  -4.623790575091643e-23,
   1.778883727325797e-03,  -1.185974448499885e-05,   7.906840266020959e-08,  -5.271454474665215e-10,   3.514453539839902e-12,  -2.343067993894248e-14,   1.562106900178338e-16,
  -1.041425840582583e-18,   6.942139963154068e-21,  -4.624257046113884e-23,   1.778884281660532e-03,  -1.185975557070576e-05,   7.906855046959139e-08,  -5.271470898284372e-10,
   3.514469963917239e-12,  -2.343083323239895e-14,   1.562120524829451e-16,  -1.041437509625758e-18,   6.942236792323991e-21,  -4.624334371667130e-23,   1.608703132097103e-02,
  -1.072422893696921e-04,   7.148868468513979e-07,  -4.765292819927350e-09,   3.176310267264203e-11,  -2.117079519867369e-13,   1.411014342433114e-15,  -9.403705380588283e-18,
   6.266107284871035e-20,  -4.172302691076689e-22,   1.608713310919495e-02,  -1.072443248434899e-04,   7.149139846721274e-07,  -4.765594333487194e-09,   3.176611760906132e-11,
  -2.117360887568852e-13,   1.411264390879401e-15,  -9.405846688276749e-18,   6.267883934617201e-20,  -4.173721473983247e-22,   1.608730021383723e-02,  -1.072476664963496e-04,
   7.149585376598386e-07,  -4.766089345763257e-09,   3.177106750127380e-11,  -2.117822844479204e-13,   1.411674937080104e-15,  -9.409362517090763e-18,   6.270801073536008e-20,
  -4.176050935114421e-22,   1.608747752858312e-02,  -1.072512123749868e-04,   7.150058143554878e-07,  -4.766614631424762e-09,   3.177632024434268e-11,  -2.118313079387454e-13,
   1.412110627935070e-15,  -9.413093797732470e-18,   6.273897036822404e-20,  -4.178523079755053e-22,   1.608761707897525e-02,  -1.072540030918373e-04,   7.150430231969861e-07,
  -4.767028062514120e-09,   3.178045456079651e-11,  -2.118698942399569e-13,   1.412453569330401e-15,  -9.416030852602999e-18,   6.276334049255135e-20,  -4.180468964355518e-22,
   1.608769761733992e-02,  -1.072556137058743e-04,   7.150644978820487e-07,  -4.767266673110578e-09,   3.178284070802387e-11,  -2.118921649754905e-13,   1.412651507721752e-15,
  -9.417726091816641e-18,   6.277740686393414e-20,  -4.181592090029272e-22,   1.608772786050549e-02,  -1.072562185144115e-04,   7.150725619787662e-07,  -4.767356275922822e-09,
   3.178373675883401e-11,  -2.119005282034029e-13,   1.412725839375391e-15,  -9.418362710204309e-18,   6.278268928462467e-20,  -4.182013857102714e-22,   1.608773287375410e-02,
  -1.072563187704503e-04,   7.150738987255544e-07,  -4.767371128985487e-09,   3.178388529360096e-11,  -2.119019145463534e-13,   1.412738161112445e-15,  -9.418468240882800e-18,
   6.278356494037024e-20,  -4.182083772203732e-22,   4.513257918968663e-02,  -3.008709948336495e-04,   2.005633393966901e-06,  -1.336915129083390e-08,   8.911219959860025e-11,
  -5.939520889677621e-13,   3.958636753429217e-15,  -2.638232649280433e-17,   1.757967740893197e-19,  -1.170530984756935e-21,   4.513286475916087e-02,  -3.008767054076225e-04,
   2.005709529819320e-06,  -1.336999719485868e-08,   8.912065807965663e-11,  -5.940310273661006e-13,   3.959338268776278e-15,  -2.638833388286568e-17,   1.758466137679664e-19,
  -1.170928841744386e-21,   4.513333357552297e-02,  -3.008860805004718e-04,   2.005834524369582e-06,  -1.337138596449427e-08,   8.913454512856194e-11,  -5.941606305094253e-13,
   3.960490063404200e-15,  -2.639819746003732e-17,   1.759284471253893e-19,  -1.171582071173061e-21,   4.513383103659274e-02,  -3.008960285539813e-04,   2.005967160352355e-06,
  -1.337285966688906e-08,   8.914928183326839e-11,  -5.942981671140589e-13,   3.961712401786341e-15,  -2.640866548145734e-17,   1.760152969325448e-19,  -1.172275310454817e-21,
   4.513422254879895e-02,  -3.009038579817192e-04,   2.006071550711964e-06,  -1.337401955841304e-08,   8.916088076356599e-11,  -5.944064219272912e-13,   3.962674529909626e-15,
  -2.641690532020561e-17,   1.760836614283754e-19,  -1.172820974649998e-21,   4.513444850124777e-02,  -3.009083766007308e-04,   2.006131798491951e-06,  -1.337468898656076e-08,
   8.916757516049330e-11,  -5.944689030212713e-13,   3.963229849546685e-15,  -2.642166127390424e-17,   1.761231212230093e-19,  -1.173135920650808e-21,   4.513453334922488e-02,
  -3.009100734066020e-04,   2.006154422522219e-06,  -1.337494036954844e-08,   8.917008905390302e-11,  -5.944923662619895e-13,   3.963438388306859e-15,  -2.642344729175073e-17,
   1.761379397713498e-19,  -1.173254192148388e-21,   4.513454741402247e-02,  -3.009103546774916e-04,   2.006158172799634e-06,  -1.337498204019666e-08,   8.917050577198140e-11,
  -5.944962556810867e-13,   3.963472957156585e-15,  -2.642374335557340e-17,   1.761403962107618e-19,  -1.173273797665950e-21,   8.984876914162959e-02,  -5.989661801201867e-04,
   3.992762989223569e-06,  -2.661495995694853e-08,   1.774022576879944e-10,  -1.182424417914405e-12,   7.880750852576479e-15,  -5.252121911705420e-17,   3.499701462442928e-19,
  -2.330201111578465e-21,   8.984933764593903e-02,  -5.989775485828749e-04,   3.992914558505555e-06,  -2.661664396074644e-08,   1.774190966115059e-10,  -1.182581566328869e-12,
   7.882147404795790e-15,  -5.253317814157828e-17,   3.500693507565408e-19,  -2.330992557118969e-21,   8.985027095340435e-02,  -5.989962122747840e-04,   3.993163394417067e-06,
  -2.661940868732551e-08,   1.774467425863182e-10,  -1.182839576737690e-12,   7.884440357217576e-15,  -5.255281374823972e-17,   3.502322377129919e-19,  -2.332292004037857e-21,
   8.985126128601145e-02,  -5.990160166019279e-04,   3.993427442694398e-06,  -2.662234249583912e-08,   1.774760800337287e-10,  -1.183113380864299e-12,   7.886873745617598e-15,
  -5.257365263037166e-17,   3.504051096394299e-19,  -2.333671036112462e-21,   8.985204069836643e-02,  -5.990316032237857e-04,   3.993635260317100e-06,  -2.662465157780830e-08,
   1.774991708816664e-10,  -1.183328891597391e-12,   7.888789116514297e-15,  -5.259005582627569e-17,   3.505411870160627e-19,  -2.334756499520922e-21,   8.985249051864648e-02,
  -5.990405987734236e-04,   3.993755200036216e-06,  -2.662598425800603e-08,   1.775124979124763e-10,  -1.183453277256887e-12,   7.889894627338871e-15,  -5.259952358839277e-17,
   3.506197304571558e-19,  -2.335383004897592e-21,   8.985265943180067e-02,  -5.990439767305830e-04,   3.993800239369385e-06,  -2.662648470473935e-08,   1.775175025059122e-10,
  -1.183499987237160e-12,   7.890309778973267e-15,  -5.260307904591102e-17,   3.506492262897383e-19,  -2.335618275835318e-21,   8.985268743163527e-02,  -5.990445366773814e-04,
   3.993807705324477e-06,  -2.662656766158529e-08,   1.775183320973942e-10,  -1.183507730186714e-12,   7.890378597424165e-15,  -5.260366842542418e-17,   3.506541157511336e-19,
  -2.335657275990447e-21,   1.518581657050476e-01,  -1.012344479522253e-03,   6.748380299793429e-06,  -4.498335411469311e-08,   2.998369557265112e-10,  -1.998478139396229e-12,
   1.331967306949312e-14,  -8.876881353137674e-17,   5.914992988436598e-19,  -3.938242073096155e-21,   1.518591265643054e-01,  -1.012363693963442e-03,   6.748636475068092e-06,
  -4.498620033870814e-08,   2.998654160799396e-10,  -1.998743744000399e-12,   1.332203344051268e-14,  -8.878902528136049e-17,   5.916669319606367e-19,  -3.939578235409133e-21,
   1.518607039967073e-01,  -1.012395238458101e-03,   6.749057045827164e-06,  -4.499087314953770e-08,   2.999121420011707e-10,  -1.999179820638275e-12,   1.332590885470896e-14,
  -8.882221109069463e-17,   5.919421737196683e-19,  -3.941772024459587e-21,   1.518623778103231e-01,  -1.012428710800812e-03,   6.749503327811759e-06,  -4.499583173470014e-08,
   2.999617267694853e-10,  -1.999642591046990e-12,   1.333002162544396e-14,  -8.885743052831139e-17,   5.922342874713303e-19,  -3.944100160206399e-21,   1.518636951364444e-01,
  -1.012455054576328e-03,   6.749854571387481e-06,  -4.499973443644002e-08,   3.000007538303080e-10,  -2.000006836797368e-12,   1.333325887319019e-14,  -8.888515328326804e-17,
   5.924642266688364e-19,  -3.945932672581016e-21,   1.518644554015351e-01,  -1.012470258431433e-03,   6.750057287861981e-06,  -4.500198686982935e-08,   3.000232785484639e-10,
  -2.000217067383458e-12,   1.333512734281673e-14,  -8.890115458053329e-17,   5.925969467675524e-19,  -3.946990354297886e-21,   1.518647408906075e-01,  -1.012475967695822e-03,
   6.750133411225460e-06,  -4.500283270136015e-08,   3.000317370759642e-10,  -2.000296014317956e-12,   1.333582900777844e-14,  -8.890716359597881e-17,   5.926467878280201e-19,
  -3.947387543748686e-21,   1.518647882146117e-01,  -1.012476914091577e-03,   6.750146029831759e-06,  -4.500297291111938e-08,   3.000331392123125e-10,  -2.000309101074304e-12,
   1.333594532069049e-14,  -8.890815969577837e-17,   5.926550498735929e-19,  -3.947453384611003e-21,   2.338707697918273e-01,  -1.559071793216447e-03,   1.039291425801254e-05,
  -6.927708895090987e-08,   4.617670654251692e-10,  -3.077777282706714e-12,   2.051309958250800e-14,  -1.367091652717871e-16,   9.109362856263874e-19,  -6.064786534370437e-21,
   2.338722495732617e-01,  -1.559101384619257e-03,   1.039330878344559e-05,  -6.928147230814189e-08,   4.618108960849339e-10,  -3.078186329304185e-12,   2.051673466136643e-14,
  -1.367402907334705e-16,   9.111943663684063e-19,  -6.066840933270351e-21,   2.338746789146701e-01,  -1.559149965050962e-03,   1.039395648787791e-05,  -6.928866871960974e-08,
   4.618828568200412e-10,  -3.078857912782417e-12,   2.052270297547110e-14,  -1.367913958278425e-16,   9.116181162109602e-19,  -6.070213943693664e-21,   2.338772566889833e-01,
  -1.559201514485391e-03,   1.039464378915421e-05,  -6.929630524084398e-08,   4.619592203519000e-10,  -3.079570606220567e-12,   2.052903682911387e-14,  -1.368456326286837e-16,
   9.120678406797285e-19,  -6.073793486860352e-21,   2.338792854509706e-01,  -1.559242085494726e-03,   1.039518472552676e-05,  -6.930231563770685e-08,   4.620193243778158e-10,
  -3.080131565930737e-12,   2.053402233737056e-14,  -1.368883247673477e-16,   9.124218436217630e-19,  -6.076610980732158e-21,   2.338804563052424e-01,  -1.559265500352138e-03,
   1.039549692117090e-05,  -6.930578452143880e-08,   4.620540138013697e-10,  -3.080455333299178e-12,   2.053689986518833e-14,  -1.369129662385268e-16,   9.126261726644325e-19,
  -6.078237161444076e-21,   2.338808959756994e-01,  -1.559274292964976e-03,   1.039561415575953e-05,  -6.930708715318407e-08,   4.620670404435224e-10,  -3.080576916184149e-12,
   2.053798046097849e-14,  -1.369222199236362e-16,   9.127029053588945e-19,  -6.078847836775591e-21,   2.338809688575312e-01,  -1.559275750471740e-03,   1.039563358917722e-05,
  -6.930730308469846e-08,   4.620691998180064e-10,  -3.080597070552404e-12,   2.053815958812506e-14,  -1.369237538843449e-16,   9.127156251707488e-19,  -6.078949066445273e-21,
   3.405974326608870e-01,  -2.270552453288800e-03,   1.513570899546400e-05,  -1.008916105939427e-07,   6.724939450683764e-10,  -4.482317369525692e-12,   2.987422222401327e-14,
  -1.990958488979038e-16,   1.326622894975975e-18,  -8.831702557383442e-21,   3.405995877389152e-01,  -2.270595548695008e-03,   1.513628356213348e-05,  -1.008979942911441e-07,
   6.725577777839750e-10,  -4.482913082847453e-12,   2.987951609092803e-14,  -1.991411744275007e-16,   1.326998568076969e-18,  -8.834687161726324e-21,   3.406031257075441e-01,
  -2.270666298752093e-03,   1.513722684575302e-05,  -1.009084747766054e-07,   6.726625776924838e-10,  -4.483891140661955e-12,   2.988820791301124e-14,  -1.992155946776127e-16,
   1.327615394859305e-18,  -8.839587381352316e-21,   3.406068798462672e-01,  -2.270741372712957e-03,   1.513822779619160e-05,  -1.009195962154108e-07,   6.727737896072701e-10,
  -4.484929068784484e-12,   2.989743207980160e-14,  -1.992945753446009e-16,   1.328270029716233e-18,  -8.844787582740560e-21,   3.406098344315066e-01,  -2.270800458256781e-03,
   1.513901558826768e-05,  -1.009283494498806e-07,   6.728613220149113e-10,  -4.485746020115279e-12,   2.990469261328526e-14,  -1.993567444274703e-16,   1.328785327766254e-18,
  -8.848880666645676e-21,   3.406115396038090e-01,  -2.270834558458043e-03,   1.513947025404192e-05,  -1.009334013546622e-07,   6.729118419046240e-10,  -4.486217537366536e-12,
   2.990888323638136e-14,  -1.993926277835728e-16,   1.329082755214455e-18,  -8.851243064656518e-21,   3.406121799173848e-01,  -2.270847363569862e-03,   1.513964098850284e-05,
  -1.009352984408867e-07,   6.729308132352821e-10,  -4.486394604091289e-12,   2.991045693778430e-14,  -1.994061031652391e-16,   1.329194449524399e-18,  -8.852130206213167e-21,
   3.406122860587585e-01,  -2.270849486208199e-03,   1.513966929033877e-05,  -1.009356129124961e-07,   6.729339580370555e-10,  -4.486423955820961e-12,   2.991071780557798e-14,
  -1.994083369461376e-16,   1.329212964842532e-18,  -8.852277264607551e-21,   4.812619386833176e-01,  -3.208275726022326e-03,   2.138665754906781e-05,  -1.425591840785952e-07,
   9.502295307658519e-10,  -6.333484793148147e-12,   4.221206402050691e-14,  -2.813202654211638e-16,   1.874469137858140e-18,  -1.247747991005595e-20,   4.812649837944384e-01,
  -3.208336619548658e-03,   2.138746940800067e-05,  -1.425682042004905e-07,   9.503197259380590e-10,  -6.334326529441099e-12,   4.221954405055002e-14,  -2.813843011573055e-16,
   1.874999551648728e-18,  -1.248168061199700e-20,   4.812699829209086e-01,  -3.208436588915308e-03,   2.138880226156389e-05,  -1.425830130570798e-07,   9.504678074616156e-10,
  -6.335708514227382e-12,   4.223182525920308e-14,  -2.814894417442990e-16,   1.875870448248012e-18,  -1.248857735293980e-20,   4.812752874943042e-01,  -3.208542667929640e-03,
   2.139021659796391e-05,  -1.425987275764982e-07,   9.506249491039722e-10,  -6.337175095065231e-12,   4.224485864876834e-14,  -2.816010251857381e-16,   1.876794722350750e-18,
  -1.249589615304447e-20,   4.812794623038710e-01,  -3.208626155415551e-03,   2.139132974299674e-05,  -1.426110958388628e-07,   9.507486317713725e-10,  -6.338329438146912e-12,
   4.225511749955573e-14,  -2.816888572566297e-16,   1.877522265200358e-18,  -1.250165668242229e-20,   4.812818717011516e-01,  -3.208674338776289e-03,   2.139197218275152e-05,
  -1.426182341468776e-07,   9.508200160149425e-10,  -6.338995686734974e-12,   4.226103868617271e-14,  -2.817395530020528e-16,   1.877942198217758e-18,  -1.250498143449802e-20,
   4.812827764600350e-01,  -3.208692432315308e-03,   2.139221342942418e-05,  -1.426209147171547e-07,   9.508468223697318e-10,  -6.339245880029846e-12,   4.226326226464926e-14,
  -2.817585909191009e-16,   1.878099897411273e-18,  -1.250622995685418e-20,   4.812829264370999e-01,  -3.208695431589356e-03,   2.139225341973259e-05,  -1.426213590634570e-07,
   9.508512659521869e-10,  -6.339287353694382e-12,   4.226363086062490e-14,  -2.817617467875801e-16,   1.878126038846333e-18,  -1.250643691967201e-20,   6.796568878474852e-01,
  -4.530852161857947e-03,   3.020307226184354e-05,  -2.013276420890663e-07,   1.341951211213267e-09,  -8.944393695248497e-12,   5.961348246003437e-14,  -3.972892148984454e-16,
   2.647093039361491e-18,  -1.761681303906948e-20,   6.796611882722251e-01,  -4.530938158071756e-03,   3.020421880069811e-05,  -2.013403806561696e-07,   1.342078588261070e-09,
  -8.945582421009210e-12,   5.962404560748310e-14,  -3.973796250703317e-16,   2.647841019101972e-18,  -1.762270100414850e-20,   6.796682482336838e-01,  -4.531079338711909e-03,
   3.020610110849295e-05,  -2.013612942996335e-07,   1.342287714612087e-09,  -8.947534102180074e-12,   5.964138887936099e-14,  -3.975280698107350e-16,   2.649069134128318e-18,
  -1.763236760976749e-20,   6.796757395592085e-01,  -4.531229147634901e-03,   3.020809848952838e-05,  -2.013834869553723e-07,   1.342509636006004e-09,  -8.949605252412628e-12,
   5.965979436153199e-14,  -3.976856107984131e-16,   2.650372510746711e-18,  -1.764262537915758e-20,   6.796816353881726e-01,  -4.531347051919990e-03,   3.020967051636595e-05,
  -2.014009538966974e-07,   1.342684305364392e-09,  -8.951235450903523e-12,   5.967428169457637e-14,  -3.978096178485253e-16,   2.651398457131261e-18,  -1.765069883956640e-20,
   6.796850380330227e-01,  -4.531415098342026e-03,   3.021057779484829e-05,  -2.014110348930042e-07,   1.342785116902919e-09,  -8.952176347450514e-12,   5.968264346839352e-14,
  -3.978811933465747e-16,   2.651990623837818e-18,  -1.765535840747237e-20,   6.796863157688201e-01,  -4.531440650743795e-03,   3.021091849281009e-05,  -2.014148204986411e-07,
   1.342822973854675e-09,  -8.952529678037483e-12,   5.968578355839717e-14,  -3.979080722842189e-16,   2.652213002116967e-18,  -1.765710816224144e-20,   6.796865275722831e-01,
  -4.531444886435631e-03,   3.021097496868360e-05,  -2.014154480217772e-07,   1.342829249250486e-09,  -8.952588248408810e-12,   5.968630408174426e-14,  -3.979125279386727e-16,
   2.652249865227351e-18,  -1.765739821128281e-20,   1.732599914589732e-03,  -1.125019237176760e-05,   7.304721135118512e-08,  -4.742740486667694e-10,   3.079194360543842e-12,
  -1.999064603345244e-14,   1.297771640493804e-16,  -8.424604258698149e-19,   5.468494084833805e-21,  -3.548631294429102e-23,   1.732610315034887e-03,  -1.125039495039603e-05,
   7.304984207422350e-08,  -4.743025181085721e-10,   3.079471643447020e-12,  -1.999316659874923e-14,   1.297989844789936e-16,  -8.426425369732049e-19,   5.469970060857789e-21,
  -3.549794627785881e-23,   1.732627389320193e-03,  -1.125072752480023e-05,   7.305416100318923e-08,  -4.743492579000599e-10,   3.079926881904642e-12,  -1.999730490830774e-14,
   1.298348104999188e-16,  -8.429415449337523e-19,   5.472393521639051e-21,  -3.551704762566951e-23,   1.732645506825440e-03,  -1.125108042390919e-05,   7.305874395351960e-08,
  -4.743988559588569e-10,   3.080409970894599e-12,  -2.000169650972469e-14,   1.298728304597861e-16,  -8.432588740898487e-19,   5.474965554389279e-21,  -3.553732018129208e-23,
   1.732659765664393e-03,  -1.125135816602395e-05,   7.306235092814948e-08,  -4.744378924460713e-10,   3.080790197633509e-12,  -2.000515311061397e-14,   1.299027565554103e-16,
  -8.435086562371522e-19,   5.476990158502575e-21,  -3.555327808211911e-23,   1.732667994826256e-03,  -1.125151845990164e-05,   7.306443265134260e-08,  -4.744604221901400e-10,
   3.081009647214957e-12,  -2.000714813792118e-14,   1.299200291690834e-16,  -8.436528274101722e-19,   5.478158757806455e-21,  -3.556248901847670e-23,   1.732671084978605e-03,
  -1.125157865250295e-05,   7.306521437187996e-08,  -4.744688825266186e-10,   3.081092055228050e-12,  -2.000789731987637e-14,   1.299265155245877e-16,  -8.437069683348281e-19,
   5.478597608836944e-21,  -3.556594806608526e-23,   1.732671597216657e-03,  -1.125158863032282e-05,   7.306534395392251e-08,  -4.744702849587001e-10,   3.081105715668369e-12,
  -2.000802150905813e-14,   1.299275907475969e-16,  -8.437159431376915e-19,   5.478670356279122e-21,  -3.556652146589533e-23,   1.566914997809169e-02,  -1.017435993567798e-04,
   6.606185885758247e-07,  -4.289202104115451e-09,   2.784737424843984e-11,  -1.807898222877709e-13,   1.173668437418818e-15,  -7.618976524503361e-18,   4.945551543991828e-20,
  -3.209275448671123e-22,   1.566924403681442e-02,  -1.017454314213461e-04,   6.606423801006249e-07,  -4.289459573799788e-09,   2.784988191759689e-11,  -1.808126175754548e-13,
   1.173865775215273e-15,  -7.620623482369148e-18,   4.946886356613757e-20,  -3.210327458634269e-22,   1.566939845188450e-02,  -1.017484391314207e-04,   6.606814392885742e-07,
  -4.289882275426456e-09,   2.785399896710182e-11,  -1.808500432898411e-13,   1.174189775619426e-15,  -7.623327620108994e-18,   4.949078035750027e-20,  -3.212054805524018e-22,
   1.566956230154452e-02,  -1.017516306524515e-04,   6.607228862120443e-07,  -4.290330826424773e-09,   2.785836788904495e-11,  -1.808897597049509e-13,   1.174533617386346e-15,
  -7.626197449173475e-18,   4.951404077150196e-20,  -3.213888064810628e-22,   1.566969125450370e-02,  -1.017541424746066e-04,   6.607555066837201e-07,  -4.290683861517988e-09,
   2.786180655350939e-11,  -1.809210202367514e-13,   1.174804260533056e-15,  -7.628456403460119e-18,   4.953235046321184e-20,  -3.215331146812276e-22,   1.566976567674644e-02,
  -1.017555921276908e-04,   6.607743332071715e-07,  -4.290887614234101e-09,   2.786379119425194e-11,  -1.809390627058027e-13,   1.174960469166776e-15,  -7.629760243987055e-18,
   4.954291879696794e-20,  -3.216164096806149e-22,   1.566979362322168e-02,  -1.017561364927745e-04,   6.607814028694963e-07,  -4.290964127155485e-09,   2.786453646931336e-11,
  -1.809458380978939e-13,   1.175019129931708e-15,  -7.630249878148680e-18,   4.954688758595791e-20,  -3.216476900329704e-22,   1.566979825575963e-02,  -1.017562267293922e-04,
   6.607825747733166e-07,  -4.290976810359736e-09,   2.786466001052150e-11,  -1.809469612301237e-13,   1.175028853944544e-15,  -7.630331043553553e-18,   4.954754548402663e-20,
  -3.216528753178992e-22,   4.396020235874158e-02,  -2.854442788973436e-04,   1.853382402768019e-06,  -1.203346657072161e-08,   7.812652305278253e-11,  -5.072104851000770e-13,
   3.292756876328637e-15,  -2.137523183885694e-17,   1.387486094295432e-19,  -9.003660054271417e-22,   4.396046624290189e-02,  -2.854494188014980e-04,   1.853449150501366e-06,
  -1.203418890852707e-08,   7.813355838285609e-11,  -5.072744378573306e-13,   3.293310512126233e-15,  -2.137985239737421e-17,   1.387860568366075e-19,  -9.006611049560253e-22,
   4.396089945834355e-02,  -2.854578570092948e-04,   1.853558732055464e-06,  -1.203537480878617e-08,   7.814510887073171e-11,  -5.073794366473964e-13,   3.294219502825320e-15,
  -2.138743888556507e-17,   1.388475431379698e-19,  -9.011456430993424e-22,   4.396135914276936e-02,  -2.854668109034460e-04,   1.853675012462839e-06,  -1.203663323012066e-08,
   7.815736599318537e-11,  -5.074908620563176e-13,   3.295184158926668e-15,  -2.139549022237060e-17,   1.389127988857599e-19,  -9.016598903458705e-22,   4.396172092360547e-02,
  -2.854738578849595e-04,   1.853766530033207e-06,  -1.203762367913268e-08,   7.816701325444650e-11,  -5.075785642703087e-13,   3.295943454587676e-15,  -2.140182774315064e-17,
   1.389641656610089e-19,  -9.020646887482330e-22,   4.396192971711729e-02,  -2.854779249238878e-04,   1.853819348327861e-06,  -1.203819531260552e-08,   7.817258121490027e-11,
  -5.076291828743405e-13,   3.296381701551991e-15,  -2.140548568184248e-17,   1.389938145038665e-19,  -9.022983391321776e-22,   4.396200812167073e-02,  -2.854794521540993e-04,
   1.853839182446930e-06,  -1.203840997156960e-08,   7.817467210318051e-11,  -5.076481914085038e-13,   3.296546275695602e-15,  -2.140685935576333e-17,   1.390049487089431e-19,
  -9.023860834699006e-22,   4.396202111837482e-02,  -2.854797053152458e-04,   1.853842470253171e-06,  -1.203844555462454e-08,   7.817501870120531e-11,  -5.076513423844285e-13,
   3.296573556640302e-15,  -2.140708706618138e-17,   1.390067944034160e-19,  -9.024006286819079e-22,   8.751483172609092e-02,  -5.682550737828532e-04,   3.689665661195147e-06,
  -2.395591342849532e-08,   1.555322575919994e-10,  -1.009741488346584e-12,   6.555134927681966e-15,  -4.255325025936677e-17,   2.762167903533339e-19,  -1.792411054972119e-21,
   8.751535705983930e-02,  -5.682653061708547e-04,   3.689798540853051e-06,  -2.395735143987737e-08,   1.555462633444946e-10,  -1.009868803815198e-12,   6.556237090029346e-15,
  -4.256244867062861e-17,   2.762913361470861e-19,  -1.792998388613159e-21,   8.751621949391475e-02,  -5.682821047362791e-04,   3.690016692971348e-06,  -2.395971229937784e-08,
   1.555692577559404e-10,  -1.010077832647178e-12,   6.558046682764221e-15,  -4.257755152794732e-17,   2.764137356570021e-19,  -1.793962759120257e-21,   8.751713462175795e-02,
  -5.682999299167353e-04,   3.690248180993159e-06,  -2.396221753195560e-08,   1.555936589171591e-10,  -1.010299655422863e-12,   6.559967092579169e-15,  -4.259357978536826e-17,
   2.765436388944814e-19,  -1.794986258057467e-21,   8.751785484567176e-02,  -5.683139588649254e-04,   3.690430371800739e-06,  -2.396418929217889e-08,   1.556128644344583e-10,
  -1.010474250685393e-12,   6.561478676684875e-15,  -4.260619625053424e-17,   2.766458936250453e-19,  -1.795791921622332e-21,   8.751827050638467e-02,  -5.683220554206354e-04,
   3.690535521093049e-06,  -2.396532728528137e-08,   1.556239489855982e-10,  -1.010575020871821e-12,   6.562351126214909e-15,  -4.261347831814108e-17,   2.767049149272438e-19,
  -1.796256951753875e-21,   8.751842659213797e-02,  -5.683250957909658e-04,   3.690575006343327e-06,  -2.396575462278364e-08,   1.556281114717116e-10,  -1.010612862561994e-12,
   6.562678755715191e-15,  -4.261621296928249e-17,   2.767270795437199e-19,  -1.796431587652904e-21,   8.751845246563970e-02,  -5.683255997776162e-04,   3.690581551622792e-06,
  -2.396582546060721e-08,   1.556288014700625e-10,  -1.010619135442041e-12,   6.562733065839956e-15,  -4.261666628541694e-17,   2.767307537269075e-19,  -1.796460536710166e-21,
   1.479134544064948e-01,  -9.604380113568573e-04,   6.236099444949130e-06,  -4.048915867995251e-08,   2.628733099537494e-10,  -1.706617589048580e-12,   1.107918054835135e-14,
  -7.192148468944599e-17,   4.668477709167321e-19,  -3.029413291466804e-21,   1.479143423008997e-01,  -9.604553056580202e-04,   6.236324031900023e-06,  -4.049158913917964e-08,
   2.628969818174169e-10,  -1.706832771610243e-12,   1.108104336771412e-14,  -7.193703121962711e-17,   4.669737558722932e-19,  -3.030405617245417e-21,   1.479157999464299e-01,
  -9.604836978035793e-04,   6.236692742354669e-06,  -4.049557935290702e-08,   2.629358458893738e-10,  -1.707186062219498e-12,   1.108410185031027e-14,  -7.196255704234828e-17,
   4.671806151960112e-19,  -3.032034960939691e-21,   1.479173466524893e-01,  -9.605138250856026e-04,   6.237083992526491e-06,  -4.049981357922157e-08,   2.629770875835780e-10,
  -1.707560976544517e-12,   1.108734763032551e-14,  -7.198964691164303e-17,   4.674001559945945e-19,  -3.033764201420712e-21,   1.479185639410898e-01,  -9.605375361543155e-04,
   6.237391922864366e-06,  -4.050314615564479e-08,   2.630095478449672e-10,  -1.707856069168393e-12,   1.108990243367830e-14,  -7.201097040070029e-17,   4.675729698379438e-19,
  -3.035125398460615e-21,   1.479192664712861e-01,  -9.605512205721475e-04,   6.237569641254982e-06,  -4.050506953808158e-08,   2.630282824315826e-10,  -1.708026386153299e-12,
   1.109137700393936e-14,  -7.202327805426057e-17,   4.676727177484064e-19,  -3.035911082374275e-21,   1.479195302800885e-01,  -9.605563592631484e-04,   6.237636377368732e-06,
  -4.050579180383580e-08,   2.630353176696938e-10,  -1.708090344381414e-12,   1.109193074682017e-14,  -7.202789997484175e-17,   4.677101766630541e-19,  -3.036206135376062e-21,
   1.479195740102648e-01,  -9.605572110776917e-04,   6.237647439892381e-06,  -4.050591153059460e-08,   2.630364838724298e-10,  -1.708100946505449e-12,   1.109202253905770e-14,
  -7.202866613880532e-17,   4.677163861505701e-19,  -3.036255045735835e-21,   2.277956755503307e-01,  -1.479132689444073e-03,   9.603970724362810e-06,  -6.235575587583969e-08,
   4.048408134489659e-10,  -2.628294406332103e-12,   1.706260810262648e-14,  -1.107634002159468e-16,   7.189719160078579e-19,  -4.665400596297835e-21,   2.277970429614739e-01,
  -1.479159323714987e-03,   9.604316601865182e-06,  -6.235949893018921e-08,   4.048772695505707e-10,  -2.628625800376804e-12,   1.706547694918089e-14,  -1.107873423858540e-16,
   7.191659207353204e-19,  -4.666928037365910e-21,   2.277992878238471e-01,  -1.479203049338215e-03,   9.604884438289534e-06,  -6.236564410089632e-08,   4.049371225716779e-10,
  -2.629169889093165e-12,   1.707018718428400e-14,  -1.108266529929371e-16,   7.194844640891979e-19,  -4.669436005409174e-21,   2.278016698448274e-01,  -1.479249447176656e-03,
   9.605486987243041e-06,  -6.237216506576000e-08,   4.050006372748151e-10,  -2.629747279626791e-12,   1.707518586786337e-14,  -1.108683722792606e-16,   7.198225355101946e-19,
  -4.672097732582428e-21,   2.278035445429757e-01,  -1.479285963658114e-03,   9.605961218607526e-06,  -6.237729743520515e-08,   4.050506280403538e-10,  -2.630201739955079e-12,
   1.707912040850634e-14,  -1.109012111482068e-16,   7.200886518476907e-19,  -4.674192945101295e-21,   2.278046264820143e-01,  -1.479307038490130e-03,   9.606234915689334e-06,
  -6.238025956059890e-08,   4.050794804366906e-10,  -2.630464038320078e-12,   1.708139132949908e-14,  -1.109201653351410e-16,   7.202422537763825e-19,  -4.675402301224158e-21,
   2.278050327635430e-01,  -1.479314952385405e-03,   9.606337693345159e-06,  -6.238137189358617e-08,   4.050903151288274e-10,  -2.630562537824753e-12,   1.708224412462154e-14,
  -1.109272832429998e-16,   7.202999367948119e-19,  -4.675856458223553e-21,   2.278051001106622e-01,  -1.479316264231377e-03,   9.606354730301378e-06,  -6.238155628004295e-08,
   4.050921111515653e-10,  -2.630578865731209e-12,   1.708238548982016e-14,  -1.109284631603844e-16,   7.203094987900479e-19,  -4.675931742921697e-21,   3.317499759921115e-01,
  -2.154133229380678e-03,   1.398673196728986e-05,  -9.081173496388843e-08,   5.895894632001741e-10,  -3.827713578521960e-12,   2.484910851896832e-14,  -1.613100662718908e-16,
   1.047069842442546e-18,  -6.794280921623926e-21,   3.317519674197926e-01,  -2.154172018171178e-03,   1.398723568560129e-05,  -9.081718615684390e-08,   5.896425559991207e-10,
  -3.828196203591318e-12,   2.485328654320245e-14,  -1.613449335065399e-16,   1.047352338562880e-18,  -6.796503680577449e-21,   3.317552367225860e-01,  -2.154235697933406e-03,
   1.398806265353901e-05,  -9.082613566923133e-08,   5.897297228731183e-10,  -3.828988586128109e-12,   2.486014626040590e-14,  -1.614021819521292e-16,   1.047816178841159e-18,
  -6.800153308278002e-21,   3.317587057761627e-01,  -2.154303269373255e-03,   1.398894017502951e-05,  -9.083563246901191e-08,   5.898222224332201e-10,  -3.829829467698586e-12,
   2.486742605732036e-14,  -1.614629381737804e-16,   1.048308454122855e-18,  -6.804026672928687e-21,   3.317614359907035e-01,  -2.154356450109972e-03,   1.398963082134361e-05,
  -9.084310698942993e-08,   5.898950264233423e-10,  -3.830491320103829e-12,   2.487315609719610e-14,  -1.615107617469387e-16,   1.048695953308816e-18,  -6.807075630220142e-21,
   3.317630116714059e-01,  -2.154387142417884e-03,   1.399002941978076e-05,  -9.084742087738604e-08,   5.899370455753743e-10,  -3.830873317811007e-12,   2.487646333655011e-14,
  -1.615383649163753e-16,   1.048919617113083e-18,  -6.808835483105889e-21,   3.317636033590535e-01,  -2.154398667810370e-03,   1.399017909990418e-05,  -9.084904082226987e-08,
   5.899528246659825e-10,  -3.831016767370464e-12,   2.487770529854629e-14,  -1.615487307953444e-16,   1.049003610850569e-18,  -6.809496370719615e-21,   3.317637014399548e-01,
  -2.154400578315776e-03,   1.399020391165620e-05,  -9.084930935327699e-08,   5.899554403014945e-10,  -3.831040546484836e-12,   2.487791117472830e-14,  -1.615504491205697e-16,
   1.049017534318425e-18,  -6.809605924693851e-21,   4.687605404327034e-01,  -3.043776126128321e-03,   1.976316054356203e-05,  -1.283163859455513e-07,   8.330860442060640e-10,
  -5.408534128731824e-12,   3.511162385144669e-14,  -2.279298742732479e-16,   1.479493773105111e-18,  -9.599897557701938e-21,   4.687633543069569e-01,  -3.043830934434914e-03,
   1.976387229423199e-05,  -1.283240884453642e-07,   8.331610639748131e-10,  -5.409216074184755e-12,   3.511752733426313e-14,  -2.279791394120432e-16,   1.479892843687555e-18,
  -9.603034431380340e-21,   4.687679738103636e-01,  -3.043920913521320e-03,   1.976504079450359e-05,  -1.283367340475379e-07,   8.332842301829712e-10,  -5.410335704515097e-12,
   3.512722000698204e-14,  -2.280600277347406e-16,   1.480548091022639e-18,  -9.608184951327242e-21,   4.687728755603170e-01,  -3.044016391522681e-03,   1.976628072661364e-05,
  -1.283501529631995e-07,   8.334149314407376e-10,  -5.411523863594961e-12,   3.513750624537151e-14,  -2.281458722972606e-16,   1.481243506403411e-18,  -9.613651184209072e-21,
   4.687767333355582e-01,  -3.044091535554893e-03,   1.976725660532523e-05,  -1.283607144114150e-07,   8.335178029902188e-10,  -5.412459055860782e-12,   3.514560270120659e-14,
  -2.282134438604613e-16,   1.481790908626596e-18,  -9.617953958226474e-21,   4.687789597620573e-01,  -3.044134903584687e-03,   1.976781982230235e-05,  -1.283668099067385e-07,
   8.335771757700413e-10,  -5.412998815627965e-12,   3.515027577806712e-14,  -2.282524453176460e-16,   1.482106867911134e-18,  -9.620437501815726e-21,   4.687797958128230e-01,
  -3.044151188888685e-03,   1.976803131933493e-05,  -1.283690988782103e-07,   8.335994715191696e-10,  -5.413201508731182e-12,   3.515203065068984e-14,  -2.282670916196415e-16,
   1.482225521846070e-18,  -9.621370159215551e-21,   4.687799344004933e-01,  -3.044153888420294e-03,   1.976806637817778e-05,  -1.283694783107580e-07,   8.336031673945930e-10,
  -5.413235108433400e-12,   3.515232155047200e-14,  -2.282695194995804e-16,   1.482245190860522e-18,  -9.621524763804333e-21,   6.620019254542473e-01,  -4.298539408390219e-03,
   2.791030644506652e-05,  -1.812134069051850e-07,   1.176516615445654e-09,  -7.638142788524748e-12,   4.958599621478539e-14,  -3.218909704062098e-16,   2.089375450743388e-18,
  -1.355636879710079e-20,   6.620058993172607e-01,  -4.298616810819311e-03,   2.791131160713230e-05,  -1.812242846757470e-07,   1.176622561269872e-09,  -7.639105856947650e-12,
   4.959433324519966e-14,  -3.219605392540180e-16,   2.089938785328839e-18,  -1.356078855779271e-20,   6.620124231602169e-01,  -4.298743882795952e-03,   2.791296180880604e-05,
  -1.812421432881964e-07,   1.176796501361201e-09,  -7.640687040023323e-12,   4.960802145360040e-14,  -3.220747641544840e-16,   2.090863741517444e-18,  -1.356804541638533e-20,
   6.620193456027592e-01,  -4.298878720554850e-03,   2.791471288930901e-05,  -1.812610940041034e-07,   1.176981082741330e-09,  -7.642365001900547e-12,   4.962254790770477e-14,
  -3.221959878635984e-16,   2.091845397148797e-18,  -1.357574700654809e-20,   6.620247937034788e-01,  -4.298984841889124e-03,   2.791609106330037e-05,  -1.812760092930674e-07,
   1.177126361929030e-09,  -7.643685714743729e-12,   4.963398190159535e-14,  -3.222914076795482e-16,   2.092618114168943e-18,  -1.358180928541278e-20,   6.620279379498522e-01,
  -4.299046087912940e-03,   2.791688646028989e-05,  -1.812846175892278e-07,   1.177210210468897e-09,  -7.644447983293807e-12,   4.964058132374824e-14,  -3.223464827834636e-16,
   2.093064123949538e-18,  -1.358530838052549e-20,   6.620291186533648e-01,  -4.299069086654668e-03,   2.791718514465106e-05,  -1.812878501639875e-07,   1.177241697389579e-09,
  -7.644734233931277e-12,   4.964305959349617e-14,  -3.223671652541505e-16,   2.093231616337015e-18,  -1.358662240780555e-20,   6.620293143722803e-01,  -4.299072899038537e-03,
   2.791723465611679e-05,  -1.812883860134256e-07,   1.177246916848034e-09,  -7.644781684663527e-12,   4.964347040856933e-14,  -3.223705937341528e-16,   2.093259381192746e-18,
  -1.358684023097529e-20,   1.688732999344054e-03,  -1.068777161916174e-05,   6.763885868870358e-08,  -4.280438918249573e-10,   2.708714666364094e-12,  -1.714040671899914e-14,
   1.084580566080558e-16,  -6.862538368263964e-19,   4.341964059381329e-21,  -2.746792560657091e-23,   1.688742629504234e-03,  -1.068795444677274e-05,   6.764117282167915e-08,
  -4.280683012193204e-10,   2.708946387861749e-12,  -1.714245981012779e-14,   1.084753807567473e-16,  -6.863947877732105e-19,   4.343078577427430e-21,  -2.747652637953365e-23,
   1.688758439209448e-03,  -1.068825459543058e-05,   6.764497198866850e-08,  -4.281083753045418e-10,   2.709326822955048e-12,  -1.714583059619971e-14,   1.085038243630060e-16,
  -6.866262134385406e-19,   4.344908538608269e-21,  -2.749064855730525e-23,   1.688775214853105e-03,  -1.068857308661099e-05,   6.764900339310611e-08,  -4.281508998795843e-10,
   2.709730530356059e-12,  -1.714940767492427e-14,   1.085340095941680e-16,  -6.868718172825188e-19,   4.346850675868644e-21,  -2.750563683631528e-23,   1.688788417607806e-03,
  -1.068882374827022e-05,   6.765217627051313e-08,  -4.281843690241880e-10,   2.710048276533175e-12,  -1.715222315458983e-14,   1.085577686916392e-16,  -6.870651401725180e-19,
   4.348379442827909e-21,  -2.751743526608475e-23,   1.688796037269915e-03,  -1.068896841299241e-05,   6.765400745660337e-08,  -4.282036855560628e-10,   2.710231664620926e-12,
  -1.715384814319018e-14,   1.085714817989721e-16,  -6.871767231704169e-19,   4.349261842289596e-21,  -2.752424540301168e-23,   1.688798898546612e-03,  -1.068902273659685e-05,
   6.765469509586786e-08,  -4.282109392635146e-10,   2.710300530666680e-12,  -1.715445836529437e-14,   1.085766314467400e-16,  -6.872186260731975e-19,   4.349593214396096e-21,
  -2.752680287228491e-23,   1.688799372845120e-03,  -1.068903174154155e-05,   6.765480908248202e-08,  -4.282121416776697e-10,   2.710311946304756e-12,  -1.715455951954165e-14,
   1.085774850872089e-16,  -6.872255722045500e-19,   4.349648145244199e-21,  -2.752722681971849e-23,   1.527242984191212e-02,  -9.665722306808048e-05,   6.117069568199560e-07,
  -3.871109470644053e-09,   2.449685931364859e-11,  -1.550130536541897e-13,   9.808643866422764e-16,  -6.206288046819045e-18,   3.926750674901671e-20,  -2.484120782644323e-22,
   1.527251693439256e-02,  -9.665887650995870e-05,   6.117278851926044e-07,  -3.871330222392834e-09,   2.449895493818544e-11,  -1.550316212369657e-13,   9.810210613895816e-16,
  -6.207562766899815e-18,   3.927758609556848e-20,  -2.484898594710846e-22,   1.527265991295328e-02,  -9.666159097063471e-05,   6.117622437983308e-07,  -3.871692641232966e-09,
   2.450239548696601e-11,  -1.550621056847982e-13,   9.812782973958200e-16,  -6.209655714471688e-18,   3.929413568187151e-20,  -2.486175735650943e-22,   1.527281162719166e-02,
  -9.666447131596456e-05,   6.117987026947110e-07,  -3.872077221618990e-09,   2.450604650400074e-11,  -1.550944557857643e-13,   9.815512841695808e-16,  -6.211876885430054e-18,
   3.931169975252293e-20,  -2.487531202406647e-22,   1.527293102921966e-02,  -9.666673823003927e-05,   6.118273973122815e-07,  -3.872379907219933e-09,   2.450892011172370e-11,
  -1.551199181975409e-13,   9.817661547905017e-16,  -6.213625242378880e-18,   3.932552543357279e-20,  -2.488598194659166e-22,   1.527299993931678e-02,  -9.666804653740412e-05,
   6.118439580481120e-07,  -3.872554600542033e-09,   2.451057862239420e-11,  -1.551346141406082e-13,   9.818901722911578e-16,  -6.214634367109272e-18,   3.933350557290220e-20,
  -2.489214070070676e-22,   1.527302581590451e-02,  -9.666853782491838e-05,   6.118501768656678e-07,  -3.872620201047367e-09,   2.451120142768715e-11,  -1.551401328188927e-13,
   9.819367442627607e-16,  -6.215013324981107e-18,   3.933650239653487e-20,  -2.489445355050386e-22,   1.527303010532781e-02,  -9.666861926312452e-05,   6.118512077287872e-07,
  -3.872631075345333e-09,   2.451130466753108e-11,  -1.551410476296542e-13,   9.819444643479912e-16,  -6.215076143806991e-18,   3.933699917360252e-20,  -2.489483694776852e-22,
   4.284719383622277e-02,  -2.711743196949293e-04,   1.716159564727570e-06,  -1.086049695867210e-08,   6.872656743072983e-11,  -4.348930997596005e-13,   2.751840197832607e-15,
  -1.741189986578804e-17,   1.101659735999203e-19,  -6.969254490744311e-22,   4.284743817641157e-02,  -2.711789584685486e-04,   1.716218279814089e-06,  -1.086111628336793e-08,
   6.873244675912366e-11,  -4.349451915879320e-13,   2.752279752754755e-15,  -1.741547612022441e-17,   1.101942512111844e-19,  -6.971436558328566e-22,   4.284783930643275e-02,
  -2.711865739576325e-04,   1.716314673764147e-06,  -1.086213305872379e-08,   6.874209930698230e-11,  -4.350307164859334e-13,   2.753001434803248e-15,  -1.742134792934049e-17,
   1.102406810812494e-19,  -6.975019438348371e-22,   4.284826494462173e-02,  -2.711946548403696e-04,   1.716416960133532e-06,  -1.086321200886533e-08,   6.875234232892656e-11,
  -4.351214755214975e-13,   2.753767306022937e-15,  -1.742757947185450e-17,   1.102899570851611e-19,  -6.978822051991228e-22,   4.284859993007534e-02,  -2.712010147259788e-04,
   1.716497463619473e-06,  -1.086406120108585e-08,   6.876040430910491e-11,  -4.351929109688867e-13,   2.754370130921951e-15,  -1.743248452453944e-17,   1.103287450345582e-19,
  -6.981815381306939e-22,   4.284879325912115e-02,  -2.712046852158641e-04,   1.716543925188818e-06,  -1.086455130768373e-08,   6.876505730333380e-11,  -4.352341408129765e-13,
   2.754718065120339e-15,  -1.743531564546429e-17,   1.103511333154632e-19,  -6.983543151709039e-22,   4.284886585655206e-02,  -2.712060635355926e-04,   1.716561372241055e-06,
  -1.086473535158479e-08,   6.876680459955889e-11,  -4.352496236060300e-13,   2.754848723950863e-15,  -1.743637881984244e-17,   1.103595409040415e-19,  -6.984191996107012e-22,
   4.284887789063920e-02,  -2.712062920125697e-04,   1.716564264353990e-06,  -1.086476585970677e-08,   6.876709424158927e-11,  -4.352521901310155e-13,   2.754870382842958e-15,
  -1.743655505939583e-17,   1.103609346120776e-19,  -6.984299553961131e-22,   8.529908320057103e-02,  -5.398468087765685e-04,   3.416485991047029e-06,  -2.162079591992893e-08,
   1.368190695406930e-10,  -8.657739132552845e-13,   5.478292128060506e-15,  -3.466315742731422e-17,   2.193154881352288e-19,  -1.387417894719008e-21,   8.529956962668737e-02,
  -5.398560435268862e-04,   3.416602879519795e-06,  -2.162202885548425e-08,   1.368307739552419e-10,  -8.658776163121165e-13,   5.479167182284039e-15,  -3.467027692452712e-17,
   2.193717816583547e-19,  -1.387852261752455e-21,   8.530036818593914e-02,  -5.398712042452162e-04,   3.416794778097731e-06,  -2.162405302551408e-08,   1.368499899972826e-10,
  -8.660478770543506e-13,   5.480603887668841e-15,  -3.468196634119114e-17,   2.194642117007701e-19,  -1.388565477280900e-21,   8.530121553541632e-02,  -5.398872914571713e-04,
   3.416998407151371e-06,  -2.162620097149604e-08,   1.368703815398247e-10,  -8.662285577814410e-13,   5.482128563674588e-15,  -3.469437190385435e-17,   2.195623076630657e-19,
  -1.389322433140269e-21,   8.530188241577698e-02,  -5.398999525526399e-04,   3.417158671405108e-06,  -2.162789152136276e-08,   1.368864311209610e-10,  -8.663707696118191e-13,
   5.483328651409722e-15,  -3.470413673135334e-17,   2.196395245770013e-19,  -1.389918291028945e-21,   8.530226729023167e-02,  -5.399072596687910e-04,   3.417251165893409e-06,
  -2.162886721287723e-08,   1.368956941812451e-10,  -8.664528489128867e-13,   5.484021309533577e-15,  -3.470977283946455e-17,   2.196840939317050e-19,  -1.390262224239600e-21,
   8.530241181531592e-02,  -5.399100035919904e-04,   3.417285899032900e-06,  -2.162923360270616e-08,   1.368991726532721e-10,  -8.664836716545281e-13,   5.484281421648957e-15,
  -3.471188937417627e-17,   2.197008312948757e-19,  -1.390391384403553e-21,   8.530243577246478e-02,  -5.399104584380361e-04,   3.417291656576388e-06,  -2.162929433748482e-08,
   1.368997492651173e-10,  -8.664887810257034e-13,   5.484324539593729e-15,  -3.471224022643484e-17,   2.197036058118673e-19,  -1.390412795067725e-21,   1.441685004136502e-01,
  -9.124236973497849e-04,   5.774384008972477e-06,  -3.654245284422343e-08,   2.312451592943856e-10,  -1.463290365949624e-12,   9.259151739173130e-15,  -5.858603506115353e-17,
   3.706765350777439e-19,  -2.344940450751008e-21,   1.441693225482046e-01,  -9.124393054906353e-04,   5.774581568374066e-06,  -3.654453669393549e-08,   2.312649415454487e-10,
  -1.463465639968226e-12,   9.260630713874249e-15,  -5.859806805715074e-17,   3.707716777156506e-19,  -2.345674514183003e-21,   1.441706722355107e-01,  -9.124649294240329e-04,
   5.774905906329088e-06,  -3.654795785095834e-08,   2.312974195960582e-10,  -1.463753406649397e-12,   9.263058964438483e-15,  -5.861782488794433e-17,   3.709278952837267e-19,
  -2.346879820199541e-21,   1.441721043857621e-01,  -9.124921192734003e-04,   5.775250070582681e-06,  -3.655158820827641e-08,   2.313318844223347e-10,  -1.464058784697692e-12,
   9.265635898720967e-15,  -5.863879211023211e-17,   3.710936888994277e-19,  -2.348159044892106e-21,   1.441732315155969e-01,  -9.125135184617480e-04,   5.775520941690113e-06,
  -3.655444549618391e-08,   2.313590106696259e-10,  -1.464299144429955e-12,   9.267664229465522e-15,  -5.865529610207928e-17,   3.712241944749575e-19,  -2.349166020003871e-21,
   1.441738820123068e-01,  -9.125258686059503e-04,   5.775677271525952e-06,  -3.655609456411181e-08,   2.313746666585142e-10,  -1.464437870995608e-12,   9.268834927010539e-15,
  -5.866482195198809e-17,   3.712995218684902e-19,  -2.349747252641874e-21,   1.441741262818099e-01,  -9.125305062559467e-04,   5.775735975845469e-06,  -3.655671381897571e-08,
   2.313805458083559e-10,  -1.464489966140617e-12,   9.269274556034028e-15,  -5.866839920626786e-17,   3.713278099580172e-19,  -2.349965527836625e-21,   1.441741667730567e-01,
  -9.125312750153503e-04,   5.775745706974803e-06,  -3.655681647004329e-08,   2.313815203705810e-10,  -1.464498601758933e-12,   9.269347431916495e-15,  -5.866899219807376e-17,
   3.713324992142243e-19,  -2.350001710948088e-21,   2.220282196543953e-01,  -1.405187738734851e-03,   8.892900997333217e-06,  -5.627758992761052e-08,   3.561315465563475e-10,
  -2.253555759309622e-12,   1.425965413043547e-14,  -9.022603222707926e-17,   5.708638804962216e-19,  -3.611332400934237e-21,   2.220294857913871e-01,  -1.405211776216792e-03,
   8.893205250773327e-06,  -5.628079918233472e-08,   3.561620124203738e-10,  -2.253825691882207e-12,   1.426193183922746e-14,  -9.024456367289579e-17,   5.710104014061966e-19,
  -3.612462717333599e-21,   2.220315643915585e-01,  -1.405251238625684e-03,   8.893704750861807e-06,  -5.628606797128538e-08,   3.562120305841561e-10,  -2.254268869947822e-12,
   1.426567148915935e-14,  -9.027499022928390e-17,   5.712509784786921e-19,  -3.614318655375857e-21,   2.220337699896585e-01,  -1.405293112639983e-03,   8.894234784650511e-06,
  -5.629165894135677e-08,   3.562651085027180e-10,  -2.254739170581976e-12,   1.426964012082092e-14,  -9.030728085118136e-17,   5.715063027462229e-19,  -3.616288412190862e-21,
   2.220355058378488e-01,  -1.405326068685702e-03,   8.894651942556436e-06,  -5.629605933773003e-08,   3.563068845654484e-10,  -2.255109339083205e-12,   1.427276387047760e-14,
  -9.033269786346849e-17,   5.717072829545695e-19,  -3.617838956465993e-21,   2.220365076421679e-01,  -1.405345088655541e-03,   8.894892699968957e-06,  -5.629859900218250e-08,
   3.563309957359637e-10,  -2.255322986370898e-12,   1.427456681413153e-14,  -9.034736817123314e-17,   5.718232880645909e-19,  -3.618733940298084e-21,   2.220368838319925e-01,
  -1.405352230917333e-03,   8.894983108175393e-06,  -5.629955269216594e-08,   3.563400499825734e-10,  -2.255403216039805e-12,   1.427524386890133e-14,  -9.035287733012755e-17,
   5.718668520671312e-19,  -3.619070041031924e-21,   2.220369461909641e-01,  -1.405353414853361e-03,   8.894998094703760e-06,  -5.629971078102508e-08,   3.563415508673883e-10,
  -2.255416515413445e-12,   1.427535610208243e-14,  -9.035379056855478e-17,   5.718740735787026e-19,  -3.619125755879675e-21,   3.233505480820356e-01,  -2.046443583546832e-03,
   1.295116636976018e-05,  -8.195980482117795e-08,   5.186517773818596e-10,  -3.281963391106870e-12,   2.076703091257059e-14,  -1.314005614975938e-16,   8.313760615788923e-19,
  -5.259321733689729e-21,   3.233523920192201e-01,  -2.046478590506632e-03,   1.295160946891557e-05,  -8.196447861567934e-08,   5.186961463078926e-10,  -3.282356507045087e-12,
   2.077034804738524e-14,  -1.314275495416573e-16,   8.315894374785436e-19,  -5.260967469843898e-21,   3.233554191862428e-01,  -2.046536061541458e-03,   1.295233691530777e-05,
  -8.197215181053066e-08,   5.187689902031804e-10,  -3.283001928823100e-12,   2.077579427605356e-14,  -1.314718608828087e-16,   8.319397856954491e-19,  -5.263669705530981e-21,
   3.233586313065562e-01,  -2.046597044715103e-03,   1.295310882941995e-05,  -8.198029421349404e-08,   5.188462901688137e-10,  -3.283686850516611e-12,   2.078157398158286e-14,
  -1.315188869308587e-16,   8.323116099061378e-19,  -5.266537657086002e-21,   3.233611593071166e-01,  -2.046645040215235e-03,   1.295371635686717e-05,  -8.198670272579365e-08,
   5.189071306897035e-10,  -3.284225944913106e-12,   2.078612324555957e-14,  -1.315559026810821e-16,   8.326042937598002e-19,  -5.268795235593757e-21,   3.233626182837104e-01,
  -2.046672739926928e-03,   1.295406698365418e-05,  -8.199040136325718e-08,   5.189422449651385e-10,  -3.284537089851625e-12,   2.078874895743923e-14,  -1.315772676010464e-16,
   8.327732298835034e-19,  -5.270098322933829e-21,   3.233631661473386e-01,  -2.046683141551859e-03,   1.295419864954396e-05,  -8.199179026858989e-08,   5.189554311067694e-10,
  -3.284653932221410e-12,   2.078973498423194e-14,  -1.315852907958652e-16,   8.328366713400136e-19,  -5.270587681976300e-21,   3.233632569637568e-01,  -2.046684865775762e-03,
   1.295422047515769e-05,  -8.199202050112176e-08,   5.189576169186424e-10,  -3.284673300746218e-12,   2.078989843470663e-14,  -1.315866207792485e-16,   8.328471878943725e-19,
  -5.270668802182923e-21,   4.568922038799190e-01,  -2.891611362803060e-03,   1.829991314562447e-05,  -1.158086667114901e-07,   7.328515599265683e-10,  -4.637392736436243e-12,
   2.934367772734035e-14,  -1.856680899201758e-16,   1.174726929020315e-18,  -7.431303114424410e-21,   4.568948093510681e-01,  -2.891660827407679e-03,   1.830053924182502e-05,
  -1.158152707524515e-07,   7.329142529263549e-10,  -4.637948206546810e-12,   2.934836480868838e-14,  -1.857062233951262e-16,   1.175028406388219e-18,  -7.433627642326705e-21,
   4.568990867182188e-01,  -2.891742033602986e-03,   1.830156711880630e-05,  -1.158261129264254e-07,   7.330171808698384e-10,  -4.638860183068637e-12,   2.935606028024220e-14,
  -1.857688342804033e-16,   1.175523410869933e-18,  -7.437444422035451e-21,   4.569036254231563e-01,  -2.891828202427414e-03,   1.830265782838429e-05,  -1.158376180883825e-07,
   7.331264052113052e-10,  -4.639827972697361e-12,   2.936422695148332e-14,  -1.858352809784287e-16,   1.176048758426920e-18,  -7.441495259353223e-21,   4.569071974713692e-01,
  -2.891896019754341e-03,   1.830351626068280e-05,  -1.158466732742093e-07,   7.332123724659248e-10,  -4.640589709360268e-12,   2.937065501996362e-14,  -1.858875833582598e-16,
   1.176462289037530e-18,  -7.444683969493970e-21,   4.569092589957282e-01,  -2.891935159265305e-03,   1.830401169403329e-05,  -1.158518994246748e-07,   7.332619887054416e-10,
  -4.641029355011342e-12,   2.937436512686185e-14,  -1.859177714837138e-16,   1.176700977438835e-18,  -7.446524508994848e-21,   4.569100331234419e-01,  -2.891949856693117e-03,
   1.830419773707204e-05,  -1.158538619387959e-07,   7.332806206365670e-10,  -4.641194452473506e-12,   2.937575837370731e-14,  -1.859291080675599e-16,   1.176790613317840e-18,
  -7.447215701388918e-21,   4.569101614464453e-01,  -2.891952293010185e-03,   1.830422857652110e-05,  -1.158541872558527e-07,   7.332837091743222e-10,  -4.641221820065392e-12,
   2.937598932773380e-14,  -1.859309873025002e-16,   1.176805472064920e-18,  -7.447330279139138e-21,   6.452409974916908e-01,  -4.083646392407372e-03,   2.584385137633856e-05,
  -1.635495177872768e-07,   1.034961567194726e-09,  -6.549106936072599e-12,   4.144028470767198e-14,  -2.622076149850349e-16,   1.658990107144180e-18,  -1.049455998352040e-20,
   6.452446770397088e-01,  -4.083716248252039e-03,   2.584473557382184e-05,  -1.635588442715561e-07,   1.035050104690845e-09,  -6.549891392300473e-12,   4.144690396536137e-14,
  -2.622614673958253e-16,   1.659415809770496e-18,  -1.049784045432825e-20,   6.452507177044947e-01,  -4.083830930809580e-03,   2.584618718180029e-05,  -1.635741560126113e-07,
   1.035195463541525e-09,  -6.551179320574585e-12,   4.145777177514163e-14,  -2.623498870008102e-16,   1.660114782934806e-18,  -1.050322683715543e-20,   6.452571274407001e-01,
  -4.083952621785597e-03,   2.584772752442338e-05,  -1.635904040511601e-07,   1.035349714410627e-09,  -6.552546070258661e-12,   4.146930502912185e-14,  -2.624437235604626e-16,
   1.660856601632564e-18,  -1.050894350903535e-20,   6.452621720265617e-01,  -4.084048396060800e-03,   2.584893983600945e-05,  -1.636031921378402e-07,   1.035471120715830e-09,
  -6.553621824027934e-12,   4.147838296833580e-14,  -2.625175853922063e-16,   1.661440528465952e-18,  -1.051344350346695e-20,   6.452650833916987e-01,  -4.084103670405341e-03,
   2.584963950631771e-05,  -1.636105727114069e-07,   1.035541190701703e-09,  -6.554242708499636e-12,   4.148362250873555e-14,  -2.625602172968048e-16,   1.661777568806726e-18,
  -1.051604091647314e-20,   6.452661766450613e-01,  -4.084124426686367e-03,   2.584990224355601e-05,  -1.636133442504091e-07,   1.035567503440502e-09,  -6.554475865475580e-12,
   4.148559009977529e-14,  -2.625762269076876e-16,   1.661904139264284e-18,  -1.051701634237079e-20,   6.452663578678135e-01,  -4.084127867348390e-03,   2.584994579622927e-05,
  -1.636138036758477e-07,   1.035571865193810e-09,  -6.554514515039767e-12,   4.148591626098192e-14,  -2.625788807776876e-16,   1.661925120575539e-18,  -1.051717803694646e-20
  };
  static constexpr double xi[35460] = {  -4.163931362630452e-04,   1.705926461164262e-05,  -4.611385532728351e-07,   1.024417065914939e-08,  -2.012756661973609e-10,
   3.610350596962766e-12,  -5.997212302305935e-14,   9.258056413134603e-16,  -1.320550853403403e-17,   1.705663460200062e-19,  -1.892311388367779e-21,   1.502692556422075e-23,
   1.307122189081872e-26,  -4.088794427779859e-27,  -3.961533994354047e-04,   1.623041209797189e-05,  -4.387445909649190e-07,   9.746965956151527e-09,  -1.915123380884515e-10,
   3.435320821352478e-12,  -5.706606644810712e-14,   8.809568711864942e-16,  -1.256571962135389e-17,   1.622944216801256e-19,  -1.800239442385659e-21,   1.428641866152411e-23,
   1.276179306667815e-26,  -3.898035314355619e-27,  -3.576495399695225e-04,   1.465346886356295e-05,  -3.961341306175151e-07,   8.800789665759262e-09,  -1.729305039524190e-10,
   3.102159284273883e-12,  -5.153394743527562e-14,   7.955752109576030e-16,  -1.134773986685636e-17,   1.465503152959686e-19,  -1.625119208086294e-21,   1.288176332444241e-23,
   1.204121752565874e-26,  -3.531901919750265e-27,  -3.046426794008495e-04,   1.248227116198303e-05,  -3.374575235524737e-07,   7.497642669791641e-09,  -1.473337000887758e-10,
   2.643145729744337e-12,  -4.391096711939405e-14,   6.779134743142544e-16,  -9.669339586465401e-18,   1.248610996625620e-19,  -1.384109114506988e-21,   1.095595536780618e-23,
   1.079284897701060e-26,  -3.021574722245595e-27,  -2.423156469572647e-04,   9.928961561973510e-06,  -2.684431488496735e-07,   5.964628826903484e-09,  -1.172161269380475e-10,
   2.102965384043346e-12,  -3.493863412933041e-14,   5.394115058149743e-16,  -7.693736333079830e-18,   9.933948278719003e-20,  -1.100814250195781e-21,   8.701609823160607e-24,
   8.999522572189469e-27,  -2.413543240904786e-27,  -1.767683218239039e-04,   7.243400892879277e-06,  -1.958436702542980e-07,   4.351722154874843e-09,  -8.552370724479550e-11,
   1.534447409505900e-12,  -2.549432072054379e-14,   3.936118836783038e-16,  -5.614109465612017e-18,   7.248173203531894e-20,  -8.029691405268773e-22,   6.340217398409905e-24,
   6.809250854784295e-27,  -1.766645156704779e-27,  -1.144201330933085e-04,   4.688683468180647e-06,  -1.267739933515434e-07,   2.817055150158649e-09,  -5.536494304819726e-11,
   9.933768737328792e-13,  -1.650506094190069e-14,   2.548289726122063e-16,  -3.634616099242332e-18,   4.692257268722177e-20,  -5.197224689499191e-22,   4.100706802044615e-24,
   4.512089807387911e-27,  -1.146087227516918e-27,  -6.137904271667961e-05,   2.515208017826957e-06,  -6.800791338354147e-08,   1.511233567862679e-09,  -2.970149881804647e-11,
   5.329231506264665e-13,  -8.854695998646193e-15,   1.367127046310740e-16,  -1.949921412480450e-18,   2.517258584605904e-20,  -2.787892855027843e-22,   2.198870935360879e-24,
   2.449264589981047e-27,  -6.155071169049745e-28,  -2.284095564724565e-05,   9.359872316887787e-07,  -2.530798994210634e-08,   5.623830442545887e-10,  -1.105303438336688e-11,
   1.983216788406164e-13,  -3.295196674662209e-15,   5.087656658163386e-17,  -7.256471641904948e-19,   9.367675883108352e-21,  -1.037446428193336e-22,   8.181489433380249e-25,
   9.151775729357758e-28,  -2.291397276031421e-28,  -2.580066099395450e-06,   1.057272121537046e-07,  -2.858741305416786e-09,   6.352575077675920e-11,  -1.248531518728244e-12,
   2.240209156727699e-14,  -3.722202949218128e-16,   5.746940480551400e-18,  -8.196799707512558e-20,   1.058156693059162e-21,  -1.171875616726139e-23,   9.241429836686836e-26,
   1.034434601658695e-28,  -2.588477696415200e-29,  -3.432287083161428e-03,   1.230113969636139e-04,  -2.603267102867995e-06,   3.678081054914276e-08,  -2.433132855356789e-10,
  -4.368654159532634e-12,   1.948549153232444e-13,  -4.053506226018087e-15,   5.213569406422475e-17,  -1.870587821180822e-19,  -1.110823784233526e-20,   3.683103187863432e-22,
  -6.773942378882545e-24,   7.261843847878901e-26,  -3.265416966157872e-03,   1.170313600081758e-04,  -2.476686521586864e-06,   3.499047320522213e-08,  -2.313913858595033e-10,
  -4.158693021456517e-12,   1.854204218733577e-13,  -3.856538395532908e-15,   4.958482708585377e-17,  -1.773563379866925e-19,  -1.058121696506564e-20,   3.505628419271712e-22,
  -6.444089086761967e-24,   6.900270695810599e-26,  -2.947979660886585e-03,   1.056553213038638e-04,  -2.235898372611509e-06,   3.158557922222056e-08,  -2.087499439788188e-10,
  -3.758294397503403e-12,   1.674573267977153e-13,  -3.481802735871570e-15,   4.473884941834122e-17,  -1.591462436016243e-19,  -9.573361996037699e-21,   3.167368829838536e-22,
  -5.816810392328638e-24,   6.215894781490074e-26,  -2.511003651655950e-03,   8.999496387658713e-05,  -1.904447860816147e-06,   2.690017338866338e-08,  -1.776552576623160e-10,
  -3.205198012937323e-12,   1.426990963293969e-13,  -2.965867986726462e-15,   3.808070689170709e-17,  -1.345577095106160e-19,  -8.175696111933526e-21,   2.700473733697201e-22,
  -4.953715152539696e-24,   5.280498417983690e-26,  -1.997230267568684e-03,   7.158183941603758e-05,  -1.514761334663308e-06,   2.139345230822845e-08,  -1.411881254292641e-10,
  -2.552468498414700e-12,   1.135508443364387e-13,  -2.359154995785980e-15,   3.026853263005568e-17,  -1.062546866703362e-19,  -6.519385491468676e-21,   2.149937796408644e-22,
  -3.939454299936176e-24,   4.189214614006879e-26,  -1.456944904755823e-03,   5.221808561566633e-05,  -1.104980533063604e-06,   1.560456028603109e-08,  -1.029253453503338e-10,
  -1.863792773729327e-12,   8.286229533019320e-14,  -1.721038328880162e-15,   2.206829282160112e-17,  -7.705747230747018e-20,  -4.765478740425293e-21,   1.569518659922626e-22,
  -2.873353917011602e-24,   3.049573702621839e-26,  -9.430524728402544e-04,   3.379992403164855e-05,  -7.152277087412625e-07,   1.009985093116001e-08,  -6.659210725392317e-11,
  -1.207171939071730e-12,   5.364753849319799e-14,  -1.114027229636839e-15,   1.427921197739051e-17,  -4.968380043471325e-20,  -3.088751178744644e-21,   1.016421824375102e-22,
  -1.859689689140928e-24,   1.971195687974490e-26,  -5.058838422682739e-04,   1.813141617204971e-05,  -3.836698984483807e-07,   5.417698890087870e-09,  -3.571403425481685e-11,
  -6.477794651454221e-13,   2.878168014658439e-14,  -5.976090577619766e-16,   7.658405932474806e-18,  -2.659853679144127e-20,  -1.658048708567361e-21,   5.453798752349101e-23,
  -9.975485730466561e-25,   1.056659120138045e-26,  -1.882539182408406e-04,   6.747226794015234e-06,  -1.427744190807256e-07,   2.016057157170756e-09,  -1.328916619841708e-11,
  -2.410849980181052e-13,   1.071093151994429e-14,  -2.223886488775905e-16,   2.849728340309209e-18,  -9.891155098734946e-21,  -6.171555815246079e-22,   2.029694398645370e-23,
  -3.712101166084399e-25,   3.931155362740999e-27,  -2.126475759192142e-05,   7.621523245148972e-07,  -1.612748802325258e-08,   2.277290431574121e-10,  -1.501096757686472e-12,
  -2.723293814434708e-14,   1.209891686715423e-15,  -2.512056377837661e-17,   3.218958726348296e-19,  -1.117159467778497e-21,  -6.971521958353740e-23,   2.292731230430116e-24,
  -4.193098168881782e-26,   4.440373389046168e-28,  -7.980141734156451e-03,   2.104839086672364e-04,  -1.903655171419951e-06,  -3.111549972375837e-08,   1.294925204539738e-09,
  -1.611733766723786e-11,  -1.165102935166144e-13,   8.072362987299235e-15,  -1.265830116762805e-16,  -2.402405643167493e-19,   5.038619374736376e-20,  -9.671746194229979e-22,
   2.012491267642499e-24,   3.093790237481033e-25,  -7.592041263575169e-03,   2.002431175619950e-04,  -1.810829895944276e-06,  -2.960680772373234e-08,   1.231887255897551e-09,
  -1.532834651044982e-11,  -1.109481806309531e-13,   7.679452643459554e-15,  -1.203585331238786e-16,  -2.301297555379834e-19,   4.793912433549409e-20,  -9.194118911040073e-22,
   1.895112560203242e-24,   2.944496342840561e-25,  -6.853807426366950e-03,   1.807651064441638e-04,  -1.634359574866421e-06,  -2.673516167674226e-08,   1.112003168771588e-09,
  -1.382964427882461e-11,  -1.003256640680694e-13,   6.932199329757784e-15,  -1.085462749899441e-16,  -2.102562422324610e-19,   4.328295203802924e-20,  -8.288536559170406e-22,
   1.679791399982122e-24,   2.660030161120540e-25,  -5.837671377506323e-03,   1.539581178195639e-04,  -1.391650962548661e-06,  -2.277891401694812e-08,   9.470380798839796e-10,
  -1.177082858748041e-11,  -8.562221288015313e-14,   5.903902307147386e-15,  -9.234123705574027e-17,  -1.816602551676369e-19,   3.687128918613459e-20,  -7.047772329016052e-22,
   1.398810728567178e-24,   2.267550340100756e-25,  -4.643075690262238e-03,   1.224473906549074e-04,  -1.106560188219679e-06,  -1.812330168383104e-08,   7.531622426807099e-10,
  -9.355572165706398e-12,  -6.823255421638276e-14,   4.695334673190356e-15,  -7.335835453330968e-17,  -1.464732891785863e-19,   2.933022053152783e-20,  -5.596341045696394e-22,
   1.087935275226800e-24,   1.804979080089960e-25,  -3.386951137241270e-03,   8.931764247997260e-05,  -8.070127407860726e-07,  -1.322366168811408e-08,   5.493579381992990e-10,
  -6.820707898233585e-12,  -4.985045297036734e-14,   3.424824594184556e-15,  -5.346131593166748e-17,  -1.080135226075919e-19,   2.139768845780790e-20,  -4.076910845789643e-22,
   7.791512583966142e-25,   1.317511751571477e-25,  -2.192269028527474e-03,   5.781119653580856e-05,  -5.222767152408735e-07,  -8.560716517260097e-09,   3.555627990666795e-10,
  -4.413194052829903e-12,  -3.229972367267754e-14,   2.216677018044324e-15,  -3.458210010212640e-17,  -7.041248754367732e-20,   1.385107243038783e-20,  -2.636543275169352e-22,
   4.981422993671298e-25,   8.531450163474378e-26,  -1.175993135439330e-03,   3.101113436992767e-05,  -2.801421141579832e-07,  -4.592601595035314e-09,   1.907282050992247e-10,
  -2.366906400735785e-12,  -1.733556165376734e-14,   1.189056880437993e-15,  -1.854479050505795e-17,  -3.790850309230090e-20,   7.430370595250304e-21,  -1.413676044214253e-22,
   2.655160102496851e-25,   4.577493001757645e-26,  -4.376194399712839e-04,   1.154004884353250e-05,  -1.042458236462637e-07,  -1.709085217970178e-09,   7.097451732200655e-11,
  -8.807325628334559e-13,  -6.452219221575667e-15,   4.424770108703621e-16,  -6.900250903944778e-18,  -1.412458051112507e-20,   2.765081231673064e-21,  -5.259851604670173e-23,
   9.858553302955829e-26,   1.703539227364647e-26,  -4.943252521553593e-05,   1.303537555490379e-06,  -1.177532823301482e-08,  -1.930554166543713e-10,   8.017112112684634e-12,
  -9.948455596470175e-14,  -7.288495660981659e-16,   4.998115740303898e-17,  -7.794231807132996e-19,  -1.595800139262006e-21,   3.123381062572120e-22,  -5.941264050407031e-24,
   1.113205566285366e-26,   1.924303211381147e-27,  -1.189614430789983e-02,   1.661500923385369e-04,   2.381062736608130e-06,  -8.613984125195665e-08,   7.867857097010391e-11,
   3.071442647928432e-11,  -3.637347064131819e-13,  -7.531313100283598e-15,   2.194728648623160e-16,   4.607234417214509e-19,  -8.902561055751410e-20,   8.004773264898284e-22,
   2.560016176113510e-23,  -5.933874686304643e-25,  -1.131744111654182e-02,   1.580608317929964e-04,   2.265260699375743e-06,  -8.194085404968573e-08,   7.469010916061363e-11,
   2.921576700334970e-11,  -3.458605122356241e-13,  -7.164485548765395e-15,   2.086789388776896e-16,   4.396095320924645e-19,  -8.464524823497266e-20,   7.601771914673651e-22,
   2.434559354368771e-23,  -5.636874808052065e-25,  -1.021671101374536e-02,   1.426772605213648e-04,   2.044986551647106e-06,  -7.395761323705791e-08,   6.716936140462412e-11,
   2.636705787247270e-11,  -3.119358918531720e-13,  -6.466940204105186e-15,   1.881960070157390e-16,   3.989187206750376e-19,  -7.633370363029561e-20,   6.840791220768883e-22,
   2.196304900620668e-23,  -5.075366203294656e-25,  -8.701741803082454e-03,   1.215096330101977e-04,   1.741794410154331e-06,  -6.297681156455550e-08,   5.694532943005783e-11,
   2.244985021164654e-11,  -2.653862321679364e-13,  -5.507245185860705e-15,   1.600972980111466e-16,   3.418884662887972e-19,  -6.493337244343382e-20,   5.804171290781490e-22,
   1.869111986068024e-23,  -4.309129834761151e-25,  -6.920859325747169e-03,   9.663324129208265e-05,   1.385357076003312e-06,  -5.007719982499451e-08,   4.508735433148017e-11,
   1.784958484873183e-11,  -2.108453727417913e-13,  -4.379557421205288e-15,   1.271836699635515e-16,   2.735535388942172e-19,  -5.158148071355116e-20,   4.599157719369489e-22,
   1.485408884530547e-23,  -3.416714924677107e-25,  -5.048394544826253e-03,   7.048378374076069e-05,   1.010564062049457e-06,  -3.652222301672667e-08,   3.276919691263764e-11,
   1.301695063327797e-11,  -1.536668112304762e-13,  -3.194306493527688e-15,   9.268649145125976e-17,   2.005016466860494e-19,  -3.758905834829876e-20,   3.344781296332506e-22,
   1.082834579167831e-23,  -2.486139341851242e-25,  -3.267620891424528e-03,   4.561916831475415e-05,   6.541059070993652e-07,  -2.363661565026699e-08,   2.115903909302269e-11,
   8.423906305608446e-12,  -9.940519962104388e-14,  -2.067396994596636e-15,   5.995494672773683e-17,   1.301861564615959e-19,  -2.431411318174295e-20,   2.160645180868692e-22,
   7.005787815723141e-24,  -1.606540996644318e-25,  -1.752827760980609e-03,   2.447059658793354e-05,   3.508800293895221e-07,  -1.267847584357539e-08,   1.133611791209490e-11,
   4.518383053074137e-12,  -5.330753565373322e-14,  -1.108958957195961e-15,   3.215096568613566e-17,   6.994760828654302e-20,  -1.303831481617390e-20,   1.157837690461620e-22,
   3.757250959865974e-24,  -8.610602165985047e-26,  -6.522737376554474e-04,   9.106082761358212e-06,   1.305720867716821e-07,  -4.717899757279796e-09,   4.216646637998407e-12,
   1.681358982168988e-12,  -1.983511283788190e-14,  -4.126677736075178e-16,   1.196289895808015e-17,   2.604395673886670e-20,  -4.851340912026619e-21,   4.307090202180864e-23,
   1.398067034061589e-24,  -3.203293981424823e-26,  -7.367936902120976e-05,   1.028601195011120e-06,   1.474913380671022e-08,  -5.329215565310317e-10,   4.762701967013231e-13,
   1.899215959197926e-13,  -2.240493075057292e-15,  -4.661392532625080e-17,   1.351278244705494e-18,   2.942128144520536e-21,  -5.479864426884371e-22,   4.864917433305325e-24,
   1.579205999424190e-25,  -3.618200158341930e-27,  -1.342424363300590e-02,   3.755636709500496e-06,   4.902359484217436e-06,  -1.129073575333963e-09,  -1.792543381913787e-09,
   1.840885976317832e-13,   6.699268362220593e-13,   2.926562270714143e-17,  -2.550740159012719e-16,  -5.489732048674341e-20,   9.840819941590998e-20,   3.827012652279261e-23,
  -3.837786096516836e-23,  -2.211334998232289e-26,  -1.277113871915913e-02,   3.572860704895630e-06,   4.663588077901166e-06,  -1.074100279517962e-09,  -1.705055537638892e-09,
   1.751524642862180e-13,   6.371297906754979e-13,   2.778380427002118e-17,  -2.425360870563485e-16,  -5.216500567650352e-20,   9.354673902163126e-20,   3.635786316155542e-23,
  -3.647065267853001e-23,  -2.100183172400177e-26,  -1.152891841086919e-02,   3.225240978276520e-06,   4.209547613650109e-06,  -9.695571168045960e-10,  -1.538764997068227e-09,
   1.581475636037677e-13,   5.748322509763293e-13,   2.498901743757744e-17,  -2.187409302277087e-16,  -4.699318540331144e-20,   8.433022542532194e-20,   3.274128126746964e-23,
  -3.285946567904014e-23,  -1.890227424976406e-26,  -9.819263338130265e-03,   2.746862755206710e-06,   3.584866012181938e-06,  -8.257089651171420e-10,  -1.310120629231168e-09,
   1.347280949062719e-13,   4.892539311108151e-13,   2.118837856112804e-17,  -1.860931117394733e-16,  -3.992382737491528e-20,   7.170387747259090e-20,   2.780362094945560e-23,
  -2.792108296450533e-23,  -1.604086092654412e-26,  -7.809588191266631e-03,   2.184595783224802e-06,   2.850826996194795e-06,  -6.566599785606278e-10,  -1.041630255145913e-09,
   1.071789191344583e-13,   3.888616211000191e-13,   1.677862318178260e-17,  -1.478439929483129e-16,  -3.167520848233309e-20,   5.693535860088076e-20,   2.204969032211824e-23,
  -2.215604291668758e-23,  -1.271287735917592e-26,  -5.696625810679438e-03,   1.593486869254158e-06,   2.079309344788616e-06,  -4.789623299763513e-10,  -7.595997088184388e-10,
   7.819534392572901e-14,   2.834994704729934e-13,   1.219603885785488e-17,  -1.077481612150108e-16,  -2.305966579327735e-20,   4.147626716172679e-20,   1.604670654916913e-23,
  -1.613186072995312e-23,  -9.246911568941034e-27,  -3.687173884109067e-03,   1.031374473942474e-06,   1.345760357613160e-06,  -3.099975647491991e-10,  -4.915667628088085e-10,
   5.061868812232725e-14,   1.834317953364860e-13,   7.875600551024089e-18,  -6.969994632439872e-17,  -1.490606476362659e-20,   2.682239655214110e-20,   1.037042733551229e-23,
  -1.042877716189958e-23,  -5.973853812199115e-27,  -1.977880004984736e-03,   5.532463692921895e-07,   7.218717271594404e-07,  -1.662856773237949e-10,  -2.636626849566953e-10,
   2.715469585329281e-14,   9.837892579256951e-14,   4.219589163264299e-18,  -3.737736235165390e-17,  -7.990585554224127e-21,   1.438168432037373e-20,   5.558546771430330e-24,
  -5.590736411811477e-24,  -3.201404479776260e-27,  -7.360209095849249e-04,   2.058767711207169e-07,   2.686243423922582e-07,  -6.187876809511023e-11,  -9.811262700686932e-11,
   1.010519746516567e-14,   3.660705905586264e-14,   1.569565159705934e-18,  -1.390764430040638e-17,  -2.972813174084684e-21,   5.350968389412831e-21,   2.067914243734985e-24,
  -2.080007995279111e-24,  -1.190924987974396e-27,  -8.313924721986538e-05,   2.325535941189870e-08,   3.034314039489221e-08,  -6.989676170321449e-12,  -1.108252249902822e-11,
   1.141464136449885e-15,   4.135008624086335e-15,   1.772827801553118e-19,  -1.570949858749854e-18,  -3.357897943767155e-22,   6.044182888022862e-22,   2.335767349248815e-25,
  -2.349448811457855e-25,  -1.345169826447753e-28,  -1.197982214510824e-02,  -1.561823950189387e-04,   2.467145690730453e-06,   8.118787583967387e-08,   7.058777942764615e-12,
  -2.878648752405567e-11,  -3.137406247498425e-13,   7.032863940452112e-15,   1.910470335099998e-16,  -5.081811399013131e-19,  -7.635234598843770e-20,  -6.476021483301559e-22,
   2.145957284441729e-23,   4.796115620214131e-25,  -1.139704629567466e-02,  -1.485784071224601e-04,   2.347143829033022e-06,   7.723032608468245e-08,   6.576131063488876e-12,
  -2.738191506106537e-11,  -2.983217252631809e-13,   6.690232026563258e-15,   1.816526380620170e-16,  -4.845114016062164e-19,  -7.259652119655877e-20,  -6.149993333449106e-22,
   2.040808479269453e-23,   4.556237222746136e-25,  -1.028857056995858e-02,  -1.341177001449873e-04,   2.118886316395381e-06,   6.970609388359061e-08,   5.714800083970742e-12,
  -2.471204352730537e-11,  -2.690577551186954e-13,   6.038729838937099e-15,   1.638248920899869e-16,  -4.390602890127792e-19,  -6.546961841009507e-20,  -5.534356124943767e-22,
   1.841114333646765e-23,   4.102653153160596e-25,  -8.762942426522688e-03,  -1.142199390991144e-04,   1.804716046233486e-06,   5.935661229393676e-08,   4.639156225788930e-12,
  -2.104073931469164e-11,  -2.289043397532065e-13,   5.142446828336024e-15,   1.393674090052235e-16,  -3.756736314139553e-19,  -5.569341445252828e-20,  -4.695718695517376e-22,
   1.566863138399383e-23,   3.483555839763931e-25,  -6.969532156537277e-03,  -9.083592543885422e-05,   1.435385837351971e-06,   4.719859099487790e-08,   3.513608545410972e-12,
  -1.672924008818911e-11,  -1.818592118751481e-13,   4.089353217164491e-15,   1.107174543893316e-16,  -3.001130122658202e-19,  -4.424271352108546e-20,  -3.720841192520075e-22,
   1.245228957650869e-23,   2.762337952317953e-25,  -5.083897237270608e-03,  -6.625523732919186e-05,   1.047048277243239e-06,   3.442283643918209e-08,   2.459561854158823e-12,
  -1.219994278847577e-11,  -1.325402393397853e-13,   2.982580285327239e-15,   8.068768196489178e-17,  -2.196928018445891e-19,  -3.224178887103605e-20,  -2.706021816776002e-22,
   9.077606649628297e-24,   2.010118773090003e-25,  -3.290599693693945e-03,  -4.288232313449605e-05,   6.777167786119117e-07,   2.227794056373799e-08,   1.547758080670664e-12,
  -7.895185838244160e-12,  -8.573821096567955e-14,   1.930339095751530e-15,   5.219390868325926e-17,  -1.425298517004821e-19,  -2.085559359496974e-20,  -1.748024362690183e-22,
   5.873138509914749e-24,   1.298992789492247e-25,  -1.765153945431994e-03,  -2.300252266031070e-05,   3.635443806611818e-07,   1.194969851618402e-08,   8.180757976350084e-13,
  -4.234791434815569e-12,  -4.597827889891827e-14,   1.035433488041833e-15,   2.798922532291739e-17,  -7.654759596941298e-20,  -1.118378713737381e-20,  -9.367246284981318e-23,
   3.149818566839913e-24,   6.962385353748737e-26,  -6.568606149054933e-04,  -8.559777811019737e-06,   1.352846896316466e-07,   4.446708527901370e-09,   3.028506371933194e-13,
  -1.575830422862276e-12,  -1.710796519174569e-14,   3.853064220293979e-16,   1.041439406884903e-17,  -2.849720930783914e-20,  -4.161312925942126e-21,  -3.484562843718728e-23,
   1.172044366751130e-24,   2.590148572088472e-26,  -7.419749190595268e-05,  -9.668918985662837e-07,   1.528145630693250e-08,   5.022885178231806e-10,   3.418105639187981e-14,
  -1.780013891886675e-13,  -1.932445353154525e-15,   4.352323855125170e-17,   1.176366018578404e-18,  -3.219192227153556e-21,  -4.700440699320195e-22,  -3.935861616901138e-24,
   1.323899311651252e-25,   2.925640758084859e-27,  -8.289257994504385e-03,  -2.036248722336006e-04,  -1.538710537890548e-06,   3.450739998541236e-08,   1.178439903434033e-09,
   1.201621288084466e-11,  -1.503763576760055e-13,  -6.970767337044966e-15,  -8.816628743465777e-17,   5.918654463244885e-19,   4.165398610464966e-20,   6.305875771009348e-22,
  -1.631170638403255e-24,  -2.495225103422042e-25,  -7.886111187983038e-03,  -1.937174067406757e-04,  -1.463657104993322e-06,   3.283250769861822e-08,   1.121052857927673e-09,
   1.142739129714605e-11,  -1.431350760140175e-13,  -6.631066407443781e-15,  -8.382215093499433e-17,   5.641024671348407e-19,   3.962458840826580e-20,   5.993368539928932e-22,
  -1.563808305742871e-24,  -2.373941729069849e-25,  -7.119261917326654e-03,  -1.748735407719544e-04,  -1.320982380704730e-06,   2.964522490637876e-08,   1.011923535713768e-09,
   1.030915429107601e-11,  -1.293315748439846e-13,  -5.985175654612910e-15,  -7.558175732000962e-17,   5.108759976725027e-19,   3.576576720296055e-20,   5.401296473682417e-22,
  -1.430789286272049e-24,  -2.143206978576945e-25,  -6.063748630281049e-03,  -1.489396147745165e-04,  -1.124773016382803e-06,   2.525550000467895e-08,   8.617729352766531e-10,
   8.773460979132854e-12,  -1.102750361735143e-13,  -5.096686613410580e-15,  -6.428372967317479e-17,   4.368065800204604e-19,   3.045715185896631e-20,   4.590939831706984e-22,
  -1.238245632897916e-24,  -1.825555502353942e-25,  -4.822873016581941e-03,  -1.184555337115170e-04,  -8.943246192412110e-07,   2.009151879378729e-08,   6.853275127940314e-10,
   6.972483815984531e-12,  -8.779984914465282e-14,  -4.052844556419517e-15,  -5.105766755009598e-17,   3.487100197730701e-19,   2.421983625116477e-20,   3.644082250853567e-22,
  -9.999528109823602e-25,  -1.452050440783186e-25,  -3.518096932008088e-03,  -8.640554411968759e-05,  -6.522121980954447e-07,   1.465847987732466e-08,   4.998645333478365e-10,
   5.082869044341881e-12,  -6.410017014614304e-14,  -2.955882413445050e-15,  -3.720276559134318e-17,   2.551279976787701e-19,   1.766469005807284e-20,   2.653881250904481e-22,
  -7.382870223892742e-25,  -1.059253762098931e-25,  -2.277151520997320e-03,  -5.592620507626575e-05,  -4.220865470099724e-07,   9.489035366130831e-09,   3.235227613986537e-10,
   3.288573654267200e-12,  -4.151290822195279e-14,  -1.913030094875875e-15,  -2.406228165771652e-17,   1.654599874123349e-19,   1.143261356964991e-20,   1.715918704827220e-22,
  -4.816552586169232e-25,  -6.856370111848724e-26,  -1.221525289208772e-03,  -2.999995130542788e-05,  -2.263994167995476e-07,   5.090468517825401e-09,   1.735398172808320e-10,
   1.763692347669753e-12,  -2.227495175460990e-14,  -1.026140673098608e-15,  -1.290273005441924e-17,   8.884634175016421e-20,   6.132436534814920e-21,   9.199542676992107e-23,
  -2.594150516822416e-25,  -3.677983410067453e-26,  -4.545630610524621e-04,  -1.116375691766635e-05,  -8.424695136711981e-08,   1.894341132419588e-09,   6.457808490858955e-11,
   6.562681737772341e-13,  -8.289937845667518e-15,  -3.818473003014699e-16,  -4.800821879528407e-18,   3.307370556660069e-20,   2.282005699033187e-21,   3.422740722911600e-23,
  -9.667040710811003e-26,  -1.368683853341247e-26,  -5.134643657822447e-05,  -1.261032399650954e-06,  -9.516304563717150e-09,   2.139812630980992e-10,   7.294582372602260e-12,
   7.412970099416675e-14,  -9.364276689111500e-16,  -4.313248571089079e-17,  -5.422787732599621e-19,   3.736139457644899e-21,   2.577695540688978e-22,   3.866133554724277e-24,
  -1.092209385295247e-26,  -1.546035920503444e-27,  -3.970762502544939e-03,  -1.318896936150422e-04,  -2.515570062956367e-06,  -2.954806864235281e-08,  -6.371616937447975e-11,
   6.706513734768196e-12,   1.922049239419379e-13,   3.063852437189485e-15,   2.402331166846066e-17,  -2.679026672391797e-19,  -1.406828168356286e-20,  -2.898012250627260e-22,
  -3.444048519816983e-24,  -4.519906246078514e-27,  -3.777698109101145e-03,  -1.254771669625070e-04,  -2.393223061269159e-06,  -2.810884111484282e-08,  -6.053120414970999e-11,
   6.382218176923841e-12,   1.828759028038332e-13,   2.914535653760527e-15,   2.283593374467451e-17,  -2.553457485852067e-19,  -1.339072602834715e-20,  -2.757146064855960e-22,
  -3.274057981736134e-24,  -4.221242067772189e-27,  -3.410437406803900e-03,  -1.132787466179683e-04,  -2.160500679368017e-06,  -2.537207966819165e-08,  -5.450789687937786e-11,
   5.764594203118978e-12,   1.651229441521698e-13,   2.630635414842734e-15,   2.058506636427588e-17,  -2.312684529188359e-19,  -1.209919636075860e-20,  -2.489161874611751e-22,
  -2.951715880943424e-24,  -3.685133609932364e-27,  -2.904887465329835e-03,  -9.648698731352721e-05,  -1.840176988487057e-06,  -2.160682586528650e-08,  -4.628512246765226e-11,
   4.913001101948791e-12,   1.406723973140879e-13,   2.240108117740678e-15,   1.750187701984254e-17,  -1.977554058582520e-19,  -1.031624789819686e-20,  -2.120236698773938e-22,
  -2.509992336579636e-24,  -3.009308253809580e-27,  -2.310503237704693e-03,  -7.674446509780708e-05,  -1.463602782479955e-06,  -1.718249979474345e-08,  -3.670426241077987e-11,
   3.909986473810648e-12,   1.119092193514359e-13,   1.781305263494187e-15,   1.389620590289033e-17,  -1.578856124973631e-19,  -8.213553963177964e-21,  -1.686446040458278e-22,
  -1.993181770871279e-24,  -2.293471442623419e-27,  -1.685461089514740e-03,  -5.598350124111072e-05,  -1.067638888137371e-06,  -1.253234958783379e-08,  -2.671017493864466e-11,
   2.853576777656592e-12,   8.164735852120605e-14,   1.299162324938805e-15,   1.012255889148903e-17,  -1.155231081353873e-19,  -5.996401308938475e-21,  -1.230248256808635e-22,
  -1.452082069247084e-24,  -1.614193747843013e-27,  -1.090961898226059e-03,  -3.623693564921309e-05,  -6.910476128902124e-07,  -8.111099569897984e-09,  -1.726120346753527e-11,
   1.847625406362734e-12,   5.285369071819539e-14,   8.408076372962789e-16,   6.545941554407300e-18,  -7.492485094904213e-20,  -3.883388124564223e-21,  -7.963220167748391e-23,
  -9.390871468599236e-25,  -1.019656045907496e-27,  -5.852259421503570e-04,  -1.943863372743565e-05,  -3.706962780060418e-07,  -4.350821983662975e-09,  -9.251814651838515e-12,
   9.912802517992232e-13,   2.835378417637426e-14,   4.510046482089516e-16,   3.509747339853246e-18,  -4.023314805240156e-20,  -2.083734681936034e-21,  -4.271744304788716e-23,
  -5.035312862327391e-25,  -5.400383028157636e-28,  -2.177792258865247e-04,  -7.233670398182002e-06,  -1.379462207160419e-07,  -1.619035590494006e-09,  -3.441874901902016e-12,
   3.689038501655046e-13,   1.055143355910926e-14,   1.678276780536959e-16,   1.305856698957711e-18,  -1.497722573012993e-20,  -7.754900485045227e-22,  -1.589640794869308e-23,
  -1.873492569723327e-25,  -2.000650441138658e-28,  -2.459986980672556e-05,  -8.170997750380004e-07,  -1.558209900573569e-08,  -1.828822335136385e-10,  -3.887690159067694e-13,
   4.167094331601590e-14,   1.191870379856606e-15,   1.895737968337309e-17,   1.475027987895269e-19,  -1.691890465167680e-21,  -8.759898660818871e-23,  -1.795624390196493e-24,
  -2.116204540870960e-26,  -2.258280692186286e-29,  -8.224569999792503e-04,  -3.146300017032729e-05,  -7.856058907467002e-07,  -1.588696658791458e-08,  -2.783475703391426e-10,
  -4.319522186701605e-12,  -5.910480291577842e-14,  -6.852956862026401e-16,  -5.806301565200206e-18,  -5.927065738579918e-21,   1.184852987619485e-21,   3.510765030598522e-23,
   7.216405043365440e-25,   1.229017604870685e-26,  -7.824758495650813e-04,  -2.993404889331307e-05,  -7.474434771882203e-07,  -1.511550480144255e-08,  -2.648350289227661e-10,
  -4.109847080446524e-12,  -5.623475003944035e-14,  -6.519686245098955e-16,  -5.522284373066764e-18,  -5.581090688259367e-21,   1.128642772388778e-21,   3.342859681305329e-23,
   6.870269791416201e-25,   1.169929275142911e-26,  -7.064176616312779e-04,  -2.702523398272515e-05,  -6.748340526774016e-07,  -1.364757497108075e-08,  -2.391219302856241e-10,
  -3.710847424260135e-12,  -5.077362241748920e-14,  -5.885742832097482e-16,  -4.982697923113109e-18,  -4.946386017623225e-21,   1.021148187052105e-21,   3.022324757462217e-23,
   6.209903338987600e-25,   1.057255644639299e-26,  -6.017140848362538e-04,  -2.302047527056356e-05,  -5.748565799249606e-07,  -1.162612998769939e-08,  -2.037101026938491e-10,
  -3.161334317317866e-12,  -4.325322147089860e-14,  -5.013146893037201e-16,  -4.241276722552982e-18,  -4.118184180403736e-21,   8.720756705999799e-22,   2.578894986119691e-23,
   5.297149007208250e-25,   9.016288495960948e-27,  -4.786042735902016e-04,  -1.831118292433391e-05,  -4.572764111229452e-07,  -9.248496360958353e-09,  -1.620546877996196e-10,
  -2.514916047480114e-12,  -3.440764764156409e-14,  -3.987289777012665e-16,  -3.371277620720698e-18,  -3.202138509649543e-21,   6.954119481775564e-22,   2.054758685435335e-23,
   4.219279594591515e-25,   7.179886850969536e-27,  -3.491371594573181e-04,  -1.335821925369512e-05,  -3.335990468444424e-07,  -6.747308301910179e-09,  -1.182310515912201e-10,
  -1.834833621242120e-12,  -2.510237633093793e-14,  -2.908585886615311e-16,  -2.457996203780643e-18,  -2.292715811906555e-21,   5.083322476712147e-22,   1.500985528648420e-23,
   3.081403272926451e-25,   5.242545654176518e-27,  -2.259913337954567e-04,  -8.646744908045620e-06,  -2.159424492051385e-07,  -4.367698428302302e-09,  -7.653509010634497e-11,
  -1.187757754739976e-12,  -1.624939501166964e-14,  -1.882640432842129e-16,  -1.590460469870978e-18,  -1.465546746947940e-21,   3.294793078498451e-22,   9.724468583557801e-24,
   1.996035666505894e-25,   3.395513198272027e-27,  -1.212294869122013e-04,  -4.638455837044593e-06,  -1.158413198012326e-07,  -2.343056021150037e-09,  -4.105766031123849e-11,
  -6.371806398169697e-13,  -8.717006277942705e-15,  -1.009900533223282e-16,  -8.530219213291216e-19,  -7.810726086710182e-22,   1.768661502973027e-22,   5.218965620115276e-24,
   1.071152052527331e-25,   1.822045468729638e-27,  -4.511303193155195e-05,  -1.726110802936403e-06,  -4.310824828610763e-08,  -8.719290276164329e-10,  -1.527896386979421e-11,
  -2.371169828201032e-13,  -3.243888130327403e-15,  -3.758118905676849e-17,  -3.174142173064019e-19,  -2.899996547097651e-22,   6.583288525524787e-23,   1.942443992961203e-24,
   3.986600898640054e-26,   6.781109226292020e-28,  -5.095872022638852e-06,  -1.949779072567434e-07,  -4.869421499769959e-09,  -9.849141593575826e-11,  -1.725882980550867e-12,
  -2.678429150234644e-14,  -3.664233330243170e-16,  -4.245088245180939e-18,  -3.585407291344941e-20,  -3.274590761302933e-23,   7.436626229382062e-24,   2.194199746334301e-25,
   4.503274727653180e-27,   7.659930304922745e-29,  -3.548263829560323e-04,   1.381214955054686e-05,  -3.553792974976115e-07,   7.531234805647192e-09,  -1.415867440672301e-10,
   2.439522501977488e-12,  -3.913924391183807e-14,   5.881467075129221e-16,  -8.270829723879183e-18,   1.077290991406122e-19,  -1.268173397123146e-21,   1.261419281016796e-23,
  -8.270509780580917e-26,  -4.106131468867328e-28,  -3.375781133686877e-04,   1.314099514749259e-05,  -3.381188302167339e-07,   7.165639461104721e-09,  -1.347173986601090e-10,
   2.321231063846522e-12,  -3.724239286049471e-14,   5.596544995287252e-16,  -7.870231776677400e-18,   1.025097367658509e-19,  -1.206650403959877e-21,   1.199964943569143e-23,
  -7.860156749462513e-26,  -3.930396700223239e-28,  -3.047656466286816e-04,   1.186411011980566e-05,  -3.052771921474177e-07,   6.469940701585140e-09,  -1.216440266328483e-10,
   2.096078011282499e-12,  -3.363156740692899e-14,   5.054122092128628e-16,  -7.107559379911900e-18,   9.257353779528548e-20,  -1.089560903862330e-21,   1.083111101329454e-23,
  -7.082879789064410e-26,  -3.586424511795951e-28,  -2.595948059512733e-04,   1.010609828298744e-05,  -2.600546220141585e-07,   5.511821196422265e-09,  -1.036363019105392e-10,
   1.785891709790372e-12,  -2.865626090626040e-14,   4.306631542708347e-16,  -6.056493068832379e-18,   7.888128365125666e-20,  -9.282736421701202e-22,   9.223524568376418e-24,
  -6.019392313045359e-26,  -3.094125961158080e-28,  -2.064827199871715e-04,   8.038759875826256e-06,  -2.068670618651038e-07,   4.384759434489150e-09,  -8.244951131742642e-11,
   1.420878939578499e-12,  -2.280055833151115e-14,   3.426751913895499e-16,  -4.819196493140039e-18,   6.276450631219671e-20,  -7.385081620147849e-22,   7.334678225230997e-24,
  -4.777247490467035e-26,  -2.491448556636657e-28,  -1.506275032029502e-04,   5.864405339310948e-06,  -1.509188103965485e-07,   3.199020592052929e-09,  -6.015613326388784e-11,
   1.036739548426552e-12,  -1.663709134171323e-14,   2.500517333056624e-16,  -3.516645906133005e-18,   4.579914934729951e-20,  -5.388271759034364e-22,   5.349556726306040e-24,
  -3.478722306921142e-26,  -1.835365334117047e-28,  -9.749911885666245e-05,   3.796032155265854e-06,  -9.769235440919436e-08,   2.070841929730021e-09,  -3.894246274200123e-11,
   6.711612638498211e-13,  -1.077078577928391e-14,   1.618862461313135e-16,  -2.276738811523275e-18,   2.965069578549216e-20,  -3.488144669315101e-22,   3.462251515032487e-24,
  -2.249055737198560e-26,  -1.195660016394343e-28,  -5.230190809677495e-05,   2.036346121970276e-06,  -5.240685466612488e-08,   1.110915423270018e-09,  -2.089125048409870e-11,
   3.600600604732636e-13,  -5.778325628126962e-15,   8.684998740314048e-17,  -1.221448948325278e-18,   1.590718570332802e-20,  -1.871269161774933e-22,   1.857149401594296e-24,
  -1.205734323036355e-26,  -6.435032315199325e-29,  -1.946307282406238e-05,   7.577870309114733e-07,  -1.950229338758794e-08,   4.134098867752374e-10,  -7.774397228067054e-12,
   1.339922538204609e-13,  -2.150349421209324e-15,   3.232053848576480e-17,  -4.545534399401910e-19,   5.919727424431587e-21,  -6.963680041352980e-23,   6.910838562295474e-25,
  -4.485935613250610e-27,  -2.397397547042267e-29,  -2.198507362116696e-06,   8.559806634246741e-08,  -2.202940624782416e-09,   4.669800480347987e-11,  -8.781820968255167e-13,
   1.513554046302485e-14,  -2.429000698511244e-16,   3.650879318772177e-18,  -5.134568656314527e-20,   6.686833738302070e-22,  -7.866049976255296e-24,   7.806307993790755e-26,
  -5.067046343963228e-28,  -2.708539350904396e-30,  -2.979198752561516e-03,   1.038793901266889e-04,  -2.187413195274093e-06,   3.240760225999701e-08,  -2.921755578874545e-10,
  -8.741928214149901e-13,   1.032475702398687e-13,  -2.552148280697999e-15,   4.053590944770108e-17,  -3.897160906337389e-19,  -7.548711625178599e-22,   1.299142335914249e-22,
  -3.331050650704923e-24,   5.404761737467093e-26,  -2.834354651060763e-03,   9.882955225109136e-05,  -2.081068701266643e-06,   3.083102099166398e-08,  -2.779178700229440e-10,
  -8.332671310929646e-13,   9.825931186666842e-14,  -2.428426579993992e-15,   3.856316600764076e-17,  -3.705465409733616e-19,  -7.247060573328458e-22,   1.237204518612681e-22,
  -3.170461016698457e-24,   5.141560325995886e-26,  -2.558818337044121e-03,   8.922301518715474e-05,  -1.878768304513843e-06,   2.783229218426937e-08,  -2.508168817849591e-10,
  -7.547737840599643e-13,   8.875736688018391e-14,  -2.192924669701982e-15,   3.481120503858636e-17,  -3.341704354564499e-19,  -6.646694476877662e-22,   1.118882449339160e-22,
  -2.864416261366794e-24,   4.641040357275304e-26,  -2.179523827939555e-03,   7.599847375564080e-05,  -1.600284701048813e-06,   2.370510412473775e-08,  -2.135519387306703e-10,
  -6.454800628693222e-13,   7.565247276555537e-14,  -1.868456243401296e-15,   2.964790018102167e-17,  -2.842711055045348e-19,  -5.768763527017371e-22,   9.550386166397186e-23,
  -2.442049604173211e-24,   3.952371993456873e-26,  -1.733571435129710e-03,   6.044920982216476e-05,  -1.272855711746111e-06,   1.885356795457921e-08,  -1.697904405172641e-10,
  -5.154059071534902e-13,   6.021308825477312e-14,  -1.486606174239463e-15,   2.357913585991794e-17,  -2.258241367676618e-19,  -4.671315884619013e-22,   7.611787308021822e-23,
  -1.944098138919955e-24,   3.143107435798954e-26,  -1.264608770720982e-03,   4.409705793603032e-05,  -9.285281404434781e-07,   1.375260837150619e-08,  -1.238198641501795e-10,
  -3.771532111019120e-13,   4.394777701967331e-14,  -1.084719144997323e-15,   1.719906895530597e-17,  -1.645685566050912e-19,  -3.456376739635341e-22,   5.561770765879275e-23,
  -1.419191189630491e-24,   2.292499805506081e-26,  -8.185563092187204e-04,   2.854335277841497e-05,  -6.010192681363307e-07,   8.901481505090566e-09,  -8.012939956798714e-11,
  -2.446260034355757e-13,   2.845654789436574e-14,  -7.022314440797625e-16,   1.113198219565417e-17,  -1.064509121506784e-19,  -2.258096250145548e-22,   3.603920741090445e-23,
  -9.190446691905225e-25,   1.483742976550471e-26,  -4.390998881113721e-04,   1.531162525475169e-05,  -3.224063975517928e-07,   4.774954925794145e-09,  -4.297936641444552e-11,
  -1.313635894487695e-13,   1.526776590060115e-14,  -3.767309272629445e-16,   5.971377134841516e-18,  -5.708410065550837e-20,  -1.217060724314178e-22,   1.934332080089305e-23,
  -4.931235027650115e-25,   7.958866375515514e-27,  -1.634016652351907e-04,   5.697902048592727e-06,  -1.199767167437772e-07,   1.776886625753127e-09,  -1.599325726301668e-11,
  -4.890207956978523e-14,   5.681931149396281e-15,  -1.401964561230550e-16,   2.222097975250569e-18,  -2.124009403075824e-20,  -4.536474324511269e-23,   7.199594675723500e-24,
  -1.835207366952433e-25,   2.961669580470432e-27,  -1.845750012789402e-05,   6.436228678361006e-07,  -1.355231232933203e-08,   2.007130870075022e-10,  -1.806553171311698e-12,
  -5.524194774642291e-15,   6.418251107307521e-16,  -1.583636265056732e-17,   2.510029925984238e-19,  -2.399189783111800e-21,  -5.125637719518011e-24,   8.132756230404067e-25,
  -2.073038194646453e-26,   3.345428667501208e-28,  -7.170565226056605e-03,   1.940882056411824e-04,  -2.163667754472110e-06,  -1.305876775117621e-08,   9.605687830068940e-10,
  -1.665508009810154e-11,   5.381440992791633e-14,   4.192684132746575e-15,  -1.086175147399097e-16,   9.957296925757636e-19,   1.393012980724655e-20,  -6.338448004532485e-22,
   9.260643270042696e-24,   7.519370981361483e-27,  -6.821850641661105e-03,   1.846465170934431e-04,  -2.058254837609482e-06,  -1.242852845348438e-08,   9.138700532169447e-10,
  -1.584234891289290e-11,   5.110654965327792e-14,   3.989809173438625e-15,  -1.033155392062070e-16,   9.462608442717817e-19,   1.327063572033584e-20,  -6.029940208725596e-22,
   8.801335631785111e-24,   7.368689170254590e-27,  -6.158530036768859e-03,   1.666878349018946e-04,  -1.857817215166794e-06,  -1.122773173480074e-08,   8.250341213177601e-10,
  -1.429750736307454e-11,   4.599262110844277e-14,   3.603486274574369e-15,  -9.323818357385484e-17,   8.525867231948786e-19,   1.200883393730570e-20,  -5.443199352916471e-22,
   7.931278898707742e-24,   6.994419590965425e-27,  -5.245497047769434e-03,   1.419707542018502e-04,  -1.582073568554792e-06,  -9.571079986539612e-09,   7.027432573107062e-10,
  -1.217328130738266e-11,   3.902509380141072e-14,   3.070922709044871e-15,  -7.938266446661932e-17,   7.244720282410366e-19,   1.025784753212487e-20,  -4.635773686828318e-22,
   6.740730969610831e-24,   6.309562040151495e-27,  -4.172098476506024e-03,   1.129152548010750e-04,  -1.258088471821507e-06,  -7.618637571238843e-09,   5.589581445737308e-10,
  -9.678720495004254e-12,   3.092436424866285e-14,   2.443801069433410e-15,  -6.311327443138908e-17,   5.748979409425813e-19,   8.181417419320964e-21,  -3.686793081867661e-22,
   5.350005630958200e-24,   5.289980962284550e-27,  -3.043400836160743e-03,   8.236558808726282e-05,  -9.175898366009036e-07,  -5.561121342997504e-09,   4.077516205898113e-10,
  -7.058225182729432e-12,   2.249072593054801e-14,   1.783424189739046e-15,  -4.602415437912914e-17,   4.185902895354580e-19,   5.981358630424725e-21,  -2.689176701904950e-22,
   3.895968064103410e-24,   4.018277864639285e-27,  -1.969903820043957e-03,   5.331189543461709e-05,  -5.938681804463500e-07,  -3.601085444502035e-09,   2.639303555946874e-10,
  -4.567698117543329e-12,   1.452871042162373e-14,   1.154681140563717e-15,  -2.978375057812352e-17,   2.706085391849888e-19,   3.877240496383367e-21,  -1.740533459067018e-22,
   2.518889501970664e-24,   2.669046986001923e-27,  -1.056711535470921e-03,   2.859773738606412e-05,  -3.185507827963229e-07,  -1.932145887364250e-09,   1.415809293429409e-10,
  -2.449997713424356e-12,   7.785653240009546e-15,   6.194922415875314e-16,  -1.597509228772956e-17,   1.450703604139783e-19,   2.081425045293140e-21,  -9.336454200901801e-23,
   1.350415873086092e-24,   1.450512661266432e-27,  -3.932316245544190e-04,   1.064197694560416e-05,  -1.185394008441569e-07,  -7.190597592988101e-10,   5.268635279377299e-11,
  -9.116804691242506e-13,   2.896227049208659e-15,   2.305417377646182e-16,  -5.944548138250417e-18,   5.397283005363789e-20,   7.747585176411516e-22,  -3.474320071835089e-23,
   5.024252046568701e-25,   5.422054186861742e-28,  -4.441857839604310e-05,   1.202093689112057e-06,  -1.338991085316112e-08,  -8.122438874058052e-11,   5.951337411115071e-12,
  -1.029808531457242e-13,   3.271329653881401e-16,   2.604169350933964e-17,  -6.714790147357063e-19,   6.096439295667835e-21,   8.751864776798432e-23,  -3.924509510418454e-24,
   5.675101749423571e-26,   6.128987568053331e-29,  -1.119990604521493e-02,   1.811285888055704e-04,   1.373511328339856e-06,  -8.049843519288403e-08,   5.926732889636245e-10,
   2.024067891191931e-11,  -4.782084668569590e-13,  -8.441289481903307e-16,   1.829174413159005e-16,  -2.145997871293880e-18,  -3.777744961101371e-20,   1.292915106241915e-21,
  -3.566660110749710e-24,  -4.295803878799139e-25,  -1.065509793198775e-02,   1.723112664427542e-04,   1.306808484882589e-06,  -7.657694887410524e-08,   5.636327901801506e-10,
   1.925562785408188e-11,  -4.547962717278729e-13,  -8.053525868523144e-16,   1.739696811458457e-16,  -2.039511246113087e-18,  -3.594672790142641e-20,   1.229033804888007e-21,
  -3.374084361768956e-24,  -4.084884924859968e-25,  -9.618827975312967e-03,   1.555426368378829e-04,   1.179889326258746e-06,  -6.912028399528089e-08,   5.084810135413010e-10,
   1.738216600040850e-11,  -4.103254593891526e-13,  -7.306647954396796e-16,   1.569705818628075e-16,  -1.837819298441177e-18,  -3.246167844243756e-20,   1.107928783599960e-21,
  -3.015590202705299e-24,  -3.684489650199873e-25,  -8.192557040889923e-03,   1.324682478908687e-04,   1.005117135063132e-06,  -5.886180643988339e-08,   4.327387982333352e-10,
   1.480398888719839e-11,  -3.492364627396167e-13,  -6.260642290881856e-16,   1.336131901106328e-16,  -1.561874866564058e-18,  -2.765952215079470e-20,   9.420255708867672e-22,
  -2.537256067412538e-24,  -3.134941112236710e-25,  -6.515915892973932e-03,   1.053498277664322e-04,   7.995551655239944e-07,  -4.680824442599927e-08,   3.439106285170502e-10,
   1.177369700189820e-11,  -2.775736415988424e-13,  -5.008228628093376e-16,   1.062054092249444e-16,  -1.239581670140117e-18,  -2.200749460373657e-20,   7.479855976756921e-22,
  -1.993973649391821e-24,  -2.490874314088659e-25,  -4.753029199347304e-03,   7.684250017035024e-05,   5.833167459799003e-07,  -3.413997510572694e-08,   2.507088445166548e-10,
   8.587963074041756e-12,  -2.023641697078679e-13,  -3.670183643608608e-16,   7.743424918650283e-17,  -9.026565562281288e-19,  -1.605837469723584e-20,   5.448830083279910e-22,
  -1.440415240466768e-24,  -1.815501496983622e-25,  -3.076451061000577e-03,   4.973509358606099e-05,   3.775932860411907e-07,  -2.209565774170681e-08,   1.622071886960095e-10,
   5.558504616096026e-12,  -1.309347064020637e-13,  -2.382804404230592e-16,   5.010426917493010e-17,  -5.835897834445319e-19,  -1.039610147874203e-20,   3.523676000592506e-22,
  -9.263090209529188e-25,  -1.174476319718881e-25,  -1.650282073108344e-03,   2.667852581006647e-05,   2.025597352612365e-07,  -1.185213861504857e-08,   8.699339607091919e-11,
   2.981673668948525e-12,  -7.022336052468742e-14,  -1.280186058077288e-16,   2.687274720536073e-17,  -3.128685015896363e-19,  -5.577305701743375e-21,   1.889319470121962e-22,
  -4.952386689999340e-25,  -6.298443166957289e-26,  -6.141140566670196e-04,   9.927718474752954e-06,   7.537913962874798e-08,  -4.410432499623687e-09,   3.237018069717433e-11,
   1.109555078155873e-12,  -2.613028530789381e-14,  -4.766494750412144e-17,   9.999499520443980e-18,  -1.164030258085828e-19,  -2.075540507054854e-21,   7.029542638732480e-23,
  -1.840771847409454e-25,  -2.343594945075352e-26,  -6.936894281978591e-05,   1.121411429555768e-06,   8.514680496750614e-09,  -4.981913722004586e-10,   3.656420040097011e-12,
   1.253327502258052e-13,  -2.951587730630667e-15,  -5.384587772041761e-18,   1.129510801380785e-18,  -1.314819916434924e-20,  -2.344497503728211e-22,   7.940212540542145e-24,
  -2.078910300247784e-26,  -2.647231980718787e-27,  -1.333155003996199e-02,   4.243863540195391e-05,   4.719639001993396e-06,  -2.892280441196090e-08,  -1.632689908270123e-09,
   1.537464478388438e-11,   5.614548817193853e-13,  -7.433399310337476e-15,  -1.905645891701762e-16,   3.399679913906313e-18,   6.290202045334013e-20,  -1.501452498314231e-21,
  -1.989049092402455e-23,   6.444330570620693e-25,  -1.268295916343525e-02,   4.037183532597934e-05,   4.489783576948035e-06,  -2.751143302220089e-08,  -1.553025558069769e-09,
   1.462219316516062e-11,   5.339873777902050e-13,  -7.068214486948753e-15,  -1.812116284369979e-16,   3.231877469583670e-18,   5.980359107049322e-20,  -1.426938343617556e-21,
  -1.890737217701794e-23,   6.122486882712970e-25,  -1.144932287230796e-02,   3.644159343893706e-05,   4.052690763270973e-06,  -2.482869903731022e-08,  -1.401596576768295e-09,
   1.319282759687742e-11,   4.818054579522893e-13,  -6.375067365324924e-15,  -1.634553867908034e-16,   2.913693695947314e-18,   5.392586283356669e-20,  -1.285809448540689e-21,
  -1.704374524905613e-23,   5.513732818870155e-25,  -9.751478436475362e-03,   3.103410611956455e-05,   3.451313211583974e-06,  -2.113982527015993e-08,  -1.193369398703966e-09,
   1.122912157541562e-11,   4.101079357063661e-13,  -5.423889920389863e-15,  -1.390821547521719e-16,   2.477678108830469e-18,   4.586652466259132e-20,  -1.092733476659625e-21,
  -1.449102619006711e-23,   4.682484478755501e-25,  -7.755682148679471e-03,   2.467978814294019e-05,   2.744641422966839e-06,  -1.680783939652774e-08,  -9.488328258632848e-10,
   8.925258672175761e-12,   3.259801944092960e-13,  -4.309325967115859e-15,  -1.105133188702387e-16,   1.967545166885417e-18,   3.643095431907403e-20,  -8.672377583677034e-22,
  -1.150572081660926e-23,   3.713657168774619e-25,  -5.657307851718220e-03,   1.800085339345896e-05,   2.001872981418599e-06,  -1.225715547926108e-08,  -6.919440435564430e-10,
   6.507129897997470e-12,   2.376700113321392e-13,  -3.140767213997870e-15,  -8.055213481542539e-17,   1.433424675256026e-18,   2.654588153788040e-20,  -6.315126081131872e-22,
  -8.381299773441603e-24,   2.702743955269183e-25,  -3.661726504148787e-03,   1.165048442141301e-05,   1.295647622372728e-06,  -7.932165703632204e-09,  -4.477909883518778e-10,
   4.210361992997384e-12,   1.537849840124040e-13,  -2.031756633495576e-15,  -5.211188689166223e-17,   9.270311207679787e-19,   1.716987362991771e-20,  -4.082865263766945e-22,
  -5.419958563428747e-24,   1.746741710832611e-25,  -1.964229863122358e-03,   6.249387395151002e-06,   6.949924824925226e-07,  -4.254614129313708e-09,  -2.401844713830761e-10,
   2.258139651297343e-12,   8.248029651285033e-14,  -1.089569043374801e-15,  -2.794680038220149e-17,   4.970699861852429e-19,   9.206960170546067e-21,  -2.188861051537715e-22,
  -2.906037910044999e-24,   9.362676409286551e-26,  -7.309413843721134e-04,   2.325536628850110e-06,   2.586221715917117e-07,  -1.583205141831763e-09,  -8.937629523730422e-11,
   8.402623765441507e-13,   3.069135395510701e-14,  -4.054171049558342e-16,  -1.039881040820209e-17,   1.849456078538747e-19,   3.425719297010359e-21,  -8.143672091503625e-23,
  -1.081238538713424e-24,   3.483161503490038e-26,  -8.256547650212058e-05,   2.626868965888709e-07,   2.921332330928872e-08,  -1.788343879759367e-10,  -1.009569576732893e-11,
   9.491322129418898e-14,   3.466794627803799e-15,  -4.579427585630220e-17,  -1.174609376219640e-18,   2.089054856017183e-20,   3.869537224422130e-22,  -9.198610480407681e-24,
  -1.221311225012262e-25,   3.934332329416725e-27,  -1.255896497764525e-02,  -1.325923234676541e-04,   3.421965473444702e-06,   7.636481031879669e-08,  -6.245997192341014e-10,
  -3.330136767496486e-11,  -3.840315184626424e-14,   1.222997377390113e-14,   1.142636333744072e-16,  -3.750798867722951e-18,  -7.480280607026039e-20,   8.382176510356421e-22,
   3.598845379745916e-23,  -3.201590382086845e-26,  -1.194799120883728e-02,  -1.261361971627708e-04,   3.255408487432734e-06,   7.264052372319133e-08,  -5.942357468034019e-10,
  -3.167396151446250e-11,  -3.644066187038995e-14,   1.163109884203626e-14,   1.086063102790167e-16,  -3.566988929403761e-18,  -7.109418886388923e-20,   7.973677629336575e-22,
   3.419921757166314e-23,  -3.078797521044636e-26,  -1.078589132808420e-02,  -1.138586769592551e-04,   2.938643570769065e-06,   6.556052726638015e-08,  -5.364731672664830e-10,
  -2.858155026796729e-11,  -3.274632727855417e-14,   1.049360086809418e-14,   9.788601443849311e-17,  -3.217918601613626e-18,  -6.406861092170702e-20,   7.196975978620482e-22,
   3.081169968618943e-23,  -2.831705449905988e-26,  -9.186478111757660e-03,  -9.696547384988094e-05,   2.502741898678464e-06,   5.582353497155940e-08,  -4.569565302249665e-10,
  -2.433121713206079e-11,  -2.773613221362240e-14,   8.931127381367905e-15,   8.320933231988578e-17,  -2.738544228722653e-18,  -5.445414318076269e-20,   6.128548104224058e-22,
   2.617977670914094e-23,  -2.465524223808056e-26,  -7.306356439442431e-03,  -7.711309811955720e-05,   1.990419945171917e-06,   4.438686681770999e-08,  -3.634624102807018e-10,
  -1.934224850525412e-11,  -2.194058510568673e-14,   7.098324550382643e-15,   6.605508609755914e-17,  -2.176372414649345e-18,  -4.322164523694955e-20,   4.873324193955383e-22,
   2.077326007719545e-23,  -2.002239115931057e-26,  -5.329574000718670e-03,  -5.624539107038399e-05,   1.451836452126742e-06,   3.237082502603207e-08,  -2.651413774804429e-10,
  -1.410361596549018e-11,  -1.593454754558815e-14,   5.174923788645483e-15,   4.811038864663309e-17,  -1.586543957674352e-18,  -3.147621066054312e-20,   3.554253261331064e-22,
   1.512444924546447e-23,  -1.484709924958159e-26,  -3.449608409706178e-03,  -3.640344918942854e-05,   9.396858043328912e-07,   2.094932518910906e-08,  -1.716217004337873e-10,
  -9.126340639866067e-12,  -1.028389983825560e-14,   3.348268750948374e-15,   3.110860148172341e-17,  -1.026476718388005e-18,  -2.035120185544620e-20,   2.300276056471562e-22,
   9.777253944631719e-24,  -9.713082626770428e-27,  -1.850447743730819e-03,  -1.952712985623196e-05,   5.040613059019894e-07,   1.123687948861977e-08,  -9.206364168056305e-11,
  -4.894931797554936e-12,  -5.508293520234599e-15,   1.795745031295864e-15,   1.667875815708524e-17,  -5.505078409754438e-19,  -1.091078058581155e-20,   1.233852901693744e-22,
   5.241390639714323e-24,  -5.238695050769165e-27,  -6.886004201251788e-04,  -7.266495225406760e-06,   1.875735569510364e-07,   4.181434252151141e-09,  -3.425955455294196e-11,
  -1.821449956408213e-12,  -2.048716580616063e-15,   6.681998264432643e-16,   6.205492613828704e-18,  -2.048432819127383e-19,  -4.059404186447658e-21,   4.591405088805093e-23,
   1.950026094595790e-24,  -1.953129548710658e-27,  -7.778274361652100e-05,  -8.208056767105734e-07,   2.118786702934316e-08,   4.723234585153856e-10,  -3.869886064715618e-12,
  -2.057453680787020e-13,  -2.313992998822080e-16,   7.547754522982784e-17,   7.009384347152955e-19,  -2.313836050622741e-20,  -4.585270297771834e-22,   5.186331568084240e-24,
   2.202627582870453e-25,  -2.206869115373223e-28,  -9.125279721023439e-03,  -2.139410265392081e-04,  -1.004390330100645e-06,   5.501721959444695e-08,   1.365346072648575e-09,
   5.778665399352886e-12,  -3.792621763815812e-13,  -9.078883190060949e-15,  -3.078867423159945e-17,   2.734537335808538e-18,   6.199364907740915e-20,   1.439868438829019e-22,
  -2.030348135385201e-23,  -4.333887952000980e-25,  -8.681452607889864e-03,  -2.035299542058765e-04,  -9.552933173396731e-07,   5.234286448386663e-08,   1.298765961632266e-09,
   5.491934802877146e-12,  -3.608398958277474e-13,  -8.634355062361880e-15,  -2.920849043080513e-17,   2.601754412129912e-18,   5.893840442353842e-20,   1.359847085976537e-22,
  -1.931721722525234e-23,  -4.118357355772636e-25,  -7.837231270877950e-03,  -1.837289133784101e-04,  -8.620041129321445e-07,   4.725524524671565e-08,   1.172191831295197e-09,
   4.948841545903157e-12,  -3.257883158032129e-13,  -7.790002167005046e-15,  -2.623645377484426e-17,   2.349092217728511e-18,   5.314317855881644e-20,   1.211711286803219e-22,
  -1.744066148787425e-23,  -3.710316100987317e-25,  -6.675237026523927e-03,  -1.564789882105854e-04,  -7.337941875118692e-07,   4.025139568948868e-08,   9.981108358479036e-10,
   4.205796320521580e-12,  -2.775240382789244e-13,  -6.630157475228024e-15,  -2.221097184675728e-17,   2.001152375489248e-18,   4.519813851942354e-20,   1.015703868370508e-22,
  -1.485673837853772e-23,  -3.152422462775202e-25,  -5.309201437040254e-03,  -1.244496786548162e-04,  -5.833169304226462e-07,   3.201618084847798e-08,   7.936351853263767e-10,
   3.337934573241933e-12,  -2.207609084071865e-13,  -5.269599712949334e-15,  -1.756112943927641e-17,   1.591899899099155e-18,   3.589794397470547e-20,   7.952408787604478e-23,
  -1.181786582278334e-23,  -2.501296795272695e-25,  -3.872839190625782e-03,  -9.077663761295035e-05,  -4.253218825610526e-07,   2.335558545615816e-08,   5.787942099956346e-10,
   2.430666428123452e-12,  -1.610533783049994e-13,  -3.841749127812663e-15,  -1.274872162980008e-17,   1.161380021219112e-18,   2.615621894755464e-20,   5.726960664504954e-23,
  -8.621459569782314e-24,  -1.821061226973292e-25,  -2.506758296754892e-03,  -5.875487505651110e-05,  -2.752181378536027e-07,   1.511776532470490e-08,   3.745786898053992e-10,
   1.571485597918041e-12,  -1.042519239033238e-13,  -2.485692778253891e-15,  -8.225578992475741e-18,   7.517884146908788e-19,   1.691728382934794e-20,   3.675254993706079e-23,
  -5.580724464076114e-24,  -1.177202027486748e-25,  -1.344690736454623e-03,  -3.151716094369184e-05,  -1.476126182286526e-07,   8.109697540932320e-09,   2.009185758362307e-10,
   8.424894226199958e-13,  -5.592552240473488e-14,  -1.333131138454826e-15,  -4.405189982261227e-18,   4.032971549900707e-19,   9.071359762952237e-21,   1.962799101751495e-23,
  -2.993740122852399e-24,  -6.310661334751813e-26,  -5.003960687767077e-04,  -1.172833086650335e-05,  -5.492788150022810e-08,   3.017856642885283e-09,   7.476530440519694e-11,
   3.134489623774940e-13,  -2.081167797127618e-14,  -4.960608154303720e-16,  -1.638355489386882e-18,   1.500802123529835e-19,   3.375245048803700e-21,   7.292839982504914e-24,
  -1.114064318943150e-24,  -2.347830472389907e-26,  -5.652362743884968e-05,  -1.324805039442218e-06,  -6.204481251086431e-09,   3.408906849666673e-10,   8.445287197769198e-12,
   3.540534517959026e-14,  -2.350845659510382e-15,  -5.603332436813202e-17,  -1.850482212090726e-19,   1.695276923043919e-20,   3.812520185865305e-22,   8.235809872664007e-25,
  -1.258424439353807e-25,  -2.651960563316271e-27,  -4.540824843671874e-03,  -1.534379193212734e-04,  -2.870942342998782e-06,  -2.921327669673000e-08,   1.238869490002678e-10,
   1.242228913917156e-11,   2.863723796748683e-13,   3.541863138226345e-15,   7.426210039016460e-19,  -1.132611598262961e-18,  -3.021101134007785e-20,  -4.288130530278225e-22,
  -1.429709371026782e-24,   1.034095902102438e-25,  -4.320042945668941e-03,  -1.459772467342052e-04,  -2.731276349292795e-06,  -2.778863335948885e-08,   1.179887558081885e-10,
   1.182027044682428e-11,   2.724435192207615e-13,   3.368368734314308e-15,   6.660600145797674e-19,  -1.078219843543581e-18,  -2.874424598570450e-20,  -4.077135066924648e-22,
  -1.351464231963047e-24,   9.853704651227316e-26,  -3.900056141253929e-03,  -1.317851476022114e-04,  -2.465624919806264e-06,  -2.508030361045250e-08,   1.067178190908902e-10,
   1.067426535283558e-11,   2.459490483520903e-13,   3.038856380537699e-15,   5.368639562247205e-19,  -9.744759827842146e-19,  -2.595316801833701e-20,  -3.676776140130294e-22,
  -1.206167359726378e-24,   8.920478511111204e-26,  -3.321926657599926e-03,  -1.122493507663339e-04,  -2.100004726582423e-06,  -2.135552244934533e-08,   9.110406178852905e-11,
   9.095185514444731e-12,   2.094821882552532e-13,   2.586279637015220e-15,   3.909055501051549e-19,  -8.311335368127171e-19,  -2.210942177261015e-20,  -3.127631165858746e-22,
  -1.013039293906329e-24,   7.623586159238472e-26,  -2.642209570468048e-03,  -8.928105207999196e-05,  -1.670214779489400e-06,  -1.698047104778295e-08,   7.262158163214408e-11,
   7.236665804235977e-12,   1.666124515236525e-13,   2.055458219162702e-15,   2.596669146077991e-19,  -6.619273516530253e-19,  -1.758813235699987e-20,  -2.484487723880599e-22,
  -7.946877269209911e-25,   6.083307092806217e-26,  -1.927433364270376e-03,  -6.512833728970730e-05,  -1.218327786183109e-06,  -1.238371307764065e-08,   5.306915257201730e-11,
   5.280452619932068e-12,   1.215362610132762e-13,   1.498453381480536e-15,   1.593009803174720e-19,  -4.833642670852846e-19,  -1.283168755743624e-20,  -1.810505683318449e-22,
  -5.732011974956182e-25,   4.449157039294458e-26,  -1.247585157461927e-03,  -4.215604688962476e-05,  -7.885723938840891e-07,  -8.014351089008312e-09,   3.439040388365605e-11,
   3.418547086989713e-12,   7.866609602640479e-14,   9.695059908625596e-16,   9.022901624098571e-20,  -3.130860246825300e-19,  -8.306320227297489e-21,  -1.171098342402967e-22,
  -3.682373740620331e-25,   2.884764223059761e-26,  -6.692435165565975e-04,  -2.261379077643008e-05,  -4.230080737379308e-07,  -4.298774508003189e-09,   1.845907753805114e-11,
   1.833987608562674e-12,   4.219848718361712e-14,   5.199602509326843e-16,   4.485256262413752e-20,  -1.680082938639583e-19,  -4.455947443442356e-21,  -6.279924820285082e-23,
  -1.967672024569025e-25,   1.548832838049022e-26,  -2.490445534594405e-04,  -8.415231688801904e-06,  -1.574124706631937e-07,  -1.599647999718257e-09,   6.870571929737774e-12,
   6.825013128388760e-13,   1.570319858119855e-14,   1.934773723826822e-16,   1.623122431560793e-20,  -6.252833323707890e-20,  -1.658207919508510e-21,  -2.336652195587696e-23,
  -7.312335296894447e-26,   5.765402946911671e-27,  -2.813153346482455e-05,  -9.505662904529366e-07,  -1.778095624421635e-08,  -1.806919082923401e-10,   7.761104519932857e-13,
   7.709427087609996e-14,   1.773798247223421e-15,   2.185452275713763e-17,   1.825204055418741e-21,  -7.063202543928699e-21,  -1.873079895875312e-22,  -2.639380360735206e-24,
  -8.258075259211327e-27,   6.512788933982407e-28,  -9.622023182434668e-04,  -3.859323256231483e-05,  -1.006090132869065e-06,  -2.111562431396057e-08,  -3.805852933515832e-10,
  -5.989074943560418e-12,  -8.084022033354702e-14,  -8.616267487628623e-16,  -4.682074894631259e-18,   8.526617085135246e-20,   3.771463902254832e-21,   9.015322173454522e-23,
   1.696095896547863e-24,   2.674119360693422e-26,  -9.154304913646945e-04,  -3.671793172839689e-05,  -9.572215538871474e-07,  -2.009033558550876e-08,  -3.621095645896418e-10,
  -5.698301865857447e-12,  -7.691199381143875e-14,  -8.196246622068723e-16,  -4.449264305109867e-18,   8.126680622792991e-20,   3.591357133314445e-21,   8.583028094575652e-23,
   1.614533162932866e-24,   2.545010927563964e-26,  -8.264529948001219e-04,  -3.315013094216681e-05,  -8.642403729633830e-07,  -1.813939638673581e-08,  -3.269519838773614e-10,
  -5.145000059002651e-12,  -6.943848474634188e-14,  -7.397692311260879e-16,  -4.008487901028070e-18,   7.359954590412748e-20,   3.247419340816059e-21,   7.758233255786010e-23,
   1.459011147190255e-24,   2.299039312187363e-26,  -7.039623288884794e-04,  -2.823798777902802e-05,  -7.362091944341894e-07,  -1.545275465327080e-08,  -2.785333055216924e-10,
  -4.383021786900454e-12,  -5.914902772104357e-14,  -6.299301694339091e-16,  -3.405803105206756e-18,   6.292996006188420e-20,   2.771401058643756e-21,   6.618106284276373e-23,
   1.244215803978707e-24,   1.959728745209409e-26,  -5.599359737146584e-04,  -2.246153482187978e-05,  -5.856316981154289e-07,  -1.229263981157910e-08,  -2.215777543324641e-10,
  -3.486726394601864e-12,  -4.704918796417764e-14,  -5.008987338100488e-16,  -2.702367447852231e-18,   5.023940652929581e-20,   2.208476639570700e-21,   5.271606212064203e-23,
   9.907750313029736e-25,   1.559886480625778e-26,  -4.084697798080214e-04,  -1.638605728238833e-05,  -4.272418996113949e-07,  -8.968240196853412e-09,  -1.616575905424485e-10,
  -2.543805778604780e-12,  -3.432307476451333e-14,  -3.653132600448154e-16,  -1.967460773274683e-18,   3.675784981843262e-20,   1.613473068096580e-21,   3.850026496383262e-23,
   7.234211198995107e-25,   1.138576143180508e-26,  -2.643972921982283e-04,  -1.060670394468191e-05,  -2.765599019693651e-07,  -5.805385608792737e-09,  -1.046466041178549e-10,
  -1.646684616675269e-12,  -2.221731068852604e-14,  -2.364244222637047e-16,  -1.271843427945759e-18,   2.383932750254102e-20,   1.045408900074112e-21,   2.493965329436937e-23,
   4.685422339718863e-25,   7.372629127520831e-27,  -1.418319858016237e-04,  -5.689868131116814e-06,  -1.483596474150093e-07,  -3.114311137159243e-09,  -5.613823250434822e-11,
  -8.833701247937234e-13,  -1.191826088270596e-14,  -1.268158253339613e-16,  -6.818015066042934e-19,   1.280104906929866e-20,   5.610773721738790e-22,   1.338371854438012e-23,
   2.514198858135886e-25,   3.955699548845453e-27,  -5.277985291057702e-05,  -2.117375020642673e-06,  -5.520940365188833e-08,  -1.158939527268481e-09,  -2.089096204282713e-11,
  -3.287319790291054e-13,  -4.435150349808956e-15,  -4.719053353919417e-17,  -2.536588074094483e-19,   4.765304583859391e-21,   2.088300951080706e-22,   4.981150548133483e-24,
   9.357075655230920e-26,   1.472130859720319e-27,  -5.961900324407459e-06,  -2.391743339405018e-07,  -6.236344681783119e-09,  -1.309115816268058e-10,  -2.359803722549459e-12,
  -3.713293893805198e-14,  -5.009854522673527e-16,  -5.330518194041776e-18,  -2.865169320070587e-20,   5.383084229192531e-22,   2.358966290346885e-23,   5.626723136841527e-25,
   1.056973401227442e-26,   1.662905513871248e-28,  -3.047413464008731e-04,   1.129550509572006e-05,  -2.771379493732490e-07,   5.610236676765261e-09,  -1.009963464915657e-10,
   1.671149659624895e-12,  -2.585730142118501e-14,   3.767559322121804e-16,  -5.182795537364521e-18,   6.690643592158451e-20,  -8.023522202046999e-22,   8.608840882299356e-24,
  -7.766503639284139e-26,   3.763258518855502e-28,  -2.899268927041257e-04,   1.074658933540966e-05,  -2.636759120554506e-07,   5.337850471207497e-09,  -9.609539847895491e-11,
   1.590099946513017e-12,  -2.460391426556740e-14,   3.585021047695358e-16,  -4.931777320791295e-18,   6.366616981264744e-20,  -7.634778004446837e-22,   8.190969377978575e-24,
  -7.387530292583601e-26,   3.574843635906748e-28,  -2.617447683708393e-04,   9.702285811303337e-06,  -2.380622644168213e-07,   4.819538987470845e-09,  -8.676855060571949e-11,
   1.435838551877402e-12,  -2.221807541222279e-14,   3.237521383211139e-16,  -4.453875788529924e-18,   5.749709458884451e-20,  -6.894723424993372e-22,   7.395777085339706e-24,
  -6.667163517448031e-26,   3.218626512360149e-28,  -2.229488885509694e-04,   8.264530293819887e-06,  -2.027938857005504e-07,   4.105752414599828e-09,  -7.392214804493230e-11,
   1.223330380479419e-12,  -1.893084626184606e-14,   2.758664237919909e-16,  -3.795254114246943e-18,   4.899499285123578e-20,  -5.874925465920365e-22,   6.300605159667092e-24,
  -5.676608424375539e-26,   2.732554348685825e-28,  -1.773333499207211e-04,   6.573847146311960e-06,  -1.613154177147811e-07,   3.266149561132973e-09,  -5.880877495927458e-11,
   9.732770218775965e-13,  -1.506216593930694e-14,   2.195018477569679e-16,  -3.019925683451163e-18,   3.898612046451434e-20,  -4.674562186706238e-22,   5.012290550180759e-24,
  -4.513348559018804e-26,   2.166502125123225e-28,  -1.293626437484750e-04,   4.795691223818615e-06,  -1.176855856491474e-07,   2.382875871036479e-09,  -4.290688765778160e-11,
   7.101361340695457e-13,  -1.099037356413736e-14,   1.601698876457179e-16,  -2.203696964002906e-18,   2.844906363913624e-20,  -3.411009753659934e-22,   3.656874315589167e-24,
  -3.291361231068970e-26,   1.576335137074784e-28,  -8.373439910229832e-05,   3.104237388756215e-06,  -7.617937684605622e-08,   1.542508007027427e-09,  -2.777575827023959e-11,
   4.597205405285786e-13,  -7.115048893298747e-15,   1.036950376653860e-16,  -1.426715938222217e-18,   1.841853792685723e-20,  -2.208307716610300e-22,   2.367235963910867e-24,
  -2.129985031527776e-26,   1.018579378070191e-28,  -4.491796141069415e-05,   1.665234946365251e-06,  -4.086611596506649e-08,   8.274837373489023e-10,  -1.490062860716349e-11,
   2.466263349707300e-13,  -3.817070445580445e-15,   5.563092113944218e-17,  -7.654206464201791e-19,   9.881402703108199e-21,  -1.184725167772722e-22,   1.269920100067515e-24,
  -1.142468653869980e-26,   5.459158296243243e-29,  -1.671528031053933e-05,   6.196845885062862e-07,  -1.520759038948730e-08,   3.079347004877307e-10,  -5.545057583828921e-12,
   9.177899798648447e-14,  -1.420484129119005e-15,   2.070258358809836e-17,  -2.848459136388905e-19,   3.677296875737113e-21,  -4.408855049641210e-23,   4.725813022266275e-25,
  -4.251293230001534e-27,   2.030883761676806e-29,  -1.888122385574011e-06,   6.999828813310824e-08,  -1.717819095041157e-09,   3.478371687173049e-11,  -6.263596641112360e-13,
   1.036719848916181e-14,  -1.604555930399139e-16,   2.338532187522991e-18,  -3.217577679951529e-20,   4.153821053417378e-22,  -4.980175088209539e-24,   5.338190216922435e-26,
  -4.802140501060158e-28,   2.293930390336072e-30,  -2.596329805852727e-03,   8.785561316936472e-05,  -1.826772072328794e-06,   2.770573178238664e-08,  -2.899657488937325e-10,
   8.798634101382863e-13,   4.784936093311177e-14,  -1.476563108678108e-15,   2.697848094905929e-17,  -3.437472778098643e-19,   2.299531877494836e-21,   2.529632724489441e-23,
  -1.265402837448619e-24,   2.676442220458553e-26,  -2.470097853851308e-03,   8.358475873728884e-05,  -1.737968947836545e-06,   2.635837459167904e-08,  -2.758402947711038e-10,
   8.361429709714133e-13,   4.554442763707986e-14,  -1.405110207700220e-15,   2.566929476553226e-17,  -3.269853364156423e-19,   2.185187010805987e-21,   2.412813369570181e-23,
  -1.204923212070349e-24,   2.547460482426637e-26,  -2.229968310001432e-03,   7.546010633611202e-05,  -1.569034360398861e-06,   2.379544337383278e-08,  -2.489807783443593e-10,
   7.533568254282408e-13,   4.115105246643711e-14,  -1.269049234893165e-15,   2.317782790670682e-17,  -2.951191423659078e-19,   1.968701267392912e-21,   2.188084372528905e-23,
  -1.089449018882501e-24,   2.301632689769586e-26,  -1.899415489191073e-03,   6.427553391711776e-05,  -1.336475122454599e-06,   2.026766691013703e-08,  -2.120286962423581e-10,
   6.401390246754180e-13,   3.508638142585624e-14,  -1.081487603613784e-15,   1.974620513999582e-17,  -2.512920213145917e-19,   1.672697559231907e-21,   1.873871101132089e-23,
  -9.296689898984505e-25,   1.962331431440007e-26,  -1.510773084521812e-03,   5.112481473057165e-05,  -1.063033793712800e-06,   1.612025893728784e-08,  -1.686102965334954e-10,
   5.079650266540723e-13,   2.793450960018512e-14,  -8.606289525412582e-16,   1.570904320474626e-17,  -1.998120542874151e-19,   1.327214196379369e-21,   1.498281953027013e-23,
  -7.407689032372927e-25,   1.562260918190826e-26,  -1.102079682008429e-03,   3.729503109591840e-05,  -7.754725082078311e-07,   1.175917607178649e-08,  -1.229774423511087e-10,
   3.698487483230214e-13,   2.039367330428402e-14,  -6.280625601394415e-16,   1.146128484996976e-17,  -1.457220821211066e-19,   9.662771600410505e-22,   1.097569063037463e-23,
  -5.411526243082723e-25,   1.140487210581764e-26,  -7.133536871856466e-04,   2.414051339428000e-05,  -5.019517874306116e-07,   7.611371810913520e-09,  -7.959201801510739e-11,
   2.390952942414184e-13,   1.320724791467384e-14,  -4.066391660028123e-16,   7.419442777535645e-18,  -9.430710339603536e-20,   6.246383563964528e-22,   7.124027818511926e-24,
  -3.506089175401377e-25,   7.385764959414617e-27,  -3.826656172025396e-04,   1.294979488619331e-05,  -2.692640841052794e-07,   4.082953683687120e-09,  -4.269327456376323e-11,
   1.281756017837176e-13,   7.086672224899549e-15,  -2.181636859573211e-16,   3.980241837459629e-18,  -5.058496667920773e-20,   3.348517983970684e-22,   3.826979804059159e-24,
  -1.881691931812507e-25,   3.962957088754916e-27,  -1.424008273156450e-04,   4.818996442216419e-06,  -1.002010234151898e-07,   1.519380238675428e-09,  -1.588707624098582e-11,
   4.768709470337945e-14,   2.637397588748795e-15,  -8.118877141277499e-17,   1.481189944693681e-18,  -1.882354817378223e-20,   1.245789066802713e-22,   1.424831377704424e-24,
  -7.003498127419778e-26,   1.474858939672721e-27,  -1.608529023442139e-05,   5.443435699508430e-07,  -1.131849415143361e-08,   1.716258479638039e-10,  -1.794564245975964e-12,
   5.386439271647593e-15,   2.979191161566700e-16,  -9.170976939921588e-18,   1.673125233378473e-19,  -2.126257252064620e-21,   1.407164413654330e-23,   1.609584740895033e-25,
  -7.911212606479533e-27,   1.665991995314548e-28,  -6.429487288679717e-03,   1.763886286828184e-04,  -2.238830372027133e-06,  -2.510057374644151e-10,   6.480124250980639e-10,
  -1.431179398760759e-11,   1.284266184852920e-13,   1.351167298190547e-15,  -6.829645302166574e-17,   1.121883825172895e-18,  -4.687439913108698e-21,  -2.342976563988180e-22,
   6.653052303088799e-24,  -7.979240173997041e-26,  -6.116821296230779e-03,   1.678089970469984e-04,  -2.129817192619525e-06,  -2.430490079053521e-10,   6.165499408380099e-10,
  -1.361481439154006e-11,   1.221230176305499e-13,   1.286644152616746e-15,  -6.498065557073940e-17,   1.066930155223715e-18,  -4.446394770341926e-21,  -2.230850761288524e-22,
   6.328741474651662e-24,  -7.581590675594683e-26,  -5.522068248572368e-03,   1.514895797948089e-04,  -1.922508827937146e-06,  -2.261857390208490e-10,   5.566815149801685e-10,
  -1.228942454176056e-11,   1.101559710338969e-13,   1.163426309643393e-15,  -5.867110424495539e-17,   9.625580768413254e-19,  -3.993204326443330e-21,  -2.016824950906997e-22,
   5.712144263750867e-24,  -6.829084335427747e-26,  -4.703408582163737e-03,   1.290278525203751e-04,  -1.637264534410218e-06,  -1.996240027202146e-10,   4.742346997245135e-10,
  -1.046585016685705e-11,   9.372956944057811e-14,   9.928867764160466e-16,  -4.998187056585820e-17,   8.192051438763066e-19,  -3.379724695310933e-21,  -1.720792781173803e-22,
   4.864018708894854e-24,  -5.800855987013455e-26,  -3.740950193465455e-03,   1.026225391056251e-04,  -1.302055219270820e-06,  -1.641566750538621e-10,   3.772557468874917e-10,
  -8.322957443160090e-12,   7.447593192366954e-14,   7.912104520978151e-16,  -3.976092101111022e-17,   6.510677520403573e-19,  -2.671551303530354e-21,  -1.370953999277744e-22,
   3.867692104716057e-24,  -4.601617688120556e-26,  -2.728899805385171e-03,   7.485837883896502e-05,  -9.497029682569485e-07,  -1.229090969823962e-10,   2.752330266546508e-10,
  -6.070578388932527e-12,   5.428439006722359e-14,   5.780418772598607e-16,  -2.900828448736219e-17,   4.746363470748571e-19,  -1.939066780804379e-21,  -1.001407688982123e-22,
   2.820759942636345e-24,  -3.349548782136163e-26,  -1.766339403371335e-03,   4.845311426321918e-05,  -6.146715642452370e-07,  -8.090795628238434e-11,   1.781665161674794e-10,
  -3.928994450852676e-12,   3.511820490536710e-14,   3.745263337668475e-16,  -1.877794688777111e-17,   3.070919120061263e-19,  -1.250936808124298e-21,  -6.487561060636490e-23,
   1.825542341496117e-24,  -2.164995608001862e-26,  -9.475146702248036e-04,   2.599146538417604e-05,  -3.297151201943681e-07,  -4.377386680042890e-11,   9.557798758905466e-11,
  -2.107536498481439e-12,   1.883329581698928e-14,   2.010101962058510e-16,  -1.007349412112101e-17,   1.646979078971072e-19,  -6.698904720237242e-22,  -3.481690541560873e-23,
   9.792021681921614e-25,  -1.160518587375945e-26,  -3.525965487509947e-04,   9.672125751380717e-06,  -1.226945842483683e-07,  -1.633772378338575e-11,   3.556779641045188e-11,
  -7.842615418904590e-13,   7.007731356757951e-15,   7.481490223200172e-17,  -3.748687968998277e-18,   6.128414576732670e-20,  -2.491362329143719e-22,  -1.295838208420248e-23,
   3.643791832377896e-25,  -4.317515584626819e-27,  -3.982853153487005e-05,   1.092541698975942e-06,  -1.385928241093982e-08,  -1.846338273894287e-12,   4.017670365731613e-12,
  -8.858825690986923e-14,   7.915660804510908e-16,   8.451167547732889e-18,  -4.234446466604714e-19,   6.922441372286809e-21,  -2.813921733380613e-23,  -1.463787001965720e-24,
   4.115930769198043e-26,  -4.876774165525947e-28,  -1.045927033953625e-02,   1.884406811291696e-04,   4.757701646593105e-07,  -6.839786935773521e-08,   8.838884191372701e-10,
   9.062324358256183e-12,  -4.329730000441728e-13,   3.586964509858244e-15,   9.122465190526304e-17,  -2.633603602627330e-18,   9.392470793702583e-21,   7.597700180562322e-22,
  -1.513705455318783e-23,  -3.025204632445742e-26,  -9.950513604414391e-03,   1.792687690553280e-04,   4.527857429445049e-07,  -6.506827336357312e-08,   8.407030022369833e-10,
   8.623756119687112e-12,  -4.118370412882702e-13,   3.409683226067429e-15,   8.679977958275043e-17,  -2.504262630805176e-18,   8.906088430049552e-21,   7.227411239836165e-22,
  -1.438535130913321e-23,  -2.902215810104707e-26,  -8.982806624937788e-03,   1.618252332676704e-04,   4.090028355867305e-07,  -5.873610235475357e-08,   7.586378647626638e-10,
   7.788642495069473e-12,  -3.716649382448428e-13,   3.073618201988288e-15,   7.837810823606154e-17,  -2.258746306014385e-18,   7.992978314084297e-21,   6.523370546897349e-22,
  -1.296180859009634e-23,  -2.658386799025774e-26,  -7.650883557604227e-03,   1.378210697611469e-04,   3.486169059747834e-07,  -5.002274442772291e-08,   6.458368730091948e-10,
   6.637450461663794e-12,  -3.164326693090122e-13,   2.613280744948780e-15,   6.677690691071864e-17,  -1.921800730316760e-18,   6.759501626942723e-21,   5.554912966794749e-22,
  -1.101464080419252e-23,  -2.303678320007229e-26,  -6.085128429719759e-03,   1.096085638716102e-04,   2.774721774281418e-07,  -3.978227282634186e-08,   5.134236779137358e-10,
   5.281922838126891e-12,  -2.515790772254532e-13,   2.074924571668544e-15,   5.312659752843728e-17,  -1.526936094836198e-18,   5.338910013420500e-21,   4.417157704750195e-22,
  -8.741000452699215e-24,  -1.862613899021741e-26,  -4.438809444487384e-03,   7.994984908153822e-05,   2.025200330580127e-07,  -2.901731792824922e-08,   3.743754693203171e-10,
   3.854569896572179e-12,  -1.834587048150985e-13,   1.511474419388328e-15,   3.876243878771295e-17,  -1.112905563594129e-18,   3.872611098743975e-21,   3.221546939248345e-22,
  -6.364692858972669e-24,  -1.376497342621558e-26,  -2.873076433669692e-03,   5.174670934853004e-05,   1.311338882421909e-07,  -1.878100068009468e-08,   2.422583988766762e-10,
   2.495629561144393e-12,  -1.187219765267974e-13,   9.774304557959422e-16,   2.509338173454699e-17,  -7.199484975100845e-19,   2.497252797384224e-21,   2.084947519245613e-22,
  -4.114734869827598e-24,  -8.985586210653915e-27,  -1.541189144837995e-03,   2.775770100279629e-05,   7.035728202923568e-08,  -1.007436354845694e-08,   1.299366031012200e-10,
   1.338912744472855e-12,  -6.367878046596835e-14,   5.240725018336738e-16,   1.346178086931734e-17,  -3.860896392939635e-19,   1.337015237211920e-21,   1.118350930421524e-22,
  -2.205897416611229e-24,  -4.841011578041322e-27,  -5.735179343892473e-04,   1.032932087176665e-05,   2.618362776739559e-08,  -3.748911988087383e-09,   4.835073110071941e-11,
   4.982707519610489e-13,  -2.369572960436794e-14,   1.949897018272932e-16,   5.009629391018172e-18,  -1.436602850258669e-19,   4.972061754586718e-22,   4.161598458948653e-23,
  -8.206991874240790e-25,  -1.804178987784699e-27,  -6.478330100489388e-05,   1.166775756736437e-06,   2.957676030673016e-09,  -4.234681677523788e-10,   5.461551298825342e-12,
   5.628400145064264e-14,  -2.676601161458743e-15,   2.202503038744353e-17,   5.658789974707060e-19,  -1.622729202923112e-20,   5.615732434751811e-23,   4.700832934393688e-24,
  -9.270121247899949e-26,  -2.038445561429472e-28,  -1.308907003963466e-02,   7.839109105514039e-05,   4.228126221009173e-06,  -5.193533422520295e-08,  -1.210335962771741e-09,
   2.578987030386589e-11,   2.889987777156507e-13,  -1.122857467805964e-14,  -4.044443709676646e-17,   4.439146899515968e-18,  -1.170446548437724e-20,  -1.613155496791639e-21,
   1.416317784278222e-23,   5.270984987915799e-25,  -1.245228797225299e-02,   7.457350513846561e-05,   4.022253182969943e-06,  -4.940153663135358e-08,  -1.151336073006258e-09,
   2.452845448056539e-11,   2.749080261728371e-13,  -1.067768003221120e-14,  -3.849264073623616e-17,   4.220599236860033e-18,  -1.110762581148151e-20,  -1.533475055443887e-21,
   1.345091464165170e-23,   5.009979757623005e-25,  -1.124110747358656e-02,   6.731390287485649e-05,   3.630747049355654e-06,  -4.458507768642133e-08,  -1.039163964317785e-09,
   2.213194334680176e-11,   2.481195262104470e-13,  -9.631743773596261e-15,  -3.477377935131536e-17,   3.805966996547562e-18,  -9.983622287609316e-21,  -1.382409581833437e-21,
   1.210566271049970e-23,   4.515403245931664e-25,  -9.574159352981703e-03,   5.732555731411993e-05,   3.092055011847622e-06,  -3.796181887940833e-08,  -8.848737858739966e-10,
   1.883893973778513e-11,   2.112749042537720e-13,  -8.195869743990647e-15,  -2.964299374959734e-17,   3.237346863525379e-18,  -8.458320775256839e-21,  -1.175445531510777e-21,
   1.027254828237021e-23,   3.838325934096369e-25,  -7.614669395240272e-03,   4.558815910121060e-05,   2.458999607541849e-06,  -3.018333808743592e-08,  -7.036232422806973e-10,
   1.497475213222448e-11,   1.679951348217448e-13,  -6.512619318741279e-15,  -2.359601090812571e-17,   2.571512875456353e-18,  -6.692667830195801e-21,  -9.333574084502495e-22,
   8.140881931349615e-24,   3.046983878457797e-25,  -5.554456347691732e-03,   3.325102196245101e-05,   1.793566254982779e-06,  -2.201166698505337e-08,  -5.131648748217826e-10,
   1.091819853556143e-11,   1.225195222505959e-13,  -4.747141475257669e-15,  -1.722356382055890e-17,   1.873851893091520e-18,  -4.861655126820739e-21,  -6.799396132804517e-22,
   5.921150608824967e-24,   2.219207843518011e-25,  -3.595159053804452e-03,   2.152071661132980e-05,   1.160842056436235e-06,  -1.424492639365327e-08,  -3.321121242247405e-10,
   7.064735915943790e-12,   7.929169242557579e-14,  -3.071151236981485e-15,  -1.115304080687308e-17,   1.212044038595955e-18,  -3.138088233584901e-21,  -4.397150711840756e-22,
   3.825181993619855e-24,   1.434948904341053e-25,  -1.928522680431625e-03,   1.154384866606686e-05,   6.226859591108009e-07,  -7.640667060535013e-09,  -1.781420065840494e-10,
   3.789090578709878e-12,   4.253108949079607e-14,  -1.647029077742866e-15,  -5.984105818834355e-18,   6.499416095148858e-19,  -1.680958800822376e-21,  -2.357681276934703e-22,
   2.049896785799110e-24,   7.693395065663445e-26,  -7.176539420600926e-04,   4.295725407462074e-06,   2.317158126605998e-07,  -2.843211830394487e-09,  -6.628998961076765e-11,
   1.409943750279938e-12,   1.582658253195555e-14,  -6.128504280556091e-16,  -2.227020103560871e-18,   2.418311326661286e-19,  -6.252206495624327e-22,  -8.772194901496365e-23,
   7.625595231506035e-25,   2.862398000344440e-26,  -8.106455966875574e-05,   4.852346008833572e-07,   2.617405639824888e-08,  -3.211612990329624e-10,  -7.487942858358170e-12,
   1.592626754131711e-13,   1.787728497575103e-15,  -6.922525436682380e-17,  -2.515623088116636e-19,   2.731617202940632e-20,  -7.061797979315488e-23,  -9.908629051444470e-24,
   8.613231594078600e-26,   3.233207230271477e-27,  -1.302908535686077e-02,  -1.017713212370886e-04,   4.256572664492012e-06,   6.111499842708628e-08,  -1.270568175411950e-09,
  -2.984367420304053e-11,   3.313724661111630e-13,   1.324985370717428e-14,  -6.134490595802945e-17,  -5.534403466600292e-18,  -4.389675424684260e-21,   2.176497721067173e-21,
   1.285270261068663e-23,  -8.124786005011082e-25,  -1.239522013429968e-02,  -9.681569679221982e-05,   4.049305283929650e-06,   5.813349761170905e-08,  -1.208619740864349e-09,
  -2.838382356956239e-11,   3.152033019552849e-13,   1.259947743911440e-14,  -5.836673904367776e-17,  -5.261667300062823e-18,  -4.151222731478514e-21,   2.068759879170814e-21,
   1.220221501763575e-23,  -7.720899204780958e-25,  -1.118958814193776e-02,  -8.739174859132523e-05,   3.655151306080316e-06,   5.246594532487149e-08,  -1.090846830835399e-09,
  -2.561037868298747e-11,   2.844684862995309e-13,   1.136479113654239e-14,  -5.269957857592513e-17,  -4.744335725469453e-18,  -3.707863043212252e-21,   1.864594092826744e-21,
   1.097527988345572e-23,  -6.956208784664747e-25,  -9.530277539559266e-03,  -7.442507995397297e-05,   3.112823258987241e-06,   4.467220425684853e-08,  -9.288626604190744e-10,
  -2.179956140956354e-11,   2.422059046566054e-13,   9.670045101701358e-15,  -4.489488940084498e-17,  -4.035084482087644e-18,  -3.117348811794451e-21,   1.585062151627538e-21,
   9.306576959700118e-24,  -5.910568097177340e-25,  -7.579766850816047e-03,  -5.918726742994036e-05,   2.475504140553426e-06,   3.551893738039364e-08,  -7.385860692494701e-10,
  -1.732790051740037e-11,   1.925742397543492e-13,   7.683635167328731e-15,  -3.571428475980007e-17,  -3.204840965814264e-18,  -2.448015545062986e-21,   1.258319663280186e-21,
   7.370145552884767e-24,  -4.690013522190589e-25,  -5.528995936727795e-03,  -4.317033609128711e-05,   1.805597597700578e-06,   2.590284730099065e-08,  -5.386546523201939e-10,
  -1.263377882801992e-11,   1.404359628276323e-13,   5.600478901975339e-15,  -2.605602827148751e-17,  -2.335158146326917e-18,  -1.767320539139439e-21,   9.164992961394653e-22,
   5.357503286655943e-24,  -3.414711039217856e-25,  -3.578679185769539e-03,  -2.794087061471771e-05,   1.168626109894192e-06,   1.676316504410076e-08,  -3.486047550521996e-10,
  -8.174770321422295e-12,   9.088285014938310e-14,   3.623116229788885e-15,  -1.686687330164808e-17,  -1.510341510623934e-18,  -1.136069384128659e-21,   5.926243172894350e-22,
   3.459744176317775e-24,  -2.207468717536708e-25,  -1.919682392405616e-03,  -1.498770908436163e-05,   6.268605845177101e-07,   8.991408398530269e-09,  -1.869874208612933e-10,
  -4.384431118278491e-12,   4.874736109306978e-14,   1.943015227376514e-15,  -9.048294603410704e-18,  -8.098761949845578e-19,  -6.072549882822333e-22,   3.177354287795883e-22,
   1.853699355966300e-24,  -1.183384487654692e-25,  -7.143642227629914e-04,  -5.577269598154393e-06,   2.332691822142373e-07,   3.345845536572881e-09,  -6.958139376400448e-11,
  -1.631471819843891e-12,   1.813962862818194e-14,   7.229816913522920e-16,  -3.367176817183338e-18,  -3.013367938228551e-19,  -2.256961918784541e-22,   1.182168069496053e-22,
   6.895275055614881e-25,  -4.402712748909736e-26,  -8.069296016156747e-05,  -6.299948020477779e-07,   2.634951937688957e-08,   3.779374348587704e-10,  -7.859728690302518e-12,
  -1.842857360848799e-13,   2.049001493667561e-15,   8.166519954662255e-17,  -3.803498788922193e-19,  -3.403761359373165e-20,  -2.548912293463829e-23,   1.335312762304307e-23,
   7.788239443545308e-26,  -4.973030176291961e-27,  -9.992401465478496e-03,  -2.189588107198467e-04,  -2.111366562351094e-07,   7.720568434571027e-08,   1.369178423562804e-09,
  -6.377448361217108e-12,  -6.290793363564427e-13,  -8.018444288485355e-15,   1.106277476397389e-16,   4.976582818728755e-18,   3.937273638732930e-20,  -1.317430061991546e-21,
  -3.788871209240369e-23,  -1.133698185359890e-25,  -9.506373680708757e-03,  -2.083016996712671e-04,  -2.006233516100779e-07,   7.344846306149255e-08,   1.302300950205040e-09,
  -6.072228292337378e-12,  -5.983883215300855e-13,  -7.623113026379262e-15,   1.052988490099514e-16,   4.732363607300456e-18,   3.738368753124157e-20,  -1.253601488041138e-21,
  -3.601008012389127e-23,  -1.070274521195100e-25,  -8.581891481832513e-03,  -1.880334673697865e-04,  -1.807249161574863e-07,   6.630257829852837e-08,   1.175206373153999e-09,
  -5.489636071702574e-12,  -5.400480334072038e-13,  -6.873310318151393e-15,   9.514138033123462e-17,   4.268707038169219e-18,   3.363044403073622e-20,  -1.132087389043218e-21,
  -3.245123552308850e-23,  -9.530211649634650e-26,  -7.309446224227795e-03,  -1.601420628407506e-04,  -1.535290692398463e-07,   5.646861601916466e-08,   1.000496554870786e-09,
  -4.683836787932761e-12,  -4.598222673583628e-13,  -5.845484336615063e-15,   8.111965699295266e-17,   3.632237533376227e-18,   2.852291542516786e-20,  -9.646367212237063e-22,
  -2.758106042500312e-23,  -7.981804660835378e-26,  -5.813591209732550e-03,  -1.273606163196133e-04,  -1.218013863666743e-07,   4.491000746189761e-08,   7.953923506886319e-10,
  -3.731594927772196e-12,  -3.656034115944462e-13,  -4.642500423304085e-15,   6.458422520091984e-17,   2.886174422878867e-18,   2.259239776124113e-20,  -7.675363913117499e-22,
  -2.189145144089114e-23,  -6.244089117375567e-26,  -4.240750680576052e-03,  -9.289856538542009e-05,  -8.866736787579311e-08,   3.275834859237527e-08,   5.799935686583453e-10,
  -2.725722614534715e-12,  -2.666218861256411e-13,  -3.382543874785939e-15,   4.714963231658372e-17,   2.103724297069394e-18,   1.642530780169823e-20,  -5.600631463615241e-22,
  -1.594224592924125e-23,  -4.493636820849664e-26,  -2.744886606494645e-03,  -6.012769498763237e-05,  -5.731373393468252e-08,   2.120268470288721e-08,   3.753197581145152e-10,
  -1.765841846261004e-12,  -1.725452280333234e-13,  -2.187711499735450e-15,   3.053465996352197e-17,   1.360977473574803e-18,   1.060808864673281e-20,  -3.625854428768295e-22,
  -1.030748372048266e-23,  -2.882460421535669e-26,  -1.472426678289932e-03,  -3.225340327250022e-05,  -3.072319358253454e-08,   1.137348455609991e-08,   2.013063998671137e-10,
  -9.476770680518250e-13,  -9.254947152863099e-14,  -1.173078812725517e-15,   1.638407403987321e-17,   7.298731738087983e-19,   5.683996908943575e-21,  -1.945210133004490e-22,
  -5.526065277825215e-24,  -1.539038561952190e-26,  -5.479297941258516e-04,  -1.200228413938102e-05,  -1.143016690002899e-08,   4.232358908869746e-09,   7.490836750632119e-11,
  -3.527125762264462e-13,  -3.443910496642927e-14,  -4.364741310130239e-16,   6.097540899838273e-18,   2.715809910772281e-19,   2.114333709848980e-21,  -7.238924546693796e-23,
  -2.055992981833693e-24,  -5.717875021480749e-27,  -6.189292600452314e-05,  -1.355749787675324e-06,  -1.291076577565226e-09,   4.780774110773905e-10,   8.461424760635193e-12,
  -3.984263421980914e-14,  -3.890145451418173e-15,  -4.930206368600430e-17,   6.887750668684704e-19,   3.067674208417394e-20,   2.388154431970186e-22,  -8.176976157267743e-24,
  -2.322331098821417e-25,  -6.457116471598939e-28,  -5.202656082377377e-03,  -1.777525244199110e-04,  -3.200109153296719e-06,  -2.483689448789200e-08,   4.489157116301403e-10,
   2.044104183297428e-11,   3.778692838196328e-13,   2.642913517217531e-15,  -6.632518271682850e-17,  -2.711535204035876e-18,  -4.769411852005587e-20,  -2.750467566696855e-22,
   1.012704729846708e-23,   3.675843599498533e-25,  -4.949692195146732e-03,  -1.691087865118120e-04,  -3.044374299588006e-06,  -2.362273760777124e-08,   4.272486007777947e-10,
   1.944841917107377e-11,   3.594340212477326e-13,   2.511456210266900e-15,  -6.316274734823757e-17,  -2.580086792850886e-18,  -4.535421126033757e-20,  -2.608151426024440e-22,
   9.650489877876290e-24,   3.497678365529163e-25,  -4.468487664475551e-03,  -1.526665236291569e-04,  -2.748181677543913e-06,  -2.131574537165151e-08,   3.859668685109821e-10,
   1.755967106002815e-11,   3.243905832256580e-13,   2.262589678873866e-15,  -5.712153279691630e-17,  -2.329875650175814e-18,  -4.091154870607167e-20,  -2.340916070880904e-22,
   8.737488377232242e-24,   3.158523889452962e-25,  -3.806091562190887e-03,  -1.300339530246898e-04,  -2.340570899021720e-06,  -1.814523549598196e-08,   3.290147748075465e-10,
   1.495874032768688e-11,   2.762011563359765e-13,   1.922343113038206e-15,  -4.875632276939009e-17,  -1.985139722908450e-18,  -3.481250719642100e-20,  -1.979820524932757e-22,
   7.468199324601402e-24,   2.691214048864644e-25,  -3.027303446797665e-03,  -1.034255725035513e-04,  -1.861476002147445e-06,  -1.442414559435543e-08,   2.618956832872380e-10,
   1.189953113632962e-11,   2.196065543748863e-13,   1.525257750540984e-15,  -3.885894651959019e-17,  -1.579438402227660e-18,  -2.766266930237343e-20,  -1.563840225177605e-22,
   5.960079391099955e-24,   2.141233379236954e-25,  -2.208348777150239e-03,  -7.544581702015373e-05,  -1.357800759250453e-06,  -1.051721906092371e-08,   1.911659955742889e-10,
   8.681370235966466e-12,   1.601512891641239e-13,   1.110441014026749e-15,  -2.839308832769263e-17,  -1.152451264010267e-18,  -2.016360807893716e-20,  -1.134393125611828e-22,
   4.359477274187254e-24,   1.562378332753537e-25,  -1.429414642525038e-03,  -4.883405274396691e-05,  -8.788297088690814e-07,  -6.805478813872348e-09,   1.237883805307033e-10,
   5.619655165756965e-12,   1.036423588923563e-13,   7.178226538756539e-16,  -1.839803524237038e-17,  -7.460782157103252e-19,  -1.304473744494009e-20,  -7.315328090587622e-23,
   2.826806530170125e-24,   1.011460760767596e-25,  -7.667822721234976e-04,  -2.619600620840173e-05,  -4.714192685189064e-07,  -3.650096198660356e-09,   6.641794563438732e-11,
   3.014666827571865e-12,   5.559146410382905e-14,   3.848030783526121e-16,  -9.874736011307922e-18,  -4.002530965416300e-19,  -6.995750111288558e-21,  -3.916635230906811e-23,
   1.517767220180434e-24,   5.426249528277039e-26,  -2.853414683468058e-04,  -9.748266281704810e-06,  -1.754269232561609e-07,  -1.358230235609409e-09,   2.471782108985547e-11,
   1.121857391992505e-12,   2.068644987842385e-14,   1.431625825583948e-16,  -3.675376962389607e-18,  -1.489499021729211e-19,  -2.603077549551600e-21,  -1.456515493715558e-23,
   5.649830860403677e-25,   2.019321136150562e-26,  -3.223155381239983e-05,  -1.101142817776956e-06,  -1.981581670816215e-08,  -1.534214124352540e-10,   2.792104057228469e-12,
   1.267228342731954e-13,   2.336683755513398e-15,   1.617073319454283e-17,  -4.151752906118346e-19,  -1.682513612791594e-20,  -2.940336988539602e-22,  -1.645073429995965e-24,
   6.382246925079237e-26,   2.280992048856494e-27,  -1.134436538589116e-03,  -4.776885286311198e-05,  -1.300331114110644e-06,  -2.827711566978879e-08,  -5.217935816508282e-10,
  -8.231578141740808e-12,  -1.063413478527206e-13,  -9.238047343747501e-16,   2.318480447423642e-18,   3.451720302046726e-19,   1.011894928358245e-20,   2.140206663334947e-22,
   3.669261538107990e-24,   5.017903041578678e-26,  -1.079295967371679e-03,  -4.544788684608107e-05,  -1.237175773205843e-06,  -2.690415644986002e-08,  -4.964607848519045e-10,
  -7.831766470069016e-12,  -1.011668616981547e-13,  -8.784987212528316e-16,   2.219305326237346e-18,   3.287338191709231e-19,   9.633973299245697e-21,   2.037269145171102e-22,
   3.491982964873190e-24,   4.773265920501764e-26,  -9.743966035797493e-04,  -4.103212045854361e-05,  -1.117009309929717e-06,  -2.429163767125975e-08,  -4.482556689714440e-10,
  -7.071045447087691e-12,  -9.132520449371373e-14,  -7.924721755910321e-16,   2.025150201883393e-18,   2.973240567055863e-19,   8.708565690801656e-21,   1.840997530943132e-22,
   3.154290594681034e-24,   4.308159300108354e-26,  -8.299844453057063e-04,  -3.495234847387354e-05,  -9.515409305630147e-07,  -2.069388428475170e-08,  -3.818696512204491e-10,
  -6.023549329142124e-12,  -7.778089273334624e-14,  -6.743593343235794e-16,   1.747216393768306e-18,   2.538158112683223e-19,   7.429170083897186e-21,   1.569936244830518e-22,
   2.688552297929338e-24,   3.668431643298223e-26,  -6.601790657682620e-04,  -2.780262698478028e-05,  -7.569282073776381e-07,  -1.646202821621821e-08,  -3.037809039891904e-10,
  -4.791570238780244e-12,  -6.186060722243804e-14,  -5.358804871588870e-16,   1.406917137382587e-18,   2.023184800168093e-19,   5.917953338628354e-21,   1.250124549644881e-22,
   2.139852161114128e-24,   2.916952598532360e-26,  -4.815990277732655e-04,  -2.028261395939161e-05,  -5.522135694196606e-07,  -1.201011287301768e-08,  -2.216294311244540e-10,
  -3.495656414962510e-12,  -4.512292247980469e-14,  -3.906219845486425e-16,   1.036435042432537e-18,   1.478439647715405e-19,   4.322250803901683e-21,   9.127732340387929e-23,
   1.561806864771657e-24,   2.127340462841964e-26,  -3.117340110416472e-04,  -1.312900819677429e-05,  -3.574575813167675e-07,  -7.774492224870898e-09,  -1.434678190207652e-10,
  -2.262794784718615e-12,  -2.920577874508571e-14,  -2.527164599899931e-16,   6.751925121721981e-19,   9.580615874100024e-20,   2.799937276798808e-21,   5.911751125612375e-23,
   1.011278540140606e-24,   1.376759963634683e-26,  -1.672253623720453e-04,  -7.042951688010448e-06,  -1.917574084576344e-07,  -4.170647902895734e-09,  -7.696390188721162e-11,
  -1.213870300203295e-12,  -1.566653165816938e-14,  -1.355306498689536e-16,   3.633877906015288e-19,   5.142372169557887e-20,   1.502590562840786e-21,   3.172231008133481e-23,
   5.425790974029883e-25,   7.384758301680269e-27,  -6.222951388459620e-05,  -2.620901224427850e-06,  -7.135916901087658e-08,  -1.552038537832711e-09,  -2.864088472219328e-11,
  -4.517204324473674e-13,  -5.829915862583484e-15,  -5.043036383539590e-17,   1.353815463002382e-19,   1.914015694712658e-20,   5.592366256450626e-22,   1.180604814257370e-23,
   2.019217822079822e-25,   2.747999396749490e-27,  -7.029314695842541e-06,  -2.960516588308027e-07,  -8.060591215819762e-09,  -1.753153029915495e-10,  -3.235219973339720e-12,
  -5.102544714184643e-14,  -6.585338412992786e-16,  -5.696424976899732e-18,   1.529517780780109e-20,   2.162101075470601e-21,   6.317159092824253e-23,   1.333608468989289e-24,
   2.280887421860652e-26,   3.104066393030338e-28,  -2.636028445920021e-04,   9.322559469744265e-06,  -2.185079743968207e-07,   4.231237167420129e-09,  -7.301278585945808e-11,
   1.160444727081093e-12,  -1.730810994337753e-14,   2.439287212785081e-16,  -3.270005011083489e-18,   4.136712146666126e-20,  -4.979115339791002e-22,   5.414154973328806e-24,
  -5.453137142919914e-26,   4.934733537353820e-28,  -2.507876307527434e-04,   8.869485150184238e-06,  -2.078927173594669e-07,   4.025773864933337e-09,  -6.946914885274681e-11,
   1.104152813488278e-12,  -1.646896366564406e-14,   2.321082831163364e-16,  -3.111617891591665e-18,   3.936387496106815e-20,  -4.737998968651558e-22,   5.151954162527182e-24,
  -5.187392954699221e-26,   4.695560115265546e-28,  -2.264089978573363e-04,   8.007532969392750e-06,  -1.876959992947052e-07,   3.634819088381688e-09,  -6.272561100198828e-11,
   9.970172862956511e-13,  -1.487170543730861e-14,   2.096064669443487e-16,  -2.810076785799810e-18,   3.554987357523941e-20,  -4.278933570345352e-22,   4.652753273254040e-24,
  -4.682121149443267e-26,   4.240261660098181e-28,  -1.928495541602437e-04,   6.820859683587347e-06,  -1.598873247819483e-07,   3.096443808110906e-09,  -5.343783804784010e-11,
   8.494377388973522e-13,  -1.267112062296312e-14,   1.786004471877712e-16,  -2.394515603101310e-18,   3.029336809835485e-20,  -3.646241327401960e-22,   3.964759725957721e-24,
  -3.987069362974325e-26,   3.612908481718307e-28,  -1.533915617548827e-04,   5.425464401799843e-06,  -1.271832545531525e-07,   2.463201035688639e-09,  -4.251169486290092e-11,
   6.757954235475980e-13,  -1.008145832479467e-14,   1.421064502674243e-16,  -1.905328645372562e-18,   2.410513151153942e-20,  -2.901400111313803e-22,   3.154831950701831e-24,
  -3.170487682483233e-26,   2.874563969913999e-28,  -1.118969114951121e-04,   3.957907230919158e-06,  -9.278402398411089e-08,   1.797048709888973e-09,  -3.101607547550686e-11,
   4.930751630699373e-13,  -7.355989236669460e-15,   1.036931269496199e-16,  -1.390346239481941e-18,   1.759018464818037e-20,  -2.117233106386299e-22,   2.302157497999019e-24,
  -2.312350141330583e-26,   2.097456141598674e-28,  -7.242890395422569e-05,   2.561930798212140e-06,  -6.005990209738483e-08,   1.163274783483384e-09,  -2.007804809264576e-11,
   3.191983421084905e-13,  -4.762134931311315e-15,   6.713094701023456e-17,  -9.001335008634881e-19,   1.138831639416014e-20,  -1.370748815186568e-22,   1.490468393993375e-24,
  -1.496540621051655e-26,   1.357858544145246e-28,  -3.885325607333684e-05,   1.374317241663772e-06,  -3.221878560974981e-08,   6.240401532703188e-10,  -1.077104811976061e-11,
   1.712394025903692e-13,  -2.554768228056258e-15,   3.601462054943519e-17,  -4.829128068331693e-19,   6.109757522612553e-21,  -7.353978574296317e-23,   7.996252655126541e-25,
  -8.027378881053249e-27,   7.284580314867468e-29,  -1.445841979245587e-05,   5.114248534091973e-07,  -1.198962839950443e-08,   2.322261197906193e-10,  -4.008285743726169e-12,
   6.372454004583578e-14,  -9.507292493773607e-16,   1.340251712473713e-17,  -1.797124826850090e-19,   2.273706581327506e-21,  -2.736735423249281e-23,   2.975751789476215e-25,
  -2.987147305255405e-27,   2.710877545772435e-29,  -1.633192109384432e-06,   5.776948531865366e-08,  -1.354324282276907e-09,   2.623181382069558e-11,  -4.527685735977390e-13,
   7.198212693745285e-15,  -1.073928066928997e-16,   1.513927416734002e-18,  -2.030005634781832e-20,   2.568346204959850e-22,  -3.091376925540183e-24,   3.361366054784594e-26,
  -3.374204584177504e-28,   3.062162528548584e-30,  -2.272139220851298e-03,   7.449412065589770e-05,  -1.521391667002653e-06,   2.325701184998897e-08,  -2.637753925360823e-10,
   1.618914151671687e-12,   1.686629264351238e-14,  -7.922108990546795e-16,   1.639648404406313e-17,  -2.431715368670883e-19,   2.477610957135870e-21,  -9.886570654390130e-24,
  -3.346600212431420e-25,   1.118305696657155e-26,  -2.161666920038474e-03,   7.087277727072274e-05,  -1.447437708196510e-06,   2.212626289969454e-08,  -2.509376965863863e-10,
   1.539673806478715e-12,   1.605957861428689e-14,  -7.539378698449255e-16,   1.560226290446391e-17,  -2.313595087397566e-19,   2.356437428488957e-21,  -9.379613194933739e-24,
  -3.188345374503044e-25,   1.064931061085181e-26,  -1.951517706791487e-03,   6.398372942122659e-05,  -1.306749800845123e-06,   1.997525537673020e-08,  -2.265220177015429e-10,
   1.389151014006834e-12,   1.451956586668684e-14,  -6.810324393112063e-16,   1.409021825850834e-17,  -2.088851678913357e-19,   2.126219395849268e-21,  -8.425886647910798e-24,
  -2.885491933613523e-25,   9.629906707362567e-27,  -1.662236431069551e-03,   5.450013315142600e-05,  -1.113072441015615e-06,   1.701426921637829e-08,  -1.929226793491408e-10,
   1.182364695269462e-12,   1.238915243818993e-14,  -5.804815545436586e-16,   1.200645822961412e-17,  -1.779392918977077e-19,   1.809871753209370e-21,  -7.133709491025581e-24,
  -2.465088075291742e-25,   8.218767050779551e-27,  -1.322120701884515e-03,   4.334942676686855e-05,  -8.853441273152166e-07,   1.353294263920398e-08,  -1.534318467434905e-10,
   9.397675229850473e-13,   9.871064343371504e-15,  -4.620171372379133e-16,   9.553550325416843e-18,  -1.415443725040623e-19,   1.438643318023883e-21,  -5.640683886827051e-24,
  -1.966358193678638e-25,   6.549699283562632e-27,  -9.644597177274149e-04,   3.162294969894244e-05,  -6.458526589285057e-07,   9.872013290300214e-09,  -1.119157876242034e-10,
   6.851473715738799e-13,   7.210669027347680e-15,  -3.372140332949892e-16,   6.971334000112831e-18,  -1.032617831425967e-19,   1.048928247285078e-21,  -4.095130866087665e-24,
  -1.437746235174816e-25,   4.785267609126072e-27,  -6.242743624480845e-04,   2.046905383632557e-05,  -4.180520687650417e-07,   6.389950101476562e-09,  -7.243662489032626e-11,
   4.433130068538841e-13,   4.671561839939813e-15,  -2.183493856671758e-16,   4.513344686045167e-18,  -6.684261459392344e-20,   6.787211441440391e-22,  -2.642288918937090e-24,
  -9.320471518212257e-26,   3.100563851180663e-27,  -3.348804316531982e-04,   1.098029695309858e-05,  -2.242577609009208e-07,   3.427771833447247e-09,  -3.885615867162642e-11,
   2.377606671829296e-13,   2.507143364070599e-15,  -1.171509425008368e-16,   2.421361287319066e-18,  -3.585743172306634e-20,   3.640245759921076e-22,  -1.415091218957431e-24,
  -5.003719888197244e-26,   1.664110607455414e-27,  -1.246185661937069e-04,   4.086088577305897e-06,  -8.345290272139810e-08,   1.275571900021148e-09,  -1.445933941815831e-11,
   8.847152066673850e-14,   9.331312048037504e-16,  -4.359798805268459e-17,   9.010914482094310e-19,  -1.334369636926107e-20,   1.354557945881184e-22,  -5.262958233045654e-25,
  -1.862535480608578e-26,   6.193757752031626e-28,  -1.407664391489022e-05,   4.615558550506505e-07,  -9.426662932175369e-09,   1.440858481620050e-10,  -1.633293111045575e-12,
   9.993444053709603e-15,   1.054072017517566e-16,  -4.924784317720894e-18,   1.017859485424686e-19,  -1.507277301572030e-21,   1.530064790151909e-23,  -5.944386089503999e-26,
  -2.103970978712423e-27,   6.996536941644321e-29,  -5.759551551553596e-03,   1.586215783430468e-04,  -2.188511096228394e-06,   8.003656258308232e-09,   3.945393762822996e-10,
  -1.098690257815213e-11,   1.413843756744608e-13,  -2.394470121170419e-16,  -3.302123660253379e-17,   8.074420907677682e-19,  -9.421344198607667e-21,  -1.189818930583990e-23,
   2.797908947425448e-24,  -5.979310537079122e-26,  -5.479470024952969e-03,   1.509068800222435e-04,  -2.081990662997071e-06,   7.611088932892986e-09,   3.754117955304717e-10,
  -1.045264143527321e-11,   1.344798329850691e-13,  -2.269361880290849e-16,  -3.142763203749719e-17,   7.681470583056977e-19,  -8.957575701649916e-21,  -1.145790525140810e-23,
   2.663723046346069e-24,  -5.686946639439167e-26,  -4.946696897258917e-03,   1.362323638137910e-04,  -1.879405410469357e-06,   6.865709243368196e-09,   3.390033742354206e-10,
  -9.436356497526646e-12,   1.213577995199180e-13,  -2.034904048194223e-16,  -2.839130110258560e-17,   6.934115979539723e-19,  -8.077670435166334e-21,  -1.056411415484199e-23,
   2.407708344218461e-24,  -5.131453831423481e-26,  -4.213346400332986e-03,   1.160340670152942e-04,  -1.600626300795544e-06,   5.842356570859879e-09,   2.888418600868624e-10,
  -8.037444962979133e-12,   1.033185753473602e-13,  -1.719010121059817e-16,  -2.420224264472220e-17,   5.905631392564886e-19,  -6.870923024104423e-21,  -9.224761735313562e-24,
   2.053829413520198e-24,  -4.368083370151687e-26,  -3.351176380461563e-03,   9.228883928526548e-05,  -1.272972172184207e-06,   4.642592508644705e-09,   2.298106725967521e-10,
  -6.392780970277083e-12,   8.213969484164259e-14,  -1.356274483758465e-16,  -1.926518250725877e-17,   4.696783529067267e-19,  -5.457806125436909e-21,  -7.512152114240731e-24,
   1.635920021288081e-24,  -3.472213655898725e-26,  -2.444576750257286e-03,   6.732097179622342e-05,  -9.285218702871191e-07,   3.384124948334189e-09,   1.676830840982638e-10,
  -4.663344879896980e-12,   5.989656341319552e-14,  -9.829087474791778e-17,  -1.406238428098866e-17,   3.425924219998389e-19,  -3.977102400877476e-21,  -5.582701403898327e-24,
   1.194737593567038e-24,  -2.531670093253526e-26,  -1.582306907136387e-03,   4.357465809134050e-05,  -6.009761929020482e-07,   2.189381713374151e-09,   1.085552214010760e-10,
  -3.018460052048275e-12,   3.876008959665233e-14,  -6.334509168694763e-17,  -9.106058941018310e-18,   2.217406888927113e-19,  -2.572473660529208e-21,  -3.657495608372496e-24,
   7.739126156967851e-25,  -1.638166039482707e-26,  -8.487948892983680e-04,   2.337460366562369e-05,  -3.223725424348229e-07,   1.174152840685120e-09,   5.823726305977326e-11,
  -1.619190304873665e-12,   2.078946361587408e-14,  -3.390413201356444e-17,  -4.885816474641952e-18,   1.189453367040055e-19,  -1.379454216120269e-21,  -1.974096059477485e-24,
   4.153119333865061e-25,  -8.786175843366142e-27,  -3.158602363643396e-04,   8.698329232939431e-06,  -1.199627261658390e-07,   4.368968651399166e-10,   2.167237233331289e-11,
  -6.025460496225461e-13,   7.736006986879294e-15,  -1.260682957448582e-17,  -1.818286386285838e-18,   4.426251957887075e-20,  -5.132692951926546e-22,  -7.361846137892500e-25,
   1.545702472344706e-25,  -3.269397235150584e-27,  -3.567887951156830e-05,   9.825439712968517e-07,  -1.355070703036593e-08,   4.935022808825466e-11,   2.448075537390606e-12,
  -6.806228386770374e-14,   8.738364325385509e-16,  -1.423863385300100e-18,  -2.053921137291316e-19,   4.999790753125716e-21,  -5.797662536080109e-23,  -8.318591284263401e-26,
   1.746029429701478e-26,  -3.693006476943028e-28,  -9.702740346131361e-03,   1.892144588014237e-04,  -2.558935082628834e-07,  -5.333128213482844e-08,   9.707036490872177e-10,
   1.224322908060203e-13,  -3.050893699332800e-13,   5.114388051136157e-15,   9.310864769758228e-18,  -1.798489590138688e-18,   2.750366001728032e-20,   9.998961671034473e-23,
  -1.077303432216454e-23,   1.542118678859105e-25,  -9.230803208674896e-03,   1.800062486060497e-04,  -2.432739426848664e-07,  -5.073718478765943e-08,   9.233522797435684e-10,
   1.196611374644412e-13,  -2.902417620358873e-13,   4.863698799068720e-15,   8.894604623678154e-18,  -1.710843565305797e-18,   2.614476739707855e-20,   9.548112919790675e-23,
  -1.024607740860448e-23,   1.465222177537876e-25,  -8.333122433335774e-03,   1.624931252599222e-04,  -2.193403785113248e-07,  -4.580293588131560e-08,   8.333399142757706e-10,
   1.130943036707156e-13,  -2.620031267957682e-13,   4.387641648547460e-15,   8.087906192850018e-18,  -1.544197951257798e-18,   2.356858639017891e-20,   8.676056439113226e-23,
  -9.244935510051218e-24,   1.319723940058223e-25,  -7.097565042439932e-03,   1.383921