//
// BAGEL - Brilliantly Advanced General Electronic Structure Library
// Filename: _complex_eriroot_2.cc
// Copyright (C) 2013 Toru Shiozaki
//
// Author: Ryan D. Reynolds <RyanDReynolds@u.northwestern.edu>
// Maintainer: Shiozaki group
//
// This file is part of the BAGEL package.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

#include <algorithm>
#include <complex>
#include "comperirootlist.h"

using namespace std;
using namespace bagel;

void ComplexERIRootList::complex_eriroot2(const complex<double>* ta, complex<double>* rr, complex<double>* ww, const int n) {

  static constexpr double ax[2] = {2.752551286084111e-01,2.724744871391588e+00};
  static constexpr double aw[2] = {8.049140900055123e-01,8.131283544724531e-02};
  static constexpr double xr[4840] = {   2.847856012242962e-01,  -2.929614680264552e-02,   1.843738710047808e-03,  -6.721284273593050e-05,  -5.298861369899153e-07,
   2.502677483453836e-07,  -1.539166905532855e-08,   2.409390141112788e-10,   3.459184940845356e-11,  -3.239261381672435e-12,   1.078114202666287e-13,   3.469898103947347e-15,
  -6.081654502693700e-16,   3.117673695903706e-17,   2.849576197729302e-01,  -2.931421484705055e-02,   1.843325681938220e-03,  -6.697574843599378e-05,  -5.503681751858326e-07,
   2.505801823501796e-07,  -1.529418989546419e-08,   2.306632581795649e-10,   3.493187298155383e-11,  -3.214990967788365e-12,   1.042117400768757e-13,   3.642496476806585e-15,
  -6.052364691685843e-16,   3.017493077716421e-17,   2.852611043104009e-01,  -2.934604161505941e-02,   1.842587798209738e-03,  -6.655720297946663e-05,  -5.863951272698490e-07,
   2.511153646324434e-07,  -1.512152986912071e-08,   2.126026092928241e-10,   3.551966573244137e-11,  -3.171498720679311e-12,   9.787930117518800e-14,   3.941074446537364e-15,
  -5.996529608759767e-16,   2.840520143899807e-17,   2.856280040778477e-01,  -2.938443380288318e-02,   1.841680080206469e-03,  -6.605077958772001e-05,  -6.297645810040843e-07,
   2.517351212548936e-07,  -1.491164573377892e-08,   1.908858677865899e-10,   3.620970744796429e-11,  -3.117787770433921e-12,   9.025624593648767e-14,   4.291930272407295e-15,
  -5.922036440282250e-16,   2.626279224386202e-17,   2.859841028713102e-01,  -2.942160678236718e-02,   1.840782739345485e-03,  -6.555883443615214e-05,  -6.716623965378133e-07,
   2.523081908771140e-07,  -1.470676251557376e-08,   1.699332870791009e-10,   3.685795398622666e-11,  -3.064495495616017e-12,   8.289345349305532e-14,   4.621867829004340e-15,
  -5.842547037179989e-16,   2.418172013132601e-17,   2.862709129057184e-01,  -2.945148298554886e-02,   1.840048319183218e-03,  -6.516230927161039e-05,  -7.052677996240204e-07,
   2.527494456598499e-07,  -1.454091645099718e-08,   1.531480965879441e-10,   3.736472120253815e-11,  -3.020754941011217e-12,   7.699018022847516e-14,   4.880020968740168e-15,
  -5.773466573834009e-16,   2.250523234413428e-17,   2.864604030601061e-01,  -2.947119043521351e-02,   1.839557393410337e-03,  -6.490018748497254e-05,  -7.274015464443950e-07,
   2.530310594954628e-07,  -1.443094552562044e-08,   1.421031490867910e-10,   3.769203860208677e-11,  -2.991462079494210e-12,   7.310363814206023e-14,   5.046864841132127e-15,
  -5.725387602808685e-16,   2.139779610658601e-17,   2.865577063798161e-01,  -2.948130057179226e-02,   1.839303540015532e-03,  -6.476554355713412e-05,  -7.387459510295059e-07,
   2.531726080906290e-07,  -1.437435316197094e-08,   1.364454792966383e-10,   3.785780267521271e-11,  -2.976299544162161e-12,   7.111221643597649e-14,   5.131391273403137e-15,
  -5.699952860645489e-16,   2.082926076448406e-17,   2.865915722649547e-01,  -2.948481781268717e-02,   1.839214907336590e-03,  -6.471867449077839e-05,  -7.426909163780637e-07,
   2.532213866345840e-07,  -1.435463716025046e-08,   1.344785819829455e-10,   3.791512798322361e-11,  -2.971003218154656e-12,   7.041980979719927e-14,   5.160627503398031e-15,
  -5.690982366437254e-16,   2.063141316961670e-17,   2.865969462467448e-01,  -2.948537587039559e-02,   1.839200829421332e-03,  -6.471123677852953e-05,  -7.433167590503995e-07,
   2.532291039272944e-07,  -1.435150762594923e-08,   1.341665721190048e-10,   3.792420714426725e-11,  -2.970161870877520e-12,   7.030996904167346e-14,   5.165258157898618e-15,
  -5.689553299732022e-16,   2.060001934121134e-17,   1.559737756474515e+00,  -3.577841664064815e-02,  -1.652022232844268e-03,  -2.876344054247098e-05,   2.648104674621212e-06,
   2.307696279894238e-07,   4.640456578350340e-09,  -4.169976012801039e-10,  -3.817217166819128e-11,  -8.593744568376158e-13,   7.343436901711422e-14,   6.690202685181194e-15,
   1.494903670458626e-16,  -1.249940429867310e-17,   1.559585930720011e+00,  -3.578577127013480e-02,  -1.650502603127368e-03,  -2.855429420640671e-05,   2.653535903098516e-06,
   2.299167318448929e-07,   4.547015620641902e-09,  -4.191133828539940e-10,  -3.784682812634167e-11,  -8.286919046683942e-13,   7.397575950975978e-14,   6.592924267210571e-15,
   1.409390333359214e-16,  -1.262870328257225e-17,   1.559318150924194e+00,  -3.579870207081341e-02,  -1.647818962707670e-03,  -2.818591144100329e-05,   2.663015239825374e-06,
   2.284087761120673e-07,   4.382840347474248e-09,  -4.227653447781100e-10,  -3.727122616700163e-11,  -7.749647944387753e-13,   7.489010014401988e-14,   6.420718490468014e-15,
   1.260365657862442e-16,  -1.284088319319921e-17,   1.558994551943804e+00,  -3.581425885219174e-02,  -1.644570105436475e-03,  -2.774158448614685e-05,   2.674300723649023e-06,
   2.265802994384334e-07,   4.185518035241912e-09,  -4.270433776806068e-10,  -3.657268970604431e-11,  -7.107024205775283e-13,   7.592655027899329e-14,   6.211598795908057e-15,
   1.083348233917302e-16,  -1.307060125841139e-17,   1.558680620545842e+00,  -3.582927821884414e-02,  -1.641412262630230e-03,  -2.731141982436648e-05,   2.685071799792245e-06,
   2.248000778841456e-07,   3.995220127160446e-09,  -4.310529465434151e-10,  -3.589204972253954e-11,  -6.490574385906443e-13,   7.686109723898904e-14,   6.007739064410555e-15,
   9.148433073045418e-17,  -1.326597112149068e-17,   1.558427874093365e+00,  -3.584131833186167e-02,  -1.638865573387646e-03,  -2.696573161208468e-05,   2.693617019412689e-06,
   2.233623290415976e-07,   3.842822407531125e-09,  -4.341809101784272e-10,  -3.534201712644189e-11,  -5.999281203634055e-13,   7.756322136095253e-14,   5.842958003636814e-15,
   7.814945933384204e-17,  -1.340389744966612e-17,   1.558260938482212e+00,  -3.584924523083091e-02,  -1.637181420549277e-03,  -2.673772211359968e-05,   2.699199208370762e-06,
   2.224105461701782e-07,   3.742563860425938e-09,  -4.361981098374055e-10,  -3.497775736083129e-11,  -5.677247480585564e-13,   7.800256619286511e-14,   5.733824029307311e-15,
   6.945546647168138e-17,  -1.348564537411016e-17,   1.558175232178406e+00,  -3.585330711450858e-02,  -1.636316113650937e-03,  -2.662075680442627e-05,   2.702046074918636e-06,
   2.219212273662362e-07,   3.691213477923282e-09,  -4.372187279338623e-10,  -3.479044966568241e-11,  -5.512673841328814e-13,   7.822063112911235e-14,   5.677705934870419e-15,
   6.502702716734394e-17,  -1.352475174580616e-17,   1.558145404995722e+00,  -3.585471946488698e-02,  -1.636014869992939e-03,  -2.658006642019062e-05,   2.703033795856916e-06,
   2.217508312461660e-07,   3.673362357437050e-09,  -4.375715313663605e-10,  -3.472521746264382e-11,  -5.455520873832370e-13,   7.829533157624887e-14,   5.658162371762075e-15,
   6.349145546010945e-17,  -1.353790796025879e-17,   1.558140672007386e+00,  -3.585494351778559e-02,  -1.635967063660088e-03,  -2.657361038822242e-05,   2.703190383769611e-06,
   2.217237877418475e-07,   3.670530668003254e-09,  -4.376274010644089e-10,  -3.471486421686591e-11,  -5.446457581615157e-13,   7.830712867565045e-14,   5.655060556517975e-15,
   6.324805614015618e-17,  -1.353997411705764e-17,   1.921467006418030e-01,  -1.764990138376525e-02,   1.095768881092779e-03,  -5.224928409998822e-05,   1.629885628317447e-06,
   9.846950927536192e-09,  -4.658824919953757e-09,   2.996193232033453e-10,  -1.092708387060427e-11,   3.601445475266558e-14,   2.748281660122140e-14,  -1.966866499332965e-15,
   7.176885988868580e-17,  -6.485605222063012e-19,   1.922511902015827e-01,  -1.766454549433846e-02,   1.096646836190054e-03,  -5.223512032245545e-05,   1.623030727261632e-06,
   1.043403067315011e-08,  -4.684841479387921e-09,   2.994802762000073e-10,  -1.079959582153267e-11,   2.599348365624960e-14,   2.785354663185040e-14,  -1.964819130293384e-15,
   7.022638617986351e-17,  -5.247313812271438e-19,   1.924356258815582e-01,  -1.769038116295692e-02,   1.098192797013554e-03,  -5.220968173485873e-05,   1.610906465867236e-06,
   1.146959145576655e-08,  -4.730469227181402e-09,   2.992075424330110e-10,  -1.057343534308038e-11,   8.326824551525728e-15,   2.849964102134624e-14,  -1.960477449529261e-15,
   6.747659353913272e-17,  -3.067170874070943e-19,   1.926587533668697e-01,  -1.772161487791905e-02,   1.100056716437074e-03,  -5.217816026042317e-05,   1.596196999403480e-06,
   1.272117480468195e-08,  -4.785165578334355e-09,   2.988310968165256e-10,  -1.029792303572755e-11,  -1.300737626036986e-14,   2.926706217257470e-14,  -1.953986804432919e-15,
   6.410438819274228e-17,  -4.398596493272702e-20,   1.928754723257801e-01,  -1.775192855476164e-02,   1.101860435094877e-03,  -5.214676332050556e-05,   1.581866611826478e-06,
   1.393549468113409e-08,  -4.837761974729068e-09,   2.984168454076028e-10,  -1.002835254159507e-11,  -3.368574174145414e-14,   2.999744868091882e-14,  -1.946389936500574e-15,
   6.078231228890606e-17,   2.100453846408998e-19,   1.930501374256682e-01,  -1.777634344178024e-02,   1.103309365600452e-03,  -5.212089994797744e-05,   1.570286118748264e-06,
   1.491320974552311e-08,  -4.879771856234260e-09,   2.980481986006147e-10,  -9.809697341873832e-12,  -5.031880832157149e-14,   3.057528778762488e-14,  -1.939343981487343e-15,
   5.807209250063143e-17,   4.138951692556038e-19,   1.931655916885314e-01,  -1.779247368675851e-02,   1.104264771862476e-03,  -5.210353070525363e-05,   1.562616331860425e-06,
   1.555899843884579e-08,  -4.907353836760093e-09,   2.977875156544173e-10,  -9.664490145309262e-12,  -6.129657432276169e-14,   3.095191543354988e-14,  -1.934235776595111e-15,
   5.626485665718283e-17,   5.481817935982673e-19,   1.932248949239088e-01,  -1.780075650596876e-02,   1.104754792964646e-03,  -5.209452444842897e-05,   1.558672102723450e-06,
   1.589055664231605e-08,  -4.921463513396630e-09,   2.976483613805034e-10,  -9.589697006649460e-12,  -6.692998113965784e-14,   3.114371738398217e-14,  -1.931472800281664e-15,
   5.533175084711396e-17,   6.170112281121611e-19,   1.932455378588213e-01,  -1.780363928389191e-02,   1.104925249622105e-03,  -5.209137599800788e-05,   1.557298415284849e-06,
   1.600594474360624e-08,  -4.926365749779078e-09,   2.975990870122609e-10,  -9.563629316285938e-12,  -6.889005690532246e-14,   3.121021819943876e-14,  -1.930488906427466e-15,
   5.500618350556309e-17,   6.409462765618727e-19,   1.932488136985027e-01,  -1.780409673471507e-02,   1.104952294013025e-03,  -5.209087573003176e-05,   1.557080389099086e-06,
   1.602425458837945e-08,  -4.927143250810187e-09,   2.975912279561245e-10,  -9.559491061992381e-12,  -6.920106122011268e-14,   3.122075872130889e-14,  -1.930331721846333e-15,
   5.495448299272016e-17,   6.447434011319880e-19,   1.389498123564031e+00,  -4.929500463164663e-02,  -1.588058198172523e-03,   5.007617361501194e-05,   6.717335115112470e-06,
   6.997284387391441e-08,  -2.149334865917146e-08,  -1.034878249630107e-09,   4.175355689674813e-11,   5.458299321098096e-12,   4.366169193043585e-14,  -1.924659174282499e-14,
  -8.870204556748319e-16,   4.082538978087921e-17,   1.389356498663164e+00,  -4.928074472641147e-02,  -1.584442219540661e-03,   5.012700627644967e-05,   6.688417656050413e-06,
   6.818771965173678e-08,  -2.138284216948034e-08,  -1.018707139501332e-09,   4.181445462547042e-11,   5.370267778468159e-12,   3.961246049684275e-14,  -1.895671556085793e-14,
  -8.544273804620071e-16,   4.072693986221399e-17,   1.389106855838178e+00,  -4.925557374929892e-02,  -1.578074684207359e-03,   5.021541653099313e-05,   6.637518889714979e-06,
   6.506263504491663e-08,  -2.118779291148865e-08,  -9.904063097672787e-10,   4.190923908801115e-11,   5.216138285261069e-12,   3.261986015126796e-14,  -1.844635637904115e-14,
  -7.979814301153026e-16,   4.051124072118215e-17,   1.388805421871056e+00,  -4.922512131354803e-02,  -1.570396975401853e-03,   5.032014487761227e-05,   6.576187327730472e-06,
   6.132577822882539e-08,  -2.095185429534287e-08,  -9.565802774849160e-10,   4.200259071844080e-11,   5.031811359405773e-12,   2.442053235663135e-14,  -1.783130818252198e-14,
  -7.315205186995943e-16,   4.018118694169110e-17,   1.388513251621999e+00,  -4.919554269603570e-02,  -1.562966558350868e-03,   5.041954799131577e-05,   6.516873654450588e-06,
   5.774179823721772e-08,  -2.072274411969157e-08,  -9.241539940264439e-10,   4.207138003373906e-11,   4.855009328782978e-12,   1.672458090933780e-14,  -1.723660280398406e-14,
  -6.688524720943734e-16,   3.979122922283565e-17,   1.388278209686436e+00,  -4.917170330046188e-02,  -1.556997133107745e-03,   5.049801375652773e-05,   6.469253209419515e-06,
   5.488567661794101e-08,  -2.053814451651364e-08,  -8.983245869041121e-10,   4.211145177461471e-11,   4.714108775009261e-12,   1.071072190408059e-14,  -1.675934659164660e-14,
  -6.196747381678593e-16,   3.942928715340512e-17,   1.388123057859408e+00,  -4.915594521080942e-02,  -1.553060669561644e-03,   5.054907764501437e-05,   6.437865721689695e-06,
   5.301353370078212e-08,  -2.041615505379024e-08,  -8.813995193380436e-10,   4.213053765043751e-11,   4.621751101039980e-12,   6.826643791278989e-15,  -1.644493185887722e-14,
  -5.878110191687168e-16,   3.916752387157463e-17,   1.388043429312587e+00,  -4.914785100858644e-02,  -1.551041586324003e-03,   5.057505960126821e-05,   6.421771253305426e-06,
   5.205675930512054e-08,  -2.035350601889858e-08,  -8.727515979491396e-10,   4.213807823562072e-11,   4.574551636405015e-12,   4.859482760028739e-15,  -1.628376862875676e-14,
  -5.716412858199298e-16,   3.902627590553144e-17,   1.388015721718424e+00,  -4.914503348285947e-02,  -1.550339220323571e-03,   5.058406444874879e-05,   6.416173327801769e-06,
   5.172448550164898e-08,  -2.033170030545562e-08,  -8.697485850031344e-10,   4.214034510895860e-11,   4.558160112346291e-12,   4.179148818791794e-15,  -1.622772359202961e-14,
  -5.660439699768881e-16,   3.897604237254885e-17,   1.388011325277442e+00,  -4.914458636779725e-02,  -1.550227783230901e-03,   5.058549157225043e-05,   6.415285199338763e-06,
   5.167179333505810e-08,  -2.032824003452745e-08,  -8.692723790365386e-10,   4.214068789479121e-11,   4.555560743956222e-12,   4.071395441261535e-15,  -1.621883237591090e-14,
  -5.651572078779030e-16,   3.896802046318735e-17,   1.357184131711957e-01,  -1.096140823865120e-02,   6.182820347037142e-04,  -2.846590151983193e-05,   1.206158724171596e-06,
  -3.522504363043796e-08,  -1.794379512651070e-10,   6.476604575721241e-11,  -3.215380854468940e-12,   1.765697122060167e-13,  -7.340047995263235e-15,  -1.012718690150123e-16,
   1.684196702986523e-17,  -1.789463355870400e-19,   1.357777347018280e-01,  -1.096952623450745e-02,   6.189584085654806e-04,  -2.849776665816936e-05,   1.205799172147818e-06,
  -3.508835682696708e-08,  -1.884331320425403e-10,   6.534549473714990e-11,  -3.242776064273051e-12,   1.759529829546530e-13,  -7.229903379686023e-15,  -1.035567488126452e-16,
   1.697320352003190e-17,  -1.975721132650416e-19,   1.358824597533057e-01,  -1.098385764732149e-02,   6.201516908917387e-04,  -2.855388620135587e-05,   1.205154239162335e-06,
  -3.484625164502713e-08,  -2.043615540514340e-10,   6.636617646112581e-11,  -3.290732442560657e-12,   1.748542200362959e-13,  -7.034915124873732e-15,  -1.076905269980554e-16,
   1.720260980777382e-17,  -2.297920617991346e-19,   1.360091818222176e-01,  -1.100119940166943e-02,   6.215942933039586e-04,  -2.862156364248195e-05,   1.204356437133643e-06,
  -3.455193021476737e-08,  -2.237177763129167e-10,   6.759736511724027e-11,  -3.348067469749914e-12,   1.735073425477244e-13,  -6.798055595815013e-15,  -1.128605900270089e-16,
   1.747633596975232e-17,  -2.676576953617984e-19,   1.361322929374160e-01,  -1.101804707997359e-02,   6.229943996707697e-04,  -2.868707158325524e-05,   1.203563101781802e-06,
  -3.426457150701408e-08,  -2.426076462110073e-10,   6.878938116397943e-11,  -3.403040250962443e-12,   1.721803622095372e-13,  -6.566997362653667e-15,  -1.180558545871346e-16,
   1.773823110061069e-17,  -3.032773693163251e-19,   1.362315352143715e-01,  -1.103162836493807e-02,   6.241220554238842e-04,  -2.873970582870455e-05,   1.202910462295739e-06,
  -3.403190829934868e-08,  -2.578956351450768e-10,   6.974734133563760e-11,  -3.446832024967663e-12,   1.710971793692951e-13,  -6.380064638254062e-15,  -1.223650712036490e-16,
   1.794647206000688e-17,  -3.311605685258691e-19,   1.362971448393197e-01,  -1.104060704338898e-02,   6.248670657733544e-04,  -2.877441781109283e-05,   1.202472565531928e-06,
  -3.387759609457653e-08,  -2.680320055264517e-10,   7.037920426443345e-11,  -3.475526655509850e-12,   1.703743883822550e-13,  -6.256156132685730e-15,  -1.252723000002029e-16,
   1.808273593971038e-17,  -3.491899397358438e-19,   1.363308484459502e-01,  -1.104521938601355e-02,   6.252496254747998e-04,  -2.879222307382724e-05,   1.202245626569152e-06,
  -3.379817250033408e-08,  -2.732480925792002e-10,   7.070334184346543e-11,  -3.490187709890612e-12,   1.700010018361935e-13,  -6.192404166602070e-15,  -1.267835898897607e-16,
   1.815230064199363e-17,  -3.583270444236280e-19,   1.363425808748429e-01,  -1.104682497075336e-02,   6.253827726881457e-04,  -2.879841701190954e-05,   1.202166310457685e-06,
  -3.377050024343018e-08,  -2.750652792165170e-10,   7.081610434537455e-11,  -3.495278672381292e-12,   1.698706893517943e-13,  -6.170195813446621e-15,  -1.273125022556423e-16,
   1.817644750944423e-17,  -3.614879380532857e-19,   1.363444427247301e-01,  -1.104707976522174e-02,   6.254039010226410e-04,  -2.879939974563567e-05,   1.202153708509575e-06,
  -3.376610770139556e-08,  -2.753537213741111e-10,   7.083399551372559e-11,  -3.496085970427506e-12,   1.698499938136097e-13,  -6.166670757553351e-15,  -1.273965704014080e-16,
   1.818027616339063e-17,  -3.619886100514841e-19,   1.173167431027913e+00,  -5.787490358923495e-02,  -4.026611565427101e-04,   1.356551506513290e-04,   2.053636128391325e-06,
  -4.961545917502621e-07,  -1.075992908034071e-08,   1.937166231386965e-09,   5.579452283951421e-11,  -7.673446160806441e-12,  -2.821167649592287e-13,   3.043284695687414e-14,
   1.390347494335451e-15,  -1.204564492214428e-16,   1.173131845795131e+00,  -5.783828167438649e-02,  -4.015823368033494e-04,   1.352187742919448e-04,   2.039974866174364e-06,
  -4.926928947381940e-07,  -1.063315168144964e-08,   1.914580022968713e-09,   5.481217142146797e-11,  -7.542592505116617e-12,  -2.753770898948708e-13,   2.973563461148889e-14,
   1.347888003793694e-15,  -1.169560559516524e-16,   1.173069128568006e+00,  -5.777375663755657e-02,  -3.996846545675997e-04,   1.344513140947726e-04,   2.016006807549140e-06,
  -4.866192422157793e-07,  -1.041142605677547e-08,   1.875066816266874e-09,   5.310034471342666e-11,  -7.314441930655251e-12,  -2.636813193545968e-13,   2.852459379418631e-14,
   1.274545868148826e-15,  -1.109010831306897e-16,   1.172993415257321e+00,  -5.769589373229619e-02,  -3.973999975259882e-04,   1.335275943585077e-04,   1.987257277442504e-06,
  -4.793334969489220e-07,  -1.014665079771454e-08,   1.827862685870906e-09,   5.106668839087227e-11,  -7.043183765669054e-12,  -2.498685690305331e-13,   2.709246218871849e-14,
   1.188499526428949e-15,  -1.037829210341304e-16,   1.172920044695688e+00,  -5.762047438211746e-02,  -3.951925554391679e-04,   1.326353456647954e-04,   1.959589764669858e-06,
  -4.723215120667502e-07,  -9.893068917738979e-09,   1.782634306840550e-09,   4.912991355410165e-11,  -6.784626684167727e-12,  -2.367984011906313e-13,   2.573537922183754e-14,
   1.107667143623548e-15,  -9.708134885396044e-17,   1.172861031681274e+00,  -5.755983801465552e-02,  -3.934217300428770e-04,   1.319197580241981e-04,   1.937473290820578e-06,
  -4.667160581585191e-07,  -9.691237395184590e-09,   1.746621988914128e-09,   4.759613095720180e-11,  -6.579711877516579e-12,  -2.265076651046182e-13,   2.466551329575811e-14,
   1.044439594155547e-15,  -9.182896027964602e-17,   1.172822082551341e+00,  -5.751982944132968e-02,  -3.922552390202119e-04,   1.314484692876731e-04,   1.922942868965720e-06,
  -4.630331522614519e-07,  -9.559060091807366e-09,   1.723031092409964e-09,   4.659543592172532e-11,  -6.445942023829430e-12,  -2.198226858740604e-13,   2.396985066282422e-14,
   1.003567688071070e-15,  -8.842865738948937e-17,   1.172802094398167e+00,  -5.749930129887682e-02,  -3.916573123629035e-04,   1.312069207436180e-04,   1.915506591931746e-06,
  -4.611482954477754e-07,  -9.491546307585272e-09,   1.710979190629920e-09,   4.608545763221207e-11,  -6.377746286791630e-12,  -2.164248049759974e-13,   2.361605045664993e-14,
   9.828550248613000e-16,  -8.670394113885544e-17,   1.172795139579632e+00,  -5.749215918177755e-02,  -3.914493769144772e-04,   1.311229239841577e-04,   1.912922423574649e-06,
  -4.604932848431316e-07,  -9.468105520099377e-09,   1.706794436999960e-09,   4.590857725549586e-11,  -6.354089626951217e-12,  -2.152477082889094e-13,   2.349345419166219e-14,
   9.756895670658545e-16,  -8.610703767033341e-17,   1.172794036052077e+00,  -5.749102596334549e-02,  -3.914163888863225e-04,   1.311095984809719e-04,   1.912512545896924e-06,
  -4.603893925810099e-07,  -9.464388539568533e-09,   1.706130849307909e-09,   4.588053825763641e-11,  -6.350339407563636e-12,  -2.150611828661182e-13,   2.347402576601833e-14,
   9.745545791292453e-16,  -8.601247824151584e-17,   9.999549912567360e-02,  -7.106090945507729e-03,   3.697808591336854e-04,  -1.457470011593832e-05,   5.629610404250378e-07,
  -2.552088543655955e-08,   7.589168086403551e-10,   1.102708517076740e-11,  -1.328647880667231e-12,  -1.123764362519099e-14,   8.294155061816615e-16,   2.477092750930285e-16,
  -1.044659790245207e-17,  -6.899158453718631e-19,   1.000308134153601e-01,  -7.110273665813930e-03,   3.701032955768947e-04,  -1.459844406397302e-05,   5.639874441703921e-07,
  -2.549926078950325e-08,   7.554615973674704e-10,   1.101780570547971e-11,  -1.326834290652725e-12,  -1.011579072399659e-14,   7.753917463856976e-16,   2.435798338161110e-16,
  -1.020958315075907e-17,  -6.723969315793767e-19,   1.000931512902360e-01,  -7.117659539308378e-03,   3.706726995474515e-04,  -1.464032415403556e-05,   5.657946101337222e-07,
  -2.546110477560948e-08,   7.493676979001943e-10,   1.100439905542265e-11,  -1.323810389796672e-12,  -8.152680128555623e-15,   6.811979923843040e-16,   2.363888879998740e-16,
  -9.796910486701686e-18,  -6.421363325859769e-19,   1.001685739990480e-01,  -7.126599817413015e-03,   3.713620116690984e-04,  -1.469093790031101e-05,   5.679731387859778e-07,
  -2.541496468677023e-08,   7.420035434716077e-10,   1.099321696480684e-11,  -1.320451729148545e-12,  -5.806596197012413e-15,   5.692098674042847e-16,   2.278538722170163e-16,
  -9.307205517113678e-18,  -6.066372886134976e-19,   1.002418382052363e-01,  -7.135288516490524e-03,   3.720320020696373e-04,  -1.474004340717369e-05,   5.700809859616439e-07,
  -2.537016717367779e-08,   7.348591082982855e-10,   1.098759053273548e-11,  -1.317499865377153e-12,  -3.557768218717778e-15,   4.624729588231613e-16,   2.197329801707662e-16,
  -8.841363084336142e-18,  -5.732955476056310e-19,   1.003008912639784e-01,  -7.142294918331778e-03,   3.725723227002448e-04,  -1.477958106252834e-05,   5.717740040182218e-07,
  -2.533407211118339e-08,   7.291066898445233e-10,   1.098677805795749e-11,  -1.315340757630745e-12,  -1.766482925564388e-15,   3.778892226225470e-16,   2.133067403588969e-16,
  -8.472802170018224e-18,  -5.472219313154513e-19,   1.003399283290191e-01,  -7.146928000776320e-03,   3.729296429698967e-04,  -1.480569650533402e-05,   5.728902548098946e-07,
  -2.531021669031708e-08,   7.253069969873675e-10,   1.098805206256112e-11,  -1.314020309958088e-12,  -5.927017638550356e-16,   3.226779448141721e-16,   2.091162399971828e-16,
  -8.232500046564100e-18,  -5.303712702833670e-19,   1.003599806350478e-01,  -7.149308354440049e-03,   3.731132323853542e-04,  -1.481910483770832e-05,   5.734627406589841e-07,
  -2.529796417456106e-08,   7.233560879681122e-10,   1.098926410953017e-11,  -1.313374862461563e-12,   7.058474975266180e-18,   2.945333088722694e-16,   2.069813030553840e-16,
  -8.110083359863363e-18,  -5.218332691776478e-19,   1.003669608048737e-01,  -7.150137024542513e-03,   3.731771464211955e-04,  -1.482377122153325e-05,   5.736618782438562e-07,
  -2.529369929566248e-08,   7.226771206346035e-10,   1.098977457456376e-11,  -1.313155391752726e-12,   2.153294393372883e-16,   2.847704642075978e-16,   2.062409223891256e-16,
  -8.067631747374945e-18,  -5.188798247386220e-19,   1.003680684987760e-01,  -7.150268530965364e-03,   3.731872893656776e-04,  -1.482451168821219e-05,   5.736934728749334e-07,
  -2.529302250446150e-08,   7.225693808941674e-10,   1.098985978049621e-11,  -1.313120810490433e-12,   2.483563690174622e-16,   2.832228067287431e-16,   2.061235621976839e-16,
  -8.060902677729113e-18,  -5.184120193814139e-19,   9.453295160375894e-01,  -5.477729321222616e-02,   1.100969251113236e-03,   9.370601042714408e-05,  -6.151353286231746e-06,
  -1.636533210710383e-07,   2.783786253721185e-08,  -1.253630310892819e-10,  -1.064823493453375e-10,   3.369194045850084e-12,   3.367664058721900e-13,  -2.264122048301502e-14,
  -7.561163488554287e-16,   1.129232456118107e-16,   9.454261967971760e-01,  -5.475148166132515e-02,   1.097711829395962e-03,   9.355180729562671e-05,  -6.115164769220833e-06,
  -1.637613032758414e-07,   2.758434916203183e-08,  -1.163215528070286e-10,  -1.052027299979835e-10,   3.276345773012595e-12,   3.323354104762575e-13,  -2.199963215757238e-14,
  -7.513903646264646e-16,   1.094217539592219e-16,   9.455965666989321e-01,  -5.470597211688134e-02,   1.091979924684290e-03,   9.327967196870193e-05,  -6.051589346487779e-06,
  -1.639384729815483e-07,   2.713966681947372e-08,  -1.006055528044810e-10,  -1.029597826042123e-10,   3.115022168235735e-12,   3.245453078902218e-13,  -2.088682910822061e-14,
  -7.426098387244403e-16,   1.033582158775086e-16,   9.458021971794135e-01,  -5.465100174812377e-02,   1.085075815437627e-03,   9.295053871511647e-05,  -5.975188307859876e-06,
  -1.641301643017931e-07,   2.660644221371118e-08,  -8.200261785867667e-11,  -1.002730235082306e-10,   2.924172327410615e-12,   3.151753100896827e-13,  -1.957365849158552e-14,
  -7.312681473331360e-16,   9.621931908500764e-17,   9.460014199144023e-01,  -5.459770056180936e-02,   1.078401563236702e-03,   9.263096261967292e-05,  -5.901514399624224e-06,
  -1.642929593865524e-07,   2.609347140328994e-08,  -6.435746556727869e-11,  -9.769130668897259e-11,   2.743255356638264e-12,   3.061329842047931e-13,  -1.833226363121051e-14,
  -7.195350493005621e-16,   8.948788280696482e-17,   9.461616253574204e-01,  -5.455480702276405e-02,   1.073044958163857e-03,   9.237347950228052e-05,  -5.842516451087212e-06,
  -1.644076320867599e-07,   2.568355864042750e-08,  -5.043560349524126e-11,  -9.563045865111505e-11,   2.600585915939297e-12,   2.988883679764217e-13,  -1.735575532758408e-14,
  -7.095896033410629e-16,   8.420522495802686e-17,   9.462673465806202e-01,  -5.452648586710006e-02,   1.069515213373720e-03,   9.220332350986133e-05,  -5.803703671614482e-06,
  -1.644754275494476e-07,   2.541431818251281e-08,  -4.137808193610662e-11,  -9.427793721232091e-11,   2.507799408539733e-12,   2.941211700717414e-13,  -1.672186620451360e-14,
  -7.027858850653560e-16,   8.078217580477783e-17,   9.463215963446597e-01,  -5.451194844225839e-02,   1.067705546244005e-03,   9.211593588018492e-05,  -5.783824495397679e-06,
  -1.645077949225116e-07,   2.527655046950070e-08,  -3.677012750984318e-11,  -9.358620743364593e-11,   2.460604999074831e-12,   2.916792375817305e-13,  -1.639981690960522e-14,
  -6.992221376560370e-16,   7.904499056886388e-17,   9.463404716083202e-01,  -5.450688964789906e-02,   1.067076156156312e-03,   9.208551915973911e-05,  -5.776913796954528e-06,
  -1.645186724634289e-07,   2.522867863176265e-08,  -3.517318488859753e-11,  -9.334589848071113e-11,   2.444250783937551e-12,   2.908303040167630e-13,  -1.628827627633983e-14,
  -6.979708219384226e-16,   7.844362708797568e-17,   9.463434665269730e-01,  -5.450608693862578e-02,   1.066976303446804e-03,   9.208069241484269e-05,  -5.775817564253353e-06,
  -1.645203801823639e-07,   2.522108580044515e-08,  -3.492009896461356e-11,  -9.330778629810577e-11,   2.441659017251033e-12,   2.906956377490475e-13,  -1.627060243970075e-14,
  -6.977717404876236e-16,   7.834835432322753e-17,   7.655329984035991e-02,  -4.726497921898945e-03,   2.353689467757065e-04,  -8.642205604141984e-06,   2.352146094969465e-07,
  -8.229223410909800e-09,   5.255878413353203e-10,  -2.149926907954538e-11,  -2.137125631921717e-13,   5.758959166849016e-14,  -7.401402412805803e-16,  -1.538735219766065e-16,
   5.301814717512062e-18,   4.324741200175486e-19,   7.657563961916229e-02,  -4.728956943869943e-03,   2.355053816747867e-04,  -8.650250326986353e-06,   2.359464507754787e-07,
  -8.268774070506323e-09,   5.249793843492239e-10,  -2.132235755002205e-11,  -2.161109974906879e-13,   5.690396781308304e-14,  -7.162887419230653e-16,  -1.510502894141144e-16,
   5.098910983725886e-18,   4.263425315701121e-19,   7.661506940045870e-02,  -4.733297822694524e-03,   2.357464561474383e-04,  -8.664474671716414e-06,   2.372370828054147e-07,
  -8.338287070860044e-09,   5.239010503578263e-10,  -2.101199761657335e-11,  -2.202688370599246e-13,   5.570566056141556e-14,  -6.751496835896526e-16,  -1.461052630692212e-16,
   4.747625857275749e-18,   4.155076919832701e-19,   7.666276689898052e-02,  -4.738550096723740e-03,   2.360385334474979e-04,  -8.681724729283508e-06,   2.387965089930501e-07,
  -8.421876355848275e-09,   5.225892010125822e-10,  -2.063976058757554e-11,  -2.251720864188741e-13,   5.427613543767158e-14,  -6.269968451784432e-16,  -1.401881294062166e-16,
   4.334178535755042e-18,   4.023856590124765e-19,   7.670909028942499e-02,  -4.743652308707957e-03,   2.363226709913736e-04,  -8.698522789003711e-06,   2.403090912088967e-07,
  -8.502537218432214e-09,   5.213075177181298e-10,  -2.028157004377529e-11,  -2.298044289801168e-13,   5.290864307995663e-14,  -5.818909386653207e-16,  -1.345092810664219e-16,
   3.944468248260182e-18,   3.896331885935059e-19,   7.674642178629973e-02,  -4.747765020934305e-03,   2.365519938618945e-04,  -8.712092222739278e-06,   2.415266864034406e-07,
  -8.567169923675781e-09,   5.202692502406657e-10,  -1.999526933704256e-11,  -2.334465930544571e-13,   5.182143485554697e-14,  -5.467097263790865e-16,  -1.299813331711189e-16,
   3.638730349377695e-18,   3.793552291958131e-19,   7.677109662358797e-02,  -4.750483822505936e-03,   2.367037345131574e-04,  -8.721076795220683e-06,   2.423307992872215e-07,
  -8.609709024455121e-09,   5.195803965225257e-10,  -1.980718244174516e-11,  -2.358101500704716e-13,   5.111005212437731e-14,  -5.240205728329325e-16,  -1.270122845570228e-16,
   3.440665125186449e-18,   3.725634481640382e-19,   7.678377045267785e-02,  -4.751880426977661e-03,   2.367817249628886e-04,  -8.725696400062144e-06,   2.427436095864634e-07,
  -8.631502756100730e-09,   5.192257833008052e-10,  -1.971092800673365e-11,  -2.370107720636749e-13,   5.074688749470866e-14,  -5.125395127774037e-16,  -1.254946285056383e-16,
   3.340161912727589e-18,   3.690758775696020e-19,   7.678818203249980e-02,  -4.752366586852142e-03,   2.368088804984951e-04,  -8.727305185933255e-06,   2.428872696581630e-07,
  -8.639079977361631e-09,   5.191022216399934e-10,  -1.967747930637811e-11,  -2.374265756046599e-13,   5.062082857769745e-14,  -5.085704871250015e-16,  -1.249675233815013e-16,
   3.305372842528066e-18,   3.678620869715531e-19,   7.678888210548694e-02,  -4.752443736525416e-03,   2.368131901943521e-04,  -8.727560520331342e-06,   2.429100654723294e-07,
  -8.640281984887331e-09,   5.190826076971149e-10,  -1.967217399699170e-11,  -2.374924592500160e-13,   5.060084107311875e-14,  -5.079419392160861e-16,  -1.248839326495071e-16,
   3.299861389009229e-18,   3.676694801510084e-19,   7.485315969793844e-01,  -4.318510928852395e-02,   1.628768781580436e-03,  -7.703083467871205e-07,  -4.364223678216985e-06,
   2.329532799676539e-07,   2.057142464393134e-09,  -8.856549833119779e-10,   3.846688715645994e-11,   1.056932995582447e-12,  -1.856826957731929e-13,   5.824440110571335e-15,
   3.435422638019688e-16,  -3.777118913743690e-17,   7.486794116897517e-01,  -4.318460915487955e-02,   1.626336407585159e-03,  -5.659510408611237e-07,  -4.360329941276692e-06,
   2.312758434340915e-07,   2.143645449971516e-09,  -8.815622681067880e-10,   3.775547471539599e-11,   1.078362718757712e-12,  -1.834575424350780e-13,   5.595967118954227e-15,
   3.462352328360085e-16,  -3.689766995506649e-17,   7.489400506119723e-01,  -4.318368234887680e-02,   1.622046453580135e-03,  -2.066170516044090e-07,  -4.353366085601338e-06,
   2.283227744816843e-07,   2.294806921426866e-09,  -8.742879611141793e-10,   3.650787871815191e-11,   1.115266523180110e-12,  -1.795218197234497e-13,   5.197937587835230e-15,
   3.506052761392504e-16,  -3.536177805475192e-17,   7.492549070156094e-01,  -4.318248627975246e-02,   1.616862446462882e-03,   2.257526457217184e-07,  -4.344787364697635e-06,
   2.247635293054636e-07,   2.475090314888897e-09,  -8.654036746131749e-10,   3.501242199094054e-11,   1.158355143477889e-12,  -1.747479139504702e-13,   4.725330339499509e-15,
   3.552500526247341e-16,  -3.351445095774341e-17,   7.495602387044848e-01,  -4.318124647777291e-02,   1.611833550310829e-03,   6.432525311067603e-07,  -4.336295314998995e-06,
   2.213205284564826e-07,   2.647499986907706e-09,  -8.566887785371196e-10,   3.357444800033336e-11,   1.198595009611205e-12,  -1.700995738531947e-13,   4.275600755943609e-15,
   3.591038306995399e-16,  -3.173220461999332e-17,   7.498059768824732e-01,  -4.318019150748264e-02,   1.607784974913576e-03,   9.779854315349748e-07,  -4.329337746254542e-06,
   2.185557167371236e-07,   2.784533746086262e-09,  -8.496050165460989e-10,   3.242592737428330e-11,   1.229885633164270e-12,  -1.663460519078550e-13,   3.919776780218457e-15,
   3.617489524332584e-16,  -3.030492225913214e-17,   7.499682422328856e-01,  -4.317946695292783e-02,   1.605111049657892e-03,   1.198389117178091e-06,  -4.324683679085733e-06,
   2.167331176178272e-07,   2.874177980360495e-09,  -8.448938561648269e-10,   3.167185359877138e-11,   1.250015794546013e-12,  -1.638618777914699e-13,   3.687812877695497e-15,
   3.632758913526514e-16,  -2.936614978299946e-17,   7.500515379915296e-01,  -4.317908638533078e-02,   1.603738265563233e-03,   1.311335447816918e-06,  -4.322276165510100e-06,
   2.157984715495533e-07,   2.919935510210003e-09,  -8.424651921212751e-10,   3.128610088031851e-11,   1.260185815321772e-12,  -1.625850166678218e-13,   3.569662674535613e-15,
   3.639925849591369e-16,  -2.888543275330147e-17,   7.500805242302195e-01,  -4.317895257750126e-02,   1.603260520060671e-03,   1.350609029733129e-06,  -4.321435441525895e-06,
   2.154733740171702e-07,   2.935817486733603e-09,  -8.416184105166472e-10,   3.115207503098257e-11,   1.263698972346906e-12,  -1.621404234224049e-13,   3.528694320779000e-15,
   3.642313724929929e-16,  -2.871833939354489e-17,   7.500851236806515e-01,  -4.317893128008383e-02,   1.603184711498199e-03,   1.356839382760132e-06,  -4.321301899011503e-06,
   2.154217957102714e-07,   2.938335633781124e-09,  -8.414839687141498e-10,   3.113081831818206e-11,   1.264255200631608e-12,  -1.620698646879312e-13,   3.522200556838526e-15,
   3.642687600507900e-16,  -2.869183471564865e-17,   6.083462392853438e-02,  -3.203448401341934e-03,   1.504850020156958e-04,  -5.708024348597267e-06,   1.506561673595468e-07,
  -2.120967276214582e-09,   5.080379194732765e-11,  -8.264735506363012e-12,   5.824447027954893e-13,  -1.218385640291413e-14,  -9.127494949517570e-16,   7.454478330801229e-17,
  -8.685592063196485e-19,  -1.697559084542330e-19,   6.084890302535518e-02,  -3.205061313604781e-03,   1.505702542692225e-04,  -5.710154199647539e-06,   1.507446072245517e-07,
  -2.137735850908657e-09,   5.225176567505568e-11,  -8.297198522946341e-12,   5.785324954543715e-13,  -1.184489775631258e-14,  -9.151137179753052e-16,   7.336682133679903e-17,
  -8.006138630178520e-19,  -1.687269532752143e-19,   6.087410527947558e-02,  -3.207907834502702e-03,   1.507207276171574e-04,  -5.713925282145657e-06,   1.509022842949963e-07,
  -2.167372043289403e-09,   5.479835926713448e-11,  -8.353583104328384e-12,   5.716237885396850e-13,  -1.125166736812285e-14,  -9.189662462316760e-16,   7.129552161842321e-17,
  -6.827833363206500e-19,  -1.668264620114116e-19,   6.090459130815719e-02,  -3.211350752773188e-03,   1.509027578077047e-04,  -5.718507379440691e-06,   1.510957107841927e-07,
  -2.203288954589927e-09,   5.786343524316923e-11,  -8.420243671769685e-12,   5.632609514683486e-13,  -1.054260386905207e-14,  -9.230874909061732e-16,   6.880353592289271e-17,
  -5.437902379467991e-19,  -1.643871402090268e-19,   6.093419834290820e-02,  -3.214693996936648e-03,   1.510795500038692e-04,  -5.722978734197729e-06,   1.512863694946810e-07,
  -2.238239566603787e-09,   6.082398470881527e-11,  -8.483376115888010e-12,   5.551341928740197e-13,  -9.862895801728078e-15,  -9.265345254780912e-16,   6.639800853743803e-17,
  -4.124810321409753e-19,  -1.618756262968597e-19,   6.095805778932632e-02,  -3.217387931064845e-03,   1.512220295757909e-04,  -5.726597394958011e-06,   1.514420218608837e-07,
  -2.266454011839797e-09,   6.319823238805932e-11,  -8.533110492595678e-12,   5.485820950515107e-13,  -9.321500378245491e-15,  -9.289208046306748e-16,   6.447020255390374e-17,
  -3.092741213747305e-19,  -1.597526806842399e-19,   6.097382780253108e-02,  -3.219168358703301e-03,   1.513162061541226e-04,  -5.728996675155013e-06,   1.515458805056655e-07,
  -2.285126007079751e-09,   6.476183652221692e-11,  -8.565426862217366e-12,   5.442502496340296e-13,  -8.966767642259578e-15,  -9.303088478788904e-16,   6.320137538806811e-17,
  -2.423283544438374e-19,  -1.583022925206471e-19,   6.098192773204297e-02,  -3.220082793832874e-03,   1.513645792209382e-04,  -5.730231337435646e-06,   1.515995275980863e-07,
  -2.294723678026361e-09,   6.556319615857352e-11,  -8.581854326229518e-12,   5.420249707675596e-13,  -8.785524960109540e-15,  -9.309638235989779e-16,   6.255135124298519e-17,
  -2.083336570042479e-19,  -1.575429939461435e-19,   6.098474718939698e-02,  -3.220401087343479e-03,   1.513814173281442e-04,  -5.730661473824907e-06,   1.516182493798345e-07,
  -2.298065615160618e-09,   6.584185784756155e-11,  -8.587545285809039e-12,   5.412503403085852e-13,  -8.722589604702967e-15,  -9.311826307456763e-16,   6.232535783398283e-17,
  -1.965626403189319e-19,  -1.572764349797365e-19,   6.098519460807258e-02,  -3.220451596899368e-03,   1.513840893712599e-04,  -5.730729749579863e-06,   1.516212226139676e-07,
  -2.298595999934495e-09,   6.588606532985909e-11,  -8.588447093119583e-12,   5.411274123870985e-13,  -8.712609644686411e-15,  -9.312169183661355e-16,   6.228950786496144e-17,
  -1.946976416201101e-19,  -1.572340280573350e-19,   6.005673116529371e-01,  -3.103884452908308e-02,   1.346167938975481e-03,  -3.651040986754586e-05,  -4.921758221252000e-07,
   1.221910019314020e-07,  -6.639215061605456e-09,   9.650617443001791e-11,   1.194085758842196e-11,  -1.015163238794437e-12,   3.101580969850840e-14,   8.334424913224670e-16,
  -1.369176145496861e-16,   6.303349659344212e-18,   6.006928569422562e-01,  -3.104870544756271e-02,   1.345840859629358e-03,  -3.639474396343468e-05,  -5.011138610613547e-07,
   1.223292995743786e-07,  -6.605791301930077e-09,   9.323347569782372e-11,   1.204538535237517e-11,  -1.009479065559705e-12,   3.019288495660139e-14,   8.704980031594393e-16,
  -1.364860433169009e-16,   6.140107005567854e-18,   6.009143527616773e-01,  -3.106607857208242e-02,   1.345259730506428e-03,  -3.619056003812077e-05,  -5.168461742172397e-07,
   1.225681677791011e-07,  -6.546607366435540e-09,   8.747533075284239e-11,   1.222702791194406e-11,  -9.993031989522154e-13,   2.874368785174750e-14,   9.349073351048283e-16,
  -1.356608637766126e-16,   5.851607209934632e-18,   6.011821351338210e-01,  -3.108704093884368e-02,   1.344550227980242e-03,  -3.594350849830294e-05,  -5.358032104956312e-07,
   1.228482302394990e-07,  -6.474692313109639e-09,   8.054105968115860e-11,   1.244190836711824e-11,  -9.867522051226757e-13,   2.699640306563821e-14,   1.011127102019522e-15,
  -1.345557046461520e-16,   5.502084465099611e-18,   6.014420381540051e-01,  -3.110734328614729e-02,   1.343854355565108e-03,  -3.570352127466093e-05,  -5.541363917656267e-07,
   1.231109405757119e-07,  -6.404517916699088e-09,   7.383960828587874e-11,   1.264553223825107e-11,  -9.743136529331378e-13,   2.530577806481071e-14,   1.083375623403115e-15,
  -1.333719790431697e-16,   5.162217290259221e-18,   6.016513727309235e-01,  -3.112366451150533e-02,   1.343288694219931e-03,  -3.551008281989550e-05,  -5.688550891091117e-07,
   1.233160240331034e-07,  -6.347731677766511e-09,   6.846289026646321e-11,   1.280600934706331e-11,  -9.641136630162874e-13,   2.394803855304820e-14,   1.140327742521196e-15,
  -1.323400562616526e-16,   4.888124149012368e-18,   6.017896776771596e-01,  -3.113443259593738e-02,   1.342912434708078e-03,  -3.538221027703207e-05,  -5.785562726606507e-07,
   1.234483382452723e-07,  -6.310085124594424e-09,   6.492085873079626e-11,   1.291030991118594e-11,  -9.572867476378933e-13,   2.305300276092048e-14,   1.177348328769503e-15,
  -1.316202736471215e-16,   4.706900420649285e-18,   6.018606978045014e-01,  -3.113995736013883e-02,   1.342718441279828e-03,  -3.531652577399881e-05,  -5.835306540385193e-07,
   1.235152994036614e-07,  -6.290714024656886e-09,   6.310521817948185e-11,   1.296333583741716e-11,  -9.537541291068110e-13,   2.259403495872992e-14,   1.196170771964037e-15,
  -1.312390031368192e-16,   4.613808327395322e-18,   6.018854160409229e-01,  -3.114187948299366e-02,   1.342650798202769e-03,  -3.529366117855450e-05,  -5.852608156421575e-07,
   1.235384486086841e-07,  -6.283965746960159e-09,   6.247380485488883e-11,   1.298170650074202e-11,  -9.525203421878188e-13,   2.243439602120840e-14,   1.202691941847197e-15,
  -1.311044557889886e-16,   4.581403523082159e-18,   6.018893384385763e-01,  -3.114218445839835e-02,   1.342640058393378e-03,  -3.529003276371145e-05,  -5.855353106468372e-07,
   1.235421146067600e-07,  -6.282894604474751e-09,   6.237363378435337e-11,   1.298461761444842e-11,  -9.523243569320797e-13,   2.240906872374952e-14,   1.203725330177411e-15,
  -1.310830176728318e-16,   4.576261187564369e-18,   5.004860478295207e-02,  -2.235627807666254e-03,   9.512847107277110e-05,  -3.617986681351180e-06,   1.103727658342671e-07,
  -2.096032049875771e-09,  -5.570928721104188e-12,   1.282091727145965e-12,   5.049561418616209e-14,  -8.698528495977665e-15,   4.396783823685703e-16,  -5.932151187746184e-18,
  -6.623059236907385e-19,   5.090747649337584e-20,   5.005764762721856e-02,  -2.236652223562023e-03,   9.519052406585720e-05,  -3.619934944109116e-06,   1.103669652409472e-07,
  -2.093982120634010e-09,  -5.403493403418939e-12,   1.252329385718115e-12,   5.220622543434805e-14,  -8.716023972965649e-15,   4.352405232843915e-16,  -5.590704547928520e-18,
  -6.702053855793650e-19,   5.036908322867299e-20,   5.007360859481768e-02,  -2.238460264304897e-03,   9.530001539656530e-05,  -3.623371268455307e-06,   1.103569349694831e-07,
  -2.090412801242183e-09,  -5.104488830117591e-12,   1.199774771327962e-12,   5.520912353250071e-14,  -8.745496179629324e-15,   4.273743892816894e-16,  -4.991603968339444e-18,
  -6.837557986495793e-19,   4.940494912210513e-20,   5.009291682666069e-02,  -2.240647321285011e-03,   9.543240988413829e-05,  -3.627524119313035e-06,   1.103451584720131e-07,
  -2.086178301553455e-09,  -4.736878179149546e-12,   1.136162121617269e-12,   5.881374996723710e-14,  -8.778759158272249e-15,   4.178034329497822e-16,  -4.272994938823434e-18,
  -6.994815799319817e-19,   4.821548788128741e-20,   5.011166936349960e-02,  -2.242771268531508e-03,   9.556093248097534e-05,  -3.631553164993724e-06,   1.103340983591877e-07,
  -2.082152973015526e-09,  -4.373700762835468e-12,   1.074345330889217e-12,   6.228520107629457e-14,  -8.808575925155255e-15,   4.084518624471825e-16,  -3.581554473084365e-18,
  -7.140606079626130e-19,   4.703664887637975e-20,   5.012678221024290e-02,  -2.244482858821921e-03,   9.566446604027564e-05,  -3.634797164556559e-06,   1.103254576726020e-07,
  -2.078971474176329e-09,  -4.076631273408778e-12,   1.024503893688520e-12,   6.506173001377744e-14,  -8.830832183017456e-15,   4.008763704636878e-16,  -3.029008754258823e-18,
  -7.253152598719065e-19,   4.607012694739550e-20,   5.013677147088369e-02,  -2.245614124265312e-03,   9.573287793760271e-05,  -3.636939895281737e-06,   1.103198808484920e-07,
  -2.076899198817266e-09,  -3.878138847544963e-12,   9.915496152175960e-13,   6.688657865181992e-14,  -8.844678854415160e-15,   3.958505371736234e-16,  -2.666103538458457e-18,
  -7.325131980230067e-19,   4.542338035009271e-20,   5.014190234982668e-02,  -2.246195168872785e-03,   9.576801034405597e-05,  -3.638040030218947e-06,   1.103170581570744e-07,
  -2.075844267068213e-09,  -3.775526701488216e-12,   9.746200461122664e-13,   6.782067947067924e-14,  -8.851524654854562e-15,   3.932634214916909e-16,  -2.480420852515955e-18,
  -7.361360053157634e-19,   4.508878075256828e-20,   5.014368834500032e-02,  -2.246397420407573e-03,   9.578023844045169e-05,  -3.638422901068169e-06,   1.103160822830056e-07,
  -2.075478566127485e-09,  -3.739704018165000e-12,   9.687266216399232e-13,   6.814531635344297e-14,  -8.853865260571343e-15,   3.923619884785196e-16,  -2.415901932382297e-18,
  -7.373852461460834e-19,   4.497193122219795e-20,   5.014397176475743e-02,  -2.246429515588110e-03,   9.578217886813138e-05,  -3.638483655447002e-06,   1.103159277384321e-07,
  -2.075420604580669e-09,  -3.734014347434122e-12,   9.677913724084400e-13,   6.819680869944729e-14,  -8.854234683478679e-15,   3.922188979051180e-16,  -2.405668880224890e-18,
  -7.375829279201964e-19,   4.495337040573470e-20,   4.951687216275544e-01,  -2.201990685423458e-02,   9.170097790015292e-04,  -3.214152565753007e-05,   6.893277206321009e-07,
   1.351054406580760e-08,  -2.345243873501097e-09,   1.309522960387656e-10,  -3.770278050293513e-12,  -3.013413707292835e-14,   1.001930753385399e-14,  -5.914224755559694e-16,
   1.739445733777219e-17,   1.111364493059552e-19,   4.952554303463859e-01,  -2.202889402404512e-02,   9.173782641931070e-04,  -3.212672050003409e-05,   6.859252529355429e-07,
   1.376534669635978e-08,  -2.354203275275973e-09,   1.307738693765490e-10,  -3.725270876185389e-12,  -3.309239365024855e-14,   1.010752714542851e-14,  -5.892820696248783e-16,
   1.698123261457330e-17,   1.354811331543432e-19,   4.954084550084017e-01,  -2.204474827065215e-02,   9.180268820527735e-04,  -3.210040335201700e-05,   6.799116742612250e-07,
   1.421462673902441e-08,  -2.369914620488797e-09,   1.304509874809565e-10,  -3.645569669271428e-12,  -3.830196440377472e-14,   1.026107061468537e-14,  -5.853631704439802e-16,
   1.624813921004610e-17,   1.782497838666309e-19,   4.955935379071465e-01,  -2.206391296096966e-02,   9.188085006299885e-04,  -3.206825111701091e-05,   6.726232374962970e-07,
   1.475734111657567e-08,  -2.388746028940060e-09,   1.300468584502844e-10,  -3.548712631182707e-12,  -4.458343376918991e-14,   1.044310703533173e-14,  -5.803829035652068e-16,
   1.535507710884040e-17,   2.296365012850520e-19,   4.957732589822656e-01,  -2.208251093469716e-02,   9.195644543340378e-04,  -3.203669373100866e-05,   6.655303045852938e-07,
   1.528360141101769e-08,  -2.406851933932951e-09,   1.296402210847254e-10,  -3.454187737009390e-12,  -5.066201318717617e-14,   1.061600752705272e-14,  -5.752963425557039e-16,
   1.448137872089733e-17,   2.791650634257740e-19,   4.959180726813472e-01,  -2.209748833866631e-02,   9.201714118736470e-04,  -3.201102481389970e-05,   6.598039010263028e-07,
   1.570711394889469e-08,  -2.421311860410032e-09,   1.293024015596328e-10,  -3.377687629245400e-12,  -5.554460368922388e-14,   1.075254773536636e-14,  -5.710190387055579e-16,
   1.377284447321540e-17,   3.188008539934777e-19,   4.960137789919148e-01,  -2.210738273927848e-02,   9.205714841284964e-04,  -3.199394253197326e-05,   6.560139382778598e-07,
   1.598674688835223e-08,  -2.430804909959795e-09,   1.290741717694361e-10,  -3.326967177144459e-12,  -5.876381784948314e-14,   1.084142207440818e-14,  -5.681050386548613e-16,
   1.330241076639225e-17,   3.448590565746941e-19,   4.960629337025745e-01,  -2.211246324254176e-02,   9.207766325994067e-04,  -3.198513264466079e-05,   6.540657438312169e-07,
   1.613028412250772e-08,  -2.435660899198316e-09,   1.289554188396719e-10,  -3.300867449901308e-12,  -6.041480717944368e-14,   1.088664518606722e-14,  -5.665815279901040e-16,
   1.306013667429086e-17,   3.581995438411420e-19,   4.960800432357493e-01,  -2.211423143943654e-02,   9.208479873853325e-04,  -3.198206034295837e-05,   6.533873601852187e-07,
   1.618023273975241e-08,  -2.437348020013521e-09,   1.289138398226299e-10,  -3.291774902026732e-12,  -6.098909118280375e-14,   1.090231885846633e-14,  -5.660469588182064e-16,
   1.297570306450399e-17,   3.628361308248253e-19,   4.960827583203288e-01,  -2.211451202228813e-02,   9.208593080796939e-04,  -3.198157252903910e-05,   6.532796959676980e-07,
   1.618815838198256e-08,  -2.437615597970861e-09,   1.289072301312931e-10,  -3.290331646643100e-12,  -6.108020509632779e-14,   1.090480288888408e-14,  -5.659619261709435e-16,
   1.296229951125237e-17,   3.635715743993925e-19,   4.239138383023817e-02,  -1.621410845675871e-03,   6.093681194908417e-05,  -2.181817906846625e-06,   7.012209504381787e-08,
  -1.802821823274050e-09,   2.567090541399003e-11,   5.061160221761070e-13,  -4.345482321809166e-14,   7.690091296589591e-16,   5.586151080484096e-17,  -5.183210182294438e-18,
   2.124968564177563e-19,  -3.225473605955818e-21,   4.239717622362806e-02,  -1.622030401630455e-03,   6.097645146191934e-05,  -2.183499407358350e-06,   7.015692332347273e-08,
  -1.801797038084226e-09,   2.556261671737223e-11,   5.080002465041639e-13,  -4.318057243442077e-14,   7.417937265850554e-16,   5.707735615357859e-17,  -5.197277579983643e-18,
   2.104231654822174e-19,  -3.052967609406933e-21,   4.240740003739146e-02,  -1.623124000849485e-03,   6.104641163828186e-05,  -2.186465652304946e-06,   7.021825689036840e-08,
  -1.799986123844548e-09,   2.537214803088340e-11,   5.112499886604582e-13,  -4.269257140858123e-14,   6.937225011200097e-16,   5.921183097721649e-17,  -5.221074093965232e-18,
   2.067210453059636e-19,  -2.748540909148725e-21,   4.241976797412714e-02,  -1.624447045614940e-03,   6.113103484845048e-05,  -2.190051120603092e-06,   7.029221545239147e-08,
  -1.797791886006022e-09,   2.514287454332038e-11,   5.150516474810561e-13,  -4.209554283804243e-14,   6.355132829859678e-16,   6.177412485143193e-17,  -5.248100537270632e-18,
   2.021716031337683e-19,  -2.380412878964994e-21,   4.243177999090023e-02,  -1.625732118127075e-03,   6.121321342233705e-05,  -2.193530419313436e-06,   7.036379738064338e-08,
  -1.795657191668742e-09,   2.492139979876597e-11,   5.186081295184645e-13,  -4.150873189654249e-14,   5.789237368171194e-16,   6.424175198990321e-17,  -5.272506681999947e-18,
   1.976796476244052e-19,  -2.023093389971217e-21,   4.244146061231367e-02,  -1.626767845483712e-03,   6.127943531700351e-05,  -2.196332284478239e-06,   7.042130870370467e-08,
  -1.793934312239113e-09,   2.474377601325272e-11,   5.213770332876927e-13,  -4.103085119218545e-14,   5.332805127100575e-16,   6.621532294960413e-17,  -5.290856675999973e-18,
   1.940075038840488e-19,  -1.735325329164956e-21,   4.244785930279935e-02,  -1.627452475371579e-03,   6.132320329756664e-05,  -2.198183210840625e-06,   7.045923586768895e-08,
  -1.792794328641837e-09,   2.462679595726138e-11,   5.231595705270996e-13,  -4.071256258343089e-14,   5.030942155268666e-16,   6.751236187929278e-17,  -5.302340175976792e-18,
   1.915550602502889e-19,  -1.545232929118864e-21,   4.245114592675134e-02,  -1.627804139697492e-03,   6.134568325675299e-05,  -2.199133596541809e-06,   7.047869003453055e-08,
  -1.792208424024657e-09,   2.456684234015878e-11,   5.240604155173182e-13,  -4.054833089219718e-14,   4.875842734575982e-16,   6.817625866093280e-17,  -5.308039050480136e-18,
   1.902876350969882e-19,  -1.447633766448105e-21,   4.245228996028514e-02,  -1.627926551485732e-03,   6.135350809086968e-05,  -2.199464362535487e-06,   7.048545753801325e-08,
  -1.792004420541383e-09,   2.454599427602163e-11,   5.243716423157157e-13,  -4.049104531094717e-14,   4.821846691395001e-16,   6.840698363817293e-17,  -5.309991006461231e-18,
   1.898452304556716e-19,  -1.413667397934871e-21,   4.245247150711219e-02,  -1.627945977110770e-03,   6.135474980698734e-05,  -2.199516849382279e-06,   7.048653127215245e-08,
  -1.791972044495909e-09,   2.454268689437048e-11,   5.244209195485860e-13,  -4.048194903143853e-14,   4.813277684611625e-16,   6.844357986138778e-17,  -5.310299255428717e-18,
   1.897749669336641e-19,  -1.408277595936516e-21,   4.195916218480377e-01,  -1.603324894622821e-02,   5.993244897604925e-04,  -2.100132333887498e-05,   6.257457148395147e-07,
  -1.164428931081484e-08,  -2.051431669458301e-10,   3.320885168037399e-11,  -1.862711421527047e-12,   6.596124595967238e-14,  -1.140115073566578e-15,  -3.668087254588795e-17,
   4.208932908455891e-18,  -2.063163969566483e-19,   4.196485109272097e-01,  -1.603919182805482e-02,   5.996744781765528e-04,  -2.101165802815777e-05,   6.253983759256385e-07,
  -1.157549051996052e-08,  -2.101103820142565e-10,   3.342477918792431e-11,  -1.866605712431469e-12,   6.571347644796514e-14,  -1.111961978371493e-15,  -3.818861071563467e-17,
   4.255511996127650e-18,  -2.063805028281312e-19,   4.197489190269391e-01,  -1.604968039727625e-02,   6.002918654952510e-04,  -2.102984026478718e-05,   6.247797826396958e-07,
  -1.145375176218412e-08,  -2.188828613610582e-10,   3.380506372709615e-11,  -1.873378865706891e-12,   6.526996757950290e-14,  -1.062058894019960e-15,  -4.084866591943581e-17,
   4.337003000580427e-18,  -2.064379180527028e-19,   4.198703786185243e-01,  -1.606236713333334e-02,   6.010381204898986e-04,  -2.105173504614295e-05,   6.240220342044316e-07,
  -1.130596128935215e-08,  -2.295037062599681e-10,   3.426366331527340e-11,  -1.881400760996129e-12,   6.472290544761745e-14,  -1.001331819085722e-15,  -4.406436907828049e-17,
   4.434339724332721e-18,  -2.064120910581290e-19,   4.199883366430655e-01,  -1.607468721359345e-02,   6.017622592918038e-04,  -2.107289421019805e-05,   6.232762195495656e-07,
  -1.116187975909292e-08,  -2.398277382502845e-10,   3.470754545630248e-11,  -1.889011402134998e-12,   6.418055573000871e-14,  -9.419803709087146e-16,  -4.718492058316849e-17,
   4.527557393884227e-18,  -2.062869195355919e-19,   4.200833958699854e-01,  -1.608461498002198e-02,   6.023453904759415e-04,  -2.108987087928462e-05,   6.226680836747582e-07,
  -1.104537389217025e-08,  -2.481541849439740e-10,   3.506417584285486e-11,  -1.895015241266614e-12,   6.373557262268963e-14,  -8.938842449506049e-16,  -4.969773152721327e-17,
   4.601727959158982e-18,  -2.061141212720568e-19,   4.201462258472884e-01,  -1.609117647328112e-02,   6.027306020517927e-04,  -2.110105497117358e-05,   6.222626535770147e-07,
  -1.096817588758179e-08,  -2.536607707482058e-10,   3.529935880819630e-11,  -1.898920007370685e-12,   6.343758400196296e-14,  -8.619653561584147e-16,  -5.135754725112405e-17,
   4.650281623672881e-18,  -2.059646096972096e-19,   4.201784971591943e-01,  -1.609454654695067e-02,   6.029283921225463e-04,  -2.110678807443538e-05,   6.220533367825630e-07,
  -1.092846521110691e-08,  -2.564900828756460e-10,   3.541998961386342e-11,  -1.900905934582649e-12,   6.328333074831856e-14,  -8.455310529608181e-16,  -5.220973709214283e-17,
   4.675074026378129e-18,  -2.058768824170356e-19,   4.201897302986324e-01,  -1.609571960081569e-02,   6.029972292622960e-04,  -2.110878186658250e-05,   6.219803055570905e-07,
  -1.091463307576852e-08,  -2.574750754206140e-10,   3.546195280216373e-11,  -1.901594069565558e-12,   6.322944699697330e-14,  -8.398042064931184e-16,  -5.250631535086689e-17,
   4.683680524721105e-18,  -2.058446037721645e-19,   4.201915128817879e-01,  -1.609590575157640e-02,   6.030081525067092e-04,  -2.110909817477743e-05,   6.219687081229532e-07,
  -1.091243760942895e-08,  -2.576313908115299e-10,   3.546861066645256e-11,  -1.901703120576300e-12,   6.322088715498443e-14,  -8.388951153720721e-16,  -5.255337657928898e-17,
   4.685045177022837e-18,  -2.058393987499704e-19,   3.673851641717211e-02,  -1.222079354912669e-03,   4.041253949560555e-05,  -1.312438767798556e-06,   4.070009237826664e-08,
  -1.140959840199256e-09,   2.578118845254379e-11,  -3.069052033116311e-13,  -8.662081388213491e-15,   6.954241891746234e-16,  -2.177906994284153e-17,   1.119999821526273e-19,
   2.814577504010773e-20,  -1.847431379957852e-21,   3.674235145523649e-02,  -1.222452262909753e-03,   4.043563608612225e-05,  -1.313513145041234e-06,   4.073605492705094e-08,
  -1.141526756334883e-09,   2.575670804688094e-11,  -3.045595253536298e-13,  -8.747433314235011e-15,   6.954550293341716e-16,  -2.157989377461305e-17,   9.801968055515642e-20,
   2.869077617180639e-20,  -1.856505500160556e-21,   3.674912022486616e-02,  -1.223110511419523e-03,   4.047640676039577e-05,  -1.315409321221754e-06,   4.079948274581992e-08,
  -1.142523335996699e-09,   2.571333385867561e-11,  -3.004208586206481e-13,  -8.897333136690093e-15,   6.954503842679859e-16,  -2.122573997466635e-17,   7.330226569319600e-20,
   2.964912474130222e-20,  -1.872148431757119e-21,   3.675730813721501e-02,  -1.223906892886359e-03,   4.052573501017890e-05,  -1.317702912977943e-06,   4.087613133024946e-08,
  -1.143722012662509e-09,   2.566058265748409e-11,  -2.954169939019974e-13,  -9.077385233541509e-15,   6.953439274856785e-16,  -2.079289428401337e-17,   4.333175601467011e-20,
   3.080222811203432e-20,  -1.890432919621980e-21,   3.676526000929468e-02,  -1.224680446480292e-03,   4.057365124152234e-05,  -1.319930238667548e-06,   4.095048895066524e-08,
  -1.144878968132894e-09,   2.560905710047268e-11,  -2.905601573494371e-13,  -9.250903279152501e-15,   6.951348158304657e-16,  -2.036789444858162e-17,   1.415303679348983e-20,
   3.191551266228369e-20,  -1.907518757700922e-21,   3.677166821934368e-02,  -1.225303926690704e-03,   4.061227286228931e-05,  -1.321725076393159e-06,   4.101035346188878e-08,
  -1.145806197264713e-09,   2.556732360721832e-11,  -2.866482472784108e-13,  -9.389769122875907e-15,   6.948904621997346e-16,  -2.002209141812689e-17,  -9.411672780852298e-21,
   3.280788815834087e-20,  -1.920804365555206e-21,   3.677590376964195e-02,  -1.225716065804180e-03,   4.063780358476818e-05,  -1.322911333505497e-06,   4.104989268887601e-08,
  -1.146416544277984e-09,   2.553963699369157e-11,  -2.840637073577640e-13,  -9.481077430779743e-15,   6.946917910439924e-16,  -1.979191665605042e-17,  -2.501100250767147e-20,
   3.339533161182925e-20,  -1.929347978374002e-21,   3.677807927358923e-02,  -1.225927766743626e-03,   4.065091799953624e-05,  -1.323520613647068e-06,   4.107019234238210e-08,
  -1.146729260145036e-09,   2.552538469892743e-11,  -2.827365488005370e-13,  -9.527828418924642e-15,   6.945782477350602e-16,  -1.967319408278002e-17,  -3.303060335729830e-20,
   3.369631767152346e-20,  -1.933662561872971e-21,   3.677883653278293e-02,  -1.226001458802089e-03,   4.065548309584874e-05,  -1.323732691958959e-06,   4.107725692522108e-08,
  -1.146837988108445e-09,   2.552041866862594e-11,  -2.822746399987867e-13,  -9.544078165952939e-15,   6.945368937038387e-16,  -1.963178941211806e-17,  -3.582325716147189e-20,
   3.380096747844318e-20,  -1.935152656766976e-21,   3.677895670200476e-02,  -1.226013153078039e-03,   4.065620753769453e-05,  -1.323766346472652e-06,   4.107837793459827e-08,
  -1.146855236248284e-09,   2.551963037234563e-11,  -2.822013424406799e-13,  -9.546655714519992e-15,   6.945302442939268e-16,  -1.962521516095963e-17,  -3.626647712643529e-20,
   3.381756867247244e-20,  -1.935388561562970e-21,   3.636679095298523e-01,  -1.209478628046397e-02,   3.994550683922150e-04,  -1.290029850231837e-05,   3.921871332173046e-07,
  -1.029657180275352e-08,   1.782859715603535e-10,   1.981941384001179e-12,  -3.669135613972060e-13,   2.045999157502472e-14,  -7.760633279524778e-16,   2.024088647618143e-17,
  -2.041541904811028e-19,  -1.395401090688689e-20,   3.637058039376512e-01,  -1.209844831931909e-02,   3.996770121304316e-04,  -1.290990794148807e-05,   3.924255450416868e-07,
  -1.029152499824945e-08,   1.772546787576504e-10,   2.053558702785517e-12,  -3.702102168967251e-13,   2.055919609044836e-14,  -7.768436774852920e-16,   2.011236282888050e-17,
  -1.938828241783184e-19,  -1.443180230426539e-20,   3.637726862903419e-01,  -1.210491223383105e-02,   4.000687414443327e-04,  -1.292685974665331e-05,   3.928450205562419e-07,
  -1.028250394735221e-08,   1.754278984082474e-10,   2.180196903271852e-12,  -3.760294646971714e-13,   2.073367800014517e-14,  -7.781678198392369e-16,   1.988271996848690e-17,
  -1.756566079653198e-19,  -1.527641893280432e-20,   3.638535902633980e-01,  -1.211273220057328e-02,   4.005426052306000e-04,  -1.294735082565262e-05,   3.933501931441518e-07,
  -1.027139771194607e-08,   1.732069158634186e-10,   2.333785570662451e-12,  -3.830698675413376e-13,   2.094369003731308e-14,  -7.796786150525534e-16,   1.960014951018681e-17,
  -1.534434737258878e-19,  -1.630031479934240e-20,   3.639321609380106e-01,  -1.212032759632378e-02,   4.010028125278673e-04,  -1.296723556643719e-05,   3.938384399166796e-07,
  -1.026040837797338e-08,   1.710382334645498e-10,   2.483363321721705e-12,  -3.899082890916011e-13,   2.114653627259004e-14,  -7.810501878008930e-16,   1.932071334964625e-17,
  -1.316980077018295e-19,  -1.729691616431569e-20,   3.639954783079314e-01,  -1.212644914731473e-02,   4.013736842763422e-04,  -1.298324892297216e-05,   3.942302082397716e-07,
  -1.025140651325144e-08,   1.692821473227492e-10,   2.604201645991300e-12,  -3.954197844621007e-13,   2.130920127237475e-14,  -7.820866711015268e-16,   1.909192851490186e-17,
  -1.140506872868737e-19,  -1.810158852322053e-20,   3.640373280012205e-01,  -1.213049552931754e-02,   4.016188155485791e-04,  -1.299382753277937e-05,   3.944883174475278e-07,
  -1.024538518196051e-08,   1.681173376495953e-10,   2.684215737000719e-12,  -3.990628858634763e-13,   2.141631949092747e-14,  -7.827379259193470e-16,   1.893895034323315e-17,
  -1.023264614086677e-19,  -1.863417219668192e-20,   3.640588231316081e-01,  -1.213257396376263e-02,   4.017447225134870e-04,  -1.299925930576586e-05,   3.946206320744031e-07,
  -1.024227032357940e-08,   1.675177852640391e-10,   2.725358137593139e-12,  -4.009341550918577e-13,   2.147121540003460e-14,  -7.830619477512822e-16,   1.885983126651930e-17,
  -9.628600990196838e-20,  -1.890794385569315e-20,   3.640663052356482e-01,  -1.213329744934913e-02,   4.017885488191113e-04,  -1.300114974846060e-05,   3.946666476547866e-07,
  -1.024118256600620e-08,   1.673088879387940e-10,   2.739686291935522e-12,  -4.015855242923040e-13,   2.149030415084597e-14,  -7.831730638768324e-16,   1.883220436108248e-17,
  -9.418047467894329e-20,  -1.900327426652912e-20,   3.640674925675361e-01,  -1.213341225974938e-02,   4.017955036036765e-04,  -1.300144972923300e-05,   3.946739479013774e-07,
  -1.024100978279336e-08,   1.672757284784555e-10,   2.741960360163145e-12,  -4.016888902927796e-13,   2.149333240406952e-14,  -7.831906174965629e-16,   1.882781613595834e-17,
  -9.384620810992923e-20,  -1.901840385980112e-20,   3.241065236795798e-02,  -9.522374507471550e-04,   2.791754425301470e-05,  -8.134163473160426e-07,   2.328832917229853e-08,
  -6.390133213836984e-10,   1.599882248107488e-11,  -3.286235986736587e-13,   3.709208698324835e-15,   9.185350165502177e-17,  -7.679473185462922e-18,   2.816484474361853e-19,
  -5.842441554592782e-21,  -2.045311945509036e-23,   3.241329618877944e-02,  -9.524683539349170e-04,   2.793077156155102e-05,  -8.140208078913549e-07,   2.331093333199718e-08,
  -6.396546893019896e-10,   1.600786588791131e-11,  -3.282762547523839e-13,   3.675789717432479e-15,   9.328868661773552e-17,  -7.711835355953405e-18,   2.812492116984084e-19,
  -5.762310079525763e-21,  -2.494180435613750e-23,   3.241796227571390e-02,  -9.528759253975021e-04,   2.795412171765715e-05,  -8.150878751856749e-07,   2.335082879309444e-08,
  -6.407858187762280e-10,   1.602375119188768e-11,  -3.276594364064515e-13,   3.616713782800111e-15,   9.581916192523058e-17,  -7.768523614978990e-18,   2.805177338767727e-19,
  -5.619812241867842e-21,  -3.288720496003190e-23,   3.242360630359398e-02,  -9.533690025119278e-04,   2.798237464720357e-05,  -8.163790145956950e-07,   2.339908791706593e-08,
  -6.421526090903454e-10,   1.604283707133214e-11,  -3.269068853608500e-13,   3.545096028278814e-15,   9.887566886476477e-17,  -7.836359748715018e-18,   2.795870525946617e-19,
  -5.445620848880885e-21,  -4.253717338701610e-23,   3.242908725694257e-02,  -9.538479218838015e-04,   2.800982061123418e-05,  -8.176332994048277e-07,   2.344595488018727e-08,
  -6.434784300510887e-10,   1.606123652246148e-11,  -3.261693236429380e-13,   3.475380908677644e-15,   1.018392431640612e-16,  -7.901463545144423e-18,   2.786350886368870e-19,
  -5.274551124510523e-21,  -5.194898383956077e-23,   3.243350395249041e-02,  -9.542339113227662e-04,   2.803194398736165e-05,  -8.186443573051910e-07,   2.348372302804202e-08,
  -6.445457484470883e-10,   1.607596646609674e-11,  -3.255701430077123e-13,   3.419084193791539e-15,   1.042239888980509e-16,  -7.953369287822289e-18,   2.778333792403095e-19,
  -5.135331548741379e-21,  -5.956202537688520e-23,   3.243642306823274e-02,  -9.544890535572228e-04,   2.804656921590783e-05,  -8.193127509696730e-07,   2.350868576052403e-08,
  -6.452506467455422e-10,   1.608565444652505e-11,  -3.251717633467951e-13,   3.381818533677777e-15,   1.057984500137353e-16,  -7.987401401436139e-18,   2.772865402265486e-19,
  -5.042649089590650e-21,  -6.460762245988272e-23,   3.243792237242921e-02,  -9.546201083036241e-04,   2.805408197965106e-05,  -8.196560972786892e-07,   2.352150723515800e-08,
  -6.456125320180612e-10,   1.609061566566271e-11,  -3.249664184212718e-13,   3.362660564826678e-15,   1.066065917610507e-16,  -8.004795878984825e-18,   2.770004214874219e-19,
  -4.994839409344051e-21,  -6.720339590417177e-23,   3.243844425060428e-02,  -9.546657274073735e-04,   2.805669718574279e-05,  -8.197756170973680e-07,   2.352597017162943e-08,
  -6.457384713654415e-10,   1.609234022999769e-11,  -3.248948256086525e-13,   3.355989238388319e-15,   1.068878055907681e-16,  -8.010837003562575e-18,   2.768999922874863e-19,
  -4.978164948845884e-21,  -6.810761096636103e-23,   3.243852706698439e-02,  -9.546729667349646e-04,   2.805711219811807e-05,  -8.197945839581921e-07,   2.352667839264522e-08,
  -6.457584553438445e-10,   1.609261378855782e-11,  -3.248834590891356e-13,   3.354930438041573e-15,   1.069324271464001e-16,  -8.011795020484510e-18,   2.768840155255659e-19,
  -4.975517334306046e-21,  -6.825113215298940e-23,   3.208315188243201e-01,  -9.425804065083341e-03,   2.762682633040160e-04,  -8.038344736499521e-06,   2.289175891294337e-07,
  -6.173120370526670e-09,   1.464021350644196e-10,  -2.451905536255880e-12,  -9.819013807209788e-15,   3.283796036411138e-15,  -1.831595604829508e-16,   7.064258888920475e-18,
  -2.073686827273405e-19,   4.240531398375367e-21,   3.208576797674563e-01,  -9.428085374710623e-03,   2.763981879783462e-04,  -8.044170782679730e-06,   2.291229349729938e-07,
  -6.177753416605397e-09,   1.463594243441927e-10,  -2.439840014951484e-12,  -1.063295848898359e-14,   3.321328386261446e-15,  -1.844424260748714e-16,   7.093070899335817e-18,
  -2.073895161860685e-19,   4.201922524330734e-21,   3.209038512047521e-01,  -9.432112120331437e-03,   2.766275358860009e-04,  -8.054454403549637e-06,   2.294852154015444e-07,
  -6.185908701022144e-09,   1.462822985237833e-10,  -2.418446421851039e-12,  -1.207357574988945e-14,   3.387673281816888e-15,  -1.867059733297235e-16,   7.143669460214349e-18,
  -2.074088130063501e-19,   4.132971873500208e-21,   3.209596993266479e-01,  -9.436983587613081e-03,   2.769050257019556e-04,  -8.066895375072674e-06,   2.299231926647425e-07,
  -6.195736285924508e-09,   1.461860262322186e-10,  -2.392399868508744e-12,  -1.382308581614513e-14,   3.468099537365661e-15,  -1.894428656862351e-16,   7.204440010483908e-18,
  -2.074022340409430e-19,   4.048186491361997e-21,   3.210139336576771e-01,  -9.441715115605378e-03,   2.771745754061221e-04,  -8.078979027376558e-06,   2.303482709882928e-07,
  -6.205241118453575e-09,   1.460894055432845e-10,  -2.366928491950949e-12,  -1.552933341866983e-14,   3.546385842364962e-15,  -1.920994921086143e-16,   7.262997387971784e-18,
  -2.073643505018655e-19,   3.964398012296168e-21,   3.210576369885391e-01,  -9.445528487271834e-03,   2.773918410613820e-04,  -8.088717873526999e-06,   2.306906339119126e-07,
  -6.212872465464801e-09,   1.460092983906577e-10,  -2.346275736609328e-12,  -1.690949075182432e-14,   3.609602009985447e-15,  -1.942393646796343e-16,   7.309853841223820e-18,
  -2.073111432468139e-19,   3.895835489579740e-21,   3.210865216689456e-01,  -9.448049134867905e-03,   2.775354650439306e-04,  -8.095155286415223e-06,   2.309168241744943e-07,
  -6.217902536494878e-09,   1.459552508418277e-10,  -2.332563395084911e-12,  -1.782422874152815e-14,   3.651447180985635e-15,  -1.956531992266067e-16,   7.340659495553142e-18,
  -2.072648268204303e-19,   3.850008624977921e-21,   3.211013572824825e-01,  -9.449343867690493e-03,   2.776092409855010e-04,  -8.098461872147776e-06,   2.310329721277018e-07,
  -6.220481817072011e-09,   1.459271497747674e-10,  -2.325501218891296e-12,  -1.829484229926239e-14,   3.672959214838761e-15,  -1.963792181594803e-16,   7.356431086014100e-18,
  -2.072375799590686e-19,   3.826312658959369e-21,   3.211065212638029e-01,  -9.449794552650164e-03,   2.776349222676408e-04,  -8.099612865578204e-06,   2.310733966349054e-07,
  -6.221378937369126e-09,   1.459173139619995e-10,  -2.323039941222976e-12,  -1.845877926516015e-14,   3.680450258021241e-15,  -1.966319068724940e-16,   7.361912773897041e-18,
  -2.072275444890873e-19,   3.818039299050029e-21,   3.211073407312443e-01,  -9.449866072109132e-03,   2.776389976706253e-04,  -8.099795517413845e-06,   2.310798113593672e-07,
  -6.221521268463955e-09,   1.459157505430444e-10,  -2.322649217338101e-12,  -1.848480024148613e-14,   3.681639153391543e-15,  -1.966720046635708e-16,   7.362782273467366e-18,
  -2.072259257765430e-19,   3.816725207316967e-21,   2.899437883248861e-02,  -7.624568822895508e-04,   2.003014198637833e-05,  -5.250474576821572e-07,   1.367869879832059e-08,
  -3.505996950595092e-10,   8.650347964805292e-12,  -1.968155734108118e-13,   3.762211606492779e-15,  -4.348423923176548e-17,  -6.779855741763090e-19,   6.563736814773236e-20,
  -2.577553206440726e-21,   6.811266315422158e-23,   2.899627224137746e-02,  -7.626057216091488e-04,   2.003790562078573e-05,  -5.253794223935765e-07,   1.369097915587363e-08,
  -3.509893387465515e-10,   8.660152226784599e-12,  -1.969529431327469e-13,   3.758826148280754e-15,  -4.312691603268568e-17,  -6.942694799298738e-19,   6.612443937692270e-20,
  -2.585006808372544e-21,   6.792487471617025e-23,   2.899961379124486e-02,  -7.628684274112389e-04,   2.005161031927991e-05,  -5.259654769995945e-07,   1.371265922054976e-08,
  -3.516770863846437e-10,   8.677444457063034e-12,  -1.971943398746368e-13,   3.752796314346843e-15,  -4.249438361737550e-17,  -7.230385451753323e-19,   6.698266037273918e-20,
  -2.598011588368399e-21,   6.758557849307786e-23,   2.900365545256183e-02,  -7.631862245276031e-04,   2.006819181316639e-05,  -5.266746481194581e-07,   1.373889404410102e-08,
  -3.525090840478463e-10,   8.698341460812167e-12,  -1.974845402410850e-13,   3.745409170081233e-15,  -4.172606101220409e-17,  -7.578870305213922e-19,   6.801831097840258e-20,
  -2.613484680283684e-21,   6.716171875157521e-23,   2.900758009960426e-02,  -7.634948731366026e-04,   2.008429892515487e-05,  -5.273636308904826e-07,   1.376438230587209e-08,
  -3.533171547058736e-10,   8.718614248394294e-12,  -1.977644775514970e-13,   3.738137428839088e-15,  -4.097657066498595e-17,  -7.917801613012538e-19,   6.902144152363991e-20,
  -2.628239553169452e-21,   6.673597252630489e-23,   2.901074251271978e-02,  -7.637436144076301e-04,   2.009728183393909e-05,  -5.279190475276365e-07,   1.378492960606393e-08,
  -3.539683984322520e-10,   8.734935879530173e-12,  -1.979887096352658e-13,   3.732207378678118e-15,  -4.037020348634358e-17,  -8.191285722608380e-19,   6.982790086105147e-20,
  -2.639933932899892e-21,   6.638273659135583e-23,   2.901283255535569e-02,  -7.639080261918907e-04,   2.010586424947831e-05,  -5.282862435720617e-07,   1.379851388951131e-08,
  -3.543988617126422e-10,   8.745716063524074e-12,  -1.981362492350155e-13,   3.728253610263245e-15,  -3.996826133260702e-17,  -8.372215360437467e-19,   7.035997521435117e-20,
  -2.647566873008669e-21,   6.614428656665360e-23,   2.901390600867806e-02,  -7.639924743529028e-04,   2.011027282577452e-05,  -5.284748740344959e-07,   1.380549223137319e-08,
  -3.546199662581993e-10,   8.751250694706308e-12,  -1.982118230720543e-13,   3.726212238934023e-15,  -3.976145372726012e-17,  -8.465197846024093e-19,   7.063296483451768e-20,
  -2.651457419563699e-21,   6.602026998102582e-23,   2.901427965247422e-02,  -7.640218696720411e-04,   2.011180744551837e-05,  -5.285405377848498e-07,   1.380792145136637e-08,
  -3.546969302483280e-10,   8.753176832952403e-12,  -1.982380961985059e-13,   3.725499981593249e-15,  -3.968941021297610e-17,  -8.497571795889624e-19,   7.072794038624602e-20,
  -2.652806880287124e-21,   6.597685607549360e-23,   2.901433894547881e-02,  -7.640265344165515e-04,   2.011205097681600e-05,  -5.285509581540118e-07,   1.380830695146304e-08,
  -3.547091436833575e-10,   8.753482473120746e-12,  -1.982422639077549e-13,   3.725386873578703e-15,  -3.967797494557863e-17,  -8.502709595709577e-19,   7.074300974797164e-20,
  -2.653020798764913e-21,   6.596995506992604e-23,   2.870146362612548e-01,  -7.547490606313960e-03,   1.982652844001491e-04,  -5.195432207349018e-06,   1.351669415192801e-07,
  -3.447880374722035e-09,   8.382947530927328e-11,  -1.826244004069683e-12,   3.003386667654035e-14,  -5.414509005285769e-17,  -2.425340436736016e-17,   1.385049493938857e-18,
  -5.332451503235592e-20,   1.621261648980815e-21,   2.870333775870476e-01,  -7.548963317363701e-03,   1.983419866447285e-04,  -5.198694810527687e-06,   1.352857269237364e-07,
  -3.451475049221929e-09,   8.390593574424141e-11,  -1.826226290781605e-12,   2.992037012446335e-14,  -4.652805842944252e-17,  -2.459866364431132e-17,   1.397218966541898e-18,
  -5.365540589943591e-20,   1.627048252690538e-21,   2.870664528782154e-01,  -7.551562690492936e-03,   1.984773834970778e-04,  -5.204454464674834e-06,   1.354954121075404e-07,
  -3.457817781002222e-09,   8.404060234875377e-11,  -1.826173784415575e-12,   2.971890602442826e-14,  -3.303635385564241e-17,  -2.520954068274986e-17,   1.418725707047097e-18,
  -5.423901516310806e-20,   1.637193575324672e-21,   2.871064579825615e-01,  -7.554707161735533e-03,   1.986411998312410e-04,  -5.211423770985227e-06,   1.357491129093142e-07,
  -3.465487238327823e-09,   8.420301625481657e-11,  -1.826073961604641e-12,   2.947324749334330e-14,  -1.663441964713509e-17,  -2.595105192964247e-17,   1.444788760412286e-18,
  -5.494427170881820e-20,   1.649349279367223e-21,   2.871453048349708e-01,  -7.557761102489784e-03,   1.988003273298221e-04,  -5.218194344153632e-06,   1.359955551858430e-07,
  -3.472932331455881e-09,   8.436023609627098e-11,  -1.825938885602735e-12,   2.923261893011290e-14,  -6.198295708178113e-19,  -2.667386277832670e-17,   1.470149528624670e-18,
  -5.562842717798206e-20,   1.661031248982349e-21,   2.871766069441056e-01,  -7.560222279731721e-03,   1.989285882106152e-04,  -5.223652134290618e-06,   1.361941959883465e-07,
  -3.478929777374376e-09,   8.448656722380763e-11,  -1.825802634356702e-12,   2.903722949703020e-14,   1.234722958521042e-17,  -2.725827295999271e-17,   1.490622007286636e-18,
  -5.617920190906305e-20,   1.670356313152426e-21,   2.871972945375227e-01,  -7.561849053125512e-03,   1.990133749196459e-04,  -5.227260260604235e-06,   1.363255081312891e-07,
  -3.482892664359693e-09,   8.456988572467690e-11,  -1.825699133412052e-12,   2.890736312752446e-14,   2.094793838379049e-17,  -2.764547996368767e-17,   1.504170405026417e-18,
  -5.654295496844636e-20,   1.676475818799213e-21,   2.872079197564492e-01,  -7.562684624893721e-03,   1.990569275315563e-04,  -5.229113736730482e-06,   1.363929598344097e-07,
  -3.484927757975686e-09,   8.461262449597361e-11,  -1.825641807930785e-12,   2.884043627284491e-14,   2.537481238404186e-17,  -2.784465057422679e-17,   1.511134488781439e-18,
  -5.672969961781831e-20,   1.679605315903282e-21,   2.872116181442757e-01,  -7.562975476512859e-03,   1.990720881014965e-04,  -5.229758940544540e-06,   1.364164396642515e-07,
  -3.485636084657392e-09,   8.462749226133952e-11,  -1.825621190287958e-12,   2.881710444682903e-14,   2.691721883757981e-17,  -2.791402487083460e-17,   1.513559408242789e-18,
  -5.679468812687713e-20,   1.680692464342907e-21,   2.872122050361803e-01,  -7.563021631761211e-03,   1.990744939551245e-04,  -5.229861329514204e-06,   1.364201657155049e-07,
  -3.485748486044702e-09,   8.462985119777306e-11,  -1.825617886969478e-12,   2.881340023506277e-14,   2.716205310962979e-17,  -2.792503604397342e-17,   1.513944257299771e-18,
  -5.680500044619168e-20,   1.680864879926393e-21,   2.622986441182714e-02,  -6.241727128377256e-04,   1.484364420770099e-05,  -3.526662040600877e-07,   8.360725759817051e-09,
  -1.970594126135306e-10,   4.576713473862076e-12,  -1.027964491209631e-13,   2.152327416235501e-15,  -3.884305169148722e-17,   2.623199124089940e-02,  -6.243242743400598e-04,
   1.485083894926070e-05,  -3.529492573982204e-07,   8.370597917272542e-09,  -1.973697783375127e-10,   4.585348534220058e-12,  -1.029945176159423e-13,   2.155185847910133e-15,
  -3.880971450643299e-17,   2.623548352420225e-02,  -6.245731750421974e-04,   1.486265640757662e-05,  -3.534142558288035e-07,   8.386818015785868e-09,  -1.978797211183374e-10,
   4.599532490281519e-12,  -1.033195462541915e-13,   2.159856569841977e-15,  -3.875374078643862e-17,   2.623919012525854e-02,  -6.248373975353109e-04,   1.487520397408358e-05,
  -3.539080910238340e-07,   8.404046950501367e-09,  -1.984213902811701e-10,   4.614593747051426e-12,  -1.036642436510838e-13,   2.164782738291694e-15,  -3.869265174872714e-17,
   2.624210797751570e-02,  -6.250454286710812e-04,   1.488508500952298e-05,  -3.542970577270381e-07,   8.417619363881434e-09,  -1.988481068981132e-10,   4.626454959819066e-12,
  -1.039353877294306e-13,   2.168637964666776e-15,  -3.864334277674135e-17,   2.624379222292860e-02,  -6.251655222534421e-04,   1.489078996846616e-05,  -3.545216646722581e-07,
   8.425457542463366e-09,  -1.990945417714709e-10,   4.633303465100181e-12,  -1.040918156689060e-13,   2.170854163051443e-15,  -3.861439087661668e-17,   2.624442472975288e-02,
  -6.252106251568698e-04,   1.489293269485754e-05,  -3.546060307601879e-07,   8.428401853403275e-09,  -1.991871123353649e-10,   4.635875744530620e-12,  -1.041505455148529e-13,
   2.171684714051155e-15,  -3.860342551648449e-17,   2.624452957976306e-02,  -6.252181019552942e-04,   1.489328790657017e-05,  -3.546200169103279e-07,   8.428889967683921e-09,
  -1.992024589098020e-10,   4.636302168164616e-12,  -1.041602802768468e-13,   2.171822302443242e-15,  -3.860160290844177e-17,   2.596488717649729e-01,  -6.178665039089322e-03,
   1.469350963990028e-04,  -3.490744923167528e-06,   8.272790451285215e-08,  -1.947357465012365e-09,   4.503899309507637e-11,  -9.994197073983509e-13,   2.022282625355423e-14,
  -3.274026444146637e-16,   2.596699248745540e-01,  -6.180165200595182e-03,   1.470062837644698e-04,  -3.493541617518896e-06,   8.282500488266515e-08,  -1.950370342679999e-09,
   4.511976066481912e-11,  -1.001061206861539e-12,   2.023227829489024e-14,  -3.260913673880283e-16,   2.597044943732208e-01,  -6.182628827540082e-03,   1.471232095801520e-04,
  -3.498135953891118e-06,   8.298453556737569e-08,  -1.955319990952705e-09,   4.525237843890064e-11,  -1.003750961730323e-12,   2.024736285683991e-14,  -3.239153348930029e-16,
   2.597411853603442e-01,  -6.185244107789054e-03,   1.472473588140828e-04,  -3.503015128598104e-06,   8.315397946933869e-08,  -1.960576730896512e-09,   4.539312907381476e-11,
  -1.006598112373748e-12,   2.026277843346893e-14,  -3.215745459348021e-16,   2.597700686589836e-01,  -6.187303203057865e-03,   1.473451242496764e-04,  -3.506858128011719e-06,
   8.328745545987962e-08,  -1.964717269310918e-09,   4.550392385718039e-11,  -1.008833810596741e-12,   2.027448119565020e-14,  -3.197091909844188e-16,   2.597867407021197e-01,
  -6.188491890455408e-03,   1.474015703901633e-04,  -3.509077226548431e-06,   8.336453627297699e-08,  -1.967108238920813e-09,   4.556787485038756e-11,  -1.010122049302977e-12,
   2.028106232087185e-14,  -3.186233550485852e-16,   2.597930017733863e-01,  -6.188938319288341e-03,   1.474227709761876e-04,  -3.509910752362142e-06,   8.339349018635510e-08,
  -1.968006333170815e-09,   4.559189079356200e-11,  -1.010605411238784e-12,   2.028350086623370e-14,  -3.182138512822618e-16,   2.597940396647591e-01,  -6.189012324681383e-03,
   1.474262855141547e-04,  -3.510048933450206e-06,   8.339829020265107e-08,  -1.968155218932493e-09,   4.559587186954994e-11,  -1.010685515077511e-12,   2.028390336134367e-14,
  -3.181458771626607e-16,   2.394672838070193e-02,  -5.203425193754858e-04,   1.130118188267481e-05,  -2.453099197244579e-07,   5.320024766530163e-09,  -1.151359649145477e-10,
   2.478509088644065e-12,  -5.266456229128436e-14,   1.087170133267883e-15,  -2.113512858134896e-17,   2.394834581817274e-02,  -5.204478314649736e-04,   1.130575465155915e-05,
  -2.454751118226834e-07,   5.325367517242440e-09,  -1.152950974499274e-10,   2.482889205091057e-12,  -5.277376182905983e-14,   1.089491977075832e-15,  -2.116968173295487e-17,
   2.395100157886079e-02,  -5.206207695992325e-04,   1.131326490585128e-05,  -2.457464658042814e-07,   5.334145291072358e-09,  -1.155565757384878e-10,   2.490086559464849e-12,
  -5.295315707111911e-14,   1.093303177977089e-15,  -2.122621836995088e-17,   2.395382019240300e-02,  -5.208043400698165e-04,   1.132123837261902e-05,  -2.460346169443744e-07,
   5.343468413094257e-09,  -1.158343459559582e-10,   2.497732592512289e-12,  -5.314368086257480e-14,   1.097346474231667e-15,  -2.128595130461220e-17,   2.395603892408780e-02,
  -5.209488615138348e-04,   1.132751679753534e-05,  -2.462615553994321e-07,   5.350812443160082e-09,  -1.160531855012846e-10,   2.503756636942348e-12,  -5.329374800633821e-14,
   1.100528053389687e-15,  -2.133277443163698e-17,   2.395731958518307e-02,  -5.210322879230808e-04,   1.133114150856913e-05,  -2.463925909893917e-07,   5.355053507285602e-09,
  -1.161795754884810e-10,   2.507235866635641e-12,  -5.338040426112903e-14,   1.102363990703075e-15,  -2.135972165930935e-17,   2.395780052163363e-02,  -5.210636191991593e-04,
   1.133250287113848e-05,  -2.464418084405630e-07,   5.356646575905382e-09,  -1.162270538448429e-10,   2.508542850159249e-12,  -5.341295390399293e-14,   1.103053362058098e-15,
  -2.136982633394324e-17,   2.395788024560591e-02,  -5.210688130086997e-04,   1.133272854953077e-05,  -2.464499675857266e-07,   5.356910676575759e-09,  -1.162349249937266e-10,
   2.508759527666520e-12,  -5.341834996656026e-14,   1.103167633024382e-15,  -2.137150057417995e-17,   2.370481704254275e-01,  -5.150858803816167e-03,   1.118699048127971e-04,
  -2.428276065807864e-06,   5.265779964978050e-08,  -1.139245863166393e-09,   2.449599310841618e-11,  -5.186654985760527e-13,   1.060222238484795e-14,  -2.007343361826310e-16,
   2.370641813587006e-01,  -5.151901265480725e-03,   1.119151657551110e-04,  -2.429910537783909e-06,   5.271059643313431e-08,  -1.140812396344058e-09,   2.453865621384808e-11,
  -5.196989578746625e-13,   1.062237451546257e-14,  -2.009271421504414e-16,   2.370904706014173e-01,  -5.153613142537001e-03,   1.119895016644082e-04,  -2.432595406332257e-06,
   5.279733694570733e-08,  -1.143386349682256e-09,   2.460875242632318e-11,  -5.213962352776123e-13,   1.065541931441557e-14,  -2.012400622311195e-16,   2.371183719156487e-01,
  -5.155430266451440e-03,   1.120684223389175e-04,  -2.435446460027187e-06,   5.288946514790890e-08,  -1.146120552289513e-09,   2.468320844639994e-11,  -5.231981036432068e-13,
   1.069043001604488e-14,  -2.015671748371404e-16,   2.371403350288666e-01,  -5.156860852356456e-03,   1.121305655828694e-04,  -2.437691848604097e-06,   5.296203559383830e-08,
  -1.148274585186120e-09,   2.474186252795561e-11,  -5.246168480032839e-13,   1.071794531079960e-14,  -2.018210330746614e-16,   2.371530122283310e-01,  -5.157686671887614e-03,
   1.121664426007490e-04,  -2.438988345677301e-06,   5.300394351188424e-08,  -1.149518602196872e-09,   2.477573569841164e-11,  -5.254358975397315e-13,   1.073380944164776e-14,
  -2.019660978638643e-16,   2.371577729939082e-01,  -5.157996813225597e-03,   1.121799172235740e-04,  -2.439475314116407e-06,   5.301968528550477e-08,  -1.149985909781759e-09,
   2.478845970937297e-11,  -5.257435085329289e-13,   1.073976363881927e-14,  -2.020202978773810e-16,   2.371585621774716e-01,  -5.158048225590853e-03,   1.121821509642267e-04,
  -2.439556042484300e-06,   5.302229497011634e-08,  -1.150063381504349e-09,   2.479056912304260e-11,  -5.257945020768929e-13,   1.074075047666974e-14,  -2.020292678715900e-16,
   2.202936954062273e-02,  -4.404171328351842e-04,   8.801447245727289e-06,  -1.758180394684062e-07,   3.510371545367039e-09,  -7.002836373782017e-11,   1.394306638775589e-12,
  -2.762915613547567e-14,   5.413389621457026e-16,  -1.034544683065410e-17,   2.203062811327538e-02,  -4.404925481375880e-04,   8.804461578998811e-06,  -1.759184001400889e-07,
   3.513373806135094e-09,  -7.011179087777036e-11,   1.396488938254815e-12,  -2.768280670043464e-14,   5.425554458564723e-16,  -1.036965614001798e-17,   2.203269457682838e-02,
  -4.406163857000153e-04,   8.809411956173972e-06,  -1.760832446000570e-07,   3.518305883709711e-09,  -7.024886634376378e-11,   1.400075049300989e-12,  -2.777097248219239e-14,
   5.445541844395712e-16,  -1.040940632163972e-17,   2.203488767968485e-02,  -4.407478292598283e-04,   8.814667219763678e-06,  -1.762582744986898e-07,   3.523543796797680e-09,
  -7.039447219541639e-11,   1.403884967792741e-12,  -2.786464510912153e-14,   5.466772854468718e-16,  -1.045159316442584e-17,   2.203661397118310e-02,  -4.408513066955388e-04,
   8.818804973110061e-06,  -1.763961088468750e-07,   3.527669393064169e-09,  -7.050917938231869e-11,   1.406886854807675e-12,  -2.793845424082940e-14,   5.483498287387324e-16,
  -1.048480062297914e-17,   2.203761037126357e-02,  -4.409110378424000e-04,   8.821193686649724e-06,  -1.764756897930556e-07,   3.530051691405609e-09,  -7.057542511453481e-11,
   1.408620690588597e-12,  -2.798108632501627e-14,   5.493157473508583e-16,  -1.050396771253409e-17,   2.203798455274807e-02,  -4.409334698064002e-04,   8.822090811327970e-06,
  -1.765055796672716e-07,   3.530946520744293e-09,  -7.060030973813139e-11,   1.409272025609679e-12,  -2.799710178619259e-14,   5.496785842572592e-16,  -1.051116559400493e-17,
   2.203804657991677e-02,  -4.409371883481527e-04,   8.822239529917898e-06,  -1.765105346814209e-07,   3.531094864844768e-09,  -7.060443517932918e-11,   1.409380007559590e-12,
  -2.799975693104135e-14,   5.497387362525266e-16,  -1.051235876936855e-17,   2.180682767989917e-01,  -4.359680003631638e-03,   8.712530827310389e-05,  -1.740413193351363e-06,
   3.474837700841225e-08,  -6.931399337487396e-10,   1.379662541737818e-11,  -2.731149929500093e-13,   5.335458000644019e-15,  -1.011677324267689e-16,   2.180807353771441e-01,
  -4.360426535223968e-03,   8.715514640738943e-05,  -1.741406552036250e-06,   3.477808318199725e-08,  -6.939645128581537e-10,   1.381812656235430e-11,  -2.736391153117276e-13,
   5.347082142477611e-15,  -1.013851921194955e-16,   2.181011912463520e-01,  -4.361652395852640e-03,   8.720414894999237e-05,  -1.743038162779310e-06,   3.482688397727779e-08,
  -6.953193288656262e-10,   1.385345771716359e-11,  -2.745003507350442e-13,   5.366176701680249e-15,  -1.017419890423419e-16,   2.181229007146346e-01,  -4.362953547746779e-03,
   8.725616947574288e-05,  -1.744770586063221e-06,   3.487871068413066e-08,  -6.967584381744482e-10,   1.389099241285229e-11,  -2.754152800196943e-13,   5.386453271041942e-15,
  -1.021203043727070e-16,   2.181399892293110e-01,  -4.363977864625225e-03,   8.729712804206937e-05,  -1.746134851356671e-06,   3.491953138946123e-08,  -6.978921440028823e-10,
   1.392056545269795e-11,  -2.761361244342678e-13,   5.402422400899504e-15,  -1.024178389939553e-16,   2.181498525677793e-01,  -4.364569139621771e-03,   8.732077330566638e-05,
  -1.746922532041503e-06,   3.494310297789003e-08,  -6.985468766995261e-10,   1.393764587989182e-11,  -2.765524545059366e-13,   5.411643035765507e-15,  -1.025894701664869e-16,
   2.181535565805513e-01,  -4.364791192268916e-03,   8.732965371249674e-05,  -1.747218377594490e-06,   3.495195683221618e-08,  -6.987928202128141e-10,   1.394406225464633e-11,
  -2.767088504273510e-13,   5.415106331478655e-15,  -1.026539037728787e-16,   2.181541705858789e-01,  -4.364828001887391e-03,   8.733112583959880e-05,  -1.747267421586460e-06,
   3.495342461660265e-08,  -6.988335933487809e-10,   1.394512599274149e-11,  -2.767347784464196e-13,   5.415680467404200e-15,  -1.026645837389800e-16,   2.039638308181418e-02,
  -3.775858069722026e-04,   6.987654676300302e-06,  -1.292702161400155e-07,   2.390600376850708e-09,  -4.418921052453873e-11,   8.161774517489406e-13,  -1.504852775093562e-14,
   2.762997618294497e-16,  -5.022636441166432e-18,   2.039738160140035e-02,  -3.776412188737742e-04,   6.989705829044047e-06,  -1.293334842352646e-07,   2.392355836214072e-09,
  -4.423459941211372e-11,   8.172904614018774e-13,  -1.507458421290050e-14,   2.768801178271306e-16,  -5.034728934800009e-18,   2.039902104553339e-02,  -3.777322060939362e-04,
   6.993074215934706e-06,  -1.294373959163434e-07,   2.395239430618173e-09,  -4.430916911369737e-11,   8.191193244023317e-13,  -1.511740503685587e-14,   2.778339165470559e-16,
  -5.054600098421766e-18,   2.040076091152193e-02,  -3.778287772347928e-04,   6.996649813646643e-06,  -1.295477179650782e-07,   2.398301491322300e-09,  -4.438837016842941e-11,
   8.210621709718436e-13,  -1.516290233669152e-14,   2.788473987400354e-16,  -5.075711252698654e-18,   2.040213040453187e-02,  -3.779047985449407e-04,   6.999464899056407e-06,
  -1.296345881604907e-07,   2.400713047562103e-09,  -4.445075748973929e-11,   8.225928546690262e-13,  -1.519875321701189e-14,   2.796460488109776e-16,  -5.092344875914860e-18,
   2.040292084965561e-02,  -3.779486796740186e-04,   7.001089969445634e-06,  -1.296847411618571e-07,   2.402105484988446e-09,  -4.448678476401402e-11,   8.234769052936736e-13,
  -1.521946121539443e-14,   2.801073800720218e-16,  -5.101952088848607e-18,   2.040321768552494e-02,  -3.779651589383666e-04,   7.001700280744379e-06,  -1.297035776127116e-07,
   2.402628487879543e-09,  -4.450031758623905e-11,   8.238090004843194e-13,  -1.522724063166785e-14,   2.802806929408460e-16,  -5.105561133082322e-18,   2.040326689115613e-02,
  -3.779678906895529e-04,   7.001801452862539e-06,  -1.297067002087330e-07,   2.402715189890281e-09,  -4.450256106802386e-11,   8.238640566318525e-13,  -1.522853035839236e-14,
   2.803094261654939e-16,  -5.106159459784850e-18,   2.019033776552349e-01,  -3.737714134693271e-03,   6.917064498031368e-05,  -1.279642368721787e-06,   2.366440165915308e-08,
  -4.374181739298645e-10,   8.078523317140981e-12,  -1.489096606449193e-13,   2.731732089368097e-15,  -4.953911031785942e-17,   2.019132619791805e-01,  -3.738262655552105e-03,
   6.919094920101870e-05,  -1.280268642638631e-06,   2.368177703076688e-08,  -4.378672956984471e-10,   8.089526336226673e-12,  -1.491665832846708e-13,   2.737416146089126e-15,
  -4.965556309959720e-17,   2.019294908014435e-01,  -3.739163335486385e-03,   6.922429263127304e-05,  -1.281297236335318e-06,   2.371031855544344e-08,  -4.386051587895717e-10,
   8.107605998992886e-12,  -1.495887957523233e-13,   2.746757103140316e-15,  -4.984689170535529e-17,   2.019467136974814e-01,  -3.740119290487723e-03,   6.925968722560643e-05,
  -1.282389284282894e-06,   2.374062649218075e-08,  -4.393888461165982e-10,   8.126812258552636e-12,  -1.500373837569151e-13,   2.756681705892707e-15,  -5.005011294652813e-17,
   2.019602702793503e-01,  -3.740871823289077e-03,   6.928755356012417e-05,  -1.283249188533195e-06,   2.376449578669390e-08,  -4.400061610610973e-10,   8.141943872606408e-12,
  -1.503908508048506e-13,   2.764501922931290e-15,  -5.021019848189834e-17,   2.019680948786354e-01,  -3.741306201344038e-03,   6.930364001832138e-05,  -1.283745639272115e-06,
   2.377827795681696e-08,  -4.403626457466487e-10,   8.150683115425249e-12,  -1.505950143640975e-13,   2.769018931969859e-15,  -5.030264671604385e-17,   2.019710332505228e-01,
  -3.741469329115094e-03,   6.930968144712084e-05,  -1.283932096094185e-06,   2.378345457188278e-08,  -4.404965509193361e-10,   8.153966015620471e-12,  -1.506717121059012e-13,
   2.770715833669425e-15,  -5.033737322395682e-17,   2.019715203360079e-01,  -3.741496370642699e-03,   6.931068294282763e-05,  -1.283963005808626e-06,   2.378431273710102e-08,
  -4.405187498148707e-10,   8.154510268092202e-12,  -1.506844275583829e-13,   2.770997157391894e-15,  -5.034313023423927e-17,   1.898885514967301e-02,  -3.273001945875458e-04,
   5.639839975536361e-06,  -9.715379674643888e-08,   1.673103452007538e-09,  -2.880349773514007e-11,   4.956636127462989e-13,  -8.523506096922525e-15,   1.463435174819082e-16,
  -2.502811806152609e-18,   1.898966062539860e-02,  -3.273418173068503e-04,   5.641274582920043e-06,  -9.719500324492495e-08,   1.674168503708331e-09,  -2.882917746569434e-11,
   4.962524617514283e-13,  -8.536479271578360e-15,   1.466190549279895e-16,  -2.508429429647258e-18,   1.899098309273476e-02,  -3.274101605051725e-04,   5.643630382716858e-06,
  -9.726267688346007e-08,   1.675917870070982e-09,  -2.887136302163280e-11,   4.972199491702871e-13,  -8.557797721652036e-15,   1.470718981233380e-16,  -2.517662555502930e-18,
   1.899238653475769e-02,  -3.274826952788126e-04,   5.646130965149981e-06,  -9.733451987963574e-08,   1.677775322653755e-09,  -2.891616340253395e-11,   4.982476113833992e-13,
  -8.580446650718641e-15,   1.475530850756460e-16,  -2.527474419793485e-18,   1.899349119726663e-02,  -3.275397930982310e-04,   5.648099586201884e-06,  -9.739108679839196e-08,
   1.679238045686447e-09,  -2.895144924824652e-11,   4.990571719056110e-13,  -8.598292061052960e-15,   1.479322783202258e-16,  -2.535207132458632e-18,   1.899412877824073e-02,
  -3.275727504067641e-04,   5.649235976353941e-06,  -9.742374314097050e-08,   1.680082571926306e-09,  -2.897182451401284e-11,   4.995246999719924e-13,  -8.608599253215213e-15,
   1.481513173411468e-16,  -2.539674132556399e-18,   1.899436820732116e-02,  -3.275851271566783e-04,   5.649662751393203e-06,  -9.743600790132694e-08,   1.680399768025085e-09,
  -2.897947773038924e-11,   4.997003209462431e-13,  -8.612471267692196e-15,   1.482336063349115e-16,  -2.541352348541194e-18,   1.899440789670316e-02,  -3.275871788304044e-04,
   5.649733498062432e-06,  -9.743804106532353e-08,   1.680452351411708e-09,  -2.898074647143085e-11,   4.997294357779324e-13,  -8.613113191898582e-15,   1.482472489007763e-16,
  -2.541630579758204e-18,   1.879702875737641e-01,  -3.239937908661193e-03,   5.582865946919343e-05,  -9.617233207918965e-07,   1.656200222374603e-08,  -2.851238242165689e-10,
   4.906449896621146e-12,  -8.436609836443072e-14,   1.448171093766660e-15,  -2.474943477435412e-17,   1.879782609613130e-01,  -3.240349931046517e-03,   5.584286060431739e-05,
  -9.621312208483253e-07,   1.657254488005800e-08,  -2.853780013460118e-10,   4.912276802212845e-12,  -8.449437433488333e-14,   1.450889845782979e-15,  -2.480457233283184e-17,
   1.879913520381209e-01,  -3.241026458866749e-03,   5.586618059512445e-05,  -9.628011171245829e-07,   1.658986137746522e-08,  -2.857955522992165e-10,   4.921850469154559e-12,
  -8.470516504545999e-14,   1.455357997344832e-15,  -2.489519157846643e-17,   1.880052446816760e-01,  -3.241744478998073e-03,   5.589093378463253e-05,  -9.635122855237467e-07,
   1.660824778645114e-08,  -2.862389842848075e-10,   4.932019557727447e-12,  -8.492910902777507e-14,   1.460105688231943e-15,  -2.499148428493076e-17,   1.880161797130007e-01,
  -3.242309689057851e-03,   5.591042110442869e-05,  -9.640722371588538e-07,   1.662272687379140e-08,  -2.865882415732876e-10,   4.940030428400553e-12,  -8.510555610290632e-14,
   1.463846954413125e-15,  -2.506736758383513e-17,   1.880224911138735e-01,  -3.242635932730539e-03,   5.592167019584370e-05,  -9.643954998047672e-07,   1.663108660225453e-08,
  -2.867899146744060e-10,   4.944656764914444e-12,  -8.520746817948105e-14,   1.466008040861448e-15,  -2.511120158529111e-17,   1.880248612173874e-01,  -3.242758449905814e-03,
   5.592589482891288e-05,  -9.645169077306448e-07,   1.663422643726654e-08,  -2.868656657072791e-10,   4.946394587660723e-12,  -8.524575249753099e-14,   1.466819914963294e-15,
  -2.512766930024035e-17,   1.880252541017588e-01,  -3.242778759378916e-03,   5.592659514802851e-05,  -9.645370338656308e-07,   1.663474694541610e-08,  -2.868782236215770e-10,
   4.946682687648564e-12,  -8.525209947959034e-14,   1.466954513956785e-15,  -2.513039946127113e-17,   1.776309771247473e-02,  -2.864297225139463e-04,   4.617494809781125e-06,
  -7.441894132517433e-08,   1.199081241913887e-09,  -1.931519226880079e-11,   3.110455396613218e-13,  -5.007092807910428e-15,   8.055044219881652e-17,  -1.293737733226745e-18,
   1.776375688247946e-02,  -2.864615911843690e-04,   4.618522423828027e-06,  -7.444655560299609e-08,   1.199749052733477e-09,  -1.933026291910783e-11,   3.113692931626516e-13,
  -5.013791021569684e-15,   8.068475636748155e-17,  -1.296351688398530e-18,   1.776483912306382e-02,  -2.865139173170786e-04,   4.620209832012257e-06,  -7.449190445663477e-08,
   1.200845873305201e-09,  -1.935501834553985e-11,   3.119011750892239e-13,  -5.024796940832563e-15,   8.090548354605269e-17,  -1.300647947813371e-18,   1.776598760852318e-02,
  -2.865694510146312e-04,   4.622000864559569e-06,  -7.454004423409728e-08,   1.202010365985099e-09,  -1.938130550500164e-11,   3.124660708272693e-13,  -5.036488289043098e-15,
   8.114000326939293e-17,  -1.305213451384545e-18,   1.776689157729664e-02,  -2.866131647465370e-04,   4.623410823660513e-06,  -7.457794580357506e-08,   1.202927321372244e-09,
  -1.940200793816052e-11,   3.129110292466430e-13,  -5.045699019269091e-15,   8.132479699200511e-17,  -1.308811483549723e-18,   1.776741331732041e-02,  -2.866383961719145e-04,
   4.624224701848981e-06,  -7.459982568027932e-08,   1.203456712173461e-09,  -1.941396145252837e-11,   3.131679768726543e-13,  -5.051018553692745e-15,   8.143153550845689e-17,
  -1.310889966643788e-18,   1.776760924382062e-02,  -2.866478714612058e-04,   4.624530352057551e-06,  -7.460804295229816e-08,   1.203655541102100e-09,  -1.941845120044072e-11,
   3.132644922707407e-13,  -5.053016818242227e-15,   8.147163398590801e-17,  -1.311670833706101e-18,   1.776764172186100e-02,  -2.866494421597010e-04,   4.624581019582535e-06,
  -7.460940514399621e-08,   1.203688501817262e-09,  -1.941919549763827e-11,   3.132804926101261e-13,  -5.053348097526640e-15,   8.147828178496687e-17,  -1.311800293438226e-18,
   1.758365398548811e-01,  -2.835361946774504e-03,   4.570848629106298e-05,  -7.366715565737613e-07,   1.186967856367257e-08,  -1.912004926566889e-10,   3.079017247645973e-12,
  -4.956398453522384e-14,   7.972987541444832e-16,  -1.280299215584796e-17,   1.758430649652165e-01,  -2.835677414080897e-03,   4.571865861946289e-05,  -7.369449094281901e-07,
   1.187628917117109e-08,  -1.913496730191557e-10,   3.082221777842369e-12,  -4.963026926457325e-14,   7.986270679871953e-16,  -1.282879989706854e-17,   1.758537780425281e-01,
  -2.836195389381330e-03,   4.573536223520450e-05,  -7.373938162785968e-07,   1.188714651247896e-08,  -1.915947203643419e-10,   3.087486371431150e-12,  -4.973918231149546e-14,
   8.008099587977181e-16,  -1.287121642806354e-17,   1.758651468764961e-01,  -2.836745116299356e-03,   4.575309162615777e-05,  -7.378703503894459e-07,   1.189867373409786e-08,
  -1.918549298671075e-10,   3.093077732771879e-12,  -4.985487795795310e-14,   8.031292332465632e-16,  -1.291629021785294e-17,   1.758740952448134e-01,  -2.837177837622973e-03,
   4.576704877960188e-05,  -7.382455368045627e-07,   1.190775060304455e-08,  -1.920598576280008e-10,   3.097481946243838e-12,  -4.994602559393095e-14,   8.049567308567591e-16,
  -1.295181176561098e-17,   1.758792599385900e-01,  -2.837427602978350e-03,   4.577510534148383e-05,  -7.384621249976080e-07,   1.191299100059015e-08,  -1.921781822019153e-10,
   3.100025221186871e-12,  -4.999866660494213e-14,   8.060123045536267e-16,  -1.297233129432852e-17,   1.758811994109903e-01,  -2.837521398670094e-03,   4.577813096602200e-05,
  -7.385434675077203e-07,   1.191495919234811e-08,  -1.922226249870150e-10,   3.100980533100122e-12,  -5.001844099989971e-14,   8.064088510962869e-16,  -1.298004024004921e-17,
   1.758815209104448e-01,  -2.837536946981849e-03,   4.577863252271181e-05,  -7.385569517992948e-07,   1.191528546784537e-08,  -1.922299925809832e-10,   3.101138904860870e-12,
  -5.002171926733352e-14,   8.064745932328941e-16,  -1.298131830119287e-17,   1.668602769358355e-02,  -2.527626641656429e-04,   3.828026413502368e-06,  -5.796139625585054e-08,
   8.774136844654453e-10,  -1.327916731267705e-11,   2.009256034723805e-13,  -3.039395624334487e-15,   4.596127783584855e-17,  -6.944638900462251e-19,   1.668657396139123e-02,
  -2.527874762136269e-04,   3.828778031572876e-06,  -5.798037071314758e-08,   8.778447765576972e-10,  -1.328830786787637e-11,   2.011101516438759e-13,  -3.042987043834304e-15,
   4.602915393604054e-17,  -6.957145322944568e-19,   1.668747082613670e-02,  -2.528282150804011e-04,   3.830012201062434e-06,  -5.801152978235629e-08,   8.785527695031942e-10,
  -1.330332134848788e-11,   2.014133134291030e-13,  -3.048887588231662e-15,   4.614068808385908e-17,  -6.977698994065556e-19,   1.668842257461065e-02,  -2.528714501522972e-04,
   3.831322112963481e-06,  -5.804460477929585e-08,   8.793043929379067e-10,  -1.331926239099980e-11,   2.017352581907225e-13,  -3.055154843578028e-15,   4.625917663562557e-17,
  -6.999538436074080e-19,   1.668917168217627e-02,  -2.529054821642021e-04,   3.832353283186007e-06,  -5.807064425855677e-08,   8.798962057307402e-10,  -1.333181573925321e-11,
   2.019888236223251e-13,  -3.060091787155799e-15,   4.635253079670560e-17,  -7.016748229089349e-19,   1.668960403747603e-02,  -2.529251250223398e-04,   3.832948497003253e-06,
  -5.808567587341059e-08,   8.802378652284106e-10,  -1.333906359556565e-11,   2.021352386834649e-13,  -3.062942831184684e-15,   4.640644864531414e-17,  -7.026689177712990e-19,
   1.668976639698883e-02,  -2.529325015491858e-04,   3.833172025619595e-06,  -5.809132109793026e-08,   8.803661830856546e-10,  -1.334178581878969e-11,   2.021902336468378e-13,
  -3.064013773987718e-15,   4.642670315026657e-17,  -7.030423774546828e-19,   1.668979331070796e-02,  -2.529337243372194e-04,   3.833209079737667e-06,  -5.809225691182392e-08,
   8.803874547319751e-10,  -1.334223709691453e-11,   2.021993506222851e-13,  -3.064191316417943e-15,   4.643006103683094e-17,  -7.031042925641730e-19,   1.651746458342332e-01,
  -2.502092427230044e-03,   3.789355492263117e-05,  -5.737586701098984e-07,   8.685499774073817e-09,  -1.314501767039937e-10,   1.988956143462328e-12,  -3.008675584139821e-14,
   4.549600467674032e-16,  -6.873959401138752e-18,   1.651800533280524e-01,  -2.502338041182859e-03,   3.790099517421475e-05,  -5.739464978289683e-07,   8.689767140467782e-09,
  -1.315406583492837e-10,   1.990782939608895e-12,  -3.012230427987546e-14,   4.556317714510900e-16,  -6.886329804539819e-18,   1.651889313737647e-01,  -2.502741314387377e-03,
   3.791321219221478e-05,  -5.742549407423028e-07,   8.696775539205609e-09,  -1.316892756205413e-10,   1.993783861737390e-12,  -3.018070876902985e-14,   4.567355488827567e-16,
  -6.906659832519345e-18,   1.651983527123790e-01,  -2.503169297475052e-03,   3.792617898275954e-05,  -5.745823493796860e-07,   8.704215834625027e-09,  -1.318470747462318e-10,
   1.996970711155028e-12,  -3.024274297417160e-14,   4.579081466419876e-16,  -6.928261500815734e-18,   1.652057681127998e-01,  -2.503506179661098e-03,   3.793638651524808e-05,
  -5.748401135881283e-07,   8.710074169744142e-09,  -1.319713393469168e-10,   1.999480690472486e-12,  -3.029160952718720e-14,   4.588320050950375e-16,  -6.945283822768783e-18,
   1.652100479890405e-01,  -2.503700623909881e-03,   3.794227852438784e-05,  -5.749889111988637e-07,   8.713456245703102e-09,  -1.320430853004010e-10,   2.000930015499829e-12,
  -3.031982954368071e-14,   4.593655901728618e-16,  -6.955116440846713e-18,   1.652116551825261e-01,  -2.503773643997442e-03,   3.794449122949006e-05,  -5.750447931468880e-07,
   8.714726459882406e-09,  -1.320700323712362e-10,   2.001474396458987e-12,  -3.033042987680348e-14,   4.595660338831237e-16,  -6.958810332493375e-18,   1.652119216008795e-01,
  -2.503785748351042e-03,   3.794485802743054e-05,  -5.750540567471524e-07,   8.714937027197985e-09,  -1.320744995374196e-10,   2.001564643045721e-12,  -3.033218721506412e-14,
   4.595992643711034e-16,  -6.959422734748953e-18,   1.573213269128961e-02,  -2.247005579063315e-04,   3.208733375519857e-06,  -4.581165201316464e-08,   6.539295624103255e-10,
  -9.332508597818683e-12,   1.331611110529872e-13,  -1.899613009486361e-15,   2.709266430627992e-17,  -3.862052762545323e-19,   1.573259044373932e-02,  -2.247201630102968e-04,
   3.209293347867169e-06,  -4.582498108754651e-08,   6.542151016901069e-10,  -9.338217422735216e-12,   1.332698042541415e-13,  -1.901608240119031e-15,   2.712825893443048e-17,
  -3.868254150923189e-19,   1.573334197634968e-02,  -2.247523520866767e-04,   3.210212809761334e-06,  -4.584686880629652e-08,   6.546840287379463e-10,  -9.347593703655357e-12,
   1.334483445360260e-13,  -1.904886038111608e-15,   2.718674246039854e-17,  -3.878444790780279e-19,   1.573413948921268e-02,  -2.247865127923570e-04,   3.211188670051782e-06,
  -4.587010136963970e-08,   6.551818251414687e-10,  -9.357548537652483e-12,   1.336379293688661e-13,  -1.908367168521837e-15,   2.724886489644145e-17,  -3.889271527471279e-19,
   1.573476719300121e-02,  -2.248134015082773e-04,   3.211956851155221e-06,  -4.588839131476995e-08,   6.555737590825807e-10,  -9.365387300348694e-12,   1.337872349055397e-13,
  -1.911109106741099e-15,   2.729780405355299e-17,  -3.897802140062816e-19,   1.573512947597294e-02,  -2.248289211401621e-04,   3.212400253224928e-06,  -4.589894912359720e-08,
   6.558000182097675e-10,  -9.369912910324549e-12,   1.338734426674666e-13,  -1.912692443483883e-15,   2.732606724175393e-17,  -3.902729300383070e-19,   1.573526552114884e-02,
  -2.248347492240266e-04,   3.212566768293416e-06,  -4.590291412510464e-08,   6.558849933122360e-10,  -9.371612644549680e-12,   1.339058222187904e-13,  -1.913287174347887e-15,
   2.733668402658098e-17,  -3.904580250126049e-19,   1.573528807281185e-02,  -2.248357153285858e-04,   3.212594371244939e-06,  -4.590357140403591e-08,   6.558990798139360e-10,
  -9.371894416851839e-12,   1.339111899980818e-13,  -1.913385768585862e-15,   2.733844410462804e-17,  -3.904887111222593e-19,   1.557320587752638e-01,  -2.224306213101312e-03,
   3.176318585684567e-05,  -4.534886031443308e-07,   6.473235282765270e-09,  -9.238230720765513e-11,   1.318158785174034e-12,  -1.880420778302833e-14,   2.681883584565161e-16,
  -3.822963920757664e-18,   1.557365900573725e-01,  -2.224500283623112e-03,   3.176872901158525e-05,  -4.536205473719468e-07,   6.476061829480094e-09,  -9.243881867461677e-11,
   1.319234730950330e-12,  -1.882395811269811e-14,   2.685406835037254e-16,  -3.829101286861810e-18,   1.557440294632646e-01,  -2.224818922629583e-03,   3.177783074594891e-05,
  -4.538372134404969e-07,   6.480703727452874e-09,  -9.253163416505812e-11,   1.321002087625848e-12,  -1.885640427727903e-14,   2.691195686349604e-16,  -3.839186705056800e-18,
   1.557519240267342e-01,  -2.225157078754033e-03,   3.178749076687580e-05,  -4.540671920973470e-07,   6.485631402495712e-09,  -9.263017673182076e-11,   1.322878773376693e-12,
  -1.889086317598257e-14,   2.697344722574450e-16,  -3.849901631823462e-18,   1.557581376536594e-01,  -2.225423249601090e-03,   3.179509497580513e-05,  -4.542482438801841e-07,
   6.489511147471560e-09,  -9.270777237911510e-11,   1.324356737388454e-12,  -1.891800497873494e-14,   2.702188841618198e-16,  -3.858344132225005e-18,   1.557617238853642e-01,
  -2.225576878118606e-03,   3.179948420376518e-05,  -4.543527554080679e-07,   6.491750881310448e-09,  -9.275257123913390e-11,   1.325210101358429e-12,  -1.893367805556174e-14,
   2.704986400893642e-16,  -3.863220394240746e-18,   1.557630705937695e-01,  -2.225634570201170e-03,   3.180113253300019e-05,  -4.543920048747255e-07,   6.492592047873195e-09,
  -9.276939685064891e-11,   1.325530624028225e-12,  -1.893956515569790e-14,   2.706037275926116e-16,  -3.865052222266635e-18,   1.557632938322189e-01,  -2.225644133650374e-03,
   3.180140577404907e-05,  -4.543985112650631e-07,   6.492731489825824e-09,  -9.277218610511928e-11,   1.325583759259259e-12,  -1.894054111671768e-14,   2.706211492695597e-16,
  -3.865355913195302e-18,   1.488142223424704e-02,  -2.010649217842937e-04,   2.716128305069031e-06,  -3.668481093389858e-08,   4.953865580463002e-10,  -6.688425996863100e-12,
   9.028697620494156e-14,  -1.218560022393275e-15,   1.644321005677263e-17,  -2.217972855051359e-19,   1.488180961209059e-02,  -2.010806170806674e-04,   2.716552384740759e-06,
  -3.669435997308246e-08,   4.955800691925798e-10,  -6.692085920331146e-12,   9.035289746419184e-14,  -1.219704877080034e-15,   1.646253760227466e-17,  -2.221161364432948e-19,
   1.488244559933030e-02,  -2.011063864044368e-04,   2.717248699851160e-06,  -3.671004003896648e-08,   4.958978509889042e-10,  -6.698096755710215e-12,   9.046117368470462e-14,
  -1.221585525579637e-15,   1.649429086697774e-17,  -2.226400480883894e-19,   1.488312049050520e-02,  -2.011337336649780e-04,   2.717987706715097e-06,  -3.672668292957480e-08,
   4.962351806185581e-10,  -6.704478086795481e-12,   9.057613900515290e-14,  -1.223582649445351e-15,   1.652801613585243e-17,  -2.231965929770210e-19,   1.488365167653504e-02,
  -2.011552590112246e-04,   2.718569426838768e-06,  -3.673978468647835e-08,   4.965007611854802e-10,  -6.709502669116724e-12,   9.066667228727506e-14,  -1.225155563189033e-15,
   1.655458172125183e-17,  -2.236350562552357e-19,   1.488395825166993e-02,  -2.011676828755006e-04,   2.718905196141969e-06,  -3.674734745592451e-08,   4.966540731719000e-10,
  -6.712403432757988e-12,   9.071894285963136e-14,  -1.226063790413157e-15,   1.656992271455951e-17,  -2.238882863164382e-19,   1.488407337694986e-02,  -2.011723483804924e-04,
   2.719031289784997e-06,  -3.675018763259963e-08,   4.967116509560831e-10,  -6.713492883422083e-12,   9.073857514722281e-14,  -1.226404927243128e-15,   1.657568520156626e-17,
  -2.239834115780178e-19,   1.488409246078530e-02,  -2.011731217663541e-04,   2.719052192082372e-06,  -3.675065844739099e-08,   4.967211956993992e-10,  -6.713673485228246e-12,
   9.074182969980730e-14,  -1.226461480223875e-15,   1.657664051079552e-17,  -2.239991817908837e-19,   1.473108934128597e-01,  -1.990337536008502e-03,   2.688689837175416e-05,
  -3.631421908198396e-07,   4.903821369849068e-09,  -6.620859117979799e-11,   8.937488801528321e-13,  -1.206249751136611e-14,   1.627708062432865e-16,  -2.195556321561079e-18,
   1.473147280581862e-01,  -1.990492903425302e-03,   2.689109632771938e-05,  -3.632367165619511e-07,   4.905736932609886e-09,  -6.624482067675506e-11,   8.944014325021561e-13,
  -1.207383034556047e-14,   1.629621256252991e-16,  -2.198712425803551e-18,   1.473210236828250e-01,  -1.990747993432614e-03,   2.689798913670371e-05,  -3.633919332110190e-07,
   4.908882647916520e-09,  -6.630432179570585e-11,   8.954732551921754e-13,  -1.209244674910390e-14,   1.632764445953116e-16,  -2.203898294439736e-18,   1.473277044167202e-01,
  -1.991018703403657e-03,   2.690530455047984e-05,  -3.635566808421774e-07,   4.912221866811682e-09,  -6.636749044282537e-11,   8.966112930454987e-13,  -1.211221613295000e-14,
   1.636102839694544e-16,  -2.209407175890744e-18,   1.473329626163326e-01,  -1.991231782364539e-03,   2.691106298604272e-05,  -3.636863748637565e-07,   4.914850843245601e-09,
  -6.641722866554858e-11,   8.975074789605906e-13,  -1.212778629098740e-14,   1.638732510958484e-16,  -2.213747240960476e-18,   1.473359973973036e-01,  -1.991354765942120e-03,
   2.691438675948254e-05,  -3.637612385626415e-07,   4.916368475367068e-09,  -6.644594325684864e-11,   8.980249035945263e-13,  -1.213677676554047e-14,   1.640251083364916e-16,
  -2.216253801077961e-18,   1.473371370200879e-01,  -1.991400949680316e-03,   2.691563495786645e-05,  -3.637893534130140e-07,   4.916938436638751e-09,  -6.645672770342984e-11,
   8.982192429469227e-13,  -1.214015365390146e-14,   1.640821499707158e-16,  -2.217195384176147e-18,   1.473373259305834e-01,  -1.991408605411095e-03,   2.691584186927909e-05,
  -3.637940139989304e-07,   4.917032919851594e-09,  -6.645851547647427e-11,   8.982514596530953e-13,  -1.214071346769100e-14,   1.640916063735894e-16,  -2.217351483248299e-18,
   1.411801027732445e-02,  -1.809714761756901e-04,   2.319405381343806e-06,  -2.972165793372278e-08,   3.808019486569724e-10,  -4.878147680741096e-12,   6.247988467017865e-14,
  -8.001191833386076e-16,   1.024465888731444e-17,  -1.311278677813490e-19,   1.411834100114717e-02,  -1.809841896075742e-04,   2.319731285493485e-06,  -2.972862018578290e-08,
   3.809358067585695e-10,  -4.880549617676324e-12,   6.252093065814021e-14,  -8.007955199909661e-16,   1.025549288553931e-17,  -1.312974954249697e-19,   1.411888397148736e-02,
  -1.810050629173360e-04,   2.320266392681757e-06,  -2.974005232475988e-08,   3.811556199513421e-10,  -4.884494249880051e-12,   6.258834556400954e-14,  -8.019064659006025e-16,
   1.027329075195170e-17,  -1.315761904734588e-19,   1.411946015073816e-02,  -1.810272140399291e-04,   2.320834295297842e-06,  -2.975218607300847e-08,   3.813889450067007e-10,
  -4.888681799983723e-12,   6.265992051274097e-14,  -8.030861218377089e-16,   1.029219212575989e-17,  -1.318722118673903e-19,   1.411991363996832e-02,  -1.810446492098888e-04,
   2.321281319134887e-06,  -2.976173783382741e-08,   3.815726355336757e-10,  -4.891978865666348e-12,   6.271628117673481e-14,  -8.040151377241861e-16,   1.030707953327482e-17,
  -1.321054028307972e-19,   1.412017537075307e-02,  -1.810547122373535e-04,   2.321539338005077e-06,  -2.976725131893839e-08,   3.816786719817198e-10,  -4.893882244862773e-12,
   6.274882037048555e-14,  -8.045515397905389e-16,   1.031567613085557e-17,  -1.322400703677530e-19,   1.412027365577602e-02,  -1.810584911648944e-04,   2.321636232832679e-06,
  -2.976932187214312e-08,   3.817184944584763e-10,  -4.894597091971809e-12,   6.276104149664487e-14,  -8.047530111463562e-16,   1.031890514319545e-17,  -1.322906560958552e-19,
   1.412028994805785e-02,  -1.810591175847010e-04,   2.321652294863120e-06,  -2.976966510571968e-08,   3.817250958538793e-10,  -4.894715593878596e-12,   6.276306744645036e-14,
  -8.047864103896293e-16,   1.031944044593241e-17,  -1.322990422870466e-19,   1.397538941122493e-01,  -1.791432930135646e-03,   2.295974628859405e-05,  -2.942140821564230e-07,
   3.769550677025917e-09,  -4.828868374175181e-11,   6.184870902940633e-13,  -7.920362940006384e-15,   1.014116411045744e-16,  -1.298030603478943e-18,   1.397571679405858e-01,
  -1.791558780137054e-03,   2.296297240708523e-05,  -2.942830013466169e-07,   3.770875735612698e-09,  -4.831246046474497e-11,   6.188934035684187e-13,  -7.927057974378418e-15,
   1.015188861247182e-16,  -1.299709716596946e-18,   1.397625427928446e-01,  -1.791765404602177e-03,   2.296826942216325e-05,  -2.943961678556233e-07,   3.773051661873952e-09,
  -4.835150829560197e-11,   6.195607421427068e-13,  -7.938055191458489e-15,   1.016950660021244e-16,  -1.302468467762279e-18,   1.397682463794283e-01,  -1.791984678110303e-03,
   2.297389107850833e-05,  -2.945162795804018e-07,   3.775361341783993e-09,  -4.839296076559516e-11,   6.202692608819380e-13,  -7.949732566712467e-15,   1.018821694167816e-16,
  -1.305398728821810e-18,   1.397727354600146e-01,  -1.792157268500057e-03,   2.297831615829972e-05,  -2.946108322646268e-07,   3.777179690521230e-09,  -4.842559834910300e-11,
   6.208271737718951e-13,  -7.958928864267443e-15,   1.020295388461559e-16,  -1.307707042757158e-18,   1.397753263276835e-01,  -1.792256882202490e-03,   2.298087028180200e-05,
  -2.946654101405340e-07,   3.778229343132956e-09,  -4.844443985953292e-11,   6.211492784865003e-13,  -7.964238690554824e-15,   1.021146359756751e-16,  -1.309040091512088e-18,
   1.397762992491094e-01,  -1.792294289728694e-03,   2.298182944171246e-05,  -2.946859065041937e-07,   3.778623545008843e-09,  -4.845151611595280e-11,   6.212702551271753e-13,
  -7.966233048825330e-15,   1.021465997468004e-16,  -1.309540830147701e-18,   1.397764605260731e-01,  -1.792300490645509e-03,   2.298198843942225e-05,  -2.946893041663205e-07,
   3.778688892085752e-09,  -4.845268916382279e-11,   6.212903099566879e-13,  -7.966563666826596e-15,   1.021518986717629e-16,  -1.309623843480320e-18,   1.342911308854553e-02,
  -1.637462153217226e-04,   1.996327489080493e-06,  -2.433485892979855e-08,   2.965939881464825e-10,  -3.614366885530356e-12,   4.403909604333621e-14,  -5.365135197175789e-16,
   6.535197972025596e-18,  -7.958065042912246e-20,   1.342939769096619e-02,  -1.637566226316420e-04,   1.996581268642266e-06,  -2.434001603790399e-08,   2.966883055063402e-10,
  -3.615976791857783e-12,   4.406526606773757e-14,  -5.369237192527661e-16,   6.541448696984398e-18,  -7.967375803717189e-20,   1.342986493810358e-02,  -1.637737095102670e-04,
   1.996997947184357e-06,  -2.434848392440075e-08,   2.968431831678154e-10,  -3.618620601393444e-12,   4.410824643799594e-14,  -5.375974738042265e-16,   6.551716594027067e-18,
  -7.982672048766571e-20,   1.343036075904730e-02,  -1.637918421772901e-04,   1.997440154598781e-06,  -2.435747126158691e-08,   2.970075753291453e-10,  -3.621427094599920e-12,
   4.415387646063813e-14,  -5.383128494245675e-16,   6.562620221240164e-18,  -7.998917675798029e-20,   1.343075099852730e-02,  -1.638061142515950e-04,   1.997788231567780e-06,
  -2.436454597637590e-08,   2.971369926522200e-10,  -3.623636693697145e-12,   4.418980529509644e-14,  -5.388761942466007e-16,   6.571207659899621e-18,  -8.011714031068728e-20,
   1.343097622370170e-02,  -1.638143515741985e-04,   1.997989136609519e-06,  -2.436862958742126e-08,   2.972116978892025e-10,  -3.624912247072070e-12,   4.421054765248041e-14,
  -5.392014480874142e-16,   6.576166135918368e-18,  -8.019103454352408e-20,   1.343106079994871e-02,  -1.638174448897271e-04,   1.998064582801263e-06,  -2.437016314775538e-08,
   2.972397534673663e-10,  -3.625391296314661e-12,   4.421833796084473e-14,  -5.393236099512085e-16,   6.578028565125383e-18,  -8.021879087550124e-20,   1.343107481977536e-02,
  -1.638179576573299e-04,   1.998077089316999e-06,  -2.437041736386210e-08,   2.972444042402959e-10,  -3.625470709079782e-12,   4.421962938702779e-14,  -5.393438613906146e-16,
   6.578337314336803e-18,  -8.022339232343317e-20,   1.329345149728628e-01,  -1.620920426308840e-03,   1.976160486087436e-05,  -2.408902693293187e-07,   2.935977804093732e-09,
  -3.577854364236239e-11,   4.359421074133563e-13,  -5.310936263615161e-15,   6.469178687094064e-17,  -7.877670200440253e-19,   1.329373322463864e-01,  -1.621023448056232e-03,
   1.976411701955009e-05,  -2.409413194366422e-07,   2.936911449702014e-09,  -3.579448007186782e-11,   4.362011639314556e-13,  -5.314996819238772e-15,   6.475366259804089e-17,
  -7.886886864879651e-19,   1.329419575162142e-01,  -1.621192590717212e-03,   1.976824171189015e-05,  -2.410251428713313e-07,   2.938444580492282e-09,  -3.582065108788853e-11,
   4.366266257074859e-13,  -5.321666299802683e-15,   6.485530418271153e-17,  -7.902028522651788e-19,   1.329468656375646e-01,  -1.621372085616091e-03,   1.977261911401372e-05,
  -2.411141083377368e-07,   2.940071895121183e-09,  -3.584843250620519e-11,   4.370783163361451e-13,  -5.328747786336368e-15,   6.496323883889608e-17,  -7.918109967138349e-19,
   1.329507286101715e-01,  -1.621513364586851e-03,   1.977606472078909e-05,  -2.411841407942751e-07,   2.941352994544443e-09,  -3.587030528205358e-11,   4.374339751080403e-13,
  -5.334324323539891e-15,   6.504824561803182e-17,  -7.930776998667238e-19,   1.329529581095525e-01,  -1.621594905674319e-03,   1.977805347567572e-05,  -2.412245643762261e-07,
   2.942092500151095e-09,  -3.588293195857840e-11,   4.376393032647081e-13,  -5.337544003689353e-15,   6.509732941235740e-17,  -7.938091742083093e-19,   1.329537953280867e-01,
  -1.621625526341279e-03,   1.977880031598002e-05,  -2.412397450585081e-07,   2.942370221743153e-09,  -3.588767405714074e-11,   4.377164193622854e-13,  -5.338753281115744e-15,
   6.511576553899944e-17,  -7.940839323813364e-19,   1.329539341100631e-01,  -1.621630602217260e-03,   1.977892411772272e-05,  -2.412422615385326e-07,   2.942416259648869e-09,
  -3.588846016246317e-11,   4.377292031627312e-13,  -5.338953749639703e-15,   6.511882183748037e-17,  -7.941294818229272e-19  };
  static constexpr double xi[4840] = {  -2.943552170788592e-02,   3.656058000513285e-03,  -1.941714266280500e-04,  -2.760909749707764e-06,   1.254839589029086e-06,
  -8.736391721433042e-08,   1.152094056694571e-09,   2.938024227366948e-10,  -2.733575032271533e-11,   8.154033134264331e-13,   5.079746012203539e-14,  -6.951142948236074e-15,
   3.088883331745265e-16,   4.438809222047845e-18,  -2.800920948483908e-02,   3.477930989737050e-03,  -1.845019784059285e-04,  -2.652015054469163e-06,   1.194232157924198e-06,
  -8.292737620299711e-08,   1.073719508099219e-09,   2.803074683326666e-10,  -2.593367495775459e-11,   7.645158793424935e-13,   4.888682244537528e-14,  -6.599157327480465e-15,
   2.897481029502953e-16,   4.491412794243589e-18,  -2.529398144191751e-02,   3.139230228423256e-03,  -1.662009197238006e-04,  -2.434483859451629e-06,   1.078762261098109e-06,
  -7.456399365193191e-08,   9.338080207435169e-10,   2.542985983932544e-10,  -2.329523029657458e-11,   6.723208654668045e-13,   4.501367624772409e-14,  -5.934457108077974e-15,
   2.550126169826996e-16,   4.477141317005269e-18,  -2.155249354605787e-02,   2.673278342109638e-03,  -1.411888267057555e-04,  -2.114987708615750e-06,   9.194810099203605e-07,
  -6.319965745650581e-08,   7.589234135432368e-10,   2.178576085812841e-10,  -1.971989288403411e-11,   5.543079456329526e-13,   3.923055455139733e-14,  -5.029736939822637e-15,
   2.104468309764421e-16,   4.240885313217099e-18,  -1.714868512992363e-02,   2.125814408542516e-03,  -1.120097301168698e-04,  -1.714083901048397e-06,   7.318114313467379e-07,
  -5.002697380364911e-08,   5.755926973340850e-10,   1.742298563703834e-10,  -1.558943230519667e-11,   4.267658445269059e-13,   3.187661072791569e-14,  -3.980285229093969e-15,
   1.621647946239101e-16,   3.696791974630868e-18,  -1.251320092514525e-02,   1.550456324390950e-03,  -8.153833950135824e-05,  -1.269054710362162e-06,   5.341080682521192e-07,
  -3.635152827667819e-08,   4.034598379806769e-10,   1.276442312323713e-10,  -1.131544621844822e-11,   3.030425649202828e-13,   2.364179413040564e-14,  -2.891104791129064e-15,
   1.152285332724725e-16,   2.883581148445507e-18,  -8.101063476350123e-03,   1.003456640389984e-03,  -5.270513109805148e-05,  -8.293995242795532e-07,   3.458282389490396e-07,
  -2.346867305328386e-08,   2.541450606903803e-10,   8.285213416792509e-11,  -7.299801299422789e-12,   1.926222680530909e-13,   1.546672931845366e-14,  -1.865877039193911e-15,
   7.327365629679000e-17,   1.945333232283660e-18,  -4.346087706254271e-03,   5.382523387797010e-04,  -2.825260524153003e-05,  -4.471081645743096e-07,   1.855433987097836e-07,
  -1.257253864193531e-08,   1.344044563165150e-10,   4.450750896201047e-11,  -3.909077719578855e-12,   1.023573701569854e-13,   8.341617648478588e-15,  -9.993814033834913e-16,
   3.894516560281231e-17,   1.065083455621704e-18,  -1.617357924439432e-03,   2.002947239064873e-04,  -1.051099890113400e-05,  -1.666654790798419e-07,   6.904988414910578e-08,
  -4.676423740931852e-09,   4.976633094589916e-11,   1.657064380880545e-11,  -1.453801269833767e-12,   3.796437848243392e-14,   3.109931480055052e-15,  -3.716981549705503e-16,
   1.444584058690259e-17,   3.991280749240090e-19,  -1.826942352507503e-04,   2.262478143738947e-05,  -1.187253081559409e-06,  -1.883125800470892e-08,   7.799795270808950e-09,
  -5.281996958682570e-10,   5.617027650680272e-12,   1.871929658759731e-12,  -1.642024997256954e-13,   4.286121074216767e-15,   3.513945806674254e-16,  -4.198262378576782e-17,
   1.630932683346093e-18,   4.513442172234817e-20,  -3.568930295456910e-02,  -3.251744580046150e-03,  -8.028646893890338e-05,   1.069797403400262e-05,   1.113816122967020e-06,
   2.351817169954917e-08,  -3.004123041437206e-09,  -2.844404026826852e-10,  -5.733251991562963e-12,   7.643906537312878e-13,   6.543850376383103e-14,   1.076329423422346e-15,
  -1.714384555223509e-16,  -1.408971408581501e-17,  -3.395546195596898e-02,  -3.092612027986680e-03,  -7.618594350850805e-05,   1.018407913145449e-05,   1.058283793607753e-06,
   2.220056209315297e-08,  -2.862291221987137e-09,  -2.697773097747120e-10,  -5.369625117706657e-12,   7.286757770601095e-13,   6.191498925789654e-14,   9.929166518933573e-16,
  -1.635058409706017e-16,  -1.328603622192051e-17,  -3.065663989334478e-02,  -2.790316125442289e-03,  -6.846602659416948e-05,   9.203898047232888e-06,   9.532037436790352e-07,
   1.976563386278749e-08,  -2.590671827284590e-09,  -2.422210147105790e-10,  -4.713052679232675e-12,   6.600779895148316e-13,   5.535038697170798e-14,   8.472634152446319e-16,
  -1.482176977464292e-16,  -1.180515810116776e-17,  -2.611453984637899e-02,  -2.375002634121921e-03,  -5.799476101347527e-05,   7.849638257871379e-06,   8.096397922459319e-07,
   1.655180742383455e-08,  -2.213348122204784e-09,  -2.049436680313397e-10,  -3.876765790343468e-12,   5.644415465959174e-13,   4.658258411204581e-14,   6.716336689240100e-16,
  -1.268229079896143e-16,  -9.859935869184105e-18,  -2.077288977643646e-02,  -1.887736898194836e-03,  -4.587985251126678e-05,   6.251188836734784e-06,   6.422237665695420e-07,
   1.294678039640145e-08,  -1.765527313467365e-09,  -1.619480465974556e-10,  -2.978021496370437e-12,   4.505736508579431e-13,   3.661552998890204e-14,   4.960406202333482e-16,
  -1.012774961078117e-16,  -7.691404720001577e-18,  -1.515440706808054e-02,  -1.376295700167694e-03,  -3.332265231859745e-05,   4.564588525079437e-06,   4.674574613394141e-07,
   9.316587771806928e-09,  -1.290829171395375e-09,  -1.175129630371764e-10,  -2.110812258887962e-12,   3.295963719285069e-13,   2.645382005561116e-14,   3.396663094180956e-16,
  -7.409644761268501e-17,  -5.521838593613043e-18,  -9.809558868093404e-03,  -8.905179090878981e-04,  -2.150678021729883e-05,   2.956461760958393e-06,   3.021337095880213e-07,
   5.975908536056158e-09,  -8.367536338984061e-10,  -7.579610634873581e-11,  -1.340069898390367e-12,   2.137175831665419e-13,   1.701317845187231e-14,   2.104475864575497e-16,
  -4.804713833975442e-17,  -3.536123884157783e-18,  -5.262275091817181e-03,  -4.776111571458308e-04,  -1.151977268879172e-05,   1.586460371398525e-06,   1.619523115723829e-07,
   3.190670490666331e-09,  -4.491959608354530e-10,  -4.058566232702089e-11,  -7.116556582594811e-13,   1.147464516641951e-13,   9.096130535906137e-15,   1.103109480494318e-16,
  -2.579662910353607e-17,  -1.886403147339389e-18,  -1.958258111406555e-03,  -1.777209940045967e-04,  -4.284616670347733e-06,   5.904345468667632e-07,   6.025130673496718e-08,
   1.185398811522489e-09,  -1.672018365925783e-10,  -1.509352709704533e-11,  -2.638960873905533e-13,   4.271346007859372e-14,   3.381007369235241e-15,   4.071647617408796e-17,
  -9.602529296363919e-18,  -7.006261644195488e-19,  -2.212008794275055e-04,  -2.007476879685369e-05,  -4.839412584331084e-07,   6.669541714856702e-08,   6.805574688022490e-09,
   1.338653082535231e-10,  -1.888753146115821e-11,  -1.704760891878943e-12,  -2.979244524204479e-14,   4.825053012779360e-15,   3.818409705093743e-16,   4.593273528161672e-18,
  -1.084732012017956e-18,  -7.911686912437325e-20,  -1.779883290024155e-02,   2.196493932732898e-03,  -1.554006163773871e-04,   6.257859455806834e-06,   7.147795983509175e-08,
  -2.893203333700100e-08,   2.075267434767852e-09,  -7.935883373689535e-11,  -3.270601022861850e-13,   2.988715748588905e-13,  -2.125697555641721e-14,   7.207031898783710e-16,
   3.134158575934777e-18,  -2.492750941682881e-18,  -1.693768998796693e-02,   2.090197069308460e-03,  -1.478268691657769e-04,   5.944726176290661e-06,   6.892498871198183e-08,
  -2.757276772624545e-08,   1.973891323174540e-09,  -7.517128985331011e-11,  -3.394849117469033e-13,   2.854545691305675e-13,  -2.021127914443542e-14,   6.796250329181466e-16,
   3.484947299930793e-18,  -2.389667178959217e-18,  -1.529782897952784e-02,   1.887787284511979e-03,  -1.334266185044766e-04,   5.352648098125923e-06,   6.369314266451261e-08,
  -2.496749340887917e-08,   1.781206417858635e-09,  -6.733761308748739e-11,  -3.515742134085395e-13,   2.594646332323818e-13,  -1.822565895478082e-14,   6.038820370412398e-16,
   3.946370412320120e-18,  -2.185838945252914e-18,  -1.303712932188105e-02,   1.608766441710985e-03,  -1.136179844604336e-04,   4.544599086825496e-06,   5.576379315326682e-08,
  -2.134353734101605e-08,   1.516309518876412e-09,  -5.681205602179530e-11,  -3.458561917141298e-13,   2.227962794850469e-13,  -1.550064493833239e-14,   5.043248576213093e-16,
   4.183562253895291e-18,  -1.890621567416950e-18,  -1.037493041645387e-02,   1.280218052723894e-03,  -9.034658163375203e-05,   3.603414651041865e-06,   4.552081047376461e-08,
  -1.703552205018899e-08,   1.205347761021621e-09,  -4.476575515683485e-11,  -3.108740465290044e-13,   1.785765555416478e-13,  -1.230933390960366e-14,   3.933149427077183e-16,
   3.960619832244443e-18,  -1.525556432396159e-18,  -7.571453003732279e-03,   9.342601303252856e-04,  -6.589192290894089e-05,   2.621965144649151e-06,   3.389200540017233e-08,
  -1.246163833756360e-08,   8.788416329022524e-10,  -3.240684749461122e-11,  -2.477829917892196e-13,   1.310624158057255e-13,  -8.966987747664981e-15,   2.822871657343461e-16,
   3.260245548040381e-18,  -1.125421760421401e-18,  -4.902190757495013e-03,   6.048837704511834e-04,  -4.264439649752101e-05,   1.694294080126091e-06,   2.223068191432741e-08,
  -8.080884406272406e-09,   5.686631772897295e-10,  -2.086952679746440e-11,  -1.693621614792556e-13,   8.517087313133824e-14,  -5.798559727830124e-15,   1.807286165754013e-16,
   2.268670964093247e-18,  -7.337570582868586e-19,  -2.630061246571886e-03,   3.245219088022995e-04,  -2.287412315657705e-05,   9.080874097516968e-07,   1.200596682188679e-08,
  -4.338888841707437e-09,   3.049947546518178e-10,  -1.116561603764674e-11,  -9.332309260006002e-14,   4.578068355564669e-14,  -3.108947557316409e-15,   9.639861940061123e-17,
   1.260563741775306e-18,  -3.950564128808974e-19,  -9.787689950955312e-04,   1.207694574755935e-04,  -8.511896747820098e-06,   3.378234923105436e-07,   4.478218141827617e-09,
  -1.615148082776328e-09,   1.134901835783222e-10,  -4.151226257966687e-12,  -3.504827778066316e-14,   1.704823126943382e-14,  -1.156720486617274e-15,   3.580135106079174e-17,
   4.747326938695482e-19,  -1.471982994002241e-19,  -1.105604933309886e-04,   1.364195715887013e-05,  -9.614815632702111e-07,   3.815798755427789e-08,   5.060372463371574e-10,
  -1.824530211340115e-10,   1.281947880677788e-11,  -4.688450910171711e-13,  -3.964714902424128e-15,   1.925945092890743e-15,  -1.306569103225662e-16,   4.042764183468762e-18,
   5.372587456565968e-20,  -1.663054128588742e-20,  -4.874130644511609e-02,  -3.080576606880037e-03,   1.506079222036027e-04,   2.577867216335253e-05,   2.803287852718173e-07,
  -1.232004258558458e-07,  -6.383383698555831e-09,   3.344766686193181e-10,   4.321873128361119e-11,   1.592491918299474e-13,  -1.877836672744782e-13,  -7.928632529752597e-15,
   5.127331159744205e-16,   5.401718220414015e-17,  -4.636597092433141e-02,  -2.928506417234118e-03,   1.433256661766704e-04,   2.448880541131809e-05,   2.639788472092197e-07,
  -1.169987152637834e-07,  -6.038301771054391e-09,   3.182977724887017e-10,   4.087345682694551e-11,   1.396338239247665e-13,  -1.776526837972334e-13,  -7.426923167983965e-15,
   4.870715442206766e-16,   5.070286854775189e-17,  -4.184965956975552e-02,  -2.640162382095898e-03,   1.294557361240381e-04,   2.205004487442693e-05,   2.340034633849452e-07,
  -1.052873627594666e-07,  -5.396251170850890e-09,   2.874704279740761e-10,   3.651312762717086e-11,   1.073996534329421e-13,  -1.587901664086235e-13,  -6.521914771608203e-15,
   4.384676523665713e-16,   4.468892711275648e-17,  -3.563706908903649e-02,  -2.245052329380378e-03,   1.103306412318944e-04,   1.872181943547447e-05,   1.949049133988338e-07,
  -8.933291934249278e-08,  -4.540066545666064e-09,   2.449535481535289e-10,   3.070498895366647e-11,   7.262497610582796e-14,  -1.336164885226697e-13,  -5.369750615854766e-15,
   3.720597297995587e-16,   3.696329927790585e-17,  -2.833826283524334e-02,  -1.782795968828599e-03,   8.780467698893907e-05,   1.484512857668365e-05,   1.516436993104375e-07,
  -7.078607471478894e-08,  -3.567987266920600e-09,   1.948873335239102e-10,   2.411908282518661e-11,   4.350624553612317e-14,  -1.050172865799973e-13,  -4.130413112194076e-15,
   2.947424755016197e-16,   2.856314444232639e-17,  -2.066807067514080e-02,  -1.298818056230436e-03,   6.408018729463206e-05,   1.080226401772090e-05,   1.086470721913440e-07,
  -5.147941449869601e-08,  -2.577605483008591e-09,   1.421882400054654e-10,   1.741733221777607e-11,   2.351241721962573e-14,  -7.586966053271745e-14,  -2.931729233610426e-15,
   2.142599484394151e-16,   2.035129260523904e-17,  -1.337624837320919e-02,  -8.399734787160948e-04,   4.148980980049942e-05,   6.980567893061977e-06,   6.948482213295636e-08,
  -3.325414861330625e-08,  -1.657719715946706e-09,   9.204166833386044e-11,   1.119851916542205e-11,   1.174995191465476e-14,  -4.879367009188765e-14,  -1.863276237910522e-15,
   1.383503200548202e-16,   1.296773404385740e-17,  -7.174957104342719e-03,  -4.503889422707340e-04,   2.225974272141383e-05,   3.741428945823967e-06,   3.704308700354683e-08,
  -1.782000976574325e-08,  -8.863117485439011e-10,   4.937524592874129e-11,   5.986541775397392e-12,   5.355355682390012e-15,  -2.608774580517906e-14,  -9.901196400911500e-16,
   7.412050016529513e-17,   6.900125285038309e-18,  -2.669943642933998e-03,  -1.675767759457362e-04,   8.283912011614970e-06,   1.391882399102075e-06,   1.375494146998945e-08,
  -6.628929951303122e-09,  -3.294414635092296e-10,   1.837406239446369e-11,   2.225086000893622e-12,   1.870605627571145e-15,  -9.696769358635853e-15,  -3.672382191835332e-16,
   2.756990535772959e-17,   2.560478852159164e-18,  -3.015899403261573e-04,  -1.892864796830058e-05,   9.357404352908000e-07,   1.572166777931096e-07,   1.553193648857937e-09,
  -7.487465051762059e-10,  -3.720617938386016e-11,   2.075496440580935e-12,   2.512929395975406e-13,   2.091103342147011e-16,  -1.095124930309002e-15,  -4.146070421959627e-17,
   3.114013006678107e-18,   2.890962324198159e-19,  -1.103638099380265e-02,   1.243173868149450e-03,  -8.570564226401726e-05,   4.782970498858452e-06,  -1.697411702269780e-07,
  -1.477440581067939e-09,   4.802915695080873e-10,  -2.712690503328734e-11,   1.538272407958088e-12,  -6.498103150067217e-14,  -1.298254620324847e-15,   2.117930284720946e-16,
  -3.966843089441785e-18,   2.157388318342621e-19,  -1.050215972187677e-02,   1.183131131523945e-03,  -8.156663404192828e-05,   4.549832860187168e-06,  -1.612658572427355e-07,
  -1.422828301264063e-09,   4.582001193007313e-10,  -2.587457169044413e-11,   1.461642248266962e-12,  -6.146943887914358e-14,  -1.243670967287829e-15,   2.019728989791898e-16,
  -3.845168650870845e-18,   2.038616794934725e-19,  -9.484958146378994e-03,   1.068749982802327e-03,  -7.368162805440635e-05,   4.106571590874555e-06,  -1.452331036428528e-07,
  -1.311994586498114e-09,   4.156613115028838e-10,  -2.346468225126086e-11,   1.316601133149076e-12,  -5.493154207589377e-14,  -1.136551580371699e-15,   1.830937777017770e-16,
  -3.583345216507872e-18,   1.818401869682562e-19,  -8.082858751217479e-03,   9.109823234520756e-04,  -6.280535554778599e-05,   3.496855860245667e-06,  -1.233377894443119e-07,
  -1.145903904617904e-09,   3.561086678473553e-10,  -2.009434729483406e-11,   1.118377745721863e-12,  -4.620841209673245e-14,  -9.825402552588311e-16,   1.567251971198678e-16,
  -3.165458763239125e-18,   1.526267978760749e-19,  -6.432005886626464e-03,   7.250906915907069e-04,  -4.998987463443618e-05,   2.780585399033390e-06,  -9.781706898283786e-08,
  -9.334249804278949e-10,   2.848338682434040e-10,  -1.606546725800825e-11,   8.871607113270410e-13,  -3.630415398025047e-14,  -7.928861140984555e-16,   1.252479876446563e-16,
  -2.603531641469579e-18,   1.196607788440656e-19,  -4.693783438016562e-03,   5.292368304300656e-04,  -3.648730598973641e-05,   2.027924164416861e-06,  -7.118805845316337e-08,
  -6.938700652845366e-10,   2.087132106987713e-10,  -1.176768242490182e-11,   6.457546964832558e-13,  -2.621839074588428e-14,  -5.851980012831069e-16,   9.171024583446760e-17,
  -1.948736881942263e-18,   8.627277306315881e-20,  -3.038943103076619e-03,   3.426913031960647e-04,  -2.362631382053143e-05,   1.312436159658600e-06,  -4.600674279420875e-08,
  -4.546795508409092e-10,   1.354941452713473e-10,  -7.637504159179344e-12,   4.173764970648071e-13,  -1.685717464925270e-14,  -3.817316582128455e-16,   5.950853258241241e-17,
  -1.282273580913140e-18,   5.540828597296361e-20,  -1.630393215881028e-03,   1.838655307422765e-04,  -1.267633579251782e-05,   7.039777960610604e-07,  -2.465966644142245e-08,
  -2.454357406733954e-10,   7.279303067091786e-11,  -4.102636313174451e-12,   2.237261415669397e-13,  -9.011436496015725e-15,  -2.055900894615489e-16,   3.196244417387627e-17,
  -6.935624398638264e-19,   2.960324304988071e-20,  -6.067428435796133e-04,   6.842616036651274e-05,  -4.717541848068413e-06,   2.619631822888659e-07,  -9.173999697765216e-09,
  -9.153208870314044e-11,   2.710256873817984e-11,  -1.527437322109127e-12,   8.323311943929799e-14,  -3.349358868567500e-15,  -7.661212861066044e-17,   1.189933490590750e-17,
  -2.588312735609965e-19,   1.100073944824395e-20,  -6.853684424492882e-05,   7.729352729681862e-06,  -5.328889866450577e-07,   2.959066852424824e-08,  -1.036229176484600e-09,
  -1.034282458286941e-11,   3.061702180193124e-12,  -1.725490850563821e-13,   9.401443005802430e-15,  -3.782636641153696e-16,  -8.655845724768563e-18,   1.344216267175398e-18,
  -2.925021531216292e-20,   1.242342451526619e-21,  -5.687093038995871e-02,  -7.776985751583685e-04,   3.930679209353409e-04,   7.729730624388011e-06,  -2.334163204125221e-06,
  -5.858857915205614e-08,   1.233769907096889e-08,   3.882129954269671e-10,  -6.039343394650888e-11,  -2.340656954879192e-12,   2.801229917599715e-13,   1.315124098168557e-14,
  -1.245049759007622e-15,  -7.055807871122531e-17,  -5.409361997765417e-02,  -7.392138519524743e-04,   3.735456114470087e-04,   7.337045821556744e-06,  -2.215310862121044e-06,
  -5.550752021116156e-08,   1.168933939019167e-08,   3.669614900664094e-10,  -5.709962579565516e-11,  -2.206714623800057e-12,   2.642015551922486e-13,   1.236157881662270e-14,
  -1.171085315453702e-15,  -6.609915532866138e-17,  -4.881538384832740e-02,  -6.662805922212315e-04,   3.365771743634832e-04,   6.596996838959058e-06,  -1.991430516422226e-06,
  -4.974297050550607e-08,   1.047609416670953e-08,   3.275300091301711e-10,  -5.098332968895295e-11,  -1.960431529480151e-12,   2.348854157952453e-13,   1.092361932041424e-14,
  -1.036103779934051e-15,  -5.806171666778351e-17,  -4.155926869821737e-02,  -5.664163253854480e-04,   2.860135611694860e-04,   5.591660534767331e-06,  -1.687503939426476e-06,
  -4.199288654920767e-08,   8.844606654376201e-09,   2.751509091157766e-10,  -4.284960253067063e-11,  -1.637590995586613e-12,   1.963777146615202e-13,   9.065547896422848e-15,
  -8.611247233721116e-16,  -4.783320753541987e-17,  -3.304025268412301e-02,  -4.496739125960861e-04,   2.269744892163191e-04,   4.426457568011853e-06,  -1.335513282061073e-06,
  -3.311225015975276e-08,   6.974690707164437e-09,   2.159296993757158e-10,  -3.364195442358356e-11,  -1.278010244089714e-12,   1.533888140081765e-13,   7.029873388889835e-15,
  -6.687142320027025e-16,  -3.682465593614988e-17,  -2.409312034506136e-02,  -3.275318515402364e-04,   1.652702574766788e-04,   3.216682138141479e-06,  -9.703074138831010e-07,
  -2.398648992565948e-08,   5.052769255817710e-09,   1.558169616302064e-10,  -2.428505460424351e-11,  -9.180781828286443e-13,   1.102656401210382e-13,   5.023814255473940e-15,
  -4.784429742822529e-16,  -2.616103726768439e-17,  -1.559109460625390e-02,  -2.117926945216443e-04,   1.068466259921621e-04,   2.076835992096967e-06,  -6.263877704083741e-07,
  -1.545438828775427e-08,   3.255606287430698e-09,   1.001357650307403e-10,  -1.561048360750442e-11,  -5.882396138929069e-13,   7.068289606760046e-14,   3.207772582858570e-15,
  -3.057275282163922e-16,  -1.663827361735778e-17,  -8.362488024636808e-03,  -1.135540062017861e-04,   5.728031442959101e-05,   1.112635783918556e-06,  -3.355545628008997e-07,
  -8.270571298262847e-09,   1.742305793749954e-09,   5.351819934241675e-11,  -8.344136937692052e-12,  -3.139040240982480e-13,   3.772763505295993e-14,   1.708715723643851e-15,
  -1.629194816930709e-16,  -8.844779689659695e-18,  -3.111782393458962e-03,  -4.224914359440029e-05,   2.131103372931064e-05,   4.138566175342676e-07,  -1.248099615559416e-07,
  -3.075174362407272e-09,   6.478309197989592e-10,   1.989008652621629e-11,  -3.101237155273948e-12,  -1.166000255066612e-13,   1.401512878277336e-14,   6.343088390485396e-16,
  -6.048727181830245e-17,  -3.281014285037090e-18,  -3.514977393796988e-04,  -4.772236766522904e-06,   2.407165763662911e-06,   4.674499967258338e-08,  -1.409719786681746e-08,
  -3.473195184830863e-10,   7.316807035588089e-11,   2.246283266628720e-12,  -3.502399999248307e-13,  -1.316707892491606e-14,   1.582681624647866e-15,   7.162234791097343e-17,
  -6.830009648678135e-18,  -3.704304662714707e-19,  -7.135679991436847e-03,   7.417913071105395e-04,  -4.407764561835593e-05,   2.270844858151025e-06,  -1.259876260083934e-07,
   4.370452035588805e-09,   7.645092071019727e-11,  -1.047280597140492e-11,  -2.919255718822150e-14,   4.485754010621761e-15,   2.394528554313577e-15,  -1.050373483470197e-16,
  -7.361867957071426e-18,   3.910968123013670e-19,  -6.789941611048934e-03,   7.059153317391452e-04,  -4.195608465070981e-05,   2.161669479113336e-06,  -1.198254725099633e-07,
   4.151350032257743e-09,   7.272563562875698e-11,  -9.959719336726582e-12,  -2.467991586379548e-14,   4.103960153629916e-15,   2.264342781830205e-15,  -9.906927575409267e-17,
  -6.937033701469029e-18,   3.684814705880958e-19,  -6.131763006151265e-03,   6.375920046290364e-04,  -3.791152701901644e-05,   1.953482930144020e-06,  -1.081182039998651e-07,
   3.737246470516144e-09,   6.564592745106765e-11,  -8.985504095678303e-12,  -1.737804785563641e-14,   3.446133815220310e-15,   2.022462691021868e-15,  -8.807746469498297e-17,
  -6.157471404098305e-18,   3.270011253172006e-19,  -5.224800013067178e-03,   5.433916058821412e-04,  -3.232701777917780e-05,   1.665928003150556e-06,  -9.203137735554121e-08,
   3.172423659266675e-09,   5.591013285297287e-11,  -7.647739920994642e-12,  -9.788549296668769e-15,   2.671439647259405e-15,   1.700515154842702e-15,  -7.363584977903366e-17,
  -5.138406413834197e-18,   2.728111105908610e-19,  -4.157260517768184e-03,   4.324478343700689e-04,  -2.573969853921359e-05,   1.326611473270378e-06,  -7.315417142540458e-08,
   2.514940082014581e-09,   4.447061929111114e-11,  -6.078707827621090e-12,  -3.944276968419312e-15,   1.923361209705591e-15,   1.335670399860265e-15,  -5.751218859752143e-17,
  -4.006569493105885e-18,   2.126659716995167e-19,  -3.033531826321769e-03,   3.156036971019358e-04,  -1.879256707245807e-05,   9.686474139477971e-07,  -5.333720846142452e-08,
   1.829683678155113e-09,   3.244283180262484e-11,  -4.431967907799066e-12,  -6.352540380447715e-16,   1.285836944270476e-15,   9.645207917183771e-16,  -4.133965417343017e-17,
  -2.876278182214455e-18,   1.526406201313261e-19,  -1.963924431591028e-03,   2.043443307112668e-04,  -1.217086754320082e-05,   6.273743825503771e-07,  -3.451239090193806e-08,
   1.182214653248710e-09,   2.100128537477662e-11,  -2.867771073079790e-12,   5.428907409469648e-16,   7.825317587664524e-16,   6.201457594792110e-16,  -2.649765045481587e-17,
  -1.842159633847740e-18,   9.774850974035530e-20,  -1.053616595724623e-03,   1.096334721103287e-04,  -6.530719739478888e-06,   3.366505637667512e-07,  -1.851032248813090e-08,
   6.335985090611021e-10,   1.126634017577130e-11,  -1.538109179953678e-12,   5.532541118394050e-16,   4.061269845271372e-16,   3.315229542174279e-16,  -1.414272152745406e-17,
  -9.828381008889500e-19,   5.214781172936365e-20,  -3.920944940177602e-04,   4.079991197595579e-05,  -2.430511077651875e-06,   1.252911600854872e-07,  -6.887803364237063e-09,
   2.357051424563194e-10,   4.192609746961619e-12,  -5.723419315379403e-13,   2.397731587916738e-16,   1.493673737899362e-16,   1.232214626294023e-16,  -5.253676028861688e-18,
  -3.650511661749638e-19,   1.936858320098429e-20,  -4.429039202832283e-05,   4.608708744254621e-06,  -2.745496498726450e-07,   1.415286738474648e-08,  -7.780239268399710e-10,
   2.662340012537962e-11,   4.735896601918866e-13,  -6.464992943118528e-14,   2.769150440810498e-17,   1.684061445974283e-17,   1.391618451946213e-17,  -5.932784764425326e-19,
  -4.122301951181303e-20,   2.187168935447157e-21,  -5.398494858094394e-02,   2.119941655717013e-03,   2.753403327246771e-04,  -2.330053204971590e-05,  -8.167212895707080e-07,
   1.547752557194193e-07,  -4.234394644538644e-10,  -7.733901284755645e-10,   2.433970869285388e-11,   3.032194799143679e-12,  -1.993241753057930e-13,  -8.560554841649468e-15,
   1.146803829460289e-15,   7.316186427503138e-18,  -5.135113221539508e-02,   2.014834698221289e-03,   2.618017144121921e-04,  -2.212261010524628e-05,  -7.771128271845137e-07,
   1.467788759895657e-07,  -3.839971836652620e-10,  -7.326214647196458e-10,   2.290608045172394e-11,   2.870916379079944e-12,  -1.875262989897171e-13,  -8.123390069483902e-15,
   1.077565718739681e-15,   7.254054293601088e-18,  -4.634456146105118e-02,   1.815724347572271e-03,   2.361090552447448e-04,  -1.990037436622449e-05,  -7.017145134794520e-07,
   1.317617677416012e-07,  -3.169087659942885e-10,  -6.563757356494239e-10,   2.028440385874505e-11,   2.569803647600101e-12,  -1.659752108846813e-13,  -7.299462904935625e-15,
   9.515835203295407e-16,   7.001652055383788e-18,  -3.945989523390490e-02,   1.543247500691962e-03,   2.008611765469170e-04,  -1.687703700835788e-05,  -5.978349845361403e-07,
   1.114638990994707e-07,  -2.396820177002130e-10,  -5.539348432880662e-10,   1.687632086630118e-11,   2.166276914527459e-12,  -1.380029338140203e-13,  -6.181032699304743e-15,
   7.890219567239690e-16,   6.409022820298416e-18,  -3.137443472593946e-02,   1.224917771243702e-03,   1.595704437560233e-04,  -1.336730488180376e-05,  -4.756038515756831e-07,
   8.806846248580927e-08,  -1.676116074956702e-10,  -4.366454692351982e-10,   1.311784475807837e-11,   1.705647860554870e-12,  -1.072061043475463e-13,  -4.887258862505341e-15,
   6.112663437986860e-16,   5.424316528205291e-18,  -2.288028297469208e-02,   8.920507400135543e-04,   1.162905989503693e-04,  -9.718109776207732e-06,  -3.469916081786503e-07,
   6.390001653973432e-08,  -1.089068633178165e-10,  -3.162173076469626e-10,   9.392059488860537e-12,   1.234056704749982e-12,  -7.672208863788137e-14,  -3.547605018606088e-15,
   4.364722479316814e-16,   4.140169246580634e-18,  -1.480705069979031e-02,   5.767644476845678e-04,   7.522422546406050e-05,  -6.276223286071606e-06,  -2.246189210484621e-07,
   4.121448566852849e-08,  -6.483148174424099e-11,  -2.036983238501307e-10,   6.004242950503400e-12,   7.944368492338326e-13,  -4.903326697239312e-14,  -2.288637047204877e-15,
   2.785317993563378e-16,   2.755512757353686e-18,  -7.942177375191463e-03,   3.092181773085702e-04,   4.033936117726930e-05,  -3.362884844980511e-06,  -1.204974382266817e-07,
   2.206843928854772e-08,  -3.322680636929578e-11,  -1.090002256210087e-10,   3.200312757673916e-12,   4.249667219832694e-13,  -2.613129127895648e-14,  -1.225565019528382e-15,
   1.483225854462550e-16,   1.498547134441991e-18,  -2.955408431686252e-03,   1.150460664913330e-04,   1.500970719131415e-05,  -1.250923377863572e-06,  -4.484113347923730e-08,
   8.207080403828191e-09,  -1.216429569578146e-11,  -4.052716742354705e-11,   1.188272783382088e-12,   1.579876796703446e-13,  -9.702026503311796e-15,  -4.557901869561135e-16,
   5.505426593956622e-17,   5.602688712679301e-19,  -3.338347131166684e-04,   1.299494564492791e-05,   1.695433247997753e-06,  -1.412926041028664e-07,  -5.065168131276351e-09,
   9.269606030138569e-10,  -1.370464153673305e-12,  -4.577235391471987e-12,   1.341771740756931e-13,   1.784317688890203e-14,  -1.095522855480748e-15,  -5.148009226506135e-17,
   6.216289530264430e-18,   6.333352626376999e-20,  -4.740566879308683e-03,   4.707105606572053e-04,  -2.597881865624335e-05,   9.585775152911063e-07,  -4.239932439946405e-08,
   3.106502338404608e-09,  -1.405851390628657e-10,  -1.832682057671381e-12,   4.716677669881611e-13,  -5.743034759114820e-15,  -1.464672722457934e-15,   4.674381408775137e-17,
   5.012292450612983e-18,  -3.364156605029670e-19,  -4.510767845434064e-03,   4.479023086987307e-04,  -2.472291333517317e-05,   9.128719435932271e-07,  -4.039824192419867e-08,
   2.954230369307002e-09,  -1.333651055945152e-10,  -1.749216004366673e-12,   4.468437211496570e-13,  -5.394068402905793e-15,  -1.383877022148698e-15,   4.374831540072407e-17,
   4.743276105495596e-18,  -3.156915228170172e-19,  -4.073345914914159e-03,   4.044830800581435e-04,  -2.233091925711032e-05,   8.255603745370699e-07,  -3.656683746141572e-08,
   2.665063064974218e-09,  -1.197891313049997e-10,  -1.588049996249720e-12,   4.004079239435519e-13,  -4.760160792337956e-15,  -1.234146248067998e-15,   3.835734464449274e-17,
   4.241809441130773e-18,  -2.781285361732309e-19,  -3.470668988647854e-03,   3.446529758886702e-04,  -1.903255750312666e-05,   7.046608438672415e-07,  -3.124488419289821e-08,
   2.267976624329137e-09,  -1.014063995538401e-10,  -1.361659525356207e-12,   3.379942486971795e-13,  -3.944008566383886e-15,  -1.035654266885323e-15,   3.151882830826352e-17,
   3.571464519367599e-18,  -2.299434941666469e-19,  -2.761397815737832e-03,   2.742313771122305e-04,  -1.514740146112344e-05,   5.616172838573132e-07,  -2.492753316227574e-08,
   1.802342885630051e-09,  -8.017657459808631e-11,  -1.089889978732511e-12,   2.664947556817919e-13,  -3.053525083214657e-15,  -8.118233093705312e-16,   2.419556266707315e-17,
   2.808598500283807e-18,  -1.776221930815574e-19,  -2.014896379391729e-03,   2.001043612355464e-04,  -1.105510731171465e-05,   4.103574328317466e-07,  -1.822849823584290e-08,
   1.313843258235835e-09,  -5.820598729208869e-11,  -7.990150826309898e-13,   1.930374679658027e-13,  -2.179383271811637e-15,  -5.852461009164389e-16,   1.714471343151820e-17,
   2.029954990623399e-18,  -1.265252821343885e-19,  -1.304419577588953e-03,   1.295482492978231e-04,  -7.158045598382472e-06,   2.659018033898297e-07,  -1.181785532306870e-08,
   8.500248884124800e-10,  -3.755566710193396e-11,  -5.188620008419812e-13,   1.243687309133274e-13,  -1.390397456489411e-15,  -3.758535484314798e-16,   1.088380222470849e-17,
   1.305882234326664e-18,  -8.061031864282217e-20,  -6.997923078742292e-04,   6.950063319168553e-05,  -3.840437572295412e-06,   1.427169053732654e-07,  -6.344678155162939e-09,
   4.558703268505977e-10,  -2.011309944983269e-11,  -2.787927089837600e-13,   6.655600502089568e-14,  -7.403183221874767e-16,  -2.008054998765219e-16,   5.779993547038041e-18,
   6.982950859726465e-19,  -4.289008028434481e-20,  -2.604205343658889e-04,   2.586405942669056e-05,  -1.429218889327803e-06,   5.311923924358608e-08,  -2.361709957478892e-09,
   1.696281295403464e-10,  -7.480395545609177e-12,  -1.038059678217207e-13,   2.474678997819718e-14,  -2.747796446571357e-16,  -7.462013943307368e-17,   2.143358794757603e-18,
   2.595678525468794e-19,  -1.591520961942766e-20,  -2.941668135969116e-05,   2.921564214824845e-06,  -1.614429552063827e-07,   6.000417392362243e-09,  -2.667857340849951e-10,
   1.916057180586450e-11,  -8.448929265237830e-13,  -1.172675876145856e-14,   2.794974861227341e-15,  -3.102573339461401e-17,  -8.427042606231915e-18,   2.419741263478220e-19,
   2.931506721400990e-20,  -1.796934496540070e-21,  -4.291227198974677e-02,   3.186348235918586e-03,   3.036358875166730e-06,  -1.722071804613619e-05,   1.093465060465397e-06,
   1.606152345616865e-08,  -5.946848510752822e-09,   2.650831750055899e-10,   1.076055205438805e-11,  -1.684887899229158e-12,   4.631935240480611e-14,   4.279667486366332e-15,
  -4.070742717362949e-16,   4.706427666724281e-18,  -4.082463573975378e-02,   3.029837357564480e-03,   3.077320631362640e-06,  -1.637783884138455e-05,   1.037662185624315e-06,
   1.543754650442532e-08,  -5.648320110600954e-09,   2.504348048972431e-10,   1.029298767523943e-11,  -1.595869883053021e-12,   4.330688312141015e-14,   4.079119619378000e-15,
  -3.837405382210087e-16,   4.229752238039656e-18,  -3.685385877910464e-02,   2.732756906582267e-03,   3.077921656548583e-06,  -1.477666284233187e-05,   9.325881247733668e-07,
   1.418526526099531e-08,  -5.084194126160835e-09,   2.232956662132162e-10,   9.379568313374070e-12,  -1.429405604479097e-12,   3.789505532963210e-14,   3.693805023714267e-15,
  -3.408071966998232e-16,   3.429540017010731e-18,  -3.138883752185082e-02,   2.325063953985065e-03,   2.929469786543697e-06,  -1.257691825583644e-05,   7.900336561688093e-07,
   1.233629671902832e-08,  -4.314992150572378e-09,   1.873347436511466e-10,   8.077059729991669e-12,  -1.205843068692131e-12,   3.105394354520442e-14,   3.156754448642795e-15,
  -2.845132456525952e-16,   2.528869630596544e-18,  -2.496469013339451e-02,   1.847314172845413e-03,   2.566940290540331e-06,  -9.996227801131727e-06,   6.250592901759150e-07,
   1.000626916308762e-08,  -3.420010193564921e-09,   1.468074897212482e-10,   6.490594776011288e-12,  -9.500829274039212e-13,   2.376652086281972e-14,   2.518058467896251e-15,
  -2.218576890051608e-16,   1.715434905484755e-18,  -1.821029672875349e-02,   1.346396463252207e-03,   2.011322509530963e-06,  -7.287722347842011e-06,   4.540189887314318e-07,
   7.412516983649036e-09,  -2.487694107709925e-09,   1.058092766946660e-10,   4.772816400218949e-12,  -6.877539981114658e-13,   1.679470664182188e-14,   1.840656964114552e-15,
  -1.592412877357104e-16,   1.081015733105605e-18,  -1.178674112879413e-02,   8.709889772623652e-04,   1.361119296514455e-06,  -4.715329141840168e-06,   2.930445887359190e-07,
   4.846064242173860e-09,  -1.607169977071934e-09,   6.794118357728007e-11,   3.105355943621934e-12,  -4.428948954986947e-13,   1.064073895238706e-14,   1.192894590536082e-15,
  -1.019650648648987e-16,   6.279829021806225e-19,  -6.322669194263946e-03,   4.670868454890718e-04,   7.464433229295068e-07,  -2.528936900852692e-06,   1.569692720249995e-07,
   2.612782822793898e-09,  -8.612913149906974e-10,   3.629548026571361e-11,   1.670178033165452e-12,  -2.369561273717238e-13,   5.644948955095073e-15,   6.402894612937192e-16,
  -5.439247179370403e-17,   3.172941268314846e-19,  -2.352831395668355e-03,   1.737983342052185e-04,   2.798822963173682e-07,  -9.410228831729641e-07,   5.838308781654803e-08,
   9.739980230327086e-10,  -3.204014891457389e-10,   1.348713660349001e-11,   6.220839775960332e-13,  -8.809695728413745e-14,   2.092495168744477e-15,   2.383182363165337e-16,
  -2.020154596789493e-17,   1.155497113665775e-19,  -2.657704938593587e-04,   1.963156137459919e-05,   3.165270372732031e-08,  -1.062947147029037e-07,   6.594295869895457e-09,
   1.100512932280619e-10,  -3.618989480129221e-11,   1.523129322838325e-12,   7.027934059648219e-14,  -9.949786670579482e-15,   2.362177185965564e-16,   2.692077046786439e-17,
  -2.281216105030436e-18,   1.300705353777276e-20,  -3.212067945140745e-03,   3.009102817402996e-04,  -1.707486236762026e-05,   6.018207550941245e-07,  -1.118643452580163e-08,
   3.674608031296665e-10,  -5.910448840776250e-11,   4.402763353023849e-12,  -8.742522392081283e-14,  -9.207789761495652e-15,   7.232812617101397e-16,  -4.815754961470727e-18,
  -2.085672453256157e-18,   1.124456716688821e-19,  -3.056342565744292e-03,   2.863278079304109e-04,  -1.624639596906755e-05,   5.726655491650846e-07,  -1.066893673271992e-08,
   3.522895353442075e-10,  -5.629707893950425e-11,   4.178721083872937e-12,  -8.223805286272875e-14,  -8.765499688837717e-15,   6.840643082685640e-16,  -4.338571513611260e-18,
  -1.979358909596141e-18,   1.056558818618490e-19,  -2.759927829071405e-03,   2.585684028316115e-04,  -1.466972840906837e-05,   5.171623684245951e-07,  -9.673819219248984e-09,
   3.223252002644890e-10,  -5.092859902600082e-11,   3.756581145660105e-12,  -7.275883491588355e-14,  -7.921416626419728e-15,   6.111240961710284e-16,  -3.533819568452035e-18,
  -1.778938265070710e-18,   9.328946068915859e-20,  -2.351545594198178e-03,   2.203183970267409e-04,  -1.249801422455703e-05,   4.406771992515412e-07,  -8.283220453704486e-09,
   2.789451119687674e-10,  -4.348536022206535e-11,   3.183344440082822e-12,  -6.045557835569431e-14,  -6.754738820551449e-15,   5.139254850408919e-16,  -2.621585582584630e-18,
  -1.506751744426009e-18,   7.732057697933007e-20,  -1.870953996373200e-03,   1.752990392490290e-04,  -9.942953416367176e-06,   3.506458816632507e-07,  -6.621910001352518e-09,
   2.252555621287861e-10,  -3.466833921035494e-11,   2.519333904859942e-12,  -4.692255124749624e-14,  -5.377827704581440e-15,   4.036845925970930e-16,  -1.790275340442414e-18,
  -1.191690635170141e-18,   5.986188880940145e-20,  -1.365154890927133e-03,   1.279127167712857e-04,  -7.254475613407420e-06,   2.558701777533816e-07,  -4.850282907287455e-09,
   1.663036953920034e-10,  -2.533657881859288e-11,   1.830362247397842e-12,  -3.355029613864839e-14,  -3.925744701517285e-15,   2.915011894786167e-16,  -1.135268475488983e-18,
  -8.652359994295353e-19,   4.271323617486327e-20,  -8.837781476023867e-04,   8.281046248213821e-05,  -4.696224424389154e-06,   1.656543205654817e-07,  -3.147933977456411e-09,
   1.084918466317135e-10,  -1.641961491901904e-11,   1.181571991061592e-12,  -2.142758685012841e-14,  -2.542117528079169e-15,   1.874118219348241e-16,  -6.626446013219218e-19,
  -5.582721223140001e-19,   2.724147150631790e-20,  -4.741256334930909e-04,   4.442634700498828e-05,  -2.519356062802466e-06,   8.887186479425938e-08,  -1.690979519348332e-09,
   5.843147981890304e-11,  -8.813414244836942e-12,   6.329555324622283e-13,  -1.141511744998481e-14,  -1.363948818111932e-15,   1.001840683442409e-16,  -3.357116135011092e-19,
  -2.989799004865453e-19,   1.450177446267235e-20,  -1.764407569658909e-04,   1.653285652579479e-05,  -9.375441702457132e-07,   3.307301183970480e-08,  -6.295634123670297e-10,
   2.177418732822147e-11,  -3.280422383958595e-12,   2.354272336924510e-13,  -4.237632518855081e-15,  -5.075991574523972e-16,   3.723610969834416e-17,  -1.223775732760959e-19,
  -1.111945440459010e-19,   5.382118532427764e-21,  -1.993045759409557e-05,   1.867525509545558e-06,  -1.059033196219521e-07,   3.735878439386798e-09,  -7.111953026096236e-11,
   2.460105771183167e-12,  -3.705619487615316e-13,   2.659131549896516e-14,  -4.784900078457474e-16,  -5.733792363788802e-17,   4.205299701264782e-18,  -1.377783537694338e-20,
  -1.255913916041374e-20,   6.076943896683362e-22,  -3.102214648206890e-02,   2.668868640785638e-03,  -1.058196738815020e-04,  -2.242569274865210e-06,   6.122515930301813e-07,
  -3.807635587443751e-08,   5.040181246792943e-10,   1.007882141086821e-10,  -8.697437436104751e-12,   2.495373772328845e-13,   1.190873880274193e-14,  -1.588065004122685e-15,
   6.611289499582861e-17,   6.526450975267307e-19,  -2.951620338065926e-02,   2.538832565368471e-03,  -1.005628737702682e-04,  -2.144612651017432e-06,   5.826689199877565e-07,
  -3.616022016011454e-08,   4.723602253574578e-10,   9.613522868960307e-11,  -8.257473835212707e-12,   2.348239643855780e-13,   1.145171643088986e-14,  -1.508757448925184e-15,
   6.222524300600546e-17,   6.619062510170324e-19,  -2.665051182555902e-02,   2.291577916519405e-03,  -9.060839109115819e-05,  -1.953740383397294e-06,   5.263147122251557e-07,
  -3.254135776941841e-08,   4.150666078305976e-10,   8.717955637882525e-11,  -7.427270873004728e-12,   2.078896895122082e-13,   1.053089689986380e-14,  -1.358616792677285e-15,
   5.510289987704260e-17,   6.622497331026118e-19,  -2.270386951546218e-02,   1.951434313865776e-03,  -7.699363202849555e-05,  -1.682235913368148e-06,   4.485900244344219e-07,
  -2.761073471259816e-08,   3.418570097286706e-10,   7.465295858367468e-11,  -6.297720094397918e-12,   1.728531365823820e-13,   9.165419870159018e-15,  -1.153471624876039e-15,
   4.582883729159294e-17,   6.298232376524674e-19,  -1.806133730567082e-02,   1.551792832134884e-03,  -6.109797337491317e-05,  -1.351974826362127e-06,   3.570235160436942e-07,
  -2.187844209833832e-08,   2.629135386323292e-10,   5.967941140492815e-11,  -4.986799734623182e-12,   1.342336121167666e-13,   7.438820391116300e-15,  -9.144078009240117e-16,
   3.559722237066840e-17,   5.509714821284118e-19,  -1.317712156132427e-02,   1.131793102453953e-03,  -4.448639860100387e-05,  -9.944158920467914e-07,   2.605683830741871e-07,
  -1.591110994429737e-08,   1.865175590203269e-10,   4.370963287344089e-11,  -3.624515883524654e-12,   9.601375021395562e-14,   5.512722811223732e-15,  -6.651721510838968e-16,
   2.546515519550501e-17,   4.309257199918055e-19,  -8.530019164163816e-03,   7.324966307872412e-04,  -2.875946627938645e-05,  -6.471566288102675e-07,   1.687138931090245e-07,
  -1.027803079582975e-08,   1.184781117388197e-10,   2.836629404353830e-11,  -2.340362803633019e-12,   6.133332214677639e-14,   3.604791859001728e-15,  -4.297277197731284e-16,
   1.626818956939236e-17,   2.912099986548319e-19,  -4.575976661876041e-03,   3.929096792400638e-04,  -1.541766502084962e-05,  -3.481163259126648e-07,   9.051803854817653e-08,
  -5.507697235699696e-09,   6.293606424109791e-11,   1.523682576521216e-11,  -1.253864521933750e-12,   3.267699818084043e-14,   1.943724009209819e-15,  -2.302883992268063e-16,
   8.667573648585843e-18,   1.595767526924217e-19,  -1.702878148827195e-03,   1.462097183906957e-04,  -5.736081397503240e-06,  -1.296684523993449e-07,   3.368622699951606e-08,
  -2.048824621332980e-09,   2.334013149726613e-11,   5.672673360104338e-12,  -4.663937463023083e-13,   1.213102660497805e-14,   7.246067838034055e-16,  -8.566671590125641e-17,
   3.217784208275688e-18,   5.981736436896769e-20,  -1.923539128244687e-04,   1.651547666461872e-05,  -6.479125612236694e-07,  -1.464929827838711e-08,   3.805157078868254e-09,
  -2.314174146793628e-10,   2.635013929850447e-12,   6.408197677842472e-13,  -5.267915234713883e-14,   1.369774489933205e-15,   8.187314863908254e-17,  -9.676185015288157e-18,
   3.633365138028357e-19,   6.764618402367528e-21,  -2.239859653612577e-03,   1.903906379672313e-04,  -1.083823979057502e-05,   4.385946753668691e-07,  -1.033925661161498e-08,
  -2.548117395179073e-11,   7.383553460955488e-12,   4.997314304292853e-13,  -7.880932360478882e-14,   4.047741058530943e-15,  -3.842882896047847e-17,  -8.524226913523536e-18,
   6.054532588871331e-19,  -1.318777792617315e-20,  -2.131237070704986e-03,   1.811690800219867e-04,  -1.031290110711478e-05,   4.172547345234965e-07,  -9.833311312815935e-09,
  -2.390987257821125e-11,   6.958579425477002e-12,   4.796586006383202e-13,  -7.501798132128870e-14,   3.836664904624111e-15,  -3.539776904300725e-17,  -8.136829177842936e-18,
   5.736892375475536e-19,  -1.229826643562427e-20,  -1.924492648942978e-03,   1.636127396624800e-04,  -9.312900289419022e-06,   3.766665629684430e-07,  -8.872222821511505e-09,
  -2.105236938494646e-11,   6.176948409175412e-12,   4.397354805007876e-13,  -6.778723358010208e-14,   3.440885155771742e-15,  -3.011107337020171e-17,  -7.388100950016281e-18,
   5.141812828051438e-19,  -1.070839715508451e-20,  -1.639677368439756e-03,   1.394176917189858e-04,  -7.935069017336669e-06,   3.208070405481180e-07,  -7.551833249964839e-09,
  -1.737746849431010e-11,   5.152971487484763e-12,   3.814286217756052e-13,  -5.779986020560962e-14,   2.907272148620203e-15,  -2.375646926156202e-17,  -6.335358620144759e-18,
   4.340716284171801e-19,  -8.716857460247509e-21,  -1.304532740278004e-03,   1.109356939812531e-04,  -6.313498884477830e-06,   2.551467271232106e-07,  -6.002643249344317e-09,
  -1.338956784099785e-11,   4.014909228262082e-12,   3.086668370921808e-13,  -4.601777835088826e-14,   2.294150605456974e-15,  -1.744344039526379e-17,  -5.070867322428916e-18,
   3.422159646783082e-19,  -6.622795233217112e-21,  -9.518384390921285e-04,   8.095157296642198e-05,  -4.606771536687076e-06,   1.861132398064826e-07,  -4.376488803606467e-09,
  -9.511166042798266e-12,   2.879589532809039e-12,   2.282572115678379e-13,  -3.359385901808362e-14,   1.662774220983892e-15,  -1.187552228348568e-17,  -3.717289545164282e-18,
   2.478358360271947e-19,  -4.649601144253915e-21,  -6.161941808821842e-04,   5.240947831574891e-05,  -2.982380783931069e-06,   1.204624765535630e-07,  -2.831826531867062e-09,
  -6.046069894937829e-12,   1.842846558659764e-12,   1.490637859391933e-13,  -2.175479756024362e-14,   1.071665430451549e-15,  -7.324958886265692e-18,  -2.413749264334199e-18,
   1.596418900953255e-19,  -2.932198317181543e-21,  -3.305705713336161e-04,   2.811719086448349e-05,  -1.599984859358761e-06,   6.461858129468917e-08,  -1.518811783056665e-09,
  -3.212797639351980e-12,   9.827608566057455e-13,   8.032479234164017e-14,  -1.167269986803188e-14,   5.736025406251046e-16,  -3.829890507933116e-18,  -1.296886181005775e-18,
   8.542197380206276e-20,  -1.551650546927314e-21,  -1.230179309807889e-04,   1.046361017207759e-05,  -5.954184035392684e-07,   2.404625212557643e-08,  -5.651584297042588e-10,
  -1.191615715550311e-12,   3.649620653311565e-13,   2.993802832740166e-14,  -4.344095687645356e-15,   2.132889509821220e-16,  -1.412344176746421e-18,  -4.828755943710251e-19,
   3.176005782127727e-20,  -5.746608997731290e-22,  -1.389589674420544e-05,   1.181953978815403e-06,  -6.725750539303488e-08,   2.716209694362303e-09,  -6.383845178575141e-11,
  -1.345313525907396e-13,   4.121185896109784e-14,   3.382575074905085e-15,  -4.907059286995596e-16,   2.408970215082300e-17,  -1.593047718397106e-19,  -5.454936545845004e-20,
   3.587047162336779e-21,  -6.486312914480052e-23,  -2.204248967334160e-02,   1.830471039076088e-03,  -9.543788543029110e-05,   2.630533784367884e-06,   7.691397596258427e-08,
  -1.438117924599520e-08,   9.012464141627282e-10,  -2.733351184128266e-11,  -4.606559653923262e-13,   1.056796992444515e-13,  -6.281013917256093e-15,   1.716711291180616e-16,
   3.687155911215755e-18,  -6.706522340738453e-19,  -2.097315151318023e-02,   1.741662625545898e-03,  -9.078105619067094e-05,   2.498257479570241e-06,   7.357309607709974e-08,
  -1.369819643080436e-08,   8.569783633062825e-10,  -2.588908869141459e-11,  -4.465827045651266e-13,   1.008048003181363e-13,  -5.967177360635072e-15,   1.617316868743488e-16,
   3.606039321636082e-18,  -6.406043321375877e-19,  -1.893800424579805e-02,   1.572646458537699e-03,  -8.192911638702402e-05,   2.248404801950882e-06,   6.705539608011847e-08,
  -1.239226962996504e-08,   7.729411839188442e-10,  -2.318795864203097e-11,  -4.164100717696411e-13,   9.142067252657153e-14,  -5.373343887828081e-15,   1.434639586827763e-16,
   3.411377737334351e-18,  -5.823336985478501e-19,  -1.613464456491626e-02,   1.339836795631777e-03,  -6.975695605833644e-05,   1.907915235381918e-06,   5.776884777036087e-08,
  -1.058169791340584e-08,   6.576045392800707e-10,  -1.956037204139930e-11,  -3.682974654940497e-13,   7.829186931547529e-14,  -4.562311014140084e-15,   1.195658282511081e-16,
   3.065600591447530e-18,  -5.000357515624291e-19,  -1.283628866659147e-02,   1.065927018510422e-03,  -5.546241737081761e-05,   1.511963826346641e-06,   4.645264068105023e-08,
  -8.436789630191307e-09,   5.224511830169994e-10,  -1.541064823962327e-11,  -3.034287151709367e-13,   6.259434384406684e-14,  -3.617271685939617e-15,   9.305998560807978e-17,
   2.561237179794477e-18,  -4.007426926085975e-19,  -9.365573916855299e-03,   7.777116318059225e-04,  -4.044608740079302e-05,   1.099671272980918e-06,   3.418224685621288e-08,
  -6.166297596296242e-09,   3.807595027624620e-10,  -1.115489505363913e-11,  -2.274978086865730e-13,   4.584818515349536e-14,  -2.631783921626267e-15,   6.668133291439665e-17,
   1.940287762983546e-18,  -2.940637040851285e-19,  -6.062893219049171e-03,   5.034560059295108e-04,  -2.617448802215505e-05,   7.103919358447069e-07,   2.225198096134966e-08,
  -3.996354806123680e-09,   2.463026187746219e-10,  -7.183107719043785e-12,  -1.498824193932090e-13,   2.975575770666297e-14,  -1.700477004578833e-15,   4.264503561016499e-17,
   1.286569149022533e-18,  -1.910669127600143e-19,  -3.252534973629077e-03,   2.700860945365518e-04,  -1.403932671168275e-05,   3.806901800544526e-07,   1.197151057694886e-08,
  -2.145155848231657e-09,   1.320814822954453e-10,  -3.842980055701257e-12,  -8.112496980966547e-14,   1.598361983596166e-14,  -9.113485269270874e-16,   2.273365430306322e-17,
   6.985865901284518e-19,  -1.026918489540826e-19,  -1.210388040970824e-03,   1.005088716805493e-04,  -5.224240572134598e-06,   1.416156175158236e-07,   4.459453564377394e-09,
  -7.984529328740441e-10,   4.914570101154016e-11,  -1.428752289324175e-12,  -3.028256568646457e-14,   5.950763678289012e-15,  -3.390293688377022e-16,   8.441372751412942e-18,
   2.610549507815392e-19,  -3.824001247980517e-20,  -1.367233002972418e-04,   1.135330305839639e-05,  -5.901154535620529e-07,   1.599569665414875e-08,   5.038111247500982e-10,
  -9.019472907664216e-11,   5.551291906430179e-12,  -1.613649222227343e-13,  -3.422331620549936e-15,   6.722356006636187e-16,  -3.829406057244930e-17,   9.531880984798263e-19,
   2.950775276182306e-20,  -4.319964500677219e-21,  -1.622307932200932e-03,   1.219570154346669e-04,  -6.549268608649708e-06,   2.798773335541450e-07,  -8.919100785751272e-09,
   1.482516480758475e-10,   3.612595312547133e-12,  -3.291964763720915e-13,   5.106511713469783e-15,   6.412307852852692e-16,  -5.765014782861332e-17,   2.351761326339768e-18,
  -2.553116263192664e-20,  -3.347726959155797e-21,  -1.543595389034365e-03,   1.160500318173650e-04,  -6.232297032864837e-06,   2.663074613092523e-07,  -8.483647329787325e-09,
   1.408384839270915e-10,   3.440684401108905e-12,  -3.124721511260307e-13,   4.780670951131812e-15,   6.138078013236914e-16,  -5.488823731095176e-17,   2.229235531437696e-18,
  -2.358247592407223e-20,  -3.212543036884068e-21,  -1.393795209846043e-03,   1.048041067721818e-04,  -5.628735827980823e-06,   2.404782869605341e-07,  -7.656024176323936e-09,
   1.268206072408857e-10,   3.112053328097243e-12,  -2.809445035874917e-13,   4.192298200852981e-15,   5.600962965648691e-16,  -4.961568921272431e-17,   1.999397516168290e-18,
  -2.016321730016138e-20,  -2.943859418505086e-21,  -1.187457724241956e-03,   8.930568593674820e-05,  -4.796754029166446e-06,   2.048931554970228e-07,  -6.518177620739867e-09,
   1.076865792203286e-10,   2.656645309238655e-12,  -2.381063422848562e-13,   3.443451702409122e-15,   4.831820462975527e-16,  -4.232354031367347e-17,   1.689381657266337e-18,
  -1.601419170577100e-20,  -2.551957871478491e-21,  -9.446968579308428e-04,   7.106121121380165e-05,  -3.817117622944290e-06,   1.630169983593754e-07,  -5.182181076578997e-09,
   8.539467261907166e-11,   2.117509997725496e-12,  -1.884591661405982e-13,   2.640429652132692e-15,   3.890116110376934e-16,  -3.370957102892872e-17,   1.333079276835531e-18,
  -1.184195870814997e-20,  -2.063754251211311e-21,  -6.892595670421864e-04,   5.185452802591373e-05,  -2.785591334654566e-06,   1.189455153491700e-07,  -3.778946734337071e-09,
   6.214256957678104e-11,   1.547237642920365e-12,  -1.369286296807990e-13,   1.868250951504135e-15,   2.865226112960081e-16,  -2.461624373361490e-17,   9.661524207976758e-19,
  -8.112394599346867e-21,  -1.525222001446971e-21,  -4.461956365484554e-04,   3.357154327868351e-05,  -1.803517391222878e-06,   7.700286717960010e-08,  -2.445455652730689e-09,
   4.015908518994622e-11,   1.002570125928809e-12,  -8.839535336109284e-14,   1.184509257341084e-15,   1.866308557590527e-16,  -1.594422611997299e-17,   6.226581295881023e-19,
  -5.026045133271431e-21,  -9.956295218684230e-22,  -2.393678602957841e-04,   1.801081816392199e-05,  -9.675910884204779e-07,   4.131005333331459e-08,  -1.311660539947671e-09,
   2.152485587143780e-11,   5.381035996649537e-13,  -4.735295545650337e-14,   6.285825966333235e-16,   1.004365569557940e-16,  -8.555855680817122e-18,   3.332635919332670e-19,
  -2.634175311303597e-21,  -5.363864358714442e-22,  -8.907748626170273e-05,   6.702596567897685e-06,  -3.600847790960923e-07,   1.537307579635939e-08,  -4.880857373381680e-10,
   8.007716466687438e-12,   2.002815318621435e-13,  -1.761294415665167e-14,   2.330293672016853e-16,   3.741696202461772e-17,  -3.184246096996230e-18,   1.239196091883184e-19,
  -9.722281899875133e-22,  -1.999018911544224e-22,  -1.006203392474347e-05,   7.571154312683451e-07,  -4.067469455003151e-08,   1.736517052289188e-09,  -5.513274105484829e-11,
   9.044931845394492e-13,   2.262404604674259e-14,  -1.989368728419960e-15,   2.630664477476361e-17,   4.227285574700873e-18,  -3.596921336289043e-19,   1.399594655177473e-20,
  -1.096769771691711e-22,  -2.258580927788641e-23,  -1.603894592788777e-02,   1.198629048373476e-03,  -6.288604700467316e-05,   2.476186622042831e-06,  -5.520150198778121e-08,
  -1.446842685736614e-09,   2.421009402459124e-10,  -1.502832237979381e-11,   5.733071111199385e-13,  -9.287748623045155e-15,  -5.193799697559113e-16,   5.408406670886953e-17,
  -2.663923696677021e-18,   7.648716436829257e-20,  -1.526069006066934e-02,   1.140547306491849e-03,  -5.983682720607417e-05,   2.355284928856878e-06,  -5.240670802140157e-08,
  -1.385893912842932e-09,   2.307980492134088e-10,  -1.430665869116129e-11,   5.446837635718264e-13,  -8.745923510811529e-15,  -4.993409607719967e-16,   5.162471620975576e-17,
  -2.534173919157266e-18,   7.232754937636103e-20,  -1.377959414707576e-02,   1.029979798877642e-03,  -5.403294567620106e-05,   2.125498956595381e-06,  -4.713502090041569e-08,
  -1.266138908958073e-09,   2.091055457750239e-10,  -1.293004975364612e-11,   4.905289764343924e-13,  -7.751536647084731e-15,  -4.591000751128886e-16,   4.687566239243492e-17,
  -2.287322123330213e-18,   6.458795222934505e-20,  -1.173955631611885e-02,   8.776232666455710e-04,  -4.603701305598994e-05,   1.809583804231366e-06,  -3.996539875334715e-08,
  -1.093889053058902e-09,   1.788747767258205e-10,  -1.102783606039867e-11,   4.165632266081962e-13,  -6.453496701600850e-15,  -3.995950665688782e-16,   4.020272754094204e-17,
  -1.947578676537063e-18,   5.427568467760922e-20,  -9.339468598031723e-03,   6.982979884172157e-04,  -3.662768310224998e-05,   1.438662514505289e-06,  -3.164660579462350e-08,
  -8.819909003377693e-10,   1.428647690381398e-10,  -8.782392945920186e-12,   3.303499449752117e-13,  -5.017530221703794e-15,  -3.244312990744490e-16,   3.218772948887179e-17,
  -1.548398409220354e-18,   4.259295594993958e-20,  -6.814114103402070e-03,   5.095397142928798e-04,  -2.672526428392190e-05,   1.049086420041627e-06,  -2.300230857133273e-08,
  -6.504067805477583e-10,   1.045631048067078e-10,  -6.412951062791302e-12,   2.404021173832037e-13,  -3.592081111913230e-15,  -2.405422411913551e-16,   2.360333344641507e-17,
  -1.129046015889662e-18,   3.072770832968305e-20,  -4.411130095996822e-03,   3.298766026627551e-04,  -1.730131263273178e-05,   6.788846486676322e-07,  -1.485325068571139e-08,
  -4.239952321396129e-10,   6.782937041339354e-11,  -4.153667442852197e-12,   1.553566314223566e-13,  -2.295876452831831e-15,  -1.573553385516506e-16,   1.533026334750773e-17,
  -7.305777467237927e-19,   1.974150944946417e-20,  -2.366406395177645e-03,   1.769733683412853e-04,  -9.281688410341120e-06,   3.641290336254480e-07,  -7.957919405939014e-09,
  -2.282712522029307e-10,   3.642651893396760e-11,  -2.228897264503173e-12,   8.326884286281908e-14,  -1.223523806954886e-15,  -8.486686850169311e-17,   8.238000072898333e-18,
  -3.918374224658519e-19,   1.054902994813620e-20,  -8.806251372441800e-04,   6.585906471928442e-05,  -3.454074274914498e-06,   1.354968302776251e-07,  -2.960094901002176e-09,
  -8.505335702263525e-11,   1.356061805098848e-11,  -8.295317591576278e-13,   3.097771190614149e-14,  -4.542638959946259e-16,  -3.164050679421435e-17,   3.067452382582993e-18,
  -1.458048986726757e-19,   3.920281086543769e-21,  -9.947383102058946e-05,   7.439337472720141e-06,  -3.901664340198025e-07,   1.530532196564238e-08,  -3.343430829778342e-10,
  -9.609363378061875e-12,   1.531872575136825e-12,  -9.370382464923655e-14,   3.499013944911437e-15,  -5.129394641110832e-17,  -3.575103007313241e-18,   3.465260700052882e-19,
  -1.646964378362627e-20,   4.427311633003254e-22,  -1.221103470330944e-03,   8.081329181145407e-05,  -3.941282921001619e-06,   1.629537610327609e-07,  -5.691283385836182e-09,
   1.526244860824655e-10,  -2.014305195865153e-12,  -7.377805440536988e-14,   6.216687290861115e-15,  -2.018780186417221e-16,   1.206591612081888e-19,   3.817820600100029e-19,
  -2.466698224105289e-20,   8.912696637737216e-22,  -1.161827268635944e-03,   7.689712746001033e-05,  -3.750594977810015e-06,   1.550728665504917e-07,  -5.415335948248517e-09,
   1.451537246182246e-10,  -1.911155454841146e-12,  -7.040107780627015e-14,   5.914068073536529e-15,  -1.914148474541880e-16,   6.601570317670993e-20,   3.652501097578463e-19,
  -2.350144632252880e-20,   8.458477877717675e-22,  -1.049029040731041e-03,   6.944220321389614e-05,  -3.387471666629080e-06,   1.400641109953207e-07,  -4.890092481461592e-09,
   1.309624371808002e-10,  -1.717056240442222e-12,  -6.389070216817812e-14,   5.338457621371357e-15,  -1.717697756732712e-16,  -1.818650309645170e-20,   3.329691016343070e-19,
  -2.126970854319799e-20,   7.602461026737578e-22,  -8.936821161020607e-04,   5.916986332932159e-05,  -2.886873755945442e-06,   1.193706674637237e-07,  -4.166461511504280e-09,
   1.114667172545496e-10,  -1.453979160278396e-12,  -5.476223362627320e-14,   4.546297687705368e-15,  -1.452335996193462e-16,  -9.572587354436731e-20,   2.869251436388114e-19,
  -1.817017969845991e-20,   6.440134027120219e-22,  -7.109424470470241e-04,   4.707941555883972e-05,  -2.297370595890139e-06,   9.499894801299249e-08,  -3.314906857210818e-09,
   8.859512397726066e-11,  -1.149874491587042e-12,  -4.382024832560153e-14,   3.615321918454966e-15,  -1.146820847921266e-16,  -1.381907243468418e-19,   2.307659414063818e-19,
  -1.449251480231311e-20,   5.094527591004062e-22,  -5.186881233347831e-04,   3.435315640715056e-05,  -1.676583559519549e-06,   6.933096401938390e-08,  -2.418717456063454e-09,
   6.459058075453021e-11,  -8.349312438503784e-13,  -3.211994024928521e-14,   2.636808469672916e-15,  -8.316479682105846e-17,  -1.373228879328912e-19,   1.698325062289746e-19,
  -1.059508192132951e-20,   3.699689128268619e-22,  -3.357659215800807e-04,   2.224021903987015e-05,  -1.085516135073033e-06,   4.488980344521132e-08,  -1.565824093753587e-09,
   4.179194329125432e-11,  -5.387747460384933e-13,  -2.085621177608130e-14,   1.706520674738048e-15,  -5.361887538391302e-17,  -1.045200351084351e-19,   1.105662716737824e-19,
  -6.867680658160368e-21,   2.387512866133785e-22,  -1.801237033239510e-04,   1.193149686664084e-05,  -5.823874428894465e-07,   2.408397807363027e-08,  -8.400232278121288e-10,
   2.241405372046997e-11,  -2.885588795241807e-13,  -1.120598192149764e-14,   9.153651437096803e-16,  -2.870431943941092e-17,  -6.037728113682227e-20,   5.948653981479008e-20,
  -3.686686744678215e-21,   1.278733777168834e-22,  -6.703024419124924e-05,   4.440198544693804e-06,  -2.167336613838406e-07,   8.962811365072171e-09,  -3.126051418605563e-10,
   8.340330944876677e-12,  -1.073218229617881e-13,  -4.172401970241676e-15,   3.406247275484720e-16,  -1.067410615742996e-17,  -2.302643233008746e-20,   2.215933073020360e-20,
  -1.372262481906235e-21,   4.755929693262050e-23,  -7.571610760850758e-06,   5.015578850761082e-07,  -2.448195729321045e-08,   1.012428329296216e-09,  -3.531135399299743e-11,
   9.420953935916841e-13,  -1.212178055214771e-14,  -4.713473759562101e-16,   3.847607495892923e-17,  -1.205587860021695e-18,  -2.611024700159197e-21,   2.503476770412885e-21,
  -1.550139099766051e-22,   5.371728221800294e-24,  -1.208463408648257e-02,   7.986597489965656e-04,  -3.871472918529226e-05,   1.566713542337875e-06,  -5.096612215387068e-08,
   1.016377577373614e-09,   1.749701181127699e-11,  -3.109286704615540e-12,   1.893950560688747e-13,  -7.763237192891427e-15,   2.108500009019487e-16,  -1.544664832708565e-18,
  -2.252006192560112e-19,   1.667198547101543e-20,  -1.149799786173225e-02,   7.599529802598996e-04,  -3.684070272210718e-05,   1.490804146566207e-06,  -4.847869983210424e-08,
   9.649601900568719e-10,   1.680520117114423e-11,  -2.966373044891147e-12,   1.804610771440997e-13,  -7.387775401890496e-15,   2.001302973350594e-16,  -1.429986324546021e-18,
  -2.162162369528446e-19,   1.592629364169217e-20,  -1.038167657463078e-02,   6.862713399852344e-04,  -3.327240352372817e-05,   1.346294725961609e-06,  -4.375066150875012e-08,
   8.679562267070006e-10,   1.542489126556975e-11,  -2.691155049866751e-12,   1.633536551670838e-13,  -6.672642057687769e-15,   1.799233697140552e-16,  -1.227719770775635e-18,
  -1.983297042209986e-19,   1.448113647313482e-20,  -8.844274890732239e-03,   5.847467257073134e-04,  -2.835391042069544e-05,   1.147160448177726e-06,  -3.724960996416454e-08,
   7.359955420077741e-10,   1.339986141456497e-11,  -2.305793382355895e-12,   1.395871633551943e-13,  -5.686567925558199e-15,   1.524713353930560e-16,  -9.802898035899643e-19,
  -1.721619661495495e-19,   1.244038950258446e-20,  -7.035789090595836e-03,   4.652573991909800e-04,  -2.256282633154228e-05,   9.127689430091640e-07,  -2.961558864161407e-08,
   5.828443917014186e-10,   1.086032549560318e-11,  -1.844469164724837e-12,   1.113706304766535e-13,  -4.525255505623975e-15,   1.206639360643754e-16,  -7.289338619196104e-19,
  -1.394340646335025e-19,   9.976330954255388e-21,  -5.133150840805279e-03,   3.394883111381904e-04,  -1.646528607001231e-05,   6.660411061729331e-07,  -2.159669550775042e-08,
   4.236660412716618e-10,   8.041430311724820e-12,  -1.351657133208951e-12,   8.144464495272976e-14,  -3.302335741004520e-15,   8.766014594565452e-17,  -5.017751747607781e-19,
  -1.031844877152816e-19,   7.325198612360807e-21,  -3.322874284709837e-03,   2.197832336296392e-04,  -1.066026984439174e-05,   4.311975553647457e-07,  -1.397595712177762e-08,
   2.735841370404417e-10,   5.256025796560598e-12,  -8.775319626508309e-13,   5.280363594247876e-14,  -2.138050517660635e-15,   5.658478007332205e-17,  -3.119306944586526e-19,
  -6.741852820544784e-20,   4.761780832828622e-21,  -1.782575539846321e-03,   1.179095689046898e-04,  -5.719231327842024e-06,   2.313308542464307e-07,  -7.496278948533571e-09,
   1.465809730690544e-10,   2.833551419237715e-12,  -4.714611635061601e-13,   2.834926029130233e-14,  -1.147057408683368e-15,   3.031076614663820e-17,  -1.637806362066499e-19,
  -3.633890177811078e-20,   2.559961957949113e-21,  -6.633577394689703e-04,   4.387893013683849e-05,  -2.128383336640872e-06,   8.608777792558117e-08,  -2.789467152604921e-09,
   5.452387188914149e-11,   1.056266209496052e-12,  -1.755381107549582e-13,   1.055264014905070e-14,  -4.268707199833854e-16,   1.127390917608309e-17,  -6.048739940395999e-20,
  -1.354521746735182e-20,   9.533587464294187e-22,  -7.493164493914430e-05,   4.956494471019693e-06,  -2.404192691555444e-07,   9.724342478583807e-09,  -3.150901690005411e-10,
   6.158484744243720e-12,   1.193461900015962e-13,  -1.983008979076926e-14,   1.192058467791249e-15,  -4.821871424077742e-17,   1.273376123510327e-18,  -6.824277458824672e-21,
  -1.530441381535433e-21,   1.077023154126961e-22,  -9.504300647980823e-04,   5.576957412496399e-05,  -2.441101337657023e-06,   9.330727366141608e-08,  -3.200021333680635e-09,
   9.580373122230022e-11,  -2.268025407386496e-12,   2.753703817319658e-14,   9.146128663145467e-16,  -7.859931178760859e-17,   3.044549292931775e-18,  -6.269437614874540e-20,
  -6.876780388920845e-22,   1.298314704383368e-22,  -9.042742517382517e-04,   5.306530057570364e-05,  -2.322938649020906e-06,   8.879731109476864e-08,  -3.045379650504688e-09,
   9.116059824571224e-11,  -2.156923303007175e-12,   2.611282389853021e-14,   8.741858618741308e-16,  -7.487573068441280e-17,   2.894904135848708e-18,  -5.933427317695699e-20,
  -6.728147538714468e-22,   1.242198624779190e-22,  -8.164508614888925e-04,   4.791806539462202e-05,  -2.097947098502126e-06,   8.020726176812295e-08,  -2.750823327537250e-09,
   8.232193545360457e-11,  -1.945908757657435e-12,   2.343813047202927e-14,   7.956358015045918e-16,  -6.775189359103082e-17,   2.610844110518448e-18,  -5.306697282436243e-20,
  -6.370434588118447e-22,   1.132591088232572e-22,  -6.955144986604484e-04,   4.082690571813338e-05,  -1.787821243628824e-06,   6.836159276770641e-08,  -2.344606150376217e-09,
   7.014325546328239e-11,  -1.656085994556663e-12,   1.982342427188561e-14,   6.843182181095741e-16,  -5.786765683522404e-17,   2.221047357110438e-18,  -4.468341166956998e-20,
  -5.732132211475321e-22,   9.761763450015591e-23,  -5.532720248877784e-04,   3.248238933309566e-05,  -1.422674428350197e-06,   5.440770495459066e-08,  -1.866063334578849e-09,
   5.580962805982522e-11,  -1.316163059764211e-12,   1.565873034967110e-14,   5.494069112534471e-16,  -4.614896933844344e-17,   1.764382537879469e-18,  -3.513851964169772e-20,
  -4.796175373330295e-22,   7.852843201467958e-23,  -4.036411004438062e-04,   2.370064716900122e-05,  -1.038202642035490e-06,   3.970916449322304e-08,  -1.361956413573877e-09,
   4.072286280663992e-11,  -9.594845846188391e-13,   1.135884007808217e-14,   4.037811970087989e-16,  -3.373583463004561e-17,   1.285750200952554e-18,  -2.539513813451207e-20,
  -3.638260058884277e-22,   5.780406209434125e-23,  -2.612857086172594e-04,   1.534324420908331e-05,  -6.721738965338513e-07,   2.571140056022222e-08,  -8.818656047464896e-10,
   2.636369106852496e-11,  -6.207840464613159e-13,   7.324987695568238e-15,   2.626414984375692e-16,  -2.186676071833507e-17,   8.316596273102589e-19,  -1.633562998503512e-20,
  -2.414757549205280e-22,   3.763718749247521e-23,  -1.401666692088780e-04,   8.231237848389128e-06,  -3.606213454055950e-07,   1.379474655093139e-08,  -4.731431250516286e-10,
   1.414359109578393e-11,  -3.329335781642358e-13,   3.921815455129481e-15,   1.412423480613492e-16,  -1.173833321950114e-17,   4.459671408510245e-19,  -8.734744371079052e-21,
  -1.311839685325841e-22,   2.025084884913559e-23,  -5.216063781200904e-05,   3.063161213717348e-06,  -1.342034655824212e-07,   5.133722172932304e-09,  -1.760807626992128e-10,
   5.263399133113137e-12,  -1.238844230273670e-13,   1.458442767596911e-15,   5.260604562470070e-17,  -4.369244199462284e-18,   1.659361109576478e-19,  -3.246790490811743e-21,
  -4.903095118865686e-23,   7.543827297397329e-24,  -5.891964029173222e-06,   3.460095528900801e-07,  -1.515944046173886e-08,   5.798995980046928e-10,  -1.988989424316589e-11,
   5.945451517835431e-13,  -1.399354342555216e-14,   1.647250345899946e-16,   5.943085008702029e-18,  -4.935596505159504e-19,   1.874340769034803e-20,  -3.666848591000218e-22,
  -5.542260504433421e-24,   8.522761741511209e-25,  -9.407839140906721e-03,   5.518677414258829e-04,  -2.411955728777380e-05,   9.166359712540823e-07,  -3.085267742565492e-08,
   8.709780574649131e-10,  -1.642855466587624e-11,  -1.258095924612265e-13,   3.182096788657288e-14,  -1.912330643564143e-15,   7.946349135627953e-17,  -2.472651310506023e-18,
   5.106114533024303e-20,  -4.725820243541598e-23,  -8.950963953560718e-03,   5.251069645540692e-04,  -2.295189522315797e-05,   8.723091630752111e-07,  -2.935921527673739e-08,
   8.285250573717604e-10,  -1.560236112165593e-11,  -1.217647012621143e-13,   3.038029530606251e-14,  -1.823356684371372e-15,   7.569669506939944e-17,  -2.352339102192557e-18,
   4.841284081736901e-20,  -3.390671677451175e-23,  -8.081641177060329e-03,   4.741715430886752e-04,  -2.072862769840863e-05,   7.878893885421318e-07,  -2.651552888965663e-08,
   7.478087409588930e-10,  -1.404173914096482e-11,  -1.132336848149369e-13,   2.759661944277417e-14,  -1.652474840054821e-15,   6.849139543254608e-17,  -2.123472497131725e-18,
   4.344055692188978e-20,  -1.293506877113680e-23,  -6.884549726060266e-03,   4.040001598686976e-04,  -1.766421307782591e-05,   6.714916486366520e-07,  -2.259582224717412e-08,
   6.367801368607994e-10,  -1.191496724418489e-11,  -9.986261961708751e-14,   2.368098019568728e-14,  -1.414090087881071e-15,   5.849621262620671e-17,  -1.808462707601177e-18,
   3.672480347058805e-20,   7.284561406731550e-24,  -5.476560755954734e-03,   3.214266838935277e-04,  -1.405626897610614e-05,   5.343998528160308e-07,  -1.798073057457112e-08,
   5.063468563315915e-10,  -9.441873334495539e-12,  -8.207255373714750e-14,   1.897095815161671e-14,  -1.129819115498995e-15,   4.664820148540777e-17,  -1.438198643716180e-18,
   2.899479308273742e-20,   2.000698160616924e-23,  -3.995438542123791e-03,   2.345272262921009e-04,  -1.025751315803298e-05,   3.900124544849338e-07,  -1.312144612800572e-08,
   3.692863906846067e-10,  -6.866927975460860e-12,  -6.142718108923184e-14,   1.391861066788168e-14,  -8.271590218235051e-16,   3.409975821392800e-17,  -1.048978835061590e-18,
   2.102322738809126e-20,   2.298931622539878e-23,  -2.586334221231275e-03,   1.518272286672451e-04,  -6.641077705055428e-06,   2.525232730891980e-07,  -8.495315823427620e-09,
   2.389953264128740e-10,  -4.435929001673789e-12,  -4.042760218038769e-14,   9.043339640101619e-15,  -5.366766496748032e-16,   2.210226291017873e-17,  -6.789071688959252e-19,
   1.355282857495800e-20,   1.848436198955172e-23,  -1.387438369763853e-03,   8.145116726509189e-05,  -3.562925880483632e-06,   1.354825006621795e-07,  -4.557727807231288e-09,
   1.281946601122710e-10,  -2.377119438210471e-12,  -2.187060391620023e-14,   4.860536636497205e-15,  -2.882412291620597e-16,   1.186465664368208e-17,  -3.641654117176036e-19,
   7.254934452997029e-21,   1.091061898809121e-23,  -5.163115327033025e-04,   3.031111477307152e-05,  -1.325923738314862e-06,   5.041963319779928e-08,  -1.696134752462395e-09,
   4.770359797983792e-11,  -8.842760775261418e-13,  -8.162514965249234e-15,   1.809962818427753e-15,  -1.073082446554100e-16,   4.416252303796781e-18,  -1.355134500066485e-19,
   2.697791951914527e-21,   4.189162628592784e-24,  -5.832154455169901e-05,   3.423892550848531e-06,  -1.497745075979369e-07,   5.695341698663648e-09,  -1.915930450536748e-10,
   5.388472122391044e-12,  -9.988021487675261e-14,  -9.224474227864416e-16,   2.044713300094774e-16,  -1.212212220149519e-17,   4.988695790955096e-19,  -1.530725419889376e-20,
   3.047013056701845e-22,   4.755119460865572e-25,  -7.603772944640702e-04,   3.997696286432212e-05,  -1.574164700225050e-06,   5.477337530258904e-08,  -1.757194689289539e-09,
   5.202245104553166e-11,  -1.376231886311577e-12,   2.971066655616479e-14,  -3.655503901101366e-16,  -7.909963529868568e-18,   7.556823820410390e-19,  -3.135790317435260e-20,
   8.613470536050885e-22,  -1.226778628478310e-23,  -7.234395560913446e-04,   3.803738528153996e-05,  -1.497911761961500e-06,   5.212470345070285e-08,  -1.672339030157544e-09,
   4.951056929779251e-11,  -1.309589929538561e-12,   2.825670928158628e-14,  -3.467452031845877e-16,  -7.576753058290400e-18,   7.206063860503746e-19,  -2.985981767318404e-20,
   8.186189596303893e-22,  -1.157801765118230e-23,  -6.531606055161217e-04,   3.434609370902375e-05,  -1.352742196203556e-06,   4.708032849542319e-08,  -1.510684245470973e-09,
   4.472515614379376e-11,  -1.182706909592769e-12,   2.549462648119176e-14,  -3.113889838021727e-16,  -6.922063884365502e-18,   6.532024122780224e-19,  -2.699894023504787e-20,
   7.376656721177366e-22,  -1.030311510530528e-23,  -5.563926937514447e-04,   2.926159514320099e-05,  -1.152685371724833e-06,   4.012511590400873e-08,  -1.287701133496420e-09,
   3.812400719749447e-11,  -1.007831093820802e-12,   2.169982333002284e-14,  -2.635298816711041e-16,  -5.980406955252319e-18,   5.591020206358460e-19,  -2.303957191775533e-20,
   6.268815792858741e-22,  -8.621021458081505e-24,  -4.425880344548626e-04,   2.327950454096295e-05,  -9.171902150971692e-07,   3.193328427882984e-08,  -1.024955289550532e-09,
   3.034542973971811e-11,  -8.019548859707783e-13,   1.724758747487448e-14,  -2.082913478049843e-16,  -4.821992986748362e-18,   4.468043623428149e-19,  -1.835803545958630e-20,
   4.974822474965082e-22,  -6.736653698121014e-24,  -3.228827456788383e-04,   1.698498685864904e-05,  -6.692827208242954e-07,   2.330542989562887e-08,  -7.481156849013964e-10,
   2.214934627672733e-11,  -5.852082237730474e-13,   1.257456278400043e-14,  -1.511684969440229e-16,  -3.555927219402187e-18,   3.271681896653840e-19,  -1.341080743289969e-20,
   3.622271259610215e-22,  -4.843057615760601e-24,  -2.090054022885759e-04,   1.099533570606155e-05,  -4.333029920076134e-07,   1.508971459006096e-08,  -4.844242412465318e-10,
   1.434235392868594e-11,  -3.788776431672832e-13,   8.136155416320751e-15,  -9.751577680778018e-17,  -2.318103995217651e-18,   2.122961579959990e-19,  -8.688595694860903e-21,
   2.341692976474732e-22,  -3.104218852702058e-24,  -1.121199009673202e-04,   5.898606223450838e-06,  -2.324622954914009e-07,   8.095866486116671e-09,  -2.599113329121160e-10,
   7.695219258620960e-12,  -2.032652069856829e-13,   4.363635457475521e-15,  -5.221886611107764e-17,  -1.248031293857390e-18,   1.140274686461422e-19,  -4.663047450753708e-21,
   1.255345727891427e-22,  -1.656750506323284e-24,  -4.172338033458826e-05,   2.195086589838401e-06,  -8.650908292999309e-08,   3.012867260803698e-09,  -9.672701933386111e-11,
   2.863808711434337e-12,  -7.564380088439181e-14,   1.623722454948469e-15,  -1.942025139843579e-17,  -4.650145560292393e-19,   4.245166686770893e-20,  -1.735538803127106e-21,
   4.670444305019142e-23,  -6.154282670468163e-25,  -4.712989418340113e-06,   2.479530773130371e-07,  -9.771936913726739e-09,   3.403299192686874e-10,  -1.092619326539063e-11,
   3.234931919049376e-13,  -8.544614319064857e-15,   1.834101918038039e-16,  -2.193456666024638e-18,  -5.253755262456150e-20,   4.795585349007602e-21,  -1.960478313268048e-22,
   5.275443578123282e-24,  -6.949779610677856e-26,  -7.526893980415028e-03,   3.957027737453671e-04,  -1.557603368867198e-05,   5.411632537970025e-07,  -1.727143889180513e-08,
   5.032991690823949e-10,  -1.270254604519365e-11,   2.320855796226468e-13,   1.525718783788129e-17,  -2.659829747253344e-16,   1.610158421174471e-17,  -6.641785978738285e-19,
   2.147908614895582e-20,  -5.398234465780816e-22,  -7.161251010547884e-03,   3.765042151480673e-04,  -1.482150500217361e-05,   5.149909665881165e-07,  -1.643701451880257e-08,
   4.789620471998417e-10,  -1.208455161934384e-11,   2.205046166179029e-13,   3.640324102630965e-17,  -2.541434858665397e-16,   1.536080076857312e-17,  -6.331223455658106e-19,
   2.045752907217269e-20,  -5.134132507330039e-22,  -6.465566813614357e-03,   3.399666704328708e-04,  -1.338504971822083e-05,   4.651473805912058e-07,  -1.484754273789341e-08,
   4.326115007411547e-10,  -1.090908703496943e-11,   1.985934536503147e-13,   6.780814452757012e-17,  -2.311799926281331e-16,   1.393457474732648e-17,  -5.735413790988802e-19,
   1.850483798555679e-20,  -4.632308346932814e-22,  -5.507671255992349e-03,   2.896388076425952e-04,  -1.140550110763804e-05,   3.964253584690959e-07,  -1.265535862489818e-08,
   3.687020972277443e-10,  -9.291283332003936e-12,   1.686640575424358e-13,   9.385961649362620e-17,  -1.987108563361964e-16,   1.193818578980963e-17,  -4.905498636323801e-19,
   1.579876926916211e-20,  -3.942721687154055e-22,  -4.381130920852360e-03,   2.304264107362053e-04,  -9.075314300810898e-06,   3.154880407122570e-07,  -1.007264092532761e-08,
   2.934289865485253e-10,  -7.389586671009769e-12,   1.337719854060382e-13,   1.026248342083529e-16,  -1.594448260757177e-16,   9.548967867835507e-18,  -3.917409604283920e-19,
   1.259449936159215e-20,  -3.133618053930536e-22,  -3.196181087775156e-03,   1.681216137321553e-04,  -6.622329741069755e-06,   2.302458089479872e-07,  -7.351742139158889e-09,
   2.141490813492113e-10,  -5.390195801809137e-12,   9.735888039226379e-14,   9.134843219405697e-17,  -1.171319565690437e-16,   6.997247319903263e-18,  -2.866856465844712e-19,
   9.204001743142508e-21,  -2.284456485203146e-22,  -2.068921611172712e-03,   1.088345295511750e-04,  -4.287381856242633e-06,   1.490776468240810e-07,  -4.760320180274192e-09,
   1.386563288354496e-10,  -3.488802703193440e-12,   6.292177476175684e-14,   6.619451178808375e-17,  -7.616841357225283e-17,   4.542642788240680e-18,  -1.859583448059803e-19,
   5.964614048999078e-21,  -1.478039678461693e-22,  -1.109862613085887e-03,   5.838584251862362e-05,  -2.300131333648395e-06,   7.998218057857749e-08,  -2.554052082657015e-09,
   7.439122773517961e-11,  -1.871459565626839e-12,   3.372656499705599e-14,   3.745812247696169e-17,  -4.095602543163404e-17,   2.440530082691946e-18,  -9.986209624083500e-20,
   3.201546243277687e-21,  -7.926873659528791e-23,  -4.130151670836684e-04,   2.172750113029989e-05,  -8.559762069116815e-07,   2.976523692026020e-08,  -9.504960807161569e-10,
   2.768460161930932e-11,  -6.964177540493476e-13,   1.254716151766023e-14,   1.419186759901398e-17,  -1.525346068680669e-17,   9.086719801683336e-19,  -3.717554670933847e-20,
   1.191637621870142e-21,  -2.949581316991721e-23,  -4.665336543950667e-05,   2.454299866228245e-06,  -9.668979049359576e-08,   3.362245242712183e-09,  -1.073670658777558e-10,
   3.127219699271787e-12,  -7.866574085730610e-14,   1.417238285057125e-15,   1.607611886186388e-18,  -1.723223024265796e-18,   1.026502470280814e-19,  -4.199520543425893e-21,
   1.346093059997311e-22,  -3.331741155838775e-24,  -6.199189158616234e-04,   2.950094508513480e-05,  -1.052686717724795e-06,   3.332901921298916e-08,  -9.836227079957970e-10,
   2.744963797867802e-11,  -7.193120213063206e-13,   1.716086370835127e-14,  -3.447270302452195e-16,   4.441503497954169e-18,  -5.732347081419577e-04,   2.728151199046369e-05,
  -9.735930509772866e-07,   3.082869797710003e-08,  -9.099500846826286e-10,   2.539626703483537e-11,  -6.655115823217792e-13,   1.587414517506642e-14,  -3.186438307437475e-16,
   4.092367670673500e-18,  -4.869454325230197e-04,   2.317787315323518e-05,  -8.272900951936954e-07,   2.620141287982195e-08,  -7.735343097313450e-10,   2.159257213962177e-11,
  -5.658458055201801e-13,   1.349240240582494e-14,  -2.705051828144893e-16,   3.455826751673551e-18,  -3.741561250227715e-04,   1.781176595807850e-05,  -6.358739459726653e-07,
   2.014338744807679e-08,  -5.948198095738037e-10,   1.660683741939416e-11,  -4.351998658713674e-13,   1.037353686893400e-14,  -2.077062116766773e-16,   2.638566271134723e-18,
  -2.520273378534805e-04,   1.199912716577705e-05,  -4.284266876511944e-07,   1.357414286906123e-08,  -4.009058876749405e-10,   1.119448644917601e-11,  -2.933675621200305e-13,
   6.990836724022082e-15,  -1.398319281478503e-16,   1.768365762771407e-18,  -1.391654927472951e-04,   6.626149067275366e-06,  -2.366052139642892e-07,   7.497270058260418e-09,
  -2.214509995318149e-10,   6.184065606165451e-12,  -1.620635748517836e-13,   3.861289873365435e-15,  -7.718835475390617e-17,   9.736056153636969e-19,  -5.277364929341096e-05,
   2.512795496128772e-06,  -8.972921443232419e-08,   2.843340258903670e-09,  -8.398853753863162e-11,   2.345467843048554e-12,  -6.146700728063083e-14,   1.464410060243813e-15,
  -2.926746668495912e-17,   3.687983667348931e-19,  -6.016926354536685e-06,   2.864945960286170e-07,  -1.023046588514914e-08,   3.241851021027868e-10,  -9.576063229790724e-12,
   2.674229200695196e-13,  -7.008279599177509e-15,   1.669658619671829e-16,  -3.336829641261252e-18,   4.204041195357327e-20,  -6.136555253818786e-03,   2.920251620143908e-04,
  -1.041957030674842e-05,   3.297724008275927e-07,  -9.718867077907074e-09,   2.700044093972039e-10,  -6.983710859442652e-12,   1.605708261964687e-13,  -2.860311631716592e-15,
   1.502883094032005e-17,  -5.674429897010004e-03,   2.700553261550494e-04,  -9.636690666224942e-06,   3.050323642053945e-07,  -8.990847041583451e-09,   2.497989192105017e-10,
  -6.460755337360962e-12,   1.484882147790550e-13,  -2.640992112972750e-15,   1.361247712542282e-17,  -4.820255372506513e-03,   2.294340322255871e-04,  -8.188567373045425e-06,
   2.592470026815940e-07,  -7.642860609834676e-09,   2.123746661435455e-10,  -5.492345268799850e-12,   1.261489018779227e-13,  -2.237946554204361e-15,   1.116508190032251e-17,
  -3.703758007072224e-03,   1.763157777985510e-04,  -6.293913329634918e-06,   1.993057013891224e-07,  -5.876986066515137e-09,   1.633283081617580e-10,  -4.223534885461820e-12,
   9.693928123983164e-14,  -1.715065482457112e-15,   8.252705726282039e-18,  -2.494809511490165e-03,   1.187773979344916e-04,  -4.240586706055464e-06,   1.343068600826797e-07,
  -3.961010979346097e-09,   1.100930500880264e-10,  -2.846703466083247e-12,   6.530210100492138e-14,  -1.152839465530842e-15,   5.385238851771154e-18,  -1.377594175084693e-03,
   6.559116217180748e-05,  -2.341928170833871e-06,   7.418021773176659e-08,  -2.187953064127701e-09,   6.081615219509402e-11,  -1.572470320380069e-12,   3.606028098844692e-14,
  -6.358082579226627e-16,   2.918128544091455e-18,  -5.224044426621907e-04,   2.487374965199344e-05,  -8.881433351106420e-07,   2.813283315708407e-08,  -8.298109310338038e-10,
   2.306589144041696e-11,  -5.963849384206957e-13,   1.367481010795577e-14,  -2.409979572082950e-16,   1.098681258462252e-18,  -5.956133599850840e-05,   2.835962911324479e-06,
  -1.012615559467952e-07,   3.207581038633177e-09,  -9.461193709127385e-11,   2.629896814677297e-12,  -6.799765795020697e-14,   1.559121518340231e-15,  -2.747501985108471e-17,
   1.251151706177370e-19,  -5.165546076535300e-04,   2.244805506633162e-05,  -7.316912503242093e-07,   2.118789749206020e-08,  -5.741444814368465e-10,   1.485667741419365e-11,
  -3.687829799467077e-13,   8.701907707994128e-15,  -1.898835109104138e-16,   3.591271028146567e-18,  -4.776479751309393e-04,   2.075867506594897e-05,  -6.766865523959972e-07,
   1.959725140876096e-08,  -5.311078211413552e-10,   1.374479267013494e-11,  -3.412171010946417e-13,   8.051608117687398e-15,  -1.756638126381772e-16,   3.320255788943625e-18,
  -4.057383797897830e-04,   1.763541722396005e-05,  -5.749595702629530e-07,   1.665417372471177e-08,  -4.514395216556219e-10,   1.168544595420437e-11,  -2.901409454203846e-13,
   6.846586705843726e-15,  -1.493321225583687e-16,   2.819647722403707e-18,  -3.117513848404258e-04,   1.355186080896313e-05,  -4.418939395764736e-07,   1.280226346974648e-08,
  -3.471023853858795e-10,   8.986673130904146e-12,  -2.231711018252509e-13,   5.266435138058546e-15,  -1.148331352993488e-16,   2.165866533789859e-18,  -2.099883042088300e-04,
   9.129052493059543e-06,  -2.977131224558539e-07,   8.626446943025149e-09,  -2.339252067980714e-10,   6.057501977023056e-12,  -1.504498225253278e-13,   3.550430130366447e-15,
  -7.739798986741950e-17,   1.458535640335180e-18,  -1.159509612501774e-04,   5.041132013386006e-06,  -1.644110582613063e-07,   4.764339101061907e-09,  -1.292083438665400e-10,
   3.346189033071996e-12,  -8.311561806363549e-14,   1.961452914869536e-15,  -4.275310402980942e-17,   8.052611428004248e-19,  -4.397017229000391e-05,   1.911703636825573e-06,
  -6.234979669331841e-08,   1.806844690179553e-09,  -4.900324043888255e-11,   1.269115041799198e-12,  -3.152433505114295e-14,   7.439494040566179e-16,  -1.621477733619725e-17,
   3.053500505221857e-19,  -5.013204794162985e-06,   2.179612472822007e-07,  -7.108789748852662e-09,   2.060078624893877e-10,  -5.587151364736392e-12,   1.447002653629215e-13,
  -3.594317091237832e-15,   8.482311553427225e-17,  -1.848749761618053e-18,   3.481380760120412e-20,  -5.113362122114577e-03,   2.222122499514637e-04,  -7.242859353468014e-06,
   2.097167617015315e-07,  -5.680833271643510e-09,   1.468152665890207e-10,  -3.630520233635513e-12,   8.476632560937777e-14,  -1.797486558368270e-15,   3.120212863374144e-17,
  -4.728226259015988e-03,   2.054891531177992e-04,  -6.698378608038876e-06,   1.939725181509774e-07,  -5.254997492843187e-09,   1.358263399108908e-10,  -3.359054593307789e-12,
   7.842554058615251e-14,  -1.662502418097272e-15,   2.882520765062378e-17,  -4.016394828018796e-03,   1.745721656631629e-04,  -5.691403525408722e-06,   1.648419466516397e-07,
  -4.466709341578814e-09,   1.154742019461781e-10,  -2.856117021210358e-12,   6.667960570487864e-14,  -1.412768618004969e-15,   2.444793845326089e-17,  -3.086019732933136e-03,
   1.341492293087425e-04,  -4.374214116510909e-06,   1.267158621237741e-07,  -3.434344852263564e-09,   8.880391168751899e-11,  -2.196768922581404e-12,   5.128330550152287e-14,
  -1.085955683929256e-15,   1.875371039010187e-17,  -2.078669352087237e-03,   9.036805709055009e-05,  -2.946998451941690e-06,   8.538387172631442e-08,  -2.314525091879938e-09,
   5.985791130119076e-11,  -1.480886796492122e-12,   3.456950252294687e-14,  -7.317081025144566e-16,   1.261546948967411e-17,  -1.147795874233655e-03,   4.990192580759931e-05,
  -1.627469726171549e-06,   4.715702078598573e-08,  -1.278423079174854e-09,   3.306552946648513e-11,  -8.180944108430375e-13,   1.909689621694549e-14,  -4.041073026596744e-16,
   6.960669563025591e-18,  -4.352597147708412e-04,   1.892386320642883e-05,  -6.171872162989692e-07,   1.788399115957181e-08,  -4.848512618663585e-10,   1.254078953107609e-11,
  -3.102867206322895e-13,   7.242992770921549e-15,  -1.532534548953964e-16,   2.638820441018313e-18,  -4.962559787669555e-05,   2.157587999193595e-06,  -7.036837914912516e-08,
   2.039047799414443e-09,  -5.528077414320057e-11,   1.429858394050451e-12,  -3.537798203122162e-14,   8.258233757406212e-16,  -1.747320127631279e-17,   3.008474781258203e-19,
  -4.370533540054653e-04,   1.747520069952634e-05,  -5.241069885449122e-07,   1.396965090180702e-08,  -3.488723584952889e-10,   8.349490864715602e-12,  -1.933513657812831e-13,
   4.335338646456252e-15,  -9.326761080555140e-17,   1.879736752059295e-18,  -4.041304968146810e-04,   1.615972936630525e-05,  -4.846908503820816e-07,   1.292026446374497e-08,
  -3.227012955558404e-10,   7.724096454441640e-12,  -1.788910706866116e-13,   4.011508461647661e-15,  -8.630344297891672e-17,   1.739151021683457e-18,  -3.432830262160782e-04,
   1.372794125855974e-05,  -4.118037165871393e-07,   1.097903365154276e-08,  -2.742664590368055e-10,   6.566100899601804e-12,  -1.521026048213516e-13,   3.411352410869453e-15,
  -7.339515639443602e-17,   1.478708280641388e-18,  -2.637586614551623e-04,   1.054879666767917e-05,  -3.164792134021512e-07,   8.438989072791077e-09,  -2.108546157569329e-10,
   5.049067319770865e-12,  -1.169859396684389e-13,   2.624210231254136e-15,  -5.646258298807545e-17,   1.137300871813369e-18,  -1.776590052644064e-04,   7.105871459375326e-06,
  -2.132086441059515e-07,   5.685991645731918e-09,  -1.420905139338391e-10,   3.403035250232418e-12,  -7.886102072249658e-14,   1.769237975191621e-15,  -3.806842290754481e-17,
   7.666549847259146e-19,  -9.809861672340492e-05,   3.923851720318725e-06,  -1.177405690768622e-07,   3.140219156833784e-09,  -7.847964246546277e-11,   1.879752523715171e-12,
  -4.356512628784143e-14,   9.774550014235060e-16,  -2.103220646962617e-17,   4.235198912561293e-19,  -3.720020639457759e-05,   1.487998204111327e-06,  -4.465044016637674e-08,
   1.190890268176797e-09,  -2.976344126111246e-11,   7.129230965099935e-13,  -1.652330367116954e-14,   3.707382653014654e-16,  -7.977356472419723e-18,   1.606314674538459e-19,
  -4.241333326020437e-06,   1.696526632034717e-07,  -5.090795395348650e-09,   1.357793302998991e-10,  -3.393496737969097e-12,   8.128485027045610e-14,  -1.883937301374478e-15,
   4.227066539219293e-17,  -9.095597899789169e-19,   1.831470816528183e-20,  -4.326381994348978e-03,   1.729865695611247e-04,  -5.188104691804701e-06,   1.382821611547758e-07,
  -3.453104594122489e-09,   8.261523250297765e-11,  -1.911072249678228e-12,   4.271520685971065e-14,  -9.112108234131210e-16,   1.796607002508362e-17,  -4.000479319798816e-03,
   1.599647516837042e-04,  -4.797926525187367e-06,   1.278945255461014e-07,  -3.194064129085980e-09,   7.642700596246423e-11,  -1.768134214193013e-12,   3.952367354626591e-14,
  -8.431184223330562e-16,   1.661947878352102e-17,  -3.398151481937968e-03,   1.358925421920732e-04,  -4.076420888374232e-06,   1.086787364615841e-07,  -2.714658544198112e-09,
   6.496883808687256e-11,  -1.503341982538703e-12,   3.360933218608024e-14,  -7.169394432290210e-16,   1.412659443600253e-17,  -2.610941460699975e-03,   1.044222700543617e-04,
  -3.132809095370812e-06,   8.353544595419189e-08,  -2.087013149601873e-09,   4.995822421734515e-11,  -1.156242733818913e-12,   2.585321541681215e-14,  -5.514770877913402e-16,
   1.086167905232946e-17,  -1.758642768318730e-03,   7.034084067360608e-05,  -2.110539750375933e-06,   5.628420216807269e-08,  -1.406393373805143e-09,   3.367138056600626e-11,
  -7.794229197259521e-13,   1.742964274852570e-14,  -3.717863452182645e-16,   7.320085409357662e-18,  -9.710761500157610e-04,   3.884210820023067e-05,  -1.165506905821869e-06,
   3.108423710252246e-08,  -7.767809061788013e-10,   1.859920440791627e-11,  -4.305733157942474e-13,   9.629219262396538e-15,  -2.053956758672110e-16,   4.043235022580464e-18,
  -3.682440630589498e-04,   1.472965629638635e-05,  -4.419920545694610e-07,   1.178832184631543e-08,  -2.945944723036906e-10,   7.054010154024044e-12,  -1.633067080933901e-13,
   3.652235174058812e-15,  -7.790353295483406e-17,   1.533426122375056e-18,  -4.198486965838560e-05,   1.679387388713341e-06,  -5.039348112664027e-08,   1.344045273185235e-09,
  -3.358836578146348e-11,   8.042720138707806e-13,  -1.861973175944836e-14,   4.164183998998783e-16,  -8.882353020768521e-18,   1.748350202810719e-19,  -3.745956441393957e-04,
   1.386923069289334e-05,  -3.851692338338284e-07,   9.507403565869459e-09,  -2.199627042681915e-10,   4.882667398790254e-12,  -1.052045190431454e-13,   2.211228289131123e-15,
  -4.529614226782479e-17,   8.965453547742431e-19,  -3.463748334151408e-04,   1.282499469904563e-05,  -3.561924417034750e-07,   8.792863839024164e-09,  -2.034508944429804e-10,
   4.516645377876262e-12,  -9.732980781129722e-14,   2.045962276995524e-15,  -4.191493012256006e-17,   8.296543359677426e-19,  -2.942193213445114e-04,   1.089474035206329e-05,
  -3.026152642313507e-07,   7.471270219746248e-09,  -1.728991524818568e-10,   3.839092075564259e-12,  -8.274556875498687e-14,   1.739733508064549e-15,  -3.564717450180331e-17,
   7.056378527278999e-19,  -2.260577420809081e-04,   8.371476097614525e-06,  -2.325547783608889e-07,   5.742359614488551e-09,  -1.329113865819206e-10,   2.951766136331817e-12,
  -6.363407437350702e-14,   1.338194082850750e-15,  -2.742438611957271e-17,   5.429044472682699e-19,  -1.522632158529040e-04,   5.639060381364027e-06,  -1.566638359832111e-07,
   3.868853460232616e-09,  -8.955953480387735e-11,   1.989288410455170e-12,  -4.289212523179159e-14,   9.021500777705318e-16,  -1.849080533658254e-17,   3.660711255931619e-19,
  -8.407518599505663e-05,   3.113840574773663e-06,  -8.651287988839678e-08,   2.136595103664062e-09,  -4.946352945835553e-11,   1.098776101274831e-12,  -2.369357377151809e-14,
   4.983944925149881e-16,  -1.021608262457663e-17,   2.022587506378644e-19,  -3.188227065131513e-05,   1.180821047878491e-06,  -3.280778327773805e-08,   8.102682786092621e-10,
  -1.875876416784050e-11,   4.167183854275654e-13,  -8.986273444158894e-15,   1.890330959328146e-16,  -3.874911731892557e-18,   7.671666323559263e-20,  -3.635014304914649e-06,
   1.346300511967801e-07,  -3.740556387830153e-09,   9.238253907574488e-11,  -2.138786111263083e-12,   4.751253140712802e-14,  -1.024584363157761e-15,   2.155303921706035e-17,
  -4.418090503112379e-19,   8.747084492509679e-21,  -3.708114569649546e-03,   1.372912182350271e-04,  -3.812779551551137e-06,   9.411314713708370e-08,  -2.177352589968981e-09,
   4.832823354902098e-11,  -1.040998930138593e-12,   2.185999428562012e-14,  -4.466393423312301e-16,   8.781437875641793e-18,  -3.428757345120269e-03,   1.269543483857533e-04,
  -3.525939076375628e-06,   8.703996427682549e-08,  -2.013906287935556e-09,   4.470535301646684e-11,  -9.630766706693735e-13,   2.022605737512066e-14,  -4.132913278737137e-16,
   8.125844535901310e-18,  -2.912471004663847e-03,   1.078468017780135e-04,  -2.995580066122749e-06,   7.395759528260516e-08,  -1.711482346965694e-09,   3.799895561076803e-11,
  -8.187631248266054e-13,   1.719854269436681e-14,  -3.514788003571441e-16,   6.910618086554019e-18,  -2.237740934665357e-03,   8.286906280795583e-05,  -2.302053252670342e-06,
   5.684322430432913e-08,  -1.315653868789176e-09,   2.921626187233562e-11,  -6.296536087029737e-13,   1.322887848514218e-14,  -2.703936795930908e-16,   5.316425855891757e-18,
  -1.507250438766604e-03,   5.582093804652084e-05,  -1.550810925892304e-06,   3.829751389025209e-08,  -8.865254497041076e-10,   1.968974607640929e-11,  -4.244126259071637e-13,
   8.918231974376172e-15,  -1.823073061360493e-16,   3.584522461099871e-18,  -8.322585351053589e-04,   3.082384120536481e-05,  -8.563885728803251e-07,   2.115000730592461e-08,
  -4.896259579707184e-10,   1.087555355238515e-11,  -2.344447903114343e-13,   4.926867967399613e-15,  -1.007223997100703e-16,   1.980411728867655e-18,  -3.156019407357645e-04,
   1.168892227856097e-05,  -3.247633265941326e-07,   8.020789642445098e-09,  -1.856878716190476e-10,   4.124627702131966e-12,  -8.891793654145179e-14,   1.868678882411647e-15,
  -3.820331134854679e-17,   7.511578917821070e-19,  -3.598293176096597e-05,   1.332699995131742e-06,  -3.702766277413953e-08,   9.144883628751058e-10,  -2.117125811996244e-11,
   4.702732218272273e-13,  -1.013811994456634e-14,   2.130616114039008e-16,  -4.355854773266030e-18,   8.564534236161222e-20,  -3.246345554015105e-04,   1.119102644309673e-05,
  -2.893674590997010e-07,   6.650485400302632e-09,  -1.432783930550132e-10,   2.962681184008539e-12,  -5.952785390608386e-14,   1.169977020575737e-15,  -2.255365875605407e-17,
   4.256514353888446e-19,  -3.001756824977314e-04,   1.034830144547200e-05,  -2.675921470458808e-07,   6.150460933986951e-09,  -1.325170445856480e-10,   2.740429038146923e-12,
  -5.506830995767325e-14,   1.082456381794006e-15,  -2.086899736392589e-17,   3.938968927090840e-19,  -2.549738802665129e-04,   8.790618791472403e-06,  -2.273337949432469e-07,
   5.225749809289240e-09,  -1.126089655030044e-10,   2.329108478481461e-12,  -4.681138465787216e-14,   9.203324446493007e-16,  -1.774681374345500e-17,   3.350219467238717e-19,
  -1.959020272036168e-04,   6.754523540839076e-06,  -1.746956122379850e-07,   4.016243106605821e-09,  -8.655821741782965e-11,   1.790602712861569e-12,  -3.599518122905945e-14,
   7.078272991085638e-16,  -1.365188132866348e-17,   2.577635367609257e-19,  -1.319503781631818e-04,   4.549793046064720e-06,  -1.176826785282140e-07,   2.705780450229706e-09,
  -5.832183710724881e-11,   1.206647745266639e-12,  -2.426002323819744e-14,   4.771387729695563e-16,  -9.204078160806470e-18,   1.738077141809742e-19,  -7.285866762567194e-05,
   2.512330555937421e-06,  -6.498559332657230e-08,   1.494243397459984e-09,  -3.220987443158049e-11,   6.664568377053563e-13,  -1.340048677493160e-14,   2.635814074826184e-16,
  -5.084999992443727e-18,   9.603159702893969e-20,  -2.762878497084628e-05,   9.527145687464445e-07,  -2.464395469308644e-08,   5.666615742238295e-10,  -1.221524990994877e-11,
   2.527539792744168e-13,  -5.082305365466905e-15,   9.997012488603955e-17,  -1.928686572133620e-18,   3.642485036011990e-20,  -3.150057825621995e-06,   1.086226645744657e-07,
  -2.809760192508071e-09,   6.460767709488153e-11,  -1.392722293234268e-12,   2.881789596596370e-14,  -5.794652251207121e-16,   1.139828180427932e-17,  -2.199041056989970e-19,
   4.153092454087699e-21,  -3.213550800404913e-03,   1.107797395042877e-04,  -2.864442146009786e-06,   6.583295531187023e-08,  -1.418302237373249e-09,   2.932678042196379e-11,
  -5.892052045291877e-13,   1.157743480729928e-14,  -2.230070764299367e-16,   4.200026554710889e-18,  -2.971432919557883e-03,   1.024376221583737e-04,  -2.648888806394174e-06,
   6.088322780756688e-08,  -1.311776404696074e-09,   2.712676283855077e-11,  -5.450644621895178e-13,   1.071136032019104e-14,  -2.063482591440252e-16,   3.886635157863722e-18,
  -2.523981207067024e-03,   8.701815374397042e-05,  -2.250372257245926e-06,   5.172953974103885e-08,  -1.114707751173479e-09,   2.305520720544355e-11,  -4.633372623166995e-13,
   9.107048662424485e-15,  -1.754751577288984e-16,   3.305623783428411e-18,  -1.939230146105507e-03,   6.686288892710892e-05,  -1.729308037126056e-06,   3.975666900040278e-08,
  -8.568332945577545e-10,   1.772468186269929e-11,  -3.562785712155026e-13,   7.004205004058982e-15,  -1.349843813667572e-16,   2.543254826874469e-18,  -1.306174084945387e-03,
   4.503830732167917e-05,  -1.164938254500425e-06,   2.678443861473540e-08,  -5.773234626007042e-10,   1.194427063780844e-11,  -2.401243661007715e-13,   4.721447408680171e-15,
  -9.100556913039463e-17,   1.714857938717299e-18,  -7.212264552822039e-04,   2.486950824322737e-05,  -6.432909630961227e-07,   1.479147000995002e-08,  -3.188431078346961e-10,
   6.597070278230114e-12,  -1.326372194401192e-13,   2.608222200295809e-15,  -5.027784952892988e-17,   9.474752514411275e-19,  -2.734967752994595e-04,   9.430901823116942e-06,
  -2.439499669659525e-07,   5.609365704174127e-09,  -1.209178327586045e-10,   2.501941014304477e-12,  -5.030434757323366e-14,   9.892357687475786e-16,  -1.906982320376221e-17,
   3.593763374562120e-19,  -3.118235775562437e-05,   1.075253511353976e-06,  -2.781375451522468e-08,   6.395494321664837e-10,  -1.378645237109739e-11,   2.852602977154648e-13,
  -5.735511194819777e-15,   1.127895663988728e-16,  -2.174293798332234e-18,   4.097537775812425e-20,  -2.840445480542576e-04,   9.160387211907590e-06,  -2.215851776270898e-07,
   4.764269021227847e-09,  -9.602633365380614e-11,   1.857837984196864e-12,  -3.493826655820264e-14,   6.433188778949780e-16,  -1.164566413418689e-17,   2.075054302510801e-19,
  -2.626424420146536e-04,   8.470486847037260e-06,  -2.049069584176998e-07,   4.405945323483111e-09,  -8.881071281287578e-11,   1.718384448373695e-12,  -3.231889204390066e-14,
   5.951529774213853e-16,  -1.077499281532800e-17,   1.920139014381045e-19,  -2.230906147311382e-04,   7.195337702108862e-06,  -1.740743361431925e-07,   3.743356450373643e-09,
  -7.546407704715148e-11,   1.460349404567616e-12,  -2.747026526549056e-14,   5.059556728773635e-16,  -9.161858219869032e-18,   1.632984420210943e-19,  -1.714038255848133e-04,
   5.528641435418194e-06,  -1.337640394207978e-07,   2.876819013624945e-09,  -5.800262841846041e-11,   1.122611462910997e-12,  -2.112076997636629e-14,   3.890823506262797e-16,
  -7.046936196287142e-18,   1.256280334039588e-19,  -1.154487010117109e-04,   3.723994466237878e-06,  -9.010718059472121e-08,   1.938069480822359e-09,  -3.907946306293433e-11,
   7.564526692717300e-13,  -1.423378547136228e-14,   2.622508124580071e-16,  -4.750558132892304e-18,   8.470320499358050e-20,  -6.374671467743779e-05,   2.056319135247981e-06,
  -4.975742215148678e-08,   1.070259368775311e-09,  -2.158210197999105e-11,   4.177885737556396e-13,  -7.861925109284755e-15,   1.448647180174724e-16,  -2.624401130129224e-18,
   4.679777506096908e-20,  -2.417339685475313e-05,   7.797855318165454e-07,  -1.886900089133481e-08,   4.058710182008899e-10,  -8.184691268809071e-12,   1.584441656739450e-13,
  -2.981681464806097e-15,   5.494257020938429e-17,  -9.953859426195374e-19,   1.775012541647225e-20,  -2.756095791049682e-06,   8.890631124217415e-08,  -2.151331719671287e-09,
   4.627515027306683e-11,  -9.331762636516932e-13,   1.806506291889399e-14,  -3.399590202009003e-16,   6.264358679941161e-18,  -1.134910525990493e-19,   2.023829965817759e-21,
  -2.811751153638556e-03,   9.067848485411340e-05,  -2.193467071858182e-06,   4.716139236980635e-08,  -9.505616259387271e-10,   1.839059515094651e-11,  -3.458446828950529e-13,
   6.367609885635040e-15,  -1.152443081741180e-16,   2.052159065936550e-18,  -2.599892145042232e-03,   8.384917531172998e-05,  -2.028369725954592e-06,   4.361435406240948e-08,
  -8.791344189759057e-10,   1.701015481246823e-11,  -3.199161439602302e-13,   5.890858006733198e-15,  -1.066280657967913e-16,   1.898944257865381e-18,  -2.208369418217309e-03,
   7.122650011638953e-05,  -1.723158237968815e-06,   3.705540158496272e-08,  -7.470164886851689e-10,   1.445588512578726e-11,  -2.719208145668168e-13,   5.007974053900159e-15,
  -9.066444033741830e-17,   1.614947010879900e-18,  -1.696722952879056e-03,   5.472790800597636e-05,  -1.324127447620376e-06,   2.847756687123407e-08,  -5.741661600293024e-10,
   1.111264291765654e-11,  -2.090688097210259e-13,   3.851152934217992e-15,  -6.973528182091653e-17,   1.242393792127658e-18,  -1.142824322724430e-03,   3.686374472635351e-05,
  -8.919691087818587e-07,   1.918490627962503e-08,  -3.868463491948492e-10,   7.488065385731050e-12,  -1.408963807346694e-13,   2.595767480910686e-15,  -4.701061277099434e-17,
   8.376638460150830e-19,  -6.310274207389792e-04,   2.035546088052195e-05,  -4.925476881382981e-07,   1.059447345437831e-08,  -2.136405329662203e-10,   4.135656078782986e-12,
  -7.782305555648491e-14,   1.433875364110040e-15,  -2.597053785426812e-17,   4.628001845441857e-19,  -2.392919595140873e-04,   7.719080961673126e-06,  -1.867838478007391e-07,
   4.017708092357299e-09,  -8.101999532465054e-11,   1.568426261410389e-12,  -2.951485163295268e-14,   5.438231442562401e-16,  -9.850131429059020e-18,   1.755371886159916e-19,
  -2.728253569043164e-05,   8.800817487377948e-07,  -2.129598799677867e-08,   4.580766730804715e-10,  -9.237481782907515e-12,   1.788246284210412e-13,  -3.365161602746645e-15,
   6.200480136249207e-17,  -1.123083668778204e-18,   2.001435663031184e-20,  -2.506197677298767e-04,   7.592827066404240e-06,  -1.725387984631731e-07,   3.484988558929137e-09,
  -6.598731618399087e-11,   1.199382982405046e-12,  -2.119217522612027e-14,   3.667377910913841e-16,  -6.244610292092163e-18,   1.048741540851676e-19,  -2.317351274823588e-04,
   7.020923721204350e-06,  -1.595498687180621e-07,   3.222810058651486e-09,  -6.102702881827942e-11,   1.109309610741694e-12,  -1.960235447553478e-14,   3.392584629896904e-16,
  -5.777324152823133e-18,   9.703738527826202e-20,  -1.968362765044692e-04,   5.963906609482397e-06,  -1.355389501928837e-07,   2.738049140169776e-09,  -5.185317904565307e-11,
   9.426713842661540e-13,  -1.666010932237424e-14,   2.883830709026974e-16,  -4.911813888608511e-18,   8.251540007063639e-20,  -1.512310745209663e-04,   4.582383849012559e-06,
  -1.041496310642183e-07,   2.104147069991542e-09,  -3.985288082632244e-11,   7.246067231474437e-13,  -1.280812980019202e-14,   2.217437147914002e-16,  -3.777497314160357e-18,
   6.347210448672427e-20,  -1.018607734883189e-04,   3.086575216030073e-06,  -7.015669094381539e-08,   1.417489677138661e-09,  -2.684988764292305e-11,   4.882368094796043e-13,
  -8.631090796740756e-15,   1.494477072343853e-16,  -2.546276662161875e-18,   4.279092428026565e-20,  -5.624374376318784e-05,   1.704336524943834e-06,  -3.874026316811390e-08,
   7.827662708299720e-10,  -1.482781447234173e-11,   2.696443926624674e-13,  -4.767124057887855e-15,   8.254931540184939e-17,  -1.406586476543913e-18,   2.364021178224851e-20,
  -2.132816688292609e-05,   6.463070295898102e-07,  -1.469101226696559e-08,   2.968440111560997e-10,  -5.623177199740474e-12,   1.022600165755117e-13,  -1.807932218423619e-15,
   3.130774053470249e-17,  -5.334803654591054e-19,   8.966396701082787e-21,  -2.431700379003229e-06,   7.368788833684084e-08,  -1.674981002461551e-09,   3.384446252152183e-11,
  -6.411246843148412e-13,   1.165918567642615e-14,  -2.061324498058795e-16,   3.569587468615766e-18,  -6.082568688145131e-20,   1.022324923730308e-21,  -2.480879939360045e-03,
   7.516123933458783e-05,  -1.707958018607738e-06,   3.449782899403989e-08,  -6.532069367529682e-10,   1.187265271208524e-11,  -2.097797045860855e-13,   3.630246124597264e-15,
  -6.181016898453813e-17,   1.037871697818075e-18,  -2.293941272962843e-03,   6.949997985505149e-05,  -1.579380870070540e-06,   3.190252948633296e-08,  -6.041051645533833e-10,
   1.098101929213425e-11,  -1.940421858701635e-13,   3.358234686290583e-15,  -5.718487043295191e-17,   9.603149842452186e-19,  -1.948478263072872e-03,   5.903658915462448e-05,
  -1.341697281200022e-06,   2.710389126569692e-08,  -5.132934340654882e-10,   9.331472872733507e-12,  -1.649171210253075e-13,   2.854631330888279e-15,  -4.861787859359145e-17,
   8.165986854526048e-19,  -1.497033304216536e-03,   4.536092369582070e-05,  -1.030975056480466e-06,   2.082890790189574e-08,  -3.945027554055439e-10,   7.172857914257948e-12,
  -1.267866697040034e-13,   2.194984672927545e-15,  -3.739021327392544e-17,   6.281386976459214e-19,  -1.008317707113111e-03,   3.055394473019244e-05,  -6.944796411333359e-07,
   1.403170070649242e-08,  -2.657864229314191e-10,   4.833039934289930e-12,  -8.543848541677508e-14,   1.479344619791464e-15,  -2.520339882234561e-17,   4.234708465954909e-19,
  -5.567556656856761e-04,   1.687119228918480e-05,  -3.834890685391827e-07,   7.748586963804478e-09,  -1.467801957604657e-10,   2.669200857701906e-12,  -4.718938298650115e-14,
   8.171344742861808e-16,  -1.392258287800147e-17,   2.339498379917853e-19,  -2.111270864321467e-04,   6.397780024348463e-06,  -1.454260283587515e-07,   2.938452665500569e-09,
  -5.566370225286590e-11,   1.012268494412107e-12,  -1.789657748300253e-14,   3.099072722660655e-16,  -5.280460016849956e-18,   8.873381644657087e-20,  -2.407135216603571e-05,
   7.294348946459811e-07,  -1.658060250291623e-08,   3.350256275019637e-10,  -6.346478559129136e-12,   1.154138902176029e-13,  -2.040488750857110e-15,   3.533442816008071e-17,
  -6.020607721327182e-19,   1.011719524721060e-20,  -2.227673635006891e-04,   6.363506927139411e-06,  -1.363429906182124e-07,   2.596583685675288e-09,  -4.635748152274643e-11,
   7.944775955658113e-13,  -1.323664670159208e-14,   2.160118115896243e-16,  -3.469465202412331e-18,   5.500203879543119e-20,  -2.059806995632804e-04,   5.884155021554733e-06,
  -1.260773965630339e-07,   2.401196946494702e-09,  -4.287168422650495e-11,   7.347876179973305e-13,  -1.224311180530375e-14,   1.998154917490750e-16,  -3.209637773026463e-18,
   5.088827035547787e-20,  -1.749593666334871e-04,   4.998221462121845e-06,  -1.071016727955668e-07,   2.039958572531942e-09,  -3.642550372931428e-11,   6.243745835526738e-13,
  -1.040472147013624e-14,   1.698360469048615e-16,  -2.728508987661730e-18,   4.326747804367441e-20,  -1.344219944357312e-04,   3.840348336386943e-06,  -8.229637370767758e-08,
   1.567625958704596e-09,  -2.799436693988900e-11,   4.799120061331765e-13,  -7.998443470815659e-15,   1.305782191024900e-16,  -2.098162268523591e-18,   3.327777659233159e-20,
  -9.053866662547192e-05,   2.586733469566014e-06,  -5.543510055062591e-08,   1.056028000925722e-09,  -1.885985086158071e-11,   3.233475684901235e-13,  -5.389637956949614e-15,
   8.799878268524268e-17,  -1.414172158324357e-18,   2.243260364420700e-20,  -4.999195167326658e-05,   1.428327069443774e-06,  -3.061076212488094e-08,   5.831514834226272e-10,
  -1.041511769614961e-11,   1.785742483573132e-13,  -2.976702574736207e-15,   4.860516372965604e-17,  -7.811619522789759e-19,   1.239236939176721e-20,  -1.895740683052501e-05,
   5.416394091311509e-07,  -1.160811581404359e-08,   2.211440333053159e-10,  -3.949712868551735e-12,   6.772186724438129e-14,  -1.128900151995728e-15,   1.843375130697550e-17,
  -2.962680412289129e-19,   4.700148081850087e-21,  -2.161401181054647e-06,   6.175431823836047e-08,  -1.323486870500941e-09,   2.521355986022058e-11,  -4.503246390565232e-13,
   7.721302356300439e-15,  -1.287119362117261e-16,   2.101739452829913e-18,  -3.377940658640818e-20,   5.358965767577582e-22,  -2.205169561336471e-03,   6.299222452336154e-05,
  -1.349656466030489e-06,   2.570352846038571e-08,  -4.588917371604435e-10,   7.864515332693562e-12,  -1.310291244726467e-13,   2.138284661337437e-15,  -3.434344306591782e-17,
   5.444249998492359e-19,  -2.038998719389703e-03,   5.824712984393718e-05,  -1.248037561148117e-06,   2.376939914985259e-08,  -4.243859027347990e-10,   7.273645615412848e-12,
  -1.211941547982339e-13,   1.977958452014080e-15,  -3.177146723029085e-17,   5.037056263561028e-19,  -1.731919181104155e-03,   4.947729171415271e-05,  -1.060197260995989e-06,
   2.019350792001567e-08,  -3.605752970746113e-10,   6.180669529275926e-12,  -1.029959890826120e-13,   1.681194111235019e-15,  -2.700887897556633e-17,   4.282727392564451e-19,
  -1.330640565321686e-03,   3.801552939644499e-05,  -8.146501143881012e-07,   1.551789709693069e-08,  -2.771156507849197e-10,   4.750637811855718e-12,  -7.917632284134077e-14,
   1.292583792466927e-15,  -2.076921867722519e-17,   3.293918664269615e-19,  -8.962404035716438e-04,   2.560602154790797e-05,  -5.487509226688656e-07,   1.045359944313211e-08,
  -1.866932677753438e-10,   3.200810070336555e-12,  -5.335184430015040e-14,   8.710931759275363e-16,  -1.399855805126794e-17,   2.220434829442587e-19,  -4.948693040546311e-04,
   1.413898035801929e-05,  -3.030153060554466e-07,   5.772604530214254e-09,  -1.030990314196954e-10,   1.767702334792867e-12,  -2.946627819221741e-14,   4.811387628483056e-16,
  -7.732538011931702e-18,   1.226627142449121e-19,  -1.876589813139683e-04,   5.361677399151882e-06,  -1.149085002119393e-07,   2.189100233408579e-09,  -3.909812476260622e-11,
   6.703771898381149e-13,  -1.117494443057050e-14,   1.824742792460830e-16,  -2.932687399426596e-18,   4.652321432203562e-20,  -2.139566595123230e-05,   6.113047293397181e-07,
  -1.310116936940216e-08,   2.495885100311909e-10,  -4.457754147513994e-12,   7.643299255832435e-14,  -1.274115103683648e-15,   2.080495634681250e-17,  -3.343743695707421e-19,
   5.304435180022726e-21,  -1.993138222380792e-04,   5.385894616930143e-06,  -1.091607386235988e-07,   1.966571837266698e-09,  -3.321266554906462e-11,   5.384499760478180e-13,
  -8.486471680946044e-15,   1.310163338143592e-16,  -1.990883683848869e-18,   2.986820991308482e-20,  -1.842939371380773e-04,   4.980154023182886e-06,  -1.009407317019246e-07,
   1.818564148621920e-09,  -3.071461929299479e-11,   4.979814101120939e-13,  -7.849194083262245e-15,   1.211873350690720e-16,  -1.841684740073167e-18,   2.763247454092639e-20,
  -1.565379088857927e-04,   4.230286619869983e-06,  -8.574685330085899e-08,   1.544938781938686e-09,  -2.609545530814975e-11,   4.231322730429218e-13,  -6.670179946342947e-15,
   1.029971828898854e-16,  -1.565471362286387e-18,   2.349184894072598e-20,  -1.202680700309801e-04,   3.250276290925179e-06,  -6.588626859148616e-08,   1.187191534547299e-09,
  -2.005458829841768e-11,   3.252152786925265e-13,  -5.127253798202748e-15,   7.918294029232037e-17,  -1.203696177899007e-18,   1.806594292837791e-20,  -8.100508327806328e-05,
   2.189261773107769e-06,  -4.438058000872319e-08,   7.997323470008339e-10,  -1.351041204481808e-11,   2.191098587932577e-13,  -3.454753668312634e-15,   5.335932528513770e-17,
  -8.112357884863693e-19,   1.217719454702455e-20,  -4.472776681136403e-05,   1.208847653606646e-06,  -2.450635768037649e-08,   4.416165616216433e-10,  -7.460830242555798e-12,
   1.210044482904061e-13,  -1.908008619061376e-15,   2.947137300106939e-17,  -4.480916652174376e-19,   6.726661036065656e-21,  -1.696116414659699e-05,   4.584092468815195e-07,
  -9.293194789947580e-09,   1.674700761462504e-10,  -2.829343887517004e-12,   4.588891018730243e-14,  -7.235952171909244e-16,   1.117701374951473e-17,  -1.699430634190168e-19,
   2.551222497457600e-21,  -1.933802180912851e-06,   5.226492291846966e-08,  -1.059553100701794e-09,   1.909395221929062e-11,  -3.225859606872147e-13,   5.232012440996169e-15,
  -8.250080666913072e-17,   1.274353629567675e-18,  -1.937623832858645e-20,   2.908816907140059e-22,  -1.973003437523092e-03,   5.331486032376368e-05,  -1.080579912110380e-06,
   1.946705424925129e-08,  -3.287714919254094e-10,   5.330104973814290e-12,  -8.400738521926410e-14,   1.296926335120013e-15,  -1.970761496301200e-17,   2.956592808865413e-19,
  -1.824321903042712e-03,   4.929844250984356e-05,  -9.992102322322846e-07,   1.800192917738235e-08,  -3.040433834929645e-10,   4.929507490322676e-12,  -7.769898902324958e-14,
   1.199629394794493e-15,  -1.823070480651980e-17,   2.735281686297512e-19,  -1.549565548772742e-03,   4.187552046764038e-05,  -8.488063416543427e-07,   1.529331728913418e-08,
  -2.583183743649385e-10,   4.188577456814585e-12,  -6.602795543119680e-14,   1.019565672356840e-15,  -1.549648774147527e-17,   2.325409322313961e-19,  -1.190531158004417e-03,
   3.217441832588872e-05,  -6.522068210723943e-07,   1.175198463060848e-08,  -1.985199562974240e-10,   3.219299190801143e-12,  -5.075456540401029e-14,   7.838292709318249e-16,
  -1.191530079398723e-17,   1.788309853305967e-19,  -8.018676575955233e-04,   2.167145738025530e-05,  -4.393224509992316e-07,   7.916534086509698e-09,  -1.337392904104942e-10,
   2.168963874160135e-12,  -3.419852566965707e-14,   5.282021667491289e-16,  -8.030363678006385e-18,   1.205394821848392e-19,  -4.427592461005447e-04,   1.196635812407572e-05,
  -2.425879319081363e-07,   4.371553278213069e-09,  -7.385460481598002e-11,   1.197820482999940e-12,  -1.888733262038922e-14,   2.917361287098363e-16,  -4.435626490459058e-18,
   6.658579459448409e-20,  -1.678982159383567e-04,   4.537783730816540e-06,  -9.199314456744089e-08,   1.657782846027767e-09,  -2.800761683410561e-11,   4.542533546194468e-13,
  -7.162852099627221e-15,   1.106408824200139e-16,  -1.682253891853200e-18,   2.525401105908776e-20,  -1.914266811798491e-05,   5.173693997780753e-07,  -1.048849440616171e-08,
   1.890106410673593e-10,  -3.193271776834035e-12,   5.179158086334815e-14,  -8.166735519876909e-16,   1.261478362657437e-17,  -1.918039585560170e-19,   2.879376222869189e-21,
  -1.793791143340977e-04,   4.598722564818645e-06,  -8.842764059210779e-08,   1.511384207726668e-09,  -2.421666792698697e-11,   3.724809717763272e-13,  -5.569768042971490e-15,
   8.158152765710192e-17,  -1.176199020834817e-18,   1.674381457423287e-20,  -1.658610356539862e-04,   4.252260584574987e-06,  -8.176816510469451e-08,   1.397616562527027e-09,
  -2.239483567295965e-11,   3.444778586248771e-13,  -5.151354666077241e-15,   7.545824335973861e-17,  -1.088001688337413e-18,   1.548960673116532e-20,  -1.408805351127099e-04,
   3.611962028975956e-06,  -6.945920508198105e-08,   1.187302579423326e-09,  -1.902631291140107e-11,   2.926894159360828e-13,  -4.377354070074390e-15,   6.412789770966170e-17,
  -9.247525105282482e-19,   1.316732158272934e-20,  -1.082380183430495e-04,   2.775170826113612e-06,  -5.337033944365227e-08,   9.123491728658696e-10,  -1.462142585666562e-11,
   2.249486729729736e-13,  -3.364614613815508e-15,   4.929737432777414e-17,  -7.109864504726728e-19,   1.012507051789681e-20,  -7.290212873918335e-05,   1.869235556201042e-06,
  -3.594950042459123e-08,   6.145782774089457e-10,  -9.849943161870021e-12,   1.515514008872768e-13,  -2.266986920505966e-15,   3.321844406174648e-17,  -4.791409161957229e-19,
   6.824187939362635e-21,  -4.025355632105170e-05,   1.032134087140194e-06,  -1.985069295038943e-08,   3.393699807101438e-10,  -5.439337781428309e-12,   8.369336467277686e-14,
  -1.251991947574575e-15,   1.834661443474898e-17,  -2.646468331750236e-19,   3.769500804445024e-21,  -1.526449218404849e-05,   3.913967783786711e-07,  -7.527674371373640e-09,
   1.286955737183874e-10,  -2.062729389805306e-12,   3.173907769798586e-14,  -4.748023546192016e-16,   6.957870183561267e-18,  -1.003684344037701e-19,   1.429635535144453e-21,
  -1.740358399174302e-06,   4.462457365910562e-08,  -8.582589187578375e-10,   1.467310230575476e-11,  -2.351806536583663e-13,   3.618718555478468e-15,  -5.413457154727739e-17,
   7.933040347917940e-19,  -1.144358656128256e-20,   1.630017153013074e-22,  -1.775670172932090e-03,   4.552266032886018e-05,  -8.753434001568229e-07,   1.496116126363717e-08,
  -2.397202985975275e-10,   3.687181457331700e-12,  -5.513501625196729e-14,   8.075736348528295e-16,  -1.164315567013760e-17,   1.657459004002190e-19,  -1.641854989393409e-03,
   4.209304029390586e-05,  -8.094213889237902e-07,   1.383497767792671e-08,  -2.216860185181946e-10,   3.409979217586214e-12,  -5.099315105171840e-14,   7.469593855769341e-16,
  -1.077009308674211e-17,   1.533305770639080e-19,  -1.394573526996162e-03,   3.575473802740529e-05,  -6.875752461731409e-07,   1.175308387411373e-08,  -1.883410808605933e-10,
   2.897326491260828e-12,  -4.333133547342739e-14,   6.348005574186309e-16,  -9.154094721392055e-18,   1.303424269787327e-19,  -1.071445923136075e-03,   2.747135907658476e-05,
  -5.283118952771283e-07,   9.031325743732489e-09,  -1.447371943446303e-10,   2.226762273663026e-12,  -3.330624896910509e-14,   4.879935524656814e-16,  -7.038031433874174e-18,
   1.002273848134712e-19,  -7.216566768432072e-04,   1.850352442448723e-05,  -3.558633672103597e-07,   6.083697758892975e-09,  -9.750438511668620e-11,   1.500204191148006e-12,
  -2.244085561500549e-14,   3.288285980839822e-16,  -4.743000089854967e-18,   6.755217022136421e-20,  -3.984691282431328e-04,   1.021707415493340e-05,  -1.965016022851742e-07,
   3.359416476260894e-09,  -5.384389301543788e-11,   8.284788904092522e-13,  -1.239344182576635e-14,   1.816127054376923e-16,  -2.619730238910624e-18,   3.731403020962582e-20,
  -1.511028949874658e-04,   3.874428679879198e-06,  -7.451629417434916e-08,   1.273954843815397e-09,  -2.041891587673687e-11,   3.141844753900261e-13,  -4.700058472029605e-15,
   6.887579351546828e-17,  -9.935438068899210e-19,   1.415186411026262e-20,  -1.722777209095745e-05,   4.417377392027157e-07,  -8.495887429871266e-09,   1.452487386793719e-10,
  -2.328048461721402e-12,   3.582162033037700e-14,  -5.358769794438736e-16,   7.852898006067949e-18,  -1.132796841989469e-19,   1.613542798226982e-21,  -1.622928089552197e-04,
   3.957783500444261e-06,  -7.239156720617108e-08,   1.176958182174864e-09,  -1.793859929681935e-11,   2.624631026727573e-13,  -3.733305782570206e-15,   5.201677405127146e-17,
  -7.133986505619509e-19,   9.661057734447892e-21,  -1.500620253258227e-04,   3.659592727741312e-06,  -6.693926878478466e-08,   1.088351919700116e-09,  -1.658881034390439e-11,
   2.427260780763904e-13,  -3.452759121540588e-15,   4.811092903719819e-17,  -6.598774592759276e-19,   8.936951856745526e-21,  -1.274605621258082e-04,   3.108514362656347e-06,
  -5.686188052075806e-08,   9.245592942228386e-10,  -1.409324057505323e-11,   2.062278443091031e-13,  -2.933846746496880e-15,   4.088464268127619e-17,  -5.608285520649256e-19,
   7.596466044222163e-21,  -9.792711903647760e-05,   2.388339416021675e-06,  -4.369037258904302e-08,   7.104377047054622e-10,  -1.083014186216253e-11,   1.584922284389832e-13,
  -2.254970310434950e-15,   3.142763425308650e-17,  -4.311565824589469e-19,   5.840838906658974e-21,  -6.595717165991211e-05,   1.608672730596000e-06,  -2.942891256739687e-08,
   4.785589964078111e-10,  -7.295731586375125e-12,   1.067756190578732e-13,  -1.519282666758743e-15,   2.117616332556570e-17,  -2.905444886663214e-19,   3.936398429744192e-21,
  -3.641877230649987e-05,   8.882562121538324e-07,  -1.625004137945543e-08,   2.642578335708888e-10,  -4.028800734720006e-12,   5.896523291797782e-14,  -8.390385393772906e-16,
   1.169532879972314e-17,  -1.604730304675022e-19,   2.174278242617661e-21,  -1.381030017522994e-05,   3.368362337233999e-07,  -6.162240784969810e-09,   1.002112818840405e-10,
  -1.527812293714186e-12,   2.236127729721852e-14,  -3.181923876158011e-16,   4.435356259504736e-18,  -6.085933946780120e-20,   8.246132512462527e-22,  -1.574560684265533e-06,
   3.840391860075360e-08,  -7.025803608069759e-10,   1.142548683731904e-11,  -1.741923198419905e-13,   2.549509689546265e-15,  -3.627864459037845e-17,   5.056978830613393e-19,
  -6.938911850570657e-21,   9.401910323627815e-23,  -1.606533186502631e-03,   3.917801767919812e-05,  -7.166026386988912e-07,   1.165068490023611e-08,  -1.775738263803061e-10,
   2.598116863339861e-12,  -3.695591688712375e-14,   5.149129464941990e-16,  -7.061916600918251e-18,   9.563450330782716e-20,  -1.485460910262831e-03,   3.622623333742732e-05,
  -6.626304484766107e-07,   1.077357332573962e-08,  -1.642122932296643e-10,   2.402740462155678e-12,  -3.417879127759067e-14,   4.762490691177988e-16,  -6.532111566743884e-18,
   8.846660171012011e-20,  -1.261729489702109e-03,   3.077111990651348e-05,  -5.628745887833210e-07,   9.152193486316911e-09,  -1.395086992907867e-10,   2.041445195594067e-12,
  -2.904208838423837e-14,   4.047162130638107e-16,  -5.551628732097045e-18,   7.519717460224922e-20,  -9.693785424226887e-04,   2.364212288376027e-05,  -4.324901019738341e-07,
   7.032608264353684e-09,  -1.072073520829878e-10,   1.568911314389288e-12,  -2.232190455399189e-14,   3.111014864867061e-16,  -4.268008923409349e-18,   5.781827705465808e-20,
  -6.529086891874366e-04,   1.592421835915451e-05,  -2.913162017859293e-07,   4.737245687871479e-09,  -7.222029728106101e-11,   1.056969660202646e-12,  -1.503934775444881e-14,
   2.096223925862546e-16,  -2.876093090224099e-18,   3.896628150817876e-20,  -3.605086799515477e-04,   8.792830022034720e-06,  -1.608588262541358e-07,   2.615882873306023e-09,
  -3.988101581074715e-11,   5.836956296800170e-13,  -8.305625179863434e-15,   1.157718122351868e-16,  -1.588518769157294e-18,   2.152311031916623e-20,  -1.367078781241122e-04,
   3.334334967622252e-06,  -6.099989511527136e-08,   9.919894235497239e-10,  -1.512378254807608e-11,   2.213538247284810e-13,  -3.149779876056073e-15,   4.390549772565570e-17,
  -6.024451753438750e-19,   8.162820009240551e-21,  -1.558654391232355e-05,   3.801596023940926e-07,  -6.954828578559828e-09,   1.131006598103597e-10,  -1.724326200066413e-12,
   2.523754405716493e-14,  -3.591215538409826e-16,   5.005892639773410e-18,  -6.868812581182467e-20,   9.306920738338794e-22  };
  static constexpr double wr[4840] = {   1.629016079100553e+00,  -1.873249613425887e-01,   2.088315563572829e-02,  -2.022887615289805e-03,   1.718650673084636e-04,
  -1.307762553689894e-05,   9.045116637023200e-07,  -5.729180001694581e-08,   3.335117660689478e-09,  -1.782615303932028e-10,   8.703907232448701e-12,  -3.847326902143839e-13,
   1.515334843168669e-14,  -5.172515843301236e-16,   1.631184001282976e+00,  -1.879410137705110e-01,   2.098772122955915e-02,  -2.036196008188825e-03,   1.732517667802667e-04,
  -1.320101338455501e-05,   9.141015766027185e-07,  -5.794982390114210e-08,   3.375077384961914e-09,  -1.804009679644005e-10,   8.803731700233900e-12,  -3.887035034882705e-13,
   1.528329446264602e-14,  -5.206117283913005e-16,   1.635018275284585e+00,  -1.890312775097426e-01,   2.117289055560613e-02,  -2.059776237173315e-03,   1.757099167649028e-04,
  -1.341981450126123e-05,   9.311103901414261e-07,  -5.911690295892418e-08,   3.445934692446833e-09,  -1.841928808236074e-10,   8.980534054771497e-12,  -3.957305449789574e-13,
   1.551319184984202e-14,  -5.265770888280955e-16,   1.639670005520131e+00,  -1.903551589249343e-01,   2.139793119619485e-02,  -2.088456289155974e-03,   1.787016699155080e-04,
  -1.368624154585274e-05,   9.518269308308563e-07,  -6.053838519615405e-08,   3.532210602189703e-09,  -1.888068783437328e-10,   9.195453765807881e-12,  -4.042627958946289e-13,
   1.579223602548552e-14,  -5.338538874845129e-16,   1.644201881890965e+00,  -1.916461643204511e-01,   2.161758678642034e-02,  -2.116473577406134e-03,   1.816263454543093e-04,
  -1.394683054411298e-05,   9.720951941109636e-07,  -6.192909720291579e-08,   3.616590308927561e-09,  -1.933162775688952e-10,   9.405278594740622e-12,  -4.125826961401487e-13,
   1.606424884817212e-14,  -5.409863709525507e-16,   1.647864243334481e+00,  -1.926903548681012e-01,   2.179539445301880e-02,  -2.139169988209492e-03,   1.839970578632111e-04,
  -1.415815814395238e-05,   9.885360005708810e-07,  -6.305717618835815e-08,   3.685014398787806e-09,  -1.969706905813607e-10,   9.575161455275069e-12,  -4.193117140832914e-13,
   1.628419827489865e-14,  -5.467824664467466e-16,   1.650289931715868e+00,  -1.933823867232946e-01,   2.191330704825612e-02,  -2.154229300794944e-03,   1.855707720374688e-04,
  -1.429848781144585e-05,   9.994552871720816e-07,  -6.380639178010709e-08,   3.730448179508997e-09,  -1.993961082230341e-10,   9.687834377966115e-12,  -4.237712211653690e-13,
   1.642994460699377e-14,  -5.506375684013710e-16,   1.651537393873685e+00,  -1.937384132403653e-01,   2.197399112549118e-02,  -2.161982175726314e-03,   1.863811784794265e-04,
  -1.437076714847852e-05,   1.005080065600673e-06,  -6.419232784259492e-08,   3.753848870157215e-09,  -2.006449734827362e-10,   9.745826563529183e-12,  -4.260654533284265e-13,
   1.650491978283128e-14,  -5.526252387112723e-16,   1.651971864193553e+00,  -1.938624327434266e-01,   2.199513354668021e-02,  -2.164683695132135e-03,   1.866636031948100e-04,
  -1.439595864374158e-05,   1.007040563441788e-06,  -6.432684418509340e-08,   3.762004574395827e-09,  -2.010801778170942e-10,   9.766031867253177e-12,  -4.268646296781783e-13,
   1.653103599514209e-14,  -5.533183320288128e-16,   1.652040821933169e+00,  -1.938821177377562e-01,   2.199848954439596e-02,  -2.165112534419519e-03,   1.867084369861108e-04,
  -1.439995780260503e-05,   1.007351797702132e-06,  -6.434819899419328e-08,   3.763299289043761e-09,  -2.011492636994680e-10,   9.769239148596492e-12,  -4.269914787371883e-13,
   1.653518125007033e-14,  -5.534283767224604e-16,   1.395128611048898e+00,  -4.392940011402415e-01,   8.067740653197122e-02,  -1.055967440777559e-02,   1.081527720472069e-03,
  -9.116135043622784e-05,   6.532320980139485e-06,  -4.071583158805565e-07,   2.245432225812208e-08,  -1.110731211498448e-09,   4.987037334510495e-11,  -2.055337117584450e-12,
   7.867933248720369e-14,  -2.829963442817455e-15,   1.404028476093070e+00,  -4.425925090657477e-01,   8.134233566153207e-02,  -1.065249104411723e-02,   1.091474572788292e-03,
  -9.202807935367315e-05,   6.596017638403701e-06,  -4.112100742894525e-07,   2.268194346350088e-08,  -1.122219406455846e-09,   5.039960332288113e-11,  -2.077922105003538e-12,
   7.958232056404336e-14,  -2.863817045829578e-15,   1.419790054550513e+00,  -4.484353059240947e-01,   8.252034451737522e-02,  -1.081694841636922e-02,   1.109100667295558e-03,
  -9.356407245224254e-05,   6.708907736005860e-06,  -4.183916499005136e-07,   2.308543751846754e-08,  -1.142587142373165e-09,   5.133807178828408e-11,  -2.117978777331476e-12,
   8.118389782711609e-14,  -2.923836924222191e-15,   1.438947662299271e+00,  -4.555390025702089e-01,   8.395289624987076e-02,  -1.101697666282565e-02,   1.130542123889453e-03,
  -9.543276298412792e-05,   6.846264699506439e-06,  -4.271307485223875e-07,   2.357651713319049e-08,  -1.167381392245905e-09,   5.248080757044671e-11,  -2.166766619786722e-12,
   8.313462795351323e-14,  -2.996899409974569e-15,   1.457649083907236e+00,  -4.624756345731310e-01,   8.535209625354515e-02,  -1.121238475260876e-02,   1.151491450756504e-03,
  -9.725878819910693e-05,   6.980501095165773e-06,  -4.356724086428155e-07,   2.405658272012665e-08,  -1.191625151680680e-09,   5.359849614287229e-11,  -2.214497941758579e-12,
   8.504315797807370e-14,  -3.068336494537204e-15,   1.472789151121223e+00,  -4.680928051823625e-01,   8.648538823047497e-02,  -1.137068326059092e-02,   1.168464562483164e-03,
  -9.873839259253425e-05,   7.089282243629018e-06,  -4.425951066338704e-07,   2.444571608097457e-08,  -1.211280767983101e-09,   5.450489326127142e-11,  -2.253215057655840e-12,
   8.659127683736884e-14,  -3.126250577775428e-15,   1.482829990789021e+00,  -4.718188257142028e-01,   8.723725012229143e-02,  -1.147571640665298e-02,   1.179727538323433e-03,
  -9.972030402508633e-05,   7.161478261169913e-06,  -4.471899613511373e-07,   2.470402700917464e-08,  -1.224330348022389e-09,   5.510677338854660e-11,  -2.278929000054966e-12,
   8.761946449713882e-14,  -3.164698191221512e-15,   1.487997768649678e+00,  -4.737367449682903e-01,   8.762429769395513e-02,  -1.152978992636284e-02,   1.185526319379663e-03,
  -1.002258689224909e-04,   7.198652117325683e-06,  -4.495559806989337e-07,   2.483704736545198e-08,  -1.231050997393463e-09,   5.541678188625503e-11,  -2.292174745694073e-12,
   8.814910455627716e-14,  -3.184498277872343e-15,   1.489798266166892e+00,  -4.744050002830801e-01,   8.775916145333208e-02,  -1.154863206355177e-02,   1.187546981891843e-03,
  -1.004020436442893e-04,   7.211606398942239e-06,  -4.503805062738261e-07,   2.488340455725510e-08,  -1.233393220370247e-09,   5.552482893190410e-11,  -2.296791489463447e-12,
   8.833370821753377e-14,  -3.191398701767806e-15,   1.490084066059879e+00,  -4.745110767280029e-01,   8.778056951862234e-02,  -1.155162306544370e-02,   1.187867744520582e-03,
  -1.004300100367046e-04,   7.213662805072674e-06,  -4.505113951424389e-07,   2.489076357148527e-08,  -1.233765043273962e-09,   5.554198143320247e-11,  -2.297524409040264e-12,
   8.836301450957662e-14,  -3.192494122896506e-15,   1.107054111910690e+00,  -8.485883691944759e-02,   7.200918842427759e-03,  -5.719884334805474e-04,   4.129009852240748e-05,
  -2.717601548894169e-06,   1.661816722797950e-07,  -9.488374678035930e-09,   5.072635104691282e-10,  -2.559723631119824e-11,   1.215611513391838e-12,  -5.397219636512483e-14,
   2.243870583208251e-15,  -8.612038044004018e-17,   1.107778723671591e+00,  -8.502932506102531e-02,   7.225571067121120e-03,  -5.747075646184682e-04,   4.154111574670603e-05,
  -2.737802518236516e-06,   1.676308730807644e-07,  -9.582827957192082e-09,   5.128856273890995e-10,  -2.590240097683852e-11,   1.230768402899332e-12,  -5.465454605456555e-14,
   2.271065853969113e-15,  -8.706788130391116e-17,   1.109059366203837e+00,  -8.533080622863640e-02,   7.269189252044073e-03,  -5.795213871602758e-04,   4.198574338246772e-05,
  -2.773602652842098e-06,   1.702003120084983e-07,  -9.750349547210669e-09,   5.228590553569183e-10,  -2.644378344890393e-11,   1.257651867837946e-12,  -5.586424831348837e-14,
   2.319241301257092e-15,  -8.874366368839806e-17,   1.110611441511017e+00,  -8.569647508983555e-02,   7.322136194185680e-03,  -5.853694605815245e-04,   4.252630682181113e-05,
  -2.817158154619213e-06,   1.733283585683415e-07,  -9.954385742945047e-09,   5.350099244362341e-10,  -2.710341499164610e-11,   1.290397119308456e-12,  -5.733674322678389e-14,
   2.377817758303186e-15,  -9.077667524571669e-17,   1.112121852526057e+00,  -8.605263066022777e-02,   7.373749840503202e-03,  -5.910752043865736e-04,   4.305414155445566e-05,
  -2.859720436314972e-06,   1.763871599286836e-07,  -1.015400418345280e-08,   5.469013815949411e-10,  -2.774901620534572e-11,   1.322435158479033e-12,  -5.877640412624106e-14,
   2.435020152592989e-15,  -9.275721841460403e-17,   1.113341265284977e+00,  -8.634038603933371e-02,   7.415482717848398e-03,  -5.956921981751754e-04,   4.348156339314512e-05,
  -2.894209079456610e-06,   1.788672307242972e-07,  -1.031592522497123e-08,   5.565497821658435e-10,  -2.827287505787834e-11,   1.348423949134112e-12,  -5.994349026383032e-14,
   2.481343382325492e-15,  -9.435767018645152e-17,   1.114148329267238e+00,  -8.653094244501376e-02,   7.443134466456417e-03,  -5.987531034194045e-04,   4.376507938291472e-05,
  -2.917097336990519e-06,   1.805138509310031e-07,  -1.042346577944245e-08,   5.629590787428859e-10,  -2.862088397479066e-11,   1.365684936309125e-12,  -6.071826683817162e-14,
   2.512071297987609e-15,  -9.541763929832762e-17,   1.114563197125849e+00,  -8.662893013744737e-02,   7.457358325913485e-03,  -6.003281479450130e-04,   4.391101418561182e-05,
  -2.928882174841752e-06,   1.813618979745643e-07,  -1.047886229318220e-08,   5.662610395231823e-10,  -2.880017732818448e-11,   1.374576562049374e-12,  -6.111726215867383e-14,
   2.527888153042384e-15,  -9.596273112230283e-17,   1.114707659712786e+00,  -8.666305602495887e-02,   7.462312793803640e-03,  -6.008768544176506e-04,   4.396186165479995e-05,
  -2.932988877387924e-06,   1.816574557286924e-07,  -1.049817054744607e-08,   5.674119879808132e-10,  -2.886267353654994e-11,   1.377675721777681e-12,  -6.125631303129593e-14,
   2.533399180985665e-15,  -9.615257413943202e-17,   1.114730586976433e+00,  -8.666847230089880e-02,   7.463099176461205e-03,  -6.009639502219595e-04,   4.396993299025768e-05,
  -2.933640786414085e-06,   1.817043750672357e-07,  -1.050123578358147e-08,   5.675947070131219e-10,  -2.887259517091064e-11,   1.378167722246893e-12,  -6.127838688981982e-14,
   2.534273981831588e-15,  -9.618270525021651e-17,   4.106505457074692e-01,  -1.044067730565546e-01,   1.732599689676450e-02,  -2.104319798920982e-03,   2.043760638373466e-04,
  -1.658214961919264e-05,   1.154232290716446e-06,  -7.037017719794090e-08,   3.816001332880256e-09,  -1.860948229303482e-10,   8.242346531593294e-12,  -3.344550678918895e-13,
   1.251310496762289e-14,  -4.348331475535999e-16,   4.125259052237489e-01,  -1.050581211686421e-01,   1.745092004368253e-02,  -2.121132827783092e-03,   2.061281536899068e-04,
  -1.673157226831467e-05,   1.165031976068191e-06,  -7.104728164571176e-08,   3.853493487917286e-09,  -1.879550214844912e-10,   8.325962269452510e-12,  -3.378999202331158e-13,
   1.264501701655157e-14,  -4.395730967773279e-16,   4.158457500304678e-01,  -1.062115042825847e-01,   1.767218101112598e-02,  -2.150916967547472e-03,   2.092324025294358e-04,
  -1.699633908108948e-05,   1.184169870806855e-06,  -7.224724803492613e-08,   3.919941273948095e-09,  -1.912520869497887e-10,   8.474179945678519e-12,  -3.440071987630929e-13,
   1.287893123997997e-14,  -4.479813175158707e-16,   4.198785094224290e-01,  -1.076131450229755e-01,   1.794115504572579e-02,  -2.187132841399812e-03,   2.130077426828931e-04,
  -1.731839330037004e-05,   1.207451321720307e-06,  -7.370716305913911e-08,   4.000790630619639e-09,  -1.952641090868787e-10,   8.654563666902184e-12,  -3.514414450068667e-13,
   1.316375718151356e-14,  -4.582248137727471e-16,   4.238127396185963e-01,  -1.089811442416711e-01,   1.820376567411481e-02,  -2.222501380702382e-03,   2.166955317555703e-04,
  -1.763303017304164e-05,   1.230199401834015e-06,  -7.513378208003176e-08,   4.079803421596736e-09,  -1.991853811007322e-10,   8.830894144813666e-12,  -3.587103017579019e-13,
   1.344233882506564e-14,  -4.682491870934302e-16,   4.269959750748719e-01,  -1.100884421812576e-01,   1.841639645277870e-02,  -2.251145385520510e-03,   2.196827288466422e-04,
  -1.788793019530401e-05,   1.248630568742755e-06,  -7.628977866820607e-08,   4.143833168457727e-09,  -2.023633484352198e-10,   8.973819360972667e-12,  -3.646032925799510e-13,
   1.366825621421443e-14,  -4.763824001833149e-16,   4.291062098216438e-01,  -1.108227052771100e-01,   1.855742696422548e-02,  -2.270147262560259e-03,   2.216646506422223e-04,
  -1.805706717138356e-05,   1.260861423081126e-06,  -7.705694647379389e-08,   4.186328586267989e-09,  -2.044726465381701e-10,   9.068692025846097e-12,  -3.685156034858350e-13,
   1.381827357243387e-14,  -4.817850474943464e-16,   4.301920260606096e-01,  -1.112005840170127e-01,   1.863001645159867e-02,  -2.279928699682654e-03,   2.226849523530809e-04,
  -1.814414514330977e-05,   1.267158626367370e-06,  -7.745194840358977e-08,   4.208209572338111e-09,  -2.055587713638140e-10,   9.117547045637550e-12,  -3.705304446631025e-13,
   1.389554263505915e-14,  -4.845683608920474e-16,   4.305702905591131e-01,  -1.113322355902706e-01,   1.865530795675255e-02,  -2.283336894396601e-03,   2.230404745777230e-04,
  -1.817448818174810e-05,   1.269352987713558e-06,  -7.758959574797584e-08,   4.215834624068729e-09,  -2.059372692152539e-10,   9.134572742932855e-12,  -3.712326345013701e-13,
   1.392247318780424e-14,  -4.855385209448410e-16,   4.306303318935211e-01,  -1.113531329334536e-01,   1.865932260847216e-02,  -2.283877902551853e-03,   2.230969099083512e-04,
  -1.817930485470531e-05,   1.269701324328990e-06,  -7.761144624240615e-08,   4.217045050517959e-09,  -2.059973535635385e-10,   9.137275496473606e-12,  -3.713441053906495e-13,
   1.392674842228862e-14,  -4.856925385995152e-16,   8.511228907523720e-01,  -4.654314633515588e-02,   3.023336274920139e-03,  -1.951249149201520e-04,   1.210128474497816e-05,
  -6.866319695181342e-07,   3.634001377363337e-08,  -1.865707269370387e-09,   9.011530871458925e-11,  -4.025726817146363e-12,   1.787656786523111e-13,  -7.788007418599694e-15,
   2.942513330320063e-16,  -1.083025664638434e-17,   8.514206175226865e-01,  -4.660041662563413e-02,   3.030450466749626e-03,  -1.958017464138218e-04,   1.215541509272276e-05,
  -6.905421279010599e-07,   3.659370701217831e-08,  -1.880445742164793e-09,   9.093539488720629e-11,  -4.069368412284280e-12,   1.807847553227179e-13,  -7.876152652688115e-15,
   2.984950782197825e-16,  -1.099011521744355e-17,   8.519465407767861e-01,  -4.670163157092666e-02,   3.043029048451912e-03,  -1.969990806108041e-04,   1.225122581983341e-05,
  -6.974658285159705e-07,   3.704314342077373e-08,  -1.906574352944472e-09,   9.238955067021317e-11,  -4.146753484905005e-12,   1.843690817119673e-13,  -8.032658240869891e-15,
   3.060087575670613e-16,  -1.127379598314128e-17,   8.525834826678125e-01,  -4.682429612924741e-02,   3.058282742262884e-03,  -1.984521308099038e-04,   1.236758880466881e-05,
  -7.058793803079959e-07,   3.758967057592599e-08,  -1.938378677620761e-09,   9.416009012318913e-11,  -4.240977036533033e-12,   1.887402658712719e-13,  -8.223570136041253e-15,
   3.151383996084199e-16,  -1.161955191586025e-17,   8.532028532860817e-01,  -4.694366471094517e-02,   3.073136479706669e-03,  -1.998682105987024e-04,   1.248108539105582e-05,
  -7.140905750154794e-07,   3.812345162759039e-08,  -1.969473899181533e-09,   9.589169720912006e-11,  -4.333130551101706e-12,   1.930225761704465e-13,  -8.410654452612880e-15,
   3.240480304917819e-16,  -1.195804158357314e-17,   8.537025555730845e-01,  -4.704003325626570e-02,   3.085135299036013e-03,  -2.010129268818496e-04,   1.257290024885607e-05,
  -7.207366720211552e-07,   3.855577678098444e-08,  -1.994682185565549e-09,   9.729587339145968e-11,  -4.407860091362308e-12,   1.965002618685654e-13,  -8.562627008891121e-15,
   3.312594414301252e-16,  -1.223274335534314e-17,   8.540331154305462e-01,  -4.710381329621117e-02,   3.093080020252543e-03,  -2.017712692713894e-04,   1.263375815877724e-05,
  -7.251436527836487e-07,   3.884258840722476e-08,  -2.011417184711649e-09,   9.822825913360818e-11,  -4.457481906514331e-12,   1.988119550490840e-13,  -8.663666938518728e-15,
   3.360414039031666e-16,  -1.241524483352824e-17,   8.542029868786667e-01,  -4.713659880315904e-02,   3.097165005977278e-03,  -2.021613135725801e-04,   1.266506994895759e-05,
  -7.274116086159532e-07,   3.899023293323671e-08,  -2.020035528478690e-09,   9.870848911682923e-11,  -4.483040103331695e-12,   2.000033643531182e-13,  -8.715747752240911e-15,
   3.385024009604703e-16,  -1.250927115943723e-17,   8.542621302147536e-01,  -4.714801510223388e-02,   3.098587617946317e-03,  -2.022971675468356e-04,   1.267597760228672e-05,
  -7.282017502161990e-07,   3.904167823962912e-08,  -2.023039067097349e-09,   9.887586164066053e-11,  -4.491947830845406e-12,   2.004187216106293e-13,  -8.733905562715649e-15,
   3.393598095905393e-16,  -1.254204604238931e-17,   8.542715163034679e-01,  -4.714982694925490e-02,   3.098813404641208e-03,  -2.023187302362644e-04,   1.267770893825605e-05,
  -7.283271708482546e-07,   3.904984457438430e-08,  -2.023515869954677e-09,   9.890243200012902e-11,  -4.493361932846653e-12,   2.004846652081591e-13,  -8.736788411026909e-15,
   3.394959082903984e-16,  -1.254724924935300e-17,   1.647656811123181e-01,  -2.917965576444212e-02,   4.255971708140584e-03,  -4.655186090653535e-04,   4.164650954162488e-05,
  -3.197981777567354e-06,   2.138821488452122e-07,  -1.259847631778164e-08,   6.659948499676402e-10,  -3.198339234592533e-11,   1.394204920590078e-12,  -5.562129589274780e-14,
   2.077476297361867e-15,  -7.179593344352944e-17,   1.652154421041793e-01,  -2.932199069440383e-02,   4.281234779331559e-03,  -4.687428129965514e-04,   4.196972676496353e-05,
  -3.224650026708683e-06,   2.157625231272818e-07,  -1.271456523433267e-08,   6.723260418935174e-10,  -3.229243263089263e-11,   1.408029243961278e-12,  -5.618661051993869e-14,
   2.098143681588575e-15,  -7.251794515684201e-17,   1.660112029557251e-01,  -2.957392021559813e-02,   4.325965045879488e-03,  -4.744528799013059e-04,   4.254225104050562e-05,
  -3.271896440305404e-06,   2.190942600030064e-07,  -1.292027043458561e-08,   6.835458065735345e-10,  -3.284015062083815e-11,   1.432528451125104e-12,  -5.718848792423423e-14,
   2.134792390251498e-15,  -7.379772303857722e-17,   1.669771212563254e-01,  -2.987988488691794e-02,   4.380315258170150e-03,  -4.813933055890323e-04,   4.323831977114094e-05,
  -3.329352011560826e-06,   2.231466110437608e-07,  -1.317048995502254e-08,   6.971954338929706e-10,  -3.350658162631101e-11,   1.462334470638184e-12,  -5.840744540243244e-14,
   2.179417336963296e-15,  -7.535515221934628e-17,   1.679186787509283e-01,  -3.017830600829195e-02,   4.433352668411744e-03,  -4.881685192050113e-04,   4.391800928655948e-05,
  -3.385470141689237e-06,   2.271053466038718e-07,  -1.341495296636315e-08,   7.105330424333837e-10,  -3.415787672467301e-11,   1.491460312722119e-12,  -5.959864836193699e-14,
   2.223062859521070e-15,  -7.687752685033576e-17,   1.686799595426536e-01,  -3.041971346434709e-02,   4.476276714211546e-03,  -4.936535524695695e-04,   4.446840417445754e-05,
  -3.430923555879781e-06,   2.303122742485748e-07,  -1.361300693495089e-08,   7.213400565556570e-10,  -3.468566935815142e-11,   1.515060895914707e-12,  -6.056391948407564e-14,
   2.258456181144284e-15,  -7.811147059330088e-17,   1.691843619929337e-01,  -3.057972370362988e-02,   4.504737266272399e-03,  -4.972912262564873e-04,   4.483349273501054e-05,
  -3.461078857853247e-06,   2.324401070515735e-07,  -1.374442642390592e-08,   7.285117888352310e-10,  -3.503595651077831e-11,   1.530723138509799e-12,  -6.120453037001013e-14,
   2.281957823353130e-15,  -7.893055042614375e-17,   1.694438185945817e-01,  -3.066204919457925e-02,   4.519383208411101e-03,  -4.991634549609532e-04,   4.502141620379979e-05,
  -3.476602387799831e-06,   2.335355632716354e-07,  -1.381208674700714e-08,   7.322043149634245e-10,  -3.521632024724342e-11,   1.538787341698132e-12,  -6.153437538664580e-14,
   2.294062464572293e-15,  -7.935233941442750e-17,   1.695341920558055e-01,  -3.069072765002286e-02,   4.524485657515971e-03,  -4.998157561954894e-04,   4.508689370253789e-05,
  -3.482011445752466e-06,   2.339172791341321e-07,  -1.383566365848162e-08,   7.334910464183614e-10,  -3.527917313041642e-11,   1.541597491887476e-12,  -6.164931815402626e-14,
   2.298281240151939e-15,  -7.949933077286868e-17,   1.695485362716368e-01,  -3.069527968070448e-02,   4.525295573642734e-03,  -4.999192985217330e-04,   4.509728735770595e-05,
  -3.482870071412868e-06,   2.339778727168659e-07,  -1.383940627757580e-08,   7.336953048853844e-10,  -3.528915060968226e-11,   1.542043582214457e-12,  -6.166756450439159e-14,
   2.298950969789517e-15,  -7.952266501234590e-17,   7.020681185837147e-01,  -2.923585438699632e-02,   1.506497163906949e-03,  -7.721399617249482e-05,   4.111778455802824e-06,
  -2.129738214070746e-07,   9.601847150334580e-09,  -4.014478579650817e-10,   1.896016127889888e-11,  -8.786443853669473e-13,   2.797201080357717e-14,  -7.536649360698481e-16,
   5.643293393127770e-17,  -3.130274265436636e-18,   7.022141582492003e-01,  -2.925830071108583e-02,   1.508890125836202e-03,  -7.742076932991725e-05,   4.125905947133426e-06,
  -2.138136420756503e-07,   9.654327026311115e-09,  -4.045396920255499e-10,   1.908965599393421e-11,  -8.833674213379886e-13,   2.832806229628069e-14,  -7.753451790879688e-16,
   5.655379022294205e-17,  -3.105921835856282e-18,   7.024720396469027e-01,  -2.929795613990190e-02,   1.513119154443961e-03,  -7.778627928792096e-05,   4.150895208851236e-06,
  -2.153005315170705e-07,   9.747211943507817e-09,  -4.100088529858384e-10,   1.931937956684143e-11,  -8.917910527306017e-13,   2.895713698155332e-14,  -8.134781296050139e-16,
   5.678612094291515e-17,  -3.064653774344986e-18,   7.027842005250423e-01,  -2.934599077459550e-02,   1.518244230581953e-03,  -7.822937811510032e-05,   4.181216865963825e-06,
  -2.171070565061851e-07,   9.860014316673890e-09,  -4.166455281529916e-10,   1.959926000575706e-11,  -9.021297300160290e-13,   2.971927594672387e-14,  -8.593871855913008e-16,
   5.709919218570347e-17,  -3.017610977349309e-18,   7.030875847899284e-01,  -2.939270888038517e-02,   1.523231413126087e-03,  -7.866070732251346e-05,   4.210762196185514e-06,
  -2.188697858880141e-07,   9.970031034028782e-09,  -4.231129180453370e-10,   1.987316115439174e-11,  -9.123258854733120e-13,   3.046075124302215e-14,  -9.037520093339829e-16,
   5.743627255650100e-17,  -2.974882123592060e-18,   7.033322339388400e-01,  -2.943040674912988e-02,   1.527257528787017e-03,  -7.900902589988872e-05,   4.234642256224013e-06,
  -2.202962703301871e-07,   1.005902619956409e-08,  -4.283407539320130e-10,   2.009538937122629e-11,  -9.206538210920289e-13,   3.105927931042022e-14,  -9.393521695228671e-16,
   5.773123484656408e-17,  -2.942528792953993e-18,   7.034940146797967e-01,  -2.945534740650036e-02,   1.529922086331978e-03,  -7.923960349727738e-05,   4.250460403979289e-06,
  -2.212420308709284e-07,   1.011801303220851e-08,  -4.318039860916120e-10,   2.024300684017728e-11,  -9.262125065239319e-13,   3.145538848580572e-14,  -9.628101042389594e-16,
   5.793746984027025e-17,  -2.922148133003449e-18,   7.035771342624910e-01,  -2.946816509207954e-02,   1.531291755892780e-03,  -7.935814464018211e-05,   4.258595743984262e-06,
  -2.217287041930052e-07,   1.014836152752825e-08,  -4.335852470216035e-10,   2.031905472812965e-11,  -9.290843716479233e-13,   3.165900365730807e-14,  -9.748369494493866e-16,
   5.804685660999449e-17,  -2.911987140305574e-18,   7.036060707561262e-01,  -2.947262791245560e-02,   1.531768687713428e-03,  -7.939942444851162e-05,   4.261429229881673e-06,
  -2.218982514303862e-07,   1.015893351654250e-08,  -4.342056662513872e-10,   2.034556199873000e-11,  -9.300866891900573e-13,   3.172990511225682e-14,  -9.790198740408790e-16,
   5.808548043362731e-17,  -2.908498864865235e-18,   7.036106628622193e-01,  -2.947333617216868e-02,   1.531844379997078e-03,  -7.940597595810675e-05,   4.261878955600805e-06,
  -2.219251636561516e-07,   1.016061156918459e-08,  -4.343041389150517e-10,   2.034977014691232e-11,  -9.302458731506696e-13,   3.174115769248342e-14,  -9.796834988937306e-16,
   5.809163559834503e-17,  -2.907947613403551e-18,   9.206819874769410e-02,  -9.655236791544048e-03,   1.213604380038888e-03,  -1.191686330990340e-04,   9.473132768283535e-06,
  -6.613463035257344e-07,   4.214668918619695e-08,  -2.406607660212881e-09,   1.208948164909656e-10,  -5.534200020924970e-12,   2.438049016618375e-13,  -9.935658921077231e-15,
   3.353285659753992e-16,  -1.028733618470036e-17,   9.219340275117419e-02,  -9.691097537578476e-03,   1.219292741931464e-03,  -1.198315234437542e-04,   9.536462486901750e-06,
  -6.664074914604906e-07,   4.248702211180420e-08,  -2.426721264254928e-09,   1.219967610897606e-10,  -5.588761468610088e-12,   2.460594701808344e-13,  -1.001986661839189e-14,
   3.391873848840566e-16,  -1.045086517137523e-17,   9.241480471927710e-02,  -9.754533548483340e-03,   1.229359878275199e-03,  -1.210051623605032e-04,   9.648607011978745e-06,
  -6.753709449813026e-07,   4.308994162010556e-08,  -2.462364227970532e-09,   1.239490512259544e-10,  -5.685398174237204e-12,   2.500572527155249e-13,  -1.016941748673344e-14,
   3.460094597753124e-16,  -1.073885468823167e-17,   9.268334232152201e-02,  -9.831513081771990e-03,   1.241584332645613e-03,  -1.224311061716497e-04,   9.784894310273024e-06,
  -6.862659282110290e-07,   4.382309661287594e-08,  -2.505724273906301e-09,   1.263232832513970e-10,  -5.802872606853133e-12,   2.549248156910102e-13,  -1.035189959348944e-14,
   3.542817469874339e-16,  -1.108618981581749e-17,   9.294489068679347e-02,  -9.906529178989104e-03,   1.253505365725858e-03,  -1.238224966412763e-04,   9.917915174197775e-06,
  -6.969017406946553e-07,   4.453913743546056e-08,  -2.548090813660658e-09,   1.286423446941028e-10,  -5.917567840859062e-12,   2.596852025855668e-13,  -1.053076889605281e-14,
   3.623371122991864e-16,  -1.142249192406345e-17,   9.315620605089690e-02,  -9.967166460363762e-03,   1.263147418738170e-03,  -1.249484920913089e-04,   1.002558943971248e-05,
  -7.055123473212706e-07,   4.511906688902387e-08,  -2.582417233741151e-09,   1.305207649643974e-10,  -6.010435245463606e-12,   2.635452605011122e-13,  -1.067609366064115e-14,
   3.688446649220839e-16,  -1.169282209713834e-17,   9.329614143262743e-02,  -1.000733524798245e-02,   1.269537673813704e-03,  -1.256950379397944e-04,   1.009699123150385e-05,
  -7.112229705141933e-07,   4.550379424369306e-08,  -2.605195979539401e-09,   1.317670097540973e-10,  -6.072031700519933e-12,   2.661082517866666e-13,  -1.077272330991058e-14,
   3.731538797738073e-16,  -1.187117969020117e-17,   9.336809846454847e-02,  -1.002799505167577e-02,   1.272825248588950e-03,  -1.260792019830948e-04,   1.013373772201854e-05,
  -7.141621216720201e-07,   4.570184123112948e-08,  -2.616923840482411e-09,   1.324085715807463e-10,  -6.103736181063329e-12,   2.674282888012809e-13,  -1.082253319686132e-14,
   3.753697370445676e-16,  -1.196269445157349e-17,   9.339315866872132e-02,  -1.003519085861612e-02,   1.273970454984363e-03,  -1.262130376227700e-04,   1.014654014596557e-05,
  -7.151861518182127e-07,   4.577084837721424e-08,  -2.621010592460975e-09,   1.326321210067255e-10,  -6.114782658088927e-12,   2.678883480206899e-13,  -1.083989957522691e-14,
   3.761414470205255e-16,  -1.199453452559397e-17,   9.339713608559698e-02,  -1.003633297025437e-02,   1.274152227915020e-03,  -1.262342813764853e-04,   1.014857230665506e-05,
  -7.153487002997329e-07,   4.578180242678419e-08,  -2.621659329909246e-09,   1.326676069996506e-10,  -6.116536125441733e-12,   2.679613819656119e-13,  -1.084265678487360e-14,
   3.762639287058596e-16,  -1.199958652101501e-17,   6.045965326381397e-01,  -2.002917597875053e-02,   8.665015430703397e-04,  -3.587611326982769e-05,   1.501199757281649e-06,
  -7.141101515531714e-08,   3.404117614721565e-09,  -1.235913929815703e-10,   2.972954433123967e-12,  -1.120586851139492e-13,   1.041208093940259e-14,  -5.163000319299670e-16,
  -1.656209932491338e-18,   1.106646807709418e-18,   6.046795183709860e-01,  -2.003950984252362e-02,   8.673736354155436e-04,  -3.594517423775998e-05,   1.506091185163319e-06,
  -7.166149089178329e-08,   3.412826231256916e-09,  -1.240325145177421e-10,   3.016767924395176e-12,  -1.145037620142152e-13,   1.040763480961336e-14,  -5.103923662136889e-16,
  -1.538793118693648e-18,   1.065429555405025e-18,   6.048260178031785e-01,  -2.005776026970521e-02,   8.689147181511497e-04,  -3.606722657374350e-05,   1.514732499070239e-06,
  -7.210419596022028e-08,   3.428286174290603e-09,  -1.248174374210293e-10,   3.094067613535871e-12,  -1.187955350674858e-13,   1.040043946094167e-14,  -5.001981071874673e-16,
  -1.326075423967788e-18,   9.938383806362315e-19,   6.050032856212981e-01,  -2.007985646970526e-02,   8.707820722578851e-04,  -3.621514333692041e-05,   1.525199324925569e-06,
  -7.264078284457701e-08,   3.447139837470455e-09,  -1.257777149209468e-10,   3.187523940160725e-12,  -1.239472887305491e-13,   1.039286434733500e-14,  -4.882586710436255e-16,
  -1.059699889569644e-18,   9.091837226570614e-19,   6.051754990690951e-01,  -2.010133600804852e-02,   8.725989141906031e-04,  -3.635908422024916e-05,   1.535378921617303e-06,
  -7.316302389367559e-08,   3.465609491408445e-09,  -1.267215514711574e-10,   3.278235791217543e-12,  -1.289096348397966e-13,   1.038671095986139e-14,  -4.770683176106486e-16,
  -7.918707026460760e-19,   8.289751756491923e-19,   6.053143215974299e-01,  -2.011866040084631e-02,   8.740654410629807e-04,  -3.647528928801194e-05,   1.543592853041717e-06,
  -7.358469503773313e-08,   3.480607941793852e-09,  -1.274901816475908e-10,   3.351303572525558e-12,  -1.328799364045291e-13,   1.038262886222828e-14,  -4.683363729055427e-16,
  -5.697345183669606e-19,   7.657514584907481e-19,   6.054060969734005e-01,  -2.013011822496221e-02,   8.750359183413635e-04,  -3.655219718176175e-05,   1.549027050721406e-06,
  -7.386380067308829e-08,   3.490577177336092e-09,  -1.280021227487557e-10,   3.399581897939591e-12,  -1.354902993048754e-13,   1.038036577843858e-14,  -4.627033899645551e-16,
  -4.199241387666554e-19,   7.246466441993446e-19,   6.054532416131572e-01,  -2.013600551468270e-02,   8.755347450284454e-04,  -3.659173071957829e-05,   1.551819811254012e-06,
  -7.400728154799278e-08,   3.495714956375333e-09,  -1.282662766998913e-10,   3.424374155522914e-12,  -1.368268290382440e-13,   1.037933911472839e-14,  -4.598525999252394e-16,
  -3.420732709985623e-19,   7.037433819715940e-19,   6.054696529016197e-01,  -2.013805514129136e-02,   8.757084363240623e-04,  -3.660549672690474e-05,   1.552792182408652e-06,
  -7.405724479561336e-08,   3.497506088870393e-09,  -1.283584162776477e-10,   3.433003184546619e-12,  -1.372913852395973e-13,   1.037900346089996e-14,  -4.588670160940693e-16,
  -3.148324826155508e-19,   6.965004426571725e-19,   6.054722572498686e-01,  -2.013838041261874e-02,   8.757360020688684e-04,  -3.660768148745435e-05,   1.552946499771275e-06,
  -7.406517438747188e-08,   3.497790453720830e-09,  -1.283730469720010e-10,   3.434372486044594e-12,  -1.373650738403580e-13,   1.037895122892920e-14,  -4.587109330833138e-16,
  -3.105029400129221e-19,   6.953526337392921e-19,   6.646188111199153e-02,  -3.826341725239883e-03,   3.867969523012408e-04,  -3.533572434150773e-05,   2.571030073668552e-06,
  -1.549096126205909e-07,   8.574545299268072e-09,  -4.732701883731378e-10,   2.486297077724982e-11,  -1.100452850104083e-12,   3.892438479300987e-14,  -1.361580100544892e-15,
   6.866072383852435e-17,  -3.351214127280339e-18,   6.650119526499119e-02,  -3.836823004880609e-03,   3.883163120708751e-04,  -3.548937784838252e-05,   2.583909942493739e-06,
  -1.559042656298246e-07,   8.643547818697674e-09,  -4.771946007995147e-10,   2.504176241646738e-11,  -1.108385666441638e-12,   3.937397947566124e-14,  -1.385154401450115e-15,
   6.919526616138704e-17,  -3.332446739075259e-18,   6.657069045204687e-02,  -3.855354012099487e-03,   3.910033323787178e-04,  -3.576127957089321e-05,   2.606717053299043e-06,
  -1.576657333268048e-07,   8.765694326712419e-09,  -4.841417229094221e-10,   2.535880689360162e-11,  -1.122481205775032e-12,   4.016998298822585e-14,  -1.426657615170856e-15,
   7.013806493335961e-17,  -3.300648373963129e-18,   6.665493782998717e-02,  -3.877824479175178e-03,   3.942629091269492e-04,  -3.609139546049548e-05,   2.634433021188204e-06,
  -1.598066340883897e-07,   8.914063292821192e-09,  -4.925806932422485e-10,   2.574485321439797e-11,  -1.139692469864471e-12,   4.113710026130846e-14,  -1.476688631941463e-15,
   7.127771793151853e-17,  -3.264418966159639e-18,   6.673694728763271e-02,  -3.899704110765278e-03,   3.974381767875596e-04,  -3.641326274503849e-05,   2.661483450229154e-06,
  -1.618964459951789e-07,   9.058799898986601e-09,  -5.008135828803881e-10,   2.612242723946708e-11,  -1.156575223577352e-12,   4.208075957868497e-14,  -1.525102005848198e-15,
   7.238405243551563e-17,  -3.231543963729271e-18,   6.680317354064789e-02,  -3.917377240083808e-03,   4.000039835526852e-04,  -3.667355848918601e-05,   2.683378558823578e-06,
  -1.635882069356932e-07,   9.175903308655569e-09,  -5.074750622785317e-10,   2.642861281086952e-11,  -1.170300469971278e-12,   4.284439865108460e-14,  -1.563996092878080e-15,
   7.327555313796811e-17,  -3.206683979528780e-18,   6.684701338332141e-02,  -3.929078477566609e-03,   4.017032771315782e-04,  -3.684604993003817e-05,   2.697897313046286e-06,
  -1.647101340544065e-07,   9.253531495943006e-09,  -5.118911981876012e-10,   2.663192457958684e-11,  -1.179430853364640e-12,   4.335068241531769e-14,  -1.589646009955812e-15,
   7.386487001528131e-17,  -3.191043415748595e-18,   6.686955161094048e-02,  -3.935094791718641e-03,   4.025771396423409e-04,  -3.693478515929434e-05,   2.705369140269609e-06,
  -1.652875491964378e-07,   9.293474265920523e-09,  -5.141635469618875e-10,   2.673664149448653e-11,  -1.184138585444255e-12,   4.361120451659026e-14,  -1.602803208887456e-15,
   7.416760547057548e-17,  -3.183252654128862e-18,   6.687740012977444e-02,  -3.937189967126964e-03,   4.028814857492881e-04,  -3.696569458946532e-05,   2.707972288109915e-06,
  -1.654887233021083e-07,   9.307388984371092e-09,  -5.149551687322603e-10,   2.677313802937303e-11,  -1.185780153111978e-12,   4.370196460577322e-14,  -1.607380297366788e-15,
   7.427299208614433e-17,  -3.180579281799144e-18,   6.687864576597753e-02,  -3.937522496849586e-03,   4.029297903207029e-04,  -3.697060064541620e-05,   2.708385491020545e-06,
  -1.655206563354816e-07,   9.309597641448470e-09,  -5.150808219348100e-10,   2.677893184694637e-11,  -1.186040789607251e-12,   4.371637092191851e-14,  -1.608106505263211e-15,
   7.428971632598537e-17,  -3.180156868170213e-18,   5.360806424783058e-01,  -1.449575411772362e-02,   5.445388456883336e-04,  -1.985467544355758e-05,   6.565404645830939e-07,
  -2.236156437487823e-08,   1.008759853321911e-09,  -5.150437282078255e-11,   1.933548394525998e-12,  -2.533531876004438e-14,  -1.442880740314337e-15,   2.967086173735143e-17,
   6.824327016607268e-18,  -5.236041294517824e-19,   5.361324512720480e-01,  -1.450141531543108e-02,   5.449165200221803e-04,  -1.987650464855395e-05,   6.580178180254302e-07,
  -2.246431872580708e-08,   1.013742439651395e-09,  -5.158954887720947e-11,   1.928842832437925e-12,  -2.530455136455545e-14,  -1.399983205481461e-15,   2.643804499653849e-17,
   6.844231271601151e-18,  -5.126198709916588e-19,   5.362238985047932e-01,  -1.451140973043796e-02,   5.455836217533192e-04,  -1.991510136100923e-05,   6.606302931738467e-07,
  -2.264576678914313e-08,   1.022525088708852e-09,  -5.173984669728791e-11,   1.920687349589580e-12,  -2.526321195830019e-14,  -1.324230689936722e-15,   2.079730322195646e-17,
   6.875569182450863e-18,  -4.933602883972002e-19,   5.363345283275950e-01,  -1.452350386484881e-02,   5.463914655858996e-04,  -1.996190724231282e-05,   6.637989731709546e-07,
  -2.286540836590090e-08,   1.033129686014701e-09,  -5.192161771414588e-11,   1.911077329468412e-12,  -2.523512515400267e-14,  -1.232541411059415e-15,   1.408439382428555e-17,
   6.907134487154910e-18,  -4.702845539942575e-19,   5.364419791453090e-01,  -1.453525385245951e-02,   5.471769414884741e-04,  -2.000748633581854e-05,   6.668851668774707e-07,
  -2.307887633574740e-08,   1.043408515057577e-09,  -5.209813848358410e-11,   1.902011731450126e-12,  -2.523056514560202e-14,  -1.143453818524670e-15,   7.679958553178183e-18,
   6.931304826775034e-18,  -4.481119505322155e-19,   5.365285783512108e-01,  -1.454472610073746e-02,   5.478105971836341e-04,  -2.004430517498225e-05,   6.693785908949553e-07,
  -2.325101807651976e-08,   1.051677786272319e-09,  -5.224040571235891e-11,   1.894897554186020e-12,  -2.524300010875803e-14,  -1.071641410214884e-15,   2.600628037477214e-18,
   6.946246587254073e-18,  -4.304178989966584e-19,   5.365858202935144e-01,  -1.455098843513842e-02,   5.482297402824579e-04,  -2.006868384423485e-05,   6.710297370305303e-07,
  -2.336485185999179e-08,   1.057136558319135e-09,  -5.233445329977889e-11,   1.890289164121289e-12,  -2.525903952855653e-14,  -1.024171477449081e-15,  -7.167348529466547e-19,
   6.953945328676620e-18,  -4.188097200484680e-19,   5.366152225651525e-01,  -1.455420544691845e-02,   5.484451248911146e-04,  -2.008121875152461e-05,   6.718787726141814e-07,
  -2.342333743255569e-08,   1.059938241020861e-09,  -5.238276537021547e-11,   1.887951154312373e-12,  -2.526968204997883e-14,  -9.997888594833387e-16,  -2.408351525526288e-18,
   6.957235678317087e-18,  -4.128745772039395e-19,   5.366254572179459e-01,  -1.455532531716131e-02,   5.485201129127635e-04,  -2.008558407614087e-05,   6.721744611941032e-07,
  -2.344369808787232e-08,   1.060913129884642e-09,  -5.239958323717566e-11,   1.887141944974364e-12,  -2.527376802051183e-14,  -9.913016231839507e-16,  -2.995226411544842e-18,
   6.958276124945933e-18,  -4.108129971771348e-19,   5.366270813602082e-01,  -1.455550303273524e-02,   5.485320134969367e-04,  -2.008627690866087e-05,   6.722213911574860e-07,
  -2.344692924363352e-08,   1.061067818891294e-09,  -5.240225211857110e-11,   1.887013750907332e-12,  -2.527443450579541e-14,  -9.899547867513209e-16,  -3.088264883248266e-18,
   6.958436271166714e-18,  -4.104860528005717e-19,   5.540705051095893e-02,  -1.908734602068939e-03,   1.343046077258108e-04,  -1.107262673628086e-05,   7.987163209260048e-07,
  -4.623601818599728e-08,   2.165021987003123e-09,  -9.049946050718699e-11,   4.147282541481556e-12,  -2.222087644026308e-13,   1.098629763948790e-14,  -3.774934594086611e-16,
   5.156162358638487e-18,   1.337270861928408e-19,   5.542058018183112e-02,  -1.912007521701873e-03,   1.347719508319274e-04,  -1.111759190636910e-05,   8.019028207601554e-07,
  -4.642703782600885e-08,   2.176894179520324e-09,  -9.130011314510469e-11,   4.194824949317658e-12,  -2.241532726917635e-13,   1.102269403389721e-14,  -3.773192761001091e-16,
   5.246492504803931e-18,   1.190216002088249e-19,   5.544449131211887e-02,  -1.917793208203222e-03,   1.355980763663253e-04,  -1.119708325516820e-05,   8.075394126708005e-07,
  -4.676540150483344e-08,   2.197945049145124e-09,  -9.271821432389187e-11,   4.278843268773382e-12,  -2.275844748202329e-13,   1.108742069969453e-14,  -3.770980547407822e-16,
   5.410499691517529e-18,   9.316700247264407e-20,   5.547346946512134e-02,  -1.924807366601515e-03,   1.365995834633289e-04,  -1.129346081725641e-05,   8.143791281422546e-07,
  -4.717678805801724e-08,   2.223574436640623e-09,  -9.444209860658987e-11,   4.380660317225623e-12,  -2.317339139500846e-13,   1.116656456911010e-14,  -3.769769935474052e-16,
   5.616575591599131e-18,   6.206715491968051e-20,   5.550166866731290e-02,  -1.931635517603275e-03,   1.375745024959548e-04,  -1.138729121928557e-05,   8.210441239964463e-07,
  -4.757850145572234e-08,   2.248637933153437e-09,  -9.612514802952987e-11,   4.479735804300437e-12,  -2.357628411038540e-13,   1.124433227615928e-14,  -3.770122855216642e-16,
   5.824604164513906e-18,   3.205300038264118e-20,   5.552443416986489e-02,  -1.937149770931491e-03,   1.383618040848224e-04,  -1.146307294552242e-05,   8.264314278693980e-07,
  -4.790380303958655e-08,   2.268960004536846e-09,  -9.748782211107271e-11,   4.559718015708045e-12,  -2.390092302472013e-13,   1.130766507571788e-14,  -3.771498231025478e-16,
   5.997798307191497e-18,   8.004582186037347e-21,   5.553950103102788e-02,  -1.940800151220071e-03,   1.388829804440219e-04,  -1.151324299774778e-05,   8.300001391235472e-07,
  -4.811958441138606e-08,   2.282452799162526e-09,  -9.839159832886096e-11,   4.612651707234563e-12,  -2.411548360001611e-13,   1.134985456546971e-14,  -3.772939689746814e-16,
   6.114946602489279e-18,  -7.820777215988407e-21,   5.554724595907710e-02,  -1.942676857724618e-03,   1.391509209620049e-04,  -1.153903710374144e-05,   8.318355946049441e-07,
  -4.823065495371309e-08,   2.289401905238162e-09,  -9.885676542536915e-11,   4.639861420983211e-12,  -2.422568650759220e-13,   1.137162725447756e-14,  -3.773844328913609e-16,
   6.175935494662905e-18,  -1.592732448460451e-20,   5.554994282673193e-02,  -1.943330390984389e-03,   1.392442265549900e-04,  -1.154801966129385e-05,   8.324748802927014e-07,
  -4.826935494596028e-08,   2.291823776369029e-09,  -9.901883584317620e-11,   4.649336116447603e-12,  -2.426404631906127e-13,   1.137922247164014e-14,  -3.774185335963109e-16,
   6.197294217175543e-18,  -1.874558714403342e-20,   5.555037083825704e-02,  -1.943434113304575e-03,   1.392590350729618e-04,  -1.154944529187059e-05,   8.325763469599447e-07,
  -4.827549804292826e-08,   2.292208244533977e-09,  -9.904456200792470e-11,   4.650839815212248e-12,  -2.427013362345989e-13,   1.138042853863622e-14,  -3.774240689373155e-16,
   6.200689754585998e-18,  -1.919264963949338e-20,   4.855169416613925e-01,  -1.094130254958738e-02,   3.577463510095411e-04,  -1.199076832153195e-05,   3.660888540119426e-07,
  -9.585029663427133e-09,   2.453493631523058e-10,  -1.023273164598809e-11,   6.245903276466734e-13,  -3.063979834347434e-14,   8.254491604185181e-16,   9.370387702192881e-18,
  -1.963567694015536e-18,   7.040191647051466e-20,   4.855508979144142e-01,  -1.094470729004572e-02,   3.579543485023266e-04,  -1.199993881799002e-05,   3.664541121547228e-07,
  -9.606789701032902e-09,   2.470523706100548e-10,  -1.033446935984339e-11,   6.277151126485765e-13,  -3.057766491341894e-14,   8.141844764809606e-16,   9.746944073908016e-18,
  -1.945451150383344e-18,   6.787778905778902e-20,   4.856108303638709e-01,  -1.095071713786029e-02,   3.583215351990478e-04,  -1.201613738483680e-05,   3.671005874478198e-07,
  -9.645347623800912e-09,   2.500638083646314e-10,  -1.051380701015203e-11,   6.331910173850206e-13,  -3.046659172629195e-14,   7.944063277639473e-16,   1.039654822297888e-17,
  -1.912801666723907e-18,   6.343591315633444e-20,   4.856833287954097e-01,  -1.095798794420659e-02,   3.587658349192628e-04,  -1.203575407455036e-05,   3.678856788530986e-07,
  -9.692248284214634e-09,   2.537162217627186e-10,  -1.073035431714356e-11,   6.397482826085643e-13,  -3.032987161108622e-14,   7.706606881320396e-16,   1.115681745152806e-17,
  -1.872174776103727e-18,   5.808625677793690e-20,   4.857537378001698e-01,  -1.096505012640645e-02,   3.591974616985778e-04,  -1.205482831263653e-05,   3.686513636848224e-07,
  -9.738067403304774e-09,   2.572733196580819e-10,  -1.094024719807123e-11,   6.460469841195864e-13,  -3.019467703816763e-14,   7.477900169803516e-16,   1.186851832963049e-17,
  -1.831555714347813e-18,   5.291677335874577e-20,   4.858104790101468e-01,  -1.097074206041319e-02,   3.595453960817204e-04,  -1.207021633942061e-05,   3.692707242510833e-07,
  -9.775185405627979e-09,   2.601469895637886e-10,  -1.110909731229707e-11,   6.510733684518781e-13,  -3.008403487919245e-14,   7.294974954444317e-16,   1.242302633439790e-17,
  -1.798003952315341e-18,   4.877034532699347e-20,   4.858479826961643e-01,  -1.097450452763186e-02,   3.597754135865490e-04,  -1.208039530926999e-05,   3.696812295590571e-07,
  -9.799813458112017e-09,   2.620498146976619e-10,  -1.122055360652738e-11,   6.543714157138998e-13,  -3.001009215326746e-14,   7.174754407337024e-16,   1.278023886614404e-17,
  -1.775433537359982e-18,   4.603966642555936e-20,   4.858672457593363e-01,  -1.097643714877819e-02,   3.598935722349025e-04,  -1.208562605492404e-05,   3.698924284230995e-07,
  -9.812492403044323e-09,   2.630282254849591e-10,  -1.127775542322596e-11,   6.560579350726333e-13,  -2.997186486013719e-14,   7.113219068647692e-16,   1.296084544118983e-17,
  -1.763720157970090e-18,   4.464025833572225e-20,   4.858739509425976e-01,  -1.097710988122770e-02,   3.599347037965806e-04,  -1.208744719896152e-05,   3.699659994072549e-07,
  -9.816910401375293e-09,   2.633689640213277e-10,  -1.129765924025472e-11,   6.566438013382909e-13,  -2.995851932611853e-14,   7.091833701342054e-16,   1.302325566314607e-17,
  -1.759623841118499e-18,   4.415365436175057e-20,   4.858750149864656e-01,  -1.097721663773420e-02,   3.599412310635875e-04,  -1.208773621485420e-05,   3.699776770192953e-07,
  -9.817611713035696e-09,   2.634230437225044e-10,  -1.130081742626454e-11,   6.567367160551408e-13,  -2.995639967228632e-14,   7.088441687285074e-16,   1.303313787835799e-17,
  -1.758972894956912e-18,   4.407645959985975e-20,   4.931241253330819e-02,  -1.203904980432420e-03,   5.487708218351644e-05,  -3.530140480939292e-06,   2.432095059467577e-07,
  -1.475656837890771e-08,   7.282088602919075e-10,  -2.823964668482516e-11,   8.610299731037911e-13,  -2.492099159012886e-14,   1.173612676169952e-15,  -7.824762989819471e-17,
   4.229609642163806e-18,  -1.414209159185367e-19,   4.931784398630537e-02,  -1.204948364628612e-03,   5.501984348478599e-05,  -3.544456780068120e-06,   2.442619177858665e-07,
  -1.481371355073264e-08,   7.305912737012196e-10,  -2.833534009071542e-11,   8.668233255595249e-13,  -2.536008282136144e-14,   1.199806741819251e-15,  -7.917911156700737e-17,
   4.230888758727271e-18,  -1.395350055898055e-19,   4.932743946987127e-02,  -1.206792790468981e-03,   5.527223609222315e-05,  -3.569762158456534e-06,   2.461216880192593e-07,
  -1.491470604826841e-08,   7.348079543484226e-10,  -2.850542326193942e-11,   8.771356257406145e-13,  -2.613866707564245e-14,   1.246027142732179e-15,  -8.081174871918265e-17,
   4.232603251169444e-18,  -1.362240259128861e-19,   4.933906223561958e-02,  -1.209028822633880e-03,   5.557826497701371e-05,  -3.600436876069240e-06,   2.483752806580497e-07,
  -1.503709963658690e-08,   7.399288933692434e-10,  -2.871319502969416e-11,   8.897585448897992e-13,  -2.708658916241324e-14,   1.301916536464753e-15,  -8.276731070566515e-17,
   4.233769135218561e-18,  -1.322499893398593e-19,   4.935036618861745e-02,  -1.211205536210494e-03,   5.587622601649934e-05,  -3.630294202879086e-06,   2.505680049670419e-07,
  -1.515620420177869e-08,   7.449235057277940e-10,  -2.891710992136538e-11,   9.021730494131526e-13,  -2.801352999587236e-14,   1.356169929311752e-15,  -8.464631623854329e-17,
   4.233973495153511e-18,  -1.284244776440025e-19,   4.935948741415822e-02,  -1.212963382470956e-03,   5.611688621450300e-05,  -3.654403445144640e-06,   2.523380096143151e-07,
  -1.525236015613451e-08,   7.489639082350339e-10,  -2.908297344847418e-11,   9.122889245641646e-13,  -2.876504458838014e-14,   1.399872026942175e-15,  -8.614617635927477e-17,
   4.233489564549394e-18,  -1.253668801815365e-19,   4.936552186659383e-02,  -1.214127050833444e-03,   5.627621733994710e-05,  -3.670362131818009e-06,   2.535093511434908e-07,
  -1.531600008622743e-08,   7.516420114242055e-10,  -2.919335528532479e-11,   9.190295741022517e-13,  -2.926396280313511e-14,   1.428747158295403e-15,  -8.713050948080507e-17,
   4.232858678815769e-18,  -1.233586988257955e-19,   4.936862310913522e-02,  -1.214725304806848e-03,   5.635813655602576e-05,  -3.678566263194905e-06,   2.541114343239707e-07,
  -1.534871382149488e-08,   7.530199155116786e-10,  -2.925028406985401e-11,   9.225086178816048e-13,  -2.952089961174413e-14,   1.443575038089375e-15,  -8.763393131093678e-17,
   4.232439845968486e-18,  -1.223312630187436e-19,   4.936970288537636e-02,  -1.214933636841237e-03,   5.638666442914126e-05,  -3.681423153148859e-06,   2.543210814493945e-07,
  -1.536010517473299e-08,   7.534999176927272e-10,  -2.927013729736549e-11,   9.237223005701639e-13,  -2.961044298534488e-14,   1.448735865731709e-15,  -8.780882128075679e-17,
   4.232279090299125e-18,  -1.219742764685600e-19,   4.936987424810679e-02,  -1.214966701216461e-03,   5.639119212857129e-05,  -3.681876567142085e-06,   2.543543536716947e-07,
  -1.536191306497546e-08,   7.535761069126143e-10,  -2.927328956660552e-11,   9.239150267795926e-13,  -2.962465770101816e-14,   1.449554810572282e-15,  -8.783655822712538e-17,
   4.232252872045016e-18,  -1.219176572868281e-19,   4.466879244060556e-01,  -8.568160180153767e-03,   2.435195789297826e-04,  -7.414614329404457e-06,   2.182373177206987e-07,
  -5.670605291109892e-09,   1.170590022240324e-10,  -1.848925005835717e-12,   5.583643051832717e-14,  -4.809343584535779e-15,   3.225149790188822e-16,  -1.384420156188884e-17,
   3.074850658010825e-19,   5.458250488864888e-21,   4.467110026671470e-01,  -8.570264386717584e-03,   2.436432795809843e-04,  -7.419963855026493e-06,   2.184040566880205e-07,
  -5.674536004972067e-09,   1.172348181218736e-10,  -1.866946746572010e-12,   5.724558413812000e-14,  -4.878389867411250e-15,   3.240777896919953e-16,  -1.378678937928728e-17,
   3.001686672787356e-19,   5.783227887192956e-21,   4.467517341638847e-01,  -8.573978521480147e-03,   2.438616280994160e-04,  -7.429406264367923e-06,   2.186984828005609e-07,
  -5.681501534797382e-09,   1.175480839143570e-10,  -1.898934066083241e-12,   5.973711889194369e-14,  -4.999964891496632e-15,   3.267984673808910e-16,  -1.368362541792317e-17,
   2.872464355295190e-19,   6.351316735400038e-21,   4.468010033989221e-01,  -8.578471789280444e-03,   2.441257884371663e-04,  -7.440829406589248e-06,   2.190548708668516e-07,
  -5.689975212902549e-09,   1.179320717692365e-10,  -1.937932968957204e-12,   6.275845193263206e-14,  -5.146529188705596e-15,   3.300253474874973e-16,  -1.355573064900469e-17,
   2.716018212266664e-19,   7.029063993895613e-21,   4.468488501666543e-01,  -8.582835971825357e-03,   2.443823679690196e-04,  -7.451924344902304e-06,   2.194012313764838e-07,
  -5.698254859476916e-09,   1.183102776336173e-10,  -1.976126348616961e-12,   6.570034457915570e-14,  -5.288338101484116e-15,   3.330919476876024e-16,  -1.342830504686906e-17,
   2.563971873410975e-19,   7.677271906717562e-21,   4.468874071184944e-01,  -8.586353274377749e-03,   2.445891635061982e-04,  -7.460866273649435e-06,   2.196805330132448e-07,
  -5.704963384227348e-09,   1.186188572986035e-10,  -2.007133227458140e-12,   6.807654696772646e-14,  -5.402233851502741e-15,   3.355150519191387e-16,  -1.332333187191699e-17,
   2.441381665272248e-19,   8.192405166458983e-21,   4.469128908491504e-01,  -8.588678216031131e-03,   2.447258585202796e-04,  -7.466776900695773e-06,   2.198652276043118e-07,
  -5.709415206428350e-09,   1.188246742493591e-10,  -2.027738749348540e-12,   6.964972871601059e-14,  -5.477324003310453e-15,   3.370930250414023e-16,  -1.325283946496683e-17,
   2.360333131393693e-19,   8.529310894920251e-21,   4.469259798150423e-01,  -8.589872423226900e-03,   2.447960728647254e-04,  -7.469812897842651e-06,   2.199601196827644e-07,
  -5.711707305884361e-09,   1.189309632481481e-10,  -2.038356729746214e-12,   7.045856300126257e-14,  -5.515833379405414e-15,   3.378962225520723e-16,  -1.321629117522252e-17,
   2.318699127154372e-19,   8.701243739294460e-21,   4.469305358441720e-01,  -8.590288115936734e-03,   2.448205139851596e-04,  -7.470869701254209e-06,   2.199931545332268e-07,
  -5.712506028915841e-09,   1.189680524252376e-10,  -2.042058152080242e-12,   7.074023266875710e-14,  -5.529228446106401e-15,   3.381746416658752e-16,  -1.320351511384147e-17,
   2.304206312165305e-19,   8.760913327974413e-21,   4.469312588372384e-01,  -8.590354082446884e-03,   2.448243925671156e-04,  -7.471037405998834e-06,   2.199983970318794e-07,
  -5.712632819763180e-09,   1.189739424453620e-10,  -2.042645789109659e-12,   7.078493675536882e-14,  -5.531353655700783e-15,   3.382187687692801e-16,  -1.320148511656026e-17,
   2.301906423365625e-19,   8.770373835281813e-21,   4.517673529358828e-02,  -8.855797744138755e-04,   2.858179480004680e-05,  -1.271482921001827e-06,   7.217031406310138e-08,
  -4.274605481541113e-09,   2.273603938463150e-10,  -1.009477955535562e-11,   3.552089947086503e-13,  -9.113691710419407e-15,   1.382226909342347e-16,  -9.591638116468051e-19,
   1.520960878235662e-19,  -1.918621479967656e-20,   4.517950013559116e-02,  -8.859521369732853e-04,   2.862426463928632e-05,  -1.275662108662420e-06,   7.250124295492516e-08,
  -4.294974773904842e-09,   2.283060311487505e-10,  -1.012586379476686e-11,   3.558412515994252e-13,  -9.125167906171652e-15,   1.396714122671958e-16,  -1.123329779928420e-18,
   1.629996827769372e-19,  -1.962542071709519e-20,   4.518438220637428e-02,  -8.866101622457564e-04,   2.869935732658109e-05,  -1.283052029368404e-06,   7.308625860072473e-08,
  -4.330966637601915e-09,   2.299760035454027e-10,  -1.018074880237493e-11,   3.569622957417479e-13,  -9.146130163879721e-15,   1.422829458124211e-16,  -1.415552509149858e-18,
   1.822759421651376e-19,  -2.039587544332514e-20,   4.519029157272501e-02,  -8.874075365991973e-04,   2.879042311090723e-05,  -1.292014759470124e-06,   7.379551929304333e-08,
  -4.374573557279170e-09,   2.319977142527681e-10,  -1.024717973543228e-11,   3.583272408665204e-13,  -9.172699750105297e-15,   1.455351468360752e-16,  -1.773239044889571e-18,
   2.056455768733692e-19,  -2.131970728137901e-20,   4.519603448745594e-02,  -8.881833796033507e-04,   2.887910394628275e-05,  -1.300743677905351e-06,   7.448599969875489e-08,
  -4.416995650067512e-09,   2.339628405264380e-10,  -1.031173787548568e-11,   3.596622809607079e-13,  -9.199781682620693e-15,   1.487912267898297e-16,  -2.124982327120850e-18,
   2.283933102065503e-19,  -2.220826192424694e-20,   4.520066535782415e-02,  -8.888096560690003e-04,   2.895074195516399e-05,  -1.307795706099245e-06,   7.504363445794103e-08,
  -4.451234324604657e-09,   2.355477085401837e-10,  -1.036379513755974e-11,   3.607450363744588e-13,  -9.222528287676582e-15,   1.514852409759712e-16,  -2.411554229529655e-18,
   2.467604340294199e-19,  -2.291805952961595e-20,   4.520372753785062e-02,  -8.892241098786677e-04,   2.899817608769441e-05,  -1.312465423963573e-06,   7.541279189178215e-08,
  -4.473889977935483e-09,   2.365958396040011e-10,  -1.039821866508725e-11,   3.614641061841637e-13,  -9.238016664141393e-15,   1.533001789343991e-16,  -2.602481469642285e-18,
   2.589168709423769e-19,  -2.338410874266242e-20,   4.520530078970733e-02,  -8.894371441326503e-04,   2.902256581294441e-05,  -1.314866599858509e-06,   7.560258299737161e-08,
  -4.485534437963354e-09,   2.371343774189792e-10,  -1.041590463770493e-11,   3.618345077248909e-13,  -9.246112824443221e-15,   1.542430008385312e-16,  -2.701014408956675e-18,
   2.651657433221809e-19,  -2.362252184194243e-20,   4.520584848208550e-02,  -8.895113233019759e-04,   2.903105966312326e-05,  -1.315702837234363e-06,   7.566867514479401e-08,
  -4.489588943173380e-09,   2.373218638580245e-10,  -1.042206166083672e-11,   3.619636093417188e-13,  -9.248953444701214e-15,   1.545728730445043e-16,  -2.735386406091191e-18,
   2.673416558442713e-19,  -2.370535581741354e-20,   4.520593539843523e-02,  -8.895230959697655e-04,   2.903240774727754e-05,  -1.315835559670241e-06,   7.567916465432660e-08,
  -4.490232410628313e-09,   2.373516174363420e-10,  -1.042303875554647e-11,   3.619841045522045e-13,  -9.249405289579894e-15,   1.546253006230744e-16,  -2.740844407356606e-18,
   2.676869873189595e-19,  -2.371849339673435e-20,   4.158216798831068e-01,  -6.924249719400002e-03,   1.722044064204557e-04,  -4.692814138693757e-06,   1.293341740348206e-07,
  -3.376049486792977e-09,   7.643492572241984e-11,  -1.269572534967309e-12,   7.807231635618836e-15,   1.585765900823462e-16,   1.417907316243752e-17,  -2.000270526525800e-18,
   1.188226941041543e-19,  -4.487013731303132e-21,   4.158379712927521e-01,  -6.925580797641754e-03,   1.722777651303630e-04,  -4.696000167237427e-06,   1.294419273542289e-07,
  -3.378546004418510e-09,   7.645724235109823e-11,  -1.269343238639987e-12,   7.891811172987251e-15,   1.470287758920533e-16,   1.494462083589816e-17,  -2.032141340254264e-18,
   1.195012867295843e-19,  -4.471325758300624e-21,   4.158667234058004e-01,  -6.927930238333620e-03,   1.724072570711811e-04,  -4.701623866994811e-06,   1.296320860479606e-07,
  -3.382950935129785e-09,   7.649681599643181e-11,  -1.268971231286597e-12,   8.043704742744950e-15,   1.265199000006645e-16,   1.629867442363282e-17,  -2.088272056238111e-18,
   1.206823915312606e-19,  -4.442711117591184e-21,   4.159015004290309e-01,  -6.930772455871100e-03,   1.725639242522898e-04,  -4.708427348329975e-06,   1.298620729222249e-07,
  -3.388277096150666e-09,   7.654500629179257e-11,  -1.268577211864738e-12,   8.231904677967485e-15,   1.014946185515184e-16,   1.794146561537969e-17,  -2.155961671708131e-18,
   1.220827046197829e-19,  -4.406520788802866e-21,   4.159352714813310e-01,  -6.933532939517234e-03,   1.727161021641904e-04,  -4.715035446781401e-06,   1.300853874803379e-07,
  -3.393447344034666e-09,   7.659214692477102e-11,  -1.268253470356420e-12,   8.419357511085171e-15,   7.696454593058760e-17,   1.954189861868411e-17,  -2.221475809969084e-18,
   1.234127343585795e-19,  -4.369725793211994e-21,   4.159624842552706e-01,  -6.935757686732830e-03,   1.728387578596273e-04,  -4.720361278560763e-06,   1.302653208111289e-07,
  -3.397612248716734e-09,   7.663038306555746e-11,  -1.268034996283076e-12,   8.573778059060304e-15,   5.703467238181463e-17,   2.083517598152940e-17,  -2.274108046890241e-18,
   1.244630322642622e-19,  -4.338894974362450e-21,   4.159804695239052e-01,  -6.937228219188561e-03,   1.729198374805321e-04,  -4.723881684881006e-06,   1.303842342721264e-07,
  -3.400364268897784e-09,   7.665577767853245e-11,  -1.267911447046499e-12,   8.677489109320227e-15,   4.378285762845189e-17,   2.169168305089281e-17,  -2.308814074907773e-18,
   1.251466462002868e-19,  -4.317940913059914e-21,   4.159897069187239e-01,  -6.937983549979679e-03,   1.729614853090912e-04,  -4.725689950472165e-06,   1.304453072084681e-07,
  -3.401777542717853e-09,   7.666885917953105e-11,  -1.267854454788434e-12,   8.731267544332086e-15,   3.695192640305433e-17,   2.213213357591162e-17,  -2.326614593386381e-18,
   1.254944874838215e-19,  -4.307000284289993e-21,   4.159929222535341e-01,  -6.938246472389307e-03,   1.729759827398354e-04,  -4.726319392536606e-06,   1.304665650297694e-07,
  -3.402269442648884e-09,   7.667341873504584e-11,  -1.267835647643542e-12,   8.750068111968766e-15,   3.457030252430792e-17,   2.228553044946813e-17,  -2.332806588988475e-18,
   1.256150422072558e-19,  -4.303163701065647e-21,   4.159934324911920e-01,  -6.938288195628130e-03,   1.729782833547172e-04,  -4.726419279108472e-06,   1.304699383925034e-07,
  -3.402347500257807e-09,   7.667414257900215e-11,  -1.267832712118273e-12,   8.753055420219364e-15,   3.419217912541518e-17,   2.230987687678130e-17,  -2.333789000186394e-18,
   1.256341481337085e-19,  -4.302553530826408e-21,   4.201618115821231e-02,  -7.032931081680586e-04,   1.817678970678612e-05,  -5.807273416658720e-07,   2.383685863656015e-08,
  -1.191440517453619e-09,   6.187991161340083e-11,  -2.952531296061539e-12,   1.212818966250058e-13,  -4.087207150273151e-15,   1.040891521697387e-16,  -1.500389831466327e-18,
  -1.749974173822195e-20,   1.634634010292602e-21,   4.201791319292723e-02,  -7.034605626927104e-04,   1.819071317039344e-05,  -5.818952831927632e-07,   2.392776233883530e-08,
  -1.197476174905797e-09,   6.220726519078732e-11,  -2.966516253429618e-12,   1.217176452972442e-13,  -4.094575235116910e-15,   1.039835321669935e-16,  -1.490577837333283e-18,
  -1.747282678604754e-20,   1.597392496994710e-21,   4.202097051918501e-02,  -7.037563148503890e-04,   1.821532383374464e-05,  -5.839608035967752e-07,   2.408854114605366e-08,
  -1.208148665219211e-09,   6.278581364515774e-11,  -2.991212885552162e-12,   1.224861717292874e-13,  -4.107537473332083e-15,   1.037975295817739e-16,  -1.473500326127857e-18,
  -1.740461707578035e-20,   1.530603482722386e-21,   4.202466938924403e-02,  -7.041144128983608e-04,   1.824515588430113e-05,  -5.864664261067018e-07,   2.428360149383966e-08,
  -1.221092302698686e-09,   6.348698227355761e-11,  -3.021110271449453e-12,   1.234148712456089e-13,  -4.123145985115860e-15,   1.035733088553602e-16,  -1.453256630964347e-18,
  -1.728666228039350e-20,   1.448008089151887e-21,   4.202826220033352e-02,  -7.044625428677100e-04,   1.827419247379824e-05,  -5.889072055358300e-07,   2.447363895736915e-08,
  -1.233697947336369e-09,   6.416932027267399e-11,  -3.050169604119073e-12,   1.243157985959162e-13,  -4.138230699712087e-15,   1.033564601722767e-16,  -1.434035782614744e-18,
  -1.713481583301317e-20,   1.365907239943564e-21,   4.203115796601362e-02,  -7.047433468882562e-04,   1.829763864272137e-05,  -5.908794694280545e-07,   2.462721585282562e-08,
  -1.243881702880149e-09,   6.472018867987416e-11,  -3.073604775281639e-12,   1.250411179994090e-13,  -4.150334841451900e-15,   1.031824233129772e-16,  -1.418864730321157e-18,
  -1.698560562544870e-20,   1.298394117126332e-21,   4.203307214417639e-02,  -7.049290712956917e-04,   1.831315826498284e-05,  -5.921856501426825e-07,   2.472893455275615e-08,
  -1.250625062156495e-09,   6.508477311590314e-11,  -3.089102706455478e-12,   1.255201734123542e-13,  -4.158309846176833e-15,   1.030677693821010e-16,  -1.408994814608609e-18,
  -1.687379378390473e-20,   1.253110453010156e-21,   4.203405538532844e-02,  -7.050245035699488e-04,   1.832113663461146e-05,  -5.928573477706039e-07,   2.478124557737303e-08,
  -1.254092466673817e-09,   6.527218412447302e-11,  -3.097065461375952e-12,   1.257661225235437e-13,  -4.162398274839479e-15,   1.030090019294049e-16,  -1.403974365847156e-18,
  -1.681227454588726e-20,   1.229647338889087e-21,   4.203439764630928e-02,  -7.050577282338087e-04,   1.832391490158480e-05,  -5.930912834479358e-07,   2.479946463157082e-08,
  -1.255300023929681e-09,   6.533744280834080e-11,  -3.099837579740322e-12,   1.258517164270278e-13,  -4.163820161697640e-15,   1.029885658461011e-16,  -1.402234660261381e-18,
  -1.679020872953277e-20,   1.221447716299626e-21,   4.203445196007009e-02,  -7.050630009381371e-04,   1.832435583708405e-05,  -5.931284127112957e-07,   2.480235630118649e-08,
  -1.255491679649444e-09,   6.534779981876627e-11,  -3.100277505629038e-12,   1.258652984816923e-13,  -4.164045742102302e-15,   1.029853238080196e-16,  -1.401958959456325e-18,
  -1.678667614537662e-20,   1.220144979324461e-21,   3.905669416903084e-01,  -5.741232347539225e-03,   1.263697633751521e-04,  -3.075460494201455e-06,   7.745124481536319e-08,
  -1.933596915169552e-09,   4.539704238219207e-11,  -9.185870528820012e-13,   1.291685757256321e-14,   9.286823995491912e-18,  -7.077037314503576e-18,   1.602925186699945e-19,
   5.089474560701770e-21,  -6.042336337171080e-22,   3.905788770262736e-01,  -5.742103761058969e-03,   1.264136923995875e-04,  -3.077288435501905e-06,   7.751547749026923e-08,
  -1.935404599879156e-09,   4.543036790178466e-11,  -9.185400887907613e-13,   1.288848874773428e-14,   9.916495753144105e-18,  -7.032778615111795e-18,   1.553200470926159e-19,
   5.362869254066068e-21,  -6.142947926530903e-22,   3.905999405062876e-01,  -5.743641804561987e-03,   1.264912353223199e-04,  -3.080515244279557e-06,   7.762885493124869e-08,
  -1.938594205539769e-09,   4.548911169967203e-11,  -9.184556389239407e-13,   1.283859460476137e-14,   1.100614993607685e-17,  -6.953291924609208e-18,   1.464864205582127e-19,
   5.846756678603841e-21,  -6.320344288900425e-22,   3.906254164764725e-01,  -5.745502340638849e-03,   1.265850513102391e-04,  -3.084419484800738e-06,   7.776601667935585e-08,
  -1.942450968596526e-09,   4.556004394498512e-11,  -9.183508664485161e-13,   1.277854345556838e-14,   1.228709213022392e-17,  -6.854798131163048e-18,   1.357031086397989e-19,
   6.434380369189806e-21,  -6.534611581799436e-22,   3.906501541674250e-01,  -5.747309268427746e-03,   1.266761788912786e-04,  -3.088212113570905e-06,   7.789923845208237e-08,
  -1.946194896488066e-09,   4.562879789561313e-11,  -9.182464274792110e-13,   1.272054570675336e-14,   1.349198054537702e-17,  -6.756685900930786e-18,   1.251285507997406e-19,
   7.007431310260126e-21,  -6.742347991167122e-22,   3.906700868729922e-01,  -5.748765444649139e-03,   1.267496278152926e-04,  -3.091269168279527e-06,   7.800660851776043e-08,
  -1.949210846566019e-09,   4.568410957531010e-11,  -9.181603755320478e-13,   1.267404058308582e-14,   1.443479255971313e-17,  -6.675855046166618e-18,   1.165337197299303e-19,
   7.470916793227888e-21,  -6.909491966344508e-22,   3.906832601769731e-01,  -5.749727923792304e-03,   1.267981800336293e-04,  -3.093290078420065e-06,   7.807758039543989e-08,
  -1.951203678454236e-09,   4.572062162104117e-11,  -9.181025902155449e-13,   1.264341832916732e-14,   1.504409748706156e-17,  -6.621563820335092e-18,   1.108171716851289e-19,
   7.778075285337208e-21,  -7.019832154385539e-22,   3.906900259568731e-01,  -5.750222284495975e-03,   1.268231196362228e-04,  -3.094328179314461e-06,   7.811403516126879e-08,
  -1.952227076103377e-09,   4.573936090358284e-11,  -9.180726322316894e-13,   1.262772583929626e-14,   1.535275824369601e-17,  -6.593410265375838e-18,   1.078699406355845e-19,
   7.936091347182770e-21,  -7.076463441706811e-22,   3.906923809532895e-01,  -5.750394364260130e-03,   1.268318010032661e-04,  -3.094689542318391e-06,   7.812672473992705e-08,
  -1.952583276329536e-09,   4.574588146937607e-11,  -9.180621603995132e-13,   1.262226928100355e-14,   1.545951322746773e-17,  -6.583567760827481e-18,   1.068422979725397e-19,
   7.991134009484028e-21,  -7.096169026430380e-22,   3.906927546637609e-01,  -5.750421671565678e-03,   1.268331786598550e-04,  -3.094746887667045e-06,   7.812873845652837e-08,
  -1.952639800271480e-09,   4.574691610732692e-11,  -9.180604965485811e-13,   1.262140365510456e-14,   1.547642159959052e-17,  -6.582003829802583e-18,   1.066791382788098e-19,
   7.999870595027446e-21,  -7.099295770587760e-22,   3.945698999961273e-02,  -5.806695817840524e-04,   1.291034223322934e-05,  -3.309799890031332e-07,   9.946427285904163e-09,
  -3.703587728170687e-10,   1.637757984957677e-11,  -7.556855253853955e-13,   3.273896672305404e-14,  -1.256537774601277e-15,   4.106055539311614e-17,  -1.079455522023845e-18,
   1.947030394775274e-20,  -4.059465983325672e-23,   3.945821185097718e-02,  -5.807639420534652e-04,   1.291607369129298e-05,  -3.313403677126050e-07,   9.970523594208502e-09,
  -3.719166131148213e-10,   1.646718363741216e-11,  -7.600713424616837e-13,   3.291584885956877e-14,  -1.262101210913102e-15,   4.117523810332568e-17,  -1.079439729415913e-18,
   1.934624934292478e-20,  -3.486925461115304e-23,   3.946036828038371e-02,  -5.809305269567070e-04,   1.292619821216366e-05,  -3.319774707226304e-07,   1.001314579933680e-08,
  -3.746725382629229e-10,   1.662567062703140e-11,  -7.678254482884353e-13,   3.322834840360123e-14,  -1.271917598246192e-15,   4.137696674921278e-17,  -1.079378375799289e-18,
   1.912672828091950e-20,  -2.480661208196849e-23,   3.946297663167112e-02,  -5.811321078577308e-04,   1.293846014542583e-05,  -3.327499278589619e-07,   1.006486246515110e-08,
  -3.780171406130003e-10,   1.681796276437565e-11,  -7.772278188030324e-13,   3.360688666727396e-14,  -1.283786929463102e-15,   4.161982159645875e-17,  -1.079247260954970e-18,
   1.886023813701309e-20,  -1.270827190560643e-23,   3.946550958508640e-02,  -5.813279508396358e-04,   1.295038402338819e-05,  -3.335019834886310e-07,   1.011525430410337e-08,
  -3.812767236324240e-10,   1.700531591333574e-11,  -7.863827267634285e-13,   3.397505480002681e-14,  -1.295308564930125e-15,   4.185444990721337e-17,  -1.079060589695980e-18,
   1.860047064669224e-20,  -1.038048971939746e-24,   3.946755068116736e-02,  -5.814858282914662e-04,   1.296000425140360e-05,  -3.341093861836587e-07,   1.015598299153749e-08,
  -3.839117165633634e-10,   1.715673237284233e-11,  -7.937773245392164e-13,   3.427213911041780e-14,  -1.304589510377163e-15,   4.204265133520637e-17,  -1.078867819866225e-18,
   1.839046370480118e-20,   8.308552747016064e-24,   3.946889968616857e-02,  -5.815902042871763e-04,   1.296636824178883e-05,  -3.345115105110864e-07,   1.018296134334720e-08,
  -3.856573420905630e-10,   1.725702442068786e-11,  -7.986731015008316e-13,   3.446868789940006e-14,  -1.310721799964267e-15,   4.216661317227209e-17,  -1.078719751677052e-18,
   1.825133999674253e-20,   1.445727320603625e-23,   3.946959255299468e-02,  -5.816438228811504e-04,   1.296963865834238e-05,  -3.347182569879297e-07,   1.019683631631340e-08,
  -3.865551877412972e-10,   1.730860306456018e-11,  -8.011902731648406e-13,   3.456969945111102e-14,  -1.313870894989943e-15,   4.223015017891446e-17,  -1.078637327418576e-18,
   1.817978533977035e-20,   1.760636546078647e-23,   3.946983372568621e-02,  -5.816624879561203e-04,   1.297077730772114e-05,  -3.347902546526184e-07,   1.020166886132212e-08,
  -3.868679114994232e-10,   1.732656724930563e-11,  -8.020668683937263e-13,   3.460486927206247e-14,  -1.314966945150818e-15,   4.225224516908488e-17,  -1.078607623807514e-18,
   1.815486305404329e-20,   1.870106149674056e-23,   3.946987199713785e-02,  -5.816654499714502e-04,   1.297095801236109e-05,  -3.348016814788075e-07,   1.020243587321163e-08,
  -3.869175469163395e-10,   1.732941847663769e-11,  -8.022059943236303e-13,   3.461045079945933e-14,  -1.315140872196683e-15,   4.225575040676898e-17,  -1.078602862089579e-18,
   1.815090742516080e-20,   1.887470923306257e-23,   3.694164954255869e-01,  -4.859424109338372e-03,   9.579324419375605e-05,  -2.094335242680278e-06,   4.782802874461645e-08,
  -1.107277298094098e-09,   2.521129898726267e-11,  -5.395292617812797e-13,   9.983731180138922e-15,  -1.268210499280441e-16,  -4.200804453222965e-19,   8.866033623153733e-20,
  -2.948950649917194e-21,   3.858602492864723e-23,   3.694255304418239e-01,  -4.860016830053839e-03,   9.582034944316229e-05,  -2.095382305681878e-06,   4.786379131958768e-08,
  -1.108346082135064e-09,   2.523745647091675e-11,  -5.399451464479933e-13,   9.981403176447144e-15,  -1.263565598328531e-16,  -4.374993955354199e-19,   8.886170306119228e-20,
  -2.931781583590771e-21,   3.714785966326110e-23,   3.694414749604767e-01,  -4.861062936081929e-03,   9.586819351046970e-05,  -2.097230681485441e-06,   4.792692483188923e-08,
  -1.110232628090081e-09,   2.528360645987420e-11,  -5.406777018918361e-13,   9.977236382214072e-15,  -1.255361996325441e-16,  -4.681438095153151e-19,   8.920822683073385e-20,
  -2.901014963431846e-21,   3.459232268728016e-23,   3.694607588079133e-01,  -4.862328309723884e-03,   9.592607508885885e-05,  -2.099467150079660e-06,   4.800331750353752e-08,
  -1.112514983054375e-09,   2.533940239305471e-11,  -5.415613326236849e-13,   9.972097481255023e-15,  -1.245429408653975e-16,  -5.050415436236054e-19,   8.961218455873667e-20,
  -2.863005523779890e-21,   3.147165672376168e-23,   3.694794829676757e-01,  -4.863557143169469e-03,   9.598229487849898e-05,  -2.101639734064165e-06,   4.807753153975819e-08,
  -1.114731828404416e-09,   2.539355845306861e-11,  -5.424168582184684e-13,   9.967003906290106e-15,  -1.235774048638825e-16,  -5.406938656910387e-19,   8.998847342487674e-20,
  -2.825259777529203e-21,   2.841023373029377e-23,   3.694945695838089e-01,  -4.864547384064874e-03,   9.602760585130282e-05,  -2.103390985134547e-06,   4.813735562545039e-08,
  -1.116518530561979e-09,   2.543717886844512e-11,  -5.431044181428485e-13,   9.962825689801494e-15,  -1.227986751306570e-16,  -5.692935212733656e-19,   9.028017312260376e-20,
  -2.794243651004560e-21,   2.592110195711206e-23,   3.695045398618089e-01,  -4.865201868779132e-03,   9.605755684076866e-05,  -2.104548692754098e-06,   4.817690502904569e-08,
  -1.117699562476230e-09,   2.546599900248823e-11,  -5.435579418674455e-13,   9.960028209193155e-15,  -1.222836699659272e-16,  -5.881316295505150e-19,   9.046729836023072e-20,
  -2.773449980043780e-21,   2.426511775187170e-23,   3.695096604820723e-01,  -4.865538024756868e-03,   9.607294129485711e-05,  -2.105143389412000e-06,   4.819722132713691e-08,
  -1.118306205857861e-09,   2.548079844390209e-11,  -5.437905993758517e-13,   9.958580271137273e-15,  -1.220190578317590e-16,  -5.977872055641248e-19,   9.056165098150125e-20,
  -2.762678877321803e-21,   2.341122312492751e-23,   3.695114428254024e-01,  -4.865655034368646e-03,   9.607829650257088e-05,  -2.105350404249844e-06,   4.820429352200192e-08,
  -1.118517373848524e-09,   2.548594935306526e-11,  -5.438715383624391e-13,   9.958074505981393e-15,  -1.219269362658662e-16,  -6.011449297392153e-19,   9.059421294410433e-20,
  -2.758915146735571e-21,   2.311346519631478e-23,   3.695117256618068e-01,  -4.865673602536023e-03,   9.607914632437975e-05,  -2.105383255850876e-06,   4.820541582566185e-08,
  -1.118550884259446e-09,   2.548676672323510e-11,  -5.438843803852709e-13,   9.957994162736693e-15,  -1.219123168540221e-16,  -6.016776122669014e-19,   9.059936685566515e-20,
  -2.758317194023205e-21,   2.306618890355434e-23,   3.731893959222846e-02,  -4.910212804608077e-04,   9.702677134620471e-06,  -2.152427469067694e-07,   5.225151335301773e-09,
  -1.452960068120990e-10,   4.884115975383920e-12,  -1.921747325109265e-13,   7.948940694119288e-15,  -3.148335899257517e-16,   1.131818758067534e-17,  -3.572284522410702e-19,
   9.535356369555307e-21,  -1.986231312743504e-22,   3.731985519869823e-02,  -4.910823097046047e-04,   9.705656660590783e-06,  -2.153823102073470e-07,   5.232280191269809e-09,
  -1.456921536111714e-10,   4.906013697599215e-12,  -1.932869677346745e-13,   7.998615044575263e-15,  -3.167307708472935e-16,   1.137796521923120e-17,  -3.586523822182890e-19,
   9.552575399971659e-21,  -1.981250655686424e-22,   3.732147103272510e-02,  -4.911900292685517e-04,   9.710917403260077e-06,  -2.156288793203252e-07,   5.244884613852417e-09,
  -1.463929657066438e-10,   4.944759755506572e-12,  -1.952547704692667e-13,   8.086471917912066e-15,  -3.200843155842117e-16,   1.148352713932585e-17,  -3.611617973080174e-19,
   9.582662536012454e-21,  -1.972335545802725e-22,   3.732342531227086e-02,  -4.913203403865998e-04,   9.717284422305532e-06,  -2.159275585495661e-07,   5.260169485303965e-09,
  -1.472434783615655e-10,   4.991794959241350e-12,  -1.976432148667654e-13,   8.193060315364586e-15,  -3.241495752048342e-16,   1.161131480815864e-17,  -3.641908174613619e-19,
   9.618537920875832e-21,  -1.961339447676951e-22,   3.732532290771440e-02,  -4.914469023159743e-04,   9.723471365083470e-06,  -2.162180624049715e-07,   5.275053402493403e-09,
  -1.480723773917642e-10,   5.037648000584770e-12,  -1.999712684866218e-13,   8.296902216859623e-15,  -3.281066419139224e-16,   1.173551527400874e-17,  -3.671256263184600e-19,
   9.652833150736954e-21,  -1.950438746658825e-22,   3.732685188321686e-02,  -4.915489006708037e-04,   9.728459756872807e-06,  -2.164524843495088e-07,   5.287076461764936e-09,
  -1.487424515174857e-10,   5.074724510228575e-12,  -2.018534583564234e-13,   8.380819549656044e-15,  -3.313019776517406e-16,   1.183567352637437e-17,  -3.694857316452169e-19,
   9.680078539902621e-21,  -1.941495560744500e-22,   3.732786234862005e-02,  -4.916163198073281e-04,   9.731758091538116e-06,  -2.166075803452203e-07,   5.295037160684095e-09,
  -1.491863644871578e-10,   5.099291634361976e-12,  -2.031004800801054e-13,   8.436399785175303e-15,  -3.334171037051844e-16,   1.190190684697073e-17,  -3.710432022021756e-19,
   9.697894073996527e-21,  -1.935506929460392e-22,   3.732838131600505e-02,  -4.916509490851666e-04,   9.733452592503627e-06,  -2.166872896774004e-07,   5.299130338583096e-09,
  -1.494146880191507e-10,   5.111928965754298e-12,  -2.037419081123927e-13,   8.464982852973785e-15,  -3.345044672450105e-16,   1.193593637339231e-17,  -3.718424014431336e-19,
   9.706985038878902e-21,  -1.932407019215259e-22,   3.732856195452949e-02,  -4.916630031297923e-04,   9.734042482348370e-06,  -2.167150428178031e-07,   5.300555799742031e-09,
  -1.494942143505595e-10,   5.116330840057748e-12,  -2.039653259061763e-13,   8.474937814039449e-15,  -3.348831163195091e-16,   1.194778312967355e-17,  -3.721204683861835e-19,
   9.710139963223195e-21,  -1.931324173776812e-22,   3.732859061971610e-02,  -4.916649159884924e-04,   9.734136094646144e-06,  -2.167194473137660e-07,   5.300782038459428e-09,
  -1.495068367545762e-10,   5.117029515269683e-12,  -2.040007869677024e-13,   8.476517831336120e-15,  -3.349432113628287e-16,   1.194966316375744e-17,  -3.721645889466048e-19,
   9.710640166035676e-21,  -1.931152156312616e-22,   3.513692228249317e-01,  -4.182120066939281e-03,   7.461708162415575e-05,  -1.477961351762096e-06,   3.067972280437154e-08,
  -6.516157545265345e-10,   1.390221076516464e-11,  -2.908900669757571e-13,   5.738293129933785e-15,  -9.887720412412345e-17,   3.513798944072573e-01,  -4.182754344952288e-03,
   7.464344714929698e-05,  -1.478896064054861e-06,   3.070967225432630e-08,  -6.524931432238179e-10,   1.392522901500765e-11,  -2.913956352869775e-13,   5.745719808024478e-15,
  -9.884219362545864e-17,   3.513974162765606e-01,  -4.183795905165205e-03,   7.468674899756077e-05,  -1.480431451432000e-06,   3.075887472034157e-08,  -6.539346101645342e-10,
   1.396303838366853e-11,  -2.922254642908898e-13,   5.757876452036514e-15,  -9.878291963834564e-17,   3.514160120589209e-01,  -4.184901475621357e-03,   7.473272085820248e-05,
  -1.482061847892444e-06,   3.081113073687818e-08,  -6.554656011269910e-10,   1.400318578362794e-11,  -2.931057787179813e-13,   5.770727281218084e-15,  -9.871758015417052e-17,
   3.514306497350765e-01,  -4.185771851182902e-03,   7.476891924751524e-05,  -1.483345870809480e-06,   3.085229155160443e-08,  -6.566715727470069e-10,   1.403480276077211e-11,
  -2.937984443596734e-13,   5.780805871868117e-15,  -9.866438666734613e-17,   3.514390985058779e-01,  -4.186274276543532e-03,   7.478981738188461e-05,  -1.484087263395637e-06,
   3.087606031911239e-08,  -6.573679928912197e-10,   1.405305784448458e-11,  -2.941981355992447e-13,   5.786608328579914e-15,  -9.863297759342976e-17,   3.514422713078061e-01,
  -4.186462963928749e-03,   7.479766622611629e-05,  -1.484365731340997e-06,   3.088498838503277e-08,  -6.576295869136691e-10,   1.405991437848817e-11,  -2.943482122475131e-13,
   5.788784540690422e-15,  -9.862104894207259e-17,   3.514427972559285e-01,  -4.186494242706785e-03,   7.479896735757216e-05,  -1.484411894958538e-06,   3.088646847995481e-08,
  -6.576729541578381e-10,   1.406105102984714e-11,  -2.943730889966764e-13,   5.789145138147318e-15,  -9.861906451554814e-17,   3.549554915090312e-02,  -4.225002129611807e-04,
   7.542250508454026e-06,  -1.499447776238253e-07,   3.169173730551744e-09,  -7.189397117311671e-11,   1.839508290044958e-12,  -5.582479222177137e-14,   1.965166502613444e-15,
  -7.325976512313176e-17,   3.549662795660014e-02,  -4.225645946292282e-04,   7.544979341378473e-06,  -1.500485561157850e-07,   3.173198377421108e-09,  -7.206715639647717e-11,
   1.847713578129564e-12,  -5.621995826636310e-14,   1.983113200189555e-15,  -7.399467305893645e-17,   3.549839927518881e-02,  -4.226703199311500e-04,   7.549461677691503e-06,
  -1.502191061180592e-07,   3.179818347768305e-09,  -7.235233457668530e-11,   1.861236286766217e-12,  -5.687144393987944e-14,   2.012699639455885e-15,  -7.520582164714357e-17,
   3.550027916785140e-02,  -4.227825466792104e-04,   7.554221206114188e-06,  -1.504003190897851e-07,   3.186860172385596e-09,  -7.265611176591270e-11,   1.875656340046763e-12,
  -5.756647669917555e-14,   2.044262068229818e-15,  -7.649731139879426e-17,   3.550175893338377e-02,  -4.228709016245937e-04,   7.557969461970451e-06,  -1.505431133257607e-07,
   3.192414848943944e-09,  -7.289604375812893e-11,   1.887056859184127e-12,  -5.811619818364888e-14,   2.069224459566405e-15,  -7.751833815947325e-17,   3.550261304733673e-02,
  -4.229219057885853e-04,   7.560133649776459e-06,  -1.506255944226087e-07,   3.195625673319559e-09,  -7.303485788747139e-11,   1.893657161598155e-12,  -5.843454881777435e-14,
   2.083679978979974e-15,  -7.810944600435447e-17,   3.550293379685513e-02,  -4.229410607791421e-04,   7.560946512221082e-06,  -1.506565804717568e-07,   3.196832337398000e-09,
  -7.308704922461282e-11,   1.896139585853871e-12,  -5.855430002476926e-14,   2.089117487372045e-15,  -7.833176346280038e-17,   3.550298696679934e-02,  -4.229442361206862e-04,
   7.561081265748878e-06,  -1.506617175695593e-07,   3.197032410319996e-09,  -7.309570413058769e-11,   1.896551291476195e-12,  -5.857416144876013e-14,   2.090019324010047e-15,
  -7.836863426560093e-17,   3.357328992214682e-01,  -3.648665719536942e-03,   5.944870196930566e-05,  -1.075650676079934e-06,   2.041867695990555e-08,  -3.979134136296409e-10,
   7.857934383922153e-12,  -1.551851826963983e-13,   3.005026326280195e-15,  -5.512683951200837e-17,   3.357413944631656e-01,  -3.649126953839264e-03,   5.946623225915914e-05,
  -1.076220894278496e-06,   2.043559440655930e-08,  -3.983817297550800e-10,   7.870027212093421e-12,  -1.554697776847525e-13,   3.010760729972372e-15,  -5.520825180337906e-17,
   3.357553425963061e-01,  -3.649884321501120e-03,   5.949502155435797e-05,  -1.077157483363839e-06,   2.046338585502362e-08,  -3.991511626303189e-10,   7.889896058166985e-12,
  -1.559372851623350e-13,   3.020173955966193e-15,  -5.534154272472982e-17,   3.357701451164600e-01,  -3.650688187645437e-03,   5.952558348128848e-05,  -1.078151934416782e-06,
   2.049290018856052e-08,  -3.999684281543064e-10,   7.911000878858951e-12,  -1.564337520090595e-13,   3.030161081455761e-15,  -5.548248272691155e-17,   3.357817965685227e-01,
  -3.651321008734180e-03,   5.954964620783202e-05,  -1.078935049051589e-06,   2.051614656806585e-08,  -4.006122272674895e-10,   7.927626729374522e-12,  -1.568247668766346e-13,
   3.038020214304613e-15,  -5.559304550027187e-17,   3.357885215673928e-01,  -3.651686292012154e-03,   5.956353742007093e-05,  -1.079387190888423e-06,   2.052956990512029e-08,
  -4.009840196722872e-10,   7.937228344563405e-12,  -1.570505463989451e-13,   3.042555545350809e-15,  -5.565670952473611e-17,   3.357910470070786e-01,  -3.651823472720934e-03,
   5.956875449151986e-05,  -1.079557010768818e-06,   2.053461190018362e-08,  -4.011236774234441e-10,   7.940835077290638e-12,  -1.571353509830038e-13,   3.044258543725255e-15,
  -5.568058873695506e-17,   3.357914656420163e-01,  -3.651846213083703e-03,   5.956961933710645e-05,  -1.079585162750756e-06,   2.053544775682405e-08,  -4.011468301220202e-10,
   7.941433009792470e-12,  -1.571494097234903e-13,   3.044540836693952e-15,  -5.568454561850470e-17,   3.391591831789623e-02,  -3.685934467444036e-04,   6.006273525014583e-06,
  -1.087712135256732e-07,   2.074706952829445e-09,  -4.125628759860878e-11,   8.711879071098202e-13,  -2.048405710693140e-14,   5.622595893223188e-16,  -1.777064978043461e-17,
   3.391677663886384e-02,  -3.686400929763339e-04,   6.008055708928253e-06,  -1.088304554866938e-07,   2.076594343737115e-09,  -4.131903908233409e-11,   8.735131377061326e-13,
  -2.057958942743342e-14,   5.663202496149868e-16,  -1.793679359520378e-17,   3.391818589672845e-02,  -3.687166887235634e-04,   6.010982626037425e-06,  -1.089277759466871e-07,
   2.079696434562247e-09,  -4.142226510608477e-11,   8.773422443621291e-13,  -2.073704564495603e-14,   5.730159397976601e-16,  -1.821076686921075e-17,   3.391968147986258e-02,
  -3.687979877613446e-04,   6.014089907848495e-06,  -1.090311292002448e-07,   2.082992940711113e-09,  -4.153208111214048e-11,   8.814213941598666e-13,  -2.090497005281262e-14,
   5.801607346083226e-16,  -1.850313773179555e-17,   3.392085869388419e-02,  -3.688619886627040e-04,   6.016536511893778e-06,  -1.091125330870687e-07,   2.085590898908132e-09,
  -4.161871398067716e-11,   8.846434522669551e-13,  -2.103774570254083e-14,   5.858128838940439e-16,  -1.873444323144281e-17,   3.392153816018299e-02,  -3.688989321052887e-04,
   6.017948959011743e-06,  -1.091595386810825e-07,   2.087091673295657e-09,  -4.166879471151013e-11,   8.865076855068639e-13,  -2.111462160506743e-14,   5.890865669968266e-16,
  -1.886841950298530e-17,   3.392179332034734e-02,  -3.689128061099694e-04,   6.018479434704873e-06,  -1.091771946328571e-07,   2.087655501853380e-09,  -4.168761627437814e-11,
   8.872086173060071e-13,  -2.114353631349421e-14,   5.903180857091221e-16,  -1.891882078913884e-17,   3.392183561752563e-02,  -3.689151059973609e-04,   6.018567373274542e-06,
  -1.091801216173204e-07,   2.087748978909189e-09,  -4.169073704930391e-11,   8.873248539658555e-13,  -2.114833182389384e-14,   5.905223446657794e-16,  -1.892718037312753e-17,
   3.220147852511789e-01,  -3.219698327421399e-03,   4.826804314245068e-05,  -8.036743506966775e-07,   1.404355643982110e-08,  -2.522081430858939e-10,   4.604715752621621e-12,
  -8.475713807602037e-14,   1.556841043745810e-15,  -2.806257761390625e-17,   3.220216783758331e-01,  -3.220042709778095e-03,   4.828009030069405e-05,  -8.040354217401743e-07,
   1.405346026430119e-08,  -2.524637616060304e-10,   4.610983878548425e-12,  -8.490247370111342e-14,   1.559956666971990e-15,  -2.812101571401123e-17,   3.220329958040817e-01,
  -3.220608181093873e-03,   4.829987379716649e-05,  -8.046284422068389e-07,   1.406972870094005e-08,  -2.528837157385881e-10,   4.621283016626626e-12,  -8.514128210705467e-14,
   1.565075224886617e-15,  -2.821695940703476e-17,   3.220450061674319e-01,  -3.221208342050884e-03,   4.832087395938363e-05,  -8.052580416173602e-07,   1.408700396847709e-08,
  -2.533297478510882e-10,   4.632223429002421e-12,  -8.539497048100602e-14,   1.570511510535124e-15,  -2.831877357968458e-17,   3.220544596156673e-01,  -3.221680782101514e-03,
   4.833740724091031e-05,  -8.057537996294914e-07,   1.410060925722578e-08,  -2.536810877863048e-10,   4.640842451201537e-12,  -8.559483758348986e-14,   1.574793582552373e-15,
  -2.839890907538280e-17,   3.220599158783050e-01,  -3.221953480687977e-03,   4.834695134437931e-05,  -8.060400155269524e-07,   1.410846497048382e-08,  -2.538839773910712e-10,
   4.645820210583256e-12,  -8.571027018880715e-14,   1.577266325864964e-15,  -2.844515959557864e-17,   3.220619648523382e-01,  -3.222055890073597e-03,   4.835053570828846e-05,
  -8.061475121532600e-07,   1.411141559403497e-08,  -2.539601879869648e-10,   4.647690080490970e-12,  -8.575363242038474e-14,   1.578195144277166e-15,  -2.846252763170457e-17,
   3.220623045040275e-01,  -3.222072866335912e-03,   4.835112989208419e-05,  -8.061653322977162e-07,   1.411190474038151e-08,  -2.539728222256966e-10,   4.648000073635952e-12,
  -8.576082118243579e-14,   1.578349123921311e-15,  -2.846540665860292e-17,   3.253010057267802e-02,  -3.252561270852594e-04,   4.876183010366539e-06,  -8.120554096205866e-08,
   1.420695780110045e-09,  -2.565765038701489e-11,   4.784744601663612e-13,  -9.402574010136803e-15,   2.033785617297947e-16,  -5.059603456791397e-18,   3.253079694062457e-02,
  -3.252909254174625e-04,   4.877401910933258e-06,  -8.124229497256430e-08,   1.421727033190189e-09,  -2.568618166184508e-11,   4.793051134039800e-13,  -9.429487334567192e-15,
   2.043492318746996e-16,  -5.096313576943802e-18,   3.253194026766121e-02,  -3.253480639114457e-04,   4.879403573142960e-06,  -8.130266215886635e-08,   1.423421294539597e-09,
  -2.573307915424857e-11,   4.806715976155274e-13,  -9.473807915592283e-15,   2.059491590671476e-16,  -5.156852636960975e-18,   3.253315359777735e-02,  -3.254087077684457e-04,
   4.881528361260627e-06,  -8.136675657662345e-08,   1.425220795862091e-09,  -2.578292108111054e-11,   4.821254028332184e-13,  -9.521023598113932e-15,   2.076555510366753e-16,
  -5.221462029908785e-18,   3.253410861934743e-02,  -3.254564460281775e-04,   4.883201210792150e-06,  -8.141722832909923e-08,   1.426638288400597e-09,  -2.582220503759860e-11,
   4.832723578948408e-13,  -9.558319235293000e-15,   2.090048437172368e-16,  -5.272580739635515e-18,   3.253465983084303e-02,  -3.254840012124673e-04,   4.884166897666275e-06,
  -8.144636824142997e-08,   1.427456862994397e-09,  -2.584489990868729e-11,   4.839354142186741e-13,  -9.579898197558595e-15,   2.097861005905742e-16,  -5.302191178345192e-18,
   3.253486682566842e-02,  -3.254943493090880e-04,   4.884529570466508e-06,  -8.145731277639751e-08,   1.427764342729878e-09,  -2.585342647350650e-11,   4.841846116294163e-13,
  -9.588011710462673e-15,   2.100799538216426e-16,  -5.313330797489740e-18,   3.253490113852098e-02,  -3.254960646991165e-04,   4.884589691195115e-06,  -8.145912710623981e-08,
   1.427815317007583e-09,  -2.585484010671152e-11,   4.842259309205104e-13,  -9.589357190327132e-15,   2.101286897283251e-16,  -5.315178436662715e-18,   3.098521333839649e-01,
  -2.868658481470880e-03,   3.982314072754138e-05,  -6.140425748582070e-07,   9.937865815308448e-09,  -1.653589447849939e-10,   2.800256659945608e-12,  -4.795214308263714e-14,
   8.254188199052836e-16,  -1.416187578376308e-17,   3.098578176425382e-01,  -2.868921465693864e-03,   3.983166022623746e-05,  -6.142791136851527e-07,   9.943882769463769e-09,
  -1.655034217784064e-10,   2.803577806603150e-12,  -4.802551702166395e-14,   8.269670790401013e-16,  -1.419244108558892e-17,   3.098671501550095e-01,  -2.869353270147267e-03,
   3.984565008851678e-05,  -6.146675795592581e-07,   9.953765715062240e-09,  -1.657407631775914e-10,   2.809034479858042e-12,  -4.814608571852468e-14,   8.295112935705643e-16,
  -1.424266106969135e-17,   3.098770538711091e-01,  -2.869811547680289e-03,   3.986049947991950e-05,  -6.150799746183830e-07,   9.964259275863119e-09,  -1.659928170206925e-10,
   2.814830515803826e-12,  -4.827417276829678e-14,   8.322142955189560e-16,  -1.429600550295438e-17,   3.098848490160654e-01,  -2.870172286665803e-03,   3.987218969850761e-05,
  -6.154046785601124e-07,   9.972522828541512e-09,  -1.661913414154178e-10,   2.819396434574254e-12,  -4.837508976617582e-14,   8.343440298578482e-16,  -1.433802918108106e-17,
   3.098893480947816e-01,  -2.870380505119929e-03,   3.987893782363495e-05,  -6.155921304478104e-07,   9.977293917748216e-09,  -1.663059765721209e-10,   2.822033283561297e-12,
  -4.843337578280884e-14,   8.355741264728071e-16,  -1.436229841809691e-17,   3.098910376093854e-01,  -2.870458698689120e-03,   3.988147208988456e-05,  -6.156625316299357e-07,
   9.979085893255999e-09,  -1.663490350962017e-10,   2.823023780865541e-12,  -4.845527124022290e-14,   8.360362262305059e-16,  -1.437141488425312e-17,   3.098913176740861e-01,
  -2.870471660681000e-03,   3.988189219546595e-05,  -6.156742022210317e-07,   9.979382959110499e-09,  -1.663561732898719e-10,   2.823187987609699e-12,  -4.845890117304311e-14,
   8.361128357055310e-16,  -1.437292623389042e-17,   3.130142212143026e-02,  -2.897934428475888e-04,   4.022973573837855e-06,  -6.203381187660407e-08,   1.004257561640214e-09,
  -1.673436286826467e-11,   2.851116961737437e-13,  -4.986736539611888e-15,   9.132313989812194e-17,  -1.820243419868251e-18,   3.130199635154311e-02,  -2.898200110576684e-04,
   4.023834528576906e-06,  -6.205775336289790e-08,   1.004870562679719e-09,  -1.674941878163581e-11,   2.854812970766719e-13,  -4.996298091335820e-15,   9.159717155448852e-17,
  -1.828990208492022e-18,   3.130293913235201e-02,  -2.898636344933063e-04,   4.025248304877983e-06,  -6.209707273890317e-08,   1.005877476432424e-09,  -1.677415630915991e-11,
   2.860888540364793e-13,  -5.012027752168461e-15,   9.204843433248382e-17,  -1.843407293742221e-18,   3.130393961683749e-02,  -2.899099324159745e-04,   4.026748947129924e-06,
  -6.213881478371280e-08,   1.006946669649540e-09,  -1.680043305857633e-11,   2.867346047077860e-13,  -5.028762870673379e-15,   9.252916134990397e-17,  -1.858783763515513e-18,
   3.130472709114202e-02,  -2.899463764290147e-04,   4.027930334460211e-06,  -6.217168131342255e-08,   1.007788695539957e-09,  -1.682113353450643e-11,   2.872436017708215e-13,
  -5.041965978166567e-15,   9.290887792590903e-17,  -1.870942397193293e-18,   3.130518159314498e-02,  -2.899674119103320e-04,   4.028612286155719e-06,  -6.219065537494620e-08,
   1.008274871888204e-09,  -1.683308842604391e-11,   2.875376703341747e-13,  -5.049598800665598e-15,   9.312857521513360e-17,  -1.877982404689855e-18,   3.130535226981730e-02,
  -2.899753114963892e-04,   4.028868394149850e-06,  -6.219778148547500e-08,   1.008457478819120e-09,  -1.683757916575482e-11,   2.876481558768497e-13,  -5.052467471868778e-15,
   9.321117889238790e-17,  -1.880630356721042e-18,   3.130538056226964e-02,  -2.899766209950604e-04,   4.028910849211552e-06,  -6.219896280159321e-08,   1.008487750794218e-09,
  -1.683832365241851e-11,   2.876664735972661e-13,  -5.052943125599691e-15,   9.322487718631697e-17,  -1.881069522829954e-18,   2.989715145932319e-01,  -2.577073989031166e-03,
   3.331022628780270e-05,  -4.782508708945902e-07,   7.207635044647884e-09,  -1.116926436837344e-10,   1.762164515793303e-12,  -2.814226283375386e-14,   4.530237345322543e-16,
  -7.315946267291202e-18,   2.989762673025736e-01,  -2.577278729084999e-03,   3.331640193004297e-05,  -4.784105334798332e-07,   7.211418233051624e-09,  -1.117773516626610e-10,
   1.763985501678892e-12,  -2.818014098445842e-14,   4.537870514426907e-16,  -7.330748467988460e-18,   2.989840702830465e-01,  -2.577614892464797e-03,   3.332654258824826e-05,
  -4.786727328432814e-07,   7.217631767287624e-09,  -1.119164956007606e-10,   1.766977150418709e-12,  -2.824237910542886e-14,   4.550414201521418e-16,  -7.355074316585664e-18,
   2.989923507169032e-01,  -2.577971655010206e-03,   3.333730579434064e-05,  -4.789510654510132e-07,   7.224228639425905e-09,  -1.120642496953185e-10,   1.770154520702237e-12,
  -2.830849337305587e-14,   4.563741164578980e-16,  -7.380920780746251e-18,   2.989988680907918e-01,  -2.578252477688065e-03,   3.334577880015756e-05,  -4.791702007406382e-07,
   7.229423188484444e-09,  -1.121806138133978e-10,   1.772657301294036e-12,  -2.836057985556285e-14,   4.574241973935955e-16,  -7.401287331062394e-18,   2.990026296468495e-01,
  -2.578414565464038e-03,   3.335066966213521e-05,  -4.792967025125081e-07,   7.232422177577298e-09,  -1.122478022547906e-10,   1.774102576672503e-12,  -2.839066172533193e-14,
   4.580307177433169e-16,  -7.413051388627925e-18,   2.990040421962157e-01,  -2.578475434725135e-03,   3.335250640423787e-05,  -4.793442117101833e-07,   7.233548538278254e-09,
  -1.122730383149303e-10,   1.774645456782097e-12,  -2.840196187767741e-14,   4.582585663463950e-16,  -7.417470822931578e-18,   2.990042763490066e-01,  -2.578485524871076e-03,
   3.335281087975409e-05,  -4.793520873839615e-07,   7.233735259791826e-09,  -1.122772218766765e-10,   1.774735455628129e-12,  -2.840383525659566e-14,   4.582963404829798e-16,
  -7.418203508390876e-18,   3.020225623800242e-02,  -2.603373538953395e-04,   3.365019279618771e-06,  -4.831361531252750e-08,   7.281720645056434e-10,  -1.128807790586455e-11,
   1.783802759775496e-13,  -2.866577038925074e-15,   4.709578769945027e-17,  -8.052452188467163e-19,   3.020273635968493e-02,  -2.603580370666973e-04,   3.365643196328569e-06,
  -4.832975203348077e-08,   7.285550930551837e-10,  -1.129671167542267e-11,   1.785699630530852e-13,  -2.870769579248354e-15,   4.719324261951240e-17,  -8.077368056179374e-19,
   3.020352462167864e-02,  -2.603919968374141e-04,   3.366667693718740e-06,  -4.835625198188013e-08,   7.291841901752136e-10,  -1.131089450588996e-11,   1.788816476833972e-13,
  -2.877661633326268e-15,   4.735356369467903e-17,  -8.118396203801044e-19,   3.020436111632143e-02,  -2.604280375726115e-04,   3.367755087024303e-06,  -4.838438258917544e-08,
   7.298521103394514e-10,  -1.132595596468916e-11,   1.792127537723063e-13,  -2.884987328567807e-15,   4.752413058877312e-17,  -8.162100262006088e-19,   3.020501950554181e-02,
  -2.604564067407280e-04,   3.368611104771750e-06,  -4.840653029985951e-08,   7.303780564570919e-10,  -1.133781838381661e-11,   1.794736148890662e-13,  -2.890761899633771e-15,
   4.765869716671535e-17,  -8.196619095459062e-19,   3.020539950030932e-02,  -2.604727811150240e-04,   3.369105222978100e-06,  -4.841931569555283e-08,   7.306817063302126e-10,
  -1.134466801713976e-11,   1.796242748695102e-13,  -2.894098216164013e-15,   4.773649057510236e-17,  -8.216590233046732e-19,   3.020554219693844e-02,  -2.604789302282935e-04,
   3.369290786977342e-06,  -4.842411740401767e-08,   7.307957518256079e-10,  -1.134724080321186e-11,   1.796808703625248e-13,  -2.895351736074614e-15,   4.776572783646312e-17,
  -8.224098993086677e-19,   3.020556585120129e-02,  -2.604799495515080e-04,   3.369321547800131e-06,  -4.842491339102487e-08,   7.308146576569593e-10,  -1.134766731524521e-11,
   1.796902529929179e-13,  -2.895559561883460e-15,   4.777057565411608e-17,  -8.225344173789230e-19,   2.891623964061645e-01,  -2.331743807911797e-03,   2.819620773618395e-05,
  -3.787429400140105e-07,   5.340414952133017e-09,  -7.743283865222834e-11,   1.143191919130150e-12,  -1.709041926267161e-14,   2.577818226001781e-16,  -3.910347839395591e-18,
   2.891664181316672e-01,  -2.331905892541737e-03,   2.820078151990707e-05,  -3.788535668795596e-07,   5.342867529314581e-09,  -7.748423618208268e-11,   1.144227081205647e-12,
  -1.711064433818830e-14,   2.581669197071133e-16,  -3.917491082332363e-18,   2.891730209178497e-01,  -2.332172014940391e-03,   2.820829164386711e-05,  -3.790352317903149e-07,
   5.346895433197109e-09,  -7.756865736000979e-11,   1.145927579848891e-12,  -1.714387361883284e-14,   2.587997153176030e-16,  -3.929230359890990e-18,   2.891800276271210e-01,
  -2.332454437927927e-03,   2.821626252917085e-05,  -3.792280643680113e-07,   5.351171528085266e-09,  -7.765829433421985e-11,   1.147733453365258e-12,  -1.717916855772219e-14,
   2.594719715141867e-16,  -3.941703625059111e-18,   2.891855424096286e-01,  -2.332676740017397e-03,   2.822253715214511e-05,  -3.793798768181952e-07,   5.354538414597307e-09,
  -7.772888226630250e-11,   1.149155781533882e-12,  -1.720697202042741e-14,   2.600016284420010e-16,  -3.951532456704645e-18,   2.891887252850682e-01,  -2.332805048416941e-03,
   2.822615895891480e-05,  -3.794675116819327e-07,   5.356482143173454e-09,  -7.776963725204203e-11,   1.149977074598646e-12,  -1.722302843540598e-14,   2.603075395755363e-16,
  -3.957209803708243e-18,   2.891899205217212e-01,  -2.332853232051943e-03,   2.822751909663524e-05,  -3.795004234014853e-07,   5.357212152166658e-09,  -7.778494442716811e-11,
   1.150285561442046e-12,  -1.722905976296275e-14,   2.604224568285191e-16,  -3.959342637293050e-18,   2.891901186511658e-01,  -2.332861219313934e-03,   2.822774456490669e-05,
  -3.795058791988492e-07,   5.357333167915806e-09,  -7.778748198322311e-11,   1.150336701938184e-12,  -1.723005964652408e-14,   2.604415083603709e-16,  -3.959696234234802e-18,
   2.921133404491580e-02,  -2.355539611565088e-04,   2.848395894769095e-06,  -3.826088026704292e-08,   5.394998977864193e-10,  -7.823077986860082e-12,   1.155447718211039e-13,
  -1.730325709616378e-15,   2.625975134866226e-17,  -4.060036331246809e-19,   2.921174032177997e-02,  -2.355703350649231e-04,   2.848857948735955e-06,  -3.827205705581361e-08,
   5.397477954993447e-10,  -7.828282657523940e-12,   1.156502867889243e-13,  -1.732429706018749e-15,   2.630207663357620e-17,  -4.068951467375784e-19,   2.921240733877727e-02,
  -2.355972189455687e-04,   2.849616638514268e-06,  -3.829041093147400e-08,   5.401549229932515e-10,  -7.836831527379554e-12,   1.158236291394737e-13,  -1.735887080636175e-15,
   2.637165634979275e-17,  -4.083617167331079e-19,   2.921311516030266e-02,  -2.356257495242368e-04,   2.850421875566798e-06,  -3.830989311038384e-08,   5.405871387458845e-10,
  -7.845908741327688e-12,   1.160077253503269e-13,  -1.739560146125686e-15,   2.644561641550269e-17,  -4.099219570294395e-19,   2.921367226658782e-02,  -2.356482066457920e-04,
   2.851055752406639e-06,  -3.832523097379680e-08,   5.409274556425310e-10,  -7.853057050181567e-12,   1.161527307644848e-13,  -1.742454148191720e-15,   2.650391814317671e-17,
  -4.111528484411693e-19,   2.921399380237131e-02,  -2.356611684554025e-04,   2.851421635688185e-06,  -3.833408487435669e-08,   5.411239236733204e-10,  -7.857184281362297e-12,
   1.162364646582829e-13,  -1.744125649853777e-15,   2.653760326454470e-17,  -4.118644148649112e-19,   2.921411454581892e-02,  -2.356660360019486e-04,   2.851559039947336e-06,
  -3.833741000277788e-08,   5.411977115660111e-10,  -7.858734438499222e-12,   1.162679167272693e-13,  -1.744753564368533e-15,   2.655025956320493e-17,  -4.121318413137349e-19,
   2.921413456096166e-02,  -2.356668428810806e-04,   2.851581817274073e-06,  -3.833796121155050e-08,   5.412099436087470e-10,  -7.858991417214349e-12,   1.162731308412072e-13,
  -1.744857663328735e-15,   2.655235790592711e-17,  -4.121761830155899e-19,   2.802596828688486e-01,  -2.123009972053514e-03,   2.411728793779901e-05,  -3.043422821795489e-07,
   4.031682663794754e-09,  -5.492189038959084e-11,   7.618536178850525e-13,  -1.070258429099314e-14,   1.517439355228792e-16,  -2.165633119110333e-18,   2.802631218775100e-01,
  -2.123140179620346e-03,   2.412073962490932e-05,  -3.044207117832661e-07,   4.033316162309309e-09,  -5.495405358015089e-11,   7.624624316905085e-13,  -1.071377392350974e-14,
   1.519448106973551e-16,  -2.169164164425823e-18,   2.802687679234963e-01,  -2.123353960685882e-03,   2.412640713851376e-05,  -3.045494998318893e-07,   4.035998756115884e-09,
  -5.500687889613677e-11,   7.634624782596909e-13,  -1.073215663550077e-14,   1.522748621173595e-16,  -2.174966727237691e-18,   2.802747592995243e-01,  -2.123580831913076e-03,
   2.413242218230405e-05,  -3.046861989883000e-07,   4.038846475738053e-09,  -5.506296359029262e-11,   7.645243939248424e-13,  -1.075167995581761e-14,   1.526254561552440e-16,
  -2.181131557217470e-18,   2.802794748950496e-01,  -2.123759404654294e-03,   2.413715704832241e-05,  -3.047938145951042e-07,   4.041088573381861e-09,  -5.510712640921635e-11,
   7.653606987192984e-13,  -1.076705783901110e-14,   1.529016537366207e-16,  -2.185989008258087e-18,   2.802821964981952e-01,  -2.123862472054247e-03,   2.413989003099786e-05,
  -3.048559347584399e-07,   4.042382903626278e-09,  -5.513262320790202e-11,   7.658435758060051e-13,  -1.077593790115910e-14,   1.530611643645192e-16,  -2.188794623664461e-18,
   2.802832185138463e-01,  -2.123901176698552e-03,   2.414091636857696e-05,  -3.048792639724968e-07,   4.042869007802844e-09,  -5.514219931909616e-11,   7.660249442956860e-13,
  -1.077927343319199e-14,   1.531210832943548e-16,  -2.189848592308948e-18,   2.802833879289730e-01,  -2.123907592642884e-03,   2.414108650269981e-05,  -3.048831312542340e-07,
   4.042949590237062e-09,  -5.514378679208112e-11,   7.660550110057381e-13,  -1.077982639709956e-14,   1.531310168281285e-16,  -2.190023325501114e-18,   2.831197733920701e-02,
  -2.144675598577778e-04,   2.436340909453858e-06,  -3.074482540703855e-08,   4.072839805725017e-10,  -5.548359669863999e-12,   7.697221260489727e-14,  -1.081795731717424e-15,
   1.536450120562517e-17,  -2.205597106954887e-19,   2.831232474964435e-02,  -2.144807134987481e-04,   2.436689601916345e-06,  -3.075274859665966e-08,   4.074490192562451e-10,
  -5.551610810367785e-12,   7.703386755746635e-14,  -1.082936032250073e-15,   1.538535701579484e-17,  -2.209446848146119e-19,   2.831289511613628e-02,  -2.145023097811976e-04,
   2.437262139130471e-06,  -3.076575914678369e-08,   4.077200523306694e-10,  -5.556950553668193e-12,   7.713514440703629e-14,  -1.084809452360692e-15,   1.541962973272295e-17,
  -2.215775641830073e-19,   2.831350036804821e-02,  -2.145252284391615e-04,   2.437869784168634e-06,  -3.077956890323600e-08,   4.080077690322481e-10,  -5.562619792680902e-12,
   7.724268893493702e-14,  -1.086799244244718e-15,   1.545604272551398e-17,  -2.222502991808239e-19,   2.831397673995261e-02,  -2.145432679571834e-04,   2.438348104530797e-06,
  -3.079044055480038e-08,   4.082342975079469e-10,  -5.567083946698667e-12,   7.732738643039866e-14,  -1.088366633000725e-15,   1.548473401471767e-17,  -2.227806165754405e-19,
   2.831425167771325e-02,  -2.145536798834978e-04,   2.438624192868659e-06,  -3.079671612094520e-08,   4.083650691819286e-10,  -5.569661273036998e-12,   7.737629083071252e-14,
  -1.089271770205051e-15,   1.550130599305098e-17,  -2.230870230160438e-19,   2.831435492226414e-02,  -2.145575898482898e-04,   2.438727874403737e-06,  -3.079907290862349e-08,
   4.084141823658085e-10,  -5.570629269187595e-12,   7.739465942316026e-14,  -1.089611765356951e-15,   1.550753152223656e-17,  -2.232021478875135e-19,   2.831437203666807e-02,
  -2.145582379905710e-04,   2.438745061504202e-06,  -3.079946359311526e-08,   4.084223239546781e-10,  -5.570789738138771e-12,   7.739770451792104e-14,  -1.089668130073002e-15,
   1.550856362930854e-17,  -2.232212349772354e-19,   2.721318352348364e-01,  -1.943660975981414e-03,   2.081893522098106e-05,  -2.477222671581719e-07,   3.094374723981019e-09,
  -3.974910536705321e-11,   5.199507846745443e-13,  -6.888261090291776e-15,   9.211086002610720e-17,  -1.240224469260319e-18,   2.721348032482926e-01,  -1.943766934571484e-03,
   2.082158365004079e-05,  -2.477790078156780e-07,   3.095489006088683e-09,  -3.976979302904382e-11,   5.203200644237957e-13,  -6.894663349024715e-15,   9.221936185707061e-17,
  -1.242028605124292e-18,   2.721396759963046e-01,  -1.943940900300556e-03,   2.082593216417422e-05,  -2.478721781123961e-07,   3.097318851513078e-09,  -3.980376903597866e-11,
   5.209266101895878e-13,  -6.905180394021591e-15,   9.239762217473583e-17,  -1.244993075371761e-18,   2.721448467304274e-01,  -1.944125515247823e-03,   2.083054721066569e-05,
  -2.479710679882639e-07,   3.099261235258648e-09,  -3.983983905263181e-11,   5.215706281385267e-13,  -6.916348904579834e-15,   9.258695647719548e-17,  -1.248142265189676e-18,
   2.721489163946392e-01,  -1.944270825462173e-03,   2.083417995501172e-05,  -2.480489158361756e-07,   3.100790463766626e-09,  -3.986823999761906e-11,   5.220777822656476e-13,
  -6.925145183461183e-15,   9.273609857685985e-17,  -1.250623344685485e-18,   2.721512651853899e-01,  -1.944354693756283e-03,   2.083627675484024e-05,  -2.480938517697556e-07,
   3.101673236906354e-09,  -3.988463621294718e-11,   5.223705945950888e-13,  -6.930224335998270e-15,   9.282222555071597e-17,  -1.252056287390310e-18,   2.721521472000787e-01,
  -1.944386188444271e-03,   2.083706417544889e-05,  -2.481107272510417e-07,   3.102004769621979e-09,  -3.989079418985152e-11,   5.224805719362125e-13,  -6.932132108949900e-15,
   9.285457732508306e-17,  -1.252594572670768e-18,   2.721522934077149e-01,  -1.944391409208702e-03,   2.083719470439866e-05,  -2.481135246875756e-07,   3.102059728163858e-09,
  -3.989181501727457e-11,   5.224988034892991e-13,  -6.932448376040655e-15,   9.285994063502405e-17,  -1.252683811769100e-18,   2.749089798931496e-02,  -1.963496317293493e-04,
   2.103139557569763e-06,  -2.502503264316604e-08,   3.125955321743328e-10,  -4.015494133872608e-12,   5.252716694764655e-14,  -6.959528655963624e-16,   9.310692098399223e-18,
  -1.255742102722992e-19,   2.749119781956320e-02,  -1.963603357214918e-04,   2.103407103431050e-06,  -2.503076464339530e-08,   3.127081009573102e-10,  -4.017584328244665e-12,
   5.256449602358525e-14,  -6.966012158125499e-16,   9.321744079225343e-18,  -1.257610752355955e-19,   2.749169006707745e-02,  -1.963779098303665e-04,   2.103846392888547e-06,
  -2.504017680398790e-08,   3.128929585547853e-10,  -4.021017124416713e-12,   5.262580966009739e-14,  -6.976662820217732e-16,   9.339902524825519e-18,  -1.260681656516165e-19,
   2.749221241730215e-02,  -1.963965597288423e-04,   2.104312607604697e-06,  -2.505016676287762e-08,   3.130891852302229e-10,  -4.024661495242095e-12,   5.269091156907261e-14,
  -6.987973439987653e-16,   9.359190213770011e-18,  -1.263944496147846e-19,   2.749262353687726e-02,  -1.964112390426628e-04,   2.104679589581404e-06,  -2.505803103437519e-08,
   3.132436734962638e-10,  -4.027531016892730e-12,   5.274217855629655e-14,  -6.996881800175846e-16,   9.374384348230652e-18,  -1.266515538743133e-19,   2.749286081292886e-02,
  -1.964197114615834e-04,   2.104891409537798e-06,  -2.506257050979105e-08,   3.133328544874362e-10,  -4.029187628403363e-12,   5.277177834706186e-14,  -7.002025733756324e-16,
   9.383159046413235e-18,  -1.268000610142302e-19,   2.749294991450709e-02,  -1.964228930714313e-04,   2.104970955232652e-06,  -2.506427528873811e-08,   3.133663471451818e-10,
  -4.029809807322076e-12,   5.278289574697210e-14,  -7.003957850950332e-16,   9.386455142167086e-18,  -1.268558509901964e-19,   2.749296468447781e-02,  -1.964234204757838e-04,
   2.104984141344244e-06,  -2.506455788873332e-08,   3.133718992599361e-10,  -4.029912947914104e-12,   5.278473874093107e-14,  -7.004278154414810e-16,   9.387001575754284e-18,
  -1.268651002474148e-19,   2.646725811637494e-01,  -1.788214809665099e-03,   1.811912403084283e-05,  -2.039541829715328e-07,   2.410119943863351e-09,  -2.928873853391204e-11,
   3.624540676696610e-13,  -4.542864187372101e-15,   5.747514942195471e-17,  -7.322703624187825e-19,   2.646751637954499e-01,  -1.788302029882600e-03,   1.812118629800202e-05,
  -2.039959781873497e-07,   2.410896379214647e-09,  -2.930237508740249e-11,   3.626843419274069e-13,  -4.546641300893621e-15,   5.753572757375679e-17,  -7.332242893984131e-19,
   2.646794038163202e-01,  -1.788445228913764e-03,   1.812457232345352e-05,  -2.040646058518569e-07,   2.412171379495703e-09,  -2.932476987294717e-11,   3.630625492616677e-13,
  -4.552845586198627e-15,   5.763524511050974e-17,  -7.347915988840508e-19,   2.646839030956422e-01,  -1.788597191727180e-03,   1.812816581085991e-05,  -2.041374442129759e-07,
   2.413524737316283e-09,  -2.934854358753127e-11,   3.634640942518934e-13,  -4.559433629190724e-15,   5.774093433284801e-17,  -7.364563816740893e-19,   2.646874442617263e-01,
  -1.788716799985839e-03,   1.813099437700680e-05,  -2.041947822222081e-07,   2.414590187566650e-09,  -2.936726167767735e-11,   3.637802845132729e-13,  -4.564621943189333e-15,
   5.782417999478448e-17,  -7.377678398388768e-19,   2.646894880219507e-01,  -1.788785833352628e-03,   1.813262698734485e-05,  -2.042278786560323e-07,   2.415205220290647e-09,
  -2.937806748219848e-11,   3.639628331683432e-13,  -4.567617620116039e-15,   5.787224984242787e-17,  -7.385252155380817e-19,   2.646902554901218e-01,  -1.788811757032698e-03,
   1.813324008458331e-05,  -2.042403077447186e-07,   2.415436197764428e-09,  -2.938212577963251e-11,   3.640313950623353e-13,  -4.568742791185113e-15,   5.789030568136814e-17,
  -7.388097136152735e-19,   2.646903827097945e-01,  -1.788816054304612e-03,   1.813334171611619e-05,  -2.042423680994016e-07,   2.415474486988671e-09,  -2.938279853272546e-11,
   3.640427608666349e-13,  -4.568929318355776e-15,   5.789329896596097e-17,  -7.388568783076564e-19,   2.673736030566056e-02,  -1.806463799980108e-04,   1.830403232452882e-06,
  -2.060355675739216e-08,   2.434715882540722e-10,  -2.958766382196431e-12,   3.661552502422056e-14,  -4.589376596459218e-16,   5.807049765212952e-18,  -7.401954414316088e-20,
   2.673762120444385e-02,  -1.806551910293847e-04,   1.830611563772299e-06,  -2.060777893621180e-08,   2.435500246865019e-10,  -2.960144003280805e-12,   3.663879126127936e-14,
  -4.593194773091737e-16,   5.813183908545161e-18,  -7.411665012129877e-20,   2.673804953353389e-02,  -1.806696570693989e-04,   1.830953621855047e-06,  -2.061471174581672e-08,
   2.436788267531917e-10,  -2.962406417750762e-12,   3.667700426324161e-14,  -4.599466534294896e-16,   5.823261197616486e-18,  -7.427620311668527e-20,   2.673850405304613e-02,
  -1.806850084312200e-04,   1.831316637854712e-06,  -2.062206992269741e-08,   2.438155446009840e-10,  -2.964808138092825e-12,   3.671757529044970e-14,  -4.606126261817647e-16,
   5.833963636726733e-18,  -7.444568865714898e-20,   2.673886178346608e-02,  -1.806970913192268e-04,   1.831602381104239e-06,  -2.062786224436864e-08,   2.439231776827474e-10,
  -2.966699118576999e-12,   3.674952234464598e-14,  -4.611371055342604e-16,   5.842393509630083e-18,  -7.457921054766787e-20,   2.673906824517559e-02,  -1.807040651055611e-04,
   1.831767308264985e-06,  -2.063120566690139e-08,   2.439853090398112e-10,  -2.967790766776609e-12,   3.676796660911609e-14,  -4.614399353182344e-16,   5.847261360702796e-18,
  -7.465632315441260e-20,   2.673914577520514e-02,  -1.807066839290986e-04,   1.831829243672648e-06,  -2.063246126125103e-08,   2.440086426667994e-10,  -2.968200753234340e-12,
   3.677489393626976e-14,  -4.615536778549506e-16,   5.849089817873330e-18,  -7.468529001395620e-20,   2.673915862700194e-02,  -1.807071180417248e-04,   1.831839510543914e-06,
  -2.063266939957605e-08,   2.440125106911002e-10,  -2.968268717613626e-12,   3.677604230967469e-14,  -4.615725337299951e-16,   5.849392938822838e-18,  -7.469009222952428e-20,
   2.577949978063031e-01,  -1.652437714287195e-03,   1.588513598725853e-05,  -1.696456193516998e-07,   1.902010317592072e-09,  -2.193042015583724e-11,   2.575012582544466e-13,
  -3.062279232407197e-15,   3.676160684140629e-17,  -4.444370411280940e-19,   2.577972616500525e-01,  -1.652510250287859e-03,   1.588676313259876e-05,  -1.696769055598328e-07,
   1.902561732066572e-09,  -2.193960827485062e-11,   2.576484629267250e-13,  -3.064570118097789e-15,   3.679646973715565e-17,  -4.449580903327290e-19,   2.578009782839313e-01,
  -1.652629339548213e-03,   1.588943469595645e-05,  -1.697282764014283e-07,   1.903467195699101e-09,  -2.195469701716973e-11,   2.578902238378186e-13,  -3.068332912000017e-15,
   3.685373844716275e-17,  -4.458141101643340e-19,   2.578049221480658e-01,  -1.652755715610260e-03,   1.589226989461976e-05,  -1.697827977049965e-07,   1.904428271919287e-09,
  -2.197071407960332e-11,   2.581468876557920e-13,  -3.072328157318023e-15,   3.691455341947153e-17,  -4.467232745628623e-19,   2.578080261552062e-01,  -1.652855183759464e-03,
   1.589450154648921e-05,  -1.698257155781293e-07,   1.905184867983051e-09,  -2.198332447416011e-11,   2.583489825255183e-13,  -3.075474341715749e-15,   3.696245021965432e-17,
  -4.474394157033533e-19,   2.578098176047071e-01,  -1.652912592591660e-03,   1.589578961097670e-05,  -1.698504880588977e-07,   1.905621604190259e-09,  -2.199060413709834e-11,
   2.584656551640994e-13,  -3.077290830343526e-15,   3.699010647565269e-17,  -4.478529650301735e-19,   2.578104903243376e-01,  -1.652934150900758e-03,   1.589627331743489e-05,
  -1.698597910781721e-07,   1.905785619959272e-09,  -2.199333809300786e-11,   2.585094744126076e-13,  -3.077973084347270e-15,   3.700049433616816e-17,  -4.480083042361686e-19,
   2.578106018379064e-01,  -1.652937724537148e-03,   1.589635350004585e-05,  -1.698613332240466e-07,   1.905812808816525e-09,  -2.199379130485864e-11,   2.585167384766297e-13,
  -3.078086185335964e-15,   3.700221641315869e-17,  -4.480340564299037e-19,   2.604258329681556e-02,  -1.669301079680242e-04,   1.604724609549827e-06,  -1.713768777984011e-08,
   1.921420655812845e-10,  -2.215422778114763e-12,   2.601294479284534e-14,  -3.093553722765723e-16,   3.713813330336432e-18,  -4.490432403387609e-20,   2.604281199147578e-02,
  -1.669374355921465e-04,   1.604888984613758e-06,  -1.714084832938916e-08,   1.921977698374567e-10,  -2.216350974279435e-12,   2.602781607790899e-14,  -3.095868381021369e-16,
   3.717337480292416e-18,  -4.495707779590656e-20,   2.604318744774226e-02,  -1.669494660505243e-04,   1.605158867326102e-06,  -1.714603783940574e-08,   1.922892403754527e-10,
  -2.217875259445169e-12,   2.605223987030640e-14,  -3.099670225610963e-16,   3.723126567142506e-18,  -4.504374690621469e-20,   2.604358585892606e-02,  -1.669622326253603e-04,
   1.605445280561738e-06,  -1.715154561079419e-08,   1.923863289352566e-10,  -2.219493324878308e-12,   2.607816923110154e-14,  -3.103706939621864e-16,   3.729274164516975e-18,
  -4.513579830727329e-20,   2.604389942732426e-02,  -1.669722809489910e-04,   1.605670723188090e-06,  -1.715588119741177e-08,   1.924627607743838e-10,  -2.220767244171283e-12,
   2.609858579173123e-14,  -3.106885783947641e-16,   3.734115926888405e-18,  -4.520830757195782e-20,   2.604408040047446e-02,  -1.669780804187690e-04,   1.605800844128992e-06,
  -1.715838372674046e-08,   1.925068801577686e-10,  -2.221502645703717e-12,   2.611037260508485e-14,  -3.108721130828757e-16,   3.736911634809168e-18,  -4.525017988947020e-20,
   2.604414835895761e-02,  -1.669802582502507e-04,   1.605849708405645e-06,  -1.715932352275088e-08,   1.925234491403829e-10,  -2.221778833684984e-12,   2.611479943013568e-14,
  -3.109410468104268e-16,   3.737961721722222e-18,  -4.526590824012985e-20,   2.604415962411571e-02,  -1.669806192608383e-04,   1.605857808494488e-06,  -1.715947931115655e-08,
   1.925261957769193e-10,  -2.221824617769001e-12,   2.611553327982011e-14,  -3.109524743342167e-16,   3.738135802946319e-18,  -4.526851569682543e-20,   2.514272050636969e-01,
  -1.533013557637942e-03,   1.401852086902897e-05,  -1.424134769375489e-07,   1.518886237979358e-09,  -1.665980893291715e-11,   1.860886501220030e-13,  -2.105279253083448e-15,
   2.404314586240092e-17,  -2.765378515263065e-19,   2.514292026147965e-01,  -1.533074441047738e-03,   1.401982001871859e-05,  -1.424372384023746e-07,   1.519284608436095e-09,
  -1.666612324533410e-11,   1.861848809266107e-13,  -2.106703856051336e-15,   2.406376943134366e-17,  -2.768310967485763e-19,   2.514324820523038e-01,  -1.533174398366091e-03,
   1.402195302947251e-05,  -1.424762531979258e-07,   1.519938746733289e-09,  -1.667649229370206e-11,   1.863429188771070e-13,  -2.109043660744256e-15,   2.409764543072860e-17,
  -2.773128290169358e-19,   2.514359619712312e-01,  -1.533280470794157e-03,   1.402421665351879e-05,  -1.425176597548010e-07,   1.520633040200536e-09,  -1.668749884631957e-11,
   1.865106902682132e-13,  -2.111527854211365e-15,   2.413361642017009e-17,  -2.778244231353367e-19,   2.514387008176974e-01,  -1.533363957584863e-03,   1.402599837997082e-05,
  -1.425502533369539e-07,   1.521179599230044e-09,  -1.669616409642645e-11,   1.866427858406252e-13,  -2.113483999497725e-15,   2.416194456688914e-17,  -2.782273684159131e-19,
   2.514402815124595e-01,  -1.533412142343737e-03,   1.402702674633952e-05,  -1.425690662981891e-07,   1.521495087840251e-09,  -1.670116619876809e-11,   1.867190442785961e-13,
  -2.114613359065382e-15,   2.417830082938545e-17,  -2.784600435641615e-19,   2.514408750890620e-01,  -1.533430236747896e-03,   1.402741292650897e-05,  -1.425761312375704e-07,
   1.521613568048319e-09,  -1.670304476801535e-11,   1.867476845230606e-13,  -2.115037526083917e-15,   2.418444419322666e-17,  -2.785474395120344e-19,   2.514409734834078e-01,
  -1.533433236183298e-03,   1.402747694236900e-05,  -1.425773023780052e-07,   1.521633208424200e-09,  -1.670335617989611e-11,   1.867524322879259e-13,  -2.115107842126559e-15,
   2.418546261888385e-17,  -2.785619279137878e-19,   2.539930559814832e-02,  -1.548658182265124e-04,   1.416158189828577e-06,  -1.438668270879416e-08,   1.534386698612167e-10,
  -1.682982537619648e-12,   1.879877654690661e-14,  -2.126767535054520e-16,   2.428872052654453e-18,  -2.793708937193289e-20,   2.539950739178802e-02,  -1.548719686998935e-04,
   1.416289430599249e-06,  -1.438908310430255e-08,   1.534789134622760e-10,  -1.683620413883619e-12,   1.880849792377526e-14,  -2.128206737286992e-16,   2.430955811432820e-18,
  -2.796673147855255e-20,   2.539983868225207e-02,  -1.548820664396200e-04,   1.416504908444057e-06,  -1.439302439919819e-08,   1.535449948703741e-10,  -1.684667902426910e-12,
   1.882446315006451e-14,  -2.130570520836495e-16,   2.434378569514519e-18,  -2.801542660728388e-20,   2.540019022545232e-02,  -1.548927819308758e-04,   1.416733580910934e-06,
  -1.439720731106581e-08,   1.536151327758771e-10,  -1.685779792114549e-12,   1.884141166419650e-14,  -2.133080173773415e-16,   2.438013005924987e-18,  -2.806714052698031e-20,
   2.540046690513130e-02,  -1.549012158094257e-04,   1.416913571834680e-06,  -1.440049993165381e-08,   1.536703464678801e-10,  -1.686655161788486e-12,   1.885475615532761e-14,
  -2.135056367425411e-16,   2.440875228548595e-18,  -2.810787198509004e-20,   2.540062658772934e-02,  -1.549060834585576e-04,   1.417017457934842e-06,  -1.440240042676385e-08,
   1.537022172998391e-10,  -1.687160477698191e-12,   1.886245989651156e-14,  -2.136197301961290e-16,   2.442527835999667e-18,  -2.813139187341915e-20,   2.540068655114308e-02,
  -1.549079113645750e-04,   1.417056470054438e-06,  -1.440311413060773e-08,   1.537141862352713e-10,  -1.687350252090673e-12,   1.886535317681448e-14,  -2.136625816377451e-16,
   2.443148550752295e-18,  -2.814022627720281e-20,   2.540069649099051e-02,  -1.549082143690825e-04,   1.417062936969586e-06,  -1.440323243982243e-08,   1.537161703167874e-10,
  -1.687381711138917e-12,   1.886583280312137e-14,  -2.136696853110012e-16,   2.443251450716689e-18,  -2.814169083545014e-20  };
  static constexpr double wi[4840] = {  -1.968896128093147e-01,   4.371145617795603e-02,  -6.382909103916530e-03,   7.282608088882853e-04,  -6.978287426269958e-05,
   5.829784749722743e-06,  -4.329099320840618e-07,   2.887165176166422e-08,  -1.735024792240006e-09,   9.373391929805600e-11,  -4.520324775682708e-12,   1.918966499452582e-13,
  -7.002447245683066e-15,   2.114921060821990e-16,  -1.875216126428360e-01,   4.165370753138239e-02,  -6.085376358833243e-03,   6.946281943008702e-04,  -6.658734891521297e-05,
   5.564732002364269e-06,  -4.133327485551059e-07,   2.756984375575891e-08,  -1.656793884021494e-09,   8.949321566297172e-11,  -4.314352488250805e-12,   1.830584239430669e-13,
  -6.675904908691576e-15,   2.015832208425889e-16,  -1.696183665982022e-01,   3.771207476164710e-02,  -5.514229536908931e-03,   6.299353780884244e-04,  -6.042925847838973e-05,
   5.053138807957764e-06,  -3.755005308111325e-07,   2.505246761060443e-08,  -1.505511635160625e-09,   8.129857921478906e-11,  -3.916960045515769e-12,   1.660469309861168e-13,
  -6.049155275919587e-15,   1.825902574267738e-16,  -1.448127133484195e-01,   3.223321138237676e-02,  -4.717969494436037e-03,   5.394900688431223e-04,  -5.179765455156049e-05,
   4.334490877028758e-06,  -3.222697722625009e-07,   2.150726351952671e-08,  -1.292458908036584e-09,   6.976967972834453e-11,  -3.359081161048083e-12,   1.422432299925596e-13,
  -5.175512297276131e-15,   1.561589787677423e-16,  -1.154434570028419e-01,   2.572412209394560e-02,  -3.768991045399378e-03,   4.313769062576437e-04,  -4.145205159129644e-05,
   3.471176638957033e-06,  -2.582149209380853e-07,   1.723720764746834e-08,  -1.035845946346011e-09,   5.589851535447447e-11,  -2.689378780993273e-12,   1.137654229312856e-13,
  -4.134434523177273e-15,   1.247074560264614e-16,  -8.436757589832863e-02,   1.881604971991396e-02,  -2.759059294191456e-03,   3.160215939073916e-04,  -3.038761128324336e-05,
   2.546065324236974e-06,  -1.894751857660249e-07,   1.265124295627936e-08,  -7.602524065864420e-10,   4.101530354635412e-11,  -1.972219143372238e-12,   8.335883263623984e-14,
  -3.026560095818913e-15,   9.127130209252022e-17,  -5.467531534660518e-02,   1.220101946594128e-02,  -1.790021723815987e-03,   2.051292312178911e-04,  -1.973325643377978e-05,
   1.653983196352880e-06,  -1.231206396151976e-07,   8.221934254508727e-09,  -4.940782405388181e-10,   2.665056588072981e-11,  -1.281019952839932e-12,   5.411462647017604e-14,
  -1.963569565075130e-15,   5.920798289819948e-17,  -2.934775440849082e-02,   6.551021273760696e-03,  -9.613665013700895e-04,   1.101964816465320e-04,  -1.060320180093461e-05,
   8.888960268740620e-07,  -6.617753236398186e-08,   4.419625631245408e-09,  -2.655862516201464e-10,   1.432440201209312e-11,  -6.884050372090920e-13,   2.907242037053633e-14,
  -1.054574622864597e-15,   3.179713657363959e-17,  -1.092349459200015e-02,   2.438600887106613e-03,  -3.578999877127880e-04,   4.102782656349386e-05,  -3.948043403735393e-06,
   3.309971261517807e-07,  -2.464362636036730e-08,   1.645851159199418e-09,  -9.890313918960012e-11,   5.334173414739113e-12,  -2.563339779981010e-13,   1.082433105875944e-14,
  -3.925999237693639e-16,   1.183731665691223e-17,  -1.233936607153275e-03,   2.754730501411584e-04,  -4.043026388310749e-05,   4.634783429573131e-06,  -4.460034973818925e-07,
   3.739254874368019e-08,  -2.783996968024028e-09,   1.859329879668517e-10,  -1.117315626882979e-11,   6.026022208324555e-13,  -2.895777933715806e-14,   1.222794398929406e-15,
  -4.435015461618929e-17,   1.337201952437702e-18,  -4.937919779135064e-01,   1.743679891551936e-01,  -3.393621505426606e-02,   4.622254525724992e-03,  -4.866501857559786e-04,
   4.184422712896877e-05,  -3.043645285313515e-06,   1.919326287937248e-07,  -1.069035133799482e-08,   5.340886842393123e-10,  -2.426761689226129e-11,   1.016504701525083e-12,
  -3.977003273990531e-14,   1.466393397181321e-15,  -4.709153010237723e-01,   1.663235461650892e-01,  -3.237576085984344e-02,   4.410244487801802e-03,  -4.643715570991016e-04,
   3.993149551522161e-05,  -2.904690748600398e-06,   1.831802925550500e-07,  -1.020348836386030e-08,   5.098060177930036e-10,  -2.316684695299536e-11,   9.705333843166702e-13,
  -3.797654506770959e-14,   1.400295060345367e-15,  -4.269415272024632e-01,   1.508462159520117e-01,  -2.937128952738192e-02,   4.001819426369384e-03,  -4.214349674500128e-04,
   3.624395312467361e-05,  -2.636727997032118e-06,   1.662978205710707e-07,  -9.264108518967855e-09,   4.629364532543858e-10,  -2.104108683271348e-11,   8.816966091750648e-13,
  -3.450847745932047e-14,   1.272461425432843e-15,  -3.655212669804027e-01,   1.292008193770607e-01,  -2.516523612755624e-02,   3.429618841078368e-03,  -3.612461771905562e-04,
   3.107237378282836e-05,  -2.260783128199501e-06,   1.426038383728585e-07,  -7.945206645275217e-09,   3.970974542784941e-10,  -1.805285939207613e-11,   7.567035315311731e-13,
  -2.962462780569718e-14,   1.092410662019049e-15,  -2.921773367565701e-01,   1.033187910962790e-01,  -2.013061675598072e-02,   2.744153683702137e-03,  -2.890994030176911e-04,
   2.487036961520069e-05,  -1.809754028354603e-06,   1.141671839502779e-07,  -6.361659202896656e-09,   3.180051322992533e-10,  -1.446044559339503e-11,   6.062967072031672e-13,
  -2.374252182228059e-14,   8.755278114093144e-16,  -2.139900501970444e-01,   7.569563276509103e-02,  -1.475239099445292e-02,   2.011403040232317e-03,  -2.119351816700641e-04,
   1.823430818845372e-05,  -1.326994084719495e-06,   8.372023169944222e-08,  -4.665560906116138e-09,   2.332519756187430e-10,  -1.060845181726256e-11,   4.448917754577074e-13,
  -1.742554917420064e-14,   6.425916390330772e-16,  -1.388767812032518e-01,   4.913624913652770e-02,  -9.577860794227977e-03,   1.306054729946672e-03,  -1.376284549743590e-04,
   1.184208476217268e-05,  -8.618581214425700e-07,   5.437801964825749e-08,  -3.030582299705544e-09,   1.515254711221533e-10,  -6.892304269491534e-12,   2.890890835645641e-13,
  -1.132459557126471e-14,   4.176126681167627e-16,  -7.459872119169628e-02,   2.639687309984649e-02,  -5.145853241256645e-03,   7.017445171188937e-04,  -7.395164969001706e-05,
   6.363339031865758e-06,  -4.631343411719515e-07,   2.922187090886193e-08,  -1.628642350705981e-09,   8.143382392083364e-11,  -3.704335746207539e-12,   1.553856043766114e-13,
  -6.087399144862914e-15,   2.244830578826643e-16,  -2.777338266821326e-02,   9.828038044345526e-03,  -1.915954049536006e-03,   2.612863524504095e-04,  -2.753551519935191e-05,
   2.369389206799908e-06,  -1.724500418852390e-07,   1.088100492181926e-08,  -6.064457201803497e-10,   3.032339616134593e-11,  -1.379407693776871e-12,   5.786348853119982e-14,
  -2.266919021562714e-15,   8.359648634462265e-17,  -3.137455594962391e-03,   1.110243725936137e-03,  -2.164405881536059e-04,   2.951698058171591e-05,  -3.110639069292581e-06,
   2.676663481697157e-07,  -1.948145822788971e-08,   1.229215152164672e-09,  -6.850963637870592e-11,   3.425615741654642e-12,  -1.558313825059845e-13,   6.536853044907348e-15,
  -2.560953911443869e-16,   9.443952913395703e-18,  -8.731066770254182e-02,   1.483217757035256e-02,  -1.777142564133499e-03,   1.722822760686362e-04,  -1.428866410086745e-05,
   1.056803184621998e-06,  -7.093831150894578e-08,   4.364815001652712e-09,  -2.490534410558223e-10,   1.318325208809090e-11,  -6.443029552233862e-13,   2.910714576102541e-14,
  -1.201869452079290e-15,   4.420737241870653e-17,  -8.312054791441027e-02,   1.412672136408315e-02,  -1.693329960416370e-03,   1.642252035206659e-04,  -1.362610905506389e-05,
   1.008193294512484e-06,  -6.770023885275179e-08,   4.166954285377983e-09,  -2.378210690817812e-10,   1.259061117307107e-11,  -6.153658696829572e-13,   2.779551387278051e-14,
  -1.147322751915181e-15,   4.217732353655989e-17,  -7.512754110660698e-02,   1.277840853632543e-02,  -1.532848999807808e-03,   1.487697251646758e-04,  -1.235279948513825e-05,
   9.146091882397727e-07,  -6.145576888163679e-08,   3.784802805638934e-09,  -2.161019900897821e-10,   1.144382776213962e-11,  -5.593586839328470e-13,   2.525869783402035e-14,
  -1.041987105581131e-15,   3.826707818487050e-17,  -6.408154268034090e-02,   1.091005747341168e-02,  -1.309902674836056e-03,   1.272438354230752e-04,  -1.057479511883307e-05,
   7.836125994724332e-07,  -5.269460975294907e-08,   3.247502822819653e-09,  -1.855177592331533e-10,   9.827347085957826e-12,  -4.803887136953293e-13,   2.168536352566379e-14,
  -8.939298181069746e-16,   3.279034722764033e-17,  -5.103959100416029e-02,   8.697718548950796e-03,  -1.045189098384272e-03,   1.016162523409901e-04,  -8.452212260610370e-06,
   6.268263372921032e-07,  -4.218305500838798e-08,   2.601435959125644e-09,  -1.486829161373124e-10,   7.878507234749060e-12,  -3.851544005140250e-13,   1.738063747797867e-14,
  -7.159720350704012e-16,   2.623213509308418e-17,  -3.727352744564808e-02,   6.356587322782582e-03,  -7.643941080658070e-04,   7.436757350573674e-05,  -6.189986575873591e-06,
   4.593517892162708e-07,  -3.093125561505986e-08,   1.908561621243175e-09,  -1.091247969414310e-10,   5.783772183472927e-12,  -2.827668441028261e-13,   1.275685349632113e-14,
  -5.252021714539460e-16,   1.922460287328209e-17,  -2.414401072464357e-02,   4.119531676961172e-03,  -4.956119092924735e-04,   4.823970472322671e-05,  -4.017055494948801e-06,
   2.982272489641861e-07,  -2.008961092004974e-08,   1.240034407370037e-09,  -7.091893270793493e-11,   3.759399433064122e-12,  -1.838029825256928e-13,   8.290694437838458e-15,
  -3.412008257461017e-16,   1.248165702489327e-17,  -1.295647268903507e-02,   2.211238340255759e-03,  -2.660923539340555e-04,   2.590575153046475e-05,  -2.157746803273979e-06,
   1.602264485683240e-07,  -1.079559494533479e-08,   6.664804764511054e-10,  -3.812174532986127e-11,   2.020989388086614e-12,  -9.881128103723861e-14,   4.456617967923211e-15,
  -1.833751038057928e-16,   6.706015848767204e-18,  -4.822103604439569e-03,   8.230452448408731e-04,  -9.905043222408284e-05,   9.643957299426421e-06,  -8.033313814752983e-07,
   5.965697564792405e-08,  -4.019798331556362e-09,   2.481832410869914e-10,  -1.419637824760651e-11,   7.526290157693665e-13,  -3.679818095272264e-14,   1.659630760196021e-15,
  -6.828371187311727e-17,   2.496854904928790e-18,  -5.447057016550818e-04,   9.297264527741809e-05,  -1.118905831382624e-05,   1.089426689855394e-06,  -9.074924998860417e-08,
   6.739299300854810e-09,  -4.541116470573131e-10,   2.803723379588952e-11,  -1.603774886265469e-12,   8.502540871462037e-14,  -4.157139321557411e-15,   1.874897464114273e-16,
  -7.713980093918751e-18,   2.820636222076647e-19,  -1.150724293643678e-01,   3.706982629733395e-02,  -6.718147763321765e-03,   8.693076952595991e-04,  -8.819962645722563e-05,
   7.372869970808861e-06,  -5.248207936557430e-07,   3.254677685529420e-08,  -1.786755484863743e-09,   8.798584148733643e-11,  -3.930326938699542e-12,   1.606453798542579e-13,
  -6.067715914321880e-15,   2.142599641604868e-16,  -1.096989905906441e-01,   3.534860365401130e-02,  -6.407694698593808e-03,   8.292802326029422e-04,  -8.414943731303955e-05,
   7.035024672839222e-06,  -5.008114817033340e-07,   3.105970699590868e-08,  -1.705204704843468e-09,   8.397374223910931e-11,  -3.751282106226845e-12,   1.533383767805074e-13,
  -5.792351225929336e-15,   2.045687117252715e-16,  -9.938793091762983e-02,   3.204166379508552e-02,  -5.810606056957911e-03,   7.522353241578872e-04,  -7.634898266091884e-05,
   6.384045908372045e-06,  -4.545322879776175e-07,   2.819250915561729e-08,  -1.547931118924574e-09,   7.623469056757187e-11,  -3.405843878681380e-12,   1.392360095560363e-13,
  -5.260640287863034e-15,   1.858418992741696e-16,  -8.502039456845344e-02,   2.742581784469089e-02,  -4.975981707212118e-03,   6.444226779982590e-04,  -6.542446238335559e-05,
   5.471760626758328e-06,  -3.896440626913226e-07,   2.417086890518759e-08,  -1.327262320929999e-09,   6.537306055783282e-11,  -2.920883917736503e-12,   1.194286290990740e-13,
  -4.513317807319887e-15,   1.594947974271332e-16,  -6.790692344282939e-02,   2.191780558920772e-02,  -3.978522435326387e-03,   5.154280876054916e-04,  -5.234233158894197e-05,
   4.378555446211021e-06,  -3.118469603770866e-07,   1.934723868648839e-08,  -1.062498900559862e-09,   5.233717518211313e-11,  -2.338664266470880e-12,   9.563730948626923e-14,
  -3.615033794478609e-15,   1.277920644925017e-16,  -4.970337723521000e-02,   1.604969446331668e-02,  -2.914448321193773e-03,   3.776819835911175e-04,  -3.836223697937095e-05,
   3.209626578385933e-06,  -2.286235691573214e-07,   1.418538620326964e-08,  -7.790884053859394e-10,   3.837960209190864e-11,  -1.715110102815280e-12,   7.014618795725196e-14,
  -2.651964437895716e-15,   9.377184264996947e-17,  -3.224338436471454e-02,   1.041482219468356e-02,  -1.891690214898023e-03,   2.451891970246334e-04,  -2.490806489206099e-05,
   2.084195617078697e-06,  -1.484710271636287e-07,   9.212764606018070e-09,  -5.060102422552349e-10,   2.492838262886839e-11,  -1.114058677318368e-12,   4.556746634562283e-14,
  -1.722941214742759e-15,   6.093262517278838e-17,  -1.731607237718210e-02,   5.594064493304027e-03,  -1.016204865555524e-03,   1.317268475051132e-04,  -1.338271442601799e-05,
   1.119869050311152e-06,  -7.977913069308239e-08,   4.950532967784940e-09,  -2.719151867722257e-10,   1.339612116435196e-11,  -5.986935070265256e-13,   2.448889587822608e-14,
  -9.260010290605413e-16,   3.275134975805282e-17,  -6.446358503056530e-03,   2.082647532635283e-03,  -3.783458082241463e-04,   4.904519434636009e-05,  -4.982843409042752e-06,
   4.169738343982023e-07,  -2.970553680599306e-08,   1.843338387290951e-09,  -1.012490151911418e-10,   4.988157649090970e-12,  -2.229305876574297e-13,   9.118859546313823e-15,
  -3.448197082533088e-16,   1.219616071594395e-17,  -7.282125085770764e-04,   2.352681536273489e-04,  -4.274047696445474e-05,   5.540503052962192e-06,  -5.629005874258322e-07,
   4.710474092315427e-08,  -3.355786009856347e-09,   2.082393097667371e-10,  -1.143797459369064e-11,   5.635067040424278e-13,  -2.518426111078000e-14,   1.030151417390925e-15,
  -3.895418226918340e-17,   1.377803440154435e-18,  -4.725773415371141e-02,   6.159175753081439e-03,  -5.996066243930548e-04,   4.985948907888985e-05,  -3.563539992367339e-06,
   2.282030045100489e-07,  -1.374776444630338e-08,   7.648131679756879e-10,  -3.887893460485114e-11,   1.923778246282429e-12,  -9.217843279907159e-14,   3.874981765432182e-15,
  -1.551045436427279e-16,   6.902341773658658e-18,  -4.497788661249627e-02,   5.864171594780672e-03,  -5.710925330029660e-04,   4.750365332187870e-05,  -3.396466040656819e-06,
   2.175905727030675e-07,  -1.311215639900010e-08,   7.297162413443656e-10,  -3.711373043201362e-11,   1.836697322535340e-12,  -8.800667037383070e-14,   3.702728626688257e-15,
  -1.482277229646926e-16,   6.582632397839237e-18,  -4.063375321668700e-02,   5.301187681921993e-03,  -5.165925147270917e-04,   4.299460746629224e-05,  -3.076149925879717e-06,
   1.972082653070585e-07,  -1.188985729200887e-08,   6.621126256192276e-10,  -3.370553715184571e-11,   1.668457936047252e-12,  -7.994660615428589e-14,   3.368541704033498e-15,
  -1.348794466793578e-16,   5.968250028756910e-18,  -3.463979112209276e-02,   4.522705863384327e-03,  -4.410681891798854e-04,   3.673398577976586e-05,  -2.630361077569889e-06,
   1.687720718274878e-07,  -1.018157322041389e-08,   5.674156817224969e-10,  -2.891592456793387e-11,   1.431815546273631e-12,  -6.860890646009274e-14,   2.895836467525464e-15,
  -1.159844233452719e-16,   5.110238874315201e-18,  -2.757471751139792e-02,   3.602973570355693e-03,  -3.516341109480266e-04,   2.930494009337487e-05,  -2.100055638860502e-06,
   1.348564862353895e-07,  -8.140311568426005e-09,   4.539909874542006e-10,  -2.315964125936063e-11,   1.147137751029965e-12,  -5.496900715643733e-14,   2.323933886080360e-15,
  -9.310497073395641e-17,   4.085522966082143e-18,  -2.012853733831625e-02,   2.631634291775707e-03,  -2.569893498339433e-04,   2.142872880927497e-05,  -1.536603500655462e-06,
   9.873901042203391e-08,  -5.962976903402703e-09,   3.327558200494998e-10,  -1.698904963925030e-11,   8.417086428090325e-13,  -4.033403183619238e-14,   1.707415487760961e-15,
  -6.842129364501293e-17,   2.992747215405110e-18,  -1.303449208533691e-02,   1.704831262380879e-03,  -1.665491787008139e-04,   1.389237900623463e-05,  -9.966065956015427e-07,
   6.406772116591557e-08,  -3.870340068060688e-09,   2.160630107739516e-10,  -1.103721795046179e-11,   5.469213665868301e-13,  -2.620836301091402e-14,   1.110382989422451e-15,
  -4.450353624634743e-17,   1.942513114012244e-18,  -6.993687668415410e-03,   9.149194381872416e-04,  -8.939886435841773e-05,   7.458381519744782e-06,  -5.351616267183808e-07,
   3.441099359311149e-08,  -2.079105939264951e-09,   1.160898891800974e-10,  -5.931905992179222e-12,   2.939659123996950e-13,  -1.408687569211432e-14,   5.970812250994372e-16,
  -2.393268305782680e-17,   1.043513043850677e-18,  -2.602754906809046e-03,   3.405187162032588e-04,  -3.327520796308419e-05,   2.776263464661028e-06,  -1.992202522102035e-07,
   1.281089237105070e-08,  -7.740749169036143e-10,   4.322458603090372e-11,  -2.208882631171639e-12,   1.094683100121087e-13,  -5.245743752245690e-15,   2.223771717703312e-16,
  -8.913758624154506e-18,   3.885141747345147e-19,  -2.940052284471168e-04,   3.846517397627289e-05,  -3.758827146069962e-06,   3.136148270454126e-07,  -2.250476806726098e-08,
   1.447190747771603e-09,  -8.744464733184428e-11,   4.882990155510890e-12,  -2.495366254245632e-13,   1.236665213179938e-14,  -5.926126997852888e-16,   2.512258303574586e-17,
  -1.007017401167527e-18,   4.388918699807176e-20,  -3.147498088411009e-02,   8.991557051440615e-03,  -1.473074931106441e-03,   1.760402795591071e-04,  -1.692610152204403e-05,
   1.360700631181726e-06,  -9.369002115133112e-08,   5.667706406674095e-09,  -3.063788045838064e-10,   1.485912629167190e-11,  -6.529857484225524e-13,   2.656426381396611e-14,
  -9.959630910547620e-16,   3.356831070047947e-17,  -2.999241530154174e-02,   8.570704110025158e-03,  -1.404548011761397e-03,   1.678932949964606e-04,  -1.614558971327212e-05,
   1.298130790197202e-06,  -8.939306149143956e-08,   5.408235730832190e-09,  -2.923663253686885e-10,   1.418057486653237e-11,  -6.232122120645235e-13,   2.535157700434251e-14,
  -9.505229233346385e-16,   3.205026165303930e-17,  -2.715288512891521e-02,   7.763542210950869e-03,  -1.272943278834900e-03,   1.522293864902240e-04,  -1.464374444235284e-05,
   1.177660802206238e-06,  -8.111506213976246e-08,   4.908171773478895e-09,  -2.653550474386491e-10,   1.287211020239743e-11,  -5.657798687635311e-13,   2.301300672600453e-14,
  -8.628826982985852e-16,   2.911647188284269e-17,  -2.320661242293329e-02,   6.639628385137017e-03,  -1.089353508567199e-03,   1.303437508723847e-04,  -1.254307595772138e-05,
   1.009012834881930e-06,  -6.951735442773549e-08,   4.207183190583285e-09,  -2.274795026520239e-10,   1.103650440432912e-11,  -4.851723557799493e-13,   1.973201889503944e-14,
  -7.399015791423275e-16,   2.498837526155198e-17,  -1.851917418017153e-02,   5.301911992697016e-03,  -8.704109944124671e-04,   1.042004995895939e-04,  -1.003086511396907e-05,
   8.071444823655863e-07,  -5.562358298473646e-08,   3.366931836738419e-09,  -1.820652378456979e-10,   8.834469430158495e-12,  -3.884268819814703e-13,   1.579565551307749e-14,
  -5.923280842264559e-16,   2.002095551349403e-17,  -1.354525786930592e-02,   3.879915477561699e-03,  -6.372770414882583e-04,   7.632264599909187e-05,  -7.349302635561351e-06,
   5.915009200136033e-07,  -4.077106823963838e-08,   2.468251018051687e-09,  -1.334798371940017e-10,   6.477691654743229e-12,  -2.848396937886859e-13,   1.158223104873716e-14,
  -4.343442366545693e-16,   1.469061242937767e-17,  -8.782943120497487e-03,   2.516650195087135e-03,  -4.134947481194754e-04,   4.953515343968764e-05,  -4.770764521699180e-06,
   3.840261018340572e-07,  -2.647377965123681e-08,   1.602853831975905e-09,  -8.668469903575456e-11,   4.207078356146458e-12,  -1.850097631368847e-13,   7.522509650228120e-15,
  -2.821081189055065e-16,   9.545662572897283e-18,  -4.715690167871867e-03,   1.351462073813558e-03,  -2.220871190237177e-04,   2.660893887610231e-05,  -2.562972392964292e-06,
   2.063237464795621e-07,  -1.422441464622471e-08,   8.612579585799203e-10,  -4.657932089563423e-11,   2.260728762529700e-12,  -9.942138593569320e-14,   4.042369276350747e-15,
  -1.515983084059275e-16,   5.130726775284904e-18,  -1.755392719383123e-03,   5.031057335390829e-04,  -8.268066161783753e-05,   9.906704915640751e-06,  -9.542456121497658e-07,
   7.682043599971368e-08,  -5.296297585483934e-09,   3.206848785192405e-10,  -1.734372362806800e-11,   8.417897035328202e-13,  -3.702038897240039e-14,   1.505195893754134e-15,
  -5.644861713662992e-17,   1.910602959057833e-18,  -1.982952248227916e-04,   5.683310903187466e-05,  -9.340068991129572e-06,   1.119125303406929e-06,  -1.077983147751436e-07,
   8.678214125075852e-09,  -5.983118801510838e-10,   3.622720933171630e-11,  -1.959292929435283e-12,   9.509585355584623e-14,  -4.182152867437599e-15,   1.700400787848299e-16,
  -6.376933415419237e-18,   2.158411217668749e-19,  -2.944874731237861e-02,   3.044798923698573e-03,  -2.356580610269900e-04,   1.680257772025986e-05,  -1.090846414821485e-06,
   5.963103508250814e-08,  -2.953110120773544e-09,   1.583873996199111e-10,  -8.174341249022686e-12,   3.036303496477036e-13,  -9.928724168652101e-15,   6.857352185846488e-16,
  -3.839345437499867e-17,   1.816680291648185e-19,  -2.802364797900483e-02,   2.898232178945258e-03,  -2.243934463960142e-04,   1.600333246897365e-05,  -1.039130623397682e-06,
   5.683102052009590e-08,  -2.816354621713620e-09,   1.510161154397057e-10,  -7.790627888463127e-12,   2.899888963019376e-13,  -9.520194345136761e-15,   6.529670535555447e-16,
  -3.643936572674018e-17,   1.851445397108529e-19,  -2.530999059385599e-02,   2.618824774421447e-03,  -2.028867935379045e-04,   1.447578848022705e-05,  -9.402196565364809e-07,
   5.146453902968681e-08,  -2.553448473257134e-09,   1.368615443175036e-10,  -7.055253701494497e-12,   2.635846877527357e-13,  -8.712668173545766e-15,   5.904381513263797e-16,
  -3.276132232679787e-17,   1.865485976882329e-19,  -2.156921900066437e-02,   2.233047350529887e-03,  -1.731298161370678e-04,   1.235913001170823e-05,  -8.030258749634056e-07,
   4.399932453422651e-08,  -2.186179482823543e-09,   1.171188443988386e-10,  -6.032283322496727e-12,   2.263556092585331e-13,  -7.542368396867042e-15,   5.039485377778425e-16,
  -2.777062833282630e-17,   1.785873570398936e-19,  -1.716439544411875e-02,   1.778008442244918e-03,  -1.379508855871043e-04,   9.852841115887938e-06,  -6.404034619709522e-07,
   3.512313027821520e-08,  -1.747555572549705e-09,   9.357746078617220e-11,  -4.815811502224264e-12,   1.814652551078988e-13,  -6.092440757292007e-15,   4.016770451389375e-16,
  -2.198896623147029e-17,   1.570120404743098e-19,  -1.252608714722396e-02,   1.298122074099268e-03,  -1.007769343372439e-04,   7.200723597538851e-06,  -4.681553492208988e-07,
   2.569620821351438e-08,  -1.279927092026156e-09,   6.851226888529148e-11,  -3.523588865016825e-12,   1.332135776477535e-13,  -4.499033822298083e-15,   2.935339123610666e-16,
  -1.598429838945795e-17,   1.232097824801678e-19,  -8.110017901931435e-03,   8.407185780497959e-04,  -6.529269539217873e-05,   4.666564019101171e-06,  -3.034531490569781e-07,
   1.666458119655373e-08,  -8.306634668365936e-10,   4.445356410682824e-11,  -2.285285591419406e-12,   8.658525808263638e-14,  -2.935495692776217e-15,   1.902275306331313e-16,
  -1.032296026868327e-17,   8.342245972283216e-20,  -4.351060731573962e-03,   4.511179263666246e-04,  -3.504212683715727e-05,   2.504860245096190e-06,  -1.628993508535572e-07,
   8.948222899934390e-09,  -4.461989322715139e-10,   2.387583000899125e-11,  -1.227154655945583e-12,   4.654599354450872e-14,  -1.581122891754963e-15,   1.021084021991295e-16,
  -5.531246934997531e-18,   4.575560177002242e-20,  -1.619230530034639e-03,   1.678906976546509e-04,  -1.304238689796326e-05,   9.323331995966042e-07,  -6.063472789601575e-08,
   3.331031649199170e-09,  -1.661217357994723e-10,   8.888706877513833e-12,  -4.568221498832115e-13,   1.733391010022055e-14,  -5.892134738523094e-16,   3.800585860706079e-17,
  -2.057523815320656e-18,   1.715679033164292e-20,  -1.829061552845087e-04,   1.896487228366388e-05,  -1.473279479425930e-06,   1.053179862876758e-07,  -6.849440865521694e-09,
   3.762866187706623e-10,  -1.876615735342011e-11,   1.004117772568209e-12,  -5.160456378673584e-14,   1.958230792263136e-15,  -6.657120138166215e-17,   4.293210745052570e-18,
  -2.323989422144197e-19,   1.940319089913800e-21,  -1.022062431342343e-02,   2.532033529898220e-03,  -3.727965258785297e-04,   3.971134366844091e-05,  -3.482572464958173e-06,
   2.667572720829558e-07,  -1.778983081793047e-08,   1.026003762634429e-09,  -5.307923789144273e-11,   2.586837211619099e-12,  -1.153463212011568e-13,   4.330433234800114e-15,
  -1.481426804767183e-16,   6.284286980535989e-18,  -9.735515794399310e-03,   2.412572635719150e-03,  -3.553046320556822e-04,   3.786109193949619e-05,  -3.321285375551819e-06,
   2.544359876378762e-07,  -1.696961298621916e-08,   9.789170959085782e-10,  -5.065420899143137e-11,   2.468234616533170e-12,  -1.100339376146894e-13,   4.134486274201288e-15,
  -1.416028137688879e-16,   5.986716181300185e-18,  -8.807925977403337e-03,   2.183851992511185e-03,  -3.217745843387613e-04,   3.430892706194645e-05,  -3.011232706819539e-06,
   2.307362236101668e-07,  -1.539132441615788e-08,   8.882182399670697e-10,  -4.597837669329811e-11,   2.239737217977447e-12,  -9.980983014718512e-14,   3.755831949864627e-15,
  -1.288915254290535e-16,   5.417706319390901e-18,  -7.521758914712806e-03,   1.866140817876822e-03,  -2.751212193489402e-04,   2.935596934007875e-05,  -2.578120690787350e-06,
   1.976033733983491e-07,  -1.318364193036682e-08,   7.611712435813133e-10,  -3.941964620909914e-11,   1.919578183340758e-12,  -8.550435839931475e-14,   3.223112570571745e-15,
  -1.108702237998686e-16,   4.628426684197298e-18,  -5.997772501128758e-03,   1.488956480163958e-03,  -2.196367478488780e-04,   2.345220741845273e-05,  -2.060871313295428e-06,
   1.580003038250882e-07,  -1.054332217756776e-08,   6.090034853200871e-10,  -3.155283782722455e-11,   1.535993705250376e-12,  -6.838932709025186e-14,   2.582203673854459e-15,
  -8.902105051365655e-17,   3.692398485645149e-18,  -4.384122500396980e-03,   1.088903801792308e-03,  -1.606971568952814e-04,   1.716851815907781e-05,  -1.509414996848764e-06,
   1.157467890547840e-07,  -7.724880691594220e-09,   4.463648740225410e-10,  -2.313442338754037e-11,   1.125895193243039e-12,  -5.011320938846435e-14,   1.894602673071756e-15,
  -6.542987177993571e-17,   2.700177290385617e-18,  -2.841549821181346e-03,   7.059987261737904e-04,  -1.042201588985401e-04,   1.113879945679366e-05,  -9.796064703518385e-07,
   7.513001471225229e-08,  -5.014621095903523e-09,   2.898269062005101e-10,  -1.502469601006910e-11,   7.310927319193193e-13,  -3.253364290204437e-14,   1.231020531727531e-15,
  -4.256112300049033e-17,   1.750667539600284e-18,  -1.525344643655799e-03,   3.790438081270930e-04,  -5.596332186474630e-05,   5.982369223980801e-06,  -5.262073244473126e-07,
   4.035991998802133e-08,  -2.693992773035246e-09,   1.557217775692724e-10,  -8.073588173244272e-12,   3.928226560225055e-13,  -1.747869269721045e-14,   6.616496163852497e-16,
  -2.288887917173693e-17,   9.399213304448241e-19,  -5.677600476904711e-04,   1.410949856976400e-04,  -2.083285133366705e-05,   2.227139064650062e-06,  -1.959094996331605e-07,
   1.502657110152630e-08,  -1.003029017541140e-09,   5.798085435427037e-11,  -3.006209897854964e-12,   1.462636736741719e-13,  -6.507772029587390e-15,   2.463860333888600e-16,
  -8.525083616517947e-18,   3.498767673468039e-19,  -6.413538195424956e-05,   1.593853700907154e-05,  -2.353364772991721e-06,   2.515894658651074e-07,  -2.213117626093996e-08,
   1.697503333182967e-09,  -1.133092666800433e-10,   6.549971743209913e-12,  -3.396071956386708e-13,   1.652311931513569e-14,  -7.351657527228722e-16,   2.783423348188473e-17,
  -9.631090611774154e-19,   3.952321236954782e-20,  -2.008697123681452e-02,   1.740684182598093e-03,  -1.087827527192060e-04,   6.125551792678090e-06,  -3.645219248389297e-07,
   2.069587003175924e-08,  -8.830138885715218e-10,   2.618647858085830e-11,  -1.159022969100513e-12,   1.032309193874637e-13,  -5.206607160698792e-15,  -9.048286361075271e-18,
   1.059446405369947e-17,   1.867272171979103e-19,  -1.911326562373056e-02,   1.656574994950436e-03,  -1.035575198390071e-04,   5.833807795926283e-06,  -3.471890958088038e-07,
   1.970608539786312e-08,  -8.410675062456645e-10,   2.502318229876831e-11,  -1.109460876972059e-12,   9.819964004278374e-14,  -4.934327978230227e-15,  -8.127376006795459e-18,
   9.919079589266310e-18,   1.812914792378364e-19,  -1.725981636218199e-02,   1.496363689245832e-03,  -9.359181223355676e-05,   5.276362984059072e-06,  -3.140591200957078e-07,
   1.781664239258520e-08,  -7.608805516323358e-10,   2.276557020452022e-11,  -1.012385614417580e-12,   8.863482846415943e-14,  -4.424577460571730e-15,  -6.560466161736215e-18,
   8.701929452519152e-18,   1.693242517471118e-19,  -1.470613975311512e-02,   1.275412539367228e-03,  -7.982327840670817e-05,   4.504223050952975e-06,  -2.681468718119862e-07,
   1.520284459198064e-08,  -6.497290845804479e-10,   1.957120417019368e-11,  -8.733723294976973e-13,   7.547906562164323e-14,  -3.738360079562153e-15,  -4.772841577905598e-18,
   7.155121709232636e-18,   1.498436271241448e-19,  -1.170078856626121e-02,   1.015111703592324e-03,  -6.357152601869281e-05,   3.590325780733657e-06,  -2.137768994180035e-07,
   1.211328278456402e-08,  -5.180590016661499e-10,   1.570584432871193e-11,  -7.031660500632519e-13,   6.002328530795771e-14,  -2.950513863390919e-15,  -3.154634518152833e-18,
   5.495653126409251e-18,   1.233534572754629e-19,  -8.537671674362679e-03,   7.408945915863207e-04,  -4.642186444985051e-05,   2.623613381638724e-06,  -1.562379610474298e-07,
   8.848873641507433e-09,  -3.786663114254043e-10,   1.153886200890598e-11,  -5.179180041007030e-13,   4.377958777325735e-14,  -2.139125147209765e-15,  -1.917975321081358e-18,
   3.895624044474352e-18,   9.234811277058185e-20,  -5.527190661456158e-03,   4.797330223218302e-04,  -3.006833259642257e-05,   1.700154680452861e-06,  -1.012545971280155e-07,
   5.733047138493011e-09,  -2.454262648683243e-10,   7.503833181261166e-12,  -3.373578668847274e-13,   2.833520713240587e-14,  -1.379040544712944e-15,  -1.075613627492848e-18,
   2.473551170602832e-18,   6.075947385796070e-20,  -2.965217240824509e-03,   2.573901087854650e-04,  -1.613523533957508e-05,   9.125526347359390e-07,  -5.435063097464911e-08,
   3.076866376856871e-09,  -1.317437702410095e-10,   4.034926165636770e-12,  -1.815524868355674e-13,   1.519927839093298e-14,  -7.382398611383233e-16,  -5.309894631383579e-19,
   1.313744536364198e-18,   3.286013202664238e-20,  -1.103475394734852e-03,   9.578819147627251e-05,  -6.005111572130389e-06,   3.396563318292154e-07,  -2.022988757621846e-08,
   1.145181583026556e-09,  -4.903720999048270e-11,   1.502758935937522e-12,  -6.763632406495931e-14,   5.656007461701131e-15,  -2.745239240121697e-16,  -1.916193656737770e-19,
   4.871837069418313e-19,   1.226249716489446e-20,  -1.246467950666715e-04,   1.082013440045190e-05,  -6.783375112091862e-07,   3.836809017429335e-08,  -2.285204450170920e-09,
   1.293606754771653e-10,  -5.539345146678556e-12,   1.697707672906148e-13,  -7.641405305310805e-15,   6.388889971753382e-16,  -3.100611660961867e-17,  -2.153767452581654e-20,
   5.500080458045478e-20,   1.385758701599741e-21,  -3.985749092201242e-03,   8.008118453167807e-04,  -1.094056126200025e-04,   1.063813210760768e-05,  -8.083332895850182e-07,
   5.425388260181914e-08,  -3.496308558546980e-09,   2.082167262129886e-10,  -1.036757225945962e-11,   4.193823099063201e-13,  -1.672656008913082e-14,   8.644832904827159e-16,
  -4.171973553537804e-17,   8.726546696335938e-19,  -3.795351438139113e-03,   7.628406704338816e-04,  -1.042321744421145e-04,   1.013722656422000e-05,  -7.706084819466188e-07,
   5.174711954956003e-08,  -3.335009898493138e-09,   1.985477331386941e-10,  -9.886329270672087e-12,   4.004163526170810e-13,  -1.599412230054496e-14,   8.244547417845770e-16,
  -3.962380313088452e-17,   8.298097169479253e-19,  -3.431789689732244e-03,   6.902187943692528e-04,  -9.433192644147359e-05,   9.177781824436402e-06,  -6.982097504335841e-07,
   4.692565989422457e-08,  -3.024667124052292e-09,   1.799719122269013e-10,  -8.961736544677254e-12,   3.637631348445885e-13,  -1.456779629384529e-14,   7.474947289994863e-16,
  -3.566705178650076e-17,   7.486356664051474e-19,  -2.928661278057937e-03,   5.894926472333899e-04,  -8.058909013426139e-05,   7.844240569747093e-06,  -5.973114897625725e-07,
   4.018572402871412e-08,  -2.590637251656965e-09,   1.540450324341969e-10,  -7.671130719257107e-12,   3.121894442783866e-13,  -1.254052511153932e-14,   6.399765824121897e-16,
  -3.027629004491954e-17,   6.373722963737297e-19,  -2.333734064685961e-03,   4.701030604422307e-04,  -6.428555938030271e-05,   6.260054633532993e-06,  -4.771078059900263e-07,
   3.213048291080158e-08,  -2.071654288133790e-09,   1.231078647502613e-10,  -6.130902554751657e-12,   2.501300055864897e-13,  -1.007642527179459e-14,   5.115664662730855e-16,
  -2.400468858210730e-17,   5.069191590987972e-19,  -1.704951082660206e-03,   3.436536877713554e-04,  -4.700458221502409e-05,   4.578867574519018e-06,  -3.492273513087937e-07,
   2.353708466921657e-08,  -1.517766465971757e-09,   9.014829215265833e-11,  -4.489729598845632e-12,   1.835362516821703e-13,  -7.410302079927571e-15,   3.746687922367754e-16,
  -1.746762737375740e-17,   3.698595303790042e-19,  -1.104666559394859e-03,   2.227495035359630e-04,  -3.047202557774463e-05,   2.969070298473142e-06,  -2.265562757610689e-07,
   1.527729202277094e-08,  -9.852196238083846e-10,   5.849848924981597e-11,  -2.913562743985514e-12,   1.192583521892684e-13,  -4.822059960029055e-15,   2.431533328042414e-16,
  -1.128846005971483e-17,   2.394628064994415e-19,  -5.928778238647090e-04,   1.195752482954116e-04,  -1.635910262522517e-05,   1.594155395763184e-06,  -1.216722684856520e-07,
   8.206868962817346e-09,  -5.292755004983023e-10,   3.142111119637149e-11,  -1.564985665517258e-12,   6.410059251965419e-14,  -2.593732417443318e-15,   1.306109404786705e-16,
  -6.050627613511234e-18,   1.284769180486871e-19,  -2.206656138606138e-04,   4.450842770832882e-05,  -6.089366856741707e-06,   5.934189680322905e-07,  -4.529591229745437e-08,
   3.055519671314242e-09,  -1.970586495013308e-10,   1.169796527768504e-11,  -5.826427870169421e-13,   2.387007353666254e-14,  -9.661117925149520e-16,   4.862683525192994e-17,
  -2.250987398358689e-18,   4.781300095167224e-20,  -2.492660737774819e-05,   5.027774165828946e-06,  -6.878717998346674e-07,   6.703469903426735e-08,  -5.116854446458102e-09,
   3.451719604010740e-10,  -2.226111427082120e-11,   1.321471417255208e-12,  -6.581885672476246e-14,   2.696606178033464e-15,  -1.091462090049687e-16,   5.493190498702063e-18,
  -2.542555186694310e-19,   5.400909861139809e-21,  -1.450586618135146e-02,   1.090318719146183e-03,  -5.977209235069641e-05,   2.657726010260613e-06,  -1.150759444500488e-07,
   6.238524612522580e-09,  -3.627007155185182e-10,   1.511168099843876e-11,  -2.258294492847054e-13,  -1.125755729474082e-14,   7.776978971499379e-17,   8.261836510160357e-17,
  -5.754376429262145e-18,   3.559500611768733e-20,  -1.380210389043038e-02,   1.037525918808618e-03,  -5.688568272880643e-05,   2.530336917323894e-06,  -1.096410787373023e-07,
   5.944463570449181e-09,  -3.452468063616956e-10,   1.436552758789735e-11,  -2.148283859262840e-13,  -1.057447800605454e-14,   6.318405367232821e-17,   7.864964665193540e-17,
  -5.430457583963889e-18,   3.140388464180152e-20,  -1.246273460346096e-02,   9.370104691873872e-04,  -5.138694110962203e-05,   2.287266744944824e-06,  -9.923743272485747e-08,
   5.381303597866005e-09,  -3.119711476561439e-10,   1.295097930167622e-11,  -1.939294008598735e-13,  -9.330186920839344e-15,   3.994937194431357e-17,   7.107297640560245e-17,
  -4.832505826041909e-18,   2.449388684359873e-20,  -1.061782711793176e-02,   7.984733926480746e-04,  -4.380212118331330e-05,   1.951228645522307e-06,  -8.479011894211198e-08,
   4.598777527146122e-09,  -2.660230610378476e-10,   1.101297420320212e-11,  -1.651960529953535e-13,  -7.724299191837104e-15,   1.659568384637146e-17,   6.059830187277887e-17,
  -4.044468872016625e-18,   1.698046766352422e-20,  -8.447204461308149e-03,   6.353731263052547e-04,  -3.486474319439156e-05,   1.554311876435617e-06,  -6.764416527774311e-08,
   3.669505114826507e-09,  -2.118203216936601e-10,   8.745742178454436e-12,  -1.314285237849041e-13,  -5.971690569854925e-15,  -1.169489995408782e-19,   4.823725479886500e-17,
  -3.161917710969065e-18,   1.058236950526136e-20,  -6.163193502961054e-03,   4.636550865584052e-04,  -2.544789567291248e-05,   1.135210311598704e-06,  -4.946451718343680e-08,
   2.683696960906130e-09,  -1.546532385781827e-10,   6.371838545573314e-12,  -9.590633366277519e-14,  -4.255060025417252e-15,  -7.836721691981569e-18,   3.520602264510548e-17,
  -2.274424250155390e-18,   6.039952555978523e-21,  -3.989789242812051e-03,   3.001841104489776e-04,  -1.647821627298147e-05,   7.353851334338726e-07,  -3.206846561206326e-08,
   1.740036222432104e-09,  -1.001613946077415e-10,   4.120975360366304e-12,  -6.209561047795785e-14,  -2.710936242920047e-15,  -8.364410497541979e-18,   2.279438470135211e-17,
  -1.458505977086742e-18,   3.203213829743488e-21,  -2.140382128059945e-03,   1.610474994938734e-04,  -8.841179893848325e-06,   3.946457244778786e-07,  -1.721662405691293e-08,
   9.342187390160954e-10,  -5.374560518338147e-11,   2.209696353539044e-12,  -3.331548338922954e-14,  -1.442309698122485e-15,  -5.389900481291060e-18,   1.222912317709625e-17,
  -7.786300032051373e-19,   1.525720579137066e-21,  -7.965145705416319e-04,   5.993286948114011e-05,  -3.290281545339178e-06,   1.468799241045732e-07,  -6.408622224835009e-09,
   3.477541564657814e-10,  -2.000233037903399e-11,   8.221717165933337e-13,  -1.239838425461275e-14,  -5.351804158673381e-16,  -2.122460670477021e-18,   4.550986107761148e-18,
  -2.892642401888006e-19,   5.429379645002902e-22,  -8.997287447594416e-05,   6.769932200286195e-06,  -3.716671470942243e-07,   1.659161501671975e-08,  -7.239368311352302e-10,
   3.928343460559463e-11,  -2.259456879561942e-12,   9.286860284742755e-14,  -1.400508190750611e-15,  -6.042514368919550e-17,  -2.418396143813067e-19,   5.140727154073731e-19,
  -3.266595152497983e-20,   6.088472398776272e-23,  -1.954141270504396e-03,   2.767903784302320e-04,  -3.419700202299032e-05,   3.278219080172957e-06,  -2.371650633312789e-07,
   1.344969744907713e-08,  -6.712309200658836e-10,   3.575192343579680e-11,  -2.113881843285773e-12,   1.118520181041639e-13,  -4.123160771460506e-15,   6.978290704906034e-17,
   3.649836344102808e-19,   1.435511485201666e-19,  -1.860171259604232e-03,   2.636274058823212e-04,  -3.257670310952918e-05,   3.122834538262106e-06,  -2.259354839706053e-07,
   1.281838918550529e-08,  -6.403733053748224e-10,   3.413346578374384e-11,  -2.016578764188924e-12,   1.065292585711061e-13,  -3.922554141364614e-15,   6.676143266098303e-17,
   2.877329944783185e-19,   1.395576989053237e-19,  -1.680992575859312e-03,   2.384684485153027e-04,  -2.947729018431375e-05,   2.825631394270061e-06,  -2.044522243643068e-07,
   1.160837123964916e-08,  -5.809569568596206e-10,   3.100616715563225e-11,  -1.829255670237767e-12,   9.635780069387526e-14,  -3.541160665242579e-15,   6.087190071685499e-17,
   1.651967377993239e-19,   1.306868931769556e-19,  -1.433524914220449e-03,   2.036040320779515e-04,  -2.517745914549058e-05,   2.413368915460641e-06,  -1.746428219881264e-07,
   9.924986567748248e-09,  -4.977718212139668e-10,   2.660699746783399e-11,  -1.567080739116164e-12,   8.226605957710956e-14,  -3.016414162222012e-15,   5.248050849892575e-17,
   4.364546327669227e-20,   1.160650468740990e-19,  -1.141531151606234e-03,   1.623188032138516e-04,  -2.007972850352547e-05,   1.924662926282334e-06,  -1.392939487739142e-07,
   7.923182402542672e-09,  -3.981928657464776e-10,   2.131516777397141e-11,  -1.253371895533988e-12,   6.558249327802490e-14,  -2.399543436394315e-15,   4.224099679139172e-17,
  -3.994858834099442e-20,   9.591300631365079e-20,  -8.335028879233226e-04,   1.186288197258725e-04,  -1.467947650151434e-05,   1.407005671430099e-06,  -1.018392241296117e-07,
   5.796893581828062e-09,  -2.918124334443926e-10,   1.563859200321648e-11,  -9.183857665161605e-13,   4.792931348908172e-14,  -1.750710853102166e-15,   3.111256116163054e-17,
  -7.286733311106037e-20,   7.204297030844218e-20,  -5.398425441004871e-04,   7.688038013856607e-05,  -9.515300550708872e-06,   9.120116600344311e-07,  -6.601575841853262e-08,
   3.759539279625090e-09,  -1.894579490402521e-10,   1.016089430015601e-11,  -5.961955606163809e-13,   3.106155799668131e-14,  -1.133355525012641e-15,   2.026797151025838e-17,
  -6.581881146250331e-20,   4.750834807785484e-20,  -2.896805514768659e-04,   4.126709502621506e-05,  -5.108052164759674e-06,   4.895865504412105e-07,  -3.543979673037701e-08,
   2.018758775000844e-09,  -1.017895281976217e-10,   5.461198278915829e-12,  -3.202985221080859e-13,   1.667287772802144e-14,  -6.080162592975336e-16,   1.090833188282720e-17,
  -4.043782325279589e-20,   2.572450288351370e-20,  -1.078103212586520e-04,   1.536003726044433e-05,  -1.901337236053007e-06,   1.822350976092780e-07,  -1.319164157581295e-08,
   7.515000470839685e-10,  -3.789930640128998e-11,   2.033637723081605e-12,  -1.192544519015116e-13,   6.205812854692120e-15,  -2.262668179397131e-16,   4.063975351475506e-18,
  -1.571210489086389e-20,   9.603732659854697e-21,  -1.217823458467669e-05,   1.735097086668001e-06,  -2.147796437192440e-07,   2.058570687627679e-08,  -1.490161744575336e-09,
   8.489252381587559e-11,  -4.281391589382587e-12,   2.297398806499902e-13,  -1.347184063922510e-14,   7.010195817117781e-16,  -2.555873100038614e-17,   4.591417393016687e-19,
  -1.786705567546001e-21,   1.085370352728981e-21,  -1.093373150585313e-02,   7.154629759899310e-04,  -3.599193391013723e-05,   1.467163896794858e-06,  -4.847463859962682e-08,
   1.539916074830453e-09,  -7.641586683854906e-11,   5.144671723121172e-12,  -2.698923155734211e-13,   7.406207786945516e-15,   1.302997693451626e-16,  -2.178551246902848e-17,
   6.751547264577056e-19,   2.899069523337555e-20,  -1.040299410211933e-02,   6.807943756786548e-04,  -3.425000672350002e-05,   1.396268377849454e-06,  -4.615174985539362e-08,
   1.468262094834625e-09,  -7.292257995944029e-11,   4.902120722955753e-12,  -2.565806483679536e-13,   7.011057909482013e-15,   1.251727646794116e-16,  -2.065273447328931e-17,
   6.320721128735840e-19,   2.802199241185528e-20,  -9.393031801667513e-03,   6.147972882936717e-04,  -3.093312402304336e-05,   1.261228301206808e-06,  -4.171929215396017e-08,
   1.330654478783855e-09,  -6.618684952597270e-11,   4.437585571993913e-12,  -2.313330257050476e-13,   6.273800228789295e-15,   1.149007653177904e-16,  -1.852642694881744e-17,
   5.543170646006285e-19,   2.599142739497136e-20,  -8.002084902483546e-03,   5.238563158669703e-04,  -2.636095349035354e-05,   1.074994207862475e-06,  -3.559113916270848e-08,
   1.138700344618707e-09,  -5.673948142370718e-11,   3.792100664685396e-12,  -1.967256822357309e-13,   5.286731476237786e-15,   9.978187858228872e-17,  -1.565616470100633e-17,
   4.553984746362294e-19,   2.284052439443089e-20,  -6.365848295410971e-03,   4.168173291999921e-04,  -2.097733028056867e-05,   8.555957835901772e-07,  -2.835217053795514e-08,
   9.098023514054697e-10,  -4.541041949819022e-11,   3.025633855391151e-12,  -1.562265761002022e-13,   4.161140551466528e-15,   8.080899909592825e-17,  -1.235535303718728e-17,
   3.493241977928720e-19,   1.869862004070775e-20,  -4.644399339373931e-03,   3.041472150972866e-04,  -1.530851585313392e-05,   6.244691925229162e-07,  -2.070794266455481e-08,
   6.660925049557115e-10,  -3.329069994515827e-11,   2.212656791001473e-12,  -1.138179824077110e-13,   3.009809004796986e-15,   5.977948038130375e-17,  -8.954943476225644e-18,
   2.472691914666650e-19,   1.394720431048166e-20,  -3.006497160736382e-03,   1.969055284548784e-04,  -9.911440704946910e-06,   4.043469965116701e-07,  -1.341479803664179e-08,
   4.321797991901599e-10,  -2.161877622646579e-11,   1.434556370432376e-12,  -7.360909612283876e-14,   1.937248619751088e-15,   3.904388158776500e-17,  -5.771267423418761e-18,
   1.568275101180165e-19,   9.157293538284856e-21,  -1.612855755568110e-03,   1.056366526032969e-04,  -5.317515160467320e-06,   2.169434362940728e-07,  -7.199150867106828e-09,
   2.321194185628172e-10,  -1.161638130344857e-11,   7.701870364727034e-13,  -3.946885146585795e-14,   1.036194331967987e-15,   2.103983996119886e-17,  -3.088938698074224e-18,
   8.324007408243642e-20,   4.947667841812885e-21,  -6.001994995095307e-04,   3.931175074223948e-05,  -1.978890636065321e-06,   8.073589451137018e-08,  -2.679402306488383e-09,
   8.641512953090035e-11,  -4.325297818660550e-12,   2.866921245440666e-13,  -1.468523031871797e-14,   3.852083929801387e-16,   7.841836477211385e-18,  -1.148579445172308e-18,
   3.086117290392132e-20,   1.845737540691633e-21,  -6.779741474039161e-05,   4.440594377738123e-06,  -2.235328494047767e-07,   9.119842698552538e-09,  -3.026665362441651e-10,
   9.761927211704436e-12,  -4.886212970050111e-13,   3.238561982455920e-14,  -1.658771424666351e-15,   4.350533512051870e-17,   8.860172926728128e-19,  -1.297248558483175e-19,
   3.483953386775855e-21,   2.085723339811909e-22,  -1.214715133662604e-03,   1.120828519523676e-04,  -1.090197786184617e-05,   1.000803702639448e-06,  -7.553317129888095e-08,
   4.450159036520716e-09,  -2.014804005055259e-10,   7.190548442945270e-12,  -2.517830681163764e-13,   1.354278927835386e-14,  -9.273272286523898e-16,   5.048485360778258e-17,
  -1.653094615959137e-18,   2.535129012755582e-21,  -1.155975270083097e-03,   1.067229366808186e-04,  -1.038539749448298e-05,   9.534613562315945e-07,  -7.194989631321447e-08,
   4.238262434639211e-09,  -1.918971978061846e-10,   6.855860158125872e-12,  -2.408025374001262e-13,   1.296661603483107e-14,  -8.853811393902639e-16,   4.803044881965228e-17,
  -1.565096977023739e-18,   2.059180138635468e-21,  -1.044106075650411e-03,   9.649061627563207e-05,  -9.397259535224715e-06,   8.628693274587581e-07,  -6.509738267907854e-08,
   3.833370948586182e-09,  -1.735822013855535e-10,   6.213245858095155e-12,  -2.194074264745775e-13,   1.183711335815688e-14,  -8.042903734794826e-16,   4.336033991665143e-17,
  -1.400841082391954e-18,   1.306136896233285e-21,  -8.898605929587386e-04,   8.233482733303539e-05,  -8.026433116430351e-06,   7.371282209633427e-07,  -5.559437482471286e-08,
   3.272504491110790e-09,  -1.482042881331872e-10,   5.317010376224609e-12,  -1.889671610337823e-13,   1.021742432503783e-14,  -6.901691873293910e-16,   3.693054425456773e-17,
  -1.180784296012899e-18,   5.561212090258403e-22,  -7.081905061154417e-04,   6.560203405201198e-05,  -6.401260110563609e-06,   5.879761956123139e-07,  -4.433240910342905e-08,
   2.608612657831082e-09,  -1.181539642711550e-10,   4.248358756400644e-12,  -1.519174227492008e-13,   8.231006656077800e-15,  -5.528659699388388e-16,   2.937102140298769e-17,
  -9.296543505705925e-19,   2.354741334462791e-23,  -5.168500166965974e-04,   4.792242814461496e-05,  -4.679674290787970e-06,   4.299014958902512e-07,  -3.240629045532838e-08,
   1.906290655878222e-09,  -8.635297210548630e-11,   3.110496342969719e-12,  -1.117734923860636e-13,   6.065576049237022e-15,  -4.055917827224359e-16,   2.142312360499598e-17,
  -6.725938496953049e-19,  -2.232625834192174e-22,  -3.346487059228522e-04,   3.104790533139418e-05,  -3.033372920678961e-06,   2.786878029889019e-07,  -2.100446691055852e-08,
   1.235342066660356e-09,  -5.596407853236648e-11,   2.018261398653490e-12,  -7.275728527038988e-14,   3.952303185907155e-15,  -2.635052647396611e-16,   1.386549501312670e-17,
  -4.329826101261108e-19,  -2.455583866364037e-22,  -1.795443983082531e-04,   1.666299488210455e-05,  -1.628387254433584e-06,   1.496131370274047e-07,  -1.127533013112562e-08,
   6.630736638464234e-10,  -3.004012491570913e-11,   1.084013695417141e-12,  -3.914206572374642e-14,   2.127352671777440e-15,  -1.416202464333341e-16,   7.437513903948077e-18,
  -2.316132773726370e-19,  -1.592641468503963e-22,  -6.681726037569137e-05,   6.201802164486679e-06,  -6.061236078531988e-07,   5.569037514543875e-08,  -4.196892068226081e-09,
   2.468001160929067e-10,  -1.118128152988526e-11,   4.035681384157191e-13,  -1.458049648627649e-14,   7.925828261390750e-16,  -5.273557162964131e-17,   2.767660765823704e-18,
  -8.610552322442635e-20,  -6.281603497347085e-23,  -7.547599038276141e-06,   7.005605655621020e-07,  -6.846917768816024e-08,   6.290934330946233e-09,  -4.740901412318267e-10,
   2.787893067471155e-11,  -1.263058111718370e-12,   4.558933548849551e-14,  -1.647243432944830e-15,   8.954518802040441e-17,  -5.957516831851696e-18,   3.126280644590320e-19,
  -9.724781671103775e-21,  -7.159089809388791e-24,  -8.552365127467309e-03,   4.866426189596996e-04,  -2.224737240700436e-05,   8.729465321038070e-07,  -2.833107685310706e-08,
   7.061146059678582e-10,  -1.380483603862480e-11,   5.263739675346643e-13,  -4.747704790631953e-14,   3.313503200545854e-15,  -1.466246762047073e-16,   3.040936989004181e-18,
   1.001877414148153e-19,  -1.191946411742052e-20,  -8.137044152144196e-03,   4.630504250910237e-04,  -2.117032200528578e-05,   8.306971182300517e-07,  -2.695935622803756e-08,
   6.721144713827784e-10,  -1.317399783788298e-11,   5.043493577625400e-13,  -4.536216432845224e-14,   3.157039385910869e-15,  -1.392819634840059e-16,   2.865278971986621e-18,
   9.660377259682230e-20,  -1.134843710682649e-20,  -7.346785058516510e-03,   4.181436221594431e-04,  -1.911959168929335e-05,   7.502483500295468e-07,  -2.434764870514335e-08,
   6.073050633424703e-10,  -1.195778021907692e-11,   4.610083741146119e-13,  -4.125998953721657e-14,   2.857451659829921e-15,  -1.253975499281442e-16,   2.542414661483071e-18,
   8.925055868048391e-20,  -1.025766264918601e-20,  -6.258559802198927e-03,   3.562730583677248e-04,  -1.629301026758338e-05,   6.393539863485441e-07,  -2.074799191190785e-08,
   5.178332715345067e-10,  -1.025199148587263e-11,   3.985409709366300e-13,  -3.546022132856765e-14,   2.441335354260950e-15,  -1.064501843924151e-16,   2.119879201464787e-18,
   7.810203308790997e-20,  -8.748435285185442e-21,  -4.978606918396654e-03,   2.834617616303657e-04,  -1.296510687273621e-05,   5.087793040783273e-07,  -1.651003656273363e-08,
   4.123072434053733e-10,  -8.206111438945241e-12,   3.215340743676336e-13,  -2.844834422950512e-14,   1.947485222307300e-15,  -8.438762642413626e-17,   1.650848628447172e-18,
   6.371348904646828e-20,  -6.965834189303470e-21,  -3.632162240539034e-03,   2.068305862117890e-04,  -9.461224000504163e-06,   3.712884352604614e-07,  -1.204807179159330e-08,
   3.010240059556611e-10,  -6.016775832509145e-12,   2.372243132470120e-13,  -2.089544866872278e-14,   1.423947698520178e-15,  -6.139152061406534e-17,   1.183523086274696e-18,
   4.740542506984721e-20,  -5.085136544102725e-21,  -2.351180637103984e-03,   1.338989172055216e-04,  -6.125524425461392e-06,   2.403889561979746e-07,  -7.800323871062874e-09,
   1.949558976164015e-10,  -3.907657851430962e-12,   1.546942955839615e-13,  -1.358624311869135e-14,   9.230888410577820e-16,  -3.966511795248486e-17,   7.571981632382279e-19,
   3.107881761413457e-20,  -3.292873385474619e-21,  -1.261291129956271e-03,   7.183361849619133e-05,  -3.286330451599933e-06,   1.289692401729959e-07,  -4.184853221111060e-09,
   1.046107335658467e-10,  -2.099814054624677e-12,   8.329825511758984e-14,  -7.304895458979919e-15,   4.955568415908691e-16,  -2.125758679927918e-17,   4.037407794450861e-19,
   1.677985703690735e-20,  -1.766743808558377e-21,  -4.693680975717000e-04,   2.673211957960929e-05,  -1.222989968983420e-06,   4.799534140792571e-08,  -1.557369919440827e-09,
   3.893256366590542e-11,  -7.818704677988966e-13,   3.103851675343383e-14,  -2.720536061243555e-15,   1.844603146222877e-16,  -7.907953627516640e-18,   1.499268767967029e-19,
   6.258253184671035e-21,  -6.574981115333428e-22,  -5.301890756094745e-05,   3.019616436319845e-06,  -1.381472469352099e-07,   5.421489588628119e-09,  -1.759183344019574e-10,
   4.397808623187751e-12,  -8.832682040671880e-14,   3.506776223169873e-15,  -3.073448733131755e-16,   2.083712456984937e-17,  -8.932186916328816e-19,   1.692974107627325e-20,
   7.071693801517888e-22,  -7.427031306537636e-23,  -8.866391263105633e-04,   5.770549934825899e-05,  -3.901015004376351e-06,   2.975890753931803e-07,  -2.202689684598492e-08,
   1.398321447209840e-09,  -7.183248893860635e-11,   2.861439986257547e-12,  -8.233165392612456e-14,   1.483478862472962e-15,  -2.367636513160152e-17,   2.749537348092620e-18,
  -2.883529661271851e-19,   1.775128005299456e-20,  -8.436345839079806e-04,   5.492603634206448e-05,  -3.715276509563214e-06,   2.835354871429015e-07,  -2.098779836706068e-08,
   1.332100775475401e-09,  -6.840728258279250e-11,   2.723880520300401e-12,  -7.836350380750758e-14,   1.416216340110195e-15,  -2.311010393022189e-17,   2.657279303865069e-18,
  -2.760909513014642e-19,   1.691203945616459e-20,  -7.617857236983638e-04,   4.962812006497208e-05,  -3.360359883519969e-06,   2.566335056435169e-07,  -1.899823131566351e-08,
   1.205413780606837e-09,  -6.186425611140560e-11,   2.461575307718622e-12,  -7.080191279471419e-14,   1.286380678831568e-15,  -2.179983466346814e-17,   2.465004854771993e-18,
  -2.520401115449573e-19,   1.530487449373809e-20,  -6.490345537954482e-04,   4.231466013761675e-05,  -2.868708083233010e-06,   2.192748478259629e-07,  -1.623441568392204e-08,
   1.029631549498158e-09,  -5.280441828047157e-11,   2.099272410684188e-12,  -6.036658917863635e-14,   1.103910750663272e-15,  -1.953961259750751e-17,   2.167737064989169e-18,
  -2.175371696738168e-19,   1.307278091573586e-20,  -5.163659618855354e-04,   3.368986944928740e-05,  -2.286735609617685e-06,   1.749366404653759e-07,  -1.295312192917447e-08,
   8.211968098883074e-10,  -4.208534017867479e-11,   1.671739556426810e-12,  -4.806240347906917e-14,   8.844934385587412e-16,  -1.629712874461802e-17,   1.776871187560001e-18,
  -1.752200750417294e-19,   1.042497022197964e-20,  -3.767562807115686e-04,   2.459569561582292e-05,  -1.671071555288874e-06,   1.279235981803932e-07,  -9.472850634520232e-09,
   6.003641989207602e-10,  -3.075060404119505e-11,   1.220683352888549e-12,  -3.508922502369957e-14,   6.490741532704616e-16,  -1.233537296560855e-17,   1.327188186453746e-18,
  -1.291019120442984e-19,   7.620066059995574e-21,  -2.438997558442661e-04,   1.592868042400952e-05,  -1.082910495130460e-06,   8.293536957286572e-08,  -6.141770040323883e-09,
   3.891670627280587e-10,  -1.992570271859660e-11,   7.906304397695034e-13,  -2.272501165108242e-14,   4.217994761576766e-16,  -8.176518405036752e-18,   8.723305358209216e-19,
  -8.411130579958233e-20,   4.938636499408301e-21,  -1.308447152647204e-04,   8.546963657255239e-06,  -5.812550089850922e-07,   4.452584369025476e-08,  -3.297448592427417e-09,
   2.089168922932076e-10,  -1.069469547104935e-11,   4.242592631114774e-13,  -1.219389284111587e-14,   2.267290366383943e-16,  -4.439213478696686e-18,   4.716030803127305e-19,
  -4.527010916331275e-20,   2.650950516324702e-21,  -4.869224532100499e-05,   3.180869411647241e-06,  -2.163466295518739e-07,   1.657409197926043e-08,  -1.227438728060996e-09,
   7.776407134385655e-11,  -3.980568392085112e-12,   1.578971538769665e-13,  -4.538148611728083e-15,   8.443243724600743e-17,  -1.658841055548692e-18,   1.759708083038519e-19,
  -1.686572675931798e-20,   9.867139080678335e-22,  -5.500192174939205e-06,   3.593095177423812e-07,  -2.443885533557409e-08,   1.872258846378745e-09,  -1.386553510227831e-10,
   8.784422335201782e-12,  -4.496501512991380e-13,   1.783604710170700e-14,  -5.126275925934876e-16,   9.538383772666759e-18,  -1.875025263544487e-19,   1.988577635918841e-20,
  -1.905464158259350e-21,   1.114609956758816e-22,  -6.905000169421027e-03,   3.438315354199130e-04,  -1.407543211119092e-05,   5.176187170385052e-07,  -1.687228453263142e-08,
   4.568010180228224e-10,  -8.822879684823407e-12,   6.721885413293901e-14,   6.558881080114301e-16,   1.961697765261710e-16,  -2.435844659767233e-17,   1.472962755298435e-18,
  -5.637617273674287e-20,   1.119108261045272e-21,  -6.569561596118731e-03,   3.271538838795530e-04,  -1.339381774512677e-05,   4.925775112209361e-07,  -1.605554432131334e-08,
   4.346251114393848e-10,  -8.393378538592431e-12,   6.417601929866395e-14,   5.905024275726166e-16,   1.890597724136324e-16,  -2.328344307058614e-17,   1.403771522312463e-18,
  -5.356242823720993e-20,   1.054371808010173e-21,  -5.931347749483066e-03,   2.954122520552154e-04,  -1.209608397193552e-05,   4.448910736224214e-07,  -1.450041334668095e-08,
   3.924267426284672e-10,  -7.576601864583337e-12,   5.829969346001636e-14,   4.795375111133021e-16,   1.745527558096781e-16,  -2.119382982424328e-17,   1.271130824313409e-18,
  -4.823739944157386e-20,   9.353578526595959e-22,  -5.052588584770224e-03,   2.516870716098537e-04,  -1.030752817873112e-05,   3.791492105699074e-07,  -1.235685939506752e-08,
   3.343119490863948e-10,  -6.452721631403981e-12,   5.003644671538190e-14,   3.530004257321513e-16,   1.526742617734520e-16,  -1.823099098502048e-17,   1.086600111347554e-18,
  -4.096256774049387e-20,   7.796066285692990e-22,  -4.019123278044675e-03,   2.002387159233895e-04,  -8.201942280424599e-06,   3.017293915196405e-07,  -9.833036660049699e-09,
   2.659509086188898e-10,  -5.131862113129815e-12,   4.009515712223969e-14,   2.377124878007523e-16,   1.245268378498138e-16,  -1.463848164231693e-17,   8.672327788851723e-19,
  -3.248253259495448e-20,   6.068090153270034e-22,  -2.932079930885262e-03,   1.460994966817402e-04,  -5.985187977033142e-06,   2.201988905874070e-07,  -7.175673708241433e-09,
   1.940314677408259e-10,  -3.743291272541773e-12,   2.942531941556152e-14,   1.479762472148465e-16,   9.265983508586327e-17,  -1.075930183940502e-17,   6.343494498510281e-19,
  -2.363612578399551e-20,   4.348111519714668e-22,  -1.897964228784033e-03,   9.457972916360714e-05,  -3.874958452119220e-06,   1.425700896440812e-07,  -4.645806514800912e-09,
   1.256035304388676e-10,  -2.422834608893567e-12,   1.912270395598429e-14,   8.486532991876349e-17,   6.075621653783479e-17,  -6.998794871977498e-18,   4.113302077421972e-19,
  -1.527342830098569e-20,   2.780768982573512e-22,  -1.018152852665203e-03,   5.073902207927427e-05,  -2.078890275705969e-06,   7.649010864052916e-08,  -2.492472309294189e-09,
   6.738074617146652e-11,  -1.299653458200392e-12,   1.027916573154752e-14,   4.251050090774843e-17,   3.280644296866592e-17,  -3.763877760942689e-18,   2.208502274267857e-19,
  -8.185990175130248e-21,   1.482395638649119e-22,  -3.788869805319729e-04,   1.888188849922103e-05,  -7.736455561943049e-07,   2.846558006307377e-08,  -9.275609275488855e-10,
   2.507469497383872e-11,  -4.836341638412541e-13,   3.827916856359053e-15,   1.542860636725007e-17,   1.223605721335749e-17,  -1.401876827086584e-18,   8.221047676231669e-20,
  -3.045309436074508e-21,   5.504364165325912e-23,  -4.279831266014603e-05,   2.132865389146175e-06,  -8.738988845738757e-08,   3.215435994277825e-09,  -1.047760099003242e-10,
   2.832390458621531e-12,  -5.463019900586725e-14,   4.324424738710901e-16,   1.735775541965862e-18,   1.382657720977365e-18,  -1.583750305704388e-19,   9.286779953019540e-21,
  -3.439748603115322e-22,   6.215449656998920e-24,  -7.018978491537759e-04,   3.642278538792235e-05,  -1.762219117559570e-06,   9.769858559742979e-08,  -6.153651825702723e-09,
   3.837534701232942e-10,  -2.126237083267913e-11,   9.896132740415274e-13,  -3.703331899686975e-14,   1.026952008628570e-15,  -1.565974804644407e-17,  -2.037569817872066e-19,
   1.748694785966150e-20,   2.812783892614292e-23,  -6.678113471998237e-04,   3.466010573383880e-05,  -1.677625371493725e-06,   9.306250186810375e-08,  -5.863936681782873e-09,
   3.657105861397557e-10,  -2.025910830915892e-11,   9.425750132755531e-13,  -3.525269435247965e-14,   9.766702691991156e-16,  -1.486556204963094e-17,  -1.936015735691761e-19,
   1.647535558113891e-20,   3.987511642172782e-23,  -6.029530525705633e-04,   3.130367234101910e-05,  -1.516265225133068e-06,   8.419725517537101e-08,  -5.308982873798838e-09,
   3.311387106370512e-10,  -1.833823534951297e-11,   8.526566247325668e-13,  -3.185727815584841e-14,   8.811638139034177e-16,  -1.336858940266871e-17,  -1.743414500764782e-19,
   1.461425443330974e-20,   5.696490894005397e-23,  -5.136407279169992e-04,   2.667690958346286e-05,  -1.293290788501881e-06,   7.190411609230637e-08,  -4.537607007817333e-09,
   2.830645367978561e-10,  -1.567001532796609e-11,   7.280297127972824e-13,  -2.716752979264419e-14,   7.499717049038223e-16,  -1.133422727842862e-17,  -1.479837558893269e-19,
   1.217728301804654e-20,   7.022295550842249e-23,  -4.085938651677906e-04,   2.122890379180245e-05,  -1.030049369927967e-06,   5.733685298742213e-08,  -3.621216681712609e-09,
   2.259281294985363e-10,  -1.250245421003094e-11,   5.804278714889783e-13,  -2.163377883875546e-14,   5.960756649879867e-16,  -8.974975491381127e-18,  -1.172550613899152e-19,
   9.473809707813300e-21,   7.270056070391308e-23,  -2.980907038575663e-04,   1.549219369340684e-05,  -7.522139876694998e-07,   4.191158012794631e-08,  -2.648704155881837e-09,
   1.652702297009039e-10,  -9.143056708813646e-12,   4.242105896671944e-13,  -1.579610044699658e-14,   4.345658552393478e-16,  -6.523779233947787e-18,  -8.524382735317154e-20,
   6.784963751256061e-21,   6.297939784741486e-23,  -1.929606126078112e-04,   1.003040116101137e-05,  -4.872409302732474e-07,   2.716511138322105e-08,  -1.717491186761096e-09,
   1.071729882379125e-10,  -5.927852281527165e-12,   2.749247831493192e-13,  -1.023075979583610e-14,   2.811747049993570e-16,  -4.212841602749156e-18,  -5.504324678796775e-20,
   4.337404853965136e-21,   4.503365683888691e-23,  -1.035136807615214e-04,   5.381348685809659e-06,  -2.614675307467907e-07,   1.458232137887415e-08,  -9.221547390456081e-10,
   5.754528479640112e-11,  -3.182572005104057e-12,   1.475725772568225e-13,  -5.489829455350719e-15,   1.508005425587218e-16,  -2.257199685282771e-18,  -2.948877273327155e-20,
   2.311667159806532e-21,   2.533574274577957e-23,  -3.852085225146773e-05,   2.002647435601030e-06,  -9.731198853638245e-08,   5.427806636860351e-09,  -3.432687208925599e-10,
   2.142128001750339e-11,  -1.184673725733736e-12,   5.492817592671285e-14,  -2.043145877979500e-15,   5.611324711475694e-17,  -8.396194858069648e-19,  -1.096858598695845e-20,
   8.582829125041507e-22,   9.580907071283212e-24,  -4.351240418177361e-06,   2.262164114227447e-07,  -1.099237524925743e-08,   6.131367675965301e-10,  -3.877684011130701e-11,
   2.419827645626611e-12,  -1.338244191732500e-13,   6.204786866847657e-15,  -2.307933511863301e-16,   6.338360535460098e-18,  -9.483535290726996e-20,  -1.238897183551362e-21,
   9.691472538216389e-23,   1.084977408231569e-24,  -5.721195355269075e-03,   2.521075996928759e-04,  -9.217587748463905e-06,   3.099652124357174e-07,  -9.677947338865002e-09,
   2.721985815311836e-10,  -6.387994598820358e-12,   1.010615664930100e-13,   1.219201864122385e-16,  -6.701263839637511e-17,   1.354831787227126e-18,   8.423128833181684e-20,
  -8.746169037749194e-21,   4.447134334597892e-22,  -5.443191119421252e-03,   2.398728046223467e-04,  -8.770974556914785e-06,   2.949695198265607e-07,  -9.210057080260133e-09,
   2.590215159146807e-10,  -6.077169527991910e-12,   9.607520599102450e-14,   1.176578348523870e-16,  -6.360535073659267e-17,   1.271312504915603e-18,   8.117829069817125e-20,
  -8.361863338802814e-21,   4.240304807694840e-22,  -4.914283291854364e-03,   2.165895516735486e-04,  -7.920761991489253e-06,   2.664130733918752e-07,  -8.318919172718682e-09,
   2.339316772933614e-10,  -5.485988378203085e-12,   8.661954678461191e-14,   1.088391970989256e-16,  -5.718197873816018e-17,   1.119499077477670e-18,   7.494978111915662e-20,
  -7.614127386185256e-21,   3.842945696442397e-22,  -4.186086214476572e-03,   1.845210031526277e-04,  -6.749179484012983e-06,   2.270445949424975e-07,  -7.090128336140831e-09,
   1.993489572527007e-10,  -4.672383032125533e-12,   7.366088170711578e-14,   9.535496233949892e-17,  -4.845512951321380e-17,   9.243245364122713e-19,   6.555702604725182e-20,
  -6.552524695569731e-21,   3.288466884401464e-22,  -3.329763246635913e-03,   1.467944242389937e-04,  -5.370172206231291e-06,   1.806832389597235e-07,  -5.642756522116360e-09,
   1.586319348962803e-10,  -3.716043809903998e-12,   5.849751766386939e-14,   7.784911745117516e-17,  -3.834423443109522e-17,   7.124949729205275e-19,   5.347268013170092e-20,
  -5.263529938325070e-21,   2.627206501597078e-22,  -2.429114577152666e-03,   1.071004727563242e-04,  -3.918584582628581e-06,   1.318605232791066e-07,  -4.118250278882938e-09,
   1.157612402586415e-10,  -2.710595410342814e-12,   4.261919102768476e-14,   5.794625329088110e-17,  -2.785444402181869e-17,   5.063407129159517e-19,   3.979029376312252e-20,
  -3.870014847187222e-21,   1.923251535056543e-22,  -1.572366272663927e-03,   6.933113124991857e-05,  -2.536910973053277e-06,   8.537441123389087e-08,  -2.666501356877881e-09,
   7.494797528363114e-11,  -1.754432974401795e-12,   2.756365020788754e-14,   3.799542594505991e-17,  -1.797912199371350e-17,   3.219861674091921e-19,   2.609090973304756e-20,
  -2.517963324859014e-21,   1.247751542556667e-22,  -8.434810727336499e-04,   3.719340344508930e-05,  -1.361015091930101e-06,   4.580410397125840e-08,  -1.430628122207982e-09,
   4.020945929090528e-11,  -9.411115476757965e-13,   1.477972352287986e-14,   2.051526216642860e-17,  -9.630584261850916e-18,   1.711337875551316e-19,   1.408850212139157e-20,
  -1.354290429310127e-21,   6.701210832478188e-23,  -3.138852296453797e-04,   1.384098609893614e-05,  -5.064901934141530e-07,   1.704586672647670e-08,  -5.324077075257036e-10,
   1.496373547239851e-11,  -3.502116704381378e-13,   5.499143159670409e-15,   7.651515446689106e-18,  -3.581999427207041e-18,   6.347764349870407e-20,   5.254722201950754e-21,
  -5.044331536076821e-22,   2.494730352003732e-23,  -3.545583032944229e-05,   1.563452522584254e-06,  -5.721235372717582e-08,   1.925479545285234e-09,  -6.014016449677029e-11,
   1.690282835811240e-12,  -3.955910328849968e-14,   6.211567424233170e-16,   8.646066127434703e-19,  -4.045823401284499e-19,   7.166601538380049e-21,   5.937769846797972e-22,
  -5.698797819388939e-23,   2.818175961079357e-24,  -5.787509867774830e-04,   2.578231481107003e-05,  -9.963138649639447e-07,   4.031975819530990e-08,  -1.900629776967876e-09,
   1.017083785660999e-10,  -5.484281419716556e-12,   2.706265653648451e-13,  -1.160050232315663e-14,   4.162378004007763e-16,  -1.179579773916999e-17,   2.215340791819775e-19,
   5.636682523669210e-24,  -2.018043944124849e-22,  -5.506304763604425e-04,   2.453190974306095e-05,  -9.481979382980461e-07,   3.838935647916844e-08,  -1.810665595283487e-09,
   9.693232184652667e-11,  -5.227271234075789e-12,   2.579111444101214e-13,  -1.105202841054276e-14,   3.963495461036522e-16,  -1.122177803628520e-17,   2.102852267634869e-19,
   2.850060027977065e-23,  -1.923952815847911e-22,  -4.971298565636120e-04,   2.215201624765696e-05,  -8.565363665261855e-07,   3.470508160029201e-08,  -1.638540401901961e-09,
   8.777858050939851e-11,  -4.734465393435096e-12,   2.335434386734770e-13,  -1.000235520449967e-14,   3.583733757685729e-16,  -1.012997421428912e-17,   1.890798088380486e-19,
   6.249308189014962e-23,  -1.743216293670800e-22,  -4.234688418373000e-04,   1.887349705446695e-05,  -7.301036675885634e-07,   2.960993612270084e-08,  -1.399679387176954e-09,
   7.504509274849750e-11,  -4.048512404369825e-12,   1.996516598309725e-13,  -8.545168651862729e-15,   3.058207386955055e-16,  -8.627386921731775e-18,   1.602649536781069e-19,
   9.095431470951653e-23,  -1.491140938236000e-22,  -3.368450637192910e-04,   1.501571881927344e-05,  -5.811286352701596e-07,   2.358952005749329e-08,  -1.116402390966471e-09,
   5.990519488607036e-11,  -3.232396759681693e-12,   1.593624371162086e-13,  -6.816402130257704e-15,   2.436848847237715e-16,  -6.861276186300551e-18,   1.268637070025709e-19,
   1.013544385403323e-22,  -1.190783302626160e-22,  -2.457353816239457e-04,   1.095600397472558e-05,  -4.241649410433995e-07,   1.723054264424608e-08,  -8.162273603375528e-10,
   4.382637790611169e-11,  -2.365184591125826e-12,   1.165822716148917e-13,  -4.983993232025602e-15,   1.780204460485149e-16,  -5.004630809264978e-18,   9.218592077535866e-20,
   9.092132466231855e-23,  -8.713709719126419e-23,  -1.590652472235890e-04,   7.092594284658292e-06,  -2.746573061729776e-07,   1.116259239780315e-08,  -5.291126778271209e-10,
   2.842218573532282e-11,  -1.534024605417279e-12,   7.560276387879336e-14,  -3.230980928186608e-15,   1.153387184424096e-16,  -3.239153253427159e-18,   5.951642880847659e-20,
   6.609603657306067e-23,  -5.651600615748060e-23,  -8.532924452692048e-05,   3.804967905150446e-06,  -1.473635879113391e-07,   5.990620493937192e-09,  -2.840494273441421e-10,
   1.526152659596859e-11,  -8.237511239395113e-13,   4.059470821354021e-14,  -1.734562835674482e-15,   6.190154657079061e-17,  -1.737516122437510e-18,   3.188414612332069e-20,
   3.744837266858143e-23,  -3.034799100468805e-23,  -3.175365908275959e-05,   1.415973027627220e-06,  -5.484192280531559e-08,   2.229624791736091e-09,  -1.057309806217162e-10,
   5.681189427594811e-12,  -3.066516916125480e-13,   1.511150240199623e-14,  -6.456568568959144e-16,   2.303924478517202e-17,  -6.465704468765720e-19,   1.185951452256798e-20,
   1.419346477273719e-23,  -1.129734937808038e-23,  -3.586828502789392e-06,   1.599458961359274e-07,  -6.194891870587086e-09,   2.518597635305306e-10,  -1.194364649345893e-11,
   6.417696545375674e-13,  -3.464069123448598e-14,   1.707053230179381e-15,  -7.293516726178780e-17,   2.602533420424080e-18,  -7.303504029976976e-20,   1.339526778795343e-21,
   1.607884063101274e-24,  -1.276195672385575e-24,  -4.839922260892967e-03,   1.909771719992108e-04,  -6.271825492531830e-06,   1.912857898548778e-07,  -5.543419039245278e-09,
   1.515110812242004e-10,  -3.774786805129426e-12,   7.923775981191472e-14,  -1.104126538824374e-15,  -5.414666878615494e-18,   9.840494450013821e-19,  -3.364320100309545e-20,
   3.614993550727734e-22,   2.764040255152861e-23,  -4.604694770435920e-03,   1.817051270183723e-04,  -5.967754791756371e-06,   1.820267822369593e-07,  -5.275472160065513e-09,
   1.441909733643990e-10,  -3.592091472518729e-12,   7.537744088514120e-14,  -1.049099829689278e-15,  -5.205644854809706e-18,   9.368265535841480e-19,  -3.193860640227197e-20,
   3.378832148214476e-22,   2.659503198997165e-23,  -4.157189155737859e-03,   1.640616854696241e-04,  -5.388974783993159e-06,   1.643967537501997e-07,  -4.765121856515674e-09,
   1.302472000976741e-10,  -3.244212275333065e-12,   6.803710484695752e-14,  -9.449688661579386e-16,  -4.785811364387986e-18,   8.467258235035962e-19,  -2.872301439995472e-20,
   2.953749146544179e-22,   2.448613173566088e-23,  -3.541102460044457e-03,   1.397640633095602e-04,  -4.591570322347788e-06,   1.400955028571524e-07,  -4.061356100251274e-09,
   1.110162740818073e-10,  -2.764677808531998e-12,   5.793878346352958e-14,  -8.026853890444798e-16,  -4.164974136639855e-18,   7.221911284958149e-19,  -2.434992858986291e-20,
   2.415834393230503e-22,   2.134880962997356e-23,  -2.816661618791627e-03,   1.111833864912447e-04,  -3.653174414767306e-06,   1.114825733164257e-07,  -3.232346795056250e-09,
   8.835964184879983e-11,  -2.200042299828396e-12,   4.607367256198981e-14,  -6.367400058133885e-16,  -3.380961137672659e-18,   5.751566277737609e-19,  -1.927736320439643e-20,
   1.843781134570396e-22,   1.736197795890983e-23,  -2.054764557527906e-03,   8.111592377093927e-05,  -2.665562184381777e-06,   8.135508170579062e-08,  -2.359104728231389e-09,
   6.449106644586000e-11,  -1.605503992191384e-12,   3.360382769221372e-14,  -4.634859719491185e-16,  -2.506310539991209e-18,   4.199863489701229e-19,  -1.400879068083275e-20,
   1.299067286267505e-22,   1.288999833707432e-23,  -1.330034758866491e-03,   5.250887377881373e-05,  -1.725638770662164e-06,   5.267262036657786e-08,  -1.527501016874967e-09,
   4.175847108625346e-11,  -1.039473020057723e-12,   2.174847982069140e-14,  -2.995756120101884e-16,  -1.639342954227862e-18,   2.720251433233913e-19,  -9.044453416618458e-21,
   8.211343163325791e-23,   8.439775218822677e-24,  -7.134805699006294e-04,   2.816858565086533e-05,  -9.257632522728263e-07,   2.825888900246646e-08,  -8.195380912584896e-10,
   2.240462741479410e-11,  -5.576788170042192e-13,   1.166585993944863e-14,  -1.605835688303229e-16,  -8.840895868555142e-19,   1.459710138243445e-19,  -4.845322576652485e-21,
   4.350355422515122e-23,   4.553938626053721e-24,  -2.655075232754834e-04,   1.048248644406571e-05,  -3.445128058692660e-07,   1.051641013435820e-08,  -3.049914444829340e-10,
   8.337928199295633e-12,  -2.075376233603804e-13,   4.341107355673091e-15,  -5.974241438480709e-17,  -3.296026601615323e-19,   5.432618436893375e-20,  -1.802251031268838e-21,
   1.611828896418733e-23,   1.698094915537175e-24,  -2.999117466875420e-05,   1.184081735009486e-06,  -3.891559906733166e-08,   1.187919404134657e-09,  -3.445149584227323e-11,
   9.418437942568359e-13,  -2.344317023164134e-14,   4.903604537573963e-16,  -6.748099492430593e-18,  -3.724209515484962e-20,   6.136679405057551e-21,  -2.035634615780763e-22,
   1.819420727717283e-24,   1.918748825968454e-25,  -4.890704272794232e-04,   1.934856897673439e-05,  -6.454231117405749e-07,   2.100219883533681e-08,  -7.373254596085374e-10,
   3.011441696902188e-11,  -1.394621554724366e-12,   6.610841177561867e-14,  -2.939835381802252e-15,   1.167819179365243e-16,  -4.016809480339391e-18,   1.151525876121822e-19,
  -2.517861434069049e-21,   2.830959630746373e-23,  -4.653012648031214e-04,   1.840933883664502e-05,  -6.141625873248508e-07,   1.998972689579856e-08,  -7.020931402609306e-10,
   2.869151111899892e-11,  -1.329264980849313e-12,   6.301916595285129e-14,  -2.802254801887038e-15,   1.112904980970777e-16,  -3.826346855300407e-18,   1.096146125022461e-19,
  -2.393251835289845e-21,   2.674483583954948e-23,  -4.200817580982284e-04,   1.662204966057211e-05,  -5.546476107809405e-07,   1.806021705131744e-08,  -6.348221943999810e-10,
   2.596807611794419e-11,  -1.203948395578363e-12,   5.709202287341209e-14,  -2.538369604174334e-15,   1.007685628681801e-16,  -3.462061199751744e-18,   9.905450733524153e-20,
  -2.157072008234148e-21,   2.384409214041065e-23,  -3.578271757820255e-04,   1.416056830062655e-05,  -4.726275583582988e-07,   1.539733418901220e-08,  -5.417355533691557e-10,
   2.218669921127237e-11,  -1.029517881438041e-12,   4.883475480672885e-14,  -2.170904887000314e-15,   8.613763444858126e-17,  -2.956784792863164e-18,   8.446946829940287e-20,
  -1.833657966673201e-21,   1.999886370001217e-23,  -2.846231846675555e-04,   1.126503689718035e-05,  -3.760744018697040e-07,   1.225786191355663e-08,  -4.316752379658841e-10,
   1.769962065959092e-11,  -8.219882064305281e-13,   3.900167870302027e-14,  -1.733520254151147e-15,   6.874945775250101e-17,  -2.357893765782939e-18,   6.726097150231670e-20,
  -1.455605338532450e-21,   1.566607664771559e-23,  -2.076339118020936e-04,   8.218734351510563e-06,  -2.744283547648479e-07,   8.948347886922534e-09,  -3.153610098116279e-10,
   1.294249511290297e-11,  -6.014627442948378e-13,   2.854462410105555e-14,  -1.268575419138616e-15,   5.029050135168696e-17,  -1.723619159458201e-18,   4.910921916840716e-20,
  -1.060134666669814e-21,   1.128616837949910e-23,  -1.344001096802850e-04,   5.320293245086716e-06,  -1.776701269345692e-07,   5.794855853742267e-09,  -2.043247731285713e-10,
   8.390678398806999e-12,  -3.901020292884562e-13,   1.851646409974007e-14,  -8.228381010193947e-16,   3.261153544454665e-17,  -1.117193961079990e-18,   3.180593802053310e-20,
  -6.854703379586164e-22,   7.244465838476657e-24,  -7.209729896849613e-05,   2.854105266441531e-06,  -9.531845276923865e-08,   3.109309517698453e-09,  -1.096609131858975e-10,
   4.504684853468669e-12,  -2.094802785960063e-13,   9.943879548866290e-15,  -4.418693121857336e-16,   1.751026609265038e-17,  -5.997197834817707e-19,   1.706680477028012e-20,
  -3.675051943373349e-22,   3.869379074063625e-24,  -2.682957230404423e-05,   1.062111175938670e-06,  -3.547208996996294e-08,   1.157162099687311e-09,  -4.081503938695606e-11,
   1.676796149637214e-12,  -7.798174271786624e-14,   3.701835078014333e-15,  -1.644934680244338e-16,   6.518195626810962e-18,  -2.232274610618871e-19,   6.351704199971391e-21,
  -1.367328643191587e-22,   1.437731596182509e-24,  -3.030612470182979e-06,   1.199740904381943e-07,  -4.006875239094116e-09,   1.307123098468884e-10,  -4.610505633436965e-12,
   1.894157730155450e-13,  -8.809153817837248e-15,   4.181769917650004e-16,  -1.858192528025950e-17,   7.363193981418446e-19,  -2.521627043617870e-20,   7.174865861682322e-22,
  -1.544457700413071e-23,   1.623640640359226e-25,  -4.149236197029890e-03,   1.481627392380224e-04,  -4.407309348305898e-06,   1.221690438767047e-07,  -3.248801565656006e-09,
   8.328676213018495e-11,  -2.033648370404928e-12,   4.574585229176246e-14,  -8.797477295779064e-16,   1.151967117318161e-17,  -3.836652812121036e-03,   1.370100731656060e-04,
  -4.075935574883482e-06,   1.129963512567017e-07,  -3.005242358308369e-09,   7.705065563657198e-11,  -1.881427559055094e-12,   4.231544588528917e-14,  -8.133265868851568e-16,
   1.062800892193400e-17,  -3.258956543498484e-03,   1.163928862397244e-04,  -3.463118670017468e-06,   9.602530243418715e-08,  -2.554393760423492e-09,   6.550234959960742e-11,
  -1.599507772335699e-12,   3.596595812572144e-14,  -6.906565890706285e-16,   8.994417677592267e-18,  -2.503963826300433e-03,   8.943895575474463e-05,  -2.661569565612587e-06,
   7.381460129077464e-08,  -1.963978714370656e-09,   5.037119676170412e-11,  -1.230073049177642e-12,   2.765177926409608e-14,  -5.304845129705441e-16,   6.883480779746074e-18,
  -1.686571183517580e-03,   6.024809658862389e-05,  -1.793121246146609e-06,   4.973726502912342e-08,  -1.323576429863279e-09,   3.395115739585365e-11,  -8.291213468302938e-13,
   1.863463615908761e-14,  -3.572221788070276e-16,   4.621969719446058e-18,  -9.312753323604438e-04,   3.326900658639742e-05,  -9.902344479483127e-07,   2.746941381736406e-08,
  -7.310690735290065e-10,   1.875420221131443e-11,  -4.580054169397491e-13,   1.029252017250749e-14,  -1.972182908990793e-16,   2.547496686082417e-18,  -3.531504197209223e-04,
   1.261624536779778e-05,  -3.755262431742396e-07,   1.041756796059257e-08,  -2.772624725286087e-10,   7.112860101825353e-12,  -1.737078586816673e-13,   3.903472604992211e-15,
  -7.478326499951517e-17,   9.653818487164724e-19,  -4.026397458356311e-05,   1.438429164562198e-06,  -4.281546150139695e-08,   1.187761144860439e-09,  -3.161232737080341e-11,
   8.109830909592884e-13,  -1.980557818512966e-14,   4.450573421131766e-16,  -8.526234804253452e-18,   1.100542768334658e-19,  -4.191815460828415e-04,   1.497707988325857e-05,
  -4.472924414541630e-07,   1.263958647473759e-08,  -3.603780551207494e-10,   1.117281338728908e-11,  -4.003847049891000e-13,   1.625609102430734e-14,  -6.851593392114505e-16,
   2.763702844312209e-17,  -3.876025383870711e-04,   1.384974948516541e-05,  -4.136701131840061e-07,   1.169173620345872e-08,  -3.334787521204025e-10,   1.034576914634892e-11,
  -3.710562381296704e-13,   1.507493797410911e-14,  -6.355497763354580e-16,   2.563523127657840e-17,  -3.292402102134438e-04,   1.176570493419670e-05,  -3.514865525989434e-07,
   9.937356672782725e-09,  -2.836148792750721e-10,   8.808467165384752e-12,  -3.163518475628319e-13,   1.286586880699385e-14,  -5.426580797283263e-16,   2.188735995008665e-17,
  -2.529662325535708e-04,   9.041083240835855e-06,  -2.701435570506160e-07,   7.640163282272229e-09,  -2.181958669180016e-10,   6.784590215144301e-12,  -2.440176768647587e-13,
   9.935000174980206e-15,  -4.192353212134010e-16,   1.690838768175424e-17,  -1.703881302542490e-04,   6.090302198747538e-06,  -1.820030443365893e-07,   5.148747575732172e-09,
  -1.471196260704524e-10,   4.578737207991931e-12,  -1.648679064078870e-13,   6.718259777191266e-15,  -2.835991424406174e-16,   1.143748755315956e-17,  -9.408336739113172e-05,
   3.363073552367118e-06,  -1.005111140773110e-07,   2.843828547795209e-09,  -8.128351002238769e-11,   2.531087934440699e-12,  -9.119720372280333e-14,   3.718067642061970e-15,
  -1.569842469256942e-16,   6.330977669315841e-18,  -3.567750822834636e-05,   1.275343119034102e-06,  -3.811702557113734e-08,   1.078532559217935e-09,  -3.083054099386903e-11,
   9.602231517081438e-13,  -3.460612493002052e-14,   1.411137574801727e-15,  -5.958570441112366e-17,   2.402993513623545e-18,  -4.067723619438430e-06,   1.454070488204010e-07,
  -4.345900518938854e-09,   1.229697163465422e-10,  -3.515233304776474e-12,   1.094862239064200e-13,  -3.946007683629950e-15,   1.609117164653254e-16,  -6.794633069292834e-18,
   2.740159432368748e-19,  -3.618917298922108e-03,   1.179960181035959e-04,  -3.205723755214080e-06,   8.124539669173871e-08,  -1.982209065658616e-09,   4.704934274864886e-11,
  -1.085430907747619e-12,   2.402686469099895e-14,  -4.949004431118550e-16,   8.869193243087957e-18,  -3.346257246830104e-03,   1.091119659109025e-04,  -2.964593113255982e-06,
   7.514165662433877e-08,  -1.833502543689708e-09,   4.352486383735359e-11,  -1.004217965669548e-12,   2.222967076864269e-14,  -4.578159268062682e-16,   8.200170655740017e-18,
  -2.842361793601193e-03,   9.268989959582036e-05,  -2.518725847284475e-06,   6.385092044960715e-08,  -1.558296415553625e-09,   3.699908317323498e-11,  -8.537884317754373e-13,
   1.890043143443989e-14,  -3.891580096909481e-16,   6.964217034481580e-18,  -2.183848119230059e-03,   7.122261791706585e-05,  -1.935644526108703e-06,   4.907799018349651e-08,
  -1.198000034677825e-09,   2.845036387475292e-11,  -6.566287675881991e-13,   1.453645391329088e-14,  -2.992280190433116e-16,   5.349804498160822e-18,  -1.470936798970821e-03,
   4.797587722850404e-05,  -1.303998754095519e-06,   3.306718985796659e-08,  -8.073018009898228e-10,   1.917510607533686e-11,  -4.426159048013336e-13,   9.798934324788114e-15,
  -2.016672134502476e-16,   3.602854338585265e-18,  -8.122028811064657e-04,   2.649187638886097e-05,  -7.201017331799653e-07,   1.826198523535474e-08,  -4.458884126309815e-10,
   1.059177906145251e-11,  -2.445068865235466e-13,   5.413155407489000e-15,  -1.113926126316832e-16,   1.989208224281940e-18,  -3.079959882869925e-04,   1.004616935680445e-05,
  -2.730811524371809e-07,   6.925619579043664e-09,  -1.691031461632339e-10,   4.017073319075668e-12,  -9.273513365107662e-14,   2.053083101350199e-15,  -4.224676017711517e-17,
   7.543046039257591e-19,  -3.511573759251008e-05,   1.145403301991111e-06,  -3.113517679169053e-08,   7.896240345329888e-10,  -1.928039277166633e-11,   4.580116142539727e-13,
  -1.057336155948131e-14,   2.340861813858720e-16,  -4.816809877092741e-18,   8.600053681284264e-20,  -3.655888037975558e-04,   1.192162940350949e-05,  -3.241942576885932e-07,
   8.258770097078336e-09,  -2.058777255999473e-10,   5.245348880349462e-12,  -1.452405961707924e-13,   4.610085472894163e-15,  -1.656757958207368e-16,   6.251947341733070e-18,
  -3.380442674714157e-04,   1.102404362586983e-05,  -2.998102445619773e-07,   7.638521021904285e-09,  -1.904545957250011e-10,   4.854237984362253e-12,  -1.344982253027456e-13,
   4.272588117754358e-15,  -1.536485239147599e-16,   5.800010873398375e-18,  -2.871399660665772e-04,   9.364862621664888e-06,  -2.547216236256356e-07,   6.491054683248783e-09,
  -1.618983278017900e-10,   4.128976474189403e-12,  -1.145250633470544e-13,   3.642958390749327e-15,  -1.311478473128937e-16,   4.953322529650639e-18,  -2.206158741789295e-04,
   7.195938097530761e-06,  -1.957556443761287e-07,   4.989485256262583e-09,  -1.244906651731422e-10,   3.177050437148069e-12,  -8.822122144213453e-14,   2.810216160202301e-15,
  -1.012843222186375e-16,   3.827584794791976e-18,  -1.485964285770231e-04,   4.847220707598571e-06,  -1.318769358138971e-07,   3.361884154567193e-09,  -8.390446592622321e-11,
   2.142390924514145e-12,  -5.954343732904533e-14,   1.898811466275233e-15,  -6.849713010399430e-17,   2.589690611953412e-18,  -8.205005987607261e-05,   2.676595927875343e-06,
  -7.282613348127744e-08,   1.856705300361740e-09,  -4.634633124501557e-11,   1.183749233565967e-12,  -3.291681205579751e-14,   1.050371698066697e-15,  -3.791025431189780e-17,
   1.433649215280632e-18,  -3.111425761157006e-05,   1.015010819871689e-06,  -2.761758964152810e-08,   7.041370668460366e-10,  -1.757745139477933e-11,   4.490031155900254e-13,
  -1.248794849295385e-14,   3.985844804073858e-16,  -1.438857287836647e-17,   5.441835035623811e-19,  -3.547449155371143e-06,   1.157253815364105e-07,  -3.148802989119753e-09,
   8.028224858062707e-11,  -2.004114772763773e-12,   5.119460282272520e-14,  -1.423900997903776e-15,   4.544920827446910e-17,  -1.640731502459755e-18,   6.205432166683239e-20,
  -3.192727378266929e-03,   9.577418250542869e-05,  -2.394048246458744e-06,   5.584255836290559e-08,  -1.255341953029869e-09,   2.754672494488230e-11,  -5.924896993685144e-13,
   1.245346291425500e-14,  -2.526784974881603e-16,   4.814864891834007e-18,  -2.952158514950433e-03,   8.856189886457062e-05,  -2.213911287480994e-06,   5.164514932476446e-08,
  -1.161102704536319e-09,   2.548170310344212e-11,  -5.481378540583429e-13,   1.152231678458350e-14,  -2.337916484766488e-16,   4.454394092377351e-18,  -2.507581512060771e-03,
   7.523088575000724e-05,  -1.880861578366757e-06,   4.388203502223600e-08,  -9.867353360367839e-10,   2.165909795063384e-11,  -4.659985579153681e-13,   9.797183993344911e-15,
  -1.987963169486760e-16,   3.786826074395646e-18,  -1.926607305511054e-03,   5.780564617016475e-05,  -1.445377140710555e-06,   3.372682123815979e-08,  -7.585192250588038e-10,
   1.665302421263990e-11,  -3.583646500743724e-13,   7.535506313030996e-15,  -1.529108117443519e-16,   2.912100766448107e-18,  -1.297659957179953e-03,   3.893733734774748e-05,
  -9.736810789393183e-07,   2.272278544692485e-08,  -5.111090224604021e-10,   1.122298505950825e-11,  -2.415513714076717e-13,   5.079865484952015e-15,  -1.030842845452287e-16,
   1.962829156435906e-18,  -7.165214168764788e-04,   2.150061336069453e-05,  -5.376803459289228e-07,   1.254868466877708e-08,  -2.822833552019730e-10,   6.198969864150991e-12,
  -1.334321510655426e-13,   2.806306706005072e-15,  -5.694867993295263e-17,   1.084247507387600e-18,  -2.717120310260899e-04,   8.153361033181088e-06,  -2.039006261558609e-07,
   4.758867045385428e-09,  -1.070542246256329e-10,   2.351001272641615e-12,  -5.060678899314881e-14,   1.064376835711054e-15,  -2.159966594454417e-17,   4.112205187757835e-19,
  -3.097886232706650e-05,   9.295960841095466e-07,  -2.324757153950944e-08,   5.425808017419748e-10,  -1.220581675193915e-11,   2.680515683497666e-13,  -5.770012438807377e-15,
   1.213571497516423e-16,  -2.462733963880425e-18,   4.688591734944603e-20,  -3.225316005974305e-04,   9.675421796326944e-06,  -2.419061014996843e-07,   5.649851563666321e-09,
  -1.277724538527693e-10,   2.867676302324725e-12,  -6.609434574834469e-14,   1.648478587150711e-15,  -4.670687433492988e-17,   1.495085199814794e-18,  -2.982291650801597e-04,
   8.946814452565970e-06,  -2.237044546097971e-07,   5.225216665239038e-09,  -1.181844125677619e-10,   2.653034804044943e-12,  -6.116997467893797e-14,   1.526605955695050e-15,
  -4.328804655806070e-17,   1.386594193783719e-18,  -2.533176822882381e-04,   7.600073300026582e-06,  -1.900518343704774e-07,   4.439831861954847e-09,  -1.004416660222201e-10,
   2.255507594798131e-12,  -5.203606601993363e-14,   1.299977193765048e-15,  -3.690962938273403e-17,   1.183601360968281e-18,  -1.946272547246725e-04,   5.839719232165978e-06,
  -1.460485599839100e-07,   3.412404450146389e-09,  -7.721559472029964e-11,   1.734571631608915e-12,  -4.004365207284890e-14,   1.001462172986161e-15,  -2.847307383337242e-17,
   9.141373170601247e-19,  -1.310905433282886e-04,   3.933580448954563e-06,  -9.838604725847477e-08,   2.299062953582563e-09,  -5.203216264934624e-11,   1.169183427660880e-12,
  -2.700509261292580e-14,   6.759523214139813e-16,  -1.923905622425491e-17,   6.182460377656757e-19,  -7.238351007359408e-05,   2.172064325095190e-06,  -5.433020456001535e-08,
   1.269667304018175e-09,  -2.873790556480472e-11,   6.458582985967742e-13,  -1.492204096266081e-14,   3.736903289498332e-16,  -1.064263509830669e-17,   3.421819681341437e-19,
  -2.744854533272838e-05,   8.236800058815229e-07,  -2.060325733312478e-08,   4.814999168957268e-10,  -1.089878238611981e-11,   2.449553431171391e-13,  -5.660124295804974e-15,
   1.417717394692391e-16,  -4.038574927906733e-18,   1.298740714015491e-19,  -3.129507015741472e-06,   9.391092949260935e-08,  -2.349064517773016e-09,   5.489808808687154e-11,
  -1.242629713551999e-12,   2.792898249239054e-14,  -6.453601337058814e-16,   1.616512643884823e-17,  -4.605049977179890e-19,   1.480958765789702e-20,  -2.844123910642567e-03,
   7.899816611132945e-05,  -1.828483778751110e-06,   3.949592347126839e-08,  -8.224776366335733e-10,   1.673753405718325e-11,  -3.349089320396210e-13,   6.598766231927004e-15,
  -1.275633784769324e-16,   2.392074625954372e-18,  -2.629808519033572e-03,   7.304833299384082e-05,  -1.690865899913488e-06,   3.652599961396146e-08,  -7.606985287382511e-10,
   1.548192035273772e-11,  -3.098199573904001e-13,   6.105127284851469e-15,  -1.180315395160502e-16,   2.213401073398756e-18,  -2.233756686251852e-03,   6.205132832298889e-05,
  -1.436450215073674e-06,   3.103385325511911e-08,  -6.464122831208689e-10,   1.315817063825612e-11,  -2.633667751491740e-13,   5.190715443532341e-15,  -1.003682254037596e-16,
   1.882261536343997e-18,  -1.716208849074172e-03,   4.767779545446061e-05,  -1.103821342316102e-06,   2.385059829532009e-08,  -4.968673716077219e-10,   1.011590020754297e-11,
  -2.025143581195256e-13,   3.992158826749391e-15,  -7.720516526676820e-17,   1.447947429909776e-18,  -1.155938662762056e-03,   3.211478878601950e-05,  -7.435696114926724e-07,
   1.606814340276604e-08,  -3.347802767785263e-10,   6.816876256026549e-12,  -1.364910573957567e-13,   2.691061460442684e-15,  -5.204952335925257e-17,   9.762046321209304e-19,
  -6.382654014637101e-04,   1.773313743623433e-05,  -4.106026346768673e-07,   8.873418134596064e-09,  -1.848909601385770e-10,   3.765101649025726e-12,  -7.539359278536444e-14,
   1.486595267327034e-15,  -2.875526311280671e-17,   5.393262609547469e-19,  -2.420362053108909e-04,   6.724652829196816e-06,  -1.557088782638778e-07,   3.365053976554936e-09,
  -7.011779385296169e-11,   1.427915782815608e-12,  -2.859400246144999e-14,   5.638295776120162e-16,  -1.090647124893033e-17,   2.045607291255982e-19,  -2.759540813680445e-05,
   7.667031113957135e-07,  -1.775300817262405e-08,   3.836649955180550e-10,  -7.994481248477408e-12,   1.628046658441614e-13,  -3.260180363859147e-15,   6.428608100741286e-17,
  -1.243527264802580e-18,   2.332351178734368e-20,  -2.873149629828331e-04,   7.980478101480963e-06,  -1.847238298998454e-07,   3.991312135055271e-09,  -8.324593137218919e-11,
   1.705084115731934e-12,  -3.489408863080138e-14,   7.340191042645731e-16,  -1.660761013965309e-17,   4.224762822273574e-19,  -2.656647046300796e-04,   7.379419877178416e-06,
  -1.708209315896142e-07,   3.691188785009261e-09,  -7.699371859716798e-11,   1.577230679921619e-12,  -3.228423793208910e-14,   6.793613547775061e-16,  -1.537997352694801e-17,
   3.915453594398678e-19,  -2.256553310730450e-04,   6.268491105400695e-06,  -1.451184652649328e-07,   3.136180486784961e-09,  -6.542723674231250e-11,   1.340578746437181e-12,
  -2.744949298372673e-14,   5.779615484447339e-16,  -1.309701255446597e-17,   3.338425478805108e-19,  -1.733723639783579e-04,   4.816461770100900e-06,  -1.115144314350364e-07,
   2.410271143679152e-09,  -5.029167786569785e-11,   1.030693405285079e-12,  -2.111189855485253e-14,   4.447971851476322e-16,  -1.008972662832510e-17,   2.575275411208805e-19,
  -1.167735612038753e-04,   3.244270349817612e-06,  -7.511973892304814e-08,   1.623802971446096e-09,  -3.388603681997478e-11,   6.945965091711193e-13,  -1.423158004488060e-14,
   2.999857601351374e-16,  -6.810319151991914e-18,   1.740056007888599e-19,  -6.447792294746424e-05,   1.791420569603555e-06,  -4.148148121961622e-08,   8.967247647554249e-10,
  -1.871456082259117e-11,   3.836513651376906e-13,  -7.861911465978086e-15,   1.657671787581656e-16,  -3.765017814682446e-18,   9.625493115169832e-20,  -2.445063099018620e-05,
   6.793316490971720e-07,  -1.573062335399671e-08,   3.400638531680074e-10,  -7.097303077516402e-12,   1.455014996446904e-13,  -2.981847953259443e-15,   6.287848195385842e-17,
  -1.428388226947330e-18,   3.652580938407927e-20,  -2.787703354424091e-06,   7.745317162892883e-08,  -1.793512942576958e-09,   3.877221838145612e-11,  -8.091994639078424e-13,
   1.658947049385114e-14,  -3.399812476566653e-16,   7.169339863668984e-18,  -1.628680642934871e-19,   4.164910772599472e-21,  -2.554670816081400e-03,   6.606527139159732e-05,
  -1.423704751208488e-06,   2.863300169025843e-08,  -5.552236997117378e-10,   1.052481318855842e-11,  -1.963775859492791e-13,   3.618389284053468e-15,  -6.585574232201872e-17,
   1.179305054295473e-18,  -2.362157136148939e-03,   6.108891184476020e-05,  -1.316529391574755e-06,   2.647921373363515e-08,  -5.134993076716529e-10,   9.734772839980892e-12,
  -1.816553538939140e-13,   3.347496109466203e-15,  -6.093217644448715e-17,   1.091237077046119e-18,  -2.006400397007979e-03,   5.189151794076582e-05,  -1.118406738029574e-06,
   2.249673958732978e-08,  -4.363245164733352e-10,   8.272952133292380e-12,  -1.544032793246576e-13,   2.845823728559898e-15,  -5.181001861609644e-17,   9.280076887918999e-19,
  -1.541518641235982e-03,   3.987073621004516e-05,  -8.593993858254630e-07,   1.728872205759913e-08,  -3.353602294513781e-10,   6.359622643683793e-12,  -1.187149620826396e-13,
   2.188473773894799e-15,  -3.985024388575108e-17,   7.139010925687562e-19,  -1.038271653488740e-03,   2.685576259301996e-05,  -5.789055273957165e-07,   1.164698091941418e-08,
  -2.259478280629592e-10,   4.285309296396644e-12,  -8.000511160291244e-14,   1.475095107000075e-15,  -2.686430513944990e-17,   4.813234796048040e-19,  -5.732922940826491e-04,
   1.482909769846578e-05,  -3.196700249701976e-07,   6.431753721625146e-09,  -1.247816838880646e-10,   2.366770398790958e-12,  -4.419032031031492e-14,   8.148313745890064e-16,
  -1.484093859615995e-17,   2.659219194867295e-19,  -2.173975314034135e-04,   5.623384579991906e-06,  -1.212247650263030e-07,   2.439085574194321e-09,  -4.732149671029711e-11,
   8.975848351785473e-13,  -1.675945303623260e-14,   3.090400860203886e-16,  -5.628889449097249e-18,   1.008619232133226e-19,  -2.478626034477715e-05,   6.411430509771068e-07,
  -1.382132126481245e-08,   2.780907907255097e-10,  -5.395350947137795e-12,   1.023384136401629e-13,  -1.910843950897365e-15,   3.523567380822709e-17,  -6.417898591908988e-19,
   1.150003930559665e-20,  -2.580741762611043e-04,   6.673954501037371e-06,  -1.438249015891975e-07,   2.892748746444520e-09,  -5.611483648109420e-11,   1.065563530340321e-12,
  -2.001441439249365e-14,   3.768578833732054e-16,  -7.286459273122959e-18,   1.504020594016258e-19,  -2.386263441336384e-04,   6.171239619170124e-06,  -1.329978845013818e-07,
   2.675155838240847e-09,  -5.189798715229698e-11,   9.855874162374807e-13,  -1.851467535586188e-14,   3.486887222557756e-16,  -6.744089807670103e-18,   1.392832390804606e-19,
  -2.026876131703415e-04,   5.242113248607067e-06,  -1.129832299333141e-07,   2.272813792138691e-09,  -4.409829777474976e-11,   8.376007278790349e-13,  -1.573809955956191e-14,
   2.964948512827940e-16,  -5.737772072191021e-18,   1.186069024415735e-19,  -1.557250161491827e-04,   4.027766477029313e-06,  -8.681790265926319e-08,   1.746656318150004e-09,
  -3.389420312439677e-11,   6.438957499359491e-13,  -1.210126870968206e-14,   2.280592675761904e-16,  -4.416004385781413e-18,   9.137159607874158e-20,  -1.048867433410843e-04,
   2.712985797122894e-06,  -5.848196798559273e-08,   1.176679429667148e-09,  -2.283617446629488e-11,   4.338828142888951e-13,  -8.155800913332352e-15,   1.537457539273678e-16,
  -2.978422208969412e-18,   6.167293435870624e-20,  -5.791428622974767e-05,   1.498044654917040e-06,  -3.229358170861031e-08,   6.497919657261845e-10,  -1.261150110650432e-11,
   2.396348142625982e-13,  -4.504945956861083e-15,   8.493666806135744e-17,  -1.645866592765179e-18,   3.409506210784268e-20,  -2.196161188718916e-05,   5.680778019658456e-07,
  -1.224632155176603e-08,   2.464177674649786e-10,  -4.782717156318338e-12,   9.088047945154701e-14,  -1.708548740838745e-15,   3.221506196322972e-17,  -6.243125394878908e-19,
   1.293509726023891e-20,  -2.503920933791412e-06,   6.476866912756574e-08,  -1.396252200491317e-09,   2.809516559867705e-11,  -5.453005958263555e-13,   1.036177129797002e-14,
  -1.948020840397259e-16,   3.673072505604415e-18,  -7.118358049928008e-20,   1.474888547080776e-21,  -2.311206918646257e-03,   5.591348583087138e-05,  -1.127208526150296e-06,
   2.120793100463435e-08,  -3.847343117919229e-10,   6.823607821608694e-12,  -1.191639305740157e-13,   2.057080158610946e-15,  -3.516619387006820e-17,   5.950034240076605e-19,
  -2.137032977192394e-03,   5.170140861791831e-05,  -1.042338669931356e-06,   1.961223230227458e-08,  -3.558108144935507e-10,   6.311129444963659e-12,  -1.102244102292066e-13,
   1.902955728619764e-15,  -3.253497174823083e-17,   5.505437038779087e-19,  -1.815171549080477e-03,   4.391681611772272e-05,  -8.854583735975901e-07,   1.666195517048988e-08,
  -3.023197365221742e-10,   5.363046704143725e-12,  -9.368020309291564e-14,   1.617602343095428e-15,  -2.766123835716160e-17,   4.681559149185071e-19,  -1.394589329548164e-03,
   3.374293654225537e-05,  -6.803821166933001e-07,   1.280420909765102e-08,  -2.323510698340029e-10,   4.122402317956571e-12,  -7.202050408801006e-14,   1.243820117785515e-15,
  -2.127356377690329e-17,   3.601150884147919e-19,  -9.393048737057215e-04,   2.272801478525306e-05,  -4.583078165559733e-07,   8.625618195267038e-09,  -1.565390106965130e-10,
   2.777640174607122e-12,  -4.853292713694696e-14,   8.382988297932338e-16,  -1.433991825983214e-17,   2.427796875363484e-19,  -5.186454124526069e-04,   1.254977911933953e-05,
  -2.530735180627002e-07,   4.763199490359415e-09,  -8.644790258190822e-11,   1.534035428189208e-12,  -2.680571924356117e-14,   4.630469298042116e-16,  -7.921554331391523e-18,
   1.341261118162840e-19,  -1.966747541730558e-04,   4.759026718276595e-06,  -9.596974551242768e-08,   1.806315400469180e-09,  -3.278370532130628e-11,   5.817672952949725e-13,
  -1.016607323440911e-14,   1.756159605682948e-16,  -3.004439677220860e-18,   5.087218648160445e-20,  -2.242357965519224e-05,   5.425941803827589e-07,  -1.094188778366072e-08,
   2.059456802894708e-10,  -3.737821797218037e-12,   6.633024045069742e-14,  -1.159090823589886e-15,   2.002305802885674e-17,  -3.425565293159646e-19,   5.800313711050849e-21,
  -2.334793144213361e-04,   5.648410171272569e-06,  -1.138714247449115e-07,   2.142472406559528e-09,  -3.887020049349925e-11,   6.897024727503384e-13,  -1.206670761588388e-14,
   2.096697336445595e-16,  -3.657824074304046e-18,   6.536689031600513e-20,  -2.158841730756638e-04,   5.222903888921127e-06,  -1.052978112893268e-07,   1.981271537229020e-09,
  -3.594804105533110e-11,   6.379048977194884e-13,  -1.116160086546458e-14,   1.939680943094945e-16,  -3.384551937711907e-18,   6.050246843379655e-20,  -1.833695656932857e-04,
   4.436500207397487e-06,  -8.944965110318454e-08,   1.683228180621001e-09,  -3.054379208988201e-11,   5.420786204041774e-13,  -9.486463162707768e-15,   1.648927301789238e-16,
  -2.878127838294468e-18,   5.147624895562580e-20,  -1.408821330603916e-04,   3.408729467574608e-06,  -6.873269924772806e-08,   1.293510187635147e-09,  -2.347477965595820e-11,
   4.166803749494784e-13,  -7.293247686570295e-15,   1.267994207247440e-16,  -2.213971701412803e-18,   3.961938509579162e-20,  -9.488906261378874e-05,   2.295996193014402e-06,
  -4.629859164322731e-08,   8.713795771641839e-10,  -1.581538409943175e-11,   2.807567562593084e-13,  -4.914822652304551e-15,   8.546380038616041e-17,  -1.492630010308973e-18,
   2.672243124736064e-20,  -5.239382696337759e-05,   1.267785390667037e-06,  -2.556567255702086e-08,   4.811892833249088e-10,  -8.733972091199019e-12,   1.550566949264537e-13,
  -2.714579878086892e-15,   4.720869865782748e-17,  -8.246288074162467e-19,   1.476695459098866e-20,  -1.986818506627543e-05,   4.807594214701509e-07,  -9.694934166958049e-09,
   1.824781088429663e-10,  -3.312191544267734e-12,   5.880371652645522e-14,  -1.029508227740648e-15,   1.790466278024188e-17,  -3.127718072652628e-19,   5.601454892634954e-21,
  -2.265241577711450e-06,   5.481315397216748e-08,  -1.105357539658232e-09,   2.080510325706192e-11,  -3.776382794257946e-13,   6.704510881250522e-15,  -1.173800505101826e-16,
   2.041424962728589e-18,  -3.566145150520789e-20,   6.386736877406389e-22,  -2.104111735736120e-03,   4.781860164377146e-05,  -9.055991101186458e-07,   1.600609424119122e-08,
  -2.727781969817023e-10,   4.545055863422837e-12,  -7.457468297244207e-14,   1.209923252135651e-15,  -1.945724816480453e-17,   3.103946230616580e-19,  -1.945539291642159e-03,
   4.421604705310357e-05,  -8.374050924396264e-07,   1.480151888076111e-08,  -2.522647713356292e-10,   4.203556974161805e-12,  -6.897704184886865e-14,   1.119208277583097e-15,
  -1.800024625680678e-17,   2.871824074800219e-19,  -1.652511567718371e-03,   3.755811996048563e-05,  -7.113555591806844e-07,   1.257454817933118e-08,  -2.143312295835315e-10,
   3.571875267097241e-12,  -5.861949598319013e-14,   9.512923065104946e-16,  -1.530219123646825e-17,   2.441796653737159e-19,  -1.269612241913239e-03,   2.885699170265951e-05,
  -5.465914118062463e-07,   9.662857466298962e-09,  -1.647191124399691e-10,   2.745417510925874e-12,  -4.506256478049623e-14,   7.314040364259029e-16,  -1.176720915798732e-17,
   1.878064233770773e-19,  -8.551252109937291e-04,   1.943685031844792e-05,  -3.681801381994906e-07,   6.509270700369022e-09,  -1.109702197352456e-10,   1.849749906860906e-12,
  -3.036470607170873e-14,   4.929072936753153e-16,  -7.931248021475046e-18,   1.266025013274404e-19,  -4.721638525547980e-04,   1.073243533063004e-05,  -2.033039690596677e-07,
   3.594468564383968e-09,  -6.128150208600139e-11,   1.021551583777324e-12,  -1.677043745410813e-14,   2.722526571113461e-16,  -4.381099608346216e-18,   6.993920297006323e-20,
  -1.790484055748369e-04,   4.069860460204900e-06,  -7.709603082740702e-08,   1.363098317462462e-09,  -2.323965244677336e-11,   3.874089635857906e-13,  -6.360104872804925e-15,
   1.032532826035574e-16,  -1.661605425037576e-18,   2.652645820741389e-20,  -2.041393497870540e-05,   4.640196490969138e-07,  -8.790016450743123e-09,   1.554124830150419e-10,
  -2.649656820812995e-12,   4.417038442483957e-14,  -7.251494721582174e-16,   1.177251062072792e-17,  -1.894502947406504e-19,   3.024467630028971e-21,  -2.125584503630744e-04,
   4.830659903834433e-06,  -9.148412542446689e-08,   1.616949580849327e-09,  -2.755684876462750e-11,   4.592040566181513e-13,  -7.538174273236602e-15,   1.225279712193926e-16,
  -1.982745555219635e-18,   3.222168937969880e-20,  -1.965393804579740e-04,   4.466727974078673e-06,  -8.459512803425360e-08,   1.495262355373022e-09,  -2.548452569060058e-11,
   4.247014108813014e-13,  -6.972372363006289e-15,   1.133426120826173e-16,  -1.834343532076729e-18,   2.981547839630906e-20,  -1.669375689914966e-04,   3.794140731963434e-06,
  -7.186153434897633e-08,   1.270291868714339e-09,  -2.165237244455906e-11,   3.608805728088121e-13,  -5.925433735836798e-15,   9.633948714823090e-17,  -1.559492444138896e-18,
   2.535569083492976e-20,  -1.282568820520133e-04,   2.915148249446110e-06,  -5.521696871828291e-08,   9.761503535615213e-10,  -1.664041359683963e-11,   2.773806115505745e-13,
  -4.555081640131332e-15,   7.407237409664802e-17,  -1.199312397542074e-18,   1.950579573587052e-20,  -8.638518888438282e-05,   1.963520687757095e-06,  -3.719376264181579e-08,
   6.575722631254916e-10,  -1.121054276593994e-11,   1.868878628838397e-13,  -3.069382925154796e-15,   4.991957987734410e-17,  -8.083946598814847e-19,   1.315117010332922e-20,
  -4.769823537332319e-05,   1.084196176822373e-06,  -2.053788023181839e-08,   3.631163875612291e-10,  -6.190840807230078e-12,   1.032116226745700e-13,  -1.695225142937026e-15,
   2.757285380702428e-17,  -4.465585070862012e-19,   7.265786227213167e-21,  -1.808756207435563e-05,   4.111394120213829e-07,  -7.788283995674485e-09,   1.377013961092867e-10,
  -2.347739349095006e-12,   3.914155296076422e-14,  -6.429062497459676e-16,   1.045718834597396e-17,  -1.693667501870548e-19,   2.755853804134512e-21,  -2.062226217116701e-06,
   4.687550533075913e-08,  -8.879723601528263e-10,   1.569990633022476e-11,  -2.676762757394293e-13,   4.462719396325145e-15,  -7.330118041726647e-17,   1.192285871553353e-18,
  -1.931062674400083e-20,   3.142160253647093e-22,  -1.926206822055209e-03,   4.127423477189895e-05,  -7.369992633304414e-07,   1.228197943302337e-08,  -1.973551496261781e-10,
   3.100558899149693e-12,  -4.796989252420789e-14,   7.339305782205550e-16,  -1.113335568315262e-17,   1.676731428994095e-19,  -1.781037792045337e-03,   3.816451676789229e-05,
  -6.814947571924701e-07,   1.135750057981135e-08,  -1.825097252451951e-10,   2.867509659699970e-12,  -4.436752503071125e-14,   6.788708239331953e-16,  -1.029906838218182e-17,
   1.551238511526093e-19,  -1.512780831504403e-03,   3.241752958198970e-05,  -5.789043938710366e-07,   9.648464032814022e-09,  -1.550598730240453e-10,   2.436482006621655e-12,
  -3.770294869900501e-14,   5.769734950473032e-16,  -8.754509356690251e-18,   1.318813444958548e-19,  -1.162253553005610e-03,   2.490709694788601e-05,  -4.448111835304723e-07,
   7.414127007785389e-09,  -1.191630420275908e-10,   1.872634463387110e-12,  -2.898144744299995e-14,   4.435706360908460e-16,  -6.731437910056034e-18,   1.014225703364103e-19,
  -7.828131909624513e-04,   1.677624605008648e-05,  -2.996177693751946e-07,   4.994337091879466e-09,  -8.027700140591116e-11,   1.261653414368274e-12,  -1.952766740383316e-14,
   2.989110741351707e-16,  -4.536714322777100e-18,   6.836398466594833e-20,  -4.322354445846129e-04,   9.263291985207410e-06,  -1.654435295598500e-07,   2.757878029575186e-09,
  -4.433091111381356e-11,   6.967503908780020e-13,  -1.078480946700195e-14,   1.650943994603401e-16,  -2.505896564199712e-18,   3.776445418827654e-20,  -1.639071148190580e-04,
   3.512739203375676e-06,  -6.273858465318102e-08,   1.045840875538097e-09,  -1.681140807453235e-11,   2.642303981635671e-13,  -4.090038584383601e-15,   6.261204204843388e-17,
  -9.503869133220680e-19,   1.432297834982848e-20,  -1.868762136270817e-05,   4.005001160101109e-07,  -7.153065157342985e-09,   1.192405603942231e-10,  -1.916741856193704e-12,
   3.012615197179370e-14,  -4.663262269867054e-16,   7.138748168136040e-18,  -1.083594004824410e-19,   1.633057986488378e-21,  -1.945864041300103e-04,   4.169544455146299e-06,
  -7.445205051644269e-08,   1.240732768164040e-09,  -1.993702113734737e-11,   3.132295150140995e-13,  -4.846671000265834e-15,   7.418995245183205e-17,  -1.127450021815219e-18,
   1.707833226675647e-20,  -1.799213540343226e-04,   3.855399140830707e-06,  -6.884495634412796e-08,   1.147341376212402e-09,  -1.843732150284785e-11,   2.896860930548615e-13,
  -4.482706577284817e-15,   6.862440225620526e-17,  -1.042975265118520e-18,   1.580069912209762e-20,  -1.528218978720286e-04,   3.274835535453025e-06,  -5.848122429311523e-08,
   9.746935067802503e-10,  -1.566430966283565e-11,   2.461421966269118e-13,  -3.809350594194127e-15,   5.832429088411666e-17,  -8.865757888300636e-19,   1.343405284664715e-20,
  -1.174114518642486e-04,   2.516127762549843e-06,  -4.493505816498919e-08,   7.489794722505485e-10,  -1.203797500226616e-11,   1.891803344337062e-13,  -2.928169765737652e-15,
   4.483928811005938e-17,  -6.817111682704364e-19,   1.033203672133478e-20,  -7.908019128176623e-05,   1.694745016980417e-06,  -3.026754362339135e-08,   5.045308738808818e-10,
  -8.109666842767625e-12,   1.274568362761753e-13,  -1.972999549662144e-15,   3.021619364815433e-17,  -4.594526037973006e-19,   6.964669623123383e-21,  -4.366464698241792e-05,
   9.357825276466177e-07,  -1.671319181177824e-08,   2.786024633117158e-10,  -4.478355209230393e-12,   7.038827788089553e-14,  -1.089655828174980e-15,   1.668903207716879e-17,
  -2.537852122532274e-19,   3.847414581225338e-21,  -1.655798106368239e-05,   3.548587236567259e-07,  -6.337884607670273e-09,   1.056514615056618e-10,  -1.698306116902920e-12,
   2.669352435359582e-14,  -4.132419185768447e-16,   6.329320311960560e-18,  -9.625096250219486e-20,   1.459230353797445e-21,  -1.887833124209416e-06,   4.045872800786711e-08,
  -7.226063802669040e-10,   1.204575167539786e-11,  -1.936312775632941e-13,   3.043454435706247e-15,  -4.711582732927989e-17,   7.216412238273496e-19,  -1.097416459231839e-20,
   1.663768556146566e-22,  -1.772038484473440e-03,   3.591843350178421e-05,  -6.067003697306677e-07,   9.564161670469709e-09,  -1.453788681535369e-10,   2.160581525988088e-12,
  -3.162154757180203e-14,   4.576854905241203e-16,  -6.568655888959324e-18,   9.362183811138987e-20,  -1.638485245648225e-03,   3.321208840272205e-05,  -5.610043574722032e-07,
   8.844144440929650e-09,  -1.344407453323529e-10,   1.998134713398911e-12,  -2.924593245142959e-14,   4.233323895623119e-16,  -6.076123277855158e-18,   8.660969126037674e-20,
  -1.391694932150824e-03,   2.821065358947888e-05,  -4.765460025091742e-07,   7.513153091436444e-09,  -1.142171506347139e-10,   1.697717237584496e-12,  -2.485148992992213e-14,
   3.597667182363398e-16,  -5.164457145824715e-18,   7.362563043664828e-20,  -1.069220962028790e-03,   2.167469342700437e-05,  -3.661572197267521e-07,   5.773172362879211e-09,
  -8.777274524729523e-11,   1.304777183135013e-12,  -1.910172630117360e-14,   2.765647955622202e-16,  -3.970660618959757e-18,   5.661551484489573e-20,  -7.201510119589036e-04,
   1.459896202831270e-05,  -2.466349868123074e-07,   3.888882620517691e-09,  -5.912870717173666e-11,   8.790399382143301e-13,  -1.287014919804927e-14,   1.863595743034415e-16,
  -2.675879197077887e-18,   3.815864667950846e-20,  -3.976355074774909e-04,   8.061038770502619e-06,  -1.361865261859547e-07,   2.147423486214106e-09,  -3.265183789819067e-11,
   4.854418547703020e-13,  -7.107789071162167e-15,   1.029266795882059e-16,  -1.477988262862342e-18,   2.107795479312959e-20,  -1.507864578330392e-04,   3.056827892323430e-06,
  -5.164378151636775e-08,   8.143416088779199e-10,  -1.238233961341321e-11,   1.840939723093458e-13,  -2.695536827840758e-15,   3.903446237243830e-17,  -5.605338238680747e-19,
   7.994125381508880e-21,  -1.719168791135893e-05,   3.485199399059584e-07,  -5.888102033818366e-09,   9.284633223577121e-11,  -1.411763202141388e-12,   2.098939499424058e-14,
  -3.073314548469614e-16,   4.450527809424690e-18,  -6.390971751309689e-20,   9.114607263123451e-22,  -1.790122393069305e-04,   3.628498633921144e-06,  -6.128918434719353e-08,
   9.661766688769647e-10,  -1.468626390090150e-11,   2.182645288196745e-13,  -3.194538806363559e-15,   4.624315747370844e-17,  -6.640045382781199e-19,   9.480010512007621e-21,
  -1.655206224158792e-04,   3.355102259502685e-06,  -5.667294961855525e-08,   8.934401483031366e-10,  -1.358128798859460e-11,   2.018539644245155e-13,  -2.954544913052612e-15,
   4.277225762552045e-17,  -6.142178759509085e-19,   8.770065028068721e-21,  -1.405897379879056e-04,   2.849854741240581e-06,  -4.814092303346574e-08,   7.589826992502399e-10,
  -1.153828793672291e-11,   1.715054403840709e-13,  -2.510600900804850e-15,   3.634981641263670e-17,  -5.220628114127388e-19,   7.455435802862930e-21,  -1.080132516330708e-04,
   2.189588682608236e-06,  -3.698939124985764e-08,   5.832089264687989e-10,  -8.866857663872518e-12,   1.318101705817684e-13,  -1.929736452598438e-15,   2.794336684948555e-17,
  -4.013869023860857e-19,   5.733075414027937e-21,  -7.275002570185561e-05,   1.474794655939569e-06,  -2.491519361785438e-08,   3.928569801874377e-10,  -5.973219054164800e-12,
   8.880168287758858e-14,  -1.300196731284967e-15,   1.882929317019795e-17,  -2.705009451471025e-19,   3.864129043259801e-21,  -4.016934352459822e-05,   8.143302843762237e-07,
  -1.375763314089627e-08,   2.169338570476488e-10,  -3.298509141818393e-12,   4.903992747087090e-14,  -7.180589188001131e-16,   1.039945413271024e-17,  -1.494081685840049e-19,
   2.134473983308765e-21,  -1.523252554073298e-05,   3.088023265634292e-07,  -5.217081454570518e-09,   8.226522031704653e-11,  -1.250871715315234e-12,   1.859739751198491e-14,
  -2.723145472200251e-16,   3.943945328482182e-18,  -5.666378548992536e-20,   8.095333749910448e-22,  -1.736713156880785e-06,   3.520766365911913e-08,  -5.948191054451358e-10,
   9.379385621484349e-12,  -1.426172043331697e-13,   2.120374274120610e-15,  -3.104792553507761e-17,   4.496703165756387e-19,  -6.460568350708048e-21,   9.230006271002550e-23,
  -1.637396888779592e-03,   3.148740346302081e-05,  -5.045834296749467e-07,   7.546524746481365e-09,  -1.088291321934307e-10,   1.534479099720047e-12,  -2.130704025791954e-14,
   2.925919279660135e-16,  -3.984191113193755e-18,   5.388338430638524e-20,  -1.513988717251724e-03,   2.911481250832674e-05,  -4.665755671552711e-07,   6.978326054428686e-09,
  -1.006394053518860e-10,   1.419076812897008e-12,  -1.970577302179817e-14,   2.706210065831136e-16,  -3.685288757267846e-18,   4.984501655741988e-20,  -1.285946757346594e-03,
   2.473023558162899e-05,  -3.963288785444124e-07,   5.928024867008038e-09,  -8.549828821718540e-11,   1.205678250902354e-12,  -1.674405847675173e-14,   2.299725808334106e-16,
  -3.132123804898242e-18,   4.236892441441458e-20,  -9.879732217707680e-04,   1.900050728746442e-05,  -3.045182469115923e-07,   4.555060841758271e-09,  -6.570131349504792e-11,
   9.265874872257706e-13,  -1.286945079784210e-14,   1.767769023161401e-16,  -2.407933223346088e-18,   3.257727803891951e-20,  -6.654268397737578e-04,   1.279770074945676e-05,
  -2.051144871358552e-07,   3.068301993186021e-09,  -4.425919629793912e-11,   6.242321031920187e-13,  -8.670707301292217e-15,   1.191130969130212e-16,  -1.622641369945153e-18,
   2.195540997014875e-20,  -3.674187684634926e-04,   7.066423745992434e-06,  -1.132591885130550e-07,   1.694288165919785e-09,  -2.444035133024409e-11,   3.447207676476437e-13,
  -4.788461297305284e-15,   6.578452710689097e-17,  -8.962150590241532e-19,   1.212716580738634e-20,  -1.393279693805151e-04,   2.679656735076785e-06,  -4.294933629753050e-08,
   6.425024963247844e-10,  -9.268309412251347e-12,   1.307275347279840e-13,  -1.815946940866854e-15,   2.494821545785024e-17,  -3.398893233953096e-19,   4.599336037442544e-21,
  -1.588526455934481e-05,   3.055172428734781e-07,  -4.896813941179120e-09,   7.325423145278083e-11,  -1.056718567924466e-12,   1.490482807382489e-14,  -2.070447897712506e-16,
   2.844474569150918e-18,  -3.875267410917525e-20,   5.243980182184604e-22,  -1.654106760379569e-04,   3.180873696609376e-06,  -5.097327777603694e-08,   7.623538329926782e-10,
  -1.099397735284151e-11,   1.550140948769756e-13,  -2.152465789332484e-15,   2.955895930860023e-17,  -4.025531617220424e-19,   5.446832661782501e-21,  -1.529439190647981e-04,
   2.941193337783647e-06,  -4.713370394222549e-08,   7.049541073471773e-10,  -1.016664676273755e-11,   1.433560805028776e-13,  -1.990703706635787e-15,   2.733936282697501e-17,
  -3.723530838338756e-19,   5.038627168170611e-21,  -1.299070029625399e-04,   2.498261120995522e-06,  -4.003734730344863e-08,   5.988521382988322e-10,  -8.637082996663552e-12,
   1.217984177783523e-13,  -1.691507432164571e-15,   2.323288174619699e-17,  -3.164629956293734e-19,   4.282921142340628e-21,  -9.980556311080886e-05,   1.919441021047520e-06,
  -3.076259004116853e-08,   4.601546024270379e-10,  -6.637181990639362e-12,   9.360448466961140e-14,  -1.300089417892609e-15,   1.785881715043947e-17,  -2.432926972943939e-19,
   3.293136513249182e-21,  -6.722176167248330e-05,   1.292830313527383e-06,  -2.072077106505853e-08,   3.099614545514926e-10,  -4.471087797615428e-12,   6.306034318726680e-14,
  -8.759266907309852e-16,   1.203335709954747e-17,  -1.639485833600769e-19,   2.219413932903548e-21,  -3.711683300308192e-05,   7.138537621645723e-07,  -1.144150151941958e-08,
   1.711578669781305e-10,  -2.468977429388356e-12,   3.482392195235033e-14,  -4.837369144301393e-16,   6.645858856452240e-18,  -9.055191609841338e-20,   1.225905868186402e-21,
  -1.407498314193768e-05,   2.707003019355617e-07,  -4.338764059321378e-09,   6.490593454871156e-11,  -9.362895993653685e-13,   1.320618281196297e-14,  -1.834494478023865e-16,
   2.520384894301503e-18,  -3.434179858551322e-20,   4.649361821194608e-22,  -1.604737597713578e-06,   3.086350904941754e-08,  -4.946786647878520e-10,   7.400180356219370e-12,
  -1.067502778179597e-13,   1.505695680767202e-15,  -2.091594835568912e-17,   2.873620687743912e-19,  -3.915499815536901e-21,   5.301018393085660e-23,  -1.518986000905278e-03,
   2.778553243501578e-05,  -4.235429407676629e-07,   6.025538331712528e-09,  -8.265715818369605e-11,   1.108625608525415e-12,  -1.464326858301639e-14,   1.912807040637934e-16,
  -2.477696004514084e-18,   3.187729131813785e-20,  -1.404500320997492e-03,   2.569179563840457e-05,  -3.916371787092737e-07,   5.571807653031075e-09,  -7.643593726373647e-11,
   1.025231552946032e-12,  -1.354247640205148e-14,   1.769120006421567e-16,  -2.291729182908805e-18,   2.948688362091447e-20,  -1.192947128706563e-03,   2.182259508794805e-05,
  -3.326698670299397e-07,   4.733128725314927e-09,  -6.493479588400414e-11,   8.710329187286290e-13,  -1.150663801194343e-14,   1.503316606525571e-16,  -1.947620289777700e-18,
   2.506240268261889e-20,  -9.165208002306252e-04,   1.676644062210035e-05,  -2.556034064368352e-07,   3.636851109344560e-09,  -4.989810583424123e-11,   6.693848298224081e-13,
  -8.843614622481292e-15,   1.155519338995841e-16,  -1.497206825655596e-18,   1.926887036914275e-20,  -6.173005083331889e-04,   1.129290545246253e-05,  -1.721655147738725e-07,
   2.449762396265705e-09,  -3.361287185012984e-11,   4.509462160783554e-13,  -5.958133307834762e-15,   7.785622714226515e-17,  -1.008876167464603e-18,   1.298543235417646e-20,
  -3.408451964432735e-04,   6.235514591147606e-06,  -9.506513372229361e-08,   1.352726437258714e-09,  -1.856115404586540e-11,   2.490232344592532e-13,  -3.290360867680781e-15,
   4.299790420952599e-17,  -5.572047844392008e-19,   7.172306350539484e-21,  -1.292510167256033e-04,   2.364565601188017e-06,  -3.604985474584546e-08,   5.129751564592773e-10,
  -7.038762956391591e-12,   9.443590682174401e-14,  -1.247807662414406e-15,   1.630643961209898e-17,  -2.113174429038830e-19,   2.720125203733765e-21,  -1.473635525697354e-05,
   2.695925331823453e-07,  -4.110177143621685e-09,   5.848628453347417e-11,  -8.025181629987864e-13,   1.076704844270206e-14,  -1.422683493176773e-16,   1.859178439015831e-18,
  -2.409343426691610e-20,   3.101371844096995e-22,  -1.534487472291645e-04,   2.806908780487825e-06,  -4.278652578160695e-08,   6.087029851849936e-10,  -8.350069012053678e-12,
   1.119939639738409e-13,  -1.479273230482276e-15,   1.932345585072091e-17,  -2.503086761072730e-19,   3.220805943385793e-21,  -1.418833449495797e-04,   2.595398412199187e-06,
  -3.956338928362633e-08,   5.628668783866180e-10,  -7.721598048200296e-12,   1.035694511344768e-13,  -1.368070447408043e-15,   1.787190929763693e-17,  -2.315214679865249e-19,
   2.979287236870379e-21,  -1.205121326342425e-04,   2.204529782133179e-06,  -3.360648112028047e-08,   4.781431012414072e-10,  -6.559746780098165e-12,   8.799222116277402e-14,
  -1.162408645693913e-15,   1.518672560693777e-17,  -1.967580049456183e-19,   2.532251196865011e-21,  -9.258740272856234e-05,   1.693754456921211e-06,  -2.582118762191456e-08,
   3.673965719459022e-10,  -5.040732549573104e-12,   6.762162128128489e-14,  -8.933881689206693e-16,   1.167322738065506e-17,  -1.512551169809195e-19,   1.946887943328555e-21,
  -6.236001491205657e-05,   1.140815118295914e-06,  -1.739224887878802e-08,   2.474762588415758e-10,  -3.395589761201590e-12,   4.555483326015003e-14,  -6.018948248968362e-16,
   7.865151803413336e-18,  -1.019216074966936e-19,   1.312023469824245e-21,  -3.443235708698466e-05,   6.299148917770980e-07,  -9.603528718096746e-09,   1.366531213176420e-10,
  -1.875057416307171e-12,   2.515646330708412e-14,  -3.323945757417639e-16,   4.343712364805098e-18,  -5.629156340266558e-20,   7.246767100598379e-22,  -1.305700420071048e-05,
   2.388696334520400e-07,  -3.641774873494156e-09,   5.182101447740326e-11,  -7.110594875362846e-13,   9.539966947811216e-15,  -1.260544105641693e-16,   1.647300855001048e-18,
  -2.134832705817297e-20,   2.748365407543013e-22,  -1.488674188938511e-06,   2.723437639045388e-08,  -4.152122096685666e-10,   5.908314582839805e-12,  -8.107080139826814e-14,
   1.087693121547132e-15,  -1.437204904545890e-17,   1.878169798070768e-19,  -2.434037214023065e-21,   3.133570258791546e-23  };
  int offset = -2;
  for (int i = 1; i <= n; ++i) {
    complex<double> t = ta[i-1];
    offset += 2;
    if (std::isnan(t.real())) {
      fill_n(rr+offset, 2, 0.5);
      fill_n(ww+offset, 2, 0.0);
    } else if (t.real() < -2) {
      throw runtime_error ("ERROR!  Invalid T value!  Real part is too small.  Consider regenerating interpolation files with a larger domain or reducing the magnetic field strength.");
    } else if (t.real() >= 42) {
      t = 1.0/sqrt(t);
      for (int r = 0; r != 2; ++r) {
        rr[offset+r] = ax[r]*t*t;
        ww[offset+r] = aw[r]*t;
      }
    } else if ( fabs(t.imag()) > 5.000000000000000e-01){
      throw runtime_error ("ERROR!  Invalid T value!  Magnitude of imaginary part is too large.  Consider regenerating interpolation files with a larger domain or reducing the magnetic field strength.");
    } else {
      const complex<double> torig = t;
      if (torig.imag() < 0) t = conj(torig);
      int itr = static_cast<int>((t.real()-(-2))*   0.500000000000000) ;
      int iti = static_cast<int>((t.imag()-(0))*   2.000000000000000) ;
      double tr = (t.real()-itr*2.000000000000000-   1.000000000000000 - -2) *   1.000000000000000;
      double ti = (t.imag()-iti*0.500000000000000-   0.250000000000000 - 0) *   4.000000000000000;
      const double tr2 = tr * 2.0;
      const double ti2 = ti * 2.0;
      if (itr < 11) {
        for (int j=1; j <=2; ++j) {
          vector<double> xrval(10);
          vector<double> xival(10);
          vector<double> wrval(10);
          vector<double> wival(10);
          for (int k=1; k<= 10; k++){
            const int boxof = iti*4840 + itr*280 + (j-1)*140 + (k-1)*14;
            double dr = xr[boxof+13];
            double di = xi[boxof+13];
            double er = wr[boxof+13];
            double ei = wi[boxof+13];
            double fr = tr2*dr + xr[boxof+12];
            double fi = tr2*di + xi[boxof+12];
            double gr = tr2*er + wr[boxof+12];
            double gi = tr2*ei + wi[boxof+12];
            dr = tr2*fr - dr + xr[boxof+11];
            di = tr2*fi - di + xi[boxof+11];
            er = tr2*gr - er + wr[boxof+11];
            ei = tr2*gi - ei + wi[boxof+11];
            fr = tr2*dr - fr + xr[boxof+10];
            fi = tr2*di - fi + xi[boxof+10];
            gr = tr2*er - gr + wr[boxof+10];
            gi = tr2*ei - gi + wi[boxof+10];
            dr = tr2*fr - dr + xr[boxof+9];
            di = tr2*fi - di + xi[boxof+9];
            er = tr2*gr - er + wr[boxof+9];
            ei = tr2*gi - ei + wi[boxof+9];
            fr = tr2*dr - fr + xr[boxof+8];
            fi = tr2*di - fi + xi[boxof+8];
            gr = tr2*er - gr + wr[boxof+8];
            gi = tr2*ei - gi + wi[boxof+8];
            dr = tr2*fr - dr + xr[boxof+7];
            di = tr2*fi - di + xi[boxof+7];
            er = tr2*gr - er + wr[boxof+7];
            ei = tr2*gi - ei + wi[boxof+7];
            fr = tr2*dr - fr + xr[boxof+6];
            fi = tr2*di - fi + xi[boxof+6];
            gr = tr2*er - gr + wr[boxof+6];
            gi = tr2*ei - gi + wi[boxof+6];
            dr = tr2*fr - dr + xr[boxof+5];
            di = tr2*fi - di + xi[boxof+5];
            er = tr2*gr - er + wr[boxof+5];
            ei = tr2*gi - ei + wi[boxof+5];
            fr = tr2*dr - fr + xr[boxof+4];
            fi = tr2*di - fi + xi[boxof+4];
            gr = tr2*er - gr + wr[boxof+4];
            gi = tr2*ei - gi + wi[boxof+4];
            dr = tr2*fr - dr + xr[boxof+3];
            di = tr2*fi - di + xi[boxof+3];
            er = tr2*gr - er + wr[boxof+3];
            ei = tr2*gi - ei + wi[boxof+3];
            fr = tr2*dr - fr + xr[boxof+2];
            fi = tr2*di - fi + xi[boxof+2];
            gr = tr2*er - gr + wr[boxof+2];
            gi = tr2*ei - gi + wi[boxof+2];
            dr = tr2*fr - dr + xr[boxof+1];
            di = tr2*fi - di + xi[boxof+1];
            er = tr2*gr - er + wr[boxof+1];
            ei = tr2*gi - ei + wi[boxof+1];
            xrval[k-1] = tr*dr - fr + xr[boxof+0]*0.5;
            xival[k-1] = tr*di - fi + xi[boxof+0]*0.5;
            wrval[k-1] = tr*er - gr + wr[boxof+0]*0.5;
            wival[k-1] = tr*ei - gi + wi[boxof+0]*0.5;
          }
          const double denom = 10;
          const double fac = 2 / denom;
          const double pi = 3.141592653589793238462;
          vector<double> tcxr(10);
          vector<double> tcxi(10);
          vector<double> tcwr(10);
          vector<double> tcwi(10);
          for (int b = 0; b != 10; ++b) {
            double sumxr = 0;
            double sumxi = 0;
            double sumwr = 0;
            double sumwi = 0;
            double fac2 = pi * b / 10;
            for (int k = 0; k !=10; ++k) {
              double fac3 = cos (fac2 * (k + 0.5) );
              sumxr += xrval[k] * fac3;
              sumxi += xival[k] * fac3;
              sumwr += wrval[k] * fac3;
              sumwi += wival[k] * fac3;
            }
            tcxr[b] = (sumxr * fac);
            tcxi[b] = (sumxi * fac);
            tcwr[b] = (sumwr * fac);
            tcwi[b] = (sumwi * fac);
          }
          double dr = tcxr[9];
          double di = tcxi[9];
          double er = tcwr[9];
          double ei = tcwi[9];
          double fr = ti2*dr + tcxr[8];
          double fi = ti2*di + tcxi[8];
          double gr = ti2*er + tcwr[8];
          double gi = ti2*ei + tcwi[8];
          dr = ti2*fr - dr + tcxr[7];
          di = ti2*fi - di + tcxi[7];
          er = ti2*gr - er + tcwr[7];
          ei = ti2*gi - ei + tcwi[7];
          fr = ti2*dr - fr + tcxr[6];
          fi = ti2*di - fi + tcxi[6];
          gr = ti2*er - gr + tcwr[6];
          gi = ti2*ei - gi + tcwi[6];
          dr = ti2*fr - dr + tcxr[5];
          di = ti2*fi - di + tcxi[5];
          er = ti2*gr - er + tcwr[5];
          ei = ti2*gi - ei + tcwi[5];
          fr = ti2*dr - fr + tcxr[4];
          fi = ti2*di - fi + tcxi[4];
          gr = ti2*er - gr + tcwr[4];
          gi = ti2*ei - gi + tcwi[4];
          dr = ti2*fr - dr + tcxr[3];
          di = ti2*fi - di + tcxi[3];
          er = ti2*gr - er + tcwr[3];
          ei = ti2*gi - ei + tcwi[3];
          fr = ti2*dr - fr + tcxr[2];
          fi = ti2*di - fi + tcxi[2];
          gr = ti2*er - gr + tcwr[2];
          gi = ti2*ei - gi + tcwi[2];
          dr = ti2*fr - dr + tcxr[1];
          di = ti2*fi - di + tcxi[1];
          er = ti2*gr - er + tcwr[1];
          ei = ti2*gi - ei + tcwi[1];
          rr[offset+j-1].real( ti*dr - fr + tcxr[0]*0.5 ) ;
          ww[offset+j-1].real( ti*er - gr + tcwr[0]*0.5 ) ;
          if (torig.imag() < 0) {
            rr[offset+j-1].imag(-1*( ti*di - fi + tcxi[0]*0.5 )) ;
            ww[offset+j-1].imag(-1*( ti*ei - gi + tcwi[0]*0.5 )) ;
          } else {
            rr[offset+j-1].imag( ti*di - fi + tcxi[0]*0.5 ) ;
            ww[offset+j-1].imag( ti*ei - gi + tcwi[0]*0.5 ) ;
          }
        }
      } else {
        for (int j=1; j <=2; ++j) {
          vector<double> xrval(8);
          vector<double> xival(8);
          vector<double> wrval(8);
          vector<double> wival(8);
          for (int k=1; k<= 8; k++){
            const int boxof = iti*4840 + itr*160 + 1320 + (j-1)*80 + (k-1)*10;
            double dr = xr[boxof+9];
            double di = xi[boxof+9];
            double er = wr[boxof+9];
            double ei = wi[boxof+9];
            double fr = tr2*dr + xr[boxof+8];
            double fi = tr2*di + xi[boxof+8];
            double gr = tr2*er + wr[boxof+8];
            double gi = tr2*ei + wi[boxof+8];
            dr = tr2*fr - dr + xr[boxof+7];
            di = tr2*fi - di + xi[boxof+7];
            er = tr2*gr - er + wr[boxof+7];
            ei = tr2*gi - ei + wi[boxof+7];
            fr = tr2*dr - fr + xr[boxof+6];
            fi = tr2*di - fi + xi[boxof+6];
            gr = tr2*er - gr + wr[boxof+6];
            gi = tr2*ei - gi + wi[boxof+6];
            dr = tr2*fr - dr + xr[boxof+5];
            di = tr2*fi - di + xi[boxof+5];
            er = tr2*gr - er + wr[boxof+5];
            ei = tr2*gi - ei + wi[boxof+5];
            fr = tr2*dr - fr + xr[boxof+4];
            fi = tr2*di - fi + xi[boxof+4];
            gr = tr2*er - gr + wr[boxof+4];
            gi = tr2*ei - gi + wi[boxof+4];
            dr = tr2*fr - dr + xr[boxof+3];
            di = tr2*fi - di + xi[boxof+3];
            er = tr2*gr - er + wr[boxof+3];
            ei = tr2*gi - ei + wi[boxof+3];
            fr = tr2*dr - fr + xr[boxof+2];
            fi = tr2*di - fi + xi[boxof+2];
            gr = tr2*er - gr + wr[boxof+2];
            gi = tr2*ei - gi + wi[boxof+2];
            dr = tr2*fr - dr + xr[boxof+1];
            di = tr2*fi - di + xi[boxof+1];
            er = tr2*gr - er + wr[boxof+1];
            ei = tr2*gi - ei + wi[boxof+1];
            xrval[k-1] = tr*dr - fr + xr[boxof+0]*0.5;
            xival[k-1] = tr*di - fi + xi[boxof+0]*0.5;
            wrval[k-1] = tr*er - gr + wr[boxof+0]*0.5;
            wival[k-1] = tr*ei - gi + wi[boxof+0]*0.5;
          }
          const double denom = 8;
          const double fac = 2 / denom;
          const double pi = 3.141592653589793238462;
          vector<double> tcxr(8);
          vector<double> tcxi(8);
          vector<double> tcwr(8);
          vector<double> tcwi(8);
          for (int b = 0; b != 8; ++b) {
            double sumxr = 0;
            double sumxi = 0;
            double sumwr = 0;
            double sumwi = 0;
            double fac2 = pi * b / 8;
            for (int k = 0; k !=8; ++k) {
              double fac3 = cos (fac2 * (k + 0.5) );
              sumxr += xrval[k] * fac3;
              sumxi += xival[k] * fac3;
              sumwr += wrval[k] * fac3;
              sumwi += wival[k] * fac3;
            }
            tcxr[b] = (sumxr * fac);
            tcxi[b] = (sumxi * fac);
            tcwr[b] = (sumwr * fac);
            tcwi[b] = (sumwi * fac);
          }
          double dr = tcxr[7];
          double di = tcxi[7];
          double er = tcwr[7];
          double ei = tcwi[7];
          double fr = ti2*dr + tcxr[6];
          double fi = ti2*di + tcxi[6];
          double gr = ti2*er + tcwr[6];
          double gi = ti2*ei + tcwi[6];
          dr = ti2*fr - dr + tcxr[5];
          di = ti2*fi - di + tcxi[5];
          er = ti2*gr - er + tcwr[5];
          ei = ti2*gi - ei + tcwi[5];
          fr = ti2*dr - fr + tcxr[4];
          fi = ti2*di - fi + tcxi[4];
          gr = ti2*er - gr + tcwr[4];
          gi = ti2*ei - gi + tcwi[4];
          dr = ti2*fr - dr + tcxr[3];
          di = ti2*fi - di + tcxi[3];
          er = ti2*gr - er + tcwr[3];
          ei = ti2*gi - ei + tcwi[3];
          fr = ti2*dr - fr + tcxr[2];
          fi = ti2*di - fi + tcxi[2];
          gr = ti2*er - gr + tcwr[2];
          gi = ti2*ei - gi + tcwi[2];
          dr = ti2*fr - dr + tcxr[1];
          di = ti2*fi - di + tcxi[1];
          er = ti2*gr - er + tcwr[1];
          ei = ti2*gi - ei + tcwi[1];
          rr[offset+j-1].real( ti*dr - fr + tcxr[0]*0.5 ) ;
          ww[offset+j-1].real( ti*er - gr + tcwr[0]*0.5 ) ;
          if (torig.imag() < 0) {
            rr[offset+j-1].imag(-1*( ti*di - fi + tcxi[0]*0.5 )) ;
            ww[offset+j-1].imag(-1*( ti*ei - gi + tcwi[0]*0.5 )) ;
          } else {
            rr[offset+j-1].imag( ti*di - fi + tcxi[0]*0.5 ) ;
            ww[offset+j-1].imag( ti*ei - gi + tcwi[0]*0.5 ) ;
          }
        }
      }
    }
  }
}