Summary: 	A Universal Instant Messaging Client 
Name: 		ayttm
Version: 	0.5.0
Release:	89
Group: 		Applications/Internet
License: 	GPL
URL: 		http://ayttm.sourceforge.net
Source: 	%{name}-%{version}.tar.bz2
Buildroot: 	%{_tmppath}/%{name}-%{version}-%{release}-root
Requires:	gdb

# If you want stripped RPM with no crash dialog use
# --define "nodebug 1" in rpmbuild commandline
%if "%{nodebug}" != "1"
%define nodebug 0
%endif

%description
Ayttm is designed to become a Universal Instant Messaging client, seamlessly
integrating all existing Instant Messaging clients and providing a single
consistant user interface. Currently, Ayttm supports sending and receiving
messages through AOL, ICQ, Yahoo, MSN, IRC and Jabber.

%if "%{nodebug}" == "0"
%define optflags -g
%define __spec_install_post %{_libdir}/rpm/brp-compress 
%endif

%define debug_package %{nil}

%prep
%setup 

%build
%if "%{nodebug}" == "0"
%configure --enable-smtp --enable-jasper-filter --sysconfdir=/etc
%else
%configure --disable-crash-dialog --enable-smtp --enable-jasper-filter --sysconfdir=/etc
%endif
make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
# Install documentation.
%doc COPYING AUTHORS README ChangeLog
# Install man page.
%{_mandir}/man*/*
# Icons and sounds
%{_datadir}/pixmaps/*.png
%{_datadir}/ayttm/sounds/*
%{_datadir}/ayttm/smileys/*
# Red Hat menu (doesn't do any damage on other distros)
%{_datadir}/gnome/apps/Internet/ayttm.desktop
%{_datadir}/applnk/Internet/ayttm.desktop
# Install the modules
%{_libdir}/ayttm/*.la  
%{_libdir}/ayttm/*.so 
# Install translations
%{_datadir}/locale/*/LC_MESSAGES/ayttm.mo
# the config file
%config(noreplace) /etc/ayttmrc
# Lastly, the binary itself
%{_bindir}/ayttm_streamer_wrapper.sh
%{_bindir}/ayttm
%exclude %{_libdir}/ayttm/*.a


%changelog
* Wed May 20 2009 08:50 UTC [siddheshp]   0.5.0-89
- configure.ac, Makefile.am, ChangeLog:
 * Removed mingw32

* Mon May 18 2009 14:45 UTC [siddheshp]   0.5.0-89
 * Added Categories into the .desktop. Closes #522497 in bugs.debian.org.
Thanks Andrei Popescu
 * Disabled -DGTK_DISABLE_DEPRECATED. We needed it only for the gtk2 port and
 now it is only getting in the way, caused #527696 in bugs.debian.org. Fixed.

* Thu May 14 2009 15:40 UTC [siddheshp]   0.5.0-88
 * Fixed some warnings

* Sun Apr 19 2009 02:30 UTC [siddheshp]   0.5.0-87
- modules/aim-oscar/libfaim/CHANGES, modules/aim-oscar/libfaim/src/chatnav.c,
modules/aim-oscar/libfaim/src/im.c, ChangeLog, configure.ac:
 * Fixed spelling errors reported by Kartik Mistry.

* Sun Mar 15 2009 09:05 UTC [siddheshp]   0.5.0-86
- ChangeLog, configure.ac, src/chat_room.c, modules/irc/libirc/.cvsignore:
 * Pressing the invite button in chat room without selecting an account causes
 a crash
 * Added a .cvsignore to libirc

* Sun Mar 08 2009 18:40 UTC [siddheshp]   0.5.0-85
- ChangeLog, configure.ac, libproxy/libproxy.h, libproxy/proxy.c,
modules/aim-oscar/aim-oscar.c, modules/irc/irc.c,
modules/jabber/libjabber/jconn.c, modules/msn2/msn.C, /modules/yahoo2/yahoo.c,
src/main.c, src/prefs.c, src/util.c:
 * Re-wrote network connectivity code.
 * Replaced deprecated gethostbyname with getaddrinfo
 * Multi-threading to avoid hang-ups during proxy connections or hostname
 look-ups
 * Removed datagram connection support from SOCKS5 since it was not used and
 was only getting in the way
 * Removed unused code

* Thu Feb 23 2009 08:35 UTC [siddheshp]   0.5.0-84
- ChangeLog, configure.ac, libproxy/proxy.c:
 * Removed ap_base64encode() in favour of g_base64_encode()

* Thu Feb 19 2009 16:45 UTC [siddheshp]   0.5.0-83
- ChangeLog, po/*.po, src/Makefile.am:
 * Updated po files due to string changes
 * Removed ./gen warning. Looks like AC_INIT defines a localedir as well.

* Fri Feb 13 2009 14:30 UTC [siddheshp]   0.5.0-83
- ChangeLog, configure.ac, src/chat_room.c, src/chat_window.c,
src/edit_local_accounts.c:
 * Replaced deprecated gtk_tool_item_set_tooltip with
 gtk_tool_item_set_tooltip_text.
 * Bumped GTK required version to 2.12.0 since the above function needs it

* Wed Nov 19 2008 18:35 UTC [siddheshp]   0.5.0-82
- ChangeLog, libproxy/proxy.c:
 * Code formatting only.

* Mon Nov 10 2008 19:00 UTC [siddheshp]   0.5.0-82
- ChangeLog, ayttm.spec.in, modules/irc/Makefile.am,
modules/irc/libirc/Makefile.am, modules/yahoo2/libyahoo2/Makefile.am,
pixmaps/Makefile.am, configure.ac, ChangeLog-0.5.0-45:
 * Header files and images went missing from the built tarballs
 * Fixed rpm build errors
 * Moved old entries to ChangeLog-0.5.0-45

* Sun Sep 28 2008 15:40 UTC [siddheshp]   0.5.0-81
- ChangeLog, modules/msn2/libmsn2/msn_bittybits.C,
modules/msn2/libmsn2/msn_bittybits.h:
 Code formatting. No functional changes.

* Sat Sep 20 2008 19:55 UTC [siddheshp]   0.5.0-81
- ChangeLog, configure.ac, src/chat_room.c:
 Need to be more careful with my commits -- autocomplete for nicknames is
 finally fixed.

* Sat Sep 20 2008 19:00 UTC [siddheshp]   0.5.0-80
- ChangeLog, configure.ac, src/chat_room.c:
 * Previous commit b0rked autocomplete for buddy nicknames
 * Trying to delete from list even when a valid entry was not found in the chat
 room

* Sat Sep 20 2008 14:25 UTC [siddheshp]   0.5.0-79
- ChangeLog, configure.ac,  modules/irc/irc.c, src/auto_complete.c, 
src/chat_room.c, src/chat_room.h, src/chat_window.c, 
src/gtk/html_text_buffer.c:
 * Sort Chat room buddy list alphabetically
 * Replaced strlen() with g_utf8_strlen() in autocomplete to cater for UTF-8
 characters. We might need to look at this in other modules as well.
 * Removed calls to strlen("literal") with the just actual length of the
 literal
 * Put autocomplete changes in chat_window.c in chat_room.c as well
 * Linkify 3rd person messages as well
 * Made chat window entry to be the same as chat room entry

* Wed Sep 17 2008 19:38 UTC [siddheshp]   0.5.0-78
- ChangeLog, configure.ac, src/status.c:
 Sort contacts and groups alphabetically

* Sun Aug 31 2008 08:20 UTC [siddheshp]   0.5.0-77
- ChangeLog, configure.ac, modules/yahoo2/yahoo.c:
 No need to convert to/from UTF8; GTK2 does UTF8 by default.

* Sun Aug 31 2008 07:40 UTC [siddheshp]   0.5.0-76
- modules/yahoo2/yahoo.c, modules/yahoo2/libyahoo2/libyahoo2.c,
modules/yahoo2/libyahoo2/yahoo2_callbacks.h,
modules/yahoo2/libyahoo2/yahoo2_types.h, src/file_select.c: ChangeLog,
configure.ac:
 * Merged changes made by Gennady Feldman in libyahoo2 upstream -- mostly 
 fixes and code cleanup
 * We don't really need to bump protocol version to 0xe; 0xc is quite alright
 * Set the full filename correctly for incoming files during file transfer

* Sun Aug 24 2008 18:55 UTC [siddheshp]   0.5.0-75
- ChangeLog, configure.ac, modules/yahoo2/yahoo.c,
modules/yahoo2/libyahoo2/libyahoo2.c,
modules/yahoo2/libyahoo2/yahoo_httplib.c, src/chat_room.c, src/chat_window.c,
src/plugin_api.h:
 * Fixed Yahoo file transfer.
 * Put a slight padding in text entry and chat box so that words don't stick to
 the borders.

* Tue Aug 19 2008 14:35 UTC [siddheshp]   0.5.0-74
- ChangeLog, configure.ac, modules/aim-oscar/aim-oscar.c:
 Attached to default smileys callback in aim-oscar.

* Tue Aug 19 2008 08:05 UTC [siddheshp]   0.5.0-73
- ChangeLog, configure.ac, src/chat_room.c, src/chat_window.c,
src/gtk/html_text_buffer.c:
 Fixed wrap behaviour for long words in the entry box and chat window.

* Mon Aug 11 2008 04:45 UTC [siddheshp]   0.5.0-72
- ChangeLog, configure.ac, modules/aim-oscar/aim-oscar.c,
modules/aim-oscar/libfaim/src/admin.c, modules/aim-oscar/libfaim/src/auth.c,
modules/aim-oscar/libfaim/src/bart.c, modules/aim-oscar/libfaim/src/bos.c,
modules/aim-oscar/libfaim/src/bstream.c, modules/aim-oscar/libfaim/src/ssi.c,
modules/aycryption/aycryption.c, modules/irc/libirc/irc_message.c,
modules/irc/libirc/libirc.h, modules/jabber/jabber.c,
modules/jabber/libxode/snprintf.c, modules/smileys/smiley-themer.c,
modules/utility/custom_message.c, modules/yahoo2/libyahoo2/libyahoo2.c,
pixmaps/admin_icon.xpm, pixmaps/aim_away.xpm, pixmaps/aim_online.xpm,
pixmaps/angry.xpm, pixmaps/aol_icon.xpm, pixmaps/away_icon.xpm,
pixmaps/ayttm.xpm, pixmaps/ayttm_32x32.xpm, pixmaps/ayttmlogo.xpm,
pixmaps/beer.xpm, pixmaps/biglaugh.xpm, pixmaps/blank_icon.xpm,
pixmaps/blankface.xpm, pixmaps/blush.xpm, pixmaps/checkbox_off.xpm,
pixmaps/checkbox_on.xpm, pixmaps/confused.xpm, pixmaps/cooldude.xpm,
pixmaps/cry.xpm, pixmaps/dt_icon.xpm, pixmaps/dude.xpm, pixmaps/free_icon.xpm,
pixmaps/grin.xpm, pixmaps/help.xpm, pixmaps/heyyy.xpm, pixmaps/icq_away.xpm,
pixmaps/icq_online.xpm, pixmaps/ignore.xpm, pixmaps/info.xpm,
pixmaps/jabber_away.xpm, pixmaps/jabber_online.xpm, pixmaps/laugh.xpm,
pixmaps/log.xpm, pixmaps/login_icon.xpm, pixmaps/logoff_icon.xpm,
pixmaps/lovey.xpm, pixmaps/no_such_smiley.xpm, pixmaps/nomodule_away.xpm,
pixmaps/nomodule_online.xpm, pixmaps/note.xpm, pixmaps/oh.xpm,
pixmaps/penguin_talk.xpm, pixmaps/print.xpm, pixmaps/question.xpm,
pixmaps/reconnect.xpm, pixmaps/sad.xpm, pixmaps/smile.xpm,
pixmaps/smiley_button.xpm, pixmaps/tb_book_open.xpm, pixmaps/tb_book_red.xpm,
pixmaps/tb_mail_send.xpm, pixmaps/tb_open.xpm, pixmaps/tb_search.xpm,
pixmaps/tb_trash.xpm, pixmaps/tb_volume.xpm, pixmaps/tongue.xpm,
pixmaps/warning.xpm, pixmaps/wine.xpm, pixmaps/wink.xpm,
pixmaps/workwizu_away.xpm, pixmaps/workwizu_online.xpm, pixmaps/worried.xpm,
pixmaps/msn/angel.xpm, pixmaps/msn/bat.xpm, pixmaps/msn/boy.xpm,
pixmaps/msn/brheart.xpm, pixmaps/msn/bulb.xpm, pixmaps/msn/cake.xpm,
pixmaps/msn/cat.xpm, pixmaps/msn/clock.xpm, pixmaps/msn/coffee.xpm,
pixmaps/msn/deadflower.xpm, pixmaps/msn/devil.xpm, pixmaps/msn/dog.xpm,
pixmaps/msn/email.xpm, pixmaps/msn/film.xpm, pixmaps/msn/flower.xpm,
pixmaps/msn/gift.xpm, pixmaps/msn/girl.xpm, pixmaps/msn/handcuffs.xpm,
pixmaps/msn/heart.xpm, pixmaps/msn/kiss.xpm, pixmaps/msn/moon.xpm,
pixmaps/msn/neutral.xpm, pixmaps/msn/phone.xpm, pixmaps/msn/photo.xpm,
pixmaps/msn/question.xpm, pixmaps/msn/rainbow.xpm, pixmaps/msn/run.xpm,
pixmaps/msn/runback.xpm, pixmaps/msn/star.xpm, pixmaps/msn/sun.xpm,
pixmaps/msn/thumbdown.xpm, pixmaps/msn/thumbup.xpm, po/de.po, po/en_GB.po,
po/es.po, po/fr.po, po/hi.po, po/nl.po, po/pt_BR.po, po/sv.po,
src/chat_room.c, src/nomodule.c, src/plugin.c, src/smileys.c, src/smileys.h,
src/gtk/html_text_buffer.c:
 Cleaned up some warnings... shouldn't break anything...

* Sun Aug 10 2008 20:20 UTC [siddheshp]   0.5.0-71
- ChangeLog, modules/irc/irc.c, modules/irc/libirc/libirc.h,
src/auto_complete.c, src/chat_room.c, src/chat_room.h, src/chat_window.c,
configure.ac:
 * Fix Invite goof-up in IRC -- channel name and invitee got interchanged
 * Defer focus on notebook tab to chat room message entry box.

* Sun Aug 10 2008 15:10 UTC [siddheshp]   0.5.0-70
- ChangeLog, src/auto_complete.c, src/auto_complete.h:
 Forgot to add the auto_complete sources..

* Sun Aug 10 2008 15:05 UTC [siddheshp]   0.5.0-70
- src/Makefile.am, src/chat_room.c, src/chat_window.c, src/prefs.c,
src/prefs.h, src/util.c, src/gtk/prefs_window.C, ChangeLog, configure.ac:
 * Added option to disable smileys in Preferences
 * Separated auto complete into a separate source file
 * Don't send the auto-completed version of a word on enter.

* Sun Aug 10 2008 09:00 UTC [siddheshp]   0.5.0-69
- ChangeLog, configure.ac, src/chat_room.c, src/chat_window.c:
 * Set focus on message entry widget when chaging tabs with mouseclick.
 * Removed frames from chat windows. Now scroll windows have the ability to
 draw pretty borders

* Wed Aug 06 2008 03:46 UTC [siddheshp]   0.5.0-68
- ChangeLog, configure.ac, src/browser.c, modules/Makefile.am:
 * Removed workwizu from SUBDIRS
 * Fixed double free() when using an alternate browser. George is on a roll :)

* Sun Aug 03 2008 20:25 UTC [siddheshp]   0.5.0-67
- ChangeLog, configure.ac, modules/aim-oscar/aim-oscar.c:
 Changed the Service Name from AIM/ICQ to AIM-ICQ. The / seems to confuse the
 parser.

* Sun Aug 03 2008 16:00 UTC [siddheshp]   0.5.0-66
- ChangeLog, configure.ac, pixmaps/smileys.png, pixmaps/smileys.xcf,
src/ayttm_tray.c, modules/aim-oscar/aim-oscar.c:
 * Disabled aim-toc and icq-toc modules by default and enabled aim-oscar.
 * Made smiley's eyes a little bigger 8)
 * Updated protocol display name in aim-oscar to AIM/ICQ instead of AIM-oscar.

* Sat Aug 02 2008 21:00 UTC [siddheshp]   0.5.0-65
- ChangeLog, configure.ac, src/main.c, src/icons.c, src/icons.h,
src/Makefile.am, pixmaps/Makefile.am, pixmaps/buddy.png, pixmaps/buddy.xcf,
pixmaps/away.png, pixmaps/away.xcf, pixmaps/group.png, pixmaps/group.xcf,
pixmaps/group-chat.png, pixmaps/group-chat.xcf, pixmaps/smileys.png,
pixmaps/smileys.xcf, src/status.c:
 Little icons for our menus. Also added a GtkIconFactory for ayttm so that we can
 put even more pwetty icons...

* Fri Aug 01 2008 22:05 UTC [siddheshp]   0.5.0-64
- ChangeLog, configure.ac, modules/irc/irc.c:
 * A buddy leaving a chatroom doesn't mean that he has logged off.
 * Store server-truncated nickname only for exchanges with the server, not for
 our records

* Thu Jul 31 2008 20:17 UTC [siddheshp]   0.5.0-63
- ChangeLog, configure.ac, src/edit_local_accounts.c:
 NULL check on service type to prevent crash on account creation. NOW #2021862
 is closed.

* Sun Jul 27 2008 16:10 UTC [siddheshp]   0.5.0-62
- ChangeLog, src/gtk/html_text_buffer.c, configure.ac:
 Fixed scrolling behaviour when long text is received.

* Sat Jul 26 2008 08:40 UTC [siddheshp]   0.5.0-61
- ChangeLog, configure.ac, src/gtk/html_text_buffer.c:
 Finally, the chat window won't scroll back on new messages if you've scrolled
 up to see the previous messages.

* Sat Jul 26 2008 06:25 UTC [siddheshp]   0.5.0-60
- ChangeLog, configure.ac,  modules/irc/irc.c,  modules/irc/libirc/libirc.h:
 * Recognize nickname that the server recognizes you as -- servers may truncate
 your nickname to a maxlen. Freenode limits nickname length to 16 characters
 * */me hits /me on the head* My nickname can be lower case as well as uppercase.
 * Comparing nickname to a blank string in PART. Should be assigned to the
 notices window.

* Sun Jul 20 2008 18:55 UTC [siddheshp]   0.5.0-59
- ChangeLog, configure.ac, modules/irc/irc.c, /src/prefs.c:
 * Buddy Management changes: Set buddy status if he/she appears in any chatroom
 or even messages us.
 * Allow offline personal messaging so that we may 'discover' if our buddy is
 online by simply messaging him/her.
 * Fixed crash when a user adds an invalid account when the protocol module is
 unloaded and then tries to load the protocol module and subsequently tries to
 connect... Phew! In short, it closes #2021862 on SF.Net.

* Mon Jul 14 2008 20:35 UTC [siddheshp]   0.5.0-58
- ChangeLog, configure.ac, modules/irc/irc.c,
modules/irc/libirc/irc_message.c:
 * Allow /j command as a shortcut to /join
 * Fixed behaviour after nickname change. Change own nickname in our local
 account so that we can receive messages sent to our new nickname. Thanks
 to 'loot' of puppy linux for reporting this.

* Sat Jul 12 2008 18:55 UTC [siddheshp]   0.5.0-57
- ChangeLog, configure.ac, src/util.c, src/gtk/html_text_buffer.c:
 * Allow mixed case URLs. This is important for URLs that contain
 case-sensitive GET data.
 * Replaced the standard strcmp with glib string compare functions.

* Sat Jul 12 2008 05:55 UTC [siddheshp]   0.5.0-56
- ChangeLog, configure.ac, modules/msn2/libmsn2/msn_core:
 Fixed crash when user cancels msn connect request just as the server
 certificate is being authenticated.

* Tue Jul 08 2008 19:00 UTC [siddheshp]   0.5.0-55
- ChangeLog, configure.ac, modules/irc/irc.c, modules/irc/irc.h:
 * Show the MOTD that comes on login in the notices window
 * Somebody better change the topic on #ayttm because ayttm now recognizes
 topics :)

* Sun Jul 06 2008 19:09 UTC [siddheshp]   0.5.0-54
- ChangeLog, configure.ac, modules/irc/irc.c, src/info_window.c:
 * Info window crash fix. A bug left behind in the gtk2 port where we missed
 porting a GtkEditable reference to GtkTextView/Buffer.
 * UTF-8 validation in the info_window. TDOD, we need to add this before all
 text appends.

* Sun Jul 06 2008 13:25 UTC [siddheshp]   0.5.0-53
- ChangeLog, configure.ac, modules/irc/irc.c, modules/irc/Attic/irc.h,
modules/irc/libirc/Attic/irc_message.c, modules/irc/libirc/Attic/libirc.h:
 * Fixed buddy management for IRC
 * PRIVMSGs with individual members with /msg command
 * Fixed /whois crash
 * Added handlers for some errors

* Thu Jun 19 2008 02:15 UTC [siddheshp]   0.5.0-52
- ChangeLog, configure.ac, src/offline_queue_mgmt.c:
 Trying to fclose a potentially NULL file pointer.

* Wed Jun 18 2008 20:10 UTC [siddheshp]   0.5.0-51
- ChangeLog, configure.ac, src/offline_queue_mgmt.c:
 We don't need to return from contact_mgmt_flush if contact_actions_queue
 does not exist. We can proceed with creating a blank contact_actions_queue and
 also auto-starting chatrooms.

* Tue Jun 17 2008 19:45 UTC [siddheshp]   0.5.0-50
- ChangeLog, configure.ac, modules/irc/irc.c, modules/irc/irc.h,
modules/irc/libirc/irc_message.c, modules/irc/libirc/libirc.h,
src/chat_room.c, src/service.h:
 * Changed the public chatroom list download interface in service.h
 * Implemented channel list download.
 * irc_warning to show error messages and not log off. irc_error causes a
 logoff
 * Reject malformed messages sent by server. 
 * ChangeLog seemed to think it was Sunday for the past three days ;)

* Mon Jun 16 2008 15:20 UTC [siddheshp]   0.5.0-49
- ChangeLog, configure.ac, modules/irc/irc.c:
 Ensure that ay_irc_make_chatroom_window returns a chatroom window.

* Sat Jun 14 2008 10:55 UTC [siddheshp]   0.5.0-48
- ChangeLog, configure.ac, modules/aim-oscar/aim-oscar.c,
modules/aim-toc/aim-toc.c, modules/icq/icq.c, modules/icq-toc/icq-toc.c,
modules/irc/irc.c, modules/irc/irc.h, modules/irc/libirc/irc_message.c,
modules/irc/libirc/libirc.c, modules/irc/libirc/Attic/libirc.h,
modules/jabber/jabber.c, modules/msn2/msn.C, modules/workwizu/workwizu.c,
modules/yahoo2/yahoo.c, po/de.po, po/en_GB.po, po/es.po, po/fr.po, po/hi.po,
po/nl.po, po/pt_BR.po, po/sv.po, src/chat_room.c, src/chat_room.h:
 * buffer overrun protection - replace strcat, strcpy, etc with strncat,
 strncpy, etc respectively
 * Allow creation of a chatroom window without joining a room
 * Allow /commands like /me, /join, /part, /leave, /quit, /nick

* Sat Jun 14 2008 05:24 UTC [siddheshp]   0.5.0-47
- ChangeLog, configure.ac, modules/irc/irc.c, modules/irc/libirc/libirc.c,
src/status.c:
 * Die if libltdl is not found during ./configure
 * Don't supply blank passwords during login
 * Reduce contact_mgmt_flush timeout by 4 seconds. 5 seconds seems too long at
 times
 * Chat room autoconnect is working now. We were not setting the
 ela->connecting and ela->connected flags during our login sequence. 

* Sun Jun 08 2008 21:30 UTC [siddheshp]   0.5.0-46
- ChangeLog, configure.ac, modules/yahoo2/yahoo.c,
modules/irc/libirc/libirc.h, modules/irc/libirc/libirc.c,
modules/irc/libirc/irc_replies.h, modules/irc/libirc/irc_message.c,
modules/irc/libirc/ctcp.h, modules/irc/libirc/ctcp.c, modules/irc/irc.c:
 * Fixed memory leak in CTCP decode.
 * Yahoo stubs for yahoologout and yahooerror from HEAD
 * Added server-to-server ERROR message into IRC command list. Freenode was
 sending me that on some connect timeouts -- it's not supposed to, but doesn't
 hurt to handle it.
 * Freeing some more memory (param list, CTCP extended data list)
 * Added some error reply handlers
 * Replaced NOTICE popups with a chat room window.


