/*==============================================================*/
/* Database name:  axyl                                         */
/* DBMS name:      PostgreSQL 7                                 */
/* Created on:     22/03/2008 11:34:49 a.m.                     */
/*==============================================================*/


CREATE SEQUENCE seq_block_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_blocklet_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_cat_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_category_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_contactinfo_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_element_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_enc_scheme_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_forum_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_group_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_lang_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_layout_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_location_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_menu_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_menuoption_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_microsite_page_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_microsite_template_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_msg_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_org_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_page_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_plugin_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_query_resource_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

CREATE SEQUENCE seq_story_id
increment 1
minvalue 1
maxvalue 2147483647
start 1
cache 1;

/*==============================================================*/
/* Table: ax_block                                              */
/*==============================================================*/
CREATE TABLE ax_block (
block_id             INT4                 not null,
layout_id            INT4                 not null,
background_img       INT4                 null,
lang_id              INT4                 not null DEFAULT 0,
block_desc           TEXT                 null,
block_style          TEXT                 null,
block_type           TEXT                 null,
cols                 INT4                 not null DEFAULT 1,
gutter_width         INT4                 not null DEFAULT 0,
gutter_colour        TEXT                 null,
blocklet_sep         INT4                 not null DEFAULT 0,
border_width         INT4                 not null DEFAULT 0,
border_colour        TEXT                 null,
background_colour    TEXT                 null,
justify              TEXT                 not null DEFAULT '' 
      CONSTRAINT CKC_JUSTIFY_AX_BLOCK CHECK (justify in ('','left','center','right')),
valign               TEXT                 not null DEFAULT '' 
      CONSTRAINT CKC_VALIGN_AX_BLOCK CHECK (valign in ('','top','middle','bottom')),
exportable           BOOL                 not null DEFAULT false,
cache                TEXT                 null,
cache_updated        TIMESTAMP WITH TIME ZONE null,
last_modified        TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
CONSTRAINT ax_block_pkey PRIMARY KEY (block_id)
);

COMMENT ON COLUMN ax_block.lang_id is
'A unique text code for this language';

/*==============================================================*/
/* Index: ax_block_layout_FK                                    */
/*==============================================================*/
CREATE INDEX ax_block_layout_FK ON ax_block (
layout_id
);

/*==============================================================*/
/* Table: ax_block_blocklet                                     */
/*==============================================================*/
CREATE TABLE ax_block_blocklet (
blocklet_id          INT4                 not null,
block_id             INT4                 not null,
display_order        INT4                 not null DEFAULT 0,
visible              BOOL                 not null DEFAULT true,
CONSTRAINT ax_block_blocklet_pkey PRIMARY KEY (blocklet_id, block_id)
);

/*==============================================================*/
/* Index: ax_block_blocklet_FK                                  */
/*==============================================================*/
CREATE INDEX ax_block_blocklet_FK ON ax_block_blocklet (
blocklet_id
);

/*==============================================================*/
/* Index: ax_block_blocklet_FK2                                 */
/*==============================================================*/
CREATE INDEX ax_block_blocklet_FK2 ON ax_block_blocklet (
block_id
);

/*==============================================================*/
/* Table: ax_blocklet                                           */
/*==============================================================*/
CREATE TABLE ax_blocklet (
blocklet_id          INT4                 not null,
blocklet_desc        TEXT                 null,
blocklet_type        TEXT                 not null DEFAULT 'text' 
      CONSTRAINT CKC_BLOCKLET_TYPE_AX_BLOCKLET CHECK (blocklet_type in ('text','list','ordered','bullets','table','raw')),
blocklet_width       INT4                 not null DEFAULT 100 
      CONSTRAINT CKC_BLOCKLET_WIDTH_AX_BLOCKLET CHECK (blocklet_width between 0 and 100),
blocklet_style       TEXT                 null,
justify              TEXT                 not null DEFAULT '' 
      CONSTRAINT CKC_JUSTIFY_AX_BLOCKLET CHECK (justify in ('','left','center','right')),
heading              TEXT                 null,
heading_level        INT4                 not null DEFAULT 3,
heading_colour       TEXT                 null,
ruler                TEXT                 not null DEFAULT 'none' 
      CONSTRAINT CKC_RULER_AX_BLOCKLET CHECK (ruler in ('none','top','bottom')),
ruler_width          INT4                 not null DEFAULT 100 
      CONSTRAINT CKC_RULER_WIDTH_AX_BLOCKLET CHECK (ruler_width between 0 and 100),
ruler_size           INT4                 not null DEFAULT 1,
ruler_colour         TEXT                 null,
content              TEXT                 null,
content_size         FLOAT4               not null DEFAULT '1.0',
content_colour       TEXT                 null,
table_style          TEXT                 null,
table_autojustify    BOOL                 not null DEFAULT false,
table_rowstripes     BOOL                 not null DEFAULT false,
CONSTRAINT ax_blocklet_pkey PRIMARY KEY (blocklet_id)
);

/*==============================================================*/
/* Table: ax_catalog                                            */
/*==============================================================*/
CREATE TABLE ax_catalog (
cat_id               INT4                 not null,
cat_name             TEXT                 not null,
cat_desc             TEXT                 null,
mime_type            TEXT                 not null,
mime_category        TEXT                 not null,
upload_timestamp     TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
category             TEXT                 null,
keywords             TEXT                 null,
filesize             INT4                 not null DEFAULT 0,
filepath             TEXT                 not null,
width                INT4                 not null DEFAULT 0,
height               INT4                 not null DEFAULT 0,
CONSTRAINT ax_catalog_pkey PRIMARY KEY (cat_id)
);

/*==============================================================*/
/* Table: ax_config                                             */
/*==============================================================*/
CREATE TABLE ax_config (
config_name          TEXT                 not null,
config_fields        TEXT                 null,
CONSTRAINT ax_config_pkey PRIMARY KEY (config_name)
);

/*==============================================================*/
/* Table: ax_configuration                                      */
/*==============================================================*/
CREATE TABLE ax_configuration (
config_name          TEXT                 not null,
config_id            TEXT                 not null,
config_set           TEXT                 null,
CONSTRAINT ax_configuration_pkey PRIMARY KEY (config_name, config_id)
);

/*==============================================================*/
/* Index: ax_configuration_config_FK                            */
/*==============================================================*/
CREATE INDEX ax_configuration_config_FK ON ax_configuration (
config_name
);

/*==============================================================*/
/* Table: ax_contactinfo                                        */
/*==============================================================*/
CREATE TABLE ax_contactinfo (
contactinfo_id       INT4                 not null,
addr_postal          TEXT                 null,
addr_street          TEXT                 null,
addr_suburb          TEXT                 null,
addr_city            TEXT                 null,
addr_country         TEXT                 null,
addr_code            TEXT                 null,
addr_other           TEXT                 null,
emails               TEXT                 null,
phone                TEXT                 null,
phone_fax            TEXT                 null,
phone_work           TEXT                 null,
phone_mobile         TEXT                 null,
urls                 TEXT                 null,
CONSTRAINT ax_contactinfo_pkey PRIMARY KEY (contactinfo_id)
);

/*==============================================================*/
/* Table: ax_content_location                                   */
/*==============================================================*/
CREATE TABLE ax_content_location (
location_id          INT4                 not null,
location_name        TEXT                 not null,
location_desc        TEXT                 null,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT PK_AX_CONTENT_LOCATION PRIMARY KEY (location_id)
);

COMMENT ON TABLE ax_content_location is
'Contains unique logical locations on the website for content. These are not necessarily physical pages, but can be used in your application code to present the story in the locations required.';

COMMENT ON COLUMN ax_content_location.enabled is
'If true, then items in this location can be displayed in an order determined by the user, else display by default method (usually reverse date order)';

/*==============================================================*/
/* Table: ax_control                                            */
/*==============================================================*/
CREATE TABLE ax_control (
app_version          TEXT                 null,
last_db_patch        TEXT                 null,
updated_at           TIMESTAMP            null
);

COMMENT ON TABLE ax_control is
'Details which are registered for any Axyl website, on first access, or on upgrade.';

COMMENT ON COLUMN ax_control.app_version is
'The code name of this website - often used as a prefix for messaging etc.';

COMMENT ON COLUMN ax_control.last_db_patch is
'The version of Axyl that this website was installed under';

COMMENT ON COLUMN ax_control.updated_at is
'The full physical path to this website when installed';

/*==============================================================*/
/* Table: ax_element_set_enc                                    */
/*==============================================================*/
CREATE TABLE ax_element_set_enc (
schema_name          TEXT                 not null,
element_id           INT4                 not null,
enc_scheme_id        INT4                 not null,
CONSTRAINT PK_AX_ELEMENT_SET_ENC PRIMARY KEY (schema_name, element_id, enc_scheme_id)
);

/*==============================================================*/
/* Table: ax_enc_qualifier                                      */
/*==============================================================*/
CREATE TABLE ax_enc_qualifier (
enc_scheme_id        INT4                 not null,
qual_name            TEXT                 not null,
qual_label           TEXT                 null,
comments             TEXT                 null,
default_value        TEXT                 null,
list_of_values       TEXT                 null,
display_order        INT4                 not null DEFAULT 999,
CONSTRAINT PK_AX_ENC_QUALIFIER PRIMARY KEY (enc_scheme_id, qual_name)
);

/*==============================================================*/
/* Table: ax_enc_scheme                                         */
/*==============================================================*/
CREATE TABLE ax_enc_scheme (
enc_scheme_id        INT4                 not null,
enc_scheme_name      TEXT                 not null,
label                TEXT                 null,
tag_name             TEXT                 not null,
description          TEXT                 null,
datasrc_uri          TEXT                 null,
reference_url        TEXT                 null,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT PK_AX_ENC_SCHEME PRIMARY KEY (enc_scheme_id)
);

COMMENT ON TABLE ax_enc_scheme is
'This table holds encoding schemes, which are basically lists of values. An example would be an encoding scheme for Media Types, which is essentially a list of mime-types. Other examples include Language Name Codes, and even Medical Subject Headings.';

COMMENT ON COLUMN ax_enc_scheme.enc_scheme_name is
'Short name-tag - often an code like ''RFC3066''.';

COMMENT ON COLUMN ax_enc_scheme.label is
'Full name of the scheme.';

COMMENT ON COLUMN ax_enc_scheme.datasrc_uri is
'Location of downloadable scheme data.';

COMMENT ON COLUMN ax_enc_scheme.reference_url is
'Web-page where scheme is described/defined.';

/*==============================================================*/
/* Table: ax_enc_value                                          */
/*==============================================================*/
CREATE TABLE ax_enc_value (
enc_scheme_id        INT4                 not null,
enc_value            TEXT                 not null,
enc_label            TEXT                 null,
CONSTRAINT PK_AX_ENC_VALUE PRIMARY KEY (enc_scheme_id, enc_value)
);

/*==============================================================*/
/* Table: ax_forum                                              */
/*==============================================================*/
CREATE TABLE ax_forum (
forum_id             INT4                 not null,
moderator            TEXT                 null,
forum_name           TEXT                 not null,
forum_desc           TEXT                 null,
enabled              BOOL                 not null DEFAULT true,
private              BOOL                 not null DEFAULT false,
last_author          TEXT                 null,
threadlast_author    INT4                 not null DEFAULT 0,
datelast_author      DATE                 null,
posts                INT4                 not null DEFAULT 0,
CONSTRAINT ax_forum_pkey PRIMARY KEY (forum_id)
);

/*==============================================================*/
/* Table: ax_forum_member                                       */
/*==============================================================*/
CREATE TABLE ax_forum_member (
user_id              TEXT                 not null,
forum_id             INT4                 not null,
CONSTRAINT ax_forum_mbr_pkey PRIMARY KEY (user_id, forum_id)
);

/*==============================================================*/
/* Index: ax_forum_member_FK                                    */
/*==============================================================*/
CREATE INDEX ax_forum_member_FK ON ax_forum_member (
user_id
);

/*==============================================================*/
/* Index: ax_forum_member_FK2                                   */
/*==============================================================*/
CREATE INDEX ax_forum_member_FK2 ON ax_forum_member (
forum_id
);

/*==============================================================*/
/* Table: ax_forum_msg                                          */
/*==============================================================*/
CREATE TABLE ax_forum_msg (
msg_id               INT4                 not null,
forum_id             INT4                 not null,
msg_subject          TEXT                 not null,
msg_text             TEXT                 not null,
msg_author           TEXT                 not null,
msg_votes            INT4                 not null DEFAULT 0,
last_modified        TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
parent_thread_id     INT4                 null,
sticky               BOOL                 not null DEFAULT false,
locked               BOOL                 not null DEFAULT false,
views                INT4                 not null DEFAULT 0,
enabled              BOOL                 not null DEFAULT true,
replies              INT4                 not null DEFAULT 0,
CONSTRAINT ax_forum_msg_pkey PRIMARY KEY (msg_id)
);

/*==============================================================*/
/* Index: ax_fk_forum_msg_forum_FK                              */
/*==============================================================*/
CREATE INDEX ax_fk_forum_msg_forum_FK ON ax_forum_msg (
forum_id
);

/*==============================================================*/
/* Table: ax_group                                              */
/*==============================================================*/
CREATE TABLE ax_group (
group_id             INT4                 not null,
group_desc           TEXT                 not null,
CONSTRAINT ax_group_pkey PRIMARY KEY (group_id)
);

/*==============================================================*/
/* Table: ax_language                                           */
/*==============================================================*/
CREATE TABLE ax_language (
lang_id              INT4                 not null,
lang_desc            TEXT                 not null,
char_encoding        TEXT                 not null,
direction            TEXT                 not null DEFAULT 'LTR' 
      CONSTRAINT CKC_DIRECTION_AX_LANGU CHECK (direction in ('LTR','RTL')),
is_default           BOOL                 not null DEFAULT false,
display_order        INT4                 not null DEFAULT 999,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT PK_AX_LANGUAGE PRIMARY KEY (lang_id)
);

COMMENT ON TABLE ax_language is
'Contains the languages that Axyl supports.';

COMMENT ON COLUMN ax_language.lang_id is
'A unique text code for this language';

COMMENT ON COLUMN ax_language.lang_desc is
'Nice descriptive word or phrase for this language.';

COMMENT ON COLUMN ax_language.char_encoding is
'The character encoding code to use for this language. This code may appear in various webpage tags to guide browsers.';

COMMENT ON COLUMN ax_language.direction is
'The direction the language is written in: LTR (left to right) or RTL (right to left.';

COMMENT ON COLUMN ax_language.is_default is
'Whether this language is the default one.';

/*==============================================================*/
/* Table: ax_layout                                             */
/*==============================================================*/
CREATE TABLE ax_layout (
layout_id            INT4                 not null,
layout_name          TEXT                 not null,
lang_id              INT4                 not null DEFAULT 0,
index_category       TEXT                 null,
layout_table         TEXT                 null,
show_last_modified   BOOL                 not null DEFAULT false,
format_last_modified TEXT                 null,
prefix_last_modified TEXT                 null,
layout_style         TEXT                 null,
cache                TEXT                 null,
cache_updated        TIMESTAMP WITH TIME ZONE null,
last_modified        TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
CONSTRAINT ax_layout_pkey PRIMARY KEY (layout_id)
);

/*==============================================================*/
/* Index: ax_layout_set_FK                                      */
/*==============================================================*/
CREATE INDEX ax_layout_set_FK ON ax_layout (
layout_name
);

/*==============================================================*/
/* Table: ax_layout_metadata                                    */
/*==============================================================*/
CREATE TABLE ax_layout_metadata (
layout_id            INT4                 not null,
element_id           INT4                 not null,
schema_name          TEXT                 not null,
meta_tag_value       TEXT                 null,
enc_scheme_id        INT4                 null,
linked_uri           BOOL                 not null DEFAULT false,
language             TEXT                 null,
CONSTRAINT PK_AX_LAYOUT_METADATA PRIMARY KEY (layout_id, element_id, schema_name)
);

COMMENT ON TABLE ax_layout_metadata is
'This is the actual container of metadata values for the given layout. A webpage might contain multiple layouts, therefore the metadata to be entered for the page is the unique combination of all layout metadata elements.';

/*==============================================================*/
/* Table: ax_layout_set                                         */
/*==============================================================*/
CREATE TABLE ax_layout_set (
layout_name          TEXT                 not null,
page_id              INT4                 null,
CONSTRAINT ax_layout_set_pkey PRIMARY KEY (layout_name)
);

/*==============================================================*/
/* Index: ax_layout_set_sitepage_FK                             */
/*==============================================================*/
CREATE INDEX ax_layout_set_sitepage_FK ON ax_layout_set (
page_id
);

/*==============================================================*/
/* Table: ax_layout_set_group                                   */
/*==============================================================*/
CREATE TABLE ax_layout_set_group (
layout_name          TEXT                 not null,
cm_privilege         TEXT                 not null 
      CONSTRAINT CKC_CM_PRIVILEGE_AX_LAYOU CHECK (cm_privilege in ('editor','author','entry')),
group_id             INT4                 not null,
CONSTRAINT PK_AX_LAYOUT_SET_GROUP PRIMARY KEY (layout_name, cm_privilege, group_id)
);

/*==============================================================*/
/* Table: ax_menu                                               */
/*==============================================================*/
CREATE TABLE ax_menu (
menu_id              INT4                 not null,
menu_name            TEXT                 not null,
lang_id              INT4                 not null DEFAULT 0,
menu_desc            TEXT                 null,
menu_user_groups     TEXT                 null,
active               BOOL                 not null DEFAULT true,
last_modified        TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
CONSTRAINT ax_menu_pkey PRIMARY KEY (menu_id)
);

/*==============================================================*/
/* Index: menu_language                                         */
/*==============================================================*/
CREATE unique INDEX menu_language ON ax_menu (
menu_name,
lang_id
);

/*==============================================================*/
/* Table: ax_menuoption                                         */
/*==============================================================*/
CREATE TABLE ax_menuoption (
menuoption_id        INT4                 not null,
menu_id              INT4                 not null,
parent_id            INT4                 null DEFAULT 0,
user_groups          TEXT                 null,
user_type            TEXT                 null,
menu_level           INT4                 not null DEFAULT 0,
label                TEXT                 null,
description          TEXT                 null,
display_order        INT4                 not null DEFAULT 0,
action               TEXT                 null,
sitepage             TEXT                 null,
sitepage_parms       TEXT                 null,
auth_code            BOOL                 not null DEFAULT false,
active               BOOL                 not null DEFAULT true,
width                INT4                 not null DEFAULT 80,
height               INT4                 not null DEFAULT 20,
is_parent            BOOL                 not null DEFAULT false,
target               TEXT                 null,
last_modified        TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
CONSTRAINT ax_menuoption_pkey PRIMARY KEY (menuoption_id)
);

/*==============================================================*/
/* Index: ax_menuoption_menu_FK                                 */
/*==============================================================*/
CREATE INDEX ax_menuoption_menu_FK ON ax_menuoption (
menu_id
);

/*==============================================================*/
/* Table: ax_meta_element                                       */
/*==============================================================*/
CREATE TABLE ax_meta_element (
element_id           INT4                 not null,
label                TEXT                 null,
tag_name             TEXT                 not null,
definition           TEXT                 null,
parent_element       INT4                 null,
parent_schema        TEXT                 null,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT PK_AX_META_ELEMENT PRIMARY KEY (element_id)
);

COMMENT ON TABLE ax_meta_element is
'A metadata element is the basic description of a template for an actual container of metadata. It is usually first ''born'' in a particular meta schema, but can thenceforth be picked up and used as part of other schemas - this is the function of the foreign key field ''parent_schema''.';

/*==============================================================*/
/* Table: ax_meta_element_set                                   */
/*==============================================================*/
CREATE TABLE ax_meta_element_set (
schema_name          TEXT                 not null,
element_id           INT4                 not null,
preferred_enc_scheme INT4                 null,
comments             TEXT                 null,
obligation           TEXT                 not null DEFAULT 'o' 
      CONSTRAINT CKC_OBLIGATION_AX_META_ CHECK (obligation in ('m','c','r','o')),
default_value        TEXT                 null,
list_of_values       TEXT                 null,
display_order        INT4                 not null DEFAULT 999,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT PK_AX_META_ELEMENT_SET PRIMARY KEY (schema_name, element_id)
);

COMMENT ON TABLE ax_meta_element_set is
'This table represents a list of metadata elements which comprise the given schema. The elements might originate from other schemas, but all together they comprise a logical set for this schema. Each schema can also flag it''s elements as either mandatory or not, and can define a default display (data entry) order.';

/*==============================================================*/
/* Table: ax_meta_schema                                        */
/*==============================================================*/
CREATE TABLE ax_meta_schema (
schema_name          TEXT                 not null,
description          TEXT                 null,
namespace            TEXT                 null,
namespace_uri        TEXT                 null,
CONSTRAINT PK_AX_META_SCHEMA PRIMARY KEY (schema_name)
);

COMMENT ON TABLE ax_meta_schema is
'A meta schema is simply an umbrella entity which describes a metadata element set. Examples would be ''Dublin Core'', ''AGLS'', or ''NZGLS''.';

/*==============================================================*/
/* Table: ax_microsite                                          */
/*==============================================================*/
CREATE TABLE ax_microsite (
microsite_name       TEXT                 not null,
menu_id              INT4                 null,
microsite_desc       TEXT                 null,
microsite_domain     TEXT                 null,
css                  TEXT                 null,
css_ie               TEXT                 null,
css_ns               TEXT                 null,
req_microsite_publish BOOL                 not null DEFAULT false,
req_microsite_remove BOOL                 not null DEFAULT false,
currently_installed  BOOL                 not null DEFAULT false,
last_installed       TIMESTAMP            null,
last_modified        TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
CONSTRAINT PK_AX_MICROSITE PRIMARY KEY (microsite_name)
);

/*==============================================================*/
/* Table: ax_microsite_media                                    */
/*==============================================================*/
CREATE TABLE ax_microsite_media (
microsite_name       TEXT                 not null,
cat_id               INT4                 not null,
CONSTRAINT PK_AX_MICROSITE_MEDIA PRIMARY KEY (microsite_name, cat_id)
);

/*==============================================================*/
/* Table: ax_microsite_page                                     */
/*==============================================================*/
CREATE TABLE ax_microsite_page (
microsite_page_id    INT4                 not null,
microsite_name       TEXT                 not null,
page_id              INT4                 null,
menuoption_id        INT4                 null,
microsite_template_id INT4                 null,
page_title           TEXT                 not null,
corepage             BOOL                 not null DEFAULT false,
microsite_homepage   BOOL                 not null DEFAULT false,
menuoption_label     TEXT                 not null,
display_order        INT4                 not null DEFAULT 999,
cache_seconds        INT4                 not null DEFAULT 0,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT PK_AX_MICROSITE_PAGE PRIMARY KEY (microsite_page_id)
);

/*==============================================================*/
/* Table: ax_microsite_page_plugin                              */
/*==============================================================*/
CREATE TABLE ax_microsite_page_plugin (
plugin_id            INT4                 not null,
microsite_page_id    INT4                 not null,
plugin_pattern       TEXT                 not null,
plugin_content       TEXT                 not null,
CONSTRAINT PK_AX_MICROSITE_PAGE_PLUGIN PRIMARY KEY (plugin_id)
);

/*==============================================================*/
/* Table: ax_microsite_story                                    */
/*==============================================================*/
CREATE TABLE ax_microsite_story (
microsite_name       TEXT                 not null,
story_id             INT4                 not null,
CONSTRAINT PK_AX_MICROSITE_STORY PRIMARY KEY (microsite_name, story_id)
);

/*==============================================================*/
/* Table: ax_microsite_template                                 */
/*==============================================================*/
CREATE TABLE ax_microsite_template (
microsite_template_id INT4                 not null,
microsite_name       TEXT                 not null,
template_name        TEXT                 not null,
template_type        TEXT                 not null,
template_content     TEXT                 null,
CONSTRAINT PK_AX_MICROSITE_TEMPLATE PRIMARY KEY (microsite_template_id)
);

/*==============================================================*/
/* Table: ax_organisation                                       */
/*==============================================================*/
CREATE TABLE ax_organisation (
org_id               INT4                 not null,
contactinfo_id       INT4                 null,
org_name             TEXT                 not null,
org_desc             TEXT                 null,
org_contact          TEXT                 null,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT ax_org_pkey PRIMARY KEY (org_id)
);

/*==============================================================*/
/* Index: ax_org_contactinfo_FK                                 */
/*==============================================================*/
CREATE INDEX ax_org_contactinfo_FK ON ax_organisation (
contactinfo_id
);

/*==============================================================*/
/* Table: ax_plugin_area                                        */
/*==============================================================*/
CREATE TABLE ax_plugin_area (
plugin_pattern       TEXT                 not null,
plugin_desc          TEXT                 null,
CONSTRAINT PK_AX_PLUGIN_AREA PRIMARY KEY (plugin_pattern)
);

/*==============================================================*/
/* Table: ax_plugin_content                                     */
/*==============================================================*/
CREATE TABLE ax_plugin_content (
plugin_content       TEXT                 not null,
plugin_content_desc  TEXT                 not null,
generator            TEXT                 not null,
generator_type       TEXT                 not null DEFAULT 'defer' 
      CONSTRAINT CKC_GENERATOR_TYPE_AX_PLUGI CHECK (generator_type in ('cm','func','defer','lit','file')),
replace_content      BOOL                 not null DEFAULT false,
CONSTRAINT PK_AX_PLUGIN_CONTENT PRIMARY KEY (plugin_content)
);

/*==============================================================*/
/* Table: ax_query_resource                                     */
/*==============================================================*/
CREATE TABLE ax_query_resource (
quid                 INT4                 not null,
q_desc               TEXT                 null,
q_query              TEXT                 null,
q_script             TEXT                 null,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT ax_query_key PRIMARY KEY (quid)
);

/*==============================================================*/
/* Table: ax_site_meta_element                                  */
/*==============================================================*/
CREATE TABLE ax_site_meta_element (
element_id           INT4                 not null,
schema_name          TEXT                 not null,
label                TEXT                 null,
description          TEXT                 null,
indexed              BOOL                 not null DEFAULT false,
searchable           BOOL                 not null DEFAULT false,
obligation           TEXT                 not null DEFAULT 'o' 
      CONSTRAINT CKC_OBLIGATION_AX_SITE_ CHECK (obligation in ('m','c','r','o')),
default_value        TEXT                 null,
list_of_values       TEXT                 null,
display_order        INT4                 not null DEFAULT 999,
enabled              BOOL                 null DEFAULT true,
CONSTRAINT PK_AX_SITE_META_ELEMENT PRIMARY KEY (element_id, schema_name)
);

COMMENT ON TABLE ax_site_meta_element is
'This table holds the list of metadata elements which are going to be used for the website. These can be assembled from any of the defined metadata elements.';

/*==============================================================*/
/* Table: ax_sitepage                                           */
/*==============================================================*/
CREATE TABLE ax_sitepage (
page_id              INT4                 not null,
page_title           TEXT                 not null,
page_path            TEXT                 not null,
managed              BOOL                 not null DEFAULT true,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT ax_sitepage_pkey PRIMARY KEY (page_id)
);

/*==============================================================*/
/* Table: ax_sitepage_group                                     */
/*==============================================================*/
CREATE TABLE ax_sitepage_group (
group_id             INT4                 not null,
page_id              INT4                 not null,
CONSTRAINT PK_AX_SITEPAGE_GROUP PRIMARY KEY (group_id, page_id)
);

COMMENT ON TABLE ax_sitepage_group is
'Indicates mandatory group membership for sitepage access.';

/*==============================================================*/
/* Table: ax_story                                              */
/*==============================================================*/
CREATE TABLE ax_story (
story_id             INT4                 not null,
lang_id              INT4                 not null DEFAULT 0,
category_id          INT4                 null,
story_author         TEXT                 null,
story_icon           INT4                 null,
story_icon_url       TEXT                 null,
story_headline       TEXT                 null,
story_precis         TEXT                 null,
story_content        TEXT                 null,
story_type           TEXT                 null,
story_url            TEXT                 null,
story_date           TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
expiry_date          TIMESTAMP WITH TIME ZONE null,
last_modified        TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
deleted              BOOL                 not null DEFAULT false,
visible              BOOL                 not null DEFAULT true,
CONSTRAINT PK_AX_STORY PRIMARY KEY (story_id)
);

COMMENT ON COLUMN ax_story.story_url is
'If the story is on a remote website, or a filesystem then the URL or physical path to the file is stored here.';

/*==============================================================*/
/* Table: ax_story_category                                     */
/*==============================================================*/
CREATE TABLE ax_story_category (
category_id          INT4                 not null,
category_desc        TEXT                 not null,
has_media            BOOL                 not null DEFAULT false,
has_precis           BOOL                 not null DEFAULT true,
has_expiry           BOOL                 not null DEFAULT false,
has_multilang        BOOL                 not null DEFAULT true,
has_multimedia       BOOL                 not null DEFAULT false,
CONSTRAINT PK_AX_STORY_CATEGORY PRIMARY KEY (category_id)
);

COMMENT ON TABLE ax_story_category is
'The story can be used to split stories into groups, or subject areas.';

COMMENT ON COLUMN ax_story_category.has_media is
'True if this category can have media (images, movies etc.) associated with it.';

COMMENT ON COLUMN ax_story_category.has_precis is
'True if this category requires a precis or lead-in.';

COMMENT ON COLUMN ax_story_category.has_expiry is
'True if this category has an expiry date associated with it.';

COMMENT ON COLUMN ax_story_category.has_multilang is
'True if this category is for stories which could be translated into multiple languages.';

COMMENT ON COLUMN ax_story_category.has_multimedia is
'If true then the category will support more than one item of associated media.';

/*==============================================================*/
/* Table: ax_story_category_locs                                */
/*==============================================================*/
CREATE TABLE ax_story_category_locs (
category_id          INT4                 not null,
location_id          INT4                 not null,
CONSTRAINT PK_AX_STORY_CATEGORY_LOCS PRIMARY KEY (category_id, location_id)
);

COMMENT ON TABLE ax_story_category_locs is
'The default content locations for a story category.';

/*==============================================================*/
/* Table: ax_story_location                                     */
/*==============================================================*/
CREATE TABLE ax_story_location (
story_id             INT4                 not null,
location_id          INT4                 not null,
display_order        INT4                 not null DEFAULT 999,
CONSTRAINT PK_AX_STORY_LOCATION PRIMARY KEY (story_id, location_id)
);

COMMENT ON TABLE ax_story_location is
'Contains lists of stories which should be displayed in a particular location on the website. Also determines the order that the stories should be displayed in.';

/*==============================================================*/
/* Table: ax_story_media                                        */
/*==============================================================*/
CREATE TABLE ax_story_media (
story_id             INT4                 not null,
cat_id               INT4                 not null,
caption              TEXT                 null,
width                INT4                 not null DEFAULT 0,
height               INT4                 not null DEFAULT 0,
justify              TEXT                 not null DEFAULT '' 
      CONSTRAINT CKC_JUSTIFY_AX_STORY CHECK (justify in ('','left','center','right')),
display_order        INT4                 not null DEFAULT 999,
CONSTRAINT PK_AX_STORY_MEDIA PRIMARY KEY (story_id, cat_id)
);

COMMENT ON TABLE ax_story_media is
'Media items associated with the story.';

/*==============================================================*/
/* Table: ax_story_translation                                  */
/*==============================================================*/
CREATE TABLE ax_story_translation (
story_id             INT4                 not null,
translated_story_id  INT4                 not null,
CONSTRAINT PK_AX_STORY_TRANSLATION PRIMARY KEY (story_id, translated_story_id)
);

COMMENT ON TABLE ax_story_translation is
'Used to link translations of the same story together.';

/*==============================================================*/
/* Table: ax_user                                               */
/*==============================================================*/
CREATE TABLE ax_user (
user_id              TEXT                 not null,
org_id               INT4                 not null DEFAULT 0,
password             TEXT                 null,
full_name            TEXT                 null,
honorific_prefix     TEXT                 null,
first_name           TEXT                 null,
mid_names            TEXT                 null,
last_name            TEXT                 null,
user_type            TEXT                 not null DEFAULT 'user' 
      CONSTRAINT CKC_USER_TYPE_AX_USER CHECK (user_type in ('user','sys','remote')),
email                TEXT                 null,
address              TEXT                 null,
phone                TEXT                 null,
fax                  TEXT                 null,
mobile               TEXT                 null,
last_login           TIMESTAMP WITH TIME ZONE null,
total_logins         INT4                 not null DEFAULT 0,
limit_logins         INT4                 not null DEFAULT 0,
auth_code            TEXT                 null,
passwd_forever       BOOL                 not null DEFAULT false,
passwd_expiry        TIMESTAMP WITH TIME ZONE null,
passwd_history       TEXT                 null,
passwd_failures      INT4                 not null DEFAULT 0,
locked               BOOL                 not null DEFAULT false,
enabled              BOOL                 not null DEFAULT true,
CONSTRAINT ax_user_pkey PRIMARY KEY (user_id)
);

/*==============================================================*/
/* Index: ax_user_org_FK                                        */
/*==============================================================*/
CREATE INDEX ax_user_org_FK ON ax_user (
org_id
);

/*==============================================================*/
/* Table: ax_user_group                                         */
/*==============================================================*/
CREATE TABLE ax_user_group (
group_id             INT4                 not null,
user_id              TEXT                 not null,
CONSTRAINT ax_ugroup_pkey PRIMARY KEY (group_id, user_id)
);

/*==============================================================*/
/* Index: ax_user_group_FK                                      */
/*==============================================================*/
CREATE INDEX ax_user_group_FK ON ax_user_group (
group_id
);

/*==============================================================*/
/* Index: ax_user_group_FK2                                     */
/*==============================================================*/
CREATE INDEX ax_user_group_FK2 ON ax_user_group (
user_id
);

/*==============================================================*/
/* Table: ax_user_ip                                            */
/*==============================================================*/
CREATE TABLE ax_user_ip (
user_id              TEXT                 not null,
ip                   INET                 not null,
CONSTRAINT ax_user_ip_pkey PRIMARY KEY (user_id, ip)
);

/*==============================================================*/
/* Index: ax_user_ip_user_FK                                    */
/*==============================================================*/
CREATE INDEX ax_user_ip_user_FK ON ax_user_ip (
user_id
);

/*==============================================================*/
/* Table: ax_wwwsession                                         */
/*==============================================================*/
CREATE TABLE ax_wwwsession (
session_id           TEXT                 not null,
user_id              TEXT                 not null,
menuoption_id        INT4                 null,
lang_id              INT4                 not null DEFAULT 0,
menu_status          TEXT                 null,
user_groups          TEXT                 null,
login_type           INT4                 not null DEFAULT 0 
      CONSTRAINT CKC_LOGIN_TYPE_AX_WWWSE CHECK (login_type between 0 and 4),
login_datetime       TIMESTAMP WITH TIME ZONE not null DEFAULT CURRENT_TIMESTAMP,
CONSTRAINT wwwsession_pkey PRIMARY KEY (session_id)
);

/*==============================================================*/
/* Index: ax_wwwsession_user_FK                                 */
/*==============================================================*/
CREATE INDEX ax_wwwsession_user_FK ON ax_wwwsession (
user_id
);

ALTER TABLE ax_block
   ADD CONSTRAINT fk_AX_BLOCK_AX_BLOCK__AX_CATAL FOREIGN KEY (background_img)
      REFERENCES ax_catalog (cat_id)
      ON DELETE set null ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_block
   ADD CONSTRAINT fk_ax_block_language FOREIGN KEY (lang_id)
      REFERENCES ax_language (lang_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_block
   ADD CONSTRAINT ax_block_layout FOREIGN KEY (layout_id)
      REFERENCES ax_layout (layout_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_block_blocklet
   ADD CONSTRAINT ax_block_blocklet_block FOREIGN KEY (block_id)
      REFERENCES ax_block (block_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_block_blocklet
   ADD CONSTRAINT ax_block_blocklet_blocklet FOREIGN KEY (blocklet_id)
      REFERENCES ax_blocklet (blocklet_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_configuration
   ADD CONSTRAINT ax_configuration_config FOREIGN KEY (config_name)
      REFERENCES ax_config (config_name)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_element_set_enc
   ADD CONSTRAINT fk_ax_elemset_enc_enc FOREIGN KEY (enc_scheme_id)
      REFERENCES ax_enc_scheme (enc_scheme_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_element_set_enc
   ADD CONSTRAINT fk_ax_elemset_enc_set FOREIGN KEY (schema_name, element_id)
      REFERENCES ax_meta_element_set (schema_name, element_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_enc_qualifier
   ADD CONSTRAINT fk_ax_enc_qual_scheme FOREIGN KEY (enc_scheme_id)
      REFERENCES ax_enc_scheme (enc_scheme_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_enc_value
   ADD CONSTRAINT fk_ax_enc_schema_value FOREIGN KEY (enc_scheme_id)
      REFERENCES ax_enc_scheme (enc_scheme_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_forum
   ADD CONSTRAINT FK_AX_FORUM_MODERATOR FOREIGN KEY (moderator)
      REFERENCES ax_user (user_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_forum_member
   ADD CONSTRAINT ax_forum_mbr_forum FOREIGN KEY (forum_id)
      REFERENCES ax_forum (forum_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_forum_member
   ADD CONSTRAINT ax_forum_mbr_user FOREIGN KEY (user_id)
      REFERENCES ax_user (user_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_forum_msg
   ADD CONSTRAINT ax_forum_msg_forum FOREIGN KEY (forum_id)
      REFERENCES ax_forum (forum_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_forum_msg
   ADD CONSTRAINT fk_AX_FORUM_PARENT_TH_AX_FORUM FOREIGN KEY (parent_thread_id)
      REFERENCES ax_forum_msg (msg_id)
      ON DELETE cascade ON UPDATE cascade;

ALTER TABLE ax_layout
   ADD CONSTRAINT fk_ax_layout_language FOREIGN KEY (lang_id)
      REFERENCES ax_language (lang_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_layout
   ADD CONSTRAINT ax_layout_set_layout FOREIGN KEY (layout_name)
      REFERENCES ax_layout_set (layout_name)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_layout_metadata
   ADD CONSTRAINT fk_ax_lay_metadata_elem FOREIGN KEY (element_id, schema_name)
      REFERENCES ax_site_meta_element (element_id, schema_name)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_layout_metadata
   ADD CONSTRAINT fk_ax_lay_metadata_scheme FOREIGN KEY (enc_scheme_id)
      REFERENCES ax_enc_scheme (enc_scheme_id)
      ON DELETE set null ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_layout_metadata
   ADD CONSTRAINT fk_ax_layout_meta_data FOREIGN KEY (layout_id)
      REFERENCES ax_layout (layout_id)
      ON DELETE cascade
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_layout_set
   ADD CONSTRAINT ax_layout_set_sitepage FOREIGN KEY (page_id)
      REFERENCES ax_sitepage (page_id)
      ON DELETE set null ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_layout_set_group
   ADD CONSTRAINT fk_group_layout_set FOREIGN KEY (layout_name)
      REFERENCES ax_layout_set (layout_name)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_layout_set_group
   ADD CONSTRAINT fk_layout_set_group FOREIGN KEY (group_id)
      REFERENCES ax_group (group_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_menu
   ADD CONSTRAINT fk_ax_menu_language FOREIGN KEY (lang_id)
      REFERENCES ax_language (lang_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_menuoption
   ADD CONSTRAINT fk_ax_menuoption_menu FOREIGN KEY (menu_id)
      REFERENCES ax_menu (menu_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_meta_element
   ADD CONSTRAINT fk_ax_meta_elem_parent_schema FOREIGN KEY (parent_schema)
      REFERENCES ax_meta_schema (schema_name)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_meta_element
   ADD CONSTRAINT fk_ax_parent_element FOREIGN KEY (parent_element)
      REFERENCES ax_meta_element (element_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_meta_element_set
   ADD CONSTRAINT fk_ax_meta_elem_set_elem FOREIGN KEY (element_id)
      REFERENCES ax_meta_element (element_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_meta_element_set
   ADD CONSTRAINT fk_ax_meta_elem_set_schema FOREIGN KEY (schema_name)
      REFERENCES ax_meta_schema (schema_name)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_meta_element_set
   ADD CONSTRAINT fk_ax_pref_enc_scheme FOREIGN KEY (preferred_enc_scheme)
      REFERENCES ax_enc_scheme (enc_scheme_id)
      ON DELETE restrict ON UPDATE restrict;

ALTER TABLE ax_microsite
   ADD CONSTRAINT fk_ax_microsite_menu FOREIGN KEY (menu_id)
      REFERENCES ax_menu (menu_id)
      ON DELETE set null ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_media
   ADD CONSTRAINT fk_ax_microsite_media FOREIGN KEY (cat_id)
      REFERENCES ax_catalog (cat_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_media
   ADD CONSTRAINT fk_ax_microsite_media_page FOREIGN KEY (microsite_name)
      REFERENCES ax_microsite (microsite_name)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_page
   ADD CONSTRAINT fk_ax_microsite_page FOREIGN KEY (microsite_name)
      REFERENCES ax_microsite (microsite_name)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_page
   ADD CONSTRAINT fk_ax_microsite_page_template FOREIGN KEY (microsite_template_id)
      REFERENCES ax_microsite_template (microsite_template_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_page
   ADD CONSTRAINT fk_ax_microsite_sitepage FOREIGN KEY (page_id)
      REFERENCES ax_sitepage (page_id)
      ON DELETE set null ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_page
   ADD CONSTRAINT fk_microsite_page_menuoption FOREIGN KEY (menuoption_id)
      REFERENCES ax_menuoption (menuoption_id)
      ON DELETE set null ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_page_plugin
   ADD CONSTRAINT fk_microsite_page_plugin FOREIGN KEY (microsite_page_id)
      REFERENCES ax_microsite_page (microsite_page_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_page_plugin
   ADD CONSTRAINT fk_plugin_area FOREIGN KEY (plugin_pattern)
      REFERENCES ax_plugin_area (plugin_pattern)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_page_plugin
   ADD CONSTRAINT fk_plugin_content FOREIGN KEY (plugin_content)
      REFERENCES ax_plugin_content (plugin_content)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_story
   ADD CONSTRAINT fk_microsite_story FOREIGN KEY (story_id)
      REFERENCES ax_story (story_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_story
   ADD CONSTRAINT fk_story_microsite FOREIGN KEY (microsite_name)
      REFERENCES ax_microsite (microsite_name)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_microsite_template
   ADD CONSTRAINT fk_ax_microsite_template FOREIGN KEY (microsite_name)
      REFERENCES ax_microsite (microsite_name)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_organisation
   ADD CONSTRAINT ax_org_contactinfo FOREIGN KEY (contactinfo_id)
      REFERENCES ax_contactinfo (contactinfo_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_site_meta_element
   ADD CONSTRAINT fk_ax_site_meta_element FOREIGN KEY (schema_name, element_id)
      REFERENCES ax_meta_element_set (schema_name, element_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_sitepage_group
   ADD CONSTRAINT fk_ax_sitepage_gp_group FOREIGN KEY (group_id)
      REFERENCES ax_group (group_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_sitepage_group
   ADD CONSTRAINT fk_ax_sitepage_gp_page FOREIGN KEY (page_id)
      REFERENCES ax_sitepage (page_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story
   ADD CONSTRAINT fk_ax_story_author FOREIGN KEY (story_author)
      REFERENCES ax_user (user_id)
      ON DELETE set null ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story
   ADD CONSTRAINT fk_ax_story_category FOREIGN KEY (category_id)
      REFERENCES ax_story_category (category_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story
   ADD CONSTRAINT fk_ax_story_language FOREIGN KEY (lang_id)
      REFERENCES ax_language (lang_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story
   ADD CONSTRAINT fk_story_icon FOREIGN KEY (story_icon)
      REFERENCES ax_catalog (cat_id)
      ON DELETE set null ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story_category_locs
   ADD CONSTRAINT fk_ax_story_categ_loc FOREIGN KEY (category_id)
      REFERENCES ax_story_category (category_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story_category_locs
   ADD CONSTRAINT fk_ax_story_categ_loc_loc FOREIGN KEY (location_id)
      REFERENCES ax_content_location (location_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story_location
   ADD CONSTRAINT fk_ax_content_location FOREIGN KEY (location_id)
      REFERENCES ax_content_location (location_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story_location
   ADD CONSTRAINT fk_ax_story_location FOREIGN KEY (story_id)
      REFERENCES ax_story (story_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story_media
   ADD CONSTRAINT fk_ax_story_media_cat_id FOREIGN KEY (cat_id)
      REFERENCES ax_catalog (cat_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story_media
   ADD CONSTRAINT fk_ax_story_media_story FOREIGN KEY (story_id)
      REFERENCES ax_story (story_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story_translation
   ADD CONSTRAINT fk_ax_original_story FOREIGN KEY (story_id)
      REFERENCES ax_story (story_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_story_translation
   ADD CONSTRAINT fk_ax_translated_story FOREIGN KEY (translated_story_id)
      REFERENCES ax_story (story_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_user
   ADD CONSTRAINT ax_user_organisation FOREIGN KEY (org_id)
      REFERENCES ax_organisation (org_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_user_group
   ADD CONSTRAINT ax_user_group_group FOREIGN KEY (group_id)
      REFERENCES ax_group (group_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_user_group
   ADD CONSTRAINT ax_user_group_user FOREIGN KEY (user_id)
      REFERENCES ax_user (user_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_user_ip
   ADD CONSTRAINT ax_user_ip_user FOREIGN KEY (user_id)
      REFERENCES ax_user (user_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_wwwsession
   ADD CONSTRAINT fk_ax_session_language FOREIGN KEY (lang_id)
      REFERENCES ax_language (lang_id)
      ON DELETE restrict ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_wwwsession
   ADD CONSTRAINT ax_wwwsession_user FOREIGN KEY (user_id)
      REFERENCES ax_user (user_id)
      ON DELETE cascade ON UPDATE restrict
      DEFERRABLE INITIALLY DEFERRED;

ALTER TABLE ax_wwwsession
   ADD CONSTRAINT fk_AX_WWWSE_SESSION_M_AX_MENUO FOREIGN KEY (menuoption_id)
      REFERENCES ax_menuoption (menuoption_id)
      ON DELETE set null ON UPDATE set null;

