<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    site-webpage.php                                        */
/* Author:      Paul Waite                                              */
/* Description: Included by every Site Webpage.                         */
/*                                                                      */
/* ******************************************************************** */
include_once("button-defs.php");
include_once("layout-defs.php");

// Returns the main menu
function main_menu() {
  global $RESPONSE, $LIBDIR;
  $s = "";

  // Standard dumb ol' menu for Netscape 4.xx, not multi-level..
  if ($RESPONSE->browser == BROWSER_NETSCAPE) {
    include_once("menu-defs.php");
    $menu = new sitemenu("main", MENU_LEVEL_ALL, "", VERTICAL);
  }
  else {
    // A nice menu for other browsers. Out of the box we have a
    // choice of two: Xmenu and TreeMenu. Take your choice and
    // uncomment the relevant lines here..

    // XMenu is a multi-level Javascript menu which is generally
    // used in vertical mode down the left-hand sidebar..
    //include_once("xmenu-defs.php");
    //$menu = new Xmenu("main", $RESPONSE);
    //$menu->set_default_images();
    //$menu->set_menu_images(
    //            new img("$LIBDIR/img/_tri.gif", "", "", 5, 10),
    //            new img("$LIBDIR/img/_tridown.gif", "", "", 10, 5)
    //            );

    // TreeMenu is a non-javascript multi-level menu, used only
    // as a left-hand sidebar menu..
    include_once("treemenu-defs.php");
    $menu = new treemenu("main", $RESPONSE);
  }
  return $menu->render();
} // main menu


// -----------------------------------------------------------------------
// Returns the side menu for the page.
function member_login() {
  global $IMAGESDIR;
  global $RESPONSE;
  // Actual HTML content..
  $s  = "";
  $s .= "<form name=login_fm method=post action=\"$RESPONSE->requested\">";

  $Tlog = new table("auth");
  $Tlog->setwidth(203);
  $Tlog->setpadding(0);
  $Tlog->tbody("font-size:8pt;");
  if ($RESPONSE->ismemberof_group("Guest")) {
    // Button to login..
    $loginbtn = new form_imagebutton("login", "Login", "", "$IMAGESDIR/login.gif", "Click to Login", 203, 21);

    // Username textbox..
    $username_F = new form_textfield("tbxUsername", "NAME");
    $username_F->setcss("loginentry");

    // Password textbox..
    $password_F = new form_passwordfield("tbxPassword", "PASSWD");
    $password_F->setcss("loginentry");

    // Login field labels are images..
    $username_img = new img("$IMAGESDIR/username.gif", "", "", 50, 8);
    $password_img = new img("$IMAGESDIR/password.gif", "", "", 50, 8);

    // This image is 50px wide + 18px padding = 68px..
    $Tlog->tr();
    $Tlog->td( $username_img->render(), "background-color:#AC9D46;padding-left:18px;" );
    $Tlog->td( $username_F->render(), "background-color:#AC9D46" );
    // 132px + 68px + 3px = 203px..
    $Tlog->td_width(132);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    $Tlog->td( "", "bglogin" );
    $Tlog->td_colspan(2);
    $Tlog->td_metrics(200,3);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    // This image is 50px wide + 18px padding = 68px..
    $Tlog->td( $password_img->render(), "background-color:#AC9D46;padding-left:18px;" );
    $Tlog->td( $password_F->render(), "background-color:#AC9D46" );
    // 132px + 68px + 3px = 203px..
    $Tlog->td_width(132);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    $Tlog->td( $loginbtn->render() );
    $Tlog->td_colspan(3);

  }
  else {
    $logoutbtn = new form_imagebutton("logout", "Logout", "", "$IMAGESDIR/logout.gif", "Logout", 203, 21);
    $logout_F = new form_hiddenfield("tbxLogoff", "Logoff");
    $Tlog->tr();
    $Tlog->td( "", "bglogin" );
    $Tlog->td_metrics(200,3);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    $Tlog->td( $RESPONSE->name, "background-color:#AC9D46;color:white;text-align:center;" );
    $Tlog->td_width(200);
    $Tlog->td( "", "background-color:white;" );
    $Tlog->td_width(3);

    $Tlog->tr();
    $Tlog->td( $logoutbtn->render() . $logout_F->render() );
    $Tlog->td_colspan(3);
  }
  $s .= $Tlog->render();
  $s .= "</form>";

  // Return HTML..
  return $s;
} // member_login

// -----------------------------------------------------------------------
// Returns the latest news items
function latest_news() {
  global $RESPONSE, $LIBDIR, $CONTEXT;
  static $latest_news;
  // Max. latest stories to display..
  $max_stories = $CONTEXT->configvalue("Max Latest News");
  debugbr("max_stories = $max_stories");
  if (!isset($latest_news)) {
    include_once("story-defs.php");
    $q  = "SELECT * FROM ax_story s, ax_story_location sl, ax_content_location l";
    $q .= " WHERE s.visible";
    $q .= "   AND s.story_date <= CURRENT_TIMESTAMP";
    $q .= "   AND (s.expiry_date IS NULL OR s.expiry_date > CURRENT_TIMESTAMP)";
    $q .= "   AND sl.story_id=s.story_id";
    $q .= "   AND l.location_id=sl.location_id";
    $q .= "   AND l.location_name='Latest News'";
    $q .= " ORDER BY story_date DESC";
    $stories = dbrecordset($q);
    $num_stories = 0;
    $latest_news = "";
    if ($stories->hasdata) {
      $Ts = new table("story_$storyid");
      $Ts->setpadding(3);
      $Ts->setstyle("padding-top:15px;");
      $Ts->setclass("axlatestnews");
      $Ts->setwidth("100%");
      // Title
      $Ts->tr();
      $Ts->td("<span class=\"axtitle\">Latest News</span>", "axlatestnews");
      for ($count = 0; $count < $max_stories; $count++) {
        $storyid = $stories->field("story_id");
        $story = new story($storyid);
        // Story headline & date..
        $storydate = timestamp_to_displaydate(NICE_DATE, $story->story_date_ts);
        $Ts->tr();
        $Ts->td("<span class=\"axhdg\">" . $story->story_headline . "</span><br><span class=\"axsubhdg\">$storydate</span>", "axlatestnews");
        if ($story->story_precis != "") {
          $precis = $story->story_precis;
        }
        else {
          $precis = $story->make_precis(30);
        }
        $href = "/axyl-news.php";
        $href = href_addparm($href, "story_id", $storyid);
        $storylink = new anchor($href, "MORE..");
        $storylink->set_linkover_text("View story");
        $precis .= "&nbsp; " . $storylink->render();
        $Ts->tr();
        $Ts->td($precis, "axlatestnews");
        if (isset($story->story_icon)) {
          $Ts->tr();
          $Ts->td($story->render_story_icon(), "axlatestnews");
          $Ts->td_alignment("right", "bottom");
        }
        $Ts->tr();
        $Ts->td("&nbsp;", "axlatestnews");
        $Ts->td_metrics("", 10);
        // Get next story, or break out if we have no more..
        if ($stories->get_next() === false) {
          break;
        }
      }
      $latest_news .= $Ts->render();
    }
  }
  // Return latest news items as stacked tables..
  if (isset($latest_news)) {
    $s = $latest_news;
  }
  return $s;

} // latest_news

// -----------------------------------------------------------------------
// Featured news item..
function featured_news_item() {
  global $RESPONSE, $LIBDIR, $IMAGESDIR;
  static $feat_news;
  $s = "";
  if (!isset($feat_news)) {
    $Ts = new table("story_$storyid");
    $Ts->setwidth("80%");
    $Ts->setalign("center");

    include_once("story-defs.php");
    $q  = "SELECT * FROM ax_story s, ax_story_location sl, ax_content_location l";
    $q .= " WHERE s.visible";
    $q .= "   AND s.story_date <= CURRENT_TIMESTAMP";
    $q .= "   AND (s.expiry_date IS NULL OR s.expiry_date > CURRENT_TIMESTAMP)";
    $q .= "   AND sl.story_id=s.story_id";
    $q .= "   AND l.location_id=sl.location_id";
    $q .= "   AND l.location_name='Featured News Item'";
    $q .= " ORDER BY story_date DESC";
    $stories = dbrecordset($q);
    if ($stories->hasdata) {
      $storyid = $stories->field("story_id");
      $story = new story($storyid);
      $Ts->setstyle("background-color:#FAFDED;padding-top:15px;padding-bottom:5px;");
      $Ts->tr("background-color:black");
      $axfeature = new img("$IMAGESDIR/axyl_news.gif", "", "Feature", 160, 40);
      $Ts->td($axfeature->render(), "border-bottom:3px solid #FFDF60;border-top:3px solid #FFDF60");
      $Ts->tr();
      $Ts->td("<h3>" . $story->story_headline . "</h3>", "padding-left:10px;padding-right:10px;");
      if ($story->story_precis != "") {
        $precis = $story->story_precis;
      }
      else {
        $precis = $story->make_precis(100);
      }
      $href = "/axyl-news.php";
      $href = href_addparm($href, "story_id", $storyid);
      $storylink = new anchor($href, "MORE..");
      $storylink->set_linkover_text("View story");
      $precis .= "&nbsp; " . $storylink->render();
      $Ts->tr();
      $Ts->td($precis, "padding-left:10px;padding-right:10px;padding-top:5px;padding-bottom:10px;");
      if (isset($story->story_icon)) {
        $Ts->tr();
        $Ts->td($story->render_story_icon());
        $Ts->td_alignment("right");
      }
      $feat_news = $Ts->render();
    }
    else {
      $axfig = new img("$IMAGESDIR/axyl_fig1.jpg", "fig1", "Axyl");
      $Ts->tr();
      $Ts->td($axfig->render());
      $Ts->td_alignment("center");
      $feat_news = $Ts->render();
    }
  }
  // Return the asked-for story teaser..
  if (isset($feat_news)) {
    $s = $feat_news;
  }
  return $s;

} // featured_news_item

// -----------------------------------------------------------------------
// BODY - Template
// MAIN MENU and SIDEBARS - Only for main pages..
debugbr("template: " . $RESPONSE->template);

// Generic window opener..
$RESPONSE->head->add_script(
      "var newwin = null;\n"
    . "function windowopen(winurl,winname,winparams) {\n"
    . "  newwin = window.open(winurl,winname,winparams);\n"
    . "}\n"
    );


switch ($RESPONSE->template) {
 case "index":
  $RESPONSE->plugin("MEMBER_LOGIN", "member_login()");
  $RESPONSE->plugin("LEFT_SIDEBAR", "main_menu()");
  $RESPONSE->plugin("RIGHT_SIDEBAR", "latest_news()");
  break;

 case "main":
  $RESPONSE->plugin("MEMBER_LOGIN", "member_login()");
  $RESPONSE->plugin("LEFT_SIDEBAR", "main_menu()");
  $RESPONSE->plugin("RIGHT_SIDEBAR", "latest_news()");
  break;

 case "sidebar":
  $RESPONSE->plugin("MEMBER_LOGIN", "member_login()");
  $RESPONSE->plugin("LEFT_SIDEBAR", "main_menu()");
  $RESPONSE->plugin("RIGHT_SIDEBAR", "<!--LAYOUTID=\"RightSideBar\"-->");
  break;

 default:
  $RESPONSE->plugin("MEMBER_LOGIN", "member_login()");
  $RESPONSE->plugin("LEFT_SIDEBAR", "main_menu()");
  break;

} // switch

// This checks for/executes any search activity. If there
// is a search then this will not return..
include_once("axyl-search.php");

// -----------------------------------------------------------------------
?>