<?php
/************************************************************************/
/* CATALYST Php  Source Code                                            */
/* Copyright (C)2002 Catalyst IT Limited                                */
/*                                                                      */
/* Filename:    axyl-story-admin.php                                    */
/* Author:      Paul Waite                                              */
/* Date:        June 2004                                               */
/* Description: Page where news stories are added/administered.         */
/*                                                                      */
/************************************************************************/
include_once("application.php");
include_once("story-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("News", "main", $theme);

//debug_on(DBG_DUMP|DBG_DIAGNOSTIC|DBG_SQL|DBG_TABLES);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");

// We either have a specific news article to display or we don't. If
// They have just come here to look then they just see the Top 10
// articles list, with option to display All.
$initial_limit = 10;
$NEWS_ARTICLE = "";

// Default to featured article, if one exists. If it doesn't
// then there's nothing lost - we will just show the index.
if (!isset($story_id)) {
  $q  = "SELECT * FROM ax_story s, ax_story_location sl, ax_content_location l";
  $q .= " WHERE s.visible";
  $q .= "   AND s.story_date <= CURRENT_TIMESTAMP";
  $q .= "   AND (s.expiry_date IS NULL OR s.expiry_date > CURRENT_TIMESTAMP)";
  $q .= "   AND sl.story_id=s.story_id";
  $q .= "   AND l.location_id=sl.location_id";
  $q .= "   AND l.location_name='Featured News Item'";
  $q .= " ORDER BY story_date DESC";
  $featured = dbrecordset($q);
  if ($featured->hasdata) {
    $story_id = $featured->field("story_id");
  }
}

if (isset($story_id) && is_numeric($story_id)) {
  $story = new story($story_id);
  if ($story->valid) {
    $Tvw = new table("story");
    $Tvw->setpadding(3);
    $Tvw->setwidth("85%");
    $Tvw->setalign("center");

    // HEADLINE, BY-LINE, STORY TYPE & WORDCOUNT
    // STORY TYPE
    $Tvw->tr();
    $Tvw->td("<h2>" . $story->story_headline . "</h2>",
      "vertical-align:bottom;padding-bottom:0px;margin-bottom:0px;"
      );
    $Tvw->tr();
    $byline = "by ";
    $byline .= ($story->story_author_name != "") ? $story->story_author_name : "(anonymous)";
    $Tvw->td("<h6>$byline</h6>",
      "vertical-align:top;padding-bottom:5px;"
      );
    if (isset($story->story_icon)) {
      $Tvw->tr();
      $Tvw->td($story->render_story_icon());
    }

    // STORY DATE & EXPIRY DATE
    $Tvw->tr();
    $Tvw->td( timestamp_to_displaydate(NICE_FULLDATETIME, $story->story_date_ts) );

    // LEAD-IN & STORY CONTENT
    $Tvw->tr();
    //$content = $story->story_precis . " " . $story->story_content;
    $media_content = "";
    if ($story->has_media) {
      if (count($story->story_media) > 0) {
        foreach ($story->story_media as $cat_id => $media) {
          $width   = ($media->width  > 0) ? $media->width  : $media->catalogitem->width;
          $height  = ($media->height > 0) ? $media->height : $media->catalogitem->height;
          $caption = ($media->caption != "") ? $media->caption : $media->catalogitem->cat_name;
          $pic = new img(
                  $media->catalogitem->filepath,
                  $caption,
                  $caption,
                  $width,
                  $height
                  );
          $pic->setalign(($media->justify != "") ? $media->justify : "right");
          $pic->setstyle("padding:2px");
          $media_content .= $pic->render();
        } // foreach
      }
    }
    // Content..
    $story_lead_in = str_replace("\r\n\r\n", "<p>", $story->story_precis);
    $story_content = str_replace("\r\n\r\n", "<p>", $story->story_content);
    $content = "<p>" . $story_lead_in . "</p>"
            . $media_content
            . "<p>" . $story_content . "</p>";
    $Tvw->td($content, "padding-top:10px;padding-bottom:30px;border-top:1px solid black");

    // TRANSLATIONS
    if ($RESPONSE->multilang) {
      $story->get_story_translations();
      if (count($story->story_translations) > 0) {
        $translinks = array();
        foreach ($story->story_translations as $trans_story_id => $trans_lang_id) {
          $lq = dbrecordset("SELECT * FROM ax_language WHERE lang_id=$trans_lang_id");
          if ($lq->hasdata) {
            $href = "/axyl-news.php";
            $href = href_addparm($shref, "story_id", $trans_story_id);
            $translink = new anchor($href, ucfirst($lq->field("lang_desc")));
            $translinks[] = $translink->render();
          }
        }
        if (count($translinks) > 0) {
          $Tvw->tr();
          $Tvw->td("Also in: " . implode("&nbsp;|&nbsp;", $translinks), "border-top:1px solid black");
        }
      }
    }
    // Rule-off row..
    $Tvw->tr("axfoot");
    $Tvw->td("", "axfoot");
    $NEWS_ARTICLE = $Tvw->render();
  }
}

// Top 10 or All articles list..
$q  = "SELECT * FROM ax_story";
$q .= " WHERE visible";
$q .= "   AND story_date <= CURRENT_TIMESTAMP";
$q .= "   AND (expiry_date IS NULL OR expiry_date > CURRENT_TIMESTAMP)";
$q .= " ORDER BY story_date DESC";
$news = dbrecordset($q);
$Tix = new table("storyindex");
$Tix->setpadding(3);
$Tix->setwidth("85%");
$Tix->setalign("center");
$Tix->tr();
if (isset($limit) && $limit == "all") {
  $title = "All News";
}
else {
  $title = "Top $initial_limit";
  $limit = $initial_limit;
}
$Tix->td("<h3>$title</h3>");
$Tix->td_colspan(2);
if ($news->hasdata) {
  $dolist = true;
  $count = 0;
  $last_date = "";
  do {
    $storyid = $news->field("story_id");
    $headline = $news->field("story_headline");
    $date = datetime_to_displaydate(NICE_DATE, $news->field("story_date"));
    if ($date == $last_date) {
      $date = "";
    }
    else {
      $last_date = $date;
    }

    $href = "/axyl-news.php";
    $href = href_addparm($href, "story_id", $storyid);
    $storylink = new anchor($href, $headline);
    $storylink->set_linkover_text("View story");

    $Tix->tr();
    $Tix->td($date);
    $Tix->td($storylink->render());

    // Keep track..
    $count += 1;

    // Get next story..
    $dolist = $news->get_next();

    // Check limits..
    if ($limit != "all" && $count > $limit) {
      $dolist = false;
    }
  } while ($dolist);

  $href = "/axyl-news.php";
  if (isset($story_id)) {
    $href = href_addparm($href, "story_id", $storyid);
  }
  if ($limit == "all") {
    $href = href_addparm($href, "limit", $initial_limit);
    $modelink = new anchor($href, "View top $initial_limit ..");
  }
  else {
    $href = href_addparm($href, "limit", "all");
    $modelink = new anchor($href, "View all news ..");
  }
  $modelink->set_linkover_text("Set index mode");
  $Tix->tr();
  $Tix->td($modelink->render(), "padding-top:5px;padding-bottom:20px;border-top:1px solid black");
  $Tix->td_colspan(2);
}
else {
  $Tix->td("No news is good news.. watch this space!");
}
$NEWS_INDEX = $Tix->render();

// #######################################################################
// CONTENT HTML LAYOUT
$RESPONSE->plugin_inline("MAIN_CONTENT");
?>
<table border="0" cellspacing="0" cellpadding="2" width="85%" align="center" style="padding-top:20px">
  <tr class="axyl_rowstripe_lite">
    <td valign="top"><!--NEWS_ARTICLE--></td>
  </tr>
  <tr class="axyl_rowstripe_lite">
    <td valign="top"><!--NEWS_INDEX--></td>
  </tr>
</table>
<?php
$RESPONSE->plugin_inline();

// -----------------------------------------------------------------------
// Plugins..
$RESPONSE->plugin("NEWS_ARTICLE", $NEWS_ARTICLE);
$RESPONSE->plugin("NEWS_INDEX",   $NEWS_INDEX);

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>