<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    axyl-metadata-editor.php                                */
/* Author:      Paul Waite                                              */
/* Description: Metadata Editor entry point. This page expects to be    */
/*              handed a layout_id for the layout to edit the metadata  */
/*              of. It then displays the metadata for that layout and   */
/*              the buttons etc. to edit each element.                  */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");
include_once("metadata-defs.php");
include_once("form-defs.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("Metadata Editor", "popup", $theme);

// -----------------------------------------------------------------------
// Common site-specific content..
include_once("site-webpage.php");

// See if we can find the page details for this layout..
$layout_name = "";
$page_title = "";
$page_path = "";
$q  = "SELECT *";
$q .= "  FROM ax_layout_set ls, ax_layout l, ax_sitepage p";
$q .= " WHERE l.layout_id=$layout_id";
$q .= "   AND ls.layout_name=l.layout_name";
$q .= "   AND p.page_id=ls.page_id";
$page = dbrecordset($q);
if ($page->hasdata) {
  $layout_name = $page->field("layout_name");
  $page_path   = $page->field("page_path");
  $page_title  = $page->field("page_title");
}

// -----------------------------------------------------------------------
// FUNCTIONS
function reindex_layout($layout_id, $page_path, $page_title) {
  debugbr("reindex: layout=$layout_id, path=$page_path, title=$page_title");
  if ($layout_id != "" && $page_path != "" && $page_title != "") {
    $layout = new layout($layout_id);
    if ($layout->exists) {
      $layout->index($page, $path);
    }
  }
} // reindex_layout

// -----------------------------------------------------------------------
// MAIN CONTENT
$formname = "metaedit_form";
$form = new form($formname);

// When you have one of these, you need this script..
$RESPONSE->add_script(
    "function meta_action(act,elid,schid) {\n"
  . " document.forms.$formname.mode.value=act;\n"
  . " document.forms.$formname.element_id.value=elid;\n"
  . " document.forms.$formname.schema_name.value=schid;\n"
  . " document.forms.$formname.submit();\n"
  . "}\n"
  );

switch ($mode) {
  case "add":
  case "edit":
    $layout_elements = new layout_metadata_elements($layout_id, $formname);
    $element = $layout_elements->get_metadata_element($element_id);
    $element->inherit_schemes();
    $form->add_text( $element->definition_form($formname) );
    break;

  case "unset":
    $medel = new dbdelete("ax_layout_metadata");
    $medel->where("layout_id=$layout_id");
    $medel->where("AND element_id=$element_id");
    $medel->where("AND schema_name='" . addslashes($schema_name) . "'");
    $medel->execute();
    reindex_layout($layout_id, $page_path, $page_title);
    $layout_elements = new layout_metadata_elements($layout_id, $formname);
    $form->add_text($layout_elements->metadata_tree());
    $mode = "view";
    break;

  case "save":
    $layout_elements = new layout_metadata_elements($layout_id, $formname);
    $element = $layout_elements->get_metadata_element($element_id);
    $element->POSTprocess();
    $layout_elements->add_metadata_element($element);
    $layout_elements->save_metadata_element($element_id);
    reindex_layout($layout_id, $page_path, $page_title);
    $form->add_text($layout_elements->metadata_tree());
    $mode = "view";
    break;

  default:
    $layout_elements = new layout_metadata_elements($layout_id, $formname);
    $form->add_text($layout_elements->metadata_tree());
    $mode = "view";
} // switch

// Conteol values to carry forward..
$form->add( new form_hiddenfield("mode", $mode) );
$form->add( new form_hiddenfield("element_id", $element_id) );
$form->add( new form_hiddenfield("schema_name", $schema_name) );
$form->add( new form_hiddenfield("layout_id", $layout_id) );

$T = new table("Container");
$Te = new table("MetaEditor");
if ($mode == "view") {
  $Te->setclass("tablestyle_2");
  $Te->tr("axbgdark");
  $Te->td("<h2>Meta Browser</h2>", "axfg");
  if ($page_title != "") {
    $Te->td("<h4>$page_title</h4>", "axfg");
    $Te->td_alignment("right");
  }
}
$Te->tr("axbglite");
$Te->td( $form->render() );
$Te->td_colspan(2);

$RESPONSE->plugin("MAIN_CONTENT", $Te->render());

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>