<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    application.php                                         */
/* Author:      Paul Waite                                              */
/* Description: Main include file for the application. Mainly used      */
/*              to set the sub-directory that the Axyl library resides  */
/*              in. Also used to define user-specific stuff.            */
/*                                                                      */
/* ******************************************************************** */
/**
* THE AXYL LIBRARY DIRECTORY
*
* You can either leave this commented out, and let Axyl find it with
* the code just below, or force it here. The default is 'lib', however
* you might need to change this if it clashes with an existing directory.
*
* NOTE: This library directory must be specified as an absolute path.
*       It is usually defined as part of the Apache VirtualHost with
*       lines like:
*         SetEnv LIBDIR /path/to/axyl/lib
*/
//$LIBDIR = "/path/to/axyl/lib";
// -----------------------------------------------------------------------
// Document root is undefined for command-line scripts..
if (empty($DOCUMENT_ROOT)) {
  $DOCUMENT_ROOT = getcwd();
}
// -----------------------------------------------------------------------
/**
* AXYL LIBRARY LOCATOR
* If not defined above, sniff the Axyl library. We only allow for the
* basic possibilities, as listed in the below possibles array. These
* are relative to the website root directory.
*
*/
if (!isset($LIBDIR)) {
  $LIBDIR_POSSIBLES = array("lib", "library", "axyl");
  foreach ($LIBDIR_POSSIBLES as $testdir) {
    if (is_dir("$DOCUMENT_ROOT/$testdir")) {
      $LIBDIR = "/$testdir";
      break;
    }
  }
  // Failure is not an option..
  if (!isset($LIBDIR)) {
    die("could not locate Axyl library in document root $DOCUMENT_ROOT/");
  }
}

// -----------------------------------------------------------------------
/*
* THE RESPONSE OBJECT
* This module contains all the information, methods, and parameters
* required to co-ordinate the response to the browser request. It
* creates and initialises the $RESPONSE object from your application.xml
* configuration file.
*/
include_once("response-defs.php");

// -----------------------------------------------------------------------
/**
* USER DEFINITIONS & SETUP
* Put any other setup calls on the $RESPONSE object, etc. here. Other
* sundry setup procedures that are required 'early' should also be
* included here.
*/


// -----------------------------------------------------------------------
?>