#!/bin/sh

# Gotta have the power..
if [ $(id -u) != 0 ]
then
  echo "You must be root to run this script."
  exit 1
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# AXYL CONFIGURATION

# See if the config file is present - if so it will define
# our directories, and Axyl admin user..

# Defaults..
AXUSER=
AXYL_HOME=
AXYL_DATA=
AXYL_LOGS=
LUCENE_PORT=

CONF=/etc/axyl/axyl.conf
if [ -f $CONF ]
then
  . $CONF
  # But if they are invalid dirs, then nullify them again..
  [ ! -d $AXYL_HOME ] && AXYL_HOME=
  [ ! -d $AXYL_DATA ] && AXYL_DATA=
  [ ! -d $AXYL_LOGS ] && AXYL_LOGS=
fi

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# Find apache conf dir, trying the obvious first, then searching..
if [ -f /etc/apache/httpd.conf ]
then
  APACHE_CONFDIR=/etc/apache
else
  APACHE_CONFDIR=
  httpdfiles=`find /etc -type f -name "httpd.conf"`
  for conf in $httpdfiles; do
    APACHE_CONFDIR=`dirname $conf`
    if [ -f ${APACHE_CONFDIR}/httpd.conf ]
    then
      break
    else
      APACHE_CONFDIR=
    fi
  done
fi
APACHE_CONFDIR=${APACHE_CONFDIR:-/etc/apache}

# +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
# FUNCTIONS
# Make a directory tree, if not already made..
mkaxyldir () {
 if [ ! -d $1 ]
 then
   mkdir --verbose --parents $1
 fi
 if [ ! -d $1 ]
 then
   echo "ERROR: failed to create $1"
   echo "check permissions, and try again."
   exit 1
 fi
}

# Duplicate the contents of one directory across to
# another directory. Create destination dir if reqd.
# Removes any CVS directories.
dupedir () {
 if [ -d $1 -a "$1" != "" -a "$2" != "" ]
 then
   mkaxyldir $2
   cp -a $1/* $2
   # Remove CVS
   find $2 -depth -type d -name "CVS" -exec rm -rf {} \;
 fi
}

# Make sure we have a user in existence, or create it. We
# also make sure the assigned group is created.
# $1  - the Unix username
# $2  - the primary group
# $3  - the home directory path
# $4  - path to the login shell
# $5* - full user name
# eg: mkuser george users /home/george /bin/bash George Thing
mkuser () {
  USR=$1; shift
  GP=$1; shift
  UXUID="`grep $USR /etc/passwd | cut -d : -f 3`"
  if [ "x$UXUID" = "x" ]
  then
    HM=$1; shift
    SH=$1; shift
    NM=$*
    echo "You don't seem to have a '$USR' user account. Adding it now.."
    mkgroup $GP
    useradd -c "$NM" -d $HM -g $GP -s $SH $USR
    UXUID="`grep $USR /etc/passwd | cut -d : -f 3`"
    echo "unix user account $USR successfully added."
  else
    # Make sure group is defined..
    mkgroup $GP
  fi
}

# Make sure we have a group in existence, or create it
mkgroup () {
  UXGID=`grep "^$1" /etc/group | cut -d : -f 1`
  if [ "x$UXGID" = "x" ]
  then
    groupadd $1
    echo "unix group '$1' added."
  fi
}

# Re-writes the Axyl configuration file. Expects all the
# configuration vars to be passed, or else it does nothing.
# NB: If $5 (lucene port) is "null" it will remain blank.
# $1 - AXUSER
# $2 - AXYL_HOME
# $3 - AXYL_DATA
# $4 - AXYL_LOGS
# $5 - LUCENE_PORT
rewrite_axylconf () {
  CONF=/etc/axyl/axyl.conf
  mkaxyldir /etc/axyl
  if [ -f ${2}${CONF} ]
  then
    cp ${2}${CONF} $CONF
  else
    echo "ERROR: could not find config template ${2}${CONF}" >/dev/tty
    exit 1
  fi
  # Plug in the relevant values to the Axyl config..
  sed -e "s;_AXYL_ADMIN_USER_;$1;" $CONF > $$.tmp && mv $$.tmp $CONF
  sed -e "s;_AXYL_INSTALLATION_DIR_;$2;" $CONF > $$.tmp && mv $$.tmp $CONF
  sed -e "s;_AXYL_DATA_DIR_;$3;" $CONF > $$.tmp && mv $$.tmp $CONF
  sed -e "s;_AXYL_LOGS_DIR_;$4;" $CONF > $$.tmp && mv $$.tmp $CONF
  if [ -e ${2}/lucene -a "$5" != "null" ] ; then
    sed -e "s;^LUCENE_PORT=$;LUCENE_PORT=$5;" $CONF > $$.tmp && mv $$.tmp $CONF
  fi
  rm -f $$.tmp
}

# END
