<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    usersetup.php                                           */
/* Author:      Paul Waite                                              */
/* Description: User setup page                                         */
/*                                                                      */
/* ******************************************************************** */
include_once("application.php");

// -----------------------------------------------------------------------
// Define the webpage..
// Usage: $RESPONSE->page(title, templatename, theme, stylesheet);
$RESPONSE->page("User Setup", "maint", $theme);

// -----------------------------------------------------------------------
// Site-specific content..
include_once("site-webpage.php");
include_once("maintainer-defs.php");

//debug_on(DBG_SQL|DBG_DUMP|DBG_DIAGNOSTIC);
//debug_on(DBG_ALL);

// -----------------------------------------------------------------------
// AUTHORISATION
// No guests allowed to see content..
if (!$RESPONSE->ismemberof_group_in("Admin,Editor")) {
  $RESPONSE->send();
  exit;
}

// Pass the password entry through the standard validation. This will
// result in messages appearing on the maintainer screen if it fails.
function validate_password($password) {
  global $RESPONSE, $maint, $recmaint_user_id;

  // Initialise..
  $valid = true;
  
  // If nothing to do, leave..
  if ($password == "") {
    return true;
  }
  
  $user = new user($recmaint_user_id);
  if ($user->valid) {
    // Set us user security profile..
    $user->set_security_profile(
      $RESPONSE->passwd_encryption,
      $RESPONSE->passwd_expiry_days,
      $RESPONSE->passwd_max_attempts,
      $RESPONSE->passwd_history_cycle,
      $RESPONSE->passwd_delay_ms,
      $RESPONSE->passwd_min_chars,
      $RESPONSE->passwd_char_uniqueness,
      $RESPONSE->passwd_alphanum_mixed,
      $RESPONSE->passwd_apply_stopwords
      );
    $old_password = $user->password;
    $user->set_password($password);
    if ($user->password == $old_password) {
      $maint->msgs[] = "Please choose a DIFFERENT password from the old one!";
      $valid = false;
    }
    else {
      $valid = $user->valid_password($password, $maint->msgs);
      if ($valid) {
        $user->save_password_data();
      }
    }
  }
  return $valid;
}

// MAINTAINER DEFINITION
$maint = new maintainer("Users", "ax_user");
$maint->set_passwd_encryption($RESPONSE->passwd_encryption);
$maint->setalign("center");
$maint->view_primary_keys();
$maint->view_passwords();

// Various field settings..
$maint->set_datetimeformat("last_login", SHORT_DATETIME);
$maint->set_nonblankfields("full_name,email");

// Special form widgets..
$utype = new form_combofield("user_type", "User type");
$utype->setclass("axcombo");
$utype->additem("user", "Standard user");
$utype->additem("sys", "System engineer");
$maint->set_formfieldwidget("user_type", $utype);

// Field labels..
$maint->set_fieldlabel("passwd_forever", "Password never expires");
$maint->set_fieldlabel("passwd_failures", "Password failures");
$maint->set_fieldlabel("locked", "Account locked");

// Password field(s)..
$maint->set_fieldsize("password", 200);
$maint->set_fieldtexttype("password", "password");
$maint->set_fieldvalidationproc("password", "validate_password", "Password failed validation.");

// Field size settings..
$maint->set_fieldsize("limit_logins", 50);
$maint->set_fieldsize("honorific_prefix", 50);

// View-only, Omitted and Hidden fields..
$maint->set_viewonlyfields("auth_code,last_login,total_logins,passwd_failures");
$maint->set_omittedfields("passwd_expiry,passwd_history");
if ($RESPONSE->user_type != "sys") {
  $maint->set_viewonlyfields("user_type");
}

// The Guest User normally needs a bit of special protection against
// inadvertent disabling, locking etc. 
if ($bevent != "add" && $recmaint_user_id == "guest") {
  $maint->set_hiddenfields(
        "org_id," .
        "password," .
        "honorific_prefix," .
        "first_name," .
        "mid_names," .
        "last_name," .
        "email," .
        "address," .
        "phone," .
        "fax," .
        "mobile," .
        "limit_logins," .
        "passwd_forever," .
        "passwd_failures," .
        "locked," .
        "enabled"
        );
  $maint->set_hiddenbuttons("remove");
}
else {
  // GROUPS MAINTENANCE
  $maint->linked_table("Group Membership", "ax_group", "ax_user_group", "checkbox");

  // IP ADDRESS MAINTENANCE
  $ip_head = "User IPs"
  . "<p><span class=axfg>"
  . "Enter IP addresses for either single hosts or networks. "
  . "with each address on a separate line. "
  . "A host is a full address like this: 204.13.223.3. A Class C "
  . "network of machines can be entered short-hand like this: 204.13.223 or like "
  . "this: 204.13.223.0, or properly, like this: 204.13.223.0/24. When you save "
  . "the list, the system will re-format your entries"
  . "</span></p>";
  $maint->detail_table($ip_head, "ax_user_ip", "", 300);
  $maint->set_fieldpostproc("ip", "ip_format");
  $maint->set_labelfields("ax_user_ip", "ip");
}

// -----------------------------------------------------------------------
// Plug it in
$RESPONSE->plugin("MAIN_CONTENT", $maint->render());

// -----------------------------------------------------------------------
// DELIVER..
$RESPONSE->send();
?>