#!/usr/bin/php -q
<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    iso3166-import.php                                      */
/* Author:      Paul Waite                                              */
/* Description: Importer for country codes defined by ISO3166.          */
/*                                                                      */
/*              The source file is expected to be an ASCII content file */
/*              with data delimited by semi-colon ";" per the following */
/*              example:   AUSTRALIA;AU                                 */
/*                                                                      */
/*              Field 1: Country label/name                             */
/*              Field 2: 2-char code                                    */
/*                                                                      */
/*       usage: ./iso3166-import.php [--verbose] [--file=datafile]      */
/*                                                                      */
/*              --verbose  Shows detailed messages on import process    */
/*              --file     Over-ride import data dilename. Normally     */
/*                         this is taken from the ISO3166 data source   */
/*                         URL in the database.                         */
/*                                                                      */
/* ******************************************************************** */
// In older versions of Php CLI Program working dir is always its
// own directory so we need to get into the website root directory..
if (PHP_VERSION < 4.2) {
  chdir("..");
}
include("application.php");
include_once("optlist-defs.php");

$verbose = false;
$ISO3166_DATA_FILE = "";
$ISO3166_DATA_URL = "";
$opts = new optlist();
$PROGNAME = $opts->progname;
if ($opts->optcount > 0) {
  // Debugging..
  if ($opts->opt_exists("verbose")) {
    debug_on(DBG_DEBUG);
  }
  if ($opts->opt_exists("file")) {
    $ISO3166_DATA_FILE = $opts->opt_value("file");
  }
}

// Ascertain ISO3166 Record ID
$q = "SELECT * FROM ax_enc_scheme WHERE enc_scheme_name='ISO3166'";
$sch = dbrecordset($q);
if ($sch->rowcount == 1) {
  $iso3166_id = $sch->field("enc_scheme_id");
  $ISO3166_DATA_URL = $sch->field("datasrc_uri");
  if ($iso3166_id != "") {
    debugbr("ISO3166-1 encoding scheme ID: $iso3166_id", DBG_DEBUG);
  }
}
else {
  echo "Error: failed to find unique ISO3166 record in 'ax_enc_scheme'\n";
  exit;
}

// Try to get the latest file
if ($ISO3166_DATA_URL != "") {
  $urlbits = parse_url($ISO3166_DATA_URL);
  if ($ISO3166_DATA_FILE == "") {
    $ISO3166_DATA_FILE = basename($urlbits["path"]);
  }
  if (file_exists($ISO3166_DATA_FILE)) {
    unlink($ISO3166_DATA_FILE);
  }
  debugbr("data will be downloaded from $ISO3166_DATA_URL", DBG_DEBUG);
  debugbr("destination data file is $ISO3166_DATA_FILE", DBG_DEBUG);
  exec("wget $ISO3166_DATA_URL -O $ISO3166_DATA_FILE");
}
else {
  debugbr("Warning: no data source URL, so no download.", DBG_DEBUG);
}


debugbr("deleting current set of country codes..", DBG_DEBUG);
$del = new dbdelete("ax_enc_value");
$del->where("enc_scheme_id=$iso3166_id");
$del->execute();

debugbr("loading new country codes..", DBG_DEBUG);
$countryF = new csv_inputfile($ISO3166_DATA_FILE);
if ($countryF->opened) {
  $lineno = 0;
  while (!$countryF->eof()) {
    $fields = $countryF->readln(";");
    if (count($fields) ==2) {
      $lineno += 1;
      $country_label = trim($fields[0]);
      $country_code = trim($fields[1]);

      $q  = "SELECT * FROM ax_enc_value";
      $q .= " WHERE enc_scheme_id=$iso3166_id";
      $q .= "   AND enc_value='$country_code'";
      $existing = dbrecordset($q);
      if ($existing->hasdata) {
        $countryQ = new dbupdate("ax_enc_value");
        $existing_label = $existing->field("enc_label");
        if (!strstr($existing_label, $country_label)) {
          $country_label = $existing_label . "/" . $country_label;
          $countryQ->set("enc_label", $country_label);
          $countryQ->where("enc_scheme_id=$iso3166_id");
          $countryQ->where("AND enc_value='$country_code'");
          $countryQ->execute();
        }
      }
      else {
        $countryin = new dbinsert("ax_enc_value");
        $countryin->set("enc_scheme_id", $iso3166_id);
        $countryin->set("enc_value", $country_code);
        $countryin->set("enc_label", $country_label);
        $countryin->execute();
      }
      debugbr("ISO3166: $country_label ($country_code)", DBG_DEBUG);
    }
  } // while
}
else {
  echo "failed to open $ISO3166_DATA_FILE\n";
  exit;
}

// Close the file..
$countryF->closefile();
debugbr("finished.", DBG_DEBUG);
?>