#! /bin/sh
#
# Restart or re-load Apache process
# P Waite
set -e

# Name of this script
THIS=`basename $0`

# Gotta have the power..
if [ $(id -u) != 0 ]
then
  echo "$THIS: You must be root to run this script."
  exit 2
fi

# Must have all parms for this..
if [ $# -lt 1 ]
then
  echo "usage: $THIS restart|reload"
  exit 3
fi

INITMODE=$1
if [ "$INITMODE" != "restart" -a "$INITMODE" != "reload" ]
then
  INITMODE=restart
fi

# Restart apache..
if [ -x /etc/init.d/apache ] ; then
  /etc/init.d/apache $INITMODE >/dev/null 2>&1
fi
if [ -x /etc/init.d/apache-perl ] ; then
  /etc/init.d/apache-perl $INITMODE >/dev/null 2>&1
fi
if [ -x /etc/init.d/apache-ssl ] ; then
  /etc/init.d/apache-ssl $INITMODE >/dev/null 2>&1
fi

# END