<?php
/* ******************************************************************** */
/* CATALYST PHP Source Code                                             */
/* -------------------------------------------------------------------- */
/* This program is free software; you can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License, or    */
/* (at your option) any later version.                                  */
/*                                                                      */
/* This program is distributed in the hope that it will be useful,      */
/* but WITHOUT ANY WARRANTY; without even the implied warranty of       */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        */
/* GNU General Public License for more details.                         */
/*                                                                      */
/* You should have received a copy of the GNU General Public License    */
/* along with this program; if not, write to:                           */
/*   The Free Software Foundation, Inc., 59 Temple Place, Suite 330,    */
/*   Boston, MA  02111-1307  USA                                        */
/* -------------------------------------------------------------------- */
/*                                                                      */
/* Filename:    wap-diags.php                                           */
/* Author:      Paul Waite                                              */
/* Date:        March 2003                                              */
/* Description: This page is a private one for sending phone data       */
/*              to identify phone characteristics more easily.          */
/*                                                                      */
/************************************************************************/
include_once("application.php");
include_once("mail-defs.php");

// DIAGS CARD
$RESPONSE->card("Phone Diagnostics", "index");

if ($WEBMASTER_EMAIL != "") {
  $CARD->insert_para(
    "Thank you! A diagnostic e-mail of data on your phone has been sent " .
    "to $WEBMASTER_EMAIL"
    );
  
  $body  = "User: $RESPONSE->name\r\n\r\n";
  $body .= "User agent: " . $RESPONSE->user_agent . "\r\n\r\n";
  $body .= "Accept: " . wordwrap($RESPONSE->accept, 70, "\r\n", true) . "\r\n\r\n";
  $body .= "Browser type: " . $RESPONSE->browser_type . "\r\n\r\n";
  $body .= "Browser make: " . $RESPONSE->browser . "\r\n\r\n";
  $body .= "Remote Address: " . $RESPONSE->remote_address . "\r\n";
  
  $CARD->insert_para(
    "Axyl detection: $RESPONSE->browser ($RESPONSE->browser_type)"
    );
  $to = $WEBMASTER_EMAIL;
  $from = $RESPONSE->email;
  if ($from == "") $from = APP_PREFIX . "@axyl.org";
  $diag = new email($from, $to, "Phone Diagnostics", $body);
  $diag->send();
}

if ($RESPONSE->ismemberof_group("Guest")) {
  $loginlink = new Link("/wap-login.php", "Login..");
  $CARD->insert_para($loginlink->render());
}
else {
  if ($RESPONSE->ismemberof_group("Guest")) {
    $CARD->insert_para(
      "You are currently logged in as a Guest."
      );
  }
  else {
    $CARD->insert_para(
      "You are currently logged in as '$RESPONSE->name'."
      );
  }
  $homelink = new Link("/wap-index.php", APP_NAME . " Home");
  $CARD->insert_para($homelink->render());
  $CARD->insert_go("home", "Home", "/wap-index.php");
}

//-----------------------------------------------------------------------
// Plug it in
$RESPONSE->plugin("MAIN_CONTENT", $CARD->render());

//-----------------------------------------------------------------------
// Deliver it..
$RESPONSE->send();
?>