/*
 * LuceneDataSource.java
 *
 * See package.html for licence.
 * 
 * Created on 2002. j?lius 14., 15:33
 */

package nz.net.catalyst.lucene.cache;

import java.io.IOException;

import org.apache.lucene.search.Searcher; 

/**
 * The searcher source is responsible to create different <code>Searcher</code>
 * objects. The design of the interface is very similar to <code>DataSource</code>
 * in the javax.sql package. Implementing classes encapsulates the configuration
 * and managing logic.
 *
 * @author  Peter Halacsy
 */
public interface SearcherSource {
    /** Returns a Searcher that can directly used by the caller. The caller is
     * responsible to close the Searcher after using it.
     * @throws IOException if the searcher can't be opened
     * @return A searcher object to be used by the caller.
     */
    public Searcher getSearcher(int maxSearchers) throws IOException;
}
