/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import nz.net.catalyst.lucene.server.Backup;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.EXPERIMENTAL;
import nz.net.catalyst.lucene.server.GarbageCollect;
import nz.net.catalyst.lucene.server.HealthCheck;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Optimize;
import nz.net.catalyst.lucene.server.Transmission;

public class Control
implements IPackage,
Constants {
    private final Transmission input;

    Control(Transmission transmission) {
        this.input = transmission;
    }

    Transmission execute() {
        Transmission response;
        String subCommand = this.input.get("Sub-Command", NO_APP);
        if ("APPLICATION".equalsIgnoreCase(subCommand)) {
            response = this.application();
        } else if ("GC".equalsIgnoreCase(subCommand)) {
            response = this.gc();
        } else if ("OPTIMIZE".equalsIgnoreCase(subCommand)) {
            response = this.optimize();
        } else if ("BACKUP".equalsIgnoreCase(subCommand)) {
            response = this.backup();
        } else if ("HEALTHCHECK".equalsIgnoreCase(subCommand)) {
            response = this.healthcheck();
        } else if (subCommand.equalsIgnoreCase("EXPERIMENTAL")) {
            response = this.experimentalCommand();
        } else {
            response = new Transmission(ECommand.CONTROL_RESPONSE);
            response.setSerial(this.input.getSerial());
            if (subCommand == null) {
                response.add("Error", "\"Sub-Command\" header required.");
            } else {
                response.add("Error", "\" Unrecognised \"Sub-Command\" header in: " + subCommand);
            }
        }
        return response;
    }

    private Transmission application() {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", "Application sub-command no longer supported.");
        response.add("Error", "Please consult the System Administrator to edit the server configuration file");
        return response;
    }

    private Transmission optimize() {
        Optimize optimize = new Optimize(this.input);
        return optimize.execute();
    }

    private Transmission backup() {
        Backup backup = new Backup(this.input);
        return backup.execute();
    }

    private Transmission healthcheck() {
        HealthCheck healthcheck = new HealthCheck(this.input);
        return healthcheck.execute();
    }

    private Transmission gc() {
        GarbageCollect gc = new GarbageCollect(this.input);
        return gc.execute();
    }

    private Transmission experimentalCommand() {
        EXPERIMENTAL expCommand = new EXPERIMENTAL(this.input);
        return expCommand.execute();
    }
}

