/*
 * Decompiled with CFR 0.152.
 */
package nz.net.catalyst.lucene.server;

import nz.net.catalyst.ELog;
import nz.net.catalyst.Log;
import nz.net.catalyst.lucene.server.Constants;
import nz.net.catalyst.lucene.server.ECommand;
import nz.net.catalyst.lucene.server.IPackage;
import nz.net.catalyst.lucene.server.Transmission;

class GarbageCollect
implements IPackage,
Constants {
    private final Transmission input;

    GarbageCollect(Transmission transmission) {
        this.input = transmission;
    }

    Transmission execute() {
        String shutdown = this.input.get("Action", NO_APP);
        if (shutdown != null && shutdown.trim().equalsIgnoreCase("shutdown")) {
            System.err.println("About to shutdown lucene server");
            System.out.println("About to shutdown lucene server");
            System.exit(0);
        }
        long tStart = System.currentTimeMillis();
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        Runtime r = Runtime.getRuntime();
        response.add("INFO", "Free memory before: " + r.freeMemory());
        Log.log(ELog.NOTICE, "About to perform system garbage collection and finalization.");
        Log.log(ELog.NOTICE, "Free memory before gc: " + r.freeMemory());
        r.gc();
        r.runFinalization();
        response.add("INFO", "Garbage Collection Suggested to JVM");
        response.add("INFO", "Running of finalizers suggested to JVM");
        response.add("INFO", "Free memory after: " + r.freeMemory());
        Log.log(ELog.NOTICE, "Free memory after gc: " + r.freeMemory());
        response.add("Timer:total time", String.valueOf(System.currentTimeMillis() - tStart));
        return response;
    }

    private Transmission error(String message) {
        Transmission response = new Transmission(ECommand.CONTROL_RESPONSE);
        response.setSerial(this.input.getSerial());
        response.add("Error", message);
        return response;
    }
}

