# Arch Perl library, Copyright (C) 2004 Mikhael Goikhman
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use 5.005;
use strict;

package AXP::Command::self::doc;
use base 'AXP::Command::self';

use Arch::Util qw(load_file);

sub optusage {
	my $self = shift;
	return $self->SUPER::optusage if ref($self) eq __PACKAGE__;

	"[options] docdir"
}

sub infoline {
	"automatically create web pages for documentation"
}

sub options {
	(
		template => { sh => 't', type => "=s", arg => 'FILE', desc => "use the FILE as a template" },
	)
}

sub escape_html ($) {
	my $self = shift;
	my $html = shift;

	$html =~ s/&/&amp;/g;
	$html =~ s/>/&gt;/g;
	$html =~ s/</&lt;/g;
	return $html;
}

sub _execute {
	my $self = shift;
	my %opt = %{$self->{options}};

	$self->{docdir} = shift @ARGV || die "No directory is given\n";
	$self->{template} = $opt{template}?
		load_file($opt{template}): $self->default_template;
}

1;
