/*
Copyright (C) 2000-2001 Jos Roberto B. de A. Monteiro <jrm@autsens.com>
                        and Pedro Zorzenon Neto <pzn@autsens.com>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

#include "avrpp.h"
#define extern
#include <sys/io.h>
#undef extern
#include <stdlib.h>

/* begin of reg_pp functions */
struct reg_pp * rpp_new() {
  return (struct reg_pp *) malloc(sizeof(struct reg_pp));
}

struct reg_pp * rpp_init(struct reg_pp * reg,
			 unsigned short base, int offset, int row) {
  reg->base=base;
  reg->offset=offset;
  reg->row=row;
  return reg;
}

void rpp_delete(struct reg_pp * reg) {
  if (reg) free(reg);
}

void rpp_set(struct reg_pp * reg) {
  unsigned char data;
  unsigned short addr;
  addr = reg->base + reg->offset;
  data = inb(addr);
  data |= 1<<reg->row;
  outb(data, addr);
  //  printf("set 0x%x=0x%x (%d,%d)\n", addr, data, reg->offset, reg->row);
}

void rpp_clear(struct reg_pp * reg) {
  unsigned char data;
  unsigned short addr;
  addr = reg->base + reg->offset;
  data = inb(addr);
  data &= ~(1<<reg->row);
  outb(data, addr);
  //  printf("clr 0x%x=0x%x (%d,%d)\n", addr, data, reg->offset, reg->row);
}

unsigned char rpp_read(struct reg_pp * reg) {
  unsigned char data;
  unsigned short addr;
  addr = reg->base + reg->offset;
  data = inb(addr);
  data >>= reg->row;
  data &= 1;
  return data;
}

void rpp_write(struct reg_pp * reg, int val) {
  if (val)
    rpp_set(reg);
  else
    rpp_clear(reg);
}

/* end of reg_pp functions */

/* begin of avr_serial_pp functions */

ASPP * aspp_new() {
  return (ASPP *) malloc(sizeof(ASPP));
}

ASPP * aspp_init(ASPP *aspp, unsigned short base) {
  aspp->NSCK=rpp_init(rpp_new(), base, 2, 0);
  aspp->NMISO=rpp_init(rpp_new(), base, 1, 7);
  aspp->MOSI=rpp_init(rpp_new(), base, 0, 0);
  aspp->RESET=rpp_init(rpp_new(), base, 2, 2);
  return aspp;
}

void aspp_delete(ASPP *aspp) {
  rpp_delete(aspp->NSCK);
  rpp_delete(aspp->NMISO);
  rpp_delete(aspp->MOSI);
  rpp_delete(aspp->RESET);
  free(aspp);
}

void aspp_SCK(ASPP *aspp, int data) {
  rpp_write(aspp->NSCK, !data);
}

int aspp_MISO(ASPP *aspp) {
  return ! rpp_read(aspp->NMISO);
}

void aspp_MOSI(ASPP *aspp, int data) {
  rpp_write(aspp->MOSI, data);
}

void aspp_RESET(ASPP *aspp, int data) {
  rpp_write(aspp->RESET, data);
}

/* end of avr_serial_pp functions */
