/* Test of tan() function. 500 random cases.
   $Id: tan-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x;		/* argument	*/
    long z;		/* tan(x)	*/
} t[] = {

    /* x, tan(x)	*/
    { 0xbfc768db,0xc29aec61 }, /*   1: -1.5578874e+00 -7.7461678e+01 */
    { 0x3efd97ab,0x3f0a4b5e }, /*   2:  4.9529776e-01  5.4021251e-01 */
    { 0xc0991de2,0x415c46a5 }, /*   3: -4.7848978e+00  1.3767247e+01 */
    { 0x3ecd2c71,0x3ed8e920 }, /*   4:  4.0072969e-01  4.2365360e-01 */
    { 0x3da705de,0x3da764ea }, /*   5:  8.1554160e-02  8.1735447e-02 */
    { 0xbedd5970,0xbeec414a }, /*   6: -4.3232298e-01 -4.6143562e-01 */
    { 0x3ef58253,0x3f051df1 }, /*   7:  4.7950992e-01  5.1998812e-01 */
    { 0x40411375,0xbe00712f }, /*   8:  3.0168126e+00 -1.2543176e-01 */
    { 0xbc8567c1,0xbc856ac6 }, /*   9: -1.6284825e-02 -1.6286265e-02 */
    { 0xbfa6f0a8,0xc06a5dd6 }, /*  10: -1.3042192e+00 -3.6619773e+00 */
    { 0xbfa18d47,0xc048b65d }, /*  11: -1.2621239e+00 -3.1361306e+00 */
    { 0x3c99abcd,0x3c99b06a }, /*  12:  1.8758679e-02  1.8760879e-02 */
    { 0x3f9a967a,0x4028749a }, /*  13:  1.2077172e+00  2.6321168e+00 */
    { 0xbf288299,0xbf45f689 }, /*  14: -6.5824276e-01 -7.7329308e-01 */
    { 0xbfd187d2,0x41717b27 }, /*  15: -1.6369574e+00  1.5092566e+01 */
    { 0x403ec5cb,0xbe260fe1 }, /*  16:  2.9808223e+00 -1.6216995e-01 */
    { 0x3fd5d75d,0xc11fb9d6 }, /*  17:  1.6706349e+00 -9.9828701e+00 */
    { 0x3fe6bd28,0xc087899c }, /*  18:  1.8026476e+00 -4.2355480e+00 */
    { 0x3f5b3a26,0x3f939689 }, /*  19:  8.5635602e-01  1.1530315e+00 */
    { 0x3ed7620f,0x3ee50e85 }, /*  20:  4.2067000e-01  4.4737640e-01 */
    { 0x3fa0e9e9,0x40454eea }, /*  21:  1.2571384e+00  3.0829415e+00 */
    { 0xc0265ace,0x3f1a416e }, /*  22: -2.5992923e+00  6.0256088e-01 */
    { 0x3f30028c,0x3f523a9d }, /*  23:  6.8753886e-01  8.2120687e-01 */
    { 0x3e0161d7,0x3e02133a }, /*  24:  1.2634979e-01  1.2702647e-01 */
    { 0x3ed48f75,0x3ee1ad6b }, /*  25:  4.1515699e-01  4.4077620e-01 */
    { 0x3ec8a9a0,0x3ed39c12 }, /*  26:  3.9191914e-01  4.1330010e-01 */
    { 0xbf9065db,0xc007006a }, /*  27: -1.1281084e+00 -2.1094003e+00 */
    { 0xbf5a7762,0xbf92b475 }, /*  28: -8.5338414e-01 -1.1461321e+00 */
    { 0x3f8b8707,0x3ff56c2f }, /*  29:  1.0900582e+00  1.9173640e+00 */
    { 0xbdb3546f,0xbdb3ca20 }, /*  30: -8.7563388e-02 -8.7787867e-02 */
    { 0x3c97b660,0x3c97bad1 }, /*  31:  1.8519580e-02  1.8521698e-02 */
    { 0xbf9f07f3,0xc03bd92a }, /*  32: -1.2424301e+00 -2.9351296e+00 */
    { 0xbf5f1c20,0xbf9830f5 }, /*  33: -8.7152290e-01 -1.1889941e+00 */
    { 0x3c8ba75b,0x3c8baad2 }, /*  34:  1.7047575e-02  1.7049227e-02 */
    { 0x3d4fbdaf,0x3d4feb55 }, /*  35:  5.0718006e-02  5.0761539e-02 */
    { 0xc01192ce,0x3f96cdb9 }, /*  36: -2.2745852e+00  1.1781532e+00 */
    { 0x3f5b74ea,0x3f93db0d }, /*  37:  8.5725272e-01  1.1551224e+00 */
    { 0x3fd53c21,0xc127bc01 }, /*  38:  1.6658975e+00 -1.0483399e+01 */
    { 0x3d7d85e4,0x3d7dd8e6 }, /*  39:  6.1895266e-02  6.1974429e-02 */
    { 0xbeeedda6,0xbf00ecdc }, /*  40: -4.6653479e-01 -5.0361419e-01 */
    { 0xbf83babd,0xbfd4bc16 }, /*  41: -1.0291363e+00 -1.6619899e+00 */
    { 0x3f2c6adc,0x3f4c4827 }, /*  42:  6.7350554e-01  7.9797596e-01 */
    { 0x3f8375dc,0x3fd3b9da }, /*  43:  1.0270343e+00  1.6541092e+00 */
    { 0xc0566d3b,0xbe58ffe0 }, /*  44: -3.3504169e+00 -2.1191359e-01 */
    { 0xbedb9a5f,0xbeea23e1 }, /*  45: -4.2891213e-01 -4.5730498e-01 */
    { 0x3b001e69,0x3b001e74 }, /*  46:  1.9549376e-03  1.9549401e-03 */
    { 0x3e6e4e32,0x3e72b3ed }, /*  47:  2.3272017e-01  2.3701449e-01 */
    { 0xbee360d2,0xbef39b9b }, /*  48: -4.4409806e-01 -4.7579655e-01 */
    { 0x3deafa13,0x3dec036e }, /*  49:  1.1473479e-01  1.1524092e-01 */
    { 0xbe91b658,0xbe95c72a }, /*  50: -2.8459430e-01 -2.9253513e-01 */
    { 0xbf2e7e2f,0xbf4fb37d }, /*  51: -6.8161291e-01 -8.1133252e-01 */
    { 0xc014793b,0x3f89a55a }, /*  52: -2.3198993e+00  1.0753586e+00 */
    { 0x3effe532,0x3f0bc914 }, /*  53:  4.9979550e-01  5.4603696e-01 */
    { 0x3f4fbd9a,0x3f86dbf5 }, /*  54:  8.1148684e-01  1.0535876e+00 */
    { 0xbf2d6676,0xbf4de53b }, /*  55: -6.7734468e-01 -8.0427903e-01 */
    { 0x3f8c6e60,0x3ff9b4e5 }, /*  56:  1.0971184e+00  1.9508330e+00 */
    { 0x3f1fc3a0,0x3f385776 }, /*  57:  6.2407875e-01  7.2008455e-01 */
    { 0x3f53b55c,0x3f8b1d7c }, /*  58:  8.2698607e-01  1.0868373e+00 */
    { 0xbf576e77,0xbf8f3db8 }, /*  59: -8.4152931e-01 -1.1190710e+00 */
    { 0xbfabe673,0xc08a04f9 }, /*  60: -1.3429703e+00 -4.3131070e+00 */
    { 0x3fc48a79,0x41e26740 }, /*  61:  1.5354759e+00  2.8300415e+01 */
    { 0x3f523c4c,0x3f8984cf }, /*  62:  8.2123256e-01  1.0743655e+00 */
    { 0xbf5e3c6e,0xbf972415 }, /*  63: -8.6810958e-01 -1.1807886e+00 */
    { 0xbebfee31,0xbec974db }, /*  64: -3.7486413e-01 -3.9346966e-01 */
    { 0x3ee075a1,0x3ef009bc }, /*  65:  4.3839744e-01  4.6882427e-01 */
    { 0xbf26a83b,0xbf4304b6 }, /*  66: -6.5100449e-01 -7.6179063e-01 */
    { 0xbf2bc70b,0xbf4b3c8e }, /*  67: -6.7100590e-01 -7.9389274e-01 */
    { 0xbed9f87a,0xbee82b54 }, /*  68: -4.2572385e-01 -4.5345557e-01 */
    { 0x3e6c5921,0x3e70a2f4 }, /*  69:  2.3080875e-01  2.3499662e-01 */
    { 0x3f3010ac,0x3f525245 }, /*  70:  6.8775439e-01  8.2156783e-01 */
    { 0xbfc63316,0xc232d7b5 }, /*  71: -1.5484340e+00 -4.4710651e+01 */
    { 0x3f2a24ee,0x3f489659 }, /*  72:  6.6462600e-01  7.8354412e-01 */
    { 0x3fc2f4a3,0x41a79164 }, /*  73:  1.5230907e+00  2.0945992e+01 */
    { 0xbf2deb6c,0xbf4ec08f }, /*  74: -6.7937350e-01 -8.0762571e-01 */
    { 0xbdbf004e,0xbdbf8e90 }, /*  75: -9.3262300e-02 -9.3533635e-02 */
    { 0x3f2a4f84,0x3f48db1d }, /*  76:  6.6527581e-01  7.8459340e-01 */
    { 0x3f997537,0x402413f9 }, /*  77:  1.1988896e+00  2.5637190e+00 */
    { 0xc02f6435,0x3ed9229e }, /*  78: -2.7404912e+00  4.2409223e-01 */
    { 0xbf50610b,0xbf8788d8 }, /*  79: -8.1398076e-01 -1.0588636e+00 */
    { 0xbd5e94c5,0xbd5eccec }, /*  80: -5.4341096e-02 -5.4394647e-02 */
    { 0x3fbec7a1,0x4146c07e }, /*  81:  1.4904672e+00  1.2421995e+01 */
    { 0x3f544836,0x3f8bbe08 }, /*  82:  8.2922685e-01  1.0917368e+00 */
    { 0x3f7c63ae,0x3fc14bed }, /*  83:  9.8589599e-01  1.5101296e+00 */
    { 0x3f8605a2,0x3fdda01a }, /*  84:  1.0470469e+00  1.7314484e+00 */
    { 0x3f524af7,0x3f89949c }, /*  85:  8.2145637e-01  1.0748477e+00 */
    { 0xbfa140d6,0xc0471b3c }, /*  86: -1.2597911e+00 -3.1110373e+00 */
    { 0x3fa0a8ad,0x4043fa60 }, /*  87:  1.2551476e+00  3.0621567e+00 */
    { 0xbf97fc59,0xc01ea9d7 }, /*  88: -1.1873885e+00 -2.4791162e+00 */
    { 0xbdea5c26,0xbdeb6369 }, /*  89: -1.1443357e-01 -1.1493570e-01 */
    { 0x3e6f7901,0x3e73ef9b }, /*  90:  2.3386003e-01  2.3821871e-01 */
    { 0x3ee707cb,0x3ef81a2a }, /*  91:  4.5123133e-01  4.8457462e-01 */
    { 0x3fb51ce5,0x40cba868 }, /*  92:  1.4149443e+00  6.3643074e+00 */
    { 0xbf245171,0xbf3f58f1 }, /*  93: -6.4186770e-01 -7.4745089e-01 */
    { 0xbf85b48c,0xbfdc5d4f }, /*  94: -1.0445724e+00 -1.7215976e+00 */
    { 0xbf7fdddf,0xbfc71ebb }, /*  95: -9.9947923e-01 -1.5556253e+00 */
    { 0x3ffe87e1,0xc010319e }, /*  96:  1.9885217e+00 -2.2530284e+00 */
    { 0xbf314510,0xbf5458d3 }, /*  97: -6.9246006e-01 -8.2948035e-01 */
    { 0x3f05c8e9,0x3f1375bb }, /*  98:  5.2259690e-01  5.7601517e-01 */
    { 0xbe0d3abd,0xbe0e21bd }, /*  99: -1.3791938e-01 -1.3880058e-01 */
    { 0x3f47bcfe,0x3f7d5dc2 }, /* 100:  7.8022754e-01  9.8971188e-01 */
    { 0xbf5d8df6,0xbf9653df }, /* 101: -8.6544740e-01 -1.1744345e+00 */
    { 0x3e531833,0x3e5622f3 }, /* 102:  2.0614700e-01  2.0911770e-01 */
    { 0x3ff1ef02,0xc04192cb }, /* 103:  1.8901064e+00 -3.0245845e+00 */
    { 0x3eedc159,0x3f003ada }, /* 104:  4.6436575e-01  5.0089800e-01 */
    { 0x3f2824cb,0x3f4560cd }, /* 105:  6.5681142e-01  7.7100831e-01 */
    { 0x3f2fd0f4,0x3f51e7a0 }, /* 106:  6.8678212e-01  8.1994057e-01 */
    { 0xbf8ad633,0xbff239bf }, /* 107: -1.0846618e+00 -1.8923873e+00 */
    { 0xbeae090b,0xbeb51022 }, /* 108: -3.3991274e-01 -3.5363871e-01 */
    { 0x3ef1b23c,0x3f02b450 }, /* 109:  4.7206295e-01  5.1056385e-01 */
    { 0x3fb2af9b,0x40b52f5e }, /* 110:  1.3959841e+00  5.6620321e+00 */
    { 0xbe49f1f7,0xbe4c9ac8 }, /* 111: -1.9721209e-01 -1.9980919e-01 */
    { 0x3f2fea83,0x3f521262 }, /* 112:  6.8717211e-01  8.2059300e-01 */
    { 0x3ef3365b,0x3f03a955 }, /* 113:  4.7502407e-01  5.1430255e-01 */
    { 0xbec86228,0xbed34869 }, /* 114: -3.9137387e-01 -4.1266182e-01 */
    { 0x3f4c1681,0x3f830ff4 }, /* 115:  7.9721838e-01  1.0239244e+00 */
    { 0x3f5b6c88,0x3f93d145 }, /* 116:  8.5712481e-01  1.1548239e+00 */
    { 0xbee358b6,0xbef391a9 }, /* 117: -4.4403619e-01 -4.7572067e-01 */
    { 0x3ef16393,0x3f0282bf }, /* 118:  4.7146282e-01  5.0980753e-01 */
    { 0x3f1db5a9,0x3f353d59 }, /* 119:  6.1605316e-01  7.0796734e-01 */
    { 0x3ee8b05f,0x3efa2744 }, /* 120:  4.5447060e-01  4.8858082e-01 */
    { 0xbefc0202,0xbf0945c8 }, /* 121: -4.9220282e-01 -5.3622103e-01 */
    { 0xbfa82ff0,0xc073af78 }, /* 122: -1.3139629e+00 -3.8075848e+00 */
    { 0x3f230311,0x3f3d51bc }, /* 123:  6.3676554e-01  7.3952842e-01 */
    { 0xbf59b25a,0xbf91d150 }, /* 124: -8.5037768e-01 -1.1392002e+00 */
    { 0x3eaeec2b,0x3eb60fd2 }, /* 125:  3.4164557e-01  3.5558945e-01 */
    { 0xbec8bee5,0xbed3b4f9 }, /* 126: -3.9208141e-01 -4.1349009e-01 */
    { 0x3ff3545e,0xc03ab75d }, /* 127:  1.9010122e+00 -2.9174416e+00 */
    { 0xbfa02fae,0xc0418d9d }, /* 128: -1.2514551e+00 -3.0242684e+00 */
    { 0x3ea95bca,0x3eafd173 }, /* 129:  3.3077842e-01  3.4339485e-01 */
    { 0x3f20965f,0x3f39983b }, /* 130:  6.2729448e-01  7.2497910e-01 */
    { 0x3f2575d8,0x3f41223c }, /* 131:  6.4632940e-01  7.5442863e-01 */
    { 0xbfaaffe2,0xc085bc4c }, /* 132: -1.3359339e+00 -4.1792355e+00 */
    { 0x3f245cba,0x3f3f6a89 }, /* 133:  6.4203990e-01  7.4771935e-01 */
    { 0x3f217871,0x3f3af1fd }, /* 134:  6.3074404e-01  7.3025495e-01 */
    { 0x3ea2d618,0x3ea88ee5 }, /* 135:  3.1803966e-01  3.2921520e-01 */
    { 0x3f2cad32,0x3f4cb4d1 }, /* 136:  6.7451775e-01  7.9963404e-01 */
    { 0xbf4df0a5,0xbf84f935 }, /* 137: -8.0445319e-01 -1.0388552e+00 */
    { 0xbd7189e0,0xbd71d1a6 }, /* 138: -5.8969378e-02 -5.9037827e-02 */
    { 0xbea31548,0xbea8d4f1 }, /* 139: -3.1852174e-01 -3.2974961e-01 */
    { 0x3fb0c7bd,0x40a6a889 }, /* 140:  1.3810955e+00  5.2080731e+00 */
    { 0x4113534c,0xbe61b34a }, /* 141:  9.2078362e+00 -2.2041050e-01 */
    { 0x3f2eeb14,0x3f50684e }, /* 142:  6.8327451e-01  8.1409156e-01 */
    { 0x3e1046a9,0x3e113d04 }, /* 143:  1.4089455e-01  1.4183432e-01 */
    { 0xbfdd5fca,0x40c7f4ca }, /* 144: -1.7294858e+00  6.2486315e+00 */
    { 0x3fb0f993,0x40a809bb }, /* 145:  1.3826164e+00  5.2511878e+00 */
    { 0x3e06575c,0x3e071e09 }, /* 146:  1.3119262e-01  1.3195051e-01 */
    { 0x3f4ae2a9,0x3f81d62a }, /* 147:  7.9252106e-01  1.0143483e+00 */
    { 0x3dc7ea09,0x3dc88d35 }, /* 148:  9.7614355e-02  9.7925581e-02 */
    { 0xb91bbf02,0xb91bbf02 }, /* 149: -1.4853108e-04 -1.4853108e-04 */
    { 0x3f83269b,0x3fd292ee }, /* 150:  1.0246156e+00  1.6451089e+00 */
    { 0xbfd84f31,0x4105ae96 }, /* 151: -1.6899167e+00  8.3551235e+00 */
    { 0x3e4c2207,0x3e4ee174 }, /* 152:  1.9934855e-01  2.0203191e-01 */
    { 0xb52e33bf,0xb52e33bf }, /* 153: -6.4895352e-07 -6.4895352e-07 */
    { 0xbf886d47,0xbfe79076 }, /* 154: -1.0658349e+00 -1.8090961e+00 */
    { 0xbf6361e9,0xbf9d73d9 }, /* 155: -8.8821274e-01 -1.2300979e+00 */
    { 0x3fbc0c55,0x411cd44d }, /* 156:  1.4691263e+00  9.8018312e+00 */
    { 0x3fb7ee5f,0x40edac1e }, /* 157:  1.4369620e+00  7.4272604e+00 */
    { 0x3f5b9764,0x3f940351 }, /* 158:  8.5777879e-01  1.1563512e+00 */
    { 0x3f0d7c27,0x3f1de621 }, /* 159:  5.5267566e-01  6.1679274e-01 */
    { 0xbd2539e2,0xbd2550d7 }, /* 160: -4.0338404e-02 -4.0360298e-02 */
    { 0xbe5fd5c9,0xbe637838 }, /* 161: -2.1858896e-01 -2.2213829e-01 */
    { 0xc00a6db0,0x3fbe4935 }, /* 162: -2.1629448e+00  1.4866091e+00 */
    { 0xbf2bf977,0xbf4b8ecf }, /* 163: -6.7177528e-01 -7.9514784e-01 */
    { 0x3ddf304f,0x3de01394 }, /* 164:  1.0897886e-01  1.0941234e-01 */
    { 0xbf5351fa,0xbf8ab146 }, /* 165: -8.2546961e-01 -1.0835350e+00 */
    { 0xbef3ccf9,0xbf04089e }, /* 166: -4.7617319e-01 -5.1575649e-01 */
    { 0x3f525c1f,0x3f89a71b }, /* 167:  8.2171816e-01  1.0754122e+00 */
    { 0x3ff6a219,0xc02c1a2c }, /* 168:  1.9268218e+00 -2.6890974e+00 */
    { 0xbf25561c,0xbf40f075 }, /* 169: -6.4584517e-01 -7.5366908e-01 */
    { 0x3f54a3e2,0x3f8c22a7 }, /* 170:  8.3062565e-01  1.0948075e+00 */
    { 0xbfa85485,0xc074cc26 }, /* 171: -1.3150793e+00 -3.8249602e+00 */
    { 0x3ef5c672,0x3f054939 }, /* 172:  4.8002964e-01  5.2064854e-01 */
    { 0xbe709d72,0xbe7524ba }, /* 173: -2.3497561e-01 -2.3939791e-01 */
    { 0xbf54cb84,0xbf8c4e40 }, /* 174: -8.3123040e-01 -1.0961380e+00 */
    { 0xbf5cf48c,0xbf959ddd }, /* 175: -8.6310649e-01 -1.1688801e+00 */
    { 0x3f4e532f,0x3f855fcf }, /* 176:  8.0595678e-01  1.0419863e+00 */
    { 0x3ecac258,0x3ed6118a }, /* 177:  3.9601398e-01  4.1810256e-01 */
    { 0x07107f42,0x07107f42 }, /* 178:  1.0870754e-34  1.0870754e-34 */
    { 0x3c758b14,0x3c758fc9 }, /* 179:  1.4986772e-02  1.4987894e-02 */
    { 0xbefdbcc0,0xbf0a6352 }, /* 180: -4.9558067e-01 -5.4057801e-01 */
    { 0xbf4def56,0xbf84f7d8 }, /* 181: -8.0443323e-01 -1.0388136e+00 */
    { 0x3ee06c13,0x3eeffe14 }, /* 182:  4.3832454e-01  4.6873534e-01 */
    { 0xbf2c331a,0xbf4becf3 }, /* 183: -6.7265475e-01 -7.9658431e-01 */
    { 0x3f572d7a,0x3f8ef49c }, /* 184:  8.4053767e-01  1.1168399e+00 */
    { 0xbf3ad22f,0xbf64fe22 }, /* 185: -7.2976965e-01 -8.9450276e-01 */
    { 0xbfdae503,0x40e433fe }, /* 186: -1.7101139e+00  7.1313467e+00 */
    { 0x3ef440b9,0x3f0451ec }, /* 187:  4.7705629e-01  5.1687503e-01 */
    { 0x3f2f4e39,0x3f510d5d }, /* 188:  6.8478733e-01  8.1661016e-01 */
    { 0x400582f5,0xbfe2008b }, /* 189:  2.0861180e+00 -1.7656416e+00 */
    { 0xbf3993dd,0xbf62c397 }, /* 190: -7.2491246e-01 -8.8579696e-01 */
    { 0x3ed69218,0x3ee4151c }, /* 191:  4.1908336e-01  4.4547355e-01 */
    { 0x3ef6f07d,0x3f0606dd }, /* 192:  4.8230353e-01  5.2354223e-01 */
    { 0x3f8d2753,0x3ffd379f }, /* 193:  1.1027626e+00  1.9782599e+00 */
    { 0x3f5f8b3c,0x3f98b752 }, /* 194:  8.7321830e-01  1.1930945e+00 */
    { 0xbfb00434,0xc0a17326 }, /* 195: -1.3751283e+00 -5.0453062e+00 */
    { 0xbed31618,0xbedfeb4f }, /* 196: -4.1227794e-01 -4.3734214e-01 */
    { 0x3ee2317c,0x3ef22802 }, /* 197:  4.4178379e-01  4.7296149e-01 */
    { 0xbf4e8a0a,0xbf859911 }, /* 198: -8.0679381e-01 -1.0437337e+00 */
    { 0x35a97e3b,0x35a97e3b }, /* 199:  1.2628219e-06  1.2628219e-06 */
    { 0xbf5ba518,0xbf941355 }, /* 200: -8.5798788e-01 -1.1568400e+00 */
    { 0xbf6109f5,0xbf9a8a57 }, /* 201: -8.7905818e-01 -1.2073468e+00 */
    { 0xbdfc94fa,0xbdfdded4 }, /* 202: -1.2333103e-01 -1.2396017e-01 */
    { 0x3f9198e4,0x400a55ea }, /* 203:  1.1374784e+00  2.1614938e+00 */
    { 0x3e827f57,0x3e85660e }, /* 204:  2.5487778e-01  2.6054424e-01 */
    { 0x3eaca795,0x3eb382d8 }, /* 205:  3.3721605e-01  3.5060763e-01 */
    { 0x3ed67ca0,0x3ee3fb62 }, /* 206:  4.1891956e-01  4.4527727e-01 */
    { 0xbf26f599,0xbf437f16 }, /* 207: -6.5218502e-01 -7.6365793e-01 */
    { 0xbf4f401e,0xbf8657d5 }, /* 208: -8.0957210e-01 -1.0495554e+00 */
    { 0x3ed22743,0x3edecf06 }, /* 209:  4.1045579e-01  4.3517321e-01 */
    { 0x3e2d3789,0x3e2ee362 }, /* 210:  1.6915716e-01  1.7078927e-01 */
    { 0xbf250314,0xbf406e63 }, /* 211: -6.4457822e-01 -7.5168437e-01 */
    { 0x3ec456eb,0x3ece90cb }, /* 212:  3.8347563e-01  4.0344843e-01 */
    { 0xbf321b5f,0xbf55c392 }, /* 213: -6.9573015e-01 -8.3501542e-01 */
    { 0x3f264f88,0x3f4278ae }, /* 214:  6.4965105e-01  7.5965393e-01 */
    { 0xbedd5c9b,0xbeec4521 }, /* 215: -4.3234715e-01 -4.6146491e-01 */
    { 0xbf97a8fb,0xc01d81d6 }, /* 216: -1.1848444e+00 -2.4610496e+00 */
    { 0x3efe3eb5,0x3f0ab755 }, /* 217:  4.9657217e-01  5.4185992e-01 */
    { 0x4097c792,0xc20227fe }, /* 218:  4.7431116e+00 -3.2539055e+01 */
    { 0xbf8c6f68,0xbff9b9da }, /* 219: -1.0971498e+00 -1.9509842e+00 */
    { 0xbf97378c,0xc01bf4fa }, /* 220: -1.1813827e+00 -2.4368272e+00 */
    { 0xbe6f3581,0xbe73a848 }, /* 221: -2.3360254e-01 -2.3794663e-01 */
    { 0xbdb42aa6,0xbdb4a200 }, /* 222: -8.7971970e-02 -8.8199615e-02 */
    { 0x3f0157c6,0x3f0d9a23 }, /* 223:  5.0524557e-01  5.5313319e-01 */
    { 0x3f604b22,0x3f99a0ab }, /* 224:  8.7614644e-01  1.2002157e+00 */
    { 0xbd88b299,0xbd88e6a9 }, /* 225: -6.6746898e-02 -6.6846199e-02 */
    { 0xbfec4299,0x4062d7c8 }, /* 226: -1.8457824e+00  3.5444202e+00 */
    { 0x40265fb9,0xbf1a269f }, /* 227:  2.5995924e+00 -6.0215181e-01 */
    { 0xbfd839fc,0x41066b4f }, /* 228: -1.6892695e+00  8.4011984e+00 */
    { 0x3f03c87e,0x3f10ce58 }, /* 229:  5.1477802e-01  5.6564856e-01 */
    { 0x3f2b09c0,0x3f4a08aa }, /* 230:  6.6811752e-01  7.8919470e-01 */
    { 0xbe831db5,0xbe860f3a }, /* 231: -2.5608602e-01 -2.6183492e-01 */
    { 0x3ec91def,0x3ed4244c }, /* 232:  3.9280650e-01  4.1433942e-01 */
    { 0xbf45b685,0xbf796361 }, /* 233: -7.7231628e-01 -9.7417265e-01 */
    { 0xbe8e750b,0xbe924038 }, /* 234: -2.7823672e-01 -2.8564620e-01 */
    { 0x3e9d5aa3,0x3ea280bb }, /* 235:  3.0733213e-01  3.1738839e-01 */
    { 0x3f2913dc,0x3f46df0f }, /* 236:  6.6045928e-01  7.7684110e-01 */
    { 0xbee75915,0xbef87e92 }, /* 237: -4.5185152e-01 -4.8534065e-01 */
    { 0x3fdf548c,0xc0b61432 }, /* 238:  1.7447677e+00 -5.6899652e+00 */
    { 0xbdc72400,0xbdc7c548 }, /* 239: -9.7236633e-02 -9.7544253e-02 */
    { 0x3eccc5a5,0x3ed86feb }, /* 240:  3.9994541e-01  4.2272887e-01 */
    { 0xbfe64108,0x4089deec }, /* 241: -1.7988596e+00  4.3084621e+00 */
    { 0x3f85f2c5,0x3fdd54c3 }, /* 242:  1.0464712e+00  1.7291492e+00 */
    { 0x3f237249,0x3f3dfdff }, /* 243:  6.3846260e-01  7.4215692e-01 */
    { 0xbf26dc77,0xbf43574f }, /* 244: -6.5180153e-01 -7.6305097e-01 */
    { 0xbecf2129,0xbedb38ad }, /* 245: -4.0454987e-01 -4.2816678e-01 */
    { 0xbfb65930,0xc0d95137 }, /* 246: -1.4245968e+00 -6.7911639e+00 */
    { 0x3e1d324d,0x3e1e716d }, /* 247:  1.5351219e-01  1.5472956e-01 */
    { 0xbf5a0a67,0xbf9236a0 }, /* 248: -8.5172123e-01 -1.1422920e+00 */
    { 0xbf4ef206,0xbf8605e0 }, /* 249: -8.0838048e-01 -1.0470543e+00 */
    { 0x3eace2ee,0x3eb3c580 }, /* 250:  3.3766884e-01  3.5111618e-01 */
    { 0xbfe4869a,0x4092d884 }, /* 251: -1.7853577e+00  4.5889301e+00 */
    { 0xbf207d83,0xbf397250 }, /* 252: -6.2691516e-01 -7.2440052e-01 */
    { 0x3f35efa8,0x3f5c5888 }, /* 253:  7.1068811e-01  8.6072588e-01 */
    { 0xbf1f093e,0xbf373d04 }, /* 254: -6.2123477e-01 -7.1577477e-01 */
    { 0xbfd2b58f,0x4153e2b8 }, /* 255: -1.6461657e+00  1.3242851e+01 */
    { 0xbed8f075,0xbee6ed4f }, /* 256: -4.2370954e-01 -4.5102927e-01 */
    { 0xbec95fe9,0xbed4719e }, /* 257: -3.9330986e-01 -4.1492933e-01 */
    { 0xbf9cb07c,0xc03129d0 }, /* 258: -1.2241359e+00 -2.7681770e+00 */
    { 0xbe605862,0xbe640147 }, /* 259: -2.1908715e-01 -2.2266112e-01 */
    { 0x3f7be79b,0x3fc080fe }, /* 260:  9.8400277e-01  1.5039365e+00 */
    { 0xbf1e4c03,0xbf361f6d }, /* 261: -6.1834735e-01 -7.1141702e-01 */
    { 0xbeec99dc,0xbeff047e }, /* 262: -4.6211135e-01 -4.9808115e-01 */
    { 0xbe94f3eb,0xbe994d6a }, /* 263: -2.9092345e-01 -2.9941875e-01 */
    { 0x3d45bcb3,0x3d45e40f }, /* 264:  4.8275661e-02  4.8313197e-02 */
    { 0x3fc3a47b,0x41bcd640 }, /* 265:  1.5284570e+00  2.3604614e+01 */
    { 0x3ed505b5,0x3ee23ab3 }, /* 266:  4.1605917e-01  4.4185409e-01 */
    { 0xbe587350,0xbe5bbb9a }, /* 267: -2.1137738e-01 -2.1458283e-01 */
    { 0x3f60600a,0x3f99ba30 }, /* 268:  8.7646544e-01  1.2009945e+00 */
    { 0xbf207a6a,0xbf396d97 }, /* 269: -6.2686789e-01 -7.2432846e-01 */
    { 0xbf23d916,0xbf3e9d9b }, /* 270: -6.4003122e-01 -7.4459237e-01 */
    { 0xbf0838a9,0xbf16b90b }, /* 271: -5.3211457e-01 -5.8876103e-01 */
    { 0xbe1f32df,0xbe207e6d }, /* 272: -1.5546750e-01 -1.5673228e-01 */
    { 0xbf83a592,0xbfd46c88 }, /* 273: -1.0284903e+00 -1.6595621e+00 */
    { 0x3f24ea41,0x3f40478c }, /* 274:  6.4419943e-01  7.5109172e-01 */
    { 0xbf4dfb62,0xbf85045f }, /* 275: -8.0461705e-01 -1.0391959e+00 */
    { 0xbe04ebae,0xbe05ac18 }, /* 276: -1.2980530e-01 -1.3053930e-01 */
    { 0xbec48c10,0xbecece99 }, /* 277: -3.8388109e-01 -4.0391997e-01 */
    { 0xbedf9fdb,0xbeef052c }, /* 278: -4.3676648e-01 -4.6683633e-01 */
    { 0x3f5847a4,0x3f903334 }, /* 279:  8.4484315e-01  1.1265626e+00 */
    { 0xbf579298,0xbf8f666e }, /* 280: -8.4208059e-01 -1.1203134e+00 */
    { 0xbf9a9f8e,0xc028989d }, /* 281: -1.2079942e+00 -2.6343148e+00 */
    { 0xbe380ace,0xbe3a0cc1 }, /* 282: -1.7972872e-01 -1.8168928e-01 */
    { 0xbf5157f2,0xbf888fc2 }, /* 283: -8.1774819e-01 -1.0668871e+00 */
    { 0xbf502482,0xbf8748b4 }, /* 284: -8.1305707e-01 -1.0569062e+00 */
    { 0x3f2b59b7,0x3f4a8a8f }, /* 285:  6.6933769e-01  7.9117674e-01 */
    { 0x3ee36381,0x3ef39ee6 }, /* 286:  4.4411853e-01  4.7582167e-01 */
    { 0xbfc36748,0xc1b4d964 }, /* 287: -1.5265894e+00 -2.2606148e+01 */
    { 0xbe6c9e7a,0xbe70ec22 }, /* 288: -2.3107329e-01 -2.3527578e-01 */
    { 0xbf2c5003,0xbf4c1c39 }, /* 289: -6.7309588e-01 -7.9730564e-01 */
    { 0x38ee8207,0x38ee8207 }, /* 290:  1.1372944e-04  1.1372944e-04 */
    { 0x3fe4a49e,0xc09233af }, /* 291:  1.7862737e+00 -4.5688090e+00 */
    { 0x3f87202a,0x3fe21ac8 }, /* 292:  1.0556691e+00  1.7664423e+00 */
    { 0xbf8ff1c1,0xc005c669 }, /* 293: -1.1245652e+00 -2.0902350e+00 */
    { 0xbed010e5,0xbedc5495 }, /* 294: -4.0637890e-01 -4.3033281e-01 */
    { 0xbebbdfd4,0xbec4c970 }, /* 295: -3.6694205e-01 -3.8434935e-01 */
    { 0xbf9b6e3a,0xc02bdaf0 }, /* 296: -1.2143013e+00 -2.6852379e+00 */
    { 0x3f5bc8f6,0x3f943d4b }, /* 297:  8.5853517e-01  1.1581205e+00 */
    { 0x3d9b8ff0,0x3d9bdcb4 }, /* 298:  7.5958133e-02  7.6104552e-02 */
    { 0x3ecd0af4,0x3ed8c1a1 }, /* 299:  4.0047419e-01  4.2335227e-01 */
    { 0x3f22bc7d,0x3f3ce4a5 }, /* 300:  6.3568860e-01  7.3786384e-01 */
    { 0x3fbe0112,0x4138bf9f }, /* 301:  1.4844077e+00  1.1546782e+01 */
    { 0xbea409e6,0xbea9e453 }, /* 302: -3.2038802e-01 -3.3182010e-01 */
    { 0xc0aa4e3c,0x3fb745b2 }, /* 303: -5.3220501e+00  1.4318144e+00 */
    { 0x3ef0dd18,0x3f022e13 }, /* 304:  4.7043681e-01  5.0851554e-01 */
    { 0x3f4e8a9f,0x3f8599ac }, /* 305:  8.0680269e-01  1.0437522e+00 */
    { 0x3d413af0,0x3d415fab }, /* 306:  4.7175348e-02  4.7210377e-02 */
    { 0x3ee9bbec,0x3efb7304 }, /* 307:  4.5651186e-01  4.9111187e-01 */
    { 0xbfbce8c0,0xc12803ce }, /* 308: -1.4758530e+00 -1.0500929e+01 */
    { 0x3eead922,0x3efcd565 }, /* 309:  4.5868784e-01  4.9381557e-01 */
    { 0xbf99542e,0xc0239737 }, /* 310: -1.1978815e+00 -2.5561044e+00 */
    { 0x3f5420f8,0x3f8b930e }, /* 311:  8.2862806e-01  1.0904253e+00 */
    { 0xbf26bccc,0xbf432538 }, /* 312: -6.5131831e-01 -7.6228666e-01 */
    { 0x3eef0b1e,0x3f01095e }, /* 313:  4.6688169e-01  5.0404918e-01 */
    { 0xbffb3014,0x401afcd2 }, /* 314: -1.9624047e+00  2.4216809e+00 */
    { 0xbf5076d3,0xbf879ff4 }, /* 315: -8.1431311e-01 -1.0595689e+00 */
    { 0x411aab6e,0x3e7cd7d5 }, /* 316:  9.6668530e+00  2.4691708e-01 */
    { 0x3fd361af,0xc14606b7 }, /* 317:  1.6514186e+00 -1.2376639e+01 */
    { 0xbf936b16,0xc00faa1a }, /* 318: -1.1517055e+00 -2.2447572e+00 */
    { 0x3ea99e44,0x3eb01bc7 }, /* 319:  3.3128560e-01  3.4396192e-01 */
    { 0xbf63e81c,0xbf9e1ce8 }, /* 320: -8.9026046e-01 -1.2352571e+00 */
    { 0x3f1c68e2,0x3f334b8f }, /* 321:  6.1097538e-01  7.0037168e-01 */
    { 0xbf52555f,0xbf899fd4 }, /* 322: -8.2161516e-01 -1.0751901e+00 */
    { 0x3d93677a,0x3d93a8c6 }, /* 323:  7.1974710e-02  7.2099254e-02 */
    { 0x3f4f0061,0x3f8614ed }, /* 324:  8.0859953e-01  1.0475136e+00 */
    { 0xbf468d60,0xbf7b077a }, /* 325: -7.7559471e-01 -9.8058283e-01 */
    { 0xbea7eed2,0xbeae39d5 }, /* 326: -3.2799393e-01 -3.4028497e-01 */
    { 0x3f7be11d,0x3fc07668 }, /* 327:  9.8390371e-01  1.5036135e+00 */
    { 0x3f2cdbb2,0x3f4d0118 }, /* 328:  6.7522728e-01  8.0079794e-01 */
    { 0x3f16ee27,0x3f2b3f55 }, /* 329:  5.8957142e-01  6.6893512e-01 */
    { 0xbf5039ff,0xbf875f75 }, /* 330: -8.1338495e-01 -1.0576006e+00 */
    { 0xc08a640b,0xc01cbb44 }, /* 331: -4.3247123e+00 -2.4489298e+00 */
    { 0xbf091edd,0xbf17efb0 }, /* 332: -5.3562719e-01 -5.9350109e-01 */
    { 0x3fb37a50,0x40bbf781 }, /* 333:  1.4021702e+00  5.8739629e+00 */
    { 0xbf2677d8,0xbf42b849 }, /* 334: -6.5026617e-01 -7.6062447e-01 */
    { 0x3f5dc06f,0x3f968ff9 }, /* 335:  8.6621755e-01  1.1762687e+00 */
    { 0xbee1e7d0,0xbef1cde2 }, /* 336: -4.4122171e-01 -4.7227389e-01 */
    { 0x3f2f8de2,0x3f51778f }, /* 337:  6.8575871e-01  8.1823057e-01 */
    { 0x3fdd814d,0xc0c6a76c }, /* 338:  1.7305084e+00 -6.2079372e+00 */
    { 0x3fd629d4,0xc11bc5ad }, /* 339:  1.6731515e+00 -9.7357607e+00 */
    { 0xbef64969,0xbf059c7f }, /* 340: -4.8102883e-01 -5.2191919e-01 */
    { 0x3f582200,0x3f900886 }, /* 341:  8.4426880e-01  1.1252601e+00 */
    { 0x3f9279a3,0x400cdce7 }, /* 342:  1.1443371e+00  2.2009828e+00 */
    { 0xbf2fac8f,0xbf51aacb }, /* 343: -6.8622679e-01 -8.1901234e-01 */
    { 0xc0202aac,0x3f3e336e }, /* 344: -2.5026045e+00  7.4297225e-01 */
    { 0xbf506237,0xbf878a17 }, /* 345: -8.1399864e-01 -1.0589017e+00 */
    { 0x3e939185,0x3e97cb8e }, /* 346:  2.8821960e-01  2.9647487e-01 */
    { 0xbef4b2ef,0xbf049a51 }, /* 347: -4.7792765e-01 -5.1797968e-01 */
    { 0xbf56ae1a,0xbf8e65cb }, /* 348: -8.3859408e-01 -1.1124815e+00 */
    { 0x3f59a4c4,0x3f91c1b5 }, /* 349:  8.5017037e-01  1.1387240e+00 */
    { 0xbe38843a,0xbe3a8a32 }, /* 350: -1.8019190e-01 -1.8216780e-01 */
    { 0x3f260e14,0x3f421189 }, /* 351:  6.4865232e-01  7.5808007e-01 */
    { 0xc0e31b35,0xbf878240 }, /* 352: -7.0970712e+00 -1.0586624e+00 */
    { 0x3e40d9e4,0x3e4329fd }, /* 353:  1.8833119e-01  1.9058986e-01 */
    { 0xbf276317,0xbf442ca7 }, /* 354: -6.5385574e-01 -7.6630634e-01 */
    { 0x40d2263d,0x3e95701f }, /* 355:  6.5671678e+00  2.9187104e-01 */
    { 0xbfa6c1ef,0xc0690ef2 }, /* 356: -1.3027934e+00 -3.6415372e+00 */
    { 0x3f9e17ff,0x40376fd8 }, /* 357:  1.2351073e+00  2.8662014e+00 */
    { 0xbef95bed,0xbf079275 }, /* 358: -4.8702946e-01 -5.2957851e-01 */
    { 0xbea6875a,0xbeaca91d }, /* 359: -3.2525140e-01 -3.3722773e-01 */
    { 0xbd4c1657,0xbd4c419e }, /* 360: -4.9825992e-02 -4.9867265e-02 */
    { 0x3fc71396,0x4280edf3 }, /* 361:  1.5552852e+00  6.4464745e+01 */
    { 0x3f2d6e10,0x3f4df1c0 }, /* 362:  6.7746067e-01  8.0447006e-01 */
    { 0x3cb1dd83,0x3cb1e4ab }, /* 363:  2.1712070e-02  2.1715483e-02 */
    { 0xbf8160ad,0xbfcc25e1 }, /* 364: -1.0107628e+00 -1.5949060e+00 */
    { 0x3faa76c1,0x40834e1e }, /* 365:  1.3317491e+00  4.1032858e+00 */
    { 0x3f9f5fcd,0x403d82dd }, /* 366:  1.2451111e+00  2.9611123e+00 */
    { 0x3ef20252,0x3f02e6d0 }, /* 367:  4.7267395e-01  5.1133442e-01 */
    { 0x3f98e522,0x4021f882 }, /* 368:  1.1944926e+00  2.5307927e+00 */
    { 0xbf5e9474,0xbf978da0 }, /* 369: -8.6945271e-01 -1.1840096e+00 */
    { 0xbfd52bf2,0x41289d85 }, /* 370: -1.6654036e+00  1.0538457e+01 */
    { 0xbea7216f,0xbead54c9 }, /* 371: -3.2642695e-01 -3.3853748e-01 */
    { 0x3faf213f,0x409bc8c4 }, /* 372:  1.3682021e+00  4.8682575e+00 */
    { 0x3ebd5635,0x3ec67798 }, /* 373:  3.6979833e-01  3.8763118e-01 */
    { 0x4050aa72,0x3df479af }, /* 374:  3.2604032e+00  1.1937272e-01 */
    { 0xc0fd06ad,0x419690a4 }, /* 375: -7.9070649e+00  1.8820625e+01 */
    { 0x3fde36fc,0xc0bfdf4a }, /* 376:  1.7360530e+00 -5.9960070e+00 */
    { 0x3fbce782,0x4127f288 }, /* 377:  1.4758151e+00  1.0496712e+01 */
    { 0x3f7d4090,0x3fc2b815 }, /* 378:  9.8926640e-01  1.5212427e+00 */
    { 0x3f5a23c5,0x3f9253df }, /* 379:  8.5210830e-01  1.1431845e+00 */
    { 0xbee5e84e,0xbef6b78c }, /* 380: -4.4903797e-01 -4.8186910e-01 */
    { 0x3f918070,0x400a10ad }, /* 381:  1.1367321e+00  2.1572678e+00 */
    { 0xbecc2633,0xbed7b414 }, /* 382: -3.9872894e-01 -4.2129576e-01 */
    { 0xbf5b8684,0xbf93ef9a }, /* 383: -8.5752130e-01 -1.1557496e+00 */
    { 0x3ea56adc,0x3eab6c7f }, /* 384:  3.2308090e-01  3.3481213e-01 */
    { 0x400137d6,0xc00516b9 }, /* 385:  2.0190330e+00 -2.0795119e+00 */
    { 0xbffea36f,0x400fde10 }, /* 386: -1.9893626e+00  2.2479286e+00 */
    { 0xbf1aa8ef,0xbf30b30e }, /* 387: -6.0414022e-01 -6.9023216e-01 */
    { 0xbf55aee5,0xbf8d497f }, /* 388: -8.3469993e-01 -1.1038054e+00 */
    { 0xbd089d36,0xbd08aa2f }, /* 389: -3.3353053e-02 -3.3365425e-02 */
    { 0x3ea7fc48,0x3eae48da }, /* 390:  3.2809663e-01  3.4039956e-01 */
    { 0x3f95f636,0x4017b439 }, /* 391:  1.1715763e+00  2.3703749e+00 */
    { 0xb79a8a9a,0xb79a8a9a }, /* 392: -1.8422772e-05 -1.8422772e-05 */
    { 0xc01ec42a,0x3f470a35 }, /* 393: -2.4807229e+00  7.7749950e-01 */
    { 0x3f81771d,0x3fcc757a }, /* 394:  1.0114475e+00  1.5973351e+00 */
    { 0xbff8395f,0x4025c41e }, /* 395: -1.9392508e+00  2.5900950e+00 */
    { 0xbfa0589c,0xc0425e0b }, /* 396: -1.2527041e+00 -3.0369899e+00 */
    { 0x3ee0a29e,0x3ef0409e }, /* 397:  4.3874067e-01  4.6924299e-01 */
    { 0x3f255769,0x3f40f27f }, /* 398:  6.4586502e-01  7.5370020e-01 */
    { 0x3f5c48c2,0x3f94d33c }, /* 399:  8.6048520e-01  1.1626964e+00 */
    { 0x3eaac760,0x3eb1684c }, /* 400:  3.3355236e-01  3.4649885e-01 */
    { 0x3ede269d,0x3eed3a55 }, /* 401:  4.3388835e-01  4.6333566e-01 */
    { 0xbe3ff0c6,0xbe423871 }, /* 402: -1.8744192e-01 -1.8966843e-01 */
    { 0xbd691819,0xbd695899 }, /* 403: -5.6907747e-02 -5.6969259e-02 */
    { 0x3e4c69a4,0x3e4f2bfe }, /* 404:  1.9962174e-01  2.0231625e-01 */
    { 0xbf00161c,0xbf0bf731 }, /* 405: -5.0033736e-01 -5.4674059e-01 */
    { 0xbe2bf23c,0xbe2d94aa }, /* 406: -1.6791624e-01 -1.6951242e-01 */
    { 0x3f9cd10c,0x4031b73f }, /* 407:  1.2251296e+00  2.7768095e+00 */
    { 0xbd40b7d6,0xbd40dc46 }, /* 408: -4.7050320e-02 -4.7085069e-02 */
    { 0x3f265070,0x3f427a1c }, /* 409:  6.4966488e-01  7.5967574e-01 */
    { 0xbf53bc62,0xbf8b2525 }, /* 410: -8.2709324e-01 -1.0870711e+00 */
    { 0xbd434b3f,0xbd43712a }, /* 411: -4.7679182e-02 -4.7715344e-02 */
    { 0xbf2de86f,0xbf4ebb9f }, /* 412: -6.7932791e-01 -8.0755037e-01 */
    { 0xbf3625a7,0xbf5cb698 }, /* 413: -7.1151203e-01 -8.6216116e-01 */
    { 0x400c58b8,0xbfb27e61 }, /* 414:  2.1929150e+00 -1.3944818e+00 */
    { 0x3f229d6c,0x3f3cb4ae }, /* 415:  6.3521457e-01  7.3713195e-01 */
    { 0x3f29d666,0x3f4817b8 }, /* 416:  6.6342771e-01  7.8161192e-01 */
    { 0x3f5f4938,0x3f98676c }, /* 417:  8.7221098e-01  1.1906562e+00 */
    { 0xbfa3dae1,0xc055f009 }, /* 418: -1.2801172e+00 -3.3427756e+00 */
    { 0xbf839b83,0xbfd446ca }, /* 419: -1.0281833e+00 -1.6584103e+00 */
    { 0x3f534c40,0x3f8aab0d }, /* 420:  8.2538223e-01  1.0833451e+00 */
    { 0x3f5c7d8f,0x3f951162 }, /* 421:  8.6129087e-01  1.1645930e+00 */
    { 0x3f5ed22f,0x3f97d7d7 }, /* 422:  8.7039465e-01  1.1862744e+00 */
    { 0x3e6f4363,0x3e73b6f3 }, /* 423:  2.3365550e-01  2.3800258e-01 */
    { 0x3f286f87,0x3f45d811 }, /* 424:  6.5795177e-01  7.7282816e-01 */
    { 0xbfc7e945,0xc2de7699 }, /* 425: -1.5618063e+00 -1.1123164e+02 */
    { 0xbfb3ac92,0xc0bdb9a4 }, /* 426: -1.4037039e+00 -5.9289112e+00 */
    { 0xbfc53996,0xc20565ed }, /* 427: -1.5408199e+00 -3.3349537e+01 */
    { 0x3ee9c267,0x3efb7b0f }, /* 428:  4.5656130e-01  4.9117324e-01 */
    { 0x3edf7c0c,0x3eeed991 }, /* 429:  4.3649328e-01  4.6650365e-01 */
    { 0x3f5921fe,0x3f912bdf }, /* 430:  8.4817493e-01  1.1341513e+00 */
    { 0xbe7e537d,0xbe81d80c }, /* 431: -2.4836536e-01 -2.5360143e-01 */
    { 0xbcace077,0xbcace709 }, /* 432: -2.1103127e-02 -2.1106260e-02 */
    { 0x3f357658,0x3f5b85ae }, /* 433:  7.0883703e-01  8.5750854e-01 */
    { 0x3ea21346,0x3ea7b710 }, /* 434:  3.1655329e-01  3.2756853e-01 */
    { 0xbf5a0402,0xbf922f42 }, /* 435: -8.5162365e-01 -1.1420672e+00 */
    { 0x3f20ab0d,0x3f39b7c9 }, /* 436:  6.2761003e-01  7.2546059e-01 */
    { 0x3f682857,0x3fa3982d }, /* 437:  9.0686554e-01  1.2780815e+00 */
    { 0xbeebce7f,0xbefe06e0 }, /* 438: -4.6055982e-01 -4.9614620e-01 */
    { 0x3eeafb12,0x3efcff9d }, /* 439:  4.5894676e-01  4.9413767e-01 */
    { 0x3edae714,0x3ee94b3a }, /* 440:  4.2754424e-01  4.5565206e-01 */
    { 0x3f573e47,0x3f8f077f }, /* 441:  8.4079403e-01  1.1174163e+00 */
    { 0x3edc09df,0x3eeaaac0 }, /* 442:  4.2976281e-01  4.5833397e-01 */
    { 0xbfd9cc7e,0x40f35536 }, /* 443: -1.7015531e+00  7.6041517e+00 */
    { 0x3f2470aa,0x3f3f89a0 }, /* 444:  6.4234412e-01  7.4819374e-01 */
    { 0xbf5ce979,0xbf9590c4 }, /* 445: -8.6293751e-01 -1.1684804e+00 */
    { 0x3f56027f,0x3f8da65c }, /* 446:  8.3597559e-01  1.1066394e+00 */
    { 0xbfc63e69,0xc235a697 }, /* 447: -1.5487796e+00 -4.5412685e+01 */
    { 0xbf5e73c8,0xbf976669 }, /* 448: -8.6895418e-01 -1.1828128e+00 */
    { 0xbf587691,0xbf90687d }, /* 449: -8.4555918e-01 -1.1281887e+00 */
    { 0x3edb42a5,0x3ee9b9d7 }, /* 450:  4.2824283e-01  4.5649597e-01 */
    { 0xbf1c1c06,0xbf32d918 }, /* 451: -6.0980260e-01 -6.9862509e-01 */
    { 0xbed5b0e3,0xbee3076b }, /* 452: -4.1736516e-01 -4.4341597e-01 */
    { 0x3eaf3f9f,0x3eb66dd8 }, /* 453:  3.4228227e-01  3.5630679e-01 */
    { 0x3e9f3cf0,0x3ea4943d }, /* 454:  3.1101179e-01  3.2144347e-01 */
    { 0x3fa4cdb2,0x405bdba6 }, /* 455:  1.2875273e+00  3.4352813e+00 */
    { 0x3e393518,0x3e3b40f4 }, /* 456:  1.8086660e-01  1.8286496e-01 */
    { 0x3eefbadf,0x3f0177a5 }, /* 457:  4.6822259e-01  5.0573188e-01 */
    { 0xbfd2fae6,0x414e13ad }, /* 458: -1.6482818e+00  1.2879804e+01 */
    { 0x3efe8072,0x3f0ae1dd }, /* 459:  4.9707371e-01  5.4250890e-01 */
    { 0xbe6e4c41,0xbe72b1e0 }, /* 460: -2.3271276e-01 -2.3700666e-01 */
    { 0xbf4ee1b3,0xbf85f4c5 }, /* 461: -8.0813140e-01 -1.0465323e+00 */
    { 0xc07e2d2c,0xbf8bef74 }, /* 462: -3.9715071e+00 -1.0932450e+00 */
    { 0x3ec0d14e,0x3eca7b4f }, /* 463:  3.7659687e-01  3.9547202e-01 */
    { 0x3f1e10d8,0x3f35c65e }, /* 464:  6.1744452e-01  7.1005809e-01 */
    { 0xc0c6e282,0x3d8b8d4c }, /* 465: -6.2151499e+00  6.8140596e-02 */
    { 0xbe88903c,0xbe8be594 }, /* 466: -2.6672542e-01 -2.7323592e-01 */
    { 0x3e531f74,0x3e562a85 }, /* 467:  2.0617467e-01  2.0914657e-01 */
    { 0x3e9d26c4,0x3ea247a4 }, /* 468:  3.0693638e-01  3.1695282e-01 */
    { 0x3f4da54a,0x3f84aaf5 }, /* 469:  8.0330336e-01  1.0364672e+00 */
    { 0x36377722,0x36377722 }, /* 470:  2.7338469e-06  2.7338469e-06 */
    { 0xbf570ca1,0xbf8ecfb9 }, /* 471: -8.4003645e-01 -1.1157142e+00 */
    { 0xbe6b2a09,0xbe6f6335 }, /* 472: -2.2965254e-01 -2.3377688e-01 */
    { 0xbed3c0ef,0xbee0b6f1 }, /* 473: -4.1358134e-01 -4.3889573e-01 */
    { 0x3ee1c120,0x3ef19e92 }, /* 474:  4.4092655e-01  4.7191292e-01 */
    { 0xbfa506d2,0xc05d4b7c }, /* 475: -1.2892706e+00 -3.4577322e+00 */
    { 0xbe1cae67,0xbe1dea61 }, /* 476: -1.5300904e-01 -1.5421440e-01 */
    { 0xbf5cdcd9,0xbf9581d6 }, /* 477: -8.6274487e-01 -1.1680248e+00 */
    { 0xbeef880a,0xbf0157bc }, /* 478: -4.6783477e-01 -5.0524497e-01 */
    { 0x3edc3249,0x3eeadba9 }, /* 479:  4.3007115e-01  4.5870712e-01 */
    { 0x3e40d715,0x3e432713 }, /* 480:  1.8832047e-01  1.9057874e-01 */
    { 0xbf319d4d,0xbf54edf0 }, /* 481: -6.9380647e-01 -8.3175564e-01 */
    { 0x3f944c74,0x40125d45 }, /* 482:  1.1585832e+00  2.2869427e+00 */
    { 0xbf9f1904,0xc03c2b56 }, /* 483: -1.2429509e+00 -2.9401450e+00 */
    { 0xc0195f7b,0x3f6c2cdb }, /* 484: -2.3964527e+00  9.2255944e-01 */
    { 0x3f26fdec,0x3f438c44 }, /* 485:  6.5231204e-01  7.6385903e-01 */
    { 0xbf27b282,0xbf44aad3 }, /* 486: -6.5506756e-01 -7.6823157e-01 */
    { 0xbe604aaf,0xbe63f2e6 }, /* 487: -2.1903490e-01 -2.2260627e-01 */
    { 0xbfee3d1d,0x40561f0a }, /* 488: -1.8612400e+00  3.3456445e+00 */
    { 0x3f5cc8ae,0x3f956a01 }, /* 489:  8.6243713e-01  1.1672975e+00 */
    { 0x3f593619,0x3f9142dd }, /* 490:  8.4848171e-01  1.1348530e+00 */
    { 0xc0089b33,0x3fca8151 }, /* 491: -2.1344726e+00  1.5820714e+00 */
    { 0x3f5a087f,0x3f92346e }, /* 492:  8.5169214e-01  1.1422250e+00 */
    { 0x3fd39bd1,0xc141be6a }, /* 493:  1.6531926e+00 -1.2108988e+01 */
    { 0x3fb0427d,0x40a31314 }, /* 494:  1.3770291e+00  5.0960789e+00 */
    { 0xbea67e3f,0xbeac9ef9 }, /* 495: -3.2518193e-01 -3.3715037e-01 */
    { 0xbf93b554,0xc0108b6b }, /* 496: -1.1539712e+00 -2.2585094e+00 */
    { 0x3f249276,0x3f3fbe5d }, /* 497:  6.4285982e-01  7.4899846e-01 */
    { 0x3f5abd1e,0x3f930539 }, /* 498:  8.5444820e-01  1.1485969e+00 */
    { 0x3eee3e3d,0x3f008900 }, /* 499:  4.6531859e-01  5.0209045e-01 */
    { 0x3ec7f909,0x3ed2cd6e }, /* 500:  3.9057186e-01  4.1172355e-01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = tan (x.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 4) x_exit (i+1);
    }
    return 0;
}
