/* Test of exp() function. 500 random cases.
   $Id: exp-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x;		/* argument	*/
    long z;		/* exp(x)	*/
} t[] = {

    /* x, exp(x)	*/
    { 0xbf59d8bf,0x3edaa02d }, /*   1: -8.5096353e-01  4.2700329e-01 */
    { 0xbd4896e7,0x3f73c3e3 }, /*   2: -4.8972037e-02  9.5220774e-01 */
    { 0x3a49825a,0x3f801933 }, /*   3:  7.6869654e-04  1.0007690e+00 */
    { 0xbed283f8,0x3f29b26d }, /*   4: -4.1116309e-01  6.6287881e-01 */
    { 0xb8439b67,0x3f7ffcf2 }, /*   5: -4.6636353e-05  9.9995339e-01 */
    { 0x404ecfee,0x41ca8766 }, /*   6:  3.2314410e+00  2.5316113e+01 */
    { 0x3f1a0da4,0x3fe9a501 }, /*   7:  6.0177064e-01  1.8253480e+00 */
    { 0x3e70295f,0x3fa1d52c }, /*   8:  2.3453282e-01  1.2643180e+00 */
    { 0xbf0a41e9,0x3f152c62 }, /*   9: -5.4006821e-01  5.8270848e-01 */
    { 0xbefe1130,0x3f1bdbf0 }, /*  10: -4.9622488e-01  6.0882473e-01 */
    { 0xbfe04c34,0x3e3187fc }, /*  11: -1.7523255e+00  1.7337030e-01 */
    { 0x3fe801a3,0x40c40897 }, /*  12:  1.8125499e+00  6.1260486e+00 */
    { 0x3cfc6675,0x3f840151 }, /*  13:  3.0810574e-02  1.0312902e+00 */
    { 0xb2099351,0x3f800000 }, /*  14: -8.0079454e-09  1.0000000e+00 */
    { 0x3e862c0a,0x3fa65938 }, /*  15:  2.6205474e-01  1.2995977e+00 */
    { 0xbf12ec5d,0x3f10354f }, /*  16: -5.7391912e-01  5.6331342e-01 */
    { 0xbe465164,0x3f52ed11 }, /*  17: -1.9366986e-01  8.2392985e-01 */
    { 0xbf139d57,0x3f0fd1c0 }, /*  18: -5.7661957e-01  5.6179428e-01 */
    { 0xc028a2b3,0x3d92e403 }, /*  19: -2.6349304e+00  7.1723960e-02 */
    { 0x392c9b0d,0x3f800565 }, /*  20:  1.6460959e-04  1.0001646e+00 */
    { 0xbcd29852,0x3f7980b6 }, /*  21: -2.5707398e-02  9.7462022e-01 */
    { 0xc1325a04,0x3771e859 }, /*  22: -1.1146976e+01  1.4418817e-05 */
    { 0x3f651c3c,0x401c9fa1 }, /*  23:  8.9496207e-01  2.4472430e+00 */
    { 0xbf8c5b53,0x3eab056f }, /*  24: -1.0965370e+00  3.3402583e-01 */
    { 0x3f0fff8b,0x3fe0a53b }, /*  25:  5.6249303e-01  1.7550424e+00 */
    { 0x3db81790,0x3f8c09ea }, /*  26:  8.9888692e-02  1.0940526e+00 */
    { 0x3bbd94a6,0x3f80be21 }, /*  27:  5.7855425e-03  1.0058023e+00 */
    { 0xc0ee188a,0x3a19e085 }, /*  28: -7.4404955e+00  5.8699428e-04 */
    { 0xbf7a9fab,0x3ec05a0d }, /*  29: -9.7899884e-01  3.7568703e-01 */
    { 0xbe93fd17,0x3f3fbd49 }, /*  30: -2.8904030e-01  7.4898201e-01 */
    { 0x3f7071c5,0x4023b6b4 }, /*  31:  9.3923599e-01  2.5580263e+00 */
    { 0xbd794ee1,0x3f70e20a }, /*  32: -6.0866240e-02  9.4094908e-01 */
    { 0xbf02b814,0x3f19a1a3 }, /*  33: -5.1062131e-01  6.0012263e-01 */
    { 0x3f89808b,0x403b604f }, /*  34:  1.0742353e+00  2.9277532e+00 */
    { 0x3f090701,0x3fda9c63 }, /*  35:  5.3526312e-01  1.7078975e+00 */
    { 0xbf710550,0x3ec7b447 }, /*  36: -9.4148731e-01  3.9004728e-01 */
    { 0xb2cb5c9f,0x3f800000 }, /*  37: -2.3674430e-08  1.0000000e+00 */
    { 0xc1672a26,0x350ea418 }, /*  38: -1.4447790e+01  5.3137910e-07 */
    { 0x3e4ff92a,0x3f9cd325 }, /*  39:  2.0309892e-01  1.2251936e+00 */
    { 0xbf168578,0x3f0e3211 }, /*  40: -5.8797407e-01  5.5545145e-01 */
    { 0xbf071a9a,0x3f1705b8 }, /*  41: -5.2774966e-01  5.8993101e-01 */
    { 0x3e56e779,0x3f9de3cd }, /*  42:  2.0986737e-01  1.2335144e+00 */
    { 0xbdaaff1e,0x3f6b7e52 }, /*  43: -8.3494410e-02  9.1989625e-01 */
    { 0xbe0ec0b3,0x3f5eb00f }, /*  44: -1.3940696e-01  8.6987394e-01 */
    { 0x3f8026b1,0x402e2cf3 }, /*  45:  1.0011808e+00  2.7214935e+00 */
    { 0xc089b525,0x3c5d8fa1 }, /*  46: -4.3033624e+00  1.3523013e-02 */
    { 0xbff6903f,0x3e152fa7 }, /*  47: -1.9262770e+00  1.4568959e-01 */
    { 0x3fe7fe99,0x40c403f0 }, /*  48:  1.8124572e+00  6.1254807e+00 */
    { 0x3f756cbf,0x4026ee0b }, /*  49:  9.5869058e-01  2.6082790e+00 */
    { 0xbe5fe762,0x3f4db89a }, /*  50: -2.1865609e-01  8.0359805e-01 */
    { 0x3ce4c37f,0x3f839ff3 }, /*  51:  2.7925251e-02  1.0283188e+00 */
    { 0xbd536891,0x3f731f46 }, /*  52: -5.1613394e-02  9.4969594e-01 */
    { 0x3d1cbb10,0x3f84fe25 }, /*  53:  3.8264334e-02  1.0390059e+00 */
    { 0xb864d9d5,0x3f7ffc6d }, /*  54: -5.4562308e-05  9.9994546e-01 */
    { 0x4049b073,0x41baf2f5 }, /*  55:  3.1513946e+00  2.3368631e+01 */
    { 0xbf62cd7c,0x3ed31c04 }, /*  56: -8.8594794e-01  4.1232312e-01 */
    { 0xbba71e99,0x3f7eb29d }, /*  57: -5.1000831e-03  9.9491292e-01 */
    { 0xbf6b89e9,0x3ecc06df }, /*  58: -9.2007309e-01  3.9848992e-01 */
    { 0x40c3fe26,0x43e4854d }, /*  59:  6.1247740e+00  4.5704141e+02 */
    { 0xbd0d7cdf,0x3f774ed9 }, /*  60: -3.4542914e-02  9.6604687e-01 */
    { 0x414adac2,0x489c9d5d }, /*  61:  1.2678408e+01  3.2074691e+05 */
    { 0xbc91d713,0x3f7b7b9a }, /*  62: -1.7802751e-02  9.8235476e-01 */
    { 0x3b6131b9,0x3f8070ca }, /*  63:  3.4361912e-03  1.0034420e+00 */
    { 0xbf74ef1b,0x3ec4acba }, /*  64: -9.5677346e-01  3.8413030e-01 */
    { 0x3e6e0519,0x3fa17e9d }, /*  65:  2.3244132e-01  1.2616764e+00 */
    { 0xbde79c86,0x3f64a02a }, /*  66: -1.1309151e-01  8.9306891e-01 */
    { 0x3ccc49f8,0x3f833b6e }, /*  67:  2.4937615e-02  1.0252512e+00 */
    { 0xbe245786,0x3f5a0abb }, /*  68: -1.6049013e-01  8.5172623e-01 */
    { 0xbe3f37c6,0x3f5464c4 }, /*  69: -1.8673620e-01  8.2966256e-01 */
    { 0xc1e5ab0c,0x2abfa77c }, /*  70: -2.8708519e+01  3.4044631e-13 */
    { 0x3d1f0502,0x3f85112c }, /*  71:  3.8823135e-02  1.0395865e+00 */
    { 0xbdc5b989,0x3f6870a4 }, /*  72: -9.6545286e-02  9.0796876e-01 */
    { 0xbf77b435,0x3ec28ee3 }, /*  73: -9.6759349e-01  3.7999639e-01 */
    { 0xc0569ccb,0x3d0f3aae }, /*  74: -3.3533199e+00  3.4968071e-02 */
    { 0x3f732ee9,0x4025797e }, /*  75:  9.4993454e-01  2.5855403e+00 */
    { 0xbf10e697,0x3f115a22 }, /*  76: -5.6601852e-01  5.6778157e-01 */
    { 0xa9036942,0x3f800000 }, /*  77: -2.9179140e-14  1.0000000e+00 */
    { 0xbf08edd8,0x3f15f30f }, /*  78: -5.3487921e-01  5.8574003e-01 */
    { 0x40cf0f04,0x4421770c }, /*  79:  6.4705830e+00  6.4586011e+02 */
    { 0xbe7d449e,0x3f47e7d7 }, /*  80: -2.4733207e-01  7.8088135e-01 */
    { 0x3f81a19a,0x4030338a }, /*  81:  1.0127442e+00  2.7531457e+00 */
    { 0x41ed41da,0x54dcbe6a }, /*  82:  2.9657154e+01  7.5846994e+12 */
    { 0xbf73f2b2,0x3ec56f04 }, /*  83: -9.5292199e-01  3.8561261e-01 */
    { 0xbdb38477,0x3f6a8403 }, /*  84: -8.7655000e-02  9.1607684e-01 */
    { 0xbf12d13b,0x3f104498 }, /*  85: -5.7350510e-01  5.6354666e-01 */
    { 0xc09b8066,0x3bfe1d41 }, /*  86: -4.8594236e+00  7.7549522e-03 */
    { 0xc26e7ee7,0x147ca00c }, /*  87: -5.9623928e+01  1.2754312e-26 */
    { 0x3eaeb738,0x3fb40e85 }, /*  88:  3.4124160e-01  1.4066931e+00 */
    { 0x3e7ff0af,0x3fa4587d }, /*  89:  2.4994157e-01  1.2839504e+00 */
    { 0x420dbe63,0x590b6a02 }, /*  90:  3.5435925e+01  2.4525987e+15 */
    { 0x414a92bb,0x4899e27e }, /*  91:  1.2660823e+01  3.1515594e+05 */
    { 0xbefac222,0x3f1cdea0 }, /*  92: -4.8976237e-01  6.1277199e-01 */
    { 0xabbddca8,0x3f800000 }, /*  93: -1.3490502e-12  1.0000000e+00 */
    { 0xbf763f72,0x3ec3aafe }, /*  94: -9.6190560e-01  3.8216394e-01 */
    { 0x410c4c2a,0x45c8e90d }, /*  95:  8.7685947e+00  6.4291313e+03 */
    { 0x3f77dc63,0x402886a4 }, /*  96:  9.6820658e-01  2.6332178e+00 */
    { 0xbf136560,0x3f0ff134 }, /*  97: -5.7576561e-01  5.6227422e-01 */
    { 0xc0a92363,0x3ba5f124 }, /*  98: -5.2855697e+00  5.0641466e-03 */
    { 0xc0841649,0x3c840d38 }, /*  99: -4.1277204e+00  1.6119584e-02 */
    { 0xbe578590,0x3f4f6977 }, /* 100: -2.1047044e-01  8.1020302e-01 */
    { 0x3f7aebed,0x402a8d8b }, /* 101:  9.8016244e-01  2.6648891e+00 */
    { 0x3db158a6,0x3f8b9406 }, /* 102:  8.6594865e-02  1.0904548e+00 */
    { 0xbf9d5c9f,0x3e95bec9 }, /* 103: -1.2293891e+00  2.9247120e-01 */
    { 0xbf5103c6,0x3ee24cc2 }, /* 104: -8.1646383e-01  4.4199187e-01 */
    { 0xbfbec10a,0x3e66b85f }, /* 105: -1.4902661e+00  2.2531269e-01 */
    { 0x3e4ac4f9,0x3f9c07a4 }, /* 106:  1.9801702e-01  1.2189832e+00 */
    { 0xc4152ca5,0x00000000 }, /* 107: -5.9669757e+02  0.0000000e+00 */
    { 0xbf0cb76b,0x3f13bf52 }, /* 108: -5.4967374e-01  5.7713807e-01 */
    { 0x3efb88b3,0x3fd1341a }, /* 109:  4.9127731e-01  1.6344025e+00 */
    { 0x3f7c9f49,0x402bb08e }, /* 110:  9.8680550e-01  2.6826510e+00 */
    { 0xbff6d075,0x3e14e4e3 }, /* 111: -1.9282366e+00  1.4540438e-01 */
    { 0xbe128903,0x3f5ddddf }, /* 112: -1.4310078e-01  8.6666673e-01 */
    { 0xc0ca3e4c,0x3aebe5c4 }, /* 113: -6.3201046e+00  1.7997553e-03 */
    { 0xc082e0ad,0x3c89234e }, /* 114: -4.0899262e+00  1.6740467e-02 */
    { 0xbc4db594,0x3f7cce4f }, /* 115: -1.2555499e-02  9.8752302e-01 */
    { 0xbe80424c,0x3f4745ae }, /* 116: -2.5050581e-01  7.7840698e-01 */
    { 0x3e502455,0x3f9cd9c2 }, /* 117:  2.0326360e-01  1.2253954e+00 */
    { 0xbeeedd90,0x3f208e5b }, /* 118: -4.6653414e-01  6.2717217e-01 */
    { 0x3fc1ee78,0x40919836 }, /* 119:  1.5150900e+00  4.5498304e+00 */
    { 0x3effa6d1,0x3fd2e48d }, /* 120:  4.9931958e-01  1.6475998e+00 */
    { 0xbe3c24c3,0x3f550840 }, /* 121: -1.8373398e-01  8.3215714e-01 */
    { 0x3feb5be1,0x40c93c5d }, /* 122:  1.8387414e+00  6.2886186e+00 */
    { 0xbf9ee0c0,0x3e93fb66 }, /* 123: -1.2412338e+00  2.8902739e-01 */
    { 0x3e671656,0x3fa067a9 }, /* 124:  2.2567114e-01  1.2531635e+00 */
    { 0x35f7843f,0x3f80000f }, /* 125:  1.8441423e-06  1.0000018e+00 */
    { 0x3f7533eb,0x4026c900 }, /* 126:  9.5782346e-01  2.6060181e+00 */
    { 0xbe96fe85,0x3f3e9dfc }, /* 127: -2.9491058e-01  7.4459815e-01 */
    { 0xc001c6eb,0x3e06c9d2 }, /* 128: -2.0277660e+00  1.3162926e-01 */
    { 0x3fcab779,0x409bf031 }, /* 129:  1.5837241e+00  4.8730702e+00 */
    { 0xbe5ef126,0x3f4dea18 }, /* 130: -2.1771678e-01  8.0435324e-01 */
    { 0x3f5c45c8,0x40174f0e }, /* 131:  8.6043978e-01  2.3642001e+00 */
    { 0xbf16d517,0x3f0e05de }, /* 132: -5.8918899e-01  5.5477703e-01 */
    { 0xbf0bc77e,0x3f144a0c }, /* 133: -5.4601276e-01  5.7925487e-01 */
    { 0xbe4ca18f,0x3f51a131 }, /* 134: -1.9983505e-01  8.1886584e-01 */
    { 0x3fd06f37,0x40a30fd9 }, /* 135:  1.6283940e+00  5.0956845e+00 */
    { 0x3cbea1d3,0x3f830378 }, /* 136:  2.3270523e-02  1.0235434e+00 */
    { 0xc0d6068c,0x3aa33ca9 }, /* 137: -6.6882992e+00  1.2453991e-03 */
    { 0xbfee042a,0x3e1f7cf8 }, /* 138: -1.8595021e+00  1.5575016e-01 */
    { 0xbf193237,0x3f0cb7b4 }, /* 139: -5.9842247e-01  5.4967809e-01 */
    { 0x3ea38685,0x3fb02a02 }, /* 140:  3.1938568e-01  1.3762820e+00 */
    { 0x40f6fdfa,0x450c996e }, /* 141:  7.7185030e+00  2.2495894e+03 */
    { 0x3eba24d0,0x3fb81ef0 }, /* 142:  3.6356211e-01  1.4384441e+00 */
    { 0xbde0d9c3,0x3f6561b2 }, /* 143: -1.0979035e-01  8.9602196e-01 */
    { 0xc08fdbf2,0x3c36d008 }, /* 144: -4.4955988e+00  1.1157997e-02 */
    { 0xbf68f17e,0x3ece1b17 }, /* 145: -9.0993488e-01  4.0255043e-01 */
    { 0x40284e66,0x415deec0 }, /* 146:  2.6297851e+00  1.3870789e+01 */
    { 0xbff4d8d7,0x3e17333c }, /* 147: -1.9128674e+00  1.4765638e-01 */
    { 0x415d9c6f,0x497ce1f7 }, /* 148:  1.3850692e+01  1.0358074e+06 */
    { 0x3c713073,0x3f81e5f2 }, /* 149:  1.4721024e-02  1.0148299e+00 */
    { 0xcd3094a6,0x00000000 }, /* 150: -1.8515824e+08  0.0000000e+00 */
    { 0x4072509b,0x4230594e }, /* 151:  3.7861698e+00  4.4087212e+01 */
    { 0x3d688d40,0x3f877a3e }, /* 152:  5.6775331e-02  1.0584180e+00 */
    { 0xbea68fc5,0x3f38e89c }, /* 153: -3.2531562e-01  7.2229934e-01 */
    { 0x3f521abf,0x40116ab0 }, /* 154:  8.2072061e-01  2.2721367e+00 */
    { 0xbe78fcf3,0x3f48be2f }, /* 155: -2.4315242e-01  7.8415197e-01 */
    { 0x3f0ab997,0x3fdc10bc }, /* 156:  5.4189438e-01  1.7192607e+00 */
    { 0xbfc04898,0x3e63facb }, /* 157: -1.5022154e+00  2.2263639e-01 */
    { 0xbe672bad,0x3f4c4431 }, /* 158: -2.2575255e-01  7.9791552e-01 */
    { 0x3df5b794,0x3f90510b }, /* 159:  1.1997905e-01  1.1274732e+00 */
    { 0x3eb9bdf3,0x3fb7f9f7 }, /* 160:  3.6277732e-01  1.4373158e+00 */
    { 0xb68a9187,0x3f7fffbb }, /* 161: -4.1296621e-06  9.9999589e-01 */
    { 0xc2d466ce,0x00000000 }, /* 162: -1.0620079e+02  0.0000000e+00 */
    { 0xc0a18a42,0x3bd26a2c }, /* 163: -5.0481272e+00  6.4213481e-03 */
    { 0x3f7d1ef0,0x402c0640 }, /* 164:  9.8875332e-01  2.6878815e+00 */
    { 0x3f7b33d4,0x402abd79 }, /* 165:  9.8125958e-01  2.6678145e+00 */
    { 0xbc4c4d81,0x3f7cd3dd }, /* 166: -1.2469650e-02  9.8760778e-01 */
    { 0xbea57ca4,0x3f394c14 }, /* 167: -3.2321656e-01  7.2381711e-01 */
    { 0x3e11d1e0,0x3f9396d3 }, /* 168:  1.4240217e-01  1.1530403e+00 */
    { 0x37167696,0x3f80004b }, /* 169:  8.9683072e-06  1.0000089e+00 */
    { 0xbddaaae7,0x3f661340 }, /* 170: -1.0677128e-01  8.9873123e-01 */
    { 0xbebecf9f,0x3f305ae9 }, /* 171: -3.7267777e-01  6.8888718e-01 */
    { 0x3f87183b,0x4037e289 }, /* 172:  1.0554270e+00  2.8732016e+00 */
    { 0x4159981d,0x4944bcd3 }, /* 173:  1.3599637e+01  8.0583719e+05 */
    { 0xbf588e8f,0x3edbbadf }, /* 174: -8.4592527e-01  4.2916009e-01 */
    { 0xbdab03f9,0x3f6b7dc3 }, /* 175: -8.3503671e-02  9.1988772e-01 */
    { 0xbf6cdca6,0x3ecaf999 }, /* 176: -9.2524183e-01  3.9643553e-01 */
    { 0xbe54e8da,0x3f4ff116 }, /* 177: -2.0791951e-01  8.1227243e-01 */
    { 0x3f72032f,0x4024b833 }, /* 178:  9.4536108e-01  2.5737426e+00 */
    { 0x3fcc6bb5,0x409e0732 }, /* 179:  1.5970370e+00  4.9383783e+00 */
    { 0x374e104d,0x3f800067 }, /* 180:  1.2282352e-05  1.0000123e+00 */
    { 0xbf12a629,0x3f105ce0 }, /* 181: -5.7284790e-01  5.6391716e-01 */
    { 0x3ff54b00,0x40d979c9 }, /* 182:  1.9163513e+00  6.7961164e+00 */
    { 0xbdba189a,0x3f69c379 }, /* 183: -9.0867236e-02  9.1313893e-01 */
    { 0x3e3d7694,0x3f9a03f4 }, /* 184:  1.8502265e-01  1.2032456e+00 */
    { 0xbf015e1a,0x3f1a71d0 }, /* 185: -5.0534213e-01  6.0329914e-01 */
    { 0x3fc16d25,0x40910567 }, /* 186:  1.5111433e+00  4.5319095e+00 */
    { 0x3fd02694,0x40a2b36b }, /* 187:  1.6261773e+00  5.0844016e+00 */
    { 0x3f73921b,0x4025b9a9 }, /* 188:  9.5144814e-01  2.5894568e+00 */
    { 0x3eaeaf51,0x3fb40bbd }, /* 189:  3.4118131e-01  1.4066082e+00 */
    { 0x3f1cd4c8,0x3fec3193 }, /* 190:  6.1262178e-01  1.8452629e+00 */
    { 0x3d833d9f,0x3f887898 }, /* 191:  6.4082377e-02  1.0661802e+00 */
    { 0xbea41692,0x3f39cdd8 }, /* 192: -3.2048470e-01  7.2579718e-01 */
    { 0xbe5df686,0x3f4e1c84 }, /* 193: -2.1676072e-01  8.0512261e-01 */
    { 0xbf14077a,0x3f0f962c }, /* 194: -5.7823908e-01  5.6088519e-01 */
    { 0xbf66cb52,0x3ecfd7e6 }, /* 195: -9.0153992e-01  4.0594405e-01 */
    { 0x3f747235,0x40264afc }, /* 196:  9.5486766e-01  2.5983267e+00 */
    { 0x40500fa4,0x41ce8510 }, /* 197:  3.2509546e+00  2.5814972e+01 */
    { 0x3e9f7df9,0x3faec823 }, /* 198:  3.1150797e-01  1.3654827e+00 */
    { 0x3c3afa65,0x3f817819 }, /* 199:  1.1412238e-02  1.0114776e+00 */
    { 0xd1ab6981,0x00000000 }, /* 200: -9.2026184e+10  0.0000000e+00 */
    { 0x3d392aa7,0x3f85eb54 }, /* 201:  4.5206692e-02  1.0462441e+00 */
    { 0xbf0eecd1,0x3f127a69 }, /* 202: -5.5830103e-01  5.7218033e-01 */
    { 0x3f26b7eb,0x3ff57e91 }, /* 203:  6.5124387e-01  1.9179250e+00 */
    { 0x40c8f592,0x440571af }, /* 204:  6.2799768e+00  5.3377631e+02 */
    { 0xbf0955a1,0x3f15b651 }, /* 205: -5.3646284e-01  5.8481318e-01 */
    { 0xbfdffab3,0x3e31f92b }, /* 206: -1.7498382e+00  1.7380206e-01 */
    { 0x40709996,0x422bafac }, /* 207:  3.7593741e+00  4.2921555e+01 */
    { 0xbf1a8c8a,0x3f0bf9d7 }, /* 208: -6.0370696e-01  5.4678100e-01 */
    { 0xbea5e9a1,0x3f3924a6 }, /* 209: -3.2404807e-01  7.2321546e-01 */
    { 0xbe441554,0x3f536308 }, /* 210: -1.9148761e-01  8.2572985e-01 */
    { 0x3cd35d3c,0x3f835875 }, /* 211:  2.5801294e-02  1.0261370e+00 */
    { 0x402aa4fd,0x416630dc }, /* 212:  2.6663201e+00  1.4386929e+01 */
    { 0xbf17a04f,0x3f0d954d }, /* 213: -5.9228987e-01  5.5305940e-01 */
    { 0xbfe4721b,0x3e2bdec6 }, /* 214: -1.7847322e+00  1.6784200e-01 */
    { 0xbf8546f7,0x3eb4bf26 }, /* 215: -1.0412282e+00  3.5302085e-01 */
    { 0xbf6678ed,0x3ed01ad6 }, /* 216: -9.0028268e-01  4.0645474e-01 */
    { 0x3dc89e91,0x3f8d2c64 }, /* 217:  9.7958691e-02  1.1029172e+00 */
    { 0x3d9540a5,0x3f89ad36 }, /* 218:  7.2877206e-02  1.0755985e+00 */
    { 0xbd88e003,0x3f6f7328 }, /* 219: -6.6833518e-02  9.3535089e-01 */
    { 0x3e4aeaf4,0x3f9c0d6d }, /* 220:  1.9816190e-01  1.2191597e+00 */
    { 0x402355a7,0x414d5852 }, /* 221:  2.5521028e+00  1.2834063e+01 */
    { 0x3f721652,0x4024c483 }, /* 222:  9.4565308e-01  2.5744941e+00 */
    { 0x4166f5c9,0x49e2ce35 }, /* 223:  1.4435006e+01  1.8579906e+06 */
    { 0xc0576403,0x3d0d7f89 }, /* 224: -3.3654792e+00  3.4545455e-02 */
    { 0xbf72d6ee,0x3ec64a57 }, /* 225: -9.4859207e-01  3.8728592e-01 */
    { 0xbf561235,0x3edddfb9 }, /* 226: -8.3621532e-01  4.3334749e-01 */
    { 0x3f2b5e26,0x3ff9fe61 }, /* 227:  6.6940534e-01  1.9530755e+00 */
    { 0x3f0f76ae,0x3fe02d41 }, /* 228:  5.6040466e-01  1.7513810e+00 */
    { 0x4148d73f,0x488a17f3 }, /* 229:  1.2552550e+01  2.8281559e+05 */
    { 0x3f6e4586,0x4022547c }, /* 230:  9.3074834e-01  2.5364065e+00 */
    { 0xbf0802e6,0x3f167cec }, /* 231: -5.3129423e-01  5.8784366e-01 */
    { 0x3f65fccc,0x401d2941 }, /* 232:  8.9838862e-01  2.4556429e+00 */
    { 0x3f01dca2,0x3fd493a6 }, /* 233:  5.0727284e-01  1.6607559e+00 */
    { 0xc14b2757,0x364d59f0 }, /* 234: -1.2697104e+01  3.0599731e-06 */
    { 0xc00edb3e,0x3ddbbfd4 }, /* 235: -2.2321315e+00  1.0729948e-01 */
    { 0x3e3be601,0x3f99c7c1 }, /* 236:  1.8349458e-01  1.2014085e+00 */
    { 0xc1577b6a,0x35be0f8a }, /* 237: -1.3467630e+01  1.4160626e-06 */
    { 0xbf78af8d,0x3ec1d03c }, /* 238: -9.7142869e-01  3.7854183e-01 */
    { 0x4066f305,0x4213a7a1 }, /* 239:  3.6085827e+00  3.6913700e+01 */
    { 0xbe43edb5,0x3f536b36 }, /* 240: -1.9133647e-01  8.2585466e-01 */
    { 0xc072cc97,0x3cb869a7 }, /* 241: -3.7937372e+00  2.2511316e-02 */
    { 0xc03b20db,0x3d5c0e8c }, /* 242: -2.9238803e+00  5.3724810e-02 */
    { 0x9e1b110f,0x3f800000 }, /* 243: -8.2091593e-21  1.0000000e+00 */
    { 0xbf6ee083,0x3ec96231 }, /* 244: -9.3311328e-01  3.9332727e-01 */
    { 0xbd3c978c,0x3f747af1 }, /* 245: -4.6042964e-02  9.5500094e-01 */
    { 0x38f91da2,0x3f8003e5 }, /* 246:  1.1878765e-04  1.0001189e+00 */
    { 0x3f648d2d,0x401c4833 }, /* 247:  8.9277917e-01  2.4419067e+00 */
    { 0x3df49d85,0x3f903d2c }, /* 248:  1.1944107e-01  1.1268668e+00 */
    { 0x3f72b506,0x40252ac8 }, /* 249:  9.4807470e-01  2.5807362e+00 */
    { 0xbf6812d0,0x3ececead }, /* 250: -9.0653706e-01  4.0392056e-01 */
    { 0x3fe5fee1,0x40c0fa64 }, /* 251:  1.7968408e+00  6.0305653e+00 */
    { 0x3f6b66d7,0x40208539 }, /* 252:  9.1953796e-01  2.5081313e+00 */
    { 0x3f6a2d03,0x401fc0ea }, /* 253:  9.1474932e-01  2.4961495e+00 */
    { 0xbfcf3e4e,0x3e4ad53f }, /* 254: -1.6190889e+00  1.9807909e-01 */
    { 0xbe71323d,0x3f4a46b7 }, /* 255: -2.3554321e-01  7.9014152e-01 */
    { 0x3f07d7ad,0x3fd999f6 }, /* 256:  5.3063470e-01  1.7000110e+00 */
    { 0x410e63d6,0x45e4fb15 }, /* 257:  8.8993740e+00  7.3273853e+03 */
    { 0xbf76b366,0x3ec35272 }, /* 258: -9.6367490e-01  3.8148838e-01 */
    { 0xc03a7a6e,0x3d5e4db3 }, /* 259: -2.9137225e+00  5.4273318e-02 */
    { 0xc34b2ab5,0x00000000 }, /* 260: -2.0316682e+02  0.0000000e+00 */
    { 0xbe53f792,0x3f50221b }, /* 261: -2.0699909e-01  8.1302041e-01 */
    { 0xbfd5908f,0x3e410f32 }, /* 262: -1.6684741e+00  1.8853453e-01 */
    { 0x247b4744,0x3f800000 }, /* 263:  5.4487313e-17  1.0000000e+00 */
    { 0xbf066051,0x3f1773c5 }, /* 264: -5.2490717e-01  5.9161025e-01 */
    { 0xbe88fa4b,0x3f43e855 }, /* 265: -2.6753458e-01  7.6526386e-01 */
    { 0xbff47b6e,0x3e17a1bc }, /* 266: -1.9100168e+00  1.4807791e-01 */
    { 0xc151907c,0x36098f14 }, /* 267: -1.3097775e+01  2.0497873e-06 */
    { 0xbd28db63,0x3f75a938 }, /* 268: -4.1224848e-02  9.5961332e-01 */
    { 0x3f0ed713,0x3fdfa1a9 }, /* 269:  5.5796927e-01  1.7471210e+00 */
    { 0xb9c41d10,0x3f7fe77e }, /* 270: -3.7405686e-04  9.9962604e-01 */
    { 0x3eb5b482,0x3fb68814 }, /* 271:  3.5489279e-01  1.4260278e+00 */
    { 0xbfe73aaa,0x3e282c53 }, /* 272: -1.8064778e+00  1.6423158e-01 */
    { 0x3e66cd02,0x3fa05c2d }, /* 273:  2.2539142e-01  1.2528130e+00 */
    { 0xbe019d6a,0x3f61902e }, /* 274: -1.2657705e-01  8.8110626e-01 */
    { 0x3fe2909c,0x40bbdfdd }, /* 275:  1.7700381e+00  5.8710771e+00 */
    { 0xcd95d263,0x00000000 }, /* 276: -3.1419914e+08  0.0000000e+00 */
    { 0x40b0be02,0x437a6f09 }, /* 277:  5.5231943e+00  2.5043373e+02 */
    { 0xbfdea798,0x3e33d31d }, /* 278: -1.7394896e+00  1.7561002e-01 */
    { 0x3fbed4cc,0x408e1c4a }, /* 279:  1.4908690e+00  4.4409533e+00 */
    { 0xbdb85590,0x3f69f6fa }, /* 280: -9.0006948e-02  9.1392481e-01 */
    { 0x3eb0e909,0x3fb4d485 }, /* 281:  3.4552792e-01  1.4127356e+00 */
    { 0xbe945cce,0x3f3f9974 }, /* 282: -2.8977054e-01  7.4843526e-01 */
    { 0xbe9eae56,0x3f3bc6d7 }, /* 283: -3.0992383e-01  7.3350281e-01 */
    { 0xc07e835d,0x3c99917e }, /* 284: -3.9767678e+00  1.8746134e-02 */
    { 0xc828318c,0x00000000 }, /* 285: -1.7223019e+05  0.0000000e+00 */
    { 0xbd10641b,0x3f7721fd }, /* 286: -3.5251718e-02  9.6536237e-01 */
    { 0xbe3adab1,0x3f554cf6 }, /* 287: -1.8247487e-01  8.3320558e-01 */
    { 0xc049aedb,0x3d2f4b75 }, /* 288: -3.1512973e+00  4.2796571e-02 */
    { 0x42097e67,0x5840b94d }, /* 289:  3.4373440e+01  8.4760837e+14 */
    { 0xbe6ede19,0x3f4abc9c }, /* 290: -2.3326911e-01  7.9194045e-01 */
    { 0xc0480eac,0x3d33cdfa }, /* 291: -3.1258955e+00  4.3897606e-02 */
    { 0x3f2ba443,0x3ffa42e3 }, /* 292:  6.7047518e-01  1.9551662e+00 */
    { 0x3cc642ec,0x3f8322b8 }, /* 293:  2.4201833e-02  1.0244970e+00 */
    { 0xc011c2e9,0x3dd1ff78 }, /* 294: -2.2775214e+00  1.0253805e-01 */
    { 0x4096be9b,0x42de4659 }, /* 295:  4.7107673e+00  1.1113740e+02 */
    { 0x4043a8b9,0x41aa2388 }, /* 296:  3.0571730e+00  2.1267349e+01 */
    { 0xbbb4118c,0x3f7e98da }, /* 297: -5.4952558e-03  9.9451983e-01 */
    { 0xbd881d17,0x3f6f89f4 }, /* 298: -6.6461734e-02  9.3569875e-01 */
    { 0xbe5d0fd4,0x3f4e4af8 }, /* 299: -2.1588069e-01  8.0583143e-01 */
    { 0xc0d4b220,0x3aaa29cb }, /* 300: -6.6467438e+00  1.2982426e-03 */
    { 0xadccaf1e,0x3f800000 }, /* 301: -2.3269883e-11  1.0000000e+00 */
    { 0x3eace1f7,0x3fb369ca }, /* 302:  3.3766147e-01  1.4016659e+00 */
    { 0xc3b65eb6,0x00000000 }, /* 303: -3.6473993e+02  0.0000000e+00 */
    { 0xbf3092b8,0x3f006fe1 }, /* 304: -6.8973875e-01  5.0170714e-01 */
    { 0xbe961555,0x3f3ef4e1 }, /* 305: -2.9313150e-01  7.4592406e-01 */
    { 0xce0a6616,0x00000000 }, /* 306: -5.8048653e+08  0.0000000e+00 */
    { 0x3d094375,0x3f845cb7 }, /* 307:  3.3511598e-02  1.0340794e+00 */
    { 0x3f75fbec,0x40274b81 }, /* 308:  9.6087527e-01  2.6139834e+00 */
    { 0xbf6b08c5,0x3ecc6de5 }, /* 309: -9.1810256e-01  3.9927593e-01 */
    { 0x3f0a60f5,0x3fdbc498 }, /* 310:  5.4054195e-01  1.7169371e+00 */
    { 0xbf79c8d6,0x3ec0fbbc }, /* 311: -9.7572076e-01  3.7692058e-01 */
    { 0x3fdcee5a,0x40b3c8e0 }, /* 312:  1.7260239e+00  5.6182709e+00 */
    { 0xc0b33115,0x3b7267e6 }, /* 313: -5.5997415e+00  3.6988198e-03 */
    { 0x3f77f0f2,0x4028942d }, /* 314:  9.6852028e-01  2.6340439e+00 */
    { 0x399d22d6,0x3f8009d3 }, /* 315:  2.9971328e-04  1.0002998e+00 */
    { 0xbfb7d492,0x3e738b3c }, /* 316: -1.4361746e+00  2.3783582e-01 */
    { 0x3e8c635d,0x3fa86163 }, /* 317:  2.7419558e-01  1.3154720e+00 */
    { 0x40090c54,0x41082daf }, /* 318:  2.1413774e+00  8.5111532e+00 */
    { 0xbf6af4e1,0x3ecc7dc8 }, /* 319: -9.1779906e-01  3.9939713e-01 */
    { 0x41c0cc04,0x50da0844 }, /* 320:  2.4099617e+01  2.9263798e+10 */
    { 0x3e39c19e,0x3f99757c }, /* 321:  1.8140265e-01  1.1988978e+00 */
    { 0xc0164d82,0x3dc39cee }, /* 322: -2.3484807e+00  9.5514163e-02 */
    { 0x405847a4,0x41ead19d }, /* 323:  3.3793726e+00  2.9352350e+01 */
    { 0xbf24542f,0x3f06bab6 }, /* 324: -6.4190954e-01  5.2628648e-01 */
    { 0xbced21b9,0x3f78b224 }, /* 325: -2.8946744e-02  9.7146821e-01 */
    { 0x3c1606c0,0x3f812d6e }, /* 326:  9.1568828e-03  1.0091989e+00 */
    { 0x3a8e205e,0x3f80238d }, /* 327:  1.0843386e-03  1.0010849e+00 */
    { 0xc07ee2d3,0x3c98ad19 }, /* 328: -3.9825943e+00  1.8637227e-02 */
    { 0x3fe0ddf8,0x40b96620 }, /* 329:  1.7567739e+00  5.7937164e+00 */
    { 0xbfead5bf,0x3e238074 }, /* 330: -1.8346480e+00  1.5966970e-01 */
    { 0xc409da53,0x00000000 }, /* 331: -5.5141132e+02  0.0000000e+00 */
    { 0xc001407b,0x3e07e61e }, /* 332: -2.0195606e+00  1.3271376e-01 */
    { 0xbfde5f77,0x3e34388e }, /* 333: -1.7372884e+00  1.7599699e-01 */
    { 0xbfdb296f,0x3e38cc99 }, /* 334: -1.7122020e+00  1.8046798e-01 */
    { 0xb9fe8d1b,0x3f7fe030 }, /* 335: -4.8551787e-04  9.9951458e-01 */
    { 0x3c5203d9,0x3f81a6bc }, /* 336:  1.2818300e-02  1.0129008e+00 */
    { 0x3ffce2b3,0x40e6c419 }, /* 337:  1.9756683e+00  7.2114377e+00 */
    { 0x40475c4f,0x41b444e2 }, /* 338:  3.1150091e+00  2.2533634e+01 */
    { 0xbf67b110,0x3ecf1db3 }, /* 339: -9.0504551e-01  4.0452346e-01 */
    { 0x3a602393,0x3f801c08 }, /* 340:  8.5502228e-04  1.0008554e+00 */
    { 0x3fe16ab3,0x40ba3267 }, /* 341:  1.7610687e+00  5.8186526e+00 */
    { 0x3e73c70b,0x3fa267b9 }, /* 342:  2.3806398e-01  1.2687904e+00 */
    { 0xbff636b8,0x3e159824 }, /* 343: -1.9235449e+00  1.4608818e-01 */
    { 0x3f16ac0d,0x3fe69432 }, /* 344:  5.8856279e-01  1.8013976e+00 */
    { 0xc1fe6444,0x288b7814 }, /* 345: -3.1798958e+01  1.5484176e-14 */
    { 0xb435bc99,0x3f7ffffd }, /* 346: -1.6925550e-07  9.9999982e-01 */
    { 0x3ff72da6,0x40dcb3e3 }, /* 347:  1.9310806e+00  6.8969588e+00 */
    { 0x3f77c5cc,0x402877c6 }, /* 348:  9.6786189e-01  2.6323104e+00 */
    { 0xbf729dbf,0x3ec676a7 }, /* 349: -9.4771951e-01  3.8762400e-01 */
    { 0xbdf88275,0x3f62bf3c }, /* 350: -1.2134258e-01  8.8573050e-01 */
    { 0xbfeb3d84,0x3e22fc1c }, /* 351: -1.8378148e+00  1.5916485e-01 */
    { 0x40077ea3,0x4104e9ab }, /* 352:  2.1171043e+00  8.3070478e+00 */
    { 0xbfb01042,0x3e8163c1 }, /* 353: -1.3754961e+00  2.5271419e-01 */
    { 0x405891b8,0x41ebe206 }, /* 354:  3.3838940e+00  2.9485363e+01 */
    { 0xbe80ca8d,0x3f4710ad }, /* 355: -2.5154534e-01  7.7759820e-01 */
    { 0xbe12490f,0x3f5debba }, /* 356: -1.4285682e-01  8.6687815e-01 */
    { 0x3f7fcc3a,0x402dd529 }, /* 357:  9.9921000e-01  2.7161353e+00 */
    { 0x3fe97637,0x40c64674 }, /* 358:  1.8239201e+00  6.1961002e+00 */
    { 0x3f74f905,0x4026a2a6 }, /* 359:  9.5692474e-01  2.6036773e+00 */
    { 0xbf400000,0x3ef1da07 }, /* 360: -7.5000000e-01  4.7236654e-01 */
    { 0x407ad625,0x424976fe }, /* 361:  3.9193203e+00  5.0366203e+01 */
    { 0xc1f66a7b,0x293cfbd6 }, /* 362: -3.0801992e+01  4.1962819e-14 */
    { 0xbf71dc3b,0x3ec70ce5 }, /* 363: -9.4476670e-01  3.8877025e-01 */
    { 0xc0bf609e,0x3b25a396 }, /* 364: -5.9805441e+00  2.5274507e-03 */
    { 0x3d473c7f,0x3f86614b }, /* 365:  4.8641678e-02  1.0498441e+00 */
    { 0x3f56a864,0x401406bc }, /* 366:  8.3850694e-01  2.3129110e+00 */
    { 0xc0f69fdd,0x39ebc09a }, /* 367: -7.7070146e+00  4.4966192e-04 */
    { 0x3ff5f251,0x40da96ca }, /* 368:  1.9214574e+00  6.8309069e+00 */
    { 0x3e95156c,0x3fab43b8 }, /* 369:  2.9117906e-01  1.3380041e+00 */
    { 0x3e4d8cb3,0x3f9c743c }, /* 370:  2.0073204e-01  1.2222972e+00 */
    { 0x41733db5,0x4a745389 }, /* 371:  1.5202565e+01  4.0030422e+06 */
    { 0x3f2aa106,0x3ff945f5 }, /* 372:  6.6651952e-01  1.9474474e+00 */
    { 0xc1a1aff7,0x30e569d1 }, /* 373: -2.0210920e+01  1.6692018e-09 */
    { 0x3f119e07,0x3fe2121a }, /* 374:  5.6881756e-01  1.7661774e+00 */
    { 0x3f7e87ea,0x402cf97c }, /* 375:  9.9426138e-01  2.7027273e+00 */
    { 0x40e6499d,0x44a6d76f }, /* 376:  7.1964860e+00  1.3347323e+03 */
    { 0x40545246,0x41dcbc2c }, /* 377:  3.3175216e+00  2.7591881e+01 */
    { 0xbef94991,0x3f1d522a }, /* 378: -4.8688939e-01  6.1453497e-01 */
    { 0x3fe88f8a,0x40c4e263 }, /* 379:  1.8168805e+00  6.1526351e+00 */
    { 0x41fa551c,0x560d73db }, /* 380:  3.1291557e+01  3.8882184e+13 */
    { 0x3ff7c0cc,0x40ddb22d }, /* 381:  1.9355712e+00  6.9280000e+00 */
    { 0xc0167241,0x3dc32cbf }, /* 382: -2.3507235e+00  9.5300190e-02 */
    { 0xc08fef48,0x3c3661b3 }, /* 383: -4.4979591e+00  1.1131692e-02 */
    { 0xbd432f06,0x3f74164d }, /* 384: -4.7652267e-02  9.5346528e-01 */
    { 0x4028bde7,0x415f72bb }, /* 385:  2.6365907e+00  1.3965510e+01 */
    { 0xc03a0681,0x3d5fe1cc }, /* 386: -2.9066470e+00  5.4658696e-02 */
    { 0xbeffd565,0x3f1b5284 }, /* 387: -4.9967495e-01  6.0672784e-01 */
    { 0x3e3ff20f,0x3f9a63a7 }, /* 388:  1.8744682e-01  1.2061661e+00 */
    { 0x3e6f9b73,0x3fa1bebf }, /* 389:  2.3399143e-01  1.2636336e+00 */
    { 0xbdb2cace,0x3f6a9947 }, /* 390: -8.7300882e-02  9.1640133e-01 */
    { 0x3eefdd3f,0x3fcc7d3c }, /* 391:  4.6848485e-01  1.5975718e+00 */
    { 0x411ad8bd,0x467964b5 }, /* 392:  9.6779146e+00  1.5961177e+04 */
    { 0xbf22d608,0x3f07846c }, /* 393: -6.3607836e-01  5.2936435e-01 */
    { 0x3db4bece,0x3f8bcf60 }, /* 394:  8.8254556e-02  1.0922661e+00 */
    { 0xbfbec485,0x3e66b219 }, /* 395: -1.4903723e+00  2.2528876e-01 */
    { 0xc270a72b,0x14135116 }, /* 396: -6.0163250e+01  7.4375948e-27 */
    { 0xbf745d2d,0x3ec51cf7 }, /* 397: -9.5454675e-01  3.8498661e-01 */
    { 0x3e596133,0x3f9e45a2 }, /* 398:  2.1228485e-01  1.2365000e+00 */
    { 0x3f18b175,0x3fe86811 }, /* 399:  5.9645778e-01  1.8156759e+00 */
    { 0xbe6d2ea8,0x3f4b1219 }, /* 400: -2.3162329e-01  7.9324490e-01 */
    { 0x3f7e77e6,0x402ceeaa }, /* 401:  9.9401700e-01  2.7020669e+00 */
    { 0xbff6f163,0x3e14be99 }, /* 402: -1.9292415e+00  1.4525832e-01 */
    { 0xbf025b24,0x3f19d973 }, /* 403: -5.0920320e-01  6.0097426e-01 */
    { 0x402b6f1e,0x41690c5e }, /* 404:  2.6786571e+00  1.4565519e+01 */
    { 0xbf550abb,0x3edec48a }, /* 405: -8.3219498e-01  4.3509322e-01 */
    { 0xbf02e318,0x3f1987d4 }, /* 406: -5.1127768e-01  5.9972882e-01 */
    { 0x3f7a2ced,0x402a0e7b }, /* 407:  9.7724801e-01  2.6571338e+00 */
    { 0x40138144,0x41205960 }, /* 408:  2.3047647e+00  1.0021820e+01 */
    { 0xc1b8fcd4,0x2ec77433 }, /* 409: -2.3123451e+01  9.0701134e-11 */
    { 0xbe94ef1d,0x3f3f62bc }, /* 410: -2.9088679e-01  7.4760032e-01 */
    { 0xc024ceca,0x3d9bf1b0 }, /* 411: -2.5751214e+00  7.6144576e-02 */
    { 0x3c65c9cd,0x3f81ced1 }, /* 412:  1.4025164e-02  1.0141240e+00 */
    { 0x3cfd7dee,0x3f8405d2 }, /* 413:  3.0943837e-02  1.0314276e+00 */
    { 0x426c0877,0x6a0c2906 }, /* 414:  5.9008266e+01  4.2360836e+25 */
    { 0xfd85b337,0x00000000 }, /* 415: -2.2214733e+37  0.0000000e+00 */
    { 0x41aa4272,0x4ed08665 }, /* 416:  2.1282444e+01  1.7492343e+09 */
    { 0x404372be,0x41a99444 }, /* 417:  3.0538783e+00  2.1197395e+01 */
    { 0xc0af94de,0x3b87ad9a }, /* 418: -5.4869223e+00  4.1405680e-03 */
    { 0xbf064fb6,0x3f177d99 }, /* 419: -5.2465379e-01  5.9176022e-01 */
    { 0xbd96d8aa,0x3f6dd267 }, /* 420: -7.3655441e-02  9.2899173e-01 */
    { 0x4032bd8d,0x41829daa }, /* 421:  2.7928193e+00  1.6326984e+01 */
    { 0xbffb1577,0x3e10026e }, /* 422: -1.9615926e+00  1.4063427e-01 */
    { 0xbf8907a2,0x3eaf864c }, /* 423: -1.0705454e+00  3.4282148e-01 */
    { 0x3e7ece02,0x3fa429dc }, /* 424:  2.4883273e-01  1.2825274e+00 */
    { 0x3f02b256,0x3fd54564 }, /* 425:  5.1053369e-01  1.6661801e+00 */
    { 0xbf5970a2,0x3edaf929 }, /* 426: -8.4937489e-01  4.2768219e-01 */
    { 0xbf06e5de,0x3f1724d7 }, /* 427: -5.2694499e-01  5.9040588e-01 */
    { 0xbf1f03bd,0x3f098e2e }, /* 428: -6.2115079e-01  5.3732574e-01 */
    { 0x3e4c8ecd,0x3f9c4d76 }, /* 429:  1.9976349e-01  1.2211139e+00 */
    { 0xbf75d518,0x3ec3fc58 }, /* 430: -9.6028280e-01  3.8278461e-01 */
    { 0xbf6cfe13,0x3ecadf1a }, /* 431: -9.2575186e-01  3.9623338e-01 */
    { 0x3e9aa4e8,0x3fad2279 }, /* 432:  3.0203938e-01  1.3526145e+00 */
    { 0x3e09609e,0x3f92609a }, /* 433:  1.3415763e-01  1.1435730e+00 */
    { 0x3f636a19,0x401b96e6 }, /* 434:  8.8833767e-01  2.4310851e+00 */
    { 0x3e5348cc,0x3f9d552c }, /* 435:  2.0633239e-01  1.2291617e+00 */
    { 0xb94403ee,0x3f7ff3c0 }, /* 436: -1.8693481e-04  9.9981308e-01 */
    { 0xbf5a0479,0x3eda7ad9 }, /* 437: -8.5163075e-01  4.2671850e-01 */
    { 0x3d3f16bd,0x3f861cee }, /* 438:  4.6652544e-02  1.0477579e+00 */
    { 0xbc21f707,0x3f7d7b55 }, /* 439: -9.8855561e-03  9.9016315e-01 */
    { 0xc2a9258f,0x027d9acf }, /* 440: -8.4573357e+01  1.8631932e-37 */
    { 0x404d730b,0x41c64303 }, /* 441:  3.2101467e+00  2.4782721e+01 */
    { 0xbefe586b,0x3f1bc642 }, /* 442: -4.9676833e-01  6.0849392e-01 */
    { 0xc46b8207,0x00000000 }, /* 443: -9.4203168e+02  0.0000000e+00 */
    { 0xc025ce9c,0x3d998731 }, /* 444: -2.5907354e+00  7.4964888e-02 */
    { 0x3f6d99e6,0x4021e7cd }, /* 445:  9.2812955e-01  2.5297730e+00 */
    { 0x4017dd11,0x412ba65b }, /* 446:  2.3728678e+00  1.0728114e+01 */
    { 0xbb5c2072,0x3f7f243e }, /* 447: -3.3588675e-03  9.9664676e-01 */
    { 0xbf7e53ad,0x3ebd96df }, /* 448: -9.9346429e-01  3.7029168e-01 */
    { 0xc038069f,0x3d66fcb5 }, /* 449: -2.8754041e+00  5.6393344e-02 */
    { 0xba4cf659,0x3f7fccc8 }, /* 450: -7.8186911e-04  9.9921846e-01 */
    { 0x3ea63c66,0x3fb11963 }, /* 451:  3.2467955e-01  1.3835872e+00 */
    { 0xbb091eae,0x3f7f7706 }, /* 452: -2.0922828e-03  9.9790990e-01 */
    { 0xbbdb01e1,0x3f7e4b72 }, /* 453: -6.6835736e-03  9.9333870e-01 */
    { 0xbc2f23dc,0x3f7d472c }, /* 454: -1.0689702e-02  9.8936725e-01 */
    { 0x3e9bd66c,0x3fad89e7 }, /* 455:  3.0437028e-01  1.3557709e+00 */
    { 0xc0036ef2,0x3e03583f }, /* 456: -2.0536466e+00  1.2826632e-01 */
    { 0x3a90db15,0x3f80243c }, /* 457:  1.1051620e-03  1.0011058e+00 */
    { 0xbf2ae5d9,0x3f0350ef }, /* 458: -6.6756970e-01  5.1295370e-01 */
    { 0x3e996325,0x3facb5cd }, /* 459:  2.9958454e-01  1.3492981e+00 */
    { 0x3cb09b05,0x3f82ca18 }, /* 460:  2.1558294e-02  1.0217924e+00 */
    { 0xbe04a954,0x3f60e4a3 }, /* 461: -1.2955219e-01  8.7848872e-01 */
    { 0xbc856fea,0x3f7bdd26 }, /* 462: -1.6288716e-02  9.8384321e-01 */
    { 0xbf5a07ed,0x3eda77e6 }, /* 463: -8.5168344e-01  4.2669600e-01 */
    { 0xbeb1e588,0x3f34dc28 }, /* 464: -3.4745431e-01  7.0648432e-01 */
    { 0x429e2c07,0x7888e61d }, /* 465:  7.9085991e+01  2.2213113e+34 */
    { 0xbed2ba07,0x3f29a083 }, /* 466: -4.1157553e-01  6.6260546e-01 */
    { 0xbe9e3bae,0x3f3bf0e9 }, /* 467: -3.0904907e-01  7.3414475e-01 */
    { 0xc12cc893,0x37ab4cd2 }, /* 468: -1.0798968e+01  2.0420561e-05 */
    { 0x3e63cc9f,0x3f9fe406 }, /* 469:  2.2246026e-01  1.2491462e+00 */
    { 0xbe0ad830,0x3f5f8a0e }, /* 470: -1.3559031e-01  8.7320030e-01 */
    { 0xbdf6e97c,0x3f62ec88 }, /* 471: -1.2056252e-01  8.8642168e-01 */
    { 0x3e4a1751,0x3f9bed30 }, /* 472:  1.9735457e-01  1.2181759e+00 */
    { 0x412039f0,0x46ae887c }, /* 473:  1.0014145e+01  2.2340242e+04 */
    { 0xbfeba305,0x3e227b10 }, /* 474: -1.8409125e+00  1.5867257e-01 */
    { 0xc0350979,0x3d7207c3 }, /* 475: -2.8287032e+00  5.9089433e-02 */
    { 0x40045030,0x40fcef35 }, /* 476:  2.0673943e+00  7.9042001e+00 */
    { 0x3ed7cb90,0x3fc3193f }, /* 477:  4.2147493e-01  1.5242079e+00 */
    { 0x3f6d7514,0x4021d085 }, /* 478:  9.2756772e-01  2.5283520e+00 */
    { 0x3c7962ee,0x3f81f697 }, /* 479:  1.5221341e-02  1.0153378e+00 */
    { 0xbf54de8d,0x3edeeaff }, /* 480: -8.3152086e-01  4.3538663e-01 */
    { 0x3f70793c,0x4023bb7a }, /* 481:  9.3934989e-01  2.5583177e+00 */
    { 0xbf014b3a,0x3f1a7d33 }, /* 482: -5.0505412e-01  6.0347289e-01 */
    { 0x3e8d001b,0x3fa894f7 }, /* 483:  2.7539143e-01  1.3170460e+00 */
    { 0xbef38cbb,0x3f1f1808 }, /* 484: -4.7568306e-01  6.2146044e-01 */
    { 0xc009ce05,0x3dedcc2a }, /* 485: -2.1531994e+00  1.1611207e-01 */
    { 0xbf76beca,0x3ec349c1 }, /* 486: -9.6384871e-01  3.8142207e-01 */
    { 0x3f7839ad,0x4028c419 }, /* 487:  9.6963006e-01  2.6369689e+00 */
    { 0xbf816f12,0x3eba418f }, /* 488: -1.0112021e+00  3.6378142e-01 */
    { 0x3c51378d,0x3f81a51e }, /* 489:  1.2769592e-02  1.0128515e+00 */
    { 0xbe82a10b,0x3f465a14 }, /* 490: -2.5513491e-01  7.7481198e-01 */
    { 0xbf1d4bec,0x3f0a7b4c }, /* 491: -6.1443973e-01  5.4094386e-01 */
    { 0xc22d292a,0x203acfe7 }, /* 492: -4.3290199e+01  1.5823602e-19 */
    { 0x2c2671a7,0x3f800000 }, /* 493:  2.3653109e-12  1.0000000e+00 */
    { 0x40ea0210,0x44bb6983 }, /* 494:  7.3127518e+00  1.4992972e+03 */
    { 0x3cb8f33c,0x3f82ec37 }, /* 495:  2.2576921e-02  1.0228337e+00 */
    { 0xbcbe6b56,0x3f7a1e37 }, /* 496: -2.3244541e-02  9.7702354e-01 */
    { 0xbe47dc33,0x3f529bce }, /* 497: -1.9517593e-01  8.2268989e-01 */
    { 0xbfca3b29,0x3e52eee5 }, /* 498: -1.5799304e+00  2.0598944e-01 */
    { 0xc03420e6,0x3d757d91 }, /* 499: -2.8145080e+00  5.9934203e-02 */
    { 0xbedc4b9d,0x3f267c7f }, /* 500: -4.3026438e-01  6.5033716e-01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = exp (x.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 55) x_exit (i+1);
    }
    return 0;
}
