/* Test of atan() function. 500 random cases.
   $Id: atan-500.c,v 1.1 2007/02/05 21:35:58 dmix Exp $
 */
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include "progmem.h"

union lofl_u {
    long lo;
    float fl;
};

volatile union lofl_u v = { .lo = 1 };

PROGMEM const struct {		/* Table of test cases.	*/
    long x;		/* argument	*/
    long z;		/* atan(x)	*/
} t[] = {

    /* x, atan(x)	*/
    { 0xbf449eeb,0xbf27ab05 }, /*   1: -7.6804990e-01 -6.5495330e-01 */
    { 0xb84cdc3e,0xb84cdc3e }, /*   2: -4.8842507e-05 -4.8842507e-05 */
    { 0x4012ebdf,0x3f947a16 }, /*   3:  2.2956464e+00  1.1599758e+00 */
    { 0xbf6e291d,0xbf3fd301 }, /*   4: -9.3031484e-01 -7.4931341e-01 */
    { 0xbeed6d6e,0xbede50ad }, /*   5: -4.6372551e-01 -4.3420926e-01 */
    { 0xbf1437c6,0xbf065a6c }, /*   6: -5.7897604e-01 -5.2481723e-01 */
    { 0xbfbd1923,0xbf79ca66 }, /*   7: -1.4773296e+00 -9.7574461e-01 */
    { 0xbff02b32,0xbf8a627e }, /*   8: -1.8763182e+00 -1.0811307e+00 */
    { 0x3f8c5b38,0x3f54d74b }, /*   9:  1.0965338e+00  8.3141011e-01 */
    { 0xbd35f0f4,0xbd35d25b }, /*  10: -4.4419244e-02 -4.4390064e-02 */
    { 0x335fd8ab,0x335fd8ab }, /*  11:  5.2118292e-08  5.2118292e-08 */
    { 0x3ea8bbe5,0x3ea2feb1 }, /*  12:  3.2955852e-01  3.1834939e-01 */
    { 0xbef6c86c,0xbee5f600 }, /*  13: -4.8199785e-01 -4.4914246e-01 */
    { 0x3f15dfc0,0x3f079711 }, /*  14:  5.8544540e-01  5.2964884e-01 */
    { 0x3e68deee,0x3e64f9fe }, /*  15:  2.2741291e-01  2.2360989e-01 */
    { 0xbec34f44,0xbeba9604 }, /*  16: -3.8146412e-01 -3.6442578e-01 */
    { 0x3f17aaea,0x3f08ebfb }, /*  17:  5.9245169e-01  5.3485078e-01 */
    { 0xbec5f029,0xbebce06d }, /*  18: -3.8659790e-01 -3.6889973e-01 */
    { 0xb8cf288a,0xb8cf288a }, /*  19: -9.8780802e-05 -9.8780802e-05 */
    { 0xbf54c3e4,0xbf318470 }, /*  20: -8.3111405e-01 -6.9342709e-01 */
    { 0x3f1a9653,0x3f0b1271 }, /*  21:  6.0385627e-01  5.4325014e-01 */
    { 0xbee3fff7,0xbed68073 }, /*  22: -4.4531223e-01 -4.1894874e-01 */
    { 0x08694f3f,0x08694f3f }, /*  23:  7.0209040e-34  7.0209040e-34 */
    { 0xbe79c23e,0xbe74f9c6 }, /*  24: -2.4390504e-01 -2.3923406e-01 */
    { 0x3d34df74,0x3d34c164 }, /*  25:  4.4158414e-02  4.4129744e-02 */
    { 0x3e0a0218,0x3e092e7c }, /*  26:  1.3477361e-01  1.3396639e-01 */
    { 0xb3428e1b,0xb3428e1b }, /*  27: -4.5298389e-08 -4.5298389e-08 */
    { 0x3ee154a3,0x3ed4451a }, /*  28:  4.4009885e-01  4.1458970e-01 */
    { 0x409e2552,0x3faf81bf }, /*  29:  4.9420557e+00  1.3711470e+00 */
    { 0xbee5895d,0xbed7c861 }, /*  30: -4.4831362e-01 -4.2145064e-01 */
    { 0x3de2a29e,0x3de1b783 }, /*  31:  1.1066173e-01  1.1021330e-01 */
    { 0x3f3cf576,0x3f22c760 }, /*  32:  7.3812044e-01  6.3585472e-01 */
    { 0xbe92c0a5,0xbe8eebc0 }, /*  33: -2.8662601e-01 -2.7914238e-01 */
    { 0x3f7c148f,0x3f471646 }, /*  34:  9.8468870e-01  7.7768362e-01 */
    { 0x3e8a0471,0x3e86d01b }, /*  35:  2.6956514e-01  2.6330647e-01 */
    { 0xbfef3327,0xbf8a2b73 }, /*  36: -1.8687485e+00 -1.0794510e+00 */
    { 0x3f0dfce4,0x3f01a358 }, /*  37:  5.5464005e-01  5.0639868e-01 */
    { 0x3eda754b,0x3ece7bf6 }, /*  38:  4.2667612e-01  4.0328950e-01 */
    { 0x3f1ac22e,0x3f0b3292 }, /*  39:  6.0452545e-01  5.4374039e-01 */
    { 0xbee07cf5,0xbed3904f }, /*  40: -4.3845335e-01 -4.1321036e-01 */
    { 0x4139214f,0x3fbe06e0 }, /*  41:  1.1570632e+01  1.4845848e+00 */
    { 0x3f68fbe1,0x3f3d0566 }, /*  42:  9.1009337e-01  7.3836362e-01 */
    { 0xbda5892f,0xbda52d42 }, /*  43: -8.0828063e-02 -8.0652729e-02 */
    { 0xbd4abfd0,0xbd4a957c }, /*  44: -4.9499333e-02 -4.9458966e-02 */
    { 0xbeb1f50a,0xbeab44fd }, /*  45: -3.4757262e-01 -3.3451071e-01 */
    { 0x3f5e3a2a,0x3f370352 }, /*  46:  8.6807501e-01  7.1489441e-01 */
    { 0x40070737,0x3f90685a }, /*  47:  2.1098154e+00  1.1281846e+00 */
    { 0x3f6aac73,0x3f3df13a }, /*  48:  9.1669387e-01  7.4196208e-01 */
    { 0x3ebec159,0x3eb69933 }, /*  49:  3.7256888e-01  3.5663757e-01 */
    { 0xbf17c717,0xbf0900d5 }, /*  50: -5.9288162e-01 -5.3516895e-01 */
    { 0xbf170fc9,0xbf087909 }, /*  51: -5.9008461e-01 -5.3309685e-01 */
    { 0x3e158cb9,0x3e147ff6 }, /*  52:  1.4604463e-01  1.4501938e-01 */
    { 0xbf7b3bc5,0xbf46a806 }, /*  53: -9.8138076e-01 -7.7600133e-01 */
    { 0xbfe809e2,0xbf8889a6 }, /*  54: -1.8128016e+00 -1.0667007e+00 */
    { 0xbe392c41,0xbe373172 }, /*  55: -1.8083288e-01 -1.7889956e-01 */
    { 0x43422629,0x3fc86714 }, /*  56:  1.9414906e+02  1.5656457e+00 */
    { 0x3f8d2914,0x3f5591a7 }, /*  57:  1.1028161e+00  8.3425373e-01 */
    { 0x3eebc65d,0x3edcf40e }, /*  58:  4.6049777e-01  4.3154949e-01 */
    { 0x3f0c8ce5,0x3f008940 }, /*  59:  5.4902488e-01  5.0209427e-01 */
    { 0x3f8d8474,0x3f55e400 }, /*  60:  1.1056046e+00  8.3551025e-01 */
    { 0xbfaa3415,0xbf6d0db1 }, /*  61: -1.3297144e+00 -9.2599016e-01 */
    { 0xbea8b812,0xbea2fb3e }, /*  62: -3.2952935e-01 -3.1832308e-01 */
    { 0x3ede70c0,0x3ed1d7fb }, /*  63:  4.3445396e-01  4.0985093e-01 */
    { 0x3f13eda3,0x3f0622df }, /*  64:  5.7784480e-01  5.2396959e-01 */
    { 0xc3b6b564,0xbfc8b62e }, /*  65: -3.6541711e+02 -1.5680597e+00 */
    { 0x3e7f493a,0x3e7a2fa3 }, /*  66:  2.4930277e-01  2.4432234e-01 */
    { 0x3e856d63,0x3e828634 }, /*  67:  2.6060018e-01  2.5493014e-01 */
    { 0x164c1761,0x164c1761 }, /*  68:  1.6486366e-25  1.6486366e-25 */
    { 0xbf57272a,0xbf32ec53 }, /*  69: -8.4044135e-01 -6.9891852e-01 */
    { 0xbe04f328,0xbe0435d3 }, /*  70: -1.2983382e-01 -1.2911157e-01 */
    { 0xbf7dcfa5,0xbf47f67a }, /*  71: -9.9144965e-01 -7.8110468e-01 */
    { 0x3ea7a473,0x3ea20276 }, /*  72:  3.2742652e-01  3.1642503e-01 */
    { 0x3eead0df,0x3edc295f }, /*  73:  4.5862481e-01  4.3000314e-01 */
    { 0xbfb15a0a,0xbf721523 }, /*  74: -1.3855603e+00 -9.4563502e-01 */
    { 0xbf1c0ba0,0xbf0c234e }, /*  75: -6.0955238e-01 -5.4741371e-01 */
    { 0xbf2383d1,0xbf11836f }, /*  76: -6.3873011e-01 -5.6841177e-01 */
    { 0xbeacf4b8,0xbea6cb3a }, /*  77: -3.3780456e-01 -3.2576925e-01 */
    { 0x3f651142,0x3f3adcce }, /*  78:  8.9479458e-01  7.2993171e-01 */
    { 0x3df107fc,0x3defed70 }, /*  79:  1.1769101e-01  1.1715209e-01 */
    { 0x3ef025d0,0x3ee08ca6 }, /*  80:  4.6903849e-01  4.3857306e-01 */
    { 0xbe7c3b32,0xbe774eda }, /*  81: -2.4631956e-01 -2.4151173e-01 */
    { 0x3b7e453a,0x3b7e44e6 }, /*  82:  3.8798586e-03  3.8798391e-03 */
    { 0xbf718ccb,0xbf41a112 }, /*  83: -9.4355458e-01 -7.5636399e-01 */
    { 0x3f43e34e,0x3f2734db }, /*  84:  7.6518714e-01  6.5315026e-01 */
    { 0x3f4e75ec,0x3f2dbe39 }, /*  85:  8.0648685e-01  6.7868382e-01 */
    { 0xc30bc179,0xbfc82564 }, /*  86: -1.3975575e+02 -1.5636411e+00 */
    { 0xbeea3c27,0xbedbae72 }, /*  87: -4.5749018e-01 -4.2906529e-01 */
    { 0xbf502008,0xbf2ebf96 }, /*  88: -8.1298876e-01 -6.8261087e-01 */
    { 0x3e0abc55,0x3e09e562 }, /*  89:  1.3548405e-01  1.3466409e-01 */
    { 0x3e2ea54e,0x3e2cfb37 }, /*  90:  1.7055246e-01  1.6892706e-01 */
    { 0x3f8ca6ab,0x3f551bbb }, /*  91:  1.0988363e+00  8.3245438e-01 */
    { 0xbf5ba8f5,0xbf358aab }, /*  92: -8.5804683e-01 -7.0914716e-01 */
    { 0x41556039,0x3fbf7b55 }, /*  93:  1.3335992e+01  1.4959513e+00 */
    { 0xbeab84ec,0xbea580d2 }, /*  94: -3.3499849e-01 -3.2324845e-01 */
    { 0x3f199475,0x3f0a5527 }, /*  95:  5.9992152e-01  5.4036182e-01 */
    { 0xbee5211e,0xbed7718e }, /*  96: -4.4751829e-01 -4.2078823e-01 */
    { 0x3e62c430,0x3e5f2a32 }, /*  97:  2.2145152e-01  2.1793440e-01 */
    { 0xbf19a96f,0xbf0a6493 }, /*  98: -6.0024160e-01 -5.4059714e-01 */
    { 0xbf99535d,0xbf600bb5 }, /*  99: -1.1978565e+00 -8.7517864e-01 */
    { 0xbee9eedc,0xbedb6e83 }, /* 100: -4.5690048e-01 -4.2857751e-01 */
    { 0xbedff68e,0xbed31f89 }, /* 101: -4.3742794e-01 -4.1234997e-01 */
    { 0x3ef4c240,0x3ee450dd }, /* 102:  4.7804451e-01  4.4592944e-01 */
    { 0xc0adf82c,0xbfb1c720 }, /* 103: -5.4365444e+00 -1.3888893e+00 */
    { 0x44f9df4e,0x3fc8ff76 }, /* 104:  1.9989783e+03  1.5702960e+00 */
    { 0x3ee87af1,0x3eda3a7f }, /* 105:  4.5406297e-01  4.2622754e-01 */
    { 0x3ee22694,0x3ed4f4df }, /* 106:  4.4170058e-01  4.1593072e-01 */
    { 0xbf1c381f,0xbf0c43bd }, /* 107: -6.1023134e-01 -5.4790860e-01 */
    { 0x3f41c389,0x3f25dc84 }, /* 108:  7.5688988e-01  6.4789605e-01 */
    { 0x3f738a05,0x3f42ad6b }, /* 109:  9.5132476e-01  7.6045865e-01 */
    { 0x3bcbdd23,0x3bcbdc77 }, /* 110:  6.2214299e-03  6.2213498e-03 */
    { 0xbf497085,0xbf2aabe4 }, /* 111: -7.8687316e-01 -6.6668534e-01 */
    { 0xbeb42a98,0xbead3ce8 }, /* 112: -3.5188746e-01 -3.3835530e-01 */
    { 0xbedfaca6,0xbed2e17c }, /* 113: -4.3686408e-01 -4.1187656e-01 */
    { 0x3f79a923,0x3f45da4b }, /* 114:  9.7523707e-01  7.7286214e-01 */
    { 0x3f172aee,0x3f088d2b }, /* 115:  5.9049881e-01  5.3340405e-01 */
    { 0xbeaf858f,0xbea917e4 }, /* 116: -3.4281585e-01 -3.3026040e-01 */
    { 0xbe742d2f,0xbe6fb345 }, /* 117: -2.3845361e-01 -2.3408230e-01 */
    { 0x3ee7efd9,0x3ed9c722 }, /* 118:  4.5300177e-01  4.2534739e-01 */
    { 0x3fba9c24,0x3f783672 }, /* 119:  1.4578900e+00  9.6958077e-01 */
    { 0x3eb40ded,0x3ead2365 }, /* 120:  3.5166875e-01  3.3816066e-01 */
    { 0x3fe58f02,0x3f87f44f }, /* 121:  1.7934268e+00  1.0621432e+00 */
    { 0xc00e9d28,0xbf931178 }, /* 122: -2.2283421e+00 -1.1489706e+00 */
    { 0x3e98463b,0x3e940241 }, /* 123:  2.9741082e-01  2.8907970e-01 */
    { 0x3c341371,0x3c341196 }, /* 124:  1.0990963e-02  1.0990521e-02 */
    { 0x3f13e01e,0x3f0618bc }, /* 125:  5.7763851e-01  5.2381492e-01 */
    { 0x42825bc8,0x3fc71928 }, /* 126:  6.5179260e+01  1.5554552e+00 */
    { 0xbf910e10,0xbf5907e7 }, /* 127: -1.1332417e+00 -8.4777683e-01 */
    { 0x3edf55fe,0x3ed298b3 }, /* 128:  4.3620294e-01  4.1132125e-01 */
    { 0x3ffbed5b,0x3f8ce3d6 }, /* 129:  1.9681810e+00  1.1007030e+00 */
    { 0xbd152770,0xbd151693 }, /* 130: -3.6414564e-02 -3.6398482e-02 */
    { 0xb97b28b6,0xb97b28b6 }, /* 131: -2.3952391e-04 -2.3952391e-04 */
    { 0xbee4b87b,0xbed71a5a }, /* 132: -4.4671997e-01 -4.2012292e-01 */
    { 0xbe93f6e8,0xbe900a47 }, /* 133: -2.8899312e-01 -2.8132841e-01 */
    { 0x3f1d3cad,0x3f0d0142 }, /* 134:  6.1420709e-01  5.5080044e-01 */
    { 0x3eb29f39,0x3eabdcc4 }, /* 135:  3.4887102e-01  3.3566868e-01 */
    { 0xbea8ec49,0xbea32a56 }, /* 136: -3.2992771e-01 -3.1868237e-01 */
    { 0xdca37fff,0xbfc90fdb }, /* 137: -3.6816924e+17 -1.5707964e+00 */
    { 0x3f981681,0x3f5f0632 }, /* 138:  1.1881868e+00  8.7118828e-01 */
    { 0xbf3d673f,0xbf2310f8 }, /* 139: -7.3985666e-01 -6.3697767e-01 */
    { 0xbf1b8443,0xbf0bc086 }, /* 140: -6.0748690e-01 -5.4590642e-01 */
    { 0x3e93ec5e,0x3e90008d }, /* 141:  2.8891271e-01  2.8125420e-01 */
    { 0x42f9b71a,0x3fc8096b }, /* 142:  1.2485762e+02  1.5627874e+00 */
    { 0x41e92a77,0x3fc4ac04 }, /* 143:  2.9145735e+01  1.5364995e+00 */
    { 0x3e4ff56d,0x3e4d2b20 }, /* 144:  2.0308466e-01  2.0035982e-01 */
    { 0xbe31bda8,0xbe2ffcc8 }, /* 145: -1.7357504e-01 -1.7186272e-01 */
    { 0x37744468,0x37744468 }, /* 146:  1.4559460e-05  1.4559460e-05 */
    { 0xbf182d9f,0xbf094ca5 }, /* 147: -5.9444612e-01 -5.3632575e-01 */
    { 0x3df0e27e,0x3defc875 }, /* 148:  1.1761950e-01  1.1708156e-01 */
    { 0x3f1a8a94,0x3f0b09d6 }, /* 149:  6.0367703e-01  5.4311883e-01 */
    { 0xbc48dbee,0xbc48d95b }, /* 150: -1.2259467e-02 -1.2258853e-02 */
    { 0xbf782f0c,0xbf4517f3 }, /* 151: -9.6946788e-01 -7.6989669e-01 */
    { 0xbe9035c3,0xbe8c917e }, /* 152: -2.8166017e-01 -2.7454752e-01 */
    { 0xbf1ad191,0xbf0b3dd6 }, /* 153: -6.0476023e-01 -5.4391229e-01 */
    { 0xbfe7128f,0xbf884fc3 }, /* 154: -1.8052539e+00 -1.0649341e+00 */
    { 0xbf99c9cb,0xbf606cd0 }, /* 155: -1.2014707e+00 -8.7666035e-01 */
    { 0x3eb7fa68,0x3eb09f2c }, /* 156:  3.5933232e-01  3.4496439e-01 */
    { 0xc187a6eb,0xbfc1859e }, /* 157: -1.6956503e+01 -1.5118902e+00 */
    { 0x3f0ba1f7,0x3effa8eb }, /* 158:  5.4544014e-01  4.9933562e-01 */
    { 0x3f52c5a2,0x3f30557d }, /* 159:  8.2332814e-01  6.8880445e-01 */
    { 0x3ff3736f,0x3f8b1a67 }, /* 160:  1.9019603e+00  1.0867432e+00 */
    { 0xbf48d0c8,0xbf2a491f }, /* 161: -7.8443575e-01 -6.6517824e-01 */
    { 0xbf123379,0xbf04d66c }, /* 162: -5.7109791e-01 -5.1889682e-01 */
    { 0xbf0db163,0xbf016993 }, /* 163: -5.5348796e-01 -5.0551718e-01 */
    { 0x3eb4cc5b,0x3eadccca }, /* 164:  3.5312161e-01  3.3945304e-01 */
    { 0xbe8a0a98,0xbe86d5d7 }, /* 165: -2.6961207e-01 -2.6335022e-01 */
    { 0xbe805876,0xbe7b822d }, /* 166: -2.5067490e-01 -2.4561377e-01 */
    { 0x3f1be344,0x3f0c05df }, /* 167:  6.0893655e-01  5.4696459e-01 */
    { 0xc034bc17,0xbf9d7fdd }, /* 168: -2.8239801e+00 -1.2304646e+00 */
    { 0x3fbfe0c3,0x3f7b8523 }, /* 169:  1.4990467e+00  9.8250026e-01 */
    { 0xbf541002,0xbf3119e7 }, /* 170: -8.2836926e-01 -6.9180149e-01 */
    { 0x3fb17770,0x3f722944 }, /* 171:  1.3864574e+00  9.4594216e-01 */
    { 0xbb188927,0xbb188915 }, /* 172: -2.3275109e-03 -2.3275067e-03 */
    { 0x3eb73593,0x3eaff0c4 }, /* 173:  3.5783061e-01  3.4363377e-01 */
    { 0x3f1c78ca,0x3f0c72d7 }, /* 174:  6.1121809e-01  5.4862732e-01 */
    { 0x3e2702d0,0x3e258da6 }, /* 175:  1.6309667e-01  1.6167316e-01 */
    { 0xbef38753,0xbee35048 }, /* 176: -4.7564182e-01 -4.4397187e-01 */
    { 0xbe80733b,0xbe7bb48c }, /* 177: -2.5087914e-01 -2.4580592e-01 */
    { 0xbf1e6a9d,0xbf0ddc0a }, /* 178: -6.1881429e-01 -5.5413878e-01 */
    { 0xbf7c6236,0xbf473dad }, /* 179: -9.8587358e-01 -7.7828485e-01 */
    { 0xfbf52b5b,0xbfc90fdb }, /* 180: -2.5459842e+36 -1.5707964e+00 */
    { 0x4056de2d,0x3fa401d8 }, /* 181:  3.3573105e+00  1.2813063e+00 */
    { 0xbee70750,0xbed90610 }, /* 182: -4.5122766e-01 -4.2387438e-01 */
    { 0xc00d4a6a,0xbf929f05 }, /* 183: -2.2076669e+00 -1.1454779e+00 */
    { 0x42e89b0f,0x3fc7f61d }, /* 184:  1.1630285e+02  1.5621983e+00 */
    { 0x3f6f180d,0x3f4052db }, /* 185:  9.3396074e-01  7.5126427e-01 */
    { 0x3e13d92b,0x3e12d567 }, /* 186:  1.4438312e-01  1.4339219e-01 */
    { 0xbee891dd,0xbeda4d80 }, /* 187: -4.5423785e-01 -4.2637253e-01 */
    { 0x3f89ba81,0x3f526e1c }, /* 188:  1.0760041e+00  8.2199264e-01 */
    { 0x3f5432ae,0x3f312e76 }, /* 189:  8.2889831e-01  6.9211519e-01 */
    { 0xbf48fc8a,0xbf2a6433 }, /* 190: -7.8510344e-01 -6.6559142e-01 */
    { 0xbf605c5d,0xbf383985 }, /* 191: -8.7640935e-01 -7.1962768e-01 */
    { 0x3f62394f,0x3f39464c }, /* 192:  8.8368696e-01  7.2372890e-01 */
    { 0x3f16fa58,0x3f086921 }, /* 193:  5.8975744e-01  5.3285414e-01 */
    { 0x3ed6ad4a,0x3ecb46dd }, /* 194:  4.1929084e-01  3.9702502e-01 */
    { 0xbf1495b2,0xbf06a0b9 }, /* 195: -5.8040917e-01 -5.2588993e-01 */
    { 0x3e9c0383,0x3e976ffa }, /* 196:  3.0471429e-01  2.9577619e-01 */
    { 0x3eecc709,0x3eddc7aa }, /* 197:  4.6245602e-01  4.3316394e-01 */
    { 0xbfdbdb9c,0xbf8593c5 }, /* 198: -1.7176394e+00 -1.0435721e+00 */
    { 0x3f18044a,0x3f092e19 }, /* 199:  5.9381545e-01  5.3585964e-01 */
    { 0x402cd066,0x3f9ba9ba }, /* 200:  2.7002196e+00  1.2161171e+00 */
    { 0x3eb468cf,0x3ead7442 }, /* 201:  3.5236213e-01  3.3877760e-01 */
    { 0xc081f184,0xbfaa27ce }, /* 202: -4.0607319e+00 -1.3293397e+00 */
    { 0xaf89900a,0xaf89900a }, /* 203: -2.5022501e-10 -2.5022501e-10 */
    { 0x3e6c9e7b,0x3e6889a2 }, /* 204:  2.3107331e-01  2.2708753e-01 */
    { 0xbea26ffd,0xbe9d4b6d }, /* 205: -3.1726065e-01 -3.0721608e-01 */
    { 0xbeea38bc,0xbedbab9e }, /* 206: -4.5746410e-01 -4.2904371e-01 */
    { 0xbeb2211f,0xbeab6c51 }, /* 207: -3.4790894e-01 -3.3481076e-01 */
    { 0xc02e62a3,0xbf9c09fc }, /* 208: -2.7247703e+00 -1.2190547e+00 */
    { 0x3aa90173,0x3aa9016d }, /* 209:  1.2894109e-03  1.2894102e-03 */
    { 0x3f5a0c1c,0x3f349c25 }, /* 210:  8.5174727e-01  7.0550758e-01 */
    { 0xbee6a0dd,0xbed8b0eb }, /* 211: -4.5044604e-01 -4.2322478e-01 */
    { 0x4372dbe5,0x3fc888ee }, /* 212:  2.4285896e+02  1.5666788e+00 */
    { 0x3e6b2a2b,0x3e672815 }, /* 213:  2.2965305e-01  2.2573884e-01 */
    { 0xbd297594,0xbd295cda }, /* 214: -4.1371897e-02 -4.1348316e-02 */
    { 0x3ea218c4,0x3e9cfc2a }, /* 215:  3.1659520e-01  3.0661136e-01 */
    { 0xbeb02b40,0xbea9ac1a }, /* 216: -3.4407997e-01 -3.3139116e-01 */
    { 0xbf6694f4,0xbf3bb37b }, /* 217: -9.0071034e-01 -7.3320740e-01 */
    { 0xc0419b50,0xbfa03261 }, /* 218: -3.0251045e+00 -1.2515374e+00 */
    { 0x3fe5d9eb,0x3f88060f }, /* 219:  1.7957128e+00  1.0626849e+00 */
    { 0x3f87fc45,0x3f50cdae }, /* 220:  1.0623862e+00  8.1563842e-01 */
    { 0x3ee48622,0x3ed6f05f }, /* 221:  4.4633585e-01  4.1980264e-01 */
    { 0xbf1b8189,0xbf0bbe88 }, /* 222: -6.0744530e-01 -5.4587603e-01 */
    { 0x3f66fc6e,0x3f3bec91 }, /* 223:  9.0228927e-01  7.3407847e-01 */
    { 0xbdfadbab,0xbdf99d5a }, /* 224: -1.2248930e-01 -1.2188216e-01 */
    { 0x41d2c982,0x3fc434cf }, /* 225:  2.6348392e+01  1.5328616e+00 */
    { 0xbee880c8,0xbeda3f57 }, /* 226: -4.5410752e-01 -4.2626449e-01 */
    { 0x3ee3424c,0x3ed5e216 }, /* 227:  4.4386518e-01  4.1774052e-01 */
    { 0xbe6b1860,0xbe67172e }, /* 228: -2.2958517e-01 -2.2567436e-01 */
    { 0x4075cd7a,0x3fa87552 }, /* 229:  3.8406663e+00  1.3160803e+00 */
    { 0x3e82c2f1,0x3e80065a }, /* 230:  2.5539353e-01  2.5004846e-01 */
    { 0x3e6b8bc3,0x3e6784c8 }, /* 231:  2.3002534e-01  2.2609246e-01 */
    { 0x3ec6045f,0x3ebcf202 }, /* 232:  3.8675210e-01  3.6903387e-01 */
    { 0xc4d8cc9a,0xbfc8fcf6 }, /* 233: -1.7343938e+03 -1.5702198e+00 */
    { 0x3dfa30da,0x3df8f50e }, /* 234:  1.2216349e-01  1.2156115e-01 */
    { 0x3eb5eb63,0x3eaecbd3 }, /* 235:  3.5531148e-01  3.4139881e-01 */
    { 0x3fd3e42a,0x3f83812e }, /* 236:  1.6554005e+00  1.0273798e+00 */
    { 0xbf69a9a6,0xbf3d6452 }, /* 237: -9.1274488e-01 -7.3981202e-01 */
    { 0xbf94366d,0xbf5bc318 }, /* 238: -1.1579109e+00 -8.5844564e-01 */
    { 0xbee0cb7a,0xbed3d227 }, /* 239: -4.3905240e-01 -4.1371271e-01 */
    { 0xbf99601d,0xbf60162e }, /* 240: -1.1982456e+00 -8.7533844e-01 */
    { 0x3de05ccd,0x3ddf78aa }, /* 241:  1.0955200e-01  1.0911687e-01 */
    { 0xbe6c0a01,0xbe67fcaa }, /* 242: -2.3050691e-01 -2.2654977e-01 */
    { 0xc04eeddf,0xbfa2ab00 }, /* 243: -3.2332685e+00 -1.2708435e+00 */
    { 0xbee30c3d,0xbed5b4eb }, /* 244: -4.4345275e-01 -4.1739592e-01 */
    { 0xbe8f27ef,0xbe8b975d }, /* 245: -2.7960154e-01 -2.7263919e-01 */
    { 0x3f4586ee,0x3f283cb3 }, /* 246:  7.7159011e-01  6.5717620e-01 */
    { 0xbe6c7c26,0xbe68690a }, /* 247: -2.3094234e-01 -2.2696319e-01 */
    { 0x3eecae67,0x3eddb35e }, /* 248:  4.6226808e-01  4.3300909e-01 */
    { 0x3fae80a4,0x3f701c30 }, /* 249:  1.3633008e+00  9.3793011e-01 */
    { 0xbe90182e,0xbe8c7615 }, /* 250: -2.8143448e-01 -2.7433839e-01 */
    { 0x3e062854,0x3e0565d4 }, /* 251:  1.3101321e-01  1.3027126e-01 */
    { 0xbf44eb42,0xbf27db02 }, /* 252: -7.6921475e-01 -6.5568554e-01 */
    { 0x3e9a784e,0x3e96060c }, /* 253:  3.0169910e-01  2.9301488e-01 */
    { 0xbfd33e3c,0xbf8354b8 }, /* 254: -1.6503367e+00 -1.0260229e+00 */
    { 0xbfe0f2e7,0xbf86d813 }, /* 255: -1.7574128e+00 -1.0534691e+00 */
    { 0xc04693e4,0xbfa1276d }, /* 256: -3.1027765e+00 -1.2590157e+00 */
    { 0x457ac134,0x3fc907b0 }, /* 257:  4.0120752e+03  1.5705471e+00 */
    { 0xc04aa109,0xbfa1e711 }, /* 258: -3.1660788e+00 -1.2648641e+00 */
    { 0x3ebe283b,0x3eb612b2 }, /* 259:  3.7140068e-01  3.5561138e-01 */
    { 0xbf3f3c3c,0xbf243f05 }, /* 260: -7.4701285e-01 -6.4158660e-01 */
    { 0x3f72b110,0x3f423b57 }, /* 261:  9.4801426e-01  7.5871795e-01 */
    { 0xbeea149b,0xbedb8dbd }, /* 262: -4.5718846e-01 -4.2881575e-01 */
    { 0x3ee0bc31,0x3ed3c556 }, /* 263:  4.3893579e-01  4.1361493e-01 */
    { 0xbf3ffdd5,0xbf24bb1a }, /* 264: -7.4996692e-01 -6.4347994e-01 */
    { 0x3ee904bd,0x3edaacb2 }, /* 265:  4.5511428e-01  4.2709881e-01 */
    { 0xbf0fd6ab,0xbf030c8d }, /* 266: -5.6186932e-01 -5.1191026e-01 */
    { 0xbee0c62f,0xbed3cdb7 }, /* 267: -4.3901202e-01 -4.1367885e-01 */
    { 0x3a7ea608,0x3a7ea603 }, /* 268:  9.7140716e-04  9.7140687e-04 */
    { 0x405f2a8e,0x3fa55034 }, /* 269:  3.4869723e+00  1.2915101e+00 */
    { 0xbe5ace91,0xbe5790ac }, /* 270: -2.1367861e-01 -2.1051282e-01 */
    { 0x3f18343d,0x3f095189 }, /* 271:  5.9454709e-01  5.3640038e-01 */
    { 0xbe669351,0xbe62cb01 }, /* 272: -2.2517134e-01 -2.2147752e-01 */
    { 0xbdba7d36,0xbdb9f9e9 }, /* 273: -9.1059133e-02 -9.0808697e-02 */
    { 0x3e1e67ba,0x3e1d28d4 }, /* 274:  1.5469256e-01  1.5347606e-01 */
    { 0x40632e73,0x3fa5e9df }, /* 275:  3.5497100e+00  1.2961997e+00 */
    { 0x3ea04f39,0x3e9b5be3 }, /* 276:  3.1310442e-01  3.0343542e-01 */
    { 0xbe3006c3,0xbe2e529a }, /* 277: -1.7190079e-01 -1.7023697e-01 */
    { 0xbee9145f,0xbedab9a5 }, /* 278: -4.5523354e-01 -4.2719761e-01 */
    { 0x3c2c4813,0x3c2c4673 }, /* 279:  1.0515231e-02  1.0514843e-02 */
    { 0xbd858812,0xbd8557c1 }, /* 280: -6.5200940e-02 -6.5108784e-02 */
    { 0x3f0a3b95,0x3efd7f3b }, /* 281:  5.3997165e-01  4.9511132e-01 */
    { 0xbfaa7732,0xbf6d3e22 }, /* 282: -1.3317626e+00 -9.2672932e-01 */
    { 0x3ee7ad40,0x3ed98fdd }, /* 283:  4.5249367e-01  4.2492571e-01 */
    { 0xbf1bf9a9,0xbf0c1635 }, /* 284: -6.0927826e-01 -5.4721385e-01 */
    { 0xbf9c285e,0xbf6258cd }, /* 285: -1.2199819e+00 -8.8416749e-01 */
    { 0xbeeab050,0xbedc0e78 }, /* 286: -4.5837641e-01 -4.2979789e-01 */
    { 0x3acbc99b,0x3acbc990 }, /* 287:  1.5547754e-03  1.5547741e-03 */
    { 0x3f206b84,0x3f0f4d9f }, /* 288:  6.2664056e-01  5.5977815e-01 */
    { 0xbf7ac142,0xbf46698f }, /* 289: -9.7951138e-01 -7.7504820e-01 */
    { 0x3e8dc702,0x3e8a4fcc }, /* 290:  2.7690893e-01  2.7014005e-01 */
    { 0x3fec7636,0x3f898e04 }, /* 291:  1.8473575e+00  1.0746465e+00 */
    { 0x3ea1377b,0x3e9c2f4d }, /* 292:  3.1487641e-01  3.0504838e-01 */
    { 0xbea1cb1b,0xbe9cb591 }, /* 293: -3.1600270e-01 -3.0607274e-01 */
    { 0xbf1152e0,0xbf042cd0 }, /* 294: -5.6767082e-01 -5.1630878e-01 */
    { 0xbee14da9,0xbed43f41 }, /* 295: -4.4004562e-01 -4.1454509e-01 */
    { 0x3f5bafca,0x3f358e9a }, /* 296:  8.5815108e-01  7.0920718e-01 */
    { 0x3fa80258,0x3f6b7477 }, /* 297:  1.3125715e+00  9.1974586e-01 */
    { 0xbf7651bd,0xbf442100 }, /* 298: -9.6218473e-01 -7.6612854e-01 */
    { 0x3d57b5bb,0x3d5782c4 }, /* 299:  5.2663546e-02  5.2614942e-02 */
    { 0x3f1a9bb5,0x3f0b1663 }, /* 300:  6.0393840e-01  5.4331034e-01 */
    { 0xbf8780dc,0xbf505983 }, /* 301: -1.0586200e+00 -8.1386584e-01 */
    { 0x3e75ba4b,0x3e712ae3 }, /* 302:  2.3996846e-01  2.3551516e-01 */
    { 0xbe5248d4,0xbe4f66b0 }, /* 303: -2.0535594e-01 -2.0254016e-01 */
    { 0x3fc77f2c,0x3f800b19 }, /* 304:  1.5585685e+00  1.0003387e+00 */
    { 0xbf214f4f,0xbf0ff0ee }, /* 305: -6.3011640e-01 -5.6227005e-01 */
    { 0xbc864c27,0xbc864913 }, /* 306: -1.6393734e-02 -1.6392266e-02 */
    { 0xc1748d0e,0xbfc0b306 }, /* 307: -1.5284437e+01 -1.5054634e+00 */
    { 0x3e758bc2,0x3e70fee2 }, /* 308:  2.3979095e-01  2.3534730e-01 */
    { 0xbeb02954,0xbea9aa62 }, /* 309: -3.4406531e-01 -3.3137804e-01 */
    { 0xbd6ac63d,0xbd6a848c }, /* 310: -5.7317961e-02 -5.7255313e-02 */
    { 0xbf9aa56c,0xbf611ffd }, /* 311: -1.2081733e+00 -8.7939435e-01 */
    { 0x3f52258f,0x3f2ff5f8 }, /* 312:  8.2088560e-01  6.8734694e-01 */
    { 0xb6840046,0xb6840046 }, /* 313: -3.9339384e-06 -3.9339384e-06 */
    { 0xaa8132b4,0xaa8132b4 }, /* 314: -2.2950186e-13 -2.2950186e-13 */
    { 0x3eee333e,0x3edef362 }, /* 315:  4.6523470e-01  4.3545061e-01 */
    { 0xbeb8cce4,0xbeb1597e }, /* 316: -3.6093819e-01 -3.4638590e-01 */
    { 0xbf1b84d7,0xbf0bc0f2 }, /* 317: -6.0749573e-01 -5.4591286e-01 */
    { 0x3e3d987c,0x3e3b78fd }, /* 318:  1.8515199e-01  1.8307872e-01 */
    { 0xbf8e0a99,0xbf565c7a }, /* 319: -1.1096984e+00 -8.3734858e-01 */
    { 0xbf1b87a5,0xbf0bc2fe }, /* 320: -6.0753852e-01 -5.4594409e-01 */
    { 0x3f622aff,0x3f393e43 }, /* 321:  8.8346857e-01  7.2360629e-01 */
    { 0xbf8e25e7,0xbf5674f0 }, /* 322: -1.1105317e+00 -8.3772182e-01 */
    { 0x3f230b0b,0x3f112d96 }, /* 323:  6.3688725e-01  5.6710184e-01 */
    { 0x3e658e82,0x3e61d2ba }, /* 324:  2.2417644e-01  2.2053042e-01 */
    { 0x3f12c0a6,0x3f0540c7 }, /* 325:  5.7325208e-01  5.2051967e-01 */
    { 0xc02d556e,0xbf9bc9bc }, /* 326: -2.7083392e+00 -1.2170939e+00 */
    { 0x3ea266b6,0x3e9d42ff }, /* 327:  3.1718987e-01  3.0715176e-01 */
    { 0x3ee8eefd,0x3eda9aad }, /* 328:  4.5494834e-01  4.2696133e-01 */
    { 0x3f72bfcd,0x3f42431a }, /* 329:  9.4823915e-01  7.5883639e-01 */
    { 0xbee4cd05,0xbed72b79 }, /* 330: -4.4687667e-01 -4.2025355e-01 */
    { 0x3dde3569,0x3ddd57c0 }, /* 331:  1.0850031e-01  1.0807753e-01 */
    { 0x3f1414db,0x3f064044 }, /* 332:  5.7844323e-01  5.2441812e-01 */
    { 0x3d30a14c,0x3d30854d }, /* 333:  4.3122575e-02  4.3095876e-02 */
    { 0xbf78990f,0xbf454e8e }, /* 334: -9.7108549e-01 -7.7072990e-01 */
    { 0x3f1c1e15,0x3f0c30c3 }, /* 335:  6.0983402e-01  5.4761904e-01 */
    { 0x3f721f4c,0x3f41ee7c }, /* 336:  9.4579005e-01  7.5754523e-01 */
    { 0xbee3b180,0xbed63ef5 }, /* 337: -4.4471359e-01 -4.1844907e-01 */
    { 0x3ee73982,0x3ed92fc3 }, /* 338:  4.5161062e-01  4.2419252e-01 */
    { 0x3e132e3b,0x3e122df1 }, /* 339:  1.4373104e-01  1.4275338e-01 */
    { 0xbedd1bf0,0xbed0b902 }, /* 340: -4.3185377e-01 -4.0766150e-01 */
    { 0xbebc1bea,0xbeb44556 }, /* 341: -3.6740047e-01 -3.5209149e-01 */
    { 0xbf5b064f,0xbf352ce0 }, /* 342: -8.5556501e-01 -7.0771599e-01 */
    { 0xbee4a0c8,0xbed70698 }, /* 343: -4.4653916e-01 -4.1997218e-01 */
    { 0xc06eae8a,0xbfa78765 }, /* 344: -3.7294030e+00 -1.3088194e+00 */
    { 0xbfa81852,0xbf6b849a }, /* 345: -1.3132422e+00 -9.1999209e-01 */
    { 0xa7adfc10,0xa7adfc10 }, /* 346: -4.8290433e-15 -4.8290433e-15 */
    { 0xbecc6777,0xbec27a5a }, /* 347: -3.9922687e-01 -3.7983972e-01 */
    { 0x3ee4ec7f,0x3ed745b5 }, /* 348:  4.4711682e-01  4.2045370e-01 */
    { 0xbe668803,0xbe62c03f }, /* 349: -2.2512822e-01 -2.2143649e-01 */
    { 0xb2ce826b,0xb2ce826b }, /* 350: -2.4040864e-08 -2.4040864e-08 */
    { 0xbf8ba66f,0xbf5432ac }, /* 351: -1.0910167e+00 -8.2889819e-01 */
    { 0xbdaaeba7,0xbdaa867d }, /* 352: -8.3457284e-02 -8.3264329e-02 */
    { 0x3f18899b,0x3f099092 }, /* 353:  5.9584969e-01  5.3736222e-01 */
    { 0xbc585655,0xbc58531d }, /* 354: -1.3204177e-02 -1.3203410e-02 */
    { 0xbcfd2ccc,0xbcfd182d }, /* 355: -3.0905150e-02 -3.0895317e-02 */
    { 0xbeaa2e9e,0xbea44cd0 }, /* 356: -3.3238691e-01 -3.2089853e-01 */
    { 0xbf18ff1b,0xbf09e737 }, /* 357: -5.9764260e-01 -5.3868431e-01 */
    { 0x3ec8a0f9,0x3ebf369d }, /* 358:  3.9185312e-01  3.7346354e-01 */
    { 0x3f3d9b91,0x3f2332c5 }, /* 359:  7.4065500e-01  6.3749343e-01 */
    { 0xbe57c25e,0xbe54a616 }, /* 360: -2.1070239e-01 -2.0766482e-01 */
    { 0xbf4abb19,0xbf2b778f }, /* 361: -7.9191738e-01 -6.6979307e-01 */
    { 0x3e33fac1,0x3e3228e9 }, /* 362:  1.7576124e-01  1.7398418e-01 */
    { 0x364c3a5c,0x364c3a5c }, /* 363:  3.0432338e-06  3.0432338e-06 */
    { 0x3fd492cf,0x3f83afc3 }, /* 364:  1.6607302e+00  1.0288013e+00 */
    { 0x3eafd3e0,0x3ea95df5 }, /* 365:  3.4341335e-01  3.3079496e-01 */
    { 0x3cfa3064,0x3cfa1c7d }, /* 366:  3.0540653e-02  3.0531162e-02 */
    { 0xbee3d0a4,0xbed658f4 }, /* 367: -4.4495118e-01 -4.1864741e-01 */
    { 0xbf000000,0xbeed6338 }, /* 368: -5.0000000e-01 -4.6364760e-01 */
    { 0xbbb4c784,0xbbb4c70c }, /* 369: -5.5169482e-03 -5.5168923e-03 */
    { 0x3fcd87b0,0x3f81c409 }, /* 370:  1.6057034e+00  1.0137950e+00 */
    { 0xbf3bd465,0xbf220bdd }, /* 371: -7.3370963e-01 -6.3299352e-01 */
    { 0x4061eadb,0x3fa5ba0a }, /* 372:  3.5299594e+00  1.2947400e+00 */
    { 0xbf18bc8d,0xbf09b627 }, /* 373: -5.9662706e-01 -5.3793567e-01 */
    { 0x3e9341c6,0x3e8f630b }, /* 374:  2.8761119e-01  2.8005251e-01 */
    { 0x3ee4caaa,0x3ed72982 }, /* 375:  4.4685870e-01  4.2023855e-01 */
    { 0x41aad82e,0x3fc31293 }, /* 376:  2.1355556e+01  1.5240043e+00 */
    { 0x3ee5c21e,0x3ed7f7a1 }, /* 377:  4.4874662e-01  4.2181113e-01 */
    { 0xbf1ee1c0,0xbf0e321e }, /* 378: -6.2063217e-01 -5.5545223e-01 */
    { 0x3e9be299,0x3e9751dc }, /* 379:  3.0446318e-01  2.9554641e-01 */
    { 0x3ef56ecf,0x3ee4dd41 }, /* 380:  4.7936103e-01  4.4700053e-01 */
    { 0x351cbe3a,0x351cbe3a }, /* 381:  5.8391345e-07  5.8391345e-07 */
    { 0xbe77b1f7,0xbe7306ed }, /* 382: -2.4188982e-01 -2.3733111e-01 */
    { 0xbeeb1a21,0xbedc65e2 }, /* 383: -4.5918372e-01 -4.3046480e-01 */
    { 0xbf18bccf,0xbf09b658 }, /* 384: -5.9663099e-01 -5.3793859e-01 */
    { 0x3f6981f2,0x3f3d4ea8 }, /* 385:  9.1213906e-01  7.3948145e-01 */
    { 0x3f112a3b,0x3f040e10 }, /* 386:  5.6705064e-01  5.1583958e-01 */
    { 0x3e6329dd,0x3e5f8b1c }, /* 387:  2.2183938e-01  2.1830410e-01 */
    { 0xc42ba3eb,0xbfc8e020 }, /* 388: -6.8656122e+02 -1.5693398e+00 */
    { 0xbf50b7ff,0xbf2f1afa }, /* 389: -8.1530756e-01 -6.8400538e-01 */
    { 0x3f6c2861,0x3f3ebf14 }, /* 390:  9.2249113e-01  7.4510312e-01 */
    { 0xbea278b3,0xbe9d5357 }, /* 391: -3.1732711e-01 -3.0727646e-01 */
    { 0xbee5e04c,0xbed810bf }, /* 392: -4.4897687e-01 -4.2200276e-01 */
    { 0x3f5e6380,0x3f371ae2 }, /* 393:  8.6870575e-01  7.1525395e-01 */
    { 0xc06aaf9c,0xbfa6fbfe }, /* 394: -3.6669683e+00 -1.3045652e+00 */
    { 0xbf13ed9f,0xbf0622dc }, /* 395: -5.7784456e-01 -5.2396941e-01 */
    { 0x3eddc661,0x3ed14897 }, /* 396:  4.3315414e-01  4.0875694e-01 */
    { 0x4c4e298b,0x3fc90fda }, /* 397:  5.4044204e+07  1.5707963e+00 */
    { 0xbf6dc1a2,0xbf3f9b7d }, /* 398: -9.2873585e-01 -7.4846631e-01 */
    { 0x3db9fb6e,0x3db97932 }, /* 399:  9.0811595e-02  9.0563193e-02 */
    { 0xbeb06595,0xbea9e040 }, /* 400: -3.4452501e-01 -3.3178902e-01 */
    { 0xbeeb2698,0xbedc702e }, /* 401: -4.5927882e-01 -4.3054336e-01 */
    { 0x40a79f9f,0x3fb0eaaf }, /* 402:  5.2382350e+00  1.3821620e+00 */
    { 0xbf773db5,0xbf449b4f }, /* 403: -9.6578532e-01 -7.6799482e-01 */
    { 0xc1401221,0xbfbe6c7b }, /* 404: -1.2004426e+01 -1.4876856e+00 */
    { 0xd142e585,0xbfc90fdb }, /* 405: -5.2317147e+10 -1.5707964e+00 */
    { 0x3d480f4b,0x3d47e6a0 }, /* 406:  4.8842710e-02  4.8803926e-02 */
    { 0xbd47bedb,0xbd479661 }, /* 407: -4.8765998e-02 -4.8727397e-02 */
    { 0x3f19f366,0x3f0a9aec }, /* 408:  6.0137022e-01  5.4142642e-01 */
    { 0x3f74c6ab,0x3f43533c }, /* 409:  9.5615643e-01  7.6298881e-01 */
    { 0x3dd5a189,0x3dd4dc76 }, /* 410:  1.0431201e-01  1.0393612e-01 */
    { 0xbe9a27d0,0xbe95bc42 }, /* 411: -3.0108500e-01 -2.9245192e-01 */
    { 0xbf3e54a6,0xbf23aa20 }, /* 412: -7.4347913e-01 -6.3931465e-01 */
    { 0xbc0f1d24,0xbc0f1c35 }, /* 413: -8.7349750e-03 -8.7347524e-03 */
    { 0x3df32f0e,0x3df20cea }, /* 414:  1.1874209e-01  1.1818869e-01 */
    { 0x398a2489,0x398a2489 }, /* 415:  2.6348632e-04  2.6348632e-04 */
    { 0x414892bf,0x3fbedf6e }, /* 416:  1.2535827e+01  1.4911935e+00 */
    { 0xbf16b438,0xbf083514 }, /* 417: -5.8868742e-01 -5.3205991e-01 */
    { 0x3f1a4abf,0x3f0adb08 }, /* 418:  6.0270303e-01  5.4240465e-01 */
    { 0x3e88c874,0x3e85a958 }, /* 419:  2.6715434e-01  2.6105762e-01 */
    { 0xbf1e47b7,0xbf0dc2cc }, /* 420: -6.1828178e-01 -5.5375361e-01 */
    { 0xbf5e4d55,0xbf370e40 }, /* 421: -8.6836749e-01 -7.1506119e-01 */
    { 0xbf57b45e,0xbf333efd }, /* 422: -8.4259593e-01 -7.0017987e-01 */
    { 0xbf1e7cfc,0xbf0de953 }, /* 423: -6.1909461e-01 -5.5434150e-01 */
    { 0xbf1907f1,0xbf09edba }, /* 424: -5.9777743e-01 -5.3878367e-01 */
    { 0x3f1bbb59,0x3f0be8be }, /* 425:  6.0832745e-01  5.4652011e-01 */
    { 0xbf5fa96a,0xbf37d42c }, /* 426: -8.7367880e-01 -7.1808124e-01 */
    { 0xbef6f2a2,0xbee6183f }, /* 427: -4.8231989e-01 -4.4940373e-01 */
    { 0x3fadea42,0x3f6fb2be }, /* 428:  1.3587115e+00  9.3632114e-01 */
    { 0x3ea48a48,0x3e9f33e9 }, /* 429:  3.2136750e-01  3.1094292e-01 */
    { 0xbfa407f8,0xbf687d19 }, /* 430: -1.2814932e+00 -9.0815884e-01 */
    { 0x3f56e5df,0x3f32c60b }, /* 431:  8.3944505e-01  6.9833440e-01 */
    { 0x3e9ea4e0,0x3e99d73f }, /* 432:  3.0985165e-01  3.0047032e-01 */
    { 0x3e921a00,0x3e8e51b4 }, /* 433:  2.8535461e-01  2.7796710e-01 */
    { 0xc0fbd595,0xbfb8e24c }, /* 434: -7.8698220e+00 -1.4444060e+00 */
    { 0x3e31ff0a,0x3e303c40 }, /* 435:  1.7382446e-01  1.7210484e-01 */
    { 0x3eaac921,0x3ea4d7e7 }, /* 436:  3.3356574e-01  3.2195970e-01 */
    { 0xbf1959d7,0xbf0a2a08 }, /* 437: -5.9902710e-01 -5.3970385e-01 */
    { 0x3fc6757c,0x3f7f7aaa }, /* 438:  1.5504603e+00  9.9796546e-01 */
    { 0xbee90cf1,0xbedab37e }, /* 439: -4.5517686e-01 -4.2715067e-01 */
    { 0xbda1c207,0xbda16c3d }, /* 440: -7.8983359e-02 -7.8819729e-02 */
    { 0xbea7c1cb,0xbea21cf7 }, /* 441: -3.2765040e-01 -3.1662723e-01 */
    { 0xbee47b00,0xbed6e717 }, /* 442: -4.4625092e-01 -4.1973183e-01 */
    { 0xbf89618a,0xbf521b89 }, /* 443: -1.0732892e+00 -8.2073265e-01 */
    { 0xbee850f1,0xbeda17ac }, /* 444: -4.5374253e-01 -4.2596185e-01 */
    { 0xbf187d45,0xbf098777 }, /* 445: -5.9566146e-01 -5.3722328e-01 */
    { 0x3f9065eb,0x3f58744e }, /* 446:  1.1281103e+00  8.4552467e-01 */
    { 0xbe701b5b,0xbe6bd89d }, /* 447: -2.3447935e-01 -2.3031850e-01 */
    { 0x3f7b90d2,0x3f46d352 }, /* 448:  9.8267853e-01  7.7666199e-01 */
    { 0x3e72cf32,0x3e6e6803 }, /* 449:  2.3711851e-01  2.3281865e-01 */
    { 0x3f2a52a4,0x3f164a5c }, /* 450:  6.6532350e-01  5.8707213e-01 */
    { 0x3ee4e113,0x3ed73c30 }, /* 451:  4.4702968e-01  4.2038107e-01 */
    { 0x3e518728,0x3e4eacd3 }, /* 452:  2.0461714e-01  2.0183115e-01 */
    { 0x401b3f5c,0x3f9702fd }, /* 453:  2.4257421e+00  1.1797787e+00 */
    { 0xbeee12ca,0xbeded8b4 }, /* 454: -4.6498710e-01 -4.3524706e-01 */
    { 0xbe98b8fe,0xbe946baa }, /* 455: -2.9828638e-01 -2.8988391e-01 */
    { 0x3f811e4d,0x3f4a2ce8 }, /* 456:  1.0087372e+00  7.8974771e-01 */
    { 0x3f839e3d,0x3f4ca120 }, /* 457:  1.0282665e+00  7.9933357e-01 */
    { 0xbebec785,0xbeb69e9f }, /* 458: -3.7261596e-01 -3.5667893e-01 */
    { 0xbbeb3035,0xbbeb2f2c }, /* 459: -7.1773776e-03 -7.1772542e-03 */
    { 0xbee30504,0xbed5aee1 }, /* 460: -4.4339764e-01 -4.1734985e-01 */
    { 0x3ef321e9,0x3ee2fd8d }, /* 461:  4.7486809e-01  4.4334069e-01 */
    { 0x3ee8e57a,0x3eda92cc }, /* 462:  4.5487577e-01  4.2690122e-01 */
    { 0xbecd653a,0xbec35515 }, /* 463: -4.0116292e-01 -3.8150850e-01 */
    { 0xbf24156b,0xbf11eabe }, /* 464: -6.4095181e-01 -5.6998813e-01 */
    { 0xbee75788,0xbed948b2 }, /* 465: -4.5183969e-01 -4.2438275e-01 */
    { 0xbf184832,0xbf096047 }, /* 466: -5.9485161e-01 -5.3662533e-01 */
    { 0x3f1b92f7,0x3f0bcb43 }, /* 467:  6.0771126e-01  5.4607028e-01 */
    { 0xbee19e19,0xbed482a1 }, /* 468: -4.4065931e-01 -4.1505912e-01 */
    { 0x42306556,0x3fc628ed }, /* 469:  4.4098961e+01  1.5481240e+00 */
    { 0xbf304da6,0xbf1a6433 }, /* 470: -6.8868482e-01 -6.0309142e-01 */
    { 0x3e41bc8d,0x3e3f792c }, /* 471:  1.8919583e-01  1.8698567e-01 */
    { 0xbf1064ec,0xbf037892 }, /* 472: -5.6403995e-01 -5.1355851e-01 */
    { 0x3f1351fd,0x3f05ae11 }, /* 473:  5.7546979e-01  5.2218729e-01 */
    { 0x3f24b678,0x3f125cc5 }, /* 474:  6.4340925e-01  5.7172805e-01 */
    { 0xbfb04bcb,0xbf715b4c }, /* 475: -1.3773130e+00 -9.4279933e-01 */
    { 0xbf192878,0xbf0a05af }, /* 476: -5.9827375e-01 -5.3914922e-01 */
    { 0xbf9873ec,0xbf5f538e }, /* 477: -1.1910377e+00 -8.7236869e-01 */
    { 0xbf972b73,0xbf5e4296 }, /* 478: -1.1810135e+00 -8.6820352e-01 */
    { 0x3bb9e8c4,0x3bb9e841 }, /* 479:  5.6734998e-03  5.6734388e-03 */
    { 0xbf78ed44,0xbf4579dd }, /* 480: -9.7237039e-01 -7.7139074e-01 */
    { 0x3fd1d1fd,0x3f82f26a }, /* 481:  1.6392208e+00  1.0230229e+00 */
    { 0xbfbfde6f,0xbf7b83b4 }, /* 482: -1.4989756e+00 -9.8247838e-01 */
    { 0xbe8fe26f,0xbe8c4447 }, /* 483: -2.8102443e-01 -2.7395841e-01 */
    { 0xbee2595c,0xbed51f5c }, /* 484: -4.4208801e-01 -4.1625488e-01 */
    { 0x3e7e0200,0x3e78fb78 }, /* 485:  2.4805450e-01  2.4314678e-01 */
    { 0x3f18d26a,0x3f09c647 }, /* 486:  5.9696066e-01  5.3818172e-01 */
    { 0x40b2949e,0x3fb25dca }, /* 487:  5.5806417e+00  1.3934872e+00 */
    { 0x3fa46cd2,0x3f68c953 }, /* 488:  1.2845709e+00  9.0932196e-01 */
    { 0x42f0e541,0x3fc7ffcf }, /* 489:  1.2044776e+02  1.5624942e+00 */
    { 0xbe884d0d,0xbe853623 }, /* 490: -2.6621285e-01 -2.6017866e-01 */
    { 0x3fd75bca,0x3f846bad }, /* 491:  1.6824887e+00  1.0345360e+00 */
    { 0xbcffe064,0xbcffcb1a }, /* 492: -3.1234927e-02 -3.1224776e-02 */
    { 0xbf45df8b,0xbf287435 }, /* 493: -7.7294225e-01 -6.5802318e-01 */
    { 0x4bcdfe9c,0x3fc90fda }, /* 494:  2.7000120e+07  1.5707963e+00 */
    { 0x05274c52,0x05274c52 }, /* 495:  7.8663201e-36  7.8663201e-36 */
    { 0x426ecd12,0x3fc6eb08 }, /* 496:  5.9700264e+01  1.5540476e+00 */
    { 0xbe6637fa,0xbe627411 }, /* 497: -2.2482291e-01 -2.2114588e-01 */
    { 0xbee2a93e,0xbed5622a }, /* 498: -4.4269747e-01 -4.1676456e-01 */
    { 0xbf86a05b,0xbf4f850f }, /* 499: -1.0517687e+00 -8.1062406e-01 */
    { 0x3f1e9bc7,0x3f0dff94 }, /* 500:  6.1956447e-01  5.5468106e-01 */
};

void x_exit (int index)
{
#ifndef	__AVR__
    fprintf (stderr, "t[%d]:  %#lx\n", index - 1, v.lo);
#endif
    exit (index ? index : -1);
}

int main ()
{
    union lofl_u x, z;
    unsigned long v1, z1, r;
    int i;
    
    for (i = 0; i < (int) (sizeof(t) / sizeof(t[0])); i++) {
	x.lo = pgm_read_dword (& t[i].x);
	z.lo = pgm_read_dword (& t[i].z);
	v.fl = atan (x.fl);
	
	v1 = (v.lo < 0) ? (unsigned long)~(v.lo) : v.lo + 0x80000000;
	z1 = (z.lo < 0) ? (unsigned long)~(z.lo) : z.lo + 0x80000000;
	r = (v1 >= z1) ? v1 - z1 : z1 - v1;
	
	if (r > 1) x_exit (i+1);
    }
    return 0;
}
