#
# $Date: 2005/03/06 16:51:02 $
#
package Fs;

$Fs::types[0]  = "ext";
$Fs::types[1]  = "fat";
$Fs::types[2]  = "ntfs";
$Fs::types[3]  = "ufs";
$Fs::types[4]  = "-----";
$Fs::types[5]  = "fat12";
$Fs::types[6]  = "fat16";
$Fs::types[7]  = "fat32";
$Fs::types[8]  = "bsdi";
$Fs::types[9]  = "freebsd";
$Fs::types[10] = "openbsd";
$Fs::types[11] = "solaris";

# These need to be updated as The Sleuth Kit supports more file systems
#
# addr_unit contains the addressable unit per filesystem type
# first_meta contains the first usable meta address on a system
# root_meta is the meta address for the root directory (diff than
# first on ntfs)

$Fs::addr_unit{'disk'}  = 'Sector';
$Fs::first_addr{'disk'} = 0;
$Fs::is_fs{'disk'}      = 0;

$Fs::addr_unit{'dls'}  = 'Unit';
$Fs::first_addr{'dls'} = 0;
$Fs::is_fs{'dls'}      = 0;

# raw
$Fs::addr_unit{'raw'}  = 'Unit';
$Fs::first_addr{'raw'} = 0;
$Fs::is_fs{'raw'}      = 0;

# Swap
$Fs::addr_unit{'swap'}  = 'Unit';
$Fs::first_addr{'swap'} = 0;
$Fs::is_fs{'swap'}      = 0;

# BSDI
$Fs::first_meta{'bsdi'} = $Fs::root_meta{'bsdi'} = 2;
$Fs::first_addr{'bsdi'} = 0;
$Fs::addr_unit{'bsdi'}  = 'Fragment';
$Fs::ctime_str{'bsdi'}  = "Changed";
$Fs::mtime_str{'bsdi'}  = "Modified";
$Fs::meta_str{'bsdi'}   = "Inode";
$Fs::is_fs{'bsdi'}      = 1;

# FreeBSD
$Fs::first_meta{'freebsd'} = $Fs::root_meta{'freebsd'} = 2;
$Fs::first_addr{'freebsd'} = 0;
$Fs::addr_unit{'freebsd'}  = 'Fragment';
$Fs::ctime_str{'freebsd'}  = "Changed";
$Fs::mtime_str{'freebsd'}  = "Modified";
$Fs::meta_str{'freebsd'}   = "Inode";
$Fs::is_fs{'freebsd'}      = 1;

# OpenBSD
$Fs::first_meta{'openbsd'} = $Fs::root_meta{'openbsd'} = 2;
$Fs::first_addr{'openbsd'} = 0;
$Fs::addr_unit{'openbsd'}  = 'Fragment';
$Fs::ctime_str{'openbsd'}  = "Changed";
$Fs::mtime_str{'openbsd'}  = "Modified";
$Fs::meta_str{'openbsd'}   = "Inode";
$Fs::is_fs{'openbsd'}      = 1;

# Solaris
$Fs::first_meta{'solaris'} = $Fs::root_meta{'solaris'} = 2;
$Fs::first_addr{'solaris'} = 0;
$Fs::addr_unit{'solaris'}  = 'Fragment';
$Fs::ctime_str{'solaris'}  = "Changed";
$Fs::mtime_str{'solaris'}  = "Modified";
$Fs::meta_str{'solaris'}   = "Inode";
$Fs::is_fs{'solaris'}      = 1;

# UFS
$Fs::first_meta{'ufs'} = $Fs::root_meta{'ufs'} = 2;
$Fs::first_addr{'ufs'} = 0;
$Fs::addr_unit{'ufs'}  = 'Fragment';
$Fs::ctime_str{'ufs'}  = "Changed";
$Fs::mtime_str{'ufs'}  = "Modified";
$Fs::meta_str{'ufs'}   = "Inode";
$Fs::is_fs{'ufs'}      = 1;

# Linux
$Fs::first_meta{'linux-ext2'} = $Fs::root_meta{'linux-ext2'} = 2;
$Fs::first_addr{'linux-ext2'} = 0;
$Fs::addr_unit{'linux-ext2'}  = 'Fragment';
$Fs::ctime_str{'linux-ext2'}  = "Changed";
$Fs::mtime_str{'linux-ext2'}  = "Modified";
$Fs::meta_str{'linux-ext2'}   = "Inode";
$Fs::is_fs{'linux-ext2'}      = 1;

$Fs::first_meta{'linux-ext3'} = $Fs::root_meta{'linux-ext3'} = 2;
$Fs::first_addr{'linux-ext3'} = 0;
$Fs::addr_unit{'linux-ext3'}  = 'Fragment';
$Fs::ctime_str{'linux-ext3'}  = "Changed";
$Fs::mtime_str{'linux-ext3'}  = "Modified";
$Fs::meta_str{'linux-ext3'}   = "Inode";
$Fs::is_fs{'linux-ext3'}      = 1;

$Fs::first_meta{'ext'} = $Fs::root_meta{'ext'} = 2;
$Fs::first_addr{'ext'} = 0;
$Fs::addr_unit{'ext'}  = 'Fragment';
$Fs::ctime_str{'ext'}  = "Changed";
$Fs::mtime_str{'ext'}  = "Modified";
$Fs::meta_str{'ext'}   = "Inode";
$Fs::is_fs{'ext'}      = 1;

# FAT
$Fs::first_meta{'fat'} = $Fs::root_meta{'fat'} = $Fs::first_meta{'fat12'} =
  $Fs::root_meta{'fat12'} = $Fs::first_meta{'fat16'} = $Fs::root_meta{'fat16'} =
  $Fs::first_meta{'fat32'} = $Fs::root_meta{'fat32'} = 2;
$Fs::first_addr{'fat'} = $Fs::first_addr{'fat12'} = $Fs::first_addr{'fat16'} =
  $Fs::first_addr{'fat32'} = 0;
$Fs::addr_unit{'fat'}      = $Fs::addr_unit{'fat12'} = $Fs::addr_unit{'fat16'} =
  $Fs::addr_unit{'fat32'}  = 'Sector';
$Fs::ctime_str{'fat'} = $Fs::ctime_str{'fat12'} = $Fs::ctime_str{'fat16'} =
  $Fs::ctime_str{'fat32'} = "Created";
$Fs::mtime_str{'fat'}     = $Fs::mtime_str{'fat12'} = $Fs::mtime_str{'fat16'} =
  $Fs::mtime_str{'fat32'} = "Written";
$Fs::meta_str{'fat'} = $Fs::meta_str{'fat12'} = $Fs::meta_str{'fat16'} =
  $Fs::meta_str{'fat32'} = "Dir Entry";
$Fs::is_fs{'fat'}        = $Fs::is_fs{'fat12'} = $Fs::is_fs{'fat16'} =
  $Fs::is_fs{'fat32'}    = 1;

# NTFS
$Fs::first_meta{'ntfs'} = 0;
$Fs::root_meta{'ntfs'}  = 5;
$Fs::first_addr{'ntfs'} = 0;
$Fs::addr_unit{'ntfs'}  = 'Cluster';
$Fs::ctime_str{'ntfs'}  = "Changed";
$Fs::mtime_str{'ntfs'}  = "Written";
$Fs::meta_str{'ntfs'}   = "MFT Entry";
$Fs::is_fs{'ntfs'}      = 1;
