"""
Setup file for automat
"""

from setuptools import setup, find_packages

try:
    from m2r import parse_from_file
    long_description = parse_from_file('README.md')
except(IOError, ImportError):
    print("\n\n!!! m2r not found, long_description is bad, don't upload this to PyPI !!!\n\n")
    import io
    long_description = io.open('README.md', encoding="utf-8").read()

setup(
    name='Automat',
    use_scm_version=True,
    url='https://github.com/glyph/Automat',
    description="""
    Self-service finite-state machines for the programmer on the go.
    """.strip(),
    long_description=long_description,
    packages=find_packages(exclude=[]),
    package_dir={'automat': 'automat'},
    setup_requires=[
        'setuptools-scm',
        'm2r',
    ],
    install_requires=[
        "attrs",
        "six",
    ],
    extras_require={
        "visualize": ["graphviz>0.5.1",
                      "Twisted>=16.1.1"],
    },
    entry_points={
        "console_scripts": [
            "automat-visualize = automat._visualize:tool"
        ],
    },
    author_name='Glyph',
    author_mail='glyph@twistedmatrix.com',
    include_package_data=True,
    license="MIT",
    keywords='fsm finite state machine automata',
)
