/*
    This file is part of audtty, copyright 2008 Chris Taylor.

    audtty is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    audtty is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with audtty; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include <audacious/audctrl.h>
#include <string.h>
#include <dirent.h>
#include "main.h"
#include "dbus.h"
#include "settings.h"
#include "kbd_constants.h"
#include "curses_printf.h"

void check_env(void);
void fix_env(void);
static const char *dbussessionaddr = "DBUS_SESSION_BUS_ADDRESS";
static const char *xsession = "DISPLAY";

void check_env(void){
	if(getenv(dbussessionaddr)==NULL||getenv(xsession)==NULL)
		fix_env();
	else
		return;
}

void fix_env(void){
	DIR* dir;
	struct dirent* contents;
	char dbus[4096];
	char *dbussession = "/.dbus/session-bus/";
	char *check = NULL;
	FILE *filename;
	char buffer[4096];
	char *file;

	strcpy(dbus,getenv("HOME"));
	strcat(dbus,dbussession);
	dir = opendir(dbus);
	
	if(!dir){
		printf("Failed to open directory: %s \n",dbus);
		exit(1);
	}
	
	while((contents=readdir(dir))){
		if(strcmp(contents->d_name, ".") == 0)
			continue;
		if(strcmp(contents->d_name, "..") == 0)
			continue;
		else{
			file=contents->d_name;
			closedir(dir);
			strcat(dbus,file);
			filename=fopen(dbus,"r");
			if(filename==NULL){
				printf("Failed to open file: %s \n",contents->d_name);
			}
			else{
				while(fgets(buffer,4096,filename)){
					if(buffer[0]=='#')
						continue;
					else{
						if((check=strchr(buffer,'=')))
						{
							char *env=strtok(buffer,"=");
							char *val=strtok(NULL, "\n");
							if((strcmp(env,dbussessionaddr))==0)
							{
								setenv(env,val,0);
								//It really doesnt matter what $DISPLAY is set to, so long as it is set.
								setenv(xsession,":0",0); 
								break;
							}
							else
								continue;
						}
						else
							continue;
					}
				}
			fclose(filename);
			break;
			}
		}
	}
	return;
}
