/* $Id: linux_usb.c,v 1.4 2002/12/18 20:37:19 smarkou Exp $ */
/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "vnetusba.h"

/**************************************************************************
	   UpdateAppInfo updates the device configuration structure (which is
	   sended to the application) with the current values.
**************************************************************************/
VOID UpdateAppInfo(PVNet_ADAPTER Adapter, PDEVICE_CONFIGURATION pDevConfig)
{
        int i;

	pDevConfig->StationState = Adapter->StationState;
	// in the application (for compatibility with PCMCIA, the OperatingMode is
	// 0 for AD_HOC(1 in driver), 1 for INFRASTRUCTURE(2 in driver) so :
	pDevConfig->OperatingMode = Adapter->OperatingMode - 1;

        pDevConfig->MgmtErrorCode = Adapter->ErrorCode;
	pDevConfig->Channel = Adapter->Channel;
	pDevConfig->RadioIsOn = Adapter->RadioIsOn;

        printk(KERN_ALERT __FILE__ ": " "*********************\n");
        printk(KERN_ALERT __FILE__ ": " "Adapter->Channel : %d\n", Adapter->Channel);
        printk(KERN_ALERT __FILE__ ": " "pDevConfig->Channel : %d\n", pDevConfig->Channel);
        printk(KERN_ALERT __FILE__ ": " "*********************\n");

	pDevConfig->RegDomain = Adapter->RegDomain;
	pDevConfig->InternationalRoaming = Adapter->InternationalRoaming;
        if(pDevConfig->InternationalRoaming){
            for( i=0; i<14; i++ ){
                pDevConfig->ChannelVector[i] = Adapter->ChannelVector[i];
        printk(KERN_ALERT __FILE__ ": " "Channel [%d] : %d\n", i+1, pDevConfig->ChannelVector[i]);
            }
        }

        
	if (Adapter->StationState == STATION_STATE_SCANNING) {
		memcpy(pDevConfig->SSID, Adapter->DesiredSSID,
		        (Adapter->DesiredSSIDsize)+1);
		pDevConfig->SSIDlength = Adapter->DesiredSSIDsize;
	} else {
		memcpy(pDevConfig->SSID, Adapter->SelectedSSID,
		        (Adapter->SSID_size)+1);
		pDevConfig->SSIDlength = Adapter->SSID_size;
	}

	memcpy(pDevConfig->BSSID, Adapter->CurrentBSSID, 6);

	// in app SHORT = 1 in driver == 0. So:
	pDevConfig->PreambleType = Adapter->PreambleType;
	pDevConfig->PowerMgmtMode = Adapter->PowerMgmtMode;
	pDevConfig->TxRate = Adapter->TxRate;
	pDevConfig->FragmentationThreshold =
	    Adapter->FragmentationThreshold;
	pDevConfig->RtsCtsThreshold = Adapter->RtsThreshold;
	pDevConfig->Rssi = Adapter->Rssi;
	pDevConfig->LinkQuality = 40 - Adapter->LinkQuality;
}

/******************************
	VNetDumpUrb prints the purb
	structure.
******************************/
#if defined(USBDBG)||defined(INSANEDBG)
void VNetDumpUrb(purb_t purb)
{
	printk(KERN_INFO "urb x%p, next x%p, dev x%p, pipe x%08X ",
	       purb, purb->next, purb->dev, purb->pipe);
	printk(KERN_INFO "status %d trans_flags x%08X trans_buf x%p ",
	       purb->status, purb->transfer_flags, purb->transfer_buffer);
	printk(KERN_INFO
	       "trans_buf_len %d actual_len %d setup_packet x%p ",
	       purb->transfer_buffer_length, purb->actual_length,
	       purb->setup_packet);
	printk(KERN_INFO "start_frame %d nr_packs %d interval %d ",
	       purb->start_frame, purb->number_of_packets, purb->interval);
	printk(KERN_INFO "err_count %d context x%p complete x%p\n",
	       purb->error_count, purb->context, purb->complete);
}
#else
void VNetDumpUrb(purb_t purb)
{
}
#endif
