/* $Id: stdinclude.h,v 1.5 2002/12/18 20:37:18 smarkou Exp $ */
/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/

/****************************************
	Callback functions -- callbacks.c
****************************************/
void RxCallback(purb_t purb);
void TxOkCB(purb_t purb);
void ctrl_callback(struct urb *purb);
void GetCmd_callback(purb_t purb);

/**************************************
	Commands functions -- command.c
**************************************/
void GetOperationalRates(PVNet_ADAPTER Adapter);
int SetAutoRateFallback(PVNet_ADAPTER Adapter);
int UsbStartIBSS(PVNet_ADAPTER Adapter);
int UsbScan(PVNet_ADAPTER Adapter);
int UsbJoin(PVNet_ADAPTER Adapter);
int GetOpMode(PVNet_ADAPTER Adapter);
int GetHWCfg(PVNet_ADAPTER Adapter);
int GetMIBvalue(PVNet_ADAPTER Adapter, USHORT Mib, USHORT bytes);
int SetMIB_NewBSSID_OK(PVNet_ADAPTER Adapter);
int StartUp(PVNet_ADAPTER Adapter);
int GetCmdStatus(PVNet_ADAPTER Adapter, UCHAR CmdID);
int SetRadio(PVNet_ADAPTER Adapter, BOOLEAN EnableRadio);
int SetPreamble(PVNet_ADAPTER Adapter);
int SetIRoaming(PVNet_ADAPTER Adapter);
int SetFragThreshold(PVNet_ADAPTER Adapter);
int SetRTSThreshold(PVNet_ADAPTER Adapter);
void UsbSelectBSS(PVNet_ADAPTER Adapter);
int GetDFUState(PVNet_ADAPTER Adapter);
int GetDFUStatus(PVNet_ADAPTER Adapter);
int DownLoadInternal(PVNet_ADAPTER Adapter);
int DownLoadExternal(PVNet_ADAPTER Adapter);
int Remap(PVNet_ADAPTER Adapter);
int DFUdetach(PVNet_ADAPTER Adapter);
int SetMacAddress(PVNet_ADAPTER Adapter);
int SetWEPvalue(PVNet_ADAPTER Adapter);
void GetNewBSS(PVNet_ADAPTER Adapter);
void GetChannelList(PVNet_ADAPTER Adapter);

/*****************************
	linux_usb.c
*****************************/
void UpdateAppInfo(PVNet_ADAPTER Adapter,
		   PDEVICE_CONFIGURATION pDevConfig);


/*****************************
	rx.c
*****************************/
int UsbRxInit(PVNet_ADAPTER Adapter);
void TimerExpired(ULONG a);
void RxData(PVNet_ADAPTER Adapter);
VOID MgmtFrameProcessing(PVNet_ADAPTER Adapter, UCHAR FrameSubType);

/*****************************
	tx.c
*****************************/
int SendAuthRequest(PVNet_ADAPTER Adapter, PUCHAR pChallengeText,
		    UCHAR ChallengeTextLength);
int SendReAssocRequest(PVNet_ADAPTER Adapter);
int SendAssocRequest(PVNet_ADAPTER Adapter);
TX_LIST *AllocPacket(PVNet_ADAPTER Adapter, USHORT length);
void DeQueueTxPacket(PVNet_ADAPTER Adapter, TX_LIST * new_tx);
void VNetDumpUrb(purb_t purb);
void DropPendingTxPackets(PVNet_ADAPTER Adapter);
void Ethernet2Wireless(PVNet_ADAPTER Adapter, PTX_LIST NewTxL);

/**************************
	vnet.c
**************************/
void init_CRCtable(PVNet_ADAPTER Adapter);
void SetParameters(PVNet_ADAPTER Adapter);
ULONG Calculate_CRC32(PUCHAR p, ULONG FrameLength, PULONG crctab);
void VnetReleaseResources(PVNet_ADAPTER Adapter);
void ChangeState(PVNet_ADAPTER Adapter, UCHAR State);
int InitDevice(PVNet_ADAPTER Adapter);
UCHAR AsciiToByte(UCHAR Ascii1, UCHAR Ascii2);
BOOLEAN ValidateChannel(PVNet_ADAPTER Adapter, UCHAR Channel);
int ChangeConfiguration(PVNet_ADAPTER Adapter,
			DEVICE_CONFIGURATION * pDevConfig);

/**************************
	vnet_kernel.c
**************************/
void VNetIf_queue(struct net_device *dev, UCHAR c);
int VNetSchedule(PVNet_ADAPTER Adapter, ULONG flag);
int InitAdapter(PVNet_ADAPTER Adapter);
int VnetUsbReset(PVNet_ADAPTER Adapter);
int rx_kernel_part(PVNet_ADAPTER Adapter, struct sk_buff **skb,
		   USHORT PacketLength, UCHAR DataOffset);
int VNetAllocMem(void **Ptr, USHORT size);
void VnetTimer(PVNet_ADAPTER Adapter, UCHAR timeout);
void VNetFreeSkb(struct sk_buff *skb);
void VNetFree(void *ptr);

/* vnetusba.c */
void mod_use(UCHAR a, PVNet_ADAPTER Adapter);
char *ssid2str(char *buf, char *ssid, int len);
char *buf2str(char *str, void *buf, int len);
