/***************************************************************************************
	Copyright 2000-2001 ATMEL Corporation.
	
	This file is part of atmel wireless lan drivers.

    Atmel wireless lan drivers is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Atmel wireless lan drivers is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Atmel wireless lan drivers; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

**************************************************************************************/
#include "xvnet.h"

FD_errorform * create_errorform(void)
{
	FL_OBJECT *obj;
	FD_errorform * fdui = (FD_errorform *)fl_calloc(1, sizeof(*fdui));

	fdui->errorform = fl_bgn_form(FL_FLAT_BOX, 340, 70);
	fdui->message = fl_add_text(FL_NORMAL_TEXT, 20, 10, 300, 20, "An error has occured");
	fdui->exit = fl_add_button(FL_NORMAL_BUTTON, 145, 40, 50, 25, "Exit");
		fl_set_object_shortcut(fdui->exit, "#e", 1);
		fl_set_object_callback(fdui->exit, exit_cb, 0);
	fl_end_form();
	return fdui;
}

FD_alertform * create_alertform(POPEN_CARDS pOpenCards)
{
	FL_OBJECT *obj;
	FD_alertform * fdui = (FD_alertform *)fl_calloc(1, sizeof(*fdui));
	
	fdui->alertform = fl_bgn_form(FL_FLAT_BOX, 340, 70);
	fdui->message = fl_add_text(FL_NORMAL_TEXT, 20, 10, 300, 20, " ");
	fdui->Retry = fl_add_button(FL_NORMAL_BUTTON, 120, 40, 45, 25, "Retry");
		fl_set_object_shortcut(fdui->Retry, "#r", 1);
		fl_set_object_callback(fdui->Retry, retry_cb, 0);
	fdui->exit = fl_add_button(FL_NORMAL_BUTTON, 175, 40, 45, 25, "Exit");
		fl_set_object_shortcut(fdui->exit, "#e", 1);
		fl_set_object_callback(fdui->exit, exit_cb, 0);
	fl_end_form();
	
	return fdui;
}

FD_alertform * create_warningform(POPEN_CARDS pOpenCards)
{
	FL_OBJECT *obj;
	FD_alertform * fdui = (FD_alertform *)fl_calloc(1, sizeof(*fdui));
	
	fdui->alertform = fl_bgn_form(FL_FLAT_BOX, 340, 70);
	fdui->message = fl_add_text(FL_NORMAL_TEXT, 20, 10, 300, 20, " ");
	fdui->Retry = fl_add_button(FL_NORMAL_BUTTON, 150, 40, 50, 25, "OK");
		fl_set_object_shortcut(fdui->Retry, "#o", 1);
		fl_set_object_callback(fdui->Retry, retry_cb, 0);

	fl_end_form();
	return fdui;
}

void create_mainform(POPEN_CARDS pOpenCards)
{
	FL_OBJECT *obj;
	char    IdentityString[12];
	int 	i;
	char 	message[45];
	
	pOpenCards->fd_mainform->mainform = fl_bgn_form(FL_FLAT_BOX, 380, 425);
	pOpenCards->fd_mainform->eth_select = fl_add_choice(FL_DROPLIST_CHOICE, 30, 5, 320, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_mainform->eth_select, FL_DOWN_BOX);
		for ( i=0; i<pOpenCards->NumOfCards; i++)
		{
         	switch(pOpenCards->pCardInfo[i]->CardType)
         	{
         		case CARD_TYPE_PCMCIA:
         			strcpy(IdentityString, "PCMCIA");
         			break;
         		case CARD_TYPE_PCMCIA_RFMD:
         			strcpy(IdentityString, "PCMCIA RFMD");
         			break;
         		case CARD_TYPE_USB:
         			strcpy(IdentityString, "USB");
         			break;
         		case CARD_TYPE_USB_RFMD:
         			strcpy(IdentityString, "USB RFMD");
				break;
         		case CARD_TYPE_USB_505:
         			strcpy(IdentityString, "RFMD 505");
				break;
			case CARD_TYPE_PCMCIA_REVD:
				strcpy(IdentityString, "RFMD REVD");				
         			break;
			case CARD_TYPE_PCMCIA_REVE:
				strcpy(IdentityString, "RFMD REVE");				
         			break;
			case CARD_TYPE_PCMCIA_PCI:
				strcpy(IdentityString, "PCI");				
         			break;
			case CARD_TYPE_PCMCIA_504:
				strcpy(IdentityString, "504");				
         			break;
         	}
#if defined(SMARTBRIDGES)||defined(SMARTBRIDGES_T)         	
			sprintf(message, "SmartBridges %s Wireless LAN Card - %s",
				IdentityString,
				pOpenCards->pCardInfo[i]->name);
#elif defined(ATMEL)
			sprintf(message, "ATMEL %s Wireless LAN Card - %s",
				IdentityString,
				pOpenCards->pCardInfo[i]->name);
#endif
			fl_addto_choice(pOpenCards->fd_mainform->eth_select, message);
		}
		fl_set_choice(pOpenCards->fd_mainform->eth_select, 1);
		fl_set_object_callback(pOpenCards->fd_mainform->eth_select, Update_Tabs, (ULONG)pOpenCards);
		if ( pOpenCards->NumOfCards <= 1)
			fl_deactivate_object(pOpenCards->fd_mainform->eth_select);
	
	pOpenCards->fd_mainform->folder = fl_add_tabfolder(FL_TOP_TABFOLDER, 5, 30, 370, 360, "");
		fl_set_object_callback(pOpenCards->fd_mainform->folder, tab_cb, (ULONG)pOpenCards);
			
	pOpenCards->fd_mainform->exit = fl_add_button(FL_NORMAL_BUTTON, 325, 400, 50, 20, "Exit");
		fl_set_object_shortcut(pOpenCards->fd_mainform->exit, "#e", 1);
		fl_set_object_callback(pOpenCards->fd_mainform->exit, exit_cb, (ULONG)pOpenCards);
	pOpenCards->fd_mainform->timer = fl_add_timer(FL_HIDDEN_TIMER, 10, 380, 70, 20, "");
		fl_set_timer(pOpenCards->fd_mainform->timer, 1);
		fl_set_object_callback(pOpenCards->fd_mainform->timer, My_Timer, (ULONG)pOpenCards);
	fl_end_form();
}

int DomainIndex (POPEN_CARDS pOpenCards)
{
    int ReIndex = 0;
    int lvalid = 0;

        switch (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RegDomain) {
            case 0x10:
            lvalid = 1;
            break;
            case 0x20:
            lvalid = 11;
            break;
            case 0x30:
            lvalid = 1;
            break;
            case 0x31:
            lvalid = 10;
            break;
            case 0x32:
            lvalid = 10;
            break;
            case 0x40:
            lvalid = 14;
            break;
            case 0x41:
            lvalid = 1;
            break;
            case 0x50:
            lvalid = 3;
            break;
        default:
            lvalid = 1;
            break;
        }
        ReIndex =(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.Channel - lvalid)+1; 

    return ReIndex;
}
void create_monitorform(POPEN_CARDS pOpenCards)
{
	FL_OBJECT *obj;
	int i=0, hvalid=0, lvalid=0;
	char tmp_c[14];
	
	Get_MAC(pOpenCards);
	pOpenCards->fd_monitorform->monitorform = fl_bgn_form(FL_FLAT_BOX, 370, 330);
	obj = fl_add_box(FL_ENGRAVED_FRAME, 10, 10, 350, 230, "");
	obj = fl_add_text(FL_NORMAL_TEXT, 20, 20, 100, 20, "Operating Mode");
	pOpenCards->fd_monitorform->OpMode = fl_add_choice(FL_DROPLIST_CHOICE, 130, 20, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_monitorform->OpMode, FL_DOWN_BOX);
		fl_addto_choice(pOpenCards->fd_monitorform->OpMode, "Ad-Hoc");
		fl_addto_choice(pOpenCards->fd_monitorform->OpMode, "InfraStructure");
		fl_set_choice(pOpenCards->fd_monitorform->OpMode, pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode+1);
		fl_set_choice_align(pOpenCards->fd_monitorform->OpMode, FL_ALIGN_LEFT);
		
		fl_set_object_callback(pOpenCards->fd_monitorform->OpMode, opmode_cb, (ULONG)pOpenCards);
		fl_deactivate_object(pOpenCards->fd_monitorform->OpMode);


		obj = fl_add_text(FL_NORMAL_TEXT, 20, 50, 100, 20, "Channel");
		pOpenCards->fd_monitorform->Channel = fl_add_choice(FL_DROPLIST_CHOICE, 130, 50, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_monitorform->Channel, FL_DOWN_BOX);

                    switch(pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RegDomain)
                    {
                    case 0x10:
                        hvalid = 12; 
                        lvalid = 1; 
                        break;
                    case 0x20:     
                        hvalid = 12; 
                        lvalid = 11; 
                        break;
                    case 0x30: 
                        hvalid = 14; 
                        lvalid = 1; 
                        break;
                    case 0x31:
                        hvalid = 12; 
                        lvalid = 10; 
                        break;
                    case 0x32:
                        hvalid = 14; 
                        lvalid = 10; 
                        break;
                    case 0x40:
                        hvalid = 15; 
                        lvalid = 14; 
                        break;
                    case 0x41:
                        hvalid = 15; 
                        lvalid = 1; 
                        break;
                    case 0x50:
                        hvalid = 10; 
                        lvalid = 3; 
                        break;
                    default:
                        hvalid = 15; 
                        lvalid = 1; 
                        break;
                    }
                    for (i=lvalid; i<hvalid; i++)
                    {
                            sprintf(tmp_c, "%d", i);
                            fl_addto_choice(pOpenCards->fd_monitorform->Channel, tmp_c);
                    }
                    fl_set_choice(pOpenCards->fd_monitorform->Channel, (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.Channel - lvalid) + 1);
                    fl_set_choice_align(pOpenCards->fd_monitorform->Channel, FL_ALIGN_LEFT);
                    fl_set_object_callback(pOpenCards->fd_monitorform->Channel, channel_cb, (ULONG)pOpenCards);		

		if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.OperatingMode == 1)
		{
			fl_deactivate_object(pOpenCards->fd_monitorform->Channel);
		 	fl_set_object_color(pOpenCards->fd_monitorform->Channel, FL_COL1, FL_INACTIVE);
		}
		else{
			fl_deactivate_object(pOpenCards->fd_monitorform->Channel);
                }
		
	obj = fl_add_text(FL_NORMAL_TEXT, 20, 80, 100, 20, "ESSID");
	
	pOpenCards->fd_monitorform->SSID = fl_add_input(FL_NORMAL_INPUT, 130, 80, 100, 20, "");
		fl_set_input(pOpenCards->fd_monitorform->SSID, pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.essid);
		fl_set_input_maxchars(pOpenCards->fd_monitorform->SSID, 32);
		fl_set_object_callback(pOpenCards->fd_monitorform->SSID, ssid_cb, (ULONG)pOpenCards);
		fl_call_object_callback(pOpenCards->fd_monitorform->SSID);
		fl_deactivate_object(pOpenCards->fd_monitorform->SSID);

	obj = fl_add_text(FL_NORMAL_TEXT, 20, 110, 100, 20, "Radio On / Off");
	pOpenCards->fd_monitorform->Radio = fl_add_choice(FL_DROPLIST_CHOICE, 130, 110, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_monitorform->Radio, FL_DOWN_BOX);
		fl_addto_choice(pOpenCards->fd_monitorform->Radio, "On");
		fl_addto_choice(pOpenCards->fd_monitorform->Radio, "Off");
		fl_set_choice_align(pOpenCards->fd_monitorform->Radio, FL_ALIGN_LEFT);
		fl_set_choice(pOpenCards->fd_monitorform->Radio, pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.RadioIsOn?1:2);
		pOpenCards->Caller = 8;
		fl_set_object_callback(pOpenCards->fd_monitorform->Radio, radio_cb, (ULONG)pOpenCards);
		fl_deactivate_object(pOpenCards->fd_monitorform->Radio);


	obj = fl_add_text(FL_NORMAL_TEXT, 20, 140, 100, 20, "Int. Roaming");
	pOpenCards->fd_monitorform->Roaming = fl_add_choice(FL_DROPLIST_CHOICE, 130, 140, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_monitorform->Roaming, FL_DOWN_BOX);
		fl_addto_choice(pOpenCards->fd_monitorform->Roaming, "Enabled");
		fl_addto_choice(pOpenCards->fd_monitorform->Roaming, "Disabled");
		fl_set_choice_align(pOpenCards->fd_monitorform->Roaming, FL_ALIGN_LEFT);
		fl_set_choice(pOpenCards->fd_monitorform->Roaming, pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.InternationalRoaming?1:2);
		pOpenCards->Caller = 8;
		fl_set_object_callback(pOpenCards->fd_monitorform->Roaming, roaming_cb, (ULONG)pOpenCards);
		fl_deactivate_object(pOpenCards->fd_monitorform->Roaming);

	obj = fl_add_text(FL_NORMAL_TEXT, 20, 170, 100, 20, "Transmit Rate");
	pOpenCards->fd_monitorform->TxRate = fl_add_choice(FL_DROPLIST_CHOICE, 130, 170, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_monitorform->TxRate, FL_DOWN_BOX);
		fl_addto_choice(pOpenCards->fd_monitorform->TxRate, "Fixed 1Mbps");
		fl_addto_choice(pOpenCards->fd_monitorform->TxRate, "Fixed 2Mbps");
		fl_addto_choice(pOpenCards->fd_monitorform->TxRate, "Fixed 5.5Mbps");
		fl_addto_choice(pOpenCards->fd_monitorform->TxRate, "Fixed 11Mbps");
		fl_addto_choice(pOpenCards->fd_monitorform->TxRate, "Auto");
		fl_set_choice_align(pOpenCards->fd_monitorform->TxRate, FL_ALIGN_LEFT);
		fl_set_choice(pOpenCards->fd_monitorform->TxRate, 4);
		fl_set_object_callback(pOpenCards->fd_monitorform->TxRate, txrate_cb, (ULONG)pOpenCards);
		fl_deactivate_object(pOpenCards->fd_monitorform->TxRate);
	
	fl_add_text(FL_NORMAL_TEXT, 20, 200, 100, 20, "MAC Address");
	pOpenCards->fd_monitorform->mac = fl_add_text(FL_NORMAL_TEXT, 130, 200, 100, 20,
		pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.MAC);
		fl_set_object_boxtype(pOpenCards->fd_monitorform->mac, FL_DOWN_BOX);
		

	pOpenCards->fd_monitorform->Change = fl_add_button(FL_NORMAL_BUTTON, 260, 40, 70, 25, "Change");
		fl_set_object_shortcut(pOpenCards->fd_monitorform->Change, "#c", 1);
		fl_set_object_callback(pOpenCards->fd_monitorform->Change, change_cb, (ULONG)pOpenCards);
	pOpenCards->fd_monitorform->Submit = fl_add_button(FL_NORMAL_BUTTON, 260, 70, 70, 25, "Submit");
		pOpenCards->Caller = 5;
		fl_set_object_callback(pOpenCards->fd_monitorform->Submit, submit_cb, (ULONG)pOpenCards);
		fl_set_object_shortcut(pOpenCards->fd_monitorform->Submit, "#s", 1);
		fl_deactivate_object(pOpenCards->fd_monitorform->Submit);
		fl_set_object_lcolor(pOpenCards->fd_monitorform->Submit, FL_INACTIVE);
	pOpenCards->fd_monitorform->Cancel = fl_add_button(FL_NORMAL_BUTTON, 260, 100, 70, 25, "Cancel");
		fl_set_object_callback(pOpenCards->fd_monitorform->Cancel, cancel_cb, (ULONG)pOpenCards);
		fl_set_object_shortcut(pOpenCards->fd_monitorform->Change, "#a", 1);
		fl_deactivate_object(pOpenCards->fd_monitorform->Cancel);
		fl_set_object_lcolor(pOpenCards->fd_monitorform->Cancel, FL_INACTIVE);
			
	fl_add_box(FL_ENGRAVED_FRAME, 10, 220, 350, 110,"");
	fl_add_text(FL_NORMAL_TEXT, 20, 230, 80, 20, "Status");
	pOpenCards->fd_monitorform->State = fl_add_text(FL_NORMAL_TEXT, 130, 230, 200, 20,
		pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.DriverState);
		fl_set_object_boxtype(pOpenCards->fd_monitorform->State, FL_DOWN_BOX);

	fl_add_text(FL_NORMAL_TEXT, 20, 260, 100, 20, "Signal Strength");
		pOpenCards->fd_monitorform->Signal_b = fl_add_slider(FL_HOR_FILL_SLIDER, 130, 260, 200, 20,
			pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.SValue);
		fl_set_object_color(pOpenCards->fd_monitorform->Signal_b,FL_COL1,FL_FREE_COL1);
		fl_set_object_lsize(pOpenCards->fd_monitorform->Signal_b, FL_DEFAULT_SIZE);
		fl_set_slider_bounds(pOpenCards->fd_monitorform->Signal_b, 0, 100);
		fl_set_slider_value(pOpenCards->fd_monitorform->Signal_b,
			pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.Rssi*2.5);
		fl_set_slider_size(pOpenCards->fd_monitorform->Signal_b, 0.15);
		fl_deactivate_object(pOpenCards->fd_monitorform->Signal_b);
	fl_add_text(FL_NORMAL_TEXT, 20, 295, 100, 20, "Link Quality");
	pOpenCards->fd_monitorform->Link_b = fl_add_slider(FL_HOR_FILL_SLIDER, 130, 295, 200, 20,
		pOpenCards->pCardInfo[pOpenCards->Active]->SupInfo.LValue);
		fl_set_object_color(pOpenCards->fd_monitorform->Link_b,FL_COL1,FL_FREE_COL1);
		fl_set_object_lsize(pOpenCards->fd_monitorform->Link_b, FL_DEFAULT_SIZE);
		fl_set_slider_bounds(pOpenCards->fd_monitorform->Link_b, 0, 100);
		fl_set_slider_value(pOpenCards->fd_monitorform->Link_b,
			pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.LinkQuality*2.5);
		fl_set_slider_size(pOpenCards->fd_monitorform->Link_b, 0.15);
		fl_deactivate_object(pOpenCards->fd_monitorform->Link_b);	
	fl_end_form();
}

void create_statisticsform(POPEN_CARDS pOpenCards)
{
	FL_OBJECT *obj;
	STATINFO StatInfo;	
	
	Get_Stats(&StatInfo, pOpenCards);
	pOpenCards->fd_statisticsform->statisticsform = fl_bgn_form(FL_FLAT_BOX, 370, 330);

	fl_add_labelframe(FL_ENGRAVED_FRAME, 20, 20, 330, 100, "Data Packets");
		fl_add_text(FL_NORMAL_TEXT, 160, 40, 50, 20, "Tx");
		fl_add_text(FL_NORMAL_TEXT, 230, 40, 50, 20, "Rx");
		fl_add_text(FL_NORMAL_TEXT, 30, 60, 90, 20, "Successfull");
		pOpenCards->fd_statisticsform->DTxSucc = fl_add_text(FL_NORMAL_TEXT, 160, 60, 55, 20, StatInfo.DTxSucc);
		pOpenCards->fd_statisticsform->DRxSucc = fl_add_text(FL_NORMAL_TEXT, 230, 60, 55, 20, StatInfo.DRxSucc);
		fl_add_text(FL_NORMAL_TEXT, 30, 90, 90, 20, "Unsuccessfull");
		pOpenCards->fd_statisticsform->DTxUnS = fl_add_text(FL_NORMAL_TEXT, 160, 90, 55, 20, StatInfo.DTxUnS);
		pOpenCards->fd_statisticsform->DRxUnS = fl_add_text(FL_NORMAL_TEXT, 230, 90, 55, 20, StatInfo.DRxUnS);
	fl_add_labelframe(FL_ENGRAVED_FRAME, 20, 130, 330, 100, "Mgmt Packets");
		fl_add_text(FL_NORMAL_TEXT, 160, 150, 50, 20, "Tx");
		fl_add_text(FL_NORMAL_TEXT, 230, 150, 50, 20, "Rx");
		fl_add_text(FL_NORMAL_TEXT, 30, 170, 90, 20, "Successfull");
		pOpenCards->fd_statisticsform->MTxSucc = fl_add_text(FL_NORMAL_TEXT, 160, 170, 55, 20, StatInfo.MTxSucc);
		pOpenCards->fd_statisticsform->MRxSucc = fl_add_text(FL_NORMAL_TEXT, 230, 170, 55, 20, StatInfo.MRxSucc);
		fl_add_text(FL_NORMAL_TEXT, 30, 200, 90, 20, "Unsuccessfull");
		pOpenCards->fd_statisticsform->MTxUnS = fl_add_text(FL_NORMAL_TEXT, 160, 200, 55, 20, StatInfo.MTxUnS);
		pOpenCards->fd_statisticsform->MRxUnS = fl_add_text(FL_NORMAL_TEXT, 230, 200, 55, 20, StatInfo.DRxUnS);

	fl_add_box(FL_ENGRAVED_FRAME, 20, 240, 330, 40, "");
		fl_add_text(FL_NORMAL_TEXT, 40, 250, 90, 20, "Rejected Packets");
		pOpenCards->fd_statisticsform->ReJTx = fl_add_text(FL_NORMAL_TEXT, 160, 250, 55, 20, StatInfo.RejTx);
		pOpenCards->fd_statisticsform->ReJRx = fl_add_text(FL_NORMAL_TEXT, 230, 250, 55, 20, StatInfo.RejRx);
	obj = fl_add_button(FL_NORMAL_BUTTON, 290, 290, 60, 25, "Clear");
		fl_set_object_shortcut(obj, "#c", 1);
		fl_set_object_callback(obj, clear_cb, (ULONG)pOpenCards);
	fl_end_form();
}

void create_sitesurveyform(POPEN_CARDS pOpenCards)
{
	FL_OBJECT *obj;
	struct iwreq wrq;
	
	pOpenCards->fd_sitesurveyform->sitesurveyform = fl_bgn_form(FL_FLAT_BOX, 370, 330);

	obj = fl_add_box(FL_DOWN_BOX, 20, 20, 330, 240, "");

	fl_set_object_color(obj, FL_WHITE,FL_BOTTOM_BCOL);
	fl_add_box(FL_UP_BOX, 22, 22, 110, 20, "BSSID");
	fl_add_box(FL_UP_BOX, 132, 22, 60, 20, "SSID");
	fl_add_box(FL_UP_BOX, 192, 22, 40, 20, "Signal");
	fl_add_box(FL_UP_BOX, 232, 22, 20, 20, "Ch");
	fl_add_box(FL_UP_BOX, 252, 22, 30, 20, "Encr.");
	fl_add_box(FL_UP_BOX, 282, 22, 66, 20, "Type");
	
	pOpenCards->fd_sitesurveyform->browser = fl_add_browser(FL_HOLD_BROWSER, 20, 42, 330, 218, "");
		fl_set_browser_fontstyle(pOpenCards->fd_sitesurveyform->browser, FL_FIXED_STYLE);
		fl_set_object_color(pOpenCards->fd_sitesurveyform->browser , FL_WHITE, FL_INACTIVE);
		fl_set_browser_dblclick_callback(pOpenCards->fd_sitesurveyform->browser, Site_Select_cb, (ULONG)pOpenCards);
		fl_set_browser_fontsize(pOpenCards->fd_sitesurveyform->browser, 10);
/*	
	pOpenCards->fd_sitesurveyform->Select = fl_add_button(FL_NORMAL_BUTTON, 150, 270, 60, 25, "Select");
		fl_set_object_callback(pOpenCards->fd_sitesurveyform->Select, select_cb, (ULONG)pOpenCards);
		fl_set_object_shortcut(pOpenCards->fd_sitesurveyform->Select, "#s", 1);	*/
	pOpenCards->fd_sitesurveyform->ReScan = fl_add_button(FL_NORMAL_BUTTON, 220, 270, 60, 25, "Re-Scan");
		fl_set_object_callback(pOpenCards->fd_sitesurveyform->ReScan, rescan_cb, (ULONG)pOpenCards);
		fl_set_object_shortcut(pOpenCards->fd_sitesurveyform->ReScan, "#r", 1);
	pOpenCards->fd_sitesurveyform->Cancel = fl_add_button(FL_NORMAL_BUTTON, 290, 270, 60, 25, "Cancel");
		fl_set_object_callback(pOpenCards->fd_sitesurveyform->Cancel, site_s_cancel_cb, (ULONG)pOpenCards);
		fl_set_object_shortcut(pOpenCards->fd_sitesurveyform->Cancel, "#a", 1);
		fl_set_object_lcolor(pOpenCards->fd_sitesurveyform->Cancel, FL_INACTIVE);		
		fl_deactivate_object(pOpenCards->fd_sitesurveyform->Cancel);
	pOpenCards->fd_sitesurveyform->Timer = fl_add_timer(FL_HIDDEN_TIMER, 150, 270, 60, 25, "");
		fl_set_timer(pOpenCards->fd_sitesurveyform->Timer, 1);
		fl_suspend_timer(pOpenCards->fd_sitesurveyform->Timer);
		fl_set_object_callback(pOpenCards->fd_sitesurveyform->Timer, site_s_timer_cb, (ULONG)pOpenCards);
	fl_end_form();
}

void create_encryptionform(POPEN_CARDS pOpenCards)
{
	FL_OBJECT *obj;
	
	Get_Wep(pOpenCards);
	pOpenCards->fd_encryptionform->encryptionform = fl_bgn_form(FL_FLAT_BOX, 370, 330);
	fl_add_box(FL_ENGRAVED_FRAME, 20, 10, 330, 30, "");
	fl_add_text(FL_NORMAL_TEXT, 50, 15, 95, 20, "Encryption");
	pOpenCards->fd_encryptionform->EncryptionLevel = fl_add_choice(FL_DROPLIST_CHOICE, 200, 15, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_encryptionform->EncryptionLevel, FL_DOWN_BOX);
		fl_set_choice_align(pOpenCards->fd_encryptionform->EncryptionLevel, FL_ALIGN_LEFT);
		fl_addto_choice(pOpenCards->fd_encryptionform->EncryptionLevel, "Disabled");
		fl_addto_choice(pOpenCards->fd_encryptionform->EncryptionLevel, "64-bit");
		fl_addto_choice(pOpenCards->fd_encryptionform->EncryptionLevel, "128-bit");
		fl_set_choice(pOpenCards->fd_encryptionform->EncryptionLevel,
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel+1);
		fl_set_object_callback(pOpenCards->fd_encryptionform->EncryptionLevel,
			EncryptionLevel_cb, (ULONG)pOpenCards);

	fl_add_box(FL_ENGRAVED_FRAME, 20, 40, 330, 150, "");
	fl_add_text(FL_NORMAL_TEXT, 50, 60, 70, 20, "Key #1");
	pOpenCards->fd_encryptionform->Wep1 = fl_add_input(FL_NORMAL_INPUT, 130, 60, 170, 20, "");
		fl_set_input(pOpenCards->fd_encryptionform->Wep1,
			pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[0]);
		if(	(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 0)||
			(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 1) )
			fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep1, 10);
		else
			fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep1, 26);
		fl_set_object_callback(pOpenCards->fd_encryptionform->Wep1, WepInput1, (ULONG)pOpenCards);
		fl_call_object_callback(pOpenCards->fd_encryptionform->Wep1);
	
	fl_add_text(FL_NORMAL_TEXT, 50, 90, 70, 20, "Key #2");
	pOpenCards->fd_encryptionform->Wep2 = fl_add_input(FL_NORMAL_INPUT, 130, 90, 170, 20, "");
		fl_set_input(pOpenCards->fd_encryptionform->Wep2, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[1]);
		if(	(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 0)||
			(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 1) )
			fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep2, 10);
		else
			fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep2, 26);
		fl_set_object_callback(pOpenCards->fd_encryptionform->Wep2, WepInput2, (ULONG)pOpenCards);
		fl_call_object_callback(pOpenCards->fd_encryptionform->Wep2);
	
	fl_add_text(FL_NORMAL_TEXT, 50, 120, 70, 20, "Key #3");
	pOpenCards->fd_encryptionform->Wep3 = fl_add_input(FL_NORMAL_INPUT, 130, 120, 170, 20, "");
		fl_set_input(pOpenCards->fd_encryptionform->Wep3, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[2]);
		if(	(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 0)||
			(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 1) )
			fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep3, 10);
		else
			fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep3, 26);
		fl_set_object_callback(pOpenCards->fd_encryptionform->Wep3, WepInput3, (ULONG)pOpenCards);
		fl_call_object_callback(pOpenCards->fd_encryptionform->Wep3);
		
	fl_add_text(FL_NORMAL_TEXT, 50, 150, 70, 20, "Key #4");
	pOpenCards->fd_encryptionform->Wep4 = fl_add_input(FL_NORMAL_INPUT, 130, 150, 170, 20, "");
		fl_set_input(pOpenCards->fd_encryptionform->Wep4, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.Wep_Ascii[3]);
		if(	(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 0)||
			(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 1) )
			fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep4, 10);
		else
			fl_set_input_maxchars(pOpenCards->fd_encryptionform->Wep4, 26);
		fl_set_object_callback(pOpenCards->fd_encryptionform->Wep4, WepInput4, (ULONG)pOpenCards);
		fl_call_object_callback(pOpenCards->fd_encryptionform->Wep4);	
	
	fl_add_box(FL_ENGRAVED_FRAME, 20, 190, 330, 90, "");
	
	fl_add_text(FL_NORMAL_TEXT, 50, 200, 100, 20, "WEP Key to use");
	pOpenCards->fd_encryptionform->WepToUse = fl_add_choice(FL_DROPLIST_CHOICE, 200, 200, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_encryptionform->WepToUse, FL_DOWN_BOX);
		fl_set_choice_align(pOpenCards->fd_encryptionform->WepToUse, FL_ALIGN_LEFT);
		fl_addto_choice(pOpenCards->fd_encryptionform->WepToUse, "One");
		fl_addto_choice(pOpenCards->fd_encryptionform->WepToUse, "Two");
		fl_addto_choice(pOpenCards->fd_encryptionform->WepToUse, "Three");
		fl_addto_choice(pOpenCards->fd_encryptionform->WepToUse, "Four");
		fl_set_choice(pOpenCards->fd_encryptionform->WepToUse, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepToUse+1);
		fl_set_object_callback(pOpenCards->fd_encryptionform->WepToUse, WepToUse_cb, (ULONG)pOpenCards);
		
	fl_add_text(FL_NORMAL_TEXT, 50, 225, 100, 20, "WEP Mode");
	pOpenCards->fd_encryptionform->WepMode = fl_add_choice(FL_DROPLIST_CHOICE, 200, 225, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_encryptionform->WepMode, FL_DOWN_BOX);
		fl_set_choice_align(pOpenCards->fd_encryptionform->WepMode, FL_ALIGN_LEFT);
		fl_addto_choice(pOpenCards->fd_encryptionform->WepMode, "Mandatory");
		fl_addto_choice(pOpenCards->fd_encryptionform->WepMode, "Optional");
		fl_set_choice(pOpenCards->fd_encryptionform->WepMode, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.WepMode+1);
		fl_set_object_callback(pOpenCards->fd_encryptionform->WepMode, WepMode_cb, (ULONG)pOpenCards);

	fl_add_text(FL_NORMAL_TEXT, 50, 250, 100, 20, "Authentication Type");
	pOpenCards->fd_encryptionform->AuthType = fl_add_choice(FL_DROPLIST_CHOICE, 200, 250, 100, 20, "");
		fl_set_object_boxtype(pOpenCards->fd_encryptionform->AuthType, FL_DOWN_BOX);
		fl_set_choice_align(pOpenCards->fd_encryptionform->AuthType, FL_ALIGN_LEFT);
		fl_addto_choice(pOpenCards->fd_encryptionform->AuthType, "Open System");
		fl_addto_choice(pOpenCards->fd_encryptionform->AuthType, "Shared Key");
		fl_set_choice(pOpenCards->fd_encryptionform->AuthType, pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.AuthType+1);
		fl_set_object_callback(pOpenCards->fd_encryptionform->AuthType, Authtype_cb, (ULONG)pOpenCards);
	
	if(pOpenCards->pCardInfo[pOpenCards->Active]->ConWepInfo.EncryptionLevel == 0)
	{
		fl_deactivate_object(pOpenCards->fd_encryptionform->Wep1);
		fl_deactivate_object(pOpenCards->fd_encryptionform->Wep2);
		fl_deactivate_object(pOpenCards->fd_encryptionform->Wep3);
		fl_deactivate_object(pOpenCards->fd_encryptionform->Wep4);
		fl_deactivate_object(pOpenCards->fd_encryptionform->WepToUse);
		fl_deactivate_object(pOpenCards->fd_encryptionform->WepMode);
		fl_deactivate_object(pOpenCards->fd_encryptionform->AuthType);
	}
	pOpenCards->fd_encryptionform->Submit = fl_add_button(FL_NORMAL_BUTTON, 290, 290, 60, 25, "Submit");
		fl_set_object_shortcut(pOpenCards->fd_encryptionform->Submit, "#s", 1);
		fl_set_object_callback(pOpenCards->fd_encryptionform->Submit, SubmitWep_cb, (ULONG)pOpenCards);
	fl_end_form();
}

void create_advancedform(POPEN_CARDS pOpenCards)
{
	FL_OBJECT *obj;
	char *IntToStr = (char *)malloc(20);
	
	pOpenCards->fd_advancedform->advancedform = fl_bgn_form(FL_FLAT_BOX, 370, 330);
	fl_add_box(FL_ENGRAVED_FRAME, 20, 20, 330, 60, "");
	fl_add_text(FL_NORMAL_TEXT, 40, 40, 80, 20, "Preamble Type");
	pOpenCards->fd_advancedform->b_long = fl_add_roundbutton(FL_PUSH_BUTTON, 180, 30, 20, 20, "");
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PreambleType == 0)
	{
		fl_deactivate_object(pOpenCards->fd_advancedform->b_long);
		fl_set_button(pOpenCards->fd_advancedform->b_long, 1);
	}
	fl_set_object_callback(pOpenCards->fd_advancedform->b_long, long_cb, (ULONG)pOpenCards);
	fl_add_text(FL_NORMAL_TEXT, 200, 30, 70, 20, "Long");
	pOpenCards->fd_advancedform->b_short = fl_add_roundbutton(FL_PUSH_BUTTON, 180, 50, 20, 20, "");
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PreambleType == 1)
	{
		fl_deactivate_object(pOpenCards->fd_advancedform->b_short);
		fl_set_button(pOpenCards->fd_advancedform->b_short, 1);
	}
	fl_set_object_callback(pOpenCards->fd_advancedform->b_short, short_cb, (ULONG)pOpenCards);
	fl_add_text(FL_NORMAL_TEXT, 200, 50, 70, 20, "Short");


	fl_add_box(FL_ENGRAVED_FRAME, 20, 87, 330, 60, "");
	fl_add_text(FL_NORMAL_TEXT, 40, 102, 80, 20, "Power Mode");
	pOpenCards->fd_advancedform->b_on = fl_add_roundbutton(FL_PUSH_BUTTON, 180, 97, 20, 20, "");
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PowerMgmtMode == 0)
	{
		fl_deactivate_object(pOpenCards->fd_advancedform->b_on);
		fl_set_button(pOpenCards->fd_advancedform->b_on, 1);
	}
	fl_set_object_callback(pOpenCards->fd_advancedform->b_on, on_cb, (ULONG)pOpenCards);
	fl_add_text(FL_NORMAL_TEXT, 200, 97, 70, 20, "Active");
	pOpenCards->fd_advancedform->b_off = fl_add_roundbutton(FL_PUSH_BUTTON, 180, 117, 20, 20, "");
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.PowerMgmtMode == 1)
	{
		fl_deactivate_object(pOpenCards->fd_advancedform->b_off);
		fl_set_button(pOpenCards->fd_advancedform->b_off, 1);
	}
	fl_set_object_callback(pOpenCards->fd_advancedform->b_off, off_cb, (ULONG)pOpenCards);
	fl_add_text(FL_NORMAL_TEXT, 200, 117, 70, 20, "Power Save");

	fl_add_box(FL_ENGRAVED_FRAME, 20, 155, 330, 110, "");
	obj = fl_add_text(FL_NORMAL_TEXT, 40, 165, 130, 20, "Fragmentation Threshold");
	fl_set_object_align(obj, FL_ALIGN_CENTER);
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.FragmentationThreshold == 2346)
		pOpenCards->fd_advancedform->rts_ed = fl_add_text(FL_NORMAL_TEXT, 40, 230, 130, 20, "(Disabled)");
	else
		pOpenCards->fd_advancedform->rts_ed = fl_add_text(FL_NORMAL_TEXT, 40, 230, 130, 20, "(Enabled)");
	
	pOpenCards->fd_advancedform->frag_ed = fl_add_text(FL_NORMAL_TEXT, 40, 180, 130, 20, "(Disabled)");
	fl_set_object_align(pOpenCards->fd_advancedform->frag_ed, FL_ALIGN_CENTER);
	sprintf(IntToStr, "%d", pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.FragmentationThreshold);
	pOpenCards->fd_advancedform->frag_input = fl_add_input(FL_NORMAL_INPUT, 243, 175, 34, 20, "");
	fl_set_input(pOpenCards->fd_advancedform->frag_input, IntToStr);
	fl_set_input_maxchars(pOpenCards->fd_advancedform->frag_input, 4);
	
	fl_set_object_callback(pOpenCards->fd_advancedform->frag_input, Frag_cb, (ULONG)pOpenCards);
	fl_set_input_return(pOpenCards->fd_advancedform->frag_input, FL_RETURN_END_CHANGED);
	obj = fl_add_text(FL_NORMAL_TEXT, 40, 215, 130, 20, "Rts/Cts Threshold");
	fl_set_object_align(obj, FL_ALIGN_CENTER);
	if (pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RtsCtsThreshold == 2347)
		pOpenCards->fd_advancedform->rts_ed = fl_add_text(FL_NORMAL_TEXT, 40, 230, 130, 20, "(Disabled)");
	else
		pOpenCards->fd_advancedform->rts_ed = fl_add_text(FL_NORMAL_TEXT, 40, 230, 130, 20, "(Enabled)");
	fl_set_object_align(pOpenCards->fd_advancedform->rts_ed, FL_ALIGN_CENTER);
	sprintf(IntToStr, "%d", pOpenCards->pCardInfo[pOpenCards->Active]->DevInfo.RtsCtsThreshold);
	pOpenCards->fd_advancedform->rts_input = fl_add_input(FL_NORMAL_INPUT, 243, 225, 34, 20, "");
	fl_set_input(pOpenCards->fd_advancedform->rts_input, IntToStr);
	fl_set_input_maxchars(pOpenCards->fd_advancedform->rts_input, 4);	
	fl_set_object_callback(pOpenCards->fd_advancedform->rts_input, Rts_cb, (ULONG)pOpenCards);
	fl_set_input_return(pOpenCards->fd_advancedform->rts_input, FL_RETURN_END_CHANGED);		
		
	obj = fl_add_button(FL_NORMAL_BUTTON, 290, 305, 60, 25, "Submit");
	fl_set_object_shortcut(obj, "#s", 1);
	fl_set_object_callback(obj, adv_submit_cb, (ULONG)pOpenCards);
	fl_end_form();
	free(IntToStr);
}

#ifdef SMARTBRIDGES_T
#include "smartbridges.xpm"
#elif defined(SMARTBRIDGES)
#include "smartbridges_full.xpm"
#else
#include "atmel.xpm" // for custom fopen custom file....
#endif
void create_versionform(POPEN_CARDS pOpenCards)
{
	VERSION_INFO VersionInfo;
	char *Dv = (char *)malloc(12);
	char *Av = (char *)malloc(12);
	char *Fv = (char *)malloc(12);
	FL_OBJECT *obj;
	
	Get_Ver(&VersionInfo, pOpenCards);
	sprintf(Dv, "%d.%d.%d.%d", VersionInfo.DriverMajorVersion, VersionInfo.DriverMinorVersion, VersionInfo.DriverSubVersion, VersionInfo.DriverBuild);
	sprintf(Fv, "%d.%d.%d.%d", VersionInfo.FwMajorVersion, VersionInfo.FwMinorVersion, VersionInfo.FwSubVersion, VersionInfo.FwBuild);
	sprintf(Av, "%d.%d.0.%d", MAJORAPPVERSION, MINORAPPVERSION,APPBUILD);	
	pOpenCards->fd_versionform->versionform = fl_bgn_form(FL_FLAT_BOX, 370, 330);
	fl_add_box(FL_ENGRAVED_FRAME, 15, 80, 340, 210, "");
	
#ifdef SMARTBRIDGES_T
	obj = fl_add_pixmap(FL_NORMAL_PIXMAP, 20, 100, 143, 36, "");
	fl_set_pixmap_data(obj, smartbridges);
#elif defined(SMARTBRIDGES)
	obj = fl_add_pixmap(FL_NORMAL_PIXMAP, 20, 90, 152, 54, "");
	fl_set_pixmap_data(obj, smartbridges_full);
#else
	obj = fl_add_pixmap(FL_NORMAL_PIXMAP, 20, 95, 98, 45, "");
	fl_set_pixmap_data(obj, atmel_xpm);
#endif

	fl_add_box(FL_ENGRAVED_FRAME, 20, 150, 330, 40, "");
	fl_add_text(FL_NORMAL_TEXT, 40, 160, 100, 20, "Driver Version");
	fl_add_text(FL_NORMAL_TEXT, 240, 160, 100, 20, Dv);
	fl_add_box(FL_ENGRAVED_FRAME, 20, 195, 330, 40, "");
	fl_add_text(FL_NORMAL_TEXT, 40, 205, 100, 20, "Firmware Version");
	fl_add_text(FL_NORMAL_TEXT, 240, 205, 100, 20, Fv);
	fl_add_box(FL_ENGRAVED_FRAME, 20, 240, 330, 40, "");
	fl_add_text(FL_NORMAL_TEXT, 40, 250, 100, 20, "Application Version");
	fl_add_text(FL_NORMAL_TEXT, 240, 250, 100, 20, Av);
	fl_end_form();
	free(Dv);
	free(Av);
	free(Fv);
}

int show_error(char *message, POPEN_CARDS pOpenCards)
{
	pOpenCards->fd_errorform = create_errorform();
	if (message==NULL){
                fl_set_object_lalign(pOpenCards->fd_errorform->message , FL_ALIGN_CENTER); 
		fl_set_object_label(pOpenCards->fd_errorform->message, "An Error");
        }
	else{
                fl_set_object_lalign(pOpenCards->fd_errorform->message , FL_ALIGN_CENTER); 
		fl_set_object_label(pOpenCards->fd_errorform->message, message);
        }
#if defined(SMARTBRIDGES)||defined(SMARTBRIDGES_T)         			
	fl_show_form(pOpenCards->fd_errorform->errorform,FL_PLACE_CENTERFREE,FL_FULLBORDER,"SmartBridges Wireless LAN Monitor Utility");
#elif defined(ATMEL)
	fl_show_form(pOpenCards->fd_errorform->errorform,FL_PLACE_CENTERFREE,FL_FULLBORDER,"ATMEL Wireless LAN Monitor Utility");
#endif	
	while (fl_do_forms())
		;
	return 0;
}
